/**
 * @author Deepak Sharma
 * This component is used for Transport -> Vehicle Type Grid
 */
Ext.define('Academia.view.transport.vehicleType.VehicleTypeGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.vehicletypegrid',
    store : 'transport.vehicleType.VehicleTypeStore',
    border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'vehicletypestructure':1
		}
	},
    title: getCommonTranslation('VEHICLE_TYPE'),
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicleType.VehicleTypeStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }],
    columns: [{
        header: getCommonTranslation('VEHICLE_TYPE_CODE'),
        dataIndex: 'code',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('VEHICLE_TYPE'),
        dataIndex: 'value',
        sortable: true,
        flex: .2
    }]
});