/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.tvet.TVETReportFilter',{
	extend : 'Ext.form.Panel',
	alias : 'widget.tvetreportfilter',
	autoScroll : true,
	frame : false,
	cls : 'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
                xtype: 'multiselectcombofield',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                autoloadStore: false,
                width: 460,
                store: 'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
                cls:'multiBrandCampusCls',
                displayField: 'value',
                valueField: 'id',
                allowBlank: false,
                queryParam: 'nameOrCode',
                minChars: 3,
                typeAhead: true,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        },
                        afterRender: function(combo) {
                            combo.getStore().on("load", function(store, items) {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            });
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            } ]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			matchFieldWidth:true,
			allowBlank: false,
			emptyText: getAdmissionTranslation('SELECT'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		}]
	}, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
                xtype: 'multiselectcombofield',
                name: 'tvetReportFilesId',
                itemId: 'tvetReportFilesItemId',
                fieldLabel: getCommonTranslation('TEVT_REPORT_FILES'),
                autoloadStore: false,
                width: 460,
                store: 'tvet.TEVTReportFileStore',
                cls:'multiBrandCampusCls',
                displayField: 'value',
                valueField: 'id',
                allowBlank: false,
                queryParam: 'nameOrCode',
                minChars: 3,
                typeAhead: true,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        },
                        afterRender: function(combo) {
                            combo.getStore().on("load", function(store, items) {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            });
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }, ]
    }, {
		xtype : 'fieldcontainer',
		width : 'auto',
		items : [ {
			xtype : 'button',
            text: getCommonTranslation('DOWNLOAD'),
			itemId : 'searchBtnTVETReportFilterItemId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'resetBtnTVETReportFilterItemId',
            text: getCommonTranslation('RESET'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
});
