/*
 * @author Rajkumar.Patidar
 * 
 * This controller is used for application form sale details.
 *    
 */
Ext.define('Academia.controller.admission.applicantFormSaleDirectSubmission.ApplicationFormCommonController', {
	extend: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
    alias: "widget.applicationformcommoncontroller",
    models: ['admission.applicationFormSale.ApplicationFormEntityDataModel','admission.applicationFormSale.PersonEnityModel',
             'admission.applicationFormSale.CreateApplicationEntityDataModel'],
    stores: ['enquiry.studentDetail.GenderStore','common.CountryStore','common.SalutationStore',
            'enquiry.OpenEnquiryCodeSearchAccessibleALStore','enquiry.EnquiryStudentSmartSearchAccessibleALStore',
            'admission.applicationFormSale.ProgramTabGridStore','admission.applicationFormSale.ApplicantTypeStore','common.RelationshipStore',
            'enquiry.EnquiryCodeSearchStore','enquiry.EnquiryStudentSmartSearchStore','program.ProgramGroupStore',
            'criteriabuilder.userquicksearch.QuickSearchCode','feeandpayment.managebill.Student','common.CreateApplicationRelationshipStore',
            'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','common.ModeOfDeliveryStore','common.RegistrationTypeStore'],
    views: ['admission.applicantFormSaleDirectSubmission.ApplicantCommonStructure','admission.applicantFormSaleDirectSubmission.ApplicantCommonForm',
            'admission.applicantFormSaleDirectSubmission.AddProgramGrid'],
     
    init: function(application) {
    	//this.control({});
    	this.callParent(arguments);
    },

    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel'
    },{
        ref: 'applicantCommonForm',
        selector: 'applicantcommonform'
    },{
    	 ref: 'searchWindow',
         selector: 'searchapplicantwindow[itemId=searchApplicationWindowCommon]'
    }, {
        ref: 'addProgramWindow',
        selector: 'addprogramwindow[itemId=addProgramApplicationCommonFormWindow]'
    }, {
        ref: 'addProgramGrid',
        selector: 'addprogramgrid'
    },{
    	ref: 'addProgramWindowGrid',
        selector: 'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] grid[itemId=addProgramWindowGrid]'
    },{
    	ref : 'manageFormQuickSeachForm',
    	selector : 'manageformquickseachform'
    },{
    	ref : 'manageformlist',
    	selector:'manageformlist'
    	
    }],
    /**
     * add program from window grid to program window
     */
    addProgram : function($this, programGrid, programWindow, addProgramWindowGrid){
    	 var records = addProgramWindowGrid.getSelectionModel().getSelection();
    	 if(records.length>0) {
    		 var addProgramWindowGridStore = addProgramWindowGrid.getStore();
    		 programGridStore = programGrid.getStore();
    		 tempArr = new Array();
			 addProgramWindowGridStore.each(function(obj1){
					 var recIndex = programGridStore.find('programBatchSeatConfigurationId', obj1.get('programBatchSeatConfigurationId'));
					 if(!isNullOrEmpty(recIndex) && recIndex != -1){
						 addProgramWindowGrid.getSelectionModel().deselect(obj1);
					 }
    		 });
			 tempArr = addProgramWindowGrid.getSelectionModel().getSelection();
			 if(tempArr.length>0){
	    		 var cmbPgmGroupID = programWindow.down('#cmbPgmGroup').getValue();
	        	 for(var i in tempArr){
	        		 tempArr[i].set('programGroupId',cmbPgmGroupID);
	        	 }
	        	 programGrid.getStore().loadRawData(tempArr,true);
	        	 
	        	 setTimeout(function(){
		        	 programGrid.getStore().totalCount = programGrid.getStore().count();
		        	 programGrid.getView().refresh();
	        	 },100);
	        	 
	        	 programWindow.close();
			 }else{
				 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICATE_DATA'));
			 }
    	 } else {
    		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	 }
    	
    },
    /**
     *  delete program from program grid
     */
    deleteProgram : function($this, grid, titleMessage, deleteMessage){
    	var store = grid.getStore();
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection()[0];
			showConfirmMessage(titleMessage, getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					store.remove(records);
					try{
						store.totalCount = store.totalCount-1;
						grid.getView().refresh();
					}
					catch(e){
						//--
					}
				}
			});
		} else {
			showWarningMessage(titleMessage, getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
    },
    
    
    // ************ afterReceiptHeaderRender for add and delete button*************
    
    addRelationshipDetailContainer: function() {
        var this$ = this;
        var form = this$.getApplicantCommonForm();
        var panelItem = new Array();
        
        var showExternalEmployeeId = true;
        var showIsEmployeeOfTheOrganization = true
        var showExternalEmployeeIdLabel = getAdmissionTranslation('EMPLOYEE_ID');
        var showIsEmployeeOfTheOrganizationLabel = getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY');
        
        var receiptheaderPanelOriginal = form.down('#relationshipDetailsId');
        if (!isNullOrEmpty(receiptheaderPanelOriginal.down('#relationshipUserExternal'))) {
        	if(receiptheaderPanelOriginal.down('#relationshipUserExternal').isVisible()){
        		showExternalEmployeeId = false;
        	}
        	showExternalEmployeeIdLabel = receiptheaderPanelOriginal.down('#relationshipUserExternal').fieldLabel;
        }
        
        if (!isNullOrEmpty(receiptheaderPanelOriginal.down('#relationshipCheckbox'))) {
        	if(receiptheaderPanelOriginal.down('#relationshipCheckbox').isVisible()){
        		showIsEmployeeOfTheOrganization = false;
        	}
        	showIsEmployeeOfTheOrganizationLabel = receiptheaderPanelOriginal.down('#relationshipCheckbox').boxLabel;
        }
        
        panelItem.push({
        	xtype:'panel',
//			itemId:'relationshipDetailsId',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'fieldcontainer',        
				width: 'auto',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
					name: 'relationship',
					valueField: 'name',
					displayField: 'value',
					itemId: 'relationShipFieldId',
					store: 'common.RelationshipStore',
					editable: false,
					allowBlank: true,
					listeners:{
						change : function(obj,value){
							this$.setMoreRelationShipDetails(obj,value);
						}
					}
				},{
					xtype: 'textfield',
					name: 'relationshipUserExternal',
					itemId:'relationshipUserExternal',
					//readOnly:true,
					fieldLabel: showExternalEmployeeIdLabel,       
					allowBlank: true,
					hidden: showExternalEmployeeId
				},{
					xtype: 'checkboxfield',
					itemId: 'relationshipCheckboxId',
					labelAlign: 'right',
					//width: 446,
					width: 300,
					boxLabel: showIsEmployeeOfTheOrganizationLabel,
					name: 'relationshipCheckbox',
					inputValue: true,
					uncheckedValue: false,
					hidden: showIsEmployeeOfTheOrganization,
					style:{marginTop:'23px'},
					listeners : {
						change : function(obj){
							this$.ShowHideMoreOrganizationDetails(obj,obj.getValue());
			        	}
					}
				},{
					xtype: 'customcombobox',
					name: 'relationshipStudent',
					itemId: 'relationshipStudentId',
					fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
					store: 'admission.manageForm.StudentWithOutAL',
					valueField: 'id',
					hidden:true,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					},
					listeners :{ 
						select : function(obj,record){
							this$.setMoreStudentRelatedDetails(obj,record);
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'relationshipUser',
					itemId: 'relationshipUserId',
					fieldLabel: getAdmissionTranslation('USER_ID'),
					store: 'criteriabuilder.userquicksearch.QuickSearchCode',
					valueField: 'id',
					displayField: 'value',
					queryParam:'code',
					minChars:3,
					hidden:true,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					//cls:'gridInputCustomStyle',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					},
					listeners :{ 
						select : function(obj,record){
							this$.setMoreEmployeeRelatedDetails(obj,record);
						}
					}
				},{
					xtype:'hidden',
					name:'personRelationshipsId'
				},{
					xtype:'hidden',
					name:'personRelationshipsVersion'
				}]
			},{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox',
                align: 'bottom'
            },
            defaults: {
				labelAlign: 'top',
				width: 226
			},
            items: [{
            	xtype: 'textfield',
            	name: 'relationshipName',
            	itemId:'relationshipNameId',
				fieldLabel: getAdmissionTranslation('NAME_SURNAME'), //Last Name       
				allowBlank: true,
				readOnly:true
			}, {
				xtype: 'fieldcontainer',
				fieldLabel: getServiceRequestTranslation('MOBILE_NO'),
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					name : 'relationshipMobileCountryCode',
					itemId : 'relationshipMobileCountryCodeItemId',
					valueField : 'isdCode',
					displayField : 'isdCode',
					store:'common.CountryStore',
					triggerAction : 'all',
					editable : false,
					readOnly:true,
					width:  70,
					listeners:{
						change : function(obj,value){
						var form = obj.up();
						countryCodeField = form.down('#relationshipMobileCountryCodeItemId');
						mobileField = form.down('#relationshipMobileNo');
						countryCodeField.getStore().load({
		        			callback: function(records, operation, success) {
		        				if (success) {
		        						var countryCode = value;
		            					for(var i in records){
		            						if(records[i].data.isdCode == countryCode){
		        								countryInfo = records[i].data;
		        								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : 0;
		        								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : 11;
		        								if(!isNullOrEmpty(mobileField.getValue())) {
		        									mobileField.isValid();
		        									try{
		        				        				form.getForm().checkValidity();
		        				        	 		}
		        				        	 		catch(e){}
		        								}
		        								break;
		        							}
		            					}
		        				}
		        			}
		        		});
						}
					}
				}, {
					xtype : 'numberfield',
					name: 'relationshipMobileNo',
					itemId: 'relationshipMobileNo',
					hideTrigger: true,
					mouseWheelEnabled:false,
					maxLength: 11,
					minLength: 0,
					enforceMaxLength : true,
					readOnly:true,
					minValue:0,
					allowExponential:false,
					keyNavEnabled: false,
					width:  146
					//fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
				}]
			}, {
				xtype: 'textfield',
				name: 'relationshipEmail',
				vtype:'email',
				readOnly:true, 
				itemId: 'relationshipEmail',
				fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
			},{
				xtype:'hidden',
				name:'relatedPersonId'
			},{
				xtype:'hidden',
				name:'relatedPersonVersion'
			},{
				xtype: 'button',
				itemId: 'addRelationBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				width:40
            },{
           	  xtype: 'button',
                 glyph: ICONGLYPH.DELETEGLYPH,
                 cls: 'CustomBodyBtnReject',
                 tooltip: getCommonTranslation('DELETETOOLTIP'),
                 width:35,
                 listeners:{
                     click:function(obj){
                     var name = obj.previousSibling().previousSibling().previousSibling().previousSibling().previousSibling().previousSibling();
                     name.validate();
                   	  var frm = obj.up('applicantcommonform');
                   	  var receiptPanel = frm.down('#relationshipDetailsId');
                   	  var container = obj.up('panel');
                   	  receiptPanel.remove(container);
                      frm.doLayout();
                     }
                 }
           }] 
		}]
        });
        var receiptheaderPanel = form.down('#relationshipDetailsId');
        receiptheaderPanel.add(panelItem);
        form.doLayout();
    },
    
    saveApplicationDetailsForm: function(obj) {  
    	var $this = this;
    	var contentpanel = this.getContentPanel();
        var submitUrl, isUpdate = false;
        var applicantForm = obj.up('applicantcommonform');
         var manageFormGrid = $this.getManageFormList();
        if (applicantForm) {
            var applicationId = applicantForm.getForm().findField('applicationId');
            var addprogramgrid = applicantForm.down('addprogramgrid');
            if (isNullOrEmpty(applicationId.getSubmitValue())) {
                submitUrl = SERVERURL.CREATE_APPLICATION,
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.UPDATE_APPLICATION,
                isUpdate = true;
            }
            var formData = applicantForm.getForm().getValues();
            if(Ext.app.checkVelocity || Ext.app.checkVelocity=="true"){
            	if(isNullOrEmpty(formData.mobileNumber)){
            		formData.mobileCountryCode="";
            	}
            	if(isNullOrEmpty(formData.phoneNo)){
            		formData.phoneCountryCode="";
            	}
            }
            if(isNullOrEmpty(formData.salutation) || isNullOrEmpty(formData.salutation.id)) {
            	delete formData.salutation;
            }
            var applicationInfo = $this.getApplicationInfoDetails(formData);
            var relationshipInfo = $this.getRelationshipInfoDetails(formData);
            var programInfo = $this.getProgramInfoDetails(addprogramgrid);
            if(!isNullOrEmpty(relationshipInfo)){
            	for (i in relationshipInfo) {
            		if(relationshipInfo[i].relationship != "BROTHER" && relationshipInfo[i].relationship != "SISTER"){
            			relationshipInfo[i].relatedPerson['haveAccessToLearner']=true
            		}
            	}
            }
            var createApplicationEntityDataModel = new Academia.model.admission.applicationFormSale.CreateApplicationEntityDataModel();
           
            createApplicationEntityDataModel.set('application',applicationInfo);
            createApplicationEntityDataModel.set('programs',programInfo);
            if(!isNullOrEmpty(relationshipInfo)){
            	createApplicationEntityDataModel.set('applicantPersonRelationships',relationshipInfo);
            }else{
            	var arr=[];
            	createApplicationEntityDataModel.set('applicantPersonRelationships',arr);
            }
            
            createApplicationEntityDataModel.set('whehterDirectSubmission',formData.whehterDirectSubmission);
            if(formData.applicationType=="EXISTING_STUDENT"){
            	createApplicationEntityDataModel.data.application.linkStudentId = {
            			id: formData.id
            	}
            }
            if(formData.applicationType=="ENQUIRED_EARLIER" && !isNullOrEmpty(formData.linkStudentId)){
            	createApplicationEntityDataModel.data.application.linkStudentId = {
            			id: formData.linkStudentId
            	}
            }
            if(!isNullOrEmpty(formData.whetherHostelApplicable) && formData.whetherHostelApplicable ){
            	createApplicationEntityDataModel.data.application.whetherHostelApplicable = formData.whetherHostelApplicable;
                createApplicationEntityDataModel.data.application.person.dietaryRequirements = formData.dietaryRequirements;
                createApplicationEntityDataModel.data.application.person.foodAllergies = formData.foodAllergies;
                createApplicationEntityDataModel.data.application.person.sleepingDisorder = formData.sleepingDisorder;
                createApplicationEntityDataModel.data.application.person.anyMedicalNeedsOrSomething = formData.anyMedicalNeedsOrSomething;	
            }
            
            if(!isNullOrEmpty(formData.applicationOwner) ){
            	createApplicationEntityDataModel.data.application.applicationOwner = {};
            	createApplicationEntityDataModel.data.application.applicationOwner.id = formData.applicationOwner; 
            }
            
            
            if(!isNullOrEmpty(formData.applicantModeOfEnquiry) ){
            	
            	var modeOfEnquiryJsonArry = [];
            	if(typeof formData.applicantModeOfEnquiry == "object"){
            		Ext.each(formData.applicantModeOfEnquiry, function(currentModeOfEnquiry){
            			var applicantModeOfEnquiry = '';
            			var mainObj = '';
            			if(!isNullOrEmpty(currentModeOfEnquiry)){
            				mainObj = {
            						"enquiryMode" : {
            							"id" : currentModeOfEnquiry.data.id
            						}	
            				}
            				modeOfEnquiryJsonArry.push(mainObj);
            			}
            		});
            	}
            	else{
            		var applicantModeOfEnquiry = '';
            		var mainObj = '';
            		mainObj = {
            				"enquiryMode" : {
            					"id" : formData.applicantModeOfEnquiry
            				}		
            		}
            		modeOfEnquiryJsonArry.push(mainObj);
            	}
            	createApplicationEntityDataModel.data.application.applicationEnquiryMultipleMode = modeOfEnquiryJsonArry;
            }
            
            var jsonFormatFormData = Ext.encode(createApplicationEntityDataModel.data);
            if (!isNullOrEmpty(jsonFormatFormData) &&  this.validatePhone(formData) && this.validateGrid(addprogramgrid) && this.validateDuplicateRelationship(relationshipInfo)) {
            	if(isUpdate) {
            	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    jsonData: jsonFormatFormData,
                    method: 'POST',
                    success: function(response, form) {
                    	 Ext.getBody().unmask();
                    	 var responseData = Ext.decode(response.responseText);
                            showSuccessMessage(getAdmissionTranslation('UPDATE_APPLICATION'), getAdmissionTranslation('UPDATE_APPLICATION_MSG')); //Application updated successfully.
                            $this.onSaveOpenNewTab(formData.token);
                    },
                    failure: function(form, action) {
                    	if(Ext.decode(form.responseText)[0].key == "ADMISSION_PROCESS_NOT_STARTED") {
                    		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_PROCESS_NOT_STARTED'));
                    	}else if(Ext.decode(form.responseText)[0].key == "APPLICATION_PROCESS_NOT_STARTED"){
                    		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('APPLICATION_PROCESS_NOT_STARTED'));
                    	}
        	        }
                });
            	} else {
            		var objectForDuplication = new Object();
            		var existingObject = createApplicationEntityDataModel.data;
            		objectForDuplication.studentFirstName = existingObject.application.person.firstName;
            		objectForDuplication.studentMiddleName = existingObject.application.person.middleName;
            		objectForDuplication.studentLastName = existingObject.application.person.lastName;
            		objectForDuplication.mobileCountryCode = existingObject.application.person.mobileCountryCode;
            		objectForDuplication.mobileNo = existingObject.application.person.mobileNumber;
            		objectForDuplication.email = existingObject.application.person.emailId;
            		if(!isNullOrEmpty(existingObject.application.person.birthDate)) {
            			objectForDuplication.dateOfBirth = existingObject.application.person.birthDate;
            		}
            		if(!isNullOrEmpty(existingObject.programs) && !isNullOrEmpty(existingObject.programs[0])) {
            			var pbsIds = [];
						for(var i=0; i<existingObject.programs.length; i++){
							pbsIds.push(existingObject.programs[i].progBatchSeatConfigId);
						}
						objectForDuplication.programBatchSeatTypeIdString = pbsIds.join();
            		}
            		jsonFormDataForDuplication = Ext.encode(objectForDuplication);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_TO_CHECK_DUPLICATE_APPLICATION_ON_ERP,
                        jsonData: jsonFormDataForDuplication,
                        method: 'POST',
                        success: function(response, form) {
                        	 Ext.getBody().unmask();
                        	 var data = Ext.decode(response.responseText);
                        	 if(data.isDuplicateApplication) {
                        		 var msgHeader = "Dear Prospective Parent/Guardian";
                        		 var status = getAdmissionTranslation(data.applicationStatus);
                        		 var applicationCode;
                        		 if(!isNullOrEmpty(data.applicationCode)) {
                        			 applicationCode=data.applicationCode;
                        		 } else {
                        			 applicationCode=data.firstName;
                        		 }
                        		 var msgBody = "The system has detected that an Application has already been submitted with these details specified. For your reference, the Application ID/Name is " + 
                        		 	applicationCode + " and has the following status: " + status + "." + "<br><br>" +
                        		 	"Kindly contact the school/college for the any further queries.";
                        		 showWarningMessage(msgHeader,msgBody);
                        	 } else {
	                        	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                             Ext.Ajax.request({
	                                 type: 'rest',
	                                 url: submitUrl,
	                                 jsonData: jsonFormatFormData,
	                                 method: 'POST',
	                                 success: function(response, form) {
	                                 	 Ext.getBody().unmask();
	                                 	 var responseData = Ext.decode(response.responseText);
	                                     var token = responseData.formToken;
	                                     showSuccessMessage(getAdmissionTranslation('ADD_APPLICATION'), getAdmissionTranslation('ADD_APPLICATION_MSG')); //Application saved successfully.
	                                     $this.resetApplicationDetailForm();
	                                     $this.onSaveOpenNewTab(token);
	                                 },
	                                 failure: function(form, action) {
	                                 	if(Ext.decode(form.responseText)[0].key == "ADMISSION_PROCESS_NOT_STARTED") {
	                                 		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_PROCESS_NOT_STARTED'));
	                                 	}else if(Ext.decode(form.responseText)[0].key == "APPLICATION_PROCESS_NOT_STARTED"){
	                                 		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('APPLICATION_PROCESS_NOT_STARTED'));
	                                 	}
	                     	        }
	                             });
                        	 }
                         },
                         failure: function(form, action) {
                        	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                             Ext.Ajax.request({
                                 type: 'rest',
                                 url: submitUrl,
                                 jsonData: jsonFormatFormData,
                                 method: 'POST',
                                 success: function(response, form) {
                                 	 Ext.getBody().unmask();
                                 	 var responseData = Ext.decode(response.responseText);
                                     var token = responseData.formToken;
                                     showSuccessMessage(getAdmissionTranslation('ADD_APPLICATION'), getAdmissionTranslation('ADD_APPLICATION_MSG')); //Application saved successfully.
                                     $this.resetApplicationDetailForm();
                                     $this.onSaveOpenNewTab(token);
                                 },
                                 failure: function(form, action) {
                                 	if(Ext.decode(form.responseText)[0].key == "ADMISSION_PROCESS_NOT_STARTED") {
                                 		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_PROCESS_NOT_STARTED'));
                                 	}else if(Ext.decode(form.responseText)[0].key == "APPLICATION_PROCESS_NOT_STARTED"){
                                 		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('APPLICATION_PROCESS_NOT_STARTED'));
                                 	}
                     	        }
                             });
             	        }
                     });
            	}
            }
        }
    },
    
    /**
     * get Person info json data
     */
    getApplicationInfoDetails : function(formData){
    	var $this = this;
    	 var applicationFormData = new Object();
         var jsonFormatFormData = "";
         if (!isEmpty(formData)) {
             var applicationFormDataModel = new Academia.model.admission.applicationFormSale.ApplicationFormEntityDataModel(formData);

             applicationFormData = applicationFormDataModel.data;

             var personEntity = new Academia.model.admission.applicationFormSale.PersonEnityModel(formData);
             personEntity.data.id = formData.personId;
             personEntity.data.version = formData.version;
             
             if(isNullOrEmpty(personEntity.data.employeeId)){ 
             	personEntity.data.employeeId=null;
         	 }
             
             if(isNullOrEmpty(personEntity.data.nationality)) {
                	delete personEntity.data.nationality;
             }
             if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                 personEntity.data.salutation.id = 1;
                 formData.whehterDirectSubmission = true;
             }
             
             personEntity.data.status = 'ACTIVE';
             applicationFormData.person = personEntity.data;
             
             if(isNullOrEmpty(applicationFormData.person.salutation)) {
            	 applicationFormData.person.salutation = null;
             }
             applicationFormData.person.genderCSM = $this.generateJsonDataForGender(applicationFormData.person.genderCSM);
             applicationFormData.person.id = formData.personId;
             applicationFormData.person.version = formData.personVersion;
             
             applicationFormData.id = formData.applicationId;
             applicationFormData.version = formData.version;
             applicationFormData.applicationFormId = formData.applicationFormId;
             applicationFormData.submissionDate = formData.submissionDate;
             
             if(isNullOrEmpty(formData.token)){
            	 applicationFormData.token = null;
             }else{
            	 applicationFormData.token = formData.token;
             }
             
             if(formData.whehterDirectSubmission){
            	 applicationFormData.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED';
             }else{
            	 applicationFormData.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
             }

             var selectedApplicationType = formData.saleRefType;
             if (!isNullOrEmpty(selectedApplicationType)) {
                 if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                     applicationFormData.code = "";
                     applicationFormData.existingStudentId = "";
                     applicationFormData.enquiryStudentDetailId =formData.saleRefPrimaryId; 
                 } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                     applicationFormData.code = "";
                     applicationFormData.existingStudentId = "";
                     applicationFormData.enquiryStudentDetailId = "";
                 } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                     applicationFormData.code = "";
                     applicationFormData.existingStudentId = formData.saleRefPrimaryId;
                     applicationFormData.enquiryStudentDetailId = "";
                 }
             } else {
                 applicationFormData.code = formData.applicationCode;// assign code for edit application  
                 applicationFormData.existingStudentId = "";
                 applicationFormData.enquiryStudentDetailId = "";
             }
             jsonFormatFormData = applicationFormData;
         }
         return jsonFormatFormData;
    },
    
    getRelationshipInfoDetails : function(formData){
    	
    	var $this = this;
    	var relationshipjsonFormatData="";
    	var employeeOrStudentId;
    	var myJson = new Array();
    	if (!isEmpty(formData["relationship"])) {
    		var isArr = isArray(formData["relationship"]);
    		if (isArr == true) {
    			for (var i = 0; i < formData["relationship"].length; i++) {
    				if(!isNullOrEmpty(formData["relationship"][i])){
    					if(!isNullOrEmpty(formData["relationshipStudent"][i])){
    						employeeOrStudentId = formData["relationshipStudent"][i]
    					}else{
    						employeeOrStudentId = formData["relationshipUser"][i]
    					}
    					var obj = new Object();
    					obj.person = $this.getIdValueJson(formData.personId);
    					obj.relationship = formData["relationship"][i];
    					obj.id = formData["personRelationshipsId"][i];
    					obj.version = formData["personRelationshipsVersion"][i];
    					obj.relatedPerson = {
    							isDeleted: false,
    							status: "ACTIVE",
    							firstName: formData["relationshipName"][i],
    							isEmployeeOfOrganization: formData["relationshipCheckbox"][i],
    							employeeId:employeeOrStudentId,
    							firstName: formData["relationshipName"][i],
    							mobileCountryCode: formData["relationshipMobileCountryCode"][i],
    							mobileNumber: formData["relationshipMobileNo"][i],
    							emailId: formData["relationshipEmail"][i],
    							isEmployeeOfOrganization: formData["relationshipCheckbox"][i],
    							id: formData["relatedPersonId"][i],
    							version: formData["relatedPersonVersion"][i],
    							externalEmployeeId: formData["relationshipUserExternal"][i],
    					}
    					myJson.push(obj);
    				}
    			}
    			if((Ext.app.checkVelocity || Ext.app.checkVelocity=="true") && !isNullOrEmpty(formData["enquirerSalutationID"])){
    				myJson[0].relatedPerson.salutation={
    					id:formData["enquirerSalutationID"]	
    				}
    			}
    		}else{
    			var obj = new Object();
    			obj.person =  $this.getIdValueJson(formData.personId);
    			obj.relationship = formData.relationship;
                obj.id = formData.personRelationshipsId;
    			obj.version = formData.personRelationshipsVersion;
    			obj.relatedPerson = $this.getRelatedPerson(formData);
    			myJson.push(obj);
    		}
    		relationshipjsonFormatData = myJson;	
    	}
    	//var abc = xyz.i;
        return relationshipjsonFormatData;
    },
    getProgramInfoDetails : function(grid){
    	var me = this;
    	var gridStore = grid.getStore();
    	var records = gridStore.getRange();
    	var selectedRecords = new Array();
    	for (var count = 0; count < records.length; count++) {
    		var selectedRecord = records[count];
    		if (!isEmpty(selectedRecord.data)) {
    			var selectedRecordObject = new Object();
    	        selectedRecordObject.id = selectedRecord.get('id');
    			selectedRecordObject.version = selectedRecord.get('version');
    			selectedRecordObject.progBatchSeatConfigId = (!isNullOrEmpty(selectedRecord.get('programBatchSeatConfigurationId'))) ? selectedRecord.get('programBatchSeatConfigurationId') : null;
    			selectedRecordObject.programId = getObjectValue(selectedRecord.get('program'),'id');
    			selectedRecordObject.currentStatus = (!isNullOrEmpty(selectedRecord.get('currentStatus'))) ? selectedRecord.get('currentStatus') : 'ACTIVE';
    			selectedRecordObject.priority = (!isNullOrEmpty(selectedRecord.priority)) ? selectedRecord.priority : count+1;
    			selectedRecordObject.academyLocationId = (!isNullOrEmpty(selectedRecord.get('academyLocationId'))) ? selectedRecord.get('academyLocationId') :null;
    			selectedRecordObject.distancetoTravel = (!isNullOrEmpty(selectedRecord.get('distancetoTravel'))) ? selectedRecord.get('distancetoTravel') : 0;
    			selectedRecordObject.programGroupId = selectedRecord.get('programGroupId');
    			
				var schoolAttendanceStartDateValue = selectedRecord.get('schoolAttendanceStartDate');
				// Optional: convert to timestamp if it's a Date object
				if (schoolAttendanceStartDateValue instanceof Date) {
					selectedRecordObject.schoolAttendanceStartDate = schoolAttendanceStartDateValue.getTime();
				} else {
					selectedRecordObject.schoolAttendanceStartDate = schoolAttendanceStartDateValue || null;
				}
    			selectedRecordObject = me.getStatus(selectedRecordObject,selectedRecord,'whetherHostelApplicable','whetherHostelApplicable');
    			selectedRecordObject = me.getStatus(selectedRecordObject,selectedRecord,'whetherTransportApplicable','whetherTransportApplicable');                    
    			selectedRecords.push(selectedRecordObject);
    		}
    	}
    	programjsonFormatData = selectedRecords;
    	return programjsonFormatData;
    },
    getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
    },
    getRelatedPerson : function(formData){
    	
    	if(!isNullOrEmpty(formData.relationshipStudent)){
    		employeeOrStudentId = formData.relationshipStudent;
    	}else{
    		employeeOrStudentId = formData.relationshipUser;
    	}
    	var enquirerSalutation;
    	if((Ext.app.checkVelocity || Ext.app.checkVelocity=="true") && !isNullOrEmpty(formData.enquirerSalutationID)){
    		enquirerSalutation={
          	  id:formData.enquirerSalutationID	
            }
    	}
    	return {
              isDeleted: false,
              status: "ACTIVE",
              firstName: formData.relationshipName,
              mobileCountryCode: formData.relationshipMobileCountryCode,
              mobileNumber: formData.relationshipMobileNo,
              emailId: formData.relationshipEmail,
              isEmployeeOfOrganization: formData.relationshipCheckbox,
              employeeId:employeeOrStudentId,
              id:formData.relatedPersonId,
              version:formData.relatedPersonVersion,
              salutation:enquirerSalutation
            };
    	},
    	/**
    	 * set employee info
    	 */
    	setEmployeeDetails : function(combo,data){
    	  var fatherDetailsContainer  = combo.up('applicantcommonform');
   		  var fatherFirstName=data[0].get('printName');
   		  fatherDetailsContainer.down('#relationshipName').setValue(fatherFirstName);
    	},
    	 /**
    	 * SET the print name value when user entered first, middle and lastname.
    	 */
    	setPrintAndShortName:function(obj){
    		var form = obj.up('form');
    		var getForm=form.getForm();
    		var firstName = getForm.findField('firstName').getValue();
    		var middleName = getForm.findField('middleName').getValue();
    		var lastName = getForm.findField('lastName').getValue();

    		var printName=null;
    		if(isNullOrEmpty(middleName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName+" "+middleName+" "+lastName ;
    		}
    		printName=printName.trim();
    		var task = new Ext.util.DelayedTask(function(){
    			if(getForm.managedListeners.length!=0){
    				if(getForm.findField('printName'))
    					getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
    				if(getForm.findField('shortName'))
    					getForm.findField('shortName').setValue(printName.replace(/ +/g, " "));
    			}
    		},this);
    	   task.delay(50);
    	   Ext.resumeLayouts();
    	},
    	setPrintAndShortOtherLanguageName:function(obj){
    		var form = obj.up('form');
    		var getForm=form.getForm();
    		var firstName = getForm.findField('firstNameOtherLanguage').getValue();
    		var middleName = getForm.findField('middleNameOtherLanguage').getValue();
    		var lastName = getForm.findField('lastNameOtherLanguage').getValue();

    		var printName=null;
    		if(isNullOrEmpty(middleName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName+" "+middleName+" "+lastName ;
    		}
    		printName=printName.trim();
    		var task = new Ext.util.DelayedTask(function(){
    			if(getForm.managedListeners.length!=0){
    				if(getForm.findField('printNameOtherLanguage'))
    					getForm.findField('printNameOtherLanguage').setValue(printName.replace(/ +/g, " "));
    				if(getForm.findField('shortNameOtherLanguage'))
    					getForm.findField('shortNameOtherLanguage').setValue(firstName.replace(/ +/g, " "));
    			}
    		},this);
    	   task.delay(50);
    	   Ext.resumeLayouts();
    	},
    	validateGrid:function(grid){
    		var isValid;
    		var store = grid.getStore();
    		var storeData = store.getRange().length;
    		
    		if(storeData > 0){
    			isValid= true;
    		}
    		else{
    			showWarningMessage(getAdmissionTranslation('ADD_APPLICATION'),getAdmissionTranslation('PROGRAM_GRID_DETAIL'));
    			isValid=false;
    		}
    		return isValid;
    	},
    	validateDuplicateRelationship : function(relationshipInfo){

    		if(!isNullOrEmpty(relationshipInfo)){
    			var isValid;
    			var myArray=[];
    			for(var i in relationshipInfo){
    				var relationship = relationshipInfo[i].relationship;
    				if(relationship==='FATHER' || relationship==='MOTHER'){
    					myArray.push(relationship);	
    				}
    			}
    			var arrrray=Ext.Array.unique(myArray);

    			if(myArray.length ==arrrray.length){
    				isValid= true;
    			}else{
    				showWarningMessage(getAdmissionTranslation('ADD_APPLICATION'),getAdmissionTranslation('DUPLICATE_RELATIONSHIP_DEATIL'));
    				isValid=false;
    			}
    			return isValid;
    		}else{
    			return true;
    		}
    	},
    	onSaveOpenNewTab : function(formToken){
    		var ManageFormController = Academia.app.getController('Academia.controller.admission.manageForm.ManageFormController');
    		var contentpanel = this.getContentPanel();
        	var structure = Ext.widget('manageformstructure');
        	var tabName = getAdmissionTranslation('MANAGE_FORMS');
        	var getcontroller=this.getController('menu.CoreERPNavigationController');
        	
        	var getApplicationTab=getcontroller.getTab(getAdmissionTranslation('CREATE_APPLICATION'));
        	contentpanel.remove(getApplicationTab, true);
        	
        	var getTab=getcontroller.getTab(tabName);
        	if(getTab!=null){
        		contentpanel.remove(getTab, true);
        	}
        	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_TWO);
        	this.getManageFormQuickSeachForm().down("#FormNo").setValue(formToken);
        	ManageFormController.getSearchManageForm();
    	},
    	
    	resetApplicationDetailForm : function(){
    		var form = this.getApplicantCommonForm();
    		var grid = form.down('addprogramgrid');
    		
    		this.createApplicationFormReset(form);
    		this.relationshipDetailReset(form);
    		this.programDetailsReset(grid);
    		Ext.resumeLayouts();
    	},
    	createApplicationFormReset : function(form){
    		try{
    			form.getForm().reset();
    		} catch(e){
    			//console.log(e);
    		}
    	},
    	programDetailsReset : function(grid){
    		var store = grid.getStore();
    		var records = store.getRange();
    		for(var i in records)
    		   store.remove(records[i]);
    	},
    	relationshipDetailReset : function(form){
    		var panel = form.down('#relationshipDetailsId');
    		var panelLength = panel.items.length;
    		if(panelLength>1){
    			for(var i=panelLength; i>1;i--){
    				panel.remove(panel.items.items[i-1]);    				
    			}
    		}
    		form.doLayout();
    	},
    	setRelationShipDetails : function(combo,data){
    		 var form = this.getApplicantCommonForm();
    		 var relationshipCheckbox = form.down("#relationshipCheckbox");
    		 relationshipCheckbox.reset();
    		var selectedValue = combo.getValue();
    		switch (selectedValue) {
    		case 'BROTHER':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
    			break;
    		case 'SISTER':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
    			break;
    		case 'FATHER':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
    			break;
    		case 'MOTHER':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
    			break;
    		case 'GUARDIAN':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
    			break;
    		case 'LOCAL_GUARDIAN':
    			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
    		}
    			this.setEditableField(form,selectedValue);
    	},
    	setMoreRelationShipDetails : function(combo,data){
   		 var form = this.getApplicantCommonForm();
   		 var relationshipCheckbox = combo.nextSibling().nextSibling();
   		 relationshipCheckbox.reset();
   		var selectedValue = combo.getValue();
   		switch (selectedValue) {
   		case 'BROTHER':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
   			break;
   		case 'SISTER':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
   			break;
   		case 'FATHER':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
   			break;
   		case 'MOTHER':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
   			break;
   		case 'GUARDIAN':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
   			break;
   		case 'LOCAL_GUARDIAN':
   			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
   		}
   		this.setMoreEditableField(combo,selectedValue);
   	},
   	ShowHideOrganizationDetails  : function(form,checked){
   		var relationShipField = form.down("#relationShipField").getValue();
		var relationshipStudent = form.down("#relationshipStudent");
		var relationshipUser = form.down("#relationshipUser");
		relationshipStudent.setVisible(false);
		relationshipUser.setVisible(false);
		var relationshipName = form.down("#relationshipName");
		var relationshipMobileNo = form.down("#relationshipMobileNo");
		var relationshipEmail = form.down("#relationshipEmail");
		if(!checked){
			relationshipStudent.reset();
			relationshipStudent.allowBlank = true;
			relationshipStudent.setFieldLabel(getAdmissionTranslation('STUDENT_NAME'));
			relationshipName.reset();
			relationshipMobileNo.reset();
			relationshipEmail.reset();
			
			
			relationshipUser.reset();
			relationshipUser.allowBlank = true;
			//relationshipUser.setFieldLabel(getAdmissionTranslation('EMPLOYEE_ID'));
			relationshipUser.setFieldLabel(getAdmissionTranslation('USER_ID'));
			
		}else{
			switch (relationShipField) {
			case 'BROTHER':
				this.setFieldMandory(relationshipStudent,getAdmissionTranslation('STUDENT_NAME'));
				relationshipStudent.setVisible(true);
				break;
			case 'SISTER':
				this.setFieldMandory(relationshipStudent,getAdmissionTranslation('STUDENT_NAME'));
				relationshipStudent.setVisible(true);
				break;
			case 'FATHER':
				//this.setFieldMandory(relationshipUser,getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'MOTHER':
				//this.setFieldMandory(relationshipUser,getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'GUARDIAN':
				//this.setFieldMandory(relationshipUser,getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'LOCAL_GUARDIAN':
				//this.setFieldMandory(relationshipUser,getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
			}
		}
		form.isValid();
	},
	ShowHideMoreOrganizationDetails  : function(obj,checked){
		var form = this.getApplicantCommonForm();
   		var relationShipField = obj.previousSibling().getValue();
   		if(isNullOrEmpty(relationShipField))
   			{
   			relationShipField = obj.previousSibling().previousSibling().getValue();
   			}
		var relationshipStudent = obj.nextSibling();
		var relationshipUser = obj.nextSibling().nextSibling();
		relationshipStudent.setVisible(false);
		relationshipUser.setVisible(false);
		if(!checked){
			relationshipStudent.reset();
			relationshipStudent.allowBlank = true;
			relationshipStudent.setFieldLabel(getAdmissionTranslation('STUDENT_NAME'));
			obj.ownerCt.nextSibling().items.items[0].reset();
			obj.ownerCt.nextSibling().items.items[1].getRefItems()[1].reset();
			obj.ownerCt.nextSibling().items.items[2].reset();
			
			relationshipUser.reset();
			relationshipUser.allowBlank = true;
			//relationshipUser.setFieldLabel(getAdmissionTranslation('EMPLOYEE_ID'));
			relationshipUser.setFieldLabel(getAdmissionTranslation('USER_ID'));
		}else{
			switch (relationShipField) {
			case 'BROTHER':
				this.setFieldMandory(relationshipStudent,getAdmissionTranslation('STUDENT_NAME'));
				relationshipStudent.setVisible(true);
				break;
			case 'SISTER':
				this.setFieldMandory(relationshipStudent,getAdmissionTranslation('STUDENT_NAME'));
				relationshipStudent.setVisible(true);
				break;
			case 'FATHER':
				//this.setFieldMandory(relationshipUser,getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'MOTHER':
				//this.setFieldMandory(relationshipUser, getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'GUARDIAN':
				//this.setFieldMandory(relationshipUser, getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
				break;
			case 'LOCAL_GUARDIAN':
				//this.setFieldMandory(relationshipUser, getAdmissionTranslation('EMPLOYEE_ID'));
				this.setFieldMandory(relationshipUser,getAdmissionTranslation('USER_ID'));
				relationshipUser.setVisible(true);
			}
		}
		form.isValid();
	},
    showHideAdmissionDetailWindow : function(selectedApplicationType, applicantform) {
    	
    	if (selectedApplicationType != 'FRESH_APPLICANT') {
    		var window = this.getAddAdmissionDetailWindow();
    		if (!window) {
    			window = Ext.widget('addadmissiondetailwindow', {
    				itemId: 'addAdmissionDetailWindowItem'
    			});
    		}
    		window.show();
    		var searchComponent = applicantform.down("#searchComponent");
    		var enquiryPanel =  window.down('#enquiryPanel');
    		var studentPanel =  window.down('#studentPanel');
    		var applicantPanel =window.down('#applicantPanel');
    		var studentId=	window.down('#studentId');
    		var searchBtn =window.down('#searchButton');
    		var existingStudentCombo = window.down('#admStudentIAppNameItemId');
    		searchComponent.down('#contactFieldSet');
    		searchComponent.down('#personalDetailFieldset');

    		if (selectedApplicationType === 'ENQUIRED_EARLIER' ) {
    			enquiryPanel.setVisible(true);
    			applicantPanel.setVisible(false);
    			studentId.setVisible(false);
    			window.setTitle(getAdmissionTranslation('SEARCH_BY_ENQUIRED_EARLIER'));
    		} else if (selectedApplicationType === 'APPLIED_EARLIER' ) {
    			enquiryPanel.setVisible(false);
    			applicantPanel.setVisible(true);
    			studentId.setVisible(false);
    			window.setTitle(getAdmissionTranslation('SEARCH_BY_APPLIED_EARLIER'));
    		} else if (selectedApplicationType === 'EXISTING_STUDENT') {
    			enquiryPanel.setVisible(false);
    			applicantPanel.setVisible(false);
    			studentPanel.setVisible(true);
    			searchBtn.setDisabled(true);
    			studentId.setVisible(false);
    			existingStudentCombo.getStore().getProxy().extraParams = {
    			existingStudentCombo : selectedApplicationType 
        		};
    			
    			window.setTitle(getAdmissionTranslation('SEARCH_BY_EXISTING_STUDENT'));
    		} else {
    			enquiryPanel.setVisible(false);
    			applicantPanel.setVisible(false);
    			studentId.setVisible(false);
    		}
    		if (selectedApplicationType === 'FRESH_APPLICANT') {
    			searchBtn.setVisible(false);
    		} else {
    			searchBtn.setVisible(true);
    		}
    	}
    },
    setDisplayField:function(applicantForm,selectedApplicationType){
    	var dispalyCode=applicantForm.down('#dispalyCode');
    	if(selectedApplicationType === 'ENQUIRED_EARLIER'){
    		dispalyCode.setFieldLabel(getAdmissionTranslation('ENQUIRY_ID'));
    	}else if(selectedApplicationType === 'APPLIED_EARLIER'){
    		dispalyCode.setFieldLabel(getAdmissionTranslation('APPLICATION_ID'));
    	}else if(selectedApplicationType === 'EXISTING_STUDENT'){
    		dispalyCode.setFieldLabel(getAdmissionTranslation('STUDENT_ID'));
    	}                        
    	if(selectedApplicationType !== 'FRESH_APPLICANT'){
    		dispalyCode.setVisible(true);
    	}else{
    		dispalyCode.setVisible(false);
    	}
    },
    onSearchClick : function(me,searchWindow, applicantForm){
    	var searchResult = me.getSearchResultGrid(me, searchWindow,applicantForm);
        if (isEmpty(searchResult)) {
        	showWarningMessage(getAdmissionTranslation('APPLICATION'), getAdmissionTranslation('SEARCH_RESULT_MSG')); //No search result found
        } else {
            me.loadDataInSearchWindowGrid(me, searchResult, applicantForm);
            searchWindow.down("#importDetailPanel").setVisible(true);
        }
    },
    getSearchResultGrid: function(me,searchWindow,applicantForm) {
    	var searchResult = null;
    	var cmbApplicationType = applicantForm.down('#cmbApplicationType');
    	var selectedApplicationType = cmbApplicationType.getValue();
    	if (!isNullOrEmpty(selectedApplicationType)) {
    		if (selectedApplicationType === 'ENQUIRED_EARLIER') {
    			var searchCriteria = me.getSearchCriteria(me, searchWindow, selectedApplicationType);
    			searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
    		} else if (selectedApplicationType === 'APPLIED_EARLIER') {
    			var searchCriteria = me.getSearchCriteria(me, searchWindow, selectedApplicationType);
    			if(!isNullOrEmpty(searchCriteria) && !isNullOrEmpty(searchCriteria.applicationName) && isNullOrEmpty(searchCriteria.applicationId)){
    				var splitRecord=searchCriteria.applicationName.split("/");
        			searchCriteria.applicationId=splitRecord[0];
        			searchCriteria.applicationName=splitRecord[1];
    			}else{
        			if(!isNullOrEmpty(searchCriteria) && !isNullOrEmpty(searchCriteria.applicationName) && !isNullOrEmpty(searchCriteria.applicationId)){
        				var splitRecord=searchCriteria.applicationName.split("/");
            			searchCriteria.applicationName=splitRecord[1];
        			}
    			}
    			searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
    		} else if (selectedApplicationType === 'EXISTING_STUDENT') {
    			var searchCriteria = me.getSearchCriteria(me, searchWindow, selectedApplicationType);
    			searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
    		}
    	}
    	return searchResult;
    },
    loadDataInSearchWindowGrid: function(me, searchResult, applicantForm) {
        if (applicantForm) {
            var cmbApplicationType = applicantForm.down('#cmbApplicationType');
            var selectedApplicationType = cmbApplicationType.getValue();
            if (!isNullOrEmpty(selectedApplicationType)) {
                var columns = null,
                    store = null;
                if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                    var columnNames = [getAdmissionTranslation('ENQUIRY_ID'), getAdmissionTranslation('STUDENT_NAME'), getAdmissionTranslation('ACADEMY_LOCATION'), getAdmissionTranslation('PROGRAM'), getAdmissionTranslation('BATCH'), getAdmissionTranslation('SEAT_TYPE'), getAdmissionTranslation('ENQUIRY_STATUS'),getAdmissionTranslation('CONTACT_NO'), getAdmissionTranslation('EMAIL_ID'),];
                    var isHidden = [false, false, false, false, false, false, false, true, true];
                    var columnDataIndexes = ['code', 'name','academyLocation','program','batch','programBatchSeatConfiguration','status','number', 'email'];
                    columns = me.createSearchResultGridColumns(columnNames, columnDataIndexes,isHidden);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                    store.data.items[0].set('academyLocation', store.data.items[0].get('admissionEnquiryDetails').academyName +' '+ store.data.items[0].get('admissionEnquiryDetails').locationName);
                } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                    var columnNames = [getAdmissionTranslation('APPLICATION_ID'), getAdmissionTranslation('APPLICANT_NAME'), getAdmissionTranslation('CONTACT_NO'), getAdmissionTranslation('EMAIL_ID')];
                    var isHidden = [false, false, false, false];
                    var columnDataIndexes = ['code', 'name', 'number', 'email'];
                    columns = me.createSearchResultGridColumns(columnNames, columnDataIndexes,isHidden);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                    var columnNames = [getAdmissionTranslation('STUDENT_ID'), getAdmissionTranslation('STUDENT_NAME'),getPersonModuleTranslation('NATIONAL_ID'), getAdmissionTranslation('ADMISSION_ID'), getAdmissionTranslation('ACADEMY_LOCATION'), getAdmissionTranslation('PROGRAM'), getAdmissionTranslation('BATCH'), getAdmissionTranslation('SEAT_TYPE'), getAdmissionTranslation('ADMISSION_STATUS')];
                    var isHidden = [false, false, false, false,false,false,false,false,false];
                    var columnDataIndexes = ['studentCode', 'studentName', 'nationalId', 'admissionID','academyLocationName','programName','batch','seatType','admissionStatus'];
                    columns = me.getSearchGridColumns(columnNames, columnDataIndexes);
                    columns = me.createSearchResultGridColumns(columnNames, columnDataIndexes,isHidden);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                }
                if (!isEmpty(columns)) {
                    var grid = me.getAddAdmissionDetailWindow().down('grid');
                    grid.setVisible(true);
                    grid.reconfigure(store, columns);
                    var formWindow = me.getAddAdmissionDetailWindow();
                    if(grid.getStore().data.length==1){
                       	grid.getSelectionModel().select(grid.getStore().getAt(0));
                       }else{
                       	grid.getSelectionModel().deselectAll(true);
                       }
					if (selectedApplicationType != 'EXISTING_STUDENT') {
						me.disableSchoolAttendanceStartDatePivileges(formWindow, me.getSCHOOL_ATTENDANCE_START_DATE_PRIVILEGES());
					}
                }
            }
        }
    },
    /**
     * This function is used to create search grid columns
     *     
     */
    createSearchResultGridColumns: function(columnNames,columnDataIndexes,isVisible) {
        var columns = new Array();
        for (var count = 0; count < columnNames.length && count < columnDataIndexes.length; count++) {
            columns.push({
                header: columnNames[count],
                hidden:isVisible[count],
                dataIndex: columnDataIndexes[count],
                flex: .2
            });
        }
        return columns;
    },
    setStudentRelatedDetails : function(obj,records){
    	var this$ = this;
    	var form = obj.up('applicantcommonform');
    	var studentCode = records[0].get('studentCode');
    	if (!isNullOrEmpty(studentCode)) {
    		var params = {
    				studentCode: studentCode
    		};
    		this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
    			if(success){
    				var data = Ext.decode(response.responseText);
    				if (!isEmpty(data)) {
    					form.down("#relationshipName").setValue(data.person.printName);
    					form.down("#relationshipMobileNo").setValue(data.person.mobileNumber);
    					form.down("#relationshipEmail").setValue(data.person.emailId);
    					form.down("#relationshipMobileCountryCodeItemId").setValue(data.person.mobileCountryCode);
    					//form.getForm().findField("birthDate").setValue(data.person.birthDate);
    				}
    			}
    		});
    	}
    },
   setEmployeeRelatedDetails : function(obj,records){
	        var this$ = this;
	        var form = obj.up('applicantcommonform');
	        //var userCode = records[0].get('value');
	        var userCode = records[0].get('code');
	        if (!isNullOrEmpty(userCode)) {
	        	var params = {
	                userCode: userCode
	            };
	            this$.sendGetAjaxRequest(SERVERURL.VALIDATE_EMPLOYEE_ID, 'GET', params, function(option, success, response) {
	            	if(success){
	            		var data = Ext.decode(response.responseText);
	            		if (!isEmpty(data)) {
	            			form.down("#relationshipName").setValue(data.person.printName);
	            			form.down("#relationshipMobileCountryCodeItemId").setValue(data.person.mobileCountryCode);
	            			form.down("#relationshipMobileNo").setValue(data.person.mobileNumber);
	            			form.down("#relationshipEmail").setValue(data.person.emailId);
	            		}
	            	}
	            });
	        }
    },
    setMoreStudentRelatedDetails : function(obj,records){
    	var this$ = this;
    	var form = obj.up('applicantcommonform');
    	var studentCode = records[0].get('studentCode');
    	if (!isNullOrEmpty(studentCode)) {
    		var params = {
    				studentCode: studentCode
    		};
    		this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
    			if(success){
    				var data = Ext.decode(response.responseText);
    				if (!isEmpty(data)) {
    					var containers = obj.ownerCt.nextSibling();
    					containers.items.items[0].setValue(data.person.printName);
    					
    					var mobileContainer = containers.items.items[1];
    					mobileContainer.items.items[0].setValue(data.person.mobileCountryCode);
    					mobileContainer.items.items[1].setValue(data.person.mobileNumber);
    					
    					containers.items.items[2].setValue(data.person.emailId);
    				}
    			}
    		});
    	}
    },
   setMoreEmployeeRelatedDetails : function(obj,records){
	        var this$ = this;
	        var form = obj.up('applicantcommonform');
	        var userCode = records[0].get('value');
	        if (!isNullOrEmpty(userCode)) {
	        	var params = {
	                userCode: userCode
	            };
	            this$.sendGetAjaxRequest(SERVERURL.VALIDATE_EMPLOYEE_ID_FOR_ADMISSION, 'GET', params, function(option, success, response) {
	            	if(success){
	            		var data = Ext.decode(response.responseText);
	            		if (!isEmpty(data)) {
	            			var containers = obj.ownerCt.nextSibling();
	            			containers.items.items[0].setValue(data.person.printName);
	            			
	            			var mobileContainer = containers.items.items[1];
	    					mobileContainer.items.items[0].setValue(data.person.mobileCountryCode);
	    					mobileContainer.items.items[1].setValue(data.person.mobileNumber);
	    					
	    					containers.items.items[2].setValue(data.person.emailId);
	            		}
	            	}
	            });
	        }
    },
    AddDefaultProgram: function(me, searchWindow, applicantForm) {
    	var $this = this;
    	if (searchWindow) {
    		var grid = searchWindow.down('grid');
    		var programGrid = applicantForm.down('addprogramgrid');
    		var programStore = programGrid.getStore();
            var schoolAttendanceStartDate = searchWindow.down('#schoolAttendanceStartDate').getValue();
    		if (grid.getSelectionModel().getCount() > 0) {
    			var record = grid.getSelectionModel().getSelection()[0];
    			var selectedRecords = record.get('admissionEnquiryDetails');
    			var currentStatus;
    			var Status = selectedRecords.Status;
    			if(Status=='O'){
    				currentStatus='ACTIVE'
    			}else{
    				currentStatus='CLOSED'
    			}
    			var myJson={
    					'academyLocationId' : selectedRecords.academyLocation.id,
    					'academy' : $this.geValueJson(selectedRecords.academyName),
    					'location' :  $this.geValueJson(selectedRecords.locationName),
    					'program':selectedRecords.program,
    				    'batch':selectedRecords.batch,
    					'seatType':selectedRecords.seatType,
    					'currentStatus':currentStatus,
    					'version:':selectedRecords.version,
    					'whetherDeleted:':selectedRecords.whetherDeleted,
    					'id':selectedRecords.program.id,
    					'programBatchSeatConfigurationId':selectedRecords.programBatchSeatConfiguration.id,
    					'schoolAttendanceStartDate':schoolAttendanceStartDate
    			};
    			programStore.loadRawData(myJson,true);
    			var programRecord = programStore.getRange();
    		}
    	}
    },
    geValueJson: function(value) {
		if (value) return {
			value: value
		};
	},
	getResetApplicationDetails : function(){
		var form = this.getApplicantCommonForm();
		var grid = form.down('addprogramgrid');
		
		this.applicationFormReset(form);
		this.relationshipDetailReset(form);
		this.programDetailsReset(grid);
		
		Ext.resumeLayouts();
	},
	applicationFormReset : function(form){
		form.getForm().getFields().each(function(field) {
			if(field.name!='applicationType'){
				field.reset();
			}
		});
	},
	getDetailsApplicationReset : function(){
		var form = this.getApplicantCommonForm();
		var grid = form.down('addprogramgrid');
		
	    this.fieldFormReset(form);
		
		this.relationshipDetailReset(form);
		this.programDetailsReset(grid);
		
		Ext.resumeLayouts();
	},
	
	fieldFormReset : function(form){
		form.getForm().getFields().each(function(field){
			if(field.name!='applicationType' && field.itemId != 'applicantDetailsId' && field.name != 'whehterDirectSubmission'){
				field.reset();
			}
		});
	},
	setEditableField : function(form,selectedValue){
		
		var relationshipName = form.down('#relationshipName');
		var relationshipMobileCountryCodeItemId = form.down('#relationshipMobileCountryCodeItemId');
		var relationshipMobileNo = form.down('#relationshipMobileNo');
		var relationshipEmail = form.down('#relationshipEmail');
		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
		relationshipName.labelSeparator='';
		
		if(!isNullOrEmpty(selectedValue)){
			relationshipName.setReadOnly(false);
			relationshipMobileNo.setReadOnly(false);
			relationshipMobileCountryCodeItemId.setReadOnly(false);
			relationshipEmail.setReadOnly(false);
			relationshipName.allowBlank=false;
			relationshipName.setFieldLabel(getAdmissionTranslation('NAME_SURNAME')+allowblankFalse);
		}else{
			relationshipName.setReadOnly(true);
			relationshipMobileNo.setReadOnly(true);
			relationshipMobileCountryCodeItemId.setReadOnly(true);
			relationshipEmail.setReadOnly(true);
			relationshipName.allowBlank=true;
			relationshipName.setFieldLabel(getAdmissionTranslation('NAME_SURNAME'));
		}
	},
	setMoreEditableField : function(combo,selectedValue){
		var container = combo.ownerCt.nextSibling();
        var relationshipName = container.items.items[0];
        
		var mobileContainer = container.items.items[1];
		var relationshipMobileCountryCode = mobileContainer.items.items[0];
		var relationshipMobileNo = mobileContainer.items.items[1];
		
		var relationshipEmail = container.items.items[2];
		
		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
		relationshipName.labelSeparator='';

		if(!isNullOrEmpty(selectedValue)){
			relationshipName.setReadOnly(false);
			relationshipMobileCountryCode.setReadOnly(false);
			relationshipMobileNo.setReadOnly(false);
			relationshipEmail.setReadOnly(false);
			relationshipName.allowBlank=false;
			relationshipName.setFieldLabel(getAdmissionTranslation('NAME_SURNAME')+allowblankFalse);
		}else{
			relationshipName.setReadOnly(true);
			relationshipMobileCountryCode.setReadOnly(true);
			relationshipMobileNo.setReadOnly(true);
			relationshipEmail.setReadOnly(true);
			relationshipName.allowBlank=true;
			relationshipName.setFieldLabel(getAdmissionTranslation('NAME_SURNAME'));
		}
		relationshipName.validate();
	},
	setFieldMandory : function(field, fieldlabel, mandatory){
		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
		field.labelSeparator = '';
		field.setFieldLabel(fieldlabel+allowblankFalse);
		field.allowBlank = false;
	},
	 generateJsonDataForGender: function(genderFormId){
    	 var genderId = null;
         if (!isNullOrEmpty(genderFormId) && !isNullOrEmpty(genderFormId)) {
             genderId = {
                 id: genderFormId
             };
         }
        return genderId;
    },
    loadDFRForCreateApplicationEnquireEarlier: function() {
    	var applicantForm = this.getApplicantCommonForm();
    	var salutaion = applicantForm.down('#salutation');
    	var store = salutaion.getStore()
    	Ext.Ajax.request({
    		type: 'rest',
            async: false,
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            params: {
                screenName: 'applicantcommonform',
                academyLocationId: this.getCurrentAcademyLocation(),
                languageCode: 'en'
            },
            method: 'GET',
            success: function(res, action) {
            	var response = Ext.decode(res.responseText);
            	if (Object.keys(response).length > 0) {
            		var records = response.applicantcommonform;
            		for (i in records) {
            			var record = records[i];
            			if(record.formFieldId == 'salutation' && record.isVisible == false) {
            				store.load({
            					callback:function(rec, success) {
            						if (success){
            							for(i in rec) {
            								if(rec[i].get('id') == 1) {
            									salutaion.setValue(rec[i].get('id'));
            								}
            							}
            						}
            						
            					}
            				})
            			}
            		}
            	}
            }
    	})
    }
});
