/**
 * @author: Amit G
 *
 */
Ext.define('Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['enquiry.closure.ClosureSubmitModel', 'enquiry.closure.ReopenSubmitModel', 
	         'enquiry.followup.FollowUpDetailModel','admission.applications.applicationFollowUp.ApplicationFollowUpDetailModel'],
	stores: ['admission.applications.applicationFollowUp.ApplicationFollowUpDetailStore','enquiry.closure.ClosureStore',
	         'enquiry.followup.ClosureReasonStore', 'enquiry.EnqIntermediateType','enquiry.followup.ClosureReason',
		     'common.AcademyLocationNameSeparated', 'facilitiesresources.resourcemaster.ProgramGridStore',
		     'enquiry.AcademicBatchStore','enquiry.Priority','common.UsersWithDepartmentStore','enquiry.ReasonForFollowup','enquiry.FollowupActivityType','enquiry.FollowupActivityStatus',
		     'enquiry.ProgramBatchSeatTypeStore', 'enquiry.FollowUpUserWithDepartment','common.ProgramsByProgramCategoryWithALStore'],
	views: ['admission.applications.applicationFollowUp.ApplicationFollowUpStructure', 'admission.applications.applicationFollowUp.ApplicationFollowUpDetailGrid',
	        'admission.applications.applicationFollowUp.ApplicationFollowUpDetailForm','baselayout.contentarea.ContentPanel'],
	
	config: {
		/*
		 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
		 */
		/**
		 * @cfg {Array} FOLLOWUP_DETAIL_PERMISSIONS array (required)
		 * The array of permissions to use for Access control wise enabling and disabling buttons.
		 * @accessor
		 */
		FOLLOWUP_DETAIL_APPLICANT_PROFILE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FOLLOWUP_DETAIL_APPLICANT_PROFILE_PRIVILEGES')
	},
	alias: "widget.applicationfollowupdetailcontroller",
	refs: [{
		ref: 'applicationfollowupdetailform',
		selector: 'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailform form'
	}, {
		ref: 'applicationfollowupstructure',
		selector: 'personinfopanel[itemId=personInfoPanel] applicationfollowupstructure'
	}, {
		ref: 'applicationfollowupdetailgrid',
		selector: 'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailgrid'
	}, {
   	 ref: 'contentPanel',
	 selector: 'contentpanel'
 }, {
	 ref: 'personinfopanel',
	 selector: 'personinfopanel'
 }],
	init: function() {
		this.control({
			'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailgrid': {
				render: function() {
					var $this = this;
					var contantPanel = $this.getContentPanel();
					var applicantprofile = contantPanel.getActiveTab();
					var personinfopanel = applicantprofile.down('personinfopanel');
					var activeInnerTab = personinfopanel.getActiveTab();
					var grid = activeInnerTab.down('applicationfollowupdetailgrid');
					$this.renderApplicationFollowUpDetailGrid(grid);
					$this.doAccessControlValidation(grid, $this.getFOLLOWUP_DETAIL_APPLICANT_PROFILE_PERMISSIONS());
				}
			},
			'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailgrid button[itemId=btnEdit]': {
				click:function(obj) {
					var grid = obj.up('applicationfollowupdetailgrid');
					this.editApplicantFollowupFormWindow(grid);
				}
			},
			'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailform button[itemId=followdetail_submitbuttonId]': {
				click:function(obj) {
					var $this = this;
					var form = obj.up('applicationfollowupdetailform');
					var submitButton = form.down('#followdetail_submitbuttonId');
					submitButton.setDisabled(true);
					$this.saveApplicantFollowUpDetail();
				}
			},
			'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailform datefield#nextFollowUpDate': {
				select: function(obj, record) {
					var userByAssignTo = Ext.ComponentQuery.query('combo#userByAssignTo')[0];
					userByAssignTo.allowBlank = false;
				}
			},
			'personinfopanel[itemId=personInfoPanel] applicationfollowupdetailform checkboxfield[itemId=applicantWhetherNextFollowUpId]': {
            	change:function(checkbox, newValue, oldValue, eOpts){ 
            		var $this = this;
            		var contantPanel = $this.getContentPanel();
					var applicantprofile = contantPanel.getActiveTab();
					var personinfopanel = applicantprofile.down('personinfopanel');
					var activeInnerTab = personinfopanel.getActiveTab();
					var form = activeInnerTab.down('applicationfollowupdetailform');
            		var nextFollowUpDate = form.down('#applicantNextFollowUpDateId');
            		var userByAssignTo = form.down('#applicantUserByAssignToId');
            		nextFollowUpDate.reset();
            		userByAssignTo.reset();
            		if(newValue==true){
            			nextFollowUpDate.setVisible(true);
            			userByAssignTo.setVisible(true);
            			$this.setAllowBlank (nextFollowUpDate,false);
            			$this.setAllowBlank (userByAssignTo,false);
            			var userByAssignToStore = userByAssignTo.getStore();
            			var loggedUserId = this.getCurrentlyLoggedInUser().id;
            			Ext.defer(function() {
	            			userByAssignToStore.load({
		            			scope:this,
		            			callback: function(records, operation, success) {
			            			if(success){
			            				userByAssignTo.setValue(loggedUserId);
			            			}
		            			}
	            			});
            			});
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}else if(newValue==false){
                		nextFollowUpDate.setVisible(false);
            			userByAssignTo.setVisible(false);
            			$this.setAllowBlank (nextFollowUpDate,true);
            			$this.setAllowBlank (userByAssignTo,true);
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}
            		form.getForm().isValid();
				}
			},
			'applicationfollowupdetailform customcombobox[itemId=applicantFollowupactivitystatusId]':{
				    select:function(objval,record){
					var $this =this;
					var form = objval.up('applicationfollowupdetailform');
					var followupStatusUpdateTime = form.down('#followupStatusUpdateTimeId');
					var todayDate= new Date();
					var newDate = dateRender(todayDate)+" "+timeRender(todayDate);
					followupStatusUpdateTime.setValue(newDate);
					followupStatusUpdateTime.setReadOnly(true);             
					
					                   	
			                }
			            }
			});
	},
	
	renderApplicationFollowUpDetailGrid: function(grid) {
		var $this = this;
		var contantPanel = $this.getContentPanel();
		var getActiveTab = contantPanel.getActiveTab()
		var store = grid.getStore();
		store.getProxy().extraParams = {
			id: getActiveTab.getApplicationId()
		};
		store.load({
			callback: function(record, operation, success) {
				if (success) {
					if(Ext.isDefined(grid)){
						var recIndex = store.find('isLatestFollowUp', true);
						if(recIndex == -1){
							grid.getSelectionModel().select(store.getAt(store.getCount()-1));
						}else{
							grid.getSelectionModel().select(store.getAt(recIndex));	
						}
						var contantPanel = $this.getContentPanel();
						var applicantprofile = contantPanel.getActiveTab();
						var personinfopanel = applicantprofile.down('personinfopanel');
						var activeInnerTab = personinfopanel.getActiveTab();
						var form = activeInnerTab.down('applicationfollowupdetailform');
						var records = grid.getSelectionModel().getSelection();
						if (records != undefined && records != "" && records != null) {
							form.loadRecord(records[0]);
							var contantPanel = $this.getContentPanel();
							var getActiveTab = contantPanel.getActiveTab();
							var getPersonInfo = getActiveTab.personInfo;
							form.getForm().findField('actualApplicantFollowUpDate').setValue(new Date());
							form.getForm().findField('applicantFollowupTime').setValue(Ext.Date.format(new Date(), 'H:i'));
							form.getForm().findField('applicantEmailAdress').setValue(getPersonInfo.emailId);
							form.getForm().findField('applicantFollowupActivityTo').setValue(getPersonInfo.printName);
							form.getForm().findField('phoneCountryCode').setValue(getPersonInfo.mobileCountryCode);
							form.getForm().findField('cellNo').setValue(getPersonInfo.mobileNumber);
							form.getForm().findField('applicantFollowupuser').setValue(records[0].data.users.value);
							form.getForm().findField('applicantNextFollowUpDate').setValue(new Date());
							if(form.getForm().findField('applicantWhetherNextFollowUp').getValue()==false) {
								form.getForm().findField('applicantNextFollowUpDate').setVisible(false);
								form.getForm().findField('applicantUserByAssignTo').setVisible(false);
							}
							var followupStatusUpdateTime = form.down('#followupStatusUpdateTimeId');
							setTimeout(function(){
							followupStatusUpdateTime.setReadOnly(true);
                            var test=records[0].data.followupStatusUpdateTime;
                            var testtime=Ext.Date.parse(test,'d-m-Y H:i:s').getTime();
                            var newDate = dateRender(testtime)+" "+timeRender(testtime);
                            followupStatusUpdateTime.setValue(newDate);
							},1000);
							var priority = form.getForm().findField('applicantPriority');
							if(!isNullOrEmpty(priority)) {
								priority.store.load({
									callback : function(r, operation,success) {
										if (success) {
											if(!isNullOrEmpty(records[0].data.enquiryPriority)){
												if (records[0].data.enquiryPriority.id != null) {
													priority.setValue(records[0].data.enquiryPriority.id);
												} 	
											}
										}
									}
								});
							}
							var followUpActivityType = form.getForm().findField('applicantFollowUpActivityType');
	            			if(!isNullOrEmpty(followUpActivityType)) {
	            				followUpActivityType.getStore().load({
	            					callback : function(r, operation,success) {
	            						if (success) {
	            							if(!isNullOrEmpty(records[0].data.followUpActivityType))
	            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
	            						}
	            					}
	            				});
	            			}
	            			
	            			var reasonForFollowUp = form.getForm().findField('applicantReasonForFollowUp');
	            			if(!isNullOrEmpty(reasonForFollowUp)) {
	            				reasonForFollowUp.getStore().load({
	            					callback : function(r, operation,success) {
	            						if (success) {
	            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)){
	            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
	            							}
	            						}
	            					}
	            				});
	            			}
	            			var followUpActivityStatus = form.getForm().findField('applicantFollowUpActivityStatus');
	            			if(!isNullOrEmpty(followUpActivityStatus)) {
	            				followUpActivityStatus.getStore().load({
	            					callback : function(r, operation,success) {
	            						if (success) {
	            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus))
	            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
	            						}
	            					}
	            				});
	            			}
	            			if(!isNullOrEmpty(records[0].data.applicationStatus) && records[0].data.applicationStatus=='ADMISSION_GRANTED'){
	            				form.down('#followdetail_submitbuttonId').setVisible(false);
	            				form.down('#applicantWhetherNextFollowUpId').setValue(false);
	            				form.down('#applicantWhetherNextFollowUpId').setDisabled(true);
	            				form.getForm().findField('actualApplicantFollowUpDate').setReadOnly(true);
								form.getForm().findField('applicantFollowupTime').setReadOnly(true);
	            			}else{
	            				form.down('#followdetail_submitbuttonId').setVisible(true);
	            				form.down('#applicantWhetherNextFollowUpId').setDisabled(false);
	            				form.getForm().findField('actualApplicantFollowUpDate').setReadOnly(false);
								form.getForm().findField('applicantFollowupTime').setReadOnly(false);
	            			}
	            			form.down('#applicantUserByAssignToId').reset();
	            			form.down('#applicantNextFollowUpDateId').reset();
						}

					}
				}
			}
		
		});
		
	},
	editApplicantFollowupFormWindow: function(grid) {
		var $this = this;
		var rec = grid.getSelectionModel().getSelection();
		if (grid.getSelectionModel().getCount() > 0) {
			if (rec.length > 0 && rec[0].get('applicationStatus') != 'ADMISSION_GRANTED') {
				if (rec[0].get('status') == 'Open' || rec[0].get('isLatestFollowUp')) {
					var contantPanel = $this.getContentPanel();
					var applicantprofile = contantPanel.getActiveTab();
					var personinfopanel = applicantprofile.down('personinfopanel');
					var activeInnerTab = personinfopanel.getActiveTab();
					var form = activeInnerTab.down('applicationfollowupdetailform');
					var records = grid.getSelectionModel().getSelection();
					if (records != undefined && records != "" && records != null) {
						form.loadRecord(records[0]);
						form.getForm().findField('actualApplicantFollowUpDate').setValue(new Date());
						form.getForm().findField('applicantFollowupTime').setValue(Ext.Date.format(new Date(), 'H:i'));
						form.getForm().findField('applicantWhetherNextFollowUp').setValue(false);
						 var userAssignToCombo=form.getForm().findField('applicantUserByAssignTo');
	        			  userAssignToCombo.store.load({
	                          callback: function(r, operation, success) {
	                              if (success) {
	                            	  if(records[0].data.userByAssignTo!=null){
	                            	   userAssignToCombo.setValue(records[0].data.userByAssignTo.id);
	                            	  }
	                              }
	                          }
	                      });
						var followUpActivityType = form.getForm().findField('applicantFollowUpActivityType');
            			if(!isNullOrEmpty(followUpActivityType)) {
            				followUpActivityType.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
            							}	
            						}
            					}
            				});
            			}
            			
            			var reasonForFollowUp = form.getForm().findField('applicantReasonForFollowUp');
            			if(!isNullOrEmpty(reasonForFollowUp)) {
            				reasonForFollowUp.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
            							reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
            							}
            						}
            					}
            				});
            			}
            			var followUpActivityStatus = form.getForm().findField('applicantFollowUpActivityStatus');
            			if(!isNullOrEmpty(followUpActivityStatus)) {
            				followUpActivityStatus.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
            							}
            						}
            					}
            				});
            			}
						var priority = form.getForm().findField('applicantPriority');
						if(!isNullOrEmpty(priority)) {
							priority.store.load({
								callback : function(r, operation,success) {
									if (success) {
										if(!isNullOrEmpty(records[0].data.enquiryPriority)){
											if (records[0].data.enquiryPriority.id != null) {
												priority.setValue(records[0].data.enquiryPriority.id);
											} 	
										}
									}
								}
							});
						}
					}
				} else {
					showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('ALERT_FOLLOWUP_ALLOW_ONLY'));
				}
			}else{
				showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('APPLICATION_HAS_BEEN_ALREADY_GRANTED')); 
			}
			}else {
			showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	saveApplicantFollowUpDetail: function() {
		var me = this;
		var academyLocationId = me.getCurrentAcademyLocation();
		var contantPanel = me.getContentPanel();
		var applicantprofile = contantPanel.getActiveTab();
		var personinfopanel = applicantprofile.down('personinfopanel');
		var activeInnerTab = personinfopanel.getActiveTab();
		var formWindow = activeInnerTab.down('applicationfollowupdetailform');
		var form = formWindow.getForm();
		var submitButton = formWindow.down('#followdetail_submitbuttonId');
		var values = form.getValues();
		var grid = activeInnerTab.down('applicationfollowupdetailgrid');
		
		var recIndex = grid.getStore().find('isLatestFollowUp', true);
		if(recIndex == -1){
		grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
		}else{
		grid.getSelectionModel().select(grid.getStore().getAt(recIndex));
		}
		var records = grid.getSelectionModel().getSelection()[0];
		var gridLastId = records.get('id');
		var assignToUser = form.findField('applicantUserByAssignTo');
		var whetherNextFollowUp = form.findField('applicantWhetherNextFollowUp').getValue();
		
		var priority = form.findField('applicantPriority');
		var followupDate = values.applicantNextFollowUpDate;
		var assignToUserId = assignToUser.getValue();
		var assignToUserName = assignToUser.getRawValue();
		var followUpDetailModel = new Academia.model.admission.applications.applicationFollowUp.ApplicationFollowUpDetailModel();
		var contantPanel = me.getContentPanel();
		var getActiveTab = contantPanel.getActiveTab()
		followUpDetailModel.set("application",this.getIdValueJson(getActiveTab.getApplicationId()));
		followUpDetailModel.set("followUpDate", values.applicantNextFollowUpDate);
		followUpDetailModel.set("actualFollowUpDate", values.actualApplicantFollowUpDate);
		followUpDetailModel.set("nextFollowUpDate", values.applicantNextFollowUpDate);
		
		followUpDetailModel.set("userByAssignTo", this.getIdValueJson(assignToUserId, assignToUserName));
		followUpDetailModel.set("users", this.getIdValueJson(assignToUserId, assignToUserName));
		followUpDetailModel.set("followUpNo", 1);
		followUpDetailModel.set("whetherDeleted", false);
		followUpDetailModel.set("remark", values.remark);
		followUpDetailModel.set("lastFollowUpId", gridLastId);
		followUpDetailModel.set("enquiryPriority", this.getIdValueJson(values.applicantPriority));
		followUpDetailModel.set("status", values.applicantStatus);
		followUpDetailModel.set("reasonForFollowUp", this.getIdValueJson(values.applicantReasonForFollowUp));
		followUpDetailModel.set("followUpActivityType", this.getIdValueJson(values.applicantFollowUpActivityType));
		followUpDetailModel.set("followUpActivityStatus", this.getIdValueJson(values.applicantFollowUpActivityStatus));
		followUpDetailModel.set("followupTime",values.applicantFollowupTime);
		var date = values.followupStatusUpdateTime;
		var newDate = dateRender(date)+" "+timeRender(date);
		if(!isNullOrEmpty(newDate)){
			followUpDetailModel.set("followupStatusUpdateTime",newDate);
		}
		//followUpDetailModel.set("followupStatusUpdateTime",values.followupStatusUpdateTime);
		
		var fData = Ext.encode(followUpDetailModel.data);
		var submitUrl = SERVERURL.PATH_APPLICATION_FOLLOWUP_DETAIL_CREATE_URL;
		var checkFollowupUserURL = SERVERURL.ENQ_FOLLOWUP_USER;
		var checkLeaveURL = SERVERURL.ENQ_FOLLOWUP_CHECK_LEAVE;
		if (assignToUserId) {
			Ext.Ajax.request({
				type: 'rest',
				// rest call to check follow should be assigned or not according to academy location working hours
				url: checkFollowupUserURL + '?id=' + academyLocationId,
				method: 'GET',
				success: function(f, action) {
					var mssg = f.responseText;
					if (mssg == "FOLLOW_UP_ALLOWED") {
						Ext.Ajax.request({
							type: 'rest',
							url: checkLeaveURL + '?userId=' + assignToUserId + '&date=' + followupDate,
							method: 'GET',
							success: function(f, action) {
								var mssg = f.responseText;
								if (mssg == 'false') {
									Ext.Ajax.request({
										type: 'rest',
										url: submitUrl,
										jsonData: fData,
										method: 'POST',
										success: function(f, action) {
											grid.getStore().load({
						            			callback: function(record, operation, success) {
					            					if (success) {
					            						var recIndex = grid.getStore().find('isLatestFollowUp', true);
					            						if(recIndex == -1){
					            							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
					            						}else{
					            							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
					            						}
					        		            		var rec = grid.getSelectionModel().getSelection();
					        		            		var records = grid.getSelectionModel().getSelection();
					        		            		if (records != undefined && records != "" && records != null) {
					        		            			form.loadRecord(records[0]);
					        		            			var contantPanel = me.getContentPanel();
					        								var getActiveTab = contantPanel.getActiveTab();
					        								var getPersonInfo = getActiveTab.personInfo;
					        								form.findField('actualApplicantFollowUpDate').setValue(new Date());
					        								form.findField('applicantEmailAdress').setValue(getPersonInfo.emailId);
					        								form.findField('applicantFollowupActivityTo').setValue(getPersonInfo.printName);
					        								form.findField('phoneCountryCode').setValue(getPersonInfo.mobileCountryCode);
					        								form.findField('cellNo').setValue(getPersonInfo.mobileNumber);
					        								form.findField('applicantFollowupuser').setValue(records[0].data.users.value);
					        								form.findField('applicantNextFollowUpDate').setValue(new Date());
					        								var followupStatusUpdateTime=records[0].data.followupStatusUpdateTime;
					        								var testtime=Ext.Date.parse(followupStatusUpdateTime,'d-m-Y H:i:s').getTime();
                                                            var newDate = dateRender(testtime)+" "+timeRender(testtime);
					        		            			
					        		            			
					        		            			form.findField('followupStatusUpdateTime').setValue(newDate);
					        								var priority = form.findField('applicantPriority');
					        								if(!isNullOrEmpty(priority)) {
					        									priority.store.load({
					        										callback : function(r, operation,success) {
					        											if (success) {
					        												if(!isNullOrEmpty(records[0].data.enquiryPriority)){
					        													if (records[0].data.enquiryPriority.id != null) {
					        														priority.setValue(records[0].data.enquiryPriority.id);
					        														if(form.isValid()) {
					        															submitButton.setDisabled(false);
					        														}
					        													} 	
					        												}
					        											}
					        										}
					        									});
					        								}
					        								var followUpActivityType = form.findField('applicantFollowUpActivityType');
					        		            			if(!isNullOrEmpty(followUpActivityType)) {
					        		            				followUpActivityType.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
					        		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
					        		            								if(form.isValid()) {
				        															submitButton.setDisabled(false);
				        														}
					        		            							}
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			
					        		            			var reasonForFollowUp = form.findField('applicantReasonForFollowUp');
					        		            			if(!isNullOrEmpty(reasonForFollowUp)) {
					        		            				reasonForFollowUp.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)){
					        		            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
					        		            								if(form.isValid()) {
				        															submitButton.setDisabled(false);
				        														}
					        		            							}
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			var followUpActivityStatus = form.findField('applicantFollowUpActivityStatus');
					        		            			if(!isNullOrEmpty(followUpActivityStatus)) {
					        		            				followUpActivityStatus.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
					        		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
					        		            							if(form.isValid()) {
			        															submitButton.setDisabled(false);
			        														}
					        		            							}
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            		}
					        		            		if(form.isValid()) {
															submitButton.setDisabled(false);
														}
					            					} else {
					            						if(form.isValid()) {
															submitButton.setDisabled(false);
														}
					            					}
					            				}
						            		
											});
											grid.getSelectionModel().deselectAll();
											whetherNextFollowUp = form.findField('applicantWhetherNextFollowUp');
											whetherNextFollowUp.setValue(false);
											showSuccessMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
										},
										failure: function(f, action) {
											if(form.isValid()) {
												submitButton.setDisabled(false);
											}
										}
									});
								} else {
									showConfirmMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('FOLLOWUP_NOT_ASSIGN'), function(btn, text) {
										if (btn == 'yes') {
											Ext.Ajax.request({
												type: 'rest',
												url: submitUrl,
												jsonData: fData,
												method: 'POST',
												success: function(f, action) {
													grid.getStore().load({
								            			callback: function(record, operation, success) {
							            					if (success) {
							            						var recIndex = grid.getStore().find('isLatestFollowUp', true);
							            						if(recIndex == -1){
							            							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
							            						}else{
							            							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
							            						}
							        		            		var rec = grid.getSelectionModel().getSelection();
							        		            		var records = grid.getSelectionModel().getSelection();
							        		            		if (records != undefined && records != "" && records != null) {
							        		            			form.loadRecord(records[0]);
							        		            			var contantPanel = me.getContentPanel();
							        								var getActiveTab = contantPanel.getActiveTab();
							        								var getPersonInfo = getActiveTab.personInfo;
							        								form.findField('actualApplicantFollowUpDate').setValue(new Date());
							        								form.findField('applicantEmailAdress').setValue(getPersonInfo.emailId);
							        								form.findField('applicantFollowupActivityTo').setValue(getPersonInfo.printName);
							        								form.findField('phoneCountryCode').setValue(getPersonInfo.mobileCountryCode);
							        								form.findField('cellNo').setValue(getPersonInfo.mobileNumber);
							        								form.findField('applicantFollowupuser').setValue(records[0].data.users.value);
							        								form.findField('applicantNextFollowUpDate').setValue(new Date());
							        								var priority = form.findField('applicantPriority');
							        								if(!isNullOrEmpty(priority)) {
							        									priority.store.load({
							        										callback : function(r, operation,success) {
							        											if (success) {
							        												if(!isNullOrEmpty(records[0].data.enquiryPriority)){
							        													if (records[0].data.enquiryPriority.id != null) {
							        														priority.setValue(records[0].data.enquiryPriority.id);
							        														if(form.isValid()) {
							        															submitButton.setDisabled(false);
							        														}
							        													} 	
							        												}
							        											}
							        										}
							        									});
							        								}
							        								var followUpActivityType = form.findField('applicantFollowUpActivityType');
							        		            			if(!isNullOrEmpty(followUpActivityType)) {
							        		            				followUpActivityType.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
							        		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
							        		            								if(form.isValid()) {
						        															submitButton.setDisabled(false);
						        														}
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            			
							        		            			var reasonForFollowUp = form.findField('applicantReasonForFollowUp');
							        		            			if(!isNullOrEmpty(reasonForFollowUp)) {
							        		            				reasonForFollowUp.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)){
							        		            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
							        		            								if(form.isValid()) {
						        															submitButton.setDisabled(false);
						        														}
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            			var followUpActivityStatus = form.findField('applicantFollowUpActivityStatus');
							        		            			if(!isNullOrEmpty(followUpActivityStatus)) {
							        		            				followUpActivityStatus.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
							        		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
							        		            							if(form.isValid()) {
					        															submitButton.setDisabled(false);
					        														}
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            		}
							        		            		if(form.isValid()) {
        															submitButton.setDisabled(false);
        														}
							            					} else {
							            						if(form.isValid()) {
        															submitButton.setDisabled(false);
        														}
							            					}
							            				}
								            		
													});
													grid.getSelectionModel().deselectAll();
													whetherNextFollowUp = form.findField('applicantWhetherNextFollowUp');
													whetherNextFollowUp.setValue(false);
													showSuccessMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
												},
												failure: function(f, action) {
													if(form.isValid()) {
														submitButton.setDisabled(false);
													}
												}
											});
										} else {
											if(form.isValid()) {
												submitButton.setDisabled(false);
											}
										}
									});
								}
							},
							failure: function(f, action) {
								if(form.isValid()) {
									submitButton.setDisabled(false);
								}
							}
						});
					} else {
						if(form.isValid()) {
							submitButton.setDisabled(false);
						}
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('FOLLOWUP_MSSG'));
					}
				},
				failure: function(f, action) {
					if(form.isValid()) {
						submitButton.setDisabled(false);
					}
				}
			});
		} else {
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: fData,
				method: 'POST',
				success: function(f, action) {
					grid.getStore().load({
            			callback: function(record, operation, success) {
        					if (success) {
        						var recIndex = grid.getStore().find('isLatestFollowUp', true);
        						if(recIndex == -1){
        							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
        						}else{
        							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
        						}
    		            		var rec = grid.getSelectionModel().getSelection();
    		            		var records = grid.getSelectionModel().getSelection();
    		            		if (records != undefined && records != "" && records != null) {
    		            			form.loadRecord(records[0]);
    		            			var contantPanel = me.getContentPanel();
    								var getActiveTab = contantPanel.getActiveTab();
    								var getPersonInfo = getActiveTab.personInfo;
    								form.findField('actualApplicantFollowUpDate').setValue(new Date());
    								form.findField('applicantEmailAdress').setValue(getPersonInfo.emailId);
    								form.findField('applicantFollowupActivityTo').setValue(getPersonInfo.printName);
    								form.findField('phoneCountryCode').setValue(getPersonInfo.mobileCountryCode);
    								form.findField('cellNo').setValue(getPersonInfo.mobileNumber);
    								form.findField('applicantFollowupuser').setValue(records[0].data.users.value);
    								form.findField('applicantNextFollowUpDate').setValue(new Date());
    								var priority = form.findField('applicantPriority');
    								if(!isNullOrEmpty(priority)) {
    									priority.store.load({
    										callback : function(r, operation,success) {
    											if (success) {
    												if(!isNullOrEmpty(records[0].data.enquiryPriority)){
    													if (records[0].data.enquiryPriority.id != null) {
    														priority.setValue(records[0].data.enquiryPriority.id);
    														if(form.isValid()) {
    															submitButton.setDisabled(false);
    														}
    													} 	
    												}
    											}
    										}
    									});
    								}
    								var followUpActivityType = form.findField('applicantFollowUpActivityType');
    		            			if(!isNullOrEmpty(followUpActivityType)) {
    		            				followUpActivityType.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
    		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
    		            								if(form.isValid()) {
															submitButton.setDisabled(false);
														}
    		            							}
    		            						}
    		            					}
    		            				});
    		            			}
    		            			
    		            			var reasonForFollowUp = form.findField('applicantReasonForFollowUp');
    		            			if(!isNullOrEmpty(reasonForFollowUp)) {
    		            				reasonForFollowUp.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)){
    		            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
    		            								if(form.isValid()) {
															submitButton.setDisabled(false);
														}
    		            							}
    		            						}
    		            					}
    		            				});
    		            			}
    		            			var followUpActivityStatus = form.findField('applicantFollowUpActivityStatus');
    		            			if(!isNullOrEmpty(followUpActivityStatus)) {
    		            				followUpActivityStatus.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
    		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
    		            							if(form.isValid()) {
														submitButton.setDisabled(false);
													}
    		            							}
    		            						}
    		            					}
    		            				});
    		            			}
    		            		}
    		            		if(form.isValid()) {
    								submitButton.setDisabled(false);
    							}
        					} else {
	        					if(form.isValid()) {
									submitButton.setDisabled(false);
								}
        					}
        				}
            		
					});
					grid.getSelectionModel().deselectAll();
					whetherNextFollowUp = form.findField('applicantWhetherNextFollowUp');
					whetherNextFollowUp.setValue(false);
					showSuccessMessage(getCommonTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
				},
				failure: function(f, action) {
					if(form.isValid()) {
						submitButton.setDisabled(false);
					}
				}
			});
		}
	},
	getIdValueJson: function(id, value, code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	}
});