/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Assign Application ID details.
 *    
 */
Ext.define('Academia.controller.admission.assignApplicationID.AssignApplicationIdController', {
	
    extend: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',

    alias: "widget.assignapplicationidcontroller",

    //models: [],

    stores: ['admission.assignApplicationID.AssignApplicantStore',
             	 'admission.admissionCommon.PaymentModeStore'],

    views: ['admission.assignApplicationID.AssignApplicationID',
            	 'admission.assignApplicationID.AssignApplicationIDGrid', 
            	 'admission.admissionCommon.MakePaymentForm', 
            	 'admission.admissionCommon.MakePaymentWindow'],

    refs: [{
        ref: 'assignApplicationIdGrid',
        selector: 'assignapplicationidgrid'
    }, {
        ref: 'assignApplicationMakePaymentWindow',
        selector: 'makepaymentwindow[itemId=assignApplicationMakePayment]'
    }],
    config: {
    	//ASSIGN_APPLICATION_ID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSIGN_APPLICATION_ID_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	'assignapplicationid':{
        		afterrender:function(structure){
        			 var grid=structure.down('assignapplicationidgrid');
         			   this.getGridHeaderFreezeAssignId(grid,structure,true);
        		}
        	},
        	
            'assignapplicationidgrid[itemId=assignApplicationIdGrid]': {
            	render:function(grid){
            		var me=this;
            		//This flag is set from Admission Application Form 
            		//If this flag is true then no need to load grid store
            		if(!grid.gridFilterWithTokenFlag){    
            			grid.getStore().load();
            		}            		
            	//	this.disableMoreActionPivileges(grid,this.getASSIGN_APPLICATION_ID_PERMISSIONS());
            		/*{
            			params:{
            				requestType:'TOKEN_GENERATED'            					
            			}
            		}
            		 * grid.getStore().on('beforeload', function(store, operation) {
            			var params= new Object();
            			params.requestType='TOKEN_GENERATED';                                    		                  
            			var searchCriteria = me.createSearchCriteria(grid);                                                	                            
                        store.proxy.params = params;
                    });*/
            	}                            	
            },
            'assignapplicationidgrid[itemId=assignApplicationIdGrid] button[itemId=btnFindApplication]': {
                click: function() {
                    var assignApplicationIdGrid = this.getAssignApplicationIdGrid();
                    if (assignApplicationIdGrid) {
                        
                    	var searchCriteria = this.createSearchCriteria(assignApplicationIdGrid);
                        searchCriteria.requestType=null;
                        
                        assignApplicationIdGrid.getStore().load({
                            params: searchCriteria
                        });
                    }
                }
            },
                       
            'assignapplicationidgrid[itemId=assignApplicationIdGrid] button[itemId=assignApplicationId]': {
                click: function(item, e, eOpts) {
                	var assignApplicationIdGrid = this.getAssignApplicationIdGrid();
                    this.assignApplicationId(this, assignApplicationIdGrid);
                }
            },
            

            'assignapplicationidgrid[itemId=assignApplicationIdGrid] button[itemId=makePayment]': {
                click: function(button, e, eOpts) {
                	 var grid = this.getAssignApplicationIdGrid();
                     var window = this.getAssignApplicationMakePaymentWindow();
                     this.showMakePaymentWindow(this, grid, window, 'assignApplicationMakePayment');
                }
            },

            'makepaymentwindow[itemId=assignApplicationMakePayment] button[itemId=btnCancelMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var window = this.getAssignApplicationMakePaymentWindow();
                    this.cancelMakePaymentWindow(window);
                }
            },

            'makepaymentwindow[itemId=assignApplicationMakePayment] button[itemId=btnSaveMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var grid = this.getAssignApplicationIdGrid();
                    var window = this.getAssignApplicationMakePaymentWindow();
                    this.saveMakePayment(this, grid, window);
                }
            },

            'assignapplicationidgrid[itemId=assignApplicationIdGrid]  textfield[itemId=txtTokenId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var grid = this.getAssignApplicationIdGrid();
                    this.hideShowSearchButton(searchField, newValue, grid);
                }
            },

            'assignapplicationidgrid[itemId=assignApplicationIdGrid]  textfield[itemId=txtReceiptNo]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var grid = this.getAssignApplicationIdGrid();
                    this.hideShowSearchButton(searchField, newValue, grid);
                }
            },            

            'assignapplicationidgrid[itemId=assignApplicationIdGrid] gridview': {
                expandbody: function(rowNode, record, expandRow, eOpts) {
                    var grid = this.getAssignApplicationIdGrid();
                    this.ExpandRowBody(this, grid, record, expandRow, 'applicantRowExpander');
                }
            }
        });
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getAssignApplicationIdGrid();
   		var findApplicationButton = grid.down("#btnFindApplication");//itemId of split button
   		var assignApplicationIdButton = grid.down('#assignApplicationId');
   		var makePaymentButton =  grid.down('#makePayment');
        	
   		findApplicationButton.setVisible(false);
   		assignApplicationIdButton.setVisible(false);
   		makePaymentButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'FINDAPPLICANT') {
           		if(!isNullOrEmpty(findApplicationButton)){
           			findApplicationButton.setVisible(true);//enable more action button
           		}        		
           	}else if(privilege === 'ASSIGNAPPLID'){
           		if(!isNullOrEmpty(assignApplicationIdButton)){
           			assignApplicationIdButton.setVisible(true);
           		}
           	}else if(privilege === 'MAKEPAYMENT'){
           		if(!isNullOrEmpty(makePaymentButton)){
           			makePaymentButton.setVisible(true);
           		}
           	}
       	});
       }
});
