/**
 * @author Abhishek.Bais
 * 
 */
Ext.define('Academia.controller.attendance.DailyAttendanceController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['personinfo.common.personalinfo.AttendanceReportProgramGroupStore','attendance.MultipleSessionValueStore',
		'attendance.facultyportal.AttendanceProgramStore','attendance.facultyportal.AttendanceCourseVariantStore','attendance.ConsolidateAttendanceGridStore'],
	views : ['attendance.DailyAttendanceStructureForFaculty','attendance.ProgramWiseDailyAttendanceSearch',
		'attendance.SessionWiseDailyAttendanceSearch','attendance.CourseWiseDailyAttendanceSearch','attendance.ConsolidateAttendanceGrid','attendance.AttendanceMainStructureForFaculty',
		'attendance.ConsolidateAttendanceCourseWiseGrid'],
	config: {
		FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES'),
	},
	refs : [{
    	ref: 'contentPanel',
    	selector: 'contentPanel' 
    },{
		ref: 'attendancemainstructureforfaculty',
		selector: 'attendancemainstructureforfaculty'
	},{
		ref: 'dailyattendancestructureforfaculty',
		selector: 'dailyattendancestructureforfaculty'
	},{
		ref: 'programwisedailyattendancesearch',
		selector: 'programwisedailyattendancesearch'
	},{
		ref: 'consolidateattendancegrid',
		selector: 'consolidateattendancegrid'
	},{
		ref: 'sessionwisedailyattendancesearch',
		selector: 'sessionwisedailyattendancesearch'
	},{
		ref: 'coursewisedailyattendancesearch',
		selector: 'coursewisedailyattendancesearch'
	},{
		ref :'consolidateattendancecoursewisegrid',
		selector : 'consolidateattendancecoursewisegrid[itemId=consolidateattendancecoursewisegrid]'
	}],
	init : function() {
		this.control({
			'attendancemainstructureforfaculty treepanel[itemId=attendanceReportTreePanelForFacultyItemId]':{
	        	itemclick : this.getOpenAttendanceReportStructureForFaculty
	        },
			'dailyattendancestructureforfaculty':{
				afterrender: function(structure){
					var grid = structure.down('consolidateattendancegrid');
					var $this=this;
					if(!isNullOrEmpty($this.getConsolidateattendancegrid())){
						$this.getConsolidateattendancegrid().getStore().removeAll(); 
						try{
							$this.getConsolidateattendancegrid().down('custompagingtoolbar').hide()
						}catch(e){
						}
					}
					var form =this.getDailyattendancestructureforfaculty();
					var attendanceTypeRadio=form.down('#dailyAttendanceTypeRadio');
					var permissionsMap = new Ext.util.HashMap();
					permissionsMap=this.getFACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES();
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

					var studentAttendanceType = [];
					var attendanceType=[];
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY) && attendanceTypess.data.COMPLETE_DAY.academyLocationId == academyLocationId) {
						attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
					} else {
						var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
						authenticationController.loadMultipleLangFilePerAL(this.getCurrentAcademyLocation());
						attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
						if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
							attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
						}
					}
					if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
						attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
					}
					if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
						attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
					}

					if(attendanceType.length > 0){
						studentAttendanceType=attendanceType.join();
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
					}


					//--setting initial values to false
					var tab2=false, tab3=false,tab4=false;

					//--initially setting all radio fields to true
					var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
					var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
					var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
					attendanceTypeRadio.items.items[0].setVisible(true);
					attendanceTypeRadio.items.items[1].setVisible(true);
					attendanceTypeRadio.items.items[2].setVisible(true);

					//--checking for the visible tabs
					if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
						tab2=true;
					}
					if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
						tab3=true;
					}
					if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
						tab4=true;
					}

					if(!tab2 && !tab3 && !tab4){
						tab2=true;
					}

					if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
						attendanceTypeRadio.setVisible(false);
					}
					else {
						attendanceTypeRadio.setVisible(true);
					}

					//-- setting values to true/false on the basis of visible tabs
					if(!tab2){
						attendanceTypeRadio.items.items[0].setVisible(false);
					}
					if(!tab3){
						attendanceTypeRadio.items.items[1].setVisible(false);
					}
					if(!tab4){
						attendanceTypeRadio.items.items[2].setVisible(false);
					}

					//-- setting radioGroup value on the basis of visible tabs
					setTimeout(function(){
						if(tab2){
							completeDayRadio.setValue(true);
						}
						else if(tab3){
							courseLevelRadio.setValue(true);
						}
						else if(tab4){
							multipleSessionRadio.setValue(true);
						}
					},300);
					Ext.defer(function() {
						var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
						$this.loadDailyAttendanceGrid(attendanceType);
					},1000);
				}
			},
			'dailyattendancestructureforfaculty radiogroup[itemId=dailyAttendanceTypeRadio]':{
				change : function(obj, record){
					var this$ = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var attendanceType = "";
					var facultyAttendanceType = "";
					var sessionNumber = "";
					var attendanceType = record.dailyAttendanceTypeWise;
					var facultyId=this.getCurrentlyLoggedInUser().id;
					var dailyattendancestructureforfaculty = obj.up('dailyattendancestructureforfaculty');
					var courseWise = dailyattendancestructureforfaculty.down('#courseWiseDailyAttendanceReportPanelItemId');
					var programWise = dailyattendancestructureforfaculty.down('#programWiseDailyAttendanceReportPanelItemId');
					var multipleSession = dailyattendancestructureforfaculty.down('#multipleSessionDailyAttendanceReportPanelItemId');
					
					if(!isNullOrEmpty(this$.getConsolidateattendancegrid())){
						this$.getConsolidateattendancegrid().getStore().removeAll(); 
						try{
							this$.getConsolidateattendancegrid().down('custompagingtoolbar').hide()
						}catch(e){
						}
					}
					
					if(attendanceType == 'COURSE_LEVEL'){
						courseWise.show();
						programWise.hide();
						multipleSession.hide();
						var coursewisedailyattendancesearch=this.getCoursewisedailyattendancesearch();

						var academicTerm = coursewisedailyattendancesearch.down('#academicTerm');
						var courseVariantId=coursewisedailyattendancesearch.down('#courseVariantId');
						var courseWiseStartDate=coursewisedailyattendancesearch.down('#courseWiseStartDate');
						var courseWiseEndDate=coursewisedailyattendancesearch.down('#courseWiseEndDate');
						
						var fromTime=coursewisedailyattendancesearch.down('#fromTime');
						var toTime=coursewisedailyattendancesearch.down('#toTime');


						courseWiseStartDate.reset();
						courseWiseEndDate.reset();
						academicTerm.reset();
						courseVariantId.reset();
						fromTime.reset();
						toTime.reset();

						courseWiseStartDate.setMinValue(false);
						courseWiseStartDate.setMaxValue(new Date());
						courseWiseEndDate.setMinValue(false);
						courseWiseEndDate.setMaxValue(new Date());
						fromTime.setMinValue(false);
						fromTime.setMaxValue(false);
						toTime.setMinValue(false);
						toTime.setMaxValue(false);

						var academicTermStore = academicTerm.getStore();
						var currentAcademicTermDefine=false; 
						academicTermStore.load({
							callback: function(record, operation, success) {
								if (success) {
									if(record.length>0){
										Ext.each(record, function(value) {
											if(value.get('whetherCurrentAcademicTerm')){
												coursewisedailyattendancesearch.down("#academicTerm").setValue(value.get('id'));
												currentAcademicTermDefine=true;
											}
										});
									}
								}
							}
						});
						setTimeout(function(){
							if(!currentAcademicTermDefine){
								var courseVariantStore = courseVariantId.getStore();
								courseVariantStore.getProxy().extraParams = {
									academyLocationIds: academyLocationId,
									facultyId: facultyId,
									isCurrentPeriod:false
								}
								courseVariantStore.load();
							}
						},500);


					}
					else if(attendanceType == 'COMPLETE_DAY'){
						courseWise.hide();
						programWise.show();
						multipleSession.hide();
						var programwisedailyattendancesearch=this.getProgramwisedailyattendancesearch();
						if(wheatherSchool){
							programwisedailyattendancesearch.down('#sectionItemId').setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'));
						}
						this.loadDailyAttendanceForm(programwisedailyattendancesearch,attendanceType);
						
					}
					else if(attendanceType == 'MULTIPLE_SESSION'){
						courseWise.hide();
						programWise.hide();
						multipleSession.show();
						var sessionwisedailyattendancesearch=this.getSessionwisedailyattendancesearch();
						if(wheatherSchool){
							sessionwisedailyattendancesearch.down('#sectionItemId').setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'));
						}
						this.loadDailyAttendanceForm(sessionwisedailyattendancesearch,attendanceType);
					}
				}
			},
			'programwisedailyattendancesearch customcombobox[itemId=academicTerm]' :{
				change : function(obj, record){
					var me = this;
					var form = obj.up('form');
					var academicTermId = obj.getValue();
					if(academicTermId > 0) {
						var programGroupId = form.down("#ProgramGroupItemId").getValue();
						this.academicTermProgramGroupChangeEvent(academicTermId,programGroupId,form);
					}
				}
			},
			'programwisedailyattendancesearch customcombobox[itemId=ProgramGroupItemId]' :{
				change : function(obj, record){
					var me = this;
					var form = obj.up('form');
					var programGroupId = obj.getValue();
					if(programGroupId > 0) {
						var academicTermId = form.down("#academicTerm").getValue();
						this.academicTermProgramGroupChangeEvent(academicTermId,programGroupId,form);
					}
				}
			},
			'programwisedailyattendancesearch button[itemId=searchBtn]':{
				click : function() {
					var $this = this;
					var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
					this.loadDailyAttendanceGrid(attendanceType);
				}
			
			},
			'programwisedailyattendancesearch button[itemId=resetBtn]':{
				click:function(obj, rec){var $this = this;
				var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
				var form=this.getProgramwisedailyattendancesearch();
				this.dailyAttendanceReportReset(form,attendanceType);}
			},
			'coursewisedailyattendancesearch customcombobox[itemId=academicTerm]' :{
				change : function(obj, record){
					var me = this;
					var form = obj.up('form');
					var academicTermId = obj.getValue();
					if(academicTermId > 0) {
						var courseVariantStore = form.down('#courseVariantId').getStore();
						var facultyId=this.getCurrentlyLoggedInUser().id;
						var academyLocationId = this.getCurrentAcademyLocation();
						courseVariantStore.getProxy().extraParams = {
							academyLocationIds: academyLocationId,
							facultyId: facultyId,
							isCurrentPeriod:false,
							academicTermId:academicTermId
						};
						courseVariantStore.load();
					}
					var topicsCombo = form.down('#courseTopicId');
					topicsCombo.reset();
					topicsCombo.setDisabled(true);
				}
			},
			'coursewisedailyattendancesearch customcombobox[itemId=courseVariantId]' :{
				select : function(obj, record){
					var me = this;
					var form = obj.up('form');
					var topicsCombo = form.down('#courseTopicId');
					var componentId= record[0].data.courseComponentId;
					var courseId= record[0].data.courseId;
					topicsCombo.reset();
					topicsCombo.setDisabled(false);
					var topicName = topicsCombo.getValue();
					var courseTopicStore = topicsCombo.getStore();
					courseTopicStore.getProxy().extraParams = {
						componentId : componentId,
						topicName : topicName,
						courseId : courseId
					};
					courseTopicStore.load();
				}
			},
			'coursewisedailyattendancesearch button[itemId=searchBtn]':{
				click : function() {
					var $this = this;
					var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
					this.loadDailyAttendanceGrid(attendanceType);
				}
			
			},
			'coursewisedailyattendancesearch button[itemId=resetBtn]':{
				click : function() {
					var $this = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId=this.getCurrentlyLoggedInUser().id;
					var coursewisedailyattendancesearch=this.getCoursewisedailyattendancesearch();
					var academicTerm = coursewisedailyattendancesearch.down('#academicTerm');
					var courseVariantId=coursewisedailyattendancesearch.down('#courseVariantId');
					var courseWiseStartDate=coursewisedailyattendancesearch.down('#courseWiseStartDate');
					var courseWiseEndDate=coursewisedailyattendancesearch.down('#courseWiseEndDate');
					var fromTime=coursewisedailyattendancesearch.down('#fromTime');
					var toTime=coursewisedailyattendancesearch.down('#toTime');
					
					coursewisedailyattendancesearch.down('#courseTopicId').reset();
					coursewisedailyattendancesearch.down('#courseTopicId').setDisabled(true);
					
					courseWiseStartDate.reset();
					courseWiseEndDate.reset();
					academicTerm.reset();
					courseVariantId.reset();
					fromTime.reset();
					toTime.reset();
					
					courseWiseStartDate.setMinValue(false);
					courseWiseStartDate.setMaxValue(new Date());
					courseWiseEndDate.setMinValue(false);
					courseWiseEndDate.setMaxValue(new Date());
					fromTime.setMinValue(false);
					fromTime.setMaxValue(false);
					toTime.setMinValue(false);
					toTime.setMaxValue(false);

					var academicTermStore = academicTerm.getStore();
					var currentAcademicTermDefine=false; 
					academicTermStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if(record.length>0){
									Ext.each(record, function(value) {
										if(value.get('whetherCurrentAcademicTerm')){
											coursewisedailyattendancesearch.down("#academicTerm").setValue(value.get('id'));
											currentAcademicTermDefine=true;
										}
									});
								}
							}
						}
					});
					setTimeout(function(){
						if(!currentAcademicTermDefine){
							var courseVariantStore = courseVariantId.getStore();
							courseVariantStore.getProxy().extraParams = {
								academyLocationIds: academyLocationId,
								facultyId: facultyId,
								isCurrentPeriod:false
							}
							courseVariantStore.load();
						}
					},500);
				}
			
			},
			'sessionwisedailyattendancesearch button[itemId=searchBtn]':{
				click : function() {
					var $this = this;
					var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
					this.loadDailyAttendanceGrid(attendanceType);
				}
			
			},
			'sessionwisedailyattendancesearch button[itemId=resetBtn]':{
				click:function(obj, rec){
					var $this = this;
					var attendanceType=$this.getDailyattendancestructureforfaculty().down('#dailyAttendanceTypeRadio').getValue().dailyAttendanceTypeWise;
					var form=this.getSessionwisedailyattendancesearch();
					this.dailyAttendanceReportReset(form,attendanceType);
				}
			},
			'sessionwisedailyattendancesearch customcombobox[itemId=academicTerm]' :{
				change : function(obj, record){
					var form = obj.up('form');
					var academicTermId = obj.getValue();
					if(academicTermId > 0) {
						var programGroupId = form.down("#ProgramGroupItemId").getValue();
						this.academicTermProgramGroupChangeEvent(academicTermId,programGroupId,form);
					}
				}
			},
			'sessionwisedailyattendancesearch customcombobox[itemId=ProgramGroupItemId]' :{
				change : function(obj, record){
					var form = obj.up('form');
					var programGroupId = obj.getValue();
					if(programGroupId > 0) {
						var academicTermId = form.down("#academicTerm").getValue();
						this.academicTermProgramGroupChangeEvent(academicTermId,programGroupId,form);
					}
				}
			},
			'tabpanel[itemId=tabpanelIdsForFaculty] tab':{
            	activate: function(){
                   	var  contentPanelMain = this.getContentPanel().getActiveTab();
                    contentPanelMain.scrollBy(0,1);
                    contentPanelMain.scrollBy(0,-1);
                    }
			}
		});
	},
    academicTermProgramGroupChangeEvent:function(academicTermId,programGroupId,form){
		var me = this;
		 var sectionIdField = form.down("#sectionItemId");
		 var programGroupId = form.down("#ProgramGroupItemId").getValue();
		 var facultyId=this.getCurrentlyLoggedInUser().id;
		 var academyLocationIds=me.getCurrentAcademyLocation();
		 var alinfomodel = Academia.model.authentication.ALInfoModel;
		 var wheatherSchool = alinfomodel.get('wheatherSchool');
		 sectionIdField.reset();
		 var sectionIdFieldStore = sectionIdField.getStore();
		 sectionIdFieldStore.getProxy().extraParams = {
    		   academyLocationIds: academyLocationIds,
    		   facultyId: facultyId,
    		   onlyCurrentRecords:false,
    		   academicTermId:academicTermId,
    		   programGroupId:programGroupId,
    		   wheatherSchool:wheatherSchool
    	   };
		 sectionIdFieldStore.load();
	},
	dailyAttendanceReportReset:function(form,attendanceType){
		var academyLocationId = this.getCurrentAcademyLocation();
		var facultyId=this.getCurrentlyLoggedInUser().id;
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		var academicTermField = form.down("#academicTerm");
		var programGroupField = form.down("#ProgramGroupItemId");
		var sectionField = form.down("#sectionItemId");
		var startDateField = form.down("#programWiseStartDate");
		var endDateField = form.down("#programWiseEndDate");
		
		academicTermField.reset();
		programGroupField.reset();
		sectionField.reset();
		startDateField.reset();
		endDateField.reset();
		
		startDateField.setMinValue(false);
		startDateField.setMaxValue(new Date());
		endDateField.setMinValue(false);
		endDateField.setMaxValue(new Date());

		var academicTermStore = academicTermField.getStore();
		var currentAcademicTermDefine=false; 
		academicTermStore.load({
			callback: function(record, operation, success) {
				if (success) {
					if(record.length>0){
						Ext.each(record, function(value) {
							if(value.get('whetherCurrentAcademicTerm')){
								form.down("#academicTerm").setValue(value.get('id'));
								currentAcademicTermDefine=true;
							}
						});
					}
				}
			}
		});
		setTimeout(function(){
		if(!currentAcademicTermDefine){
			var sectionIdFieldStore = sectionField.getStore();
			 sectionIdFieldStore.getProxy().extraParams = {
	    		   academyLocationIds: academyLocationId,
	    		   facultyId: facultyId,
	    		   onlyCurrentRecords:false,
	    		   wheatherSchool:wheatherSchool
	    	   };
			 sectionIdFieldStore.load();
		}
		},500);
		if(attendanceType=='MULTIPLE_SESSION'){
			var sessionItemId=form.down('#sessionItemId');
			sessionItemId.reset();
			var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
			var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
			var storeArray = [];
			var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
			multipleSessionStore.getProxy().extraParams = {
				type:"multipleSession"
			};
			multipleSessionStore.load({
				callback: function(records, operation, success) {
					if (success) {
						for (s=1;s<=sessionNumber;s++) {
							if(multipleSessionStore.find("code",s)>=0){
								storeArray.push({
									'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
									'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
								});
							} else {
								storeArray.push({'val':s,
									'code': s});
							}
						}
					}
					var store1 = Ext.create('Ext.data.Store', {
						fields: ['val','code'],
						data : storeArray
					});
					var l = Ext.ComponentQuery.query('[itemId=sessionItemId]').length-1;
					Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].bindStore(store1);
					if(storeArray.length>0)
					{
						Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].setValue(1);
					}
				}
			});
		
		}
	},
	loadDailyAttendanceForm:function(form,attendanceType){
		var academyLocationId = this.getCurrentAcademyLocation();
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		var facultyId=this.getCurrentlyLoggedInUser().id;
		var academicTerm = form.down('#academicTerm');
		var programGroup=form.down('#ProgramGroupItemId');
		var programWiseStartDate=form.down('#programWiseStartDate');
		var programWiseEndDate=form.down('#programWiseEndDate');
		var sectionIdField=form.down('#sectionItemId');
		programGroup.reset();
		programWiseStartDate.reset();
		programWiseEndDate.reset();
		academicTerm.reset();
		sectionIdField.reset();
		programWiseStartDate.setMinValue(false);
		programWiseStartDate.setMaxValue(new Date());
		programWiseEndDate.setMinValue(false);
		programWiseEndDate.setMaxValue(new Date());
		var academicTermStore = academicTerm.getStore();
		var currentAcademicTermDefine=false; 
		academicTermStore.load({
			callback: function(record, operation, success) {
				if (success) {
					if(record.length>0){
						Ext.each(record, function(value) {
							if(value.get('whetherCurrentAcademicTerm')){
								form.down("#academicTerm").setValue(value.get('id'));
								currentAcademicTermDefine=true;
							}
						});
					}
				}
			}
		});
		setTimeout(function(){
		if(!currentAcademicTermDefine){
			var sectionIdFieldStore = sectionIdField.getStore();
			 sectionIdFieldStore.getProxy().extraParams = {
	    		   academyLocationIds: academyLocationId,
	    		   facultyId: facultyId,
	    		   onlyCurrentRecords:false,
	    		   wheatherSchool:wheatherSchool
	    	   };
			 sectionIdFieldStore.load();
		}
		},500);
		var proramGroupStore=programGroup.getStore();
		proramGroupStore.getProxy().extraParams = {
			academyLocationId : academyLocationId,
			facultyId:facultyId
			
		};
		if(attendanceType=='MULTIPLE_SESSION'){
			var sessionItemId=form.down('#sessionItemId');
			sessionItemId.reset();
			var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
			var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
			var storeArray = [];
			var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
			multipleSessionStore.getProxy().extraParams = {
				type:"multipleSession"
			};
			multipleSessionStore.load({
				callback: function(records, operation, success) {
					if (success) {
						for (s=1;s<=sessionNumber;s++) {
							if(multipleSessionStore.find("code",s)>=0){
								storeArray.push({
									'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
									'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
								});
							} else {
								storeArray.push({'val':s,
									'code': s});
							}
						}
					}
					var store1 = Ext.create('Ext.data.Store', {
						fields: ['val','code'],
						data : storeArray
					});
					var l = Ext.ComponentQuery.query('[itemId=sessionItemId]').length-1;
					Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].bindStore(store1);
					if(storeArray.length>0)
					{
						Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].setValue(1);
					}
				}
			});
		}
	},
	loadDailyAttendanceGrid:function(record){
		var this$=this;
		var attendanceType = "";
		var academyLocationId = this.getCurrentAcademyLocation();
		var attendanceType=record;
		var faculty;
		
		if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
			this.getConsolidateattendancegrid().setVisible(false)
			var grid = this.getConsolidateattendancecoursewisegrid();
			grid.setVisible(true);
			var store = grid.getStore();
			if(this.getCurrentLoggedPortalId() == 2) {
				faculty=this.getCurrentlyLoggedInUser().id;
				grid.columns[3].setVisible(false);
			}
			var form = this.getCoursewisedailyattendancesearch().getForm();
			var values = form.getValues();
			var academicTermId = values.academicTerm;
			var courseVariantId = values.courseVariant;
			var startDate = values.courseWiseStartDate;
			var endDate = values.courseWiseEndDate;
			var fromTime = values.fromTime;
			var toTime = values.toTime;
			var courseTopicId = values.courseTopic;

			var submitURL=SERVERURL.GET_COURSE_LEVEL_CONSOLIDATE_ATTENDANCE_REPORT1;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				academicTermId:academicTermId,
				courseVariantId:courseVariantId,
				academyLocationId:academyLocationId,
				facultyId:faculty,
				startDate:startDate,
				endDate:endDate,
				fromTime:fromTime,
				toTime:toTime,
				isCurrentPeriod:false ,
				courseTopicId: courseTopicId
			};
			Ext.getBody().unmask();
			this.resetPageSetting(store);
			store.load();
		}
		else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION')
		{	
			this.getConsolidateattendancecoursewisegrid().setVisible(false);
			var grid = this.getConsolidateattendancegrid();
			grid.setVisible(true);
			var store = grid.getStore();
			if(this.getCurrentLoggedPortalId() == 2) {
				faculty=this.getCurrentlyLoggedInUser().id;
				grid.columns[5].setVisible(false);
			}
			var form = this.getSessionwisedailyattendancesearch().getForm();
			var values = form.getValues();
			var programGroupId = values.programGroup;
			var sectionId = values.section;
			var startDate = values.programWiseStartDate;
			var endDate = values.programWiseEndDate;
			var academicTermId = values.academicTerm;
			var sessionNo = values.sessionNo;
			
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				grid.columns[3].setVisible(false);
			}else{
				grid.columns[3].setVisible(true);
			}	
			grid.columns[7].setVisible(true);

			var submitURL=SERVERURL.GET_COMPLETE_DAY_CONSOLIDATE_ATTENDANCE_REPORT;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				sectionId:sectionId,
				academyLocationId:academyLocationId,
				facultyId:faculty,
				startDate:startDate,
				endDate:endDate,
				sessionNo:sessionNo,
				attendanceType:attendanceType,
				programGroupId :programGroupId,
				academicTermId:academicTermId,
				isCurrentPeriod:false 
			};
			Ext.getBody().unmask();
			this.resetPageSetting(store);
			store.load();

		}
		else{
			this.getConsolidateattendancecoursewisegrid().setVisible(false);
			var grid = this.getConsolidateattendancegrid();
			grid.setVisible(true);
			var store = grid.getStore();
			if(this.getCurrentLoggedPortalId() == 2) {
				faculty=this.getCurrentlyLoggedInUser().id;
				grid.columns[5].setVisible(false);
			}
			var form = this.getProgramwisedailyattendancesearch().getForm();
			var values = form.getValues();
			var programGroupId = values.programGroup;
			var sectionId = values.section;
			var startDate = values.programWiseStartDate;
			var endDate = values.programWiseEndDate;
			var academicTermId = values.academicTerm;
			
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				grid.columns[3].setVisible(false);
			}else{
				grid.columns[3].setVisible(true);
			}	
			grid.columns[7].setVisible(false);

			var submitURL=SERVERURL.GET_COMPLETE_DAY_CONSOLIDATE_ATTENDANCE_REPORT;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				sectionId:sectionId,
				academyLocationId:academyLocationId,
				facultyId:faculty,
				startDate:startDate,
				endDate:endDate,
				attendanceType:attendanceType,
				programGroupId :programGroupId,
				academicTermId:academicTermId,
				isCurrentPeriod:false 
			};
			Ext.getBody().unmask();
			this.resetPageSetting(store);
			store.load();
		}
		var  contentPanelMain = this$.getContentPanel().getActiveTab();
		contentPanelMain.scrollBy(0,1);
		contentPanelMain.scrollBy(0,-1);
	},
    getOpenAttendanceReportStructureForFaculty : function(treePanel, record, item,index, e, eOpts){
 	   var $this = this;
 	   var containpanel = $this.getAttendancemainstructureforfaculty();
 	   var treePanel = containpanel.down('#attendanceReportTreePanelForFacultyItemId');
 	   var tabDetail = record.data;
 	   var structure = Ext.widget(tabDetail.reportXtype);
 	   var tabstructure = containpanel.down('#tabpanelIdsForFaculty');

 	   if (!isNullOrEmpty(tabDetail.text)
 			   && !isNullOrEmpty(tabDetail.reportXtype)
 			   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
 		   treePanel.toggleCollapse();
 		   openTab(tabstructure, tabDetail.text,structure);
 		   treePanel.getSelectionModel().deselectAll();
 	   }
    },
});