/**
 * @author Akshay Sharma
 * 
 */
Ext.define('Academia.controller.attendance.EditAttendanceController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['attendance.EditStudentAttendanceListModel','attendance.AttendanceCountModel'],
	stores : ['attendance.EditStudentAttendanceListStore','attendance.AttendanceCountStore',
	          'attendance.AttendanceMarkingTypeStore'],
	views : ['attendance.EditAttendanceRecordStructure','attendance.EditStudentAttendance',
	         'attendance.EditStudentAttendanceGrid','attendance.EditStudentAttendanceCountGrid'],	
	         config: {
	        	 //ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES') 
	         },
	         refs : [{
	        	 ref: 'consolidateattendancegrid',
	        	 selector: 'consolidateattendancegrid'
	         },{
	        	 ref: 'contentPanel',
	        	 selector: 'contentPanel'
	         },{
	        	 ref :'editstudentattendance',
	        	 selector : 'editstudentattendance'
	         },{
	        	 ref :'editattendancerecordstructure',
	        	 selector : 'editattendancerecordstructure'
	         },{
	        	 ref :'editstudentattendancegrid',
	        	 selector : 'editstudentattendancegrid'
	         },{
	        	 ref :'editstudentattendancecountgrid',
	        	 selector : 'editstudentattendancecountgrid'
	         }],
	         init : function() {
	        	 this.control({
	        		 'editstudentattendancegrid checkcolumn':{
	        			 checkchange:function(obj, rowIndex, checked, eOpts ){
	        				 var this$ = this;
	        				 var grid = this$.getEditstudentattendancegrid();
	        				 var store = grid.down('grid').getStore();
	        				 var models = store.getRange();
	        				 if(checked){
	        					 if(obj.text==getProgramandcourseTranslation('ABSENT')){
	        						 for(var i =0; i<store.data.length;i++){
	        							 if(rowIndex==i){
	        								 models[rowIndex].set('present', false);
	        								 Ext.defer(function() {
	        										if(models[rowIndex].data.absent == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
	        									 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        									 var indexArr = [];
	        						        	 var statusCount = [];
	        						        	 for(var i =0; i<store.data.length;i++){
	        						        		 if(models[i].data.present){
	        						        			 preCount++;
	        						        			 presentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.absent){
	        						        			 absCount++;
	        						        			 absentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.attendanceStatus){
	        						        			 other++;
	        						        			 indexArr.push(i);
	        						        		 }
	        						        	 }
	        						        	 statusCount.push({
	        						        		 "Present":presentSummaryCount,
	        						        		 "Absent":absentSummaryCount
	        						        	 });
	        						        	 var statusStore = this$.getStore('attendance.AttendanceMarkingTypeStore');
	        						        	 statusStore.load({
	        						        		 callback: function(records, operation, success) {
	        						        			 if (success) {
	        						        				 for(var i=0; i< indexArr.length;i++){
	        						        					 for(var j=0; j< records.length;j++){
	        						        						 if(records[j].data.value == models[indexArr[i]].data.attendanceStatus){
	        						        							 if(records[j].data.code == 'PRESENT'){
	        						        								 var PresenCount = statusCount[0].Present+1;
	        						        								 var AbsentCount = statusCount[0].Absent;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }if(records[j].data.code == 'ABSENT'){
	        						        								 var PresenCount = statusCount[0].Present;
	        						        								 var AbsentCount = statusCount[0].Absent+1;
	        						        								 statusCount.pop();
	        					        									 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }
	        						        						 }
	        						        					 }
	        						        				 }
	        						        				 var gridCount = this$.getEditstudentattendancecountgrid();
	        						        	        	 var  data = {
	        						        	        			 totalStudent:store.data.length,
	        						        	        			 totalPresent:preCount,
	        						        	        			 totalAbsent:absCount,
	        						        	        			 otherCount:other,
	        						        	        			 presentPercent:parseFloat((statusCount[0].Present/store.data.length)*100).toFixed(2)+"%",
	        						        	        			 absentPercent:parseFloat((statusCount[0].Absent/store.data.length)*100).toFixed(2)+"%",
	        						        	        	 };
	        						        	        	 var gridStore =  gridCount.getStore();
	        						        	        	 gridStore.removeAll();
	        						        	        	 gridStore.loadRawData(data, true);
	        						        			 }
	        						        		 }
	        						        	 });
	        								 }, 50, this);
	        								 break;
	        							 }
	        						 }
	        					 }
	        					 if(obj.text==getProgramandcourseTranslation('PRESENT')){
	        						 for(var i =0; i<store.data.length;i++){
	        							 if(rowIndex==i){
	        								 models[rowIndex].set('absent', false);
	        								 Ext.defer(function() {
	        									 if(models[rowIndex].data.present == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
	        									 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        									 var indexArr = [];
	        						        	 var statusCount = [];
	        						        	 for(var i =0; i<store.data.length;i++){
	        						        		 if(models[i].data.present){
	        						        			 preCount++;
	        						        			 presentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.absent){
	        						        			 absCount++;
	        						        			 absentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.attendanceStatus){
	        						        			 other++;
	        						        			 indexArr.push(i);
	        						        		 }
	        						        	 }
	        						        	 statusCount.push({
	        						        		 "Present":presentSummaryCount,
	        						        		 "Absent":absentSummaryCount
	        						        	 });
	        						        	 var statusStore = this$.getStore('attendance.AttendanceMarkingTypeStore');
	        						        	 statusStore.load({
	        						        		 callback: function(records, operation, success) {
	        						        			 if (success) {
	        						        				 for(var i=0; i< indexArr.length;i++){
	        						        					 for(var j=0; j< records.length;j++){
	        						        						 if(records[j].data.value == models[indexArr[i]].data.attendanceStatus){
	        						        							 if(records[j].data.code == 'PRESENT'){
	        						        								 var PresenCount = statusCount[0].Present+1;
	        						        								 var AbsentCount = statusCount[0].Absent;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }if(records[j].data.code == 'ABSENT'){
	        						        								 var PresenCount = statusCount[0].Present;
	        						        								 var AbsentCount = statusCount[0].Absent+1;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }
	        						        						 }
	        						        					 }
	        						        				 }
	        						        				 var gridCount = this$.getEditstudentattendancecountgrid();
	        						        	        	 var  data = {
	        						        	        			 totalStudent:store.data.length,
	        						        	        			 totalPresent:preCount,
	        						        	        			 totalAbsent:absCount,
	        						        	        			 otherCount:other,
	        						        	        			 presentPercent:parseFloat((statusCount[0].Present/store.data.length)*100).toFixed(2)+"%",
	        						        	        			 absentPercent:parseFloat((statusCount[0].Absent/store.data.length)*100).toFixed(2)+"%",
	        						        	        	 };
	        						        	        	 var gridStore =  gridCount.getStore();
	        						        	        	 gridStore.removeAll();
	        						        	        	 gridStore.loadRawData(data, true);
	        						        			 }
	        						        		 }
	        						        	 });
	        								 }, 50, this);
	        								 break;
	        							 }
	        						 }
	        					 }
	        				 }else{
	        					 if(obj.text==getProgramandcourseTranslation('ABSENT')){
	        						 for(var i =0; i<store.data.length;i++){
	        							 if(rowIndex==i){
	        								 models[rowIndex].set('present', true);
	        								 Ext.defer(function() {
	        									 if(models[rowIndex].data.absent == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
	        									 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        									 var indexArr = [];
	        						        	 var statusCount = [];
	        						        	 for(var i =0; i<store.data.length;i++){
	        						        		 if(models[i].data.present){
	        						        			 preCount++;
	        						        			 presentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.absent){
	        						        			 absCount++;
	        						        			 absentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.attendanceStatus){
	        						        			 other++;
	        						        			 indexArr.push(i);
	        						        		 }
	        						        	 }
	        						        	 statusCount.push({
	        						        		 "Present":presentSummaryCount,
	        						        		 "Absent":absentSummaryCount
	        						        	 });
	        						        	 var statusStore = this$.getStore('attendance.AttendanceMarkingTypeStore');
	        						        	 statusStore.load({
	        						        		 callback: function(records, operation, success) {
	        						        			 if (success) {
	        						        				 for(var i=0; i< indexArr.length;i++){
	        						        					 for(var j=0; j< records.length;j++){
	        						        						 if(records[j].data.value == models[indexArr[i]].data.attendanceStatus){
	        						        							 if(records[j].data.code == 'PRESENT'){
	        						        								 var PresenCount = statusCount[0].Present+1;
	        						        								 var AbsentCount = statusCount[0].Absent;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }if(records[j].data.code == 'ABSENT'){
	        						        								 var PresenCount = statusCount[0].Present;
	        						        								 var AbsentCount = statusCount[0].Absent+1;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }
	        						        						 }
	        						        					 }
	        						        				 }
	        						        				 var gridCount = this$.getEditstudentattendancecountgrid();
	        						        	        	 var  data = {
	        						        	        			 totalStudent:store.data.length,
	        						        	        			 totalPresent:preCount,
	        						        	        			 totalAbsent:absCount,
	        						        	        			 otherCount:other,
	        						        	        			 presentPercent:parseFloat((statusCount[0].Present/store.data.length)*100).toFixed(2)+"%",
	        						        	        			 absentPercent:parseFloat((statusCount[0].Absent/store.data.length)*100).toFixed(2)+"%",
	        						        	        	 };
	        						        	        	 var gridStore =  gridCount.getStore();
	        						        	        	 gridStore.removeAll();
	        						        	        	 gridStore.loadRawData(data, true);
	        						        			 }
	        						        		 }
	        						        	 });
	        								 }, 50, this);
	        								 break;
	        							 }
	        						 }
	        					 }
	        					 if(obj.text==getProgramandcourseTranslation('PRESENT')){
	        						 for(var i =0; i<store.data.length;i++){
	        							 if(rowIndex==i){
	        								 models[rowIndex].set('absent', true);
	        								 Ext.defer(function() {
	        									 if(models[rowIndex].data.present == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
	        									 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        									 var indexArr = [];
	        						        	 var statusCount = [];
	        						        	 for(var i =0; i<store.data.length;i++){
	        						        		 if(models[i].data.present){
	        						        			 preCount++;
	        						        			 presentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.absent){
	        						        			 absCount++;
	        						        			 absentSummaryCount++;
	        						        		 }
	        						        		 if(models[i].data.attendanceStatus){
	        						        			 other++;
	        						        			 indexArr.push(i);
	        						        		 }
	        						        	 }
	        						        	 statusCount.push({
	        						        		 "Present":presentSummaryCount,
	        						        		 "Absent":absentSummaryCount
	        						        	 });
	        						        	 var statusStore = this$.getStore('attendance.AttendanceMarkingTypeStore');
	        						        	 statusStore.load({
	        						        		 callback: function(records, operation, success) {
	        						        			 if (success) {
	        						        				 for(var i=0; i< indexArr.length;i++){
	        						        					 for(var j=0; j< records.length;j++){
	        						        						 if(records[j].data.value == models[indexArr[i]].data.attendanceStatus){
	        						        							 if(records[j].data.code == 'PRESENT'){
	        						        								 var PresenCount = statusCount[0].Present+1;
	        						        								 var AbsentCount = statusCount[0].Absent;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }if(records[j].data.code == 'ABSENT'){
	        						        								 var PresenCount = statusCount[0].Present;
	        						        								 var AbsentCount = statusCount[0].Absent+1;
	        						        								 statusCount.pop();
	        						        								 statusCount.push({
	        						        					        		 "Present":PresenCount,
	        						        					        		 "Absent":AbsentCount
	        						        					        	 });
	        						        							 }
	        						        						 }
	        						        					 }
	        						        				 }
	        						        				 var gridCount = this$.getEditstudentattendancecountgrid();
	        						        	        	 var  data = {
	        						        	        			 totalStudent:store.data.length,
	        						        	        			 totalPresent:preCount,
	        						        	        			 totalAbsent:absCount,
	        						        	        			 otherCount:other,
	        						        	        			 presentPercent:parseFloat((statusCount[0].Present/store.data.length)*100).toFixed(2)+"%",
	        						        	        			 absentPercent:parseFloat((statusCount[0].Absent/store.data.length)*100).toFixed(2)+"%",
	        						        	        	 };
	        						        	        	 var gridStore =  gridCount.getStore();
	        						        	        	 gridStore.removeAll();
	        						        	        	 gridStore.loadRawData(data, true);
	        						        			 }
	        						        		 }
	        						        	 });
	        								 }, 50, this);
	        								 break;
	        							 }
	        						 }
	        					 }
	        				 }
	        			 }
	        		 },
	        		 'editstudentattendancegrid radiogroup[itemId=markOnlyAttendance_Id]':{
	        			 change:function(obj,record){
	        				 this.changeStatus(obj,record);
	        			 }
	        		 },
	        		 'editstudentattendancegrid customcombobox[itemId=editOtherStatusId]':{
	        			   select:function(obj,record){
	        				   this.changeOtherStatusOnEdit(obj,record);
	        			   }
	        		   },
	        		 'editattendancerecordstructure button[itemId=submitAttendanceBtn]' : {
	        			 click : function(btn){
	        				   var me = this;
	        				   btn.setDisabled(true);
	        				   setTimeout(function(){
		        				   me.editStudentAttendance(btn);
	        				   },1000);
	        			   }
	        		 },
	        	 });
	         },
	         loadEditAttendanceSummary:function() {
	        	 var this$ = this;
	        	 var grid = this$.getEditstudentattendancegrid();
	        	 var store = grid.down('grid').getStore();
	        	 var models = store.getRange();

	        	 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        	 var indexArr = [];
	        	 var statusCount = [];
	        	 for(var i =0; i<store.data.length;i++){
	        		 if(models[i].data.present){
	        			 preCount++;
	        			 presentSummaryCount++;
	        		 }
	        		 if(models[i].data.absent){
	        			 absCount++;
	        			 absentSummaryCount++;
	        		 }
	        		 if(models[i].data.attendanceStatus){
	        			 other++;
	        			 indexArr.push(i);
	        		 }
	        	 }
	        	 statusCount.push({
	        		 "Present":presentSummaryCount,
	        		 "Absent":absentSummaryCount
	        	 });
	        	 var statusStore = this$.getStore('attendance.AttendanceMarkingTypeStore');
	        	 statusStore.load({
	        		 callback: function(records, operation, success) {
	        			 if (success) {
	        				 for(var i=0; i< indexArr.length;i++){
	        					 for(var j=0; j< records.length;j++){
	        						 if(records[j].data.value == models[indexArr[i]].data.attendanceStatus){
	        							 if(records[j].data.code == 'PRESENT'){
	        								 var PresenCount = statusCount[0].Present+1;
	        								 var AbsentCount = statusCount[0].Absent;
	        								 statusCount.pop();
	        								 statusCount.push({
	        					        		 "Present":PresenCount,
	        					        		 "Absent":AbsentCount
	        					        	 });
	        							 }if(records[j].data.code == 'ABSENT'){
	        								 var PresenCount = statusCount[0].Present;
	        								 var AbsentCount = statusCount[0].Absent+1;
	        								 statusCount.pop();
	        								 statusCount.push({
	        					        		 "Present":PresenCount,
	        					        		 "Absent":AbsentCount
	        					        	 });
	        							 }
	        						 }
	        					 }
	        				 }
	        				 var gridCount = this$.getEditstudentattendancecountgrid();
	        	        	 var  data = {
	        	        			 totalStudent:store.data.length,
	        	        			 totalPresent:preCount,
	        	        			 totalAbsent:absCount,
	        	        			 otherCount:other,
	        	        			 presentPercent:parseFloat((statusCount[0].Present/store.data.length)*100).toFixed(2)+"%",
	        	        			 absentPercent:parseFloat((statusCount[0].Absent/store.data.length)*100).toFixed(2)+"%",
	        	        	 };
	        	        	 var gridStore =  gridCount.getStore();
	        	        	 gridStore.removeAll();
	        	        	 gridStore.loadRawData(data, true);
	        			 }
	        		 }
	        	 });
	         },
	         editAttendanceRadioFields:function(){
	        	 var $this =this;
	        	 Ext.Ajax.request({
	        		 type : 'rest',
	        		 url :SERVERURL.STUDENT_ATTENDANCE_MARKING_TYPE,
	        		 method : 'GET',
	        		 success : function(form, action) {
	        			 var attendanceType = Ext.JSON.decode(form.responseText);
	        			 var varattendanceTypeRadio = $this.getEditstudentattendancegrid().down('#markOnlyAttendance_Id');
	        			 for(var i=0, n=attendanceType.length; i<n; i++ ){

	        				 var attendanceName;
	        				 if(attendanceType[i].value == 'Present'){
	        					 attendanceName = getProgramandcourseTranslation('PRESENT');
	        				 }else if(attendanceType[i].value == 'Absent'){
	        					 attendanceName = getProgramandcourseTranslation('ABSENT');
	        				 }
	        				 if(i<=2){
	        					 if(i==0){
	        						 varattendanceTypeRadio.add({
	        							 style:{
	        								 color:'green !important',
	        							 },
	        							 boxLabel: getProgramandcourseTranslation('MARK_ALL') + attendanceName,
	        							 name:'attendance',
	        							 inputValue: attendanceType[i].value
	        						 });
	        					 }else if(i==1){
	        						 varattendanceTypeRadio.add({
	        							 style:{
	        								 color:'red !important',
	        							 },
	        							 boxLabel: getProgramandcourseTranslation('MARK_ALL') + attendanceName,
	        							 name:'attendance',
	        							 inputValue: attendanceType[i].value
	        						 });
	        					 } else {
	        						  varattendanceTypeRadio.add({
			        					  style:{
			        							 color:'orange !important',
			        						 },
			        					  boxLabel: getProgramandcourseTranslation('MARK_ALL_OTHER'),
			        					  name:'attendance'
			        				  });
	        					  }
	        				 }
	        			 }
	        			 var forms = $this.getEditstudentattendancegrid();
	        			 forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        			 forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        			 forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        		 }
	        	 });
	         },
	         changeStatus:function(obj,record){
	        	 var attendanceStatus = record.attendance;
	        	 var grid = this.getEditstudentattendancegrid().down('grid');
	        	 var store = grid.getStore();

	        	 var present=false,absent=false,attStatus=null;
	        	 var prePercent='0%', absPercent='0%';
	        	 var abs=0,pre=0,oth=0;
	        	 this.getEditstudentattendancegrid().down('#editOtherStatusId').clearValue();
	        	 this.getEditstudentattendancegrid().down('#editOtherStatusId').setVisible(false);
	        	 if (attendanceStatus == 'PRESENT' || attendanceStatus == 'Present') {
	        		 present = true;
	        		 absent = false;
	        		 attStatus = null;
	        		 pre=store.data.length;
	        		 prePercent='100%';
	        	 } else if (attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent') {
	        		 attStatus = null;
	        		 present = false;
	        		 absent = true;
	        		 abs=store.data.length;
	        		 absPercent='100%';
	        	 } else {
	        		   this.getEditstudentattendancegrid().down('#editOtherStatusId').setVisible(true);
	        		   var store = this.getStore('attendance.AttendanceMarkingTypeStore');
	                	 store.on('load', function(){
	                			 for(var i=0; i< store.data.items.length;i++){
		                			 if(store.data.items[i].data.value == 'Present'){
		                					 store.removeAt(i);
		                			 } 
		                			 if(store.data.items[i].data.value == 'Absent'){
		                					 store.removeAt(i);
		                			 }
		                		 }
	                	});
	        	   }

	        	 store.suspendEvents();   
	        	 store.each(function(rec) {
	        		 rec.set('present', present);
	        		 rec.set('absent', absent);
	        		 rec.set('attendanceStatus', attStatus);
	        	 });
	        	 store.resumeEvents();
	        	 grid.getView().refresh();

	        	 var gridCount = this.getEditstudentattendancecountgrid();
	        	 var data = {
	        			 totalStudent:store.data.length,
	        			 totalPresent:pre,
	        			 totalAbsent:abs,
	        			 otherCount:oth,
	        			 presentPercent:prePercent,
	        			 absentPercent:absPercent,
	        	 };
	        	 var gridStore =  gridCount.getStore();
	        	 if(store.data.length!=0){
	        		 gridStore.removeAll();
	        		 gridStore.loadRawData(data, true);
	        	 }
	         },

	         editStudentAttendance:function(btn){
	        	 var this$ = this;
	        	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	 btn.setDisabled(true);
	        	 var $this = this;
	        	 var form = $this.getEditstudentattendance();
	        	 var editForm=form.getForm();
	        	 var attendanceType = editForm.findField('attendanceType').getValue();
	        	 var academyLocationId = this.getCurrentAcademyLocation();
	        	 var studentAttendance =new Academia.model.attendance.StudentAttendance();
	        	 /*
	        	  * save course level attendance for student. 
	        	  */
	        	 if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	        		 var attendanceRecords = this$.getEditstudentattendancegrid().temp;
	        		 var store = $this.getStore('attendance.EditStudentAttendanceListStore');
	        		 var models = store.getRange();
	        		 var studentCourseAttendanceDetails =[]; 
	        		 for(var i=0;i<store.data.length;i++){
	        			 if(!store.data.items[i].data.attendanceStatus){
	        				 if(models[i].data.present){
	        					 studentCourseAttendanceDetails.push({
	        						 "admissionId":store.data.items[i].data.admissionId,
	        						 "attendanceStatus": 'PRESENT',
	        						 "attendanceId":attendanceRecords[0].attendanceId,
	        						 "id":store.data.items[i].data.attendanceDetailId,
			        				  "attendanceComment" : store.data.items[i].data.comment,
			        				  "attendanceMarkingType" : this.getIdValueJson(1)
	        					 }); 
	        				 }else{
	        					 studentCourseAttendanceDetails.push({
	        						 "admissionId":store.data.items[i].data.admissionId,
	        						 "attendanceStatus": 'ABSENT',
	        						 "attendanceId":attendanceRecords[0].attendanceId,
	        						 "id":store.data.items[i].data.attendanceDetailId,
			        				  "attendanceComment" : store.data.items[i].data.comment,
			        				  "attendanceMarkingType" : this.getIdValueJson(2)
	        					 });
	        				 }
	        			 }else{
	        				 var attendanceTest = store.data.items[i].data.attendanceStatus
	        				 studentCourseAttendanceDetails.push({
	        					 "admissionId":store.data.items[i].data.admissionId,
	        					 "attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
	        					 "attendanceId":attendanceRecords[0].attendanceId,
	        					 "id":store.data.items[i].data.attendanceDetailId,
		        				  "attendanceComment" : store.data.items[i].data.comment,
		        				  "attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
	        				 });
	        			 }
	        		 }
	        		 var submitUrl;
	        		 if (!isNullOrEmpty(attendanceRecords[0].attendanceId)) {
	        			 submitUrl = SERVERURL.UPDATE_COURSE_ATTENDANCE;
	        		 } 
	        		 var formData = Ext.encode(studentCourseAttendanceDetails);
	        		 Ext.Ajax.request({
	        			 type : 'rest',
	        			 url : submitUrl,
	        			 jsonData : formData,
	        			 method : 'POST',
	        			 success : function(form, action) {
	        				 Ext.getBody().unmask();
	        				 btn.setDisabled(false);
	        				 var msg = form.responseText;
	        				 if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	        					 showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
	        				 }
	        				 else if(msg!='' && msg=='SUCCESS'){
	        					 var gridCount = Ext.getCmp('editStudentAttendancecountGridId');
	        					 var models = gridCount.getStore().getRange();
	        					 models[0].set('totalStudent',0);
	        					 models[0].set('totalPresent',0);
	        					 models[0].set('totalAbsent',0);
	        					 models[0].set('otherCount',0);
	        					 models[0].set('presentPercent','0%');
	        					 models[0].set('absentPercent','0%');
	        					 showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        					 var contentPanel = $this.getEditattendancerecordstructure().up().up(); //get hold of the content panel where we are adding all the tabs
	        					 /**
	        					  * This is to remove tab from content panel and open same tab again
	        					  */
	        					 contentPanel.getActiveTab().close();
	        					 var editGrid = this$.getConsolidateattendancegrid();
	        					 editGrid.getStore().reload();
	        					 editGrid.getSelectionModel().deselectAll(true);
	        				 }else{
	        				 }	       			  
	        			 }
	        		 });

	        	 }else{
	        		 
	        		 var attendanceRecords = this$.getEditstudentattendancegrid().temp;
	        		 var typeOfAttendanc;
	        		 if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	        			 typeOfAttendanc = 'COMPLETE_DAY';
	        		 }else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	        			 typeOfAttendanc = 'MULTIPLE_SESSION';
	        		 }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
	        			 typeOfAttendanc = 'COURSE_LEVEL';
	        		 }
	        		 var store = $this.getStore('attendance.EditStudentAttendanceListStore');
	        		 studentAttendance.set("id", attendanceRecords[0].attendanceId);
	        		 var studentProgramAttendanceDetails =[]; 
	        		 var models = store.getRange();
	        		 for(var i=0;i<store.data.length;i++){
	        			 if(!store.data.items[i].data.attendanceStatus){
	        				 if(models[i].data.present){
	        					 studentProgramAttendanceDetails.push({
	        						 "admissionId":store.data.items[i].data.admissionId,
	        						 "attendanceStatus": 'PRESENT',
	        						 "attendanceId":attendanceRecords[0].attendanceId,
	        						 "id":store.data.items[i].data.attendanceDetailId,
		        					 "attendanceComment" : store.data.items[i].data.comment,
	        						 "attendanceMarkingType" : this.getIdValueJson("1")
	        					 }); 
	        				 }else{
	        					 studentProgramAttendanceDetails.push({
	        						 "admissionId":store.data.items[i].data.admissionId,
	        						 "attendanceStatus": 'ABSENT',
	        						 "attendanceId":attendanceRecords[0].attendanceId,
	        						 "id":store.data.items[i].data.attendanceDetailId,
		        					 "attendanceComment" : store.data.items[i].data.comment,
	        						 "attendanceMarkingType" : this.getIdValueJson("2")
	        					 }); 
	        				 }
	        			 }else{
	        				 var attendanceTest = store.data.items[i].data.attendanceStatus;
	        				 studentProgramAttendanceDetails.push({
	        					 "admissionId":store.data.items[i].data.admissionId,
	        					 "attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
	        					 "attendanceId":attendanceRecords[0].attendanceId,
	        					 "id":store.data.items[i].data.attendanceDetailId,
	        					 "attendanceComment" : store.data.items[i].data.comment,
	        					 "sessionNo" : store.data.items[i].data.sessionNo,
        						 "attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
	        				 });
	        			 }
	        		 }

	        		 var submitUrl;
	        		 if (!isNullOrEmpty(attendanceRecords[0].attendanceId)) {
	        			 submitUrl = SERVERURL.UPDATE_PROGRAM_ATTENDANCE;
	        		 }
	        		 var formData = Ext.encode(studentProgramAttendanceDetails);
	        		 Ext.Ajax.request({
	        			 type : 'rest',
	        			 url : submitUrl,
	        			 jsonData : formData,
	        			 method : 'POST',
	        			 success : function(form, action) {
	        				 Ext.getBody().unmask();
	        				 var msg = form.responseText;
	        				 if(msg!='' && msg=='SUCCESS'){
	        					 showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        					 $this.getEditattendancerecordstructure().down('#submitAttendanceBtn').setDisabled(true);
	        					 var contentPanel = $this.getEditattendancerecordstructure().up().up(); //get hold of the content panel where we are adding all the tabs
	        					 /**
	        					  * This is to remove tab from content panel and open same tab again
	        					  */
	        					 var gridCount = $this.getEditstudentattendancecountgrid();
	        					 var models = gridCount.getStore().getRange();
	        					 if(models.length > 0){
	        						 models[0].set('totalStudent',0);
	        						 models[0].set('totalPresent',0);
	        						 models[0].set('totalAbsent',0);
	        						 models[0].set('otherCount',0);
	        						 models[0].set('presentPercent','0%');
	        						 models[0].set('absentPercent','0%');
	        					 }
	        					 contentPanel.getActiveTab().close();
	        					 var editGrid = this$.getConsolidateattendancegrid();
	        					 editGrid.getStore().reload();
	        					 editGrid.getSelectionModel().deselectAll(true);
	        				 } 
	        				 else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	        					 Ext.getBody().unmask();
	        					 showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
	        				 }
	        			 }
	        		 });
	        	 }
	         },
	         getIdValueJson: function(id, value,code) {
            	 if (id) return {
            		 id: id,
            		 value: value,
            		 code: code
            	 };
             },
             changeOtherStatusOnEdit:function(obj,record){
	        	   var attStatus = obj.getValue();
	        	   var grid = this.getEditstudentattendancegrid().down('grid');
	        	   var store = grid.getStore();

	        	   var prePercent='0%', absPercent='0%';
	        	   var abs=0,pre=0,oth=0;
	        	   if(record[0].data.code == 'PRESENT' || record[0].data.code == 'Present') {
	        		   prePercent = '100%'
	        	   } else if(record[0].data.code == 'ABSENT' || record[0].data.code == 'Absent') {
	        		   absPercent = '100%'
	        	   }
	        	   store.suspendEvents();   
	        	   store.each(function(rec) {
	        		   rec.set('present', false);
	        		   rec.set('absent', false);
	        		   rec.set('attendanceStatus', attStatus);
	        		   rec.set('attendanceMarkingType' ,record[0].data.id);
	        		   rec.set('attendanceMarkStatus' ,record[0].data.code);
	        	   });
	        	   store.resumeEvents();
	        	   grid.getView().refresh();

	        	   var gridCount = this.getEditstudentattendancecountgrid();
	        	   var data = {
	        			   totalStudent:store.data.length,
	        			   totalPresent:0,
	        			   totalAbsent:0,
	        			   otherCount:store.data.length,
	        			   presentPercent:prePercent,
	        			   absentPercent:absPercent,
	        	   };
	        	   var gridStore =  gridCount.getStore();
	        	   if(store.data.length!=0){
	        		   gridStore.removeAll();
	        		   gridStore.loadRawData(data, true);
	        	   }
	           },

});
