/**
 * This controller is used for the Bulk Document Upload Management
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.bulkdocumentupload.BulkDocumentUploadController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['importutility.ImportBulkDocumentUploadStore',
        'importutility.ModuleName',
        'user.UserAcademyLocationStore',
        'bulkdocumentupload.BDUUserTypeStore',
        'common.DocumentTypeStore'
    ],
    views: ['bulkdocumentupload.BulkDocumentUploadStructure',
        'bulkdocumentupload.BulkDocumentUploadTabStructure',
        'bulkdocumentupload.BDUUploadForm',
        'bulkdocumentupload.BDUDownloadForm',
        'importutility.ImportByModule.ImportListBulkDocumentUploadGrid',
        'UploadOptionRadioGroup'
    ],
    models: [],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'importlistbulkdocumentuploadgrid',
        selector: 'importlistbulkdocumentuploadgrid'
    },{
   		ref : 'uploadoptionradiogroup',
   		selector : 'uploadoptionradiogroup[itemId=bDUListUploadOptionRadioGroupItemId]'
   	}],
   	config: {		
   		CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
   	},
    init: function() {
        this.control({
            'bulkdocumentuploadtabstructure radiogroup[itemId=importDownloadGroupItemId]': {
                change: this.bulkDocumentUploadDownloadUploadFormChange
            },
            'bdudownloadform button[itemId=resetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('bdudownloadform').getForm();
                    form.reset();
                }
            },
            'bdudownloadform button[itemId=downoladBDUDownloadFormBtnItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('bdudownloadform');
                    var csvForm = Ext.create('Ext.form.Panel');

                    var academyLocationId = form.down("#academyLocationItemId").getValue();
                    var userGroupId = form.down("#userGroupItemId").getValue();
                    var documentTypeId = form.down("#documentTypeItemId").getValue();

                    csvForm.getForm().submit({
                        target: '_blank',
                        method: 'POST',
                        params: {
                            access_token: Ext.Ajax.defaultHeaders.access_token,
                            'academyLocationId': academyLocationId,
                            'userGroupId': userGroupId,
                            'documentTypeId': documentTypeId
                        },
                        headers: {
                            'Authorization': Ext.Ajax.defaultHeaders.Authorization
                        },
                        url: SERVERURL.DOWNLOAD_TEMPLATE_BULK_DOCUMENT_UPLOAD,
                        standardSubmit: true
                    });
                }
            },
	        'bduuploadform uploadoptionradiogroup[itemId=bDUListUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	        	change: function( radioGroup, newValue, oldValue, eOpts){
	        		var grid =this.getImportlistbulkdocumentuploadgrid();
	        		var form =this.getUploadoptionradiogroup();
	        		var isUploadAll = newValue.isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Documents');
	        	}   
	 		   },
            'bduuploadform button[itemId=uploadId]': {
                click: function(obj) {
                    var $this = this;
                    var bduuploadform = obj.up('bduuploadform');
                    submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_ZIP_UPLOAD;
                    bduuploadform.getForm().submit({
                        method: 'POST',
                        url: submitUrl,
                        success: function(form, action) {
                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                        },
                        failure: function(form, action) {
                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                        }
                    });

                    Ext.defer(function() {
                    	bduuploadform.down("#uploadId").setDisabled(true);
                        var grid = $this.getImportlistbulkdocumentuploadgrid();
                        var form = $this.getUploadoptionradiogroup();
  					    var isUploadAll = form.items.items[0].getValue().isUploadAll;
  					    $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Documents');
                    }, 2000, this);
                }
            },
            'bduuploadform button[itemId=resetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('bduuploadform').getForm();
                    form.findField('file').reset();
                    form.findField('zipFile').reset();
                    var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
  				    uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  					   isUploadAll: false
  				   });
                    form.isValid();
                },
                render: function(obj) {
                    var $this = this;
                    var form = obj.up('bduuploadform').getForm();
                    var combo = form.findField('importUtilityMasterId');
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            for (var i in records) {
                                if (records[i].data.value == 'Bulk Documents') {
                                    combo.setValue(records[i].data.id);
                                    combo.setReadOnly(true);
                                }
                            }
                        }
                    });
                }
            },
            'importlistbulkdocumentuploadgrid': {
                render: function(obj) {
                    var $this = this;
                    var grid = $this.getImportlistbulkdocumentuploadgrid();
                    var form  = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Documents');
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    if (e.target.tagName == 'A') {
                        var fileType = null;
                        if (cellIndex == 1) {
                            fileType = 'successFile';
                        } else if (cellIndex == 6) {
                            fileType = 'errorFile';
                        } else if (cellIndex == 7) {
                            fileType = 'logFile';
                        }
                        var documentId = record.get("id");
                        if (!isNullOrEmpty(documentId)) {
                            this.getBulkDocumentUploadDownloadFile(documentId, fileType);
                        }
                    }
                }
            },
            'importlistbulkdocumentuploadgrid button[itemId=btnForce]': {
                click: function(obj) {
                    var grid = this.getImportlistbulkdocumentuploadgrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        if (grid.getSelectionModel().getCount() > 1) {
                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
                        } else {
                            var this$ = this;
                            var id = grid.getSelectionModel().selectionStart.data.id;
                            console.log(id);
                            var urlAppend = "?jobName=" + id;
                            var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
                            Ext.Ajax.request({
                                url: submitURL,
                                method: 'GET',
                                success: function(response) {
                                    if (response.responseText === "JOB_STATUS_NOT_PENDING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
                                    } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
                                        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
                                    } else if (response.responseText === "SUCCESS") {
                                        showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                                        grid.getStore().reload();
                                    }
                                }
                            });
                        }
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'bdudownloadform combo#academyLocationItemId': {
                render: function(obj) {
                    var userId = this.getCurrentlyLoggedInUser().id;
                    var store = obj.getStore();
                    store.getProxy().extraParams = {
                        id: userId
                    };
                    store.load();
                }
            },
            'bdudownloadform nestedJsonCombo#userGroupItemId': {
                select: function(combo) {
                    var comboVal = combo.getValue(),
                    documentType = combo.up().down('#documentTypeItemId');
                    documentType.setDisabled(false);
                    documentType.reset();
                    var store = documentType.getStore();
                    if(comboVal == 2){
                    	store.getProxy().extraParams = {
                    		isApplicableForEmployee: true
                        };	
                    }
                    else if(comboVal == 3){
                    	store.getProxy().extraParams = {
                    		isApplicableForStudent: true
                        };
                    }
                    else if(comboVal == 6){
                    	store.getProxy().extraParams = {
                    		isApplicableForParent: true
                        };
                    }
                    
                    store.load();
                }
            }
        });
    },
    bulkDocumentUploadDownloadUploadFormChange: function(cb, nv, ov) {
        var $this = this;
        var structure = cb.up('bulkdocumentuploadtabstructure');
        var downloadTemplateForm = structure.down('bdudownloadform');
        var uploadTemplateForm = structure.down('bduuploadform');
        var grid = $this.getImportlistbulkdocumentuploadgrid();
        if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
            uploadTemplateForm.hide();
            downloadTemplateForm.show();
            grid.setVisible(false);
            
            if(downloadTemplateForm.isValid()) {
            	downloadTemplateForm.down("#downoladBDUDownloadFormBtnItemId").setDisabled(false);
            } else {
            	downloadTemplateForm.down("#downoladBDUDownloadFormBtnItemId").setDisabled(true);
            }
        } else {
        	$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        		isUploadAll: false
        	});
        	downloadTemplateForm.hide();
            uploadTemplateForm.show();
            grid.setVisible(true);
            uploadTemplateForm.down("#uploadFileField").reset();
            uploadTemplateForm.down("#zipFileItemId").reset();
        }
    },
    getBulkDocumentUploadDownloadFile: function(documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        }
    },
});