/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.homework.HomeworkEvaluationController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : ['coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
	          'coursetransaction.homework.submissiondetails.GroupValue'
	          ],

	stores : ['coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
	          'coursetransaction.homework.submissiondetails.EvaluationDetailsGrid',
	          
	          'coursetransaction.homework.submissiondetails.GroupName','coursetransaction.homework.submissiondetails.StudentName',
	          'examinationcenters.manageEvaluation.ManageEvaluationResult',
	          'gradeMaster.GradeGroupMapping','coursetransaction.homework.HW_AssessmentEventStore',
	          'coursetransaction.homework.AssessmentEventResultStore'
	          ],

	views : [
	         'Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetailsGrid',
	         'Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetails',
	         'Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetailsGridNew',
	         'Academia.view.coursetransaction.homework.evaluationdetails.EditEvaluationDetailStructure',
	         'Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetailsForm',
	         'coursetransaction.homework.evaluationdetails.EvaluationAssessmentRemarkWin',
	         'examinationcenters.manageEvaluation.MarkEntryDefaultMarkGradeWindow'
	         ],	           
	         config:{

            	 /*
            	  * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
            	  */
            	 /**
            	  * @cfg {Array} HOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS array (required)
            	  * The array of permissions to use for Access control wise enabling and disabling buttons.
            	  * @accessor
            	  */
	        	 HOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PRIVILEGES'),
	        	 HOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES')
             },  
	         refs : [{
	        	  ref:'contentPanel',
	        	  selector:'contentPanel'
	          },{
	        	 ref : 'evaluationdetailsgrid',
	        	 selector : 'evaluationdetailsgrid'
	         },{
	        	 ref : 'evaluationdetailsgridnew',
	        	 selector : 'evaluationdetailsgridnew'
	         },{
	        	 ref : 'evaluationdetails',
	        	 selector : 'evaluationdetails'
	         },{
	        	 ref : 'evaluationDetails',
	        	 selector : 'evaluationdetails form'
	         },{
	        	 ref : 'assignmentdetails',
	        	 selector : 'assignmentdetails'
	         },{
            	 ref : 'submissiondetailsgrid',
            	 selector : 'submissiondetailsgrid'
             },{
            	 ref : 'submissiondetailsgridnew',
            	 selector : 'submissiondetailsgridnew'
             },{
            	 ref : 'editevaluationdetailstructure',
            	 selector : 'editevaluationdetailstructure'
             },{
            	 ref : 'evaluationassessmentremarkwin',
            	 selector : 'evaluationassessmentremarkwin'
             },{
            	 ref : 'markentrydefaultmarkgradewindow',
            	 selector : 'markentrydefaultmarkgradewindow'
             },{
            	 ref : 'evaluationdetailsform',
            	 selector : 'evaluationdetailsform'
             },{
	        	  ref:'isEvaluationNoMarkTypeMarkEntryGridItemIdWindowNew',
	        	  selector:'editevaluationdetailstructure grid[itemId=isEvaluationNoMarkTypeMarkEntryGridItemId]'
	          },{
	        	  ref:'isEvaluationNoGradeTypeMarkEntryGridItemIdWindowNew',
	        	  selector:'editevaluationdetailstructure grid[itemId=isEvaluationNoGradeTypeMarkEntryGridItemId]'
	          },{
	        	  ref:'isEvaluationYesMarkTypeMarkEntryGridItemIdWindowNew',
	        	  selector:'editevaluationdetailstructure grid[itemId=isEvaluationYesMarkTypeMarkEntryGridItemId]'
	          },{
	        	  ref:'isEvaluationYesGradeTypeMarkEntryGridItemIdWindowNew',
	        	  selector:'editevaluationdetailstructure grid[itemId=isEvaluationYesGradeTypeMarkEntryGridItemId]'
	          }],

	                 init : function() {
	                	 this.control({
	                		 'evaluationdetailsgrid button[itemId=btnEdit]':{
	                			 click: function() {
	                				 this.editEvaluationDetails();
	                			 }
	                		 },
	                		 'evaluationdetailsgrid button[itemId=btnDelete]': {
	    	        			 click : function() {
	    	        				 var grid = this.getEvaluationdetailsgrid();
	    	        				 this.deleteGroupHomeworkAssignment(grid);
	    	        			 }
	    	        		 },
	                		 'evaluationdetailsgridnew button[itemId=btnEdit]':{
	                			 click: function() {
	                				 this.editEvaluationDetailsNew();
	                			 }
	                		 },
	                		 'evaluationdetails button[itemId=btnCancel]':{
	                			 click: function() {
	                				 this.getEvaluationdetails().close();
	                			 }
	                		 },
	                		 'evaluationdetailsgrid':{
	                			 render:function(){
	                				 var form = this.getAssignmentdetails().getForm();
	                				 var assignmentId = form.findField('responseId').getValue();
	                				 var user=this.getCurrentlyLoggedInUser();
	                				 var userId=user.id;
	                            	 var userPortalId=this.getCurrentLoggedPortalId();
	                            	 if(userPortalId!=3){
	                            		 userId =null;
	                            	 }
	                            	 if(userPortalId == 7){
	                            		 var userInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                            		 if(!isNullOrEmpty(userInfo) && userInfo != undefined && userInfo != null ){
	                            			 userId=userInfo.student.id;
	                            		 }
	                            	 }
	                				 var grid=this.getEvaluationdetailsgrid();
	                				 if(grid.isVisible()==false){
	                					 var grid=this.getEvaluationdetailsgridnew();
	                				 }
	                				 if(userPortalId==1){
	                					 this.doAccessControlValidation(grid, this.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS()); 
	                				 }else if (userPortalId==2){
	                					 this.doAccessControlValidation(grid, this.getHOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES());
	                				 }
	                				 
	                            	 //this.disableMoreActionSequencePivileges(grid, this.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS());
	                				/* var store = this.getStore('coursetransaction.homework.submissiondetails.EvaluationDetailsGrid');
	                				 store.getProxy().extraParams = {
	                					 id : assignmentId,
	                					 docType:'EVALUATED_DOC',
	                					 userId: userId
	                				 };
	                				 store.load();*/
	                				 var gridStatus = form.findField('gridStatus').getValue();
	                				 if(gridStatus == 'View'){
	                					 buttonsToolBar = grid.query('toolbar')[0];
	            						 var editButton = buttonsToolBar.query('#btnEdit')[0];
	            						 editButton.setVisible(false);
	            						 var btnDelete = buttonsToolBar.query('#btnDelete')[0];
	            						 btnDelete.setVisible(false);
                						 
                					 }
	                			 },
	                			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
                    				 var $this = this;
                    				 var documentGrid = $this.getEvaluationdetailsgrid();
                    				 if(documentGrid.isVisible()==false){
	                					 var documentGrid=this.getEvaluationdetailsgridnew();
	                				 }
                    				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    				 if (columnName == "documents") {

                    					 if (e.target.tagName == 'A') {

                    						 var document = record.get("documents");
                    						 var documentId = document[0].id;

                    						 if (!isNullOrEmpty(documentId)) {
                    							 $this.getDocumentController().downloadDocumentFile(documentId);
                    						 }
                    					 }
                    				 }
                    				 if (columnName === 'remarks') {
                 	    	            var remarks = record.get('remarks');
                 	    	           if(!isNullOrEmpty(remarks)){
                 	    	            Ext.create('Ext.window.Window',{
                 	    	       	title:getCourseTxCommonTranslation('ASSIGNMENT_REMARKS'),
                 	    	       	frame: true,
                 	    	       	autoScroll:true,
                 	    	       	modal:true,
                 	    	       	height:350,
                 	    	       	maxHeight: 600,
                 	    	       	items: [{
                 	    	       		xtype: 'form',
                 	    	       		items:[{
                 	    	           		xtype: 'fieldcontainer',
                 	    	       			plugins : "formlabelrequired",
                 	    	       			height:160,
                 	    	       			defaults: {
                 	    	       				labelAlign: 'top',
                 	    	       			},
                 	    	       		items: [{
                 	    	       			xtype: 'textarea',
                 	    	       			name: 'assessmentRemark',
                 	    	       			itemId:'assessmentRemark',
                 	    	       			readOnly: true,
                 	    	       			value: remarks,
                 	    	       			scrollable: true,
                 	    	       			fieldLabel: '<b>'+getExaminationTranslation('REMARK')+'</b>',
                 	    	       			height:150,
                 	    	       			width:600,
                 	    	       		    maxLength:10000
                 	    	       		}]
                 	    	           	},{ 	
                 	    	       		   xtype:'fieldcontainer',
                 	    	           	   width:'auto',
                 	    	       		   items: [{
                 	    	       				 xtype: 'button',
                 	    	       				 text: getFeeAndPaymentCommonTranslation('CANCEL'),
                 	    	       				 ui: 'CustomBtnCancel',
                 	    	       				 itemId: 'cancelBtn',
                 	    	       				 scale: CONSTANTS.BUTTONSIZE,
                 	    	       				 handler: function (btn) {
                 	    	                        btn.up('window').close();
                 	    	                    }
                 	    	       		      }]
                 	    	       	     }]
                 	    	       	}]
                 	    	       }).show();
                 	    	        }
                    			   }
                    			 }
	                		 },
	                		 'evaluationdetailsgridnew':{
	                			 render:function(){
	                				 var form = this.getAssignmentdetails().getForm();
	                				 var assignmentId = form.findField('responseId').getValue();
	                				 var user=this.getCurrentlyLoggedInUser();
	                				 var userId=user.id;
	                            	 var userPortalId=this.getCurrentLoggedPortalId();
	                            	 if(userPortalId!=3){
	                            		 userId =null;
	                            	 }
	                            	 if(userPortalId == 7){
	                            		 var userInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                            		 if(!isNullOrEmpty(userInfo) && userInfo != undefined && userInfo != null ){
	                            			 userId=userInfo.student.id;
	                            		 }
	                            	 }
	                				 var grid=this.getEvaluationdetailsgrid();	
                    				 if(grid.isVisible()==false){
	                					 var grid=this.getEvaluationdetailsgridnew();
	                				 }
                    				 if(userPortalId == 1){
                    					 this.doAccessControlValidation(grid, this.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS());
                    				 }else if(userPortalId == 2){
                    					 this.doAccessControlValidation(grid, this.getHOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES());
                    				 }
	                				 
	                            	 //this.disableMoreActionSequencePivileges(grid, this.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS());
	                				 /*var store = this.getStore('coursetransaction.homework.submissiondetails.EvaluationDetailsGrid');
	                				 store.getProxy().extraParams = {
	                					 id : assignmentId,
	                					 docType:'EVALUATED_DOC',
	                					 userId: userId
	                				 };
	                				 store.load();*/
	                				 
	                				 var gridStatus = form.findField('gridStatus').getValue();
	                				 if(gridStatus == 'View'){
	                					 buttonsToolBar = grid.query('toolbar')[0];
	            						 var editButton = buttonsToolBar.query('#btnEdit')[0];
	            						 editButton.setVisible(false);
	            						 var btnDelete = buttonsToolBar.query('#btnDelete')[0];
	            						 btnDelete.setVisible(false);
                						 
                					 }
	                			 },
	                			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
                    				 var $this = this;
                    				 var documentGrid = $this.getEvaluationdetailsgrid();
                    				 if(documentGrid.isVisible()==false){
	                					 var documentGrid=this.getEvaluationdetailsgridnew();
	                				 }
                    				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    				 if (columnName == "documents") {

                    					 if (e.target.tagName == 'A') {

                    						 var document = record.get("documents");
                    						 var documentId = document[0].id;

                    						 if (!isNullOrEmpty(documentId)) {
                    							 $this.getDocumentController().downloadDocumentFile(documentId);
                    						 }
                    					 }
                    				 }
                    			 }
	                		 },
	                		 'editevaluationdetailstructure':{
	                			 render : function() {
	                				 var $this=this;
	                				 var portalId=this.getCurrentLoggedPortalId();
	                				 var editevaluationdetailstructure=this.getEditevaluationdetailstructure();
	                				  if(portalId==1){
	                					 this.disableEditEvaluationDetailStructurePivileges(editevaluationdetailstructure, $this.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS());
	                				 }else if (portalId==2){
	                					 this.disableEditEvaluationDetailStructurePivileges(editevaluationdetailstructure, $this.getHOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES());
	                				 }
	                			 }
	                		 },
	                		 'evaluationdetails button[itemId=btnSubmit]':{
	                			 click:function(){
	                				 this.addEvauationDetails();
	                			 }
	                		 },
	                		 'evaluationdetails' : {
	                			 render : function() {
	                				 var form = this.getAssignmentdetails().getForm();
	                				 var assignmentId = form.findField('responseId').getValue();
	                				 var store = this.getStore('coursetransaction.homework.submissiondetails.GroupName');
	                				 store.getProxy().extraParams = {
	                					 id : assignmentId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'evaluationdetails customcombobox#groupName_Id' : {
	                			 select : function(obj, record) {
	                				 var groupName = record[0].data.value;
	                				 var form = this.getAssignmentdetails().getForm();
	                				 var assignmentId = form.findField('responseId').getValue();
	                				 var store = this.getStore('coursetransaction.homework.submissiondetails.StudentName');

	                				 store.getProxy().extraParams = {
	                					 homeWorkAssignmentId : assignmentId,
	                					 groupName : groupName
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'evaluationdetailsgrid [itemId=evaluationUploadDocument]': {
          	        			  click: function() {
          	        				  this.evaluationDocumentUpload();
          	        			  }
          	        		  },
          	        		'evaluationdetailsgridnew [itemId=evaluationUploadDocument]': {
        	        			  click: function() {
        	        				  this.evaluationDocumentUpload();
        	        			  }
        	        		  },
          	        		'documentformwindow[itemId=evaluationDocItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
        	        			  click: function(){
        	        				  this.getUploadDocument();
        	        			  }
        	        		  },

    	        			  'evaluationdetails radiogroup[itemId=submissionStatusId]' : {
    	        				  change : function(obj, newValue) {
    	        					  //var form = this.getSubmissiondetails();
    	        					  var form = obj.up('form');
    	        					  var reSubmissionStatus = form.down('#reSubmissionStatusId').getValue();

    	        					  if(newValue.submissionStatus==getCourseTxCommonTranslation('HW_PENDING')){
    	        						  form.down("#reSubmissionStatusId").setVisible(true);
    	        						  // form.down("#resubmissionDate").setVisible(true);
    	        						  form.down("#reSubmissionStatusId").allowBlank=false;
    	        					  }else{    	        						  
    	        						  form.down("#reSubmissionStatusId").setVisible(false);
    	        						  form.down("#resubmissionDate").setVisible(false);
    	        						  form.down("#reSubmissionStatusId").allowBlank=true;
    	        						 if(newValue.submissionStatus == 'Completed'){
    	        							  form.down("#reSubmissionStatusId").items.items[1].setValue(true);
        	        						  form.down("#reSubmissionStatusId").items.items[0].setValue(false);

    	        						  }
    	        					  }

    	        					  if((newValue.submissionStatus==getCourseTxCommonTranslation('HW_PENDING')) && 
    	        							  (reSubmissionStatus.reSubmissionStatus == true)){
    	        						  form.down("#resubmissionDate").setVisible(true);
    	        						  form.down("#resubmissionDate").allowBlank=false;
    	        					  }

    	        				  }
    	        			  },
    	        			  'evaluationdetails radiogroup[itemId=reSubmissionStatusId]' : {
    	        				  change : function(obj, newValue) {
    	        					  var form = obj.up('form');
    	        					  form.down("#resubmissionDate").reset();
    	        					  if(newValue.reSubmissionStatus){
    	        						  form.down("#resubmissionDate").setVisible(true);
    	        						  form.down("#resubmissionDate").allowBlank=false;
    	        						  form.isValid(true);
    	        					  }else{
    	        						  form.down("#resubmissionDate").setVisible(false);
    	        						  form.down("#resubmissionDate").allowBlank=true;
    	        						  form.isValid(true);
    	        					  }

    	        				  }
    	        			  },
    	        			  'markentrydefaultmarkgradewindow[itemId=evalassessmarkentrydefaultmarkgradewin]':{
    	        				  afterrender: function(win){
    	        					  var me = this, 
    	        					  	structure,
    	        					  	marksOrGrade,
    	        					  	editEvTab,
    	        					  	isMarkType,
    	        					  	maxMarks,
    	        					  	winField,
    	        					  	contentPanelActiveTab = me.getContentPanel().getActiveTab();
    	        					  
    	        					  if(!contentPanelActiveTab.down('#isEvaluationNoMarkTypeMarkEntryGridItemId').isHidden()){
    	        						  structure = me.getEditevaluationdetailstructure();
    	        						  marksOrGrade=structure.down('#marksOrGrade').getValue();

    	        						  editEvTab = contentPanelActiveTab.down('#editevaluationdetailstructureItemId');
    	        						  isMarkType = editEvTab.isMarkType;

    	        						  maxMarks = isMarkType ? editEvTab.maxMarks : 999;
    	        						  winField = win.down('#defaultTotalMarks');
    	        						  winField.setMaxValue(maxMarks);
    	        					  }
    	        				  }
    	        			  },
    	        			  'markentrydefaultmarkgradewindow[itemId=evalassessmarkentrydefaultmarkgradewin] button#cancelBtn':{
    	        				  click : function(btn){
    	        					  btn.up('window').close();
    	        				  }
    	        			  },
    	        			  'markentrydefaultmarkgradewindow[itemId=evalassessmarkentrydefaultmarkgradewin] button[itemId=submitBtnWin]':{
    	        				  click:function(obj){
    	        					  this.saveDefaultMarkGradeForHomeworkAssignment();
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure grid[itemId=isEvaluationNoMarkTypeMarkEntryGridItemId]': {
    	        				  selectionchange: function(grid, selected) {
    	        					  var disabled = true;
    	        					  Ext.each(selected, function(currentSelected){
    	        						  if(!isNullOrEmpty(currentSelected.data.markObtained) || !isNullOrEmpty(currentSelected.data.remarks)){
    	        							  disabled = false;
    	        						  }
    	        					  });
    	        					  grid.view.up().down('#evaluationNoMarkGridResetBtn').setDisabled(disabled);
    	        					  grid.view.up().down('#evaluationNoMarkEnterRemarkBtn').setDisabled(!selected.length);
    	        					  grid.view.up().down('#evaluationNoSaveMarkBtn').setDisabled(!selected.length);
    	        				  },
    	        				  render: function(grid){
    	        					  var me = this;
    	        					  var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
    	        					  var assignmentType = assignmentdetailsFormValue.assignmentType;
    	        					  if(assignmentType == 'group') {
    	        						  grid.down('[dataIndex=groupName]').show();
    	        					  } else {
    	        						  grid.down('[dataIndex=groupName]').hide();
    	        					  }
    	        				  },
    	        				  afterrender: function(grid,eOpts){
    	        					  var me = this;
    	        					  setTimeout(function(){
    	        						  if(grid.isVisible()){
    	        							  var structure = me.getContentPanel().getActiveTab();
    	        							  if(grid.down('button').isVisible()){
    	        								  me.getGridHeaderFreezeWithoutPaginationCustomized(grid, structure, false);  
    	        							  }else{
    	        								  me.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid, structure, false);  
    	        							  }
    	        						  }
    	        					  },500);
    	        				  }
    	        			  },
	   		          		   'editevaluationdetailstructure grid[itemId=isEvaluationNoGradeTypeMarkEntryGridItemId]': {
	   		          			   selectionchange: function(grid, selected) {
	   		          				   var disabled = true;
	   		          				   Ext.each(selected, function(currentSelected){
	   		          					   if(!isNullOrEmpty(currentSelected.data.markObtained) || !isNullOrEmpty(currentSelected.data.remarks)){
	   		          						   disabled = false;
	   		          					   }
	   		          				   });
	   		          				   grid.view.up().down('#evaluationNoGradeGridResetBtn').setDisabled(disabled);
	   		          				   grid.view.up().down('#evaluationNoGradeEnterRemarkBtn').setDisabled(!selected.length);
	   		          				 grid.view.up().down('#evaluationNoSaveGradeBtn').setDisabled(!selected.length);
	   		          			   },
	    	        				  render: function(grid){
	    	        					  var me = this;
	    	        					  var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
	    	        					  var assignmentType = assignmentdetailsFormValue.assignmentType;
	    	        					  if(assignmentType == 'group') {
	    	        						  grid.down('[dataIndex=groupName]').show();
	    	        					  } else {
	    	        						  grid.down('[dataIndex=groupName]').hide();
	    	        					  }
	    	        				  },
	   		          			   afterrender: function(grid,eOpts){
			          				   var me = this;
			          				   setTimeout(function(){
			          					   if(grid.isVisible()){
			          						   var structure = me.getContentPanel().getActiveTab();
			          						   if(grid.down('button').isVisible()){
			          							 me.getGridHeaderFreezeWithoutPaginationCustomized(grid, structure, false);  
			          						   }else{
			          							 me.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid, structure, false);  
			          						   }
			          					   }
			          				   },500);
			          			   }
	   		          		   },
	   		          		   'editevaluationdetailstructure grid[itemId=isEvaluationYesMarkTypeMarkEntryGridItemId]': {
	   		          			   selectionchange: function(grid, selected) {
	   		          				   var disabled = true;
	   		          				   Ext.each(selected, function(currentSelected){
	   		          					   if(!isNullOrEmpty(currentSelected.data.totalMarks) || !isNullOrEmpty(currentSelected.data.remarks)){
	   		          						   disabled = false;
	   		          					   }
	   		          				   });
	   		          				   grid.view.up().down('#evaluationYesMarkGridResetBtn').setDisabled(disabled);
	   		          				   grid.view.up().down('#evaluationYesMarkEnterRemarkBtn').setDisabled(!selected.length);
	   		          			   },
	    	        				  render: function(grid){
	    	        					  var me = this;
	    	        					  var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
	    	        					  var assignmentType = assignmentdetailsFormValue.assignmentType;
	    	        					  if(assignmentType == 'group') {
	    	        						  grid.down('[dataIndex=groupName]').show();
	    	        					  } else {
	    	        						  grid.down('[dataIndex=groupName]').hide();
	    	        					  }
	    	        				  },
	   		          			   afterrender: function(grid,eOpts){
	 		          				   var me = this;
	 		          				   setTimeout(function(){
	 		          					   if(grid.isVisible()){
	 		          						   var structure = me.getContentPanel().getActiveTab();
	 		          						   if(grid.down('button').isVisible()){
	 		          							 me.getGridHeaderFreezeWithoutPaginationCustomized(grid, structure, false);  
	 		          						   }else{
	 		          							 me.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid, structure, false);  
	 		          						   }
	 		          					   }
	 		          				   },500);
	 		          			   }
	   		          		   },
	   		          		   'editevaluationdetailstructure grid[itemId=isEvaluationYesGradeTypeMarkEntryGridItemId]': {
	   		          			   selectionchange: function(grid, selected) {
	   		          				   var disabled = true;
	   		          				   Ext.each(selected, function(currentSelected){
	   		          					   if(!isNullOrEmpty(currentSelected.data.finalGrade) || !isNullOrEmpty(currentSelected.data.remarks)){
	   		          						   disabled = false;
	   		          					   }
	   		          				   });
	   		          				   grid.view.up().down('#evaluationYesGradeGridResetBtn').setDisabled(disabled);
	   		          				   grid.view.up().down('#evaluationYesGradeEnterRemarkBtn').setDisabled(!selected.length);
	   		          			   },
	    	        				  render: function(grid){
	    	        					  var me = this;
	    	        					  var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
	    	        					  var assignmentType = assignmentdetailsFormValue.assignmentType;
	    	        					  if(assignmentType == 'group') {
	    	        						  grid.down('[dataIndex=groupName]').show();
	    	        					  } else {
	    	        						  grid.down('[dataIndex=groupName]').hide();
	    	        					  }
	    	        				  },
	   		          			   afterrender: function(grid,eOpts){
			          				   var me = this;
			          				   setTimeout(function(){
			          					   if(grid.isVisible()){
			          						   var structure = me.getContentPanel().getActiveTab();
			          						   if(grid.down('button').isVisible()){
			          							 me.getGridHeaderFreezeWithoutPaginationCustomized(grid, structure, false);  
			          						   }else{
			          							 me.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid, structure, false);  
			          						   }
			          					   }
			          				   },500);
			          			   }
	   		          		   },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoMarkBtn]':{
    	        				  click:function(obj){
        	        					  var $this=this; 
        	        					  var grid=obj.up('grid');
        	        					  var evalGrid = this.getEvaluationdetailsgrid();
        	        					  var isEvaluationRequired = evalGrid.up().config.isEvaluationRequired;
        	        					  var structure =this.getEditevaluationdetailstructure();
        	        					  var marksOrGrade=structure.down('#marksOrGrade').getValue();
        	        					  if (grid.getSelectionModel().getCount() > 0) {
        	        						  var formWindow = this.getMarkentrydefaultmarkgradewindow();
        	        						  if (!formWindow) {
        	        							  formWindow = Ext.widget('markentrydefaultmarkgradewindow',{
        	        								  itemId:'evalassessmarkentrydefaultmarkgradewin'
        	        							  });
        	        							  formWindow = this.getMarkentrydefaultmarkgradewindow();
        	        						  }
        	        						  formWindow.show();  
        	        						  formWindow.down('#defaultTotalMarks').show();
        	        						  formWindow.down('#defaultFinalGrade').hide();
        	        						  formWindow.down('#textGradeItemId').hide();
        	        						  formWindow.down('#textGradeItemId1').hide();
        	        						  formWindow.down('#marksOrGrade').setValue(marksOrGrade);
        	        						  
        	        					  }else{
        	        						  Ext.getBody().unmask();
        	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
        	        					  }
        	        				 
        	        			  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoGradeBtn]':{
    	        				  click:function(obj){
    	        					  var $this=this; 
    	        					  var grid=obj.up('grid');
    	        					  var evalGrid = this.getEvaluationdetailsgrid();
    	        					  var isEvaluationRequired = evalGrid.up().config.isEvaluationRequired;
    	        					  var structure =this.getEditevaluationdetailstructure();
    	        					  var marksOrGrade=structure.down('#marksOrGrade').getValue();
    	        					  if (grid.getSelectionModel().getCount() > 0) {
    	        						  var formWindow = this.getMarkentrydefaultmarkgradewindow();
    	        						  if (!formWindow) {
    	        							  formWindow = Ext.widget('markentrydefaultmarkgradewindow',{
    	        								  itemId:'evalassessmarkentrydefaultmarkgradewin'
    	        							  });
    	        							  formWindow = this.getMarkentrydefaultmarkgradewindow();
    	        						  }
    	        						  formWindow.show();  
    	        						  
    	        						  if(!isNullOrEmpty(structure.maxMarks)){
    	        							  formWindow.down('#textGradeItemId').hide();
    	        							  formWindow.down('#textGradeItemId1').show();
    	        							  formWindow.down('#textGradeItemId1').setMaxValue(structure.maxMarks);
    	        						  }
    	        						  else{
    	        							  formWindow.down('#textGradeItemId1').hide();
        	        						  formWindow.down('#textGradeItemId').show();
    	        						  }
    	        						  
    	        						  
    	        						  formWindow.down('#defaultFinalGrade').hide();
    	        						  formWindow.down('#defaultTotalMarks').hide();
    	        						  formWindow.down('#marksOrGrade').setValue(marksOrGrade);
    	        						  
    	        					  }else{
    	        						  Ext.getBody().unmask();
    	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
    	        					  }
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesMarkBtn]':{
        	        				  click:function(obj){
        	        					  var $this=this; 
        	        					  var grid=obj.up('grid');
        	        					  var evalGrid = this.getEvaluationdetailsgrid();
        	        					  var isEvaluationRequired = evalGrid.up().config.isEvaluationRequired;
        	        					  var structure =this.getEditevaluationdetailstructure();
        	        					  var marksOrGrade=structure.down('#marksOrGrade').getValue();
        	        					  if (grid.getSelectionModel().getCount() > 0) {
        	        						  var formWindow = this.getMarkentrydefaultmarkgradewindow();
        	        						  if (!formWindow) {
        	        							  formWindow = Ext.widget('markentrydefaultmarkgradewindow',{
        	        								  itemId:'evalassessmarkentrydefaultmarkgradewin'
        	        							  });
        	        							  formWindow = this.getMarkentrydefaultmarkgradewindow();
        	        						  }
        	        						  formWindow.show();
        	        						  formWindow.down('#marksOrGrade').setValue(marksOrGrade);
        	        						  formWindow.down('#defaultFinalGrade').hide();
        	        						  formWindow.down('#defaultTotalMarks').show();
        	        						  formWindow.down('#textGradeItemId').hide();
        	        						  formWindow.down('#textGradeItemId1').hide();
        	        						  
        	        					  }else{
        	        						  Ext.getBody().unmask();
        	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
        	        					  }
        	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesGradeBtn]':{
    	        				  click:function(obj){
    	        					  var $this=this; 
    	        					  var grid=obj.up('grid');
    	        					  var evalGrid = this.getEvaluationdetailsgrid();
    	        					  var isEvaluationRequired = evalGrid.up().config.isEvaluationRequired;
    	        					  var structure =this.getEditevaluationdetailstructure();
    	        					  var marksOrGrade=structure.down('#marksOrGrade').getValue();
    	        					  if (grid.getSelectionModel().getCount() > 0) {
    	        						  var formWindow = this.getMarkentrydefaultmarkgradewindow();
    	        						  if (!formWindow) {
    	        							  formWindow = Ext.widget('markentrydefaultmarkgradewindow',{
    	        								  itemId:'evalassessmarkentrydefaultmarkgradewin'
    	        							  });
    	        							  formWindow = this.getMarkentrydefaultmarkgradewindow();
    	        						  }
    	        						  formWindow.show();  
    	        						  formWindow.down('#defaultFinalGrade').show();
    	        						  formWindow.down('#defaultTotalMarks').hide();
    	        						  formWindow.down('#textGradeItemId').hide();
    	        						  formWindow.down('#textGradeItemId1').hide();
    	        						  formWindow.down('#marksOrGrade').setValue(marksOrGrade);
    	        						  
    	        					  }else{
    	        						  Ext.getBody().unmask();
    	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
    	        					  }
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoMarkGridResetBtn]':{
    	        				  click:function(button){
    	        					  this.restGridItems(button);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoGradeGridResetBtn]':{
    	        				  click:function(button){
    	        					  this.restGridItems(button);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesMarkGridResetBtn]':{
    	        				  click:function(button){
    	        					  this.restGridItems(button);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesGradeGridResetBtn]':{
    	        				  click:function(button){
    	        					  this.restGridItems(button);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoMarkEnterRemarkBtn]':{
    	        				  click:function(obj){
    	        					  this.openEnterRemarkScreen(obj);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoGradeEnterRemarkBtn]':{
    	        				  click:function(obj){
    	        					  this.openEnterRemarkScreen(obj); 
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesMarkEnterRemarkBtn]':{
    	        				  click:function(obj){
    	        					  this.openEnterRemarkScreen(obj);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesGradeEnterRemarkBtn]':{
    	        				  click:function(obj){
    	        					  this.openEnterRemarkScreen(obj);
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoSaveMarkBtn]':{
    	        				  click:function(obj){
    	        					  this.saveIsEvaluationNoMarkGradeTypeBtn(obj,"MARK");
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationNoSaveGradeBtn]':{
    	        				  click:function(obj){
    	        					  this.saveIsEvaluationNoMarkGradeTypeBtn(obj,"GRADE");
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesSaveMarkBtn]':{
    	        				  click:function(obj){
    	        					  this.saveIsEvaluationYesMarkGradeTypeBtn(obj,"MARK")
    	        				  }
    	        			  },
    	        			  'editevaluationdetailstructure button[itemId=evaluationYesSaveGradeBtn]':{
    	        				  click:function(obj){
    	        					  this.saveIsEvaluationYesMarkGradeTypeBtn(obj,"GRADE")
    	        				  }
    	        			  },
    	        			  'evaluationassessmentremarkwin[itemId=evaluationassessmentremarkwinId] button[itemId=cancelBtn]':{
    	        				  click:function(obj){
    	        					  obj.up('window').close();
    	        				  }
    	        			  },
    	        			  'evaluationassessmentremarkwin[itemId=evaluationassessmentremarkwinId] button[itemId=submitBtnWin]':{
    	        				  click:function(obj){
    	        					  var me = this;
    	        					  var win = obj.up('window');
    	        					  var newRemark = win.down('#assessmentRemark').getValue();
    	        					  var grid = me.getContentPanel().getActiveTab().down('#'+win.gridItemId);
    	        					  var selectedRecords = grid.getSelectionModel().getSelection();
    	        					  Ext.each(selectedRecords, function(currentRecord){
    	        						  currentRecord.set('remarks',newRemark);
    	        					  });
    	        					  showSuccessMessage(getExaminationTranslation('REMARK'), getCommonTranslation('SUCCESS'));
    	        					  win.close();
    	        				  }
    	        			  },
    	        			  'evaluationdetailsform button[itemId=courseQuickSearchId]':{
    	        				  click: function() {
    	        					  this.searchAssesmentDetailFilter();
    	        				  }
    	        			  },
	                	 });
	                 },
	                 closeEditEvaluationTab: function(grid){
	                	 var $this = this;
	                	 var contentPanel =grid.up('homeworkstructure'); //get hold of the content panel where we are adding all the tabs
	                	 var tabName = getProgramandcourseTranslation('EDIT_ASSESSMENTS');
	                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	 var getTab=getcontroller.getInnerTab(contentPanel,tabName);
	                	 if(getTab!=null){
	                		 contentPanel.remove(getTab, true);
	                	 }
	                 },
	                 showEvaluationDetails:function(){
	                	 var $this = this;
	                	 var forms = $this.getAssignmentdetails();
	                	 var formWindow = $this.getEvaluationdetails();
	                	 if (!formWindow) {
	                		 Ext.widget('evaluationdetails');
	                		 formWindow = $this.getEvaluationdetails();
	                	 }
	                	 formWindow.show();

	                 },
	                 editEvaluationDetailsNew:function(){ 
	                	 var $this = this
	                	 var grid = this.getEvaluationdetailsgrid();
	                	 if(grid.isVisible()==false){
	                		 var grid=this.getEvaluationdetailsgridnew();
	                	 }
	                	 var portalId = $this.getCurrentLoggedPortalId();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                		 var groupName = selectedRecord.raw.groupName;
	                		 var whetherGroupLeader = selectedRecord.raw.whetherGroupLeader;
	                		 var id = selectedRecord.data.id;
	                		 if(whetherGroupLeader || groupName == null || (portalId != 3)){ // PORTAL ID check for restrict for student can not submit assignment only group lead and faculty can submit assignment
	                			 this.showEvaluationDetails();
	                			 var form = this.getEvaluationDetails();
	                			 var evaluationForm = form.getForm();
                                 var evaluationDetailsGridStructureItemId = this.getContentPanel().getActiveTab().down('#evaluationDetailsGridStructureItemId');
                                 if(!isNullOrEmpty(evaluationDetailsGridStructureItemId.isMarkType) && !isNullOrEmpty(evaluationDetailsGridStructureItemId.maxMarks)){
	                                   var maxMarks = evaluationDetailsGridStructureItemId.maxMarks;
	                                    evaluationForm.findField('markObtained').maxValue = maxMarks;
                                  }
                                  
	                			 if (selectedRecord != undefined && selectedRecord != "" && selectedRecord != null) {
	                				 var datas;
	                				 Ext.Ajax.request({
	                					 type : 'rest',
	                					 url : SERVERURL.GROUP_HW_ASSIGNMENT_FIND_BY_ID,
	                					 params : {
	                						 id : id
	                					 },
	                					 method : 'GET',
	                					 success : function(response) {
	                						 datas = Ext.decode(response.responseText);
	                						 console.log('datas..',datas);

	                						 if(selectedRecord.data.studentId==datas.studentId){
	                							 console.log('hi');
	                							 selectedRecord.set("customData",datas.customData);

	                						 }

	                						 form.loadRecord(selectedRecord);

	                						 var onlineSubmission = form.down("#submissionStatusId");
	                						 onlineSubmission.setValue(selectedRecord.get("submissionStatus"));

	                						 var studentCombo = form.down('#studentName_Id');
	                						 evaluationForm.findField('studentHiddenId').setValue(selectedRecord.data.studentId);
	                						 evaluationForm.findField('studentId').setRawValue(selectedRecord.data.studentName);
	                						 studentCombo.setDisabled(true);


	                						 var submissionStatus = form.down("#submissionStatusId");
	                						 var reSubmissionStatus = form.down("#reSubmissionStatusId");
	                						 var resubmissionDate = form.down("#resubmissionDate");
	                						 var remarksField = evaluationForm.findField('remarks');
	                						 var markObtainedField = evaluationForm.findField('markObtained');

	                						 var resubmissionDateData = selectedRecord.get("resubmissionDate");
	                						 var submissionStatusData = selectedRecord.get("submissionStatus");

	                						 if(datas.remarks !=null){
	                							 remarksField.setValue(datas.remarks);
	                						 }

	                						 if(!isNullOrEmpty(datas.markObtained)){
	                							 markObtainedField.setValue(datas.markObtained);
	                						 }else{
	                							 markObtainedField.setValue(datas.markObtainedField);
	                						 }

	                						 if(submissionStatusData==getCourseTxCommonTranslation('HW_COMPLETED')){
	                							 submissionStatus.setValue(true);
	                							 reSubmissionStatus.setVisible(false);
	                							 resubmissionDate.setVisible(false);
	                							 //submissionStatus.setReadOnly(true);
	                							 resubmissionDate.allowBlank=true;
	                						 }else{
	                							 submissionStatus.setValue(false);
	                							 reSubmissionStatus.items.items[1].setValue(true);
	                							 resubmissionDate.allowBlank=true;
	                						 }

	                						 if(resubmissionDateData){
	                							 reSubmissionStatus.items.items[0].setValue(true);
	                							 reSubmissionStatus.setVisible(true);
	                						 }
	                						 var assignmentForm = $this.getAssignmentdetails().getForm();
	                						 var endDate = assignmentForm.findField('dateSubmitted').getValue();
	                						 form.down("#resubmissionDate").setMinValue(endDate);
	                					 }
	                				 });



	                			 }
	                		 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GROUP_LEAD_ALERT'));
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }},
	                 editEvaluationDetails : function(){
	                	 var $this = this
	                	 var grid = this.getEvaluationdetailsgrid();
	                	 var isEvaluationRequired = grid.up().config.isEvaluationRequired;
        				 if(grid.isVisible()==false){
        					 var grid=this.getEvaluationdetailsgridnew();
        				 }
	                	 var portalId = $this.getCurrentLoggedPortalId();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var gridRecord = grid.getSelectionModel().getSelection();
	                			 var contentPanel = grid.up().up(); //get hold of the content panel where we are adding all the tabs
	                			 var evaluationDetailsGridStructureItemId = $this.getContentPanel().getActiveTab().down('#evaluationDetailsGridStructureItemId');
									var structure = Ext.widget('editevaluationdetailstructure', {
					    				itemId: 'editevaluationdetailstructureItemId',
					    				isMarkType: evaluationDetailsGridStructureItemId.isMarkType,
					    				maxMarks:evaluationDetailsGridStructureItemId.maxMarks
					    			});
									var tabName = getProgramandcourseTranslation('EDIT_ASSESSMENTS');
									var getcontroller=$this.getController('menu.CoreERPNavigationController');
									var getTab = null;
									for(var i =0 ;i<contentPanel.items.length;i++){
										if(contentPanel.items.items[i].title == getProgramandcourseTranslation('EDIT_ASSESSMENTS')){
											getTab= contentPanel.items.items[i];
										}
									}
									if(getTab!=null){
										contentPanel.remove(getTab, true);
									}
									openTab(contentPanel, tabName, structure);
	                			 
									var markDetailFormEvaluationRequired = structure.down('#markDetailFormEvaluationRequired');
									var gradeDetailFormEvaluationRequired = structure.down('#gradeDetailFormEvaluationRequired');
									
									var isEvaluationNoMarkTypeMarkEntryGridItemId = structure.down('#isEvaluationNoMarkTypeMarkEntryGridItemId');
									var isEvaluationNoGradeTypeMarkEntryGridItemId = structure.down('#isEvaluationNoGradeTypeMarkEntryGridItemId');
									var isEvaluationYesMarkTypeMarkEntryGridItemId = structure.down('#isEvaluationYesMarkTypeMarkEntryGridItemId');
									var isEvaluationYesGradeTypeMarkEntryGridItemId = structure.down('#isEvaluationYesGradeTypeMarkEntryGridItemId');
									var windowFormNew = '';
									var windowGridNew = '';
									if(isEvaluationRequired){
										markDetailFormEvaluationRequired.setVisible(true);
										gradeDetailFormEvaluationRequired.setVisible(false);
										windowFormNew = markDetailFormEvaluationRequired.getForm();
										
										var markOrGrade = gridRecord[0].get('marksOrGrade');
										var markGradeValue=structure.down('#marksOrGrade');
										markGradeValue.setValue(markOrGrade);
										
										isEvaluationNoMarkTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationNoGradeTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationYesMarkTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationYesGradeTypeMarkEntryGridItemId.setVisible(false);
										if(markOrGrade=='GRADE') {
											isEvaluationYesGradeTypeMarkEntryGridItemId.setVisible(true);
											windowGridNew = isEvaluationYesGradeTypeMarkEntryGridItemId;
										}else{
											isEvaluationYesMarkTypeMarkEntryGridItemId.setVisible(true);
											windowGridNew = isEvaluationYesMarkTypeMarkEntryGridItemId;
										}
										

										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_GRADE_TYPE_BY_EVAL_SEQ_DETAIL,
											method: 'GET',
											params:{
												evalSeqDetailId:gridRecord[0].data.evaluationSequenceDetailId,
												isDynamicScheme:gridRecord[0].data.isDynamicScheme,
												courseVariantId: gridRecord[0].data.courseVariantId,
												periodId: gridRecord[0].data.periodId
											},
											success: function(obj, action) {
												if(obj.responseText!=""){
													var data = Ext.decode(obj.responseText);

													if(isEvaluationRequired){
														windowFormNew.findField('section').setVisible(false);
														if(data.type=="OTHER"){
															windowFormNew.findField('course').setVisible(false);
															windowFormNew.findField('courseVariant').setVisible(false);
														} else {
															windowFormNew.findField('course').setVisible(true);
															windowFormNew.findField('course').setValue(data.courseName);
															/*if(isNullOrEmpty(courseName)){
						        								windowFormNew.findField('course').setValue(data.courseName);
						        							}else{
						        								windowFormNew.findField('course').setValue(courseName);
						        							}*/
															windowFormNew.findField('courseVariant').setVisible(true);
															windowFormNew.findField('courseVariant').setValue(gridRecord[0].data.courseVariantCode);
														}

														windowFormNew.findField('evalPlanNo').setValue(data.evaluationPlanNumber);

														windowFormNew.findField('detailSequence').setValue(data.eventName);
														windowFormNew.findField('minPassMarks').setValue(data.minMarks);
														windowFormNew.findField('maxMarks').setValue(data.maxMarks);
														windowFormNew.findField('weightage').setValue(data.weightage);
														if(!isNullOrEmpty(data.userDefinedWeighting)){
															windowFormNew.findField('weightage').setValue(data.userDefinedWeighting);
															windowFormNew.findField('effectiveWeightage').setValue(data.weightage);
														}else{
															windowFormNew.findField('effectiveWeightage').setValue(data.weightage);
														}

														if(data.evalInMarksOrGrade=='GRADE'){
															windowFormNew.findField('minPassMarks').setFieldLabel('<b>'+getExaminationTranslation('MIN_PASSING_GRADE')+'</b>');
															windowFormNew.findField('maxMarks').setFieldLabel('<b>'+getExaminationTranslation('MAX_GRADE')+'</b>');

															windowFormNew.findField('minPassMarks').setValue(data.minGrade);
															windowFormNew.findField('maxMarks').setValue(data.maxGrade);
														}

														if(data.evalInMarksOrGrade=='GRADE' && data.gradeType!=null){
															var gradeStore=$this.getStore('gradeMaster.GradeGroupMapping');
															gradeStore.getProxy().extraParams = {
						        								gradeType:data.gradeType,
						        								evaluationDetailSequneceId:gridRecord[0].data.evaluationSequenceDetailId
						        							};
						        							gradeStore.load();
														}	
													}
													var windowGridArray=[];
													Ext.Array.each(gridRecord, function(student) {
														if(student.data.whetherExamAttended) {
															var data={
																	"id":student.data.id,
																	"evaluationSequenceDetailId":student.data.evaluationSequenceDetailId,
																	"admissionId":student.data.admissionId,
																	"admissionCode":student.data.admissionCode,
																	"studentName":student.data.studentName,
																	"firstName":student.data.firstName,
																	"middleName":student.data.middleName,
																	"lastName":student.data.lastName,
																	"finalMarks":student.data.finalMarks,
																	"markObtained":student.data.finalMarks,
																	"finalDescription":student.data.finalDescription,
																	"examResultStatus":student.data.examResultStatus,
																	"whetherMalpracticeReported":student.data.whetherMalpracticeReported,
																	"whetherRevaluation":student.data.whetherRevaluation,
																	"totalMarks":student.data.totalMarksGiven,
																	"graceMarks":student.data.graceMarksGiven,
																	"penaltyMarks":student.data.penultyMarksGiven,
																	"sectionId":student.data.sectionId,
																	"courseVariantId":student.data.courseVariantId,
																	"examUniqueCode":student.data.examUniqueCode,
																	"studentId":student.data.studentId,
																	"periodId":student.data.periodId,
																	"gradePoints":student.data.gradePoints,
																	"isDynamicScheme":student.data.isDynamicScheme,
																	"whetherPublish":student.data.whetherPublish,
																	"isResultPublish":student.data.isResultPublish,
																	"resultPublishMode":student.data.resultPublishMode,
																	"groupAssignmentId":student.data.groupAssignmentId,
																	"remarks":student.data.remarks,
																	"groupName":student.data.groupName,
															};
															windowGridArray.push(data);
														}
													});

													var store = windowGridNew.getStore();
													store.clearFilter();
													store.removeAll();
													store.loadRawData(windowGridArray);

													tempERGStore = Ext.create('Academia.store.coursetransaction.homework.AssessmentEventResultStore');
													tempERGStore.clearFilter();
													tempERGStore.removeAll();
													tempERGStore.loadRawData(windowGridArray);
												}
											}
										});

									} else{
										markDetailFormEvaluationRequired.setVisible(false);
										gradeDetailFormEvaluationRequired.setVisible(true);
										var evaluationDetailsFormFields = grid.up().down('#evaluationDetailsFields');

										var displayfieldprogramCodeAndNameId = evaluationDetailsFormFields.down('#displayfieldprogramCodeAndNameId').getValue();
										var displayfieldProgramGroupId = evaluationDetailsFormFields.down('#displayfieldProgramGroupId').getValue();

										gradeDetailFormEvaluationRequired.down('#displayfieldprogramCodeAndNameId').setValue(displayfieldprogramCodeAndNameId);
										gradeDetailFormEvaluationRequired.down('#displayfieldProgramGroupId').setValue(displayfieldProgramGroupId);

										var markOrGrade = gridRecord[0].get('marksOrGrade');
										var markGradeValue=structure.down('#marksOrGrade');
										markGradeValue.setValue(markOrGrade);
										
										isEvaluationNoMarkTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationNoGradeTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationYesMarkTypeMarkEntryGridItemId.setVisible(false);
										isEvaluationYesGradeTypeMarkEntryGridItemId.setVisible(false);
										if(markOrGrade=='GRADE') {
											isEvaluationNoGradeTypeMarkEntryGridItemId.setVisible(true);
											windowGridNew = isEvaluationNoGradeTypeMarkEntryGridItemId;
										}else{
											isEvaluationNoMarkTypeMarkEntryGridItemId.setVisible(true);
											windowGridNew = isEvaluationNoMarkTypeMarkEntryGridItemId;
										}
										windowFormNew = gradeDetailFormEvaluationRequired.getForm();
										var windowGridArray=[];
										Ext.Array.each(gridRecord, function(student) {
											var markobtain="";
											if(markOrGrade=='GRADE') {
												markobtain=student.data.finalGrade;
											}
											else{
												markobtain=student.data.finalMarks;
											}
											//if(student.data.whetherExamAttended) {
												var data={
														"id":student.data.id,
														"evaluationSequenceDetailId":student.data.evaluationSequenceDetailId,
														"groupName":student.data.groupName,
														"admissionId":student.data.admissionId,
														"admissionCode":student.data.admissionCode,
														"studentName":student.data.studentName,
														"studentCode":student.data.studentCode,
														"marksOrGrade":student.data.marksOrGrade,
														"submissionStatus":student.data.submissionStatus,
														"finalMarks":student.data.finalMarks,
														"markObtained":markobtain,
														"finalDescription":student.data.finalDescription,
														"examResultStatus":student.data.examResultStatus,
														"whetherMalpracticeReported":student.data.whetherMalpracticeReported,
														"whetherRevaluation":student.data.whetherRevaluation,
														"totalMarks":student.data.totalMarksGiven,
														"graceMarks":student.data.graceMarksGiven,
														"penaltyMarks":student.data.penultyMarksGiven,
														"sectionId":student.data.sectionId,
														"courseVariantId":student.data.courseVariantId,
														"examUniqueCode":student.data.examUniqueCode,
														"studentId":student.data.studentId,
														"periodId":student.data.periodId,
														"gradePoint":student.data.gradePoints,
														"isDynamicScheme":student.data.isDynamicScheme,
														"whetherPublish":student.data.whetherPublish,
														"isResultPublish":student.data.isResultPublish,
														"resultPublishMode":student.data.resultPublishMode,
														"remarks":student.data.remarks,
																									};
												windowGridArray.push(data);
											//}
										});

										var store = windowGridNew.getStore();
										store.clearFilter();
										store.removeAll();
										store.loadRawData(windowGridArray);

										tempERGStore = Ext.create('Academia.store.coursetransaction.homework.AssessmentEventResultStore');
										tempERGStore.clearFilter();
										tempERGStore.removeAll();
										tempERGStore.loadRawData(windowGridArray);
									}
									
									
									
	                		/*// PORTAL ID check for restrict for student can not submit assignment only group lead and faculty can submit assignment
	                			 this.showEvaluationDetails();
	                			 var form = this.getEvaluationDetails();
	                			 var evaluationForm = form.getForm();
	                			 
	                			 if (selectedRecord != undefined && selectedRecord != "" && selectedRecord != null) {
	                				 var datas;
	    		                	 Ext.Ajax.request({
	    		                		 type : 'rest',
	    		                		 url : SERVERURL.GROUP_HW_ASSIGNMENT_FIND_BY_ID,
	    		                		 params : {
	    		                			 id : id
	    		                		 },
	    		                		 method : 'GET',
	    		                		 success : function(response) {
	    		                			  datas = Ext.decode(response.responseText);
	    		                			 console.log('datas..',datas);
	    	   	        						
	    	   	        							if(selectedRecord.data.studentId==datas.studentId){
	    	   	        								console.log('hi');
	    	   	        								selectedRecord.set("customData",datas.customData);
	    	   	        								    
	    	   	        								  }
	    		                			 
	    		                			 form.loadRecord(selectedRecord);
	    		                			 
	    		                			 var onlineSubmission = form.down("#submissionStatusId");
	    	                				 onlineSubmission.setValue(selectedRecord.get("submissionStatus"));

	    	                				 var studentCombo = form.down('#studentName_Id');
	    	                				 evaluationForm.findField('studentHiddenId').setValue(selectedRecord.data.studentId);
	    	                				 evaluationForm.findField('studentId').setRawValue(selectedRecord.data.studentName);
	    	                				 studentCombo.setDisabled(true);


	    	                				 var submissionStatus = form.down("#submissionStatusId");
	    	                				 var reSubmissionStatus = form.down("#reSubmissionStatusId");
	    	                				 var resubmissionDate = form.down("#resubmissionDate");
	    	                				 var remarksField = evaluationForm.findField('remarks');
	    	                				 var markObtainedField = evaluationForm.findField('markObtained');
	    	                				 
	    	                				 var resubmissionDateData = selectedRecord.get("resubmissionDate");
	    	                				 var submissionStatusData = selectedRecord.get("submissionStatus");
	    	                				 
	    	                				 if(datas.remarks !=null){
	    	                					 remarksField.setValue(datas.remarks);
	    	                				 }
	    	                				 
	    	                				 if(!isNullOrEmpty(datas.markObtained)){
	    	                					 markObtainedField.setValue(datas.markObtained);
	    	                				 }else{
	    	                					 markObtainedField.setValue(datas.markObtainedField);
	    	                				 }
	    	                				 
	    	                				 if(submissionStatusData==getCourseTxCommonTranslation('HW_COMPLETED')){
	    	                					 submissionStatus.setValue(true);
	    	                					 reSubmissionStatus.setVisible(false);
	    	                					 resubmissionDate.setVisible(false);
	    	                					 //submissionStatus.setReadOnly(true);
	    	                					 resubmissionDate.allowBlank=true;
	    	                				 }else{
	    	                					 submissionStatus.setValue(false);
	    	                					 reSubmissionStatus.items.items[1].setValue(true);
	    	                					 resubmissionDate.allowBlank=true;
	    	                				 }

	    	                				 if(resubmissionDateData){
	    	                					 reSubmissionStatus.items.items[0].setValue(true);
	    	                					 reSubmissionStatus.setVisible(true);
	    	                				 }
	    	                				 var assignmentForm = $this.getAssignmentdetails().getForm();
	    	                				 var endDate = assignmentForm.findField('dateSubmitted').getValue();
	    	                				 form.down("#resubmissionDate").setMinValue(endDate);
	    		                		 }
	    		                	 });
	                				 
	                				
	                				
	                			 }
	                		 */
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 
	                 /*getCustomDataById:function(id){
	                	 var $this = this;
	                	 var data;
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : SERVERURL.GROUP_HW_ASSIGNMENT_FIND_BY_ID,
	                		 params : {
	                			 id : id
	                		 },
	                		 method : 'GET',
	                		 success : function(response) {
	                			  data = Ext.decode(response.responseText);
	                			 console.log('data..',data)
	                			
	                		 }
	                	 });
	                	 return data.customData;
	                 },*/
	                 addEvauationDetails:function(){
	                	 var $this = this;
	                	 var evaluationForm = $this.getEvaluationDetails().getForm();
	                	 var values = evaluationForm.getValues();
	                	 var studentId = evaluationForm.findField('studentHiddenId').getValue();
	                	 //var hwfile = evaluationForm.findField('hwfile').getValue();
	                	  var markObtain=parseFloat(values.markObtained);
	                	 var assignmentdetailsForm = this.getAssignmentdetails().getForm();
	                	 var assignmentId = assignmentdetailsForm.findField('responseId').getValue();

	                	 var studentComboBox = this.getEvaluationdetails().down('customcombobox#studentName_Id');
	                	 var studentStore = studentComboBox.getStore();
	                	 var students = studentStore.data.items; 

	                	 var evaluationStore = this.getEvaluationdetailsgrid().getStore();
        				 if(this.getEvaluationdetailsgrid().isVisible()==false){
        					 var evaluationStore=this.getEvaluationdetailsgridnew().getStore();
        				 }

	                	 var evaluationSubmission =[];

	                	 if(evaluationForm.findField('groupName').isHidden()){
	                		 var gridRecord = evaluationStore.findRecord('studentId',values.studentId);
	                		 evaluationSubmission.push({	
	                			 "id":values.id,
	                			 "studentId":studentId,
	                			 "resubmissionDate":isNullOrEmpty(values.resubmissionDate)?values.resubmissionDate:values.resubmissionDate+" 00:00 AM",
	                			 "submissionDate":values.submissionDate,
	                			 "submissionStatus":values.submissionStatus,
	                			 "remarks":values.remarks,
	                			 "markObtained":markObtain,
	                			 "gradeObtained":values.gradeObtained,
	                			 "courseHomeWorkAssignmentId":assignmentId,
	                			 "whetherGroupLeader":false,
	                			 "customData":values.customData
	                		 });
	                	 }else{
	                		 for(var i=0;i<students.length;i++){
	                			 var gridRecord = evaluationStore.findRecord('studentId',students[i].data.id);
	                			 evaluationSubmission.push({	
	                				 "id":gridRecord.data.id,
	                				 "studentId":students[i].data.id,
	                				 "groupName":values.groupName,
	                				 "resubmissionDate":values.resubmissionDate,
	                				 "submissionDate":values.submissionDate,
	                				 "submissionStatus":values.submissionStatus,
	                				 "remarks":values.remarks,
	                				 "markObtained":markObtain,
	                				 "gradeObtained":values.gradeObtained,
	                				 "courseHomeWorkAssignmentId":assignmentId,
	                				 "whetherGroupLeader":false,
	                				 "remarks": values.remarks,
	                				 "markesGrade": null,
	                				 "customData":values.customData
	                			 });	
	                		 }
	                	 }
	                	 var submitUrl= SERVERURL.HW_SUMBMISSION_UPDATE;
	                	 $this.applyWindowMask(); 
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : evaluationSubmission,
	                		 method : 'POST',
	                		 success : function(form, action) {
	                			 $this.hideWindowMask();
	                			 showSuccessMessage(getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'),getCommonTranslation('SUCCESS'));
	                			 $this.getEvaluationdetailsgrid().getStore().load();
	                			 if($this.getEvaluationdetailsgrid().isVisible()==false){
	                				 $this.getEvaluationdetailsgridnew().getStore().load();
	            				 }
	                			 $this.getSubmissiondetailsgrid().getStore().load();
	                			 if($this.getSubmissiondetailsgrid().isVisible()==false){
	                				 $this.getSubmissiondetailsgridnew().getStore().load();
	            				 }
	                			/* var store = $this.getStore('coursetransaction.homework.submissiondetails.SubmissionDetailsGrid');
	                			 store.load();*/
	                			 $this.getEvaluationdetails().close();
	                		 }
	                	 });
	                 },
	                 evaluationDocumentUpload:function(){
	                	 var grid = this.getEvaluationdetailsgrid();
	                	 if(grid.isVisible()==false){
        					 var grid=this.getEvaluationdetailsgridnew();
        				 }
	                	 var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                	 
	                	 if((grid.getSelectionModel().getCount()>0)){
	                		/* if(selectedRecord.data.documents.length < 1){
	                			 this.getDocumentController().showDocumentFormWindow('evaluationDocItemId', 'DOCUMENT');
	                		 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('DOC_EXISTS')); 
	                		 }*/
	                		 if(selectedRecord.data.hwonlineSubmission){
	                			 this.getDocumentController().showDocumentFormWindow('evaluationDocItemId', 'DOCUMENT');
	                		 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ONLINE_DOC_SUBMISSION')); 
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	                	 }
	                 },
	                 getDocumentController : function() {
                		 var this$ = this;
                		 return this$.getController('Academia.controller.document.DocumentController');
                	 },
                	 
                	// ********* Hide  more Action and upload button *************
             	    disableMoreActionSequencePivileges: function(gridReference,permissionsMap) {
             	    	var associatedAcadLocationIds = new Array();
             	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
             	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
             	    	/*buttonsToolBar = gridReference.query('toolbar')[0];
             	    	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
             	    	splitbuttons.setVisible(false);
             	    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
             	    		menuItems.setVisible(false);
             	    	});*/
             	    	var uploadDocument = gridReference.down('#evaluationUploadDocument');
            	    	uploadDocument.setVisible(false);
             	    	Ext.each(permissionList, function(privilege) {
             	    		/*if (privilege === 'MOREACTIONS') {
             	    			var button = buttonsToolBar.query('#spBtnMoreActions')[0];
             	    			if(!isNullOrEmpty(button)){
             	    				button.setVisible(true);
             	    			}        		
             	    		}*/
             	    		if (privilege === 'UPLOAD_DOCUMENT') {
             	    			if(!isNullOrEmpty(uploadDocument)){
             	    				uploadDocument.setVisible(true);
             	    			}        		
             	    		}
             	    	
             	    	});
             	    }, 
                	 /**
       			   *  for upload document
       			   */
       		    getUploadDocument : function(){
       		    	var $this=this;
       		    	var grid = this.getEvaluationdetailsgrid();
       		    	if(grid.isVisible()==false){
       		    		var grid=this.getEvaluationdetailsgridnew();
       		    	}
       		    	var isTransient = true;
       		    	var module = 'homeworkEvaluation';
       		    	var entityId ;
       		    	var entityType = 'homeworkEvaluation';

       		    	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){

       		    		if (grid.getSelectionModel().getCount() > 0) {
       		    			var record = grid.getSelectionModel().getSelection()[0];
       		    			var id = record.get("id");
       		    			var data = {
       	    			    "id": id,
       	    			    "docType": "EVALUATED_DOC",
       	    			    "documents": [
       	    			            {
       	    			            //"createdBy": $this.getIdValueJson(response.createdBy.id),
       	    			            "name": response.name,
       	    			            "path": response.path,
       	    			            "type": response.type
       	    			        }
       	    			    ]
       	    			};
       		    			
       		    			
       		    			Ext.Ajax.request({
           						type : 'rest',
           						url : SERVERURL.HW_SUMBMISSION_DOC_UPLOAD,
           						jsonData : data,
           						method : 'POST',
           						success : function(response, action) {
           							showSuccessMessage(getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
           							grid.getStore().load();
           							grid.getSelectionModel().deselectAll(true);
           						}
           					});	
       		    			
       		    			
       		    		}
       		    		$this.getDocumentController().closeDocumentFormWindow();
       		    	}, isTransient);
       		    },
       		    
       		    searchAssesmentDetailFilter : function(){
       		    	var me = this;
       		    	var form = me.getEvaluationdetailsform();
       		    	var formValues = form.getValues();
       		    	var portalId = me.getCurrentLoggedPortalId();
       		    	var courseHomeWorkAssignmentId = form.config.hwAssignmentId;
       		    	var courseVariantIds = form.config.CourseVariantIDs;
       		    	var grid = me.getEvaluationdetailsgrid();
       		    	var store = grid.getStore();
       		    	store.getProxy().actionMethods.read = 'GET';
       		    	store.getProxy().api.read = SERVERURL.PATH_FIND_BY_HW_ASSESSMENT_ID_AND_AE_ID;
       		    	store.removeAll();
       		    	store.getProxy().extraParams = {
       		    		evalSeqDetailId : formValues.evaludationDetailSequenceId,
       		    		hwAssignmentId:courseHomeWorkAssignmentId,
       		    		courseVariantId: courseVariantIds.join(),
       		    		whetherExamAttended:true,
       		    		whetherEvalAnonymous:false,
       		    		portalId:portalId
       		    	};
       		    	store.load({
       		    		callback:function(record) {
       		    			if(portalId==2) {
       		    				var examResultStatus=false;
       		    				/*if(grid.down('#btnEdit').isVisible()) {
        		        		    		  grid.down('#btnEdit').setDisabled(false);
        			        		    	  for(var i in record) {
        			        	        		  if(isNullOrEmpty(record[i].data.examResultStatus)) {
        				        	        		 examResultStatus=true;
        			        	        		  }
        			                		  }
        			        		    	  if(!examResultStatus) {
        			        		    		  grid.down('#btnEdit').setDisabled(true);
        			        		    	  }
        		        		    	  }*/
       		    				if(grid.down('#btnEdit').isVisible()) {
       		    					grid.down('#btnEdit').setDisabled(false);
       		    					for(var i in record) {
       		    						if(isNullOrEmpty(record[i].data.examResultStatus)) {
       		    							examResultStatus=true;
       		    						}
       		    					}
       		    					if(!examResultStatus) {
       		    						grid.down('#btnEdit').setDisabled(true);
       		    					}
       		    				}
       		    			}
       		    			grid.getSelectionModel().deselectAll();
       		    			if(record.length != 0) {
       		    				if(record[0].data.isDynamicScheme && record[0].data.dynamicEventStatus!=
       		    					getExaminationTranslation('CNTRL_CONDUCTED')){
       		    					grid.down('#btnEdit').setVisible(false);
       		    					grid.down('#btnDelete').setVisible(false);
       		    				} else if(!(record[0].data.isDynamicScheme) && record[0].data.eventStatus!=
       		    					getExaminationTranslation('CNTRL_CONDUCTED')) {
       		    					grid.down('#btnEdit').setVisible(false);
       		    					grid.down('#btnDelete').setVisible(false);
       		    				}else{
       		    					if(grid.down('#btnEdit').isVisible() && grid.down('#btnDelete').isVisible()) {
       		    					if(portalId == 1){
       		        		    		me.doAccessControlValidation(grid, me.getHOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PERMISSIONS());
       		        		    	}else if(portalId == 2){
       		        		    		me.doAccessControlValidation(grid, me.getHOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES());
       		        		    	}
       		    				}
       		    				}
       		    			}
       		    		}});
       		    },
       		 saveDefaultMarkGradeForHomeworkAssignment:function(button){
       		    	var $this=this;
       		    	var grid=null;
       		    	var structure = this.getEditevaluationdetailstructure();
       		    	var formWindow = $this.getMarkentrydefaultmarkgradewindow();
       		    	var getMarkOrGrade=structure.down('#marksOrGrade').getValue();
       		    	var evalGrid = this.getEvaluationdetailsgrid();
       		    	var isEvaluationRequired = evalGrid.up().config.isEvaluationRequired;
       		    	if(getMarkOrGrade=="MARK"){
       		    		if(isEvaluationRequired) {
       		    			grid=structure.down('#isEvaluationYesMarkTypeMarkEntryGridItemId');
       		    			var gridRecord=grid.getSelectionModel().getSelection();
       		    			var getDefaultValue=formWindow.down('#defaultTotalMarks').getValue();
       		    			Ext.Array.each(gridRecord, function(currentRecord) {
       		    				//currentRecord.set('totalMarks',getDefaultValue);
    		        				currentRecord.data.totalMarks = getDefaultValue;
    		        				currentRecord.modified = {};
    		        				currentRecord.dirty = false;
       		    			});
       		    		}else{
       		    			grid=structure.down('#isEvaluationNoMarkTypeMarkEntryGridItemId');
       		    			var gridRecord=grid.getSelectionModel().getSelection();
       		    			var getDefaultValue=formWindow.down('#defaultTotalMarks').getValue();
       		    			Ext.Array.each(gridRecord, function(currentRecord) {
       		    				currentRecord.set('markObtained',getDefaultValue);
       		    			});
       		    		}
       		    		grid.getView().refreshView();
       		    		formWindow.close();
       		    	}else{
       		    		try{
       		    			if(isEvaluationRequired) {
       		    				grid=structure.down('#isEvaluationYesGradeTypeMarkEntryGridItemId');
       		    				var gridRecord=grid.getSelectionModel().getSelection();
       		    				var gradeData=formWindow.down('#defaultFinalGrade').getValue();
       		    				Ext.Array.each(gridRecord, function(currentRecord) {
       		    					currentRecord.set("finalGrade",gradeData);
       		    				});
       		    			} else {
       		    				grid=structure.down('#isEvaluationNoGradeTypeMarkEntryGridItemId');
       		    				var gridRecord=grid.getSelectionModel().getSelection();
       		    				if(!isNullOrEmpty(structure.maxMarks)){
       		    					var gradeData=formWindow.down('#textGradeItemId1').getValue();
       		    				}
       		    				else{
       		    					var gradeData=formWindow.down('#textGradeItemId').getValue();
       		    				}
       		    				Ext.Array.each(gridRecord, function(currentRecord) {
       		    					currentRecord.set("markObtained",gradeData);
       		    				});
       		    			}
       		    		}
       		    		catch(e){}
       		    		/*Ext.Array.each(gridRecord, function(currentRecord) {
       		    			currentRecord.data.finalGrade = getDefaultGrade;
       		    			currentRecord.modified = {};
       		    			currentRecord.dirty = false;
       		    		});*/
       		    		grid.getView().refreshView();
       		    		formWindow.close();
       		    	}
       		    },
       		    deleteGroupHomeworkAssignment:function(grid){
       		    	var me=this;
       		    	var isEvaluationRequired = grid.up().config.isEvaluationRequired;
       		    	if (grid.getSelectionModel().getCount() > 0) {
       		    		var gridRecord = grid.getSelectionModel().getSelection();
       		    		showConfirmMessage(getCommonTranslation('ASSESSMENT_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
       		    				function(btn, text) {
       		    			if (btn == 'yes') {
       		    				var ids =[];
       		    				if(isEvaluationRequired){
       		    					Ext.Array.each(gridRecord, function(student) {
           		    					ids.push(student.data.id);
           		    				});
       		    				}else{
       		    					Ext.Array.each(gridRecord, function(student) {
           		    					ids.push(student.data.id);
           		    				});
       		    				}
       		    				
       		    				Ext.Ajax.request({
       		    					method: "DELETE",
       		    					type: 'rest',
       		    					url: SERVERURL.PATH_HW_ASSESSMENT_DELETE_ALL + '?groupHWAssignmentIds=' + ids.join()+'&isEvaluationRequired='+isEvaluationRequired ,
       		    					headers : {
       		    						'Content-Type' : 'application/json'
       		    					},
       		    					success: function(form, action) {
       		    						grid.store.reload();
       		    						showSuccessMessage(getCommonTranslation('ASSESSMENT_DETAILS'), getProgramandcourseTranslation('HW_ASSIGNMENT_DETAILS_DELETE_SUCCESS'));
       		    						me.closeEditEvaluationTab(grid);
       		    					}
       		    				});
       		    			}

       		    		});
       		    	} else {
       		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
       		    	}

       		    }, 
		  		  saveIsEvaluationYesMarkGradeTypeBtn:function(obj,type){
					  var me = this;
					  var isAllFilled=true;
					  //var grid=obj.up('grid');
					  var grid=null;
					  if(type=="MARK"){
						  grid=me.getEditevaluationdetailstructure().down('#isEvaluationYesMarkTypeMarkEntryGridItemId');
					  }else{
						  grid=me.getEditevaluationdetailstructure().down('#isEvaluationYesGradeTypeMarkEntryGridItemId');  
					  }
					  if(grid.getSelectionModel().getCount()>0){
						  var assignmentdetailsForm = me.getAssignmentdetails().getForm();
						  var assignmentId = assignmentdetailsForm.findField('responseId').getValue();
						  var masterGrid = me.getEvaluationdetailsgrid();
						  var masterRecords=masterGrid.getStore().data.items;
						  var studentStore = grid.getStore();
						  var gridRecord = grid.getSelectionModel().getSelection();
						  var students = studentStore.data.items; 


						  var gradeDetailFormEvaluationRequired = grid.up('editevaluationdetailstructure').down('#markDetailFormEvaluationRequired');
						  var windowForm=gradeDetailFormEvaluationRequired.getForm();

						  var jsonData=[];
						  var isResultPublishYes = [];
						  var isResultPublishNo = [];
						  var evaluationSubmission =[];
						  var isResultPublish=false;
						  if(!isNullOrEmpty(gridRecord[0].data.isResultPublish) && 
								  gridRecord[0].data.isResultPublish && 
								  (gridRecord[0].data.resultPublishMode!='DO_NOT_PUBLISH'
									  && gridRecord[0].data.resultPublishMode!='AUTO_PUBLISH')){
							  isResultPublish=true;
						  }

						  if(masterRecords[0].data.marksOrGrade=='MARK'){
							  for(var i=0;i<masterRecords.length;i++){
								  if(isNullOrEmpty(masterRecords[i].data.finalMarks) && 
										  masterRecords[i].data.whetherExamAttended){
									  isResultPublish=false;
								  }
							  }
						  } else{
							  for(var i=0;i<masterRecords.length;i++){
								  if(isNullOrEmpty(masterRecords[i].data.finalGrade) && 
										  masterRecords[i].data.whetherExamAttended){
									  isResultPublish=false;
								  }
							  }	
						  }

						  Ext.Array.each(gridRecord, function(value) {	
							  if(!isNullOrEmpty(value.data.totalMarks) || !isNullOrEmpty(value.data.finalGrade)) {
								  var effectiveMarks=null;
								  var examResultStatusValue=null;
								  var weitage=windowForm.findField('effectiveWeightage').getValue();

								  if(weitage!=null && value.data.finalMarks!=null && value.data.finalMarks>=0){
									  effectiveMarks=(value.data.finalMarks*weitage)/100;
								  }
								 examResultStatusValue="RESULT_ENTERED";
								  var data={
										  "id":value.data.id,
										  "evaluationSequenceDetailId":value.data.evaluationSequenceDetailId,
										  "admissionId":value.data.admissionId,
										  "sectionId":value.data.sectionId,
										  "courseVariantId":value.data.courseVariantId,
										  "totalMarksGiven":value.data.totalMarks,
										  "penultyMarksGiven":value.data.penaltyMarks,
										  "graceMarksGiven":value.data.graceMarks,
										  "finalMarks":value.data.finalMarks,
										  "examResultStatus": examResultStatusValue,
										  "finalGrade":value.data.finalGrade,
										  "gradePoints":isNullOrEmpty(value.data.gradePoints) ? 0:value.data.gradePoints,
										  "finalDescription":value.data.finalDescription,
										  "whetherRevaluation":false,
										  "effectiveMarks":effectiveMarks,
										  "whetherMalpracticeReported":false,
										  "whetherExamAttended":true,
										  "examUniqueCode":value.data.examUniqueCode,
										  "periodId":value.data.periodId,
										  "isDynamicScheme":value.data.isDynamicScheme,
										  "whetherPublish":value.data.whetherPublish,
										  "isResultPublish":value.data.isResultPublish,
								  };

								  isResultPublishYes.push({
									  "levelIds":value.data.id,
									  "isResultPublish":false
								  });
								  isResultPublishNo.push({
									  "levelIds":value.data.id,
									  "isResultPublish":true
								  });
								  jsonData.push(data);
								 
  		                			var groupAssignMentdata={	
	        		                				 "id":value.data.groupAssignmentId,
	        		                				 "studentId":value.data.admissionId,
	        		                				 "groupName":value.data.groupName,
	        		                				 "resubmissionDate":null,
	        		                				 "submissionDate":null,
	        		                				 "submissionStatus":null,
	        		                				 "remarks":value.data.remarks,
	        		                				 "markObtained":null,
	        		                				 "gradeObtained":null,
	        		                				 "courseHomeWorkAssignmentId":assignmentId,
	        		                				 "whetherGroupLeader":false,
	        		                				 "markesGrade": null
	        		                				 //"customData":[]
	        		                			 };
											evaluationSubmission.push(groupAssignMentdata);

							  } else {
								  isAllFilled=false;
							  }
						  });

						  if(isAllFilled) {
							  Ext.Ajax.request({
								  type: 'rest',
								  url: SERVERURL.PATH_SAVE_MARKENTRY_FOR_STUDENT,
								  jsonData: jsonData,
								  method: 'POST',
								  success: function(obj, action) {
									  Ext.getBody().unmask();
									  var trigger=false;
									  if(obj.responseText!=""){
										  showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS')); 
										  var submitUrl= SERVERURL.HW_SUMBMISSION_UPDATE;
  	        		                	// me.applyWindowMask(); 
  	        		                	 Ext.Ajax.request({
  	        		                		 type : 'rest',
  	        		                		 url : submitUrl,
  	        		                		 jsonData : evaluationSubmission,
  	        		                		 method : 'POST',
  	        		                		 success : function(form, action) {
  	        		                			 
  	        		                		 }
  	        		                		 });
  	        		                	 	me.makeMaxMarksReadOnly();
										  me.closeEditEvaluationTab(grid);
										  me.searchAssesmentDetailFilter();
										  //$this.loadResultGridData(detailSequenceVal,courseVariantIdValue);
									  }
								  }
							  });
						  } else {
							  Ext.getBody().unmask();
							  showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('PLEASE_FILL_ALL_MARK_GRADE_ENTRY'));
							  return;
						  }
					  }else{
						  showWarningMessage(getExaminationTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					  }
				  
		  		  },
		  		  saveIsEvaluationNoMarkGradeTypeBtn:function(obj,type){
					  var me = this;
					  //var grid=obj.up('grid');
					  var grid=null;
					  if(type=="MARK"){
						  grid=me.getEditevaluationdetailstructure().down('#isEvaluationNoMarkTypeMarkEntryGridItemId');
					  }else{
						  grid=me.getEditevaluationdetailstructure().down('#isEvaluationNoGradeTypeMarkEntryGridItemId');
					  }
					  if(grid.getSelectionModel().getCount()>0){
		                	 var assignmentdetailsForm = me.getAssignmentdetails().getForm();
		                	 var assignmentId = assignmentdetailsForm.findField('responseId').getValue();

		                	 var studentStore = grid.getStore();
		                	 var gridRecord = grid.getSelectionModel().getSelection();
		                	 var students = studentStore.data.items; 

		                	/* var evaluationStore = this.getEvaluationdetailsgrid().getStore();
	        				 if(this.getEvaluationdetailsgrid().isVisible()==false){
	        					 var evaluationStore=this.getEvaluationdetailsgridnew().getStore();
	        				 }*/
		                	 var evaluationSubmission =[];
		                		Ext.Array.each(gridRecord, function(student) {
										var data={	
        		                				 "id":student.data.id,
        		                				 "studentId":student.data.studentId,
        		                				 "groupName":student.data.groupName,
        		                				 "resubmissionDate":null,
        		                				 "submissionDate":null,
        		                				 "submissionStatus":null,
        		                				 "remarks":student.data.remarks,
        		                				 "markObtained":student.data.marksOrGrade=="GRADE" ? null : student.data.markObtained,
        		                				 "gradeObtained":student.data.marksOrGrade=="MARK" ? null : student.data.markObtained,
        		                				 "courseHomeWorkAssignmentId":assignmentId,
        		                				 "whetherGroupLeader":false,
        		                				 "remarks": student.data.remarks,
        		                				 "markesGrade": null
        		                				 //"customData":[]
        		                			 };
										evaluationSubmission.push(data);
									
								});
		                	 var submitUrl= SERVERURL.HW_SUMBMISSION_UPDATE;
		                	// me.applyWindowMask(); 
		                	 Ext.Ajax.request({
		                		 type : 'rest',
		                		 url : submitUrl,
		                		 jsonData : evaluationSubmission,
		                		 method : 'POST',
		                		 success : function(form, action) {
		                			 Ext.getBody().unmask();
		                			 showSuccessMessage(getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'),getCommonTranslation('SUCCESS'));
		                			 me.makeMaxMarksReadOnly();
		                			 me.closeEditEvaluationTab(grid);
		                			 /* $this.getEvaluationdetailsgrid().getStore().load();
		                			 if($this.getEvaluationdetailsgrid().isVisible()==false){
		                				 $this.getEvaluationdetailsgridnew().getStore().load();
		            				 }
		                			 $this.getSubmissiondetailsgrid().getStore().load();
		                			 if($this.getSubmissiondetailsgrid().isVisible()==false){
		                				 $this.getSubmissiondetailsgridnew().getStore().load();
		            				 }*/
		                			/* var store = $this.getStore('coursetransaction.homework.submissiondetails.SubmissionDetailsGrid');
		                			 store.load();*/
		                			// $this.getEvaluationdetails().close();
		                		 }
		                	 });
		                 }else{
						  showWarningMessage(getExaminationTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					  }
				  
		  		  },
		  		 openEnterRemarkScreen: function(obj){
					  var me = this;
					  var grid=obj.up('grid');
					  if(grid.getSelectionModel().getCount()>0){
						  var formWindow = this.getEvaluationassessmentremarkwin();
						  if (!formWindow) {
							  Ext.widget('evaluationassessmentremarkwin',{
								  gridItemId: grid.itemId,
								  itemId: 'evaluationassessmentremarkwinId'
							  });
							  formWindow = this.getEvaluationassessmentremarkwin();
						  }
						  formWindow.show();  
					  }else{
						  showWarningMessage(getExaminationTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					  }
				  
		  		  },
		  		restGridItems: function(button){
		  			  var $this=this;
			        	var grid=button.up('grid');
			        	if (grid.getSelectionModel().getCount() > 0) {
			        		var gridRecord=grid.getSelectionModel().getSelection();

			        		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			        		Ext.Array.each(gridRecord, function(currentRecord) {
			        			var oldRecord = tempERGStore.findRecord('id',currentRecord.data.id);
		        				
		        				var oldRecordData = Object.assign({},oldRecord.data); //assigning values without reference
		        				var oldRecordRaw = Object.assign({},oldRecord.raw); //assigning values without reference
		        				
		        				currentRecord.data = oldRecordData;
		        				currentRecord.raw = oldRecordRaw;
		        				currentRecord.modified = {};
		        				currentRecord.dirty = false;
			        		});
			        		grid.getView().refreshView();
			        		Ext.getBody().unmask();
			        	}else{
			        		Ext.getBody().unmask();
			        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
			        	}
			        
		  		  },
		  		disableEditEvaluationDetailStructurePivileges:function(editevaluationdetailstructure,permissionsMap){
               	 var associatedAcadLocationIds = new Array();
            	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
            	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

            	 var evaluationNoMarkEnterRemarkBtn=editevaluationdetailstructure.down('#evaluationNoMarkEnterRemarkBtn');
				 var evaluationNoGradeEnterRemarkBtn=editevaluationdetailstructure.down('#evaluationNoGradeEnterRemarkBtn');
				 var evaluationYesMarkEnterRemarkBtn=editevaluationdetailstructure.down('#evaluationYesMarkEnterRemarkBtn');
				 var evaluationYesGradeEnterRemarkBtn=editevaluationdetailstructure.down('#evaluationYesGradeEnterRemarkBtn');
				 
				 var evaluationNoMarkBtn=editevaluationdetailstructure.down('#evaluationNoMarkBtn');
				 var evaluationYesMarkBtn=editevaluationdetailstructure.down('#evaluationYesMarkBtn');
				 var evaluationNoGradeBtn=editevaluationdetailstructure.down('#evaluationNoGradeBtn');
				 var evaluationYesGradeBtn=editevaluationdetailstructure.down('#evaluationYesGradeBtn');
				
				 evaluationNoMarkEnterRemarkBtn.setVisible(false);
				 evaluationNoGradeEnterRemarkBtn.setVisible(false);
				 evaluationYesMarkEnterRemarkBtn.setVisible(false);
				 evaluationYesGradeEnterRemarkBtn.setVisible(false);
				 
				 evaluationNoMarkBtn.setVisible(false);
				 evaluationYesMarkBtn.setVisible(false);
				 evaluationNoGradeBtn.setVisible(false);
				 evaluationYesGradeBtn.setVisible(false);

            	 Ext.each(permissionList, function(privilege) {
            		 if (privilege === 'ENTER_REMARK') {
            			 evaluationNoMarkEnterRemarkBtn.setVisible(true);
        				 evaluationNoGradeEnterRemarkBtn.setVisible(true);
        				 evaluationYesMarkEnterRemarkBtn.setVisible(true);
        				 evaluationYesGradeEnterRemarkBtn.setVisible(true);
            		 }
            		 if(privilege === 'SET_DEFAULT_MARKS'){
            			 evaluationNoMarkBtn.setVisible(true);
        				 evaluationYesMarkBtn.setVisible(true);
            		 }if(privilege === 'SET_DEFAULT_GRADE'){
            			 evaluationNoGradeBtn.setVisible(true);
        				 evaluationYesGradeBtn.setVisible(true);
            		 }
            	 });
             },
             
             makeMaxMarksReadOnly: function(){
            	 var me = this;
            	 try{
            		 me.getAssignmentdetails().down('#maxMarks').setReadOnly(true);
            	 }
            	 catch(e){
            		 //--
            	 }
             }
});