/**
 * This controller is used for the document management functionality.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.document.DocumentController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['document.DocumentStatusStore', 'document.DocumentModeSubmissionStore','common.DocumentTypeStore',
             'examinationcenters.evaluationgrouplisting.documentsubmit.DocumentNameByEvalGroup', 'common.DocumentStatusCSMStore',
			  'common.DocTypeStore'],


    views: ['document.DocumentFormWindow', 'document.SimpleDocumentForm','document.SimpleUrlForm', 'document.ExtendedDocumentForm','hostel.roomallocation.userwise.ManageDocumentHostelWin',
    	'document.StudentDocumentFormWindow','Academia.view.applicantportalsetup.GuidelineDocumentForm','Academia.view.signupSetup.SignupGuidelineDocumentForm','personinfo.common.course.RequestExamCancellationWindow',
   'document.ServiceRequestNewDocForm','document.AdhocDocumentFormWindow','Academia.view.applicantportalsetup.DashboardGuidelineDocumentForm',
   'document.AddDocumentFormWindow','document.DocumentEditWithFileForm','servicerequest.quickComment.QuickCommentInput','document.CourseSessionDiaryDocumentForm'],

    alias: "widget.documentcontroller",

    refs: [{
        ref: 'documentFormWindow',
        selector: 'documentformwindow'
    }, {
        ref: 'simpleDocumentForm',
        selector: 'simpledocumentform[itemId=simpleDocumentForm]'
    }, {
        ref: 'extendedDocumentForm',
        selector: 'extendeddocumentform[itemId=extendedDocumentForm]'
    }, {
        ref: 'onlinedocumentformwin',
        selector: 'onlinedocumentformwin'
    },{
        ref: 'physicaldocumentformwin',
        selector: 'physicaldocumentformwin'
    },{
   	 ref: 'managedocumenthostelwin',
	 selector: 'managedocumenthostelwin'
 },
 {
   	 ref: 'studentDocumentFormWindow',
	 selector: 'studentdocumentformwindow'
 },
 {
   	 ref: 'guidelineDocumentForm',
	 selector: 'guidelinedocumentform'
 },
 {
	 ref : 'signupguidelinedocumentform',
	 selector : 'signupguidelinedocumentform'
 },{
   	 ref: 'requestexamcancellationwindow',
	 selector: 'requestexamcancellationwindow'
 },{
   	 ref: 'studentregistrationdocumentuploadwindow',
	 selector: 'studentregistrationdocumentuploadwindow'
 },{
       ref: 'servicerequestnewdocform',
        selector: 'servicerequestnewdocform[itemId=servicerequestnewdocform]'
 },{
 	ref: 'adhocdocumentformwindow',
 	selector : 'adhocdocumentformwindow'
 },{
   	ref : 'dashboardGuidelineDocumentForm',
   	selector : 'dashboardguidelinedocumentform'
    },{
    	ref: 'applicantdocumentformwindow',
    	selector : 'adddocumentformwindow[itemId=applicantDocumentFormWindow]'
    },{
    	ref:'schldocumentdetailswin',
    	selector:'schldocumentdetailswin'
    },{
        ref: 'simpleUrlForm',
        selector: 'simpleurlform[itemId=simpleUrlForm]'
    }, {
        ref: 'documenteditwithfileform',
        selector: 'documenteditwithfileform[itemId=documenteditwithfileform]'
    }, {
    	ref: 'docsAndRefDetailsWindow',
    	selector: 'docsAndRefDetailsWindow'
    },{
    	ref:'attachmentdocumentform',
    	selector:'attachmentdocumentform'
    },{
    	ref:'quickCommentInput',
    	selector:'quickCommentInput'
    },{
    	ref:'coursesessiondiarydocumentform',
    	selector:'coursesessiondiarydocumentform[itemId=coursesessiondiarydocumentform]'
    }],

    init: function(application) {
        this.control({
        	'extendeddocumentform[itemId=extendedDocumentForm]': {
                afterrender: function(){
                	this.onChangeOfElectronicOrPhysical(true);
                }
            },
        	'extendeddocumentform[itemId=extendedDocumentForm] radio[itemId=electonicField]': {
                change: function( radioField, newValue, oldValue, eOpts ){
                }
            },

            'extendeddocumentform[itemId=extendedDocumentForm] radiogroup[itemId=returnableRadioGroup]': {
                change: function( radioField, newValue, oldValue, eOpts ){
                	this.onSelectionIsReturnableYes(newValue.isReturnable);
                }
            },
            
            'extendeddocumentform[itemId=extendedDocumentForm] radiogroup[itemId=inspectionRequiredRadioGroupField]': {
                change: function( radioField, newValue, oldValue, eOpts ){
                	this.onSelectionIsInspectionRequired(newValue.isInspectionRequired);
                }
            },
            'extendeddocumentform[itemId=extendedDocumentForm] radiogroup[itemId=inspectionDoneRadioGroupField]': {
                change: function( radioField, newValue, oldValue, eOpts ){
                	this.onSelectionIsInspectionDone(newValue.isInspectionDone);
                }
            },
            'simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]': {
                change: function(fileField, value, eOpts){
                	var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	var form = this.getSimpleDocumentForm();
                	if(!isNullOrEmpty(form.config) && !isNullOrEmpty(form.config.documentDashlet) && form.config.documentDashlet==true) {
                		fileField.reset();
                		form.config.documentDashlet=false;
                	} else if(isNullOrEmpty(fileField.up('#editbasicprogramdetailsItemId')) && isNullOrEmpty(fileField.up('#createeditbasicprogramdetailsItemId'))) {
                		fileField.setRawValue(value);
                	} 
                	if((!isNullOrEmpty(fileField.up('#student_disciplinary_hidden_field')) || !isNullOrEmpty(fileField.up('#student_positive_hidden_field')) ||
                			!isNullOrEmpty(fileField.up('#student_vaccination_hidden_field')) || !isNullOrEmpty(fileField.up('#studentPatentDetailsForm')) ||
                			!isNullOrEmpty(fileField.up('#studentPersonTrainingDetailsForm')) || !isNullOrEmpty(fileField.up('#studentResearchTypeForm')) ||
                			!isNullOrEmpty(fileField.up('#infirmaryeditformItemId')) || !isNullOrEmpty(fileField.up('#manageInterventionAddEditFormItemId')) ||
                			!isNullOrEmpty(fileField.up('#applicant_vaccination_hidden_field')) || !isNullOrEmpty(fileField.up('#studentSeminarDetailsForm')) || !isNullOrEmpty(fileField.up('#student_Document_positive_hidden_field')) ) 
                			&& !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) {
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                        var specialCharsExist=false;
                        for(i = 0; i < specialChars.length;i++){
                        if(newValue.indexOf(specialChars[i]) > -1){
                             specialCharsExist= true;
                         }
                         
                         }
                        if(specialCharsExist){
                        	fileField.reset();
                           showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                        }
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtension(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MESSAGE')+" "+CONSTANTS.UPLOAD_FILE_SIZE_LIMIT
                    	            		+" "+getPersonModuleTranslation('MB'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    	    }
                    	}
                	}
                	if((!isNullOrEmpty(fileField.up('#student_post_doc_hidden_field')) || !isNullOrEmpty(fileField.up('#student_joint_degree_hidden_field')) 
                			|| !isNullOrEmpty(fileField.up('#student_own_progress_report_hidden_field'))|| !isNullOrEmpty(fileField.up('#student_mou_hidden_field'))
                			|| !isNullOrEmpty(fileField.up('#functionary_progress_report_hidden_field'))|| !isNullOrEmpty(fileField.up('#student_ethics_clearance_letter_hidden_field')) 
                		    || !isNullOrEmpty(fileField.up('#studentExaminersReporthidden')) || !isNullOrEmpty(fileField.up('#independentNonExaminingChairPersonHiddenId'))
                		    || !isNullOrEmpty(fileField.up('#proof_of_activity_hidden_field'))  ) 
                			&& !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) {
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtension(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        if (file.size / 1048576 > CONSTANTS.UPLOAD_PROGRAM_FILE_SIZE_LIMIT) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('PROGRAM_FILE_SIZE_ERROR_MSG'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    	    }
                    	}
                	}
                	if(((!isNullOrEmpty(fileField.up('#Student_Passport_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) || ((!isNullOrEmpty(fileField.up('#visa_detail_hidden_field')) ) 
                			&& !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) || ((!isNullOrEmpty(fileField.up('#applicant_Passport_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ||
                			((!isNullOrEmpty(fileField.up('#applicant_visa_detail_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ||
                			((!isNullOrEmpty(fileField.up('#permit_detail_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0]))|| ((!isNullOrEmpty(fileField.up('#education_history_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0]))|| ((!isNullOrEmpty(fileField.up('#applicant_education_history_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ||
                			((!isNullOrEmpty(fileField.up('#applicant_permit_detail_hidden_field'))) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0]))|| ((!isNullOrEmpty(fileField.up('#applicant_insurance_detail_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ||
                			((!isNullOrEmpty(fileField.up('#language_detail_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ||((!isNullOrEmpty(fileField.up('#applicant_language_detail_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) || ((!isNullOrEmpty(fileField.up('#health_information_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) || 
                			((!isNullOrEmpty(fileField.up('#applicant_health_information_Details_hidden_field')) ) && !isNullOrEmpty(fileField.fileInputEl.dom.files[0])) ) {
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtension(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        if (file.size / 1048576 > CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_FILE_SIZE_ERROR_MSG'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    	    }
                    	}
                	}
                	if(!isNullOrEmpty(fileField.up('#sponsor_Invoice_hidden_field'))) {
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtensionSponsorInvoice(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        if (file.size / 1048576 > CONSTANTS.UPLOAD_PROGRAM_FILE_SIZE_LIMIT) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_FILE_SIZE_SPONSOR_ERROR_MSG'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_SPONSOR_ERROR_MSG'));
                    	    }
                    	}
                	}
                }
            },
            'servicerequestnewdocform[itemId=servicerequestnewdocform] filefield[itemId=uploadFileField]': {
                change: function(fileField, value, eOpts){
                	if(!isNullOrEmpty(fileField.fileInputEl.dom.files[0])) {
                		var $this = this;
                    	value = value.replace('C:\\fakepath\\', '');
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtension(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    	    }
                    	}
            		}
                }
            },
            /*'documentformwindow': {
            	afterrender: function(cmp) {
            		const examDocWinInterval = setInterval(examDocWinTimer, 500);
					 function examDocWinTimer() {
						 if(cmp && cmp.down('form')) {
							 cmp.down('form').isValid();
							 cmp.down('form').getForm().clearInvalid();
						 }
						 else {
							 clearInterval(examDocWinInterval);
						 }
					 }
            	}
            }*/
            
        });
    },
    /*
     * On change of radio button Electronic  
     * @param isElectornic: according to selection true or false 
     */
    onChangeOfElectronicOrPhysical : function(isElectornic){
    	var this$ = this;
    	if(isElectornic == true){
    		this$.showHideUploadFileField(false);
            this$.showHideEmployeeResponsibleField(true);
            this$.showHideReturnableRadioGroupField(true);
    	}else{
    		this$.showHideUploadFileField(true);
            this$.showHideEmployeeResponsibleField(false);
            this$.showHideReturnableRadioGroupField(false);
        }
        
    },
    /*
     * On change of radio button Returnable  
     * @param isReturnable: according to selection true or false 
     */
    onSelectionIsReturnableYes : function(isReturnable){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
        if(isReturnable){
        	this$.showHideReturnableField(false);
        }else{
        	this$.showHideReturnableField(true);
        }
        this$.changeStatus(form);
    },
    /*
     * On change of radio button Inspection Required
     * @param isInspectionRequired: according to selection true or false 
     */
    onSelectionIsInspectionRequired : function(isInspectionRequired){
    	var this$ = this;
        var form = this$.getExtendedDocumentForm();
        var inspectionDoneRadioGroupField = form.down('#inspectionDoneRadioGroupField');
        if(isInspectionRequired){
        	inspectionDoneRadioGroupField.setDisabled(false);
        	var isInspectionDoneYesField = form.down('#isInspectionDoneYesField');
        	if(isInspectionDoneYesField.getValue() == true){
        		this$.showHideInspectedField(false);
        	}else{
        		this$.showHideInspectedField(true);
        	}
        }else{
        	inspectionDoneRadioGroupField.setDisabled(true);
        	this$.showHideInspectedField(true);
        }
        this$.changeStatus(form);
    },
    
    changeStatus:function(form){
    	var values=form.getForm().getValues();
    	var documentStatusCSM = form.down('#documentStatus');
 	   
    	if(values.isReturnable==true){
    		documentStatusCSM.getStore().load({
    			   callback: function(records, operation, success) {
    				  for(var i in records){
    					  if(records[i].data.code =="RETURNED"){
    						documentStatusCSM.setValue(records[i].data.id);
    					  }
    				  }
    			  } 
    		  });
    		//form.down("#documentStatus").setValue('RETURNED');
    	}else if(values.isInspectionRequired==true && values.isInspectionDone==false){
    		//form.down("#documentStatus").setValue('INSPECTED_PENDING');
    		documentStatusCSM.getStore().load({
 			   callback: function(records, operation, success) {
 				  for(var i in records){
 					  if(records[i].data.code =="INSPECTED_PENDING"){
 						documentStatusCSM.setValue(records[i].data.id);
 					  }
 				  }
 			  } 
 		  });
    	}else{ 
    		if(documentStatusCSM.getValue()==null){
    		documentStatusCSM.getStore().load({
 			   callback: function(records, operation, success) {
 				  for(var i in records){
 					  if(records[i].data.code =="SUBMITTED"){
 						documentStatusCSM.setValue(records[i].data.id);
 					  }
 				  }
 			  } 
 		  });
    		//form.down("#documentStatus").setValue('SUBMITTED');
    	}
    	}
    	form.getForm().checkValidity();
    },
    /*
     * On change of radio button Inspection Done  
     */
    onSelectionIsInspectionDone : function(){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
        var isInspectionDoneYesField = form.down('#isInspectionDoneYesField');
        if(isInspectionDoneYesField.getValue() == true){
    		this$.showHideInspectedField(false);
    	}else{
    		this$.showHideInspectedField(true);
    	}
        
        this$.changeStatus(form);
    },
    /*
     * show or hide file upload field
     * @param isDisabled : according to selection true or false 
     */
    showHideUploadFileField : function(isDisabled){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
        var uploadFileField = form.down('#uploadFileField');
        if(isDisabled){
        	uploadFileField.setValue('');
        }
        uploadFileField.setDisabled(isDisabled);
        
    },
    /*
     * show or hide Employee Responsible Field 
     * @param isDisabled : according to selection true or false 
     */
    showHideEmployeeResponsibleField : function(isDisabled){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
        var responsibleUserField = form.down('#responsibleUserField');
        var submissionMode  = form.down('#modeOfSubmission');
        if(isDisabled){
        	responsibleUserField.clearValue();
        	submissionMode.clearValue();
        }
        responsibleUserField.setDisabled(isDisabled);
        submissionMode.setDisabled(isDisabled);
        
    },
    /*
     * show or hide Returnable Radio Group Field
     * @param isDisabled : according to selection true or false 
     */
    showHideReturnableRadioGroupField : function(isDisabled){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
        var returnableRadioGroup = form.down('#returnableRadioGroup');
        if(isDisabled){
        	returnableRadioGroup.setDisabled(true);
        	this$.showHideReturnableField(true);
        }else{
        	returnableRadioGroup.setDisabled(false);
        	var isReturnableYesField = form.down('#isReturnableYesField');
        	if(isReturnableYesField.getValue()==true){
        		this$.showHideReturnableField(false);
        	}else{
        		this$.showHideReturnableField(true);
        	}
        }
        this$.changeStatus(form);
    },
    /*
     * show or hide Returnable Field
     * @param isDisabled : according to selection true or false 
     */
    showHideReturnableField : function(isDisabled){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
    	var returnDateField = form.down('#returnDateField'); 
        var returnByField = form.down('#returnByField');
        var modeOfReturnField = form.down('#modeOfReturnField');
        var returnedToUserField = form.down('#returnedToUserField');
        var documentFormSubmitButtonId = form.down('#documentFormSubmitButtonId');
        if(isDisabled){
        	returnDateField.setValue('');
        	returnByField.clearValue();
        	modeOfReturnField.clearValue();
        	returnedToUserField.clearValue();
        }
        else{
        	var returnByStore=returnByField.getStore();
        	returnByStore.load({
    			scope:this,
				callback: function(rec, callback){
					var currentUserId = this$.getCurrentlyLoggedInUser().id;
					var preValue = returnByField.getValue();
					if(isNullOrEmpty(preValue)){
						returnByField.setValue(currentUserId);
					}
					var preDateValue = returnDateField.getValue();
					if(isNullOrEmpty(preDateValue)){
						returnDateField.setValue(new Date());
					}
		        	returnDateField.setMaxValue(new Date());
		        	if(form.isValid()){
		        		documentFormSubmitButtonId.setDisabled(false);
		        	}
				}
			});
        }
        returnDateField.setDisabled(isDisabled);
    	returnByField.setDisabled(isDisabled);
    	modeOfReturnField.setDisabled(isDisabled);
    	returnedToUserField.setDisabled(isDisabled);
    	form.getForm().checkValidity();
    },
    /*
     * show or hide Inspected Field
     * @param isDisabled : according to selection true or false 
     */
    showHideInspectedField : function(isDisabled){
    	var this$ = this;
    	var form = this$.getExtendedDocumentForm();
    	var inspectionDateField = form.down('#inspectionDateField'); 
        var inspectionDoneByField = form.down('#inspectionDoneByField');
        var documentFormSubmitButtonId = form.down('#documentFormSubmitButtonId');
        if(isDisabled){
        	inspectionDateField.setValue('');
        	inspectionDoneByField.clearValue();
        }
        else{
        	var inspectStore=inspectionDoneByField.getStore();
			inspectStore.load({
    			scope:this,
				callback: function(rec, callback){
					var currentUserId = this$.getCurrentlyLoggedInUser().id;
					var preValue = inspectionDoneByField.getValue();
					if(isNullOrEmpty(preValue)){
						inspectionDoneByField.setValue(currentUserId);
					}
					var preDateValue = inspectionDateField.getValue();
					if(isNullOrEmpty(preDateValue)){
						inspectionDateField.setValue(new Date());
					}
					inspectionDateField.setMaxValue(new Date());
					if(form.isValid()){
						documentFormSubmitButtonId.setDisabled(false);
					}
				}
			});
        }
        inspectionDateField.setDisabled(isDisabled);
        inspectionDoneByField.setDisabled(isDisabled);
    },
    /*
     * Get document Type obj. It's internal call method
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     */
    getDocumentTypeForm : function(documentType){
    	var this$ = this;
    	if (documentType == 'EXT_DOCUMENT') {
        	form = this$.getExtendedDocumentForm();
		}else if (documentType == 'DOCUMENT') {
			form = this$.getSimpleDocumentForm();
		}else if (documentType == 'EXT_DOCUMENT1') {
			form = this$.getServicerequestnewdocform();
		}else if (documentType == 'NEW_DOCUMENT') {
			form = this$.getApplicantdocumentformwindow();
		}else if (documentType == 'COURSE_SESSION_DOCUMENT') {
			form = this$.getCoursesessiondiarydocumentform();
		}
    	
    	return form;
    },

    /*
     * Show document window. It's external call method
     * @param itemId : itemId module wise, It's mandatory.
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     */
    showDocumentFormWindow: function(itemId, documentType,resizeTo) {
    	
    	var this$ = this;
        var formWindow = this$.getDocumentFormWindow();
        if (!formWindow) {
            Ext.widget('documentformwindow',{
            	itemId : itemId
            });
            Ext.suspendLayouts();
            formWindow = this$.getDocumentFormWindow();
            formWindow.removeAll();
            this$.addFormItemsToWindow(formWindow, documentType);
            var documentCharacterlengh =formWindow.down('#documentNameField')
            if(!isNullOrEmpty(documentCharacterlengh)){
            	if(itemId=='paymenttermconfiguredocumentlistgridItemId'){
                	documentCharacterlengh.maxLength=105;
                   }
            	else if(itemId=='uploaddocumentlistId' || itemId=='dashboarduploaddocumentlistId'){
            		documentCharacterlengh.maxLength=255;
            	}else if(!isNullOrEmpty(documentType) && documentType=='DOCUMENT_URL'){
                	documentCharacterlengh.maxLength=500; 
                }else{
                	documentCharacterlengh.maxLength=50; 
                }
            }
            
            Ext.resumeLayouts(true);
        }
        if(resizeTo != undefined){
        	formWindow.setHeight(resizeTo);
        }
        formWindow.show();
        
        var $this = this
        var form = formWindow.down('form');
        formWindow.body.on('click', function() {
        $this.hideInvalidIconFromField(form);
              });
    },
    
    
showStudentDocumentFormWindow: function(itemId, documentType,resizeTo) {
    	var this$ = this;
        var formWindow = this$.getStudentDocumentFormWindow();
        if (!formWindow) {
            Ext.widget('studentdocumentformwindow',{
            	itemId : itemId
            });
            formWindow = this$.getStudentDocumentFormWindow();
        }
        if(resizeTo != undefined){
        	formWindow.setHeight(resizeTo);
        }
        formWindow.show();
    },
    
    
    
    /*
     * Add form items into document window according to document type. It's internal method
     * @param formWindow - document form window obj
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     */
    addFormItemsToWindow : function(formWindow, documentType) {
    	var field = null;
		var formItems = [];
		
		if (documentType == 'EXT_DOCUMENT1') {
			formWindow.height = '50%';
			field = {
				xtype : 'servicerequestnewdocform',
				itemId : 'servicerequestnewdocform'
			};
		}else if (documentType == 'EXT_DOCUMENT') {
			formWindow.height = '80%';
			field = {
				xtype : 'extendeddocumentform',
				itemId : 'extendedDocumentForm'
			};
		} else if (documentType == 'DOCUMENT') {
			field = {
				xtype : 'simpledocumentform',
				itemId : 'simpleDocumentForm'
			};
		}else if (documentType == 'EDIT_DOCUMENT') {
			field = {
					xtype : 'documenteditwithfileform',
					itemId : 'documenteditwithfileform'
				};
		}
		else if (documentType == 'DOCUMENT_URL') {
			field = {
				xtype : 'simpleurlform',
				itemId : 'simpleUrlForm'
			};
		}
		else if (documentType == 'GUIDELINES_DOCUMENT') {
			field = {
				xtype : 'guidelinedocumentform',
				itemId : 'guidelineDocumentForm'
			};
		}
		else if (documentType == 'SIGNUP_GUIDELINES_DOCUMENT') {
			field = {
				xtype : 'signupguidelinedocumentform',
				itemId : 'signupguidelinedocumentform'
			};
		}
		else if (documentType == 'DASHBOARD_GUIDELINES_DOCUMENT') {
			field = {
				xtype : 'dashboardguidelinedocumentform',
				itemId : 'dashboardguidelinedocumentform'
			};
		}else if (documentType == 'NEW_DOCUMENT') {
			formWindow.height = '80%';
			field = {
				xtype : 'applicantdocumentformwindow',
				itemId : 'applicantDocumentFormWindow'
			};
		}else if (documentType == 'ATTACHMENTDOCUMENT') {
			field = {
					xtype : 'attachmentdocumentform',
					itemId : 'attachmentdocumentform'
				};
			}else if (documentType == 'COURSE_SESSION_DOCUMENT') {
				field = {
						xtype : 'coursesessiondiarydocumentform',
						itemId : 'coursesessiondiarydocumentform'
					};
				}
		formItems.push(field);
		Ext.apply(formWindow, {
			documentType : '',
			getDocumentType : function(){
				return formWindow.documentType;
			},
			setDocumentType : function(documentType){
				formWindow.documentType = documentType;
			}
		});
		formWindow.setDocumentType(documentType);
		formWindow.add(formItems);
		
    },
    /*
     * Close document window
     */
    closeDocumentFormWindow: function() {
        var this$ = this;
        this$.getDocumentFormWindow().close();
    },
    
    closeStudentDocumentFormWindow: function() {
        var this$ = this;
        this$.getStudentDocumentFormWindow().close();
    },

    /*
     * view document form window. It's external call method
     * @param itemId : itemId module wise, It's mandatory.
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     * @param docId :document id, It's mandatory for view.
     */
    viewDocumentFormWindow: function(itemId, documentType, docId) {
    	var this$ = this;
    	if(!isNullOrEmpty(docId)){
    		this$.editDocumentFormWindow(itemId, documentType, docId);
        	var form = this$.getDocumentTypeForm(documentType);
            if (form) {
                form.down('#documentFormSubmitButtonId').setVisible(false);
                form = form.getForm();
                toggleReadOnlyFormItems(form, true);
            }
    	}
    },
    /**
     * edit document form window. It's external call method
     * @param itemId : itemId module wise, It's mandatory.
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     * @param docId :document id, It's mandatory for view.
     */
    editDocumentFormWindow: function(itemId, documentType, docId, isView,resizeTo) {

    	var this$ = this;
    	if(!isNullOrEmpty(docId)){
    		this$.showDocumentFormWindow(itemId, documentType,resizeTo);
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.DOCUMENT_FORM_FIND_BY + docId,
                method: 'GET',
                success: function(res, action) {
                	var data = Ext.decode(res.responseText);
                	if(!isEmpty(data)){
                		this$.setDocumentFormValue(documentType, data, isView);
                	}
                }
                
            });
    	}
        
        
    }, 
    
    /*
     * edit document form window. It's internal call method
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     * @param data :form data on edit and view.
     */
    setDocumentFormValue : function(documentType, data, isView){
    	var this$ = this;
    	var filePath = '';
    	var form = this$.getDocumentTypeForm(documentType);
    	var uploadFileField = form.down('#uploadFileField');
    	if(!isNullOrEmpty(data.path)){
    		filePath = data.path;
    		var filePathArray = new Array();
    		if(filePath.indexOf('/') !=-1){
    			filePathArray = filePath.split("/");
    		}else if(filePath.indexOf('\\')){
    			filePathArray = filePath.split("\\");
    		}
    		var length = filePathArray.length;
    		if(length > 0){
    			var fileName = "";
    			filePath = filePathArray[length - 1];
    			fileName = filePath;
    			if(filePath.length > 30) {
    				filePath = filePath.substring(0,29)+"...";
    			}else{
    				fileName = filePath;
    			}
    			filePath = '<a href="#" title="'+fileName+'">'+filePath+'</a>';
    			
    		}else{
    			filePath = '';
    		}
    	}
    	var fileDisplayField = Ext.create('Ext.Component',{
            itemId: 'fileDisplayField',
            width : 226,
            autoEl: {
                tag: 'a',
                href: '#',
                html: filePath
            },
            listeners: {
            	render: function(component){
            		component.getEl().on('click', function(e){
            			this$.downloadDocumentFile(data.encryptedDocId);
            		});    
            	}
            }
        });
    	
    	
    	if(documentType == 'EXT_DOCUMENT'  ||  documentType == 'EXT_DOCUMENT1'){
    		
    		form.down('#documentStatus').show();
    		form.down('#documentStatus').setDisabled(false);
    		if(!isNullOrEmpty(data.isElectronic)){
    			form.down('#electonicField').setValue(data.isElectronic);
    			form.down('#physicalField').setValue(!data.isElectronic);
    			if(data.isElectronic && !isNullOrEmpty(filePath)){
    				var fileFieldContainer = form.down('#fileFieldContainer');
    				if(isView == undefined || isView) {
    					if(documentType == 'EXT_DOCUMENT') {
    						fileFieldContainer.remove(uploadFileField);
    						fileFieldContainer.insert(1, fileDisplayField);
    					}
                		fileFieldContainer.insert(2, {
                			xtype : 'hidden',
                			name : 'path',
                			value: data.path
                		});
    				}
            	}
    			
    		}
    		if(!isNullOrEmpty(data.isInspectionRequired)){
    			form.down('#isInspectionRequiredYesField').setValue(data.isInspectionRequired);
    			form.down('#isInspectionRequiredNoField').setValue(!data.isInspectionRequired);
    		}
    		if(!isNullOrEmpty(data.isInspectionDone)){
    			form.down('#isInspectionDoneYesField').setValue(data.isInspectionDone);
    			form.down('#isInspectionDoneNoField').setValue(!data.isInspectionDone);
    		}
    		if(!isNullOrEmpty(data.isReturnable)){
    			form.down('#isReturnableYesField').setValue(data.isReturnable);
    			form.down('#isReturnableNoField').setValue(!data.isReturnable);
    		}
    		form.getForm().setValues(data);
    		form.getForm().findField('submissionDate').setValue(dateRender(data.submissionDate));
    		form.getForm().findField('inspectionDate').setValue(dateRender(data.inspectionDate));
    		form.getForm().findField('returnedDate').setValue(dateRender(data.returnedDate));
    		/*var extForm = form.getForm();
    		toggleReadOnlyFormItems(extForm, true);
    		form.down('#responsibleUserField').setReadOnly(false);
    		form.down('#documentStatus').setReadOnly(false);*/
    		
    	}else if(documentType == 'DOCUMENT'){
    		form.getForm.setValues(data);
    		form.remove(uploadFileField);
    		form.insert(6, fileDisplayField);
    		toggleReadOnlyFormItems(form, true);
    		form.down('#documentFormSubmitButtonId').setVisible(false);
            var simpleForm = form.getForm();
            toggleReadOnlyFormItems(simpleForm, true);
    	}
    	
		
    },
    /**
     * save document file. It's external call method
     * @param entityId : person id, It's mandatory. 
     * @param module : module name, for student module 'student', It's mandatory.
     * @param entityType : entity type, It's mandatory.
     * @param documentType : document type, It's mandatory.
     * @param isTransient : true or false (send json back to module controller or not)
     * @param callBackFunction : callback function return in module controller. It's mandatory.
     */
    saveDocumentForm : function(entityId, module, entityType, documentType,callBackFunction, isTransient,otherDocTypeId){
    	var this$ = this;
    	var submitUrl = '';
    	var returnedToName = '';
    	var isUpdate = true;
    	var isUploadFile = true;
    	var form = null;
    	var formData = null;
    	var onlineOrPhysical = null;
    	if(isNullOrEmpty(isTransient)){
    		isTransient = false;
    	}
    	if (documentType == 'EXT_DOCUMENT1') {
        	form = this$.getServicerequestnewdocform();
        	formData = form.getValues();
        	isUploadFile = formData.isElectronic;
            if(!isNullOrEmpty(returnedToName)){
            	formData.returnedToName = returnedToName;
            }
		}else if (documentType == 'EXT_DOCUMENT') {
        	form = this$.getExtendedDocumentForm();
        	form.down('#documentFormSubmitButtonId').setDisabled(true);
        	formData = form.getValues();
        	isUploadFile = formData.isElectronic;
            if(!isNullOrEmpty(returnedToName)){
            	formData.returnedToName = returnedToName;
            } 
		}
		else if (documentType == 'DOCUMENT') {
			form = this$.getSimpleDocumentForm();
			formData = form.getValues();
		}else if (documentType == 'ATTACHMENTDOCUMENT') {
			form = this$.getAttachmentdocumentform();
			formData = form.getValues();
	    }else if (documentType == 'EDIT_DOCUMENT') {
			form = this$.getDocumenteditwithfileform();
			formData = form.getValues();
		}else if (documentType == 'DOCUMENT_URL') {
			form = this$.getSimpleUrlForm();
			formData = form.getValues();
		}else if (documentType == 'COURSE_SESSION_DOCUMENT') {
			form = this$.getCoursesessiondiarydocumentform();
			formData = form.getValues();
		}
		else if (documentType == 'DOCUMENT1') {
			var win = this$.getStudentDocumentFormWindow();
			form = win.down('form');
			formData = form.getValues();
		}else if (documentType == 'ONLINE_DOC_FORM') {
			var formwin = this$.getOnlinedocumentformwin();
			form = formwin.down('#onlineDocumentFormItemId');
			formData = form.getValues();
			onlineOrPhysical='ONLINE_DOC_FORM';
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'PHYSICAL_DOC_FORM') {
			var formwin = this$.getPhysicaldocumentformwin();
			isUploadFile = false;
			onlineOrPhysical='PHYSICAL_DOC_FORM';
			form = formwin.down('#physicalDocumentFormItemId');
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'HOSTEL_DOCUMENT') {
			var win=this$.getManagedocumenthostelwin();
			form =win.down('#managedocumenthostelFormItemId');
			formData = form.getValues();
			
		}
		else if (documentType == 'GUIDELINES_DOCUMENT') {
			form = this$.getGuidelineDocumentForm();
			formData = form.getValues();
		}
		else if (documentType == 'SIGNUP_GUIDELINES_DOCUMENT') {
			form = this$.getSignupguidelinedocumentform();
			formData = form.getValues();
		}else if (documentType == 'STUDENT_REGISTRATION_DOC_FORM') {
			var formwin = this$.getStudentregistrationdocumentuploadwindow();
			form = formwin.down('#onlineDocumentFormItemId');
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
			documentType = "ONLINE_DOC_FORM";
		}else if (documentType == 'ADHOC_DOC_FORM') {
			var formWin = this$.getAdhocdocumentformwindow();
	    	form = formWin.down('#adhocDocumentFormWindowItemId');
	    	form.down('#documentFormSubmitButtonId').setDisabled(true);
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'NEW_DOCUMENT') {
			var formWin = this$.getApplicantdocumentformwindow();
			isUploadFile = false;
	    	var form = formWin.down('#documentFormWindowItemId');
	    	form.down('#documentFormSubmitButtonId').setDisabled(true);
			formData = form.getValues();
		}
		else if (documentType == 'DASHBOARD_GUIDELINES_DOCUMENT') {
			form = this$.getDashboardGuidelineDocumentForm();
			formData = form.getValues();
		}else if(documentType=='SCHOLARSHIP'){
			form = this$.getSchldocumentdetailswin().down('form');
			formData = form.getValues();
		}
		else if(documentType=='DOCUMENTANDREFERENCE'){
			form = this$.getDocsAndRefDetailsWindow().down('form');
			formData = form.getValues();
		}
		else if(documentType=='QUICK_COMMENT_DOCUMENT'){
			form = this$.getQuickCommentInput();
			formData = form.down('#quickCommentFileUpload').getValue()			
			
//			if(!isNullOrEmpty(returnedToName)){
//            	formData.returnedToName = returnedToName;
//            } 
			
		}
    	var	 id = form.down('#document_hidden_field');
    	
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.DOCUMENT_FILE_ADD,
            isUpdate = false;
        }else{
        	submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
        }
        
        var fileField = form.down('#fileDisplayField');
        if(!isNullOrEmpty(fileField)){
        	isUploadFile=false;
        }
        
        var data = new Object();
        if(!isNullOrEmpty(entityId)){
        	data.entityId = entityId;
        }else{
        	data.entityId = null;
        }
        if(!isNullOrEmpty(module)){
        	data.module = module;
        }else{
        	data.module = null;
        }
        if(!isNullOrEmpty(entityType)){
        	data.entityType = entityType;
        }else{
        	data.entityType = null;
        }
        form.getForm().setValues(data);
        
        if(isUploadFile){
        	form.getForm().submit({
            	method : 'POST',
            	url : submitUrl,
            	success : function(form, action){
            		var path = Ext.JSON.decode(action.response.responseText).path;
            		if(documentType == 'EXT_DOCUMENT1') {
            			this$.saveDocumentFormValue(isTransient, documentType, isUpdate, formData, path,callBackFunction);
            		}else {
            		this$.saveDocumentFormValue(isTransient, documentType, false, formData, path,callBackFunction);
            		}
            		if(isNullOrEmpty(onlineOrPhysical)) {
            		
					}	
				},
				failure: function(form, action) {
					var msg = getCommonTranslation('SOMETHING_WRONG_UPLOADING_FILE');
					try {
						// Safely decode JSON response
						if (action.response && action.response.responseText) {
							var resp = Ext.JSON.decode(action.response.responseText);

							// Prefer "detailsMessage" or "message" or any custom key
							if (resp.detailsMessage && resp.detailsMessage.indexOf('expected type for extension') !== -1) {
								msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
							} else if (resp.message) {
								msg = resp.message;
							}
						}
					} catch (e) {
						console.error("Error decoding failure response:", e);
					}

					showWarningMessage(getCommonTranslation('ALERT'), msg);

				}
            });
        }else{
        	var path = null;
        	if(!isNullOrEmpty(formData.path)){
        		path = formData.path;
        	}
        	this$.saveDocumentFormValue(isTransient, documentType, isUpdate, formData, path,callBackFunction);
        }
        
    	
    	
    },
    
    saveStudentDocumentForm : function(entityId, module, entityType, documentType,docName,callBackFunction, isTransient,otherDocTypeId){
    	var this$ = this;
    	var submitUrl = '';
    	var returnedToName = '';
    	var isUpdate = true;
    	var isUploadFile = true;
    	var form = null;
    	var formData = null;
    	if(isNullOrEmpty(isTransient)){
    		isTransient = false;
    	}
    	if (documentType == 'EXT_DOCUMENT') {
        	form = this$.getExtendedDocumentForm();
        	formData = form.getValues();
        	isUploadFile = formData.isElectronic;
            if(!isNullOrEmpty(returnedToName)){
            	formData.returnedToName = returnedToName;
            }
		} else if (documentType == 'DOCUMENT') {
			form = this$.getSimpleDocumentForm();
			formData = form.getValues();
		}
		else if (documentType == 'DOCUMENT_URL') {
			form = this$.getSimpleUrlForm();
			formData = form.getValues();
		}
		else if (documentType == 'DOCUMENT1') {
			var win = this$.getStudentDocumentFormWindow();
			form = win.down('form');
			formData = form.getValues();
		}else if (documentType == 'ONLINE_DOC_FORM') {
			var formwin = this$.getOnlinedocumentformwin();
			form = formwin.down('#onlineDocumentFormItemId');
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'PHYSICAL_DOC_FORM') {
			var formwin = this$.getPhysicaldocumentformwin();
			isUploadFile = false;
			form = formwin.down('#physicalDocumentFormItemId');
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'HOSTEL_DOCUMENT') {
			var win=this$.getManagedocumenthostelwin();
			form =win.down('#managedocumenthostelFormItemId');
			formData = form.getValues();
			
		}else if (documentType == 'ADHOC_DOC_FORM') {
			var formWin = this$.getAdhocdocumentformwindow();
	    	form = formWin.down('#adhocDocumentFormWindowItemId');
			formData = form.getValues();
			if(!isNullOrEmpty(otherDocTypeId))
			{
				formData.documentType = {
						id:otherDocTypeId
				}
			}
		}else if (documentType == 'NEW_DOCUMENT') {
			var formWin = this$.getApplicantdocumentformwindow();
			isUploadFile = false;
	    	var form = formWin.down('#documentFormWindowItemId');
			formData = form.getValues();
			
		}
    	
        
        var id = form.down('#document_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.DOCUMENT_FILE_ADD,
            isUpdate = false;
        }else{
        	submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
        }
        
        var fileField = form.down('#fileDisplayField');
        if(!isNullOrEmpty(fileField)){
        	isUploadFile=false;
        }
        
        
        var data = new Object();
        if(!isNullOrEmpty(entityId)){
        	data.entityId = entityId;
        }else{
        	data.entityId = null;
        }
        if(!isNullOrEmpty(module)){
        	data.module = module;
        }else{
        	data.module = null;
        }
        if(!isNullOrEmpty(entityType)){
        	data.entityType = entityType;
        }else{
        	data.entityType = null;
        }
        form.getForm().setValues(data);
        
        if(isUploadFile){
        	form.getForm().submit({
            	method : 'POST',
            	url : submitUrl,
            	success : function(form, action){
            		var path = Ext.JSON.decode(action.response.responseText).path;
            		this$.saveStudentDocumentFormValue(isTransient, documentType, false, formData, path,docName,callBackFunction);
				},
				failure: function(form, action) {
					var msg = "Something went wrong while uploading the file.";
					try {
						// Safely decode JSON response
						if (action.response && action.response.responseText) {
							var resp = Ext.JSON.decode(action.response.responseText);

							// Prefer "detailsMessage" or "message" or any custom key
							if (resp.detailsMessage && resp.detailsMessage.contains('expected type for extension')) {
								msg = "The uploaded file type is invalid. Please upload a valid file.";
							} else if (resp.message) {
								msg = resp.message;
							}
						}
					} catch (e) {
						console.error("Error decoding failure response:", e);
					}

					showWarningMessage(getCommonTranslation('ALERT'), msg);

				}
            });
        }else{
        	var path = null;
        	if(!isNullOrEmpty(formData.path)){
        		path = formData.path;
        	}
        	this$.saveStudentDocumentFormValue(isTransient, documentType, isUpdate, formData, path,docName,callBackFunction);
        }
        
    	
    	
    },
    
    /*
     * save document from value. It's internal call method
     * @param isUpdate : add or edit mode, It's mandatory. 
     * @param formData : form data json.
     * @param path : return file path .
     * @param isTransient : true or false (send json back to module controller or not)
     * @param documentType :  'EXT_DOCUMENT' or 'DOCUMENT', It's mandatory and case sensitive.
     * @param callBackFunction : callback function return in module controller. It's mandatory.
     */
    
    saveDocumentFormValue : function(isTransient, documentType, isUpdate, formData, path,callBackFunction){
    	if(!isEmpty(formData)){
    		if(formData.isPreDefined=="feePayer"){
				formData.isPreDefined=false;
				formData.isFeePayerDocument=true
			}
    		formData.path = path;
    		if (documentType == 'ONLINE_DOC_FORM') {
    			formData.type ='EXT_DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			formData.modeOfSubmission = 'ONLINE';
    		    formData.isElectronic = true;	
    		}else if(documentType == 'PHYSICAL_DOC_FORM'){
    			formData.type ='EXT_DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			delete formData.isFeePayerDocument
    			formData.isElectronic = false;
    		}
    		else if(documentType == 'HOSTEL_DOCUMENT'){
    			formData.type ='DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			delete formData.isFeePayerDocument
    		 }else if(documentType == 'DOCUMENT1'){
    			formData.type ='DOCUMENT';
    			formData.name = docName;
    			delete formData.documentName;
    			delete formData.isFeePayerDocument
    		 }else if(documentType == 'GUIDELINES_DOCUMENT'){
    			formData.type ='DOCUMENT';
    			delete formData.documentName;
    			delete formData.isFeePayerDocument
    		 }
    		 else if(documentType == 'SIGNUP_GUIDELINES_DOCUMENT'){
     			formData.type ='DOCUMENT';
     			delete formData.documentName;
     			delete formData.isFeePayerDocument
     		 }else if(documentType == 'EXT_DOCUMENT1'){
    			formData.type ='EXT_DOCUMENT';
    			delete formData.modeOfSubmission;
    			delete formData.modeOfReturn;
    			delete formData.isReturnable;
    			delete formData.returnedDate;
    			delete formData.isFeePayerDocument
    		 }else if (documentType == 'ADHOC_DOC_FORM') {
	            var formWin = this.getAdhocdocumentformwindow();
	    	    var form = formWin.down('#adhocDocumentFormWindowItemId');
	    	    form.down('#documentFormSubmitButtonId').setDisabled(true);
    			formData.type ='DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.remark;
    			delete formData.documentName;
    			delete formData.isFeePayerDocument
    		}else if (documentType == 'NEW_DOCUMENT') {
    			formData.type ='DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			delete formData.docType;
    			delete formData.isFeePayerDocument
    		}else if(documentType == 'ATTACHMENTDOCUMENT'){
    			formData.type ='DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.isFeePayerDocument
    		}else if(documentType == 'EXT_DOCUMENT'){
	            formData.type ='EXT_DOCUMENT';
    			var form = this.getExtendedDocumentForm();
        	    form.down('#documentFormSubmitButtonId').setDisabled(true);
    		}
    		 else {
    			formData.type =documentType;
    		}
    		delete formData.docType;
    		var user ;
            if(formData.responsibleUser == null){
            user = this.getCurrentlyLoggedInUser();
            }
            else{
                user = formData.responsibleUser.id;
            }
    		formData.createdBy = user;
    		
    		delete formData.entityId;
    		delete formData.module;
    		delete formData.entityType;
        	if(isTransient){
        		var success = true;
        		callBackFunction(success, formData, isTransient);
        	}else{
        		delete formData.files;
        		var submitUrl = '', method = '';
        		formData = Ext.encode(formData);
        		if(isUpdate && documentType == 'EXT_DOCUMENT1') {
        			method = 'PUT';
        			submitUrl = SERVERURL.SERVICE_REQUEST_DOCUMENT_UPDATE;
        		}
        		else if(isUpdate){
        			method = 'PUT';
        			submitUrl = SERVERURL.DOCUMENT_FORM_UPDATE;
        		}else{
        			method = 'POST';
        			submitUrl = SERVERURL.DOCUMENT_FORM_SAVE;
        		}
        		Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    jsonData: formData,
                    method: method,
                    callback : function(opt, success, response){
                    	callBackFunction(success, response, isTransient);
                    }
                    
                });
        	}
            
    	}
    },
    
    saveStudentDocumentFormValue : function(isTransient, documentType, isUpdate, formData, path, docName,callBackFunction){
    	if(!isEmpty(formData)){
    		
    		formData.path = path;
    		if (documentType == 'ONLINE_DOC_FORM') {
    			formData.type ='EXT_DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			formData.modeOfSubmission = 'ONLINE';
    		    formData.isElectronic = true;	
    		}else if(documentType == 'PHYSICAL_DOC_FORM'){
    			formData.type ='EXT_DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    			formData.isElectronic = false;
    		}
    		else if(documentType == 'HOSTEL_DOCUMENT'){
    			formData.type ='DOCUMENT';
    			formData.name = formData.documentName;
    			delete formData.documentName;
    		 }else if(documentType == 'DOCUMENT1'){
    			formData.type ='DOCUMENT';
    			formData.name = docName;
    			delete formData.documentName;
    		 }else {
    			formData.type =documentType;
    		}
    		var user = this.getCurrentlyLoggedInUser();
    		formData.createdBy = user;
    		
    		delete formData.entityId;
    		delete formData.module;
    		delete formData.entityType;
        	if(isTransient){
        		var success = true;
        		callBackFunction(success, formData, isTransient);
        	}else{
        		var submitUrl = '', method = '';
        		formData = Ext.encode(formData);
        		if(isUpdate){
        			method = 'PUT';
        			submitUrl = SERVERURL.DOCUMENT_FORM_UPDATE;
        		}else{
        			method = 'POST';
        			submitUrl = SERVERURL.DOCUMENT_FORM_SAVE;
        		}
        		Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    jsonData: formData,
                    method: method,
                    callback : function(opt, success, response){
                    	callBackFunction(success, response, isTransient);
                    }
                    
                });
        	}
            
    	}
    },
    
    /*
     * download file. It's external call method
     * @param documentId : download perticular file, It's mandatory. 
     */
    
    downloadDocumentFile : function(documentId){
    	
    	var whetherFile = false;
    	if(!isNullOrEmpty(documentId)){
    	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
            method: 'GET',
            callback : function(opt, success, response){
            	if(response.responseText == 'true') {
            		var csvForm = Ext.create('Ext.form.Panel'); 
        	    	csvForm.getForm().submit({
        		    	target: '_blank',
        		    	method:'GET',
        		    	params :{
        		    		access_token : Ext.Ajax.defaultHeaders.access_token
        		    	},
        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
        		    	standardSubmit :true
        	    	});
            	} else {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
            	}
            }
         });
    	}
    },
 downloadDocumentReadmissionFile : function(documentId,isConfigured){
    	var whetherFile = false;
    	if(!isNullOrEmpty(documentId)){
    	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId+"?isConfigured="+isConfigured,
            method: 'GET',
            callback : function(opt, success, response){
            	if(response.responseText == 'true') {
            		var csvForm = Ext.create('Ext.form.Panel'); 
        	    	csvForm.getForm().submit({
        		    	target: '_blank',
        		    	method:'GET',
        		    	params :{
        		    		access_token : Ext.Ajax.defaultHeaders.access_token,
        		    		isConfigured : isConfigured
        		    	},
        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
        		    	standardSubmit :true
        	    	});
            	} else {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
            	}
            }
         });
    	}
    },
    /*
     * download multiple files as zip. It's external call method
     * @param data: records, It's mandatory.
     * @param zipFileName: Name of Zip file, It's mandatory.
     * @param directoryType: Directory type of stored file.
     */
    downloadMultipleDocumentFile:function(data, zipFileName, directoryType) {

    	if(!isNullOrEmpty(data) && !isNullOrEmpty(zipFileName) && !isNullOrEmpty(directoryType)) {
    		jsonData = data.join();
    		var submitUrl= SERVERURL.MULITPLE_DOCUMENT_FILE_DOWNLOAD;
    		var csvForm = Ext.create('Ext.form.Panel');
				csvForm.getForm().submit({
				    url : submitUrl,
				    method : 'POST',
				    target: '_blank',
				    params :{
				    	access_token : Ext.Ajax.defaultHeaders.access_token,
				    	filePaths : jsonData,
				    	zipFileName : zipFileName,
				    	directoryType : directoryType
				    	},
				    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				    	standardSubmit :true
				    });
			}
    }, 
    downloadMultipleDocumentFileForCourseSessionDiary:function(data, zipFileName, directoryType) {

    	if(!isNullOrEmpty(data) && !isNullOrEmpty(zipFileName) && !isNullOrEmpty(directoryType)) {
    		jsonData = data.join();
    		var submitUrl= SERVERURL.PATH_DOWNLOAD_FILES_ZIP_FOR_COURSE_SESSION_DIARY;
    		var csvForm = Ext.create('Ext.form.Panel');
				csvForm.getForm().submit({
				    url : submitUrl,
				    method : 'POST',
				    target: '_blank',
				    params :{
				    	access_token : Ext.Ajax.defaultHeaders.access_token,
				    	filePaths : jsonData,
				    	zipFileName : zipFileName,
				    	directoryType : directoryType
				    	},
				    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				    	standardSubmit :true
				    });
			}
    }, 
    downloadMultipleDocumentFileForReadmission:function(data, readmissionData, zipFileName, directoryType, personId) {

    	if((!isNullOrEmpty(data) || !isNullOrEmpty(readmissionData)) && !isNullOrEmpty(zipFileName) && !isNullOrEmpty(directoryType)) {
    		jsonData = data.join();
			if(!isNullOrEmpty(readmissionData)){
				readmissionJsonData = readmissionData.join();
			}
    		var submitUrl= SERVERURL.MULITPLE_DOCUMENT_FILE_DOWNLOAD;
    		var csvForm = Ext.create('Ext.form.Panel');
			if(!isNullOrEmpty(readmissionData)){
				csvForm.getForm().submit({
				    url : submitUrl,
				    method : 'POST',
				    target: '_blank',
				    params :{
				    	access_token : Ext.Ajax.defaultHeaders.access_token,
				    	filePaths : jsonData,
				    	readmissionFilePaths : readmissionJsonData,
				    	zipFileName : zipFileName,
				    	directoryType : directoryType,
				    	personId : personId
				    	},
				    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				    	standardSubmit :true
				    });
			}else{
				csvForm.getForm().submit({
				    	url : submitUrl,
				    	method : 'POST',
				    	target: '_blank',
				    	params :{
				    		access_token : Ext.Ajax.defaultHeaders.access_token,
				    		filePaths : jsonData,
				    		//readmissionFilePaths : readmissionJsonData,
				    		zipFileName : zipFileName,
				    		directoryType : directoryType,
				            personId : personId
				    		},
				    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				    	standardSubmit :true
				 });
			}
    		
    	}
    },
    showRequestExamCancellationWindow: function(itemId, documentType,resizeTo) {
    	var this$ = this;
        var formWindow = this$.getRequestexamcancellationwindow();
        if (!formWindow) {
            Ext.widget('requestexamcancellationwindow',{
            });
            formWindow = this$.getRequestexamcancellationwindow();
        }
        if(resizeTo != undefined){
        	formWindow.setHeight(resizeTo);
        }
        formWindow.show();
    },

});
