/**
 * @author Pritam.Patil 
 * This controller is used for document template functionality
 */
Ext.define('Academia.controller.documentmanagement.DocumentTemplateController', {

    extend: 'Academia.controller.base.BaseController',

    stores: [ 'documentmanagement.DocumentCategorys', 'documentmanagement.DocumentTemplateStore', 'common.AcademyStore', 'common.LocationStore',
              'documentmanagement.Templates', 'documentmanagement.DocumentTypes', 'documentmanagement.DynamicTemplateDataStore',
              'documentmanagement.DocumentDataProviderStore', 'documentmanagement.DocumentTemplateMappings',
              'organization.academylocations.AcademyLocationStore', 'coursetransaction.studymaterialdistribution.CoursesAllStore', 
              'othermasters.communitymaster.CommunityComboStore', 'course.CourseComboStore','attendance.attendancereport.AcadmyByAdmission','user.UserAcademyLocationStore',
              'documentmanagement.DocumentTemplateMappingApplyToALGridStore','documentmanagement.DocumentTemplateMappingApplyToALCourseGridStore',
              'documentmanagement.DocumentTemplateMappingAddCourseGridStore','feeandpayment.ALProgramList','feeandpayment.ALProgramSearchCombo',
              'feeandpayment.ALProgramBatchList','feeandpayment.ALProgramBatchSearchCombo','feeandpayment.finance.FinanceALProgramBatchSeatTypeList',
              'documentmanagement.DocumentTemplateMappingApplyToCommunityGridStore','documentmanagement.DocumentTemplateMappingCommunityComboStore',
              'documentmanagement.DocumentTemplateMappingApplyToALProgramBatchSeatTypeGridStore','documentmanagement.DocumentTemplateProgramGroupMappingStore',
              'feeandpayment.reports.ProgramStudentByIntakeYearStore', 'documentmanagement.ActiveFlagsStore','documentmanagement.FlagColorByFlagIdsStore'],

    views: ['documentmanagement.DocumentListSearchForm', 'documentmanagement.DocumentListGrid', 
            'documentmanagement.DocumentListView', 'documentmanagement.AddDocumentWindow', 
            'documentmanagement.TemplateListView', 'documentmanagement.TemplateListGrid', 
            'documentmanagement.TemplateListSearchForm', 'documentmanagement.AddTemplateForm', 
            'documentmanagement.DocumentTemplateMappingSearchForm', 'documentmanagement.DocumentTemplateMappingView', 
            'documentmanagement.DocumentTemplateMappingGrid', 'documentmanagement.AddDoumentTemplateMappingWindow', 
            'documentmanagement.DocumentTemplateTabPanel', 'documentmanagement.DynamicTemplateDataForm',
            'common.AcademyLocationProgramBatchSeatTypeForm','common.ALProgramBatchSeatTypeFormNew',
            'documentmanagement.DocumentTemplateMappingApplyToTabStructure','documentmanagement.DocumentTemplateMappingApplyToStructure',
            'documentmanagement.DocumentTemplateMappingApplyToGrid','feeandpayment.adjustment.AdjustmentProgressTracker',
            'documentmanagement.DocumentTemplateMappingAddALMappingTab','documentmanagement.DocumentTemplateMappingAddALStructure',
            'documentmanagement.DocumentTemplateMappingAddALGrid','documentmanagement.DocumentTemplateMappingApplyToCourseGrid',
            'documentmanagement.DocumentTemplateMappingAddCourseStructure','documentmanagement.DocumentTemplateMappingAddCourseGrid',
            'documentmanagement.DocumentTemplateMappingApplyToCommunityGrid','documentmanagement.DocumentTemplateMappingAddCommunityStructure',
            'documentmanagement.DocumentTemplateMappingAddCommunityGrid','documentmanagement.DocumentTemplateApplyToALViewWindow',
            'documentmanagement.DocumentTemplateMappingApplyToProgamBatchGrid','documentmanagement.DocumentTemplateMappingAddProgramBatchStructure',
            'documentmanagement.DocumentTemplateMappingAddProgramGrid','documentmanagement.DocumentTemplateMappingAddProgramBatchGrid',
            'documentmanagement.DocumentTemplateMappingAddProgramBatchSeatTypeGrid','committee.committee.CommitteeMappingAlertWin',
            'documentmanagement.DocumentTemplateALProgramBatchViewWindow','documentmanagement.DocumentTemplateMappingAddProgramGroupGrid',
            'documentmanagement.DocumentTemplateMappingAddProgramGroupGrid'],

    refs: [{
    	ref: 'documentListingSearchForm',
    	selector: 'documentlistingsearchform[itemId=documentListingSearchForm]'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    }, {
    	ref: 'documentListGrid',
    	selector: 'documentlistgrid[itemId=documentListGrid]'
    }, {
        ref: 'addDocumentWindow',
        selector: 'adddocumentwindow'
    }, {
        ref: 'documentForm',
        selector: 'adddocumentwindow form[itemId=documentForm]'
    }, {
    	ref: 'templateListSearchForm',
    	selector: 'templatelistsearchform[itemId=templateListSearchForm]'
    }, {
    	ref: 'templateListGrid',
    	selector: 'templatelistgrid[itemId=templateListGrid]'
    }, {
        ref: 'addTemplateForm',
        selector: 'addtemplateform'
    }, {
        ref: 'documentTemplateTabPanel',
        selector: 'documenttemplatetabpanel'
    }, {
        ref: 'addDoumentTemplateMappingWindow',
        selector: 'adddoumenttemplatemappingwindow'
    }, {
    	ref: 'documentTemplateMappingSearchForm',
    	selector: 'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm]'
    }, {
    	ref: 'documentTemplateMappingGrid',
    	selector: 'documenttemplatemappinggrid[itemId=documentTemplateMappingGrid]'
    }, {
    	ref: 'documentTemplateMappingForm',
    	selector: 'form[itemId=documentTemplateMappingForm]'
    },{
    	ref: 'academylocationprogrambatchseattypeform',
    	selector: 'academylocationprogrambatchseattypeform'
    },{
    	ref: 'alprogrambatchseattypeformnew',
    	selector: 'alprogrambatchseattypeformnew'
    },{
    	ref: 'documenttemplatemappingapplytotabstructure',
    	selector: 'documenttemplatemappingapplytotabstructure'
    },{
    	ref: 'documenttemplatemappingapplytostructure',
    	selector: 'documenttemplatemappingapplytostructure'
    },{
    	ref: 'documenttemplatemappingapplytogrid',
    	selector: 'documenttemplatemappingapplytogrid'
    },{
    	ref:'adjustmentprogresstracker',
    	selector:'adjustmentprogresstracker'
    },{
    	ref:'documenttemplatemappingaddalmappingtab',
    	selector:'documenttemplatemappingaddalmappingtab'
    },{
    	ref:'documenttemplatemappingaddalstructure',
    	selector:'documenttemplatemappingaddalstructure'
    },{
    	ref:'documenttemplatemappingaddalgrid',
    	selector:'documenttemplatemappingaddalgrid'
    },{
    	ref:'documenttemplatemappingapplytocoursegrid',
    	selector:'documenttemplatemappingapplytocoursegrid'
    },{
    	ref:'documenttemplatemappingaddcoursestructure',
    	selector:'documenttemplatemappingaddcoursestructure'
    },{
    	ref:'documenttemplatemappingaddcoursegrid',
    	selector:'documenttemplatemappingaddcoursegrid'
    },{
    	ref:'documenttemplatemappingaddcommunitystructure',
    	selector:'documenttemplatemappingaddcommunitystructure'
    },{
    	ref:'documenttemplatemappingapplytocommunitygrid',
    	selector:'documenttemplatemappingapplytocommunitygrid'
    },{
    	ref:'documenttemplatemappingaddcommunitygrid',
    	selector:'documenttemplatemappingaddcommunitygrid'
    },{
    	ref:'documenttemplateapplytoalviewwindow',
    	selector:'documenttemplateapplytoalviewwindow'
    },{
    	ref:'documenttemplatemappingapplytoprogambatchgrid',
    	selector:'documenttemplatemappingapplytoprogambatchgrid'
    },{
    	ref:'documenttemplatemappingaddprogrambatchstructure',
    	selector:'documenttemplatemappingaddprogrambatchstructure'
    },{
    	ref:'documenttemplatemappingaddprogramgrid',
    	selector:'documenttemplatemappingaddprogramgrid'
    },{
    	ref:'documenttemplatemappingaddprogrambatchgrid',
    	selector:'documenttemplatemappingaddprogrambatchgrid'
    },{
    	ref:'documenttemplatemappingaddprogrambatchseattypegrid',
    	selector:'documenttemplatemappingaddprogrambatchseattypegrid'
    },{
    	ref:'committeemappingalertwin',
    	selector:'committeemappingalertwin'
    },{
    	ref:'documenttemplatealprogrambatchviewwindow',
    	selector:'documenttemplatealprogrambatchviewwindow'
    },{
    	ref:'documenttemplatemappingaddprogramgroupgrid',
    	selector:'documenttemplatemappingaddprogramgroupgrid'
    }],
    
    config: {
    	MANAGE_DOCUMENT_TYPE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_DOCUMENT_TYPE_PRIVILEGES'),
    	MANAGE_TEMPLATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_TEMPLATE_PRIVILEGES'),
    	DOCUMENT_TEMPLATE_MAPPING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DOCUMENT_TEMPLATE_MAPPING_PRIVILEGES')
    },
    init: function() {

        this.control({
        	'documenttemplatetabpanel':{
        		tabchange: function(tp){
        			var me = this;
        			
        			var structure = tp.getActiveTab();
        			if(!isNullOrEmpty(structure)){
        				structure.scrollBy(0,1);
        				structure.scrollBy(0,-1);
        			}
        		}
        	},
        	/**
        	 * Document list
        	 */
        	'documentlistingsearchform[itemId=documentListingSearchForm] button[itemId=searchButtonId]': {
                click: function() {
                	this.loadDocumentListGrid();
                }
            },
            'documentlistgrid[itemId=documentListGrid] button[itemId=btnAdd]': {
                click: function() {
                    this.showAddDocumentWindow(getDocumentTranslation('ADD_DOCUMENT'));
                }
            },
            'documentlistgrid[itemId=documentListGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editDocumentWindow(getDocumentTranslation('EDIT_DOCUMENT'), false);
                }
            },
            'documentlistgrid[itemId=documentListGrid] button[itemId=btnView]': {
                click: function() {
                	this.editDocumentWindow(getDocumentTranslation('VIEW_DOCUMENT'), true);
                }
            },
            'documentlistgrid[itemId=documentListGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteDocumentEntryRecord();
                }
            },
            'adddocumentwindow form[itemId=documentForm]':{
            	render: function(form){
            		this.loadDataProvider(form);
            	}
            },
            'adddocumentwindow form[itemId=documentForm] button[itemId=submitButtonId]':{
            	click: function(){
            		this.saveDocumentEntry();
            	}
            },
            'adddocumentwindow form[itemId=documentForm] button[itemId=cancelButtonId]': {
                click: function(btn) {
                    this.getAddDocumentWindow().close();
                }
            },
            /**
        	 * Document template list
        	 */
            'templatelistsearchform[itemId=templateListSearchForm] button[itemId=searchButtonId]': {
                click: function() {
                	this.loadTemplateListGrid();
                }
            },
            'templatelistsearchform[itemId=templateListSearchForm] button[itemId=resetButtonId]': {
                click: function() {
                	var form = this.getTemplateListSearchForm();
                    var grid = this.getTemplateListGrid();
                    var markDefaultTemplateButton = grid.down("#markDefaultTemplateButton");
                    markDefaultTemplateButton.setDisabled(false);
                	var documentType = form.down('#document_type');
                	documentType.getStore().removeAll();
                	form.getForm().reset();
                }
            },
            'templatelistsearchform[itemId=templateListSearchForm] combo[itemId=document_category]': {
                select: function(combo, records, eOpts) {
                	var configLevel = combo.getValue();
                	var documentType = this.getTemplateListSearchForm().down('#document_type');
                	documentType.reset();
                	var store = documentType.getStore();
                	store.proxy.extraParams = {
                			configLevel: configLevel
                	};
                	store.load();
                }
            },
            'templatelistgrid[itemId=templateListGrid] button[itemId=btnAdd]': {
                click: function() {
                    this.showCreateTemplate(getDocumentTranslation('CREATE_TEMPLATE'));
                }
            },
            'templatelistgrid[itemId=templateListGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editTemplateForm(false);
                }
            },
            'templatelistgrid[itemId=templateListGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewTemplateForm(true);
                }
            },
            'templatelistgrid[itemId=templateListGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteTemplateEntryRecord();
                }
            },
			 
			
            'templatelistgrid[itemId=templateListGrid] button[itemId=markDefaultTemplateButton]': {
                click: function() {
                    this.markAsDefaultTemplate();
                }
            },
            'addtemplateform dynamictemplatedataform[itemId=dynamicTemplateDataForm] button[itemId=saveTemplateButton]':{
            	click: function(button){
            		this.addDataToTemplate(button);            		
            	}
            },
            'addtemplateform combo[itemId=document_category]': {
                select: function(combo, records, eOpts) {
                	var configLevel = combo.getValue();
                	var documentType = this.getDocumentTemplateTabPanel().getActiveTab().down('#document_type');
                	documentType.reset();
                	var store = documentType.getStore();
                	store.proxy.extraParams = {
                			configLevel: configLevel
                	};
                	store.load();
                }
            },
            
            'addtemplateform combo[itemId=document_type]': {
                change: function(combo, records, eOpts) {
                	var templatePropertyCombo = this.getDocumentTemplateTabPanel().getActiveTab().down('#templatePropertyCombo');
                	templatePropertyCombo.reset();
                	var documentTypeId = combo.getValue();
                	var store = templatePropertyCombo.getStore();
                	store.proxy.extraParams = {
                			documentTypeId: documentTypeId
                	};
                	store.load();
                }
            },
            
            'addtemplateform button[itemId=submitButtonId]':{
            	click: function(button){
            		this.saveTemplateForm(button);
            	}
            },
            'addtemplateform button[itemId=cancelButtonId]': {
                click: function(btn) {
                	btn.up('addtemplateform').close();
                }
            },
            
            /**
        	 * Document template mapping list
        	 */
            'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm] radiogroup': {
                beforerender: function(radioGroup){
                	var form = this.getDocumentTemplateMappingSearchForm();
                	this.addContainerToMappingSearchForm(form, 'ACADEMY_LOCATION_LEVEL');
                }
            },
            'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm] radio': {
                focus: function(radioBtn, newValue, oldValue, eOpts){
                	var form = this.getDocumentTemplateMappingSearchForm();
                	this.addContainerToMappingSearchForm(form, radioBtn.inputValue);
                }
            },
            'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm] button[itemId=resetBtnId]': {
            	click: function(){
            		var form = this.getDocumentTemplateMappingSearchForm();
            		var radioBtn = form.down('#acadLocationRadioId');
            		this.addContainerToMappingSearchForm(form, radioBtn.inputValue);
            		form.getForm().reset();
            	}
            },
            'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm] combo[itemId=acadamyLocationCourseId]': {
            	select: function(combo, records, eOpts) {
                	var academyLocationId = combo.getValue();
                	var courseCombo = this.getDocumentTemplateMappingSearchForm().down('#courseId');
                	courseCombo.reset();
                	var store = courseCombo.getStore();
                	store.proxy.extraParams = {
                			academyLocationId: academyLocationId
                	};
                	store.load();
                }
            },
            'documenttemplatemappingsearchform[itemId=documentTemplateMappingSearchForm] button[itemId=searchButtonId]': {
                click: function() {
                	this.loadDocumentTemplateMappingGrid();
                }
            },
            'documenttemplatemappinggrid button[itemId=btnAdd]': {
                click: function() {
                    this.showDocumentTemplateMappingWindow(getDocumentTranslation('ADD_DOCUMENT_TEMPLATE_MAPPING'), 'addTemplateMappingWindow');
                }
            },
            'documenttemplatemappinggrid button[itemId=btnEdit]': {
                click: function() {
                    this.editDocumentTemplateMappingWindow(getDocumentTranslation('EDIT_DOCUMENT_TEMPLATE_MAPPING'), 'editTemplateMappingWindow');
                }
            },
            'documenttemplatemappinggrid button[itemId=btnView]': {
                click: function() {
                    this.viewDocumentTemplateMappingWindow(getDocumentTranslation('VIEW_DOCUMENT_TEMPLATE_MAPPING'), 'editTemplateMappingWindow');
                }
            },
            'documenttemplatemappinggrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteTemplateMappingEntryRecord();
                }
            },
            'adddoumenttemplatemappingwindow form[itemId=documentTemplateMappingForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveDocumentTemplateMapping();
                }
            },
            'adddoumenttemplatemappingwindow form[itemId=documentTemplateMappingForm] button[itemId=cancelButtonId]': {
                click: function(btn) {
                    this.getAddDoumentTemplateMappingWindow().close();
                }
            },
            'adddoumenttemplatemappingwindow form[itemId=documentTemplateMappingForm] combo[itemId=document_category]': {
            	select: function(combo, records, eOpts) {
            		var form = this.getDocumentTemplateMappingForm();
            		if(this.getAddDoumentTemplateMappingWindow().itemId =='addTemplateMappingWindow'){
            			this.addContainerToMappingForm(form, combo.getValue());
            		}
            		this.loadDocumentTypeComboLoad(form, combo);
                }
            },
            'adddoumenttemplatemappingwindow form[itemId=documentTemplateMappingForm] combo[itemId=document_type]': {
            	select: function(combo, records, eOpts) {
                	var documentTypeId = combo.getValue();
                	var form = this.getDocumentTemplateMappingForm();
                	var category = form.down('#document_category');
                	var templateName = form.down('#templateName');
                	var useDefaultTemplate = form.down('#useDefaultTemplate');
                	useDefaultTemplate.setValue(false);
                	templateName.reset();
                	var store = templateName.getStore();
                	store.proxy.extraParams = {
                			limit: '-1',
                			configLevel: category.getValue(),
                			documentTypeId: documentTypeId
                	};
                	store.load();
                }
            },
            'adddoumenttemplatemappingwindow[itemId=addTemplateMappingWindow] form[itemId=documentTemplateMappingForm] combo[itemId=acadamyLocationCourseId]': {
            	select: function(combo, records, eOpts) {
                	var academyLocationId = combo.getValue();
                	var courseCombo = this.getDocumentTemplateMappingForm().down('#courseId');
                	courseCombo.reset();
                	var store = courseCombo.getStore();
                	store.proxy.extraParams = {
                			academyLocationId: academyLocationId
                	};
                	store.load();
                }
            },
            'adddoumenttemplatemappingwindow form[itemId=documentTemplateMappingForm] checkbox[itemId=useDefaultTemplate]': {
            	change: function(checkbox, newValue, oldValue, eOpts) {
            		var templateNameCombo = this.getDocumentTemplateMappingForm().down('#templateName');
            		if(newValue){
            			var store = templateNameCombo.getStore();
            			var record = store.findRecord( 'whetherDefault', true);
            			if(!isEmpty(record)){
            				templateNameCombo.setValue(record.get('templateId'));
            				templateNameCombo.setReadOnly(true);
            			}else{
            				templateNameCombo.setReadOnly(true);
            				templateNameCombo.setEditable(false);
            				templateNameCombo.setReadOnly(false);
            			}
            			
            		}else{
            			templateNameCombo.setReadOnly(true);
            			templateNameCombo.setEditable(false);
            			templateNameCombo.setReadOnly(false);
            		}
                }
            },
            
            /**
             * Implementation of permission management
             */
            'documentlistgrid[itemId=documentListGrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getMANAGE_DOCUMENT_TYPE_PERMISSIONS());
            	}
            },
            
            'templatelistgrid[itemId=templateListGrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getMANAGE_TEMPLATE_PERMISSIONS());
            		this.enableDefaultTemplatePivileges(grid, this.getMANAGE_TEMPLATE_PERMISSIONS());
            	},
               selectionchange:function(column,selected,eOpts){
	            var grid = this.getTemplateListGrid();
              if(selected.length>0){
            	if(selected[0].data.configLevel=='FLAG_NOTIFICATION'){
	             grid.down("#markDefaultTemplateButton").setDisabled(true);
                  }      else{
	             grid.down("#markDefaultTemplateButton").setDisabled(false);
                  }
                 }
               }
            },
            
            'documenttemplatemappinggrid[itemId=documentTemplateMappingGrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getDOCUMENT_TEMPLATE_MAPPING_PERMISSIONS());
            		this.disableMoreActionPivileges(grid, this.getDOCUMENT_TEMPLATE_MAPPING_PERMISSIONS());
            	}
            },
            'documenttemplatemappinggrid button[itemId=btnApplyTo]':{
    			click: this.openApplyToTab
    		},
    		/*Apply To Code Section For AL*/
    		'documenttemplatemappingapplytogrid button[itemId=btnAdd]':{
    			click:this.openAddDocumentMappingApplyToTab
	   		 },
	   		'documenttemplatemappingapplytogrid button[itemId=btnDelete]':{
    			click:function(btn){
    				this.deleteDocumentMappingAL("AL");
    			}
	   		 },
	   		'documenttemplatemappingaddalgrid customcombobox#academylocationsearchcombo' : {
	   			 select:function(obj, record){
	   				 var academylocationgrid = this.getDocumenttemplatemappingaddalgrid();
	   				 academylocationgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					 academylocationgrid.getStore().filter({property: 'id',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   					var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
		 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ obj.up().up().getStore().getCount();	
	   				 }
	   			 }
	   		 },
	   		'documenttemplatemappingaddalgrid button#resetBtn':{
	   			click:function(btn){
	   				var activeTabPnl = this.getDocumenttemplatemappingapplytotabstructure();
	   				var currentRec = activeTabPnl.config.documentTemplateGridRecord;
	   				var activeGrid = this.getDocumenttemplatemappingaddalgrid();
	   				var configLevelVal = currentRec.get('configLevel');
	   				if(configLevelVal == "ACADEMY_LOCATION_LEVEL"){
	   					activeGrid = this.getDocumenttemplatemappingaddalgrid();
	   				}
	   				else if(configLevelVal == "COURSE_LEVEL"){
	   					activeGrid = this.getDocumenttemplatemappingaddcoursestructure().down('#academylocationgridDocumentCourseItemId');
	   				}
	   				else if(configLevelVal == "PROGRAM_BATCH_SEAT_TYPE_LEVEL"){
	   					activeGrid = this.getDocumenttemplatemappingaddprogrambatchstructure().down('#academylocationgridDocumentProgramBatchItemId');
	   				}
	   				activeGrid.getSelectionModel().deselectAll();
	   				activeGrid.getStore().clearFilter();
	   				if(activeGrid.down('#academylocationsearchcombo')){
	   					activeGrid.down('#academylocationsearchcombo').reset();
	   				}
	   			}
	 		  },
	 		  'documenttemplatemappingapplytogrid button[itemId=btnView]':{
	 			  click:this.openViewDocumentMappingALWindow
	 		  },
	 		 'documenttemplatemappingaddalgrid button#submitBtn':{
	 			  click:function(btn){
	 				 this.submitDocumentMappingWithAcademyLocation(btn);
	 			  }
	 		  },
	   		/*Apply To Code Section For AL and Course Tab*/
	 		  'documenttemplatemappingapplytocoursegrid button[itemId=btnAdd]':{
	 			  click:this.openAddDocumentMappingApplyToCourseTab
	 		  },
	 		 'documenttemplatemappingapplytocoursegrid button[itemId=btnDelete]':{
	 			click:function(btn){
    				this.deleteDocumentMappingAL("COURSE");
    			}
	 		  },
	 		 'documenttemplatemappingapplytocoursegrid button[itemId=btnView]':{
	 			  click:this.openViewDocumentMappingALCourseWindow
	 		  },
	 		 'documenttemplatemappingaddalgrid button#nextButton':{
	 			 click:function(btn){
	 				 var activeTabPnl = this.getDocumenttemplatemappingapplytotabstructure();
	 				 var currentRec = activeTabPnl.config.documentTemplateGridRecord;
	 				 var activeGrid = this.getDocumenttemplatemappingaddalgrid();
	 				 var configLevelVal = currentRec.get('configLevel');
	 				 if(configLevelVal == "COURSE_LEVEL"){
	 					 this.academyLocationNextEventCourseDocumentMapping(btn);
	 				 }
	 				 else if(configLevelVal == "PROGRAM_BATCH_SEAT_TYPE_LEVEL"){
	 					this.academyLocationNextEventProgramGroup(btn);
	 				 }
	 			 }
	 		  },
	 		 'documenttemplatemappingaddprogramgroupgrid button#nextButton':{
	 			 click:function(btn){
	 					this.academyLocationNextEventProgram(btn);
	 			 }
	 		  },
	 		  'documenttemplatemappingaddcoursegrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddcoursegrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#courseId')){
	 					  activeGrid.down('#courseId').reset();
	 				  }
	 			  }
	 		  },
	 		 'documenttemplatemappingaddcoursegrid button#submitBtn':{
		 			click:function(btn){
		 				 this.submitDocumentMappingWithALCourse(btn);
		 			  }
		 		  },
	 		 'documenttemplatemappingaddcoursegrid customcombobox#courseId' : {
	 			 select:function(obj, record){
	 				 var grid = this.getDocumenttemplatemappingaddcoursegrid();
	 				 grid.getStore().clearFilter();
	 				 grid.getStore().filter({property: 'longValue',
	 					 value: record[0].get('longValue'),
	 					 exactMatch: true,
	 					 caseSensitive: true});
	 				var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ obj.up().up().getStore().getCount();	
	 			 }
	 		  },
	 		 
	 		 /*Apply To Code Section For Community Tab*/
	 		 'documenttemplatemappingapplytocommunitygrid button[itemId=btnAdd]':{
	 			  click:this.openAddDocumentMappingApplyToCommunityTab
	 		  },
	 		 'documenttemplatemappingapplytocommunitygrid button[itemId=btnView]':{
	 			  click:this.openViewDocumentMappingCommunityWindow
	 		  },
	 		  'documenttemplatemappingapplytocommunitygrid button[itemId=btnDelete]':{
	 			  click:function(btn){
	 				  this.deleteDocumentMappingAL("COMUNITTY");
	 			  }
	 		  },
	 		  'documenttemplatemappingaddcommunitygrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddcommunitygrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#communityId')){
	 					  activeGrid.down('#communityId').reset();
	 				  }
	 			  }
	 		  },
	 		 'documenttemplatemappingaddcommunitygrid button#submitBtn':{
	 			click:function(btn){
	 				 this.submitDocumentMappingWithCommunity(btn);
	 			  }
	 		  },
	 		 'documenttemplatemappingaddcommunitygrid customcombobox#communityId' : {
	 			 select:function(obj, record){
	 				 var grid = this.getDocumenttemplatemappingaddcommunitygrid();
	 				 grid.getStore().clearFilter();
	 				 grid.getStore().filter({property: 'id',
	 					 value: record[0].get('id'),
	 					 exactMatch: true,
	 					 caseSensitive: true});
	 				var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ obj.up().up().getStore().getCount();	
	 			 }
	 		  },
	 		 
	 		 /*Apply To Code Section For Program Batch Seat Type Tab*/
	 		  'documenttemplatemappingapplytoprogambatchgrid button[itemId=btnAdd]':{
	 			  click:this.openAddDocumentMappingApplyToProgramBatchTab
	 		  },
	 		 'documenttemplatemappingapplytoprogambatchgrid button[itemId=btnView]':{
	 			  click:this.openViewDocumentMappingProgramBatchSeatWindow
	 		  },
	 		 'documenttemplatemappingapplytoprogambatchgrid button[itemId=btnDelete]':{
	 			  click:function(btn){
	 				  this.deleteDocumentMappingAL("PROGRAM_BATCH");
	 			  }
	 		  },
	 		 'documenttemplatemappingaddprogramgrid button#nextButton':{
	 			 click:function(btn){
	 				 this.programNextEventOnProgram(btn);
	 			 }
	 		  },
	 		 'documenttemplatemappingaddprogramgroupgrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddprogramgroupgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programGroupsearchcombo')){
	 					  activeGrid.down('#programGroupsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'documenttemplatemappingaddprogramgrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddprogramgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programsearchcombo')){
	 					  activeGrid.down('#programsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'documenttemplatemappingaddprogrambatchgrid button#nextButton':{
	 			 click:function(btn){
	 				 this.programNextEventOnProgramBatchTab(btn);
	 			 }
	 		  },
	 		 'documenttemplatemappingaddprogrambatchgrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddprogrambatchgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programbatchsearchcombo')){
	 					  activeGrid.down('#programbatchsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		  'documenttemplatemappingaddprogrambatchgrid button#submitBatchMapping':{
	 			  click:function(btn){
	 				  this.submitDocumentMappingWithProgramBatch(btn);
	 			  }
	 		  },
	 		  'documenttemplatemappingaddprogrambatchseattypegrid button#resetBtn':{
	 			  click:function(btn){
	 				  var activeGrid = this.getDocumenttemplatemappingaddprogrambatchseattypegrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 			  }
	 		  },
	 		 'documenttemplatemappingaddprogrambatchseattypegrid button#submitMapping':{
	 			  click:function(btn){
	 				 this.submitDocumentMappingWithProgramBatchSeatType(btn);
	 			  }
	 		  },
	 		 'documenttemplatemappingaddprogramgroupgrid customcombobox#programGroupsearchcombo' : {
	 			 select:function(obj, record){
	 				 var grid = this.getDocumenttemplatemappingaddprogramgroupgrid();
	 				 grid.getStore().clearFilter();
	 				 grid.getStore().filter({property: 'longValue',
	 					 value: record[0].get('id'),
	 					 exactMatch: true,
	 					 caseSensitive: true});
	 				var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ obj.up().up().getStore().getCount();	
	 			 }
	 		  },
	 		 'documenttemplatemappingaddprogramgrid customcombobox#programsearchcombo' : {
	 			 select:function(obj, record){
	 				 var grid = this.getDocumenttemplatemappingaddprogramgrid();
	 				 grid.getStore().clearFilter();
	 				 grid.getStore().filter({property: 'programId',
	 					 value: record[0].get('id'),
	 					 exactMatch: true,
	 					 caseSensitive: true});
	 				var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ obj.up().up().getStore().getCount();	
	 			 }
	 		  },
	 		 'documenttemplatemappingaddprogrambatchgrid customcombobox#programbatchsearchcombo' : {
	 			 select:function(obj, record){
	 				 var grid = this.getDocumenttemplatemappingaddprogrambatchgrid();
	 				 grid.getStore().clearFilter();
	 				 grid.getStore().filter({property: 'batchId',
	 					 value: record[0].get('id'),
	 					 exactMatch: true,
	 					 caseSensitive: true});
	 				var gridDom = obj.up().up().el ? obj.up().up().el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+grid.getStore().getCount();	
	 			 }
	 		  },
        });
    },

    loadDocumentListGrid: function(){
    	var this$ = this;
    	var formvalues = this$.getDocumentListingSearchForm().getValues();
        var grid = this$.getDocumentListGrid();
    	var store = grid.getStore();
    	store.proxy.extraParams = formvalues;
    	store.load();
    },
    loadDataProvider: function(form){
    	var store = form.down('#dataProviderSelector').getStore();
    	store.load();
    },
    /**
     * This method is used to add document 
     */
    showAddDocumentWindow: function(title) {
    	
    	var this$ = this;
    	var formWindow = this$.getAddDocumentWindow();
    	if(!formWindow){
    		formWindow = Ext.widget('adddocumentwindow',{
    			title: title
    		});
    	}
    	
    	formWindow.show();
    },
    
    /**
     *  View Document form window
     */
    /*viewDocumentFormWindow: function(title) {
        var this$ = this;
        this$.editDocumentWindow(title, true);
        var form = this$.getDocumentForm();
        if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        //form = form.getForm();
	        Ext.suspendLayouts();
	        form.down('#document_category').setReadOnly(true);
	        form.down('#document_name').setReadOnly(true);
	        form.down('#dataProviderSelector').setDisabled(true);
	        Ext.resumeLayouts();
	    }
    },*/
    /**
     * Edit Document form window
     */
    editDocumentWindow: function(title, isView) {

        var this$ = this;
        var grid = this$.getDocumentListGrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	var whetherEditable = records.get('whetherEditable');
        	if(whetherEditable){
        		this.showAddDocumentWindow(title);
                var form = this$.getDocumentForm();
                form.down('#document_category').setReadOnly(true);
                //form.down('#dataProviderSelector').getStore().load();
                
                if (!isEmpty(records)) {
                	var params = {
                			documentTypeId: records.get('documentTypeId')
                	}; 
                	this$.sendGetAjaxRequest(SERVERURL.DYNAMIC_DOCUMENT_TYPE_BY_ID, 'GET', params, function(option, success, response) {
                		if(success){
                			var data = Ext.decode(response.responseText);
//							var dataProviders = data.dataProviders[0];
//							delete data.dataProviders;
//							data.dataProviders = dataProviders;
                			form.getForm().setValues(data);
							if( !isView&&data.typeCode == "FLAG_NOTIFICATION")  {
							form.down('#document_name').setDisabled(true);
        	        		form.down('#document_code').setDisabled(true);
							form.down('#availableForAdhoc').setDisabled(true);
							}else{ 
								form.down('#document_name').setDisabled(false);
        	        		form.down('#document_code').setDisabled(false);
							form.down('#availableForAdhoc').setDisabled(false);  
							}

                		}
                		
                	});
                }
                if (isView) {
        	        form.down('#submitButtonId').setVisible(false);
        	        Ext.suspendLayouts();
                    form.down('#document_category').setReadOnly(true);
        	        form.down('#document_name').setReadOnly(true);
        	        form.down('#document_code').setReadOnly(true);
        	        form.down('#availableForAdhoc').setReadOnly(true);
        	        form.down('#dataProviderSelector').setDisabled(true);
        	        Ext.resumeLayouts();
        	        //toggleReadOnlyFormItems(form.getForm(), true);
        	    }
        	}else{
        		if (isView) {
        			this.showAddDocumentWindow(title);
        			var form = this$.getDocumentForm();
        			form.down('#document_category').setReadOnly(true);
        			//form.down('#dataProviderSelector').getStore().load();

        			if (!isEmpty(records)) {
        				var params = {
        						documentTypeId: records.get('documentTypeId')
        				}; 
        				this$.sendGetAjaxRequest(SERVERURL.DYNAMIC_DOCUMENT_TYPE_BY_ID, 'GET', params, function(option, success, response) {
        					if(success){
        						var data = Ext.decode(response.responseText);
//      						var dataProviders = data.dataProviders[0];
//      						delete data.dataProviders;
//      						data.dataProviders = dataProviders;
        						form.getForm().setValues(data);
        					}

        				});
        			}

        			form.down('#submitButtonId').setVisible(false);
        			Ext.suspendLayouts();
        			form.down('#document_category').setReadOnly(true);
        			form.down('#document_name').setReadOnly(true);
        			form.down('#document_code').setReadOnly(true);
        			form.down('#availableForAdhoc').setReadOnly(true);
        			form.down('#dataProviderSelector').setDisabled(true);
        			Ext.resumeLayouts();
        			//toggleReadOnlyFormItems(form.getForm(), true);
        		}
        		else{
        			showWarningMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('SELECTED_DOCUMENT_CANNOT_EDITED'));	
        		}
        	}
        	
        } else {
            showWarningMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * Delete document record
     */
    deleteDocumentEntryRecord: function() {

    	var this$ = this;
        var grid = this$.getDocumentListGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                        	var whetherDeletable = records[count].get('whetherDeletable');
                        	if(whetherDeletable){
                        		var id = "";
                                if (!isNullOrEmpty(records[count].get("documentTypeId"))) {
                                    id = records[count].get("documentTypeId");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.DYNAMIC_DOCUMENT_TYPE_DELETE + id,
                                    method: 'DELETE',
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    success: function(form, action) {
                                    	if(form.responseText=="true"){
                                    		grid.getStore().reload();
                                            showSuccessMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('DOCUMENT_ENTRY_DELETE_SUCCESS'));
                                        }else{
                                        		showWarningMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('SELECTED_DOCUMENT_CANNOT_DELETED'));
                                        }
                                    }
                                        
                                });
                        	}else{
                        		showWarningMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('SELECTED_DOCUMENT_CANNOT_DELETED'));
                        	}
                            
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  Save document entry
     */
    saveDocumentEntry: function() {

        var this$ = this;
        var submitUrl, isUpdate = false;
        
        var grid = this$.getDocumentListGrid();
        var form = this$.getDocumentForm();
        
        var id = form.down('#document_type_id');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.DYNAMIC_DOCUMENT_TYPE_ADD,
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.DYNAMIC_DOCUMENT_TYPE_UPDATE,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        this$.applyWindowMask(); 
       
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	 this$.hideWindowMask();
        	if(success){
        		this$.getAddDocumentWindow().close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('DOCUMENT_ENTRY_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getDocumentTranslation('DOCUMENT_MANAGMENT'), getDocumentTranslation('DOCUMENT_ENTRY_ADD_SUCCESS'));
                }
    		}else{
    			this$.getAddDocumentWindow().close();
                grid.getStore().reload();
    		}
        });

    },
    
    /**
     *  Get Json for form submission
     */
    getJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        
        var formData = form.getValues();
//        var dataProviders= new Array();
//        dataProviders.push(formData.dataProviders);
//        delete formData.dataProviders;
//        formData.dataProviders = dataProviders;
		  formData.availableForAdhoc=form.down('#availableForAdhoc').getValue();
		  formData.typeCode=form.down('#document_code').getValue();
		  formData.typeName=form.down('#document_name').getValue();
          jsonFormFieldData = Ext.encode(formData);
          return jsonFormFieldData;
    },
    /**
     * Load template list grid
     */
    loadTemplateListGrid: function(){
    	var this$ = this;
    	var formvalues = this$.getTemplateListSearchForm().getValues();
        var grid = this$.getTemplateListGrid();
         var markDefaultTemplateButton = grid.down("#markDefaultTemplateButton");
         markDefaultTemplateButton.setDisabled(false);
    	for (var prop in formvalues) {
    	      if(formvalues.hasOwnProperty(prop)){
    	        if(isNullOrEmpty(formvalues[prop])){
    	        	delete formvalues[prop];
    	        }
    	      }
    	   }
        var grid = this$.getTemplateListGrid();
    	var store = grid.getStore();
    	store.proxy.extraParams = formvalues;
    	store.load();
    },
    
    /**
     * This method is used to add document 
     */
    showCreateTemplate: function(title) {
    	
    	var this$ = this;
    	var documentTabPanel = this$.getDocumentTemplateTabPanel();
    	var newTab = documentTabPanel.items.findBy(function(tab) {
            return tab.title === title;
        });
        if (!newTab) {
        	newTab = documentTabPanel.add({
                xtype: 'addtemplateform',
                padding: 10,
                title: title,
                closable: true
                
            });
        }
        documentTabPanel.setActiveTab(newTab);
        newTab.down("#submitButtonId").setDisabled(false);
    },
    
    /**
     * This method is used for to add data to template  
     * @param button - button reference           
     */
    addDataToTemplate:function(button){
    	var this$ = this;
    	var templateForm= this$.getDocumentTemplateTabPanel().getActiveTab();
    	if(templateForm){
    		var propertyCombo=templateForm.down("#templatePropertyCombo");
    		if(propertyCombo){    			   			
      		  	  var ckeditor=templateForm.down('ckeditor');
                  var propertyValue=propertyCombo.getValue();
                  if(ckeditor && !isNullOrEmpty(propertyValue)){
                	  ckeditor.editor.insertText("propertyValue");
					  var re = /propertyValue/gi;
					  var templateString = ckeditor.getValue();
					  templateString = templateString.replace(re, propertyValue);
                	  ckeditor.setValue(templateString);
                  }                  
    		}
    	}    	
    },
    
    /**
     *  View template form tab
     */
    viewTemplateForm: function(isView) {
        var this$ = this;
        this$.editTemplateForm(isView);
        var form = this$.getDocumentTemplateTabPanel().getActiveTab();
        if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form.down('#dynamicTemplateDataTab').setVisible(false);
	        Ext.suspendLayouts();
	        form.getForm().getFields().each(function(field) {   
	        	if(field.xtype == 'ckeditor'){
	        		field.config.readOnly = true;
	        	}else{
	        		field.setReadOnly(true);
	        	}
	            
	        });
	        Ext.resumeLayouts();
	    }
    },
    /**
     * Edit template form tab
     */
    editTemplateForm: function(isView) {

        var this$ = this;
        var tabTitle = '';
        var grid = this$.getTemplateListGrid();
        
        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	if(isView){
        		tabTitle = getDocumentTranslation('VIEW_DYNAMIC_TEMPLATE')+' ' +records.get('templateName');
        	}else{
        		tabTitle = getDocumentTranslation('EDIT_DYNAMIC_TEMPLATE')+' ' +records.get('templateName');
        	}
        	
        	this.showCreateTemplate(tabTitle);
        	
            if (!isEmpty(records)) {
            	var templateId = records.get('templateId');
            	var configLevel = records.get('configLevel');
            	var form = this$.getDocumentTemplateTabPanel().getActiveTab();
            	var ckeditor= form.down('#templateCKEditor');
            	var documentCategory = form.down('#document_category');
            	var documentType = form.down('#document_type');
            	documentCategory.setValue(configLevel);
            	documentCategory.setReadOnly(true);
            	documentType.setReadOnly(true);
            	
            	var documentTypeStore = documentType.getStore();
            	documentTypeStore.proxy.extraParams = {
            			configLevel: configLevel
            	};
            	documentTypeStore.load();
            	var params = {
                    	templateId: templateId
                };

            	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            	this$.sendGetAjaxRequest(SERVERURL.DOCUMENT_TEMPLATE_FIND_BY_ID, 'GET', params, function(option, success, response) {
            		Ext.getBody().unmask();
            		if(success){
            			var data = Ext.decode(response.responseText);
            			var editor = CKEDITOR.instances[ckeditor.name];
            			/**
            			 * @author Rajkumar.patidar
            			 */
            			 //setTimeout(function(){editor.setData(data.templateContent);},0);
            			
            			/**
            			 * @author Chetan Rathod
            			 */
            		/*	Ext.defer(function() {
            				editor.on( "instanceReady", function( event ){
            					editor.setData(data.templateContent);
            				}); 
            			},500);*/
            			
            			/*editor.on( "instanceReady", function( event ){
            	           	   editor.setData(data.templateContent);
            	           	});  */
            			
            			/*if(!isEmpty(editor.document)){
            				editor.document.getBody().$.innerHTML=data.templateContent;
            			}else{
            				ckeditor.setValue(data.templateContent);
            			}*/
            			var activeTab = this$.getDocumentTemplateTabPanel().getActiveTab();
            			form.getForm().setValues(data);
            			var ckedtr = activeTab.down('#templateCKEditor');
            			//var ckedtr = Ext.ComponentQuery.query('#templateCKEditor')[0];
            			if(ckedtr != undefined){
            				//ckedtr.setValue(data.templateContent)
            				ckedtr.on('instanceReady',function(component,ele){
                				setTimeout(function(){
                					component.editor.setData(data.templateContent);
        						},300);
            					});
            			}else{
            				//ckeditor.setValue(data.templateContent);
            				ckeditor.on('instanceReady',function(component,ele){
            					setTimeout(function(){
            						component.editor.setData(data.templateContent);
        						},300);
            					});
            			}
            			
            			if(isView){
            				ckedtr.on("instanceReady", function(event){
            					event.editor.setReadOnly(true);
            				});
            			}
            			
            			//ckeditor.editor.insertText(data.templateContent);
            		}
            	});
            }
        } else {
            showWarningMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * Delete template entryDocumentTemplateMappingSearchForm
     */
    deleteTemplateEntryRecord: function() {

    	var this$ = this;
    	var grid = this$.getTemplateListGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("templateId"))) {
                                id = records[count].get("templateId");
                                var status = records[count].get("whetherDefault");
                                if(status == true){
                                	showWarningMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getDocumentTranslation('DEFAULT_TEMPLATE_CANNOT_DELETE'));
                                }else{
                                	Ext.Ajax.request({
                                        type: 'rest',
                                        url: SERVERURL.DOCUMENT_TEMPLATE_DELETE,
                                        params: {
                                        	templateId: id
                                        },
                                        method: 'DELETE',
                                        headers: {
                                            'Content-Type': 'application/json'
                                        },
                                        success: function(form, action) {
                                            grid.getStore().reload();
                                            showSuccessMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getDocumentTranslation('DOCUMENT_TEMPLATE_ENTRY_DELETE_SUCCESS'));
                                        }
                                    });
                                }
                                
                            }
                            
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  Save template entry
     */
    saveTemplateForm: function(button) {

        var this$ = this;
        var submitUrl, isUpdate = false;
        
        var form = this$.getDocumentTemplateTabPanel().getActiveTab();
        /*var ckeditor= form.down('#templateCKEditor');
        var editor = CKEDITOR.instances[ckeditor.name];
        var textValue  = editor.document.getBody().$.innerHTML;*/
        if(!isNullOrEmpty(form.down("#document_category").getValue()) 
        		&& !isNullOrEmpty(form.down("#document_type").getValue()) 
        		&& !isNullOrEmpty(form.down("#template_name").getValue())){
        	var id = form.down('#template_hidden_id');
        	if (isNullOrEmpty(id.getSubmitValue())) {
        		submitUrl = SERVERURL.DOCUMENT_TEMPLATE_ADD,
        		isUpdate = false;
        	} else {
        		submitUrl = SERVERURL.DOCUMENT_TEMPLATE_UPDATE,
        		isUpdate = true;
        	}
        	var jsonFormatFormData = this$.getTemplateJsonSubmitData(form);

        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  
        	this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        		Ext.getBody().unmask();
        		if(success){
        			form.close();
        			if (isUpdate) {
        				showSuccessMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getDocumentTranslation('DOCUMENT_TEMPLATE_ENTRY_UPDATE_SUCCESS'));
        			} else {
        				showSuccessMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getDocumentTranslation('DOCUMENT_TEMPLATE_ENTRY_ADD_SUCCESS'));
        			}
                
        		}else{
        			form.close();
        		}
        	});
        }else{
        	showWarningMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
        	return false;
        }

    },
    
    /**
     *  Get Json for template form submission
     */
    getTemplateJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var ckeditor = form.down('#templateCKEditor');
       // var editor = CKEDITOR.instances[ckeditor.name];
        var editor = CKEDITOR.instances[ckeditor.inputEl.id];
        var formData = form.getValues();
        var templateContent = editor.getData();
        var isHindiVal = form.getForm().findField('isHindi').getValue();
        formData.templateContent = templateContent;
        formData.isHindi = isHindiVal;
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    /**
     * mark as default template
     */
    markAsDefaultTemplate: function(){
    	var this$ = this;
        var grid = this$.getTemplateListGrid();
        
        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	var submitUrl = SERVERURL.DOCUMENT_TEMPLATE_MARKS_AS_DEFAULT_TEMPLATE + '?templateId='+records.get("templateId");
        	this.sendSaveAjaxRequest(submitUrl, 'POST', null, function(option, success, response) {
            	if(success){
            		showSuccessMessage(getDocumentTranslation('TEMPLATE_MANAGMENT'), getDocumentTranslation('SET_AS_DEFAULT_TEMPLATE'));
            		grid.getStore().load();
        		}
            });
        }
    },
    /**
     * load document type combo
     */
    loadDocumentTypeComboLoad: function(form, combo){
    	var configLevel = combo.getValue();
    	var documentType = form.down('#document_type');
    	documentType.reset();
    	var store = documentType.getStore();
    	store.proxy.extraParams = {
    			configLevel: configLevel
    	};
    	store.load();
    },
    
    /**
     * 
     */
    loadDocumentTemplateMappingGrid: function(){
    	var this$ = this;
    	var ownerId = '';
    	var flagColourId = '';
    	var form = this$.getDocumentTemplateMappingSearchForm();
    	var formvalues = form.getValues();
        var grid = this$.getDocumentTemplateMappingGrid();
    	var store = grid.getStore();
    	
    	var flagColor = []
    	
    	if(formvalues.flagNameColor){ for(var i=0; i< formvalues.flagNameColor.length ;i++){
    		 flagColor.push(formvalues.flagNameColor[i].data.flagColorId)
        }}
    	
    	
    	flagColor = flagColor.join()
    	
    	switch(formvalues.configLevel) {
	    	case 'ACADEMY_LOCATION_LEVEL':
	    		ownerId = formvalues.academyLocationId;
	    		break;
	    	case 'COURSE_LEVEL':
	    		ownerId = formvalues.courseId;
	    		break;
	    	case 'COMMUNITY_LEVEL':
	    		ownerId = formvalues.communityId;
	    		break;
	    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
	    		var seatType = form.down('#seatTypeCombo');
	    		ownerId = seatType.progBatchSeatConfigId;
	    		break;
	    	case 'FLAG_NOTIFICATION':
	    		ownerId = formvalues.flagIdName;
	    		flagColorId = flagColor
	    		break;
    	}
    	
    	if(formvalues.flagNameColor){
    		store.proxy.extraParams = {
        			ownerId: ownerId,
        			flagColorId:flagColorId,
        			configLevel: formvalues.configLevel
        	};
        	store.load();
    	}
    	else{
    		store.proxy.extraParams = {
        			ownerId: ownerId,
        			configLevel: formvalues.configLevel
        	};
    		store.load();
    	}
    	
    	//store.sorters.clear();
    
    	
    	grid.getSelectionModel().deselectAll(true);
    	Ext.apply(form,{
	   		 gridData:null,
	   	     setGridData : function(gridData){
	   	    	 form.gridData = gridData;
	   	     },
	   	     getGridData:function(){
	   	     return form.gridData;
	   	     }
    	});
    	form.setGridData(formvalues);
   	

    },
    
    addContainerToMappingSearchForm: function(form, value){
    	var container = this.addDocumentCategoryMappingTemplate(value, true);
    	if(form.getComponent(1).getItemId() != 'documentTemplateButtonContainer'){
    		form.remove(1);
    	}
    	form.insert(1, container);
    },
    
    addContainerToMappingForm: function(form, value){
    	var container = this.addDocumentCategoryMappingTemplate(value, false);
    	if(form.getComponent(4).getItemId() != 'buttonContainer'){
    		form.remove(4);
    	}
    	form.insert(4, container);
    },
    /**
     * addDocumentCategoryMappingTemplate
     */
    addDocumentCategoryMappingTemplate: function(value, isMappingSearchForm){
    	var $this = this;
    	var academyLocationId = $this.getCurrentAcademyLocation();
    	var form = this.getDocumentTemplateMappingForm();
    	if(form) {
    		form.down('#useDefaultTemplate').removeCls('display-none');
    	}
    	var container = {
   			 xtype: 'fieldcontainer',
   			 plugins: "formlabelrequired",
   			 //padding: (isMappingSearchForm)?10:0,
    	        layout: {
    	            type: 'hbox'
    	        },
    	        defaults: {
    	        	width: 226,
    	            labelAlign: 'top'
    	        },
    	        items:[]
    	};
    	switch(value) {
    	
    	case 'ACADEMY_LOCATION_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('ACADAMY_LOCATION'),
                allowBlank: false,
                //editable: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                minChars:3,
    			queryParam:'qry',
    			typeAhead:false,
    			hideTrigger:false,
                labelAlign: 'top',
                width: 452,
                name: 'academyLocationId',
                itemId: 'acadamyLocationId',
                valueField: 'id',
                displayField: 'value',
                listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			},
                listeners: {
                    render: function(combo) {
                       // var store = Ext.create('Academia.store.organization.academylocations.AcademyLocationStore');
                        var store = Ext.create('Academia.store.attendance.attendancereport.AcadmyByAdmission');
                        combo.bindStore(store);
                    },
                    afterrender: function(combo){
                    	var academyLocationStore = combo.getStore();
                    	
                    	academyLocationStore.load({
                			callback: function(records, operation, success) {
                				if (success) {
                					combo.setValue(academyLocationId);
                				}
                			}
                		});
                    }
                }
	        }];
    		break;
    	case 'COURSE_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('ACADAMY_LOCATION'),
                allowBlank: false,
                //editable: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                minChars:3,
    			queryParam:'qry',
    			typeAhead:false,
    			hideTrigger:false,
                labelAlign: 'top',
                width: 452,
                name: 'academyLocationId',
                itemId: 'acadamyLocationCourseId',
                valueField: 'id',
                displayField: 'value',
                listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			},
                listeners: {
                    render: function(combo) {
                       // var store = Ext.create('Academia.store.organization.academylocations.AcademyLocationStore');
                    	var store = Ext.create('Academia.store.attendance.attendancereport.AcadmyByAdmission');
                        combo.bindStore(store);
                    },
                    afterrender: function(combo){
                    	var academyLocationStore = combo.getStore();
                    	
                    	academyLocationStore.load({
                			callback: function(records, operation, success) {
                				if (success) {
                					combo.setValue(academyLocationId);
                				}
                			}
                		});
                    }
                }
                
	        }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
                allowBlank: false,
                //editable: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                minChars:3,
                queryParam:'name',
    			typeAhead:false,
    			hideTrigger:false,
                labelAlign: 'top',
                width: 226,
                name: 'courseId',
                itemId: 'courseId',
                valueField: 'id',
                displayField: 'value',
                listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			},
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.course.CourseComboStore');
                        if(!isNullOrEmpty(academyLocationId)){
                        	store.proxy.extraParams = {
                        			academyLocationId: academyLocationId
                        	};
                        }
                        combo.bindStore(store);
                    }
                }
	        }];
    		break;
    	case 'COMMUNITY_LEVEL':
    		container.items = [{
                xtype: 'customcombobox',
                fieldLabel: getDocumentTranslation('COMMUNITY'),
                allowBlank: false,
                //editable: false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                minChars:3,
                queryParam:'name',
    			typeAhead:false,
    			hideTrigger:false,
                labelAlign: 'top',
                width: 226,
                name: 'communityId',
                itemId: 'communityId',
                valueField: 'id',
                displayField: 'value',
                listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			},
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.DocumentTemplateMappingCommunityComboStore');
                        combo.bindStore(store);
                    }
                }
            }];
    		break;
    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
    		container = {
    			xtype: 'alprogrambatchseattypeformnew',
            	itemId: 'alprogrambatchseattypeformnew',
            	margin: (isMappingSearchForm)?'-10px':0,
    			listeners: {
    				afterrender: function(form){
    					var combo = form.down('#academy_loc_combo');
    					var academyLocationStore = combo.getStore();
    					academyLocationStore.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								combo.setValue(academyLocationId);
    							}
    						}
    					});
    					
    					var programCombo = form.down('#programCombo');
    					var programStore = programCombo.getStore();
    					programStore.getProxy().extraParams = {
    						academyLocationIds: academyLocationId
    					};
    					programStore.load();
    				}
    			}
    		};
    		break;
    	case 'FLAG_NOTIFICATION':
    		if(form) {
    			form.down('#useDefaultTemplate').addCls('display-none');
    			form.down('#useDefaultTemplate').reset();    			
    		}
    		container.items = [{
                xtype: 'customcombobox',
                name: 'flagIdName',
                fieldLabel: getDocumentTranslation('FLAG_ID_NAME'),
                itemId: 'flagIdNameId',
                editable: false,
                allowBlank: false,
                valueField: 'id',
                displayField: 'valueCode',
                store:Ext.create('Academia.store.documentmanagement.ActiveFlagsStore'),
//                msgTarget: 'qtip',
                listeners: {
                    change: function(combo) {
                    	combo.nextSibling().reset();
                    	var store = combo.nextSibling().getStore();
                    	store.getProxy().extraParams = {
                        		flagIds: combo.getValue()
                        };
                    	store.load()
//                        var store = Ext.create('Academia.store.documentmanagement.ActiveFlagsStore');
//                        combo.bindStore(store);
                    }
                }
            },{
    			xtype: 'multiselectcombofield',			
    			name: 'flagNameColor',
    			cls:'multiBrandCampusCls',
    			itemId: 'flagNameColorId',
    			fieldLabel: getDocumentTranslation('FLAG_NAME_COLOR'),
    			store:Ext.create('Academia.store.documentmanagement.FlagColorByFlagIdsStore'),
    			queryParam:'qry',
    			displayField: 'valueCode',
    			valueField: 'flagColorId',
    			typeAhead : false,
    			allowBlank:false,
    			forceSelection:true,
    			editable: false,
    			hideTrigger:false,
    			triggerAction: 'all',
    			maxLength: 10000,
    			autoloadStore: false,
    			cls:'ProgramCourseMultiselectField',           
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code} / {value}'+ 
    					'</div>';
    				}
    			}
    		}];
    		break
    	}
    	
    	return container;
    },
    
    /**
     * This method is used to open document template mapping window
     */
    showDocumentTemplateMappingWindow: function(title, itemId) {
    	
    	var this$ = this;
    	var formWindow = this$.getAddDoumentTemplateMappingWindow();
    	if(!formWindow){
    		formWindow = Ext.widget('adddoumenttemplatemappingwindow',{
    			title: title,
    			itemId: itemId
    		});
    	}
    	
    	formWindow.show();
    },
    /**
     *  View Document template mapping form window
     */
    viewDocumentTemplateMappingWindow: function(title, itemId) {
        var this$ = this;
        this$.editDocumentTemplateMappingWindow(title, itemId);
        var form = this$.getDocumentTemplateMappingForm();
        if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
    },
    /**
     * Edit Document form window
     */
    editDocumentTemplateMappingWindow: function(title, itemId) {

        var this$ = this;
        var grid = this$.getDocumentTemplateMappingGrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showDocumentTemplateMappingWindow(title, itemId);
            var form = this$.getDocumentTemplateMappingForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	var category = form.down('#document_category');
            	var documentType = form.down('#document_type');
            	var templateName = form.down('#templateName');
            	category.setReadOnly(true);
            	documentType.setReadOnly(true);
            	documentType.reset();
            	templateName.reset();
            	
            	category.setValue(records.get('configLevel'));
            	
            	var documentTypeStore = documentType.getStore();
            	documentTypeStore.proxy.extraParams = {
            			configLevel: records.get('configLevel')
            	};
            	documentTypeStore.load({
            		 callback: function(rec, operation, success) {
            			   if (success) {
            				   for(var i in rec){
            					   if(rec[i].data.documentTypeId==records.data.documentTypeId)
            						   documentType.setValue(rec[i].data.documentTypeId);
            				   }
            			   }
            		 }
            	});
            	
            	var templateNameStore = templateName.getStore();
            	templateNameStore.proxy.extraParams = {
            			limit: '-1',
            			configLevel: records.get('configLevel'),
            			documentTypeId: records.get('documentTypeId')
            	};
            	templateNameStore.load({
           		 callback: function(rec, operation, success) {
      			   if (success) {
      				   for(var i in rec){
      					   if(rec[i].data.templateId==records.data.templateId)
      						 templateName.setValue(rec[i].data.templateId);
      				   }
      			   }
           		 }
            	});
            	form.loadRecord(records);
            	if(records.data.configLevel=="FLAG_NOTIFICATION"){
            		var useDefaultTemplate = form.down('#useDefaultTemplate');
            		//useDefaultTemplate.setVisible(false);
            		form.down('#useDefaultTemplate').addCls('display-none');
        			form.down('#useDefaultTemplate').reset();
            	}
            	if(records.data.configLevel=="PROGRAM_BATCH_SEAT_TYPE_LEVEL"){
            		var alForm = this$.getAlprogrambatchseattypeformnew().getForm();
            		var values = alForm.getValues();
            		this$.addContainerToMappingForm(form, this$.getAddDoumentTemplateMappingWindow().down("#document_category").getValue());
            		this$.loadDocumentTypeComboLoad(form, this$.getAddDoumentTemplateMappingWindow().down("#document_category"));
            		var filterForm = this$.getAlprogrambatchseattypeformnew().getForm();
            		var gridData = this$.getDocumentTemplateMappingSearchForm().getGridData();
            		
            		form.getForm().findField('academy_location_id').getStore().load({
            			callback: function(rec, operation, success) {
             			   if (success) {
             				 console.log(rec);
             				   for(var i in rec){
             					   if(rec[i].data.id==gridData.academy_location_id.id)
             						  form.getForm().findField('academy_location_id').setValue(rec[i].data.id);
             				   }
             			   }
             		 }
            		});
            		/*form.getForm().findField('location').getStore().getProxy().extraParams={
            			academyId:values.academy.id
            		}
            		form.getForm().findField('location').getStore().load({
            			callback: function(rec, operation, success) {
             			   if (success) {
	             				for(var i in rec){
	          					   if(rec[i].data.id==gridData.location.id)
	          						 form.getForm().findField('location').setValue(rec[i].data.id);
	          				   }
             			   }
             		 }
            		});*/
            		form.getForm().findField('program').getStore().getProxy().extraParams = {
            			academyLocationIds:values.academy_location_id
            			//locationId:values.location.id
            		};
            		form.getForm().findField('program').getStore().load({
            			callback: function(rec, operation, success) {
             			   if (success) {
	             				for(var i in rec){
		          					   if(rec[i].data.id==gridData.program.id)
		          						 form.getForm().findField('program').setValue(rec[i].data.id);
		          				   }
             			   }
             		 }
            		});
            		form.getForm().findField('batch').getStore().getProxy().extraParams = {
            			id:values.program.id
            		};
            		form.getForm().findField('batch').getStore().load({
            			callback: function(rec, operation, success) {
             			   if (success) {
             				 for(var i in rec){
	          					   if(rec[i].data.id==gridData.batch.id)
	          						 form.getForm().findField('batch').setValue(rec[i].data.id);
	          				   }
             			   }
             		 }
            		});
            		form.getForm().findField('seatType').getStore().getProxy().extraParams = {
            			batchId:values.batch.id
            		};
            		form.getForm().findField('seatType').getStore().load({
            			callback: function(rec, operation, success) {
             			   if (success) {
             				 for(var i in rec){
	          					   if(rec[i].data.seatType.id==gridData.seatType.id)
	          						 form.getForm().findField('seatType').setValue(rec[i].data.seatType.id);
	          				   }
             			   }
            			}
            		});
            		form.getForm().findField('academy_location_id').setReadOnly(true);
            		//form.getForm().findField('location').setReadOnly(true);
            		form.getForm().findField('program').setReadOnly(true);
            		form.getForm().findField('batch').setReadOnly(true);
            		form.getForm().findField('seatType').setReadOnly(true);
                }
            }
        } else {
            showWarningMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * save document template mapping
     */
    saveDocumentTemplateMapping: function(){
    	var this$ = this;
        var submitUrl, isUpdate = false;
        
        var grid = this$.getDocumentTemplateMappingGrid();
        var records = grid.getSelectionModel().getSelection()[0];
        var form = this$.getDocumentTemplateMappingForm();
        var formPopupVal = form.getValues()
        var searchForm = this$.getDocumentTemplateMappingSearchForm();
    	var formvalues = searchForm.getValues();
    	var store = grid.getStore();
    	switch(formvalues.configLevel) {
	    	case 'ACADEMY_LOCATION_LEVEL':
	    		ownerId = formvalues.academyLocationId;
	    		break;
	    	case 'COURSE_LEVEL':
	    		ownerId = formvalues.courseId;
	    		break;
	    	case 'COMMUNITY_LEVEL':
	    		ownerId = formvalues.communityId;
	    		break;
	    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
	    		var seatType = searchForm.down('#seatTypeCombo');
	    		ownerId = seatType.progBatchSeatConfigId;
	    		break;
	    	case 'FLAG_NOTIFICATION':
	    		ownerId = formPopupVal.flagIdName;
	    		break
    	}
    	store.proxy.extraParams = {
    			ownerId: ownerId,
    			configLevel: formvalues.configLevel
    	};
    	
        var id = form.down('#template_hidden_id');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.DOCUMENT_TEMPLATE_MAPPING_ADD,
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.DOCUMENT_TEMPLATE_MAPPING_UPDATE,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getTemplateMappingJsonSubmitData(form, isUpdate, records);
        this$.applyWindowMask(); 
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
        		this$.getAddDoumentTemplateMappingWindow().close();
                if (isUpdate) {
                    showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getDocumentTranslation('TEMPLATE_MAPPING_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getDocumentTranslation('TEMPLATE_MAPPING_ADD_SUCCESS'));
                }
                grid.getSelectionModel().deselectAll(true);
            	store.load();
    		}
        });
    	
    },
    /**
     * get json for template mapping
     */
    getTemplateMappingJsonSubmitData: function(form, isUpdate, records){
    	var this$ = this;
    	var ownerId = null;
        var jsonFormFieldData = new Object();
        var formData = new Object();
        var formValues = form.getValues();
        if(!isUpdate){
	        	switch(formValues.configLevel) {
		    	case 'ACADEMY_LOCATION_LEVEL':
		    		ownerId = formValues.academyLocationId;
		    		formData.academyLocationIds = ownerId;
		    		break;
		    	case 'COURSE_LEVEL':
		    		ownerId = formValues.courseId;
		    		formData.academyLocationIds = formValues.academyLocationId;
		    		break;
		    	case 'COMMUNITY_LEVEL':
		    		ownerId = formValues.communityId;
		    		break;
		    	case 'PROGRAM_BATCH_SEAT_TYPE_LEVEL':
		    		var seatType = form.down('#seatTypeCombo');
		    		//ownerId = seatType.getValue();
		    		formData.academyLocationIds = formValues.academy_location_id;
		    		ownerId = seatType.progBatchSeatConfigId;
		    		break;
		    	case 'FLAG_NOTIFICATION':
//		    		var flagIdName = form.down('#flagIdName');
		    		ownerId = formValues.flagIdName;
		    		var flagColor = Ext.Array.pluck(Ext.Array.pluck(formValues.flagNameColor, 'data'), 'flagColorId').join();
		    		formData.flagColorIds = flagColor;
		    		break
	        }
        }
        
        formData.id = formValues.id;
        formData.documentTypeId = formValues.documentTypeId;
        if(isUpdate){
        	formData.ownerId = records.get('ownerId');
        }else{
        	formData.ownerId = ownerId;
        }
        
        formData.templateId = formValues.templateId;
        formData.useDefaultTemplate = formValues.useDefaultTemplate;
        formData.whetherActive = formValues.whetherActive;
        
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    	
    },
    
    /**
     * Delete template mapping entry
     */
    deleteTemplateMappingEntryRecord: function() {

    	var this$ = this;
    	var grid = this$.getDocumentTemplateMappingGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.DOCUMENT_TEMPLATE_MAPPING_DELETE + id,
                                    method: 'DELETE',
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    success: function(form, action) {
                                        grid.getStore().reload();
                                        showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getDocumentTranslation('DOCUMENT_TEMPLATE_MAPPING_DELETE_SUCCESS'));
                                    }
                                });
                            }
                            
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    
    visibleFormComponent: function(form, visibleFieldArray, visibility){
    	if(form && !isEmpty(visibleFieldArray)){
    		for(var i = 0; i < visibleFieldArray.length; i++){
        		if(form.down('#'+visibleFieldArray[i])){
        			form.down('#'+visibleFieldArray[i]).setVisible(visibility);
        		}
        		
        	}
    	}
    },

    disableFormComponent: function(form, disableFieldArray, status){
    	if(form && !isEmpty(disableFieldArray)){
    		for(var i = 0; i < disableFieldArray.length; i++){
        		if(form.down('#'+disableFieldArray[i])){
        			form.down('#'+disableFieldArray[i]).setDisabled(status);
        		}
        		
        	}
    	}
    },
    
    resetFormComponent: function(form, resetFieldArray){
    	if(form && !isEmpty(resetFieldArray)){
    		for(var i = 0; i < resetFieldArray.length; i++){
        		if(form.down('#'+resetFieldArray[i])){
        			form.down('#'+resetFieldArray[i]).reset();
        		}
        		
        	}
    	}
    },
    
    /**
     * This function is to enable default template button
     */
    enableDefaultTemplatePivileges: function(gridReference, permissionsMap, itemId) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var defaultTemplateBtn = gridReference.down("#markDefaultTemplateButton"); 
        defaultTemplateBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'DEFAULTTEMPLATE') {
                if (!isNullOrEmpty(defaultTemplateBtn)) {
                	defaultTemplateBtn.setVisible(true); 
                }
            } 
        });
    },
    
    /**
     * This function is to hide/show the apply to button by permission
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var applyToBtn = gridReference.down('#btnApplyTo');
    	if(!isNullOrEmpty(applyToBtn)){
    		applyToBtn.setVisible(false);
    	} 
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'APPLICABLEFOR') {
    			if(!isNullOrEmpty(applyToBtn)){
    				applyToBtn.setVisible(true);
    			}        		
    		}
    	});
    },
    openApplyToTab: function(){
		var $this=this;
		var grid = $this.getDocumentTemplateMappingGrid();
		var gridData = grid.getSelectionModel().getSelection()[0];
		if (grid.getSelectionModel().getCount() > 0) {
			if(grid.getSelectionModel().getCount() == 1) {
				var record = grid.getSelectionModel().getSelection();
				
				var configLevel = record[0].get('configLevel');
				
				var tabName = getExaminationTranslation('APPLY_TO');
				var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				
				if(configLevel == "ACADEMY_LOCATION_LEVEL"){
					var applyToGrid = structure.query('documenttemplatemappingapplytogrid')[0];
					var documentApplyToGridStore = applyToGrid.getStore();
					if(!isNullOrEmpty(record)){
						structure.config.documentTemplateGridRecord = record[0];
						documentApplyToGridStore.getProxy().extraParams={
							templateId: record[0].get('templateId'),
							ownerId:record[0].get('ownerId'),
							documentTypeId: parseInt(record[0].get('documentTypeId')),
							configLevel:record[0].get('configLevel')
						};
					}
					documentApplyToGridStore.sorters.clear();
					documentApplyToGridStore.removeAll();
					documentApplyToGridStore.load();
					
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
				}
				else if(configLevel == "COURSE_LEVEL"){
					var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
					applyToALGrid.setVisible(false);
					
					var applyToGrid = structure.query('documenttemplatemappingapplytocoursegrid')[0];
					applyToGrid.setVisible(true);
					var documentApplyToGridStore = applyToGrid.getStore();
					if(!isNullOrEmpty(record)){
						structure.config.documentTemplateGridRecord = record[0];
						documentApplyToGridStore.getProxy().extraParams={
							templateId: record[0].get('templateId'),
							documentTypeId:record[0].get('documentTypeId'),
							ownerId:record[0].get('ownerId'),
							configLevel:record[0].get('configLevel')
						};
					}
					documentApplyToGridStore.sorters.clear();
					documentApplyToGridStore.removeAll();
					documentApplyToGridStore.load();
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
				}
				else if(configLevel == "COMMUNITY_LEVEL"){
					var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
					applyToALGrid.setVisible(false);
					
					var applyToGrid = structure.query('documenttemplatemappingapplytocommunitygrid')[0];
					applyToGrid.setVisible(true);
					var documentApplyToGridStore = applyToGrid.getStore();
					if(!isNullOrEmpty(record)){
						structure.config.documentTemplateGridRecord = record[0];
						documentApplyToGridStore.getProxy().extraParams={
							templateId: record[0].get('templateId'),
							documentTypeId:record[0].get('documentTypeId'),
							configLevel:record[0].get('configLevel')
						};
					}
					documentApplyToGridStore.sorters.clear();
					documentApplyToGridStore.removeAll();
					documentApplyToGridStore.load();
					
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
				}
				else if(configLevel == "PROGRAM_BATCH_SEAT_TYPE_LEVEL"){
					var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
					applyToALGrid.setVisible(false);
					
					var applyToGrid = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
					applyToGrid.setVisible(true);
					var documentApplyToGridStore = applyToGrid.getStore();
					if(!isNullOrEmpty(record)){
						structure.config.documentTemplateGridRecord = record[0];
						documentApplyToGridStore.getProxy().extraParams={
							templateId: record[0].get('templateId'),
							documentTypeId:record[0].get('documentTypeId')
						};
					}
					documentApplyToGridStore.sorters.clear();
					documentApplyToGridStore.removeAll();
					documentApplyToGridStore.load();
					
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
				}
			} else {
				 showWarningMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			 }
			
		}else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	openAddDocumentMappingApplyToTab: function(){
		var contentpanel = this.getContentPanel();
		var committeemappingtabstructure = Ext.widget('documenttemplatemappingaddalmappingtab');
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_THIRTEEN);
		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddalstructure();
		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
		var academylocationgrid = this.getDocumenttemplatemappingaddalgrid();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker();
		var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			committeeaddmappingstructure.down("#lblTemplateName").setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	openAddDocumentMappingApplyToCourseTab: function(){
		var contentpanel = this.getContentPanel();
		var committeemappingtabstructure = Ext.widget('documenttemplatemappingaddalmappingtab');
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		//var committeeaddmappingstructure = committeemappingtabstructure.down('committeeaddmappingstructure');
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_THIRTEEN);
		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddcoursestructure();
		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
		var academylocationgrid = committeeaddmappingstructure.down('#academylocationgridDocumentCourseItemId');
		var documenttemplatemappingstructureFld = committeemappingtabstructure.down('#documenttemplatemappingstructureItemId');
		committeeaddmappingstructure.setVisible(true);
		documenttemplatemappingstructureFld.setVisible(false);
		academylocationgrid.down('#nextButton').setVisible(true);
		academylocationgrid.down('#submitBtn').setVisible(false);
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker();
		var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			committeeaddmappingstructure.down("#lblTemplateName").setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	openAddDocumentMappingApplyToCommunityTab: function(){
		var contentpanel = this.getContentPanel();
		var committeemappingtabstructure = Ext.widget('documenttemplatemappingaddalmappingtab');
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_THIRTEEN);
		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddcommunitystructure();
		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
		
		var documenttemplatemappingstructureFld = committeemappingtabstructure.down('#documenttemplatemappingstructureItemId');
		committeeaddmappingstructure.setVisible(true);
		documenttemplatemappingstructureFld.setVisible(false);
		
		var academylocationgrid = this.getDocumenttemplatemappingaddcommunitygrid();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker();
		var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			committeeaddmappingstructure.down("#lblTemplateName").setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	openAddDocumentMappingApplyToProgramBatchTab: function(){
		var contentpanel = this.getContentPanel();
		var committeemappingtabstructure = Ext.widget('documenttemplatemappingaddalmappingtab');
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		//var committeeaddmappingstructure = committeemappingtabstructure.down('committeeaddmappingstructure');
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_THIRTEEN);
		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
		var academylocationgrid = committeeaddmappingstructure.down('#academylocationgridDocumentProgramBatchItemId');
		var documenttemplatemappingstructureFld = committeemappingtabstructure.down('#documenttemplatemappingstructureItemId');
		committeeaddmappingstructure.setVisible(true);
		documenttemplatemappingstructureFld.setVisible(false);
		academylocationgrid.down('#nextButton').setVisible(true);
		academylocationgrid.down('#submitBtn').setVisible(false);
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker();
		var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			committeeaddmappingstructure.down("#lblTemplateName").setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	academyLocationNextEventCourseDocumentMapping:function(btn){
		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddcoursestructure();
		var academylocationgrid = committeeaddmappingstructure.down('#academylocationgridDocumentCourseItemId');
		//var academylocationgrid = this.getCommitteeaddmappingalgrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
	    	var committeeaddmappingstructure = this.getDocumenttemplatemappingaddcoursestructure();
	    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
	    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
	    	var courseContainer = committeeaddmappingstructure.down('#courseContainerId');
	    	courseContainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(courseContainer);
	    	var alCourseGrid = this.getDocumenttemplatemappingaddcoursegrid();
	    	var alCourseSearchCombo = alCourseGrid.down('#courseId');
	    	alCourseSearchCombo.reset();
	    	alCourseSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alCourseSearchCombo.getStore().load();
	    	var alCourseGridStore = alCourseGrid.getStore();
	    	alCourseGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alCourseGridStore.clearFilter();
	    	alCourseGridStore.load();
	    	this.setProgressTracker(1);
	    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				committeeaddmappingstructure.down("#lblTemplateNamecourseTab").setValue(recordsCommitteeGrid.get('templateName'));
				committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
				committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    academyLocationNextEventProgram:function(btn){
    	var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var programGroupgrid = committeeaddmappingstructure.down('#documenttemplatemappingaddprogramGroupgridItemId');
    	var academylocationgrid = committeeaddmappingstructure.down('#academylocationgridDocumentProgramBatchItemId');
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	
    	//var academylocationgrid = this.getCommitteeaddmappingalgrid();
    	var selectionModel = programGroupgrid.getSelectionModel().getSelection();
    	var programGroupIdsArr = [];
    	selectionModel.forEach(function(obj){
    		programGroupIdsArr.push(obj.get('longValue'));
    	});
    	if(programGroupIdsArr.length > 0){
    		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    		var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    		var programcontainer = committeeaddmappingstructure.down('#programContainerId');
    		programcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programcontainer);
    		var alProgramGrid = this.getDocumenttemplatemappingaddprogramgrid();
    		var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
    		alProgramSearchCombo.reset();
    		alProgramSearchCombo.getStore().getProxy().extraParams= {
    			programGroupId: programGroupIdsArr.join(),
    			academyLocationIds:academyLocationIdsArr.join()
    		};
    		alProgramSearchCombo.getStore().load();
    		var alProgramGridStore = alProgramGrid.getStore();
    		
    		alProgramGridStore.getProxy().extraParams= {
    			programGroupId: programGroupIdsArr.join(),
    			academyLocationIds:academyLocationIdsArr.join()
	    	};
    		alProgramGridStore.clearFilter();
    		alProgramGridStore.load();
    		this.setProgressTracker(2);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){

    			committeeaddmappingstructure.down("#lblTemplateNameProgramTab").setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    academyLocationNextEventProgramGroup:function(btn){
    	var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var academylocationgrid = committeeaddmappingstructure.down('#academylocationgridDocumentProgramBatchItemId');
    	//var academylocationgrid = this.getCommitteeaddmappingalgrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
    		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    		var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    		var programGroupcontainer = committeeaddmappingstructure.down('#programGroupContainerId');
    		programGroupcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programGroupcontainer);
    		var alProgramGroupGrid = this.getDocumenttemplatemappingaddprogramgroupgrid();
    		var alProgramGroupSearchCombo = alProgramGroupGrid.down('#programGroupsearchcombo');
    		alProgramGroupSearchCombo.reset();
    		alProgramGroupSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		alProgramGroupSearchCombo.getStore().load();
    		var alProgramGroupGridStore = alProgramGroupGrid.getStore();
    		
    		alProgramGroupGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
    		alProgramGroupGridStore.clearFilter();
    		alProgramGroupGridStore.load();
    		this.setProgressTracker(1);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){

    			committeeaddmappingstructure.down("#lblTemplateNameProgramTab").setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#lblTemplateNameProgramGroupTab').setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    programNextEventOnProgram:function(btn){
    	var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var alProgramGrid = this.getDocumenttemplatemappingaddprogramgrid();
    	var selectionModel = alProgramGrid.getSelectionModel().getSelection();
    	
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		if(alprogramgridIdsArr.indexOf(obj.get('academyLocationId')) == -1){
    			alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		}
    		if(programIdsArr.indexOf(obj.get('programId')) == -1){
    			programIdsArr.push(obj.get('programId'));
    		}
    	});
    	
    	if(programIdsArr.length > 0){
    		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    		var programbatchcontainer = committeeaddmappingstructure.down('#programbatchcontainer');
    		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    		var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    		programbatchcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programbatchcontainer);
    		var alProgramBatchGrid = this.getDocumenttemplatemappingaddprogrambatchgrid();
    		
    		var alProgramBatchSearchCombo = alProgramBatchGrid.down('#programbatchsearchcombo');
    		alProgramBatchSearchCombo.reset();
    		alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: alprogramgridIdsArr.join(),
    			programIds:programIdsArr.join()
    		};
    		alProgramBatchSearchCombo.getStore().load();
    		
    		var alProgramBatchGridStore = alProgramBatchGrid.getStore();
    		
    		alProgramBatchGridStore.getProxy().extraParams= {
    			academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		page:1,
    			start:0,
    			limit:-1,
	    	};
    		alProgramBatchGridStore.clearFilter();
    		alProgramBatchGridStore.load();
    		
    		this.setProgressTracker(3);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){

    			committeeaddmappingstructure.down("#lblTemplateNameProgramBatchTab").setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    programNextEventOnProgramBatchTab: function(btn){

    	var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var alProgramBatchGrid = this.getDocumenttemplatemappingaddprogrambatchgrid();
    	var selectionModel = alProgramBatchGrid.getSelectionModel().getSelection();
    	
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	var batchIdsArr = [];
    	selectionModel.forEach(function(obj){
    		if(alprogramgridIdsArr.indexOf(obj.get('academyLocationId')) == -1){
    			alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		}
    		if(programIdsArr.indexOf(obj.get('programId')) == -1){
    			programIdsArr.push(obj.get('programId'));
    		}
    		if(batchIdsArr.indexOf(obj.get('batchId')) == -1){
    			batchIdsArr.push(obj.get('batchId'));
    		}
    	});
    	
    	if(batchIdsArr.length > 0){
    		var committeeaddmappingstructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    		var programbatchSeatTypecontainer = committeeaddmappingstructure.down('#programbatchseattypecontainer');
    		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    		var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    		programbatchSeatTypecontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programbatchSeatTypecontainer);
    		
    		var alprogrambatchseartypegrid = this.getDocumenttemplatemappingaddprogrambatchseattypegrid();
    		
    		/*var alProgramSearchCombo = alProgramBatchGrid.down('#programsearchcombo');
    		alProgramSearchCombo.reset();
    		alProgramSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		alProgramSearchCombo.getStore().load();*/
    		
    		var alProgramBatchSeatGridStore = alprogrambatchseartypegrid.getStore();
    		
    		alProgramBatchSeatGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		batchIds:batchIdsArr.join()
	    	};
    		alProgramBatchSeatGridStore.clearFilter();
    		alProgramBatchSeatGridStore.load();
    		
    		this.setProgressTracker(4);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){

    			committeeaddmappingstructure.down("#lblTemplateNameProgramBatchSeatTab").setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateName').setValue(recordsCommitteeGrid.get('templateName'));
    			committeemappingtabstructure.down('#documentTemplateMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    
    },
    setProgressTracker : function(progresstracker){
    	var structure = this.getDocumenttemplatemappingaddalmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
		var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
		
		var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
		var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
		var configLevelVal = recordsCommitteeGrid.get('configLevel');
			
    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    		
    		if(configLevelVal == "PROGRAM_BATCH_SEAT_TYPE_LEVEL"){
    			progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    			progresstracker3.textEl.addCls("inProgressCss-progress-text");
    			progresstracker3.updateText("Step 3 In Progress");
			}
    	}
    	
    	if(progresstracker==3){
			for(var i = 0; i < 11; i ++ ){
				progresstracker3.updateProgress((i * 0.1), '');
			}
			progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker4.textEl.addCls("inProgressCss-progress-text");
			progresstracker4.updateText("Step 4 In Progress");
			progresstracker3.textEl.removeCls("inProgressCss-progress-text");
			progresstracker3.textEl.addCls("custom-progress-text");
			progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
		} 
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    	
    },
    resetProgressTracker : function(){
    	var structure = this.getDocumenttemplatemappingaddalmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    	progresstracker3.reset();
    	progresstracker3.updateText('');
    	progresstracker4.reset();
    	progresstracker4.updateText('');
    },
    openViewDocumentMappingALWindow: function(){
    	var $this=this;
    	var grid = $this.getDocumenttemplatemappingapplytogrid();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getDocumenttemplateapplytoalviewwindow();
    		if (!formWindow) {
    			formWindow = Ext.widget('documenttemplateapplytoalviewwindow');
    			formWindow.down('#configLevel').setValue(getDocumentTranslation(recordsCommitteeGrid.get('configLevel')));
    			formWindow.down('#documentTypeId').setValue(recordsCommitteeGrid.get('documentTypeName'));
    			formWindow.down('#templateId').setValue(recordsCommitteeGrid.get('templateName'));
    			formWindow.down('#academyLocationId').setValue(gridData.get('academyLocationName'));
    		}
    		formWindow.show();
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openViewDocumentMappingALCourseWindow: function(){
    	var $this=this;
    	var grid = $this.getDocumenttemplatemappingapplytocoursegrid();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getDocumenttemplateapplytoalviewwindow();
    		if (!formWindow) {
    			formWindow = Ext.widget('documenttemplateapplytoalviewwindow');
    			formWindow.down('#courseCodeFldCont').setVisible(true);
    			formWindow.down('#configLevel').setValue(getDocumentTranslation(recordsCommitteeGrid.get('configLevel')));
    			formWindow.down('#documentTypeId').setValue(recordsCommitteeGrid.get('documentTypeName'));
    			formWindow.down('#templateId').setValue(recordsCommitteeGrid.get('templateName'));
    			formWindow.down('#academyLocationId').setValue(gridData.get('academyLocationName'));
    			formWindow.down('#courseCodeName').setValue(gridData.get('academyLocationName'));
    		}
    		formWindow.setHeight(300);
    		formWindow.show();
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openViewDocumentMappingCommunityWindow: function(){
    	var $this=this;
    	var grid = $this.getDocumenttemplatemappingapplytocommunitygrid();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getDocumenttemplateapplytoalviewwindow();
    		if (!formWindow) {
    			formWindow = Ext.widget('documenttemplateapplytoalviewwindow');
    			formWindow.down('#communityId').setVisible(true);
    			formWindow.down('#academyLocationId').setVisible(false);
    			formWindow.down('#configLevel').setValue(getDocumentTranslation(recordsCommitteeGrid.get('configLevel')));
    			formWindow.down('#documentTypeId').setValue(recordsCommitteeGrid.get('documentTypeName'));
    			formWindow.down('#templateId').setValue(recordsCommitteeGrid.get('templateName'));
    			formWindow.down('#communityId').setValue(gridData.get('communityName'));
    		}
    		formWindow.show();
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openViewDocumentMappingProgramBatchSeatWindow: function(){
    	var $this=this;
    	var grid = $this.getDocumenttemplatemappingapplytoprogambatchgrid();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getDocumenttemplatealprogrambatchviewwindow();
    		if (!formWindow) {
    			formWindow = Ext.widget('documenttemplatealprogrambatchviewwindow');
    			formWindow.down('#configLevel').setValue(getDocumentTranslation(recordsCommitteeGrid.get('configLevel')));
    			formWindow.down('#documentTypeId').setValue(recordsCommitteeGrid.get('documentTypeName'));
    			formWindow.down('#templateId').setValue(recordsCommitteeGrid.get('templateName'));
    			formWindow.down('#academyLocationId').setValue(gridData.get('academyLocationName'));
    			formWindow.down('#program').setValue(gridData.get('programName'));
    			formWindow.down('#batch').setValue(gridData.get('batchName'));
    			formWindow.down('#seatType').setValue(gridData.get('seatName'));
    		}
    		formWindow.show();
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitDocumentMappingWithAcademyLocation: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getDocumenttemplatemappingaddalstructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();

    	var committeeMappingId = committeemappingtabstructure.down('#documentTemplateMappingId').getValue();
    	var applyToGrid = this.getDocumenttemplatemappingapplytogrid();

    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;

    	var submitJsonArr;
    	var jsonALArr = [];
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_SAVE_DOCUMENT_MAPPING_BY_CATEGORY_AL;
    		if(activeGrid.xtype == 'documenttemplatemappingaddalgrid'){
    			selectedRecord.forEach(function(obj){
    				jsonALArr.push(obj.get('id'));
    			});
    			submitJsonArr={
    					academyLocationIds: jsonALArr.join(),
    					documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
    					id: recordsCommitteeGrid.get('id'),
    					ownerId: recordsCommitteeGrid.get('ownerId'),
    					templateId: recordsCommitteeGrid.get('templateId'),
    					useDefaultTemplate: recordsCommitteeGrid.get('useDefaultTemplate'),
    					whetherActive: recordsCommitteeGrid.get('whetherActive')
        				//configLevel:recordsCommitteeGrid.get('configLevel')
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_CHECK_ACADEMY_LOCATION_MAPPING_BY_CATEGORY,
    			params: {
    				templateId: parseInt(recordsCommitteeGrid.get('templateId')),
    				documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    				academyLocationIds: jsonALArr.join(),
    				configLevel:recordsCommitteeGrid.get('configLevel')
    			},
    			success : function(response, action) {

    				var data = Ext.decode(response.responseText);

    				if(data.documentTypeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('TEMPLATE_IS_ALREADY_MAPPED_WITH_THE_FOLLOWING_ACADEMY_LOCATIONS_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(data.academyLocationDTList.length>0){
    						data.academyLocationDTList.forEach(function(obj){
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.value + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								var documentApplyToGridStore = applyToGrid.getStore();
    								if(!isNullOrEmpty(committeeMappingId)){
    									documentApplyToGridStore.getProxy().extraParams={
    										templateId: recordsCommitteeGrid.get('templateId'),
    										ownerId:recordsCommitteeGrid.get('ownerId'),
    										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    										configLevel:recordsCommitteeGrid.get('configLevel')
    									};
    								}
    								$this.resetGridSetting(applyToGrid);
    								$this.resetPageSetting(documentApplyToGridStore);
    								documentApplyToGridStore.load();

    								var structure = Ext.widget('documenttemplatemappingapplytotabstructure');

    								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    								//End code for open Apply To tab again with updated records 
    								showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    							}
    						});
    					});
    					alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}

    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							var documentApplyToGridStore = applyToGrid.getStore();
    							if(!isNullOrEmpty(committeeMappingId)){
    								documentApplyToGridStore.getProxy().extraParams={
										templateId: recordsCommitteeGrid.get('templateId'),
										documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
										ownerId:recordsCommitteeGrid.get('ownerId'),
										configLevel:recordsCommitteeGrid.get('configLevel')
									};
    							}
    							$this.resetGridSetting(applyToGrid);
    							$this.resetPageSetting(documentApplyToGridStore);
    							documentApplyToGridStore.load();
    							var structure = Ext.widget('documenttemplatemappingapplytotabstructure');

    							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    							// End code for open Apply To tab again with updated records 
    							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitDocumentMappingWithCommunity: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getDocumenttemplatemappingaddcommunitystructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();

    	var committeeMappingId = committeemappingtabstructure.down('#documentTemplateMappingId').getValue();
    	var applyToGrid = this.getDocumenttemplatemappingapplytocommunitygrid();

    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;

    	var submitJsonArr;
    	var jsonALArr = [];
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_SAVE_DOCUMENT_MAPPING_COMMUNITY;
    		if(activeGrid.xtype == 'documenttemplatemappingaddcommunitygrid'){
    			selectedRecord.forEach(function(obj){
    				jsonALArr.push(obj.get('id'));
    			});
    			submitJsonArr={
    					academyLocationIds: jsonALArr.join(),
    					documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
    					id: recordsCommitteeGrid.get('id'),
    					ownerId: recordsCommitteeGrid.get('ownerId'),
    					templateId: recordsCommitteeGrid.get('templateId'),
    					useDefaultTemplate: recordsCommitteeGrid.get('useDefaultTemplate'),
    					whetherActive: recordsCommitteeGrid.get('whetherActive')
        				//configLevel:recordsCommitteeGrid.get('configLevel')
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_CHECK_ACADEMY_LOCATION_MAPPING_BY_CATEGORY,
    			params: {
    				templateId: parseInt(recordsCommitteeGrid.get('templateId')),
    				documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    				academyLocationIds: jsonALArr.join(),
    				configLevel:recordsCommitteeGrid.get('configLevel')
    			},
    			success : function(response, action) {

    				var data = Ext.decode(response.responseText);

    				if(data.documentTypeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('TEMPLATE_IS_ALREADY_MAPPED_WITH_COMMUNITIES_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(data.academyLocationDTList.length>0){
    						data.academyLocationDTList.forEach(function(obj){
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.value + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								var documentApplyToGridStore = applyToGrid.getStore();
    								if(!isNullOrEmpty(committeeMappingId)){
    									documentApplyToGridStore.getProxy().extraParams={
    										templateId: recordsCommitteeGrid.get('templateId'),
    										documentTypeId:recordsCommitteeGrid.get('documentTypeId'),
    										configLevel:recordsCommitteeGrid.get('configLevel')
    									};
    								}
    								$this.resetGridSetting(applyToGrid);
    								$this.resetPageSetting(documentApplyToGridStore);
    								documentApplyToGridStore.load();

    								var structure = Ext.widget('documenttemplatemappingapplytotabstructure');

    								var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
    								applyToALGrid.setVisible(false);
    								
    								var applyToGridCommunity = structure.query('documenttemplatemappingapplytocommunitygrid')[0];
    								applyToGridCommunity.setVisible(true);
    								
    								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    								//End code for open Apply To tab again with updated records 
    								showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    							}
    						});
    					});
    					alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}

    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							var documentApplyToGridStore = applyToGrid.getStore();
								if(!isNullOrEmpty(committeeMappingId)){
									documentApplyToGridStore.getProxy().extraParams={
										templateId: recordsCommitteeGrid.get('templateId'),
										documentTypeId:recordsCommitteeGrid.get('documentTypeId'),
										configLevel:recordsCommitteeGrid.get('configLevel')
									};
								}
    							$this.resetGridSetting(applyToGrid);
    							$this.resetPageSetting(documentApplyToGridStore);
    							documentApplyToGridStore.load();
    							var structure = Ext.widget('documenttemplatemappingapplytotabstructure');

    							var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
								applyToALGrid.setVisible(false);
								
								var applyToGridCommunity = structure.query('documenttemplatemappingapplytocommunitygrid')[0];
								applyToGridCommunity.setVisible(true);
								
    							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    							// End code for open Apply To tab again with updated records 
    							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitDocumentMappingWithALCourse: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getDocumenttemplatemappingaddcoursestructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();

    	var committeeMappingId = committeemappingtabstructure.down('#documentTemplateMappingId').getValue();
    	var applyToGrid = this.getDocumenttemplatemappingapplytocoursegrid();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var submitJsonArr;
    	var jsonALArr = [];
    	var jsonALCourseArr = [];
    	var alProgBatchSeat;
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_UPDATE_DOCUMENT_OWNER_CONF_COURSE;
    		if(activeGrid.xtype == 'documenttemplatemappingaddcoursegrid'){
    			selectedRecord.forEach(function(obj){
    				alProgBatchSeat = {
    						ownerId:obj.get('longValue'),
    						academyLocationId: obj.get('secondId')
        				}
    				jsonALCourseArr.push(alProgBatchSeat);
    				
    				if(jsonALArr.indexOf(obj.get('secondId')) == -1){
    					jsonALArr.push(obj.get('secondId'));
    	    		}
    			});
    			submitJsonArr={
    					alProgBatchSeat: jsonALCourseArr,
    					documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
    					id: recordsCommitteeGrid.get('id'),
    					ownerId: recordsCommitteeGrid.get('ownerId'),
    					templateId: recordsCommitteeGrid.get('templateId'),
    					useDefaultTemplate: recordsCommitteeGrid.get('useDefaultTemplate'),
    					whetherActive: recordsCommitteeGrid.get('whetherActive')
        				//configLevel:recordsCommitteeGrid.get('configLevel')
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: SERVERURL.PATH_CHECK_DUPLICATE_COURSE_ACADEMY_LOCATION,
    			jsonData: {
    				alProgBatchSeat: jsonALCourseArr,
    				templateId: parseInt(recordsCommitteeGrid.get('templateId')),
    				documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId'))
    				//academyLocationIds: recordsCommitteeGrid.get('ownerId'),
    				//configLevel:recordsCommitteeGrid.get('configLevel')
    			},
    			success : function(response, action) {
    				var data = Ext.decode(response.responseText);
    				if(!isNullOrEmpty(data) && data.length>0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('TEMPLATE_IS_ALREADY_MAPPED_WITH_ACADEMY_LOCATION_AND_COURSE_CODE_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(data.length>0){
    						data.forEach(function(obj){
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								var documentApplyToGridStore = applyToGrid.getStore();
    								if(!isNullOrEmpty(committeeMappingId)){
    									documentApplyToGridStore.getProxy().extraParams={
    										templateId: recordsCommitteeGrid.get('templateId'),
    										ownerId:recordsCommitteeGrid.get('ownerId'),
    										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    										configLevel:recordsCommitteeGrid.get('configLevel')
    									};
    								}
    								$this.resetGridSetting(applyToGrid);
    								$this.resetPageSetting(documentApplyToGridStore);
    								documentApplyToGridStore.load();

    								var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    								
    								var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
    								applyToALGrid.setVisible(false);
    								
    								var applyToGridCommunity = structure.query('documenttemplatemappingapplytocoursegrid')[0];
    								applyToGridCommunity.setVisible(true);

    								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    								//End code for open Apply To tab again with updated records 
    								showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    							}
    						});
    					});
    					alertWin.show();
    				
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}

    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							var documentApplyToGridStore = applyToGrid.getStore();
    							if(!isNullOrEmpty(committeeMappingId)){
    								documentApplyToGridStore.getProxy().extraParams={
										templateId: recordsCommitteeGrid.get('templateId'),
										ownerId:recordsCommitteeGrid.get('ownerId'),
										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
										configLevel:recordsCommitteeGrid.get('configLevel')
									};
    							}
    							$this.resetGridSetting(applyToGrid);
    							$this.resetPageSetting(documentApplyToGridStore);
    							documentApplyToGridStore.load();
    							var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    							
    							var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
								applyToALGrid.setVisible(false);
								
								var applyToGridCommunity = structure.query('documenttemplatemappingapplytocoursegrid')[0];
								applyToGridCommunity.setVisible(true);

    							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    							// End code for open Apply To tab again with updated records 
    							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitDocumentMappingWithProgramBatch: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();

    	var committeeMappingId = committeemappingtabstructure.down('#documentTemplateMappingId').getValue();
    	var applyToGrid = this.getDocumenttemplatemappingapplytoprogambatchgrid();

    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;

    	var submitJsonArr;
    	var jsonALArr = [];
    	var jsonALCourseArr = [];
    	var alProgBatchSeat;
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_UPDATE_DOC_OWNER_CONF_BY_BATCH;
    		if(activeGrid.xtype == 'documenttemplatemappingaddprogrambatchgrid'){
    			selectedRecord.forEach(function(obj){
    				alProgBatchSeat = {
    						ownerId:obj.get('batchId'),
    						academyLocationId: obj.get('academyLocationId')
        				}
    				jsonALCourseArr.push(alProgBatchSeat);
    				jsonALArr.push(obj.get('batchId'));
    			});
    			submitJsonArr={
    					alProgBatchSeat: jsonALCourseArr,
    					documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
    					id: recordsCommitteeGrid.get('id'),
    					ownerId: recordsCommitteeGrid.get('ownerId'),
    					templateId: recordsCommitteeGrid.get('templateId'),
    					useDefaultTemplate: recordsCommitteeGrid.get('useDefaultTemplate'),
    					whetherActive: recordsCommitteeGrid.get('whetherActive')
        				//configLevel:recordsCommitteeGrid.get('configLevel')
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_CHECK_ACADEMY_LOCATION_MAPPING_BY_CATEGORY,
    			params: {
    				templateId: parseInt(recordsCommitteeGrid.get('templateId')),
    				documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    				academyLocationIds: jsonALArr.join(),
    				configLevel:"PROGRAM_BATCH_LEVEL"
    			},
    			success : function(response, action) {

    				var data = Ext.decode(response.responseText);

    				if(data.documentTypeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('TEMPLATE_IS_ALREADY_MAPPED_WITH_AL_PROGRAM_BATCH_SEATTYPE_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(data.academyLocationDTList.length>0){
    						data.academyLocationDTList.forEach(function(obj){
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.value + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								var documentApplyToGridStore = applyToGrid.getStore();
    								if(!isNullOrEmpty(committeeMappingId)){
    									documentApplyToGridStore.getProxy().extraParams={
    										templateId: recordsCommitteeGrid.get('templateId'),
    										ownerId:recordsCommitteeGrid.get('ownerId'),
    										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    										configLevel:recordsCommitteeGrid.get('configLevel')
    									};
    								}
    								$this.resetGridSetting(applyToGrid);
    								$this.resetPageSetting(documentApplyToGridStore);
    								documentApplyToGridStore.load();

    								var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    								
    								var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
    								applyToALGrid.setVisible(false);
    								
    								var applyToGridProgramBatch = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
    								applyToGridProgramBatch.setVisible(true);

    								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    								//End code for open Apply To tab again with updated records 
    								showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    							}
    						});
    					});
    					alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}

    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							var documentApplyToGridStore = applyToGrid.getStore();
    							if(!isNullOrEmpty(committeeMappingId)){
    								documentApplyToGridStore.getProxy().extraParams={
										templateId: recordsCommitteeGrid.get('templateId'),
										ownerId:recordsCommitteeGrid.get('ownerId'),
										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
										configLevel:recordsCommitteeGrid.get('configLevel')
									};
    							}
    							$this.resetGridSetting(applyToGrid);
    							$this.resetPageSetting(documentApplyToGridStore);
    							documentApplyToGridStore.load();
    							var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    							
    							var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
								applyToALGrid.setVisible(false);
								
								var applyToGridProgramBatch = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
								applyToGridProgramBatch.setVisible(true);

    							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    							// End code for open Apply To tab again with updated records 
    							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitDocumentMappingWithProgramBatchSeatType: function(btn){

    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getDocumenttemplatemappingaddprogrambatchstructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getDocumenttemplatemappingaddalmappingtab();
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();

    	var committeeMappingId = committeemappingtabstructure.down('#documentTemplateMappingId').getValue();
    	var applyToGrid = this.getDocumenttemplatemappingapplytoprogambatchgrid();

    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;

    	var submitJsonArr;
    	var jsonALArr = [];
    	var jsonALCourseArr = [];
    	var alProgBatchSeat;
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_UPDATE_DOCUMENT_OWNER_CONF;
    		if(activeGrid.xtype == 'documenttemplatemappingaddprogrambatchseattypegrid'){
    			selectedRecord.forEach(function(obj){
    				alProgBatchSeat = {
    						ownerId:obj.get('programBatchSeatTypeId'),
    						academyLocationId: obj.get('academyLocationId')
        				}
    				jsonALCourseArr.push(alProgBatchSeat);
    				jsonALArr.push(obj.get('programBatchSeatTypeId'));
    			});
    			submitJsonArr={
    					alProgBatchSeat: jsonALCourseArr,
    					documentTypeId: recordsCommitteeGrid.get('documentTypeId'),
    					id: recordsCommitteeGrid.get('id'),
    					ownerId: recordsCommitteeGrid.get('ownerId'),
    					templateId: recordsCommitteeGrid.get('templateId'),
    					useDefaultTemplate: recordsCommitteeGrid.get('useDefaultTemplate'),
    					whetherActive: recordsCommitteeGrid.get('whetherActive')
        				//configLevel:recordsCommitteeGrid.get('configLevel')
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_CHECK_ACADEMY_LOCATION_MAPPING_BY_CATEGORY,
    			params: {
    				templateId: parseInt(recordsCommitteeGrid.get('templateId')),
    				documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    				academyLocationIds: jsonALArr.join(),
    				configLevel:recordsCommitteeGrid.get('configLevel')
    			},
    			success : function(response, action) {

    				var data = Ext.decode(response.responseText);

    				if(data.documentTypeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('TEMPLATE_IS_ALREADY_MAPPED_WITH_AL_PROGRAM_BATCH_SEATTYPE_MSG'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					if(data.academyLocationDTList.length>0){
    						data.academyLocationDTList.forEach(function(obj){
    							htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.value + '</div>';
    						});

    						pnlListMappingFld.setValue(htmlData);
    					}
    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						Ext.Ajax.request({
    							method: "POST",
    							type: 'rest',
    							url: submitUrl,
    							jsonData:submitJsonArr,
    							success : function(response, action) {
    								Ext.getBody().unmask();
    								var data = response.responseText;
    								var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    								var getTab=getcontroller.getTab(tabName);
    								if(getTab!=null){
    									contentPanel.remove(getTab, true);
    								}

    								//Start code for open Apply To tab again with updated records 
    								var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    								var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    								if(getTabApplyTo!=null){
    									contentPanel.remove(getTabApplyTo, true);
    								}
    								var documentApplyToGridStore = applyToGrid.getStore();
    								if(!isNullOrEmpty(committeeMappingId)){
    									documentApplyToGridStore.getProxy().extraParams={
    										templateId: recordsCommitteeGrid.get('templateId'),
    										ownerId:recordsCommitteeGrid.get('ownerId'),
    										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    										configLevel:recordsCommitteeGrid.get('configLevel')
    									};
    								}
    								$this.resetGridSetting(applyToGrid);
    								$this.resetPageSetting(documentApplyToGridStore);
    								documentApplyToGridStore.load();

    								var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    								
    								var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
    								applyToALGrid.setVisible(false);
    								
    								var applyToGridProgramBatch = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
    								applyToGridProgramBatch.setVisible(true);

    								openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    								//End code for open Apply To tab again with updated records 
    								showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    							}
    						});
    					});
    					alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    						method: "POST",
    						type: 'rest',
    						url: submitUrl,
    						jsonData:submitJsonArr,
    						success : function(response, action) {
    							Ext.getBody().unmask();
    							var data = response.responseText;
    							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    							var getTab=getcontroller.getTab(tabName);
    							if(getTab!=null){
    								contentPanel.remove(getTab, true);
    							}

    							//Start code for open Apply To tab again with updated records 
    							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    							if(getTabApplyTo!=null){
    								contentPanel.remove(getTabApplyTo, true);
    							}
    							var documentApplyToGridStore = applyToGrid.getStore();
    							if(!isNullOrEmpty(committeeMappingId)){
    								documentApplyToGridStore.getProxy().extraParams={
										templateId: recordsCommitteeGrid.get('templateId'),
										ownerId:recordsCommitteeGrid.get('ownerId'),
										documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
										configLevel:recordsCommitteeGrid.get('configLevel')
									};
    							}
    							$this.resetGridSetting(applyToGrid);
    							$this.resetPageSetting(documentApplyToGridStore);
    							documentApplyToGridStore.load();
    							var structure = Ext.widget('documenttemplatemappingapplytotabstructure');
    							
    							var applyToALGrid = structure.query('documenttemplatemappingapplytogrid')[0];
								applyToALGrid.setVisible(false);
								
								var applyToGridProgramBatch = structure.query('documenttemplatemappingapplytoprogambatchgrid')[0];
								applyToGridProgramBatch.setVisible(true);

    							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_THIRTEEN);
    							// End code for open Apply To tab again with updated records 
    							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_ADDED_SUCCESSFULLY'));
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    
    },
    deleteDocumentMappingAL:function(TypeVal){
    	var $this=this;
    	var committeapplytotabstructure = this.getDocumenttemplatemappingapplytotabstructure();
    	var recordsCommitteeGrid = committeapplytotabstructure.config.documentTemplateGridRecord;
    	var grid = $this.getDocumenttemplatemappingapplytogrid();
    	if(TypeVal == "AL"){
    		grid = $this.getDocumenttemplatemappingapplytogrid();
    	}
    	else if(TypeVal == "COURSE"){
    		grid = $this.getDocumenttemplatemappingapplytocoursegrid();
    	}
    	else if(TypeVal == "COMUNITTY"){
    		grid = $this.getDocumenttemplatemappingapplytocommunitygrid();
    	}
    	else if(TypeVal == "PROGRAM_BATCH"){
    		grid = $this.getDocumenttemplatemappingapplytoprogambatchgrid();
    	}
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getDocumentTranslation('TEMPLATE_MAPPING'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id;
    				var submitURL;
    				if(TypeVal == "PROGRAM_BATCH") {
    				   id = records[0].get("id");
    				   submitURL = SERVERURL.DOCUMENT_TEMPLATE_MAPPING_DELETE+ id;
    				} else {
    					id = records[0].get("ownerId");
    					submitURL = SERVERURL.DOCUMENT_TEMPLATE_MAPPING_DELETE+ id;
    				}
    				if(TypeVal == "COURSE") {
    					var ownerId = records[0].get("ownerId");
    					var alId = records[0].get("alId");
    					Ext.Ajax.request({
							method: "POST",
							type: 'rest',
							headers : {
        						'Content-Type' : 'application/json'
        					},
							url: SERVERURL.PATH_DELETE_DOCUMENT_OWNER_CONFIG_COURSE,
							params:{
								docOwnerConfigId:ownerId,
								academyLocationId:alId
							},
							success : function(form, action) {
        						Ext.getBody().unmask();
        						if(Ext.decode(form.responseText) == 0) {
        							showWarningMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('DEPENDENCY_EXIST_MSG'));
        						}else {
        							$this.resetGridSetting(grid);
        							$this.resetPageSetting(grid.getStore());
        							grid.getStore().getProxy().extraParams={
    									templateId: recordsCommitteeGrid.get('templateId'),
    									ownerId:recordsCommitteeGrid.get('ownerId'),
    									documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    									configLevel:recordsCommitteeGrid.get('configLevel')
    								};
        							grid.getStore().load();
        							
        							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_DELETED_SUCCESSFULLY'));
        						}
        					}
						});
    				}
    				else{
    					Ext.Ajax.request({
        					method : "DELETE",
        					type : 'rest',
        					url : submitURL,
        					headers : {
        						'Content-Type' : 'application/json'
        					},
        					success : function(form,action) {
        						Ext.getBody().unmask();
        						if(Ext.decode(form.responseText) == 0) {
        							showWarningMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('DEPENDENCY_EXIST_MSG'));
        						}else {
        							$this.resetGridSetting(grid);
        							$this.resetPageSetting(grid.getStore());
        							grid.getStore().getProxy().extraParams={
    									templateId: recordsCommitteeGrid.get('templateId'),
    									ownerId:recordsCommitteeGrid.get('ownerId'),
    									documentTypeId: parseInt(recordsCommitteeGrid.get('documentTypeId')),
    									configLevel:recordsCommitteeGrid.get('configLevel')
    								};
        							grid.getStore().load();
        							
        							showSuccessMessage(getDocumentTranslation('TEMPLATE_MAPPING'), getCommonTranslation('TEMPLATE_MAPPING_DELETED_SUCCESSFULLY'));
        						}
        					}
        				});
    				}
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    }
});