/**
 * @author Rajkumar	
 * @author seshagiri
 * @author Utsav Chandvaniya
 * @author Sumit meena
 * @author dharmendra.parajapati
 */
Ext.define('Academia.controller.enquiry.TrackEnquiryController', {
    extend: 'Academia.controller.base.BaseController',
	stores : ['enquiry.EnquiryTypeStore','enquiry.ReferredTypeStore',
	          'enquiry.EnqIntermediateType','enquiry.Priority',
	          'enquiry.EnquiryCodeSearchStore','personinfo.faculty.FacultySurveyStr',
	          'importutility.ModuleName','common.AcademyLocationNameSeparated','importutility.ImportEnquiry',
	          'common.IntakeYearStore','enquiry.AcademicBatchStore','enquiry.ProgramBatchSeatTypeStore',
	          'program.programDetails.programBatches.PrimaryAcademicStore','enquiry.FollowUpUserWithDepartment',
	          'enquiry.ViewDocuments','enquiry.followup.ClosureReasonStore','enquiry.closure.ReopenReasonStore',
	          'program.ProgramCategoryStore','enquiry.EnquirySourceStore',
	          'messaging.MessagingTemplatesStore','messaging.StaticDocumentAttachmentGridStore','committee.committee.MessageTypeNotificationStore',
	          'common.SalutationStore',
	          'importutility.ImportEnquiryNewStore','campaign.CampaignCodeOrNameSmartSearch','user.UserAcademyLocationStore',
	          'admission.applicationFormSale.ProgramGroupComboStore','campaignnew.CampaignOpenComboStore',
	          'campaignnew.RegistrationTypeStore','campaignnew.ModeOfDeliveryStore','common.ModeOfDeliveryStore','common.RegistrationTypeStore',
	          'Academia.store.campaignnew.CampaignNameFilterStore','Academia.store.campaignnew.SchoolPriorityStore','Academia.store.campaignnew.CampaignSchoolStore',
	          'Academia.store.enquiry.SchoolPriorityForCampaignStore','Academia.store.enquiry.SchoolByPriorityOrCampaignStore','enquiry.EnquiryTemplateForImportUpdatesStore',
	          'Academia.store.common.ProgramsByAcademyLocationsIds','enquiry.PopiaStatusStore','common.EnquiryPopiaStatusDropdownValue','Academia.store.program.ConfiguredBatchListStore',
	          'Academia.store.common.SeatTypeByBatchIds','enquiry.AcademicBatchStores','enquiry.EnquirerSmartSearchStore','enquiry.followup.CurrentAlApplicationStore'],
  views : ['baselayout.contentarea.ContentPanel', 
           'enquiry.TrackEnquiryStructure','enquiry.TrackEnquiryForm','enquiry.student.EnquiryReassignWindow',
           'enquiry.TrackEnquiryListing','enquiry.CheckDuplicateListStructure',
           'enquiry.EnquiryTabStructure','enquiry.student.EnquirySendSurvey',
           'enquiry.EnquiryUploaddownloadStructure','enquiry.EnquiryDownloadForm','enquiry.EnquiryUploadForm','importutility.ImportByModule.ImportListEnquiry',
           'enquiry.ViewDocumentsWin','enquiry.EnquirySendMessage','enquiry.EnquiryStaticDocumentAttachmentGrid',
           'enquiry.EnquiryNewUploaddownloadStructure',
           'importutility.ImportByModule.ImportListEnquiryNewGrid',
           'enquiry.EnquiryNewDownloadForm',
           'enquiry.EnquiryNewUploadForm','enquiry.closure.EnquiryClosureForm',
           'UploadOptionRadioGroup','enquiry.EnquiryImportEnquiryUpdatesStructure',
           'enquiry.EnquiryUpdatesDownloadForm','enquiry.EnquiryUpdatesUploadForm',
           'importutility.ImportByModule.ImportEnquiryUpdatesGrid','enquiry.student.PopiaOption','enquiry.student.ChangeLinkedApplication'
           ],
            
   config:{
	   /*
      	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
       		   	 */
       	   	/**
       	        * @cfg {Array} TRACKENQUIRY_PERMISSIONS array (required)
       	        * The array of permissions to use for Access control wise enabling and disabling buttons.
       	        * @accessor
       	        */
       TRACKENQUIRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRACKENQUIRY_PRIVILEGES'),
       DUPLICATEDETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DUPLICATEDETAILS_PRIVILEGES'),
       ENQUIRY_IMPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_IMPORT_UTILITY_PRIVILEGES'),
       ENQUIRY_ADVANCE_SEARCH_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_ADVANCE_SEARCH_PRIVILEGES'),
       LEAD_IMPORT_UTILITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAD_IMPORT_UTILITY_PRIVILEGES'),
       LEAD_IMPORT_ENQUIRY_UPDATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAD_IMPORT_ENQUIRY_UPDATE_PRIVILEGES'),
  	   CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
},
     refs : [{
            	ref : 'contentpanel',
            	selector : 'contentpanel' 
            },{
            	ref : 'trackenquiryform',
            	selector : 'trackenquiryform'
            },{
            	ref:'trackenquirygrid',
            	selector:'trackenquirygrid'
            },{
            	ref:'enquirytabstructure',
            	selector:'enquirytabstructure'
            },{
            	ref:'trackEnquiry',
            	selector:'trackEnquiry'		  
            },{
            	ref:'trackenquirylisting',
            	selector:'trackenquirylisting'
            },{
            	ref:'trackenquirygrid',
            	selector:'trackenquirygrid'
            },{
            	ref:'searchresultgrid',
            	selector:'searchresultgrid[itemId=trackenquirygrid]'
            },{
            	ref:'checkduplicatelistgrid',
            	selector:'searchresultgrid[itemId=checkduplicatelistgrid]'
            },{
            	ref:'corporateCheckduplicatelistgrid',
            	selector:'searchresultgrid[itemId=corporateCheckduplicatelistgrid]'
            },{
            	ref:'checkduplicateliststructure',
            	selector:'checkduplicateliststructure'
            },{
            	ref:'viewdocumentswin',
            	selector:'viewdocumentswin'
            },{
            	ref:'trackcorporateenquirygrid',
            	selector:'searchresultgrid[itemId=trackcorporateenquirygrid]'
            },{
            	ref:'tracknonadmissionenquirygrid',
            	selector:'searchresultgrid[itemId=tracknonadmissionenquirygrid]'
            },{
            	ref:'trackcorporateenquirygrid',
            	selector:'trackcorporateenquirygrid'
            },{
            	ref:'studentdetailstructure',
            	selector:'studentdetailstructure'
            },{
            	ref:'enquirydetailform',
            	selector:'enquirydetailform'
            },{
            	ref:'closurefollowupgrid',
            	selector:'closurefollowupgrid'
            }, {
            	ref: 'nonAdmissionCheckduplicatelistgrid',
            	selector:'searchresultgrid[itemId=nonAdmissionCheckduplicatelistgrid]'
            },{
    	    	ref :'enquirysendmessage',
    	    	selector : 'enquirysendmessage[itemId=trackEnquirySendMessageWindow]'
    	    },{
    	    	ref :'enquirysendsurvey',
    	    	selector : 'studentsendsurvey[itemId=trackEnquirySurvey]'
    	    },{
    	    	ref :'enquirySendsurvey',
    	    	selector : 'enquirysendsurvey form'
    	    },{
    	    	ref :'trackenquirygrid',
    	    	selector : 'trackenquirygrid'
    	    },{
    	    	ref :'enquiryuploaddownloadstructure',
    	    	selector :'enquiryuploaddownloadstructure'
    	    },{
    	    	ref :'enquirydownloadform',
    	    	selector :'enquirydownloadform'
    	    },{
    	    	ref :'enquiryuploadform',
    	    	selector :'enquiryuploadform'
    	    },{
    	    	ref :'importlistenquiry',
    	    	selector :'importlistenquiry'
    	    },{
    	    	ref :'enquiryreassignwindow',
    	    	selector :'enquiryreassignwindow'
    	    },{
    	    	ref :'enquirystaticdocumentattachmentgrid',
    	    	selector : 'enquirystaticdocumentattachmentgrid'
    	    }, {
			    ref: 'enquirynewuploadform',
			    selector: 'enquirynewuploadform'
			}, {
			    ref: 'enquirynewdownloadform',
			    selector: 'enquirynewdownloadform'
			}, {
			    ref: 'importlistenquirynewgrid',
			    selector: 'importlistenquirynewgrid'
			},{
				ref : 'enquiryuploadoptionradiogroup',
				selector : 'uploadoptionradiogroup[itemId=enquiryUploadOptionRadioGroupItemId]'
			},{
				ref : 'enquirynewuploadoptionradiogroup',
				selector : 'uploadoptionradiogroup[itemId=enquirynewUploadOptionRadioGroupItemId]'
			},{
				ref : 'enquiryimportenquiryupdatesstructure',
				selector : 'enquiryimportenquiryupdatesstructure'
			},{
				 ref: 'enquiryupdatesuploadform',
				 selector: 'enquiryupdatesuploadform'
			},{
				 ref: 'enquiryupdatesdownloadform',
				 //selector: 'enquiryupdatesdownloadform'
				 selector: 'enquiryupdatesdownloadform[itemId=enquiryupdatesdownloadformItemId]'
			},{
				ref : 'importEnquiryUpdatesRadioGroup',
				selector : 'uploadoptionradiogroup[itemId=importEnquiryUpdatesRadioGroupItemId]'
			},{
            	ref : 'enquiryclosureform',
            	selector : 'enquiryclosureform'
			},{
				ref : 'importenquiryupdatesgrid',
				selector :'importenquiryupdatesgrid'
			},{
    	    	ref :'popiaoption',
    	    	selector : 'popiaoption'
    	    },{
    	    	ref :'changelinkedapplication',
    	    	selector : 'changelinkedapplication'
    	    }],
            init : function() {

            	this.control({
            		'trackenquirygrid':{
            			click:this.trackEnquiryGrid
            		},
            		'trackEnquiry button[itemId=btnQuickSearch]' :{
            			click:this.showQuickSearch
            		},
            		'trackEnquiry button[itemId=btnAdvancedSearch]' :{
            			click:this.showAdvancedSearch
            		},
            		'trackenquiryform button[itemId=searchTrackEnquiry]':{
            			click:this.trackEnquiryGridSelection
            		},
            		'trackenquirygrid #tab1[itemId=trackEnquiryGrid_enquiryNo]':{
            			afterrender: this.linkClicked
            		},
            		'trackenquirygrid button[itemId=btnAdd]':{
            			click: this.oprenCreateEnquiry
            		},
            		'trackenquirygrid button[itemId=btnDelete]' : {
            			click : this.deleteEnquiry
            		},	
            		'trackenquirygrid': {
            			'edit' : function(view,rowIndex,e){
            				this.linkClicked(view,rowIndex);
            				e.stopEvent();
                 			e.stopPropagation();
            			},
            			render : this.loadTrackGrid
            		},
            		
            		'trackenquirylisting': {
            			render:function(structure){
            				var $this = this;
            				this.disableImportEnquiry(structure, this.getENQUIRY_IMPORT_PERMISSIONS());
            				structure.body.on('click', function() {
            					var filter = structure.down('trackenquiryform');
            					$this.hideInvalidIconFromField(filter);
            			       });
            			},
            			afterrender : function(structure){
            				var $this = this;
            				structure.body.on('scroll', function(e, target) {
            					var enquiryGrid = $this.getSearchresultgrid();
            					var grid = null;
            					if(!enquiryGrid.isHidden()){
            						grid = $this.getSearchresultgrid();
            					}
            					if(!isNullOrEmpty(grid)){
            						$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
                					$this.hideButtonTrackEnquiryListingMenuWhileScrolling(grid,structure);	
            					}
            				});
            			}
            		}, 
            		'trackenquiryform customcombobox#countryFilterId': {
  	        			select: function(obj, record) {
  	        				var form = obj.up('form');
  	        				form.down('#countryRegionFilterId').clearValue();
  	        				form.down('#countryRegionFilterId').setDisabled(false);
  	        				form.down('#cityFilterId').clearValue();
  	        				form.down('#cityFilterId').setDisabled(true);
  	        				var countryId = record[0].get("id");
  	        				if (countryId > 0) {
  	        					var store = form.down('#countryRegionFilterId').getStore();
  	        					store.getProxy().extraParams = {
  	        						cid: countryId
  	        					};
  	        					store.load();
  	        				}
  	        				form.getForm().checkValidity();
  	        			 }
  	        		  },
  	        		  'trackenquiryform customcombobox#countryRegionFilterId':{
  	        			select:function(obj,rec){
  	        				var form = obj.up('form');
  	        				form.down('#cityFilterId').clearValue();
  	        				form.down('#cityFilterId').setDisabled(false);
  	        				var countryRegionId=rec[0].data.id;
  	        				var store = form.down('#cityFilterId').getStore();
  	        				store.getProxy().extraParams = {
  	        					id: countryRegionId
  	        				};
  	        				store.load();
  	        				form.getForm().checkValidity();
  	        			}
  	        		  },
            		'trackenquiryform button[itemId=trackenquiry_search]' : {
            			click : this.loadEnquiryGrid
            		},
            		'trackenquiryform button[itemId=resetBtn]' : {
            			click : function(){
            				var form = this.getTrackenquiryform().getForm();
            				form.findField("dateFrom").setMaxValue(null);
            				form.findField("dateFrom").setMinValue(null);
            				form.findField("enquiryDateto").setMaxValue(null);
            				form.findField("enquiryDateto").setMinValue(null);

            				form.getFields().each(function(field) {
                                if(field.name !== 'enquiryType' || field.name !== 'dateFrom') {
            						field.reset();	
            					}
                                if (field.name == 'dateFrom') {
                                    var currentDate = new Date();        // today
                                    var fromDate = new Date(currentDate);
                                    fromDate.setFullYear(currentDate.getFullYear() - 1);

                                    field.setValue(fromDate);
                                }
            				});

            				var enquiryTypeField = form.findField("enquiryType");
            				var data;
            				var count = enquiryTypeField.getStore().totalCount;
            				for(var i=0; i<count; i++){
            					var rec = enquiryTypeField.getStore().getAt(i);
            					var code = rec.data.code;
            					if(code=='Admission'){
            						data=rec;
            					}
            				}
            				enquiryTypeField.select(data);
            				Ext.resumeLayouts();
            				
            				var enquiryCodeStore=form.findField("enquiryCode").getStore();
     				   	    if(!isNullOrEmpty(data) && !isNullOrEmpty(data.data) && !isNullOrEmpty(data.data.id)) {
     				   	    	enquiryCodeStore.getProxy().setExtraParam('enquiryType','Admission');
     				   	    	enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',data.data.id);
     				   	    } else {
     				   	    	enquiryCodeStore.getProxy().setExtraParam('enquiryType',null);
     				   	    	enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',null);
     				   	    }
            				//V2D-302826 commenting below
//            				var form = this.getTrackenquiryform();
//            				var programField=form.down('#programId');
//            				var programStore = programField.getStore();
//            				programStore.proxy.extraParams = {
//            						academyLocationIds : this.getUserAccessibleAL().join()
//            				};
//            				programField.setDisabled(true);
//            				//programStore.load();
//            				
//            				var schoolPriority=form.down('#schoolPriorityId');
//            				var schoolPriorityStore = schoolPriority.getStore();
//            				schoolPriorityStore.proxy.extraParams = {
//            						academyLocationId :this.getCurrentAcademyLocation()
//            				};
//            				//schoolPriorityStore.load();
//            				
//            				var campaignNew=form.down('#campaignNameId');
//                        	campaignNew.reset();
//                        	var campaignNewStore = campaignNew.getStore();
//                        	campaignNewStore.proxy.extraParams = {
//                        			academyLocationIds : null
//    	    	        	};
//                        	//campaignNewStore.load();
//            				
//            				var campaignField=form.down('#trackEnquiry_capaignName');
//            				var campaignStore = campaignField.getStore();
//            				campaignStore.proxy.extraParams = {
//            						academyLocationId : null
//            				};
//            				//campaignStore.load();
//            				
//            				var school=form.down('#schoolId');
//            				var schoolStore = school.getStore();
//            				schoolStore.proxy.extraParams = {
//            						campaignId :null
//            				};
//            				//schoolStore.load();
//            				form.down('#countryRegionFilterId').setDisabled(true);
//  	        				form.down('#cityFilterId').setDisabled(true);
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid]':{
            			render:function(grid){
            			   grid.setTitle(getCommonTranslation('LIST_OF_ENQUIRIES'));
            			   var $this=this;
                           var permissionsMap = new Ext.util.HashMap();
                           this.gridRenderFunction(grid);
                           permissionsMap = $this.getTRACKENQUIRY_PERMISSIONS();
                           $this.genericCBGridAccessControlValidation(grid,permissionsMap);
                           $this.disableMoreActionPivileges(grid,permissionsMap);
                           /**
                            * THis function is used to hide button menu while scrolling.
                            */
                           $this.hideButtonMenuWhileScrolling(grid);
                         },
                         cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
                        	 this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);
                        	 e.stopEvent();
                        	 e.stopPropagation();
                        	 //return true;//comment code for uncheck selected record
                         },
         	         	selectionchange: function(column, selected,eOpts ){
                        	this.disableExportReportButton(column,selected); 
                        	
                        	
        	                var $this = this;
        	                var grid = this.getSearchresultgrid();
        			    	var changLinkApplication = grid.down('#changeLinkedApplication');
        					var count=selected.length;
        	  		        var flag=true;
        	  		    	var selectionModel = grid.getSelectionModel().getSelection();
        	  		    	selectionModel.forEach(function(obj){
        	  		            if(count == 1 && obj.get('TRACK_ENQUIRY_STATUS')=="Closed"){
        	  		            	grid.down('#changeLinkedApplication').setDisabled(false);
        	  		                }else{
        	  		              	grid.down('#changeLinkedApplication').setDisabled(true);   
        	  		                }

        	  		        });
                        },
                        afterrender:function(grid){
                        	var me=this;
                        	me.addDataGridConfigButton(grid,me.getTRACKENQUIRY_PERMISSIONS());
                        },
                        show:function(grid, eOpts) {
                        	grid.down('#searchResultGridBtnDelete').setDisabled(false);
                        	grid.down('#searchResultGridBtnEdit').setDisabled(false);
                        }
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid]':{
            			render:function(grid){
            				var $this=this;
                            var permissionsMap = new Ext.util.HashMap();
                            $this.gridRenderFunction(grid);
                           permissionsMap = $this.getTRACKENQUIRY_PERMISSIONS();
                           $this.genericCBGridAccessControlValidation(grid,permissionsMap);
                           $this.disableMoreActionPivileges(grid,permissionsMap);
                           
                           grid.down('#viewDocumentsLinked').setVisible(false);
                           
                           /**
                            * THis function is used to hide button menu while scrolling.
                            */
                           $this.hideButtonMenuWhileScrolling(grid);
                         },
                         cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
                        	 this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);
                        	e.stopEvent();
                			e.stopPropagation();
                         },
                         afterrender:function(grid){
                        	 var me=this;
                        	 me.addDataGridConfigButton(grid,me.getTRACKENQUIRY_PERMISSIONS());
                         }
            		},
            	  
            		'searchresultgrid[itemId=checkduplicatelistgrid]':{
            			render:function(grid){
            				this.gridRenderFunction(grid);
            				this.genericCBGridAccessControlValidation(grid,this.getDUPLICATEDETAILS_PERMISSIONS());
            			},
            			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            				this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);
                       	 	e.stopEvent();
                			e.stopPropagation();
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid]':{
            			render:function(grid){
            			   var $this=this;
                           var permissionsMap = new Ext.util.HashMap();
                           $this.gridRenderFunction(grid);
                           permissionsMap = $this.getTRACKENQUIRY_PERMISSIONS();
                           $this.genericCBGridAccessControlValidation(grid,permissionsMap);
                           $this.disableMoreActionPivileges(grid,permissionsMap);
                           grid.down('#viewDocumentsLinked').setVisible(false);
                           /**
                            * THis function is used to hide button menu while scrolling.
                            */
                           $this.hideButtonMenuWhileScrolling(grid);
                         },
                         cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
                        	 this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);
                        	 var grid=this.getSearchresultgrid();
                        	 var buttonId="Edit"; 
                        	 e.stopEvent();
                 			e.stopPropagation();
                         },
                         afterrender:function(grid){
                         	var me=this;
                         	me.addDataGridConfigButton(grid,me.getTRACKENQUIRY_PERMISSIONS());
                         },
                         selectionchange: function(column, selected,eOpts ){
                         	this.disableEditAndDeleteButton(column,selected);               	
                         },
                         show:function(grid, eOpts) {
                        	 grid.down('#searchResultGridBtnDelete').setDisabled(false);
                             grid.down('#searchResultGridBtnEdit').setDisabled(false);
                         }
            		},
            		
          		'searchresultgrid[itemId=checkduplicatelistgrid] button[itemId=add]':{
            			click:this.loadEnquiryForDuplicateValue
            		},
            		'searchresultgrid[itemId=trackenquirygrid] button[itemId=searchResultGridBtnAdd]': {
            			click: function(button, e, eOpts) {
            				this.oprenCreateEnquiry();
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=trackenquirygrid] button[itemId=searchResultGridBtnEdit]': {
            			click: function(button, e, eOpts) {
            				var grid=this.getSearchresultgrid();
            				var buttonId="Edit"; 
            				this.linkClicked(0,0,grid,buttonId);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=trackenquirygrid] button[itemId=searchResultGridBtnView]': {
            			click: function(button, e, eOpts) {
            				var grid=this.getSearchresultgrid();
            				this.viewEnquiryFormWindow(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] button[itemId=searchResultGridBtnDelete]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.ownerCt.ownerCt;
            				this.deleteEnquiry(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'enquirysendsurvey button#saveBtn': {
                 	   click: function(obj) {
                 		  var grid = this.getTrackEnquiry();
                 		   this.sendSurveyDetails(obj,grid);
                 	   }
                    },
                    
            		'popiaoption button#saveBtn': {
                  	   click: function(obj) {
                  		  var grid = this.getTrackEnquiry();
                  		   this.sendPopiaStatus(obj,grid);
                  	   }
                     },
                     'changelinkedapplication button#saveBtn': {
                    	   click: function(obj) {
                    		  var grid = this.getTrackEnquiry();
                    		   this.saveChangeLinkedApplication(obj);
                    	   }
                       },
                       
            		'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=searchResultGridBtnAdd]': {
            			click: function(button, e, eOpts) {
            				this.oprenCreateEnquiry();
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=searchResultGridBtnEdit]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.ownerCt.ownerCt;
            				var buttonId="Edit"; 
            				this.linkClicked(0,0,grid,buttonId);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=searchResultGridBtnView]': {
            			click : function(obj, e, eOptsj){
            				var grid = obj.ownerCt.ownerCt;
            				this.viewEnquiryFormWindow(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=searchResultGridBtnDelete]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.ownerCt.ownerCt;
            				this.deleteEnquiry(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		
            		//=============================== Non admission enqyiry start
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=searchResultGridBtnAdd]': {
            			click: function(button, e, eOpts) {
            				this.oprenCreateEnquiry();
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=searchResultGridBtnEdit]': {
            			click: function(button, e, eOpts) {
            				var buttonId="Edit"; 
            				this.linkClicked(0,0,grid,buttonId);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=searchResultGridBtnView]': {
            			click: function(button, e, eOpts) {
            				this.viewEnquiryFormWindow(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=searchResultGridBtnDelete]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.ownerCt.ownerCt;
            				this.deleteEnquiry(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=checkDuplicateNameLinked]': {
            			click : function(obj, e, eOpts){ 
            				this.checkCommonDuplicateValue(obj);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=checkDuplicateEmailLinked]': {
            			click : function(obj, e, eOpts){ 
            				this.checkCommonDuplicateValue(obj);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=checkDuplicateMobileLinked]': {
            			click : function(obj, e, eOpts){ 
            				this.checkCommonDuplicateValue(obj);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=checkDuplicatePhoneLinked]': {
            			click : function(obj, e, eOpts){ 
            				this.checkCommonDuplicateValue(obj);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=viewDocumentsLinked]': {
            			click: function(obj, e, eOpts){
            				var grid = obj.up('grid');
            				this.viewUploadDocuments(grid);
            				e.stopEvent();
            				e.stopPropagation();
            				return false;
            			}
            		},
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=sendSurveyBtn]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getEnquirysendsurvey();
                			   if(!window){
                				   window = Ext.widget('enquirysendsurvey');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
            		
            		'searchresultgrid[itemId=tracknonadmissionenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getTracknonadmissionenquirygrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=tracknonadmissionenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
        	            click: function() {
        	            	var searchResultGrid=this.getTracknonadmissionenquirygrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=tracknonadmissionenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getTracknonadmissionenquirygrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=tracknonadmissionenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
        	            click: function() {         	            	
        	            	var searchResultGrid=this.getTracknonadmissionenquirygrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,searchResultGrid);
        	            }
        	        },
            		//=============================== Non admission enquiry end
            		
            		
            		
            		'trackenquiryform customcombobox#trackEnquiry_academyId': { // getting the academyId from the form and sending request to server
            			select: function(obj, record) {
            				var store = this.getStore('common.LocationStore');

            				store.getProxy().extraParams = {
            					academyId: record[0].get("id")
            				};
            				store.load();
            				obj.nextSibling().clearValue();
            			}
            		},
            		'enquiryuploadform':{
            			render:function(obj){
    	        			var $this=this;
    	    	        	var importWin=$this.getEnquiryuploadform()
    	    	        	var moduleName = importWin.down('#moduleName');
    	    	        	moduleName.getStore().load({
    	    	        		callback: function(records, operation, success) {
    	    	        			for(var i in records){
    		    	        			if(records[i].data.value=="Enquiry" || records[i].data.value=="enquiry"){
    		    	        				moduleName.setValue(records[i].data.id);
    		    	        				moduleName.setReadOnly(true)
    		    	        			}
    	    	        			}
     	            		   }	
    	    	        	});
    	        		}
            		},
            		'trackenquiryform':{
            			 afterrender:function(){
							 var $this=this; 
            				 var form=this.getTrackenquiryform().getForm();
							  var enquiryTypeField=form.findField("enquiryType");
							  var enquiryCodeStore=form.findField("enquiryCode").getStore();
							  var locations = [];
								var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
								for(var i=0; i<academyLocationList.length; i++){
									locations.push(academyLocationList[i].id);
								}
							  enquiryTypeField.store.load({
								  callback: function(records, operation, success) {
									  var id;
									  for(var i=0; i<records.length; i++){
										  var code = records[i].data.code;
										  if(code == 'Admission'){
											  id=records[i].data.id;
										  }
									  }
									  enquiryTypeField.setValue(id); 
									  if(!isNullOrEmpty(id)) {
										  enquiryCodeStore.getProxy().extraParams = {
											  academyLocationIds:locations.join(),
											  enquiryType:'Admission',
											  enquiryTypeId:id
										  };
									  } else {
										  enquiryCodeStore.getProxy().extraParams = {
											  academyLocationIds:locations.join(),
											  enquiryType:null,
											  enquiryTypeId:null
										  };
									  }
									 
								  }
							  });
							  //enquiryCode.getStore().load();
							  
							  var schoolPriority=form.findField('schoolPriority');
							  var schoolPriorityStore = schoolPriority.getStore();
							  schoolPriorityStore.proxy.extraParams = {
									  academyLocationId : this.getCurrentAcademyLocation()
							  };
							  //schoolPriorityStore.load();

							  var school=form.findField('school');
							  var schoolStore = school.getStore();
							  schoolStore.proxy.extraParams = {
									  //academyLocationIds :locations.join()
									  academyLocationIds :this.getCurrentAcademyLocation()
							  };
							  //schoolStore.load();
							  
							  var associatedAcadLocationIds = new Array();
							  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
							  var trackEnquiryPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTRACKENQUIRY_PERMISSIONS());
							  var showAllEnquiry = false;
							  var showMyEnquiry = false;

							  Ext.each(trackEnquiryPermissionList, function(privilege) {
							      if (privilege === 'VIEW_ALL_ENQUIRIES') {
							          showAllEnquiry = true;
							      }
							      if (privilege === 'VIEW_MY_ENQUIRIES') {
							          showMyEnquiry = true;
							      }
							  });

							  var searchForm = this.getTrackenquiryform();
							  var showEnquiriewByTypeItemId = searchForm.down('#showEnquiriewByTypeItemId');

							  if (showAllEnquiry && showMyEnquiry) {
							      showEnquiriewByTypeItemId.setVisible(true);
							  } else if (!showAllEnquiry && !showMyEnquiry) {
							      showEnquiriewByTypeItemId.setVisible(false);
							      showEnquiriewByTypeItemId.setValue({
							          showEnquiriewByType: 'MY_ENQUIRIES'
							      });
							  } else if (showAllEnquiry) {
							      showEnquiriewByTypeItemId.setVisible(false);
							      showEnquiriewByTypeItemId.setValue({
							          showEnquiriewByType: 'ALL_ENQUIRIES'
							      });
							  } else if (showMyEnquiry) {
							      showEnquiriewByTypeItemId.setVisible(false);
							      showEnquiriewByTypeItemId.setValue({
							          showEnquiriewByType: 'MY_ENQUIRIES'
							      });
							  }
						  }
            		},
            		
            		'trackenquiryform customcombobox[itemId=trackEnquiry_enquiryCode]':{
                            change: function(value,newValue) {
                                if(!isNullOrEmpty(newValue)){

                                     var alinfomodel = Academia.model.authentication.ALInfoModel;
                                     var isSchool = alinfomodel.get('wheatherSchool');




                                    var form = this.getTrackenquiryform();
                                    var formDate = form.down("#trackEnquiry_dateFrom").getValue();
                                     var ALValue = form.down("#academyLocationCombo").getValue();

                                     if(!isNullOrEmpty(ALValue)){
                                       var AlJoin =  ALValue
                                     }else{
                                      var locations = [];
                                      var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
                                     for(var i=0; i<academyLocationList.length; i++){
                                      locations.push(academyLocationList[i].id);
                                      }
                                    var AlJoin =  locations.join()
                                     }
                                    var enquiryField = form.down("#trackEnquiry_enquiryCode");
                                    enquiryField.getStore().getProxy().extraParams = {
                                        fromDate: dateRender(formDate),
                                        wheatherSchool:isSchool,
                                        academyLocationIds:AlJoin
                                    };
                                }
                            }
                    },


            		'trackenquiryform radiogroup[itemId=showEnquiriewByTypeItemId]': {
            		    change: function(cb, nv, ov) {
            		        var searchForm = this.getTrackenquiryform();
            		        var enquiryOwner = searchForm.down("#enquiryOwner");
            		        var followUpUser = searchForm.down("#followUpUser");

            		        if (nv.showEnquiriewByType == 'ALL_ENQUIRIES') {
            		            enquiryOwner.setVisible(true);
            		            followUpUser.setVisible(true);
            		        } else {
            		            enquiryOwner.setVisible(false);
            		            followUpUser.setVisible(false);
            		        }
            		    }
            		},
            		'trackenquiryform customcombobox[itemId=campaignNameId]':{
            			select:function(obj, record){
            				var $this=this; 
            				var form=this.getTrackenquiryform();
            				var campaignId=form.down('#campaignNameId').getValue();
            				var schoolPriority=form.down('#schoolPriorityId');
            				schoolPriority.reset();
            				var schoolPriorityStore = schoolPriority.getStore();
            				schoolPriorityStore.proxy.extraParams = {
            						campaignId :campaignId
            				};
            				schoolPriorityStore.load();

            				var school=form.down('#schoolId');
            				school.reset();
            				var schoolStore = school.getStore();
            				schoolStore.proxy.extraParams = {
            						campaignId :campaignId
            				};
            				schoolStore.load();
            			}
            		},
            		'trackenquiryform customcombobox[itemId=schoolPriorityId]':{
            			select:function(obj, record){
            				var $this=this; 
            				var form=this.getTrackenquiryform();
            				var schoolPriority=form.down('#schoolPriorityId').getValue();
            				var campaignId=form.down('#campaignNameId').getValue();
            				var school=form.down('#schoolId');
            				school.reset();
            				var schoolStore = school.getStore();
            				schoolStore.proxy.extraParams = {
            						priority :schoolPriority,
            						campaignId :campaignId
            				};
            				schoolStore.load();
            			}
            		},
            		'trackenquiryform customcombobox[itemId=academyLocationCombo]': {
                        render: function(combo) {
                        	var me = this;
                        	var form = me.getTrackenquiryform();
                        	var store = combo.getStore();
                            store.getProxy().extraParams = {
                        		id: this.getCurrentlyLoggedInUser().id
                        	};
                            //store.load();
                            store.load({
                    			callback:function(records,response,success){
                    				combo.setValue(me.getCurrentAcademyLocation());
                    				if(me.getCurrentAcademyLocation()){
                    					form.down('#programId').setDisabled(false);
                    				}
                    			}
                    		});
                            
                        },
            			change: function(value,newValue) {
                    		if(isNullOrEmpty(newValue)){
                    			var form = this.getTrackenquiryform();
                    			form.down('#programId').reset();
                    			form.down('#programId').setDisabled(true);
                    			form.down("#batchId").reset();
                    			form.down("#batchId").setDisabled(true);
                    			form.down("#seatTypeId").reset();
                    			form.down("#seatTypeId").setDisabled(true);
                    			
                    		}
                    	},
                        select: function(combo, record) {
                        	var acadLocId = record[0].get('id');
                        	var form = this.getTrackenquiryform();
                        	var programField=form.down('#programId');
                        	programField.setDisabled(false);
                        	var programStore = programField.getStore();
                        	programField.reset();
                        	var programGroupId=form.down('#programGroup').getValue();
                        	programStore.proxy.extraParams = {
                        			academyLocationIds : acadLocId,
    	    	        			programGroupId:programGroupId
    	    	        	};
                        	programStore.load();
                        	var campaignField=form.down('#trackEnquiry_capaignName');
                        	var campaignStore = campaignField.getStore();
                        	campaignStore.proxy.extraParams = {
    	    	        			academyLocationId : acadLocId
    	    	        	};
                        	campaignStore.load();
                        	
                        	var campaignNew=form.down('#campaignNameId');
                        	campaignNew.reset();
                        	var campaignNewStore = campaignNew.getStore();
                        	campaignNewStore.proxy.extraParams = {
                        			academyLocationIds : acadLocId
    	    	        	};
                        	campaignNewStore.load();
                        	
                        	var schoolPriority=form.down('#schoolPriorityId');
                        	schoolPriority.reset();
                        	var schoolPriorityStore = schoolPriority.getStore();
                        	schoolPriorityStore.proxy.extraParams = {
                        			academyLocationId : acadLocId
                        	};
                        	schoolPriorityStore.load();
                        	
                        	var school=form.down('#schoolId');
                        	school.reset();
            				var schoolStore = school.getStore();
            				schoolStore.proxy.extraParams = {
            						academyLocationIds :acadLocId
            				};
            				schoolStore.load();
                        }
            		},
            		'trackenquiryform customcombobox[itemId=programId]': {
            			render : function(combo){
            				var me = this;
            				var academyLocationId = this.getUserAccessibleAL();
            				var store = combo.getStore();
            				store.proxy.extraParams = {
            						//academyLocationIds : academyLocationId.join()
            						academyLocationIds : me.getCurrentAcademyLocation()
            				};
            				//store.load();
            			},
                       	select: function(obj, record) {
                       		var form = this.getTrackenquiryform(); 
                       		form.down("#batchId").reset();
                			form.down("#batchId").setDisabled(false);
                			form.down("#seatTypeId").reset();
                			form.down("#seatTypeId").setDisabled(true);
            				var programId = record[0].get("id");
            				if (programId > 0) {
            					var store=form.down("#batchId").getStore();
            				//	var store = this.getStore('enquiry.AcademicBatchStore');
            					store.getProxy().extraParams = {
            						id: programId
            					};
            					store.load();
            				}
            			},
         	/*	change: function(value,newValue) {
                    		if(isNullOrEmpty(newValue)){
                    			var form = this.getTrackenquiryform();
                    			form.down("#batchId").reset();
                    			form.down("#batchId").setDisabled(true);
                    			form.down("#seatTypeId").reset();
                    			form.down("#seatTypeId").setDisabled(true);
                    		}
                    	}
                    	*/
            		},
            		
            	
            		
            		'trackenquiryform customcombobox[itemId=programGroup]': {
            			select: function(obj, record) {
            				var programGroupId = record[0].get("id");
            				var form = this.getTrackenquiryform();
                        	var programField=form.down('#programId');
                        	var programStore = programField.getStore();
                        	programField.reset();
                        	var academyLocationId=form.down('#academyLocationCombo').getValue();
                        	if(!isNullOrEmpty(academyLocationId)){
                        		academyLocationIds=academyLocationId;
                        	}else{
                        		academyLocationIds = this.getUserAccessibleAL().join();	
                        	}
                        	programStore.getProxy().extraParams = {
            					programGroupId: programGroupId,
            					academyLocationIds: academyLocationIds
            				};
                        	programStore.load();
            			}
            		},
            		
            		'trackenquiryform customcombobox#batchId': {
            			select: function(obj, record) {
            				var form = this.getTrackenquiryform(); 
            				form.down("#seatTypeId").reset();
                			form.down("#seatTypeId").setDisabled(false);
            				var batchId = record[0].get("id");
            				if (batchId > 0) {
            					var store=form.down("#seatTypeId").getStore();
            					//var store = this.getStore('enquiry.ProgramBatchSeatTypeStore');
            					store.getProxy().extraParams = {
            						id: batchId
            					};
            					store.load();
            				}
            			},
           /*   		change: function(value,newValue) {
                    		if(isNullOrEmpty(newValue)){
                    			var form = this.getTrackenquiryform(); 
                    			form.down("#seatTypeId").setDisabled(true);
                    		}
                    	}
                    	*/
            		},
            		'trackenquiryform customcombobox#trackEnquiry_enquiryType':{
            			select: function(obj, record) {
            				var $this=this;
            				var enquiryType = record[0].get("code");
            				var enquiryTypeId = record[0].get("id");
            			    var form = $this.getTrackenquiryform().getForm();
            				var companyName = form.findField("companyName");
            				var contactPerson = form.findField("contactPerson");
       					  	var enquirerFirstName = form.findField("enquiryFirstName");
       					  	var enquirerMiddleName = form.findField("enquirerMiddleName");
       					  	var enquirerLastName = form.findField("enquirerLastName");
       					  	
       					  	var programId = form.findField("programId");
    					  	var batchId = form.findField("batchId");
    					  	var seatTypeId = form.findField("seatTypeId");
    					  	var enquiryCode=form.findField("enquiryCode");
    					  	var enquiryCodeStore=enquiryCode.getStore();
    					  	enquiryCode.reset();
    					  	
       					  	var grid = $this.getTrackEnquiry();
            				if(enquiryType == 'Corporate'){
            					companyName.setVisible(true);
           					 	contactPerson.setVisible(true);
           					 	if (enquirerFirstName != undefined || enquirerFirstName != null) {
           					 		enquirerFirstName.setVisible(false);
           					 	}
           					 	if (enquirerMiddleName != undefined || enquirerMiddleName != null) {
           					 		enquirerMiddleName.setVisible(false);
           					 	}
           					 	if (enquirerLastName != undefined || enquirerMiddleName != null) {
           					 		enquirerLastName.setVisible(false);
           					 	}
								programId.setVisible(false);
           					 	batchId.setVisible(false);
           					 	seatTypeId.setVisible(false);
        					 	
           					    grid.down("#trackenquirygrid").setVisible(false);
           					    grid.down("#trackcorporateenquirygrid").setVisible(true);
           					    grid.down("#tracknonadmissionenquirygrid").setVisible(false);
           					    //grid.down("#trackcorporateenquirygrid").getStore().removeAll();
           					    var store = grid.down("#trackcorporateenquirygrid").getStore();
           					    //store.load();
           					    enquiryCodeStore.getProxy().setExtraParam('enquiryType',null);
           					    enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',enquiryTypeId);
           					 
            				}else if(enquiryType == 'Counselling'){
            					companyName.setVisible(false);
           					 	contactPerson.setVisible(false);
           					 	if (enquirerFirstName != undefined || enquirerFirstName != null) {
           					 		enquirerFirstName.setVisible(true);
           					 	}
           					 	if (enquirerMiddleName != undefined || enquirerMiddleName != null) {
           					 		enquirerMiddleName.setVisible(true);
           					 	}
           					 	if (enquirerLastName != undefined || enquirerMiddleName != null) {
           					 		enquirerLastName.setVisible(true);
           					 	}
								programId.setVisible(true);
        					 	batchId.setVisible(true);
        					 	seatTypeId.setVisible(true);
           					 	
           					    grid.down("#trackenquirygrid").setVisible(false);
         					    grid.down("#trackcorporateenquirygrid").setVisible(false);
         					    grid.down("#tracknonadmissionenquirygrid").setVisible(true);
               				    //grid.down("#trackenquirygrid").getStore().removeAll();
         					    var store = grid.down("#trackenquirygrid").getStore();
         					    //store.load();
         					    enquiryCodeStore.getProxy().setExtraParam('enquiryType',null);
         					    enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',enquiryTypeId);
            			    	}else if(enquiryType == 'Admission'){
            					companyName.setVisible(false);
           					 	contactPerson.setVisible(false);
           					 	if (!isNullOrEmpty(enquirerFirstName)) {
									enquirerFirstName.setVisible(true);
								}
								if (!isNullOrEmpty(enquirerMiddleName)) {
									enquirerMiddleName.setVisible(true);
								}
								if (!isNullOrEmpty(enquirerLastName)) {
									enquirerLastName.setVisible(true);
								}
								programId.setVisible(true);
        					 	batchId.setVisible(true);
        					 	seatTypeId.setVisible(true);
           					 	
           					 	grid.down("#trackenquirygrid").setVisible(true);
           					 	grid.down("#trackcorporateenquirygrid").setVisible(false);
           					 	grid.down("#tracknonadmissionenquirygrid").setVisible(false);
           					 	//grid.down("#trackenquirygrid").getStore().removeAll();
            					var store = grid.down("#trackenquirygrid").getStore();
      		    			    //store.load();
            					enquiryCodeStore.getProxy().setExtraParam('enquiryType','Admission');
            					enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',enquiryTypeId);
            				}else{
            					companyName.setVisible(false);
           					 	contactPerson.setVisible(false);
           					 	if (enquirerFirstName != undefined || enquirerFirstName != null) {
           					 		enquirerFirstName.setVisible(true);
           					 	}
           					 	if (enquirerMiddleName != undefined || enquirerMiddleName != null) {
           					 		enquirerMiddleName.setVisible(true);
           					 	}
           					 	if (enquirerLastName != undefined || enquirerMiddleName != null) {
           					 		enquirerLastName.setVisible(true);
           					 	}
								programId.setVisible(true);
        					 	batchId.setVisible(true);
        					 	seatTypeId.setVisible(true);
           					 	
           					    grid.down("#trackenquirygrid").setVisible(false);
         					    grid.down("#trackcorporateenquirygrid").setVisible(false);
         					    grid.down("#tracknonadmissionenquirygrid").setVisible(true);
         					    //grid.down("#trackenquirygrid").getStore().removeAll();
         				   	    var store = grid.down("#trackenquirygrid").getStore();
     		    			    //store.load();
         				   	    enquiryCodeStore.getProxy().setExtraParam('enquiryType',null);
         				   	    enquiryCodeStore.getProxy().setExtraParam('enquiryTypeId',enquiryTypeId);
            				}
            			}
            		},
            		'trackenquiryform customcombobox#trackEnquiry_locationId': { // getting the academyId, locationId from the form and sending request to server
            			select: function(obj, record) {
            				var programComboBox = Ext.ComponentQuery.query('customcombobox#trackEnquiry_academyId')[0];
            				var academyId = programComboBox.getValue();
            				var locationId = record[0].get("id");
            				var store = this.getStore('common.ProgramByAcAndLoIdStore');
            				store.getProxy().extraParams = { // appending the parameters to server url
            					academyId: academyId,
            					locationId: locationId
            				};
            				store.load(); // getting the data and loading combo box
            			}
            		},
            		
            	'enquiryupdatesdownloadform multiselectcombofield#academyLocationItemId': {
                     render: function(combo) {
                        	var me = this;
                        	var form = me.getEnquiryupdatesdownloadform();
                        	var store = combo.getStore();
                            store.getProxy().extraParams = {
                        		id: this.getCurrentlyLoggedInUser().id
                        	};
                            //store.load();
                            store.load({
                    			callback:function(records,response,success){
                    				combo.setValue(me.getCurrentAcademyLocation());
                    				if(me.getCurrentAcademyLocation()){
                    					form.down('#programId').setDisabled(false);
                    				}
                    			}
                    		});
                            
                        },
            			
                        change: function(combo, record) {
                        	var $this = this;
                        	var form = combo.up('form');
                       	 	var formValues = form.getValues();
                       	 	var programCombo = form.down('#programId');
                       	 	var campaignNew = form.down('#campaignId');
                       		var programGroupCombo = form.down('#programGroup');
                       	 	var academyLocationId = $this.getCurrentAcademyLocation();
        	               	var academyLocationData=[];
        	   		        if(formValues.academyLocation !="" && formValues.academyLocation !=null){
        	   		        	for(var i in formValues.academyLocation){
        	   		        		if(Ext.isObject(formValues.academyLocation[i])&& !isNullOrEmpty(formValues.academyLocation[i])){
        	   		        			al = formValues.academyLocation[i];
        	   		        			academyLocationData.push(al);
        	   		        		}else{
        	   		        			if(!isNullOrEmpty(formValues.academyLocation[i])){
        	   		        				al = formValues.academyLocation[i];
        	   		        				academyLocationData.push(al);
        	   		        			}
        	   		        		} 
        	   		        	}
        	   		    	}	
        	   		        programCombo.reset();
        	   		        programCombo.clearValue();
        	   		        programGroupCombo.reset();
        	   		        programGroupCombo.clearValue();
        	   		        campaignNew.clearValue();
                    	 	var programStore = programCombo.getStore();
                    	 	var programGroupStore =programGroupCombo.getStore();
                    	 	if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
        	               		programStore.getProxy().extraParams = {
        	               		    academyLocationIds: academyLocationData.join(),
        	               		    programGroupId:programGroupCombo.getValue(),
        	               		};
        	               		programStore.load();
                    	 	}
                    	 	else{
                    	 		programStore.getProxy().extraParams = {
                    	 			academyLocationIds: academyLocationId,
                    	 			programGroupId:programGroupCombo.getValue()
                    	 		};
                    	 		programStore.load();
                    	 	}
                    		if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
                    		
                    			programGroupStore.load();
                    	 	}
                    		
                    	 	var campaignNewStore = campaignNew.getStore();
                    		if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
                    			campaignNewStore.getProxy().extraParams = {
        	               		    academyLocationIds: academyLocationData.join(),
        	               		};
                    			campaignNewStore.load();
                    	 	}
                    	 
                        }
            		},
            		
            		'enquiryupdatesdownloadform' :{
            			afterrender:function(form){
            				var $this = this;
            				var academyLocationId = $this.getCurrentAcademyLocation();
            				var academyLocation = form.down('#academyLocationItemId');
            				academyLocation.getStore().load({
            					callback: function(record){
            						academyLocation.select(academyLocationId);
            					}
            				});
            			}
            		},
            		
            		
            		 'enquiryupdatesdownloadform combo[itemId=templateForId]':{
            		     select:function(obj,records) {
            		     var form = this.getEnquiryupdatesdownloadform();
            		     var downloadButton = form.down('#downloadEnquiryNewFormItemId');
            		     var valid = form.isValid();      				
           				if(valid) {
           					 downloadButton.setDisabled(false);
             	            } 
            		     }
            		 },
            		 
            		 
            		 'enquiryupdatesdownloadform multiselectcombofield[itemId=campaignId]':{
            			 render:function(obj,records) {
            		     var academyLocationId = this.getCurrentAcademyLocation();
            		     obj.getStore().proxy.extraParams = {
 	                       		academyLocationIds : academyLocationId
 	      					};
            		     obj.getStore().load();
            		     }
            		 },
            		
            		'enquiryupdatesdownloadform multiselectcombofield[itemId=programId]': {
            			/*render : function(obj){
            				var academyLocationId = this.getCurrentAcademyLocation();
            				var store = obj.getStore();
            				obj.getStore().getProxy().extraParams = {
            						academyLocationIds : this.getCurrentAcademyLocation()
            				};
            				store.load();
            			}*/render : function(combo){
 	                		var $this = this;
 	                		var academyLocationId = $this.getCurrentAcademyLocation();
 	                		var store = combo.getStore();
 	                       	store.proxy.extraParams = {
 	                       		academyLocationIds : academyLocationId
 	      					};
 	                       	store.load();
 	                  	},
 	                  change:function(obj,record){
						   var form = obj.up('form');
						   var values = form.getForm().getValues();
						   var programId = values.programId;
						   var batch = form.down('#batch');
						   batch.reset();
						   var programids=[];
						   var programs; 
						   if(programId !=undefined && programId.length > 0){
							   batch.setDisabled(false);
					    		for(var i in programId){
					    			if(Ext.isObject(programId[0])){
					    				programids.push(programId[i].get("id"));
					    			}else{
					    				programids.push(programId[i]);
					    			}
					    		}
					    	programs = programids.join();
					    	var store = batch.getStore();
 	                       	store.proxy.extraParams = {
 	                       		programIds : programs,
 	      					};
 	                       	store.load();
					    	}else{
					    		batch.setDisabled(true);
					    	}
					   }
			   },
            		 'enquiryupdatesdownloadform multiselectcombofield[itemId=batch]': {
						    change : function(obj){
							    var form = this.getEnquiryupdatesdownloadform().getForm();
			            		var batchId = obj.up('form').down('#batch').getValue();
			            		
								   var batchids=[];
								   var batchs; 
								   var seatType = obj.up('form').down('#seatType');
								   seatType.reset();
								   if(batchId !=undefined && batchId.length > 0){
									   seatType.setDisabled(false);
							    		for(var i in batchId){
							    			if(Ext.isObject(batchId[0])){
							    				batchids.push(batchId[i].get("id"));
							    			}else{
							    				batchids.push(batchId[i]);
							    			}
							    		}
							    		batchs = batchids.join();
							    		var store = seatType.getStore();
										   store.getProxy().extraParams = {
											   batchIds : batchs
												};
										   store.load();
							    	}else{
							    		seatType.setDisabled(true);
							    		seatType.getStore().removeAll();
							    	}
						   }
					   
            		},
            		
            		'enquiryupdatesdownloadform customcombobox[itemId=enquiryTypeItemId]':{
          	        	change : function(obj,rec){
          	        		this.selectEnquiryTypeTemp(obj,rec);
          	        	}
          	        },
            		
          	      'enquiryupdatesdownloadform customcombobox[itemId=templateForId]':{
        	        	change : function(obj,rec){
        	        		this.selectTemplateForIdTemp(obj,rec);
        	        	}
        	        },
            		'enquiryupdatesdownloadform combo#programGroup': {
            			  render : function(obj) {
             				 var store = obj.getStore();
             				 var academyLocationId=this.getCurrentAcademyLocation();
             				/* store.getProxy().extraParams = {
             					academyLocationIds: academyLocationId
             				 };*/
             				 store.load();
             			 },
            			
            		select: function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var formValues  = form.getValues();
	                	 var academyLocationValue = form.down('#academyLocationItemId').getValue();
	                	// var academyLocationId = $this.getCurrentAcademyLocation();
     	               	var academyLocationData=[];
	                	 var program = form.down('#programId');
	                	 var programStore = program.getStore();
	                	 program.reset();
	                	 for(var i in academyLocationValue){
	                	 if(Ext.isObject(academyLocationValue[i])){
	                		 academyLocationData.push(academyLocationValue[i].data.id);
	                	 }else{
	                		 academyLocationData.push(academyLocationValue[i]);
	                	 }
	                	 }
	                	 var academyLocation = academyLocationData.join();
	                	 if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
     	               		programStore.getProxy().extraParams = {
     	               		    academyLocationIds: academyLocation,
     	               		    programGroupId:programgroupId
     	               		};
     	               		programStore.load();
                 	 	}
                 	 	else{
                 	 		programStore.getProxy().extraParams = {
                 	 			academyLocationIds: academyLocationValue,
                 	 			programGroupId:programgroupId
                 	 		};
                 	 		programStore.load();
                 	 	}
            			}
            		
            		},
            		
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=checkDuplicateNameLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=checkDuplicateEmailLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=checkDuplicateMobileLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=checkDuplicatePhoneLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=viewDocumentsLinked]': {
            			click: function(obj){
            				var grid = obj.up('grid');
            				this.viewUploadDocuments(grid);	
            			}
            		},
            		
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=reassignBtn]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getEnquiryreassignwindow();
                			   if(!window){
                				   window = Ext.widget('enquiryreassignwindow');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
            		
            		'enquiryreassignwindow button[itemId=saveBtn]':{
   	        		click: this.saveAllEnquiryReassign
         		 },
            		
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=sendSurveyBtn]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getEnquirysendsurvey();
                			   if(!window){
                				   window = Ext.widget('enquirysendsurvey');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
            		
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=popiaOptionBtn]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getPopiaoption();
                			   if(!window){
                				   window = Ext.widget('popiaoption');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
            		'searchresultgrid[itemId=trackenquirygrid] menuitem[itemId=changeLinkedApplication]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getChangelinkedapplication();
                			   if(!window){
                				   window = Ext.widget('changelinkedapplication');
                			   }
                			   window.show();
                			   var form = window.down('form');
                			   form.down('#saveBtn').setDisabled(true);
                			   if(grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID !=null){
                				   
                				var applicationId = form.down('#applicationId');
                				var applicationIdStore = applicationId.getStore();
               				 		applicationIdStore.getProxy().extraParams.code=grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID
                				
               				 		applicationId.getStore().load({
                   					callback: function(record){
                   						if(!isNullOrEmpty(record)){
                   							applicationId.setValue(record[0].data.id);
                   						}
                   					}
               				 		});
                			   }
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
            		
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=checkDuplicateNameLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=checkDuplicateEmailLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=checkDuplicateMobileLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=checkDuplicatePhoneLinked]': {
            			click : function(obj){ 
            				this.checkCommonDuplicateValue(obj);
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=viewDocumentsLinked]': {
            			click: function(obj){
            				var grid = obj.up('grid');
            				this.viewUploadDocuments(grid);	
            			}
            		},
            		'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=sendSurveyBtn]': {
            			click : function(obj, e, eOpts){
            				var grid = obj.up('grid');
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getEnquirysendsurvey();
                			   if(!window){
                				   window = Ext.widget('enquirysendsurvey');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
            		},
          		  'searchresultgrid[itemId=checkduplicatelistgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getSearchresultgrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=checkduplicatelistgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
        	            click: function() {
        	            	var searchResultGrid=this.getSearchresultgrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=checkduplicatelistgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getSearchresultgrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=checkduplicatelistgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
        	            click: function() {         	            	
        	            	var searchResultGrid=this.getSearchresultgrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,searchResultGrid);
        	            }
        	        },
            		  'searchresultgrid[itemId=trackenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
          	            click: function() {
          	            	var searchResultGrid=this.getSearchresultgrid();
          	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
          	            }
          	        },
          	        'searchresultgrid[itemId=trackenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
          	            click: function() {
          	            	var searchResultGrid=this.getSearchresultgrid();
          	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,searchResultGrid);
          	            }
          	        },
          	        'searchresultgrid[itemId=trackenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
          	            click: function() {
          	            	var searchResultGrid=this.getSearchresultgrid();
          	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
          	            }
          	        },
          	        'searchresultgrid[itemId=trackenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
          	            click: function() {         	            	
          	            	var searchResultGrid=this.getSearchresultgrid();
          	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,searchResultGrid);
          	            }
          	        },
                   'changelinkedapplication customcombobox[itemId=applicationId]': {
                     	change : function(obj) {
         	            	var academyLocationId = this.getCurrentAcademyLocation();
                     		var applicationId = this.getChangelinkedapplication().down('#applicationId');
                     		if(applicationId.getValue() != null){
                     			this.getChangelinkedapplication().down('#saveBtn').setDisabled(false);
                     		}else{
                     			this.getChangelinkedapplication().down('#saveBtn').setDisabled(true);
                     		}
                     		var store = applicationId.getStore();
                     		store.getProxy().extraParams = {
                     			academyLocationId: academyLocationId
                     		};
                     	}
                     },
                     
          	        'enquirysendmessage[itemId=trackEnquirySendMessageWindow] radiogroup[itemId=messageType]':{
          	        	change : function(val,nV,oV){
          	        		this.selectSectionMessageType(val,nV,oV);
          	        	}
          	        },
          	        'enquirysendmessage[itemId=trackEnquirySendMessageWindow] customcombobox[itemId=msgTempletId]':{
          	        	select : function(obj,rec){
          	        		this.selectEnquiryMessageTemp(obj,rec);
          	        	}
          	        },
          	        'enquirysendmessage[itemId=trackEnquirySendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
          	        	click: function(obj) {
          	        		var gridItemId = obj.up('enquirysendmessage').customGridId;
          	        		
          	        		var grid = Ext.ComponentQuery.query('#' +gridItemId)[0];
          	        		var enquirysendmessage = this.getEnquirysendmessage();
          	        		enquirysendmessage.down('#adhocMsgSubmitBtn').setDisabled(true);
          	        		var formPnl = obj.up('form');
          	        	    var isMySelfChecked = false;
          	        	    var whetherParent=false;
          	        	    formPnl.down('#adhocMsgSubmitBtn').setDisabled(true);
          	        	    var fldValues = formPnl.getForm().getFieldValues();
          	        	    isMySelfChecked = fldValues.recieverType;
          	        	    whetherParent=fldValues.recieverTypeParent;
          	        	    var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
          	        		enquirysendmessage.sendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId,whetherParent);
          	        	}
          	        },'enquirysendmessage[itemId=trackEnquirySendMessageWindow]  filefield[itemId=staticUploadFileField]': {
          	        	change: function(fileField, value, eOpts){
          	        		var this$ = this;
          	        		this$.uploadEnquiryStaticDocumentFileMessage(fileField, value, eOpts);
          	        	}
          	        },
          	        'enquirystaticdocumentattachmentgrid actioncolumn': {
          	        	click : function(view, rowIndex, colIndex, item, e, record, row){
          	        		this.deleteEnquiryStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
          	        	}
          	        },'enquirysendmessage[itemId=trackEnquirySendMessageWindow]': {
          	        	render: function(grid){
          	        		var this$ = this;
          	        		var docGrid = grid.down('#enquiryStaticDocumentAttachmentGridMessage');
          	        		docGrid.getStore().removeAll();
          	        		docGrid.getStore().sync();
          	        	}
          	        }, 'enquirysendmessage[itemId=trackEnquirySendMessageWindow] radiogroup#sendingPriority': {
          	        	change: function( radio, newValue, oldValue, eOpts) {
          	        		this.loadEnquiryScheduleField(radio, newValue, oldValue);
          	        	}
          	        },

          	        /*V2D-13247*/
          	        'enquirysendmessage[itemId=trackEnquirySendMessageWindow] textarea[itemId=smsDiscription]':{
          	        	change : function(val,nV,oV){
          	        		var enquirySendMessage = this.getEnquirysendmessage();
          	        		var smsTextField = enquirySendMessage.down('#smsDiscription');
          	        		var smsTextFieldDiscription = enquirySendMessage.down('#smsDiscriptionNotice');
          	        		var maxLength = localStorage.getItem('maxLength');
          	        		var newValue = maxLength - smsTextField.getValue().length;
          	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
          	        	}
          	        },
          	        
          	      'searchresultgrid[itemId=trackenquirygrid] button[itemId=exportReportsId]':{
          	    	  click: this.exportXLFunction
	          		},

          	      'searchresultgrid[itemId=trackenquirygrid] button[itemId=sendMessageBtn]': {
      	            click: this.openEnquirySendMessage
      	        },
      	        
      	        'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=sendMessageBtn]': {
      	        	click: this.openEnquirySendMessage
    	        },
    	        'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=sendMessageBtn]': {
    	        	click: this.openEnquirySendMessage
      	        },
      	        'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=reassignBtn]': {
      	        	click : function(obj, e, eOpts){
      	        		var grid = obj.up('grid');
      	        		if (grid.getSelectionModel().getCount() > 0) {
      	        			var this$ = this;
      	        			var window = this$.getEnquiryreassignwindow();
      	        			if(!window){
      	        				window = Ext.widget('enquiryreassignwindow');
      	        			}
      	        			window.show();
      	        		} else {
      	        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      	        		}  
      	        	}
      	        },
      	      'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=popiaOptionBtn]': {
      			click : function(obj, e, eOpts){
      				var grid = obj.up('grid');
          		   if (grid.getSelectionModel().getCount() > 0) {
          			   var this$ = this;
          			   var window = this$.getPopiaoption();
          			   if(!window){
          				   window = Ext.widget('popiaoption');
          			   }
          			   window.show();
          		   } else {
          			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
          		   }  
          	   }
      		},
      		'searchresultgrid[itemId=tracknonadmissionenquirygrid] menuitem[itemId=changeLinkedApplication]': {
      			click : function(obj, e, eOpts){
      				var grid = obj.up('grid');
          		   if (grid.getSelectionModel().getCount() > 0) {
          			   var this$ = this;
          			   var window = this$.getChangelinkedapplication();
          			   if(!window){
          				   window = Ext.widget('changelinkedapplication');
          			   }
          			   window.show();
          			  var form = window.down('form');
          			  form.down('#saveBtn').setDisabled(true);
          			  if(grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID !=null){
       				   
          				  var applicationId = form.down('#applicationId');
          				  var applicationIdStore = applicationId.getStore();
      				 		applicationIdStore.getProxy().extraParams.code=grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID
       				
      				 		applicationId.getStore().load({
          					callback: function(record){
          						if(!isNullOrEmpty(record)){
          							applicationId.setValue(record[0].data.id);
          						}
          					}
      				 		});
          			  }
          		   } else {
          			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
          		   }  
          	   }
      		},
      		
          		  'searchresultgrid[itemId=trackcorporateenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getTrackcorporateenquirygrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=trackcorporateenquirygrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
        	            click: function() {
        	            	var searchResultGrid=this.getTrackcorporateenquirygrid();
        	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=trackcorporateenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
        	            click: function() {
        	            	var searchResultGrid=this.getTrackcorporateenquirygrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=trackcorporateenquirygrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
        	            click: function() {         	            	
        	            	var searchResultGrid=this.getTrackcorporateenquirygrid();
        	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,searchResultGrid);
        	            }
        	        },
        	        'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=reassignBtn]': {
          	        	click : function(obj, e, eOpts){
          	        		var grid = obj.up('grid');
          	        		if (grid.getSelectionModel().getCount() > 0) {
          	        			var this$ = this;
          	        			var window = this$.getEnquiryreassignwindow();
          	        			if(!window){
          	        				window = Ext.widget('enquiryreassignwindow');
          	        			}
          	        			window.show();
          	        		} else {
          	        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
          	        		}  
          	        	}
          	        },
          	      'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=popiaOptionBtn]': {
          			click : function(obj, e, eOpts){
          				var grid = obj.up('grid');
              		   if (grid.getSelectionModel().getCount() > 0) {
              			   var this$ = this;
              			   var window = this$.getPopiaoption();
              			   if(!window){
              				   window = Ext.widget('popiaoption');
              			   }
              			   window.show();
              		   } else {
              			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
              		   }  
              	   }
          		},
          		 'searchresultgrid[itemId=trackcorporateenquirygrid] menuitem[itemId=changeLinkedApplication]': {
           			click : function(obj, e, eOpts){
           				var grid = obj.up('grid');
               		   if (grid.getSelectionModel().getCount() > 0) {
               			   var this$ = this;
               			   var window = this$.getChangelinkedapplication();
               			   if(!window){
               				   window = Ext.widget('changelinkedapplication');
               			   }
               			   window.show();
               			  var form = window.down('form');
               			  form.down('#saveBtn').setDisabled(true);
               			  if(grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID !=null){
           				   
               				  var applicationId = form.down('#applicationId');
               				  var applicationIdStore = applicationId.getStore();
          				 		applicationIdStore.getProxy().extraParams.code=grid.getSelectionModel().getSelection()[0].data.APPLICATION_ID
           				
          				 		applicationId.getStore().load({
              					callback: function(record){
              						if(!isNullOrEmpty(record)){
              							applicationId.setValue(record[0].data.id);
              						}
              					}
          				 		});
               			  }
               		   } else {
               			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
               		   }  
               	   }
           		},
          		
        	        'trackEnquiry':{
        	        	afterrender : function(structure){
        	        		var $this = this;
        	        		structure.body.on('scroll', function(e, target) {
        	        			var enquiryGrid = $this.getSearchresultgrid();
        	        			var corporateEnquiryGrid = $this.getTrackcorporateenquirygrid();
        	        			var nonAdmissionEnquiryGrid = $this.getTracknonadmissionenquirygrid();

        	        			var grid = null;
        	        			if(!enquiryGrid.isHidden()){
        	        				grid = $this.getSearchresultgrid();;
        	        			}
        	        			if(!corporateEnquiryGrid.isHidden()){
        	        				grid = $this.getTrackcorporateenquirygrid();
        	        			}
        	        			if(!nonAdmissionEnquiryGrid.isHidden()){
        	        				grid = $this.getTracknonadmissionenquirygrid();
        	        			} 
        	        			$this.getMultipleCBGridHeaderFreeze(grid,structure);
        	        		});
        	        	}
              			 },
              			'enquiryuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
          	   			   change: this.downloadUploadFormChange
          	   		   	},
          	   		   	
          	   		   	'enquirydownloadform multiselectcombofield[itemId=academyLocationId]':{
          	   		   		change: function() {
          	   		   			var store = this.getStore('common.AcademyLocationNameSeparated');
          	   		   			store.load();
          	   		   		}
          	   		   	},
          	   		   	
          	   		   'enquirydownloadform button[itemId=programBatchDownolad]':{
      	   		   		 click: function() {
      	   		   			 var jsonData = this.createJsonforenquiryDownload();
      	   		   			 
      	   		   			 var csvForm = Ext.create('Ext.form.Panel',{
      	   		   			 items:[{
   	        	    			xtype : 'textfield',
   	        	    			maxLength : 20480,
   	        	    			itemId : 'exportListDTO',
   	        	    			name : 'exportListDTO',
   	        	    			vtype : 'spaceAsInput'
      	   		   			 }]
      	   		   			});
   	        			
      	   		   			csvForm.down('#exportListDTO').setValue(Ext.encode(jsonData));
      	   		   			csvForm.getForm().submit({
   		  	        		  target: '_blank',
   		  	        		  method:'POST',
   		  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
   		  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   		  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_ENQUIRY,
   		  	        		  standardSubmit :true,
   		  	        		  success : function(form, action){
 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 	    	    	          },
 	    	        		  failure: function(form, action) {
 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 	    	    	          }
   		  	        	  });
      	   		   		 }
      	   		   	  },
      	   		   	  
      	   		   	  'enquirydownloadform button[itemId=resetBtn]':{
      	   		   		  click:function(obj){
      	   		   			  var $this=this;
      	   		   			  var enquirydownloadform = $this.getEnquirydownloadform().getForm();
      	   		   			  var academyLocationId = $this.getEnquirydownloadform().down("#academyLocationId");
      	   		   			  academyLocationId.clearAllDataFn();
      	   		   			  enquirydownloadform.reset();
      	   		   		  }
      	   		   	  },
      	   		   	  
      	   		 'enquiryuploadform button[itemId=resetBtn]':{
   	        		click:function(obj){
   	        			var $this=this;
   	        			var enquiryUploadForm = $this.getEnquiryuploadform().getForm();
   	        			enquiryUploadForm.findField('file').reset();
   	        			var uploadoptionradiogroupform  = $this.getEnquiryuploadoptionradiogroup();
   	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
   	        				isUploadAll: false
   	        			});
   	        		}
         		 },
         		 
         		'enquiryuploadform button[itemId=programBatchUpload]':{
 	        		click:function(obj){
 	        			var $this=this;
 	    	        	var importWin=$this.getEnquiryuploadform()
 	    	        	var grdStore;
 	    	        	var form=$this.getEnquiryuploadform();
 	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
 	    	        	Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
	 	    	        	form.getForm().submit({
	 	    	        		method : 'POST',
	 	    	        		url : submitUrl,
	 	    	        		success : function(form, action){
	 	    	        			Ext.getBody().unmask();
	 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
	 	    	    	        },
	 	    	        		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	 	    	    	        }
	 	    	        	});
			        	},1000);

 	    	        	Ext.defer(function() {
 	    	        		var grid = $this.getImportlistenquiry();
 	    	        		var form = $this.getEnquiryuploadoptionradiogroup();
 	    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
 	    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_UPLOAD');
 	         	        }, 2000, this);
 	        		}  
        		 },
	      	 		'enquiryuploadform uploadoptionradiogroup[itemId=enquiryUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	      	 			change: function( radioGroup, newValue, oldValue, eOpts){
	      	 				var grid =this.getImportlistenquiry();
	      	 				var form =this.getEnquiryuploadoptionradiogroup();
	      	 				var isUploadAll = newValue.isUploadAll;
	      	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ENQUIRY_UPLOAD');
	      	 			}   
	      	 		},
        		 'importlistenquiry':{
          			render:function(obj){
     	   				var $this = this;
      		    		var grid = $this.getImportlistenquiry();
      		    		var form = $this.getEnquiryuploadoptionradiogroup();
      		    		var isUploadAll = form.items.items[0].getValue().isUploadAll;
      		    		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_UPLOAD');
     	   			},
      		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
         				if (e.target.tagName == 'A') {
         					var fileType=null;
         					if(cellIndex==1){
         						fileType='successFile';
         					}else if(cellIndex==6){
         						fileType='errorFile';
         					}else if(cellIndex==7){
         						fileType='logFile';
         					}
         					var documentId = record.get("id");
         					if (!isNullOrEmpty(documentId)) {
         						this.getDownloadFile(documentId,fileType);
         					}
         				}
         			}
          		},
          		 'importlistenquiry button[itemId=btnForce]':{
      	   			click: function(obj) {
      		            	var grid = this.getImportlistenquiry();
      		            	if (grid.getSelectionModel().getCount() > 0) {
      		            		if(grid.getSelectionModel().getCount() > 1){
      			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
      			        		}else{
      			        			var this$ = this;
      	   	                	var id = grid.getSelectionModel().selectionStart.data.id;
      	   	                	console.log(id);
      	   	                	var urlAppend="?jobName="+id;
      	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
      	   	    	        	Ext.Ajax.request({
      	   	    	        		url: submitURL,
      	   	    	        		method: 'GET',
      	   	    	        		success: function(response) {
      	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
      	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
      	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
      	   	    	        				//console.log("Manual trigger hit");
      	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
      	   	    	        			}else if(response.responseText==="SUCCESS"){
      	   	    	        				//console.log("Manual trigger hit");
      	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
      	       	    	        			grid.getStore().reload();
      	   	    	        			}
      	   	    	        		}
      	   	    	        	});
      			        		}
      		            	} else {
      		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      		            	}  
      		            }
      	 		   },
	      	 		'enquirynewuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]': {
	      	 		    change: this.downloadUploadFormChangeNew
	      	 		},
	      	 		
	      	 		'enquiryimportenquiryupdatesstructure radiogroup[itemId=importEnquiryUpdatesRadioGroupItemId]': {
	      	 		    change: this.downloadUploadFormChangeImportEnquiryUpdates
	      	 		},
	      	 		
	      	 		'enquirynewdownloadform multiselectcombofield[itemId=academyLocationId]': {
	      	 		    change: function() {
	      	 		        var store = this.getStore('common.AcademyLocationNameSeparated');
	      	 		        store.load();
	      	 		    }
	      	 		},
	      	 		
	      	 		
	      	 		'enquirynewdownloadform button[itemId=downloadEnquiryNewFormItemId]': {
	      	 		    click: function() {
	      	 		        var jsonData = this.createJsonForEnquiryNewFormDownload();
	
	      	 		        var csvForm = Ext.create('Ext.form.Panel', {
	      	 		            items: [{
	      	 		                xtype: 'textfield',
	      	 		                maxLength: 20480,
	      	 		                itemId: 'exportListDTO',
	      	 		                name: 'exportListDTO',
	      	 		                vtype: 'spaceAsInput'
	      	 		            }]
	      	 		        });
	
	      	 		        csvForm.down('#exportListDTO').setValue(Ext.encode(jsonData));
	      	 		        csvForm.getForm().submit({
	      	 		            target: '_blank',
	      	 		            method: 'POST',
	      	 		            params: {
	      	 		                access_token: Ext.Ajax.defaultHeaders.access_token
	      	 		            },
	      	 		            headers: {
	      	 		                'Authorization': Ext.Ajax.defaultHeaders.Authorization
	      	 		            },
	      	 		            url: SERVERURL.DOWNLOAD_TEMPLATE_ENQUIRY_NEW,
	      	 		            standardSubmit: true,
	      	 		            success: function(form, action) {
	      	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	      	 		            },
	      	 		            failure: function(form, action) {
	      	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	      	 		            }
	      	 		        });
	      	 		    }
	      	 		},
	      	 		'enquirynewdownloadform button[itemId=resetBtn]':{
	      	 			click:function(obj){
	      	 				var $this=this;
	      	 				var enquirynewdownloadform = $this.getEnquirynewdownloadform().getForm();
	      	 				var academyLocationId = $this.getEnquirynewdownloadform().down("#academyLocationItemId");
	      	 				academyLocationId.clearAllDataFn();
	      	 				enquirynewdownloadform.reset();
	      	 			}
	      	 		},
	      	 		'enquirynewuploadform button[itemId=resetBtn]': {
	      	 		    click: function(obj) {
	      	 		        var $this = this;
	      	 		        var enquirynewuploadform = $this.getEnquirynewuploadform().getForm();
	      	 		        enquirynewuploadform.findField('file').reset();
	      	 		        var uploadoptionradiogroupform  = $this.getEnquirynewuploadoptionradiogroup();
	      	 		        uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	      	 		        	isUploadAll: false
	      	 		        });
	      	 		    }
	      	 		},
	      	 		
	      	 		'enquiryupdatesdownloadform button[itemId=resetBtn]': {
	      	 		    click: function(obj) {
	      	 		    	var $this=this;
	      	 				var enquiryupdatesdownloadform = $this.getEnquiryupdatesdownloadform().getForm();
	      	 				//var multiselectAcademyId = enquiryupdatesdownloadform.down('#academyLocationItemId');
	      	 				var multiselectAcademyId = $this.getEnquiryupdatesdownloadform().down("#academyLocationItemId");
	      	 				multiselectAcademyId.clearAllDataFn();
	      	 				var academyLocationId = this.getCurrentAcademyLocation();
	      		 			multiselectAcademyId.getStore().load({
	      						callback: function(record){
	      							multiselectAcademyId.select(academyLocationId);
	      						}
	      					});
	      	 				enquiryupdatesdownloadform.reset();
	      	 		    }
	      	 		},
	      	 		
	      	 		'enquiryupdatesdownloadform button[itemId=downloadEnquiryNewFormItemId]': {
	      	 			click:function(obj){
	   	        			var $this = this;
	   	        			var form =$this.getEnquiryupdatesdownloadform();
	   	        			var formValues = form.getFormValues();
	   	        			if(!isNullOrEmpty(formValues) && !isNullOrEmpty(formValues.templateFor) && (formValues.templateFor=="Follow Up Details" || 
	   	        					formValues.templateFor=="Student Details" || formValues.templateFor=="Enquiry Details" || formValues.templateFor=="Appointment Details" ||
	   	        					formValues.templateFor=="Education Details" || formValues.templateFor=="Closure Details" || formValues.templateFor=="Admission Details")) {
	   	        				if((formValues.templateFor=="Student Details" && formValues.enquiryType!=1) || formValues.templateFor=="Admission Details" && formValues.enquiryType!=1 ) {
	   	        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_LOADER_IS_FOR_ADMISSION_TYPE'));
	   	        				}
	   	        				else if (formValues.templateFor=="Follow Up Details" &&formValues.enquiryStatus=="C"){
	   	        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FOLLOWUP_NOT_WORK_FOR_CLOSED'));
	   	        				}
	   	        				else{
		   	        			var values = this.getEnquiryUpdateLoaderJson(formValues);
	
		   	        			var csvForm = Ext.create('Ext.form.Panel',{
		   	        	    		items:[{
		   	        	    			xtype : 'textfield',
		   	        	    			maxLength : 20480,
		   	        	    			itemId : 'exportListDTO',
		   	        	    			name : 'exportListDTO',
		   	        	    			vtype : 'spaceAsInput'
		   	        	    		}]
		   	        	    	});
		   	        			
		   	        			csvForm.down('#exportListDTO').setValue(values);
		   	        			csvForm.getForm().submit({
		   		  	        		  target: '_blank',
		   		  	        		  method:'POST',
		   		  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   		  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		   		  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_ENQUIRY_UPDATE,
		   		  	        		  standardSubmit :true,
		   		  	        		  success : function(form, action){
		 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	    	    	          },
		 	    	        		  failure: function(form, action) {
		 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	    	    	          }
		   		  	        	  });
		   	        		}
	   	        			}
	   	        		}
	      	 		},
	      	 		
	      	 		'enquiryupdatesuploadform button[itemId=resetBtn]': {
	      	 		    click: function(obj) {
	      	 		        var $this = this;
	      	 		        var enquiryupdatesuploadform = $this.getEnquiryupdatesuploadform().getForm();
	      	 		        enquiryupdatesuploadform.reset();
	      	 		        var uploadoptionradiogroupform  = $this.getImportEnquiryUpdatesRadioGroup();
	      	 		        uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	      	 		        	isUploadAll: false
	      	 		        });
	      	 		    }
	      	 		},
	      	 		
	      	 		'enquirynewuploadform': {
	      	 		    render: function(obj) {
	      	 		        var $this = this;
	      	 		        var importWin = $this.getEnquirynewuploadform()
	      	 		        var moduleName = importWin.down('#moduleName');
	      	 		        moduleName.getStore().load({
	      	 		            callback: function(records, operation, success) {
	      	 		                for (var i in records) {
	      	 		                    if (records[i].data.value == "Bulk Enquiry New") {
	      	 		                        moduleName.setValue(records[i].data.id);
	      	 		                        moduleName.setReadOnly(true)
	      	 		                    }
	      	 		                }
	      	 		            }
	      	 		        });
	      	 		    }
	      	 		},
	      	 		'enquirynewuploadform button[itemId=uploadEnquiryNewFormItemId]': {
	      	 		    click: function(obj) {
	      	 		        var $this = this;
	      	 		        var grdStore;
	      	 		        var form = $this.getEnquirynewuploadform();
	      	 		        submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		    	        	$this.getHashOfFile(form);
				        	setTimeout(function() {
		      	 		        form.getForm().submit({
		      	 		            method: 'POST',
		      	 		            url: submitUrl,
		      	 		            success: function(form, action) {
		      	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		      	 		            },
		      	 		            failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		      	 		            }
		      	 		        });
				        	},1000);
	      	 		        Ext.defer(function() {
	      	 		            var grid = $this.getImportlistenquirynewgrid();
	      	 		            var form = $this.getEnquirynewuploadoptionradiogroup();
	      	 		            var isUploadAll = form.items.items[0].getValue().isUploadAll;
	      	 		            $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_NEW_UPLOAD');
	      	 		        }, 2000, this);
	      	 		    }
	      	 		},
	      	 		'enquirynewuploadform uploadoptionradiogroup[itemId=enquirynewUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	      	 			change: function( radioGroup, newValue, oldValue, eOpts){
	      	 				var grid =this.getImportlistenquirynewgrid();
	      	 				var form =this.getEnquirynewuploadoptionradiogroup();
	      	 				var isUploadAll = newValue.isUploadAll;
	      	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ENQUIRY_NEW_UPLOAD');
	      	 			}   
	      	 		},
	      	 		
	      	 		'enquiryupdatesuploadform': {
	      	 		    render: function(obj) {
	      	 		        var $this = this;
	      	 		        var importWin = $this.getEnquiryupdatesuploadform()
	      	 		        //var moduleName = importWin.down('#moduleName');
	      	 		     /*   moduleName.getStore().load({
	      	 		            callback: function(records, operation, success) {
	      	 		                for (var i in records) {
	      	 		                    if (records[i].data.value == "Import Enquiry Updates") {
	      	 		                        moduleName.setValue(records[i].data.id);
	      	 		                        moduleName.setReadOnly(true)
	      	 		                    }
	      	 		                }
	      	 		            }
	      	 		        });*/
	      	 		    }
	      	 		},
	      	 		
	      	 		'enquiryupdatesuploadform customcombobox[itemId=templateForId]': {
	        			 select: function(obj, record) {
	        				 var $this = this;
	        				 var form = $this.getEnquiryupdatesuploadform();
	        				 var templateName = form.getForm().getValues().templateFor;
	        				 var moduleName = null;
	        				 switch (templateName){
		      	 		    	case null:
		      	 		    		break;
		      	 		    	case 'Follow Up Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_FOLLOW_UP';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Student Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_STUDENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Appointment Details':
		      	 		    		moduleName = 'IMPORT_BULK_APPOINTMENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Enquiry Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Education Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_EDUCATION_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Closure Details':
		      	 		    		moduleName = 'IMPORT_BULK_CLOSURE_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;	
		      	 		    	case 'Admission Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_ADMISSION_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	default : null;
		     				}
	        				var combo = form.down('#moduleName');
	        				combo.reset();
	         				combo.getStore().load({
	         					 callback: function(records, operation, success) {
	         						 if(!isNullOrEmpty(moduleName)) {
	         						 for(var i in records){
	         							 if(moduleName=='IMPORT_BULK_ENQUIRY_FOLLOW_UP' && records[i].data.value=='Bulk Enquiry Follow Up'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_ENQUIRY_STUDENT_DETAILS' && records[i].data.value=='Bulk Enquiry Student Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_APPOINTMENT_DETAILS' && records[i].data.value=='Bulk Appointment Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_ENQUIRY_DETAILS' && records[i].data.value=='Bulk Enquiry Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_ENQUIRY_EDUCATION_DETAILS' && records[i].data.value=='Bulk Enquiry Education Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_CLOSURE_DETAILS' && records[i].data.value=='Bulk Closure Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         							if(moduleName=='IMPORT_BULK_ENQUIRY_ADMISSION_DETAILS' && records[i].data.value=='Bulk Enquiry Admission Details'){
	         								 combo.setValue(records[i].data.id);
	         								 combo.setReadOnly(true);
	         							 }
	         						 }
	         						 }
	         					 }	   
	         				});
	        				var grid = $this.getImportenquiryupdatesgrid();
	      	 		        var form = $this.getEnquiryupdatesuploadform();
	      	 		        var isUploadAll = form.getForm().getValues().isUploadAll;
	      	 		        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	        			 }
	        		 },
	        		 
	      	 		'enquiryupdatesuploadform button[itemId=enquiryUpdateUploadButtonItemId]': {
	      	 		    click: function(obj) {
	      	 		        var $this = this;
	      	 		        var grdStore;
	      	 		        var form = $this.getEnquiryupdatesuploadform();
	      	 		        var moduleName = null;
	      	 		        var templateName = form.getForm().getValues().templateFor;
		      	 		    switch (templateName){
		      	 		    	case null:
		      	 		    		break;
		      	 		    	case 'Follow Up Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_FOLLOW_UP';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Student Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_STUDENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Appointment Details':
		      	 		    		moduleName = 'IMPORT_BULK_APPOINTMENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		  	case 'Enquiry Details':
	      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;	
		      	 		  		case 'Education Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_EDUCATION_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		  	case 'Closure Details':
	      	 		    		moduleName = 'IMPORT_BULK_CLOSURE_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;	
		      	 		 case 'Admission Details':
	      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_ADMISSION_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;
		      	 		    	default : null;
		     				}
		    	        	$this.getHashOfFile(form);
				        	setTimeout(function() {
		      	 		        form.getForm().submit({
		      	 		            method: 'POST',
		      	 		            url: submitUrl,
		      	 		            success: function(form, action) {
		      	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		      	 		            },
		      	 		            failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		      	 		            }
		      	 		        });
				        	},1000);
	      	 		        Ext.defer(function() {
	      	 		            var grid = $this.getImportenquiryupdatesgrid();
	      	 		            var form = $this.getEnquiryupdatesuploadform();
	      	 		            var isUploadAll = form.getForm().getValues().isUploadAll;
	      	 		            $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	      	 		        }, 2000, this);
	      	 		    }
	      	 		},
	      	 		
	      	 		'enquiryupdatesuploadform uploadoptionradiogroup[itemId=importEnquiryUpdatesRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	      	 			change: function( radioGroup, newValue, oldValue, eOpts){
	      	 				var $this=this;
	      	 				var grid =$this.getImportenquiryupdatesgrid();
	      	 				var form =$this.getEnquiryupdatesuploadform();
	      	 				var moduleName = null;
	      	 		        var templateName = form.getForm().getValues().templateFor;
		      	 		    switch (templateName){
		      	 		    	case null:
		      	 		    		break;
		      	 		    	case 'Follow Up Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_FOLLOW_UP';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Student Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_STUDENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Appointment Details':
		      	 		    		moduleName = 'IMPORT_BULK_APPOINTMENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		  	case 'Enquiry Details':
	      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;	
				      	 		case 'Education Details':
				      	 			moduleName = 'IMPORT_BULK_ENQUIRY_EDUCATION_DETAILS';
			      	 		    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			      	 		    	break;
				      	 		case 'Closure Details':
		      	 		    		moduleName = 'IMPORT_BULK_CLOSURE_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;	
				      	 		case 'Admission Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_ADMISSION_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	default : null;
		     				}
	      	 				var isUploadAll = newValue.isUploadAll;
	      	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
	      	 			}   
	      	 		},
	      	 		
	      	 		
	      	 		
	      	 		'importlistenquirynewgrid': {
	      	 		    render: function(obj) {
	      	 		        var $this = this;
	      	 		        var grid = $this.getImportlistenquirynewgrid();
	      	 		        var form = $this.getEnquirynewuploadoptionradiogroup();
		      	 		    var isUploadAll = form.items.items[0].getValue().isUploadAll;
	      	 		        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_NEW_UPLOAD');
	      	 		    },
	      	 		    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	      	 		        if (e.target.tagName == 'A') {
	      	 		            var fileType = null;
	      	 		            if (cellIndex == 1) {
	      	 		                fileType = 'successFile';
	      	 		            } else if (cellIndex == 6) {
	      	 		                fileType = 'errorFile';
	      	 		            } else if (cellIndex == 7) {
	      	 		                fileType = 'logFile';
	      	 		            }
	      	 		            var documentId = record.get("id");
	      	 		            if (!isNullOrEmpty(documentId)) {
	      	 		                this.getDownloadFileNew(documentId, fileType);
	      	 		            }
	      	 		        }
	      	 		    }
	      	 		},
	      	 		'importlistenquirynewgrid button[itemId=btnForce]': {
	      	 		    click: function(obj) {
	      	 		        var grid = this.getImportlistenquirynewgrid();
	      	 		        if (grid.getSelectionModel().getCount() > 0) {
	      	 		            if (grid.getSelectionModel().getCount() > 1) {
	      	 		                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	      	 		            } else {
	      	 		                var this$ = this;
	      	 		                var id = grid.getSelectionModel().selectionStart.data.id;
	      	 		                console.log(id);
	      	 		                var urlAppend = "?jobName=" + id;
	      	 		                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
	      	 		                Ext.Ajax.request({
	      	 		                    url: submitURL,
	      	 		                    method: 'GET',
	      	 		                    success: function(response) {
	      	 		                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
	      	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	      	 		                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
	      	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	      	 		                        } else if (response.responseText === "SUCCESS") {
	      	 		                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	      	 		                            grid.getStore().reload();
	      	 		                        }
	      	 		                    }
	      	 		                });
	      	 		            }
	      	 		        } else {
	      	 		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	      	 		        }
	      	 		    }
	      	 		},
	      	 		
	      	 		'importenquiryupdatesgrid': {
	      	 		    render: function(obj) {
	      	 		        var $this = this;
	      	 		        var grid = $this.getImportenquiryupdatesgrid();
	      	 		        var form = $this.getEnquiryupdatesuploadform();
	      	 		        var moduleName = null;
	      	 		        var templateName = form.getForm().getValues().templateFor;
		      	 		    switch (templateName){
		      	 		    	case null:
		      	 		    		break;
		      	 		    	case 'Follow Up Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_FOLLOW_UP';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Student Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_STUDENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		    	case 'Appointment Details':
		      	 		    		moduleName = 'IMPORT_BULK_APPOINTMENT_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		  	case 'Enquiry Details':
	      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;	
		      	 		  		case 'Education Details':
		      	 		    		moduleName = 'IMPORT_BULK_ENQUIRY_EDUCATION_DETAILS';
		      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		      	 		    		break;
		      	 		  	case 'Closure Details':
	      	 		    		moduleName = 'IMPORT_BULK_CLOSURE_DETAILS';
	      	 		    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	      	 		    		break;	
		      	 		    	default : null;
		     				}
	      	 		        var isUploadAll = form.getForm().getValues().isUploadAll;
	      	 		        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Import Enquiry Updates');
	      	 		    },
	      	 		    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	      	 		        if (e.target.tagName == 'A') {
	      	 		            var fileType = null;
	      	 		            if (cellIndex == 1) {
	      	 		                fileType = 'successFile';
	      	 		            } else if (cellIndex == 6) {
	      	 		                fileType = 'errorFile';
	      	 		            } else if (cellIndex == 7) {
	      	 		                fileType = 'logFile';
	      	 		            }
	      	 		            var documentId = record.get("id");
	      	 		            if (!isNullOrEmpty(documentId)) {
	      	 		                this.getDownloadFileNew(documentId, fileType);
	      	 		            }
	      	 		        }
	      	 		    }
	      	 		},
	      	 		'importenquiryupdatesgrid button[itemId=btnForce]': {
	      	 		    click: function(obj) {
	      	 		        var grid = this.getImportenquiryupdatesgrid();
	      	 		        if (grid.getSelectionModel().getCount() > 0) {
	      	 		            if (grid.getSelectionModel().getCount() > 1) {
	      	 		                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	      	 		            } else {
	      	 		                var this$ = this;
	      	 		                var id = grid.getSelectionModel().selectionStart.data.id;
	      	 		                console.log(id);
	      	 		                var urlAppend = "?jobName=" + id;
	      	 		                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
	      	 		                Ext.Ajax.request({
	      	 		                    url: submitURL,
	      	 		                    method: 'GET',
	      	 		                    success: function(response) {
	      	 		                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
	      	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	      	 		                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
	      	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	      	 		                        } else if (response.responseText === "SUCCESS") {
	      	 		                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	      	 		                            grid.getStore().reload();
	      	 		                        }
	      	 		                    }
	      	 		                });
	      	 		            }
	      	 		        } else {
	      	 		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	      	 		        }
	      	 		    }
	      	 		},
	      	 		
	      	 		
	      	 		
	      	 		'searchresultgrid[itemId=trackenquirygrid] button[itemId=followUpDetails]': {
	      	 		  click: function(obj) {
	      	 			 var grid=this.getSearchresultgrid();
	      	 				this.openEnquiryFollowUpDetailTab(0,0,grid);
	      	 		  }
	      	 		},
	      	 		'searchresultgrid[itemId=corporateCheckduplicatelistgrid] button[itemId=closeEnquiry]': {
	      	 			click: function(){
//            				var closureDetailForOtherAcademyGrid = this.getCorporateCheckduplicatelistgrid();
//            				var store = closureDetailForOtherAcademyGrid.getStore();
            				this.editCloseFormWindow(grid);
            			}
	      	 		},
	      	 		'searchresultgrid[itemId=nonAdmissionCheckduplicatelistgrid] button[itemId=closeEnquiry]': {
	      	 			click: function(){
//            				var closureDetailForOtherAcademyGrid = this.getNonAdmissionCheckduplicatelistgrid();
//            				var store = closureDetailForOtherAcademyGrid.getStore();
            				this.editCloseFormWindow(grid);
            			}
	      	 		},
	      	 		'searchresultgrid[itemId=checkduplicatelistgrid] button[itemId=closeEnquiry]': {
	      	 			click: function(){
//            				var closureDetailForOtherAcademyGrid = this.getCheckduplicatelistgrid();
//            				var store = closureDetailForOtherAcademyGrid.getStore();
            				this.editCloseFormWindow(grid);
            			}
	      	 		},
	      	 		'searchresultgrid[itemId=corporateCheckduplicatelistgrid] button[itemId=btnDeleteEnquiry]': {
	      	 			click: function(){
	      	 				var grid = this.getCorporateCheckduplicatelistgrid();
	      	 				this.deleteMultipleEnquires(grid);
	      	 			}
	      	 		},
	      	 		'searchresultgrid[itemId=nonAdmissionCheckduplicatelistgrid] button[itemId=btnDeleteEnquiry]': {
	      	 			click: function(){
	      	 				var grid = this.getNonAdmissionCheckduplicatelistgrid();
	      	 				this.deleteMultipleEnquires(grid);
	      	 			}
	      	 		},
	      	 		'searchresultgrid[itemId=checkduplicatelistgrid] button[itemId=btnDeleteEnquiry]': {
	      	 			click: function(){
	      	 				var grid = this.getCheckduplicatelistgrid();
	      	 				this.deleteMultipleEnquires(grid);
	      	 			}
	      	 		},
	      	 		'enquiryclosureform button[itemId=closureform_cancelbuttonId]':{
            			click:this.cancelClosureDetail
            		},
            		 'enquiryclosureform customcombobox#closureReasonItemId':{
              			 select:function(obj,record){
              				 var form = this.getEnquiryclosureform().down('form').getForm();
              				 var closureReason = record[0].get("value")
              				 var applicationField = form.findField("applicationId");;
              				 applicationField.allowBlank=true;
              				 applicationField.setVisible(false);
              				 applicationField.clearValue();

              				 if(closureReason=="Closed Successfully"){
              					applicationField.setVisible(true);
              					applicationField.allowBlank=false;
              				 }
              				 
              				var valid = form.isValid();      				
              				if(valid) {
              					form.findField('SubmitBtn').setDisabled(false);
                	  } 
              	    }
            	},
	      	 	'searchresultgrid[itemId=trackenquirygrid] button[itemId=makeActive]': {
            			click : function(obj){
            				var grid = obj.up('grid');
                			this.activeDeletedEnquiry(grid);
                	   }
              		 },
              		'searchresultgrid[itemId=trackcorporateenquirygrid] button[itemId=makeActive]': {
            			click : function(obj){
            				var grid = obj.up('grid');
                			this.activeDeletedEnquiry(grid);
                	   }
              		 },
              		'searchresultgrid[itemId=tracknonadmissionenquirygrid] button[itemId=makeActive]': {
            			click : function(obj){
            				var grid = obj.up('grid');
                			this.activeDeletedEnquiry(grid);
                	   }
              		 },
              		 
              		 'enquiryclosureform button[itemId=closureform_submitbuttonId]':{
             			click:function(h, grid){
             				var form = this.getEnquiryclosureform().down('form').getForm();
             				var val = form.getValues();
             				var reopenRemarks1= val.reopenRemarks;
             				var closureRemarks1= val.closureRemarks;
             				var closureRemarks1Valid='';
             				var reopenRemarks1Valid='';

             				if(closureRemarks1 != ''){
             					closureRemarks1Valid=closureRemarks1.trim();
             					if(closureRemarks1Valid==''){
             						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLOSURE_REMARKS_ALERT'));
             					}
             				}
             				if(closureRemarks1Valid !=''){
             					this.saveEnquiryClosureDetail(h, grid);	
             				}
             			}
            		},
            		'searchresultgrid[itemId=trackenquirygrid] button[itemId=sendReminder]': {
            			click : function(obj){
            				var grid = obj.up('grid');
                			this.sendReminderAction(grid);
                	   }
            		},
	      	 		'searchresultgrid[itemId=trackenquirygrid] button[itemId=makeActive]': {
            			click : function(obj){
            				var grid = obj.up('grid');
                			this.activeDeletedEnquiry(grid);
                	   }
            		}
            		
            	});
            },
            /**
			 * this function is used to hide button menu while scrolling
			 */
            hideButtonMenuWhileScrolling:function(grid){
        	    var enquiryStructure=this.getTrackEnquiry();
        	    if(enquiryStructure.body){
	        	    enquiryStructure.body.on('scroll', function(e){
					var moreactionButton=grid.down('#spBtnMoreActions');
					moreactionButton.hideMenu();
						}, enquiryStructure);
        	    }
            },
            editCloseFormWindow: function(grid) {
            	var isDiffrentRecord = false;
            	var enqStatus = 'Open';
            	if (grid.getSelectionModel().getCount() > 0) {
            		for(var i = 0; i<grid.getSelectionModel().getSelection().length; i++){
            			if(grid.getSelectionModel().getSelection()[i].data.TRACK_ENQUIRY_STATUS==='Closed'){
            				enqStatus = 'Closed'
            			}
            			for (var j=0; j<grid.getSelectionModel().getSelection().length; j++){
            				if(grid.getSelectionModel().getSelection()[i].data.TRACK_ENQUIRY_STATUS!=grid.getSelectionModel().getSelection()[j].data.TRACK_ENQUIRY_STATUS)
            					isDiffrentRecord=true;
            			}
            		}	
            		if(!isDiffrentRecord){
            			var selectedRecord = grid.getSelectionModel().getSelection()[0];
            			var enqStatus = selectedRecord.data.TRACK_ENQUIRY_STATUS;
            			if(enqStatus==='Open'){
            				var whetherDeletedEnqHere = false;
            				for(var i = 0; i<grid.getSelectionModel().getSelection().length; i++){
            					if(typeof(grid.getSelectionModel().getSelection()[i].data.whether_Deleted)==='string') {
                        			if(grid.getSelectionModel().getSelection()[i].data.whether_Deleted=='true') {
                        				grid.getSelectionModel().getSelection()[i].data.whether_Deleted=true;
                        			} else{
                        				grid.getSelectionModel().getSelection()[i].data.whether_Deleted=false;
                        			}
                        		}
            					if(grid.getSelectionModel().getSelection()[i].data.whether_Deleted)
            						whetherDeletedEnqHere = true;
            				}
            				this.showFormWindow();
            				var form = this.getEnquiryclosureform();
            				form.down('#closureDate').setValue(new Date());
            				this.showAndHideReasons(enqStatus,form);
            			}else{
            				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('Please select Open Enquires'));
            			}
            		}
            		else{
            			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('Please select Open Enquires'));
            		}
            	} else {
            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
            	}
            },
            showFormWindow : function() {

            	var formWindow = this.getEnquiryclosureform();
            	if (!formWindow) {
            		Ext.widget('enquiryclosureform');
            		formWindow = this.getEnquiryclosureform();
            	}
            	formWindow.show();

            },
            deleteMultipleEnquires:function(grid){
 	            	var grdStore = grid.getStore();  
 	            	if(grid.getSelectionModel().getCount()>0){
 	            		var records=grid.getSelectionModel().getSelection();
 	            			showConfirmMessage(getCommonTranslation('ENQUIRY_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
 	            			if (btn == 'yes') {
 	            					for(var count=0;count<records.length;count++){
 	            						var id="";
 	            						if(records[count].get("ID")!="" && records[count].get("ID")!=undefined && records[count].get("ID")!=null){
 	            							id=records[count].get("ID");
 	            						}
 	            						Ext.Ajax.request({
 	            							type: 'rest',
 	            							url: SERVERURL.ENQUIRY_DELETE+'?id='+id,
 	            							method:'DELETE',
 	            							headers: {
 	            								'Content-Type': 'application/json'
 	            							},
 	            							success:function(form, action){
 	            								grdStore.reload(); 	            								
 	            							}
 	            						});
 	            					}
 	            					showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'),getEnquiryTranslation('DELETE_ENQUIRY_MSG'));//Location deleted successfully
 	            			    }
 	            		    });
 	            	}else{
 	            		showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
 	            	}
            },
            hideButtonTrackEnquiryListingMenuWhileScrolling:function(grid,structure){
        	    var enquiryStructure=this.getTrackEnquiry();
        	    if(structure.body){
        	    	structure.body.on('scroll', function(e){
					var moreactionButton=grid.down('#spBtnMoreActions');
					moreactionButton.hideMenu();
						}, structure);
        	    }
            },
            checkCommonDuplicateValue : function(obj){
            	var $this=this;
            	var grid = null;
            	var viewCode = null;
            	var configCode = null;
            	var duplicateGrid = null;
            	var admissionGrid=$this.getSearchresultgrid();
            	var coporateGrid=$this.getTrackcorporateenquirygrid();
            	var nonAdmissionGrid = $this.getTracknonadmissionenquirygrid();
            	
            	if(!admissionGrid.isHidden()){
            		grid=admissionGrid;
            		viewCode=CONSTANTS.CB.TRACK_ENQUIRY_LIST_VIEWCODE;
            		configCode=CONSTANTS.CB.TRACK_ENQUIRY_LIST_CONFIGCODE;
            	}else if(!coporateGrid.isHidden()){
            		grid=coporateGrid;
            		viewCode=CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_VIEWCODE;
            		configCode=CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_CONFIGCODE;
            	}else if(!nonAdmissionGrid.isHidden()){
            		grid=nonAdmissionGrid;
            		viewCode=CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_VIEWCODE;
            		configCode=CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_CONFIGCODE;
            	}
            	
            	if(grid.getSelectionModel().getCount()>0){

            	var contentpanel = $this.getContentpanel();
            	var checkduplaicateenquiry = Ext.widget('checkduplicateliststructure');
            	var tabName = getCommonTranslation('DUPLICATE_DETAILS');
            	openTab(contentpanel, tabName, checkduplaicateenquiry,CONSTANTS.MENU_COLOR_ONE);

            	var duplicateAdmissionGrid=null;
                var duplicateCoporateGrid=null;
                var duplicateNonAdmissionGrid=null;
                
                Ext.each(Ext.ComponentQuery.query('#checkduplicatelistgrid'), function(currentG){
                    if(currentG.body && !isNullOrEmpty(currentG.body)){
                        duplicateAdmissionGrid=currentG;
                    }
                });
                Ext.each(Ext.ComponentQuery.query('#corporateCheckduplicatelistgrid'), function(currentG){
                    if(currentG.body && !isNullOrEmpty(currentG.body)){
                        duplicateCoporateGrid=currentG;
                    }
                });
                Ext.each(Ext.ComponentQuery.query('#nonAdmissionCheckduplicatelistgrid'), function(currentG){
                    if(currentG.body && !isNullOrEmpty(currentG.body)){
                        duplicateNonAdmissionGrid=currentG;
                    }
                });
            	
            	duplicateAdmissionGrid.setVisible(false);
            	duplicateCoporateGrid.setVisible(false);
            	duplicateNonAdmissionGrid.setVisible(false);
            	
            	if(!admissionGrid.isHidden()){
            		duplicateGrid=duplicateAdmissionGrid;
            	}else if(!coporateGrid.isHidden()){
            		duplicateGrid=duplicateCoporateGrid;
            	}else if(!nonAdmissionGrid.isHidden()){
            		duplicateGrid=duplicateNonAdmissionGrid;
            	}
            	duplicateGrid.setVisible(true);
            	
            	var records=grid.getSelectionModel().getSelection();	

            	var ENQUIRER_FIRST_NAME = records[0].get("ENQUIRER_FIRST_NAME");
            	var ENQUIRER_EMAIL = records[0].get("ENQUIRER_EMAIL");
            	
            	/*ACD-12032*/
            	var ENQUIRER_MOBILE_NO = records[0].get("ENQ_MOBILE_NO");
            	var ALTERNATE_MOBILE_NO = records[0].get("ALTERNATE_MOBILE_NO"); 
            	var ENQUIRER_PHONE_NO;
            	if(ALTERNATE_MOBILE_NO != null){
            		var arr= ALTERNATE_MOBILE_NO.split('-');
            		ENQUIRER_PHONE_NO = arr[1];
            	}/*else{
          		return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_RECORDS_FOUND'));
            	}*/

            	var searchResultGrid = duplicateGrid;

            	//close enquiry & delete btn add and permission start
            	var whetherDeletedEnquiry = false;
            	if(typeof(records[0].data.whether_Deleted)==='string') {
        			if(records[0].data.whether_Deleted=='true') {
        				records[0].data.whether_Deleted=true;
        			} else{
        				records[0].data.whether_Deleted=false;
        			}
        		}
            	whetherDeletedEnquiry = records[0].data.whether_Deleted;
            	searchResultGrid.addButtonToolbar();
            	var buttonstoolbar = searchResultGrid.down('#functionButtonsToolbar');
            	buttonstoolbar.removeAll();
            	var showCloseEnqBtn = false;
            	var associatedAcadLocationIds = new Array();
            	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            	var trackEnquiryPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTRACKENQUIRY_PERMISSIONS());
            	Ext.each(trackEnquiryPermissionList, function(privilege) {
            		if (privilege === 'ADM_CLOSE_DUPLICATE_ENQ') {
            			showCloseEnqBtn = true;
            		}
            	});
            	if(showCloseEnqBtn){
            		buttonstoolbar.insert(0,{
            			xtype: 'button',
            			itemId: 'closeEnquiry',
            			disabled:false,
            			text:getAdmissionTranslation('CLOSE_ENQUIRY'),
            			tooltip :getAdmissionTranslation('CLOSE_ENQUIRY')
            		});
            			buttonstoolbar.insert(1,{
            				xtype : 'button',				
            				itemId : 'btnDeleteEnquiry',
            				cls: 'CustomToolbarBtnReject deleteBtnEnquiry',
            				tooltip :getCommonTranslation('DELETE'),
            				glyph: ICONGLYPH.DELETEGLYPH
            			});
            	}else{
            			buttonstoolbar.insert(0,{
            				xtype : 'button',				
            				itemId : 'btnDeleteEnquiry',
            				cls: 'CustomToolbarBtnReject',
            				tooltip :getCommonTranslation('DELETE'),
            				glyph: ICONGLYPH.DELETEGLYPH
            			});	
            	}
            	//close enquiry & delete btn add and permission end
            	if(obj.itemId=="checkDuplicateNameLinked"){
            		searchResultGrid.setTitle(getEnquiryTranslation('DUPLICATE_NAME_DETAILS'));
            		var paramCodes = "ENQUIRER_FIRST_NAME";
            		this.loadEnquiryForDuplicateValue(paramCodes,ENQUIRER_FIRST_NAME,viewCode,configCode,searchResultGrid);
            	}
            	if(obj.itemId=="checkDuplicateEmailLinked"){
            		searchResultGrid.setTitle(getEnquiryTranslation('DUPLICATE_EMAIL_DETAILS'));
            		var paramCodes = "PRIMARY_EMAIL_ID";  
            		this.loadEnquiryForDuplicateValue(paramCodes,ENQUIRER_EMAIL,viewCode,configCode,searchResultGrid);
            	}
            	if(obj.itemId=="checkDuplicateMobileLinked"){
            		searchResultGrid.setTitle(getEnquiryTranslation('DUPLICATE_MOBILE_DETAILS'));
            		var paramCodes = "CELL_NO";  
            		this.loadEnquiryForDuplicateValue(paramCodes,ENQUIRER_MOBILE_NO,viewCode,configCode,searchResultGrid);
            	}
            	if(obj.itemId=="checkDuplicatePhoneLinked"){
            		searchResultGrid.setTitle(getEnquiryTranslation('DUPLICATE_PHONE_DETAILS'));
            		var paramCodes = "ALTERNATE_MOBILE_NO";  
            		this.loadEnquiryForDuplicateValue(paramCodes,ENQUIRER_PHONE_NO,viewCode,configCode,searchResultGrid);
            	}
            	}else{
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	}
            },
            sendEnquirerMessage : function(grid){

            	if(grid.getSelectionModel().getCount()>0){
            		showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SEND_SUCCESS_MESSAGE'));//Location deleted successfully
            	}else{
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	}
            },
            viewUploadDocuments : function(grid){
               
             if(grid.getSelectionModel().getCount()>0){
            
	            var records=grid.getSelectionModel().getSelection();	
	            var batchId = records[0].get("ID");
	            var store = this.getStore('enquiry.ViewDocuments');
	            store.load({params:{id:batchId}});
            		
            	var window = this.getViewdocumentswin();
        		if (!window) {
        			Ext.widget('viewdocumentswin');
        			window = this.getViewdocumentswin();
        		 }
        		  window.show();
            	}else{
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	}	
            }, 
            loadTrackGrid : function(component, options){
            	component.getStore().load();

            },
            showQuickSearch : function(){
            	var structure = this.getTrackEnquiry();
            	var qsbutton = structure.items.items[0].items.items[0]; 
            	var asbutton = structure.items.items[0].items.items[1]; 

            	var form = this.getTrackenquiryform();

            	qsbutton.hide();
            	asbutton.show();
            	form.show();
            },
            showAdvancedSearch : function(){

            	var structure = this.getTrackEnquiry();
            	var qsbutton = structure.items.items[0].items.items[0]; 
            	var asbutton = structure.items.items[0].items.items[1];

            	var form = this.getTrackenquiryform();
            	asbutton.hide();
            	qsbutton.show();
            	form.hide();
            },
            trackEnquiryGridSelection:function(model, records) {
            	this.getTrackenquirygrid().getStore().load();
        },
            trackEnquiryGrid:function(model,records){
            	if (records[0]) {
            		this.getTrackEnquiryStructure().getForm().loadRecord(records[0]);
            	}	
            },
            linkClicked : function(view,rowIndex,grid,buttonId,isCalledFromTargetByStaff,isCalledFromTargetStaffData,record){
           
            	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
            	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailController');
            	Academia.app.getController('Academia.controller.enquiry.exam.ExamDetailController');
            	Academia.app.getController('Academia.controller.enquiry.admission.AdmissionReqmntDetailController');
            	Academia.app.getController('Academia.controller.enquiry.followup.FollowUpDetailController');
            	Academia.app.getController('Academia.controller.enquiry.closure.ClosureDetailController');
            	
            	var $this = this;
            	var tabName = getEnquiryTranslation('ENQUIRY_DETAILS');
            	var getcontroller = this.getController('menu.CoreERPNavigationController');
            	var contentpanel = $this.getContentpanel();
            	var getTab = getcontroller.getTab(tabName);
            	if (getTab != null) {
            		contentpanel.remove(getTab, true);
            	}
            	var val = '';
            	if( isCalledFromTargetByStaff || grid.getSelectionModel().getCount()>0) {
            		if(isCalledFromTargetByStaff){
            			 val=isCalledFromTargetStaffData.rows[0]; 
            		}else{
            		  val=grid.getSelectionModel().getSelection()[0].data;  
            		  if(!isNullOrEmpty(record) && !isNullOrEmpty(record.data)) {
            			  val=record.data;
            		  }
            		}
            		
            		if(typeof(val.whether_Deleted)==='string') {
            			if(val.whether_Deleted=='true') {
            				val.whether_Deleted=true;
            			} else{
            				val.whether_Deleted=false;
            			}
            		}
            		if(!val.whether_Deleted){
            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
            		if (!tabStructure1) {
            			tabStructure1 = Ext.widget('enquirytabstructure');
            		}
            		var tabStructure = tabStructure1.getForm();
            		var status = val.TRACK_ENQUIRY_STATUS;
            		
            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
            			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
            				tabStructure.findField("enquiryId").setVisible(true);
            				tabStructure.findField("enquiryId").reset();
            				
            				if(val.TRACK_ENQUIRY_NO!=null && val.TRACK_ENQUIRY_NO!=undefined){
            				  tabStructure.findField("enquiryId").setValue(val.TRACK_ENQUIRY_NO);
            				}else{
            					 tabStructure.findField("enquiryId").setValue(val.id);
            				}
            			}
            			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
            				tabStructure.findField("enquiryTxtId").reset();
            				tabStructure.findField("enquiryTxtId").setVisible(false);
            			}
            		}else{
            			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
            				tabStructure.findField("enquiryTxtId").setVisible(true);
            				tabStructure.findField("enquiryTxtId").reset();
            				tabStructure.findField("enquiryTxtId").setValue(val.TRACK_ENQUIRY_NO);
            			}
            			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
            				tabStructure.findField("enquiryId").reset();
            				tabStructure.findField("enquiryId").setVisible(false);
            			}
            		}
            		
            		if(val.ID!=null && val.ID!=undefined ){
            		  tabStructure.findField("enqId").setValue(val.ID);
            		}else{
            			tabStructure.findField("enqId").setValue(val.id);
            		}
            		if(val.ENQUIRY_TYPE!=undefined){
            			if(val.ENQUIRY_TYPE_NAME!=null && val.ENQUIRY_TYPE_NAME!=""){
            				tabStructure.findField("enqTypes").setValue(val.ENQUIRY_TYPE_NAME);
            			}
            		}else{
            			tabStructure.findField("enqTypes").setValue(val.enqTypes);
            		}
            		tabStructure.findField("buttonType").setValue(buttonId);
            		var enquiryAdmissioUrl=null;
            		if(val.STUDENT_DETAIL_ID>0){
            			tabStructure.findField("studentDetailId").setValue(val.STUDENT_DETAIL_ID);
            		}
//            		var contentpanel = $this.getContentpanel();
            		var coursetabstructure = Ext.ComponentQuery.query("enquirytabstructure")[0];
            		if (!coursetabstructure) {
            			coursetabstructure = Ext.widget('enquirytabstructure');
            		}
            		if(val.ENQUIRY_TYPE != getEnquiryTranslation('CNTRL_ADMISSION')){
            			
            			/**
            			 * Hide closure follow up grid in follow up detail tab.
            			 */
            			var closureFollowupgrid=$this.getClosurefollowupgrid();
            			if(closureFollowupgrid != undefined && closureFollowupgrid != null){
            				closureFollowupgrid.setVisible(false);
            			}
            		}
            		openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_ONE);
            	
            			if(val.id!=undefined){
                			Ext.Ajax.request({
                                type : 'rest',
                                url : SERVERURL.FIND_DETAILS_BY_ENQUIRYID+'?id='+val.id,
                                method : 'GET',
                                success : function(form, action) {
                                var data = Ext.JSON.decode(form.responseText);
                                	if(!isNullOrEmpty(data)){
                                		
                                		var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
                                		if(!isNullOrEmpty(data.user)){
                                			assignToId.setVisible(true);
                                			assignToId.reset();
                                			assignToId.setValue(data.user.value);
                                		} else {
                                			assignToId.setVisible(true);
                                			assignToId.reset();
                                			assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
                                		}
                                	
                                		
                                		var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
                                		if(!isNullOrEmpty(data.enqIntermediateType)){ 
                                			intermediateStage.setValue(data.enqIntermediateType.value); 
                                		} 

                                		var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
                                		intermediateStageId.setValue(data.enqIntermediateType.id);

                                		var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
                                		if(data.status=='O'){
                                		   myTextField.setValue("Open");
                                		   var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
                   	            		if(!isNullOrEmpty(myText)){
                   	            			myText.setVisible(true);
                   	            			myText.reset();
                   	            			myText.setValue(val.code);
                   	            		}
                   	            		var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
                   	            		if(!isNullOrEmpty(myedtText)){
                   	            			myedtText.reset();
                   	            			myedtText.setVisible(false);
                   	            		}
                                		}else{
                                			myTextField.setValue("Closed");
                                			var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
                    	            		if(!isNullOrEmpty(myText)){
                    	            			myText.setVisible(true);
                    	            			myText.reset();
                    	            			myText.setValue(val.code);
                    	            		}
                    	            		var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
                    	            		if(!isNullOrEmpty(myedtText)){
                    	            			myedtText.reset();
                    	            			myedtText.setVisible(false);
                    	            		}
                                			
                                		}
                                		if(!isNullOrEmpty(data.enquiryPriority)){
                                		  var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
                                		  priorityField.setValue(data.enquiryPriority.value);
                                		

                                		var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
                                		priorityIdField.setValue(data.enquiryPriority.id);
                                		}

                                		var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
                                		if(data.enquiryStudentDetails.length!=0){ 
                                			studentName.setValue(data.enquiryStudentDetails[0].studentFirstName+" "+data.enquiryStudentDetails[0].studentLastName); 
                                		} 
                                		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
                                		if(!isNullOrEmpty(data.firstName)){ 
                                			parentName.setValue(data.firstName+" "+data.lastName); 
                                		} 
                                		if(!isNullOrEmpty(data.enquiryType)) {
                                	       tabStructure.findField("enqTypes").setValue(data.enquiryType.code);
                                		}
                                		if(data.enquiryStudentDetails.length!=0){
                                		   tabStructure.findField("studentDetailId").setValue(data.enquiryStudentDetails[0].id);
                                		   val.STUDENT_DETAIL_ID=data.enquiryStudentDetails[0].id;
                                		}else{
                                			val.STUDENT_DETAIL_ID=0;
                                		}
                                		
                                		Ext.Ajax.request({
                                            type : 'rest',
                                            url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.STUDENT_DETAIL_ID,
                                            method : 'GET',
                                            success : function(form, action) {
                                            var data = Ext.JSON.decode(form.responseText);
                                            	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
                                            	if(!isNullOrEmpty(data[0])){
                                            		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
                                            			programIntake.setValue(data[0].programIntakeCombo); 
                                            		}
                                            	}
                                            }
                                        });
                                		
                                	}
                                }
                            });
                			
                		} 
            	
            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
	            		var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
	            		if(!isNullOrEmpty(myText)){
	            			myText.setVisible(true);
	            			myText.reset();
	            			myText.setValue(val.TRACK_ENQUIRY_NO);
	            		}
	            		var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
	            		if(!isNullOrEmpty(myedtText)){
	            			myedtText.reset();
	            			myedtText.setVisible(false);
	            		}
            		}else{
            			var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
	            		if(!isNullOrEmpty(myText)){
	            			myText.setVisible(true);
	            			myText.reset();
	            			myText.setValue(val.TRACK_ENQUIRY_NO);
	            		}
	            		var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
	            		if(!isNullOrEmpty(myedtText)){
	            			myedtText.reset();
	            			myedtText.setVisible(false);
	            		}
            		}
            		var form = Ext.getCmp('followUpDetailFormId');
            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
            			form.down('#followdetail_submitbuttonId').setVisible(false);
            		}
            		if(buttonId=='View'){
            			
            			form.down('#followdetail_submitbuttonId').setVisible(false);
      	 					form.down('#actualFollowUpDate').setReadOnly(true);
      	 					form.down('#enqIntermediateStage').setReadOnly(true);
      	 					form.down('#trackEnquiry_priority').setReadOnly(true);
      	 					form.down('#remarkItemId').setReadOnly(true);
      	 					form.down('#nextFollowUpDateId').setReadOnly(true);
      	 					form.down('#userByAssignToId').setReadOnly(true);
      	 					form.down('#whetherNextFollowUpId').setDisabled(true);
            		}
            		var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
            		if(!isNullOrEmpty(val.ASSIGN_TO_ID)){
            			assignToId.setVisible(true);
            			assignToId.reset();
            			if(!isNullOrEmpty(val.ENQUIRY_OWNER)){
            				assignToId.setValue(val.ENQUIRY_OWNER);
            			} else {
            				assignToId.setValue(val.ENQ_OWNER);
            			}
            		} else if(!isNullOrEmpty(val.ASSIN_TO)){
            			assignToId.setVisible(true);
            			assignToId.reset();
            			assignToId.setValue(val.ASSIN_TO);
            		} else {
            			assignToId.setVisible(true);
            			assignToId.reset();
            			assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
            		}
            		var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
            		if(!isNullOrEmpty(val.PROSPECTIVE_STUDENT_NAME)){ 
            			studentName.setValue(val.PROSPECTIVE_STUDENT_NAME); 
            		} else if(!isNullOrEmpty(val.STUDENT_FULL_NAME)){
            			studentName.setValue(val.STUDENT_FULL_NAME);
            		}

            		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
            		if(!isNullOrEmpty(val.ENQUIRER_FIRST_NAME)){ 
            			parentName.setValue(val.ENQUIRER_FIRST_NAME); 
            		} else if(!isNullOrEmpty(val.ENQUIRER_NAME)){
            			parentName.setValue(val.ENQUIRER_NAME);
            		} 
            		
            		if(isNullOrEmpty(val.STUDENT_DETAIL_ID)){
            			val.STUDENT_DETAIL_ID = 0;
            		}
            		Ext.Ajax.request({
                        type : 'rest',
                        url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.STUDENT_DETAIL_ID,
                        method : 'GET',
                        success : function(form, action) {
                        var data = Ext.JSON.decode(form.responseText);
                        	//console.log(data);
                        	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
                        	if(!isNullOrEmpty(data[0])){
                        		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
                        			programIntake.setValue(data[0].programIntakeCombo); 
                        		}
                        	}
                        }
                    });

            		
            		var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
            		if(!isNullOrEmpty(val.ENQ_STAGE)){ 
            			intermediateStage.setValue(val.ENQ_STAGE); 
            		} else{
            			if(!isNullOrEmpty(val.ENQ_INTERMEDIATE_STAGE)){ 
            				intermediateStage.setValue(val.ENQ_INTERMEDIATE_STAGE); 
            			} }

            		var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
            		intermediateStageId.setValue(val.ENQ_INTERMEDIATE_ID);

            		var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
            		myTextField.setValue(status);

            		var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
            		priorityField.setValue(val.ENQUIRY_PRIORITY);

            		var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
            		priorityIdField.setValue(val.ENQUIRY_PRIORITY_ID);
            		 }else{
            			 // message for record already deleted
            			 showWarningMessage(getCommonTranslation('ENQUIRY_DELETE_TITLE'),getCommonTranslation('DELETED_MSSG'));//Please select a record
            		 }
            	}else{
            		showWarningMessage(getCommonTranslation('ENQUIRY_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	}
            	if(buttonId === "Edit" && (isCalledFromTargetByStaff || grid.getSelectionModel().getCount()>0) ){
            		coursetabstructure.down('button[itemId=enquirydetail_EditButtonId]').setVisible(false);
            		coursetabstructure.down('button[itemId=studentdetail_cancelbuttonId]').setVisible(false);
            		this.setMobileNoValidationForEnquiry(grid);
            	} 
            },
            oprenCreateEnquiry : function(){
            	
            	var contentpanel = this.getContentpanel();
            	
            	/**
            	 *  comment for enquiry revamp
            	 *  uncomment for previous enquiry flow
            	 */
            	var createenquiry = Ext.widget('enquiryformrevampstructure');
            	if (!createenquiry) {
            		createenquiry = Ext.widget('enquirytabstructure');
        		}
            	var tabName = getCommonTranslation('CREATE_ENQUIRY');
            	openTab(contentpanel, tabName, createenquiry,CONSTANTS.MENU_COLOR_ONE);
            	//set default logged user 
            	var followUpUserStore =createenquiry.down('#followUpUser').getStore();
            	var loggedUserId=this.getCurrentlyLoggedInUser().id;
            	Ext.defer(function() {
            	followUpUserStore.load({
            		scope:this,
	        		callback: function(records, operation, success) {
    	        			if(success){
    	        				createenquiry.down('#followUpUser').setValue(loggedUserId);
	        			}
         		   }	
	        	});
            	}, 2000, this);
            	var countryCodeField = createenquiry.down("#phoneCountryCode");
             	var mobileField = createenquiry.down("#cellNumber");
             	countryCodeField.labelSeparator = '';
             	countryCodeField.setFieldLabel('');
             	mobileField.labelSeparator = '';
             	mobileField.setFieldLabel('');
             	this$.setMaximumMinimumDigitsForMobileNoValidation(createenquiry,countryCodeField,mobileField,null);
             	countryCodeField = createenquiry.down("#alternatePhoneCountryCode");
             	mobileField = createenquiry.down("#alternateCellNumber");
             	this$.setMaximumMinimumDigitsForMobileNoValidation(createenquiry,countryCodeField,mobileField,null);
            
            },
            deleteEnquiry : function(grid) {
            	var grdStore = grid.getStore();  

            	if(grid.getSelectionModel().getCount()>0){
            		var records=grid.getSelectionModel().getSelection();
            		if(typeof(records[0].data.whether_Deleted)==='string') {
            			if(records[0].data.whether_Deleted=='true') {
            				records[0].data.whether_Deleted=true;
            			} else{
            				records[0].data.whether_Deleted=false;
            			}
            		}
            		if(!records[0].data.whether_Deleted){
            			showConfirmMessage(getCommonTranslation('ENQUIRY_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            			if (btn == 'yes') {
            					for(var count=0;count<records.length;count++){
            						var id="";
            						if(records[count].get("ID")!="" && records[count].get("ID")!=undefined && records[count].get("ID")!=null){
            							id=records[count].get("ID");
            						}
            						Ext.Ajax.request({
            							type: 'rest',
            							url: SERVERURL.ENQUIRY_DELETE+'?id='+id,
            							method:'DELETE',
            							headers: {
            								'Content-Type': 'application/json'
            							},
            							success:function(form, action){
            								grdStore.reload();            								
            							}
            						});
            					}
            					showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'),getEnquiryTranslation('DELETE_ENQUIRY_MSG'));//Location deleted successfully
            			    }
            		    });
            			}else{
            				 showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'),getCommonTranslation('DELETED_MSSG'));//Please select a record
            			 }
            	}else{
            		showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
            	}
            },
            
         // ************ save selected enquiry reassign *****************************     
            
            saveAllEnquiryReassign : function() {

            	var this$ = this;
            	var grid;
            	var admissionGrid=this$.getSearchresultgrid();
            	var coporateGrid=this$.getTrackcorporateenquirygrid();
            	var nonAdmissionGrid = this$.getTracknonadmissionenquirygrid();

            	if(!admissionGrid.isHidden()){
            		grid=admissionGrid;
            	}else if(!coporateGrid.isHidden()){
            		grid=coporateGrid;
            	}else if(!nonAdmissionGrid.isHidden()){
            		grid=nonAdmissionGrid;
            	}
          	   if(grid.getSelectionModel().getCount()>0){
          		   var reassignwindow = this$.getEnquiryreassignwindow();
            	   var applyFormVal = reassignwindow.down('form').getValues();
            	   var sendReassignNotificationField = reassignwindow.down('#sendReassignNotificationField');
            	   var submitUrl = SERVERURL.ENQUIRY_REASSIGN_SAVE_ALL; 
            	   var records = grid.getSelectionModel().getSelection();
            	   var jsonSubmitData=[];
            	   Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');
            	   for(var i in records){
            		   var data={
            				   "enquiryId":records[i].data.ID,
            				   "userId":applyFormVal.userByAssignTo,
            				   "reassignReason":applyFormVal.remark,
            				   "reassignmentDate":applyFormVal.reasignDate
            		   };
            		   if( i == 0 ){
            			   data.sendReassignNotification = applyFormVal.sendReassignNotification;
            		   }
            		   jsonSubmitData.push(data);
            	   }
            	   Ext.Ajax.request({
            		   type : 'rest',
            		   url : submitUrl,
            		   jsonData : jsonSubmitData,
            		   method : 'POST',
            		   success : function(frm, action) {
            			   Ext.getBody().unmask();
            			   grid.getStore().reload();
            			   showSuccessMessage(getEnquiryTranslation('REASSIGN_ENQUIRY'), getEnquiryTranslation('ENQUIRY_REASSIGNED_SUCCESSFULLY'));
            		   }
            	   });
            	  reassignwindow.close();
          	   }else{
          		 showWarningMessage(getEnquiryTranslation('REASSIGN_ENQUIRY'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
          	   }
         	 
            },
            // ************ DYNAMIC CB FOR DUPLICATE ENQUIRY *****************************     
            loadEnquiryForDuplicateValue : function(paramCodes,searchData,viewCode,configCode,duplicategrid) {

            	
            	var jsonFormatFormData = this.createJsonFormatForDuplicateValue(paramCodes,searchData,configCode);
            	var searchResultGrid = duplicategrid;
            	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            	resultViewUrl = resultViewUrl.concat(viewCode);
            	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
            },
            createJsonFormatForDuplicateValue:function(paramCodes,searchData,configCode){			
            	var enqForm = this.getTrackenquiryform();
            	var enqValues = enqForm.getValues();
            	var values = new Object();
            	values.configCode = configCode;
            	var searchcriteria = new Array();

            	if(searchData != "" && searchData != null){
                		searchcriteria.push({paramCode:paramCodes, paramValues:[searchData]});
                	}
            	if(enqValues.enquiryType != "" && enqValues.enquiryType != null){
            		searchcriteria.push({paramCode:'ENQUIRY_TYPE', paramValues:[enqValues.enquiryType]});
            	}
            	searchcriteria.push({paramCode:"WHETHER_DELETED", paramValues:[false]});
                	values.searchCriterias=searchcriteria;
                	return values;
                },
            //************ CB of TRACK ENQUIRY *****************************               
            loadEnquiryGrid : function(model, records) {
            	var quickSearchForm = this.getTrackenquiryform();
            	this.showInvalidIconOnField(quickSearchForm);
            	var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
            	var searchResultGrid = '';
            	 var permissionsMap = new Ext.util.HashMap();
                 //this.gridRenderFunction(grid);
                 permissionsMap = this.getTRACKENQUIRY_PERMISSIONS();
            	var enqId = quickSearchForm.down('#trackEnquiry_enquiryType').getValue();
            	var passId = quickSearchForm.down('#trackEnquiry_enquiryType').getStore().findRecord('id',enqId);
            	var deleteCheck =quickSearchForm.down('#trackEnquiry_whetherDeleted').getValue();
            	
            	var enquiryType = passId.data.code;
            	quickSearchForm.down('#trackenquiry_search').setDisabled(true);
            	var corporateGrid=this.getTrackcorporateenquirygrid();
            	var nonadmissionGrid=this.getTracknonadmissionenquirygrid();
            	var searchGrid=this.getSearchresultgrid();
            	var associatedAcadLocationIds = new Array();
        		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        		
            	corporateGrid.setVisible(false);
            	nonadmissionGrid.setVisible(false);
            	searchGrid.setVisible(false);
            	
            	if(enquiryType == 'Corporate'){
            		searchResultGrid = corporateGrid;
            	}else if(enquiryType == 'Admission'){
            		searchResultGrid = searchGrid;
            	}else{
            		searchResultGrid = nonadmissionGrid;
            	}
//            	Ext.getBody().mask(getCommonTranslation('Please wait...'), 'x-mask-loading');
            	searchResultGrid.setVisible(true);
            	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            	if(enquiryType == 'Corporate'){
            	    resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_VIEWCODE);
            	}else if(enquiryType == 'Admission'){
            		 resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRACK_ENQUIRY_LIST_VIEWCODE);
            	} else {
            		 resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_VIEWCODE);
            	}
            	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,quickSearchForm.down('#trackenquiry_search'));
            	var exportReportButtonItemId = searchResultGrid.down('#exportReportsId');
                exportReportButtonItemId.setDisabled(true);
                searchGridbuttonsToolBar = searchResultGrid.query('toolbar')[0];
        		var makeActiveBtn = searchResultGrid.down('#makeActive');
        		makeActiveBtn.setVisible(false);
                Ext.each(permissionList, function(privilege) {
            		if (privilege === 'MAKE_ACTIVE') {
            			var button = searchGridbuttonsToolBar.query('#makeActive')[0];
                		if(!isNullOrEmpty(button)){
                			if(deleteCheck == true){
                				makeActiveBtn.setVisible(true);
                			}else{
                				makeActiveBtn.setVisible(false);
                			}
                		}
            		}	
            	});
            },
            createJsonFormat:function(quickSearchForm, record){
            	var val = quickSearchForm.getValues();
            	
            	var showEnquiriewByTypeItemId = quickSearchForm.down('#showEnquiriewByTypeItemId');
            	var showEnquiriewByType = showEnquiriewByTypeItemId.getValue().showEnquiriewByType;
            	
            	var enquiryNo = quickSearchForm.down('#trackEnquiry_enquiryCode');
            	var enquiryType = quickSearchForm.down('#trackEnquiry_enquiryType');
            	
            	var enqId = quickSearchForm.down('#trackEnquiry_enquiryType').getValue();
            	var passId = quickSearchForm.down('#trackEnquiry_enquiryType').getStore().findRecord('id',enqId);
            	var enqType = passId.data.code;
            	
            	var employeeId = quickSearchForm.down('#trackEnquiry_employeeId');
            	var dateFrom = quickSearchForm.down('#trackEnquiry_dateFrom');
            	var enquiryDateTo = quickSearchForm.down('#trackEnquiry_enquiryDateTo');
            	var capaignId = quickSearchForm.down('#trackEnquiry_capaignId');
            	var capaignName = quickSearchForm.down('#trackEnquiry_capaignName');
            	var followUpNumber = quickSearchForm.down('#trackEnquiry_followUpNumber');
            	var enqStatus = quickSearchForm.down('#trackEnquiry_enquiryStatus').getRawValue();
            	var timeTakenForCompletion = quickSearchForm.down('#trackEnquiry_timeTaken');
            	var popiaStatus = quickSearchForm.down('#popiastatusId');
            	var nationalId = quickSearchForm.down('#nationalId');

            	var whetherDel = val.whetherDeleted;
            	
            	var enquiryFirstName='';
            	var enquiryMiddleName='';
            	
            if(enqType == 'Corporate') {	
            	 enquiryFirstName = quickSearchForm.down('#trackEnquiry_companyName');
            	 enquiryMiddleName = quickSearchForm.down('#trackEnquiry_contactPerson');
            } else{
            	 enquiryFirstName = quickSearchForm.down('#trackEnquiry_enquiryFirstName');
           	     enquiryMiddleName = quickSearchForm.down('#trackEnquiry_enquiryMiddleName');
            }	 
            	var enquiryLastName = quickSearchForm.down('#trackEnquiry_enquiryLastName');
            	var email = quickSearchForm.down('#trackEnquiry_email');
            	var mobileNo = quickSearchForm.down('#trackEnquiry_mobileNo');
            	var alternateMobileNo = quickSearchForm.down('#trackEnquiry_alternateMobileNo');
            	var referredType = quickSearchForm.down('#trackEnquiry_referredType');

            	var stage = quickSearchForm.down('#trackEnquiry_intermediateType');
            	var priority = quickSearchForm.down('#trackEnquiry_priority');
            	var programId = quickSearchForm.down('#programId');
            	var batchId = quickSearchForm.down('#batchId');
            	var seatTypeId = quickSearchForm.down('#seatTypeId');
            	var enquiryOwnerId = quickSearchForm.down('#enquiryOwner');
            	var programGroupId = quickSearchForm.down('#programGroup');
            	var modeOfDeliveryId = quickSearchForm.down('#modeDeliveryId');
            	var registrationTypeId = quickSearchForm.down('#registrationTypeId');
//Addition Of Three New Filter
            	var campaignNew = quickSearchForm.down('#campaignNameId');
            	var priorityOfCampaign = quickSearchForm.down('#schoolPriorityId');
            	var schoolOfCampaign = quickSearchForm.down('#schoolId');
            	var countryFilter = quickSearchForm.down('#countryFilterId');
            	var countryRegionFilter = quickSearchForm.down('#countryRegionFilterId');
            	var cityFilter = quickSearchForm.down('#cityFilterId');
            	var trackEnquiryName =quickSearchForm.down('#trackEnquiry_enquiryFirstName');
            	
            	var values = new Object();
            	/**
            	 *  we have three xml for enquiry grid 1.Admission 2. Coorporate 3.Non Admission
            	 */
            	if(enqType == 'Corporate'){	
            	 values.configCode = CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_CONFIGCODE;
            	}
            	else if(enqType == 'Admission'){
            		values.configCode = CONSTANTS.CB.TRACK_ENQUIRY_LIST_CONFIGCODE;
            	} else {
            		values.configCode = CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_CONFIGCODE;
            	} 
            	var searchcriteria = new Array();
            	
            	if(priority.getValue() != "" && priority.getValue() != null){
            		searchcriteria.push({paramCode:"PRIORITY_ID", paramValues:[priority.getValue()]});
            	}
            	if(trackEnquiryName.getDisplayValue() != "" && trackEnquiryName.getDisplayValue() != null){
            		searchcriteria.push({paramCode:"TRACK_ENQUIRER_NAME", paramValues:[trackEnquiryName.getDisplayValue()]});
            	}
            	if(enquiryNo.getValue() != "" && enquiryNo.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_NO", paramValues:[enquiryNo.getValue()]});
            	}
            	if(enquiryType.getValue() != "" && enquiryType.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_TYPE", paramValues:[enquiryType.getValue()]});
            	}
            	if(enquiryFirstName.getValue() != "" && enquiryFirstName.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRER_FIRST_NAME", paramValues:[enquiryFirstName.getValue()]});
            	}

            	if(dateFrom.getValue() != "" && dateFrom.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_DATE_FROM", paramValues:[dateFrom.getValue()]});
            	}
            	if(enquiryDateTo.getValue() != "" && enquiryDateTo.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_DATE_TO", paramValues:[enquiryDateTo.getValue()]});
            	}
            	if(capaignName.getValue() != "" && capaignName.getValue() != null){
            		searchcriteria.push({paramCode:"CAMPAIGN_ID", paramValues:[capaignName.getValue()]});
            	}            	
            	if(email.getValue() != "" && email.getValue() != null){
            		searchcriteria.push({paramCode:"PRIMARY_EMAIL_ID", paramValues:[email.getValue()]});
            	} 
            	if(mobileNo.getValue() != "" && mobileNo.getValue() != null){
            		searchcriteria.push({paramCode:"CELL_NO", paramValues:[mobileNo.getValue()]});
            	} 
            	if(alternateMobileNo.getValue() != "" && alternateMobileNo.getValue() != null){
            		searchcriteria.push({paramCode:"ALTERNATE_MOBILE_NO", paramValues:[alternateMobileNo.getValue()]});
            	} 
            	if(referredType.getValue() != "" && referredType.getValue() != null){
            		searchcriteria.push({paramCode:"ENQ_REFERRER_TYPE_ID", paramValues:[referredType.getValue()]});
            	} 
            	if(stage.getValue() != "" && stage.getValue() != null){
            		searchcriteria.push({paramCode:"STAGE", paramValues:[stage.getValue()]});
            	}
            	if(popiaStatus.getValue() != "" && popiaStatus.getValue() != null){
            		var popia=popiaStatus.getValue()=="Opt-In"?true:false;
            		searchcriteria.push({paramCode:"POPIA_STATUS", paramValues:[popia]});
            	}
            	if(whetherDel){
            		searchcriteria.push({paramCode:"WHETHER_DELETED", paramValues:[whetherDel]});
            	} else {
            		searchcriteria.push({paramCode:"WHETHER_DELETED", paramValues:[false]});
            	}
            	
            	if(!isNullOrEmpty(followUpNumber) && !isNullOrEmpty(followUpNumber.getValue())){
            		searchcriteria.push({paramCode:"NO_OF_FOLLOWUP", paramValues:[followUpNumber.getValue()]});
            	}
            	
            	if(enqStatus!= "" && enqStatus!= null){
            		if(enqStatus=="Closed"){
            			searchcriteria.push({paramCode:"STATUS", paramValues:["C"]});
            		} else if(enqStatus=="Open"){
            			searchcriteria.push({paramCode:"STATUS", paramValues:["O"]});
            		} else if(enqStatus=="Marketing"){
            			searchcriteria.push({paramCode:"STATUS", paramValues:["M"]});
            		}              		
            	}
            	
            	var currentUser = this.getCurrentlyLoggedInUser();
            	if (!isNullOrEmpty(showEnquiriewByType) && showEnquiriewByType == 'MY_ENQUIRIES') {
            	    searchcriteria.push({
            	        paramCode: "CURRENT_USER_ID",
            	        paramValues: [currentUser.id]
            	    });
            	    searchcriteria.push({
            	        paramCode: "CURRENT_FOLLOW_UP_USER_ID",
            	        paramValues: [currentUser.id]
            	    });
            	}
            	
        		// added code for user rights by academyLocationId
             	var academyLocationId = this.getCurrentAcademyLocation();
             	
             	// add user accessible AL
             	var locations =this.getUserAccessibleAL();
				var selectedAL=quickSearchForm.down('#academyLocationCombo');
             	if(!isNullOrEmpty(selectedAL.getValue())){
             		locations=[selectedAL.getValue()];
				}
                searchcriteria.push({
              		  paramCode: "ACADEMY_LOCATION_ID",
           			  paramValues: locations
           		  });
            	
                var enquirySource = quickSearchForm.down('#enquirySourceId');
                if(enquirySource.getValue() != "" && enquirySource.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_SOURCE_ID", paramValues:[enquirySource.getValue()]});
            	}
                
                var followUpUser = quickSearchForm.down('#followUpUser');
                if(followUpUser.getValue() != "" && followUpUser.getValue() != null){
            		searchcriteria.push({paramCode:"FOLLOW_UP_USER_ID", paramValues:[followUpUser.getValue()]});
            	}
                
                if(programGroupId.getValue() != "" && programGroupId.getValue() != null){
            		searchcriteria.push({paramCode:"PROGRAM_GROUP_ID", paramValues:[programGroupId.getValue()]});
            	}
                
                if(programId.getValue() != "" && programId.getValue() != null){
            		searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
            	}
                
                if(batchId.getValue() != "" && batchId.getValue() != null){
            		searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId.getValue()]});
            	}
                
                if(seatTypeId.getValue() != "" && seatTypeId.getValue() != null){
            		searchcriteria.push({paramCode:"SEAT_TYPE_ID", paramValues:[seatTypeId.getValue()]});
            	}
                
                if(enquiryOwnerId.getValue() != "" && enquiryOwnerId.getValue() != null){
            		searchcriteria.push({paramCode:"ENQUIRY_OWNER_ID", paramValues:[enquiryOwnerId.getValue()]});
            	}
                if(val.intakeYear != "" && val.intakeYear != null){
            		searchcriteria.push({paramCode:"INTAKE_YEAR_ID", paramValues:[val.intakeYear]});
            	}
                if(modeOfDeliveryId.getValue() != "" && modeOfDeliveryId.getValue() != null){
                	searchcriteria.push({paramCode:"MODE_OF_DELIVERY_ID", paramValues:[modeOfDeliveryId.getValue()]});
                }
                if(registrationTypeId.getValue() != "" && registrationTypeId.getValue() != null){
                	var registrationType = null;
                	if(registrationTypeId.getValue()=="FULL_TIME")
                		registrationType = false;
                	if(registrationTypeId.getValue()=="PART_TIME")
                		registrationType = true;
                	searchcriteria.push({paramCode:"REGISTRATION_TYPE_ID", paramValues:[registrationType]});                	
                }
                // New Three filter
                
                if(campaignNew.getValue() != "" && campaignNew.getValue() != null){
                	searchcriteria.push({paramCode:"CAMPAIGN_NEW", paramValues:[campaignNew.getValue()]});                	
                }
                if(priorityOfCampaign.getValue() != "" && priorityOfCampaign.getValue() != null){
                	searchcriteria.push({paramCode:"PRIORITY_NEW_CAMPAIGN", paramValues:[priorityOfCampaign.getValue()]});                	
                }
                if(priorityOfCampaign.getValue() != "" && priorityOfCampaign.getValue() != null){
                	searchcriteria.push({paramCode:"SCHOOL_PRIORITY", paramValues:[priorityOfCampaign.getValue()]});                	
                }
                if(schoolOfCampaign.getValue() != "" && schoolOfCampaign.getValue() != null){
                	searchcriteria.push({paramCode:"SCHOOL_NEW_CAMPAIGN", paramValues:[schoolOfCampaign.getValue()]});                	
                }
                if(countryFilter.getValue() != "" && countryFilter.getValue() != null){
                	searchcriteria.push({paramCode:"COUNTRY_ID", paramValues:[countryFilter.getValue()]});                	
                }
                if(countryRegionFilter.getValue() != "" && countryRegionFilter.getValue() != null){
                	searchcriteria.push({paramCode:"COUNTRY_REGION_ID", paramValues:[countryRegionFilter.getValue()]});                	
                }
                if(cityFilter.getValue() != "" && cityFilter.getValue() != null){
                	searchcriteria.push({paramCode:"CITY_ID", paramValues:[cityFilter.getValue()]});                	
                }
                if(nationalId.getValue() != "" && nationalId.getValue() != null){
                	searchcriteria.push({paramCode:"NATIONAL_ID_NUMBER", paramValues:[nationalId.getValue()]});                	
                }
                
                if(priorityOfCampaign.getValue() != "" && priorityOfCampaign.getValue() != null && 
                		(enquiryNo.getValue() == "" || enquiryNo.getValue() == null)){
                	
            	var submitUrl = SERVERURL.FIND_ENQUIRY_BY_AL_PRIORITY;
            	
         		Ext.Ajax.request({
         			type : 'rest',
         			url : submitUrl+'?academyLocationIds='+locations+'&schoolPriority='+priorityOfCampaign.getValue(),
         			method : 'GET',
         			async:false,
         			success : function(res, action) {
         				Ext.getBody().unmask();
         				if(res.responseText!="" && res.responseText!=null){
         					var data = Ext.decode(res.responseText);
         					if(data!=null && data.length != 0){
         						searchcriteria.push({paramCode:"ENQUIRY_PRIMERY_ID", paramValues:data});
         					} else {
         						searchcriteria.push({paramCode:"ENQUIRY_PRIMERY_ID", paramValues:[-1]});
         					}
         				}
         				else{
         					searchcriteria.push({paramCode:"ENQUIRY_PRIMERY_ID", paramValues:[-1]});
         				}
         			}
         		});
            }
         		
            	values.searchCriterias=searchcriteria;
            	return values;
            },
            gridRenderFunction:function(grid){
            	 grid.addButtonToolbar();
            	 var buttonstoolbar=grid.down('#functionButtonsToolbar');
            	 buttonstoolbar.insert(4,{
        			 xtype: 'button',
         			 itemId: 'sendMessageBtn',
         			 text:getCommonTranslation('SEND_MESSAGE'),
         			 tooltip :getCommonTranslation('SEND_MESSAGE')
        	    });
            		var moreActionButton ={
            					xtype : 'splitbutton',
            					itemId:'spBtnMoreActions',
            					text : getCommonTranslation('MOREACTIONS'),
            					menu:[{
            						text:getEnquiryTranslation('VIEW_DOCUMENTS'),
            						itemId:'viewDocumentsLinked',
            						disabled:true
            					},{
            						text:getEnquiryTranslation('CHECK_DUPLICATE_NAME'),
            						itemId:'checkDuplicateNameLinked'
            					},{
            						text:getEnquiryTranslation('CHECK_DUPLICATE_EMAIL'),
            						itemId:'checkDuplicateEmailLinked'
            					},{
            						text:getEnquiryTranslation('CHECK_DUPLICATE_MOBILE'),
            						itemId:'checkDuplicateMobileLinked'
            					},{
            						text:getEnquiryTranslation('CHECK_DUPLICATE_PHONE'),
            						itemId:'checkDuplicatePhoneLinked'
            					},{
            						text:getEnquiryTranslation('CHANGE_LINKED_APPLICATION'),
            						itemId:'changeLinkedApplication',
            						disabled:true
            					},{
            						text : getCommonTranslation('SEND_SURVEY'),
            	            	    itemId:'sendSurveyBtn'
            					},{
            						text : getEnquiryTranslation('REASSIGN_ENQUIRY'),
            	            	    itemId:'reassignBtn'
            					},{
            						text : getTranslation('POPIA_OPTION'),
            	            	    itemId:'popiaOptionBtn'
            					}],
            					listeners: { click: function() { this.showMenu(); } }
            				};
            		grid.down('#functionButtonsToolbar').insert(5,moreActionButton);
            		buttonstoolbar.insert(6,{
            			 xtype: 'button',
             			 itemId: 'followUpDetails',
             			 disabled:true,
             			 text:getEnquiryTranslation('FOLLOW_UP_DETAIL'),
             			 tooltip :getEnquiryTranslation('FOLLOW_UP_DETAIL')
            	    });
            		buttonstoolbar.insert(7,{
            			 xtype: 'button',
            			 itemId: 'sendReminder',
            			 disabled:true,
            			 text:getEnquiryTranslation('SEND_REMINDER'),
            			 tooltip :getEnquiryTranslation('SEND_REMINDER')
	           	    });
	            		buttonstoolbar.insert(8,{
	           			 xtype: 'button',
	           			 itemId: 'makeActive',
	           			// disabled:true,
	           			 text:getEnquiryTranslation('MAKE_ACTIVE'),
	           			 tooltip :getEnquiryTranslation('MAKE_ACTIVE')
	          	    });
            },
            
            disableMoreActionPivileges: function(gridReference,permissionsMap) {
            	
            	var associatedAcadLocationIds = new Array();
        		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	
            	buttonsToolBar = gridReference.query('toolbar')[0];
            	
            	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
            	splitbuttons.setVisible(false);
        		
            	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
        			menuItems.setVisible(false);
            	});
            	
            	var button = buttonsToolBar.query('#popiaOptionBtn')[0];
            	button.setVisible(false);
        			
            	Ext.each(permissionList, function(privilege) {
            		if (privilege === 'MOREACTIONS') {
                		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'VIEWDOCUMENTS') {
                		var button = buttonsToolBar.query('#viewDocumentsLinked')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'SENDMESSAGE') {
                		var button = buttonsToolBar.query('#sendMessageBtn')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'CHECKDUPLICATENAME') {
                		var button = buttonsToolBar.query('#checkDuplicateNameLinked')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'CHECKDUPLICATEEMAIL') {
                		var button = buttonsToolBar.query('#checkDuplicateEmailLinked')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'CHECKDUPLICATEMOBILE') {
                		var button = buttonsToolBar.query('#checkDuplicateMobileLinked')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'CHECKDUPLICATEPHONE') {
                		var button = buttonsToolBar.query('#checkDuplicatePhoneLinked')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'SENDSURVEY') {
                		var button = buttonsToolBar.query('#sendSurveyBtn')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'EXPORTREPORTS') {
                		var button = buttonsToolBar.query('#exportReportsId')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'FOLLOWUPDETAILS') {
                		var button = buttonsToolBar.query('#followUpDetails')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'SENDREMINDER') {
                		var button = buttonsToolBar.query('#sendReminder')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            		if (privilege === 'REASSIGNENQUIRY') {
                		var button = buttonsToolBar.query('#reassignBtn')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}  
            		}if (privilege === 'POPIA_OPTION') {
                		var button = buttonsToolBar.query('#popiaOptionBtn')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}if (privilege === 'CHANGE_LINKED_APPLICATION') {
                		var button = buttonsToolBar.query('#changeLinkedApplication')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
            			
            	});
            	
            },
        	 viewEnquiryFormWindow: function(grid) {
                         	
                 if (grid.getSelectionModel().getCount() > 0) { // checking if record is selected or not
                	 
                	 var buttonId="View"; 
                	 this.linkClicked(0,0,grid,buttonId);
                     
                 } else {
                     showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
                 }
             },
             exportUserList : function(exportUrl,filetype,whetherAll,searchResultGrid) {
                 var quickSearchForm=this.getTrackenquiryform(); 
                 var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
                 var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
                 var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
                 var visibleColumns=this.getVisibleColumns(searchResultGrid);
                 var reportTitle = searchResultGrid.title; //getCommonTranslation('ENQUIRY_TITLE');
   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                               jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                        }
   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

   },
   	
   
   createSearchCriteriaString: function(searchForm) {
 	  var me=this;
 	  var formValues = new Array();
 	  formValues = searchForm.getValues();  
 	  var searchCriteriaString="";
 	  for (var key in formValues) {
 		  var value = formValues[key];            
 		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'&& key !== 'whetherDeleted'){
 			  var keyValueJsonObject = me.getJsonObject( key , value);
 			  if(!isNullOrEmpty(keyValueJsonObject)){
 				  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
 			  }
 		  }
 	  }
 	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
 	  return searchCriteriaString;
   },
 getJsonObject : function(key, value, additionalValue) {
		if (value != '' && value != null
				&& additionalValue == undefined&&value) {
			return {
				"paramCode" : key,
				"paramValues" : [ value ]
			};
		} else if (value != '' && additionalValue != undefined) {
			return {
				"paramCode" : key,
				"paramValues" : [ value, additionalValue ]
			};
		}
	},
	getEnquiryController:function(){
		return this.getController('enquiry.EnquiryController');
	  },
	sendSurveyDetails:function(obj){
    	var $this = this;
//    	var grid = $this.getTrackenquirygrid();

    	var grid = $this.getTrackEnquiry().down("#trackenquirygrid");
   		var form = obj.up('enquirysendsurvey').down('form').getForm();
    	var surveyId = form.findField('survey').getValue();
    	var surveyUrl = form.findField('survey').getRawValue();

    	var jsonData = []; 
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"surveyMaster" : $this.getIdValueJson(surveyId),
//  				"userId":selected[i].data.ID,
    				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
    				"applicant": null,
    				"student": null,
    				"enquiry": $this.getIdValueJson(selected[i].data.ID),
    				"user" : null,
    				"userType":"ENQUIRER"

    			});
    		}
    	}
    	submitUrl = SERVERURL.SEND_SURVEY;
 		Ext.Ajax.request({
 			type : 'rest',
 			url : submitUrl,
 			jsonData : jsonData,
 			method : 'POST',
 			success : function(form, action) {
 				showSuccessMessage(getCommonTranslation('SEND_SURVEY'),getCommonTranslation('SUCCESS'));
 				grid.getStore().reload();
	 			if(!isNullOrEmpty(Ext.ComponentQuery.query('enquirysendsurvey')[0])){
	 				Ext.ComponentQuery.query('enquirysendsurvey')[0].close();
	 		   }
 			}
 		});
    },
    getIdValueJson: function(id, value,code) {
    	if (id) return {
    		id: id,
    		value: value,
    		code: code
    	};
    },
    
    sendPopiaStatus:function(obj){
    	var $this = this;
        
    	var form = $this.getPopiaoption();
    	form.down('#saveBtn').setDisabled(true);
   		var popiastatus =form.down('#popiastatusId').value; 
   		var popiastatusValue=null;
   		if(!isNullOrEmpty(popiastatus))
   			{
   			if(popiastatus=="Opt-In"){
   				popiastatusValue=true;
   				}else{
   				popiastatusValue=false;
   				      }
   			
    	var jsonData = []; 
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"popiaStatus":popiastatusValue,
    			});
    		}
    	}
    	submitUrl = SERVERURL.PATH_SEND_POPIA_STATUS;
 		Ext.Ajax.request({
 			type : 'rest',
 			url : submitUrl,
 			jsonData : jsonData,
 			method : 'POST',
 			success : function(form, action) {
 				showSuccessMessage(getCommonTranslation('POPIA_STATUS'),getCommonTranslation('SUCCESS'));
 				grid.getStore().reload();
 				if(!isNullOrEmpty(Ext.ComponentQuery.query('popiaoption')[0])){
	 				Ext.ComponentQuery.query('popiaoption')[0].close();
	 		   }
 			}
 		});
   			}
   		else
   			{
   			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'));
   			form.down('#saveBtn').setDisabled(false);
   			}
  },
  
  saveChangeLinkedApplication: function(obj) {
	    
	    var grid;
	    var admissionGrid = this.getSearchresultgrid();
	    var corporateGrid = this.getTrackcorporateenquirygrid();
	    var nonAdmissionGrid = this.getTracknonadmissionenquirygrid();

	    if (!admissionGrid.isHidden()) {
	        grid = admissionGrid;
	    } else if (!corporateGrid.isHidden()) {
	        grid = corporateGrid;
	    } else if (!nonAdmissionGrid.isHidden()) {
	        grid = nonAdmissionGrid;
	    }

	    if (grid.getSelectionModel().getCount() > 0) {
	        var form = this.getChangelinkedapplication();
	        form.down('#saveBtn').setDisabled(true);
	        
	        var formVal = form.down('form').getValues(); 
	        
	        // Check if the application ID is present
	        if (!isNullOrEmpty(formVal.applicationId)) {
	            var applicationId = formVal.applicationId;
	        }
	        var selectedRecord = grid.getSelectionModel().getSelection()[0];
	        var enquiryId = selectedRecord.data.ID;
	        var validateUrl = SERVERURL.PATH_VALIDATE_LINKED_ENQUIRY;

	        Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');

	        // Send the AJAX request to validate the linked enquiry
	        Ext.Ajax.request({
	            type: 'rest',
	            url: validateUrl +'?applicationId='+ applicationId +'&enquiryId='+ enquiryId,
	            method: 'GET',
	            success: function(response) {
	                var result = Ext.decode(response.responseText);

	                if (result === -2) {
	                	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LINKED_WITH_SAME_APPLICATION'));
	                	Ext.getBody().unmask();
	                    Ext.ComponentQuery.query('changelinkedapplication')[0].close();
	                } else if (result === -1) {
	                	showConfirmMessage(getEnquiryTranslation('CHANGE_LINKED_APPLICATION'),getCommonTranslation('CONFIRM_UPDATE'),
	                	    function(btn, text) {
	                	        if (btn == 'yes') {
	                	            saveLinkedApplication(result);
	                	        } else {
	                	        	Ext.getBody().unmask();
	                	            Ext.ComponentQuery.query('changelinkedapplication')[0].close();
	                	        }
	                	    }
	                	);
	                } else if (result === 0) {
	                    saveLinkedApplication(result);
	                }
	            },
	            failure: function(response) {
	                showErrorMessage(getEnquiryTranslation('ALERT'), getCommonTranslation('FAILURE'));
	                form.down('#saveBtn').setDisabled(false);
	                Ext.getBody().unmask();
	            }
	        });

	        function saveLinkedApplication(result) {
	            var submitUrl = SERVERURL.PATH_LINKED_APPLICATION_ID;
	            var data = {
	                id: selectedRecord.data.ID,
	                application: applicationId,
	                result:result
	            };

	            Ext.Ajax.request({
	                type: 'rest',
	                url: submitUrl,
	                jsonData: data,
	                method: 'POST',
	                success: function(response) {
	                    showSuccessMessage(getEnquiryTranslation('CHANGE_LINKED_APPLICATION'), getCommonTranslation('ENQUIRY_LINKED_SUCCESSFULLY'));
	                    grid.getStore().reload();
	                    if (!isNullOrEmpty(Ext.ComponentQuery.query('changelinkedapplication')[0])) {
	                        Ext.ComponentQuery.query('changelinkedapplication')[0].close();
	                    }
	                },
	                callback: function() {
	                    Ext.getBody().unmask();
	                    form.down('#saveBtn').setDisabled(false);
	                }
	            });
	        }
	    } else {
	    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    }
	},


    /** Download upload form change **/

	downloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		var downloadTemplateForm = this.getEnquirydownloadform();
		var uploadTemplateForm = this.getEnquiryuploadform();
		var grid = $this.getImportlistenquiry();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		}else{
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getEnquiryuploadoptionradiogroup();
        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        		isUploadAll: false
        	});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
		}
	},
	createJsonforenquiryDownload : function(){
		
		var enquiryDownloadForm = this.getEnquirydownloadform();
		var academyLocIds = enquiryDownloadForm.down('#academyLocationId').value;
		var mainJson = new Object();
		var alArray=new Array();
		for(var i=0;i<academyLocIds.length;i++) {
			alArray.push(academyLocIds[i].data.id);
		}
		mainJson.academyLocations = alArray;
		mainJson.enquiryType = enquiryDownloadForm.down('#trackEnquiry_enquiryType').rawValue;
		return mainJson;
	},
	 getDownloadFile : function(documentId,fileType){

     	if(!isNullOrEmpty(documentId)){
     		var csvForm = Ext.create('Ext.form.Panel'); 
     		csvForm.getForm().submit({
     			target: '_blank',
     			method:'POST',
     			params :{
     				access_token : Ext.Ajax.defaultHeaders.access_token
     			},
     			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
     			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
     			standardSubmit :true
     		});
     	}
     },
    
	openEnquiryFromDashlet:function(view,rowIndex,grid,buttonId){
		Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
		Academia.app.getController('Academia.controller.enquiry.student.StudentDetailController');
		Academia.app.getController('Academia.controller.enquiry.exam.ExamDetailController');
		Academia.app.getController('Academia.controller.enquiry.admission.AdmissionReqmntDetailController');
		Academia.app.getController('Academia.controller.enquiry.followup.FollowUpDetailController');
		Academia.app.getController('Academia.controller.enquiry.closure.ClosureDetailController');
		Academia.app.getController('Academia.controller.enquiry.EnquiryRevampController');
		Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController');
		Academia.app.getController('Academia.controller.enquiry.student.StudentDetailRevampController');
		var $this = this;
    	var tabName = getEnquiryTranslation('ENQUIRY_DETAILS');
    	var getcontroller = this.getController('menu.CoreERPNavigationController');
    	var contentpanel = $this.getContentpanel();
    	var getTab = getcontroller.getTab(tabName);
    	if (getTab != null) {
    		contentpanel.remove(getTab, true);
    	}
    	if(getcontroller.getVerticalNavigationMenu().items.length > 0){
    		getcontroller.collapseMenu();
    	} 
		if(grid.getSelectionModel().getCount()>0){
			var enquiryData;
			var val=grid.getSelectionModel().getSelection()[0].data; 
			var isDeleted=val.whetherDeleted;
			if(val.whetherDeleted == 'false'){
				isDeleted =false;
			}else{
				if(val.whetherDeleted == 'true'){
					isDeleted=true;
				}
			}
			if(!isDeleted){
				var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
				if (!tabStructure1) {
					tabStructure1 = Ext.widget('enquirytabstructure');
				}
				var tabStructure = tabStructure1.getForm();
				var status;
				if(val.status=='O' || val.status.toLowerCase()=='open' ){
					status='Open';
				}else{
					status='Closed';
				}
				if(val.status!='O'){//O=Open
					if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
						tabStructure.findField("enquiryId").setVisible(true);
						tabStructure.findField("enquiryId").reset();
						tabStructure.findField("enquiryId").setValue(val.enqCode);
					}
					if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
						tabStructure.findField("enquiryTxtId").reset();
						tabStructure.findField("enquiryTxtId").setVisible(false);
					}
				}else{
					if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
						tabStructure.findField("enquiryTxtId").setVisible(true);
						tabStructure.findField("enquiryTxtId").reset();
						tabStructure.findField("enquiryTxtId").setValue(val.enqCode);
					}
					if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
						tabStructure.findField("enquiryId").reset();
						tabStructure.findField("enquiryId").setVisible(false);
					}
				}
				tabStructure.findField("enqId").setValue(val.enqId);
				tabStructure.findField("enqTypes").setValue(val.enqType);
				tabStructure.findField("buttonType").setValue(buttonId);

				if(val.studentDetailsId>0){
					tabStructure.findField("studentDetailId").setValue(val.studentDetailsId);
				}
				var coursetabstructure = Ext.ComponentQuery.query("enquirytabstructure")[0];
				if (!coursetabstructure) {
					coursetabstructure = Ext.widget('enquirytabstructure');
				}
				if(val.enqType != getEnquiryTranslation('CNTRL_ADMISSION')){

					/**
					 * Hide closure follow up grid in follow up detail tab.
					 */
					var closureFollowupgrid=$this.getClosurefollowupgrid();
					if(closureFollowupgrid != undefined && closureFollowupgrid != null){
        				closureFollowupgrid.setVisible(false);
        			}
				}
				openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_ONE);

				if(val.status!='O'){
					var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
					if(!isNullOrEmpty(myText)){
						myText.setVisible(true);
						myText.reset();
						myText.setValue(val.enqCode);
					}
					var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
					if(!isNullOrEmpty(myedtText)){
						myedtText.reset();
						myedtText.setVisible(false);
					}
				}else{
					var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
					if(!isNullOrEmpty(myText)){
						myText.setVisible(true);
						myText.reset();
						myText.setValue(val.enqCode);
					}
					var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
					if(!isNullOrEmpty(myedtText)){
						myedtText.reset();
						myedtText.setVisible(false);
					}
				}

				var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
				if(!isNullOrEmpty(val.assignToUserId)){
					assignToId.setVisible(true);
					assignToId.reset();
					assignToId.setValue(val.assignToUserName);
				} else {
					assignToId.setVisible(true);
					assignToId.reset();
					assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
				}
				
				var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
        		if(!isNullOrEmpty(val.STUDENT_NAME)){ 
        			studentName.setValue(val.STUDENT_NAME); 
        		}else{
        			if(!isNullOrEmpty(val.studentName)){ 
            			studentName.setValue(val.studentName); 
            		}	
        		}

        		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
        		if(!isNullOrEmpty(val.TRACK_ENQUIRER_NAME)){ 
        			parentName.setValue(val.TRACK_ENQUIRER_NAME); 
        		}else{
        			if(!isNullOrEmpty(val.enquirerName)){
            			parentName.setValue(val.enquirerName); 
            		}
        		}
        		
        		Ext.Ajax.request({
                    type : 'rest',
                    url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.studentDetailsId,
                    method : 'GET',
                    success : function(form, action) {
                    var data = Ext.JSON.decode(form.responseText);
                    	//console.log(data);
                    	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
                		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
                			programIntake.setValue(data[0].programIntakeCombo); 
                		}
                    }
                });

				var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
				intermediateStage.setValue(val.enquiryStage);

				var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
				intermediateStageId.setValue(val.enquiryStageId);

				var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
				myTextField.setValue(status);

				var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
				priorityField.setValue(val.enqPriorityName);

				var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
				priorityIdField.setValue(val.enqPriorityId);
			}else{
				// message for record already deleted
				showWarningMessage(getEnquiryTranslation('ENQUIRY_DELETE_TITLE'),getCommonTranslation('DELETED_MSSG'));//Please select a record
			}
		}
		if(buttonId === "Edit" && grid.getSelectionModel().getCount()>0){
			coursetabstructure.down('button[itemId=enquirydetail_EditButtonId]').setVisible(false);
			coursetabstructure.down('button[itemId=studentdetail_cancelbuttonId]').setVisible(false);
		}

	},
	
	disableImportEnquiry:function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var advanceSearchPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getENQUIRY_ADVANCE_SEARCH_PERMISSIONS());
		var leadImportUtilityPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLEAD_IMPORT_UTILITY_PERMISSIONS());
		var leadImportEnquiryUpdatePermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLEAD_IMPORT_ENQUIRY_UPDATE_PERMISSIONS());
	
		
		var enquiryUploadDownloadStructure = structure.down('#enquiryuploaddownloadstructureId');
		var enquiryUploaddownloadStructureTab=false;
		var enquiryAdvanceSearchStructureTab=false;
		var leadImportUtilityStructureTab=false;
		var leadImportEnquiryUpdateStructureTab =false;
		
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				enquiryUploaddownloadStructureTab = true;
			} else {
				enquiryUploaddownloadStructureTab = false;
			}
		});
		
		Ext.each(advanceSearchPermissionList, function(privilege) {
			if (privilege === 'VIEW') {
				enquiryAdvanceSearchStructureTab = true;
			} else {
				enquiryAdvanceSearchStructureTab = false;
			}
		});
		
		Ext.each(leadImportUtilityPermissionList, function(privilege) {
			if (privilege === 'VIEW') {
				leadImportUtilityStructureTab = true;
			} else {
				leadImportUtilityStructureTab = false;
			}
		});
		
		Ext.each(leadImportEnquiryUpdatePermissionList,function(privilege) {
			if (privilege === 'VIEW') {
				leadImportEnquiryUpdateStructureTab = true;
			} else {
				leadImportEnquiryUpdateStructureTab = false;
			}
		});

		this.showEnquiryTab(enquiryUploaddownloadStructureTab, enquiryAdvanceSearchStructureTab,leadImportUtilityStructureTab,leadImportEnquiryUpdateStructureTab, structure);
	},
	showEnquiryTab : function(enquiryUploaddownloadStructureTab,enquiryAdvanceSearchStructureTab, leadImportUtilityStructureTab,leadImportEnquiryUpdateStructureTab, structure) {
		var panelItem = new Array();
		var $this = this;
		var newcont=structure.items.items.length;
		var insertPosition=newcont+1;
		if(!Ext.ComponentQuery.query("trackEnquiry")[0]){
			
			var panelItem = new Array();
 			var $this = this;
 			var newcont = structure.items.items.length;
 			var insertPosition = newcont;
 			panelItem.push({
 				xtype : 'tabpanel',
 				itemId : 'allVisibleTP',
 				plain : true,
 				style : {
 					overflow : 'hidden !important',
 					margin : '0!important'
 				},
 				bodyStyle : {
 					margin : CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
 				},
 				frame : false,
 				border : false,
 				defaults : {
 					labelAlign : 'top'
 				},
 				items : [{
 					xtype: 'trackEnquiry',
 					title: getCommonTranslation('SEARCH'),
 					tabCls: 'right-tab',
 					style:{
 						marginLeft:'17px !important'
 					},
 					listeners: {
 						activate: function(me, eOpts){
 							var  contentPanelMain = $this.getContentpanel().getActiveTab();
 							if(contentPanelMain!=undefined){
 								setTimeout(function(){
 	 								contentPanelMain.scrollBy(0,1);
 	 								contentPanelMain.scrollBy(0,-1);
 	 							},2);
 							}
 						}
 					}
 				}]
 			});
			
			
			var insertAt = panelItem["0"].items.length;
 			
			if (enquiryAdvanceSearchStructureTab) {
 				panelItem["0"].items[insertAt] = {
							xtype: 'advancedsearchquerybuilder',
							searchConfigCode : CONSTANTS.CB.TRACK_ENQUIRY_LIST_CONFIGCODE,
							searchResultViewCode: CONSTANTS.CB.TRACK_ENQUIRY_LIST_VIEWCODE,
							permissionMapKey:'TRACKENQUIRY_PRIVILEGES',
							gridTitle: getCommonTranslation('ENQUIRY_LIST'),
							tabCls: 'right-tab'
 				};
 				insertAt = insertAt + 1;
 			}
 			if (enquiryUploaddownloadStructureTab) {
 				panelItem["0"].items[insertAt] = {
 						xtype:'enquiryuploaddownloadstructure',
						itemId:'enquiryuploaddownloadstructureId',
						title: getTranslation('IMPORT_ENQUIRY')
 				};
 				insertAt = insertAt + 1;
 			}
 			if (leadImportUtilityStructureTab) {
 				panelItem["0"].items[insertAt] = {
 						xtype:'enquirynewuploaddownloadstructure',
						itemId:'enquirynewuploaddownloadstructureItemId',
						title: getTranslation('IMPORT_ENQUIRY')
 				};
 				insertAt = insertAt + 1;
 			}
			
 			if (leadImportEnquiryUpdateStructureTab) {
 				panelItem["0"].items[insertAt] = {
 						xtype:'enquiryimportenquiryupdatesstructure',
						itemId:'enquiryimportenquiryupdatesstructureItemId',
						title: getCommonTranslation('IMPORT_ENQUIRY_UPDATES')
 				};
 			}
			
			structure.insert(insertPosition,panelItem);
		}
	},
	selectSectionMessageType : function(val,nV,oV){

     	 var $this =  this;
     	 var formWin = $this.getEnquirysendmessage();

     	formWin.down('#recieverTypeIncludeMySelf').setValue(false);
     	 if(nV.messageType==2){
     		 formWin.down("#messageId").hide();
     		 formWin.down("#selectTemplate").allowBlank=true;
     		 formWin.down("#selectTemplate").setVisible(false);     		 
     		 formWin.down("#messageName").allowBlank=true;   
     		 formWin.down("#messageName").setVisible(false);
     		 formWin.down("#msgTempletId").setVisible(true);
     		 formWin.down("#msgTempletId").allowBlank=false;
     		 formWin.down("#msgTempletId").reset();
     		 formWin.down("#subject").setVisible(true);
     		 formWin.down("#subject").allowBlank=false;
     		 formWin.down("#subject").reset();
     		 formWin.down("#discriptionId").setVisible(true);
     		 formWin.down("#discriptionId").reset();
     		 formWin.down('#smsDiscription').reset();
      		 formWin.down('#smsDiscription').hide();
      		 formWin.down('#smsDiscriptionNotice').hide();
      		 formWin.down('#recieverType').setVisible(true);
     	 }else{
     		formWin.down("#msgTempletId").allowBlank=true;
     		formWin.down("#msgTempletId").setVisible(false);     		
     		formWin.down("#messageId").setVisible(true);
     		formWin.down("#selectTemplate").setVisible(true);     		
     		formWin.down("#messageName").setVisible(true);
     		formWin.down("#messageName").reset();
     		formWin.down("#subject").allowBlank=true;
     		formWin.down("#subject").setVisible(false);
     		formWin.down("#discriptionId").setVisible(false);
     		formWin.down("#messageName").allowBlank=false;  
     		formWin.down("#selectTemplate").allowBlank=false;
     		formWin.down("#selectTemplate").reset();
     		formWin.down("#enquiryDocumentMessageAttachmentGrid").setVisible(false);
     		formWin.down("#staticUploadFileField").setVisible(false);
     		formWin.down('#smsDiscription').reset();
      		formWin.down('#smsDiscription').hide();
      		formWin.down('#smsDiscriptionNotice').hide();
      		formWin.down('#recieverType').setVisible(false);
  		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
  		formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
  		formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
     	 }
      },
      selectEnquiryMessageTemp: function(obj,rec){
	       	var $this =  this;
	       	 var formWin = $this.getEnquirysendmessage();
	       	 if(rec[0].data.value == "SMS")
	       	 {
	       		formWin.down("#templateId").setVisible(false);
	       		formWin.down("#templateId").allowBlank=true;
	       		Ext.Ajax.request({
	    	   		type: 'rest',
	    	   		async: false,
	    	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	    	   		params: {
	    	   			screenName: 'enquirysendmessage',
	    	   			academyLocationId: this.getCurrentAcademyLocation(),
	    	   			languageCode:'en'
	    	   		},
	    	   		method: 'GET',
	    	   		success: function(res, action) {
	    	   			var response = Ext.decode(res.responseText);
	    	   			if( Object.keys(response).length > 0 ){
	    	   				var records=response.enquirysendmessage;
	    	   				for(i in records){
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isVisible==true){
	    	   						formWin.down("#templateId").setVisible(true);
	    	   					}
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isVisible==true && records[i].isMandatory==false){
	    	   						formWin.down("#templateId").setVisible(true);		
		    	   					formWin.down("#templateId").setFieldLabel(getMessagingModuleTranslation('SMS_TEMPLATE_ID'));			 
	  	    	   					}

	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true){
	    	   						formWin.down("#templateId").allowBlank=false;
	    	   					}
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true && records[i].isVisible==false){
	    	   						formWin.down("#templateId").allowBlank=true;
	    	   					}
	    	   				}
	    	   			}else{
	    	   				formWin.down("#templateId").setVisible(false);
	    	   				formWin.down("#templateId").allowBlank=true;
	    	   			}
	    	   		}
	    	   		
	    	   	});
	       		formWin.down("#subject").allowBlank=true;
	       		 formWin.down("#subject").hide();
	       		 formWin.down("#staticUploadFileField").hide();
	       		 formWin.down("#enquiryDocumentMessageAttachmentGrid").hide();
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#discriptionId').hide();	       		 
	       		 formWin.down('#subject').reset();
	       		 formWin.down('#smsDiscription').show();
	       		 formWin.down('#smsDiscriptionNotice').show();
	       	 }else
	       	 {
	       		formWin.down("#templateId").hide();
	       		formWin.down("#templateId").allowBlank=true;
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#smsDiscription').reset();
	       		 formWin.down('#smsDiscription').hide();
	       		 formWin.down('#smsDiscriptionNotice').hide();
	       		 formWin.down("#staticUploadFileField").show();
	       		// formWin.down("#staticDocumentMessageAttachmentGrid").show();
	       		 formWin.down("#enquiryDocumentMessageAttachmentGrid").show();
	       		 formWin.down('#subject').reset();
	       		 formWin.down("#subject").show();
	       		 formWin.down("#subject").allowBlank=false;
	       		 formWin.down('#discriptionId').show();    		
	       	 }
	       },
	       selectEnquiryTypeTemp: function(obj,rec){
		       	var $this =  this;
		       	 var form = $this.getEnquiryupdatesdownloadform();
		       	var formValues = form.getFormValues();
		       	if(!isNullOrEmpty(formValues) && !isNullOrEmpty(formValues.templateFor)&& formValues.templateFor=="Closure Details"){
		       		if(formValues.enquiryType=="2"){
		       			form.down('#programId').setDisabled(true);
		       			form.down('#programId').reset();
		       			
		       			form.down('#batch').setDisabled(true);
		       			form.down('#batch').reset();
		       			
		       			form.down('#seatType').setDisabled(true);
		       			form.down('#seatType').reset();
		       			
		       			form.down('#modeDeliveryId').setDisabled(true);
		       			form.down('#modeDeliveryId').reset();
		       			
		       			form.down('#registrationTypeId').setDisabled(true);
		       			form.down('#registrationTypeId').reset();
		       			
		       			form.down('#programGroup').setDisabled(true);
		       			form.down('#programGroup').reset();
		       		}else{
		       			form.down('#programId').setVisible(true);
		       			form.down('#programId').reset();
		       			form.down('#programId').setDisabled(false);
		       			form.down('#modeDeliveryId').setVisible(true);
		       			form.down('#modeDeliveryId').setDisabled(false);
		       			form.down('#registrationTypeId').setVisible(true);
		       			form.down('#registrationTypeId').setDisabled(false);
		       			form.down('#programGroup').setVisible(true);
		       			form.down('#programGroup').setDisabled(false);
		       			form.getForm().isValid();
		       		}
		       		
		       		
		       	}
		       	 
		       },
		       selectTemplateForIdTemp: function(obj,rec){
			       	var $this =  this;
			       	 var form = $this.getEnquiryupdatesdownloadform();
			       	var formValues = form.getFormValues();
			       	if(!isNullOrEmpty(formValues) && !isNullOrEmpty(formValues.templateFor)&& formValues.templateFor=="Closure Details"){
			       		if(formValues.enquiryType=="2"){
			       			form.down('#programId').setDisabled(true);
			       			form.down('#programId').reset();
			       			
			       			form.down('#batch').setDisabled(true);
			       			form.down('#batch').reset();
			       			
			       			form.down('#seatType').setDisabled(true);
			       			form.down('#seatType').reset();
			       			
			       			form.down('#modeDeliveryId').setDisabled(true);
			       			form.down('#modeDeliveryId').reset();
			       			
			       			form.down('#registrationTypeId').setDisabled(true);
			       			form.down('#registrationTypeId').reset();
			       			
			       			form.down('#programGroup').setDisabled(true);
			       			form.down('#programGroup').reset();
			       		}else{
			       			form.down('#programId').setVisible(true);
			       			form.down('#programId').reset();
			       			form.down('#programId').setDisabled(false);
			       			form.down('#modeDeliveryId').setVisible(true);
			       			form.down('#modeDeliveryId').setDisabled(false);
			       			form.down('#registrationTypeId').setVisible(true);
			       			form.down('#registrationTypeId').setDisabled(false);
			       			form.down('#programGroup').setVisible(true);
			       			form.down('#programGroup').setDisabled(false);
			       		}
			       		
			       		
			       	}else{
			       		form.down('#programId').setVisible(true);
		       			form.down('#programId').reset();
		       			form.down('#programId').setDisabled(false);
		       			form.down('#modeDeliveryId').setVisible(true);
		       			form.down('#modeDeliveryId').setDisabled(false);
		       			form.down('#registrationTypeId').setVisible(true);
		       			form.down('#registrationTypeId').setDisabled(false);
		       			form.down('#programGroup').setVisible(true);
		       			form.down('#programGroup').setDisabled(false);
			       	}
			       	 
			       },
	       /**
	        * upload static document file for Student
	        */
	       uploadEnquiryStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('enquirysendmessage');
	    	   var grid = setupForm.down('#enquiryStaticDocumentAttachmentGridMessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   var fileSizeLimit = '5';
	    	   var url = SERVERURL.FILE_PRIORITY;
	    	   Ext.Ajax.request({
					type: 'rest',
					url: url+'?type=emailFileSize',
					method: 'GET',
					success : function(response, action){
						var responseData = Ext.JSON.decode(response.responseText);
						if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
						{
							fileSizeLimit=responseData[0].value;
						}
	    	   if((file.size / 1048576) <=  fileSizeLimit ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	    					   || extension == "doc" || extension == "docx" || extension == "txt"
	    						   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx") {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   this$.saveEnquiryStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }

	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
	    	   }
			   }
	    	   });
	       },
	       /**
	        * Remove entry from grid
	        */
	       deleteEnquiryStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	    	   var grid = view.up('#enquiryStaticDocumentAttachmentGridMessage');
	    	   var panel = this.getContentpanel().getActiveTab();
	    	   var tabTitle = panel.title;
	    	   var store = grid.getStore();
	    	   var templateConfigDocId = record.get('templateConfigDocId');
	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	    	   if(!(tabTitle == viewTitle)){
	    		   if(!isNullOrEmpty(templateConfigDocId)){
	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    				   if (btn == 'yes') {
	    					   Ext.Ajax.request({
	    						   type: 'rest',
	    						   url: SERVERURL.STATIC_DOC_DELETE,
	    						   method: 'DELETE',
	    						   params: {
	    							   templateConfigDocId : templateConfigDocId
	    						   },
	    						   headers: {
	    							   'Content-Type': 'application/json'
	    						   },
	    						   success: function(form, action) {
	    							   store.remove(record);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    						   }
	    					   });
	    				   }
	    			   });

	    		   }else{
	    			   store.remove(record);
	    			   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    		   }
	    	   }else{
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	    	   }

	       },
	       /**
	        * This method is to enable schedule field
	        */
	       loadEnquiryScheduleField : function(radio,newValue, oldValue){
	       	var adhocMessageForm = radio.up('form');
	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	       	var radioValue = radio.getValue().sendingPriority;
	       	
	       	if(radioValue=='IMMEDIATE'){
	       		scheduleDateField.setVisible(false);
	       		scheduleDateField.setDisabled(true);
	       		scheduleTimeField.setVisible(false);
	       		scheduleTimeField.setDisabled(true);    		
	       	}
	       	else if(radioValue=='SCHEDULE'){
	       		scheduleDateField.setVisible(true);
	       		scheduleDateField.setDisabled(false);
	       		scheduleTimeField.setVisible(true);
	       		scheduleTimeField.setDisabled(false);
	       	}
	       },
	       openEnquirySendMessage:function(obj){
	    	//   if(!Ext.isDefined(Ext.ComponentQuery.query('enquirysendmessage')[0])){
	    		   
		    	var grid = obj.up('grid');
		    	if(grid.getSelectionModel().getCount()>0) {
		    		
		    			var $this=this;
		    			var contentPanel = $this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
		    	       	   var structure = Ext.widget('enquirysendmessage',{
	               			itemId:'trackEnquirySendMessageWindow',
	               			customGridId: grid.itemId
	               		});
		    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
		    	       	   /**
		    	       	    * This is to remove tab from content panel and open same tab again
		    	       	    */
		    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		    	       	   var getTab=getcontroller.getTab(tabName);
		    	       	   if(getTab!=null){
		    	       		   contentPanel.remove(getTab, true);
		    	       	   }
		    	       	var formWindowTab = $this.getEnquirysendmessage();
		    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
		    	       	formWindowTab.down("#selectTemplate").setVisible(false);
		    	       	formWindowTab.down("#messageName").allowBlank=true;   
		    	       	formWindowTab.down("#messageName").setVisible(false);
		    	       	formWindowTab.down("#templateId").setVisible(false);
		    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
		    			templateStore.getProxy().extraParams={
		    				msgRecipientTypeId:12
		    			};
		    			templateStore.load();
		    			
		    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    			   Ext.Ajax.request({
		    				   method : "GET",
		    				   type : 'rest',
		    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
		    				   headers : {
		    					   'Content-Type' : 'application/json'
		    				   },
		    				   success : function(form,action) {
		    					   var data = Ext.JSON.decode(form.responseText);
		    					   formWindowTab.down("#id").setValue(data.id);
		    					   formWindowTab.down("#code").setValue(data.code);
		    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
		    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
		    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
		    					   Ext.getBody().unmask();
		    					   
		    					   //grid.getStore().reload();
		    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
		    				   }

		    			   });
		    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
		    	       	setTimeout(function(){
		    	       		formWindowTab.down("#templateId").setVisible(false);
						  },100);
		    	       	
		    		
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
	    	  // }
		    },
		    /**
		        * save document file. It's external call method
		        * @param entityId : person id, It's mandatory. 
		        * @param module : module name, for student module 'student', It's mandatory.
		        * @param entityType : entity type, It's mandatory.
		        * @param documentType : document type, It's mandatory.
		        * @param isTransient : true or false (send json back to module controller or not)
		        * @param callBackFunction : callback function return in module controller. It's mandatory.
		        */
		    	saveEnquiryStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		       	var submitUrl = '';
		       	var templateTab = this.getContentpanel();
		       	var formWin =  this.getEnquirysendmessage();
		       	var form = formWin.down('#msgDetailsForm');
		       	var id = form.down('#document_hidden_field');
		           if (isNullOrEmpty(id.getSubmitValue())) {
		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
		           }
		           var data = new Object();
		           if(!isNullOrEmpty(entityId)){
		           	data.entityId = entityId;
		           }else{
		           	data.entityId = null;
		           }
		           if(!isNullOrEmpty(module)){
		           	data.module = module;
		           }else{
		           	data.module = null;
		           }
		           if(!isNullOrEmpty(entityType)){
		           	data.entityType = entityType;
		           }else{
		           	data.entityType = null;
		           }
		           form.getForm().setValues(data);
		           form.getForm().submit({
		           	method : 'POST',
		           	url : submitUrl,
		           	success : function(form, action){
		           		callBackFunction(true, action, isTransient);
		           		
		           	}
		           });
		       },
		       /**
		        * Add value to grid
		        */
		       loadGridWithFileNameMessage:function(grid,value,store){
		    	   grid.bindStore(store);
		       },
		       downloadUploadFormChangeNew: function(cb, nv, ov) {
		           var $this = this;
		           var downloadTemplateForm = this.getEnquirynewdownloadform();
		           var uploadTemplateForm = this.getEnquirynewuploadform();
		           var grid = $this.getImportlistenquirynewgrid();
		           if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
		               uploadTemplateForm.hide();
		               downloadTemplateForm.show();
		               grid.setVisible(false);
		           } else {
		        	   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
		        	   var uploadoptionradiogroupform  = $this.getEnquirynewuploadoptionradiogroup();
		        	   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		        		   isUploadAll: false
		        	   });
		               downloadTemplateForm.hide();
		               uploadTemplateForm.show();
		               grid.setVisible(true);
		           }
		       },
		       
		       
		       downloadUploadFormChangeImportEnquiryUpdates: function(cb, nv, ov) {
		           var $this = this;
		           var downloadTemplateEnquiryUpdatesForm = $this.getEnquiryupdatesdownloadform();
		           var uploadTemplateEnquiryUpdatesForm = $this.getEnquiryupdatesuploadform();
		           var grid = $this.getImportenquiryupdatesgrid();
		           if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
		        	   uploadTemplateEnquiryUpdatesForm.hide();
		               downloadTemplateEnquiryUpdatesForm.show();
		               grid.setVisible(false);
		           } else {
		        	   $this.doAccessControlValidationForLoader(uploadTemplateEnquiryUpdatesForm,this.getCORE_ERP_LOADER_PERMISSIONS());
		        	   var uploadoptionradiogroupform  = $this.getImportEnquiryUpdatesRadioGroup();
		        	   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		        		   isUploadAll: false
		        	   });
		        	   downloadTemplateEnquiryUpdatesForm.hide();
		               uploadTemplateEnquiryUpdatesForm.show();
		               grid.setVisible(true);
		           }
		       },
		       
		       
		       createJsonForEnquiryNewFormDownload: function() {
		           var enquiryNewDownloadForm = this.getEnquirynewdownloadform();
		           var academyLocIds = enquiryNewDownloadForm.down('#academyLocationItemId').value;
		           var mainJson = new Object();
		           var alArray = new Array();
		           for (var i = 0; i < academyLocIds.length; i++) {
		               alArray.push(academyLocIds[i].data.id);
		           }
		           mainJson.academyLocations = alArray;
		           mainJson.enquiryType = enquiryNewDownloadForm.down('#enquiryTypeItemId').rawValue;
		           return mainJson;
		       },
		       getDownloadFileNew: function(documentId, fileType) {
		           if (!isNullOrEmpty(documentId)) {
		               var csvForm = Ext.create('Ext.form.Panel');
		               csvForm.getForm().submit({
		                   target: '_blank',
		                   method: 'POST',
		                   params: {
		                       access_token: Ext.Ajax.defaultHeaders.access_token
		                   },
		                   headers: {
		                       'Authorization': Ext.Ajax.defaultHeaders.Authorization
		                   },
		                   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
		                   standardSubmit: true
		               });
		           }
		       },
		       getUserAccessibleAL:function(){
		    	   var academyLocationId = [];
		    	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
		    	   for(var i=0; i<academyLocationList.length; i++){
		    		   academyLocationId.push(academyLocationList[i].id);
		    	   }
		    	   return academyLocationId;
		       },
		       exportXLFunction:function(model, records){
		    	   var reportTypeValue = 'ENQUIRY_EXPORT_REPORT';
		    	   var enquiryIds = [];
				   var grid = this.getSearchresultgrid();
				   var records = grid.getSelectionModel().getSelection();
				   if(grid.getSelectionModel().getCount() > 0){
						for(var i in records) {
							enquiryIds.push(parseInt(records[i].data.ID));
						}
		    		}
			       	var $this = this;
			       	var code = reportTypeValue;
			       	var reportParams = new Object();
			       	reportParams.code = code;
			       	reportParams.reportTitle = getAdmissionTranslation('ENQUIRY_REPORT_TITLE');
			       	reportParams.enquiryIds = enquiryIds;
			       	reportParams.headerName = getCommonTranslation('LIST_OF_ENQUIRIES');
			       	var reportTitle="";
			       	$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.EXPORT_ENQUIRY_REPORT);
		       },
		       disableExportReportButton:function(column,selected) {
					var grid = this.getSearchresultgrid();
			    	var deleteButtonItemId = grid.down('#searchResultGridBtnDelete');
			    	var editButtonItemId = grid.down('#searchResultGridBtnEdit');
					var followUpDetailsItemId = grid.down('#followUpDetails');
					var viewDocumentsItemId = grid.down('#viewDocumentsLinked');
					var sendReminderItemId = grid.down('#sendReminder');
					var makeActiveItemId = grid.down('#makeActive');
					//followUpDetailsItemId.setDisabled(true);
					
					var exportReportButtonItemId = grid.down('#exportReportsId');
					exportReportButtonItemId.setDisabled(true);
					var counter = 0;
					var count=selected.length;
					
					if(count > 0){ // enable
						exportReportButtonItemId.setDisabled(false);
					
					}else{  // disable
						exportReportButtonItemId.setDisabled(true);
					}
					if(count >= 1){ // enable
						sendReminderItemId.setDisabled(false);
					}else{  // disable
						sendReminderItemId.setDisabled(true);
					}
					
					if(count == 1){ // enable
						followUpDetailsItemId.setDisabled(false);
						viewDocumentsItemId.setDisabled(false);
					}else{  // disable
						followUpDetailsItemId.setDisabled(true);
						viewDocumentsItemId.setDisabled(true);
					}
					var popiaflag = false;
			           var popiaflag1 = true;
			       	var enquiryPopiaStatusStore=Ext.getStore('common.EnquiryPopiaStatusDropdownValue');
			       	if(enquiryPopiaStatusStore.data.items.length>0) {
			       	var popiaValue;
			       	var popiaCode;
			       	if (enquiryPopiaStatusStore.data.items[0] != null)
			       		{
			       		    popiaValue=enquiryPopiaStatusStore.data.items[0].data.value;
	                        popiaCode=enquiryPopiaStatusStore.data.items[0].data.code;
			       		}
        	           
                       if(popiaValue!=null&&popiaValue=='Yes'&&popiaCode!=null&&popiaCode=='Enquiry')
        				{
		     				selected.forEach(function(obj){
		     		    		var PopiaStatus=obj.getData().POPIA_STATUS;
		     		    		if(!isNullOrEmpty(PopiaStatus)){
		     		    			if(PopiaStatus=='Opt-Out'){
		     		    				popiaflag=true;
		     		    			}
		     						else if(PopiaStatus=='Opt-In'){
		     							popiaflag1=false;    		        						
		     							}
		     		    	         	}
		     		    		if(popiaflag == true && popiaflag1 == true ){
		     		        		deleteButtonItemId.setDisabled(true);
		     		        		editButtonItemId.setDisabled(true);
		         					}
		         					else{
			         						if(selected.length==1){
			         						deleteButtonItemId.setDisabled(false);
				     		        		editButtonItemId.setDisabled(false);    
			     						  } else if(selected.length>1)
			   							      { 
			     			     				if(popiaflag == true && popiaflag1 == false ){
			     			     		        		deleteButtonItemId.setDisabled(true);
			     			         					}
			   				    		        editButtonItemId.setDisabled(true);
			   							       }else
			   							    	   {
	   			         						deleteButtonItemId.setDisabled(false);
			   						    		editButtonItemId.setDisabled(false);
			   							    	   }
				            					}
		     		    			});
		     				if(selected==0)
		     					{
		     					deleteButtonItemId.setDisabled(false);
						    	editButtonItemId.setDisabled(false);
		     					}
		     				} else {
		     					deleteButtonItemId.setDisabled(false);
						    	editButtonItemId.setDisabled(false);
		     				}
			       	}
		       },
		    	 openEnquiryFollowUpDetailTab : function(view,rowIndex,grid){
		                
		            	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.exam.ExamDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.admission.AdmissionReqmntDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.followup.FollowUpDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.closure.ClosureDetailController');
		            	/*//Academia.app.getController('Academia.controller.enquiry.checkList.CheckListController');*/
		            	
		            	var $this = this;
		            	var tabName = getEnquiryTranslation('ENQUIRY_DETAILS');
		            	var getcontroller = this.getController('menu.CoreERPNavigationController');
		            	var contentpanel = $this.getContentpanel();
		            	var getTab = getcontroller.getTab(tabName);
		            	if (getTab != null) {
		            		contentpanel.remove(getTab, true);
		            	}
		            	
		            	if(grid.getSelectionModel().getCount()>0){
		            		var val=grid.getSelectionModel().getSelection()[0].data; 
		               
		            		if(typeof(val.whether_Deleted)==='string') {
		            			if(val.whether_Deleted=='true') {
		            				val.whether_Deleted=true;
		            			} else{
		            				val.whether_Deleted=false;
		            			}
		            		}
		            		if(!val.whether_Deleted){
		            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
		            		if (!tabStructure1) {
		            			tabStructure1 = Ext.widget('enquirytabstructure');
		            		}
		            		var tabStructure = tabStructure1.getForm();
		            		var status = val.TRACK_ENQUIRY_STATUS;
		            		// commented by utsav : now we have applied formatter so from back end status would be 'Open' or 'Closed'
		            		// so no need to apply condition
		            		/*if(val.TRACK_ENQUIRY_STATUS=='C'){
		            			status = getCommonTranslation('CLOSE'); 
		            		}else{
		            			status = getCommonTranslation('OPEN');
		            		}
		            		*/
		            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
		            			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
		            				tabStructure.findField("enquiryId").setVisible(true);
		            				tabStructure.findField("enquiryId").reset();
		            				tabStructure.findField("enquiryId").setValue(val.TRACK_ENQUIRY_NO);
		            			}
		            			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
		            				tabStructure.findField("enquiryTxtId").reset();
		            				tabStructure.findField("enquiryTxtId").setVisible(false);
		            			}
		            		}else{
		            			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
		            				tabStructure.findField("enquiryTxtId").setVisible(true);
		            				tabStructure.findField("enquiryTxtId").reset();
		            				tabStructure.findField("enquiryTxtId").setValue(val.TRACK_ENQUIRY_NO);
		            			}
		            			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
		            				tabStructure.findField("enquiryId").reset();
		            				tabStructure.findField("enquiryId").setVisible(false);
		            			}
		            		}
		            		
		            		tabStructure.findField("enqId").setValue(val.ID);
		            		tabStructure.findField("enqTypes").setValue(val.ENQUIRY_TYPE);
		            		
		            		if(val.STUDENT_DETAIL_ID>0){
		            			tabStructure.findField("studentDetailId").setValue(val.STUDENT_DETAIL_ID);
		            		}
//		            		var contentpanel = $this.getContentpanel();
		            		var coursetabstructure = Ext.ComponentQuery.query("enquirytabstructure")[0];
		            		if (!coursetabstructure) {
		            			coursetabstructure = Ext.widget('enquirytabstructure');
		            		}
		            		//var tabName = getCommonTranslation('ENQUIRY_DETAILS');
		            		if(val.ENQUIRY_TYPE != getEnquiryTranslation('CNTRL_ADMISSION')){
		            			//coursetabstructure.items.items[1].items.items[1].tab.hide();
		            			//coursetabstructure.items.items[1].items.items[2].tab.hide();
		            			//coursetabstructure.items.items[1].items.items[3].tab.hide();
		            			
		            			/**
		            			 * Hide closure follow up grid in follow up detail tab.
		            			 */
		            			var closureFollowupgrid=$this.getClosurefollowupgrid();
		            			if(closureFollowupgrid != undefined && closureFollowupgrid != null){
		            				closureFollowupgrid.setVisible(false);
		            			}
		            		}
		            		/**
		            		 * below code commented
		            		 * because sometimes by it other tab get closed
		            		 * and also throwing some js error sometimes
		            		 */
		            		/*if(contentPanel.items.items[1]){
								var itm = contentPanel.items.items[1];
								itm.close();
							}*/
		            		/**
		                	 * This is to remove tab from content panel and open same tab again 
		                	 */
		                	//var getcontroller=this.getController('menu.CoreERPNavigationController');
		                	//var getTab=getcontroller.getTab(tabName);
		            		//if(getTab!=null){
		            			//contentpanel.remove(getTab, true);
		                 	//}
		            		openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_ONE);
		            		var enquiryTabPanelArea = contentpanel.down('#enquiryTabPanelArea');
		            		var getEnquiryTabPanel = enquiryTabPanelArea.items.items[0];
		            		var followUpTab = getEnquiryTabPanel.down('followupstructure');
		            		getEnquiryTabPanel.setActiveTab(followUpTab);
		            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
			            		var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
			            		if(!isNullOrEmpty(myText)){
			            			myText.setVisible(true);
			            			myText.reset();
			            			myText.setValue(val.TRACK_ENQUIRY_NO);
			            		}
			            		var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
			            		if(!isNullOrEmpty(myedtText)){
			            			myedtText.reset();
			            			myedtText.setVisible(false);
			            		}
		            		}else{
		            			var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
			            		if(!isNullOrEmpty(myText)){
			            			myText.setVisible(true);
			            			myText.reset();
			            			myText.setValue(val.TRACK_ENQUIRY_NO);
			            		}
			            		var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
			            		if(!isNullOrEmpty(myedtText)){
			            			myedtText.reset();
			            			myedtText.setVisible(false);
			            		}
		            		}
		            		
		            		var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
		            		if(!isNullOrEmpty(val.ASSIGN_TO_ID)){
		            			assignToId.setVisible(true);
		            			assignToId.reset();
		            			assignToId.setValue(val.ENQUIRY_OWNER);
		            		} else if(!isNullOrEmpty(val.ASSIN_TO)){
		            			assignToId.setVisible(true);
		            			assignToId.reset();
		            			assignToId.setValue(val.ASSIN_TO);
		            		} else {
		            			assignToId.setVisible(true);
		            			assignToId.reset();
		            			assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
		            		}
		            		var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
		            		if(!isNullOrEmpty(val.PROSPECTIVE_STUDENT_NAME)){ 
		            			studentName.setValue(val.PROSPECTIVE_STUDENT_NAME); 
		            		} else if(!isNullOrEmpty(val.STUDENT_FULL_NAME)){
		            			studentName.setValue(val.STUDENT_FULL_NAME);
		            		}

		            		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
		            		if(!isNullOrEmpty(val.TRACK_ENQUIRER_NAME)){ 
		            			parentName.setValue(val.TRACK_ENQUIRER_NAME); 
		            		} else if(!isNullOrEmpty(val.ENQUIRER_NAME)){
		            			parentName.setValue(val.ENQUIRER_NAME);
		            		} 
		            		
		            		if(isNullOrEmpty(val.STUDENT_DETAIL_ID)){
		            			val.STUDENT_DETAIL_ID = 0;
		            		}
		            		Ext.Ajax.request({
		                        type : 'rest',
		                        url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.STUDENT_DETAIL_ID,
		                        method : 'GET',
		                        success : function(form, action) {
		                        var data = Ext.JSON.decode(form.responseText);
		                        	//console.log(data);
		                        	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
		                        	if(!isNullOrEmpty(data[0])){
		                        		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
		                        			programIntake.setValue(data[0].programIntakeCombo); 
		                        		}
		                        	}
		                        }
		                    });

		            		
		            		var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
		            		if(!isNullOrEmpty(val.ENQ_STAGE)){ 
		            			intermediateStage.setValue(val.ENQ_STAGE); 
		            		} else{
		            			if(!isNullOrEmpty(val.ENQ_INTERMEDIATE_STAGE)){ 
		            				intermediateStage.setValue(val.ENQ_INTERMEDIATE_STAGE); 
		            			} }

		            		var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
		            		intermediateStageId.setValue(val.ENQ_INTERMEDIATE_ID);

		            		var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
		            		myTextField.setValue(status);

		            		var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
		            		priorityField.setValue(val.ENQUIRY_PRIORITY);

		            		var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
		            		priorityIdField.setValue(val.ENQUIRY_PRIORITY_ID);
		            		var form = Ext.getCmp('followUpDetailFormId');
		            		if(val.TRACK_ENQUIRY_STATUS!="Open"){
		            			form.down('#followdetail_submitbuttonId').setVisible(false);
		      	 					form.down('#actualFollowUpDate').setReadOnly(true);
		      	 					form.down('#enqIntermediateStage').setReadOnly(true);
		      	 					form.down('#trackEnquiry_priority').setReadOnly(true);
		      	 					form.down('#remarkItemId').setReadOnly(true);
		      	 					form.down('#nextFollowUpDateId').setReadOnly(true);
		      	 					form.down('#userByAssignToId').setReadOnly(true);
		      	 					form.down('#whetherNextFollowUpId').setDisabled(true);
		            		}
		            		
		            		var grid = Ext.getCmp('followUpDetailGridId');
		            		grid.getStore().load({
		            			callback: function(record, operation, success) {
	            					if (success) {
	            						
	            						var recIndex = grid.getStore().find('isLatestFollowUp', true);
	            						if(recIndex == -1){
	            							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
	            						}else{
	            							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
	            						}
	        		            		
	        		            		var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
	        		            		var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
	        		            		var rec = grid.getSelectionModel().getSelection();
	        		            		var form = Ext.getCmp('followUpDetailFormId');
	        		            		
	        		            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
	        		            		var getTabScroll = tabStructure1.up();
	        		            		var getformPosition = form.getPosition()[1];
	        		            		
	        		            		var records = grid.getSelectionModel().getSelection();
	        		            		if (records != undefined && records != "" && records != null) {
	        		            			form.loadRecord(records[0]);
	        		            			form.getForm().findField('actualFollowUpDate').setValue(new Date());
	        		            			var stageStore = $this.getStore('enquiry.EnqIntermediateType');
	        		            			stageStore.load({
	        		            				callback: function(record, operation, success) {
	        		            					if (success) {
	        		            						var enqIntermediateStage=form.down('#enqIntermediateStage');
	        		            						if (!isNullOrEmpty(enqIntermediateStage)) {
	        												if (stageId != null) {
	        													enqIntermediateStage.setValue(parseInt(stageId));
	        												} else {
	        													enqIntermediateStage.setValue(1);
	        												}
	        											}
	        		            						setTimeout(function(){
	        		            							if(form.getForm().isValid()){
	        		            								var submitButton = form.down('#followdetail_submitbuttonId');
		        		            							submitButton.setDisabled(false);
	        		            							}
	        		     	 							},100);
	        		            					}
	        		            				}
	        		            			});
	        		            			var priority = form.getForm().findField('priority');
	        		            			if(!isNullOrEmpty(priority)) {
	        		            				priority.store
	        		            				.load({
	        		            					callback : function(r, operation,
	        		            							success) {
	        		            						if (success) {
	        		            							if (priorityId != null) {
	        		            								priority
	        		            								.setValue(parseInt(priorityId));
	        		            							} else {
	        		            								priority.setValue(1);
	        		            							}

	        		            						}
	        		            					}
	        		            				});
	        		            			}
	        		            		}
	            					}
	            				}
		            		});
		            		
		            		 }else{
		            			 // message for record already deleted
		            			 showWarningMessage(getCommonTranslation('ENQUIRY_DELETE_TITLE'),getCommonTranslation('DELETED_MSSG'));//Please select a record
		            		 }
		            	}else{
		            		showWarningMessage(getCommonTranslation('ENQUIRY_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
		            	}
		            },
		            sendReminderAction:function(grid){
		            	var $this = this;
		            	var jsonData = []; 
		            	var enquiryIds=[];
		            	var records = grid.getSelectionModel().getSelection();
		            	if(grid.getSelectionModel().getCount() > 0){
		            		for(var i in records) {
		            			enquiryIds.push(parseInt(records[i].data.ID));
		            		}
		            		var sendReminderData =new Object();
		            		sendReminderData.enquiryIds = String(enquiryIds);

		            		submitUrl = SERVERURL.PATH_SENDENQUIRY_REMINDER; 
		            		Ext.Ajax.request({
		            			type : 'rest',
		            			url : submitUrl,
		            			jsonData : sendReminderData,
		            			method : 'POST',
		            			success : function(form, action) {
		            				showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('MESSAGE_SEND_MSG'));
		            				grid.getStore().reload();
		            			}
		            		});
		            	}else{
		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));   
		            	}
		            },
		            setMobileNoValidationForEnquiry:function(grid) {
		            	
		            	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
		            	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailController');
		            	
		            	var $this = this;
		            	var tabName = getEnquiryTranslation('ENQUIRY_DETAILS');
		            	var getcontroller = this.getController('menu.CoreERPNavigationController');
		            	var contentpanel = $this.getContentpanel();
		            	
		            		
		            	var enquiryTabPanelArea = contentpanel.down('#enquiryTabPanelArea');
	            		var getEnquiryTabPanel = enquiryTabPanelArea.items.items[0];
	            		var EnquiryDetailsTab = getEnquiryTabPanel.down('enquirydetailstructure');
	            		
	            		var enquiryDetailsForm = EnquiryDetailsTab.items.items[0];
	            		
	            		var countryCodeField = enquiryDetailsForm.down('#enquiryDetail_cellCountrycode');
	            		var mobileField = enquiryDetailsForm.down('#enquiryDetail_cellNumber');
	            		this$.setMaximumMinimumDigitsForMobileNoValidation(enquiryDetailsForm,countryCodeField,mobileField,null);
	            		
	            		countryCodeField = enquiryDetailsForm.down('#enquiryDetail_alternateCellCountrycode');
	            		mobileField = enquiryDetailsForm.down('#enquiryDetail_alternateCellNumber');
	            		this$.setMaximumMinimumDigitsForMobileNoValidation(enquiryDetailsForm,countryCodeField,mobileField,null);
	            		
	            		countryCodeField = enquiryDetailsForm.down('#enQStdCountryCodeItemId');
	            		mobileField = enquiryDetailsForm.down('#enQStdMobileNumberItemId');
	            		this$.setMaximumMinimumDigitsForMobileNoValidation(enquiryDetailsForm,countryCodeField,mobileField,null);
	            		
	            		var StudentDetailsTab = getEnquiryTabPanel.down('studentdetailstructure');
		            		
	            		var studentDetailsForm = StudentDetailsTab.items.items[0];
	            		
	            		countryCodeField = studentDetailsForm.down('#stdCountryCodeItemId');
	            		mobileField = studentDetailsForm.down('#stdMobileNumberItemId');
	            		this$.setMaximumMinimumDigitsForMobileNoValidation(studentDetailsForm,countryCodeField,mobileField,null);
	            		
	            		countryCodeField = studentDetailsForm.down('#stdAlternateMobileCountryCode');
	            		mobileField = studentDetailsForm.down('#stdAlternateMobileNo');
	            		this$.setMaximumMinimumDigitsForMobileNoValidation(studentDetailsForm,countryCodeField,mobileField,null);
		            		
		            },
                    showEnquiryFormFromLink: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                  	  var grid = grid.ownerCt;
                  	  var $this = this;
                  	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
                  	  if(e.target.tagName=="A"){
                  		  /**
                  		   * this function is to view enquiry @bhanu (in edit mode)
                  		   */
                  		  if(columnName=='TRACK_ENQUIRY_NO' ){
                  			  this.linkClicked(0,0,grid,'Edit',false,null,record);
                  		  }else  if( columnName=='code' ){
                  			  this.linkClicked(0,0,grid,'View',false,null,record);
                  		  }
                  		  
                  		  if(columnName=='APPLICATION_ID'){
                  			  var applicantId = record.get('APPL_ID'); 
                  			  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
                  			  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
                  			  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
                  			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
                  			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
                  			  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
                  			  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
                  			  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
                  			  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
                  			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
                  			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
                  			  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
                  			  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');

                  			  $this.openApplicantProfileFromFeeReportFromLink(applicantId, true,grid,record);
                  		  }
                  		  if(columnName=='ADMISSION_ID'){
                  			  var tabTitle = record.get('ADMISSION_ID');
                  			  var personId = record.get('STUDENT_PERSON_ID');
                  			  var programBatchSeatTypeConfigId = record.get('SEATCONFIG_ID');
                  			  var userId = record.get('STUDENT_ID'); 
                  			  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
                  			  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
                  			  var studentId=null;
                  			  Ext.Ajax.request({
                    		    	type: 'rest',
                    		    	async: false,
                    		    	url: SERVERURL.VALIDATE_SIBLING_STUDENT_ID,
                    		    	params: {
                    		    		studentCode: userId
                    		    	},
                    		    	method: 'GET',
                    		    	success: function(response, action) {
                    		    	var data = Ext.decode(response.responseText);
                    				if (!isEmpty(data)) {
                    					studentId = data.id;
                    				}
                    		    	}
                    		    });                       	 
                  			 
                  			  personController.addContentPanelTab(tabTitle, 'studentprofile', studentId, personId, null, null, programBatchSeatTypeConfigId);
                  		  }
                  	  }
                  	  e.stopEvent();
                  	  e.stopPropagation();
                  	  return false;
                    },

                    //******************For Open Applicant Profile********************************************************
                    openApplicantProfileFromFeeReportFromLink:function(applicationId,isView,searchResultGrid,record){
                  	  if(searchResultGrid){
                  		  var store=searchResultGrid.getStore();
                  		  var tabTitle = null;
                  		  var personId = null;
                  		  var applicationId = null;
                  		  var admissionId = null;
                  		  var record = record;
                  		  tabTitle = record.get('APPLICATION_ID');
                  		  personId = record.get('APPL_PERSON_ID');
                  		  applicationId = record.get('APPL_ID');
                  		  admissionId = record.get('APPLICATION_ID');

                  		  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
                  		  var me=applicationBaseController;
                  		  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
                  		  if(applicantProfile){
                  			  me.getContentPanel().setActiveTab(applicantProfile);        			
                  		  }else{
                  			  me.addContentPanelTab(tabTitle, 'applicantprofile', null, personId,applicationId,admissionId);
                  			  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
                  			  if (applicantProfile) {            	
                  				  me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
                  				  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
                  				  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
                  				  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
                  				  me.gettingDataInSummaryGrid(applicantProfile);    
                  				  //me.getApplicantProfileInformation(applicantProfile);
                  				  if(!isEmpty(applicantLinkPanelObject)){

                  					  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
                  					  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

                  					  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
                  					  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

                  					  var personInfoPanel=applicantProfile.down("#personInfoPanel");
                  					  if(personInfoPanel){
                  						  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
                  						  if(applicantPersonalDetails){
                  							  personInfoPanel.setActiveTab(applicantPersonalDetails);
                  						  }        						
                  					  }

                  				  }

                  			  }
                  		  }    	        
                  	  }                	
                    },
                    
                    activeDeletedEnquiry : function(grid) {
                    	var grdStore = grid.getStore();  

                    	if(grid.getSelectionModel().getCount()>0){
                    		var records=grid.getSelectionModel().getSelection();
                    		if(typeof(records[0].data.whether_Deleted)==='string') {
                    			if(records[0].data.whether_Deleted=='true') {
                    				records[0].data.whether_Deleted=true;
                    			} else{
                    				records[0].data.whether_Deleted=false;
                    			}
                    		}
                    		if(records[0].data.whether_Deleted){
                    			showConfirmMessage(getEnquiryTranslation('MAKE_ACTIVE'), getEnquiryTranslation('ACTIVE_ENQUIRY_CONFIRM_MESSAGE'), function(btn, text) {
                    			if (btn == 'yes') {
                    					for(var count=0;count<records.length;count++){
                    						var id="";
                    						if(records[count].get("ID")!="" && records[count].get("ID")!=undefined && records[count].get("ID")!=null){
                    							id=records[count].get("ID");
                    						}
                    						Ext.Ajax.request({
                    							type: 'rest',
                    							url: SERVERURL.ACTIVE_DELETED_ENQUIRY_BY_ID+'?id='+id,
                    							method:'POST',
                    							headers: {
                    								'Content-Type': 'application/json'
                    							},
                    							success:function(form, action){
                    								grdStore.reload();
                    								showSuccessMessage(getEnquiryTranslation('MAKE_ACTIVE'),getEnquiryTranslation('SUCCESSFULLY_ACTIVE_ENQUIRY_MSG'));
                    							}
                    						});
                    					}
                    			    }
                    		    });
                    			}else{
                    				 showWarningMessage(getEnquiryTranslation('MAKE_ACTIVE'),getEnquiryTranslation('ENQUIRY_ALREADY_ACTIVE_MSG'));
                    			 }
                    	}else{
                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                    	}
                    },
                    
                    showAndHideReasons : function(enqStatus,form){
                    	var checkbox = form.down('#programExam_radioBtn');

                    	checkbox.items.items[0].setValue(true);
                    	checkbox.items.items[1].setValue(false);
                    	checkbox.items.items[0].setDisabled(false);
                    	checkbox.items.items[1].setDisabled(true)
                    	form.down("#closureDate").show();
                    	form.down("#closureReasonItemId").show();
                    	form.down("#closureRemarks").show();

                    	form.down("#closureDate").allowBlank=false;
                    	form.down("#closureReasonItemId").allowBlank=false;
                    	form.down("#closureRemarks").allowBlank=false;
                    },
                    cancelClosureDetail : function(){
                    	var form = this.getEnquiryclosureform();	
                    	form.close();
                    },
                    saveEnquiryClosureDetail : function(h,grid){
                    	var $this = this;
                    	var form = $this.getEnquiryclosureform().down('form').getForm();	
                    	var grid =  null;
                    	if(!$this.getCheckduplicatelistgrid().isHidden()){
                    		grid = $this.getCheckduplicatelistgrid();
                    	}else if(!$this.getCorporateCheckduplicatelistgrid().isHidden()){
                    		grid = $this.getCheckduplicatelistgrid();
                    	}else if(!$this.getNonAdmissionCheckduplicatelistgrid().isHidden()){
                    		grid = $this.getNonAdmissionCheckduplicatelistgrid();
                    	}
                    	
                    	var enquiryId =null
                    	var studentDetailId = null;  
                    	var enqType = null;
                    	var submitData =null;
                    	var gridStore =grid.getStore();
                    	var value = form.getValues();
                    	if(!isNullOrEmpty(value.applicationId)){
                    		var applicationId = $this.getIdValueJson(value.applicationId.id);
                    	}
                    	enqType = grid.getSelectionModel().getSelection()[0].data.ENQUIRY_TYPE_NAME;
                    	
                    	if(enqType==='Admission'){
                    		var enquiryIds = [];
                    		var selectedRecords = grid.getSelectionModel().getSelection();
                    		for(var i=0; i<selectedRecords.length; i++){
                    			enquiryIds.push(grid.getSelectionModel().getSelection()[i].data.ID);
                    		}

                    		var closureDetails = new Array();
                    		var selectedRecords = grid.getSelectionModel().getSelection();
                    		
                    		submitData = {
                    				"enquiryIds" : enquiryIds,
                    				"closureReason": {
                    					"id": value.closureReason
                    				},
                    				"closureDate": value.closureDate,
                    				"reasonRemark": value.closureRemarks,
                    				"whetherDeleted": "false",
                    				"application" : applicationId
                    		};
                    		closureDetails.push(submitData);
                    		submitUrl = SERVERURL.CLOSE_ALL_DUPLICATE_ENQUIRES;
                    		Ext.Ajax.request({
                    			method: "POST",
                    			type:'rest',
                    			url: submitUrl,
                    			jsonData: closureDetails,
                    			headers: {
                    				'Content-Type': 'application/json'
                    			},
                    			scope:this,
                    			success: function(response) {
                    				grid.getSelectionModel().deselectAll();
                            		grid.getStore().reload();
                            		this.cancelClosureDetail();
                            		showSuccessMessage(getCommonTranslation('CLOSURE_TITLE'),getCommonTranslation('SUCCESS'));
                            		}
                    		});
                    		

                    	}else{
                    		var selectedRecords = grid.getSelectionModel().getSelection();
                    		for(var i=0; i<selectedRecords.length; i++){
                    			enquiryId = grid.getSelectionModel().getSelection()[i].data.ID;
                    			submitData = {
                    					"enquiry": {
                    						"id": parseInt(enquiryId)
                    					},
                    					"closureReason": {
                    						"id": value.closureReason
                    					},
                    					"closureDate": value.closureDate,
                    					"reasonRemark": value.closureRemarks,
                    					"whetherDeleted": "false"
                    			};
                    			submitUrl = SERVERURL.CLOSURE_DETAIL_FOR_OTHER_ENQUIRY_TYPE_CLOSER_CREATE_URL;
                    			Ext.Ajax.request({
                    				method: "POST",
                    				type:'rest',
                    				url: submitUrl,
                    				jsonData: submitData,
                    				headers: {
                    					'Content-Type': 'application/json'
                    				},
                    				scope:this,
                    				success: function(response) {
                    				}
                    			});
                    		}
                    		grid.getSelectionModel().deselectAll();
                			grid.getStore().reload();
                			this.cancelClosureDetail();
                			showSuccessMessage(getCommonTranslation('CLOSURE_TITLE'),getCommonTranslation('SUCCESS'));
                    	}
                    },
                    getEnquiryUpdateLoaderJson:function(formValues){
                    	$this = this;
        		    	var obj = new Object();
        	            obj.templateFor = formValues.templateFor;
        	            
        	            var academyLocationArray = [];
        	            if(!isNullOrEmpty(formValues.academyLocation)){
        	        		if(typeof formValues.academyLocation == "object"){
        	            		Ext.each(formValues.academyLocation, function(academyLocation){
        	                        if(!isNullOrEmpty(academyLocation)){
        	                        	academyLocationArray.push(academyLocation.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			academyLocationArray.push(formValues.academyLocation);
        	        		}
        	        		if(!isNullOrEmpty(academyLocationArray) && academyLocationArray.length>0 && !isNullOrEmpty(academyLocationArray[0])) {
        	        			obj.academyLocationIds = academyLocationArray;
        	        		}
        	        	}
        	            if(isNullOrEmpty(obj.academyLocationIds)) {
        	            	var currentAcademyLocation = [];
        	            	var loggedInAL = $this.getCurrentAcademyLocation();
        	            	currentAcademyLocation.push(loggedInAL);
        	            	obj.academyLocationIds = currentAcademyLocation;
        	            }
        	            
        	            if(!isNullOrEmpty(formValues.enquiryType)) {
        	            	obj.enquiryType = formValues.enquiryType;
        	            }
        	            
        	            var intakeYearArray = [];
        	            if(!isNullOrEmpty(formValues.intakeYear)){
        	        		if(typeof formValues.intakeYear == "object"){
        	            		Ext.each(formValues.intakeYear, function(intakeYear){
        	                        if(!isNullOrEmpty(intakeYear)){
        	                        	intakeYearArray.push(intakeYear.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			intakeYearArray.push(formValues.intakeYear);
        	        		}
        	        		if(!isNullOrEmpty(intakeYearArray) && intakeYearArray.length>0 && !isNullOrEmpty(intakeYearArray[0])) {
        	        			obj.intakeYearIds = intakeYearArray;
        	        		}
        	        	}
        	            
        	            if(!isNullOrEmpty(formValues.programGroup)) {
        	            	obj.programGroup = formValues.programGroup;
        	            }
        	            
        	            var programArray = [];
        	            if(!isNullOrEmpty(formValues.programId)){
        	        		if(typeof formValues.programId == "object"){
        	            		Ext.each(formValues.programId, function(programId){
        	                        if(!isNullOrEmpty(programId)){
        	                        	programArray.push(programId.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			programArray.push(formValues.programId);
        	        		}
        	        		if(!isNullOrEmpty(programArray) && programArray.length>0 && !isNullOrEmpty(programArray[0])) {
        	        			obj.programIds = programArray;
        	        		}
        	        	}
        	            
        	            var batchArray = [];
        	            if(!isNullOrEmpty(formValues.batchId)){
        	        		if(typeof formValues.batchId == "object"){
        	            		Ext.each(formValues.batchId, function(batchId){
        	                        if(!isNullOrEmpty(batchId)){
        	                        	batchArray.push(batchId.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			batchArray.push(formValues.batchId);
        	        		}
        	        		if(!isNullOrEmpty(batchArray) && batchArray.length>0 && !isNullOrEmpty(batchArray[0])) {
        	        			obj.batchId = batchArray;
        	        		}
        	        	}
        	            
        	            var seatTypeArray = [];
        	            if(!isNullOrEmpty(formValues.seatTypeId)){
        	        		if(typeof formValues.seatTypeId == "object"){
        	            		Ext.each(formValues.seatTypeId, function(seatTypeId){
        	                        if(!isNullOrEmpty(seatTypeId)){
        	                        	seatTypeArray.push(seatTypeId.data.sequence);
        	                        }
        	                    });
        	        		} else{
        	        			seatTypeArray.push(formValues.SEAT_TYPE);
        	        		}
        	        		if(!isNullOrEmpty(seatTypeArray) && seatTypeArray.length>0 && !isNullOrEmpty(seatTypeArray[0])) {
        	        			obj.seatTypeId = seatTypeArray;
        	        		}
        	        	}
        	            
        	            if(!isNullOrEmpty(formValues.registrationType) && formValues.registrationType!="" ) {
        	            	if(formValues.registrationType=='FULL_TIME'){
        	            		obj.batchPartTime=false
        	            	}else{
        	            		obj.batchPartTime=true
        	            	}
        	            }
        	            
        	            var schoolArray = [];
        	            if(!isNullOrEmpty(formValues.school)){
        	        		if(typeof formValues.school == "object"){
        	            		Ext.each(formValues.school, function(schoolId){
        	                        if(!isNullOrEmpty(schoolId)){
        	                        	schoolArray.push(schoolId.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			schoolArray.push(formValues.schoolId);
        	        		}
        	        		if(!isNullOrEmpty(schoolArray) && schoolArray.length>0 && !isNullOrEmpty(schoolArray[0])) {
        	        			obj.schoolId = schoolArray;
        	        		}
        	        	}
        	            if(!isNullOrEmpty(formValues.modeofDelivery)) {
        	            	obj.modeofDeliveryId = formValues.modeofDelivery;
        	            }
        	            
        	            if(!isNullOrEmpty(formValues.school)) {
        	            	obj.schoolId = formValues.school;
        	            }
        	            
        	            
        	            if(!isNullOrEmpty(formValues.enquiryOwner)) {
        	            	obj.enquiryOwner = formValues.enquiryOwner;
        	            }
        	            if(!isNullOrEmpty(formValues.followUpUser)) {
        	            	obj.followUpUser = formValues.followUpUser;
        	            }
        	            if(!isNullOrEmpty(formValues.intermediateType)) {
        	            	obj.intermediateType = formValues.intermediateType;
        	            }
        	            if(!isNullOrEmpty(formValues.dateFrom)) {
        	            	obj.dateFrom = formValues.dateFrom;
        	            }
        	            if(!isNullOrEmpty(formValues.enquiryDateto)) {
        	            	obj.dateTo = formValues.enquiryDateto;
        	            }
        	            var sourceOfEntryArray = [];
        	            if(!isNullOrEmpty(formValues.source)){
        	        		if(typeof formValues.source == "object"){
        	            		Ext.each(formValues.source, function(source){
        	                        if(!isNullOrEmpty(source)){
        	                        	sourceOfEntryArray.push(source.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			sourceOfEntryArray.push(formValues.source);
        	        		}
        	        		if(!isNullOrEmpty(sourceOfEntryArray) && sourceOfEntryArray.length>0 && !isNullOrEmpty(sourceOfEntryArray[0])) {
        	        			obj.sourceOfEntry = sourceOfEntryArray;
        	        		}
        	        	}
        	            var modeOfEnquiriesArray= [];
        	            if(!isNullOrEmpty(formValues.modeOfEnquiry)){
        	        		if(typeof formValues.modeOfEnquiry == "object"){
        	            		Ext.each(formValues.modeOfEnquiry, function(modeOfEnquiry){
        	                        if(!isNullOrEmpty(modeOfEnquiry)){
        	                        	modeOfEnquiriesArray.push(modeOfEnquiry.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			modeOfEnquiriesArray.push(formValues.modeOfEnquiry);
        	        		}
        	        		if(!isNullOrEmpty(modeOfEnquiriesArray) && modeOfEnquiriesArray.length>0 && !isNullOrEmpty(modeOfEnquiriesArray[0])) {
        	        			obj.pointOfEntry = modeOfEnquiriesArray;
        	        		}
        	        	}
        	            
        	            var campaignArray = []
        	            if(!isNullOrEmpty(formValues.campaign)){
        	        		if(typeof formValues.campaign == "object"){
        	            		Ext.each(formValues.campaign, function(campaign){
        	                        if(!isNullOrEmpty(campaign)){
        	                        	campaignArray.push(campaign.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			campaignArray.push(formValues.campaign);
        	        		}
        	        		if(!isNullOrEmpty(campaignArray) && campaignArray.length>0 && !isNullOrEmpty(campaignArray[0])) {
        	        			obj.campaignIds = campaignArray;
        	        		}
        	        	}
        	            
        	            var campaignArray = []
        	            if(!isNullOrEmpty(formValues.campaigns)){
        	        		if(typeof formValues.campaigns == "object"){
        	            		Ext.each(formValues.campaigns, function(campaigns){
        	                        if(!isNullOrEmpty(campaigns)){
        	                        	campaignArray.push(campaigns.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			campaignArray.push(formValues.campaigns);
        	        		}
        	        		if(!isNullOrEmpty(campaignArray) && campaignArray.length>0 && !isNullOrEmpty(campaignArray[0])) {
        	        			obj.othercampaignId = campaignArray;
        	        		}
        	        	}
        	            if(!isNullOrEmpty(formValues.enquiryStatus)) {
        	            	obj.enquiryStatus= formValues.enquiryStatus;
        	            }
        	            var priorityArray = [];
        	            if(!isNullOrEmpty(formValues.priority)){
        	        		if(typeof formValues.priority == "object"){
        	            		Ext.each(formValues.priority, function(priority){
        	                        if(!isNullOrEmpty(priority)){
        	                        	priorityArray.push(priority.data.id);
        	                        }
        	                    });
        	        		} else{
        	        			priorityArray.push(formValues.priority);
        	        		}
        	        		if(!isNullOrEmpty(priorityArray) && priorityArray.length>0 && !isNullOrEmpty(priorityArray[0])) {
        	        			obj.enquiryPriority = priorityArray;
        	        		}
        	        	}
        		    	return Ext.encode(obj);	
        		    },
        		    disableEditAndDeleteButton:function(column,selected) {
    					var grid = this.getTracknonadmissionenquirygrid();
    			    	var deleteButtonItemId = grid.down('#searchResultGridBtnDelete');
    			    	var editButtonItemId = grid.down('#searchResultGridBtnEdit');
    					var popiaflag = false;
    			       	var enquiryPopiaStatusStore=Ext.getStore('common.EnquiryPopiaStatusDropdownValue');
    			       	if(enquiryPopiaStatusStore.data.items.length>0) {
    			       		var popiaValue=enquiryPopiaStatusStore.data.items[0].data.value;
    			       		var popiaCode=enquiryPopiaStatusStore.data.items[0].data.code;
	    			       	if(popiaValue!=null && popiaValue=='Yes' && popiaCode!=null && popiaCode=='Enquiry') {
	    			       		if(!isNullOrEmpty(selected) && selected.length>0) {
		    			       		for(var itemCount=0;itemCount<selected.length; itemCount++){
		    			       			var PopiaStatus=selected[itemCount].getData().POPIA_STATUS;
		    			       			if(!isNullOrEmpty(PopiaStatus)){
		    			       				if(PopiaStatus=='Opt-Out'){
		    			       					popiaflag=true;
		    			       					break;
		    			       				}
		    			       			}
		    			       		}
		    			       		if(popiaflag == true){
	    			       				deleteButtonItemId.setDisabled(true);
	    			       				editButtonItemId.setDisabled(true);
	    			       			}
	    			       			else{
	    			       				deleteButtonItemId.setDisabled(false);
		    			       			editButtonItemId.setDisabled(false);
	    			       			}
	    			       		} else {
	    			       			deleteButtonItemId.setDisabled(false);
	    			       			editButtonItemId.setDisabled(false);
	    			       		}
	    			       	} else {
	    			       		deleteButtonItemId.setDisabled(false);
    			       			editButtonItemId.setDisabled(false);
	    			       	}
    			       	} else {
    			       		deleteButtonItemId.setDisabled(false);
			       			editButtonItemId.setDisabled(false);
    			       	}
        		    },
});