/**
 * This controller is used for the Event Meeting Minutes Add/Edit/Delete/View
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.eventmeetingminutes.EventMeetingMinutesController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['eventmeetingminutes.EventMeetingMinutesParticipantStore',
        'eventmeetingminutes.EventMeetingMinutesTaskTypeStore',
        'eventmeetingminutes.EventMeetingMinutesStatusStore',
        'eventmeetingminutes.EventMeetingMinutesTaskStore',
        'eventmeetingminutes.EventMeetingMinutesStore',
        'eventmeetingminutes.EventMeetingMinutesDocumentStore',
        'eventmeetingminutes.EventMeetingMinutesDateTypeStore',
        'eventmeetingminutes.EMMMinuteReportsEventNameStore',
        'eventmeetingminutes.EMMMinuteReportsStore',
        'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkStore',
        'eventmeetingminutes.EMMPreviousMinuteStore',
        'eventmeetingminutes.EMMForwardedTaskHistoryStore',
        'attendance.UserGroup',
        'hostel.roomallocation.UserSmartSearchByUserType'
    ],
    views: ['eventmeetingminutes.EventMeetingMinutesStructure',
        'eventmeetingminutes.EventMeetingMinutesTabStructure',
        'eventmeetingminutes.EventMeetingMinutesGrid',
        'eventmeetingminutes.EventMeetingMinutesForm',
        'eventmeetingminutes.EMMViewParticipantWin',
        'eventmeetingminutes.EMMViewParticipantGrid',
        'eventmeetingminutes.EventMeetingMinutesTaskGrid',
        'eventmeetingminutes.EventMeetingMinutesDocumentGrid',
        'eventmeetingminutes.EMMMinuteReportsStructure',
        'eventmeetingminutes.EMMMinuteReportsTabStructure',
        'eventmeetingminutes.EMMMinuteReportsGrid',
        'eventmeetingminutes.EMMMinuteReportsFilter',
        'eventmeetingminutes.facultyPortal.EMMEUpdateTaskStatusWin',
        'dashboard.dashlets.EMMEmployeeTaskAssignedDashlet',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkWin',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkGrid',
        'eventmeetingminutes.EMMForwardedTaskHistoryWin',
        'eventmeetingminutes.EMMForwardedTaskHistoryGrid',
        'eventmeetingminutes.EventMeetingMinutesDocumentWin'
    ],
    models: ['eventmeetingminutes.EventMeetingMinutesModel',
        'eventmeetingminutes.EventMeetingMinutesTaskModel'
    ],
    requires: ['Academia.utilities.reader.EventMeetingMinuteCustomArrayReader'],
    config: {
        EVENT_MEETING_MINUTES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVENT_MEETING_MINUTES_PRIVILEGES'),
        EVENT_MINUTE_REPORTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVENT_MINUTE_REPORTS_PRIVILEGES'),
    },
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'resourceBookingGrid',
        selector: 'resourcebooking searchresultgrid[itemId=resourceBookingGrid]'
    }, {
        ref: 'eventmeetingminutesform',
        selector: 'eventmeetingminutesform'
    }, {
        ref: 'eventmeetingminutestabstructure',
        selector: 'eventmeetingminutestabstructure'
    }, {
        ref: 'emmviewparticipantwin',
        selector: 'emmviewparticipantwin'
    }, {
        ref: 'emmviewparticipantgrid',
        selector: 'emmviewparticipantgrid'
    }, {
        ref: 'eventmeetingminutestaskgrid',
        selector: 'eventmeetingminutestaskgrid'
    }, {
        ref: 'eventmeetingminutesgrid',
        selector: 'eventmeetingminutesgrid'
    }, {
        ref: 'eventmeetingminutesdocumentgrid',
        selector: 'eventmeetingminutesdocumentgrid'
    }, {
        ref: 'emmminutereportsfilter',
        selector: 'emmminutereportsfilter'
    }, {
        ref: 'emmminutereportsgrid',
        selector: 'emmminutereportsgrid'
    }, {
        ref: 'emmeupdatetaskstatuswin',
        selector: 'emmeupdatetaskstatuswin'
    }, {
        ref: 'emmemployeetaskassigneddashlet',
        selector: 'emmemployeetaskassigneddashlet'
    }, {
        ref: 'eventmeetingminutestaskremarkwin',
        selector: 'eventmeetingminutestaskremarkwin'
    }, {
        ref: 'eventmeetingminutestaskremarkgrid',
        selector: 'eventmeetingminutestaskremarkgrid'
    }, {
        ref: 'emmforwardedtaskhistorywin',
        selector: 'emmforwardedtaskhistorywin'
    }, {
        ref: 'emmforwardedtaskhistorygrid',
        selector: 'emmforwardedtaskhistorygrid'
    }, {
        ref: 'eventmeetingminutesdocumentwin',
        selector: 'eventmeetingminutesdocumentwin'
    }],
    init: function() {
        this.control({
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=manageMinutesButtonItemId]': {
                click: this.openManageMinutesTab
            },
            'eventmeetingminutesgrid button[itemId=btnAdd]': {
                click: function() {
                    this.openAddMinutesTab('ADD');
                }
            },
            'eventmeetingminutesgrid button[itemId=btnEdit]': {
                click: function() {
                    this.openEditMinutesTab('EDIT');
                }
            },
            'eventmeetingminutesgrid button[itemId=btnView]': {
                click: function() {
                    this.openViewMinutesTab();
                }
            },
            'eventmeetingminutesgrid button[itemId=btnDelete]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getEventmeetingminutesgrid();
                    var serverURL = SERVERURL.EMM_EVENT_MEETING_MINUTES_DELETE;
                    if (grid.getSelectionModel().getCount() > 0) {
                        showConfirmMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                            if (btn == 'yes') {
                                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                var records = grid.getSelectionModel().getSelection();
                                var id = records[0].get("id");
                                Ext.Ajax.request({
                                    method: "DELETE",
                                    type: 'rest',
                                    url: serverURL + '?id=' + id,
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    success: function(form, action) {
                                        if (form.responseText != 0) {
                                            Ext.getBody().unmask();
                                            grid.getStore().reload();
                                            showSuccessMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('FD_MANAGEMENT_ITEMS_DELETED_SUCCESSFULLY'));
                                        } else {
                                            Ext.getBody().unmask();
                                            showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_MEETING_MINUTES_CANNOT_BE_DELETED_DUE_TO_DEPENDENCIES'));
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
                    }
                }
            },
            'eventmeetingminutesform button[itemId=saveEventmeetingminutesformItemId]': {
                click: this.saveEventMeetingMinutes
            },
            'eventmeetingminutesform button[itemId=importEventmeetingminutesformItemId]': {
                click: this.importEventMeetingMinutesTask
            },
            'eventmeetingminutesform button[itemId=viewParticipantsEventmeetingminutesformItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getEmmviewparticipantwin();
                    if (!formWindow) {
                        Ext.widget('emmviewparticipantwin');
                        formWindow = $this.getEmmviewparticipantwin();
                    }
                    formWindow.show();
                    var form = $this.getEventmeetingminutesform();
                    var eventIdItemId = form.down('#eventIdItemId');

                    var grid = $this.getEmmviewparticipantgrid();
                    grid.getStore().getProxy().extraParams = {
                        resourceBookingId: eventIdItemId.getValue(),
                    };
                    grid.getStore().load();
                }
            },
            'eventmeetingminutestaskgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getEventmeetingminutestaskgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                        if (columnName == "addButton") {
                            if (e.target.className == "addButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    var serialNo;
                                    if (grid.getStore() != null)
                                        serialNo = grid.getStore().getCount();
                                    this.addNewRowInTaskGrid(serialNo + 1);
                                }
                            }
                        } else if (columnName == "deleteButton") {
                            if (e.target.className == "deleteButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    if (grid.getStore().getRange().length > 1) {
                                        //grid.getStore().remove(grid.getSelectionModel().getSelection()[0]);
                                        grid.getStore().removeAt(rowIndex);
                                        var models = grid.getStore().getRange();
                                        for (var i = 0; i < models.length; i++) {
                                            models[i].data.serialNo = i + 1;
                                        }
                                        grid.getStore().loadRawData(models, true);
                                    }
                                }
                            }
                        }
                    }

                    if (e.target.tagName == 'A') {
                        if (columnName == 'showViewLink') {
                            if (!isNullOrEmpty(record.data.id)) {
                                var formWindow = $this.getEventmeetingminutestaskremarkwin();
                                if (!formWindow) {
                                    Ext.widget('eventmeetingminutestaskremarkwin');
                                    formWindow = $this.getEventmeetingminutestaskremarkwin();
                                }
                                var remarkGrid = $this.getEventmeetingminutestaskremarkgrid();
                                var remarkStore = remarkGrid.getStore();
                                remarkStore.getProxy().extraParams = {
                                    eventMeetingMinutesTaskId: record.data.id
                                };
                                remarkStore.load({
                                    callback: function(records, operation, success) {
                                        if (records.length > 0) {
                                            formWindow.show();
                                        } else {
                                            showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'),
                                                getServiceRequestTranslation('EMM_NO_REMARK_AVAILABLE'));
                                        }
                                    }
                                });
                            }
                        } else if (columnName == 'status') {
                            if (!isNullOrEmpty(record.data.id)) {
                                var formWindow = $this.getEmmforwardedtaskhistorywin();
                                if (!formWindow) {
                                    Ext.widget('emmforwardedtaskhistorywin');
                                    formWindow = $this.getEmmforwardedtaskhistorywin();
                                }
                                formWindow.show();
                                var taskGrid = $this.getEmmforwardedtaskhistorygrid();
                                taskGrid.getStore().getProxy().extraParams = {
                                    eventMeetingMinutesTaskId: record.data.id
                                };
                                taskGrid.getStore().load();
                            }
                        }
                    }
                }
            },
            'eventmeetingminutesform button#eventmeetingminuteDocumentUploadId': {
                click: function() {
                    this.getDocumentController().showDocumentFormWindow('eventmeetingminutesformItemId', 'DOCUMENT');
                }
            },
            'documentformwindow[itemId=eventmeetingminutesformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: function() {
                    var $this = this;
                    var isTransient = true;
                    var module = 'toolnservice';
                    var entityId;
                    var entityType = 'minutedocument';
                    var documentGrid = $this.getEventmeetingminutesdocumentgrid();

                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.fdmanagement.FDManagementDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("documentName", response.name);
                        documentModel.set("isNewRecord", true);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

                        var store = documentGrid.getStore();
                        store.add(documentModel);
                        documentGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
                        if (documentGrid.isHidden() && store.data.items.length > 0) {
                            documentGrid.setVisible(true);
                        }
                        Ext.apply(documentGrid, {
                            code: null,
                            setCode: function(code) {
                                documentGrid.code = code;
                            },
                            getCode: function() {
                                return documentGrid.code;
                            }
                        });
                        documentGrid.setCode(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'documentformwindow[itemId=eventmeetingminutesformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
                click: function() {
                    this.getDocumentController().closeDocumentFormWindow();
                }
            },
            'eventmeetingminutesdocumentgrid button#btnDelete': {
                click: function() {
                    var $this = this;
                    var grid = $this.getEventmeetingminutesdocumentgrid();
                    var serverURL = SERVERURL.EMM_FIND_EVENT_MEETING_MINUTES_DOCUMENT_DELETE;
                    if (grid.getSelectionModel().getCount() > 0) {
                        showConfirmMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                            if (btn == 'yes') {
                                var store = grid.getStore();
                                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                var record = grid.getSelectionModel().getSelection()[0];
                                var id = record.get("id");
                                if (!isNullOrEmpty(id)) {
                                    Ext.Ajax.request({
                                        method: "DELETE",
                                        type: 'rest',
                                        url: serverURL + '?id=' + id,
                                        headers: {
                                            'Content-Type': 'application/json'
                                        },
                                        success: function(form, action) {
                                            Ext.getBody().unmask();
                                            store.reload();
                                            showSuccessMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('FD_ITEM_ENTRY_DOCUMENT_SUCCESS_DELETE_MSG'));
                                        }
                                    });
                                } else {
                                    if (record) {
                                        store.remove(record);
                                    }
                                    Ext.getBody().unmask();
                                }
                            }
                        });
                    } else {
                        showWarningMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'eventmeetingminutesdocumentgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getEventmeetingminutesdocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'emmminutereportsfilter button[itemId=searchBtnEmmminutereportsfilterItemId]': {
                click: function() {
                    this.loadEMMMinuteReportsGrid();
                },
                afterrender: function(obj, value) {
                    var form = obj.up('form');
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'emmeupdatetaskstatuswin button[itemId=saveEmmeupdatetaskstatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getEmmeupdatetaskstatuswin();

                    var form = formWindow.down('#emmeUpdateTaskStatusFormItemId');
                    var formValues = form.getValues();
                    var id = formValues.id;
                    var taskStatus = formValues.taskStatus;
                    var ownerRemark = formValues.ownerRemark;

                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.EMM_EMPLOYEE_PORTAL_DASHLET_UPDATE_TASK_STATUS,
                        jsonData: {
                            id: id,
                            status: taskStatus,
                            ownerRemark: ownerRemark
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            Ext.getBody().unmask();
                            $this.getEmmemployeetaskassigneddashlet().loadDashlet();
                            formWindow.close();
                        }
                    });
                }
            },
            'emmeupdatetaskstatuswin button[itemId=cancelEmmeupdatetaskstatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getEmmeupdatetaskstatuswin();
                    formWindow.close();
                }
            },
            'eventmeetingminutesgrid button[itemId=exportMeetingofMinutes]': {
                click: function() {
                    var $this = this;
                    var eventmeetingminutesform = $this.getEventmeetingminutesform();
                    var form = eventmeetingminutesform;
                    var grid = $this.getEventmeetingminutesgrid();

                    if (grid.getSelectionModel().getCount() > 0) {
                        var record = grid.getSelectionModel().getSelection()[0];
                        var reportParams = new Object();
                        var reportTitle = 'Minutes Of Meeting Report';
                        var code = 'EVENT_MEETING_MINUTE_REPORT';
                        var minuteId = record.data.id;

                        reportParams.code = code;
                        reportParams.reportTitle = reportTitle;

                        reportParams.minuteId = minuteId;

                        $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.EMM_EXPORT_EVENT_MEETING_MINUTE_REPORT);
                    } else {
                        showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=printAttendanceSheetItemId]': {
                click: function() {
                    var $this = this;
                    var eventmeetingminutesform = $this.getEventmeetingminutesform();

                    var grid = $this.getResourceBookingGrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        if (records != "" && records != null && records != undefined) {
                            var reportParams = new Object();
                            var reportTitle = 'Meeting Of Minutes Attendance Sheet';
                            var code = 'EVENT_MEETING_MINUTE_ATTENDANCE_SHEET';
                            var eventId = records[0].data.ID;
                            reportParams.code = code;
                            reportParams.reportTitle = reportTitle;

                            reportParams.eventId = eventId;

                            $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.EMM_EXPORT_MEETING_OF_MINUTE_ATTENDANCE_SHEET);
                        }
                    } else {
                        showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'eventmeetingminutesgrid': {
                beforerender: function() {
                    this.getStore('eventmeetingminutes.EventMeetingMinutesStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getEVENT_MEETING_MINUTES_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getEVENT_MEETING_MINUTES_PERMISSIONS());
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getEventmeetingminutesgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                    if (e.target.tagName == 'A') {
                        if (columnName == 'eventMeetingMinutesDocuments') {
                            var formWindow = $this.getEventmeetingminutesdocumentwin();
                            if (!formWindow) {
                                Ext.widget('eventmeetingminutesdocumentwin');
                                formWindow = $this.getEventmeetingminutesdocumentwin();
                            }
                            formWindow.show();
                            var documentGrid = $this.getEventmeetingminutesdocumentgrid();
                            documentGrid.getStore().getProxy().extraParams = {
                                eventMeetingMinutesId: record.data.id
                            };
                            documentGrid.down('#btnDelete').setVisible(false);
                            documentGrid.getStore().load();
                        }
                    }
                }
            },
            'emmminutereportsgrid': {
                beforerender: function() {
                    this.getStore('eventmeetingminutes.EMMMinuteReportsStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getEVENT_MINUTE_REPORTS_PERMISSIONS());
                }
            },
            'eventmeetingminutesform button[itemId=resetEventmeetingminutesformItemId]': {
                click: function() {
                    this.resetEventMeetingMinutesForm();
                }
            },
            'emmminutereportsfilter button[itemId=resetEmmminutereportsfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getEmmminutereportsfilter();
                    form.getForm().reset();
                    var ownerIdItemId = form.down("#ownerIdItemId");
                    ownerIdItemId.setDisabled(true);
                    ownerIdItemId.reset();

                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'eventmeetingminutesform checkboxfield#importPreviousMeetingMinutesItemId': {
                change: function(obj, newValue, oldValue, eOpts) {
                    var form = obj.up('eventmeetingminutesform');
                    var previousMinuteIdItemId = form.down("#previousMinuteIdItemId");
                    var importEventmeetingminutesformItemId = form.down("#importEventmeetingminutesformItemId");

                    if (newValue) {
                        previousMinuteIdItemId.setDisabled(false);
                        importEventmeetingminutesformItemId.setDisabled(false);
                    } else {
                        previousMinuteIdItemId.setDisabled(true);
                        importEventmeetingminutesformItemId.setDisabled(true);
                    }
                    previousMinuteIdItemId.reset();
                }
            },
            'eventmeetingminutesform textfield#minuteSubjectItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getEventmeetingminutesform();
                        var eventId = form.down('#eventIdItemId').getValue();
                        var grid = this.getEventmeetingminutesgrid();
                        var submitUrl = SERVERURL.EMM_EVENT_MEETING_MINUTES_UNIQUE_MINUTE_SUBJECT + '?minuteSubject=' + data + '&eventId=' + eventId+ '&moduleName=MOM';
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                    if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.minuteSubject != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('EMM_DUPLICATE_MINUTE_SUBJECT'));
                                            form.down("#minuteSubjectItemId").setValue(grid.getSelectionModel().getSelection()[0].data.minuteSubject);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('EMM_DUPLICATE_MINUTE_SUBJECT'));
                                        form.down("#minuteSubjectItemId").reset();
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'emmminutereportsfilter customcombobox[itemId=userTypeItemId]': {
                select: function(obj, rec) {
                    var $this = this;
                    var form = $this.getEmmminutereportsfilter();
                    form.down('#ownerIdItemId').setDisabled(false);
                    var ownerIdStore = form.down('#ownerIdItemId').getStore();

                    var academyLocationId = $this.getCurrentAcademyLocation();
                    var alids = [];
                    alids.push(academyLocationId);
                    ownerIdStore.getProxy().extraParams = {
                        userType: rec[0].data.id,
                        academyLocationIds: alids.join()
                    };
                    ownerIdStore.load();
                }
            },
        });
    },
    /** Open tab for show Event Manage Minutes Grid */
    openManageMinutesTab: function() {
        var $this = this;
        var contentpanel = this.getContentpanel();
        var eventmeetingminutesstructure = Ext.widget('eventmeetingminutesstructure');
        //eventmeetingminutesstructure.setTitle(getServiceRequestTranslation('EMM_MANAGE_MINUTES'));
        var tabName = getServiceRequestTranslation('EMM_MANAGE_MINUTES');
        /**
         * This is to remove tab from content panel and open same tab again
         */
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getTab = getcontroller.getTab(getServiceRequestTranslation('EMM_MANAGE_MINUTES'));
        if (getTab != null) {
            contentPanel.remove(getTab, true);
        }
        openTab(contentpanel, tabName, eventmeetingminutesstructure, CONSTANTS.MENU_COLOR_NINE);

        var grid = $this.getResourceBookingGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formData = records[0].data;
                var form = $this.getEventmeetingminutestabstructure();

                var eventIdItemId = form.down('#eventIdItemId');
                var eventNameItemId = form.down('#eventNameItemId');
                var bookedByItemId = form.down('#bookedByItemId');

                eventIdItemId.setValue(formData.ID);
                eventNameItemId.setValue(formData.EVENT_NAME);
                bookedByItemId.setValue(formData.BOOKED_BY_PRINT_NAME);
                $this.loadManageMinutesGrid();
            }
        }
    },
    /** Open tab for Add Event Manage Minutes */
    openAddMinutesTab: function(openView) {
        var $this = this;
        var contentpanel = this.getContentpanel();
        var eventmeetingminutesform = Ext.widget('eventmeetingminutesform');
        eventmeetingminutesform.setTitle(getServiceRequestTranslation('EMM_ADD_MINUTES'));
        if (openView == 'ADD') {
            eventmeetingminutesform.setTitle(getServiceRequestTranslation('EMM_ADD_MINUTES'));
            var tabName = getServiceRequestTranslation('EMM_ADD_MINUTES');
        } else if (openView == 'EDIT') {
            eventmeetingminutesform.setTitle(getServiceRequestTranslation('EMM_EDIT_MINUTES'));
            var tabName = getServiceRequestTranslation('EMM_EDIT_MINUTES');
        } else if (openView == 'VIEW') {
            eventmeetingminutesform.setTitle(getServiceRequestTranslation('EMM_VIEW_MINUTES'));
            var tabName = getServiceRequestTranslation('EMM_VIEW_MINUTES');
        }
        /**
         * This is to remove tab from content panel and open same tab again
         */
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getAddTab = getcontroller.getTab(getServiceRequestTranslation('EMM_ADD_MINUTES'));
        var getEditTab = getcontroller.getTab(getServiceRequestTranslation('EMM_EDIT_MINUTES'));
        var getViewTab = getcontroller.getTab(getServiceRequestTranslation('EMM_VIEW_MINUTES'));
        if (getAddTab != null) {
            contentPanel.remove(getAddTab, true);
        }
        if (getEditTab != null) {
            contentPanel.remove(getEditTab, true);
        }
        if (getViewTab != null) {
            contentPanel.remove(getViewTab, true);
        }
        openTab(contentpanel, tabName, eventmeetingminutesform, CONSTANTS.MENU_COLOR_NINE);

        var structure = $this.getEventmeetingminutestabstructure();
        var eventIdItemIdStructure = structure.down('#eventIdItemId');
        var eventNameItemIdStructure = structure.down('#eventNameItemId');
        var bookedByItemIdStructure = structure.down('#bookedByItemId');

        var form = $this.getEventmeetingminutesform();
        var eventIdItemId = form.down('#eventIdItemId');
        var eventNameItemId = form.down('#eventNameItemId');
        var bookedByItemId = form.down('#bookedByItemId');

        eventIdItemId.setValue(eventIdItemIdStructure.getValue());
        eventNameItemId.setValue(eventNameItemIdStructure.getValue());
        bookedByItemId.setValue(bookedByItemIdStructure.getValue());

        var taskGrid = $this.getEventmeetingminutestaskgrid();
        taskGrid.getStore().removeAll();
        taskGrid.getStore().loadRawData([]);

        var docStore = this.getEventmeetingminutesdocumentgrid().getStore();
        docStore.removeAll();
        docStore.loadData([]);

        var viewParticipantGrid = $this.getEmmviewparticipantgrid();
        if (!viewParticipantGrid) {
            Ext.widget('emmviewparticipantgrid');
            viewParticipantGrid = $this.getEmmviewparticipantgrid();
        }
        viewParticipantGrid.getStore().getProxy().extraParams = {
            resourceBookingId: eventIdItemId.getValue(),
        };
        var viewParticipantArray = [];
        viewParticipantGrid.getStore().load({
            callback: function(records, operation, success) {
                for (var i in records) {
                    var data = records[i].data;
                    var newData = {
                        "id": data.id,
                        "printName": data.printName
                    };
                    viewParticipantArray.push(newData);
                }
                Ext.apply(taskGrid, {
                    viewParticipantList: null,
                    setViewParticipantList: function(viewParticipantList) {
                        taskGrid.viewParticipantList = viewParticipantList;
                    },
                    getViewParticipantList: function() {
                        return taskGrid.viewParticipantList;
                    }
                });
                taskGrid.setViewParticipantList(viewParticipantArray);
            }
        });

        if (openView == 'ADD') {
            var userId = this.getCurrentlyLoggedInUser();
            var minuteTakerIdItemId = form.down('#minuteTakerIdItemId');
            var minuteTakerStore = minuteTakerIdItemId.getStore();
            minuteTakerStore.getProxy().extraParams = {
                resourceBookingId: eventIdItemIdStructure.getValue(),
            };
            minuteTakerStore.load({
                callback: function(operation, success) {
                    if (success) {
                        minuteTakerIdItemId.setValue(userId.id);
                    }
                }
            });

            var previousMinuteIdItemId = form.down('#previousMinuteIdItemId');
            var previousMinuteStore = previousMinuteIdItemId.getStore();
            previousMinuteStore.getProxy().extraParams = {
                eventId: eventIdItemIdStructure.getValue()
            };
            previousMinuteStore.load();

            $this.addNewRowInTaskGrid(1);
        }
    },
    saveEventMeetingMinutes: function() {
        var $this = this;
        var eventmeetingminutesform = $this.getEventmeetingminutesform();
        var form = eventmeetingminutesform.getForm();
        var formValues = form.getValues();

        var eventMeetingMinutesModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesModel();
        eventMeetingMinutesModel.set("minuteDate", formValues.minuteDate);
        eventMeetingMinutesModel.set("minuteSubject", formValues.minuteSubject);

        var event = null;
        if (!isNullOrEmpty(formValues.eventId)) {
            event = {
                id: formValues.eventId
            };
        }
        eventMeetingMinutesModel.set("event", event);
        var minuteTaker = null;
        if (!isNullOrEmpty(formValues.minuteTakerId)) {
            minuteTaker = {
                id: formValues.minuteTakerId
            };
        }
        eventMeetingMinutesModel.set("minuteTaker", minuteTaker);

        var taskGrid = $this.getEventmeetingminutestaskgrid();
        var models = taskGrid.getStore().getRange();
        var myJson = new Array();
        for (var i = 0; i < models.length; i++) {
            if (!isNullOrEmpty(models[i].get('statusPrefillValue')) && models[i].get('statusPrefillValue') == 'PENDING') {
                var emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();
                var serialNo = models[i].get('serialNo');
                if (!isNullOrEmpty(models[i].get('id'))) {
                    emmTaskModel.set("id", models[i].get('id'));
                }
                if (!isNullOrEmpty(models[i].get('assignDate'))) {
                    var dateAssign = new Date(models[i].get('assignDate'));
                    emmTaskModel.set("assignDate", Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT));
                }
                if (!isNullOrEmpty(models[i].get('topic'))) {
                    emmTaskModel.set("topic", models[i].get('topic'));
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('EMM_TOPIC') + ' in ' + serialNo + ' Row.');
                    return false;
                }
                if (!isNullOrEmpty(models[i].get('type'))) {
                    emmTaskModel.set("type", models[i].get('type'));
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('EMM_TYPE') + ' in ' + serialNo + ' Row.');
                    return false;
                }
                if (!isNullOrEmpty(models[i].get('description'))) {
                    emmTaskModel.set("description", models[i].get('description'));
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('DESCRIPTION') + ' in ' + serialNo + ' Row.');
                    return false;
                }

                var owner = null;
                if (!isNullOrEmpty(models[i].get('ownerId'))) {
                    owner = {
                        id: models[i].get('ownerId')
                    };
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('EMM_OWNER') + ' in ' + serialNo + ' Row.');
                    return false;
                }
                emmTaskModel.set("owner", owner);

                if (!isNullOrEmpty(models[i].get('status'))) {
                    emmTaskModel.set("status", models[i].get('status'));
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('EMM_MINUTE_STATUS') + ' in ' + serialNo + ' Row.');
                    return false;
                }
                if (!isNullOrEmpty(models[i].get('dueDate'))) {
                    var dateDue = new Date(models[i].get('dueDate'));
                    emmTaskModel.set("dueDate", Ext.Date.format(dateDue, CONSTANTS.SUBMIT_DATE_FORMAT));
                } else {
                    showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                        getServiceRequestTranslation('DUE_DATE') + ' in ' + serialNo + ' Row.');
                    return false;
                }
                if (!isNullOrEmpty(models[i].get('completionDate'))) {
                    var dateCompletion = new Date(models[i].get('completionDate'));
                    emmTaskModel.set("completionDate", Ext.Date.format(dateCompletion, CONSTANTS.SUBMIT_DATE_FORMAT));
                }
                if (!isNullOrEmpty(models[i].get('noOfDaysOverdue'))) {
                    emmTaskModel.set("noOfDaysOverdue", models[i].get('noOfDaysOverdue'));
                }
                if (!isNullOrEmpty(models[i].get('parentTaskId'))) {
                    emmTaskModel.set("parentTaskId", models[i].get('parentTaskId'));
                }
                if (!isNullOrEmpty(models[i].get('forwardedDate'))) {
                    var forwardedDate = new Date(models[i].get('forwardedDate'));
                    emmTaskModel.set("forwardedDate", Ext.Date.format(forwardedDate, CONSTANTS.SUBMIT_DATE_FORMAT));
                }
                delete emmTaskModel.data.serialNo;
                delete emmTaskModel.data.ownerId;
                delete emmTaskModel.data.ownerPrefillId;
                delete emmTaskModel.data.isEditable;
                delete emmTaskModel.data.statusPrefillValue;
                delete emmTaskModel.data.dueDatePrefillValue;
                delete emmTaskModel.data.isAddDeleteRow;
                delete emmTaskModel.data.showViewLink;
                delete emmTaskModel.data.assignDatePrefillValue;

                myJson.push(emmTaskModel.data);
            }
        }
        eventMeetingMinutesModel.set("eventMeetingMinutesTasks", myJson);

        var documentGrid = $this.getEventmeetingminutesdocumentgrid();
        var docStore = documentGrid.getStore();
        var docArray = [];
        try {
            if (!isNullOrEmpty(documentGrid.getCode()) && documentGrid.getCode() != undefined) {
                docStore.add(documentGrid.getCode());
                if (docStore.data.items != null && docStore.data.items.length > 0) {
                    Ext.each(docStore.data.items, function(val) {
                        if (val.data.isNewRecord != undefined && val.data.isNewRecord) {
                            var newData = {
                                "name": val.data.documentName,
                                "path": val.data.path,
                                "type": "DOCUMENT",
                                "createdBy": $this.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                            };
                            var newData2 = {
                                "document": newData
                            };
                            docArray.push(newData2);
                        }
                    });
                }
                var arr = [];
                docStore.add(arr);
            }
        } catch (err) {

        }
        eventMeetingMinutesModel.set("eventMeetingMinutesDocuments", docArray);

        var message;
        var msg;
        var url;
        var tabName;

        if (isNullOrEmpty(formValues.id)) {
            message = getServiceRequestTranslation('EMM_MEETING_MINUTES_CREATED_SUCCESSFULLY');
            msg = getCommonTranslation('RECORD_ADD_SUCCESS');
            url = SERVERURL.EMM_EVENT_MEETING_MINUTES_SAVE;
            tabName = getServiceRequestTranslation('EMM_ADD_MINUTES');
        } else {
            eventMeetingMinutesModel.set("id", formValues.id);
            message = getServiceRequestTranslation('EMM_MEETING_MINUTES_UPDATED_SUCCESSFULLY');
            msg = getCommonTranslation('RECORD_UPDATE_SUCCESS');
            url = SERVERURL.EMM_EVENT_MEETING_MINUTES_UPDATE;
            tabName = getServiceRequestTranslation('EMM_EDIT_MINUTES');
        }
        delete eventMeetingMinutesModel.data.totalNoOfMinute;
        delete eventMeetingMinutesModel.data.totalNoOfPendingMinute;
        delete eventMeetingMinutesModel.data.totalNoOfForwardedMinute;
        delete eventMeetingMinutesModel.data.totalNoOfCompletedMinute;
        delete eventMeetingMinutesModel.data.minuteDateInOrgFormat;
        delete eventMeetingMinutesModel.data.showViewColumn;
        delete eventMeetingMinutesModel.data.minuteTakerName;
        
        var formData = Ext.encode(eventMeetingMinutesModel.data);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            jsonData: formData,
            method: 'POST',
            success: function(response, action) {
            	Ext.getBody().unmask();
            	var data = Ext.decode(response.responseText);
            	if (data.code == 'EXIST') {
            	    showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('EMM_DUPLICATE_MINUTE_SUBJECT'));
            	    eventmeetingminutesform.down("#minuteSubjectItemId").reset();
            	    eventmeetingminutesform.isValid();
            	} else {
            	    var contentpanel = $this.getContentpanel();
            	    var getcontroller = $this.getController('menu.CoreERPNavigationController');
            	    var getTab = getcontroller.getTab(tabName);
            	    if (getTab != null) {
            	        contentPanel.remove(getTab, true);
            	    }
            	    var grid = $this.getEventmeetingminutesgrid();
            	    var store = grid.getStore();
            	    if (store)
            	        $this.resetPageSetting(store);
            	    $this.loadManageMinutesGrid();
            	    showSuccessMessage(message, msg);
            	}
            }
        });
    },
    addNewRowInTaskGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getEventmeetingminutestaskgrid();
        var ObjModel = [];
        var emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();

        emmTaskModel.set("serialNo", serialNo);
        emmTaskModel.set("assignDate", new Date());
        emmTaskModel.set("topic", '');
        emmTaskModel.set("type", '');
        emmTaskModel.set("description", '');
        emmTaskModel.set("ownerId", '');
        emmTaskModel.set("status", 'PENDING');
        emmTaskModel.set("statusPrefillValue", 'PENDING');
        emmTaskModel.set("dueDate", '');
        emmTaskModel.set("completionDate", '');
        emmTaskModel.set("noOfDaysOverdue", '');
        emmTaskModel.set("isEditable", 'ADD');
        emmTaskModel.set("isAddDeleteRow", true);

        ObjModel.push(emmTaskModel);
        grid.getStore().loadRawData(ObjModel, true);
    },
    loadManageMinutesGrid: function() {
        var $this = this;
        var form = $this.getEventmeetingminutestabstructure();
        var grid = $this.getEventmeetingminutesgrid();
        var eventId = form.down("#eventIdItemId").getValue();

        var store = grid.getStore();
        store.getProxy().extraParams = {
            eventId: eventId,
            moduleName: 'MOM'
        };
        store.load();
        grid.getSelectionModel().deselectAll();
    },
    /** Open tab for Edit Event Manage Minutes */
    openEditMinutesTab: function(openView) {
        var $this = this;
        var grid = $this.getEventmeetingminutesgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            $this.openAddMinutesTab(openView);
            var submitUrl = SERVERURL.EMM_FIND_EVENT_MEETING_MINUTES_BY_ID;
            var record = grid.getSelectionModel().getSelection()[0];
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl + "?id=" + record.data.id,
                method: 'GET',
                success: function(response, action) {
                    Ext.getBody().unmask();
                    var data = Ext.decode(response.responseText);

                    var form = $this.getEventmeetingminutesform();
                    var idItemId = form.down('#idItemId');
                    var minuteTakerIdItemId = form.down('#minuteTakerIdItemId');
                    var minuteDateItemId = form.down('#minuteDateItemId');
                    var minuteSubjectItemId = form.down('#minuteSubjectItemId');

                    idItemId.setValue(data.id);
                    if (!isNullOrEmpty(data.minuteTaker) && !isNullOrEmpty(data.minuteTaker.id)) {
                        minuteTakerIdItemId.getStore().load({
                            callback: function(records, operation, success) {
                                minuteTakerIdItemId.setValue(data.minuteTaker.id);
                            }
                        });
                    }
                    minuteDateItemId.setValue(dateRender(data.minuteDate));
                    minuteSubjectItemId.setValue(data.minuteSubject);

                    if (!isNullOrEmpty(data.minuteTaker) && !isNullOrEmpty(data.minuteTaker.id)) {
                        minuteTakerIdItemId.getStore().load({
                            callback: function(records, operation, success) {
                                minuteTakerIdItemId.setValue(data.minuteTaker.id);
                            }
                        });
                    }
                    minuteDateItemId.setReadOnly(true);
                    minuteTakerIdItemId.setReadOnly(true);
                    minuteSubjectItemId.setReadOnly(true);
                    if (!isNullOrEmpty(data.eventMeetingMinutesTasks) && data.eventMeetingMinutesTasks.length > 0) {
                        var taskGrid = $this.getEventmeetingminutestaskgrid();
                        var ObjModel = [];
                        var emmTaskModel = null;

                        var models = data.eventMeetingMinutesTasks;
                        for (var i = 0; i < models.length; i++) {
                            emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();

                            emmTaskModel.set("id", models[i].id);
                            emmTaskModel.set("isAddDeleteRow", false);
                            if (!isNullOrEmpty(models[i].parentTaskId)) {
                                emmTaskModel.set("parentTaskId", models[i].parentTaskId);
                            }
                            emmTaskModel.set("serialNo", (i + 1));
                            if (openView == 'VIEW') {
                                emmTaskModel.set("isEditable", 'VIEW');
                            } else {
                                emmTaskModel.set("isEditable", 'EDIT');
                            }
                            if (!isNullOrEmpty(models[i].assignDate)) {
                                emmTaskModel.set("assignDate", models[i].assignDate);
                            }
                            if (!isNullOrEmpty(models[i].topic)) {
                                emmTaskModel.set("topic", models[i].topic);
                            }
                            if (!isNullOrEmpty(models[i].type)) {
                                emmTaskModel.set("type", models[i].type);
                            }
                            if (!isNullOrEmpty(models[i].description)) {
                                emmTaskModel.set("description", models[i].description);
                            }
                            if (!isNullOrEmpty(models[i].owner) && !isNullOrEmpty(models[i].owner.id)) {
                                emmTaskModel.set("ownerId", models[i].owner.id);
                            }
                            if (!isNullOrEmpty(models[i].status)) {
                                emmTaskModel.set("status", models[i].status);
                                emmTaskModel.set("statusPrefillValue", models[i].status);
                                if (openView == 'EDIT') {
                                    if ('COMPLETED' == models[i].status || 'FORWARDED' == models[i].status) {
                                        emmTaskModel.set("isEditable", 'VIEW');
                                    } else if ('PENDING' == models[i].status) {
                                        emmTaskModel.set("isEditable", 'EDIT');
                                    }
                                }
                            }
                            if (!isNullOrEmpty(models[i].dueDate)) {
                                emmTaskModel.set("dueDate", models[i].dueDate);
                                emmTaskModel.set("dueDatePrefillValue", models[i].dueDate);
                            }
                            if (!isNullOrEmpty(models[i].completionDate)) {
                                emmTaskModel.set("completionDate", models[i].completionDate);
                            }
                            if (!isNullOrEmpty(models[i].noOfDaysOverdue)) {
                                emmTaskModel.set("noOfDaysOverdue", models[i].noOfDaysOverdue);
                            }
                            if (!isNullOrEmpty(models[i].forwardedDate)) {
                                emmTaskModel.set("forwardedDate", models[i].forwardedDate);
                            }
                            if (!isNullOrEmpty(models[i].showViewLink)) {
                                emmTaskModel.set("showViewLink", models[i].showViewLink);
                            }
                            ObjModel.push(emmTaskModel);
                        }
                        taskGrid.getStore().loadRawData(ObjModel, true);
                    }
                    var documentGrid = $this.getEventmeetingminutesdocumentgrid();
                    var docStore = documentGrid.getStore();
                    docStore.getProxy().extraParams = {
                        eventMeetingMinutesId: data.id
                    };
                    docStore.load();
                    var resetButton = form.down('#resetEventmeetingminutesformItemId');
                    resetButton.setVisible(false);
                    var importButton = form.down('#importFieldContainerItemId');
                    importButton.setVisible(false);

                    var showViewColumn = data.showViewColumn;

                    var gridColumns;
                    if (!isNullOrEmpty(taskGrid)) {
                        gridColumns = taskGrid.columns;
                    }
                    for (i in gridColumns) {
                        var gridColumn = gridColumns[i];
                        if (gridColumn.dataIndex == "addButton") {
                            gridColumn.hide();
                        } else if (gridColumn.dataIndex == "deleteButton") {
                            gridColumn.hide();
                        } else if (showViewColumn && gridColumn.dataIndex == "showViewLink") {
                            gridColumn.show();
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    getDocumentController: function() {
        var this$ = this;
        return this$.getController('Academia.controller.document.DocumentController');
    },
    getIdValueJson: function(id, value) {
        if (id)
            return {
                id: id,
                value: value
            };
    },
    openViewMinutesTab: function() {
        var $this = this;
        $this.openEditMinutesTab('VIEW');
        var form = $this.getEventmeetingminutesform();
        var eventmeetingminutesform = form.getForm();
        this.toggleReadOnlyFormItems(eventmeetingminutesform, true);
        form.down('#saveEventmeetingminutesformItemId').setVisible(false);
        form.down('#resetEventmeetingminutesformItemId').setVisible(false);
        form.down('#eventmeetingminuteDocumentUploadId').setVisible(false);
        $this.getEventmeetingminutesdocumentgrid().down('#btnDelete').setVisible(false);
    },
    loadEMMMinuteReportsGrid: function() {
        var $this = this;
        var form = $this.getEmmminutereportsfilter();
        var grid = $this.getEmmminutereportsgrid();

        var userTypeId = form.down("#userTypeItemId").getValue();
        var ownerId = form.down("#ownerIdItemId").getValue();
        var eventId = form.down("#eventIdItemId").getValue();
        var dateType = form.down("#dateTypeItemId").getValue();
        var fromDate = form.getValues().fromDate;
        var toDate = form.getValues().toDate;
        var taskType = form.down("#taskTypeItemId").getValue();
        var taskStatus = form.down("#taskStatusItemId").getValue();

        var store = grid.getStore();
        store.getProxy().extraParams = {
        	userTypeId: userTypeId,
            ownerId: ownerId,
            eventId: eventId,
            dateType: dateType,
            fromDate: fromDate,
            toDate: toDate,
            taskType: taskType,
            taskStatus: taskStatus
        };
        store.load();
    },
    openEMMEUpdateTaskStatusWin: function(grid) {
        var $this = this;
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formWindow = $this.getEmmeupdatetaskstatuswin();
                if (!formWindow) {
                    Ext.widget('emmeupdatetaskstatuswin');
                    formWindow = $this.getEmmeupdatetaskstatuswin();
                }
                var formData = records[0].data;
                var form = formWindow.down('#emmeUpdateTaskStatusFormItemId');
                var idItemId = form.down('#idItemId');
                var taskStatusItemId = form.down('#taskStatusItemId');

                idItemId.setValue(formData.id);
                if (!isNullOrEmpty(formData.status)) {
                    taskStatusItemId.getStore().load({
                        callback: function(records, operation, success) {
                            taskStatusItemId.setValue(formData.status);
                        }
                    });
                }
            }
        }
        formWindow.show();
    },
    resetEventMeetingMinutesForm: function() {
        var $this = this;
        var form = this.getEventmeetingminutesform();
        //form.getForm().reset();
        var eventIdItemId = form.down("#eventIdItemId");
        var minuteTakerIdItemId = form.down("#minuteTakerIdItemId");
        var minuteDateItemId = form.down("#minuteDateItemId");
        var minuteSubjectItemId = form.down("#minuteSubjectItemId");
        var importPreviousMeetingMinutesItemId = form.down("#importPreviousMeetingMinutesItemId");
        var previousMinuteIdItemId = form.down("#previousMinuteIdItemId");

        minuteTakerIdItemId.reset();
        minuteDateItemId.setValue(new Date());
        minuteSubjectItemId.reset();
        importPreviousMeetingMinutesItemId.setValue(false);
        previousMinuteIdItemId.reset();

        var userId = this.getCurrentlyLoggedInUser();
        var minuteTakerStore = minuteTakerIdItemId.getStore();
        minuteTakerStore.getProxy().extraParams = {
            resourceBookingId: eventIdItemId.getValue(),
        };
        minuteTakerStore.load({
            callback: function(operation, success) {
                if (success) {
                    minuteTakerIdItemId.setValue(userId.id);
                }
            }
        });

        var grid = this.getEventmeetingminutestaskgrid();
        var store = grid.getStore();
        if (store)
            store.removeAll();
        $this.addNewRowInTaskGrid(1);

        var docGrid = $this.getEventmeetingminutesdocumentgrid();
        var docStore = docGrid.getStore();
        if (docStore)
            docStore.removeAll();
    },
    /** Disable More Action Privileges button */
    disableMoreActionPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var exportMeetingofMinutes = gridReference.down('#exportMeetingofMinutes');
        exportMeetingofMinutes.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'PRINT_MINUTE') {
                if (!isNullOrEmpty(exportMeetingofMinutes)) {
                    exportMeetingofMinutes.setVisible(true);
                }
            }
        });
    },
    importEventMeetingMinutesTask: function(openView) {
        var $this = this;
        var form = $this.getEventmeetingminutesform();
        var previousMinuteIdItemId = form.down('#previousMinuteIdItemId');
        var previousMinuteId = previousMinuteIdItemId.getValue();

        if (!isNullOrEmpty(previousMinuteId)) {
            var submitUrl = SERVERURL.EMM_FIND_ALL_PENDING_EVENT_MEETING_MINUTES_TASK_BY_MINUTE_ID;
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl + "?minuteId=" + previousMinuteId,
                method: 'GET',
                success: function(response, action) {
                    Ext.getBody().unmask();
                    var data = Ext.decode(response.responseText);
                    if (!isNullOrEmpty(data) && data.length > 0) {
                        var taskGrid = $this.getEventmeetingminutestaskgrid();
                        var ObjModel = [];
                        var emmTaskModel = null;
                        var currentGridTaskList = taskGrid.getStore().getRange();
                        var noOfOldTaskBeforeImport = currentGridTaskList.length;

                        var minuteTaskList = data;
                        for (var i = 0; i < minuteTaskList.length; i++) {
                            if (!$this.isDuplicateTaskImport(currentGridTaskList, minuteTaskList[i].id)) {
                                emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();

                                emmTaskModel.set("parentTaskId", minuteTaskList[i].id);
                                emmTaskModel.set("serialNo", (noOfOldTaskBeforeImport + i + 1));
                                emmTaskModel.set("isEditable", 'EDIT');
                                emmTaskModel.set("isAddDeleteRow", true);
                                if (!isNullOrEmpty(minuteTaskList[i].assignDate)) {
                                    emmTaskModel.set("assignDate", minuteTaskList[i].assignDate);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].topic)) {
                                    emmTaskModel.set("topic", minuteTaskList[i].topic);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].type)) {
                                    emmTaskModel.set("type", minuteTaskList[i].type);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].description)) {
                                    emmTaskModel.set("description", minuteTaskList[i].description);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].owner) && !isNullOrEmpty(minuteTaskList[i].owner.id)) {
                                    emmTaskModel.set("ownerId", minuteTaskList[i].owner.id);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].status)) {
                                    emmTaskModel.set("status", minuteTaskList[i].status);
                                    emmTaskModel.set("statusPrefillValue", minuteTaskList[i].status);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].dueDate)) {
                                    emmTaskModel.set("dueDate", minuteTaskList[i].dueDate);
                                    emmTaskModel.set("dueDatePrefillValue", minuteTaskList[i].dueDate);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].completionDate)) {
                                    emmTaskModel.set("completionDate", minuteTaskList[i].completionDate);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].noOfDaysOverdue)) {
                                    emmTaskModel.set("noOfDaysOverdue", minuteTaskList[i].noOfDaysOverdue);
                                }
                                if (!isNullOrEmpty(minuteTaskList[i].forwardedDate)) {
                                    emmTaskModel.set("forwardedDate", minuteTaskList[i].forwardedDate);
                                }
                                ObjModel.push(emmTaskModel);
                            }
                        }
                        taskGrid.getStore().loadRawData(ObjModel, true);
                    }
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    isDuplicateTaskImport: function(currentGridTaskList, importTaskId) {
        var flag = false;
        for (var i = 0; i < currentGridTaskList.length; i++) {
            if (!isNullOrEmpty(currentGridTaskList[i].data.parentTaskId) && currentGridTaskList[i].data.parentTaskId == importTaskId) {
                flag = true;
                break;
            }
        }
        return flag;
    },
    openEMMETaskReramkWin: function(grid) {
        var $this = this;
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formData = records[0].data;
                if (!isNullOrEmpty(formData.id)) {
                    var formWindow = $this.getEventmeetingminutestaskremarkwin();
                    if (!formWindow) {
                        Ext.widget('eventmeetingminutestaskremarkwin');
                        formWindow = $this.getEventmeetingminutestaskremarkwin();
                    }
                    formWindow.setTitle(getServiceRequestTranslation('EMM_VIEW_REMARK_HISTORY'));
                    var remarkGrid = $this.getEventmeetingminutestaskremarkgrid();
                    var remarkStore = remarkGrid.getStore();
                    remarkStore.getProxy().extraParams = {
                        eventMeetingMinutesTaskId: formData.id
                    };
                    remarkStore.load({
                        callback: function(records, operation, success) {
                            if (records.length > 0) {
                                formWindow.show();
                            } else {
                                showWarningMessage(getServiceRequestTranslation('EMM_MEETING_MINUTES'),
                                    getServiceRequestTranslation('EMM_NO_REMARK_AVAILABLE'));
                            }
                        }
                    });
                }
            }
        }
    },
});