/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.examination.RoomAndStaffAllocationController', {
    extend: 'Academia.controller.base.BaseController',
    alias: 'widget.roomAndStaffAllocationController',
    stores: [
        'common.AcademicTermStore',
        'examinationcenters.assessmentEvent.ManageAssessmentSchemeStore',
        'attendance.VariantMappedToSpecialGrade',
        'manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore',
        'examinationcenters.manageEvaluation.AssesmentEventStore',
        'examinationcenters.assessmentEvent.ManageAssessmentCoursesStore',
        'examinationcenters.assessmentEvent.ManageAssessmentStatusStore',
        'examinationcenters.assessmentEvent.AdministrativeByStore',
         'examinationcenters.preExamDetails.EvalPlanStore',
         'examinationcenters.assessmentEvent.AssessmentCoursesForRoomAllocationStore',
         'examinationcenters.assessmentEvent.EvaluationPlanSmartSearchStore',
         'examinationcenters.assessmentEvent.EvalPlanLevelRoomAllocationStore',
         'examinationcenters.preExamDetails.EvalPlanLevels',
         'examinationcenters.assessmentEvent.RoomAndStaffAllocationGridStore'
    ],
    views: [
        'examinationcenters.assessmentEvent.RoomAndStaffAllocationStructure',
        'examinationcenters.assessmentEvent.RoomAndStaffAllocationFilter',
        'examinationcenters.assessmentEvent.RoomAndStaffAllocationGrid'
    ],
    model: [
        'common.IdValueCodeDataModel',
        'examinationcenters.remark.EvaluationLevelByEvalPlanModel'
    ],
    requires: [],
    refs: [{
        ref: 'roomAndStaffAllocationFilter',
        selector: 'roomAndStaffAllocationFilter'
    }, {
        ref: 'roomAndStaffAllocationGrid',
        selector: 'roomAndStaffAllocationGrid'
    }],
    config: {
        ROOM_AND_STAFF_ALLOCATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ROOM_AND_STAFF_ALLOCATION_PRIVILEGE')
    },
    init: function () {
        this.control({
            'roomAndStaffAllocationFilter button[itemId=resetBtn]': {
                click: this.doResetRoomAndStaffAllocationFilter
            },
            'roomAndStaffAllocationGrid': {
                render: this.onRoomAndStaffAllocationGridRender,
                selectionchange: this.onGridSelectionChange
            },
            'roomAndStaffAllocationFilter customcombobox[itemId=academicTermRoomAndStaffAllocation]': {
            	change: this.onAcademicTermSelect
            },
            'roomAndStaffAllocationFilter multiselectcombofield[itemId=assesmentSchemeRoomAndStaffAllocation]': {
            	change: this.onSchemeSelect
            },
            'roomAndStaffAllocationFilter multiselectcombofield[itemId=courseItemIdRoomAndStaffAllocation]': {
            	change: this.onCourseSelect
            },
            'roomAndStaffAllocationFilter groupingcombobox[itemId=evaluationLevelRoomAndStaffAllocation]': {
            	select: this.onEvalLevelSelect
            },
            'roomAndStaffAllocationFilter button[itemId=roomAndStaffSearchId]':{
            	click:this.serachRoomAndStaffAllocation
            },
            'roomAndStaffAllocationGrid button[itemId=deleteBtnId]': {
                click: this.deleteNonConcessionAllocation
            },
            'roomAndStaffAllocationGrid button[itemId=mapStudentBtnId]': {
                click: this.mapStudents
            },
            'roomAndStaffAllocationStructure': {
            	afterrender: this.onStructureRender
            },
            'roomAndStaffAllocationFilter customcombobox[itemId=administrativeByRoomAndStaffAllocation]':{
            	select: this.onAdministrativeBySelect
            },
            'roomAndStaffAllocationGrid button[itemId=publishBtnId]': {
                click: this.publishTimetable
            },
            'roomAndStaffAllocationFilter datefield[itemId=fromDateRoomAndStaffAllocation]': {
            	change: this.onFromDateChange
            },
            'roomAndStaffAllocationFilter datefield[itemId=tillDateRoomAndStaffAllocation]': {
            	change: this.onTillDateChange
            }
        })
    },

    doResetRoomAndStaffAllocationFilter: function (btn) {
        btn.up('form').getForm().reset();
        var form = btn.up('form');
        var scheme = form.down('#assesmentSchemeRoomAndStaffAllocation');
    	scheme.disable();
    	scheme.clearValue();
    	
    	var course = form.down('#courseItemIdRoomAndStaffAllocation');
    	course.clearValue();
    	course.disable();
    	
    	var fromDate = form.down('#fromDateRoomAndStaffAllocation');
    	fromDate.disable();
    	
    	var toDate = form.down('#tillDateRoomAndStaffAllocation');
    	toDate.disable();
    	
    	/*var level = form.down('#evaluationLevelRoomAndStaffAllocation');
    	level.disable();*/
    	
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.clearValue();
    	event.disable();
    	
    	var academicTerm = form.down('#academicTermRoomAndStaffAllocation');
    	academicTerm.reset();
        academicTerm.disable();
    },

    onRoomAndStaffAllocationGridRender: function (grid) {
        grid.down('#deleteBtnId').setVisible(false);
        grid.down('#mapStudentBtnId').setVisible(false);
        grid.down('#publishBtnId').setVisible(false);
        grid.down('#btnExportToPDF').setVisible(false);
        grid.down('#btnExportToExcel').setVisible(false);
        var permissionsMap = this.getROOM_AND_STAFF_ALLOCATION_PERMISSION();
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        if (permissionList.indexOf('DELETE') != -1) {
            grid.down('#deleteBtnId').setVisible(true);
        }
        if (permissionList.indexOf('MAP_STUDENT') != -1) {
            grid.down('#mapStudentBtnId').setVisible(true);
        }
        if (permissionList.indexOf('PUBLISH_TIMETABLE') != -1) {
            grid.down('#publishBtnId').setVisible(true);
        }
        if (permissionList.indexOf('EXPORT') != -1) {
            grid.down('#btnExportToPDF').setVisible(true);
            grid.down('#btnExportToExcel').setVisible(true);
        }
        if(permissionList.indexOf('GRID_CONFIGURATION') != -1) {
        	var nonConcessionGridConfigBtnRunner = new Ext.util.TaskRunner();
        	var task = nonConcessionGridConfigBtnRunner.start({
        		run: function() {
        			var columnBtn = grid.getHeader().query('button[text='+getCommonTranslation('COLUMNS')+']')[0];
        			if(columnBtn) {
        				columnBtn.show();
        				nonConcessionGridConfigBtnRunner.destroy();
        			}
        		},
        		interval: 1000
        	});
        }
        var structure = grid.up('roomAndStaffAllocationStructure');
        this.getGridHeaderFreezeForConcessionNonConcession(grid, structure);
        grid.getStore().removeAll();
    },
    
    onAcademicTermSelect: function(cmp, record) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var scheme = form.down('#assesmentSchemeRoomAndStaffAllocation');
    	scheme.reset();
    	scheme.clearValue();
    	if(isNullOrEmpty(cmp.getValue())) {
    		return;
    	}
    	scheme.enable();
    	var schemeStore = scheme.getStore();
    	schemeStore.getProxy().extraParams = {
    		academicTermId:cmp.getValue(),
    		whetherDynamicScheme:true,
    		administrativeBy: vals.administrativeBy
    	};
    	schemeStore.load();
    	
    	var course = form.down('#courseItemIdRoomAndStaffAllocation');
    	course.reset();
    	course.clearValue();
    	course.disable();
    	
    	var fromDate = form.down('#fromDateRoomAndStaffAllocation');
    	fromDate.reset();
    	fromDate.disable();
    	
    	var toDate = form.down('#tillDateRoomAndStaffAllocation');
    	toDate.reset();
    	toDate.disable();
    	
    	/*var level = form.down('#evaluationLevelRoomAndStaffAllocation');
    	level.reset();
    	level.disable();*/
    	
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.disable();
    },
    
    onSchemeSelect: function(cmp, record) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var schemeIds = '';
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			schemeIds = vals.assesmentScheme;
		}
    	var academicTermRoomAndStaffAllocation = form.down('#academicTermRoomAndStaffAllocation'),
    	course = form.down('#courseItemIdRoomAndStaffAllocation');
    	course.reset();
    	course.clearValue();
    	course.enable();
    	var courseStore = course.getStore();
    	courseStore.getProxy().extraParams = {
    		evaluationPlanIds: schemeIds,
    		academicTermId:	academicTermRoomAndStaffAllocation.getValue(),
    		administrativeBy: vals.administrativeBy
    	};
    	courseStore.load();
    	
    	var fromDate = form.down('#fromDateRoomAndStaffAllocation');
    	fromDate.reset();
    	fromDate.enable();
    	
    	var toDate = form.down('#tillDateRoomAndStaffAllocation');
    	toDate.reset();
    	toDate.enable();
    	
    	/*var level = form.down('#evaluationLevelRoomAndStaffAllocation');
    	level.reset();
    	level.enable();
    	var levelStore = level.getStore();
    	levelStore.getProxy().extraParams = {
    		evaluationPlanId:cmp.getValue(),
    		administrativeBy: vals.administrativeBy
    	};
    	levelStore.load();*/
    	
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.enable();
    	var eventStore = event.getStore();
    	eventStore.getProxy().extraParams = {
    		academicTermId: vals.assessmentSchemeAcademicTerm,
    		evaluationPlanIds: schemeIds,
    		administrativeBy: vals.administrativeBy
    	};
    	eventStore.load();
    	
    	if(vals.assesmentScheme && vals.assesmentScheme.length == 0) {
        	course.disable();
        	event.disable();
        	fromDate.disable();
        	toDate.disable();
        }
    },
    
    onCourseSelect: function(cmp, record) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var fromDate = form.down('#fromDateRoomAndStaffAllocation');
    	fromDate.reset();
    	fromDate.enable();
    	
    	var toDate = form.down('#tillDateRoomAndStaffAllocation');
    	toDate.reset();
    	toDate.enable();
    	var academicTermRoomAndStaffAllocation = form.down('#academicTermRoomAndStaffAllocation');
    	var assesmentSchemeRoomAndStaffAllocation = form.down('#assesmentSchemeRoomAndStaffAllocation');
    	/*var level = form.down('#evaluationLevelRoomAndStaffAllocation');
    	level.reset();
    	level.enable();
    	var levelStore = level.getStore();
    	levelStore.getProxy().extraParams = {
    		academicTermId:academicTermRoomAndStaffAllocation.getValue(),
    		evaluationPlanId:assesmentSchemeRoomAndStaffAllocation.getValue(),
        	administrativeBy: vals.administrativeBy
    	};
    	levelStore.load();*/
    	var schemeIds = '';
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			schemeIds = vals.assesmentScheme;
		}
    	if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.enable();
    	var eventStore = event.getStore();
    	eventStore.getProxy().extraParams = {
    		evaluationPlanIds: schemeIds,
    		academicTermId:academicTermRoomAndStaffAllocation.getValue(),
    		administrativeBy: vals.administrativeBy,
    		courseIds: courseIds
    	};
    	eventStore.load();
    },
    
    onEvalLevelSelect: function(cmp, record) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	var administrativeByRoomAndStaffAllocation = form.down('#administrativeByRoomAndStaffAllocation');
    	var academicTermRoomAndStaffAllocation = form.down('#academicTermRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.enable();
    	var eventStore = event.getStore();
    	var levelOneId=null;
	    var levelTwoId=null;
	    var levelThreeId=null;
	    if(!isNullOrEmpty(record[0].data.code)){
		   if(record[0].data.code=="Assessment Method"){
			   levelThreeId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Sub Type"){
			   levelTwoId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Type"){
			   levelOneId=record[0].data.levelId;
		   }
	    }
	    if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
    	eventStore.getProxy().extraParams = {
    		evalPlanId:vals.assesmentScheme,
    		academicTermId:academicTermRoomAndStaffAllocation.getValue(),
			evaluationPlanLevelOneId: levelOneId,
			evaluationPlanLevelTwoId: levelTwoId,
			evaluationSequenceId: levelThreeId,
    		administrativeBy: vals.administrativeBy,
    		courseIds: courseIds
    	};
    	eventStore.load();
    },
    serachRoomAndStaffAllocation:function(btn){
    	btn.setDisabled(true);
    	var me = this,
    	form = me.getRoomAndStaffAllocationFilter(),
    	grid = me.getRoomAndStaffAllocationGrid(),
    	//record =form.down('#evaluationLevelRoomAndStaffAllocation').lastSelection,
    	val = form.getValues();
    	var schemeIds = '';
        if(val.assesmentScheme && val.assesmentScheme.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(val.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				schemeIds = val.assesmentScheme.join();
			}
		}else if(val.assesmentScheme){
			schemeIds = val.assesmentScheme;
		}
    	/*var levelOneId=null;
	    var levelTwoId=null;
	    var levelThreeId=null;
	    if(record && record[0] && !isNullOrEmpty(record[0].data.code)){
		   if(record[0].data.code=="Assessment Method"){
			   levelThreeId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Sub Type"){
			   levelTwoId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Type"){
			   levelOneId=record[0].data.levelId;
		   }
	    }*/
	    if(val.courseManageItem && val.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(val.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = val.courseManageItem.join();
			}
		}else if(val.courseManageItem){
			var courseIds = val.courseManageItem;
		}
	    
	    if(val.detailSequence && val.detailSequence.length > 0){
			try{
				var eventIds = Ext.Array.pluck(Ext.Array.pluck(val.detailSequence, 'data'), 'id').join();
			} catch(e) {
				var eventIds = val.detailSequence.join();
			}
		}else if(val.detailSequence){
			var eventIds = val.detailSequence;
		}
    	grid.getStore().getProxy().extraParams = {
    		academicTermId:val.assessmentSchemeAcademicTerm,
    		evaluationPlanIds: schemeIds,
    		courseIds:courseIds,
    		fromDate:val.fromdate,
    		toDate:val.tilldate,
    		administeredBy:val.administrativeBy,
    		//evaluationPlanLevelOneId: levelOneId,
			//evaluationPlanLevelTwoId: levelTwoId,
			//evaluationSequenceId: levelThreeId,
			eventIds:eventIds
    	};
    	//this.resetPageSetting(grid.getStore(), grid);
    	//grid.getStore().pageSize = 100;
    	grid.getStore().load();
    	Ext.defer(function() {
    		btn.setDisabled(false);
    	}, 1000);
    },
    
    deleteNonConcessionAllocation: function(btn) {
    	var grid = this.getRoomAndStaffAllocationGrid();
    	var selection = grid.getSelectionModel().getSelection();
    	var vals = this.getRoomAndStaffAllocationFilter().getValues();
    	var ids = [];
    	for(var i = 0; i < selection.length; i++) {
    		ids.push(selection[i].get('id'));
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_DELETE_NON_CONCESSION_ALLOCATION + "?ids=" + ids.join() + "&academicTermId=" + vals.assessmentSchemeAcademicTerm + "&administeredBy=" + vals.administrativeBy,
			method : 'DELETE',
			success : function(frm, action) {
				Ext.getBody().unmask();
				if(frm.responseText == 'false') {
					showWarningMessage(getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'), getExaminationTranslation('STUDENT_ALREADY_MAPPED'));
				}
				else {
					showSuccessMessage(getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
					grid.getStore().load();
				}
				grid.getSelectionModel().deselectAll();
			}
		});
    },
    
    onGridSelectionChange: function(sm, selected) {
    	var deleteBtn = sm.view.up('grid').down('#deleteBtnId');
    	var mapBtn = sm.view.up('grid').down('#mapStudentBtnId');
    	var publishBtn = sm.view.up('grid').down('#publishBtnId');
    	if(selected.length) {
    		deleteBtn.enable();
    		mapBtn.enable();
    		publishBtn.enable();
    	}
    	else {
    		deleteBtn.disable();
    		mapBtn.disable();
    		publishBtn.disable();
    	}
    },
    
    mapStudents: function(btn) {
    	var grid = this.getRoomAndStaffAllocationGrid();
    	var selection = grid.getSelectionModel().getSelection();
    	var vals = this.getRoomAndStaffAllocationFilter().getValues();
    	var data = [];
    	for(var i = 0; i < selection.length; i++) {
    		data.push({
    			courseId: selection[i].get('courseId'),
    			courseResourceMappingId: selection[i].get('courseResourceMappingId'),
    			eventId: selection[i].get('eventId'),
    			academicTermId: vals.assessmentSchemeAcademicTerm,
    			studntRoomAllocation: selection[i].get('studntRoomAllocation'),
    			date: selection[i].get('date'),
    			time: selection[i].get('time'),
    			mappedCount: selection[i].get('mappedCount'),
    			eventMappedStudent : selection[i].get('eventMappedStudent'),
    		});
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_NON_CONCESSION_STUDENT_MAPPING,
			jsonData: data,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'), getExaminationTranslation('MAPPING_IN_PROGRESS'));
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
			}
		});
    },
    
    onStructureRender: function(structure) {
		Ext.defer(function() {
			try {
    			structure.body.on('scroll', function() {
					if(Ext.query('.x-boundlist:visible').length) {
						var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
						if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse){
							boundListCombo.collapse();
						}
					}
				});
			}
			catch(e) {}
		}, 1000);
	},
	
	onAdministrativeBySelect: function(cmp, rec) {
		var form = cmp.up('form');
        var scheme = form.down('#assesmentSchemeRoomAndStaffAllocation');
        scheme.reset();
        scheme.clearValue();
    	scheme.disable();
    	
    	var course = form.down('#courseItemIdRoomAndStaffAllocation');
    	course.clearValue();
    	course.disable();
    	
    	var fromDate = form.down('#fromDateRoomAndStaffAllocation');
    	fromDate.disable();
    	
    	var toDate = form.down('#tillDateRoomAndStaffAllocation');
    	toDate.disable();
    	
    	/*var level = form.down('#evaluationLevelRoomAndStaffAllocation');
    	level.disable();*/
    	
    	var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.clearValue();
    	event.disable();
    	
    	var academicTerm = form.down('#academicTermRoomAndStaffAllocation');
    	academicTerm.reset();
    	academicTerm.enable();
    	academicTerm.getStore().load({
		    callback: function(records, operation, success) {
		    	records.forEach(function(rec){
		    		if(rec.data.whetherCurrentAcademicTerm){
		    			academicTerm.setValue(rec.data.id);
		    		}
		    	});
		    }
		});
	},
	
	publishTimetable: function(btn) {
		var grid = btn.up('grid');
		var selection = grid.getSelectionModel().getSelection();
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var vals = this.getRoomAndStaffAllocationFilter().getValues();
    	var data = [];
    	for(var i = 0; i < selection.length; i++) {
    		data.push({
    			courseId: selection[i].get('courseId'),
    			courseResourceMappingId: selection[i].get('courseResourceMappingId'),
    			eventId: selection[i].get('eventId'),
    			academicTermId: vals.assessmentSchemeAcademicTerm,
    			mappedCount: selection[i].get('mappedCount'),
    			date: selection[i].get('date'),
    			time: selection[i].get('time'),
    			id: selection[i].get('id')
    		});
    	}
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_PUBLISH_NON_CONCESSION,
			method : 'PUT',
			jsonData: data,
			success : function(frm, action) {
				Ext.getBody().unmask();
				if(frm.responseText == 'false') {
					showWarningMessage(getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'), getExaminationTranslation('STUDENTS_ARE_NOT_MAPPED'));
				}
				else {
					showSuccessMessage(getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'), getExaminationTranslation('TIMETABLE_PUBLISH_SUCCESS'));
					grid.getStore().load();
					grid.getSelectionModel().deselectAll();
				}
			}
		});
	},
	
	onFromDateChange: function(cmp) {
		var form = cmp.up('form');
		var vals = form.getValues();
		var schemeIds = '';
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			schemeIds = vals.assesmentScheme;
		}
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
		var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.enable();
    	var eventStore = event.getStore();
    	eventStore.getProxy().extraParams = {
    		academicTermId: vals.assessmentSchemeAcademicTerm,
    		evaluationPlanIds: schemeIds,
    		administrativeBy: vals.administrativeBy,
    		fromDate: vals.fromdate,
    		toDate: vals.tilldate,
    		courseIds: courseIds
    	};
    	eventStore.load();
	},
	
	onTillDateChange: function(cmp) {
		var form = cmp.up('form');
		var vals = form.getValues();
		var schemeIds = '';
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			schemeIds = vals.assesmentScheme;
		}
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
		var event = form.down('#detailSequenceRoomAndStaffAllocation');
    	event.reset();
    	event.clearValue();
    	event.enable();
    	var eventStore = event.getStore();
    	eventStore.getProxy().extraParams = {
    		academicTermId: vals.assessmentSchemeAcademicTerm,
    		evaluationPlanIds: schemeIds,
    		administrativeBy: vals.administrativeBy,
    		fromDate: vals.fromdate,
    		toDate: vals.tilldate,
    		courseIds: courseIds
    	};
    	eventStore.load();
	}
});