/**
 * @author Deepika Parmar
 * 
 */
Ext.define('Academia.controller.examinationcenters.averagereport.StudentAverageReportController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['examinationcenters.averagereport.StudentAverageGridModel'],
	stores : ['examinationcenters.averagereport.StudentAverageReportStore','examinationcenters.marksheet.CalculateAverageEvaluationLevelStore',
		      'examinationcenters.calculateAverage.CalculateAverageEvalLevelTypeListStore','examinationcenters.reports.StudentAsseessmentReportStudentListStore',
		      'common.picklist.StudentActiveInactiveStatusStore','personinfo.common.personalinfo.AttendanceReportProgramGroupStore','common.AcademicTermStore',
		      'common.AcademicTermStoreForIntakeYearId','program.programDetails.programBatches.courseParameter.ProgramBatchPeriodCourse','setup.templatemapping.TemplateNameListFacultyByCode',
			  'examinationcenters.marksheet.CalculateAverageReportEvaluationLevelStore','examinationcenters.marksheet.CalculateAverageReportEvaluationLevelStore',
			  'examinationcenters.marksheet.CalculateAverageReportEvaluationLevelType','examinationcenters.marksheet.CalculateAverageReportProgramBatchStore',
			  'examinationcenters.reports.StudentAverageReportStudentListStore'],

	          views : ['examinationcenters.averagereport.StudentAverageReportStructure','examinationcenters.averagereport.StudentAverageReportFilter',
	        	  'Academia.view.examinationcenters.averagereport.StudentAverageReportGrid','examinationcenters.averagereport.StudentAverageReportWin'],
	                   config:{
	                	   EXAM_STUDENT_AVERAGE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_STUDENT_AVERAGE_REPORT_PRIVILEGES'),
	                	  },           
	                   refs : [{
	                	   ref:'studentaveragereportstructure',
	                	   selector:'studentaveragereportstructure'
	                   },{
	                	   ref:'studentaveragereportfilter',
	                	   selector:'studentaveragereportfilter'
	                   },{
	                	   ref:'studentaveragereportgrid',
	                	   selector:'studentaveragereportgrid'
	                   },{
	                	   ref:'studentaveragereportwin',
	                	   selector:'studentaveragereportwin'
	                   }],
	                   init : function() {
	                	   this.control({ 
	                		   'studentaveragereportstructure':{
	                			   afterrender:function(structure){
	                				   var grid = structure.down('studentaveragereportgrid');
	                				   this.getGridHeaderFreeze(grid,structure,false);
	                			   }
	                		   },
	                		   'studentaveragereportfilter':{
	                			 afterrender:function(obj){
	                				 this.onStudentReportFilterRender(obj);
	                			 },
	                			 validitychange:function( me, valid, eOpts ) {
	                				 var filterForm = this.getStudentaveragereportfilter().getForm();
	                				 var studentAvgGrid = this.getStudentaveragereportgrid();
	                				 var exportBtn = studentAvgGrid.down('#exportReoprtItemId');
	                				 var admissionField = filterForm.findField('admissionId');
	                				 var programBatch = filterForm.findField('programBatch');
									 var programGroup  = filterForm.findField('programGroup');
									  
	                				 if(valid) {
		                				   admissionField.enable();
		                				   exportBtn.enable();
		                				   programBatch.enable();
	   									   programGroup.enable()
		                				}
	                   					 else{
	                   						 admissionField.reset();
	                   						 admissionField.disable();
	                   						 exportBtn.disable();
	                   					 }
	                			    }
	                		   },
	                		   'studentaveragereportfilter customcombobox[itemId=admissionStudentId]':{
								   blur: function(cmb){
									   if(isNullOrEmpty(cmb.value)){
										   cmb.clearValue();
									   }
								   }
							   },
	                	       'studentaveragereportfilter button[itemId=resetBtn]': {
	                			   click:function(obj){
	                				   var studentFilterForm = this.getStudentaveragereportfilter();
	                				   var filterForm =this.getStudentaveragereportfilter().getForm();
	                				   
	                				   this.getStudentaveragereportfilter().getForm().reset();
	                				   var academicTermValue = filterForm.findField('academicTerm').getValue();
	                				   filterForm.findField('assessmentlevelname').disable();
	                				  
	                				  if(isNullOrEmpty(academicTermValue)){
	                					  filterForm.findField('assessmentschemelevel').disable();
	                					  filterForm.findField('programGroup').disable();
		                				  filterForm.findField('programBatch').disable();
	                				  }
	                				   this.onStudentReportFilterRender(studentFilterForm);
	                			   }
	                		   },
	                		   'studentaveragereportfilter button[itemId=searchBtn]': {
	                			   click:function(obj){
	                				  this.onStudentAverageReportSearch(obj);
	                			   }
	                		   },
							   'studentaveragereportgrid': {
								   beforerender: function(grid) {
									   grid.getStore().removeAll();

								   },
	                			   afterrender: function(grid){
	                				     var me = this;
	                			   setTimeout(function(){
	                				   me.addDataGridConfigButton(grid,me.getEXAM_STUDENT_AVERAGE_REPORT_PERMISSIONS());
	   			    				   me.doAccessControlValidation(grid,me.getEXAM_STUDENT_AVERAGE_REPORT_PERMISSIONS());
	                				   me.disableExportReportButtonByPrivilege(grid,me.getEXAM_STUDENT_AVERAGE_REPORT_PERMISSIONS());
	   			    				  },1500); 
	                			   }
	                		     },

	                		     
	                		    'studentaveragereportfilter customcombobox#academicTermId' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
	                				   var filterForm=this.getStudentaveragereportfilter().getForm();
									   var assessmentschemelevel=filterForm.findField('assessmentschemelevel');
									   var programBatch = filterForm.findField('programBatch');
									   var programGroup  = filterForm.findField('programGroup');
									   var assessmentlevelname = filterForm.findField('assessmentlevelname');
									   var studentCodeName = filterForm.findField('admissionId');
									   var academyLocationIds = this.getCurrentAcademyLocation();
									   assessmentschemelevel.enable();
									   assessmentschemelevel.reset();
									   assessmentlevelname.reset();
									   assessmentlevelname.disable(true);
									  // programBatch.enable();
									   programGroup.reset();
									   studentCodeName.reset();
									  // programGroup.enable();
									   assessmentschemelevel.getStore().getProxy().extraParams={
	                					   academicTermId:record[0].data.id,
										   whetherCalculateAverage:true
	                				   };
	                				   assessmentschemelevel.getStore().load();
									  programBatch.reset();
									  programBatch.getStore().getProxy().extraParams={
		         					   		academyLocationIds:academyLocationIds,
											academicTermId : record[0].data.id
		         				       };
		         				      programBatch.getStore().load();
	                				  
	                			   }
		            			},


								'studentaveragereportfilter customcombobox#assessmentlevelnameItemId' : {
	                			   change : function(obj, record) {
	                				   var $this = this;
	                				   var filterForm=this.getStudentaveragereportfilter().getForm();
									   var programBatchField = filterForm.findField('programBatch').valueModels;
									   var batchValue=null;
									   if(programBatchField.length!=0){
										batchValue=programBatchField[0].data.id
									   }
									   var formValues=filterForm.getValues();
	                				   var admissionField = filterForm.findField('admissionId');
 									   var academyLocationIds = this.getCurrentAcademyLocation();
										 admissionField.reset();
		 								 admissionField.getStore().getProxy().extraParams={
	                					   	academyLocationIds: academyLocationIds,
											academicTermId:formValues.academicTerm,
											batchId:batchValue,
											levelName: formValues.assessmentschemelevel,
	                      				    levelValue: formValues.assessmentlevelname,
	                       				    programGroupId: formValues.programGroup,
	                				   	 };
	                				     admissionField.getStore().load();
	                			   }
		            			},

								'studentaveragereportfilter customcombobox#programGroupItemId' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
	                				   var filterForm=this.getStudentaveragereportfilter().getForm();
									   var programBatchField = filterForm.findField('programBatch');
									   programBatchField.reset(); 
									   var studentCodeName = filterForm.findField('admissionId');
									   var programBatchFieldValue = filterForm.findField('programBatch').valueModels;
									   var batchValue=null;
									   if(programBatchFieldValue.length!=0){
										batchValue=programBatchFieldValue[0].data.id
									   }
									   var formValues=filterForm.getValues();
 									   var academyLocationIds = this.getCurrentAcademyLocation();
										 
										 studentCodeName.reset();
		 								 programBatchField.getStore().getProxy().extraParams={
	                					   	academyLocationIds: academyLocationIds,
											academicTermId:formValues.academicTerm,
											id:record[0].data.id
	                				   	 }; 
	                				     programBatchField.getStore().load();
									  
									   var admissionField = filterForm.findField('admissionId');
 									   var academyLocationIds = this.getCurrentAcademyLocation();
										 admissionField.reset();
		 								 admissionField.getStore().getProxy().extraParams={
	                					   	academyLocationIds: academyLocationIds,
											academicTermId:formValues.academicTerm,
											batchId:batchValue,
											levelName: formValues.assessmentschemelevel,
	                      				    levelValue: formValues.assessmentlevelname,
	                       				    programGroupId: formValues.programGroup,
	                				   	 };
	                				     admissionField.getStore().load();
											
	                			   }
		            			},

								'studentaveragereportfilter multiselectcombofield#programBatchItemId' : {
	                			   change : function(obj, record) {
	                				   var $this = this;
	                				   var filterForm=this.getStudentaveragereportfilter().getForm();
									   var programBatchField = filterForm.findField('programBatch').valueModels;
									   var batchValue=null;
									   var formValues=filterForm.getValues();
	                				   var admissionField = filterForm.findField('admissionId');
 									   var academyLocationIds = this.getCurrentAcademyLocation();
					
									   var batchIds = [];
        							   var records;
      									  if (!isNullOrEmpty(formValues.programBatch)) {
         									   for (var i = 0; i < formValues.programBatch.length; i++) {
             								   var batchValue = formValues.programBatch[i];
           									     if (Ext.isObject(batchValue)) {
              								      batchIds.push(batchValue.data.id);
              										  } else {
                   							 	  batchIds.push(batchValue);
             									  }
          								 	 }
       									 }
					
										admissionField.reset();
		 								 admissionField.getStore().getProxy().extraParams={
	                					   	academyLocationIds: academyLocationIds,
											academicTermId:formValues.academicTerm,
											batchIds:batchIds.join(),
	                				   	 };
	                				     admissionField.getStore().load();
	                			   }
		            			},

 								'studentaveragereportfilter customcombobox#assessmentschemelevelItemId' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
 									   var evalLevelData = record[0].data.id;
	                				   var filterForm=this.getStudentaveragereportfilter().getForm();
									   var assessmentlevelname=filterForm.findField('assessmentlevelname');
									   var academicTerm=filterForm.findField('academicTerm');
									   assessmentlevelname.enable();
									   assessmentlevelname.reset();
									   assessmentlevelname.getStore().getProxy().extraParams = {
                    					academicTermId: academicTerm.getValue(),
                    					whetherCalculateAverage:true,
										evaluationLevel: evalLevelData,
                    				   };
                    
                  					   var evalLevelIds = [];
                   					   assessmentlevelname.getStore().load({
                    				   callback:function(record) {
                    				   for(var i in record) {
                    				   for (var i = 0; i < record.length; i++) {
                    				      evalLevelIds.push(record[i].data.id);
                    				      }
                    				    }
                    				     filterForm.findField('evalLevelIds').setValue(evalLevelIds.join());
                    				    }
                  				      });
	                			    }
		            			  },
	                		     'studentaveragereportgrid button[itemId=exportReoprtItemId]':{
	                		    	 click:function(obj){
		                				   var $this = this;
		                				  
		         							   var formWindow = $this.getStudentaveragereportwin();
		         							   if (!formWindow) {
		         								   Ext.widget('studentaveragereportwin',{
		         									   itemId:'studentAverageReportWinItemId'
		         								   });
		         								   formWindow = $this.getStudentaveragereportwin();
		         							   } 
		         					          formWindow.setHeight(160);
		         					          formWindow.setWidth(300);
		         					         
		         					          var templateWindowField = formWindow.down('#studentAverageReportFilterId');
		         					          var tempalte = formWindow.down('#studentAverageReportFilterId').getStore();
		         					          tempalte.getProxy().extraParams={
		         					          reportType:'Average Report'
		         					          };
		         							   tempalte.load({
		         								   callback: function(records){
		         									   if(records.length==1){
		         										  $this.singleTemplateExportReport();
		         									   }
		         									   else{
		         										  formWindow.show();
		         									   }
		         								   }
		         							   });
			            			   }
	                		    	 
	                		     },
	                		     'studentaveragereportwin button[itemId=submitBtn]':{
	                		    	 click:function(){
	                		    		 this.studentAverageExportReport();
	                		    	 }
	                		     }
	                		 });
	                   },
	                    onStudentReportFilterRender :function(obj){
			                    	var studentFilterForm = obj.getForm(),
			                    	currentAcademyArray = [],
			                    	academicTerm = studentFilterForm.findField('academicTerm'),
			                    	programGroup=studentFilterForm.findField('programGroup'),
			                    	studentCodeName = studentFilterForm.findField('admissionId'),
									assessmentschemelevel=studentFilterForm.findField('assessmentschemelevel'),
									statusField = studentFilterForm.findField('status'),
			                    	academyLocationIds = this.getCurrentAcademyLocation();
			                    	
			                    	   var programBatch = studentFilterForm.findField('programBatch');
									   var programGroup  = studentFilterForm.findField('programGroup');
									  
			                    	
		         				 /*   programGroup.getStore().getProxy().extraParams={
		         					   academyLocationIds:academyLocationIds,
		         				     };
		         				   programGroup.getStore().load();*/
		         				/*   studentCodeName.getStore().getProxy().extraParams={
		         					   academyLocationIds:academyLocationIds,
		         				     };
		         				    studentCodeName.getStore().load();*/
		         				   
		         				   
		         				    academicTerm.getStore().getProxy().extraParams={
		        					   academyLocationIds:academyLocationIds,
		        				   };
		         				    academicTerm.getStore().load({
		         				    	callback:function(records,values,data,eval){
		         				    		Ext.Array.each(records,function(val){
		         				    			if(val.get('sequence') == 1){
		         				    				currentAcademyArray.push(val);
		         				    			}
		         				    		});
		         				    		if(currentAcademyArray.length == 1){
		         				    			academicTerm.setValue(currentAcademyArray[0].data.id);
		         				    			assessmentschemelevel.enable();
		         				    			 assessmentschemelevel.getStore().getProxy().extraParams={
		         				    				academicTermId : academicTerm.valueModels[0].data.id,
													whetherCalculateAverage:true
		         		        				   };
		         								   assessmentschemelevel.getStore().load();
		         								 /* programBatch.enable();
		   									      programGroup.enable();*/
		
												programBatch.getStore().getProxy().extraParams={
		         					   				academyLocationIds:academyLocationIds,
													academicTermId : academicTerm.valueModels[0].data.id
		         				    			 };
		         				    			programBatch.getStore().load();
		         				    		}
		         				    		else{		         				    			
		         				    			 assessmentschemelevel.getStore().getProxy().extraParams={
			         				    				academyLocationId : academyLocationIds,
														whetherCalculateAverage:true
			         		        				};
			         							 assessmentschemelevel.getStore().load();
		         				    		}
		         				    	}
		         				    });
		         				/* 
		         				 * {
									   callback:function(records,value,rec){
										   statusField.setValue(records[0].data.name);
									   }
								   }
		         				 */  
								   statusField.getStore().load();
	                    },
	                    onStudentAverageReportSearch:function(obj){
	                    	var $this = this;
	                    var form = $this.getStudentaveragereportfilter();
	                    
	                    if(isNullOrEmpty(form.down('#admissionStudentId').value)){
							form.down('#admissionStudentId').clearValue();
						}
	                    
	                    var filterForm = $this.getStudentaveragereportfilter().getForm();
	                    var studentReportGrid = $this.getStudentaveragereportgrid();
	                    var filterFormValues = filterForm.getValues();
	                    
						var status=null;
						if(!isNullOrEmpty(filterFormValues.status) && (filterFormValues.status || filterFormValues.status==="Active")){
							status=true;
						} else if(!isNullOrEmpty(filterFormValues.status) && (!filterFormValues.status || filterFormValues.status==="Inactive")){
							status=false;
						}
	                  
						var batchIds = [];
        			   var records;
      									  if (!isNullOrEmpty(filterFormValues.programBatch)) {
         									   for (var i = 0; i < filterFormValues.programBatch.length; i++) {
             								   var batchValue = filterFormValues.programBatch[i];
           									     if (Ext.isObject(batchValue)) {
              								      batchIds.push(batchValue.data.id);
              										  } else {
                   							 	  batchIds.push(batchValue);
             									  }
          								 	 }
       									 }

	                    var academyLocationId = $this.getCurrentAcademyLocation();
	                    if(!isNullOrEmpty(status)){
	                    	studentReportGrid.getStore().getProxy().extraParams = {
		                        academyLocationId: academyLocationId,
								academicTermId:filterFormValues.academicTerm,
								levelName: filterFormValues.assessmentschemelevel,
		                        levelValue: filterFormValues.assessmentlevelname,
		                        batchId: batchIds.join(),
		                        programGroupId: filterFormValues.programGroup,
								admissionId:filterFormValues.admissionId,
								status:status
		                    };
	                    }else{
	                    	 studentReportGrid.getStore().getProxy().extraParams = {
	 	                        academyLocationId: academyLocationId,
	 							academicTermId:filterFormValues.academicTerm,
	 							levelName: filterFormValues.assessmentschemelevel,
	 	                        levelValue: filterFormValues.assessmentlevelname,
	 	                        batchId: batchIds.join(),
	 	                        programGroupId: filterFormValues.programGroup,
	 							admissionId:filterFormValues.admissionId,
	 	                    };
	                    }
	                   
	                   // $this.resetGridSetting(calculateAverageGrid);
	                    //studentReportGrid.getStore().load();
	                   // studentReportGrid.getSelectionModel().deselectAll();
	                    studentReportGrid.config.searchFilterForm = form;
						$this.resetPageSetting(studentReportGrid.getStore(), studentReportGrid);
						studentReportGrid.getStore().load();
						studentReportGrid.getSelectionModel().deselectAll();
						studentReportGrid.getStore().pageSize = 100;
	                   },
	                   
	                   disableExportReportButtonByPrivilege:function(grid,permissionsMap){
	                	   var associatedAcadLocationIds = new Array();
	                       associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                       var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                       var exportButton = grid.down('#exportReoprtItemId');
	                       exportButton.setVisible(false);
	                       Ext.each(permissionList, function(privilege) {
	                   		if (privilege === 'EXPORT_REPORT') {
	                       		if(!isNullOrEmpty(exportButton)){
	                       			exportButton.setVisible(true);
	                       		}        		
	                   		}
	                       });
	                   },
	                  
		  			studentAverageExportReport :function(){
  		    		       var $this = this;
      				       var academyLocationIds=null;
          				       academyLocationIds = $this.getCurrentAcademyLocation();
      				       var filterForm = $this.getStudentaveragereportfilter().getForm();
	                	   var filterFormValues = filterForm.getValues();
	                	   var evalLevelNameField = filterForm.findField('assessmentlevelname').getValue();
	                	   var evaluationLevelName = filterForm.findField('assessmentschemelevel').getValue();
	                	   var programBatchArray = [];
						   var studentaveragereportwin = $this.getStudentaveragereportwin();
	                	   var reportType = studentaveragereportwin.down('#studentAverageReportFilterId');
	                	   var reportCode = reportType.displayTplData[0].code;
							var reportValue=reportType.displayTplData[0].value

	              
	                	   if (!isNullOrEmpty(filterFormValues.programBatch)) {
	                		   for (var i = 0; i < filterFormValues.programBatch.length; i++) {
	                			   var programBatch = filterFormValues.programBatch[i];
	                				   programBatchArray.push(programBatch.data.id);
	                			   } 
	                		   }
	                	   if (evaluationLevelName=="EVALUATION_PLAN"){
	                		  var  planName=1;
	                	   } else if(evaluationLevelName=="EVALUATION_TYPE"){
	                		  var  levelOne= 1;
	                	   }  else if (evaluationLevelName=="EVALUATION_SUB_TYPE"){
	                		   var levelTwo= 1;
	                	   } else if (evaluationLevelName=="EVALUATION_METHOD"){
	                		  var  method=1;
	                	   }
	                	   var  levelId=evalLevelNameField;
	                	   var reportParams =new Object();
	              		  	 reportParams.BATCH_IDS=programBatchArray.join(),
		   		               //reportParams.BATCH_IDS='';
		   		        	   reportParams.ACADEMYLOCATION_ID = academyLocationIds+"";
     		   		         if(!isNullOrEmpty(filterFormValues.academicTerm)){
     		   		              reportParams.ACADEMIC_TERM = filterFormValues.academicTerm
     		   		          }
     		   		         if(!isNullOrEmpty(planName)){
     		   		              reportParams.PLAN=  planName
     		   		         }
     		   		         if(!isNullOrEmpty(levelOne)){
     		   		               reportParams.LEVEL_ONE = levelOne
     		   		         }
		       		   		 if(!isNullOrEmpty(levelTwo)){
		       		   		      reportParams.LEVEL_TWO= levelTwo
	       		   		     }
			       		   	 if(!isNullOrEmpty(method)){
			       		   	      reportParams.LEVEL_THREE =method
	       		   		     }
			       		   	 
			       		      var status = filterForm.findField("status").getDisplayValue();
				       		 if(!isNullOrEmpty(status)){
				       			reportParams.STATUS =status
	       		   		     }
				       		 if(!isNullOrEmpty(filterFormValues.programGroup)){
				       			 reportParams.PROGRAM_GROUP = filterFormValues.programGroup
		       		   		  }
				       		 if(!isNullOrEmpty(levelId)){
				       			 reportParams.LEVEL_NAMES=levelId
		       		   		  }

		              		  if(reportCode=='STUDENT_AVERAGE_REPORT_PROGRAM_WISE'|| reportValue=='STUDENT_AVERAGE_REPORT_PROGRAM_WISE'){
										reportParams.reportTitle = "STUDENT_AVERAGE_REPORT_PROGRAM_WISE";
										reportParams.code = "STUDENT_AVERAGE_REPORT_PROGRAM_WISE";
	              		 			  	reportParams.headerName = "Student Average Report By Program";
									 	$this.exportJRXMLReport('STUDENT_AVERAGE_REPORT_PROGRAM_WISE',reportParams,'Student Average Report By Program','.vnd.ms-excel',"rest/examinationResult/generateSISAvergaeReportByProgram");
									}else if(reportCode=='STUDENT_AVERAGE_REPORT_COURSE_WISE'||reportValue=='STUDENT_AVERAGE_REPORT_COURSE_WISE'){
										reportParams.reportTitle = "STUDENT_AVERAGE_REPORT_COURSE_WISE";
										reportParams.code = "STUDENT_AVERAGE_REPORT_COURSE_WISE";
	              		 			  	reportParams.headerName ="Student Average Report By Subject";
									 $this.exportJRXMLReport('STUDENT_AVERAGE_REPORT_COURSE_WISE',reportParams,'Student Average Report By Subject','.vnd.ms-excel',"rest/examinationResult/generateSISAvergaeReportByCourseCategories");
									}
		              		studentaveragereportwin.close();
		  			},
		  			singleTemplateExportReport:function(){
		    		       var $this = this;
   				       var academyLocationIds=null;
       				       academyLocationIds = $this.getCurrentAcademyLocation();
   				       var filterForm = $this.getStudentaveragereportfilter().getForm();
	                	   var filterFormValues = filterForm.getValues();
	                	   var evalLevelNameField = filterForm.findField('assessmentlevelname').getValue();
	                	   var evaluationLevelName = filterForm.findField('assessmentschemelevel').getValue();
	                	   var programBatchArray = [];
						   var studentaveragereportwin = $this.getStudentaveragereportwin();
	                	   var reportType = studentaveragereportwin.down('#studentAverageReportFilterId');
	                	   var reportCode = reportType.getStore().data.items[0].data.code;
							var reportValue=reportType.getStore().data.items[0].data.value;

	              
	                	   if (!isNullOrEmpty(filterFormValues.programBatch)) {
	                		   for (var i = 0; i < filterFormValues.programBatch.length; i++) {
	                			   var programBatch = filterFormValues.programBatch[i];
	                				   programBatchArray.push(programBatch.data.id);
	                			   } 
	                		   }
	                	   if (evaluationLevelName=="EVALUATION_PLAN"){
	                		  var  planName=1;
	                	   } else if(evaluationLevelName=="EVALUATION_TYPE"){
	                		  var  levelOne= 1;
	                	   }  else if (evaluationLevelName=="EVALUATION_SUB_TYPE"){
	                		   var levelTwo= 1;
	                	   } else if (evaluationLevelName=="EVALUATION_METHOD"){
	                		  var  method=1;
	                	   }
	                	   var  levelId=evalLevelNameField;
	                	   var reportParams =new Object();
	              		  	 reportParams.BATCH_IDS=programBatchArray.join(),
		   		               //reportParams.BATCH_IDS='';
		   		        	   reportParams.ACADEMYLOCATION_ID = academyLocationIds+"";
  		   		         if(!isNullOrEmpty(filterFormValues.academicTerm)){
  		   		              reportParams.ACADEMIC_TERM = filterFormValues.academicTerm
  		   		          }
  		   		         if(!isNullOrEmpty(planName)){
  		   		              reportParams.PLAN=  planName
  		   		         }
  		   		         if(!isNullOrEmpty(levelOne)){
  		   		               reportParams.LEVEL_ONE = levelOne
  		   		         }
		       		   		 if(!isNullOrEmpty(levelTwo)){
		       		   		      reportParams.LEVEL_TWO= levelTwo
	       		   		     }
			       		   	 if(!isNullOrEmpty(method)){
			       		   	      reportParams.LEVEL_THREE =method
	       		   		     }
				       		  if(!isNullOrEmpty(filterFormValues.status)){
				       			reportParams.STATUS =filterFormValues.status
	       		   		     }
				       		 if(!isNullOrEmpty(filterFormValues.programGroup)){
				       			 reportParams.PROGRAM_GROUP = filterFormValues.programGroup
		       		   		  }
				       		 if(!isNullOrEmpty(levelId)){
				       			 reportParams.LEVEL_NAMES=levelId
		       		   		  }

		              		  if(reportCode=='STUDENT_AVERAGE_REPORT_PROGRAM_WISE'|| reportValue=='STUDENT_AVERAGE_REPORT_PROGRAM_WISE'){
										reportParams.reportTitle = "STUDENT_AVERAGE_REPORT_PROGRAM_WISE";
										reportParams.code = "STUDENT_AVERAGE_REPORT_PROGRAM_WISE";
	              		 			  	reportParams.headerName = "Student Average Report By Program";
									 	$this.exportJRXMLReport('STUDENT_AVERAGE_REPORT_PROGRAM_WISE',reportParams,'Student Average Report By Program','.vnd.ms-excel',"rest/examinationResult/generateSISAvergaeReportByProgram");
									}else if(reportCode=='STUDENT_AVERAGE_REPORT_COURSE_WISE'||reportValue=='STUDENT_AVERAGE_REPORT_COURSE_WISE'){
										reportParams.reportTitle = "STUDENT_AVERAGE_REPORT_COURSE_WISE";
										reportParams.code = "STUDENT_AVERAGE_REPORT_COURSE_WISE";
	              		 			  	reportParams.headerName ="Student Average Report By Subject";
									 $this.exportJRXMLReport('STUDENT_AVERAGE_REPORT_COURSE_WISE',reportParams,'Student Average Report By Subject','.vnd.ms-excel',"rest/examinationResult/generateSISAvergaeReportByCourseCategories");
									}
		  			
		  			}
});