/**
 * @author Bhanu PS
 * 
 */
Ext.define('Academia.controller.examinationcenters.dutychart.ExaminationDutyChartController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationcenters.examstaffallocation.ExaminationRoles','examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter','examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
	          'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter','examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter','examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
	          'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter', 'examinationcenters.roomallocation.ExaminationDutyGridStore'],
	          views : ['personinfo.common.course.FacultyDutyFilter','personinfo.common.course.ExaminationDutyGrid','personinfo.common.course.FacultyPortalExamDuty',
	                   'personinfo.common.course.ExaminationDutySupervisorGrid','personinfo.common.course.ExaminationDutyExaminerGrid','personinfo.common.course.ExaminationDutyPaperSatterGrid'],	
	                   config: {
	                	   FACULTY_EXAMINATION_DUTY_CHART_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_M9_F_FACULTY_EXAMINATION_DUTY_CHART_PRIVILEGES'),
	                	   FACULTY_PROFILE_EXAMINATION_DUTY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_EXAMINATION_DUTY_PRIVILEGES')
	                   },
	                   refs : [{
	                	   ref: 'facultyportalexamduty',
	                	   selector: 'facultyportalexamduty'
	                   },{
	                	   ref: 'facultydutyfilter',
	                	   selector: 'facultydutyfilter[itemId=facultyDutyFilterPanel]'
	                   },{
	                	   ref: 'examinationdutygrid',
	                	   selector: 'examinationdutygrid[itemId=examinationDutyGridItemId]'
	                   },{
	                	   ref: 'examinationdutysupervisorgrid',
	                	   selector: 'examinationdutysupervisorgrid[itemId=examinationdutysupervisorgridItemId]'
	                   },{
	                	   ref: 'examinationdutyexaminergrid',
	                	   selector: 'examinationdutyexaminergrid[itemId=examinationdutyexaminergridItemId]'
	                   },{
	                	   ref: 'examinationdutypapersattergrid',
	                	   selector: 'examinationdutypapersattergrid[itemId=examinationdutypapersattergridItemId]'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] customcombobox[itemId=roleItemId]': {
	                			   select: function(combo, records, eOpts) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   var userId = $this.getCurrentlyLoggedInUser().id;
	                				   var data = records[0].data;
	                				   var group = form.findField('evaluationGroupId');
	                				   group.reset();
	                				   group.getStore().getProxy().extraParams={
	                					   usersId:userId,
	                					   roleName:data.value
	                				   };
	                				   group.getStore().load();
	                				   group.setDisabled(false);
	                				   var programId = form.findField('programId');
	                				   var batchId = form.findField('batchId');
	                				   var periodId = form.findField('periodId');
	                				   var courseId = form.findField('courseId');
	                				   var centerName = form.findField('centerName');
	                				   var dateTill = form.findField('dateTill');
	                				   var periodFrom = form.findField('periodFrom');
	                				   periodFrom.reset();
	                				   dateTill.reset();
	                				   programId.setDisabled(true);
	                				   batchId.setDisabled(true);
	                				   periodId.setDisabled(true);
	                				   courseId.setDisabled(true);
	                				   programId.reset();
	                				   batchId.reset();
	                				   periodId.reset();
	                				   courseId.reset();
	                				   centerName.reset();
	                				   if(data.value=='PAPER_SETTER') {
	                					   courseId.setVisible(true);
	                					   periodId.setVisible(true);
	                					   batchId.setVisible(true);
	                					   programId.setVisible(true);
	                					   centerName.setVisible(false);
	                				   } else {
	                					   courseId.setVisible(false);
	                					   periodId.setVisible(false);
	                					   batchId.setVisible(false);
	                					   programId.setVisible(false);
	                					   centerName.setVisible(true);
	                					   centerName.setDisabled(true);
	                				   }
	                			   }
	                		   },

	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] customcombobox[itemId=evaluationGroupItemId]': {
	                			   select: function(combo, records, eOpts) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   var userId = $this.getCurrentlyLoggedInUser().id;
	                				   var data = records[0].data;
	                				   var centerName = form.findField('centerName');
	                				   centerName.reset();
	                				   var role = form.findField('role');
	                				   if(role.getRawValue()=='PAPER_SETTER') {
	                					   var programId = form.findField('programId');
	                					   var batchId = form.findField('batchId');
	                					   var periodId = form.findField('periodId');
	                					   var courseId = form.findField('courseId');
	                					   programId.setDisabled(false);
	                					   batchId.setDisabled(true);
	                					   periodId.setDisabled(true);
	                					   courseId.setDisabled(true);
	                					   programId.reset();
	                					   batchId.reset();
	                					   periodId.reset();
	                					   courseId.reset();
	                					   programId.getStore().getProxy().extraParams={
	                						   evaluationGroupId:data.id
	                					   };
	                					   programId.getStore().load();
	                					   programId.setDisabled(false);
	                				   } else {
	                					   centerName.getStore().getProxy().extraParams={
	                						   usersId:userId,
	                						   roleName:role.getRawValue(),
	                						   evaluationGroupId:data.id
	                					   };
	                					   centerName.getStore().load();
	                					   centerName.setDisabled(false);
	                				   }
	                			   }
	                		   },
	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] customcombobox[itemId=programIdItemId]': {
	                			   select: function(combo, records, eOpts) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   var userId = $this.getCurrentlyLoggedInUser().id;
	                				   var data = records[0].data;
	                				   var role = form.findField('role');
	                				   var programId = form.findField('programId');
	                				   var batchId = form.findField('batchId');
	                				   var periodId = form.findField('periodId');
	                				   var courseId = form.findField('courseId');
	                				   periodId.setDisabled(true);
	                				   courseId.setDisabled(true);
	                				   batchId.reset();
	                				   periodId.reset();
	                				   courseId.reset();
	                				   batchId.getStore().getProxy().extraParams={
	                					   programId:data.id
	                				   };
	                				   batchId.setDisabled(false);
	                				   batchId.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length == 1){
	                								   batchId.setValue(records[0].data.id);
	                							   }		 
	                						   }
	                						   periodId.enable();
	                						   var storePeriod = periodId.getStore();
	                						   storePeriod.getProxy().extraParams = {
	                							   id:records[0].data.id,
	                						   };
	                						   storePeriod.load();
	                						   periodId.setValue(records[0].data.id);

	                					   }

	                				   });
	                			   }
	                		   },
	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] customcombobox[itemId=batchIdItemId]': {
	                			   select: function(combo, records, eOpts) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   var userId = $this.getCurrentlyLoggedInUser().id;
	                				   var data = records[0].data;
	                				   var role = form.findField('role');
	                				   var programId = form.findField('programId');
	                				   var evaluationGroupId = form.findField('evaluationGroupId');
	                				   var batchId = form.findField('batchId');
	                				   var periodId = form.findField('periodId');
	                				   var courseId = form.findField('courseId');
	                				   courseId.setDisabled(true);
	                				   periodId.reset();
	                				   courseId.reset();
	                				   periodId.getStore().getProxy().extraParams={
	                					   batchId:data.id,
	                					   programId:programId.getValue(),
	                					   evaluationGroupId:evaluationGroupId.getValue()
	                				   };
	                				   periodId.getStore().load();
	                				   periodId.setDisabled(false);
	                			   }
	                		   },
	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] customcombobox[itemId=periodItemId]': {
	                			   select: function(combo, records, eOpts) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   var userId = $this.getCurrentlyLoggedInUser().id;
	                				   var data = records[0].data;
	                				   var role = form.findField('role');
	                				   var programId = form.findField('programId');
	                				   var evaluationGroupId = form.findField('evaluationGroupId');
	                				   var batchId = form.findField('batchId');
	                				   var periodId = form.findField('periodId');
	                				   var courseId = form.findField('courseId');
	                				   courseId.reset();
	                				   courseId.getStore().getProxy().extraParams={
	                					   batchId:batchId.getValue(),
	                					   programId:programId.getValue(),
	                					   periodId:data.id,
	                					   evaluationGroupId:evaluationGroupId.getValue()
	                				   };
	                				   courseId.getStore().load();
	                				   courseId.setDisabled(false);
	                			   }
	                		   },

	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] button[itemId=resetBtn]': {
	                			   click: function(combo) {
	                				   var $this=this;
	                				   var form = combo.up('form').getForm();
	                				   form.reset();
	                				   var programId = form.findField('programId');
	                				   var batchId = form.findField('batchId');
	                				   var periodId = form.findField('periodId');
	                				   var courseId = form.findField('courseId');
	                				   var centerName = form.findField('centerName');
	                				   var evaluationGroupId = form.findField('evaluationGroupId');
	                				   var dateTill = form.findField('dateTill');
	                				   var periodFrom = form.findField('periodFrom');
	                				   periodFrom.reset();
	                				   periodFrom.setMinValue(false);
	                				   periodFrom.setMaxValue(false);
	                				   dateTill.reset();
	                				   dateTill.setMinValue(false);
	                				   dateTill.setMaxValue(false);
	                				   evaluationGroupId.setDisabled(true);
	                				   programId.setDisabled(true);
	                				   batchId.setDisabled(true);
	                				   periodId.setDisabled(true);
	                				   courseId.setDisabled(true);
	                				   programId.reset();
	                				   batchId.reset();
	                				   periodId.reset();
	                				   courseId.reset();
	                				   centerName.reset();
	                				   centerName.setDisabled(true);
	                				   courseId.setVisible(false);
	                				   periodId.setVisible(false);
	                				   batchId.setVisible(false);
	                				   programId.setVisible(false);
	                				   centerName.setVisible(true);
	                			   }
	                		   },

	                		   'facultyportalexamduty[itemId=facultyportalexamdutyItemId] facultydutyfilter[itemId=facultyDutyFilterPanel] button[itemId=searchBtn]': {
	                			   click: function(combo) {
	                				   var $this=this;
	                				   if($this.getCurrentLoggedPortalId()!=3) {
	                					   var form = combo.up('form').getForm();
	                					   var formValue = form.getValues();
	                					   var userId = $this.getCurrentlyLoggedInUser().id;
	                					   var centerName = form.findField('centerName');
	                					   var role = form.findField('role');
	                					   var evaluationGroupId = form.findField('evaluationGroupId');
	                					   var grid= $this.getExaminationdutypapersattergrid();
	                					   if(role.getRawValue()=='INVIGILATOR'){
	                						   grid= $this.getExaminationdutygrid();
	                						   $this.getExaminationdutysupervisorgrid().setVisible(false);
	                						   $this.getExaminationdutyexaminergrid().setVisible(false);
	                						   $this.getExaminationdutypapersattergrid().setVisible(false);
	                					   } else if(role.getRawValue()=='PAPER_SETTER'){
	                						   grid= $this.getExaminationdutypapersattergrid();
	                						   $this.getExaminationdutygrid().setVisible(false);
	                						   $this.getExaminationdutysupervisorgrid().setVisible(false);
	                						   $this.getExaminationdutyexaminergrid().setVisible(false);
	                					   } else if(role.getRawValue()=='EXAMINER'){
	                						   grid= $this.getExaminationdutyexaminergrid();
	                						   $this.getExaminationdutygrid().setVisible(false);
	                						   $this.getExaminationdutysupervisorgrid().setVisible(false);
	                						   $this.getExaminationdutypapersattergrid().setVisible(false);
	                					   } else if(role.getRawValue()=='CENTER_SUPERVISOR') {
	                						   grid= $this.getExaminationdutysupervisorgrid();
	                						   $this.getExaminationdutypapersattergrid().setVisible(false);
	                						   $this.getExaminationdutysupervisorgrid().setVisible(false);
	                						   $this.getExaminationdutyexaminergrid().setVisible(false);
	                					   }
	                					   $this.getExaminationdutygrid().setVisible(false);
	                					   $this.getExaminationdutysupervisorgrid().setVisible(false);
	                					   $this.getExaminationdutyexaminergrid().setVisible(false);
	                					   grid.setVisible(true);
	                					   var type = !isNullOrEmpty(centerName)?
	                							   (!isNullOrEmpty(centerName.valueModels[0])?(!isNullOrEmpty(centerName.valueModels[0].data.code)?
	                									   centerName.valueModels[0].data.code:null):null):null;
	                									   grid.getStore().getProxy().extraParams={
	                										   usersId:userId,
	                										   roleName:role.getRawValue(),
	                										   evaluationGroupId:formValue.evaluationGroupId,
	                										   centerType:type,
	                										   examCenterId:centerName.getValue(),
	                										   programId:formValue.programId,
	                										   batchId:formValue.batchId,
	                										   periodId:formValue.periodId,
	                										   courseId:formValue.courseId,
	                										   startDate:formValue.periodFrom,
	                										   endDate:formValue.dateTill
	                									   };
	                									   grid.getStore().load();
	                				   } 
	                			   }
	                		   },
	                		   'examinationdutypapersattergrid':{
	                			   render : function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_EXAMINATION_DUTY_CHART_PERMISSIONS());
	                			   }
	                		   },
	                		   'examinationdutygrid':{
	                			   render : function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_EXAMINATION_DUTY_CHART_PERMISSIONS());
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   if (portalId == 1){
	                					   this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_EXAMINATION_DUTY_PERMISSIONS());	
	                				   } 
	                			   },
								   beforerender: function(grid) {
									   grid.getStore().removeAll();
								   }	
	                		   },
	                		   'examinationdutysupervisorgrid':{
	                			   render : function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_EXAMINATION_DUTY_CHART_PERMISSIONS());
	                			   }
	                		   },
	                		   'examinationdutyexaminergrid':{
	                			   render : function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_EXAMINATION_DUTY_CHART_PERMISSIONS());
	                			   }
	                		   }
	                	   });
	                   },
});
