/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : ['examinationcenters.evaluationgroup.centerdetail.CenterUnavailableDetail'],
	stores : ['examinationcenters.evaluationgroup.centerdetail.CenterUnavailableDetail','examinationcenters.evaluationgroup.studentcovered.StundentNameCombo','examinationcenters.evaluationgroup.studentcovered.StudentCoveredCourseCombo',
	          	'examinationcenters.evaluationgroup.FilterForPeriod','examinationcenters.evaluationgroup.FilterForSections', 'examinationcenters.evaluationgroup.FilterForPlan', 'examinationcenters.evaluationgroup.FilterForCV',
	          	'examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridStore'
	],
	views : ['examinationcenters.evaluationgroup.studentcovered.StudentCoveredFilter','examinationcenters.evaluationgroup.centerdetail.CenterUnavailableDetailGrid',
	         'examinationcenters.evaluationgroup.studentcovered.StudentCoveredStructure', 'examinationcenters.evaluationgroup.studentcovered.StudentCoveredGrid'],	 
	         config:{
	          CENTER_UNAVAILABLE_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CENTER_UNAVAILABLE_DETAIL_PRIVILEGES')  
	        } , 
	         refs : [{
	        	 ref: 'studentcoveredfilter',
	        	 selector: 'studentcoveredfilter'
	         },{
	        	 ref: 'studentcoveredGridId',
	        	 selector: 'searchresultgrid[itemId=studentcoveredGridId]'
	         },{
	        	 ref: 'centerunavailabledetailgrid',
	        	 selector: 'centerunavailabledetailgrid'
	         },{
	        	 ref: 'evalgroupdetailform',
	        	 selector: 'evalgroupdetailform'
	         },{
	        	 ref: 'studentcoveredstructure',
	        	 selector: 'studentcoveredstructure'
	         }, {
	        	 ref: 'studentcoveredgrid',
	        	 selector: 'studentcoveredgrid'
	         }],
	          init : function() {
	        	  this.control({
	        		  'studentcoveredgrid' : {
	        			render : function(grid){
	        				//grid.addButtonToolbar();	
	        				this.doAccessControlValidation(grid,this.getCENTER_UNAVAILABLE_DETAIL_PERMISSIONS());
							grid.getStore().removeAll();
	        				
	        				}  
	        		  },
	        		  //**************************Export functionality*******************************
	        		  //
        			  'searchresultgrid[itemId=studentcoveredGridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
        		            click: function() {
        		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
        		            }
        		        },
        		        'searchresultgrid[itemId=studentcoveredGridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
        		            click: function() {
        		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
        		            }
        		        },
        		        'searchresultgrid[itemId=studentcoveredGridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
        		            click: function() {
        		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
        		            }
        		        },
        		        'searchresultgrid[itemId=studentcoveredGridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
        		            click: function() {
        		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
        		            }
        		        },
	        		  //******************************************************************************
	            		 'studentcoveredfilter':{
	            			 render:function(obj){
	            				 var form=obj.getForm();
	    	                     var evalGroupForm=this.getEvalgroupdetailform().getForm();
	    		        		 var evalGroupId=evalGroupForm.findField('id').getValue();
	    		        		 
	    		        		 var studentNameField=form.findField('studentId');
	    		        		 studentNameField.getStore().getProxy().extraParams = {
	    		        			 evaluationGroupId: evalGroupId
		        				 };
	    		        		 studentNameField.getStore().load();
	    		        		 
	    		        		 var courseIdField=form.findField('courseId');
	    		        		 courseIdField.getStore().getProxy().extraParams = {
	    		        			 evaluationGroupId: evalGroupId
		        				 };
	    		        		 courseIdField.getStore().load();
	            			 }
	            		 },
	            		 'studentcoveredfilter customcombobox[itemId=studentId]':{
		        			 select:function(obj,rec){
		        				 var $this = this;
		        				 var form=$this.getStudentcoveredfilter().getForm();
		        				 
		        				 var course = form.findField('courseId');
		        				 var courseVariant = form.findField('courseVariant');
		        				 var period = form.findField('periodId');
		        				 var section = form.findField('sectionId');
		        				 var plan = form.findField('evaluationPlanId');
		        				 
		        				 var evalGroupForm=this.getEvalgroupdetailform().getForm();
		        				 var evalGroupId=evalGroupForm.findField('id').getValue();
		        				 course.reset();
		        				 course.getStore().getProxy().extraParams = {
	    		        			 evaluationGroupId: evalGroupId
		        				 };
		        				 course.getStore().load();
		        				 courseVariant.reset();
		        				 period.reset();
		        				 section.reset();
		        				 plan.reset();
		        				 courseVariant.setDisabled(false);
		        				 plan.setDisabled(true);
		        				 section.setDisabled(true);
		        			 }
	            		 },
	            		 'studentcoveredfilter customcombobox[itemId=courseItemId]':{
		        			 select:function(obj,rec){
		        				 var $this = this;
		        				 var form=$this.getStudentcoveredfilter().getForm();
		        				 var courseVariant = form.findField('courseVariant');
		        				 var period = form.findField('periodId');
		        				 var section = form.findField('sectionId');
		        				 var plan = form.findField('evaluationPlanId');
		        				 var grpBasicForm = $this.getEvalgroupdetailform().getForm();
		        				 courseVariant.reset();
		        				 period.reset();
		        				 courseVariant.getStore().getProxy().extraParams = {
		        					 academyLocationId:$this.getCurrentAcademyLocation(),
		        					// programId:grpBasicForm.findField('programId').getValue(),
		        					// batchId:grpBasicForm.findField('batchId').getValue(),
		        					 courseId:rec[0].data.id
		        				 };
		        				 courseVariant.getStore().load();
		        				 courseVariant.setDisabled(false);
		        				 plan.reset();
		        				 plan.setDisabled(true);
		        				 section.reset();
		        				 section.setDisabled(true);
		        			 }
	            		 },
	            		 
	            		 'studentcoveredfilter customcombobox[itemId=courseVariantItemId]':{
		        			 select:function(obj,rec){
		        				 var $this = this;
		        				 var form=$this.getStudentcoveredfilter().getForm();
		        				 var periodId = form.findField('periodId');
		        				 var section = form.findField('sectionId');
		        				 var courseId = form.findField('courseId');
		        				 var plan = form.findField('evaluationPlanId');
		        				 var grpBasicForm = $this.getEvalgroupdetailform().getForm();
		        				 periodId.reset();
		        				 periodId.getStore().getProxy().extraParams = {
		        					 academyLocationId:$this.getCurrentAcademyLocation(),
		        					// programId:grpBasicForm.findField('programId').getValue(),
		        					// batchId:grpBasicForm.findField('batchId').getValue(),
		        					 courseId:courseId.getValue(),
		        					 courseVariantId:rec[0].data.id
		        				 };
		        				 
		        				 periodId.getStore().load();
		        				 periodId.setDisabled(false);
		        				 plan.reset();
		        				 plan.setDisabled(true);
		        				 section.reset();
		        				 section.setDisabled(true);
		        			 }
	            		 },
	            		 
	            		 'studentcoveredfilter customcombobox[itemId=periodItemId]':{
		        			 select:function(obj,rec){
		        				 var $this = this;
		        				 var form=$this.getStudentcoveredfilter().getForm();
		        				 var sectionId = form.findField('sectionId');
		        				 var courseId = form.findField('courseId');
		        				 var plan = form.findField('evaluationPlanId');
		        				 var courseVariant = form.findField('courseVariant');
		        				 var grpBasicForm = $this.getEvalgroupdetailform().getForm();
		        				 sectionId.reset();
		        				 sectionId.getStore().getProxy().extraParams = {
		        					 academyLocationId:$this.getCurrentAcademyLocation(),
		        					// programId:grpBasicForm.findField('programId').getValue(),
		        					// batchId:grpBasicForm.findField('batchId').getValue(),
		        					 courseId:courseId.getValue(),
		        					 courseVariantId:courseVariant.getValue(),
		        				 	 periodId:rec[0].data.id
		        				 };
		        				 sectionId.getStore().load();
		        				 sectionId.setDisabled(false);
		        				 plan.reset();
		        				 plan.setDisabled(true);
		        			 }
	            		 },
	            		 
	            		 'studentcoveredfilter customcombobox[itemId=sectionItemId]':{
		        			 select:function(obj,rec){
		        				 var $this = this;
		        				 var form=$this.getStudentcoveredfilter().getForm();
		        				 var section = form.findField('sectionId');
		        				 var courseId = form.findField('courseId');
		        				 var plan = form.findField('evaluationPlanId');
		        				 var variant = form.findField('courseVariant');
		        				 var grpBasicForm = $this.getEvalgroupdetailform().getForm();
		        				 plan.reset();
		        				 plan.setDisabled(false);
		        				 plan.getStore().getProxy().extraParams = {
		        					 academyLocationId:$this.getCurrentAcademyLocation(),
		        					// programId:grpBasicForm.findField('programId').getValue(),
		        					// batchId:grpBasicForm.findField('batchId').getValue(),
		        					 courseId:courseId.getValue(),
		        					 courseVariantId:variant.getValue(),
		        					 sectionsId:rec[0].data.id
		        				 };
		        				 plan.getStore().load();
		        			 }
	            		 },
	            		 
	            		 
	            		 'studentcoveredfilter button[itemId=searchBtn]': {
	            			 click: function(){
	            				 this.loadStudentCoveredGrid();
	            			 }
	                     },
	            		 'studentcoveredfilter button[itemId=resetBtn]': {
	            			 click: function(obj){
	            				 var form = obj.up('form').getForm();
	            				 form.reset();
	            				 var variant = form.findField('courseVariant');
	            				 var section = form.findField('sectionId');
	            				 var plan = form.findField('evaluationPlanId');
	            				 var periodId = form.findField('periodId');
	            				 periodId.reset();
	            				 periodId.setDisabled(true);
	            				 plan.setDisabled(true);
	            				 section.setDisabled(true);
	            				 variant.setDisabled(true);
	            			 }
	                     },
	                     'centerunavailabledetailgrid':{
	                    	 render:function(grid){
	                    	  var evalGroupForm=this.getEvalgroupdetailform().getForm();
	    		        	  var evalGroupId=evalGroupForm.findField('id').getValue();
	                          var store=this.getCenterunavailabledetailgrid().getStore();
	                               store.getProxy().extraParams = {
	    		        			 id: evalGroupId
		        				    };
	                               store.load();
	                               this.doAccessControlValidation(grid, this.getCENTER_UNAVAILABLE_DETAIL_PERMISSIONS());
	                    	 }
	                     
	                     }
	        	  });
	          }, 
	          loadStudentCoveredGrid : function(model,records){
		      		var quickSearchForm = this.getStudentcoveredfilter();
		      		var vals = quickSearchForm.getValues();
		      		var evalGroupForm = this.getEvalgroupdetailform().getForm();
		        	var evalGroupId = evalGroupForm.findField('id').getValue();
		            //var jsonFormatFormData = this.createJsonFormat(quickSearchForm, records);
		            var grid = this.getStudentcoveredgrid();
		            var gridStore = grid.getStore();
		            gridStore.getProxy().extraParams = {
		            	evaluationGroupId: evalGroupId,
		            	courseId: vals.courseId,
		            	courseVariantId: vals.courseVariant,
		            	studentId: vals.studentId,
		            	periodId: vals.periodId,
		            	sectionId: vals.sectionId,
		            	evaluationPlanId: vals.evaluationPlanId
		            };
		            this.resetPageSetting(gridStore, grid);
		            gridStore.pageSize = 100;
		            gridStore.load();
		            //var searchResultGrid = this.getStudentcoveredGridId();
		            //var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		            //resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.EVALUATION_STUDENT_COVERED_VIEWCODE);
		            //searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
		    	},
		    	createJsonFormat: function(quickSearchForm, record) {
		    		 var form =  quickSearchForm.getForm();
		    		 var studentId=form.findField('studentId');
		    		 var courseId=form.findField('courseId');
		    		 var courseVariant=form.findField('courseVariant');
		    		 var sectionId=form.findField('sectionId');
		    		 var plan=form.findField('evaluationPlanId');
		    		 var periodId = form.findField('periodId');
		    		 var evalGroupForm=this.getEvalgroupdetailform().getForm();
		        	 var evalGroupId=evalGroupForm.findField('id').getValue();
		    	     var values = new Object();
		    	     var searchcriteria = new Array();
		             values.configCode = CONSTANTS.CB.EVALUATION_STUDENT_COVERED_CONFIGCODE;
		             if(studentId.getValue() != null){
	             			searchcriteria.push({paramCode:"USER_ID", paramValues:[studentId.getValue()]});
	             		}
		             if(courseId.getValue() != null){
	             			searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseId.getValue()]});
	             	 }
		             if(courseVariant.getValue() != null){
	             			searchcriteria.push({paramCode:"COURSE_VARIANT_ID", paramValues:[courseVariant.getValue()]});
	             	 }
		             if(sectionId.getValue() != null){
	             			searchcriteria.push({paramCode:"SECTION_ID", paramValues:[sectionId.getValue()]});
	             	 }
		             if(plan.getValue() != null){
	             			searchcriteria.push({paramCode:"EVALUATION_PLAN_ID", paramValues:[plan.getValue()]});
	             	 }
		             if(!isNullOrEmpty(periodId.getValue())){
		            	 searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
		             }
		             /**
		              * This parameter is sent in filter permanently 
		              */
		             searchcriteria.push({paramCode:"EVALUATION_GROUP_ID", paramValues:[evalGroupId]});
		             values.searchCriterias = searchcriteria;
		             return values;
		    	    },
		      	 gridRenderFunction: function(grid) {
		            grid.addDocked({
		                xtype: 'toolbar',
		                dock: 'top',
		                items: [{
		                    xtype: 'button',
		                    itemId: 'btnAdd',
		                    tooltip: getCommonTranslation('ADD'),
		                    iconCls:'icon-addbutton',
   						 cls:'addbutton'
		                }, {
		                    xtype: 'button',
		                    itemId: 'btnEdit',
		                    tooltip: getCommonTranslation('EDIT'),
		                    iconCls:'icon-editbutton',
    						cls:'editbutton'
		                }]
		            });
		        },
		       //***************************Export**********************************************
		        exportUserList : function(exportUrl,filetype,whetherAll) {
                    var quickSearchForm=this.getStudentcoveredstructure(); 
                    var searchResultGrid = this.getStudentcoveredGridId();
                    var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
                    var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
                    var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
                    var visibleColumns=this.getVisibleColumns(searchResultGrid);
                    var reportTitle=getCommonTranslation('STUDENT_COVERED_LIST');
      if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                                  jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                           }
      searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

      },

           		createSearchCriteriaString: function(searchForm) {
           		    	 var me=this;
           		        var formValues = new Array();
           		        formValues = searchForm.getValues();        
           		        var searchCriteriaString="";
           		        for (var key in formValues) {
           		        	var value = formValues[key];            
           		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
           		              //  var keyValueJsonObject = me.getJsonObject( key , value);
           		//searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
           		            }
           		        }
           		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
           		        return searchCriteriaString;
           		}
	        
});
