/**
 * @author Bhanu PS
 * 
 */
Ext.define('Academia.controller.examinationcenters.manageEvaluation.RevaluationMarkentryController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationcenters.manageEvaluation.RevaluationMarkentryStore','examCenter.AssignSequence.EvaluationType'
	          ,'examinationcenters.CenterUseFor','examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
	          'attendance.CoursesForRevaluation','examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanForReval',
	          'attendance.VariantForReval','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramStore',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionStore','examinationcenters.evaluation.OtherCategory',
	          'examinationcenters.evaluation.coverageDetails.SectionForReval','examinationcenters.manageEvaluation.EvaluationEventForReval',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades','examCenter.AssignSequence.RevaluationTypeStore'],

	          views : ['examinationcenters.manageEvaluation.ManageRevaluationMasterStructure',
	                   'examinationcenters.manageEvaluation.RevaluationMarkentryFilter',
	                   'examinationcenters.manageEvaluation.RevaluationMarkentryGrid'],
	                   config:{
	                	   REVALUATION_MARKENTRY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REVALUATION_MARKENTRY_PRIVILEGES'),

	                   },           
	                   refs : [{
	                	   ref:'revaluationmarkentryfilter',
	                	   selector:'revaluationmarkentryfilter'
	                   },{
	                	   ref:'revaluationmarkentrygrid',
	                	   selector:'revaluationmarkentrygrid'
	                   },{
	                	   ref:'managerevaluationmasterstructure',
	                	   selector:'managerevaluationmasterstructure'
	                   }],
	                   init : function() {
	                	   this.control({

	                		   'managerevaluationmasterstructure':{
	                			   afterrender : function(structure){
	                				   var $this = this;
//	                				   var grid = structure.down('grid');
//	                				   $this.getGridHeaderFreeze(grid,structure, true);
	                			   }
	                		   },
	                		   'revaluationmarkentrygrid':{
	                			   render:function(grid){
	                				   buttonsToolBar = grid.query('toolbar')[0];
	                				   var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	                				   var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];

	                				   var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
	                				   var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
	                				   pdfAllBtn.setVisible(false);
	                				   excelAllBtn.setVisible(false);
	                				   this.doAccessControlValidation(grid, this.getREVALUATION_MARKENTRY_PERMISSION());
	                				   this.disableMoreActionGridPivileges(grid, this.getREVALUATION_MARKENTRY_PERMISSION());
	                			   },
	                			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	                				   var $this= this;
	                				   var grid = View.up();
	                				   var totalRevaluer = grid.getNoOfRevaluation(); 
	                				   for(var i =1; i<=totalRevaluer; i++) {
	                					   if(View.ownerCt.columnManager.columns[ColIdx].dataIndex=='revaluerMarks'+i){
	                						   if(record.data.marksOrGrade == "GRADE"){
	                							   var variantStore = grid.columnManager.columns[ColIdx].getEditor().getStore();
	                							   variantStore.getProxy().extraParams={
	                								   gradeType:record.data.gradeType
	                							   }
	                							   variantStore.load();
	                						   }
	                					   }
	                				   }
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter':{
	                			   beforerender : function(obj){
	                				   var $this= this;
	                				   var form = $this.getRevaluationmarkentryfilter().getForm();
	                				   var type = form.findField('evaluationType');
	                				   var stage = form.findField('evaluationStage').hide();
	                				   var sectionsId = form.findField('sectionsId');
	                				   var course = form.findField('course_name');
	                				   var programField = form.findField('programId');
	                				   var revaluationTypeEnum = form.findField('revaluationTypeEnum');
	                				   revaluationTypeEnum.getStore().load();
	                				   programField.allowBlank = true;
	                				   sectionsId.setDisabled(true);
	                				   type.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   type.setValue(records[0].data.id);
	                					   }	   
	                				   });
	                				   stage.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   stage.setValue(records[1].data.id);
	                					   }	   
	                				   });
	                				   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   form.findField('evalautionPlanNo').setVisible(false);
	                				   course.getStore().getProxy().extraParams = {
	                					   academyLocationId:$this.getCurrentAcademyLocation()
	                				   };
	                				   course.getStore().load();
	                			   }
	                		   },

	                		   'revaluationmarkentryfilter combo[itemId=evalautionPlanItemId]':{
	                			   select : function(obj, record){
	                				   var $this= this;
	                				   var form = $this.getRevaluationmarkentryfilter().getForm();
	                				   form.isDynamicScheme=record[0].get('check');
	                				   var courseVariantField = form.findField('courseVariant');
	                				   var course = form.findField('course_name');
	                				   var detailSequence = form.findField('detailSequence');
	                				   detailSequence.setDisabled(false);
	                				   var formValue = form.getValues();
	                				   detailSequence.getStore().getProxy().extraParams = {
	                					   evalPlanId:form.findField('evalautionPlan').getValue(),
	                					   rmAnonEvent:formValue.anonymousEventReval,
	                					   isDynamicScheme:record[0].get('check')
	                				   };
	                				   detailSequence.getStore().load();
	                				   courseVariantField.reset();
	                				   courseVariantField.setDisabled(false);
	                				   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   courseVariantField.getStore().getProxy().extraParams = {
	                					   courseId:course.getValue(),
	                					   academyLocationId:academyLocationId,
	                					   evaluationPlanId:form.findField('evalautionPlan').getValue()
	                				   };
	                				   courseVariantField.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=courseItemId]':{
	                			   select:function(obj,rec){
	                				   var $this = this;
	                				   var form=obj.up('form').getForm();
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
  				                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   var courseId=rec[0].data.id;
	                				   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   var plan = form.findField('evalautionPlan'); 
	                				   var courseVariant = form.findField('courseVariant');
	                				   var sectionField=form.findField('sectionsId');
	                				   plan.reset();
	                				   courseVariant.reset();
	                				   sectionField.reset();
	                				   plan.setDisabled(false);
	                				   var event = form.findField('detailSequence');
	                				   plan.getStore().getProxy().extraParams = {
	                					   evaluationPlanType : getExaminationTranslation('CNTRL_ACADEMICS') ,
	                					   evaluationStage : 'COURSE_EXECUTION',
	                					   academyLocationId : $this.getCurrentAcademyLocation(),
	                					   courseId : courseId,
	                					   wheatherSchool:wheatherSchool
	                				   };
	                				   var formValue = form.getValues();
	                				   plan.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length == 1){
	                								  	 form.isDynamicScheme=records[0].get('check');
	                								   plan.setValue(records[0].data.id);
	                								   event.setDisabled(false);
	                								   event.getStore().getProxy().extraParams = {
	                									   evalPlanId:form.findField('evalautionPlan').getValue(),
	                									   rmAnonEvent:formValue.anonymousEventReval,
	                									   isDynamicScheme:records[0].get('check')
	                								   };
	                								   event.getStore().load();
	                								  
	                								   courseVariant.enable();
	                								   var academyLocationId=$this.getCurrentAcademyLocation();
	                								   var store = courseVariant.getStore();
	                								   var portalId = $this.getCurrentLoggedPortalId();
	                								   store.getProxy().extraParams = {
	                									   evaluationPlanId:form.findField('evalautionPlan').getValue(),
	                									   courseId:courseId,
	                									   academyLocationId:academyLocationId,
	                									   wheatherSchool:wheatherSchool
	                								   };
	                								   store.getProxy().extraParams = {
	                									   courseId:courseId,
	                									   evaluationPlanId:form.findField('evalautionPlan').getValue(),
	                									   wheatherSchool:wheatherSchool
	                								   };
	                								   store.load();
	                							   }
	                						   }
	                					   }	   
	                				   });
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=evaluationStageItemId]':{
	                			   select:function(obj,rec){
	                				   var form=obj.up('form').getForm();
	                				   var $this = this;
	                				   var plan = form.findField("evalautionPlan");
	                				   var type = form.findField("evaluationType");
	                				   var stage = form.findField("evaluationStage");
	                				   plan.reset();
	                				   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   if(type.getValue()==getExaminationTranslation('CNTRL_ACADEMICS')) {
	                					   plan.getStore().getProxy().extraParams = {
	                						   evaluationPlanType : type.getValue() ,
	                						   evaluationStage : stage.getValue(),
	                						   academyLocationId : $this.getCurrentAcademyLocation(),
	                					   };
	                					   plan.getStore().load();
	                				   }
	                				   else {
	                					   var evalautionPlanNo = form.findField("evalautionPlanNo");
	                					   evalautionPlanNo.getStore().getProxy().extraParams = {
	                						   evaluationPlanType : getExaminationTranslation('OTHER'),
	                						   evaluationStage : stage.getValue(),
	                						   academyLocationId : $this.getCurrentAcademyLocation(),
	                					   };
	                					   evalautionPlanNo.getStore().load();
	                				   }
	                			   }
	                		   },

	                		   'revaluationmarkentryfilter customcombobox[itemId=evalautionPlanNoItemId]':{
	                			   select:function(obj,rec){
	                				   var val=rec[0].data.id;
	                				   var evalPlanFIlterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   evalPlanFIlterForm.isValid();
	                				   var form=obj.up('form').getForm();
	                				   var programField = form.findField('programId'); //evaluationPlanId
	                				   programField.setDisabled(false);
	                				   programField.reset();
	                				   programField.getStore().getProxy().extraParams = {
	                					   evaluationPlanId:val
	                				   };
	                				   programField.getStore().load();
	                				   var event = form.findField('detailSequence');
	                				   event.setDisabled(false);
	                				   event.getStore().getProxy().extraParams = {
	                					   evalPlanId : val,
	                					   rmAnonEvent:evalPlanFIlterForm.anonymousEventReval
	                				   };
	                				   event.getStore().load();
	                				   form.findField('detailSequence').enable();
	                				   form.findField('courseVariant').enable();
	                				   form.isValid();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=detailSequenceItemId]':{
	                			   select:function(obj,rec){
	                				   var form=obj.up('form').getForm();
	                				   var filter = obj.up('form');
	                				   var status=rec[0].data.code;
	                				   form.findField('evaluationEventStatus').setValue(status);
	                				   form.isValid();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=evaluationTypeItemId]':{
	                			   select:function(obj,rec){
	                				   var $this = this;
	                				   var form=obj.up('form').getForm();
	                				   var val=form.findField('evaluationType').getValue();
	                				   var courseField=form.findField('course_name'); 
	                				   var evaluationStage=form.findField('evaluationStage'); 
	                				   evaluationStage.reset();
	                				   var externalCourseField=form.findField('externalCourseMaster');
	                				   var categoryField=form.findField('category');
	                				   var evalautionPlanNoField=form.findField('evalautionPlanNo');
	                				   var sectionsId = form.findField('sectionsId');
	                				   var plan = form.findField('evalautionPlan');
	                				   var btnGenerateFoils = obj.up('form').down('#generateFoils');
	                				   var detailSequenceField=form.findField('detailSequence');
	                				   var programField = form.findField('programId');
	                				   var batchField  = form.findField('batchId');
	                				   var periodField = form.findField('periodId');
	                				   var sectionField  = form.findField('sectionId');

	                				   var courseVariantField = form.findField('courseVariant');

	                				   var portalId = $this.getCurrentLoggedPortalId();
	                				   var facultyId = $this.getCurrentlyLoggedInUser();

	                				   sectionField.setVisible(false);
	                				   sectionField.setDisabled(true);
	                				   sectionField.reset();
	                				   courseVariantField.setVisible(true);
	                				   courseVariantField.setDisabled(true);
	                				   courseVariantField.reset();

	                				   evalautionPlanNoField.setDisabled(true);
	                				   evalautionPlanNoField.reset();
	                				   detailSequenceField.setDisabled(true);
	                				   detailSequenceField.reset();

	                				   form.findField('evalautionPlanNo').enable();

	                				   programField.setVisible(false);
	                				   batchField.setVisible(false);
	                				   periodField.setVisible(false);
	                				   batchField.setDisabled(true);
	                				   periodField.setDisabled(true);

	                				   programField.reset();
	                				   batchField.reset();
	                				   periodField.reset();

	                				   courseField.setDisabled(true);
	                				   courseField.setVisible(false);
	                				   courseField.reset();

	                				   plan.setVisible(false);
	                				   plan.setDisabled(true);
	                				   plan.reset();
	                				   categoryField.setVisible(false);
	                				   categoryField.setDisabled(true);
	                				   categoryField.reset();
	                				   btnGenerateFoils.setVisible(false);
	                				   var academyLocationId=this.getCurrentAcademyLocation();	  
	                				   var loggedInUserInfo=this.getCurrentlyLoggedInUser();
	                				   if(val==getExaminationTranslation('CNTRL_ACADEMICS')){
	                					   btnGenerateFoils.setVisible(true);
	                					   sectionsId.setVisible(true);
	                					   sectionsId.setDisabled(true);
	                					   sectionsId.reset();
	                					   courseField.setVisible(true);
	                					   courseField.allowBlank=false;
	                					   courseField.setDisabled(false);
	                					   evalautionPlanNoField.setVisible(false);
	                					   evalautionPlanNoField.setDisabled(true);
	                					   evalautionPlanNoField.reset();
	                					   plan.setVisible(true);
	                					   plan.setDisabled(true);
	                					   plan.reset();
	                					   plan.getStore().getProxy().extraParams = {
	                						   evaluationPlanType : getExaminationTranslation('CNTRL_ACADEMICS') ,
	                						   evaluationStage : evaluationStage.getRawValue(),
	                						   academyLocationId : $this.getCurrentAcademyLocation(),
	                					   };
	                					   plan.getStore().load();

	                					   courseField.getStore().getProxy().extraParams = {
	                						   academyLocationId : $this.getCurrentAcademyLocation()
	                					   };
	                					   courseField.getStore().load();
	                					   programField.allowBlank=true;

	                				   }else if(val==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
	                					   externalCourseField.setVisible(true);
	                					   externalCourseField.enable();
	                					   sectionField.setDisabled(false);

	                				   }else if(val==getExaminationTranslation('CNTRL_OTHER')){
	                					   programField.setVisible(true);
	                					   programField.setDisabled(true);
	                					   programField.allowBlank=false;
	                					   batchField.setVisible(true);
	                					   periodField.setVisible(true);
	                					   categoryField.setVisible(false);
	                					   categoryField.setDisabled(true);
	                					   courseVariantField.reset();
	                					   courseVariantField.setDisabled(true);
	                					   courseField.allowBlank=true;
	                					   courseVariantField.setVisible(false);
	                					   courseVariantField.allowBlank=true;
	                					   sectionField.setVisible(true);
	                					   plan.setDisabled(true);
	                					   plan.setVisible(false);
	                					   plan.reset();
	                					   sectionsId.setVisible(false);
	                					   sectionsId.setDisabled(true);
	                					   sectionsId.reset();
	                					   evalautionPlanNoField.setDisabled(false);
	                					   evalautionPlanNoField.setVisible(true);
	                					   evalautionPlanNoField.reset();
	                					   evalautionPlanNoField.getStore().getProxy().extraParams = {
	                						   evaluationPlanType : getExaminationTranslation('OTHER') ,
	                						   evaluationStage : evaluationStage.getRawValue(),
	                						   academyLocationId : $this.getCurrentAcademyLocation(),
	                					   };
	                					   evalautionPlanNoField.getStore().load();
	                					   form.isValid();
	                				   }
	                				   form.isValid();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=courseVariantItemId]':{
	                			   select:function(obj,rec){
	                				   var coursevariantId=rec[0].data.id;
	                				   var evalPlanFIlterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var $this =this;
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
  				                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   var evalautionPlanNo=evalPlanFIlterForm.findField('evalautionPlan');
	                				   var evaluationStage=evalPlanFIlterForm.findField('evaluationStage');
	                				   var sectionsId = evalPlanFIlterForm.findField('sectionsId');
	                				   var cvIds=[];
	                				   cvIds.push(coursevariantId);
	                				   sectionsId.reset();
	                				   sectionsId.setDisabled(false);
	                				   sectionsId.getStore().getProxy().extraParams = {
	                					   courseVariantIds:cvIds.join(),
	                					   wheatherSchool:wheatherSchool
	                				   };
	                				   sectionsId.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   var arr = [];
	                						   for(var i in records){
	                							   arr.push(records[i].data.id);
	                						   }
	                						   sectionsId.setValue(arr);
	                					   }
	                				   });
	                				   evalPlanFIlterForm.isValid();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=programIdQuickFiltr]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var batchField=filterForm.findField('batchId');
	                				   var periodField=filterForm.findField('periodId');
	                				   var sectionField=filterForm.findField('sectionId');
	                				   var evalautionPlanNo=filterForm.findField('evalautionPlanNo');
	                				   periodField.reset();
	                				   periodField.setDisabled(true);
	                				   sectionField.setDisabled(true);
	                				   sectionField.reset();
	                				   periodField.setDisabled(true);
	                				   batchField.reset();
	                				   batchField.enable();
	                				   batchField.getStore().getProxy().extraParams = {
	                					   evaluationPlanId:evalautionPlanNo.getValue(),
	                					   programId:data
	                				   };
	                				   batchField.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length == 1){
	                								   batchField.setValue(records[0].data.id);
	                							   }		 
	                						   }

	                						   periodField.enable();
	                						   var storePeriod = periodField.getStore();
	                						   storePeriod.getProxy().extraParams = {
	                							   batchId:records[0].data.id,
	                						   };

	                						   storePeriod.load({
	                							   callback: function(rec, operation, success) {
	                								   if (success) {
	                									   if(records.length == 1){
	                										   periodField.setValue(rec[0].data.id);
	                										   sectionField.setDisabled(false);
	                										   sectionField.reset();
	                										   sectionField.getStore().getProxy().extraParams={
	                											   evaluationPlanId:evalautionPlanNo.getValue(),
	                											   programId:data,
	                											   batchId:records[0].data.id,
	                											   periodId:rec[0].data.id
	                										   };
	                										   sectionField.getStore().load();
	                									   }		 
	                								   }
	                							   }	   
	                						   });
	                					   }	   
	                				   });
	                				   var detailSequence = filterForm.findField('detailSequence');
	                				   detailSequence.reset();
	                				   detailSequence.getStore().getProxy().extraParams = {
	                					   evalPlanId : evalautionPlanNo.getValue(),
	                					   programId:data,
	                				   };
	                				   detailSequence.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=batchIdQuickFiltr]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var periodField=filterForm.findField('periodId');
	                				   var programId=filterForm.findField('programId');
	                				   var sectionField=filterForm.findField('sectionId');
	                				   var evalautionPlanNo=filterForm.findField('evalautionPlanNo');
	                				   sectionField.setDisabled(true);
	                				   sectionField.reset();
	                				   periodField.enable();
	                				   periodField.reset();
	                				   periodField.getStore().getProxy().extraParams = {
	                					   evaluationPlanId:evalautionPlanNo.getValue(),
	                					   programId:programId.getValue(),
	                					   batchId:data
	                				   };
	                				   periodField.getStore().load();
	                				   var detailSequence = filterForm.findField('detailSequence');
	                				   detailSequence.reset();
	                				   detailSequence.getStore().getProxy().extraParams = {
	                					   evalPlanId : evalautionPlanNo.getValue(),
	                					   programId:programId.getValue(),
	                					   batchId:data,
	                				   };
	                				   detailSequence.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=periodIdQuickFiltr]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var sectionField=filterForm.findField('sectionId');
	                				   var programId=filterForm.findField('programId');
	                				   var batchId=filterForm.findField('batchId');
	                				   var evalautionPlanNo=filterForm.findField('evalautionPlanNo');
	                				   sectionField.enable();
	                				   sectionField.reset();
	                				   sectionField.getStore().getProxy().extraParams = {
	                					   evaluationPlanId : evalautionPlanNo.getValue(),
	                					   programId:programId.getValue(),
	                					   batchId:batchId.getValue(),
	                					   periodId:data,
	                				   };
	                				   sectionField.getStore().load();
	                				   var detailSequence = filterForm.findField('detailSequence');
	                				   detailSequence.reset();
	                				   detailSequence.getStore().getProxy().extraParams = {
	                					   evalPlanId : evalautionPlanNo.getValue(),
	                					   programId:programId.getValue(),
	                					   batchId:batchId.getValue(),
	                					   periodId:data,
	                				   };
	                				   detailSequence.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter customcombobox[itemId=sectionIdQuickFiltr]':{
	                			   select:function(obj,rec){
	                				   var data=rec[0].data.id;
	                				   var filterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var sectionField=filterForm.findField('sectionId');
	                				   var programId=filterForm.findField('programId');
	                				   var batchId=filterForm.findField('batchId');
	                				   var periodId=filterForm.findField('periodId');
	                				   var evalautionPlanNo=filterForm.findField('evalautionPlanNo');
	                				   var detailSequence = filterForm.findField('detailSequence');
	                				   detailSequence.reset();
	                				   detailSequence.getStore().getProxy().extraParams = {
	                					   evalPlanId : evalautionPlanNo.getValue(),
	                					   programId:programId.getValue(),
	                					   batchId:batchId.getValue(),
	                					   periodId:periodId.getValue(),
	                					   sectionIds:sectionField.getValue(),
	                				   };
	                				   detailSequence.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter button[itemId=searchBtn]':{
	                			   click:function(obj){
	                				   var form=obj.up('form').getForm();
	                				   var detailSequenceVal=form.findField('detailSequence').getValue();
	                				   var courseVariantVal=form.findField('courseVariant').getValue();
	                				   var type = form.findField("evaluationType");
	                				   if(detailSequenceVal!=null&&detailSequenceVal>0){
	                					   if(type.getValue() == getExaminationTranslation('CNTRL_ACADEMICS')){
	                						   if(!isNullOrEmpty(courseVariantVal)){
	                							   this.loadResultGridDataForFaculty(detailSequenceVal,courseVariantVal);
	                						   }else{
	                							   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('SELECTION_ALERT_MSG'));
	                						   }
	                					   }else{
	                						   this.loadResultGridDataForFaculty(detailSequenceVal);
	                					   }
	                				   }else{
	                					   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('WARNING_MSG_SELECT_DETAIL_SEQUENCE'));
	                				   }
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter button[itemId=resetBtn]':{
	                			   click:function(){
	                				   var filterForm=this.getRevaluationmarkentryfilter().getForm();
	                				   var $this = this;
	                				   var course = filterForm.findField('course_name');
	                				   var category = filterForm.findField('category');
	                				   var detailSequence = filterForm.findField('detailSequence');
	                				   var evalautionPlanNo = filterForm.findField('evalautionPlanNo');
	                				   var sectionId = filterForm.findField('sectionId');
	                				   var programId = filterForm.findField('programId');
	                				   var batchId = filterForm.findField('batchId');
	                				   var periodId = filterForm.findField('periodId');
	                				   var sectionsId = filterForm.findField('sectionsId');
	                				   var plan = filterForm.findField("evalautionPlan");
	                				   var type = filterForm.findField("evaluationType");
	                				   var stage = filterForm.findField("evaluationStage");
	                				   var course = filterForm.findField('course_name');
									    
	                				   var courseVariant = filterForm.findField('courseVariant');//courseVariant
	                				   type.getStore().load({  
	                					   callback: function(records, operation, success) {
	                						   type.setValue(records[0].data.id);
	                					   }	   
	                				   });
	                				   stage.getStore().load({
	                					   callback: function(records, operation, success) {
	                						   stage.setValue(records[1].data.id);
	                					   }	   
	                				   });   
	                				   plan.setVisible(true);
	                				   plan.setDisabled(true);
	                				   plan.reset();
	                				   filterForm.findField('evalautionPlanNo').setVisible(false);
	                				   periodId.setVisible(false);
	                				   batchId.setVisible(false);
	                				   programId.setVisible(false);
	                				   course.setDisabled(false);
	                				   course.setVisible(true);
	                				   category.setVisible(false);
	                				   category.setDisabled(true);
	                				   detailSequence.setDisabled(false);  // V2D-402243
	                				   courseVariant.setDisabled(true);
	                				   courseVariant.reset();
	                				   courseVariant.setVisible(true);
	                				   evalautionPlanNo.setVisible(false);
	                				   evalautionPlanNo.setDisabled(true);
	                				   sectionId.setVisible(false); 
	                				   sectionId.setDisabled(true);
	                				   sectionsId.reset();
	                				   sectionsId.setDisabled(true);
	                				   sectionsId.setVisible(true);
	                				   filterForm.reset();
	                				   stage.setValue('COURSE_EXECUTION');
	                				   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   course.getStore().getProxy().extraParams = {
	                					   academyLocationId:$this.getCurrentAcademyLocation()
	                				   };
	                				   course.getStore().load();
	                			   }
	                		   },
	                		   'revaluationmarkentryfilter radiogroup[itemId=anonymousRevalEvent]':{
	                			   change : function(cb, nv, ov){
	                				   var $this = this;
	                				   var form = $this.getRevaluationmarkentryfilter();
	                				   var masterGrid=this.getRevaluationmarkentrygrid();
	                				   var filterForm= form.getForm();
	                				   var isDynamicSchemeValue=filterForm.isDynamicScheme;
	                				   var event = form.down('#detailSequenceItemId').getStore();
	                				   var evalPlanId=form.getForm().findField('evalautionPlan').getValue()!=null?
	                						   form.getForm().findField('evalautionPlan').getValue():
	                							   form.getForm().findField('evalautionPlanNo').getValue();
	                						   if(nv.anonymousEventReval == true){ 
	                							   event.getProxy().extraParams={
	                								   evalPlanId:evalPlanId,
	                								   rmAnonEvent:true,
	                								   isDynamicScheme:isDynamicSchemeValue
	                							   }
	                						   } else {
	                							   event.getProxy().extraParams={
	                								   evalPlanId:form.getForm().findField('evalautionPlan').getValue(),
	                								   rmAnonEvent:false,
	                								   isDynamicScheme:isDynamicSchemeValue
	                							   }
	                						   }
	                						   event.load();
	                			   }
	                		   },

	                		   'revaluationmarkentrygrid button[itemId=btnCalcullate]':{
	                			   click:function(obj){
	                				   var $this=this;
	                				   var grid=$this.getRevaluationmarkentrygrid();
	                				   if(grid.getSelectionModel().getCount()>0){
	                					   var records = grid.getSelectionModel().getSelection();
	                					   var totalRevaluer = grid.getNoOfRevaluation(); 
	                					   var submitJson=[];
	                					   var facultyId = $this.getCurrentlyLoggedInUser();
	                					   for(var i in records) {
	                						   var flag = false, totalEmpty=0;
	                						   for(var j=1; j <= totalRevaluer; j++){
	                							   if(!isNullOrEmpty(records[i].get('revaluerMarks'+j))){
	                								   var revaluer = {
	                										   "id":facultyId.id
	                								   };
	                								   var esrId = {
	                										   "id":records[i].data.id
	                								   };
	                								   if(records[0].data.marksOrGrade=="MARK"){
	                									   if(!isNullOrEmpty(records[i].data.revaluaerMarksMap)){
	                										   var json={
	                												   "id":Object.keys(records[i].data.revaluaerMarksMap)[j-1],
	                												   "examinationStudentRevaluation":esrId,
	                												   "revaluerId":revaluer,
	                												   "revaluationMarks":records[i].get('revaluerMarks'+j)
	                										   };
	                									   } else {
	                										   var json={
	                												   "examinationStudentRevaluation":esrId,
	                												   "revaluerId":revaluer,
	                												   "revaluationMarks":records[i].get('revaluerMarks'+j)
	                										   };
	                									   }
	                								   } else {
	                									   if(!isNullOrEmpty(records[i].data.revaluaerGradeMap)){
	                										   var json={
	                												   "id":Object.keys(records[i].data.revaluaerGradeMap)[j-1],
	                												   "examinationStudentRevaluation":esrId,
	                												   "revaluerId":revaluer,
	                												   "revaluationGrade":records[i].get('revaluerMarks'+j)
	                										   };
	                									   } else {
	                										   var json={
	                												   "examinationStudentRevaluation":esrId,
	                												   "revaluerId":revaluer,
	                												   "revaluationGrade":records[i].get('revaluerMarks'+j)
	                										   };
	                									   }
	                								   }
	                								   submitJson.push(json)
	                							   } else{
	                								   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Selected row having empty markentry please verify.!'));
	                								   return;
	                							   }
	                						   }
	                					   }
	                					   if(!isNullOrEmpty(submitJson) && submitJson.length>0) {
	                						   var submitUrl = SERVERURL.PATH_SAVE_EXAMINATION_STUDENT_REVAL_MARKING;
	                						   showConfirmMessage(getCommonTranslation('WARNING'),
	                								   getExaminationTranslation('REVAL_MARKS_SUBMIT_ALERT'),
	                								   function(btn, text) {
	                							   if (btn == 'yes') {
	                								   Ext.Ajax.request({
	                									   type : 'rest',
	                									   url : submitUrl,
	                									   jsonData : submitJson,
	                									   method : 'POST',
	                									   success : function(resp, action) {
	                										   if(resp.responseText=="SUCCESS"){
	                											   showSuccessMessage(getExaminationTranslation('Success'),getCommonTranslation('SUCCESS'));
	                											   grid.getSelectionModel().deselectAll();
	                											   grid.getStore().reload();
	                										   }
	                									   }
	                								   });
	                							   }
	                						   });
	                					   }
	                				   }else{
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },

//	                		   'manageevalresultgridwindow[itemId=faculty]  button[itemId=saveBtn]':{
//	                			   click:function(button){
//	                				   this.saveFacultyManageEvaluationResult(button);
//	                			   }
//	                		   },
//
//	                		   'manageevalresultgridwindow[itemId=faculty]  button[itemId=submitBtn]':{
//	                			   click:function(button){
//	                				   this.saveFacultyManageEvaluationResult(button);
//	                			   }
//	                		   },

	                		   'generatefoilswin[itemId=faculty] button[itemId=submitBtn]':{
	                			   click:function(obj){
	                				   var $this = this;
	                				   $this.generateGenerateFacultyFoilsReport();
	                			   }
	                		   },

	                	   });
	                   },

	                   disableMoreActionGridPivileges: function(structure,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var btnCalcullate = structure.down('#btnCalcullate');
	                	   btnCalcullate.setVisible(false);
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'CALCULAT_MARKS') {
	                			   if(!isNullOrEmpty(btnCalcullate)){
	                				   btnCalcullate.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },

	                   loadResultGridDataForFaculty:function(evalDetailSeqId,courseVariantVal){
	                	   var $this=this;
	                	   var grid=$this.getRevaluationmarkentrygrid();
	                	   var form=null;
	                	   var evalPlanFilterForm=$this.getRevaluationmarkentryfilter();
	                	   var sectionId= evalPlanFilterForm.getForm().findField('sectionId').getValue();
	                	   var programId= evalPlanFilterForm.getForm().findField('programId').getValue();
	                	   var batchId= evalPlanFilterForm.getForm().findField('batchId').getValue();
	                	   var periodId= evalPlanFilterForm.getForm().findField('periodId').getValue();
	                	   var formValues = evalPlanFilterForm.getForm().getValues();
	                	   form=evalPlanFilterForm.getForm();
	                	   var store=grid.getStore();
	                	   store.getProxy().extraParams = {
	                		   eventId: evalDetailSeqId,
	                		   courseVariantId:courseVariantVal,
	                		   sectionId:sectionId,
	                		   programId:programId,
	                		   batchId:batchId,
	                		   periodId:periodId,
	                		   whetherExamAttended:true,
	                		   revaluationType:formValues.revaluationTypeEnum
	                	   };
	                	   var gridColumns = grid.columns;
	                	   var len = gridColumns.length;
	                	   store.load({
	                		   callback:function(record) {
	                			   if(record.length>0) {
	                				   var remarkField = grid.down('#remarkForMarkentryId');
	                				   remarkField.setValue('Max Marks or Grade :'
	                						   +(!isNullOrEmpty(record[0].data.maxMarks)?record[0].data.maxMarks:record[0].data.maxGrade)+ 
	                						   '  & Minimum Passing Marks or Grade :'
	                						   +(!isNullOrEmpty(record[0].data.minMarks)?record[0].data.minMarks:record[0].data.minGrade));
	                				   remarkField.setVisible(true);
	                				   var columnModel = [{
	                					   header: getExaminationTranslation('ADMISSION_ID'),
	                					   dataIndex: 'admissionCode',
	                			//		   flex:.1,
	                					   width:grid.getWidth()/11,
	                					   sortable: false,
	                					   hidden:true
	                				   },{
	                					   header: getExaminationTranslation('STUDENT_ID'),
	                					   dataIndex: 'studentCode',
	                					   width:grid.getWidth()/11,
	                		//			   flex:.1,
	                					   sortable: false
	                				   }, {
	                					   header: getExaminationTranslation('STUDENT_NAME'),
	                					   dataIndex: 'studentName',
	                					   width:grid.getWidth()/11,
	                	//				   flex:.1,
	                					   sortable: false
	                				   }, {
	                					   header: getExaminationTranslation('PROGRAM'),
	                					   dataIndex: 'programName',
	                					   width:grid.getWidth()/11,
	                //					   flex:.1,
	                					   sortable: false
	                				   }, {
	                					   header: getExaminationTranslation('BATCH'),
	                					   dataIndex: 'batchName',
	                					   width:grid.getWidth()/11,
	                //					   flex:.1,
	                					   sortable: false
	                				   },{
	                					   header: getExaminationTranslation('PERIOD_NAME'),
	                					   dataIndex: 'periodName',
	                					   width:grid.getWidth()/11,
	                //					   flex:.1,
	                					   sortable: false
	                				   }, {
	                					   header: getExaminationTranslation('PREVIOUS_MARKS_GRADE'),
	                					   dataIndex: 'previousMarks',
	                					   width:grid.getWidth()/11,
	                //					   flex:.1,
	                					   sortable: false,
	                					   renderer:function(value,meta,record){
	                						   if(!isNullOrEmpty(record.data.previousGrade)){
	                							   if(!isNullOrEmpty(record.data.previousMarks)){
	                								   return record.data.previousMarks+" / "+record.data.previousGrade;
	                							   } else {
	                								   return record.data.previousGrade;
	                							   }
	                						   }else {
	                							   if(!isNullOrEmpty(record.data.previousMarks)){
	                								   return record.data.previousMarks;
	                							   } else {
	                								   return "-";
	                							   }
	                						   }
	                					   }	
	                				   },{
	                					   header: getExaminationTranslation('PREVIOUS_STATUS'),
	                					   dataIndex: 'resultStatus',
	                					   width:grid.getWidth()/11,
	               // 					   flex:.1,
	                					   sortable: false,
	                					   renderer:function(value){
	                						   if(value){
	                							   return getExaminationTranslation(value);
	                						   }else {
	                							   return value;
	                						   }
	                					   }
	                				   }];
	                				   Ext.apply(grid,{
	                					   noOfRevaluation:null,
	                					   setNoOfRevaluation : function(noOfRevaluation){
	                						   form.noOfRevaluation = noOfRevaluation;
	                					   },
	                					   getNoOfRevaluation:function(){
	                						   return form.noOfRevaluation;
	                					   }
	                				   });
	                				   grid.setNoOfRevaluation(record[0].data.noOfRevaluers);
	                				   var models = grid.getStore().getRange();
	                				   if(record[0].data.marksOrGrade.toUpperCase() == 'MARK') {
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.revaluaerMarksMap)){
	                							   var count=1;
	                							   for(var k in record[i].data.revaluaerMarksMap){
	                								   models[i].set('revaluerMarks'+count,record[i].data.revaluaerMarksMap[k]); 
	                								   count++;
	                							   }
	                						   }
	                					   }
	                					   for (var i=1; i<= record[0].data.noOfRevaluers; i++) {
	                						   var models = grid.getStore().getRange();
	                						   var column = Ext.create('Ext.grid.column.Column', {
	                							   header:  getCommonTranslation('Marks By Revaluer '+i),
	                							   dataIndex: 'revaluerMarks'+i,
	                							   sortable: false,
	                							   width:grid.getWidth()/11,
	                	//						   flex:.1,
	                							   editor: {
	                								   xtype: 'numberfield',
	                								   name:'graceMarks',
	                								   decimalPrecision : 2,
	                								   mouseWheelEnabled:false,
	                								   minValue:parseInt(parseInt(record[0].data.minMarksOrGradeAward)),
	                								   maxValue:parseInt(record[0].data.maxMarks),
	                								   decimalPrecision:4
	                							   },
	                							   renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                								   if(!isNullOrEmpty(val)) {
	                									   return val;
	                								   }else {
	                									   rec.tdCls = 'gridInputCustomStyle'; 
	                									   return getExaminationTranslation('CLICK_TO_ENTER');
	                								   }	
	                							   }
	                						   });
	                						   columnModel.push(column) ;           				   
	                					   }
	                				   }  else {
	                					   for (var i=1; i<= record[0].data.noOfRevaluers; i++) {
	                						   var column = Ext.create('Ext.grid.column.Column', {
	                							   header:  getCommonTranslation('Marks By Revaluer '+i),
	                							   dataIndex: 'revaluerMarks'+i,
	                							   sortable: false,
	                							   width:grid.getWidth()/11,
	                //							   flex:.1,
	                							   editor: {
	                								   xtype: 'customcombobox',
	                								   itemId:'marks',
	                								   name:'marksItemId',
	                								   displayField: 'gradeName',
	                								   valuefield:'gradeName',
	                								   editable:false,
	                								   listeners: {
	                									   render: function(combo) {
	                										   var store = Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
	                										   combo.bindStore(store);
	                									   }
	                								   }
	                							   },
	                							   renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	                								   if(!isNullOrEmpty(val)) {
	                									   return getCommonTranslation(''+val);
	                								   }else {
	                									   rec.tdCls = 'gridInputCustomStyle'; 
	                									   return getExaminationTranslation('CLICK_TO_ENTER');
	                								   }	
	                							   }
	                						   });
	                						   columnModel.push(column) ;    
	                					   }
	                				   }
	                				   columnModel.push({
	                					   header: getExaminationTranslation('REVALUATION_STATUS'),
	                					   dataIndex: 'revaluationResultStatus',
	                					   width:grid.getWidth()/11,
	             //   					   flex:.1,
	                					   sortable: false,
	                					   renderer:function(value){
	                						   if(value){
	                							   return getExaminationTranslation(value);
	                						   }else {
	                							   return value;
	                						   }
	                					   }
	                				   },{
	                					   header: getExaminationTranslation('EFFECTIVE_MARKS'),
	                					   dataIndex: 'revaluerMarks',
	        //        					   flex:.1,
	                					   sortable: false
	                				   });
	                				   grid.reconfigure(null,columnModel);
	                				   grid.getView().refresh();
	                			   }
	                		   }
	                	   });
	                   },


	                   generateGenerateFacultyFoilsReport:function() {
	                	   var $this = this;
	                	   var form = $this.getRevaluationmarkentryfilter().getForm(); 
	                	   var formValues = form.getValues();

	                	   var detailSequenceVal=form.findField('detailSequence').getValue();
	                	   var courseVariantVal=form.findField('courseVariant').getValue();
	                	   var courseId=form.findField('course_name').getValue();

	                	   var evalPlanFilterForm=$this.getRevaluationmarkentryfilter();
	                	   var generatefoilswin = $this.getGeneratefoilswin()
	                	   var tempCode = generatefoilswin.down('#chooseTemplate');
	                	   var course = form.findField('course_name').getValue();

	                	   var code =tempCode.valueModels[0].data.value;
	                	   var reportParams =new Object();
	                	   reportParams.EVENT_ID=detailSequenceVal;
	                	   reportParams.COURSEVARIANT_ID=courseVariantVal;
	                	   reportParams.COURSE_ID = courseId;

	                	   reportParams.code = code;
	                	   generatefoilswin.close();
	                	   var exportUrl = SERVERURL.PATH_GENERATE_FOILS_REPORT;
	                	   $this.exportJRXMLReport(code,reportParams,'Foils Report_'+form.findField('course_name').getRawValue()+"_"+form.findField('detailSequence').getRawValue(),'.pdf',exportUrl);
	                   },

	                   disableMoreButtonPivileges: function(grid,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var saveButton = grid.down('#saveBtn');
	                	   var submitButton = grid.down('#submitBtn');
	                	   saveButton.setVisible(false);
	                	   submitButton.setVisible(true);

	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'SAVEBUTTON') {
	                			   if(!isNullOrEmpty(saveButton)){
	                				   saveButton.setVisible(true);
	                			   }        		
	                		   }
	                		   if (privilege === 'SUBMIT') {
	                			   if(!isNullOrEmpty(submitButton)){
	                				   submitButton.setVisible(true);
	                			   }        		
	                		   }
	                		   if (privilege === 'SAVE') {
	                			   if(!isNullOrEmpty(saveButton)){
	                				   saveButton.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },
	                   disableMoreActionFacultyGridPivileges: function(structure,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var btnEdit = structure.down('#btnEdit');
	                	   var btnView = structure.down('#btnView');
	                	   btnEdit.setVisible(false);
	                	   btnView.setVisible(false);
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'GRID_EDIT_BTN') {
	                			   if(!isNullOrEmpty(btnEdit)){
	                				   btnEdit.setVisible(true);
	                			   }        		
	                		   } else if (privilege === 'GRID_VIEW_BTN') {
	                			   if(!isNullOrEmpty(btnView)){
	                				   btnView.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },

	                   saveFacultyManageEvaluationResultRMEC:function(button){

	                	   var $this=this;
	                	   var form=null;
	                	   var courseVariantIdValue=null;
	                	   var evalPlanFilterForm=$this.getRevaluationmarkentryfilter();

	                	   form=evalPlanFilterForm.getForm();
	                	   courseVariantIdValue=form.findField('courseVariant').getValue();


	                	   // var form=$this.getEvaluationplanfilter().getForm();
	                	   var detailSequenceVal=form.findField('detailSequence').getValue();

	                	   var grid=$this.getManageEvalResultGridWindow();
	                	   var windowForm=$this.getManageEvalResultFormWindow().getForm();
	                	   //var saveButton=$this.getManageevalresultgridwindow().down('#saveBtn');
	                	   //saveButton.setDisabled(true);
	                	   if (grid.getSelectionModel().getCount() > 0) {
	                		   var gridRecord=grid.getSelectionModel().getSelection();

	                		   var jsonData=[];
	                		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

	                		   Ext.Array.each(gridRecord, function(value) {	
	                			   if(!isNullOrEmpty(value.data.finalMarks) || !isNullOrEmpty(value.data.finalGrade)) {
	                				   var effectiveMarks=null;
	                				   var weitage=windowForm.findField('weightage').getValue();
	                				   if(weitage!=null && value.data.finalMarks!=null && value.data.finalMarks>=0){
	                					   effectiveMarks=(value.data.finalMarks*weitage)/100;
	                				   }
	                				   var portalId = $this.getCurrentLoggedPortalId();
	                				   var examResultStatusValue=null;
	                				   if(portalId  == 2) {
	                					   if(button.itemId=="saveBtn"){
	                						   examResultStatusValue=null;
	                					   } else {
	                						   examResultStatusValue="RESULT_ENTERED";
	                					   }
	                				   } else {
	                					   examResultStatusValue="RESULT_ENTERED";
	                				   }
	                				   var data={
	                						   "id":value.data.id,
	                						   "evaluationSequenceDetailId":value.data.evaluationSequenceDetailId,
	                						   "admissionId":value.data.admissionId,
	                						   "sectionId":value.data.sectionId,
	                						   "courseVariantId":value.data.courseVariantId,
	                						   "totalMarksGiven":value.data.totalMarks,
	                						   "penultyMarksGiven":value.data.penaltyMarks,
	                						   "graceMarksGiven":value.data.graceMarks,
	                						   "finalMarks":value.data.finalMarks,
	                						   "examResultStatus": examResultStatusValue,
	                						   "finalGrade":value.data.finalGrade,
	                						   "gradePoints":value.data.gradePoint,
	                						   "finalDescription":value.data.finalDescription,
	                						   "whetherRevaluation":false,
	                						   "effectiveMarks":effectiveMarks,
	                						   "whetherMalpracticeReported":false,//student.data.whetherMalpracticeReported
	                						   "whetherExamAttended":true,
	                						   "examUniqueCode":value.data.examUniqueCode,
	                						   "periodId":value.data.periodId
	                				   };
	                				   jsonData.push(data);
	                			   }
	                		   });

	                		   submitUrl = SERVERURL.PATH_SAVE_MARKENTRY_FOR_STUDENT;
	                		   Ext.Ajax.request({
	                			   type: 'rest',
	                			   url: submitUrl,
	                			   jsonData: jsonData,
	                			   method: 'POST',
	                			   success: function(obj, action) {
	                				   Ext.getBody().unmask();
	                				   if(obj.responseText!=""){
	                					   //saveButton.enable();
	                					   $this.loadResultGridDataForFaculty(detailSequenceVal,courseVariantIdValue);
	                					   /**
	                					    * Here another function is called to update detail sequence, its parameter status 
	                					    */
	                					   /*	$this.updateDetailSequenceDataStatus(detailSequenceVal);*/
	                					   /**
	                					    * this.updateDetailSequenceDataStatus(detailSequenceVal); commneted because we do not want to update the
	                					    * status from here now user will update the status from EPlan Hierarchy after all marks entered
	                					    */
	                					   //$this.updateDetailSequenceDataStatus(detailSequenceVal);
	                					   showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS')); 
	                					   $this.closeFacultyMarksEntryTab();
	                				   }
	                			   }
	                		   });
	                	   }else{
	                		   Ext.getBody().unmask();
	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	                	   }
	                   },
	                   closeFacultyMarksEntryTab:function(){
	                	   var me = this;
	                	   var contentpanel = me.getContentPanel();
	                	   if(!Ext.ComponentQuery.query('manageevalresultgridwindow')[0])
	                		   var manageEvalResulttab = Ext.widget('manageevalresultgridwindow');
	                	   var tabName = getExaminationTranslation('MANAGE_MARK_ENTRY');
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                	   }
	                   }

});