/**
 * @author Bhanu PS
 * 
 */
Ext.define('Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer','examinationcenters.evaluation.coverageDetails.CourseCoverageStore',
	          'examCenter.AssignSequence.RevaluationTypeByPeriod', 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'examinationcenters.studentportal.revaluation.StudentRevalGridStore','servicerequest.programcoursesectiontransfer.FindAllBatchsWithOutCurrentCheck',
	          'examCenter.AssignSequence.RevaluationTypeStore','examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore','common.CurrentBatchStore'],
	          
	          views : ['studentPortal.revaluation.RevaluationStudentStructure','studentPortal.revaluation.RevaluationStudentFilter',
	                   'studentPortal.revaluation.RevaluationStudentGrid','studentPortal.revaluation.RevalSummaryWin', 'studentPortal.revaluation.RevalTransactionWindow'],
	                   config:{
	                	   STUDENT_PORTAL_EXAM_REVALUATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_REVALUATION_PRIVILEGES'),
	                	   PARENT_PORTAL_EXAM_REVALUATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_REVALUATION_PRIVILEGES')
	                   },           
	                   refs : [{
	                	   ref: 'contentPanel',
	                	   selector: 'contentpanel'
	                   },{
	                	   ref:'revaluationstudentfilter',
	                	   selector:'revaluationstudentfilter'
	                   },{
	                	   ref:'revaluationstudentgrid',
	                	   selector:'revaluationstudentgrid'
	                   },{
	                	   ref:'revaluationstudentstructure',
	                	   selector:'revaluationstudentstructure'
	                   },{
	                	   ref:'personinfostudentportal',
	                	   selector:'personinfostudentportal'
	                   },{
	                	   ref:'revalsummarywin',
	                	   selector:'revalsummarywin'
	                   },{
	                	   ref:'revaltransactionwindow',
	                	   selector:'revaltransactionwindow'
	                   },{
	                       ref: 'documentFormWindow',
	                       selector: 'documentformwindow[itemId=offlinePaymentDocument]'
	                   },],
	                   init : function() {
	                	   this.control({
	                		   'revaluationstudentstructure':{
	                			   afterrender : function(structure){
	                				   var $this = this;
	                				   var grid = structure.down('#revaluationstudentgridportal');
	                				   $this.getGridHeaderFreeze(grid,structure.up(), true);
	                			   }
	                		   },

	                		   'revaluationstudentgrid':{
	                			   afterrender: function(grid) {
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var me = this;
	                				   setTimeout(function(){
	                					   if(portalId == 3){
	                						   me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_EXAM_REVALUATION_PERMISSION());
	                					   }
	                				   }, 1500);
	                			   },
	                			   render : function(grid){
	                				   var $this = this;
	                				   var portalId =  $this.getCurrentLoggedPortalId();
	                				   if(portalId == 7){
	                					   this.disableMoreActionGridPivileges(grid, $this.getPARENT_PORTAL_EXAM_REVALUATION_PERMISSION());
	                				   }else
	                				   {
	                					   this.disableMoreActionGridPivileges(grid, $this.getSTUDENT_PORTAL_EXAM_REVALUATION_PERMISSION());
	                				   }
	                				 
	                				   Ext.apply(grid,{
	                					   challengeCount:null,
	                					   setChallengeCount : function(challengeCount){
	                						   grid.challengeCount = challengeCount;
	                					   },
	                					   getChallengeCount:function(){
	                						   return grid.challengeCount;
	                					   }
	                				   });
	                				   Ext.apply(grid,{
	                					   bucket:null,
	                					   setBucket : function(bucket){
	                						   grid.bucket = bucket;
	                					   },
	                					   getBucket:function(){
	                						   return grid.bucket;
	                					   }
	                				   });
	                				   grid.setBucket(null);
	                				   grid.getStore().removeAll();
	                				   grid.getStore().loadData([]);
	                				   Ext.apply(grid,{
	                					   revaluationCount:null,
	                					   setRevaluationCount : function(revaluationCount){
	                						   grid.revaluationCount = revaluationCount;
	                					   },
	                					   getRevaluationCount:function(){
	                						   return grid.revaluationCount;
	                					   }
	                				   });
        							   var XMLHttpRequestObject = false;  
        							   if (window.XMLHttpRequest) {  
        								   XMLHttpRequestObject = new XMLHttpRequest();  
        								   XMLHttpRequestObject.overrideMimeType("text/xml");  
        							   }  
        							   else if (window.ActiveXObject) {  
        								   XMLHttpRequestObject = new  
        								   ActiveXObject("Microsoft.XMLHTTP");  
        							   } 
        							   var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
        							   var getcontroller=$this.getController('menu.CoreERPNavigationController');
        							   var getTab=getcontroller.getTab(tabName);
        							   var contentpanel = this.getContentPanel();
        							   if(XMLHttpRequestObject) {  
        								   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
        								   XMLHttpRequestObject.onreadystatechange = function() {       
        									   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
        										   var xmlDocument = XMLHttpRequestObject.responseXML;  
        										   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
        										   revalPostDataUrl = buildInfo.getElementsByTagName("revalPostDataUrl") [0].childNodes[0].nodeValue;
        										   Ext.apply(grid,{
        		                					   revalPath:null,
        		                					   setRevalPath : function(revalPath){
        		                						   grid.revalPath = revalPath;
        		                					   },
        		                					   getRevalPath:function(){
        		                						   return grid.revalPath;
        		                					   }
        		                				   });
        										   grid.setRevalPath(revalPostDataUrl);
        									   }  
        								   }  
        								   XMLHttpRequestObject.send(null);  
        							   }
	                			   },
	                			   
	                			   selectionchange: function(column, selected,eOpts ){
	                				   var $this = this;
	                				   var grid = $this.getRevaluationstudentgrid();
	                				   var tempStore=$this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   var records = tempStore.data.items;
	                				   uniqueAdmissionIds = new Ext.util.HashMap();
	                				   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
	                				   var btnApprove=grid.down('#btnApprove');
	                				   var btnApplyItemId=grid.down('#btnApplyItemId');
	                				   var btnApplyNow=grid.down('#btnApplyNowItemId');
	                				   var withFeeApplicable=false;
	                				   var withoutFeeApplicable=false;
	                				   var store = grid.getStore();
	                				   var models = store.getRange();
	                				   var withFeeReval=false;
	                				   var withChallenge=false;
	                				   var withReview=false;
	                				   var withoutReval=false;
	                				   var withoutChallenge=false;
	                				   var withoutReview=false;

	                				   var filterForm=this.getRevaluationstudentfilter();
	                				   var isRevalFeeApplicable=filterForm.down('#isRevalFeeApplicable').getValue();
	                				   var isReviewFeeApplicable=filterForm.down('#isReviewFeeApplicable').getValue();
	                				   var isChallengeFeeApplicable=filterForm.down('#isChallengeFeeApplicable').getValue();

	                				   for(var i in selected) {
	                					   if(!isNullOrEmpty(selected[i].data.admissionId)) {
	                						   if(selected[i].data.approvalStatus==="APPROVED" || 
	                								   selected[i].data.approvalStatus==="REJECTED"){
	                							   grid.getSelectionModel().deselect(selected[i]);
	                							   return false;
	                						   }

	                						   if(isNullOrEmpty(selected[i].data.revaluationTypeEnum)){
	                							   grid.getSelectionModel().deselect(selected[i]);
	                							   return false;
	                						   }

	                						   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
	                								   (selected[i].data.revaluationTypeEnum=="Revaluation" ||
	                										   selected[i].data.revaluationTypeEnum=="REVALUATION")){
	                							   if(isRevalFeeApplicable=="true"){
	                								   withFeeReval=true
	                							   }
	                							   if (isRevalFeeApplicable=="false") {
	                								   withoutReval=true
	                							   } 
	                						   } 

	                						   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
	                								   selected[i].data.revaluationTypeEnum=="Review"  ||
	                								   selected[i].data.revaluationTypeEnum=="REVIEW"){
	                							   if(isReviewFeeApplicable=="true"){
	                								   withReview=true
	                							   }
	                							   if (isReviewFeeApplicable=="false") {
	                								   withoutReview=true
	                							   } 
	                						   } 


	                						   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
	                								   selected[i].data.revaluationTypeEnum=="Challenge"  ||
	                								   selected[i].data.revaluationTypeEnum=="CHALLENGE"){
	                							   if(isChallengeFeeApplicable=="true"){
	                								   withChallenge=true
	                							   }
	                							   if (isChallengeFeeApplicable=="false") {
	                								   withoutChallenge=true
	                							   } 
	                						   }
	                						   if(grid.getSelectionModel().getSelection().length>1){
	                							   offlinePaymentItemId.setDisabled(true);
	                							   btnApplyItemId.setDisabled(true);
													btnApplyNow.setDisabled(true); 
	                							   //btnApprove.setDisabled(true);
	                						   }else{
	                							   if(grid.getSelectionModel().getSelection().length){
	                								   offlinePaymentItemId.setDisabled(false);
	                								   btnApplyItemId.setDisabled(false);
														btnApplyNow.setDisabled(true);   
	                								   //btnApprove.setDisabled(false);
	                							   }
	                						   }
	                					   }
	                				   }


	                				   setTimeout(function(){
	                					   //if(grid.getSelectionModel().getSelection().length) {
	                						   if((withFeeReval || withChallenge || withReview) &&
	                								   (withoutReval || withoutChallenge || withoutReview)){
	                							   btnApplyNow.setDisabled(false);
	                							   btnApplyItemId.setDisabled(false);
	                							   offlinePaymentItemId.setDisabled(false);
	                							   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_WITH_FEE_AND_WITHOUT_FEE'));
	                							   grid.getSelectionModel().deselectAll();
	                						   } else if (withFeeReval || withChallenge || withReview){
	                							   btnApplyNow.setDisabled(true); 
	                							   btnApplyItemId.setDisabled(false);
	                							   offlinePaymentItemId.setDisabled(false);
	                						   } else if(withoutReval || withoutChallenge || withoutReview) {
	                							   btnApplyNow.setDisabled(false); 
	                							   btnApplyItemId.setDisabled(true);
	                							   offlinePaymentItemId.setDisabled(true);
	                						   } else {
	                							   /*btnApplyNow.setDisabled(false);
	                							   btnApplyItemId.setDisabled(false);
	                							   offlinePaymentItemId.setDisabled(false);
	                							   grid.getSelectionModel().deselectAll();*/
	                							   
	                							   btnApplyNow.setDisabled(true);
				    	                		   btnApplyItemId.setDisabled(true);
				    	                		   offlinePaymentItemId.setDisabled(true);
				    	                		   grid.getSelectionModel().deselectAll();
	                						   }
	                					   //}
	                				   },500);


	                				   var msgLable = grid.down('#applyForRevalMsgId');
	                				   msgLable.setValue('');
	                				   var totalAmount=0, submittedRecordsCount=0,
	                				   revalCount=0, challengeCount=0, reviewCount=0, masterId=[], bucketSize=0, count=0;
	                				   if(grid.getSelectionModel().getSelection().length!=0){
	                					   var maxCourseEvent = grid.getSelectionModel().getSelection()[0].get('maxCourseEventToApply');
	                					   for(var i in selected) {
	                						   if(!isNullOrEmpty(selected[i].data.feeAmount)) {
	                							   totalAmount=totalAmount+parseInt(selected[i].data.feeAmount);
	                						   }
	                						   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) && (masterId.length==0  || 
	                								   (!isNullOrEmpty(masterId)?masterId.id != selected[i].data.examRevaluationId:false))) {
	                							   masterId.push({
	                								   "id":selected[i].data.examRevaluationId,
	                								   "bucketSize":selected[i].data.maxMasterCount,
	                								   "revalType" : selected[i].data.revaluationTypeEnum
	                							   })
	                						   }
	                					   }
	                					   for(j in masterId){
	                						   var maxCount = masterId[j].bucketSize;
	                						   var count=0, selectionMsg='';
	                						   for(var i in models) {
	                							   if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && masterId[j].id == models[i].data.examRevaluationId
	                									   && selected[0].data.admissionId==models[i].data.admissionId) {
	                								   selectionMsg = models[i].data.revaluationTypeEnum+" "; 
	                								   count++;
	                							   }
	                						   }
	                					   }
	                					   if(count >= maxCourseEvent){ 
	                						   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_ACADEMIC_TERM')+' '+selectionMsg+' '+
	                								   getExaminationTranslation('REVALUATION_ALLTYPES_WARNING_MSG')+' '+models[0].data.maxCourseEventToApply+' '+ getCommonTranslation('LOWERCASE_COURSES'));

	                						   grid.getSelectionModel().deselect(records[records.length-1]); 


	                						   return false;
	                					   }

	                				   }

	                				   /*var appeningString='';
	                				   setTimeout(function(){
	                					   //if(grid.getSelectionModel().getSelection().length) {
	                						   if(totalAmount>0 && withFeeApplicable) { 
	                							   appeningString = 'Amount to be paid '+"<span style='color:green'>"+totalAmount+"/-</span>";
	                							   msgLable.setValue(appeningString);
	                							   msgLable.setVisible(true);
	                						   } else {
	                							   msgLable.setVisible(false);
	                						   }
	                					   //}
	                				   },500);*/
	                			   },
	                			   
	                			  
									
	                			   cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
									   if(grid.getSelectionModel().getSelection().length > 0){
										   return; 
									   }
	                				   var $this = this;
	                				   var documentGrid = $this.getRevaluationstudentgrid();
	                				   var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	                				   var offlinePaymentItemId=documentGrid.down('#offlinePaymentItemId');
		    	                	   var btnApplyItemId=documentGrid.down('#btnApplyItemId');
		    	                	   var btnApplyNow=documentGrid.down('#btnApplyNowItemId');
	                				   
		    	                	   btnApplyNow.setDisabled(true);
	    	                		   btnApplyItemId.setDisabled(true);
	    	                		   offlinePaymentItemId.setDisabled(true);
	                				   
	                				   
	                				   if (columnName == "documentName") {
	                					   if (e.target.tagName == 'A') {
	                						   var documentId = record
	                						   .get("documentId");
	                						   if (!isNullOrEmpty(documentId)) {
	                							   $this.getDocumentController().downloadDocumentFile(documentId);
	                						   }
	                					   }
	                				   }
	                				   
	                				   if(e.target.type=='checkbox'){
	                					   if(cellIndex==0){
	                						   /**
	                						    * This function call on click of 0th column on check box click. 
	                						    ***/
	                						   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	    	                				   if(!e.target.checked){
	                							   tempStore.remove(record,true);
	                						   }else if(e.target.checked){
	                							   tempStore.loadRawData(record,true);
	                						   }
	                					   }
	                				   }
	                			   }
	                			   
	                		   },
	                		   
	                		   'revaluationstudentgrid button#btnApplyItemId' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var grid = $this.getRevaluationstudentgrid();
	                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   //if(grid.getSelectionModel().getCount()>0){
	                				   var record=tempStore.data.items.length!=0?tempStore.data.items:grid.getSelectionModel().getSelection();
		                				  
	                				   if(record.length>0){
	                					   var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var innerJsonArr=[], json;
	                					   var totalAmmount=0;
	                					   var models = grid.getStore().getRange();
	                					   var totalRevalApplied=0;
	                					   for(var i in models) {
	                						   if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && models[i].data.revaluationStatus.toUpperCase()!='SUBMITTED'.toUpperCase()){
	                							   totalRevalApplied=totalRevalApplied+1;
	                						   }
	                					   }
	                					   for(var i in record) {
	                						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
	                							   if(record[i].data.approvalStatus=="APPROVED"){
	                								   showWarningMessage(getCommonTranslation('ALERT'),
		                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
		                							   return false; 
	                							   }
	                						   }
	                					   }
	                					   
									var totAmount = 0;
			                        for (var i in record) {
			                            if (!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
			                                if (record[i].data.revaluationTypeEnum == "Review") {
			                                    totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#reviewFeeAmount")[0].getValue())
			                                } else {
			                                    if (record[i].data.revaluationTypeEnum == "Revaluation") {
			                                        totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue())
			                                    } else {
			                                        if (record[i].data.revaluationTypeEnum == "Challenge") {
			                                            totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#challengeFeeAmount")[0].getValue())
			                                        }
			                                    }
			                                }
			                            }
			                        }
	                					   for(var i in record) {
	                						   
	                							if (!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
                                if (record[i].data.revaluationTypeEnum == "Review") {
                                   totalAmmount = Ext.ComponentQuery.query("#reviewFeeAmount")[0].getValue()
                                } else {
                                    if (record[i].data.revaluationTypeEnum == "Revaluation") {
                                       totalAmmount = Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue()
                                    } else {
                                        if (record[i].data.revaluationTypeEnum == "Challenge") {
                                          totalAmmount = Ext.ComponentQuery.query("#challengeFeeAmount")[0].getValue()
                                        } else {
                                            if (isNaN(totalAmmount)) {
                                              totalAmmount = Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue()
                                            }
                                        }
                                    }
                                }

								var FeePlanRuleID = null;
                                if (record[i].data.revaluationTypeEnum == "Review") {
                                    FeePlanRuleID = Ext.ComponentQuery.query("#reviewFeePlanRuleStageId")[0].getValue()
                                } else {
                                    if (record[i].data.revaluationTypeEnum = "Revaluation") {
                                        FeePlanRuleID = Ext.ComponentQuery.query("#revalFeePlanRuleStageId")[0].getValue()
                                    } else {
                                        if (record[i].data.revaluationTypeEnum = "Challenge") {
                                            FeePlanRuleID = Ext.ComponentQuery.query("#challengeFeePlanRuleStageId")[0].getValue()
                                        }
                                    }
                                }
	                							   innerJsonArr.push({
	                								   "admissionId": record[i].data.admissionId,
	                								   "studentId": studentPortalInfo.student.id,
	                								   "feePlanRuleStageId": FeePlanRuleID,
	                								   "amount": totalAmmount, 
	                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
	                								   "examinationResultId": record[i].data.revaluationFor!= "COURSE_LEVEL"?record[i].data.examinationResultId:null,
	                										   "courseVariantId": record[i].data.courseVariantId,
	                										   "periodId": record[i].data.periodId,
	                										   "eventId": record[i].data.eventId,
	                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record[i].data.appliedDate,
	                										   "courseCode": record[i].data.courseCode,
	                										   "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										   "eventName": record[i].data.event,
	                										   "previousMarks": record[i].data.obtainedMarks,
	                										   "previousGrade": record[i].data.finalGrade,
	                										   "previousGradePoint": record[i].data.gradePoints,
	                										   "previousResultStatus": record[i].data.resultStatus,
	                										    "examStudentRevalId":record[i].data.studentRevalId
	                							   });
	                							   json={
	                									   'firstName':studentPortalInfo.student.firstName,
	                									   'lastName':studentPortalInfo.student.lastName,
	                									   'phoneNo':studentPortalInfo.student.person.mobileCountryCode+" "
	                									   +studentPortalInfo.student.person.mobileNumber,
	                									   'email':studentPortalInfo.student.person.emailId,
	                									   'studentCode':studentPortalInfo.student.code,
	                									   "totalAmount":totAmount,
															"currencyCode":record[i].data.currencyCode,
	                									   "examRevalPaymentDetail":innerJsonArr
	                							   };
	                						   } else {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	                							   return false;
	                						   }
	                					   }
	                					   var buildInfo="";  
	                					   var revalPaymentUrl = ""; 
	                					   if(!isNullOrEmpty(json)) {
	                						   var XMLHttpRequestObject = false;  
	                						   if (window.XMLHttpRequest) {  
	                							   XMLHttpRequestObject = new XMLHttpRequest();  
	                							   XMLHttpRequestObject.overrideMimeType("text/xml");  
	                						   }  
	                						   else if (window.ActiveXObject) {  
	                							   XMLHttpRequestObject = new  
	                							   ActiveXObject("Microsoft.XMLHTTP");  
	                						   } 
	                						   XMLHttpRequestObject.withCredentials = false;
	                						   XMLHttpRequestObject.onreadystatechange = function() {
	                							   if (this.readyState == 4 && this.status == 200) {
	                								   var id = parseInt(XMLHttpRequestObject.responseText);
	                								   if(!isNaN(id)) {
	                									   var formWindow = $this.getRevalsummarywin();
	                									   if (!formWindow) {
	                										   Ext.widget('revalsummarywin');
	                										   formWindow = $this.getRevalsummarywin();
	                									   }
	                									   formWindow.show();
	                									   var summaryGrid = formWindow.down('grid');
	                									   summaryGrid.getStore().loadRawData([]);
	                									   summaryGrid.getStore().loadRawData(innerJsonArr);
	                									   var summaryWindMsg = formWindow.down('#summaryWindMsg');
	                									   summaryWindMsg.setVisible(true);
	                									   summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totAmount+" /-</b>");
	                									   Ext.apply(formWindow,{
	                										   data:null,
	                										   setData : function(data){
	                											   formWindow.data = data;
	                										   },
	                										   getData:function(){
	                											   return formWindow.data;
	                										   }
	                									   });
	                									   formWindow.setData(id);
	                								   } else {
	                									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
	                								   }
	                							   }
	                						   };
	                						   
								var form =this.getRevaluationstudentfilter();
								var periodField = form.down('combo#periodId');
								var periodId=periodField.getValue();

						Ext.Ajax.request({       
				                   type: 'rest', 
				                   url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
				                   params: {
				                       periodId:periodId ,
				                       admissionId:record[0].data.admissionId  // V2D-460671      
				                   },
				                   method: 'GET',
				                   success: function(res, action) {
				                       var response = Ext.decode(res.responseText); 
				                      var capacity = Ext.decode(res.responseText);
					var gridRecord = grid.getSelectionModel().getSelection();
					var selectionByStudentAndPeriod = {};    				
					Ext.each(gridRecord, function(record) {  
                        var studentId = record.get('studentId');
                        var periodId = record.get('periodId');
                        var key = studentId + '-' + periodId;

                        if (!selectionByStudentAndPeriod[key]) {
                            selectionByStudentAndPeriod[key] = [];
                        }
                        selectionByStudentAndPeriod[key].push(record);
                    });

                    // Check if any student exceeds the capacity for the period
                    for (var key in selectionByStudentAndPeriod) {
                        if (selectionByStudentAndPeriod[key].length > capacity) {
                            var studentPeriod = key.split('-');
                            var studentId = studentPeriod[0];
                            var periodId = studentPeriod[1];
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP'));   
                           // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
                            break; 
                        }else{    
							XMLHttpRequestObject.open("POST",  grid.getRevalPath(), true);
							XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
							XMLHttpRequestObject.send(""+Ext.encode(json));
                    		}
                        }
				                   }
				                   
				               }); 
	                					   }
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'revalsummarywin button#payNow' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   
	                				   var XMLHttpRequestObject = false;  
        							   if (window.XMLHttpRequest) {  
        								   XMLHttpRequestObject = new XMLHttpRequest();  
        								   XMLHttpRequestObject.overrideMimeType("text/xml");  
        							   }  
        							   else if (window.ActiveXObject) {  
        								   XMLHttpRequestObject = new  
        								   ActiveXObject("Microsoft.XMLHTTP");  
        							   } 
        							   var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
        							   var getcontroller=$this.getController('menu.CoreERPNavigationController');
        							   var getTab=getcontroller.getTab(tabName);
        							   var contentpanel = this.getContentPanel();
        							   if(XMLHttpRequestObject) {  
        								   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
        								   XMLHttpRequestObject.onreadystatechange = function() {       
        									   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
        										   var xmlDocument = XMLHttpRequestObject.responseXML;  
        										   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
        										   revalPaymentUrl = buildInfo.getElementsByTagName("revalPaymentUrl") [0].childNodes[0].nodeValue;
        										   var w ='900',h ='500';
        										// Fixes dual-screen position                         Most browsers      Firefox
        										    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
        										    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

        										    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        										    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

        										    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        										    var top = ((height / 2) - (h / 2)) + dualScreenTop;
        										    var newWindow = window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

        										    // Puts focus on the newWindow
        										    if (window.focus) {
        										        newWindow.focus();
        										    }
        										    
        										  /* window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment',
        												    "status=no,height=" + 800 + ",width=" + 800 + ",resizable=yes,left="
        												    + left + ",top=" + top + ",screenX=" + left + ",screenY="
        												    + top + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");*/
        		                				   Ext.defer(function() {
        		                					   formWindow.down('#payNow').setVisible(false);
        		                					   formWindow.down('#cancelBtn').setVisible(false);
        		                					   formWindow.down('#okBtn').setVisible(true);
        		                				   }, 150, this);
        									   }  
        								   }  
        								   XMLHttpRequestObject.send(null);  
        							   }
	                			   }
	                		   },

	                		   'revalsummarywin button#okBtn' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var grid = $this.getRevaluationstudentgrid();
	                				   grid.getSelectionModel().deselectAll();
	                				   
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                					   tempStore.removeAll();
	                				   }
	                				   catch(e){}
	                				   
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   grid.getStore().reload();
	                				   formWindow.close();
	                			   }
	                		   },
	                		   'revalsummarywin button#cancelBtn' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   formWindow.close();
	                			   }
	                		   },

	                		   'revaluationstudentgrid button#btnRefreshItemId' : {
	                			   click : function(obj, record) {
	                				   var $this = this;
	                				   var form = $this.getRevaluationstudentfilter();
	                				   var grid = $this.getRevaluationstudentgrid();
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                				   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                				   var attendanceProgram = form.down("#attendanceProgramId");
	                				   var data=attendanceProgram.getStore().proxy.reader.rawData;
	                				   var admissionId=null;
	                				   for(var i in data) {
	                					   if(data[i].programId==attendanceProgram.getValue()) {
	                						   admissionId=data[i].admissionId;
	                					   }
	                				   }
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodField = form.down('combo#periodId');
	                				   grid.getSelectionModel().deselectAll();
	                				   
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                					   tempStore.removeAll();
	                				   }
	                				   catch(e){}
	                				   
	                				   $this.resetGridSetting(grid);
	                				   $this.resetPageSetting(grid.getStore(), grid);
	                				   grid.getStore().getProxy().extraParams={
	                					   admissionId : admissionId,
	                					   programId:attendanceProgram.getValue(),
	                					   batchId:batchCombo.getValue(),
	                					   periodId:periodField.getValue()
	                				   };
	                				   grid.getStore().load({
	                					   callback:function(records){
	                						  /* var msgLable = grid.down('#applyForRevalMsgId');
	                						   if(records.length>0){
	                							   msgLable.setValue('');
	                						   } else {
	                							   msgLable.setValue("<span style='color:blue'>Process not started yet</span>");
	                						   }
	                						   msgLable.setVisible(true);*/
	                					   }
	                				   });
	                				   grid.down('#btnApplyItemId').setDisabled(true);
	                				   grid.down('#btnApplyNowItemId').setDisabled(true);
	                				   grid.down('#offlinePaymentItemId').setDisabled(true);
	                			   }
	                		   },
	                		   'revaluationstudentfilter':{
	                			   beforerender : function(form){
	                				   var $this = this;
	                				   var attendanceProgram = form.down("#attendanceProgramId");
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodField = form.down('combo#periodId');
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var facultyId = null;

	                				   if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
	                					   attendanceProgram.setVisible(true);
	                					   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                					   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                					   var studentPeriodId = studentPortalInfo.programBatchDetails.periodId;
	                					   var attendanceProgramStore = attendanceProgram.getStore();
	                					   attendanceProgramStore.getProxy().extraParams = {
	                						   studentId: studentPortalInfo.student.id,
											   onlyCurrentRecords: true,
											   academyLocationId:$this.getCurrentAcademyLocation()
	                					   };
	                					   attendanceProgramStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if (success && records.length > 0){
	                									   if(records[0].data.programId == studentprogramId){
	                										   attendanceProgram.setValue(records[0].data.programId);
	                										   var batchStore = batchCombo.getStore();
	                										   batchCombo.setDisabled(false);
	                										   batchStore.getProxy().extraParams = {
	                											   programId: records[0].data.id,
	                											   studentId : studentPortalInfo.student.id,
	                											   onlyCurrentRecords: true // V2D-508173
	                										   };
	                										   batchStore.load({
	                											   callback: function(records, operation, success) {
	                												   if (success) {
	                													   for(var i in records){
	                														   if(records[i].data.id == studentbatchId){
	                															   batchCombo.setValue(records[i].data.id);
	                															   var periodCombo = form.down("#periodId");
	                															   periodCombo.setDisabled(false);

	                															   var periodStore = periodCombo.getStore();
	                															   periodStore.getProxy().extraParams = {
	                																   id: records[i].data.id
	                															   };
	                															   periodStore.load({
	                																   callback: function(records, operation, success) {
	                																	   if (success) {
	                																		   if (records.length == 1) {
	                																			   periodCombo.setValue(records[0].data.id);
	                																		   }
	                																	   }
	                																   }
	                															   });
	                						                					   form.isValid();
	                														   }
	                													   }
	                												   }
	                											   }
	                										   });
	                									   }
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },

	                		   'revaluationstudentfilter combo#attendanceProgramId' : {
	                			   select : function(obj, record) {
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                				   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                				   var studentPeriodId = studentPortalInfo.programBatchDetails.periodId;
	                				   
	                				   var form = obj.up('form');
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodComboBox = form.down('#periodId');
	                				   var periodStore = periodComboBox.getStore();
	                				   var batchStore = batchCombo.getStore();
	                				   batchCombo.setDisabled(false);
	                				   batchCombo.reset();
	                				   periodComboBox.reset();
	                				   batchStore.getProxy().extraParams = {
	                					   programId: record[0].data.id,
	                					   studentId : studentPortalInfo.student.id,
										   onlyCurrentRecords: false
	                				   };
	                				   batchStore.load({
	                					   callback:function(rec){
	                						   if(rec.length ==1){
	                							   batchCombo.setValue(rec[0].data.id);
	                							   periodComboBox.reset();
	                							   periodStore.getProxy().extraParams = {
	                								   id: rec[0].data.id
	                							   };
													periodComboBox.setDisabled(false);
	                							   periodStore.load({
	                								   callback:function(rec){
	                									   if(rec.length ==1){
	                										   periodComboBox.setValue(rec[0].data.id)
	                									   }
	                								   }
	                							   });
	                						   }
	                					   }
	                				   });
	                				   form.isValid();
	                			   }
	                		   },

	                		   'revaluationstudentfilter combo#batchCombo' : {
	                			   select : function(obj, record) {
	                				   var batch_Id = record[0].get("batchId");
	                				   var form = obj.up('form');
	                				   var periodComboBox = form.down('combo#periodId');
	                				   periodComboBox.clearValue();
	                				   periodComboBox.setDisabled(false);
	                				   var periodStore = periodComboBox.getStore();
	                				   periodStore.getProxy().extraParams = {
	                					   id: batch_Id
	                				   };
	                				   periodStore.load({
        								   callback:function(rec){
        									   if(rec.length ==1){
        										   periodComboBox.setValue(rec[0].data.id)
        									   }
        								   }
        							   });
	                			   }
	                		   },

	                		   'revaluationstudentfilter button#searchBtn' : {
	                			   click : function(obj, record) {
	                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   if(tempStore.data.length >0 ){
	                					   tempStore.removeAll();
	                				   }
	                				   var form = obj.up('form');
	                				   var $this = this;
	                				   var grid = this.getRevaluationstudentgrid();
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                				   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                				   var attendanceProgram = form.down("#attendanceProgramId");
	                				   var data=attendanceProgram.getStore().proxy.reader.rawData;
	                				   var admissionId=null;
	                				   for(var i in data) {
	                					   if(data[i].programId==attendanceProgram.getValue()) {
	                						   admissionId=data[i].admissionId;
	                					   }
	                				   }
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodField = form.down('combo#periodId');
	                				   var store = $this.getStore('examCenter.AssignSequence.RevaluationTypeByPeriod');
	                				   store.getProxy().extraParams={
	                					   periodId:periodField.getValue()
	                				   };
	                				   store.load();
	                				   
	                				   
	                				   var withFeeReval=false;
		    	                	   var withChallenge=false;
		    	                	   var withReview=false;
	                				   Ext.Ajax.request({
	       									type : 'rest',
	       									url : SERVERURL.PATH_FIND_REVAL_TYPE_BY_PERIOD,
	       									params : {
	       										periodId : periodField.getValue()
	       									},
	       									method : 'GET',
	       									success : function(response, action) {
		                				   	var revalStoreData = Ext.decode(response.responseText);
		                				   	for(var i in revalStoreData){
				    	                		   if(revalStoreData[i].code=="REVALUATION"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isRevalFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isRevalFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#revalFeeAmount').setValue(revalStoreData[i].doubleValue);
													  form.down('#revalFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                		   } 
				    	                		   if(revalStoreData[i].code=="REVIEW"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isReviewFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isReviewFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#reviewFeeAmount').setValue(revalStoreData[i].doubleValue);
													  form.down('#reviewFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                		   } 
				    	                		   if(revalStoreData[i].code=="CHALLENGE"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isChallengeFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isChallengeFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#challengeFeeAmount').setValue(revalStoreData[i].doubleValue);
													 form.down('#challengeFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                		   } 
				    	                	   }	       									
		                				   	}
		                				   });
	                				   
	                				   grid.getSelectionModel().deselectAll();
	                				   $this.resetGridSetting(grid);
	                				   $this.resetPageSetting(grid.getStore(), grid);
	                				   if(isNullOrEmpty(attendanceProgram.getValue())){
										   admissionId = studentPortalInfo.admissionDetails[0].id;
									   } // V2D-457975
	                				   grid.getStore().getProxy().extraParams={
	                					   admissionId : admissionId,
	                					   programId:attendanceProgram.getValue(), 
	                					   batchId:batchCombo.getValue(),
	                					   periodId:periodField.getValue(),
	                					   sort:null
	                				   };
	                				   grid.getStore().load({
	                					   callback:function(records){
	                						   var msgLable = grid.down('#applyForRevalMsgId');
	                						   if(records.length>0){
	                							   msgLable.setValue('');
	                							   var doneCount=0;
	                							   for(var i in records){
	                								   if(records[i].data.revaluationStatus.toUpperCase() == 'SUBMITTED'.toUpperCase()){
	                									   doneCount++;
	                								   }
	                							   }
	                							   if(records[0].data.revaluationFor == 'COURSE_LEVEL') {
	                								   //grid.columns[3].setVisible(false);
	                								   for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
							                                var column = grid.columnManager.columns[i];
							                                if (column.dataIndex == 'DETAILED_SEQUENCE') {
							                                    column.hide();
							                                }
							                            }
	                							   } else {
	                								   //grid.columns[3].setVisible(true);
	                								   for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
							                                var column = grid.columnManager.columns[i];
							                                if (column.dataIndex == 'DETAILED_SEQUENCE') {
							                                    column.show();
							                                }
							                            }
	                							   }
	                						   } else {
	                							   //msgLable.setValue("<span style='color:blue'>Process not configured or not started for "+periodField.getRawValue()+"</span>");
	                						   }
	                						   msgLable.setVisible(true);
	                					   }
	                				   });
	                				   
	                				   
	                				   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
		    	                	   var btnApplyItemId=grid.down('#btnApplyItemId');
		    	                	   var btnApplyNow=grid.down('#btnApplyNowItemId');
	                				   
		    	                	   btnApplyNow.setDisabled(true);
	    	                		   btnApplyItemId.setDisabled(true);
	    	                		   offlinePaymentItemId.setDisabled(true);
	    	                		   grid.config.searchFilterForm =form;

	                			   }
	                		   },

	                		   'revaluationstudentfilter button#resetBtn' : {
	                			   click : function(obj, record) {
	                				   var form = obj.up('form');
	                				   form.getForm().reset();
	                				   form.down('#periodId').setDisabled(true);
	                				   form.down('#batchCombo').setDisabled(true);
	                				   var $this = this;
	                				   var attendanceProgram = form.down("#attendanceProgramId");
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodField = form.down('combo#periodId');
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var facultyId = null;
	                				   var grid = this.getRevaluationstudentgrid();
	                				   grid.getSelectionModel().deselectAll();
	                				   
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
		                				   if(tempStore.data.length >0 ){
		                					   tempStore.removeAll();
		                				   }
	                				   }
	                				   catch(e){}
	                				   
	                				   $this.resetGridSetting(grid);
	                				   $this.resetPageSetting(grid.getStore(), grid);
	                				   grid.getStore().loadRawData([]);
	                				   if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
	                					   attendanceProgram.setVisible(true);
	                					   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                					   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;

	                					   var attendanceProgramStore = attendanceProgram.getStore();
	                					   attendanceProgramStore.getProxy().extraParams = {
	                						   studentId: studentPortalInfo.student.id,
	                						   onlyCurrentRecords:false
	                					   };
	                					   attendanceProgramStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   for(var i in records){
	                									   if(records[i].data.programId == studentprogramId){
	                										   attendanceProgram.setValue(records[i].data.programId);
	                										   var batchStore = batchCombo.getStore();
	                										   batchCombo.setDisabled(false);
	                										   batchStore.getProxy().extraParams = {
	                											   programId: records[i].data.id,
	                											   studentId : studentPortalInfo.student.id,
	                	                						   onlyCurrentRecords:false
	                										   };
	                										   batchStore.load({
	                											   callback: function(records, operation, success) {
	                												   if (success) {
	                													   for(var i in records){
	                														   if(records[i].data.id == studentbatchId){
	                															   batchCombo.setValue(records[i].data.id);
	                															   var periodCombo = form.down("#periodId");
	                															   periodCombo.setDisabled(false);

	                															   var periodStore = periodCombo.getStore();
	                															   periodStore.getProxy().extraParams = {
	                																   id: records[i].data.id
	                															   };
	                															   periodStore.load({
	                																   callback: function(records, operation, success) {
	                																	   if (success) {
	                																		   if (records.length == 1) {
	                																			   periodCombo.setValue(records[0].data.id);
	                																		   }
	                																	   }
	                																   }
	                															   });
	                														   }
	                													   }
	                												   }
	                											   }
	                										   });
	                									   }
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },
	                		   
	                		   'revaluationstudentgrid button#offlinePaymentItemId': {
	                               click: function() {
	                            	   
	                            	   var this$ = this;
	        	                	   var grid=this.getRevaluationstudentgrid();
	        	                	   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   
	        	                	   var record=tempStore.data.items.length!=0?tempStore.data.items:grid.getSelectionModel().getSelection();
		                				
	        	                	   if(record.length==0){
	        	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	                		   return false;
	        	                	   }
	        	                	   
	        	                	   for(var i in record) {
	            						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	            							   showWarningMessage(getCommonTranslation('ALERT'),
	            									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	            							   return false;
	            						   }
	            					   }
	        	                	   
	        	                	   for(var i in record) {
                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
                							   if(record[i].data.approvalStatus=="APPROVED"){
                								   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
	                							   return false; 
                							   }
                						   }
                					   }
	                            	   
	                                   var docController=this.getDocumentController();
								Ext.Ajax.request({        
				                   type: 'rest', 
				                   url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
				                   params: {
				                       periodId:record[0].data.periodId,
                                       admissionId:record[0].data.admissionId 
				                   },
				                   method: 'GET',
				                   success: function(res, action) {
				    var capacity = Ext.decode(res.responseText);
					var gridRecord = grid.getSelectionModel().getSelection();
					var selectionByStudentAndPeriod = {};    				
					Ext.each(gridRecord, function(record) {  
                        var studentId = record.get('studentId');
                        var periodId = record.get('periodId');
                        var key = studentId + '-' + periodId;

                        if (!selectionByStudentAndPeriod[key]) {
                            selectionByStudentAndPeriod[key] = [];
                        }
                        selectionByStudentAndPeriod[key].push(record);
                    });

                    // Check if any student exceeds the capacity for the period
                    for (var key in selectionByStudentAndPeriod) {
                        if (selectionByStudentAndPeriod[key].length > capacity) {
                            var studentPeriod = key.split('-');
                            var studentId = studentPeriod[0];
                            var periodId = studentPeriod[1];
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP'));  
                           // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
                            break; 
                        }else{    
							docController.showDocumentFormWindow('offlinePaymentDocument', 'DOCUMENT');
							Ext.defer(function() {
								Ext.ComponentQuery.query('documentformwindow')[0].setTitle(getExaminationTranslation('TRANSACTION_DETAILS'));
							}, 10, this);
                    		}}
						}  				                  
				               });  
	                               }
	                           },
	                		   
	                	       'documentformwindow[itemId=offlinePaymentDocument] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
	                			   click : this.saveRevalTransaction
	                		   },
	                		   
	                		   'revaluationstudentgrid button#btnApplyNowItemId' : {
	                			   click : function(obj) {
	                				   obj.setDisabled(true);
	                				   var $this = this;
	                				   var totalAmmount=0;
	                				   var innerJsonArr=[], json;
                					   var totalAmmount=0;
                					   var arrayData=[];
                					   var  saveModel=new Array();
                					   var grid=$this.getRevaluationstudentgrid();
                					   var record=grid.getSelectionModel().getSelection();
                					   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
                					   //var btnApprove=grid.down('#btnApprove');
                					   //btnApprove.setDisabled(true);
                					   var models = grid.getStore().getRange();
                					   var totalRevalApplied=0;
	                				   //if(grid.getSelectionModel().getCount()>0){
	                				   if(record.length>0){
	                					   
	                					   for(var i in record) {
	                						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	    	                					   obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
	                							   if(record[i].data.approvalStatus=="APPROVED"){
	                								   showWarningMessage(getCommonTranslation('ALERT'),
		                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
	        	                					   obj.setDisabled(false);
		                							   return false; 
	                							   }
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   totalAmmount=totalAmmount+parseInt(record[i].data.feeAmount);
	                							   innerJsonArr.push({
	                								   "admissionId": record[i].data.admissionId,
	                								   "studentId": record[i].data.studentId,
	                								   "feePlanRuleStageId": record[i].data.feePlanRuleStageId,
	                								   "amount": record[i].data.feeAmount,
	                								  // "remark": remark.getValue(),
	                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
	                								   "examinationResultId": record[i].data.examinationResultId,
	                										   "courseVariantId": record[i].data.courseVariantId,
	                										   "periodId": record[i].data.periodId,
	                										   "eventId": record[i].data.eventId,
	                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record[i].data.appliedDate,
	                										 //  "courseCode": record[i].data.courseCode,
	                										  // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										 //  "eventName": record[i].data.event,
	                										   "previousMarks": record[i].data.obtainedMarks,
	                										   "previousGrade": record[i].data.finalGrade,
	                										   "previousGradePoint": record[i].data.gradePoints,
	                										   "previousResultStatus": record[i].data.resultStatus,
	                										   "isApproveEvent":true,
	                										   "examStudentRevalId":record[i].data.studentRevalId,
	                										   "approvalStatus":"PENDING"
	                							   });
	                							   json={
	                									   'firstName':record[0].data.firstName,
	                									   'lastName':record[0].data.lastName,
	                									   'phoneNo':record[0].data.mobileCountryCode+" "
	                									   +record[0].data.mobileNumber,
	                									   'email':record[0].data.emailId,
	                									   'studentCode':record[0].data.studentCode,
	                									   "totalAmount":totalAmmount,
	                									   "detailModel":innerJsonArr
	                							   };
	                							   arrayData.push(json);
	                							  
	                							   
	                						   } else {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	    	                					   obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
									Ext.Ajax.request({
									    type: 'rest',
									    url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
									    params: {
									        periodId: record[0].data.periodId
									    },
									    method: 'GET',
									    success: function(res, action) {
									        var response = Ext.decode(res.responseText);
									        var capacity = Ext.decode(res.responseText);
									        var gridRecord = grid.getSelectionModel().getSelection();
									        var selectionByStudentAndPeriod = {};
									        Ext.each(gridRecord, function(record) {
									            var studentId = record.get('studentId');
									            var periodId = record.get('periodId');
									            var key = studentId + '-' + periodId;
									
									            if (!selectionByStudentAndPeriod[key]) {
									                selectionByStudentAndPeriod[key] = [];
									            }
									            selectionByStudentAndPeriod[key].push(record);
									        });
									
									        // Check if any student exceeds the capacity for the period
									        for (var key in selectionByStudentAndPeriod) {
									            if (selectionByStudentAndPeriod[key].length > capacity) {
									                var studentPeriod = key.split('-');
									                var studentId = studentPeriod[0];
									                var periodId = studentPeriod[1];
									                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP'));
									                // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
									                break;
									            } else {
									                Ext.Ajax.request({
									                    type: 'rest',
									                    url: SERVERURL.PATH_GENERATE_REVALUATION_WITHOUT_FEE,
									                    jsonData: arrayData,
									                    method: 'POST',
									                    success: function(response, action) {
									                        obj.setDisabled(false);
									                        showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getExaminationTranslation('SUCCESSFULLY_APPLIED_FOR_THE_REVALUATION'));
									                        grid.getSelectionModel().deselectAll();
									                        tempStore.removeAll();
									                        grid.getStore().load();
									                    }
									                });
									            }
									        }
									    }
									
									});
	                				 //obj.setDisabled(false);  
	                				   }else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                					   obj.setDisabled(false);
	                				   }
	                			   }
	                		   },
	                	   });
	                   },

	                   revSelectionChange: function(cell){
	                	   var $this = this;
	                	   var grid = $this.getRevaluationStudentGrid();
	                	   var tempStore=$this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                	   var records = tempStore.data.items;
	                	   uniqueAdmissionIds = new Ext.util.HashMap();
	                	   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
	                	   //var btnApprove=grid.down('#btnApprove');

	                	   for(var i in records) {
	                		   if(!isNullOrEmpty(records[i].data.admissionId)) {
	                			   if(records.length>1){
	                				   offlinePaymentItemId.setDisabled(true);
	                				   //btnApprove.setDisabled(true);
	                			   }else{
	                				   offlinePaymentItemId.setDisabled(false);
	                				   //btnApprove.setDisabled(false);
	                			   }
	                		   }
	                	   }

	                	   var msgLable = grid.down('#applyForRevalMsgId');
	                	   msgLable.setValue('');
	                	   var totalAmount=0, submittedRecordsCount=0,
	                	   revalCount=0, challengeCount=0, reviewCount=0, masterId=[], bucketSize=0, count=0;
	                	   for(var i in records) {
	                		   if(!isNullOrEmpty(records[i].data.feeAmount)) {
	                			   totalAmount=totalAmount+parseInt(records[i].data.feeAmount);
	                		   }
	                		   if(!isNullOrEmpty(records[i].data.revaluationTypeEnum) && (masterId.length==0  || 
	                				   (!isNullOrEmpty(masterId)?masterId.id != records[i].data.examRevaluationId:false))) {
	                			   masterId.push({
	                				   "id":records[i].data.examRevaluationId,
	                				   "bucketSize":records[i].data.maxMasterCount,
	                				   "revalType" : records[i].data.revaluationTypeEnum
	                			   })
	                		   }
	                	   }
	                	   for(j in masterId){
	                		   var maxCount = masterId[j].bucketSize;
	                		   var count=0, selectionMsg='';
	                		   for(var i in records) {
	                			   if(masterId[j].id == records[i].data.examRevaluationId) {
	                				   selectionMsg = records[i].data.revaluationTypeEnum+" "; 
	                				   count++;
	                			   }
	                		   }
	                		   if(count>maxCount) {
	                			   grid.getSelectionModel().deselect(records[records.length-1]);
	                			   tempStore.remove(records[records.length-1],true);
	                			   cell.checked = false;
	                			   //showWarningMessage(getCommonTranslation('ALERT'), "Selection can not be more then " +maxCount+" for "+selectionMsg);
	                			   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_ACADEMIC_TERM')+' '+selectionMsg.toLowerCase()+' '+
											getExaminationTranslation('REVALUATION_ALLTYPES_WARNING_MSG')+' '+maxCount+' '+ getCommonTranslation('LOWERCASE_COURSES'));
	                			   return false;
	                		   }
	                	   }
	                	   var store = grid.getStore();
	                	   var models = grid.getStore().getRange();
	                	   for(var i in models) {
	                		   if(models[i].data.revaluationStatus.toUpperCase() == 'SUBMITTED'.toUpperCase()) {
	                			   submittedRecordsCount++;
	                		   }
	                	   }
	                	   var appeningString='';
	                	   if(totalAmount>0) {
	                		   appeningString = 'Amount to be paid '+"<span style='color:green'>"+totalAmount+"/-</span>";
	                	   }
	                	   msgLable.setValue(appeningString);
	                	   msgLable.setVisible(true);
	                   },
	                   disableMoreActionGridPivileges: function(structure,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var btnApplyItemId = structure.down('#btnApplyItemId');
	                	   var offlinePaymentItemId = structure.down('#offlinePaymentItemId');
	                	   var btnApplyNowItemId = structure.down('#btnApplyNowItemId');
	                	   //var btnPayItemId = structure.down('#btnPayItemId');
	                	   btnApplyItemId.setVisible(false);
	                	   btnApplyNowItemId.setVisible(false);
	                	   offlinePaymentItemId.setVisible(false);
	                	   //btnPayItemId.setVisible(false);
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'APPLY_AND_PAY_ONLINE') {
	                			   if(!isNullOrEmpty(btnApplyItemId)){
	                				   btnApplyItemId.setVisible(true);
	                			   }        		
	                		   } else if (privilege === 'OFFLINE_PAYMENT') {
	                			   if(!isNullOrEmpty(offlinePaymentItemId)){
	                				   offlinePaymentItemId.setVisible(true);
	                			   }        		
	                		   } else if (privilege ==='APPLY_NOW'){
	                			   btnApplyNowItemId.setVisible(true);
	                		   }
	                	   });
	                   },
	                   
	                   saveRevalTransaction: function(obj) {
                    	   var this$ = this;
                    	   var grid=this.getRevaluationstudentgrid();
                    	   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                	   var record =tempStore.data.items;//grid.getSelectionModel().getSelection();
                    	   var isTransient = false;
                    	   var module = 'offlinePaymentDocument';
                    	   var entityId ;
                    	   var entityType = 'offlinePaymentDocument';
                    	   var formWin =  this.getDocumentFormWindow();
                    	   var uploadFiled=formWin.down('#uploadFileField');
	                	   var fileUploadPath=uploadFiled.getValue();
	                	   var submitUrl;
	                	   var totalAmmount=0;
        				   var innerJsonArr=[], json;
    					   var totalAmmount=0;
    					   var arrayData=[];

	                	   for(var i in record) {
    						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
    							   showWarningMessage(getCommonTranslation('ALERT'),
    									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
    							   return false;
    						   }
    					   }
	                	   
	                	   var getForm=this$.getRevaluationstudentfilter();
    					   var revalFeeAmount= getForm.down('#revalFeeAmount').getValue();
    					   var reviewFeeAmount= getForm.down('#reviewFeeAmount').getValue();
    					   var challengeFeeAmount= getForm.down('#challengeFeeAmount').getValue();
    					   
	                	   
	                	   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	                	   if (extension == "gif"  || extension == "png" || extension == "bmp"
	                		   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	                		   || extension == "doc"  || extension == "docx" || extension == "txt"
	                		   || extension == "csv"  || extension == "zip") {

	                		   this$.applyWindowMask(); 
	                		   this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	                		   this$.hideWindowMask();
	                			   if(success){
	                				   //var record = tempStore.data.items[0];//grid.getSelectionModel().getSelection()[0];
	                				   var record=tempStore.data.items.length!=0?tempStore.data.items[0]:grid.getSelectionModel().getSelection()[0];
		                				
	                				   var id = record.get("studentRevalId");
	                				   var documentId = Ext.decode(response.responseText);
	                				   if(isNullOrEmpty(id)){
	                						   if(!isNullOrEmpty(record.data.revaluationTypeEnum)) {
	                							   var feeAmount=0.0;
	                							   if(!isNullOrEmpty(revalFeeAmount) && record.data.revaluationTypeEnum.toUpperCase()=="REVALUATION"){
	                								   feeAmount=revalFeeAmount
	                							   } else if(!isNullOrEmpty(reviewFeeAmount) && record.data.revaluationTypeEnum.toUpperCase()=="REVIEW"){
	                								   feeAmount=reviewFeeAmount
	                							   } else if (!isNullOrEmpty(challengeFeeAmount) && record.data.revaluationTypeEnum.toUpperCase()=="CHALLENGE"){
	                								   feeAmount=challengeFeeAmount
	                							   }
	                							   
	                							   totalAmmount=totalAmmount+parseInt(feeAmount);
	                							   innerJsonArr.push({
	                								   "admissionId": record.data.admissionId,
	                								   "studentId": record.data.studentId,
	                								   "feePlanRuleStageId": record.data.feePlanRuleStageId,
	                								   "feeAmount": feeAmount,
	                								   "examRevalRuleMappingId": record.data.examRevalRuleMappingId,
	                								   "examinationResultId": record.data.examinationResultId,
	                										   "courseVariantId": record.data.courseVariantId,
	                										   "periodId": record.data.periodId,
	                										   "eventId": record.data.eventId,
	                										   "revalType": record.data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record.data.appliedDate,
	                										   //  "courseCode": record[i].data.courseCode,
	                										   // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										   //  "eventName": record[i].data.event,
	                										   "previousMarks": record.data.obtainedMarks,
	                										   "previousGrade": record.data.finalGrade,
	                										   "previousGradePoint": record.data.gradePoints,
	                										   "previousResultStatus": record.data.resultStatus,
	                										  //"approvalStatusEnum": "NOT_APPROVED",
	                										   "documentId":documentId
	                							   });
	                							   json={
	                									   'firstName':record.data.firstName,
	                									   'lastName':record.data.lastName,
	                									   'phoneNo':record.data.mobileCountryCode+" "
	                									   +record.data.mobileNumber,
	                									   'email':record.data.emailId,
	                									   'studentCode':record.data.studentCode,
	                									   "totalAmount":totalAmmount,
	                									   "detailModel":innerJsonArr
	                							   };
	                							   arrayData.push(json);

	                							   Ext.Ajax.request({
	                								   type: 'rest',
	                								   url: SERVERURL.PATH_SAVE_EXAM_STUDENT_REVALUATION,
	                								   jsonData: innerJsonArr,
	                								   method: 'POST',
	                								   success : function(response, action) {
	                									   showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                									   grid.getSelectionModel().deselectAll();
	                									   tempStore.removeAll();
	                									   grid.getStore().reload();
	                									   
	                									   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
	                									   var btnApplyItemId=grid.down('#btnApplyItemId');
	                									   var btnApplyNow=grid.down('#btnApplyNowItemId');

	                									   btnApplyNow.setDisabled(true);
	                									   btnApplyItemId.setDisabled(true);
	                									   offlinePaymentItemId.setDisabled(true);
	                								   }
	                							   });

	                						   } 
	                			   }else{
	                						   var updateUrl = SERVERURL.PATH_UPDATE_STUDENT_REVAL_DOCUMENT+'?id='+id+'&documentId='+documentId;
	                						   Ext.Ajax.request({
	                							   type : 'rest',
	                							   url : updateUrl,
	                							   method : 'POST',
	                							   success : function(response, action) {
	                								   this$.hideWindowMask();
	                								   showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                								   grid.getSelectionModel().deselectAll();
	                								   tempStore.removeAll();
	                								   grid.getStore().reload();
	                								   
	                								   
	                								   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
                									   var btnApplyItemId=grid.down('#btnApplyItemId');
                									   var btnApplyNow=grid.down('#btnApplyNowItemId');

                									   btnApplyNow.setDisabled(true);
                									   btnApplyItemId.setDisabled(true);
                									   offlinePaymentItemId.setDisabled(true);
	                							   }
	                						   });
	                					   }
	                			   this$.getDocumentController().closeDocumentFormWindow();
	                			   }
	                		   }, isTransient);
	                	   }else{
	                		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	                		   return;
	                	   }
	                   },
        			   
        			   getDocumentController : function(){
                    	   var this$ = this;
                    	   return this$.getController('Academia.controller.document.DocumentController');
                       },
});
