/**
 * @author sohan chouhan
 */
Ext.define('Academia.controller.hrm.EmployeeAvailabilityController', {
	extend: 'Academia.controller.base.BaseController',

	models: ['transport.serviceRoute.TimeDataModel','common.EmpAvailabilityDataModel'],
    stores: ['hrm.timesheet.HRMTEmployeeSmartSearchStore','department.ParentDepartmentByAccesibleStore','department.ChildDepartmentStore',
    	'userGroup.UserGroupStore','scholarships.LogedInUserAcademyLocationStore','transport.serviceRoute.WeekDays','hrm.timesheet.HRMTEmpAvailDetailsSearchStore',
    	'common.AcademicTermStoreForIntakeYearId','hrm.timesheet.AvailabilitySettingStore','user.UserAcademyLocationStore'],
             
    views: ['hrm.availability.HRMAvailabilityStructure','hrm.availability.HRMAvailabilityTabStructure','hrm.availability.HRMAvailabilityFilter',
    	'hrm.availability.HRMAvailabilityGrid','hrm.availability.HRMAvailabilityWindow','hrm.availability.HRMAvailabilityPlanningGrid',
    	'hrm.availability.HRMAvailabilityPlanningTabStructure','hrm.availability.AvailabilitySettingStructure','hrm.availability.AvailabilitySettingWin'],
            
    
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
        ref: 'hrmavailabilityfilter',
        selector: 'hrmavailabilityfilter'
    },{
        ref: 'hrmavailabilitygrid',
        selector: 'hrmavailabilitygrid'
    },{
        ref: 'hrmavailabilitywindow',
        selector: 'hrmavailabilitywindow'
    },{
        ref: 'hrmavailabilityplanningtabstructure',
        selector: 'hrmavailabilityplanningtabstructure'
    },{
        ref: 'hrmavailabilityplanninggrid',
        selector: 'hrmavailabilityplanninggrid'
    },{
        ref: 'availabilitysettingstructure',
        selector: 'availabilitysettingstructure'
    },{
        ref: 'availabilitysettingwin',
        selector: 'availabilitysettingwin'
    }],
    config: {
    	EMPLOYEE_AVAILABILITY_PRIVILEGES_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_AVAILABILITY_PRIVILEGES'),
    	FACULTY_PORTAL_AVAILABILITY_PLANNING_PRIVILEGES_PRIVILEGES_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_AVAILABILITY_PLANNING_PRIVILEGES')},
    init: function(application) {
        this.control({
        	'hrmavailabilitygrid':{
    			render: function(grid){
    				var me = this;
    				me.doAccessControlValidation(grid, this.getEMPLOYEE_AVAILABILITY_PRIVILEGES_PERMISSION());
     			 },
        	},
        	'hrmavailabilityplanninggrid':{
    			render: function(grid){
    				var me = this;
    				me.doAccessControlValidation(grid, this.getFACULTY_PORTAL_AVAILABILITY_PLANNING_PRIVILEGES_PRIVILEGES_PERMISSION());
    				var grid=me.getHrmavailabilityplanninggrid();
    		    	var store = grid.getStore();
    		    	var currentlyLoggedInUserId= me.getCurrentlyLoggedInUser().id;
    		    	store.getProxy().extraParams = {
    		    		employeeId:currentlyLoggedInUserId,
    		    	},
    		    	me.resetPageSetting(store);
    		    	store.load();
    		    	grid.getSelectionModel().deselectAll(true);
    		    	this.loadAvailabilitySettingData();
    			},
        	},
        	
        	'hrmavailabilitygrid':{
				selectionchange: function() {
					var $this=this;
					var grid = this.getHrmavailabilitygrid();
					var records = grid.getSelectionModel().getSelection();
					var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getEMPLOYEE_AVAILABILITY_PRIVILEGES_PERMISSION());
					var isEdited =false;
					var isViewed =false;
					Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'EDIT') {
			    			isEdited=true;
			        	}
			    		if (privilege === 'VIEW') {
			    			isViewed=true;
			        	}
			    	});
					var grid = this.getHrmavailabilitygrid();
					var btnEdit1= grid.down('#btnEdit');
					var btnView1= grid.down('#btnView');
					if(isEdited){
						if (grid.getSelectionModel().getCount() >= 2) {
							btnEdit1.setDisabled(true);
					 }else{
						 btnEdit1.setDisabled(false);
						 }	
					}
				      if(isViewed){
				    	  if (grid.getSelectionModel().getCount() >= 2) {
				    		  btnView1.setDisabled(true);
						 }else{
							 btnView1.setDisabled(false);
							 }
				      }		
					 }
					
			},	
        	'hrmavailabilityfilter button[itemId=searchEmpAvailFilterItemId]' : {
    			click : this.loadEmpAvailabilityMasterGridData
        		},
        	'hrmavailabilitygrid button[itemId=btnAdd]':{
    			click: this.addEmpAvailabilityDetails
        	},
        	'hrmavailabilitygrid button[itemId=btnEdit]':{
    			click: this.editEmpAvailabilityDetails
        	},
        	'hrmavailabilitygrid button[itemId=btnView]' :{
    			click : this.getViewEmpAvailabilityDetail
    		},
    		'hrmavailabilitygrid  button[itemId=btnDelete]':{
				click:function(obj){
					this.deleteEmpAvailabilityDetail(obj);
					}
			},
			'hrmavailabilityplanninggrid button[itemId=btnAdd]':{
    			click: this.addEmpAvailabilityDetails
        	},
        	'hrmavailabilityplanninggrid button[itemId=btnEdit]':{
    			click: this.editEmpAvailabilityDetails
        	},
        	'hrmavailabilityplanninggrid button[itemId=btnView]' :{
    			click : this.getViewEmpAvailabilityDetail
    		},
    		'hrmavailabilityplanninggrid  button[itemId=btnDelete]':{
				click:function(obj){
					this.deleteEmpAvailabilityDetail(obj);
					}
			},
        	 'hrmavailabilityfilter combo[itemId=empDepartment]' : {
	        	  select: function(obj, record) {
	        		    this.getUserEnableSubDepartment(record[0].get("id"));
	        	  }
	        },
	        'hrmavailabilityfilter combo[itemId=empDepartment]' : {
	        	  select: function(obj, record) {
	        		    this.getUserEnableSubDepartment(record[0].get("id"));
	        	  }
	        },
        	'hrmavailabilitywindow button[itemId=multiEmpAdd]':{
    			click: function(obj){
    				this.addMultipleEmpDetails(obj);
    			}
    		},
    		'hrmavailabilitywindow button[itemId=btnCancelEmpDetails]':{
    			click : this.getCloseEmpAvailWin
    		},
    		 'hrmavailabilitywindow button[itemId=btnSaveEmpDetails]': {
                 click: function(button) {
                 	this.SaveEmpAvailabilityDetails(button);	
                 }
             },
             
             'hrmavailabilitywindow': {
            	  close :function(obj){
            		var $this=this;
            		var portalId = $this.getCurrentLoggedPortalId();
                    if(portalId==2){
            			var form = $this.getHrmavailabilitywindow();
                		var currentlyLoggedInUserId= $this.getCurrentlyLoggedInUser().id;
              	    	//var grid=$this.getHrmavailabilitygrid();
              	    	var grid=$this.getHrmavailabilityplanninggrid();
              	    	var store = grid.getStore();
              	    	
              	    	store.getProxy().extraParams = {
              	    		employeeId:currentlyLoggedInUserId
              	    		
              	    	},
              	    	$this.resetPageSetting(store);
              	    	store.load();
            		}else{
            			var form = $this.getHrmavailabilityfilter();
              	    	var getForm = form.getForm();
              	    	var getFormValues=getForm.getValues();
              	    	
              	    	var grid=$this.getHrmavailabilitygrid();
              	    	var store = grid.getStore();
              	    	
              	    	store.getProxy().extraParams = {
              	    		employeeId:form.down("#employeeItemId").getValue(),
              	    		userGroupName:form.down("#userGroupType").getValue(),
              	    		academyLocationId:form.down("#cmbGlobalAcademyLocation").getValue(),
              	    		deptId:form.down("#empDepartment").getValue(),
              	    		subDeptId:form.down("#getEmpSubDepartmentId").getValue(),
              	    		status:form.down("#statusComboItemId").getValue(),
              	    	},
              	    	$this.resetPageSetting(store);
              	    	store.load();
            		}
                   }
             },
             
             'availabilitysettingstructure button[itemId=btnAddAvailability]': {
     			click: this.addAvailabilitySetting
            	},
             'availabilitysettingstructure button[itemId=btnEdit]': {
            	 click: Ext.bind(
     	                this.editViewEmpAvailabilitySettingDetail, this, [false])
                 	},
           	'availabilitysettingstructure button[itemId=btnView]': {
           		click: Ext.bind(
    	                this.editViewEmpAvailabilitySettingDetail, this, [true])
                     	},
            'availabilitysettingstructure button[itemId=btnDelete]': {
            	click: function(obj){
    				this.deleteEmpAvailabilitySettingDetail(obj);
    			}
                         	},
            'availabilitysettingwin button[itemId=btnSaveAvaiSetting]': {
            	click:function(obj){
					this.saveAvailabilitySetting(obj);
					}
              },
              'availabilitysettingwin button[itemId=btnCancelAvaiSetting]': {
				click:function(obj){
 	        		obj.up('window').close();
     	        	}
			},
			'availabilitysettingstructure ': {
				render: function(grid){
				var me = this;
				var grid=me.getAvailabilitysettingstructure();
		    	var store = grid.getStore();
		    	store.load();
			}},
			'hrmavailabilitygrid':{
    			render: function(){
         			 this.loadAvailabilitySettingData()
                },
        	},
        	 'hrmavailabilityfilter button[itemId=resetHRMAvailabilityFilterItemId]' : {
	        	  click: function() {
	        		    this.resetFilterSubDeptField()
	        	  }
	        },
        });
    },
   
    getUserEnableSubDepartment: function(parentId, recId) {
		if(parentId){
		    var subDepartmentCombo = this.getHrmavailabilityfilter().down("#getEmpSubDepartmentId");
		    subDepartmentCombo.reset();
		    subDepartmentCombo.enable();
		    var store = subDepartmentCombo.getStore();
		    store.getProxy().extraParams = {
		        parentId: parentId
		    };
		    store.load({
		        callback: function(records, operation, success) {
		            if (recId && success) {
		                subDepartmentCombo.setValue(recId);
		            }
		        }
		    });
		}
	},
	  addEmpAvailabilityDetails: function() {
	       	var $this = this;
	    	 var portalId = $this.getCurrentLoggedPortalId();
             if(portalId==2){
            	 var grid = $this.getHrmavailabilityplanninggrid();
            	 grid.getSelectionModel().deselectAll();
             }else{
            	 var grid = $this.getHrmavailabilitygrid();
            	 grid.getSelectionModel().deselectAll();
             }
	      	  var portalId = $this.getCurrentLoggedPortalId();
	          var emp = Ext.widget('hrmavailabilitywindow');
	          if(portalId==2){
	          	 var empId = emp.down('#employeeItemId');
	          	empId.setReadOnly(true);
	          	 var empIdStore = empId.getStore();
	          	 empIdStore.load({
	   	  				   callback: function(records, operation, success) {
	   	  					   if (success) {
	  							empId.setValue($this.getCurrentlyLoggedInUser().id);
	  					      }
	   	  				   }	   
	   	  			   });
	             }
	          emp.show();
	      },
      /**
	    * Add multiple Employee details in panel
	    */
    addMultipleEmpDetails:function(obj){
	   	   var $this = this;
	   	   var empFormWin =  $this.getHrmavailabilitywindow();
	   	   var empContiner = empFormWin.down('form').getForm();
	   	   var empContiner = empFormWin.down('#empPanelId');
	   	   var panelItem = new Array();
	   	   var fieldContainer=obj.up('fieldcontainer');
	   	   var newcont=empContiner.items.indexOf(fieldContainer);
		   var insertPosition=newcont+1;
		   if(empContiner.items.length == 0){
			   panelItem.push({
	                xtype: 'fieldcontainer',
	                //itemId:'empPanelId',
	                layout: 'hbox',
	                defaults: {
	                    labelAlign: 'top',
	                    width:'226'
	                },
	                items: [{
		                xtype: 'customcombobox',
		                name: 'employeeId',
		                itemId: 'employeeItemId',
		                fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
		                store: 'hrm.timesheet.HRMTEmployeeSmartSearchStore',
		                valueField: 'id',
		                displayField: 'valueCode',
		                queryParam: 'codeOrName',
		                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
		                enableKeyEvents: 'true',
		                minChars: 3,
		                typeAhead: false,
		                forceSelection: true,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                // triggerAction: '',
		                hideTrigger: false,
		                maxLength: 100,
		                listConfig: {
		                    listeners: {
		                        beforeshow: function(
		                            picker) {
		                            picker.minWidth = picker
		                                .up('combobox')
		                                .getSize().width;
		                        }
		                    },
		                    loadingText: getCommonTranslation('SEARCHING'),
		                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                    getInnerTpl: function() {
		                        return '<div class="search-item">' +
		                            '{studentCode} / {studentName}' +
		                            '</div>';
		                    }
		                }
		            }, {
		    			xtype: 'customcombobox',
		    			name: 'empDays',
		    			width:200,
		    			allowBlank: false,
		    			maxHeight:200,
		    			itemId: 'empDayId',
		    			autoScroll:true,
		    			store:'transport.serviceRoute.WeekDays',
		    			displayField: 'value',
		    			valueField: 'value',
		    			fieldLabel: getTransportTranslation('DAYS'),
		    			listConfig: {
		                    listeners: {
		                        beforeshow: function(
		                            picker) {
		                            picker.minWidth = picker
		                                .up('combobox')
		                                .getSize().width;
		                        }
		                    },
		                    loadingText: getCommonTranslation('SEARCHING'),
		                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                    getInnerTpl: function() {
		                        return '<div class="search-item">' +
		                            '{value}' +
		                            '</div>';
		                    }
		                }
		    		},{
						xtype : 'timefield',
						name : 'fromTime',		
						itemId : 'fromTime',			
						fieldLabel:getProgramandcourseTranslation('START_TIME'),
						format:'g:i A',
						increment: 1,
						vtype: 'timerange',
						width:200,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
									obj.nextSibling().setMinValue(sDate);	
								}
							}
						}
					},{
						xtype : 'timefield',
						name : 'toTime',		
						itemId : 'toTime',			
						fieldLabel:getProgramandcourseTranslation('END_TIME'),
						format:'g:i A',
						vtype: 'timerange',
						increment: 1,
						width:200,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
									obj.previousSibling().setMaxValue(eDate);
								}
							}
						}
					},{
						xtype: 'textfield',
						name:'remark',
						itemId:'remark',
						width: 200,
						maxLength : 255,
						fieldLabel: getPersonModuleTranslation('REMARK')
					},{
						xtype: 'button',
						itemId: 'multiEmpAdd',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					 }]
	            }); 
		   }else{
			   panelItem.push({
	                xtype: 'fieldcontainer',
	                //itemId:'empPanelId',
	                layout: 'hbox',
	                defaults: {
	                    labelAlign: 'top',
	                    width:'226'
	                },
	                items: [{
		                xtype: 'customcombobox',
		                name: 'employeeId',
		                itemId: 'employeeItemId',
		                store: 'hrm.timesheet.HRMTEmployeeSmartSearchStore',
		                valueField: 'id',
		                displayField: 'valueCode',
		                queryParam: 'codeOrName',
		                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
		                enableKeyEvents: 'true',
		                minChars: 3,
		                typeAhead: false,
		                forceSelection: true,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                // triggerAction: '',
		                hideTrigger: false,
		                maxLength: 100,
		                listConfig: {
		                    listeners: {
		                        beforeshow: function(
		                            picker) {
		                            picker.minWidth = picker
		                                .up('combobox')
		                                .getSize().width;
		                        }
		                    },
		                    loadingText: getCommonTranslation('SEARCHING'),
		                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                    getInnerTpl: function() {
		                        return '<div class="search-item">' +
		                            '{studentCode} / {studentName}' +
		                            '</div>';
		                    }
		                },
		                listeners:{
	    					 afterrender: function(obj, rec,value){
	    						 setTimeout(function(){
	    							 var portalId = $this.getCurrentLoggedPortalId();
	    				             if(portalId==2){
	    				            	 obj.setReadOnly(true);
	    				            	 var employeeFilter = $this.getHrmavailabilitywindow();
	    				             }else{
	    				            	 obj.setReadOnly(false);
	    				            	 var employeeFilter = $this.getHrmavailabilityfilter();
		    							 var filterForm = employeeFilter.getForm();
	    				             }
	    							 var values = obj.up('form').getForm().getValues();
	    							 var facultyId = values.employeeId;
	    							 for(var j in facultyId){
	    								 if(facultyId[j]==""){
	    									 obj.setValue(facultyId[j-1]);
	    								 }

	    							 }
	    						 },500);
	    					 },
	    				 }
		            }, {
		    			xtype: 'customcombobox',
		    			name: 'empDays',
		    			width:200,
		    			allowBlank: false,
		    			maxHeight:200,
		    			itemId: 'empDayId',
		    			autoScroll:true,
		    			store:'transport.serviceRoute.WeekDays',
		    			displayField: 'value',
		    			valueField: 'value',
		    			listConfig: {
		                    listeners: {
		                        beforeshow: function(
		                            picker) {
		                            picker.minWidth = picker
		                                .up('combobox')
		                                .getSize().width;
		                        }
		                    },
		                    loadingText: getCommonTranslation('SEARCHING'),
		                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                    getInnerTpl: function() {
		                        return '<div class="search-item">' +
		                            '{value}' +
		                            '</div>';
		                    }
		                }
		    		},{
						xtype : 'timefield',
						name : 'fromTime',		
						itemId : 'fromTime',			
						format:'g:i A',
						increment: 1,
						vtype: 'timerange',
						width:200,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
									obj.nextSibling().setMinValue(sDate);	
								}
							}
						}
					},{
						xtype : 'timefield',
						name : 'toTime',		
						itemId : 'toTime',			
						format:'g:i A',
						vtype: 'timerange',
						increment: 1,
						width:200,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
									obj.previousSibling().setMaxValue(eDate);
								}
							}
						}
					},{
						xtype: 'textfield',
						name:'remark',
						itemId:'remark',
						width: 200,
						maxLength : 255,
					},{
						xtype: 'button',
						itemId: 'multiEmpAdd',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
					 },{
			   			   xtype: 'button',
			   			   glyph: ICONGLYPH.DELETEGLYPH,
			   			   cls: 'CustomBodyBtnReject',
			   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
			   			   width:40,
			   			   listeners:{
			   				   click:function(obj){
			   					   var container = obj.up('fieldcontainer');
			   					   var panelContiner = $this.getHrmavailabilitywindow().down('#empPanelId');
			   					   panelContiner.remove(container);
			   					   var empFormWin =  $this.getHrmavailabilitywindow();
	   	                           var empContiner = empFormWin.down('form').getForm();
			   					   empContiner.checkValidity();
			   					   empContiner.isValid();
			   					   empContiner.clearInvalid();
			   				   }
			   			   }}]
	            });
		   }
			empContiner.insert(insertPosition,panelItem);
			empContiner.doLayout();
	      },
	      
	      SaveEmpAvailabilityDetails: function(button) {
	      	var this$ = this;
	    	var empDetails = button.up('window[xtype=hrmavailabilitywindow]');
	    	 var portalId = this.getCurrentLoggedPortalId();
             if(portalId==2){
            	 var grid = this$.getHrmavailabilityplanninggrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }else{
            	 var grid = this$.getHrmavailabilitygrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }
	    	
	    	var updatedId = [];
	  		if(record.length>0){
	  			for(var i in record){
	  				updatedId.push(record[i].data.id);
	  			}
	  	    	}
	    	var empDetailsForm = empDetails.down('form');
	    	var formData = empDetailsForm.getValues();

	    	var submitUrl;
	    	var isUpdate = false;
	    	if (updatedId == null || updatedId == "") {
	    		submitUrl = SERVERURL.PATH_UPDATE_EMP_AVAILABILITY;
	    	} else {
	    		submitUrl = SERVERURL.PATH_UPDATE_EMP_AVAILABILITY;
	    		isUpdate = true;
	    	}
	    	
	    	var empContiner = empDetailsForm.down('#empPanelId');
	    	var empFieldsCount = empContiner.items.length-1;
	    	var empArray=new Array();
	    	var weekdays=[];
	    	var fieldSequence = 1;
	    		for(var j=0; j<empContiner.items.length-1; j++){
	    			var empPanelContainer=empContiner.items.items[j];
	    			var a=empPanelContainer.items.items[1].getValue();
	    			weekdays.push(a)
	    			 empArray.push({
	    					"employeeId":empPanelContainer.items.items[0].getValue(),
	    		    	    "employeeWeekday":weekdays[j],
	    					"availableFrom":this$.timeFormator(empPanelContainer.items.items[2].getValue()),
	    					"availableTo": this$.timeFormator(empPanelContainer.items.items[3].getValue()),
	    					 "id":updatedId[j],
	    					 "remark":empPanelContainer.items.items[4].getValue(),
	    					 });
	    			 fieldSequence=fieldSequence+1;
	    			 }
	    	var status1 = this$.duplicateEntryCheckForFormData(empArray, empArray);		  
	    	var status = this$.duplicateEntryCheckForGridData(grid.getStore(),grid, empArray);
	    	if(status==false&&status1==false){
	    		var jsonFormatFormData = Ext.encode(empArray);
	    		
		    	this$.applyWindowMask(); 
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		url: submitUrl,
		    		jsonData: jsonFormatFormData,
		    		method: 'POST',
		    		success: function(form, action) {
		    			empDetails.close();
		    			grid.getStore().reload();
		    			grid.getSelectionModel().deselectAll();

		    			if (isUpdate) {
		    				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('EMPLOYEE_AVAILABILITY_SUCCESFULLY_UPDATED'));											
		    			} else {
		    				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('EMPLOYEE_AVAILABILITY_SUCCESFULLY_CREATED'));										
		    			}
		    		}, failure: function(form, action) {
		    			empDetails.close();
		    			this$.hideWindowMask();
		    		}

		    	});
	    	}
	    	
	    },
	  
	    duplicateEntryCheckForFormData: function(empArray1, empArray) {
	    	var this$ = this;
	        var status1 = false;
	        for(var i in empArray1){
	        	for(var j=parseInt(i)+1; j<=empArray.length-1; j++){
	            if (empArray[i].employeeId == empArray1[j].employeeId && empArray[i].employeeWeekday == empArray1[j].employeeWeekday 
	            		&& (this$.timeformat24hr(empArray[i].availableFrom) <= this$.timeformat24hr(empArray1[j].availableFrom) || this$.timeformat24hr(empArray[i].availableTo) >= this$.timeformat24hr(empArray1[j].availableFrom))
	            		&& (this$.timeformat24hr(empArray[i].availableFrom) >= this$.timeformat24hr(empArray1[j].availableFrom) || this$.timeformat24hr(empArray[i].availableFrom) <= this$.timeformat24hr(empArray1[j].availableFrom)) 
	            		&& (this$.timeformat24hr(empArray[i].availableTo) >= this$.timeformat24hr(empArray1[j].availableTo) || this$.timeformat24hr(empArray[i].availableTo) <= this$.timeformat24hr(empArray1[j].availableTo)) 
	            		&& (this$.timeformat24hr(empArray[i].availableTo) >= this$.timeformat24hr(empArray1[j].availableFrom))) {
	        		     showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('employee slot already exist'));
	                     status1 = true;
	                     break;
	            }
	     
	           }
	        }
	        return status1;
	    },
	    duplicateEntryCheckForGridData: function(gridStore,gridData, empArray) {
	    	var this$ = this;
	        var status = false;
	        var selectedRecord = gridData.getSelectionModel().getSelection();
	        if(!isNullOrEmpty(empArray[0].id)){
	        	gridData.getStore().remove(selectedRecord);
 				}
						      gridStore.each(function(record) {
	        	for ( var i in empArray) {
					if (empArray[i].employeeId == record
							.get('employeeId')
							&& empArray[i].employeeWeekday == record
									.get('employeeWeekday')
							&& (this$.timeformat24hr(empArray[i].availableFrom) >= this$.timeformat24hr(timeFormatRender(record
									.get('availableFrom'))) || this$.timeformat24hr(empArray[i].availableTo) >= this$.timeformat24hr(timeFormatRender(record
									.get('availableFrom'))))
							&& (this$.timeformat24hr(empArray[i].availableFrom) <= this$.timeformat24hr(timeFormatRender(record
									.get('availableFrom'))) || this$.timeformat24hr(empArray[i].availableFrom) >= this$.timeformat24hr(timeFormatRender(record
									.get('availableFrom'))))
							&& (this$.timeformat24hr(empArray[i].availableTo) <= this$.timeformat24hr(timeFormatRender(record
									.get('availableTo'))) || this$.timeformat24hr(empArray[i].availableTo) >= this$.timeformat24hr(timeFormatRender(record
									.get('availableTo'))))
							&& this$.timeformat24hr(timeFormatRender(record
									.get('availableTo'))) >= this$.timeformat24hr(empArray[i].availableFrom)) {
						showWarningMessage(
								getCommonTranslation('ALERT'),
								getCommonTranslation('employee slot already exist'));
						if (!isNullOrEmpty(empArray[0].id)) {
							gridData.getStore().add(
									selectedRecord);
						}
						status = true;
						break;
					}
				}
	        });
	        return status;
	    },
	    
	    timeformat24hr :function(time){
	    	 var len=time.length;
	    	 if(len==7){
	    	 	time="0"+time;
	    	 }
	    	 var modifier=time.substring(6,8);
	         var hour=time.substring(0,2);
	         var min=time.substring(3,5);
	         
	         if(hour=="12" && modifier=="AM"){
	             hour = "00";
	         }
	         else if (modifier=="PM") {
	             
	            hour = parseInt(hour)+ 12;
	        }
	         
	        return hour+":"+min;
	    },
	    
	    timeFormator : function(value){
            var time="";
            if(!isNullOrEmpty(value)){
           	  var model = new Academia.model.transport.serviceRoute.TimeDataModel;
           	  model.set('startTime',value);
                time=Ext.Date.format(model.get('startTime'), 'g:i A');
            }
            return time;
        },
        loadEmpAvailabilityMasterGridData:function(obj){
	    	var $this=this;
	    	var form = obj.up('form');
	    	var getForm = form.getForm();
	    	var getFormValues=getForm.getValues();
	    	
	    	var grid=$this.getHrmavailabilitygrid();
	    	var store = grid.getStore();
	    	
	    	store.getProxy().extraParams = {
	    		employeeId:form.down("#employeeItemId").getValue(),
	    		userGroupName:form.down("#userGroupType").getValue(),
	    		academyLocationId:form.down("#cmbGlobalAcademyLocation").getValue(),
	    		deptId:form.down("#empDepartment").getValue(),
	    		subDeptId:form.down("#getEmpSubDepartmentId").getValue(),
	    		status:form.down("#statusComboItemId").getValue(),
	    	},
	    	$this.resetPageSetting(store);
	    	store.load();
	    	grid.getSelectionModel().deselectAll(true);
	    	/*pdf & excel report header filter*/
	    	grid.config.searchFilterForm = form;
	    },
	    
	    getViewEmpAvailabilityDetail : function(){
	  		var $this=this;
	  		 var portalId = this.getCurrentLoggedPortalId();
             if(portalId==2){
            	 var grid = $this.getHrmavailabilityplanninggrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }else{
            	 var grid = $this.getHrmavailabilitygrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }
	  		if(record.length>0){
	  			var formWindow = $this.getHrmavailabilitywindow();
	  	    	if (!formWindow) {
	  	    		Ext.widget('hrmavailabilitywindow');
	  	    		formWindow = $this.getHrmavailabilitywindow();
	  	    	}
	  	    formWindow.show();	
	  	    var multiEmpAdd = formWindow.down('#multiEmpAdd');
	  	    multiEmpAdd.setDisabled(true);
	  	    var empId = formWindow.down('#employeeItemId');
	  	     empId.setReadOnly(true);
	  	    var empIdStore = empId.getStore();
	  	    empIdStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						   empId.setValue(record[0].data.employeeId);
	  					   }
	  				   }	   
	  			   });
	  	   var empDayId = formWindow.down('#empDayId');
	  	   empDayId.setReadOnly(true);
	  	    var empDayIdStore = empDayId.getStore();
	  	    empDayIdStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						 empDayId.setValue(record[0].data.employeeWeekday);
	  					   }
	  				   }	   
	  			   });
	  	  var fromTime = formWindow.down('#fromTime');
	  	  fromTime.setReadOnly(true);
	  	    var fromTimeStore = fromTime.getStore();
	  	  fromTimeStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						 if(!isNullOrEmpty(record[0].data.availableFrom)){
	  						   fromTime.setValue(timeFormatRender(record[0].data.availableFrom));
	  						 }
	  					   }
	  				   }	   
	  			   });
	  	  var toTime = formWindow.down('#toTime');
	  	  toTime.setReadOnly(true);
	  	    var toTimeStore = toTime.getStore();
	  	  toTimeStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						 if(!isNullOrEmpty(record[0].data.availableTo)){
	  							 toTime.setValue(timeFormatRender(record[0].data.availableTo));
	  						 }
	  					   }
	  				   }	   
	  			   });
		  	 var remark = formWindow.down('#remark');
		  	 remark.setValue(record[0].data.remark);
		  	remark.setReadOnly(true);
		  	  
	  	   var btnSaveEmpDetails = formWindow.down('#btnSaveEmpDetails');
	  	   btnSaveEmpDetails.setVisible(false);
	  		}else{
	  	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  		}
	      },
	      
	      getCloseEmpAvailWin : function(obj){
	    	  this.getHrmavailabilitywindow().close();
	    	  if(portalId==1){
	    		  var $this=this;
			    	var form = $this.getHrmavailabilityfilter();
			    	var getForm = form.getForm();
			    	var getFormValues=getForm.getValues();
			    	
			    	var grid=$this.getHrmavailabilitygrid();
			    	var store = grid.getStore();
			    	
			    	store.getProxy().extraParams = {
			    		employeeId:form.down("#employeeItemId").getValue(),
			    		userGroupName:form.down("#userGroupType").getValue(),
			    		academyLocationId:form.down("#cmbGlobalAcademyLocation").getValue(),
			    		deptId:form.down("#empDepartment").getValue(),
			    		subDeptId:form.down("#getEmpSubDepartmentId").getValue(),
			    		status:form.down("#statusComboItemId").getValue(),
			    	},
			    	$this.resetPageSetting(store);
			    	store.load();
	    	  }
	      },
	      
	      editEmpAvailabilityDetails:function(){
	  		var $this=this;
	  		 var portalId = this.getCurrentLoggedPortalId();
             if(portalId==2){
            	 var grid = $this.getHrmavailabilityplanninggrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }else{
            	 var grid = $this.getHrmavailabilitygrid();
     	    	var record = grid.getSelectionModel().getSelection();
             }
	  		if(record.length>0){
	  			var formWindow = $this.getHrmavailabilitywindow();
	  	    	if (!formWindow) {
	  	    		Ext.widget('hrmavailabilitywindow');
	  	    		formWindow = $this.getHrmavailabilitywindow();
	  	    	}
	  	    formWindow.show();	
	  	    var empId = formWindow.down('#employeeItemId');
	  	    var empIdStore = empId.getStore();
	  	    empIdStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						   for(var i=0;i<records.length;i++){
	  					   		if(record[0].data.employeeId == records[i].data.id){
	  					   			 empId.setValue(record[0].data.employeeId);
	  						         empId.setReadOnly(true);
	  					   		}
	  					   	}
	  					}
	  				   }	   
	  			   });
	  	   var empDayId = formWindow.down('#empDayId');
	  	    var empDayIdStore = empDayId.getStore();
	  	    empDayIdStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						 empDayId.setValue(record[0].data.employeeWeekday);
	  					   }
	  				   }	   
	  			   });
	  	  var fromTime = formWindow.down('#fromTime');
	  	    var fromTimeStore = fromTime.getStore();
	  	  fromTimeStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						   if(!isNullOrEmpty(record[0].data.availableFrom)){
	  							   fromTime.setValue(timeFormatRender(record[0].data.availableFrom));
	  						   }
	  					   }
	  				   }	   
	  			   });
	  	  var toTime = formWindow.down('#toTime');
	  	    var toTimeStore = toTime.getStore();
	  	  toTimeStore.load({
	  				   callback: function(records, operation, success) {
	  					   if (success) {
	  						 if(!isNullOrEmpty(record[0].data.availableTo)){
	  							 toTime.setValue(timeFormatRender(record[0].data.availableTo));
	  						 }
	  					   }
	  				   }	   
	  			   });
	  	 var remark = formWindow.down('#remark');
	  	 remark.setValue(record[0].data.remark);
	  	  
	  		}else{
	  	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  		}
	      },
	      
	      deleteEmpAvailabilityDetail:function(obj){
	    	  var $this= this;
	    	  var portalId = $this.getCurrentLoggedPortalId();
	    	  if(portalId==2){
	    		  var grid = $this.getHrmavailabilityplanninggrid();
	    		  var records = grid.getSelectionModel().getSelection();
	    	  }else{
	    		  var grid = $this.getHrmavailabilitygrid();
	    		  var records = grid.getSelectionModel().getSelection();
	    	  }
	    	  var empAvailIds=[];
	    	  if(!isNullOrEmpty(records) && records.length > 0) {
	    		  for( var i=0; i<records.length; i++ ) {
	    			  if(!isNullOrEmpty(records[i].data.id)){
	    				  empAvailIds.push(records[i].data.id);
	    			  }
	    		  }
	    		  var Ids = empAvailIds.join(',');
	    		  showConfirmMessage(getCommonTranslation('EMPLOYEE_AVAILABILITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	    				  function(btn, text) {
	    			  if (btn == 'yes'){
	    				  Ext.Ajax.request({
	    					  method: "GET",
	    					  type: 'rest',
	    					  url: SERVERURL.PATH_DELETE_EMP_AVAILABILITY,
	    					  headers: {
	    						  'Content-Type': 'application/json'
	    					  },
	    					  params: {
	    						  empAvailIds:Ids,
	    					  },
	    					  success : function(form, action) {
	    						  showSuccessMessage(getDMSTranslation('SUCCESS'),getDMSTranslation('SUCCESS_MSG'));
	    						  grid.getStore().reload();
	    					  }
	    				  });	
	    			  }
	    		  });
	    	  }
	    	  else{
	    		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	  }
	      },
	      addAvailabilitySetting: function() {
	    	  var grid = this.getAvailabilitysettingstructure();
	    	  var emp = Ext.widget('availabilitysettingwin');
	          emp.show();
	      },
	      saveAvailabilitySetting:function(obj){
		    	 var $this= this;	
		    	 var empDetails = obj.up('window[xtype=availabilitysettingwin]');
		    	 var empDetailsForm = empDetails.down('form');
		  		var window = $this.getAvailabilitysettingwin();
		  		var grid = $this.getAvailabilitysettingstructure();
		  		var record = grid.getSelectionModel().getSelection()[0];
		  		var updatedId;
		  		
		  		var availSettingArray=new Array();
		  		var alId = window.down('#settingAcademyLocation').getValue();
		  		var settingAcademicTerm = window.down('#settingAcademicTerm').getValue();
		  		var startDate = window.down('#startDate').getValue();
		  		var endDate=window.down('#endDate').getValue();
		  		updatedId= window.down('#id').getValue();
		  		var submitUrl;
		  		if(!isNullOrEmpty(updatedId)){
		  			updatedId=	record.data.id;
		  			if(record.data.academicTermName==settingAcademicTerm){
			  			settingAcademicTerm=record.data.academicTermId;
			  		}
		  		}
		  		
		  		if(!isNullOrEmpty(updatedId)){
		  			submitUrl=SERVERURL.PATH_UPDATE_AVAILABILITY_SETTING;
		  			 availSettingArray={
			  			  "id":updatedId,
		  					"acdemyLocationId":alId,
		  		    	    "academicTermId":settingAcademicTerm,
		  					"startDate":Ext.Date.format(startDate, CONSTANTS.SUBMIT_DATE_FORMAT),
		  					"endDate": Ext.Date.format(endDate, CONSTANTS.SUBMIT_DATE_FORMAT)
		  				};
		  		}else {
		  			submitUrl=	SERVERURL.PATH_CRAETE_AVAILABILITY_SETTING;
		  			

			  	    availSettingArray={
	 					"acdemyLocationId":alId,
	 		    	    "academicTermId":settingAcademicTerm,
	 					"startDate":Ext.Date.format(startDate, CONSTANTS.SUBMIT_DATE_FORMAT),
	 					"endDate": Ext.Date.format(endDate, CONSTANTS.SUBMIT_DATE_FORMAT)
	 				};
		  		}
		  		
		  	 var status = $this.duplicateEntryCheckForGridDataAvailabilitySetting(grid.getStore(),grid, availSettingArray);
		  	if(status==false){
		  	  var jsonFormatFormData = Ext.encode(availSettingArray);
	    		
		    	this$.applyWindowMask(); 
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		url: submitUrl,
		    		jsonData: jsonFormatFormData,
		    		method: 'POST',
		    		success: function(form, action) {
		    			empDetails.close();
		    			this$.hideWindowMask();
		    			grid.getStore().reload();
		    			grid.getSelectionModel().deselectAll();
		    			showSuccessMessage(getDMSTranslation('SUCCESS'),getDMSTranslation('SUCCESS_MSG'));											
		    		}, failure: function(form, action) {
		    			empDetails.close();
		    			this$.hideWindowMask();
		    		}

		    	});
		  	}
	  },
	  loadAvailabilitySettingData:function(){
			var $this= this;
			 var portalId = $this.getCurrentLoggedPortalId();
             if(portalId==2){
            	 var grid = $this.getHrmavailabilityplanninggrid();
             }else{
            	 var grid = $this.getHrmavailabilitygrid();
             }
			var addBtn = grid.down('#btnAdd');
			var editBtn = grid.down('#btnEdit')
			var academyLocationId = $this.getCurrentAcademyLocation();
			var currentDate = Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT);

	        	   Ext.Ajax.request({
			 			 method: "GET",
			             type: 'rest',
			             url: SERVERURL.PATH_FINDBY_AVAILABILITY_SETTING_DETAIL,
			             headers: {
			                 'Content-Type': 'application/json'
			             },
			             params: {
			            	 academyLocationId: academyLocationId,
			            	 currentDate:currentDate,
			             },
			             success: function(response, action) {
			                 var data = Ext.decode(response.responseText);
			                 if(data.length>0){
			                	 addBtn.setDisabled(false);	
			                	 editBtn.setDisabled(false);	
			                 }else{
			                	 addBtn.setDisabled(true);
			                	 editBtn.setDisabled(true)
			                 }
			    		},
			 		});	
	},
	 resetFilterSubDeptField: function() {
	    	var subDepartmentCombo1 = this.getHrmavailabilityfilter().down("#getEmpSubDepartmentId");
		    subDepartmentCombo1.setDisabled(true);
	    },
	    
	    editViewEmpAvailabilitySettingDetail : function(isEditable){
			var $this = this;
			
			var grid = $this.getAvailabilitysettingstructure();
			
			if(grid.getSelectionModel().getCount()>0) {
				$this.addAvailabilitySetting();
				
				 var window = $this.getAvailabilitysettingwin();
				 var record = grid.getSelectionModel().getSelection()[0];
				
				 var academyLocation = window.down('#settingAcademyLocation');
				 var empIdStore = academyLocation.getStore();
			  	   var academyLocation = window.down('#settingAcademyLocation');
				var academyLocationId= record.data.acdemyLocationId;
 				var academyLocationStore = academyLocation.getStore();
 				
 				academyLocationStore.load({
						 callback: function(records, operation, success) {
							 academyLocation.setValue(academyLocationId);
		      		   }	   
				    });
				var settingAcademicTerm = window.down('#settingAcademicTerm').setValue(record.data.academicTermName);
				 window.down('#id').setValue(record.data.id);
				var fromDateVal = new Date(record.data.startDate);
				var toDateVal = new Date(record.data.endDate);
				
				var fromDate = window.down('#startDate');
				var toDate = window.down('#endDate');
				if(record.data.startDate!=null){
					fromDate.setValue(fromDateVal);
				}
				if(record.data.endDate!=null){
						toDate.setValue(toDateVal);
				}
				if(fromDate.getValue()!=null){
					if(fromDate.getValue()< new Date()){
						fromDate.setReadOnly(true);
						
					}
				}
				if(toDate.getValue()!=null){
					if(toDate.getValue()< new Date()){
						toDate.setReadOnly(true);
					}	
				}
				
					
				var formPnl = $this.getAvailabilitysettingwin();
				var form=formPnl.down("form");
				if(isEditable) {
					formPnl.down('#btnSaveAvaiSetting').setVisible(false);
					settingAcademicTerm.setReadOnly(true);
					academyLocation.setReadOnly(true);
					toDate.setReadOnly(true);
					fromDate.setReadOnly(true);
				   formPnl.doLayout();
				}
				
				
			} else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
	    },
	   
	    deleteEmpAvailabilitySettingDetail:function(obj){
	    	  var $this= this;
	    	  var grid = this.getAvailabilitysettingstructure();
		      var grdStore = grid.getStore();
	    	  var records = grid.getSelectionModel().getSelection();
	    	  var empAvailIds=[];
          	  var currentdate1=new Date().getFullYear()+"-"+  (new Date().getMonth()+1) +""+"-"+ new Date().getDate();
              var aviValu=false;
           var   currentdate=new Date(currentdate1).toLocaleDateString()
              if(!isNullOrEmpty(records) && records.length > 0) {
            	  for (var i = 0; i < records.length; i++) {
            		  if(isNullOrEmpty(records[count].get("startDate")) && isNullOrEmpty(records[count].get("endDate"))){
            			  aviValu = true;
            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }
            		  }
            		  else if (currentdate > new Date(records[count].get("startDate")).toLocaleDateString() && currentdate > new Date(records[count].get("endDate")).toLocaleDateString()) {
            			  aviValu = true;

            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }
            		  }  else if (currentdate < new Date(records[count].get("startDate")).toLocaleDateString() && currentdate <  new Date(records[count].get("endDate")).toLocaleDateString()) {
            			  aviValu = true;

            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }
            		  }else if ( isNullOrEmpty(records[count].get("endDate")) && (currentdate >  new Date(records[count].get("startDate")).toLocaleDateString()||currentdate <  new Date(records[count].get("startDate")).toLocaleDateString())) {
            			  aviValu = true;

            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }

            		  } else if (currentdate >new Date(records[count].get("startDate")).toLocaleDateString() && currentdate > new Date(records[count].get("endDate")).toLocaleDateString()) {
            			 

            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }
            		  }else if ( isNullOrEmpty(records[count].get("startDate")) && (currentdate > new Date(records[count].get("endDate")).toLocaleDateString()||currentdate < new Date(records[count].get("endDate")).toLocaleDateString())) {
            			  aviValu = true;

            			  if (!isNullOrEmpty(records[i].data.id)) {
            				  empAvailIds.push(records[i].data.id);
            			  }

            		  }else {
            			  aviValu = false;
            			  break;
            		  }
            	  }
            	  
            	  if(aviValu==true){
            		  var Ids = empAvailIds.join(',');
            		  showConfirmMessage(getCommonTranslation('EMPLOYEE_AVAILABILITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
            				  function(btn, text) {
            			  if (btn == 'yes'){
            				  Ext.Ajax.request({
            					  method: "GET",
            					  type: 'rest',
            					  url: SERVERURL.PATH_FIND_AVAILABILITY_SETTING_DELETE,
            					  headers: {
            						  'Content-Type': 'application/json'
            					  },
            					  params: {
            						  availSettingIds:Ids,
            					  },
            					  success : function(form, action) {
            						  showSuccessMessage(getDMSTranslation('SUCCESS'),getDMSTranslation('SUCCESS_MSG'));
            						  grid.getStore().reload();
            					  }
            				  });	
            			  }
            		  });
            	  } else{
            		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_RECORD_CANNOT_BE_DELETED'));


            	  }
              }
	    	  else{
	    		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	  }
	      },
	      duplicateEntryCheckForGridDataAvailabilitySetting: function(gridStore,gridData, empArray) {
		    	var this$ = this;
		        var status = false;
		        var selectedRecord = gridData.getSelectionModel().getSelection();
		        if(!isNullOrEmpty(empArray.id)){
		        	gridData.getStore().remove(selectedRecord);
	 				}
		      
		        var data=gridStore.data
		       for(var i in data.items){
		    	   if(empArray.acdemyLocationId ==  data.items[i].data.acdemyLocationId && empArray.academicTermId == data.items[i].data.academicTermId &&(isNullOrEmpty(empArray.endDate)&&isNullOrEmpty(empArray.startDate)))
                     {
		    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
 	                if(!isNullOrEmpty(empArray.id)){
	    	        	gridData.getStore().add(selectedRecord);
	     				}
	                status = true;
	                break;
		    		   }else if(empArray.acdemyLocationId ==  data.items[i].data.acdemyLocationId && empArray.academicTermId == data.items[i].data.academicTermId 
		    				   &&(isNullOrEmpty(empArray.endDate)&& empArray.startDate == data.items[i].data.startDate))
	                     {
			    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
	 	                if(!isNullOrEmpty(empArray.id)){
		    	        	gridData.getStore().add(selectedRecord);
		     				}
		                status = true;
		                break;
			    		   }else if(empArray.acdemyLocationId ==  data.items[i].data.acdemyLocationId && empArray.academicTermId == data.items[i].data.academicTermId 
			    				   &&(isNullOrEmpty(empArray.startDate)&& empArray.endDate == data.items[i].data.endDate))
		                     {
				    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
		 	                if(!isNullOrEmpty(empArray.id)){
			    	        	gridData.getStore().add(selectedRecord);
			     				}
			                status = true;
			                break;
				    		   }else if (empArray.acdemyLocationId ==  data.items[i].data.acdemyLocationId && empArray.academicTermId == data.items[i].data.academicTermId
    	            		&& empArray.endDate == data.items[i].data.endDate && empArray.startDate == data.items[i].data.startDate)
    	            		 {
    	                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
    	                if(!isNullOrEmpty(empArray.id)){
    	    	        	gridData.getStore().add(selectedRecord);
    	     				}
    	                status = true;
    	                break;
    	            }
        	
		        }
		        
		        return status;
		    },
});
