/**
 * @author Bhanu PS
 */
Ext.define('Academia.controller.leavemanagement.administrativeleave.AdministrativeSettingController', {
	extend: 'Academia.controller.base.BaseController',

    stores: ['leavemanagement.administrativeleave.AdminCodeStore','leavemanagement.administrativeleave.AdminGridStore','leavemanagement.administrativeleave.LeaveBalanceFlagEnumStore',
             'leavemanagement.LeavePeriodEnumStore','leavemanagement.administrativeleave.AdminLeaveTypeGridStore','common.AcademyLocationNameSeparated','leavemanagement.EligibilityEnumStore',
             'leavemanagement.LeaveTypeStore','leavemanagement.EmployeeAttributeStore', 'department.DepartmentStore','leavemanagement.EnumEmployeeAttributeStore','leavemanagement.EligibilityALGridStore','leavemanagement.ApplyToSelectedALGridStore'],
             
    views: ['leavemanagement.administrativeleave.LeaveAdministrativeSettingStructure','leavemanagement.administrativeleave.AdministrativeSettingFilter','leavemanagement.administrativeleave.AdminApplyToGrid',
            'leavemanagement.administrativeleave.AdminSettingForm','leavemanagement.administrativeleave.AdminSettingsGrid','leavemanagement.administrativeleave.AddAdminSettingView',
            'leavemanagement.administrativeleave.ApplyToAdminGridView','leavemanagement.administrativeleave.AdminApplyToForm','leavemanagement.administrativeleave.AdminApplyToSaveForm'
            ,'leavemanagement.AdminstrativeMappedAlWindow'],
            
    
            
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref: 'leaveadministrativesettingstructure',
        selector: 'leaveadministrativesettingstructure'
    },{
    	ref: 'administrativesettingfilter',
        selector: 'administrativesettingfilter'
    },{
    	ref: 'adminsettingform',
        selector: 'adminsettingform'
    },{
    	ref: 'adminsettingsgrid',
        selector: 'adminsettingsgrid'
    },{
    	ref: 'addadminsettingview',
        selector: 'addadminsettingview'
    },{
    	ref: 'adminapplytogrid',
        selector: 'adminapplytogrid'
    },{
    	ref: 'adminapplytosaveform',
        selector: 'adminapplytosaveform'
    },{
    	ref: 'adminapplytoform',
        selector: 'adminapplytoform'
    },{
    	ref: 'adminstrativemappedalwindow',
        selector: 'adminstrativemappedalwindow'
    },{
    	ref: 'applytoadmingridview',
        selector: 'applytoadmingridview'
    }],
    config: {
    	FACULTY_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNASSIGNEDREQUEST_PRIVILEGES'),
    	FACULTY_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	FACULTYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTYDASHBOARD_PRIVILEGES')
    },
    init: function(application) {
        this.control({
       	 'adminsettingform button#quickSearchId':{
			   click: function(obj, record) {
				   this.searchDataList();
			   }
		   },
		   
		  'adminsettingform button#resetBtn':{
			   click: function(obj, record) {
				 this.getAdminsettingform().getForm().reset();
			   }
		   },
		   
		  'adminsettingsgrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddAdminSettingTab();
			   }
		   },
		   
		   'addadminsettingview button[itemId=saveBtn]':{
			   click : function(obj){
				    var $this = this;
					var form = $this.getAddadminsettingview().getForm();
					var formValue = form.getValues();
					$this.saveAdminSetting(form, formValue);
					
 			   }
 		   },
 		  
		   'addadminsettingview button[itemId=resetBtn]':{
			   click : function(obj){
				    var $this = this;
					var form = $this.getAddadminsettingview().getForm();
					form.reset();
 			   }
 		   },
 		   
 		  'addadminsettingview radiogroup[itemId=limitLeavesToBalanceId]':{
 			   change : function(value,newValue,oldValue){
 				    var $this = this;
					var form = $this.getAddadminsettingview().getForm();
					var leaveBalance = form.findField('leaveBalance');
					
					var balanceAfterEncahsment = form.findField('balanceAfterEncahsment'); 
					var maxLeaveBalance =form.findField('maxLeaveBalance'); 
					var encashExcessLeave =form.findField('encashExcessLeave'); 
					var maxCarryFrwdDays =form.findField('maxCarryFrwdDays');
					var minDaysToEncash =form.findField('minDaysToEncash'); 
					var limitLeavesToBalance =form.findField('limitLeavesToBalance'); 
					var minDaysToEncahsment =form.findField('minDaysToEncahsment'); 
					minDaysToEncahsment.setDisabled(false);
					limitLeavesToBalance.setDisabled(false);
					minDaysToEncash.setDisabled(false);
					maxCarryFrwdDays.setDisabled(false);
					encashExcessLeave.setDisabled(false);
					maxLeaveBalance.setDisabled(false);
					balanceAfterEncahsment.setDisabled(false);
					
					balanceAfterEncahsment.allowBlank=false;
					maxLeaveBalance.allowBlank=false;
					maxCarryFrwdDays.allowBlank=false;
					minDaysToEncash.allowBlank=false;
					minDaysToEncahsment.allowBlank=false;
					
					if(leaveBalance.getValue()=="ENCASH"){
						maxLeaveBalance.setDisabled(true);
						maxLeaveBalance.reset();
						maxLeaveBalance.allowBlank=true;
						encashExcessLeave.setDisabled(true);
						if(newValue.isLimitLeavesToBalance!=true){
							maxCarryFrwdDays.setDisabled(true);
							maxCarryFrwdDays.reset();
							maxCarryFrwdDays.allowBlank=true;
							minDaysToEncash.setDisabled(true);
							minDaysToEncash.reset();
							minDaysToEncash.allowBlank=true;
						}
					}
					if(leaveBalance.getValue()=="CARRYFORWARD"){
						minDaysToEncahsment.setDisabled(true);
						minDaysToEncahsment.reset();
						minDaysToEncash.setDisabled(true);
						balanceAfterEncahsment.setDisabled(true);
						minDaysToEncahsment.allowBlank=true;
						minDaysToEncash.allowBlank=true;
						minDaysToEncash.reset();
						balanceAfterEncahsment.allowBlank=true;
						balanceAfterEncahsment.reset();
						if(newValue.isLimitLeavesToBalance!=true){
							maxCarryFrwdDays.setDisabled(true);;
							maxCarryFrwdDays.allowBlank=true;
							maxCarryFrwdDays.reset();
						}
					}
					if(leaveBalance.getValue()=="LAPSE"){
						minDaysToEncahsment.setDisabled(true);
						limitLeavesToBalance.setDisabled(true);
						minDaysToEncash.setDisabled(true);
						maxCarryFrwdDays.setDisabled(true);
						encashExcessLeave.setDisabled(true);
						maxLeaveBalance.setDisabled(true);
						balanceAfterEncahsment.setDisabled(true);
						
						balanceAfterEncahsment.allowBlank=true;
						maxLeaveBalance.allowBlank=true;
						maxCarryFrwdDays.allowBlank=true;
						minDaysToEncash.allowBlank=true;
						minDaysToEncahsment.allowBlank=true;
						
						balanceAfterEncahsment.reset();
						maxLeaveBalance.reset();
						maxCarryFrwdDays.reset();
						minDaysToEncash.reset();
						minDaysToEncahsment.reset();
					}
					form.isValid();
 			   }
 		   },
 		   
 		   'addadminsettingview customcombobox[itemId=leaveBalanceItemId]' : {
			   change:function(obj, rec){
				    var $this = this;
					var form = $this.getAddadminsettingview().getForm();
					var isLimitLeavesToBalance = form.getValues().isLimitLeavesToBalance;
					var balanceAfterEncahsment = form.findField('balanceAfterEncahsment'); 
					var maxLeaveBalance =form.findField('maxLeaveBalance'); 
					var encashExcessLeave =form.findField('encashExcessLeave'); 
					var maxCarryFrwdDays =form.findField('maxCarryFrwdDays');
					var minDaysToEncash =form.findField('minDaysToEncash'); 
					var limitLeavesToBalance =form.findField('limitLeavesToBalance'); 
					var minDaysToEncahsment =form.findField('minDaysToEncahsment'); 
					minDaysToEncahsment.setDisabled(false);
					limitLeavesToBalance.setDisabled(false);
					minDaysToEncash.setDisabled(false);
					maxCarryFrwdDays.setDisabled(false);
					encashExcessLeave.setDisabled(false);
					maxLeaveBalance.setDisabled(false);
					balanceAfterEncahsment.setDisabled(false);
					
					balanceAfterEncahsment.allowBlank=false;
					maxLeaveBalance.allowBlank=false;
					maxCarryFrwdDays.allowBlank=false;
					minDaysToEncash.allowBlank=false;
					minDaysToEncahsment.allowBlank=false;
					
					if(rec == "ENCASH"){
						maxLeaveBalance.setDisabled(true);
						maxLeaveBalance.reset();
						maxLeaveBalance.allowBlank=true;
						encashExcessLeave.setDisabled(true);
						if(!isLimitLeavesToBalance){
							maxCarryFrwdDays.setDisabled(true);
							maxCarryFrwdDays.reset();
							maxCarryFrwdDays.allowBlank=true;
							minDaysToEncash.setDisabled(true);
							minDaysToEncash.reset();
							minDaysToEncash.allowBlank=true;
						}
					}
					if(rec == "CARRYFORWARD"){
						minDaysToEncahsment.setDisabled(true);
						minDaysToEncahsment.reset();
						minDaysToEncash.setDisabled(true);
						balanceAfterEncahsment.setDisabled(true);
						minDaysToEncahsment.allowBlank=true;
						minDaysToEncash.allowBlank=true;
						minDaysToEncash.reset();
						balanceAfterEncahsment.allowBlank=true;
						balanceAfterEncahsment.reset();
						if(!isLimitLeavesToBalance){
							maxCarryFrwdDays.setDisabled(true);
							maxCarryFrwdDays.allowBlank=true;
							maxCarryFrwdDays.reset();
						}
					}
					if(rec == "LAPSE"){
						minDaysToEncahsment.setDisabled(true);
						limitLeavesToBalance.setDisabled(true);
						minDaysToEncash.setDisabled(true);
						maxCarryFrwdDays.setDisabled(true);
						encashExcessLeave.setDisabled(true);
						maxLeaveBalance.setDisabled(true);
						balanceAfterEncahsment.setDisabled(true);
						
						balanceAfterEncahsment.allowBlank=true;
						maxLeaveBalance.allowBlank=true;
						maxCarryFrwdDays.allowBlank=true;
						minDaysToEncash.allowBlank=true;
						minDaysToEncahsment.allowBlank=true;
						
						balanceAfterEncahsment.reset();
						maxLeaveBalance.reset();
						maxCarryFrwdDays.reset();
						minDaysToEncash.reset();
						minDaysToEncahsment.reset();
					}
					form.isValid();
 			   }
 		   },
		   
		  'adminsettingsgrid button#btnEdit':{
			   click: function(obj, record) {
				   this.editAdminSettingTab();
			   }
		   },
		   
		  'adminsettingsgrid button#btnApplyToItemId':{
			   click: function(obj, record) {
				   var $this=this;
				   var grid = $this.getAdminsettingsgrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openApplyToAdminView();
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'adminapplytogrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddApplyToAdmin();
			   }
		   },
		   
		   'adminapplytogrid button#btnEdit':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getAdminapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openAddApplyToAdmin();
					   $this.editApplyToAdminidtrationSetting();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'adminapplytogrid button#btnDelete':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getAdminapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.deleteAdminFunction();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'adminapplytogrid ': {
	            cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	          	 var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	          	 if (e.target.tagName == 'A') {
	          		 this.openAdministrationSettingDetailsWindow(columnName, record, ColIdx);
	          	 }
				},
				render:function(object) {
					var $this = this;
					var grid = object;
					var leaveSettingsgrid = $this.getAdminsettingsgrid();
					var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
					grid.getStore().getProxy().extraParams={
						id:record.data.id
					};
					grid.getStore().load();
				}
			  }, 

			  'adminstrativemappedalwindow grid[itemId=attributeGrid] button[itemId=btnDelete]':{
				  click : function(obj){
					  this.deleteAdministrativeLeaveAttributeValues();
				  }
			  },
		   
		   'adminapplytosaveform multiselectcombofield[itemId=multiselectAcademyLocationId]' : {
			   render:function(obj,rec){
				   var store = obj.getStore();
				   store.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   var allAl =[];
							   for(var i in records){
								   allAl.push(records[i].get("id"));
							   }
							   obj.setValue(allAl);
						   }
					   }
				   });

			   }
		   },
		   
		   'adminapplytosaveform customcombobox[itemId=EligibilityEnumItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAdminapplytosaveform().getForm();
				   var multiLeaveType = form.findField("HRLeaveType");
				   var leaveType = form.findField("LeaveType");
				   var empAttributeType =  form.findField("empAttributeType");
				   var empAttributeValue =  form.findField("empAttributeValue");
				   var enumEmpAttributeValue =  form.findField("enumEmpAttributeValue");
				   var store = $this.getStore('leavemanagement.LeaveTypeStore');
				   store.getProxy().extraParams={
					   eligibilityCriteria:rec[0].data.id,
				   };
				   store.load();
				   if(rec[0].data.id != "EMPLOYEEATTRIBUTEBASED"){
					   multiLeaveType.setVisible(true);
					   leaveType.setVisible(false);
					   empAttributeType.setVisible(false);
					   multiLeaveType.allowBlank=false;
					   leaveType.allowBlank=true;
					   empAttributeType.allowBlank=true;
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.allowBlank=true;
				   } else {
					   multiLeaveType.setVisible(false);
					   multiLeaveType.allowBlank=true;
					   leaveType.setVisible(true);
					   empAttributeType.setVisible(true);
					   leaveType.allowBlank=false;
					   empAttributeType.allowBlank=false;
					   empAttributeValue.allowBlank=false;
					   enumEmpAttributeValue.allowBlank=false;
				   }
				   empAttributeType.reset();
				   leaveType.reset();
				   multiLeaveType.reset();
				   form.isValid();
				   empAttributeValue.setVisible(false);
				   enumEmpAttributeValue.setVisible(false);
				   empAttributeValue.reset();
				   enumEmpAttributeValue.reset();
			   }
		   },
		   
		   'adminapplytosaveform customcombobox[itemId=empAttributeTypeItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAdminapplytosaveform().getForm();
				   var empAttributeValue = form.findField("empAttributeValue");
				   var enumEmpAttributeValue = form.findField("enumEmpAttributeValue");
				   if(rec[0].data.type=="ENUM"){
					   empAttributeValue.reset();
					   empAttributeValue.setVisible(false);
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.setVisible(true);
					   enumEmpAttributeValue.reset();
					   enumEmpAttributeValue.allowBlank=false;
					   if(rec[0].data.value=="GENDER"){
						   enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
						   enumEmpAttributeValue.getStore().load();
					   }
				   } else {
					   if(rec[0].data.value=="department"){
						   empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
						   empAttributeValue.getStore().load();
					   }
					   empAttributeValue.setVisible(true);
					   empAttributeValue.reset();
					   empAttributeValue.allowBlank=false;
					   enumEmpAttributeValue.reset();
					   enumEmpAttributeValue.setVisible(false);
					   enumEmpAttributeValue.allowBlank=true;
				   }
				   
			   }
		   },
		   
		   'adminapplytosaveform button#saveBtn':{
			   click: function(obj, record) {
				   this.saveApplyToAdminstration();
			   }
		   },
		   'adminapplytosaveform button#cancelBtn':{
			   click: function(obj, record) {
				   var $this = this;
				   $this.getAdminapplytoform().close();
			   }
		   },
		   'adminapplytosaveform':{
			   beforerender: function(obj, record) {
				   var form = obj.down('form');
				   form.down('#saveBtn').setText('Save');
			   }
		   }
        });
    },
    
    deleteAdministrativeLeaveAttributeValues:function(){
    	var $this=this;
    	var winGrid = $this.getAdminstrativemappedalwindow().down('#attributeGrid');
    	if (winGrid.getSelectionModel().getCount() > 0) {
    		if(winGrid.store.data.items.length==1){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ATTRIBUTE_REQUIRED'));
    			return;
    		}
    		var records = winGrid.getSelectionModel().getSelection()[0];
    		var grid = $this.getAdminapplytogrid();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var attributeValue = record.data.hrEmployeeAttributeMasterId==1?records.data.value:records.data.id;
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_DELETE_ADMINISTRATION_LEAVE_TYPE_ATTRIBUTE+ "?eligibilityCtiteria="+record.data.eligibilityCtiteria
    					+"&hrEmployeeAttributeMasterId="+record.data.hrEmployeeAttributeMasterId+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId
    					+"&attributeValue=" +attributeValue,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params : {
    						id : record.data.hrEligibilitySettingId,
    						eligibilityCtiteria:record.data.eligibilityCtiteria,
    						attributeName:record.data.employeeAttributeType
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('ADMINISTRATIVE_SETTING'),getCommonTranslation('SUCCESS'));
    						grid.getStore().reload();
    						grid.getSelectionModel().deselectAll();
    						$this.getAdminstrativemappedalwindow().close();
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },

    editApplyToAdminidtrationSetting:function(){
    	var $this = this;
    	var filter = $this.getAdminapplytosaveform();
    	var form = filter.getForm();
    	var grid = $this.getAdminapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var multiselectAcademyLocation = form.findField('multiselectAcademyLocation');
    	var EligibilityEnum = form.findField('EligibilityEnum');
    	var HRLeaveType = form.findField('HRLeaveType');
    	var LeaveType = form.findField('LeaveType');
    	var empAttributeType = form.findField('empAttributeType');
    	var empAttributeValue = form.findField('empAttributeValue');
    	var enumEmpAttributeValue = form.findField('enumEmpAttributeValue');
    	
    	multiselectAcademyLocation.getStore().load({
    		callback:function(rec){
    			var arr=[];
    			for(var i in rec){
    				for(var j in record.data.academyLocationIdName){
    					if(rec[i].data.value==record.data.academyLocationIdName[j]){
        					arr.push(rec[i].data.id);
        				}
    				}
    			}
    			multiselectAcademyLocation.setValue(arr);
    		}
    	});
    	EligibilityEnum.getStore().load({
			callback:function(rec){
				for(var i in rec){
					if(rec[i].data.id==record.data.eligibilityCtiteria){
						EligibilityEnum.setValue(rec[i].data.id);
					}
				}
			}
		});
    	if(record.data.eligibilityCtiteria == "EMPLOYEEATTRIBUTEBASED"){
    		HRLeaveType.setVisible(false);;
    		HRLeaveType.allowBlank=true;
    		LeaveType.setVisible(true);;
    		LeaveType.allowBlank=false;
    		LeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'EMPLOYEEATTRIBUTEBASED'
    		};
    		LeaveType.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						LeaveType.setValue(rec[i].data.id);
    					}
    				}
    			}
    		});
    		 empAttributeType.setVisible(true);;
			 empAttributeType.allowBlank=false;
			 empAttributeType.getStore().load({
				 callback:function(rec){
					 if(record.data.employeeAttributeType=='Gender'){
						 empAttributeType.setValue(rec[0].data.id); 
					 } else {
						 empAttributeType.setValue(rec[1].data.id); 
					 }
				 }
			 });
    		if(record.data.employeeAttributeType=='Gender'){
    			  empAttributeValue.setVisible(false);;
    			  empAttributeValue.allowBlank=true;
    			  enumEmpAttributeValue.setVisible(true);;
    			  enumEmpAttributeValue.allowBlank=false;
    			  enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
    			  enumEmpAttributeValue.getStore().load({
    				  callback:function(rec){
    					  var arr=[];
    					  for(var i in rec){
    						  for(var j in record.data.employeeAttributeValues){
    							  if(rec[i].data.id==record.data.employeeAttributeValues[j]){
    								  arr.push(rec[i].data.id);
    							  }
    						  }
    					  }
    					  enumEmpAttributeValue.setValue(arr);
    				  }
    			  });
    		} else {
    			enumEmpAttributeValue.setVisible(false);;
    			enumEmpAttributeValue.allowBlank=true;
    			empAttributeValue.setVisible(true);;
    			empAttributeValue.allowBlank=false;
    			empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
    			empAttributeValue.getStore().load({
    				callback:function(rec){
    					var arr=[];
    					for(var i in rec){
    						for(var j in record.data.employeeAttributeValues){
    							if(rec[i].data.name==record.data.employeeAttributeValues[j]){
        							arr.push(rec[i].data.id);
        						}
    						}
    					}
    					empAttributeValue.setValue(arr);
    				}
    			});
    		}
    	} else {
    		empAttributeValue.setVisible(false);;
    		empAttributeValue.allowBlank=true;
    		enumEmpAttributeValue.setVisible(false);;
    		enumEmpAttributeValue.allowBlank=true;
    		empAttributeType.setVisible(false);;
    		empAttributeType.allowBlank=true;
    		LeaveType.setVisible(false);;
    		LeaveType.allowBlank=true;
    		HRLeaveType.setVisible(true);;
    		HRLeaveType.allowBlank=false;
    		HRLeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'GENERIC'
    		};
    		HRLeaveType.getStore().load({
    			callback:function(rec){
    				var arr=[];
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						arr.push(rec[i].data.id);
    					}
    				}
    				HRLeaveType.setValue(arr);
    			}
    		});
    	}
    	form.isValid();
    	filter.down('#saveBtn').setText('&nbspSave&nbsp');
    },
    
    deleteAdminFunction:function(){
    	
    	var $this=this;
    	var grid = $this.getAdminapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var attributeName = !isNullOrEmpty(record.data.employeeAttributeType)?record.data.employeeAttributeType:'';
    	showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    		function(btn, text) {
				if (btn == 'yes') {
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "DELETE",
						type : 'rest',
						url : SERVERURL.ADMIN_LEAVE_TYPE_DELETE+ '?id='+ record.data.hrAdministrationSettingId+"&eligibilityCtiteria="+record.data.eligibilityCtiteria
						+"&attributeName="+attributeName+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId,
						headers : {
							'Content-Type' : 'application/json'
						},
						params : {
							id : record.data.hrEligibilitySettingId,
							eligibilityCtiteria:record.data.eligibilityCtiteria,
							attributeName:record.data.employeeAttributeType
						},
						success : function(form,action) {
							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('ADMINISTRATIVE_SETTING'),getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
						}
					});
				}
    	});
    },
    
    openAdministrationSettingDetailsWindow:function(title, record, ColIdx){
    	var $this = this;
		var formWindow = this.getAdminstrativemappedalwindow();
 	    if (!formWindow) {
 		   Ext.widget('adminstrativemappedalwindow');
 		   formWindow = this.getAdminstrativemappedalwindow();
 	    }
	    formWindow.show();
	    var gridAl = formWindow.down('#alGridItemId');
	    var gridAttr = formWindow.down('#attributeGrid');
	    gridAttr.hide();
	    gridAl.hide();
	    if(ColIdx==3){
	    	gridAttr.show();
	    	formWindow.setTitle(getCommonTranslation('ATTRIBUTE_VALUE'));
			var gridStore =  gridAttr.getStore();
			gridStore.removeAll();
			var details;
			if(record.data.employeeAttributeValues.length != 0){
				for(var i in record.data.employeeAttributeValues){
					if(!isNullOrEmpty(record.data.employeeAttributeLongValues)){
						details={
								'id':record.data.employeeAttributeLongValues[i],
								'value':record.data.employeeAttributeValues[i]
						};
					} else {
						details={
								'value':record.data.employeeAttributeValues[i]
						};
					}
					gridStore.loadRawData(details, true);
				}
			}
	    } else{
	    	gridAl.show();
	    	formWindow.setTitle(getCommonTranslation('ACADEMY_LOCATION'));
			var gridStore =  gridAl.getStore();
			gridStore.removeAll();
			var details;
			if(record.data.academyLocationIdName.length != 0){
				for(var i in record.data.academyLocationIdName){
					details={
							'value':record.data.academyLocationIdName[i],
					};
					gridStore.loadRawData(details, true);
				}
			}
	    }
    },

    searchDataList:function(){
    	var $this = this;
    	var formValue = $this.getAdminsettingform().getForm().getValues();
    	var grid = $this.getAdminsettingsgrid();
    	grid.getStore().getProxy().extraParams={
    		id:formValue.aminCode
    	};
    	grid.getStore().load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getAdminsettingform();
    },
    
    openAddAdminSettingTab:function(){
    	var $this = this;
		var contentPanel = $this.getLeaveadministrativesettingstructure();
			var newTab = contentPanel.items.findBy(function(tab) {
				return tab.title === getCommonTranslation('ADD_ADMINISTRATIVE_SETTING');
			});
			if (!newTab) {
				contentPanel.add({
					title: getCommonTranslation('ADD_ADMINISTRATIVE_SETTING'),
					closable : true,
					autoScroll:true,
					xtype : 'addadminsettingview',
				}).show();
			}
			contentPanel.setActiveTab(newTab);
			contentPanel.doLayout();
    },
	
	saveAdminSetting:function(form, formValue){
    	var $this = this;
    	var filter = $this.getAddadminsettingview();
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var grid = $this.getAdminsettingsgrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var id=null, submitUrl;
    	if(filter.down("#saveBtn").getText()==" Save "){
    		submitUrl = SERVERURL.PATH_UPDATE_ADMIN_SETTING
    		id=record.data.id;
    	} else {
    		submitUrl = SERVERURL.PATH_SAVE_ADMIN_SETTING
    	}
    	if(formValue.leaveBalance=="LAPSE"){
    		var submitValue={
        			'id':id,
        			'administrationCode':formValue.adminCode,
        			'leaveBalanceFlag':formValue.leaveBalance,
        			'leaveBalanceUpdatePeriod':formValue.leaveBalanceUpdatePeriod
        	};
    	} else {
    		var submitValue={
        			'id':id,
        			'administrationCode':formValue.adminCode,
        			'leaveBalanceFlag':formValue.leaveBalance,
        			'leaveBalanceUpdatePeriod':formValue.leaveBalanceUpdatePeriod,
        			'isLimitLeavesToBalance':formValue.isLimitLeavesToBalance,
        			'maxLeavesCarryForward':formValue.maxCarryFrwdDays,
        			'maxLeaveBalance':formValue.maxLeaveBalance,
        			'isEncashExcessLeaves':formValue.isEncashExcessLeave,
        			'minDaysToEncash':formValue.minDaysToEncash,
        			'minBalanceForEncashment':formValue.minDaysToEncahsment,
        			'balanceAfterEncashment':formValue.balanceAfterEncahsment
        	};
    	}
    	
    	Ext.Ajax.request({
    		method : "GET",
    		type : 'rest',
    		url : SERVERURL.PATH_ADMIN_SETTING_CODE_EXISTS,
    		params:{
    			id:id,
    			code:formValue.adminCode
    		},
    		success : function(response, action) {
    			var resp = Ext.decode(response.responseText);
    			if(resp){
    				Ext.getBody().unmask();
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LEAVE_CODE_EXISTS_MSG'));
    			}
    			else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : submitValue,
    					method : 'POST',
    					success : function(form, action) {
    						 Ext.getBody().unmask();
    						 showSuccessMessage(getCommonTranslation('ADD_ADMINISTRATIVE_SETTING'),getCommonTranslation('SUCCESS'));
    						 grid.getStore().reload();
    						 grid.getSelectionModel().deselectAll();
    						 var tabName = getCommonTranslation('ADD_ADMINISTRATIVE_SETTING');
    						 var leaveSetting  = $this.getLeaveadministrativesettingstructure();
    						 var tabs = leaveSetting.items.items;
    						 for(var i in tabs){
    							 if(tabs[i].title===tabName){
    								 leaveSetting.remove( tabs[i],true);
    							 }
    						 }
    					}
    				});
    			}
    		}
    	});
	},
	
	editAdminSettingTab:function(){
    	var $this = this;
    	var grid = $this.getAdminsettingsgrid();
    	if(grid.getSelectionModel().getCount()>0){
    		$this.openAddAdminSettingTab();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var filter = $this.getAddadminsettingview();
    		var form = filter.getForm();
    		var adminCode = form.findField('adminCode');
    		var leaveBalance = form.findField('leaveBalance');
    		var leaveBalanceUpdatePeriod = form.findField('leaveBalanceUpdatePeriod');
    		var maxCarryFrwdDays = form.findField('maxCarryFrwdDays');
    		var maxLeaveBalance = form.findField('maxLeaveBalance');
    		var minDaysToEncash = form.findField('minDaysToEncash');
    		var minDaysToEncahsment = form.findField('minDaysToEncahsment');
    		var balanceAfterEncahsment = form.findField('balanceAfterEncahsment');
    		var limitLeavesToBalanceId = filter.down('#limitLeavesToBalanceId');
    		var encashExcessLeaveId = filter.down('#encashExcessLeaveId');
    		var saveBtn = filter.down('#saveBtn');
    		
    		adminCode.setValue(record.data.administrationCode);
    		leaveBalance.setValue(record.data.maxLeaveBalance);
    		maxCarryFrwdDays.setValue(record.data.maxLeavesCarryForward);
    		maxLeaveBalance.setValue(record.data.maxLeaveBalance);
    		minDaysToEncash.setValue(record.data.minDaysToEncash);
    		minDaysToEncahsment.setValue(record.data.minBalanceForEncashment);
    		balanceAfterEncahsment.setValue(record.data.balanceAfterEncashment);
    		
    		if(record.data.isEncashExcessLeaves){
    			encashExcessLeaveId.items.items[0].setValue(true);
    			encashExcessLeaveId.items.items[1].setValue(false);
    		}
    		if(record.data.isLimitLeavesToBalance){
    			limitLeavesToBalanceId.items.items[0].setValue(true);
    			limitLeavesToBalanceId.items.items[1].setValue(false);
    		}
    		
    		if(record.data.leaveBalanceFlag!='ENCASH'){
    			balanceAfterEncahsment.setVisible(false);
    			balanceAfterEncahsment.reset();
    			balanceAfterEncahsment.allowBlank=true;
    		}
    		
    		leaveBalance.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id == record.data.leaveBalanceFlag){
    						leaveBalance.setValue(rec[i].data.id );
    						break;
    					}
    				}
    			}
    		});
    		
    		leaveBalanceUpdatePeriod.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id == record.data.leaveBalanceUpdatePeriod){
    						leaveBalanceUpdatePeriod.setValue(rec[i].data.id );
    						break;
    					}
    				}
    			}
    		});
    		saveBtn.setText(" Save ");
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
	},
	
	openApplyToAdminView:function(){
    	var $this = this;
		var contentPanel = $this.getLeaveadministrativesettingstructure();
		var newTab = contentPanel.items.findBy(function(tab) {
			return tab.title === getCommonTranslation('ADMIN_SETTINGS_APPLY_TO');
		});
		if (!newTab) {
			contentPanel.add({
				title: getCommonTranslation('ADMIN_SETTINGS_APPLY_TO'),
				closable : true,
				autoScroll:false,
				xtype : 'applytoadmingridview',
			}).show();
		}
		contentPanel.setActiveTab(newTab);
		contentPanel.doLayout();
    },
    
    openAddApplyToAdmin:function(){
    	var $this = this;
		var formWindow = $this.getAdminapplytoform();
 	    if (!formWindow) {
 		   Ext.widget('adminapplytoform');
 		   formWindow = $this.getAdminapplytoform();
 	    }
 	   formWindow.show();
    },
    
    saveApplyToAdminstration:function(){
    	var $this=this;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var contentpanel = this.getContentPanel();
    	var filter = $this.getAdminapplytosaveform();
    	var form = filter.getForm();
    	var fromValue = form.getValues();
    	var grid = $this.getAdminapplytogrid();
    	var leaveSettingsgrid = $this.getAdminsettingsgrid();
    	var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
    	var empAttributeType;
    	if(!isNullOrEmpty(form.findField("empAttributeType").valueModels) && form.findField("empAttributeType").valueModels.length!=0){
    		empAttributeType=form.findField("empAttributeType").valueModels[0].data.type;
    	}
    	var submitValue =[], alIds=[];
    	var id;
    	var submitUrl;
    	if(filter.down('#saveBtn').getText()=='&nbspSave&nbsp'){
    		id = grid.getSelectionModel().getSelection()[0].data.id;
    	}
    	submitUrl = SERVERURL.ADMIN_LEAVE_TYPE_UPDATE;
    	for(var i in fromValue.multiselectAcademyLocation){
    		if(fromValue.multiselectAcademyLocation[i].data == undefined){
    			alIds.push(fromValue.multiselectAcademyLocation[i]);
    		} else {
    			alIds.push(fromValue.multiselectAcademyLocation[i].data.id);
    		}
    	}	
    	
    	if(fromValue.EligibilityEnum=="EMPLOYEEATTRIBUTEBASED"){
    		var enumEmpAttribute;
    		if(empAttributeType=='ENUM'){
    			for (var i in fromValue.enumEmpAttributeValue){
    				if(fromValue.enumEmpAttributeValue[i].data == undefined){
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i];
            		} else {
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i].data.id;
            		}
    				var data={
    						'id':id,
        	    			'hrAdministrationSettingId':record.data.id,
        	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
        	    			'hrLeaveTypeId':fromValue.LeaveType,
        	    			'employeeAttributeType':empAttributeType,
        	    			'employeeAttributeValue':enumEmpAttribute,
        	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
        	    			'academyLocationIds':alIds
        	    	};
    				submitValue.push(data);
    			}
        	} else {
        		for (var i in fromValue.empAttributeValue){
        			var empAttributeValue;
        			if(fromValue.empAttributeValue[i].data == undefined){
        				empAttributeValue=fromValue.empAttributeValue[i];
            		} else {
            			empAttributeValue=fromValue.empAttributeValue[i].data.id;
            		}
        			var data={
        					'id':id,
        	    			'hrAdministrationSettingId':record.data.id,
        	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
        	    			'hrLeaveTypeId':fromValue.LeaveType,
        	    			'employeeAttributeType':empAttributeType,
        	    			'employeeAttributeValue':empAttributeValue,
        	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
        	    			'academyLocationIds':alIds
        	    	};
        			submitValue.push(data);
        		}
        	}
    	} else {
    		for (var i in fromValue.HRLeaveType){
    			var leaveTp;
    			if(fromValue.HRLeaveType[i].data == undefined){
    				leaveTp=fromValue.HRLeaveType[i];
        		} else {
        			leaveTp=fromValue.HRLeaveType[i].data.id;
        		}
    			var data={
    					'id':id,
    					'hrAdministrationSettingId':record.data.id,
    	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
    	    			'hrLeaveTypeId':leaveTp,
    	    			'academyLocationIds':alIds
    	    	};
    			submitValue.push(data);
    		}
    	}
    	 Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : submitValue,
				method : 'POST',
				success : function(form, action) {
					 Ext.getBody().unmask();
					 showSuccessMessage(getCommonTranslation('ADMIN_SETTINGS_APPLY_TO'),getCommonTranslation('SUCCESS'));
					 grid.getStore().reload();
					 grid.getSelectionModel().deselectAll();
					 var formWindow = $this.getAdminapplytoform();
				 	    if (!formWindow) {
				 		   Ext.widget('adminapplytoform');
				 		   formWindow = $this.getAdminapplytoform();
				 	    }
				 	   formWindow.close();
				}
			});
    }
});
