/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.controller.manageMarksModeration.ManageMarksModerationController', {
    extend: 'Academia.controller.base.BaseController',
    models: [],
    stores: ['examinationcenters.evaluation.CourseByAcademyLocationStore','manageMarksModeration.EvalListLevelTypeStore','manageMarksModeration.ManageMarksModerationCourseStore',
        'examinationcenters.assessmentEvent.EvaluationPlanForEventStore', 'attendance.VariantMappedToSpecialGrade',
        'examinationcenters.reports.CriteriaBasedProgramStore', 'manageMarksModeration.ManageMarksModerationGridStore',
        'examinationcenters.reports.SpecialGradeBatchStore', 'examinationcenters.reports.SpecialGradePeriodStore',
        'examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId','manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore',
        'manageMarksModeration.MarksModerationCourseVariantStore', 'manageMarksModeration.MarksModerationProgramStore',
        'importutility.ModuleName', 'manageMarksModeration.ImportUtilityMarkModerationGridStore',
        'examinationcenters.calculateAverage.calculateAverageYearly.StudentStore',
        'manageMarksModeration.ProgramModerationGridStore',
        'manageMarksModeration.ProgramLevelModerationProgramStore',
        'manageMarksModeration.ProgramLevelModerationBatchStore',
        'manageMarksModeration.ProgramLevelModerationPeriodStore',
        'manageMarksModeration.ProgramLevelModerationPlanStore',
        'manageMarksModeration.ProgramLevelModerationCourseStore',
        'manageMarksModeration.ProgramLevelModerationVariantStore',
        'manageMarksModeration.ProgramLevelModerationStudentStore'
    ],
    views: ['manageMarksModeration.ManageMarksModerationStructure', 'manageMarksModeration.ManageMarksModerationFilter',
        'manageMarksModeration.ManageMarksModerationGrid', 'manageMarksModeration.ManageMarksModerationwin',
        'manageMarksModeration.ImportMarksModerationStructure', 'manageMarksModeration.DownloadMarksModerationForm',
        'manageMarksModeration.UploadMarksModerationForm', 'manageMarksModeration.ImportUtilityMarkModeration',
        'manageMarksModeration.ProgramLevelMarksModerationStructure',
        'manageMarksModeration.ProgramLevelMarksModerationFilter', 
        'manageMarksModeration.ProgramManageMarksModerationGrid','manageMarksModeration.ProgramManageMarksModerationwin'  
    ],
    config: {
        MANAGE_MARKS_MODERATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_MARKS_MODERATION_PRIVILEGES'),
        PROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES')
    },
    refs: [{
    	ref: 'managemarksmoderationstructure',
    	selector: 'managemarksmoderationstructure'
    }, {
    	ref: 'managemarksmoderationfilter',
    	selector: 'managemarksmoderationfilter'
    }, {
    	ref: 'managemarksmoderationgrid',
    	selector: 'managemarksmoderationgrid'
    }, {
    	ref: 'managemarksmoderationwin',
    	selector: 'managemarksmoderationwin'
    }, {
    	ref: 'importMarksModerationStructure',
    	selector: 'importMarksModerationStructure'
    }, {
    	ref: 'downloadMarksModerationForm',
    	selector: 'downloadMarksModerationForm'
    }, {
    	ref: 'uploadMarksModerationForm',
    	selector: 'uploadMarksModerationForm'
    }, {
    	ref: 'importUtilityMarkModeration',
    	selector: 'importUtilityMarkModeration[itemId=importMarkModerationGridId]'
    }, {
    	ref: 'programLevelMarksModerationStructure',
    	selector: 'programLevelMarksModerationStructure'
    }, {
    	ref: 'programLevelMarksModerationFilter',
    	selector: 'programLevelMarksModerationFilter'
    }, {
    	ref: 'programmanagemarksmoderationgrid',
    	selector: 'programmanagemarksmoderationgrid'
    }, {
    	ref: 'programManageMarksModerationwin',
    	selector: 'programManageMarksModerationwin'
    }],
    init: function() {
        this.control({
            'managemarksmoderationgrid': {
                render: function(grid) {
                    if (grid.getStore().getCount() > 0) {
                        grid.getStore().removeAll();
                    }
                    grid.getStore().defaultStorePageSize=0;
		            grid.getStore().loadRawData([]);
                    this.doAccessControlValidation(grid,this.getMANAGE_MARKS_MODERATION_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getMANAGE_MARKS_MODERATION_PERMISSIONS());
                   },
                  selectionchange:function(view,record){
                	 var grid = this.getManagemarksmoderationgrid();
                	 var saveBtn =grid.down('#saveMarks');
                	 var editMarks =grid.down('#editMarks');
                	 if(saveBtn.isVisible() || editMarks.isVisible() ){
                		 if(record.length> 0){
                			 saveBtn.enable();
                			 editMarks.enable();
                		 }else{
                			 saveBtn.disable();
                			 editMarks.disable();
                		 }
                	 }
                  }
            },
            'programmanagemarksmoderationgrid': {
                render: function(grid) {
                    if (grid.getStore().getCount() > 0) {
                        grid.getStore().removeAll();
                    }
                    grid.getStore().defaultStorePageSize=0;
		            grid.getStore().loadRawData([]);
                    this.doAccessControlValidation(grid,this.getPROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES());    
                    this.disableMoreActionPivileges(grid,this.getPROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES());
                    this.getGridHeaderFreezeForProgLvlModeration(grid, grid.up('programLevelMarksModerationStructure'));
                   },
                  selectionchange:function(view,record){
                	 var grid = this.getProgrammanagemarksmoderationgrid();  
                	 var saveBtn =grid.down('#saveMarks');
                	 var editMarks =grid.down('#editMarks');
                	 if(saveBtn.isVisible() || editMarks.isVisible() ){
                		 if(record.length> 0){
                			 saveBtn.enable();
                			 editMarks.enable();
                		 }else{
                			 saveBtn.disable();
                			 editMarks.disable();
                		 }
                	 }
                  }
            },
            'managemarksmoderationfilter': {
                render: function(obj) {
                    var $this = this;
                    var form = obj.getForm();  
                    var als = [];
                    als.push($this.getCurrentAcademyLocation());
                    /**
                     * Load program by academy location
                     */
                    var programField = form.findField('programId');
                    var courseId = form.findField('courseId');
                    var evaluationplan = form.findField('evaluationplan');
                    var courseVariant = form.findField('courseVariant');
                    var evaluationLevelName = form.findField('evaluationLevelName');
                    programField.getStore().getProxy().extraParams = {
                        whetherMarksheet: true,
                        academyLocationIds: als.join()
                    }
                    programField.getStore().load();
                    courseId.getStore().getProxy().extraParams = {
                        academyLocationList: als.join()  
                    }
                    courseId.getStore().load();  
                }
            },

            'managemarksmoderationfilter customcombobox[itemId=courseItemId]': {
                select: function(obj, rec) {
                    var $this = this;
                    var data = rec[0].data.id;
                    var form = obj.up('form').getForm();
                    var als = [];
                    als.push($this.getCurrentAcademyLocation());
                    var evaluationplan = form.findField('evaluationplan');
                    var program = form.findField('programId');
                    var batch =form.findField('batchId')
                    var period=form.findField('periodId');
                    var courseVariant = form.findField('courseVariant');
                    var evaluationLevelName = form.findField('evaluationLevelName');
                    evaluationplan.reset();
                    evaluationplan.setDisabled(false);
                    evaluationplan.getStore().getProxy().extraParams = {
                        courseId: data,
                        completionStatus:true
                    };
                    evaluationplan.getStore().load({
                        callback: function(records, operation, success) {
                            if (success) {
                                courseVariant.reset();
                                courseVariant.setDisabled(false);
                                if (records.length == 1) {
                                	evaluationLevelName.enable();
                                	evaluationLevelName.reset();
                                	evaluationplan.setValue(records[0].data.id);
                                	evaluationLevelName.getStore().getProxy().extraParams = {
                                		evaluationPlanId: records[0].data.id,
                                		isStatus: false
                                	};
                                	evaluationLevelName.getStore().load();
                                	courseVariant.getStore().getProxy().extraParams = {
                                		courseId: data,
                                		academyLocationId: als.join()
                                	};
                                	courseVariant.getStore().load({
                                		callback: function(records, operation, success) {
                                			if (success) {
                                				if (records.length == 1) {
                                					courseVariant.setValue(records[0].data.id);
                                				}
                                			}
                                		}
                                	});
                                } else{
                                	evaluationLevelName.reset();
                                	evaluationLevelName.disable();
                                	courseVariant.reset();
                                	courseVariant.getStore().getProxy().extraParams = {
                                        courseId: data,
                                    };
                                    courseVariant.getStore().load();
                                }
                            }
                        }
                    });
                   
                    
                    program.reset();
                    program.getStore().getProxy().extraParams = {
                        courseId: data,
                        academyLocationIds: als.join()
                    };
                    
                    program.getStore().load();
					program.enable();  
                    batch.reset();
                    period.reset();
                    batch.disable();
                    period.disable();
                },
                keyup:function(obj){
                	var form = obj.up('form').getForm();
                	  //var evaluationplan = form.findField('evaluationplan');
                	  //evaluationplan.enable();
                	  form.checkValidity();
                },
				afterrender: function(cmp) {
					cmp.getStore().on('beforeload', function(store, operation) {
						store.lastOperation = operation;
					});
				}
            },


            'managemarksmoderationfilter customcombobox[itemId=programItemId]': {
                select: function(obj, record) {
                    var $this = this;
                    var form = obj.up('form').getForm();
                    var als = [];
                    als.push($this.getCurrentAcademyLocation());
                    var batchId = form.findField("batchId");
                    var period = form.findField("periodId");
                    batchId.reset();
                    batchId.setDisabled(false);
                    batchId.getStore().getProxy().extraParams = {
                        programId: record[0].data.id,
                        whetherMarksheet: true,
                        academyLocationIds: als.join()
                    }
                    batchId.getStore().load();
                    period.reset();
                    period.disable();
                }
            },

            'managemarksmoderationfilter customcombobox[itemId=batchItemId]': {
                select: function(obj, record) {
                    var $this = this;
                    var form = obj.up('form').getForm();
                    var als = [];
                    als.push($this.getCurrentAcademyLocation());
                    var period = form.findField("periodId");
                    period.reset();
                    period.setDisabled(false);
                    period.getStore().getProxy().extraParams = {
                        programId: form.findField("programId").getValue(),
                        batchId: record[0].data.id,
                        whetherMarksheet: true,
                        academyLocationIds: als.join()
                    }
                    period.getStore().load();
                }
            },
           
            'managemarksmoderationfilter customcombobox[itemId=evalautionPlanId]': {
                select: function(obj, record) {
                    var $this = this;
                    var data = record[0].data.id;
                    var form = obj.up('form').getForm();
                    var evaluationLevelName = form.findField('evaluationLevelName');
                    var courseVariant = form.findField('courseVariant');
                    var courseId = form.findField('courseId');
                    var als = [];
                    als.push($this.getCurrentAcademyLocation());
                    
                    evaluationLevelName.enable();
                    evaluationLevelName.reset();
                    evaluationLevelName.getStore().getProxy().extraParams = {
                        evaluationPlanId: data,
                        isStatus: false
                    }
                    evaluationLevelName.getStore().load();
                    courseVariant.reset();
                    courseVariant.getStore().getProxy().extraParams = {
                        courseId: courseId.getValue(),
                        evaluationPlanId:data,
                        academyLocationId: als.join()
                    };
                    courseVariant.getStore().load({
                        callback: function(records, operation, success) {
                            if (success) {
                                if (records.length == 1) {
                                	courseVariant.setValue(records[0].data.id);
                                } else{
                                	courseVariant.reset();
                                }
                            }
                        }
                    });
                }
            },
            'managemarksmoderationfilter  groupingcombobox[itemId=evaluationLevelNameId]':{
            	select:function(obj, record){
            		// var data = record[0].data.id;
                     var form = obj.up('form').getForm();
                    var searchBtn = obj.up('form').down('#searchBtn');
                      if(form.isValid()){
                    	  searchBtn.enable();
                      }else{
                    	  searchBtn.disable();
                      }
            	}
            },
            'managemarksmoderationfilter button[itemId=searchBtn]': {
                click: function(obj) {
                    this.loadManageMarksModerationFilterData();
                }
            },
            'managemarksmoderationfilter button[itemId=resetBtn]': {
                click: function(obj) {
                    var $this = this;
                    var filterForm = obj.up('form').getForm();
                    filterForm.reset();
                    var program = filterForm.findField('programId');
                    filterForm.findField('batchId').disable();
                    filterForm.findField('periodId').disable();
                    filterForm.findField('evaluationplan').disable();
                    filterForm.findField('courseVariant').disable();
                    filterForm.findField('courseVariant').reset();
                    var courseId = filterForm.findField('courseId');
                    
                    var evaluationLevelName = filterForm.findField('evaluationLevelName');
                    evaluationLevelName.disable();
                    program.reset();
                    var arr = [];
                    arr.push($this.getCurrentAcademyLocation());
                    program.disable(); // V2D-444887 , V2D-449945 
                    var courseStore = courseId.getStore();
                    try {
                    	if (courseStore.loading && courseStore.lastOperation) {
                    		var requests = Ext.Ajax.requests;
                    		for (id in requests) {
                    			if (requests.hasOwnProperty(id) && requests[id].options == courseStore.lastOperation.request) {
                    				Ext.Ajax.abort(requests[id]);
                    				courseStore.lastOperation = null;
                    				courseId.reset();
                    			}
                    		}
                    	}
                    }
                    catch(e) {
                    	courseId.reset();
                    }
        			courseStore.getProxy().extraParams = {
                        whetherMarksheet: true,
                        academyLocationIds: arr.join()
                    }
                    //courseId.getStore().load();
                }
            },

            'managemarksmoderationgrid button[itemId=applyChangesBtn]': {
                click: function(button) {
                    var $this = this;
                    var grid = $this.getManagemarksmoderationgrid();

                    if (grid.getSelectionModel().getCount() > 0) {
                        //var records = grid.getSelectionModel().getSelection()[0];
                        var formWindow = this.getManagemarksmoderationwin();
                        if (!formWindow) {
                            Ext.widget('managemarksmoderationwin');
                            formWindow = this.getManagemarksmoderationwin();
                        }
                        formWindow.show();
                        /*var noOfRecords = formWindow.down('#noOfRecords');
                        var moderationReason = formWindow.down('#moderationReason');
                        var moderationPoints = formWindow.down('#moderationPoints');
                        var minMarks = formWindow.down('#minMarks');
                        var maxMarks = formWindow.down('#maxMarks');
                        var moderationMarks = formWindow.down('#moderationMarks');
                        var effectiveMarks = formWindow.down('#effectiveMarks');
                        var effectedModerationPoints = formWindow.down('#effectedModerationPoints');
                        
                        
                        noOfRecords.setValue(grid.getSelectionModel().getCount());
                        minMarks.setValue(records.data.minMarks);
                        maxMarks.setValue(records.data.maxMarks);
                        moderationMarks.setValue(records.data.moderationPoints);
                        moderationReason.setValue(records.data.moderationReason);
                        moderationPoints.setValue(records.data.moderationPoints);
                        effectiveMarks.setValue(records.data.effectiveMarks);
                        effectedModerationPoints.setValue(records.data.effectedModerationPoints);*/
                        
                    } else {
                        showWarningMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
                    }
                }
            },
            
            
             'programmanagemarksmoderationgrid button[itemId=applyChangesBtn]': {
                click: function(button) {
                    var $this = this;
                    var grid = $this.getProgrammanagemarksmoderationgrid();

                    if (grid.getSelectionModel().getCount() > 0) {    
                        //var records = grid.getSelectionModel().getSelection()[0];
                        var formWindow = this.getManagemarksmoderationwin();
                        if (!formWindow) {
                            Ext.widget('programManageMarksModerationwin');
                            formWindow = this.getProgramManageMarksModerationwin();  
                        }
                        formWindow.show(); 
                     } else { 
                        showWarningMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
                    }
                }
            },

            'managemarksmoderationwin button[itemId=cancelBtn]': {
                click: function(obj) {
                    obj.up('window').close();
                }
            },

            'programManageMarksModerationwin button[itemId=submitBtnWin]': {
                click: function(obj) {
                	var isDelete=false;
                    this.saveManageMarksModerationDataNew(obj,isDelete);  
                }
            },
            
            'programManageMarksModerationwin button[itemId=cancelBtn]': { 
                click: function(obj) {
                    obj.up('window').close();
                }
            },

            'managemarksmoderationwin button[itemId=submitBtnWin]': {
                click: function(obj) {
                	var isDelete=false;
                    this.saveManageMarksModerationData(obj,isDelete);
                }
            },
            
            'managemarksmoderationwin': {
                render: function(obj) {
                	var $this = this;
                	var grid = $this.getManagemarksmoderationgrid();
                	
                	var selectedItem = grid.getSelectionModel().selected.items[0];
					var maxMarks = selectedItem ? selectedItem.data.maxMarks : null;
					var maxModerationMarks = maxMarks !== null ? Math.abs(parseInt(maxMarks)) : 0;
                	
                	//var maxModerationMarks = Math.abs(parseInt(grid.getSelectionModel().selected.items[0].data.maxMarks));
                	var minModerationMarks = -Math.abs(maxModerationMarks);

                	var selectedRecords = grid.getSelectionModel().selected.items;
                	var moderationMarkToSet = '';
                	var finalModerationPoints = selectedRecords[0].data.moderationPoints;
                	var finalModerationReason = selectedRecords[0].data.moderationReason;
                	Ext.each(selectedRecords, function(currentRecord){
                		if(moderationMarkToSet==''){
                			moderationMarkToSet = currentRecord.data.moderationPoints;
                		}
                		else if(moderationMarkToSet!=currentRecord.data.moderationPoints){
                			finalModerationPoints = '';
                			finalModerationReason = '';
                			return false;
                		}
                	});
                	
                	obj.down('#moderationPoints').setMinValue(minModerationMarks);
                	obj.down('#moderationPoints').setMaxValue(maxModerationMarks);
                	
                	setTimeout(function(){
                    	obj.down('#moderationPoints').setValue(parseFloat(finalModerationPoints)); 
                    	obj.down('#moderationReason').setValue(finalModerationReason);
                    	obj.down('#noOfRecords').setValue(selectedRecords.length);
                	},100);
                }
            },
            
             'programManageMarksModerationwin': {
                render: function(obj) {
                	var $this = this;
                	var grid = $this.getProgrammanagemarksmoderationgrid();   
                	
                	var selectedItem = grid.getSelectionModel().selected.items[0];
					var maxMarks = selectedItem ? selectedItem.data.maxMarks : null;
					var maxModerationMarks = maxMarks !== null ? Math.abs(parseInt(maxMarks)) : 0;
                	
                	//var maxModerationMarks = Math.abs(parseInt(grid.getSelectionModel().selected.items[0].data.maxMarks));
                	var minModerationMarks = -Math.abs(maxModerationMarks); 

                	var selectedRecords = grid.getSelectionModel().selected.items;
                	var moderationMarkToSet = '';
                
					var finalModerationPoints = selectedRecords[0].data.moderationPoints;
                	var finalModerationReason = selectedRecords[0].data.moderationReason;	
					
                	Ext.each(selectedRecords, function(currentRecord){  
                		if(moderationMarkToSet==''){
                			moderationMarkToSet = currentRecord.data.moderationPoints;
                		}
                		else if(moderationMarkToSet!=currentRecord.data.moderationPoints){ 
                			finalModerationPoints = '';
                			finalModerationReason = '';
                			return false;
                		}
                	});
                	
                	obj.down('#moderationPoints').setMinValue(minModerationMarks);
                	obj.down('#moderationPoints').setMaxValue(maxModerationMarks);
                	
                	setTimeout(function(){
                    	obj.down('#moderationPoints').setValue(parseFloat(finalModerationPoints)); 
                    	obj.down('#moderationReason').setValue(finalModerationReason);
                    	obj.down('#noOfRecords').setValue(selectedRecords.length);
                	},100);
                }
            },

            'managemarksmoderationstructure': {
            	afterrender : function(structure){
            		//var form = structure.down('evaluationplanfilter');
            		var grid = structure.down('managemarksmoderationgrid');
            		var newstructure = structure.down('form');
            		this.getGridHeaderFreeze(grid,newstructure);
            		this.hideGridColumnMenuOnScroll(newstructure,grid);
            		
            		var permissionsMap = this.getMANAGE_MARKS_MODERATION_PERMISSIONS();
            		var programPermissionsMap = this.getPROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES();
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					if(permissionList.indexOf('IMPORT_MARKS_MODERATION') != -1) {
						structure.add({
							title: getExaminationTranslation('IMPORT_MARKS_MODERATION'),
							tabCls: 'right-tab',
							autoScroll: true,
							frame: false,
							items: [{
								xtype: 'importMarksModerationStructure'
							}]
						});
					}
					if(permissionList.indexOf('PROGRAM_LEVEL_MARKS_MODERATION') != -1) {
						structure.add({
							title: getExaminationTranslation('PROGRAM_LEVEL_MARKS_MODERATION'),
							tabCls: 'right-tab',
							frame: false,
							layout: 'fit',
							margin: 0,
							items: [{
								xtype: 'programLevelMarksModerationStructure'
							}]
						});
					}
            	}
            },
            
            'managemarksmoderationgrid button[itemId=btnDelete]' : {
				click : function(obj) {
					var isDelete=true;
					this.saveManageMarksModerationData(obj,isDelete);
					obj.removeCls('x-btn-default-toolbar-small-focus');
				}
			},
			'programmanagemarksmoderationgrid button[itemId=btnDelete]' : {
				click : function(obj) {
					var isDelete=true;
					this.saveManageMarksModerationDataNew(obj,isDelete);  
					obj.removeCls('x-btn-default-toolbar-small-focus'); 
				}
			},
			 'managemarksmoderationgrid button[itemId=editMarks]' : {
					click : function(obj) {
						var grid=this.getManagemarksmoderationgrid();
						var selectedRec = grid.getSelectionModel().getSelection();
						if(selectedRec.length>0){
							for(var i=0;i< selectedRec.length;i++){
								selectedRec[i].set("isEdit",true)
							}
						}
					}
				},
				
				'programmanagemarksmoderationgrid button[itemId=editMarks]' : {
					click : function(obj) {
						var grid=this.getProgrammanagemarksmoderationgrid();     
						var selectedRec = grid.getSelectionModel().getSelection();
						if(selectedRec.length>0){
							for(var i=0;i< selectedRec.length;i++){  
								selectedRec[i].set("isEdit",true)
							}
						}
					}
				},
				'managemarksmoderationgrid button[itemId=saveMarks]' : {
					 click: function(obj) {
						 var me = this;
					     obj.disable();
						 setTimeout(function(){
		                	var isDelete=false;
		                    me.saveManageMarksModerationData(obj,isDelete);
						 },200);
		             }
				},
				'programmanagemarksmoderationgrid button[itemId=saveMarks]' : {
					 click: function(obj) {
						 var me = this;
						 setTimeout(function(){
		                	var isDelete=false;
		                    me.saveManageMarksModerationDataNew(obj,isDelete); 
						 },200);
		             }
				},
				'importMarksModerationStructure radiogroup[itemId=importMarksModerationGroupId]': {
					change: this.toggleDownloadUploadForm
				},
				'downloadMarksModerationForm customcombobox[itemId=academicTermMarkModeration]': {
					select: this.onModerationAcademicTermSelect
				},
				'downloadMarksModerationForm customcombobox[itemId=evaluationPlanIdMarkModeration]': {
					select: this.onModerationSchemeSelect
				},
				'downloadMarksModerationForm multiselectcombofield[itemId=courseItemIdMarkModeration]': {
					change: this.onModerationCourseChange
				},
				'downloadMarksModerationForm multiselectcombofield[itemId=courseVariantItemIdMarkModeration]': {
					change: this.onModerationCourseVariantChange
				},
				'downloadMarksModerationForm customcombobox[itemId=programItemIdMarkModeration]': {
					select: this.onModerationProgramSelect
				},
				'downloadMarksModerationForm customcombobox[itemId=batchItemIdMarkModeration]': {
					select: this.onModerationBatchSelect
				},
				'downloadMarksModerationForm button[itemId=resetBtn]': {
					click: this.doResetDownloadMarkModerationForm
				},
				'downloadMarksModerationForm button[itemId=markModerationDownload]': {
					click: this.downloadMarkModerationTemplate
				},
				'uploadMarksModerationForm customcombobox[itemId=marksModerationTemplateName]': {
					render: this.loadTemplateNameCombo
				},
				'uploadMarksModerationForm button[itemId=resetBtn]': {
					click: this.resetUploadMarksModerationForm
				},
				'uploadMarksModerationForm uploadoptionradiogroup[itemId=uploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]': {
					change: this.toggleMyUploadAllUpload
				},
				'uploadMarksModerationForm button[itemId=marksModerationUpload]': {
					click: this.doUploadMarkModerationTemplate
				},
				'importUtilityMarkModeration button[itemId=btnForce]': {
					click: this.doForceRunMarkModerationTemplate
				},
				'importUtilityMarkModeration': {
					cellclick: this.onImportUtilityMarkModerationCellclick
				},
				'programLevelMarksModerationFilter': {
					afterrender: this.progLvlMarkModerationRender
				},
				'programLevelMarksModerationFilter customcombobox[itemId=academicTermProgLvlMarkModeration]': {
					select: this.onAcademicTermSelect
				},
				'programLevelMarksModerationFilter customcombobox[itemId=programProgLvlItemId]': {
					select: this.onProgramProgLvlSelect
				},
				'programLevelMarksModerationFilter customcombobox[itemId=batchProgLvlItemId]': {
					select: this.onBatchProgLvlSelect
				},
				'programLevelMarksModerationFilter customcombobox[itemId=periodProgLvlItemId]': {
					select: this.onPeriodProgLvlSelect
				},
				'programLevelMarksModerationFilter customcombobox[itemId=evalautionPlanProgLvlId]': {
					select: this.onSchemeProgLvlSelect
				},
				'programLevelMarksModerationFilter groupingcombobox[itemId=evaluationLevelNameProgLvlId]': {
					select: this.onSchemeLevelProgLvlSelect
				},
				'programLevelMarksModerationFilter button[itemId=resetBtn]': {
					click: this.resetProgLvlModerationForm
				},
				'programLevelMarksModerationFilter multiselectcombofield[itemId=courseVariantProgLvlItemId]': {
					change: this.onVariantProgLvlSelect
				},
				'programLevelMarksModerationFilter button[itemId=searchBtn]': {
					click: this.searchProgLvlModeration
				},
				'programLevelMarksModerationFilter multiselectcombofield[itemId=courseProgLvlItemId]': {
					change: this.onCourseProgLvlSelect
				}
        });
    },
    loadManageMarksModerationFilterData: function() {
        var $this = this;
        var filterForm = $this.getManagemarksmoderationfilter().getForm();
        var managemarksmoderationgrid = $this.getManagemarksmoderationgrid();
		var mForm = $this.getManagemarksmoderationfilter();
		managemarksmoderationgrid.config.searchFilterForm = mForm;
        var filterFormValues = filterForm.getValues();

        var academyLocationId = $this.getCurrentAcademyLocation();
        var courseVariantArray = [];
        var records;
        if (!isNullOrEmpty(filterFormValues.courseVariant)) {
            for (var i = 0; i < filterFormValues.courseVariant.length; i++) {
                var courseVariantValue = filterFormValues.courseVariant[i];
                if (Ext.isObject(courseVariantValue)) {
                    courseVariantArray.push(courseVariantValue.data.id);
                } else {
                    courseVariantArray.push(courseVariant);
                }
            }
        }
        
        managemarksmoderationgrid.getStore().pageSize=100;
        managemarksmoderationgrid.getStore().limit=100;
        managemarksmoderationgrid.getStore().getProxy().extraParams = {
            academyLocationId: academyLocationId,
            programId: filterFormValues.programId,
            batchId: filterFormValues.batchId,
            periodId: filterFormValues.periodId,
            courseId: filterFormValues.courseId,
            levelName: filterForm.findField('evaluationLevelName').valueModels[0].data.code,
            evaluationPlanId: filterFormValues.evaluationplan,
            courseVariantId: courseVariantArray.join(),
            levelId: filterForm.findField('evaluationLevelName').valueModels[0].data.levelId,
        };
        $this.resetPageSetting(managemarksmoderationgrid.getStore(), managemarksmoderationgrid);
        managemarksmoderationgrid.getStore().load();     
        managemarksmoderationgrid.getSelectionModel().deselectAll();
		managemarksmoderationgrid.getStore().pageSize=100;  

    },

    disableMoreActionPivileges: function(gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var applyChangesButtonId = gridReference.down("#applyChangesBtn");
        var editMarks = gridReference.down("#editMarks");
        var saveMarks = gridReference.down("#saveMarks");
        applyChangesButtonId.setVisible(false);
        editMarks.setVisible(false);
        saveMarks.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'APPLYCHANGES') {
                if (!isNullOrEmpty(applyChangesButtonId)) {
                    applyChangesButtonId.setVisible(true);
                }
            }
            if (privilege === 'EDIT') {
                if (!isNullOrEmpty(editMarks)) {
                	editMarks.setVisible(true);
                }
            }
            if (privilege === 'SAVE') {
                if (!isNullOrEmpty(saveMarks)) {
                	saveMarks.setVisible(true);
                }
            }
        });
    },

    saveManageMarksModerationData: function(obj,isDelete) {
        obj.disable();
        var $this = this;
        var formWindow = $this.getManagemarksmoderationwin();
        setTimeout(function(){
        	if(formWindow) {
        		formWindow.down('#submitBtnWin').setDisabled(true);
        	}
		},600);
        var marksModeration = $this.getManagemarksmoderationgrid();
        var moderationPoints=null;
        var moderationReason=null;
       if(!isDelete && Ext.isDefined(formWindow)){ //todo remove this code 
        	moderationPoints=formWindow.down('#moderationPoints').getValue();
        	moderationReason=formWindow.down('#moderationReason').getValue();
        	formWindow.down('#submitBtnWin').setDisabled(true);
        }
        var records = marksModeration.getSelectionModel().getSelection();
        var arrayData = [];
        var data = null;
        var courseVarintIdsArrayData = [];
        var admissionIdsArrayData = [];
        var programIdsArrayData = [];
        var batchIdsArrayData = [];
        var periodIdsArrayData = [];
        
        var saveModerationData=null;
        if (records.length > 0) {
            for (var i in records) {
            	courseVarintIdsArrayData.push(records[i].data.courseVariantId);
            	admissionIdsArrayData.push(records[i].data.admissionId);
            	programIdsArrayData.push(records[i].data.programId);
            	batchIdsArrayData.push(records[i].data.batchId);
            	periodIdsArrayData.push(records[i].data.periodId);
            }
         }
        if (records.length > 0) {
            for (var i in records) {
            	if(!records[i].data.isEdit && obj.itemId == 'saveMarks') {
            		moderationPoints = records[i].data.moderationPoints;
            		moderationReason = records[i].data.moderationReason;
            	}
				data = {
					"id": records[i].data.id,
					"levelId": records[i].data.levelId,  
					//"moderationPoints": isDelete ? null : isNullOrEmpty(moderationPoints) ? records[i].data.moderationPoints : moderationPoints,
				//"moderationReason": isDelete ? null : isNullOrEmpty(moderationReason) ? records[i].data.moderationReason : moderationReason,
					"moderationPoints": records[i].data.isEdit ? records[i].data.moderationPoints : moderationPoints,
					"moderationReason": records[i].data.isEdit ? records[i].data.moderationReason : moderationReason,
                
                };
                arrayData.push(data);
            }
        }else {
        	   showWarningMessage(getCommonTranslation('ATTENTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	   Ext.defer(function() {
            	   obj.enable();
               }, 250);
        	   return;
        }
        
        saveModerationData={
   			  'levelName': records[0] ? records[0].data.assessmentSchemeLevel : null,
   			  'moderationData':arrayData,
   			  'evaluationPlanId': records[0] ? records[0].data.evaluationPlanId : null,
   			  'courseId': records[0] ? records[0].data.courseId : null,
   			  'courseVariantIds': courseVarintIdsArrayData.join(),
  			  'admissionIds': admissionIdsArrayData.join(),
  			  'programIds': programIdsArrayData.join(),
  			  'batchIds': batchIdsArrayData.join(),
  			  'periodIds': periodIdsArrayData.join(),
        }
        
        var submitUrl;
        submitUrl = SERVERURL.PATH_SAVE_UPDATE_MODERATION_MARKS;
        Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: saveModerationData,
            method: 'POST',
            success: function(response, action) {				
                Ext.getBody().unmask();
                //obj.setDisabled(false);
               
               
                marksModeration.getStore().reload();
                marksModeration.getSelectionModel().deselectAll();
 				/**
                 * this condition is for window only
                 */
                if(isDelete){
                		showSuccessMessage(getExaminationTranslation('MODERATION_MARKS_DELETE_SUCCESSFULLY'), getExaminationTranslation('MODERATION_MARKS_DELETE_SUCCESSFULLY'));
    	            
                }else{
                    	showSuccessMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'), getExaminationTranslation('MODERATION_MARKS_SAVED_SUCCESSFULLY'));
                        if(Ext.isDefined(formWindow)){
                    	formWindow.close();
                        }
                }
                if(formWindow) {
                	formWindow.down('#submitBtnWin').setDisabled(true);
                }
               Ext.defer(function() {
            	   obj.enable();
               }, 250);
            },
            failure: function(){
            	if(!isDelete && Ext.isDefined(formWindow)){
            		formWindow.down('#submitBtnWin').setDisabled(false);
            	}
            	Ext.defer(function() {
             	   obj.enable();
                }, 250);
            }      
        });
    },
    
    deleteMarksModerationRecord:function(){
    	var $this=this;
    	var grid = $this.getManagemarksmoderationgrid();
    	var records = grid.getSelectionModel().getSelection();
    	var arrayData=[];
    	var data=null;
    	if (grid.getSelectionModel().getCount() > 0) {
    		if(records.length > 0){
    			for(var i in records){
    				data={
    						"id": records[i].data.id,
    						"levelName": records[i].data.assessmentSchemeLevel,
    				};
    				arrayData.push(data);
    			}
    		}
    		var submitUrl;
    		submitUrl = SERVERURL.PATH_FIND_DELETE_MARK_MODERATION;
    		showConfirmMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'),
    				getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : arrayData,
    					method : 'DELETE',
    					success : function(response, action) {
    						Ext.getBody().unmask();
    						grid.getStore().reload();
    						grid.getSelectionModel().deselectAll();
    						showSuccessMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'),
    								getExaminationTranslation('MODERATION_MARKS_DELETE_SUCCESSFULLY'));
    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
    	}
    },

    toggleDownloadUploadForm: function(radio, nVal, oVal) {
    	var downloadTemplateForm = this.getDownloadMarksModerationForm();
    	var uploadTemplateForm = this.getUploadMarksModerationForm();
    	downloadTemplateForm.setVisible(nVal.downloadUploadTemplate == "forDownloadTemplate");
    	uploadTemplateForm.setVisible(nVal.downloadUploadTemplate == "forUploadTemplate");
    	
    	var grid = this.getImportUtilityMarkModeration();
    	if(nVal.downloadUploadTemplate == 'forDownloadTemplate') {
    		this.doResetDownloadMarkModerationForm(downloadTemplateForm.down('#resetBtn'));

    		grid.setVisible(false);
    		this.resetPageSetting(grid.getStore(), grid);
    	}
    	else {
    		this.resetUploadMarksModerationForm(uploadTemplateForm.down('#resetBtn'));
    		grid.setVisible(true);

    		this.loadTemplateNameCombo(uploadTemplateForm.down('#marksModerationTemplateName'));
    		this.resetPageSetting(grid.getStore(), grid);
    		this.onChangeUploadOptionRadioGroup(false, grid, 'Import Marks Moderation');
    		grid.getStore().pageSize = 100;
    	}
    },
    
    onModerationAcademicTermSelect: function(combo, rec) {
    	var form = combo.up('form');
    	var scheme = form.down('#evaluationPlanIdMarkModeration');
    	var schemeStore = scheme.getStore();
    	scheme.reset();
    	scheme.enable();
    	schemeStore.getProxy().extraParams = {
    		academyLocationId: this.getCurrentAcademyLocation(),
    		academicTermId: rec[0].get('id')
    	};
    	schemeStore.load();
    	
    	var course = form.down('#courseItemIdMarkModeration');
    	course.reset();
    	course.clearValue();
    	course.disable();
    	
    	var variant = form.down('#courseVariantItemIdMarkModeration');
    	variant.reset();
    	variant.clearValue();
    	variant.disable();
    	
    	var schemeLevel = form.down('#evaluationLevelNameIdMarkModeration');
    	schemeLevel.reset();
    	schemeLevel.disable();
    	
    	var program = form.down('#programItemIdMarkModeration');
    	program.reset();
    	program.disable();
    	
    	var batch = form.down('#batchItemIdMarkModeration');
    	batch.reset();
    	batch.disable();
    	
    	var peroid = form.down('#periodItemIdMarkModeration');
    	peroid.reset();
    	peroid.disable();
    },
    
    onModerationSchemeSelect: function(combo, rec) {
    	var alId = this.getCurrentAcademyLocation();
    	var form = combo.up('form');
    	var vals = form.getValues();
    	var course = form.down('#courseItemIdMarkModeration');
    	var courseStore = course.getStore();
    	course.reset();
    	course.clearValue();
    	course.enable();
    	courseStore.getProxy().extraParams = {
    		academyLocationId: alId,
    		academicTermId: vals.academicTerm,
    		evaluationPlanId: vals.evaluationPlanId
    	};
    	courseStore.load();
    	
    	var program = form.down('#programItemIdMarkModeration');
    	var programStore = program.getStore();
    	program.reset();
    	program.enable();
    	programStore.getProxy().extraParams = {
    		academyLocationId: alId,
    		evaluationPlanId: vals.evaluationPlanId
    	};
    	programStore.load();
    	
    	var schemeLevel = form.down('#evaluationLevelNameIdMarkModeration');
    	var levelStore = schemeLevel.getStore();
    	schemeLevel.reset();
    	schemeLevel.enable();
    	levelStore.getProxy().extraParams = {
    		evaluationPlanId: vals.evaluationPlanId
    	};
    	levelStore.load();
    	
    	var variant = form.down('#courseVariantItemIdMarkModeration');
    	variant.reset();
    	variant.clearValue();
    	variant.disable();
    	
    	var program = form.down('#programItemIdMarkModeration');
    	program.reset();
    	
    	var batch = form.down('#batchItemIdMarkModeration');
    	batch.reset();
    	batch.disable();
    	
    	var peroid = form.down('#periodItemIdMarkModeration');
    	peroid.reset();
    	peroid.disable();
    },
    
    onModerationCourseChange: function(combo, rec) {
    	var alId = this.getCurrentAcademyLocation();
    	var form = combo.up('form');
    	var vals = form.getValues();
    	var courseIds = [];
    	if(vals.courseId && vals.courseId[0] && isNaN(vals.courseId[0])) {
    		for(var i = 0; i < vals.courseId.length; i++) {
    			courseIds.push(vals.courseId[i].get('id'));
    		}
    	}
    	else {
    		courseIds = vals.courseId ? vals.courseId : [];
    	}
    	
    	var courseVariantIds = [];
    	if(vals.courseVariant && vals.courseVariant[0] && isNaN(vals.courseVariant[0])) {
    		for(var i = 0; i < vals.courseVariant.length; i++) {
    			courseVariantIds.push(vals.courseVariant[i].get('id'));
    		}
    	}
    	else {
    		courseVariantIds = vals.courseVariant ? vals.courseVariant : [];
    	}
    	
    	var variant = form.down('#courseVariantItemIdMarkModeration');
    	var variantStore = variant.getStore();
    	variant.reset();
    	variant.clearValue();
    	if(rec.length) {
    		variant.enable();
    		variantStore.getProxy().extraParams = {
    			academyLocationId: alId,
    			academicTermId: vals.academicTerm,
    			evaluationPlanId: vals.evaluationPlanId,
    			courseIds: courseIds.join(',')
    		};
    		variantStore.load();
    	}
    	else {
    		variant.disable();
    	}
    	
    	var program = form.down('#programItemIdMarkModeration');
    	var programStore = program.getStore();
    	program.reset();
    	program.enable();
    	programStore.getProxy().extraParams = {
    		academyLocationId: alId,
    		evaluationPlanId: vals.evaluationPlanId,
    		academicTermId: vals.academicTerm,
    		courseIds: courseIds.join(','),
    		courseVariantIds: courseVariantIds.join(',')
    	};
    	programStore.load();
    	
    	var batch = form.down('#batchItemIdMarkModeration');
    	batch.reset();
    	batch.disable();
    	
    	var peroid = form.down('#periodItemIdMarkModeration');
    	peroid.reset();
    	peroid.disable();
    },
    
    onModerationCourseVariantChange: function(combo, rec) {
    	var alId = this.getCurrentAcademyLocation();
    	var form = combo.up('form');
    	var vals = form.getValues();
    	var courseIds = [];
    	if(vals.courseId && vals.courseId[0] && isNaN(vals.courseId[0])) {
    		for(var i = 0; i < vals.courseId.length; i++) {
    			courseIds.push(vals.courseId[i].get('id'));
    		}
    	}
    	else {
    		courseIds = vals.courseId ? vals.courseId : [];
    	}
    	
    	var courseVariantIds = [];
    	if(vals.courseVariant && vals.courseVariant[0] && isNaN(vals.courseVariant[0])) {
    		for(var i = 0; i < vals.courseVariant.length; i++) {
    			courseVariantIds.push(vals.courseVariant[i].get('id'));
    		}
    	}
    	else {
    		courseVariantIds = vals.courseVariant ? vals.courseVariant : [];
    	}
    	
    	var program = form.down('#programItemIdMarkModeration');
    	var programStore = program.getStore();
    	program.reset();
    	program.enable();
    	programStore.getProxy().extraParams = {
    		academyLocationId: alId,
    		evaluationPlanId: vals.evaluationPlanId,
    		academicTermId: vals.academicTerm,
    		courseIds: courseIds.join(','),
    		courseVariantIds: courseVariantIds.join(',')
    	};
    	programStore.load();
    	
    	var batch = form.down('#batchItemIdMarkModeration');
    	batch.reset();
    	batch.disable();
    	
    	var peroid = form.down('#periodItemIdMarkModeration');
    	peroid.reset();
    	peroid.disable();
    },
    
    onModerationProgramSelect: function(combo, rec) {
    	var form = combo.up('form');
    	var vals = form.getValues();
    	var batch = form.down('#batchItemIdMarkModeration');
    	var batchStore = batch.getStore();
    	batch.reset();
    	batch.enable();
    	batchStore.getProxy().extraParams = {
    		programId: vals.programId
    	};
    	batchStore.load();
    	
    	var peroid = form.down('#periodItemIdMarkModeration');
    	peroid.reset();
    	peroid.disable();
    },
    
    onModerationBatchSelect: function(combo, rec) {
    	var form = combo.up('form');
    	var vals = form.getValues();
    	var peroid = form.down('#periodItemIdMarkModeration');
    	var peroidStore = peroid.getStore();
    	peroid.reset();
    	peroid.enable();
    	peroidStore.getProxy().extraParams = {
    		batchId: vals.batchId,
    		academicTermId: vals.academicTerm
    	};
    	peroidStore.load();
    },
    
    doResetDownloadMarkModerationForm: function(btn) {
    	var form = btn.up('form');
    	form.getForm().reset();
    	form.down('#evaluationPlanIdMarkModeration').disable();
    	form.down('#courseItemIdMarkModeration').disable();
    	form.down('#courseVariantItemIdMarkModeration').disable();
    	form.down('#evaluationLevelNameIdMarkModeration').disable();
    	form.down('#programItemIdMarkModeration').disable();
    	form.down('#batchItemIdMarkModeration').disable();
    	form.down('#periodItemIdMarkModeration').disable();
    	form.down('#courseItemIdMarkModeration').clearValue();
    	form.down('#courseVariantItemIdMarkModeration').clearValue();
    },
    
    downloadMarkModerationTemplate: function(btn) {
    	var me = this;
    	var form = btn.up('form');
    	var vals = form.getValues();
    	
    	var courseIds = [];
    	if(vals.courseId && vals.courseId[0] && isNaN(vals.courseId[0])) {
    		for(var i = 0; i < vals.courseId.length; i++) {
    			courseIds.push(vals.courseId[i].get('id'));
    		}
    	}
    	else {
    		courseIds = vals.courseId ? vals.courseId : [];
    	}
    	
    	var courseVariantIds = [];
    	if(vals.courseVariant && vals.courseVariant[0] && isNaN(vals.courseVariant[0])) {
    		for(var i = 0; i < vals.courseVariant.length; i++) {
    			courseVariantIds.push(vals.courseVariant[i].get('id'));
    		}
    	}
    	else {
    		courseVariantIds = vals.courseVariant ? vals.courseVariant : [];
    	}
    	
    	var levelOneId = null;
        var levelTwoId = null;
        var levelThreeId = null;
        
        var assessmentSchemeLevel = form.down('#evaluationLevelNameIdMarkModeration');
        var record = assessmentSchemeLevel.lastSelection;
        if (record && record.length && !isNullOrEmpty(record[0].data.code)) {
            if (record[0].data.code == "Assessment Method") {
                levelThreeId = record[0].data.levelId;
            }
            else if (record[0].data.code == "Assessment Sub Type") {
                levelTwoId = record[0].data.levelId;
            }
            else if (record[0].data.code == "Assessment Type") {
                levelOneId = record[0].data.levelId;
            }
        }
        var jsonData = {
        		academyLocationId: me.getCurrentAcademyLocation(),
        		evaluationPlanId: vals.evaluationPlanId,
        		academicTermId: vals.academicTerm,
        		courseIds: courseIds.join(','),
        		courseVariantIds: courseVariantIds.join(','),
        		programId: vals.programId,
        		batchId: vals.batchId,
        		periodId: vals.periodId,
        		typeId: levelOneId,
        		subTypeId: levelTwoId,
        		methodId: levelThreeId
        };
        var csvForm = Ext.create('Ext.form.Panel', {
        	items:[{
        		xtype : 'textfield',
        		maxLength : 1000000,
        		itemId : 'exportListDTO',
        		name : 'exportListDTO'
        	}]
        });
        csvForm.down('#exportListDTO').setValue(Ext.encode(jsonData));
    	csvForm.getForm().submit({
    	    target: '_blank',
    	    method: 'POST',
    	    params: {
    	        access_token: Ext.Ajax.defaultHeaders.access_token
    	    },
    	    headers: {
    	        'Authorization': Ext.Ajax.defaultHeaders.Authorization
    	    },
    	    url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_MARK_MODERATION,
    	    standardSubmit: true
    	});
    },
    
    loadTemplateNameCombo: function(combo) {
    	combo.getStore().load({
    		callback: function(records, operation, success) {
    			for(var i in records){
    				if(records[i].data.code == 'importMarksModeration'){
    					combo.setValue(records[i].data.id);
    					combo.setReadOnly(true);
    				}
    			}
    		}	   
    	});
    },
    
    resetUploadMarksModerationForm: function(btn) {
    	var form = btn.up('form').getForm();
    	form.findField('file').reset();
    	var uploadoptionradiogroupform  = btn.up('form').down('uploadoptionradiogroup');
    	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    		isUploadAll: false
    	});
    	form.checkValidity();
    },
    
    toggleMyUploadAllUpload: function(radio, nVal) {
    	var grid = this.getImportUtilityMarkModeration();
    	this.onChangeUploadOptionRadioGroup(nVal, grid, 'Import Marks Moderation');
    },
    
    doUploadMarkModerationTemplate: function (btn) {
    	btn.disable();
        var $this = this;
        var form = $this.getUploadMarksModerationForm()
        var grdStore;
        var grid = $this.getImportUtilityMarkModeration();
        $this.getHashOfFile(form);
        setTimeout(function () {
            form.getForm().submit({
                method: 'POST',
                url: SERVERURL.IMPORT_UTILITY_MASTER_CREATE,
                success: function (form, action) {
                    showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                    Ext.defer(function () {
                        form.isValid();
                        form.clearInvalid();
                    }, 1000);
                },
                failure: function (form, action) {
                    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CONTENT_MISMATCH'));
                }
            });
        }, 1000);

        Ext.defer(function () {
            this.onChangeUploadOptionRadioGroup(form.getValues().isUploadAll, grid, 'Import Marks Moderation');
        }, 2000, this);
    },
    
    doForceRunMarkModerationTemplate: function(btn) {
    	var grid = this.getImportUtilityMarkModeration();
    	if (grid.getSelectionModel().getCount() > 0) {
    	    if (grid.getSelectionModel().getCount() > 1) {
    	        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    	    }
    	    else {
    	        var this$ = this;
    	        var id = grid.getSelectionModel().selectionStart.data.id;
    	        console.log(id);
    	        var urlAppend = "?jobName=" + id;
    	        var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
    	        Ext.Ajax.request({
    	            url: submitURL,
    	            method: 'GET',
    	            success: function (response) {
    	                if (response.responseText === "JOB_STATUS_NOT_PENDING") {
    	                    showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
    	                } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
    	                    //console.log("Manual trigger hit");
    	                    showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
    	                } else if (response.responseText === "SUCCESS" || response.responseText === "Success") {
    	                    //console.log("Manual trigger hit");
    	                    showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
    	                }
    	            }
    	        });
    	    }
    	}
    	else {
    	    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    onImportUtilityMarkModerationCellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    	if (e.target.tagName == 'A') {
    		var fileType = null;
    		if(cellIndex == 1) {
    			fileType = 'successFile';
    		}
    		else if(cellIndex == 6) {
    			fileType='errorFile';
    		}
    		else if(cellIndex == 7) {
    			fileType = 'logFile';
    		}
    		var documentId = record.get("id");
    		if (!isNullOrEmpty(documentId)) {
    			this.getDownloadFile(documentId,fileType);
    		}
    	}
    },
    
    getDownloadFile: function(documentId,fileType) {
    	if(!isNullOrEmpty(documentId)) {
    		var csvForm = Ext.create('Ext.form.Panel'); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params: {
    				access_token: Ext.Ajax.defaultHeaders.access_token
    			},
    			headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
    			standardSubmit: true
    		});
    	}
    },
    /* Program Level courses moderation method Logics V2D-465071 */  
	saveManageMarksModerationDataNew: function(obj, isDelete) {
		    var $this = this;
		    var formWindow = $this.getProgramManageMarksModerationwin(); 
		    var marksModeration = $this.getProgrammanagemarksmoderationgrid();
		    var moderationPoints = null;
		    var moderationReason = null; 
		
		    // Disable submit button initially
		    setTimeout(function() {
		        if (formWindow) {
		            formWindow.down('#submitBtnWin').setDisabled(true);
		        }
		    }, 600);
		
		    if (!isDelete && Ext.isDefined(formWindow)) {
		        moderationPoints = formWindow.down('#moderationPoints').getValue();
		        moderationReason = formWindow.down('#moderationReason').getValue();
		        formWindow.down('#submitBtnWin').setDisabled(true);
		    }
		
		    var records = marksModeration.getSelectionModel().getSelection();
		    if (records.length === 0) {
		        showWarningMessage(getCommonTranslation('ATTENTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        return;
		    }
		
		    // Prepare arrays for saving
		    var courseVariantIds = [];
		    var admissionIds = [];
		    var programIds = [];
		    var batchIds = [];
		    var periodIds = [];
		    var arrayData = [];
		
		    // Populate the arrays from selected records
		    records.forEach(function(record) {
		        courseVariantIds.push(record.data.courseVariantId);
		        admissionIds.push(record.data.admissionId);
		        programIds.push(record.data.programId);
		        batchIds.push(record.data.batchId);
		        periodIds.push(record.data.periodId);
		
		        if (!record.data.isEdit && obj.itemId === 'saveMarks') {
		            moderationPoints = record.data.moderationPoints;
		            moderationReason = record.data.moderationReason;
		        }
		
		        // Prepare the data for the selected record
		        arrayData.push({
		            id: record.data.id,
		            levelId: record.data.levelId,
		            moderationPoints: record.data.isEdit ? record.data.moderationPoints : moderationPoints,
		            moderationReason: record.data.isEdit ? record.data.moderationReason : moderationReason
		        });
		    });
		
		    // Prepare the data object to send
		    var saveModerationData = {
		        levelName: records[0].data.assessmentSchemeLevel,
		        moderationData: arrayData,
		        evaluationPlanId: records[0].data.evaluationPlanId,
		        courseId: records[0].data.courseId,
		        courseVariantIds: courseVariantIds.join(),
		        admissionIds: admissionIds.join(),
		        programIds: programIds.join(),
		        batchIds: batchIds.join(),
		        periodIds: periodIds.join()
		    };
		
		    // Make the AJAX request to save/update moderation marks V2D-465071   
		    // var submitUrl = "rest/programLevelMarkModeration/updateModerationMarks";
		    var submitUrl = SERVERURL.PATH_FOR_PROGRAM_SAVE_UPDATE_MODERATION_MARKS;           
		    Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
		
		    Ext.Ajax.request({
		        type: 'rest',
		        url: submitUrl,
		        jsonData: saveModerationData,
		        method: 'POST',
		        success: function(response, action) {
		            Ext.getBody().unmask();
		            marksModeration.getStore().reload();
		            marksModeration.getSelectionModel().deselectAll();
		
		            // Show success message and close the form if necessary
		            if (isDelete) {
		                showSuccessMessage(getExaminationTranslation('MODERATION_MARKS_DELETE_SUCCESSFULLY'), getExaminationTranslation('MODERATION_MARKS_DELETE_SUCCESSFULLY'));
		            } else {
		                showSuccessMessage(getExaminationTranslation('MANAGE_MARKS_MODERATION'), getExaminationTranslation('MODERATION_MARKS_SAVED_SUCCESSFULLY'));
		                if (Ext.isDefined(formWindow)) {
		                    formWindow.close();
		                }
		            }
		
		            // Disable the submit button after successful submission
		            if (Ext.isDefined(formWindow)) {
		                formWindow.down('#submitBtnWin').setDisabled(true);
		            }
		        },
		        failure: function() {
		            if (!isDelete && Ext.isDefined(formWindow)) {
		                formWindow.down('#submitBtnWin').setDisabled(false);
		            }
		        }
		    });
		}  
,   
    
    progLvlMarkModerationRender: function(form) {
    	var term = form.down('#academicTermProgLvlMarkModeration');
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	var termStore = term.getStore();
    	termStore.getProxy().extraParams = {
    		academyLocationIds: ALArray.join()
    	};
    	termStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record.length > 0) {
    					Ext.each(record, function(value) {
    						if(value.get('sequence') == 1){
    							term.setValue(value.get('id'));
    							term.fireEvent('select', term, [value]);
    						}
    					});
    				} 
    			}
    		}
    	});
    },
    
    onAcademicTermSelect: function(cmp, records) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var program = form.down('#programProgLvlItemId');
    	var programStore = program.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	programStore.getProxy().extraParams = {
    		academyLocationId: ALArray.join(),
    		academicTermId: vals.academicTerm
    	};
    	program.enable();
    	program.reset();
    	var batch = form.down('#batchProgLvlItemId');
    	batch.disable();
    	batch.reset();
    	var period = form.down('#periodProgLvlItemId');
    	period.disable();
    	period.reset();
    	var course = form.down('#courseProgLvlItemId');
    	course.disable();
    	course.reset();
    	course.clearValue();
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.disable();
    	variant.reset();
    	variant.clearValue();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.disable();
    	level.reset();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    	student.reset();
    	var me = this;
    	programStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					program.setValue(record[0].get('id'));
    					program.fireEvent('select', program, record);
    				}
    		    	me.loadProgLvlScheme(form, vals);
    			}
    		}
    	});
    },
    
    onProgramProgLvlSelect: function(cmp, records) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var batch = form.down('#batchProgLvlItemId');
    	var batchStore = batch.getStore();
    	batchStore.getProxy().extraParams = {
    		id: records[0].get('id'),
    		academicTermId: vals.academicTerm
    	};
    	batch.enable();
    	batch.reset();
    	var period = form.down('#periodProgLvlItemId');
    	period.disable();
    	period.reset();
    	var course = form.down('#courseProgLvlItemId');
    	course.disable();
    	course.reset();
    	course.clearValue();
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.disable();
    	variant.reset();
    	variant.clearValue();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.disable();
    	level.reset();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    	student.reset();
    	var me = this;
    	batchStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					batch.setValue(record[0].get('id'));
    					batch.fireEvent('select', batch, record);
    				}
    		    	me.loadProgLvlScheme(form, vals);
    			}
    		}
    	});
    },
    
    onBatchProgLvlSelect: function(cmp, records) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var period = form.down('#periodProgLvlItemId');
    	var periodStore = period.getStore();
    	periodStore.getProxy().extraParams = {
    		batchId: vals.batchId,
    		termId: vals.academicTerm,
    		academyLocationId: this.getCurrentAcademyLocation(),
    		programId: vals.programId
    	};
    	period.enable();
    	period.reset();
    	var me = this;
    	periodStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					period.setValue(record[0].get('id'));
    					period.fireEvent('select', period, record);
    				}
    		    	me.loadProgLvlScheme(form, vals);
    			}
    		}
    	});
    	var course = form.down('#courseProgLvlItemId');
    	course.disable();
    	course.reset();
    	course.clearValue();
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.disable();
    	variant.reset();
    	variant.clearValue();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.disable();
    	level.reset();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    	student.reset();
    },
    
    onPeriodProgLvlSelect: function(cmp, records) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var course = form.down('#courseProgLvlItemId');
    	course.disable();
    	course.reset();
    	course.clearValue();
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.disable();
    	variant.reset();
    	variant.clearValue();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.disable();
    	level.reset();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    	student.reset();
    	this.loadProgLvlScheme(form, vals);
    },
    
    loadProgLvlScheme: function(form, vals) {
    	var scheme = form.down('#evalautionPlanProgLvlId');
    	scheme.reset();
    	scheme.enable();
    	var schemeStore = scheme.getStore();

    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	schemeStore.getProxy().extraParams = {
    		evaluationPlantype: 'ACADEMICS',
    		academyLocationId: ALArray.join(),
    		academicTermId: vals.academicTerm,
    		programId: vals.programId,
    		batchId: vals.batchId,
    		periodId: vals.periodId
    	};
    	schemeStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					if(vals.batchId && vals.periodId) {
    						scheme.setValue(record[0].get('id'));
    						scheme.fireEvent('select', scheme, record);
    					}
    				} 
    			}
    		}
    	});
    },
    
    onSchemeProgLvlSelect: function(cmp, records) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    	student.reset();
    	this.loadProgLvlCourse(form, vals);
    	this.loadProgLvlVariant(form, vals);
    	this.loadProgLvlSchemeLevel(form, vals);
    },
    
    loadProgLvlCourse: function(form, vals) {
    	var course = form.down('#courseProgLvlItemId');
    	course.reset();
    	course.clearValue();
    	course.enable();
    	var courseStore = course.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	courseStore.getProxy().extraParams = {
    		academyLocationId: ALArray.join(),
    		evaluationPlanId: vals.evaluationplan,
    		academicTermId: vals.academicTerm,
    		programId: vals.programId,
    		batchId: vals.batchId,
    		periodId: vals.periodId
    	};
    	courseStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					course.setValue([record[0].get('id')]);
    					course.fireEvent('change', course, record);
    				} 
    			}
    		}
    	});
    },
    
    loadProgLvlVariant: function(form, vals) {
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.reset();
    	variant.clearValue();
    	variant.enable();
    	var variantStore = variant.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	var courseIds = [];
    	if(vals.courseId) {
    		for(var i = 0; i < vals.courseId.length; i++) {
    			if(isNaN(vals.courseId[i])) {
    				courseIds.push(vals.courseId[i].get('id'));
    			}
    			else {
    				courseIds.push(vals.courseId[i]);
    			}
    		}
    	}
    	variantStore.getProxy().extraParams = {
    		academyLocationId: ALArray.join(),
    		evaluationPlanId: vals.evaluationplan,
    		academicTermId: vals.academicTerm,
    		programId: vals.programId,
    		batchId: vals.batchId,
    		periodId: vals.periodId,
    		courseId: courseIds.join()
    	};
    	variantStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					variant.setValue([record[0].get('id')]);
    					variant.fireEvent('change', variant, record);
    				} 
    			}
    		}
    	});
    },
    
    loadProgLvlSchemeLevel: function(form, vals) {
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.reset();
    	level.enable();
    	var levelStore = level.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var ALArray = [];
    	ALArray.push(academyLocationId);
    	levelStore.getProxy().extraParams = {
    		evaluationPlanId: vals.evaluationplan,
    		isStatus: false
    	};
    	levelStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					level.setValue(record[0].get('id'));
    					level.fireEvent('select', level, record);
    				}
    			}
    		}
    	});
    },
    
    onSchemeLevelProgLvlSelect: function(cmp, record) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.reset();
    	student.enable();
    	var studentStore = student.getStore();
    	var variantIds = [];
    	if(vals.courseVariant) {
    		for(var i = 0; i < vals.courseVariant.length; i++) {
    			if(isNaN(vals.courseVariant[i])) {
    				variantIds.push(vals.courseVariant[i].get('id'));
    			}
    			else {
    				variantIds.push(vals.courseVariant[i]);
    			}
    		}
    	}
    	studentStore.getProxy().extraParams = {
    		academyLocationId: this.getCurrentAcademyLocation(),
    		planId: vals.evaluationplan,
    		academicTermId: vals.academicTerm,
    		programId: vals.programId,
    		batchId: vals.batchId,
    		periodId: vals.periodId,
    		courseVariantId: variantIds.join()
    	};
    	studentStore.load({
    		callback: function(record, operation, success) {
    			if (success) {
    				if(record && record.length && record.length == 1) {
    					student.setValue(record[0].get('id'));
    				}
    			}
    		}
    	});
    },
    
    resetProgLvlModerationForm: function(btn) {
    	var form = btn.up('form');
    	form.getForm().reset();
    	this.progLvlMarkModerationRender(form);
    	var program = form.down('#programProgLvlItemId');
    	program.disable();
    	var batch = form.down('#batchProgLvlItemId');
    	batch.disable();
    	var period = form.down('#periodProgLvlItemId');
    	period.disable();
    	var scheme = form.down('#evalautionPlanProgLvlId');
    	scheme.disable();
    	var course = form.down('#courseProgLvlItemId');
    	course.clearValue();
    	course.disable();
    	var variant = form.down('#courseVariantProgLvlItemId');
    	variant.disable();
    	variant.clearValue();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.disable();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.disable();
    },
    
    onVariantProgLvlSelect: function(cmp, nval) {
    	var form = cmp.up('form');
    	nval;
    },
    
    searchProgLvlModeration: function(btn) {
    	var form = btn.up('form');
    	var vals = form.getValues();
    	var grid = this.getProgrammanagemarksmoderationgrid();
    	var store = grid.getStore();
    	var courseIds = [];
    	if(vals.courseId) {
    		for(var i = 0; i < vals.courseId.length; i++) {
    			if(isNaN(vals.courseId[i])) {
    				courseIds.push(vals.courseId[i].get('id'));
    			}
    			else {
    				courseIds.push(vals.courseId[i]);
    			}
    		}
    	}
    	var variantIds = [];
    	for(var i = 0; i < vals.courseVariant.length; i++) {
    		if(isNaN(vals.courseVariant[i])) {
    			variantIds.push(vals.courseVariant[i].get('id'));
    		}
    		else {
    			variantIds.push(vals.courseVariant[i]);
    		}
    	}
    	var levelId = form.down('#evaluationLevelNameProgLvlId').lastSelection[0].get('levelId');
    	var levelName = form.down('#evaluationLevelNameProgLvlId').lastSelection[0].get('code');
    	store.getProxy().extraParams = {
    		programId: vals.programId,
    		batchId: vals.batchId,
    		periodId: vals.periodId,
    		courseId: courseIds.join(),
    		levelName: levelName,
    	    evaluationPlanId: vals.evaluationplan,
    	    courseVariantId: variantIds.join(),
    	    levelId: levelId,
    	    academicTermId: vals.academicTerm,
    	    admissionId: vals.admissionCodeSTDName,
    	    academyLocationId: this.getCurrentAcademyLocation()
    	};
    	this.resetPageSetting(store, grid);
    	grid.getSelectionModel().deselectAll();
    	grid.getStore().pageSize = 100;
    	store.load();
    },
    
    onCourseProgLvlSelect: function(cmp) {
    	var form = cmp.up('form');
    	var vals = form.getValues();
    	var level = form.down('#evaluationLevelNameProgLvlId');
    	level.reset();
    	var student = form.down('#admissionCodeSTDNameProgLvl');
    	student.reset();
    	this.loadProgLvlVariant(form, vals);
    }
});