/**
 * @author Amit Gupta
 * 
 */
Ext.define('Academia.controller.mobile.mobilesyncreport.MobileSyncController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['mobile.mobilesyncreport.MobileSyncModel'],
	stores : ['mobile.mobilesyncreport.MobileSyncStore','mobile.mobilesyncreport.MobileSyncGridStore'],
	views : ['mobile.mobilesyncreport.MobileSyncStructure','mobile.mobilesyncreport.MobileSyncTabStructure',
	         'mobile.mobilesyncreport.MobileSyncFilter','mobile.mobilesyncreport.MobileSyncGrid'],
	         config:{
	        	 
	         },	         
	         refs : [
	                 {
	                	 ref : 'mobilesyncfilter',
	                	 selector : 'mobilesyncfilter'
	                 },{
	                	 ref : 'mobilesyncgrid',
	                	 selector : 'mobilesyncgrid'
	                 },{
	                	 ref : 'mobilesynctabstructure',
	                	 selector : 'mobilesynctabstructure'
	                 }],
	                 init : function() {
	                	 this.control({
	                		 'mobilesyncfilter button[itemId=searchBtn]': {
	                			 click: this.loadMobileSyncGrid
	                		 },
	                		 'mobilesyncfilter button[itemId=resetBtn]': {
	                			 click: this.resetFilter
	                		 },
	                		 
	                		 'mobilesynctabstructure':{
	                			 render : function(obj) {
	                				 var $this = this;
	                				 var filter = $this.getMobilesyncfilter();
	                				 var mobilesyncstatus = filter.down('#mobilesyncstatus');
	                				 var comboStore = mobilesyncstatus.getStore();
	                				 comboStore.load({
	                					 callback:function(record) {
	                						 if(record.length>0) {
	                							 mobilesyncstatus.setValue(record[2].get('id'));  
	                							 $this.loadMobileSyncGrid();
	                						 }
	                					 }
	                				 });
	                			 }
	                		 }
	                	 });
	                 },
	                 loadMobileSyncGrid:function(){
	                	 var $this=this;
	                	 var form = $this.getMobilesyncfilter();
	                	 var mobileSyncStatus = form.down("#mobilesyncstatus").getValue();

	                	 var grid = $this.getMobilesyncgrid();
	                	 var values = form.getForm().getValues();
	                	 var store =  grid.getStore();
	                	 store.getProxy().extraParams = {
	                		 syncStatus: mobileSyncStatus,
	                	 };
	                	 $this.resetPageSetting(store);
	                	 store.load();
	                 },
	                 resetFilter:function(){
	                	 this.getMobilesyncfilter().getForm().reset();
	                 }

});
