/*
 * Controller for the Management Accounting tab.
 */
Ext.define('Academia.controller.organization.ManagementAccountingController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['organization.ManagementAccountingGridStore',
             'organization.OrganizationUnitType',
             'organization.AllocatedALPs'],
    views: ['organization.managementaccounting.ManagementStructure',
            'organization.managementaccounting.ManagementAccountingGrid', 
            'organization.managementaccounting.ManagementAccountFormWindow',
            'organization.managementaccounting.ManagementAccountingTree',
            'organization.managementaccounting.MAUTreeFormWindow',
            'organization.managementaccounting.LinkedALPGridMA',
            'organization.managementaccounting.LinkedALPStructureWindowMA',
            'organization.managementaccounting.ALPToChildGridMA',
            'common.NestedJsonCombo'],
    models: ['organization.ManagementAccountGroup'],

    refs: [{
        ref: 'managementAccountFormWindow',
        selector: 'managementAccountFormWindow'
    }, {
        ref: 'managementForm',
        selector: 'managementAccountFormWindow form'
    }, {
        ref: 'managementGrid',
        selector: 'managementGrid'
    }, {
        ref: 'mauTreeFormWindow',
        selector: 'mauTreeFormWindow'
    }, {
        ref: 'mautreeForm',
        selector: 'mauTreeFormWindow form'
    }, {
        ref: 'mgmtaccTree',
        selector: 'mgmtacctree'
    }, /*
     * references for the popup
     */
    {
    	ref: 'linkedALPWindow',
    	selector: 'linkedalpstructurewindowma'
    }, {
    	ref: 'linkedALPGrid',
    	selector: 'linkedalpgridma'
    }, {
    	ref: 'alpToChildGrid',
    	selector: 'alptochildgridma'
    }],
    config: {
    	ORGANIZATION_STRUCTURE_MANAGEMENT_ACCOUNTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_MANAGEMENT_ACCOUNTING_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	'mgmtacctree':{
        		render: this.renderTreeStructure
        	},

            //Listeners for management accounting grid
            'managementGrid button[itemId=btnAdd]': {
                click: function() {
                    this.showFormWindow();
                }
            },
            'managementGrid button[itemId=btnEdit]': {
                click: function() {
                    this.editFormWindow();
                }
            },
            'managementGrid button[itemId=btnView]': {
                click: function() {
                    this.viewFormWindow();
                }
            },
            'managementGrid button[itemId=btnDelete]': {
                click: function() {
                    this.deleteRecord();
                }
            },
            'managementGrid': {
                select: function(record) {
                    this.loadManagementAccountTreeGrid(record);
                }
            },
            'managementGrid[itemId=managementGrid]': {
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getORGANIZATION_STRUCTURE_MANAGEMENT_ACCOUNTING_PERMISSIONS());
                }
            },
            'managementAccountFormWindow form button[action=Submit]': {
                click: this.saveManagementGroup
            },
            'managementAccountFormWindow form button[action=Cancel]': {
                click: this.closeFormWindow
            },
            'managementAccountFormWindow combo': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },

            //Listeners for management accounting tree
            'mgmtacctree button[itemId=btnAdd]': {
                click: function() {
                    this.addChild();
                }
            },
            'mgmtacctree button[itemId=btnEdit]': {
                click: function() {
                    this.editMAUTreeFormWindow();
                }
            },
            'mgmtacctree button[itemId=btnView]': {
                click: function() {
                    this.viewMAUTreeFormWindow();
                }
            },
            'mauTreeFormWindow form button[action=Submit]': {
                click: this.saveISU
            },
            'mauTreeFormWindow form button[action=Cancel]': {
                click: this.closeMAUTreeFormWindow
            },
            'mauTreeFormWindow nestedJsonCombo#currencyCombo' : {
				render : function(component, options) {
		    		if(!component.store.items){
		    			component.store.load({
		    				 callback : function(records, options, success) {
		    					 this.removeAll();
		    					tempArr = [];
		    					records.forEach(function(obj){
		    						if(obj.get('currencyExchangeRate')!=null && obj.get('currencyExchangeRate').status){
		    							tempArr.push(obj);
		    						}else{
		    							if(obj.get('name')!=null){
		    								tempArr.push(obj);
		    							}
		    						}
		    					});
		    					this.add(tempArr);
		    				}
		    			});
		            }
				}
			},
            /*
             * Listening to the application level event which is fired from the tree drag and drop 
             * event of the StatutoryAccountingTree.js.
             * 
             * @event: statutoryAccountingTreeDrag
             * @param: node is the selected node.
             * @param: data {refer the documentation of drag drop of tree}
             * @param: overModel{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             */
            '*': {
            	managementAccTreeDrag:function(node, data, overModel, dropPosition, dropHandlers) {
            		this.moveNode(node, data, overModel, dropPosition, dropHandlers);
            	}
            },

            'linkedalpgridma grid' : {
             	render: function(this$, eOpts) {
             		this.loadGridOnTreeSelection(this$);   
             	}
             },
             'mgmtacctree splitbutton #viewLinkedALPma': {
                 click: function() {
                        this.showLinkedAlpWindowMA();
                    }
             }, 
             'managementStructure': {
            	 activate: function() {
            		 this.loadStoreManually();
            	 }
             }
            
        });
    },
    
    renderTreeStructure:function(){
    	var tree=this.getMgmtaccTree();
    	tree.setVisible(false);
    },
    
    loadManagementAccountTreeGrid:function(record){
    	var mauRecord=record.selected.items[0].data;
    	var mauName= mauRecord.unitName;
    	var mauTree=this.getMgmtaccTree();
    	var mauStore=mauTree.getStore();
    	mauStore.getProxy().extraParams = {
             id: mauRecord.id
         };
    	mauStore.reload();
    	var rootNode=mauStore.getRootNode();
    	rootNode.data.text=mauName;
    	mauTree.setVisible(true);
    	mauTree.addCls('mgmtAccTreeBox')
    	
    	if(mauTree.setVisible(true)){
    		mauTree.up().down().addCls('mgmtAccGridBox')
    	}
    
    },

    /**
     * @method
     * Method to show the form window on click of add/view/edit button. 
     */
    showFormWindow: function() {
        var formWindow = this.getManagementAccountFormWindow();
        if (!formWindow) {
            Ext.widget('managementAccountFormWindow');
            formWindow = this.getManagementAccountFormWindow();
        }
        formWindow.show();
    },
    
    /**
     * @method
     * Method to close the form window on click of add/view/edit button. 
     */
    closeFormWindow: function() {
        this.getManagementAccountFormWindow().close();
    },

    /**
     * @method
     * Method to change the form to view mode on click of view button.
     * calls the {@link}
     */
    viewFormWindow: function() {
        this.editFormWindow();
        var form = this.getManagementForm();
        if (form) {
            form.down('#formSubmitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },
    /*
     * @method
     * method to show the linked Alp window 
     */
    showLinkedAlpWindowMA: function() {
    	var tree=this.getMgmtaccTree();
		if(tree.getSelectionModel().getCount()>0){
		    var linkedAlpWindow = this.getLinkedALPWindow();
			if(!linkedAlpWindow) {
			    Ext.widget('linkedalpstructurewindowma');
			    linkedAlpWindow = this.getLinkedALPWindow();
			}
			linkedAlpWindow.show();
		}
		else {
			showWarningMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
   /*
    * @method
    * method to show load the grids according to the selected record from the tree.
    */
    loadGridOnTreeSelection: function(this$) {
    	//TODO check for the store loading functionality for the tree
    	var tree=this.getMgmtaccTree();
    	/*
    	 * Load the records only if any record is selected.
    	 */
    		if(tree.getSelectionModel().getCount()>0) {
    		    var record=tree.getSelectionModel().getSelection()[0];
    		    var orgUnitId = record.data.id;
    		    var allocatedALPToOthersStore = this$.items.items[0].getStore();
    		    var alpToChildrenStore = this.getAlpToChildGrid().items.items[0].getStore();
    		    allocatedALPToOthersStore.getProxy().extraParams = {
    		           organizationUnitId: orgUnitId
    		    };
    		    allocatedALPToOthersStore.load();
    		    alpToChildrenStore.getProxy().extraParams = {
    		           organizationUnitId: orgUnitId
    		    };
    		    alpToChildrenStore.load();
    		} 
    },

    editFormWindow: function() {

        var grid = this.getManagementGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this.showFormWindow();
            var form = this.getManagementForm();
            form.down('#shortCode').setReadOnly(true);
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
            }
        } else {
        	showWarningMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    deleteRecord: function() {
        var grid = this.getManagementGrid();

        if (grid.getSelectionModel().getCount() > 0) {

        	showConfirmMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'rest',
                        url: SERVERURL.MGMT_ACCOUNTING_DELETE,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: {
                            id: id
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('DELETE_MANAGEMENT_ACCOUNTING_GROUP_SUCCESSFUL'));
                        }
                    });
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    saveManagementGroup: function(button) {
        var this$ = this;
        var form = this.getManagementForm().getForm();
        var organization=Academia.model.singleton.Organization;
        var values = form.getValues();
        values.organizationId=organization.id;
        var successMessage;
        var submitUrl;
        if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
            submitUrl = SERVERURL.MGMTACCOUNTINGSAVE;
            successMessage=getCommonTranslation('SAVE_MANAGEMENT_ACCOUNTING_GROUP_SUCCESSFUL');
        } else {
            submitUrl = SERVERURL.MGMTACCOUNTINGUPDATE;
            successMessage=getCommonTranslation('UPDATE_MANAGEMENT_ACCOUNTING_GROUP_SUCCESSFUL');
        }
        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: submitUrl,
            jsonData: values,
            success: function(form, action) {
            	if(form.responseText == 'DUPLICATE_SHORT_CODE')
            	{
            		showSuccessMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'),getCommonTranslation('MAU_DUPLICATE_SHORT_CODE'));
            	}else {
            		this$.getManagementGrid().getStore().reload();
            		this$.closeFormWindow();
            		this$.getManagementGrid().getSelectionModel().deselectAll(true);
            		showSuccessMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'),successMessage);
            	}
            }
          });
    },

    showMAUTreeFormWindow: function() {
        var formWindow = this.getMauTreeFormWindow();
        if (!formWindow) {
            Ext.widget('mauTreeFormWindow');
            formWindow = this.getMauTreeFormWindow();
        }
        formWindow.show();
        var form= this.getMautreeForm().getForm();
        form.setValues({organizationSupervisoryUnit:this.getSupervisoryUnitId()});
    },
    getSupervisoryUnitId : function() {
        var grid = this.getManagementGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            return record.getId();
        }
    },
    closeMAUTreeFormWindow: function() {
        this.getMauTreeFormWindow().close();
    },

    editMAUTreeFormWindow: function() {
        var tree = this.getMgmtaccTree();
        if (tree.getSelectionModel().getCount() > 0) {
            var record = tree.getSelectionModel().getSelection()[0];
            /*
             * check for restricting the user from doing edit operation on the root node 
             */
            if( !record.data.root) {
                this.showMAUTreeFormWindow();
                var form = this.getMautreeForm(record.getId());
                
                if (record != undefined && record != "" && record != null) {
                    var data = record.raw.model;
                    var organizationUnit = new Academia.model.organization.OrganizationUnit(data);
    
                    var parent = organizationUnit.get('parentOrganizationUnit');
                    form.loadRecord(organizationUnit);
                    form.down("#startDate").setValue(dateRender(data.startDate));
                    form.down("#tillDate").setValue(dateRender(data.tillDate));

                    if (parent != null) {
                        form.down('#parentISU').setValue(organizationUnit.get('parentOrganizationUnit').value);
                    }else {
                	form.down('#parentISU').setValue(getCommonTranslation('ROOTNODEFORTREE'));
                    }
                    form.down('#parentItemId').setValue(record.parentNode.data.id);
                    
                    form.down('#startDate').setReadOnly(true);
                }
            } else {
        	tree.getSelectionModel().deselectAll(true);
        	showWarningMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('NOOPERATIONSONROOT'));
            }
        } else {
        	showWarningMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    viewMAUTreeFormWindow: function() {
        this.editMAUTreeFormWindow();
        var form = this.getMautreeForm();
        if (form) {
            form.down('#formSubmitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    //TODO
    addChild: function() {
	var tree=this.getMgmtaccTree();
	if(tree.getSelectionModel().getCount()>0){
		 var mgmtAccRecord=tree.getSelectionModel().getSelection()[0];
		  this.showMAUTreeFormWindow(mgmtAccRecord.getId());
	   
            var mgmtaccform = this.getMautreeForm();
            if (mgmtAccRecord.parentNode != null) {
        	mgmtaccform.down('#parentOrganizationHiddenId').setValue(mgmtAccRecord.getId());
            }
            var parentOrganization = mgmtAccRecord.getData().text;
            mgmtaccform.down('#parentISU').setValue(parentOrganization);
            mgmtaccform.down('#parentItemId').setValue(mgmtAccRecord.getId());
	} else {
		showWarningMessage(getCommonTranslation('MGMTACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },

    saveISU: function() {
        var this$ = this;
        var tree = this.getMgmtaccTree();
        var record = tree.getSelectionModel().getSelection()[0];
        var mautreeform = this.getMautreeForm();
        var parentStartDate = '';
        var parentTillDate = '';
        var submitUrl = '';
        var organizationUnit = new Academia.model.organization.OrganizationUnit();
        var id = mautreeform.getForm().findField('id').getSubmitValue();
        var parent = false;
        if (id == null || id == "") {
            submitUrl = SERVERURL.MGMTACCOUNTINGCREATE;
            if (record.raw.model) {
                parentStartDate = record.raw.model.startDate;
                parentTillDate = record.raw.model.tillDate;
            } else {
                /*
                 * set parent as true if the node to be added is below root node
                 */
                parent = true;
            }
        } else {
            parentStartDate = record.raw.model.startDate;
            parentTillDate = record.raw.model.tillDate;
            submitUrl = SERVERURL.MGMTACCOUNTINGUPDATENODE;
        }
        var childStartDate = mautreeform.getForm().findField('startDate').getSubmitValue();
        var childTillDate = mautreeform.getForm().findField('tillDate').getSubmitValue();
        var ckChildStartDate = mautreeform.getForm().findField('startDate').rawValue;
        var ckParentStartDate = dateRender(parentStartDate); 

        var parentId = mautreeform.getForm().findField('parentId').getSubmitValue();
        var parentValue = mautreeform.getForm().findField('parentOrganizationUnit').getSubmitValue();
        var parentOrganizationUnit = {
            id: parentId,
            value: parentValue
        };
           
        if (parent || Academia.utilities.date.DateHelper.validateDate(parentStartDate, parentTillDate, ckChildStartDate, childTillDate)) {
            mautreeform.updateRecord(organizationUnit);
            if (parent) {
                delete organizationUnit.data.parentOrganizationUnit;
            }
            if (!parent) {
                organizationUnit.set('parentOrganizationUnit', parentOrganizationUnit);
            }
            /*
             * Code to format the dates according to the dmy format and set it back in the obj.
             */
          /*  var startdt = Ext.Date.format(organizationUnit.data.startDate, CONSTANTS.DATE_FORMAT);
            organizationUnit.data.startDate = startdt;
            var tilldt = Ext.Date.format(organizationUnit.data.tillDate, CONSTANTS.DATE_FORMAT);
            organizationUnit.data.tillDate = tilldt;*/
            
            organizationUnit.data.startDate = mautreeform.getForm().getValues().startDate;
            organizationUnit.data.tillDate =  mautreeform.getForm().getValues().tillDate;

            organizationUnit.set('owner', {
                id: organizationUnit.get('owner')
            });
            
            var values = Ext.encode(organizationUnit.data);
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: values,
                method: 'POST',
                success: function() {
                    tree.getStore().load();
                    tree.getSelectionModel().deselectAll(true);
                    this$.closeMAUTreeFormWindow();
                },
                failure: {

                }
            });
        }
    },
    moveNode: function(node, data, overModel, dropPosition, dropHandlers) {
        var orgUnit = data.records[0].raw.model;
        var childStartDate = orgUnit.startDate;
        var childTillDate = orgUnit.tillDate;
        var parentStartDate = '';
        var parentTillDate = '';
        var parent = false;
        var tree=this.getMgmtaccTree();
        
        if (overModel.raw.model) {
            parentStartDate = overModel.raw.model.startDate;
            parentTillDate = overModel.raw.model.tillDate;
        } else {
            /*
             * set parent as true if the node to be added is below root node
             */
            parent = true;
        }

        dropHandlers.wait = true;
        if (parent || Academia.utilities.date.DateHelper.validateDate(parentStartDate, parentTillDate, childStartDate, childTillDate)) {
            var parentOrganizationUnit = {
                id: overModel.data.id,
                value: overModel.data.text
            };
            orgUnit.parentOrganizationUnit = parentOrganizationUnit;
            var values = Ext.encode(orgUnit);
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.MGMTACCOUNTINGUPDATENODE,
                jsonData: values,
                success: function() {
                    dropHandlers.processDrop();
                    var store=tree.getStore();
        		     store.reload();
                }
            });
        } else {
            dropHandlers.cancelDrop();
        }
    },
    /*
     * @method
     * method to load the store manually after the rendering of the grid.
     */
    loadStoreManually: function() {
    	this.getManagementGrid().getStore().load();
    }
});
