Ext.define('Academia.controller.organization.OrganizationInfoController', {
    extend: 'Ext.app.Controller',
    stores: ['organization.OrganizationTypeStore', 'organization.BaseCurrencyStore', 'calendar.ActiveCalendarStore',
             'organization.CurrencyFormat', 'organization.DateFormat', 'organization.TimeFormat','othermasters.currencymaster.CurrencyMasterStore'],
    views: ['organization.organizationinfo.Organization-info', 'organization.OrganizationStructure','personinfo.common.personalinfo.PhotoUploadForm','organization.organizationinfo.Organization-info'],
    models: ['Academia.model.organization.OrganizationInfo'],
    refs: [{
        ref: 'organizationinfo',
        selector: 'organizationinfo'
    },{
        ref: 'organizationstructure',
        selector: 'organizationstructure'
    }/*,{
        ref: 'organizationinfoform',
        selector: 'organizationinfo'
    }*/],
    init: function() {
        this.control({
            'organizationinfo button[action=save]': {
                click: this.saveOrganization
            },
            'organizationinfo button[action=cancel]': {
                click: this.onPageRender
            },
            'organizationinfo combo': {
                render: this.onOrganizationInfoRender
            },
            'organizationinfostructure': {
                activate: this.onPageRender
            },
         /*   'organizationinfo photouploadform[itemId=logoUploadField] filefield[itemId=photoFileImage]':{
            	change: function(photoFileImage, value, eOpts) {
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            	}
            }*/
        });
    },
    /**
     * This is the function to initialize the stores after the components are displayed on the screen.
     * 
     */
    onOrganizationInfoRender: function(component, options) {
        component.getStore().load();
    },
    
    saveOrganizationBackgroundImage : function(orgId){
    	var this$ = this;
    	
    	var form = this$.getOrganizationinfo();
    	var uploadForm = form.down('#logoUploadField');
    	//var photoFileImage = uploadForm.down('filefield#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	var uploadUrl = SERVERURL.ORGANIZATION_BACKGROUND_UPLOAD;
    	
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
                || extension == "jpeg" || extension == "jpg") {
    			
    			form.getForm().submit({
    	             type: 'rest',
    	             url: uploadUrl,
    	             method: 'POST',
    	             params:{
    	            	 organizationId : orgId
     	        	 },
    	             success: function(form, action) {
    	            	 showSuccessMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('ORGINFOSUCCESS'));
//    	            	 addLogoWindow.close();
//    	            	 showSuccessMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
    	            	 /**
    	            	  * Check if the selected AL is the same as the current AL, Only then call to change the image in the header.
    	            	  */
    	             }
    	         });
    		}else{
    			photoFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    			return;
    		}
    		
    	}
    },
    onPageRender: function(component, options) {
        var this$ = this;
        var tabPanel = this$.getOrganizationstructure();
        var form = this.getOrganizationinfo();
        Ext.Ajax.request({
            method: 'GET',
            corsSupport: true,
            url: SERVERURL.ORGINFOLOADREQUEST,
            success: function(response) {
            	if(response.responseText!=null &&  response.responseText!=""){
	                var data = JSON.parse(response.responseText);
	                if(data.onUnloadMsgRequired){
	                	window.onbeforeunload = function() {
	                	    return "Are you sure you want to leave this page?";
	                	};
	                }
	                else{
	                	window.onbeforeunload = null;
	                }
	                
	                
	                var organization = new Academia.model.organization.OrganizationInfo(data);
	                form.getForm().findField('pageSize').setValue(data.pageSize.toString());
	                var orgSettings = data.organizationSettings;
	                var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	                /*
	                 * setting the value of the orgSetting dropdowns 
	                 */
	                //TODO : make generic
	                if (data.organizationSettings.length > 0) {
	                    var val = this$.findSettingValue('DF', orgSettings);
	                    if (val != null) {
	                        organization.data.date = val;
	                        orgModel.set('dateFormat',val);
	                    }
	                    var val1 = this$.findSettingValue('CF', orgSettings);
	                    if (val1 != null) {
	                        organization.data.currencyFormat = val1;
	                        orgModel.set('currencyFormat',val1);
	                    }
	                    var val2 = this$.findSettingValue('TF', orgSettings);
	                    if (val2 != null) {
	                        organization.data.timeFormat = val2;
	                        orgModel.set('timeFormat',val2);
	                    }
	                }
	                form.loadRecord(organization);
	                CONSTANTS.DEFAULT_PAGESIZE = data.pageSize.toString();
	                CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE = data.pageSize.toString();
	                tabPanel.items.each(function(c){c.setDisabled(false);});
	            }else{
	            	tabPanel.items.each(function(c){c.disable();});
	            	tabPanel.items.items[0].setDisabled(false);
	            }
                /*Ext.defer(function() {
                	this$.imageRestMethod();
    	        }, 500, this);*/
            },
            failure: function() {
            	showErrorMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('FAILURE'));
            }
        });
    },

    /**
     * @author Bhanu Pratap Singh
     */
   /* imageRestMethod:function() {
    	 var form = this.getOrganizationinfo();
    	 Ext.Ajax.request({
         	type: 'rest',
         	binary: true,
         	url: SERVERURL.PATH_PICK_BACKGROUND_IMAGE,
         	method: 'GET',
         	success: function(res, action) {
         		Ext.suspendLayouts();
         		if(res.status == 200){
         			var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
         			var url = window.URL.createObjectURL(blob);
         			form.down('#organizationBgImage').setVisible(false);
         			form.down('#organizationBgImage').getEl().dom.src=url;
         			form.down('#organizationBgImage').setVisible(true);
         		} else {
         			form.down('#organizationBgImage').setVisible(false);
         			form.down('#organizationBgImage').getEl().dom.src="resources/images/backgroundimageforschool.jpg";
         			form.down('#organizationBgImage').setVisible(true);
         		}
         		Ext.resumeLayouts();
         	}
         });
    },*/
    
    saveOrganization: function(button) {
    	var submitUrl;
    	var this$=this;
        var win = button.up('form');
        values = win.getForm().getValues();
        if (values.id == null ||values.id == "") {
            submitUrl = SERVERURL.ORGANIZATION_SAVE;
        } else {
            submitUrl = SERVERURL.ORGANIZATION_UPDATE;
        }
        
        Ext.Ajax.request({
            url: submitUrl,
            jsonData: values,
            method: 'POST',
            corsSupport: true,
            success: function(response) {
            	var organization= Academia.model.singleton.Organization;
            	if(response.responseText)
            		organization.id=response.responseText;
            	showSuccessMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('ORGINFOSUCCESS'));
            	//this$.saveOrganizationBackgroundImage(organization.id);
            	this$.onPageRender();
            }
        });
    },

    findSettingValue: function(key, orgSettings) {
        var retvalue = null;
        Ext.each(orgSettings, function(rec) {
            if (rec.setting.fieldCode.toLowerCase() === key.toLowerCase()) {
                retvalue = rec.value;
            }
        });
        return retvalue;
    }
});