/**
 * @author trupti.paoneker
 * 
 * This controller is used for Community Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.communitymaster.CommunityMasterController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['othermasters.communitymaster.CommunityMasterStore', 
             'Academia.store.othermasters.communitymaster.CommunityComboStore'],

    models: ['Academia.model.common.IdValueDataModel'],
    views: ['othermasters.communitymaster.CommunityMaster', 
            'othermasters.communitymaster.CommunityMasterGrid', 
            'othermasters.communitymaster.CommunityMasterFormWindow',
            'othermasters.communitymaster.CommunityMappingPanel','scholarship.scholarshipmaster.EligibilityCriteriaHyperLinkForm',
            'othermasters.communitymaster.CommunityMasterFilter'],

    alias: "widget.communityMastercontroller",

    refs: [{
        ref: 'communitymasterGrid',
        selector: 'communitymastergrid'
    }, {
        ref: 'wincommunitymasterformwindow',
        selector: 'communitymasterformwindow'
    }, {
        ref: 'frmcommunitymasterformwindow',
        selector: 'communitymasterformwindow form[itemId=communityMasterForm]'
    }, {
        ref: 'communityMaster',
        selector: 'communitymaster'
    }, {
        ref: 'communitymasterformwindow',
        selector: 'communitymasterformwindow'
    }, {
        ref: 'communitymappingpanel',
        selector: 'communitymappingpanel'
    },{
        ref: 'commonComponent',
        selector: 'communitymasterfilter'
    }],
    config: {
    	COMMUNITY_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMMUNITY_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'communitymastergrid': {
                render: function(component, options) {
                     component.getStore().load();
                }
            },
            'communitymastergrid[itemId=communityMasterGrid]': {
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getCOMMUNITY_MASTER_PERMISSIONS());
                }
            },
            'communitymastergrid button[itemId=btnAdd]': {
                click: this.addCommunityMaster
            },
            'communitymastergrid button[itemId=btnView]': {
                click: Ext.bind(this.editCommunityMaster, this, [true])
            },
            'communitymasterformwindow button[itemId=btnSaveCommunityMasterForm]': {
                click: this.saveCommunityMasterForm
            },
            'communitymasterformwindow button[itemId=btnCancelCommunityMasterForm]': {
                click: this.cancelCommunityMasterForm
            },
            'communitymastergrid button[itemId=btnDelete]': {
                click: this.deleteCommunityMasterForm
            },
            'communitymasterformwindow combo[itemId=ComunityCombo]': {
                select: this.loadCombo
            },
            
            'communitymappingpanel button#findButtonId':{
            	click : this.loadCommunityMasterGrid
            },
            'communitymasterfilter':{
            	render : function(obj) {
            		obj.down('#academyLocationComboField').getStore().load();
            		
            	}
            },
            'communitymasterfilter customcombobox[itemId=academyLocationComboField]': {
            	select : function(combo) {
            		var academyLocationId = combo.getValue();
            		var academyLocationIds = [];
            		academyLocationIds.push(academyLocationId);
            		var form = combo.up('communitymasterfilter');
            		var programCombo = form.down('#programCombo');
            		//this.resetOtherDropdowns(programCombo);
        			this.clearCombo(programCombo);
        			var batchCombo = form.down('#batchCombo');
        			this.clearCombo(batchCombo);
        			batchCombo.setDisabled(true);
        			var seatTypeCombo = form.down('#seatTypeCombo');
        			this.clearCombo(seatTypeCombo);
        			seatTypeCombo.setDisabled(true);
            		programCombo.setDisabled(false);
            		var programStore = programCombo.getStore();
            		programStore.getProxy().extraParams = {
                        academyLocationIds: academyLocationIds
                    };
            		programStore.load();
            	}
            },
            'communitymasterfilter customcombobox[itemId=programCombo]': {
                select: function(combo, records, eOpts) {
                	combo.nextSibling().setDisabled(false);
                    this.loadDependentCombo(combo.nextSibling(), records, 'id');
                },
                render: function(combo) {
                    var storeUrl='Academia.store.common.ProgramsByAcademyIdLocationId';
	              	  
	              	  var store = Ext.create(storeUrl);
                    combo.bindStore(store);
                    
                }
            },
            'communitymasterfilter customcombobox[itemId=batchCombo]': { 
            	select: function(combo, records, eOpts) {
            		combo.nextSibling().setDisabled(false);
            		this.loadDependentCombo(combo.nextSibling(), records, 'batchId');
            	},
            	render: function(combo) {
            		var store = Ext.create('Academia.store.common.BatchesByProgramId');
            		combo.bindStore(store);
            	}
            },
            
            'communitymasterfilter customcombobox[itemId=seatTypeCombo]': { 
            	select: function(combo, records, eOpts) {
            		combo.progBatchSeatConfigId =records[0].get('id');
            	},
            	render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            },
            'communitymappingpanel button[itemId=clearSearch]': { 
            	click : function() {
            		this.reset();
            		}
            },
        });
    },
    
    /**
     * this is used to load community master grid
     * @param button reference
     */
    loadCommunityMasterGrid : function(button){
    	var formValues = button.up('form').getValues();
    	var criteria=new Object();
    	if(formValues.academyLocation){
    		criteria.academyLocationId= formValues.academyLocation;
    	}
    	/*if(formValues.location){
    		criteria.locationId= formValues.location.id;
    	}*/
    	if(formValues.program){
    		criteria.programId= formValues.program;
    	}
    	if(formValues.batch){
    		criteria.batchId= formValues.batch;
    	}
    	if(formValues.seatType){
    		criteria.seatTypeId= formValues.seatType;
    	}
  		this.reloadGrid(criteria);
    },
    
    reloadGrid:function(criteria){
    	 var me = this;
         var grid = me.getCommunitymasterGrid();
         var store =grid.getStore();
    	store.load({
			params:criteria	
		});
    },
    
    addCommunityMaster: function() {
        var wincommunitymasterformwindow = Ext.widget('communitymasterformwindow');
        wincommunitymasterformwindow.show();
    },

    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },

    /**
     * This function is used for to show community Master Details Dialog box with values of selected record after clicking on edit button   
     */
    editCommunityMaster: function(isView) {
        var me = this;
        var grid = me.getCommunitymasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.showCommunityMasterForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmcommunitymasterformwindow = me.getFrmcommunitymasterformwindow();
                var rec = new Academia.model.othermasters.communitymaster.CommunityMasterModel(records[0].data);
//                var commonComponent = me.getCommonComponent();
//                this.loadCommonComponent(commonComponent,rec);
//                delete rec.data.location;
//                delete rec.data.seatType ;
//                frmcommunitymasterformwindow.loadRecord(rec);
//                grid.getStore().reload();
                frmcommunitymasterformwindow.down('#community').setValue(rec.get('community').value);
                frmcommunitymasterformwindow.down('#academyCombo').setValue(rec.get('academy').value);
                frmcommunitymasterformwindow.down('#locationCombo').setValue(rec.get('location').value);
                frmcommunitymasterformwindow.down('#programCombo').setValue(rec.get('program').value);
                frmcommunitymasterformwindow.down('#batchCombo').setValue(rec.get('batch').value);
                frmcommunitymasterformwindow.down('#seatTypeCombo').setValue(rec.get('seatType').value);
                if (isView) {
                    var wincommunitymasterformwindow = me.getWincommunitymasterformwindow();
                    wincommunitymasterformwindow.down('#btnSaveCommunityMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(frmcommunitymasterformwindow.getForm(), true);
                   
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    /**     
     * This function is used for to save community Master Details after clicking on save button    
     */
    saveCommunityMasterForm: function() {
        var this$ = this;
        var wincommunitymasterformwindow = this$.getWincommunitymasterformwindow();
        var refCommunityForm = this$.getFrmcommunitymasterformwindow();
        var grid = this$.getCommunitymasterGrid();
        var submitUrl = SERVERURL.COMMUNITY_MASTER_CREATE ; //URL-rest/communityLocation/create
        var jsonData = refCommunityForm.getValues();
        var seatType = new Object();
        seatType.id = refCommunityForm.down('combo#seatTypeCombo').valueModels[0].data.id;
        jsonData.seatType = seatType;
        var jsonFormatFormData = Ext.encode(jsonData);
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
                wincommunitymasterformwindow.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                showSuccessMessage(getCommonTranslation('COMMUNITY_MASTER'), getCommonTranslation('COMMUNITY_ADD_SUCCESS'));
            }

        });
    },
    
    cancelCommunityMasterForm: function() {
        this.getWincommunitymasterformwindow().close();
    },

    showCommunityMasterForm: function() {
        var communitymasterformwindow = this.getCommunitymasterformwindow();
        if (isEmpty(communitymasterformwindow)) {
            communitymasterformwindow = Ext.widget('communitymasterformwindow');
        }
        communitymasterformwindow.show();
    },

    deleteCommunityMasterForm: function() {
        var grid = this.getCommunitymasterGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
                  showConfirmMessage(getCommonTranslation('DELETE_COMMUNITY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                      if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                   url: SERVERURL.COMMUNITY_MASTER_DELETE + '?id=' + id, 				
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                        grdStore.reload();
                                        showSuccessMessage(getCommonTranslation('COMMUNITY_MASTER'), getCommonTranslation('DELETE_COMMUNITY_MSG'));
                                    }
                                   
                                });
                            }
                        }
                    }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
   /* loadCommonComponent : function(commonComponent,rec){
    	
    	var programCombo = commonComponent.down('#programCombo');
    	var batchCombo = commonComponent.down('#batchCombo');
    	var seatCombo = commonComponent.down('#seatTypeCombo');
    	
    	this.loadDependentComboById(programCombo, rec.get('location').id, 'locationId', 'academyId', rec.get('academy').id,rec.get('program').id) ;
    	this.loadDependentComboById(batchCombo, rec.get('program').id, 'id',null,null,rec.get('batch').id) ;
    	this.loadDependentComboById(seatCombo, rec.get('batch').id, 'batchId',null,null, rec.get('seatType').id) ;
    	
    },*/
    
   /* loadDependentComboById : function(dependentCombo, id, parameter, extraParameter, extraParamValue,value){
    	
//		 dependentCombo.clearValue();
//	     dependentCombo.store.removeAll();
	     var store = dependentCombo.getStore();
	   
	     var url = store.getProxy().proxyConfig.api.read;
	     if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
	         url = url.concat('?' + parameter + '=' + id);
	     } else {
	         url = url.concat('?' + parameter + '=' + id);
	         url = url.concat('&' + extraParameter + '=' + extraParamValue);
	     }
	     store.getProxy().api.read = url;
	     store.reload({
	    	 callback : function(){
	    		 dependentCombo.setValue(value);
	    	 }
	     });
    },*/
    
    loadDependentCombo: function(dependentCombo, selectedRecord, parameter, extraParameter, extraParamValue) {
    	
  	  var id = selectedRecord[0].get('id');
  	  
  	this.loadDependentComboById(dependentCombo, id, parameter, extraParameter, extraParamValue) ;
  }, 
  
  loadDependentComboById: function(dependentCombo, id, parameter, extraParameter, extraParamValue) {
  	var me = this; 
	this.resetOtherDropdowns(dependentCombo);
    dependentCombo.clearValue();
    dependentCombo.store.removeAll();
    var store = dependentCombo.getStore();
  
    var url = store.getProxy().proxyConfig.api.read;
    if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
        url = url.concat('?' + parameter + '=' + id);
    } else {
        url = url.concat('?' + parameter + '=' + id);
        url = url.concat('&' + extraParameter + '=' + extraParamValue);
    }
    store.getProxy().api.read = url;
    store.load({
    	callback : function(record){
    		if(!isNullOrEmpty(record) && record.length == 1) {
    			if(dependentCombo.name == 'seatType' ) {
    				dependentCombo.setValue(record[0].data.seatTypeId);
    			} else {
    				dependentCombo.setValue(record[0].data.id);
    				me.loadDependentCombo(dependentCombo.nextSibling(),record,'batchId');
    				dependentCombo.nextSibling().setDisabled(false);
    			}
    		}
    	}
    });
}, 

	resetOtherDropdowns: function(combo) {
		var container = combo.up('fieldcontainer');
		switch(combo.name) {
		case 'program':
			this.clearCombo(combo);
			batchCombo = container.down('combo[name=batch]');
			this.clearCombo(batchCombo);
			seatTypeCombo = container.down('combo[name=seatType]');
			this.clearCombo(seatTypeCombo);
			seatTypeCombo.setDisabled(true);
			break;
		case 'batch':
			this.clearCombo(combo);
			seatTypeCombo = container.down('combo[name=seatType]');
			this.clearCombo(seatTypeCombo);
			seatTypeCombo.setDisabled(true);
			break;
		case 'seatType':
			this.clearCombo(combo);
			break;
		}
	},
	clearCombo: function(combo) {
		combo.clearValue();
		combo.store.removeAll();
	},
	reset:function(){
		var form = this.getCommonComponent();
		var academyLocationCombo =form.down('customcombobox[name=academyLocation]');
		academyLocationCombo.reset();
		var programCombo =form.down('customcombobox[name=program]');
		var batchCombo =form.down('customcombobox[name=batch]');
		var seatCombo =form.down('customcombobox[name=seatType]');
		programCombo.setDisabled(true);
		batchCombo.setDisabled(true);
		seatCombo.setDisabled(true);
		programCombo.reset();
		batchCombo.reset();
		seatCombo.reset();
	}
});
