/**
 * This controller is used for the student, faculty common functionality.
 * @author Sachin.Bangar
 */
var grid = "";
Ext.define('Academia.controller.personinfo.common.PersonCommonController', {
	extend: 'Academia.controller.base.BaseController',

    views: ['baselayout.contentarea.ContentPanel',
    	'personinfo.common.ParentGuardianCardLayoutView',
    	'personinfo.common.ParentGuardianCardTpl',
    	'personinfo.faculty.familydetail.FacultyFamilyDetailCardLayoutView','personinfo.faculty.familydetail.FacultyFamilyDetailCardTpl'],

    alias: "widget.personcommoncontroller",

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref :'sendMessageWindow',
    	selector : 'sendmessagewindow[itemId=studentSendMessageWindowDashlet]'
    }],
    isProfilePicSaved: true, 
    init: function(application) {
    	var this$ = this;
    	this$.callParent(arguments); 
    },
    /**
     * Add person tab to content panel
     */
    
    addContentPanelTab: function(tabTitle, contentXtype, userId, personId, applicationId, admissionId, programBatchSeatTypeConfigId,closable, forEmployee,menuColorcls,alumniPersonId) {
    
    	this.loadContollers(contentXtype);
    	
    	if(isNullOrEmpty(closable)){
    		closable = true;
    	}
    	if(isNullOrEmpty(menuColorcls)){
    		menuColorcls=CONSTANTS.MENU_COLOR_SEVEN;
    	}
        var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
        var newTab = this.getTabReferenceByTabTitle(tabTitle);
        if (!newTab) {
            newTab = contentPanel.add({
                xtype: contentXtype,
                closable: closable,
                title: tabTitle,
                menuColorCls:menuColorcls,
                alumniPersonId: alumniPersonId
                
            });
            // This is used to get and set the student profile information
            this.applyConfigToPersonTab(newTab);
            newTab.setUserId(userId);
            newTab.setPersonId(personId);
            newTab.setApplicationId(applicationId);
            newTab.setAdmissionId(admissionId);
            newTab.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
            
            if(forEmployee == getCommonTranslation('OTHER_EMPLOYEE')) {
            	var facultyDetailLink = newTab.down('#facultyPersonDetailsLinkPanel');
            	facultyDetailLink.personType = 'OTHER_EMPLOYEE';
            	facultyDetailLink.initComponent();
            }
             contentPanel.setActiveTab(newTab);
                   if(contentXtype == "studentprofile"){
        	try{
            	var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
            	var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
            	var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
    			if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
    				var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
    				studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
    			}
        	}
        	catch(e){
        		//---
        	}
        }else if(contentXtype == "applicantprofile"){
        	try{
            	var applicantPortalController =  Academia.app.getController('Academia.controller.portal.ApplicantPortalController');
            	var applicantProfile = applicantPortalController.getTabReferenceByTabTitle(tabTitle);
            	var applicantPersonDetailsLinkPanel = applicantProfile.down('#applicantPersonDetailsLinkPanel');
    			if(!isNullOrEmpty(applicantPersonDetailsLinkPanel)){
    				var applicantLinkPanelObject = applicantPersonDetailsLinkPanel.getApplicantProfileLink();
    				applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);        	
    			}
        	}
        	catch(e){
        		//---
        	}
        }
        }
        contentPanel.setActiveTab(newTab);
    },
    
    addContentPanelTabWithSubTab: function(subtabXtype, tabTitle, contentXtype, userId, personId, applicationId, admissionId, programBatchSeatTypeConfigId,closable, forEmployee,menuColorcls) {
    	this.applyMask();
    	this.loadContollers(contentXtype);
    	
    	if(isNullOrEmpty(closable)){
    		closable = true;
    	}
    	if(isNullOrEmpty(menuColorcls)){
    		menuColorcls=CONSTANTS.MENU_COLOR_SEVEN;
    	}
        var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
        var newTab = this.getTabReferenceByTabTitle(tabTitle);
        if (!newTab) {
            newTab = contentPanel.add({
                xtype: contentXtype,
                subtabXtype: subtabXtype,
                closable: closable,
                title: tabTitle,
                menuColorCls:menuColorcls,
                isSubtabRequired: true
            });
            // This is used to get and set the student profile information
            this.applyConfigToPersonTab(newTab);
            newTab.setUserId(userId);
            newTab.setPersonId(personId);
            newTab.setApplicationId(applicationId);
            newTab.setAdmissionId(admissionId);
            newTab.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
            
            if(forEmployee == getCommonTranslation('OTHER_EMPLOYEE')) {
            	var facultyDetailLink = newTab.down('#facultyPersonDetailsLinkPanel');
            	facultyDetailLink.personType = 'OTHER_EMPLOYEE';
            	facultyDetailLink.initComponent();
            }
             contentPanel.setActiveTab(newTab);
              if(contentXtype == "studentprofile"){
        	try{
            	var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
            	var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
            	var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
    			if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
    				var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
    				studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);      
    				Ext.getBody().unmask();
    			}
        	}
        	catch(e){
        		//---
        	}
        }
        }
        contentPanel.setActiveTab(newTab);
        
      
    },
    
 // Function to apply the mask
    applyMask: function() {
    	if (!document.getElementById('fullscreen-mask')) {
    		var mask = document.createElement('div');
    		mask.id = 'fullscreen-mask';
    		mask.style.position = 'fixed';
    		mask.style.top = '0';
    		mask.style.left = '0';
    		mask.style.width = '100%';
    		mask.style.height = '100%';
    		mask.style.backgroundColor = 'rgba(0, 0, 0, 0.3)';
    		mask.style.zIndex = '99999999';
    		mask.style.display = 'flex';
    		mask.style.justifyContent = 'center';
    		mask.style.alignItems = 'center';

    		var msgDiv = document.createElement('div');
    		msgDiv.className = 'html-mask';
    		mask.appendChild(msgDiv);
    		document.body.appendChild(mask);
    	}
    },

    applyConfigToPersonTab : function(newTab){
    	
    	Ext.apply(newTab,{
        	personId: null,
        	userId: null,
        	applicationId: null,
        	admissionId: null,
        	personInfo: {},
        	applicationInfo: {},
        	applicationDataObject: {},
        	setPersonId: function(personId) {
        		newTab.personId = personId;
            },
            getPersonId: function() {
                return newTab.personId;
            },
            setUserId: function(userId) {
        		newTab.userId = userId;
            },
            getUserId: function() {
                return newTab.userId;
            },
            setPersonInfo: function(personInfo) {
            	newTab.personInfo = personInfo;
            },
            getPersonInfo: function() {
                return newTab.personInfo;
            },
            setApplicationId: function(applicationId) {
        		newTab.applicationId = applicationId;
            },
            getApplicationId: function() {
                return newTab.applicationId;
            },                
            setAdmissionId: function(admissionId) {
        		newTab.admissionId = admissionId;
            },
            getAdmissionId: function() {
                return newTab.admissionId;
            },
            setProgramBatchSeatTypeConfigId: function(programBatchSeatTypeConfigId) {
        		newTab.programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
            },
            getProgramBatchSeatTypeConfigId: function() {
                return newTab.programBatchSeatTypeConfigId;
            },
            setApplicationInfo: function(applicationInfo) {
            	newTab.applicationInfo = applicationInfo;
            },
            getApplicationInfo: function() {
                return newTab.applicationInfo;
            },
            setApplicationDataObject: function(applicationDataObject) {
            	newTab.applicationDataObject = applicationDataObject;
            },
            getApplicationDataObject: function() {
                return newTab.applicationDataObject;
            }
        });
    },
    /**
     * This method is used to add panel of person detail (student, applicant, faculty)
     */
    addPersonTabPanel : function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel, approveAdmissionButton,menuColorCls) {
        var me = this;
        
        if( isNullOrEmpty(approveAdmissionButton) ){
        	approveAdmissionButton = "Other_Button";
        }
        
    	me.loadContollers(tabPanelItemXtype);
        var personInfoTabPanel = me.getContentPanelActiveTab().down('personinfopanel');
        if(!isNullOrEmpty(personInfoTabPanel)){
            var innerPanel = personInfoTabPanel.down('#'+tabPanelItemId);
        }
        else {
        	var personInfoTabPanel = me.getContentPanel();
        	var nTab = personInfoTabPanel.items.findBy( function(tab) {
        		return tab.title === getPersonModuleTranslation(tabPanelTitle);
        	});
        	if(nTab){
        		nTab.close();
        	}
        }
        if (!innerPanel) {
        	if(defaultPanel==true){
        		if(tabPanelItemId=="studentParentGuardianDetails" && tabPanelItemXtype=="parentguardiangrid" && xtypeItemId=="studentParentGuardianGrid"){
        			innerPanel = personInfoTabPanel.add(Ext.create('Ext.form.Panel',{
                        itemId : tabPanelItemId,
                        title : getPersonModuleTranslation(tabPanelTitle),
                        closable : true,
                        cls:'panelNoSpace',
                        /*bodyStyle: {
                            overflow: 'auto !important'
                        },*/
                        items: [{
                            xtype: tabPanelItemXtype,
                            itemId : xtypeItemId,
                            personType : personType
                        },{
                        	xtype: 'parentguardiancardlayoutview'
                        }]
                    }));
        		}
        		else if(tabPanelItemId=="facultyFamilyDetails" && tabPanelItemXtype=="facultyfamilydetailgrid" && xtypeItemId=="facultyFamilyDetailGridItemId"){
        			innerPanel = personInfoTabPanel.add(Ext.create('Ext.form.Panel',{
                        itemId : tabPanelItemId,
                        title : getPersonModuleTranslation(tabPanelTitle),
                        closable : true,
                        cls:'panelNoSpace',
                        /*bodyStyle: {
                            overflow: 'auto !important'
                        },*/
                        items: [{
                            xtype: tabPanelItemXtype,
                            itemId : xtypeItemId,
                            personType : personType
                        },{
                        	xtype: 'facultyfamilydetailcardlayoutview'
                        }]
                    }));
        		}
        		else {
        			innerPanel = personInfoTabPanel.add(Ext.create('Ext.form.Panel',{
                        itemId : tabPanelItemId,
                        title : getPersonModuleTranslation(tabPanelTitle),
                        closable : true,
                        cls:'panelNoSpace',
                        menuColorCls:menuColorCls,
                        /*bodyStyle: {
                            overflow: 'auto !important'
                        },*/
                        items: [{
                            xtype: tabPanelItemXtype,
                            itemId : xtypeItemId,
                            personType : personType,
                            approveAdmissionButton : approveAdmissionButton
                        }]
                    }));
        		}
        	}else{
        		innerPanel = personInfoTabPanel.add({
                    xtype: tabPanelItemXtype,
                    itemId : tabPanelItemId,
                    personType : personType,
                    approveAdmissionButton : approveAdmissionButton
                });
        	}
            
        }
        
        if(personType == 'APPLICANT')
        {
        	var verifyDetailBtn = innerPanel.down("#verifyDetail");

        	if(verifyDetailBtn)
        	{
        		verifyDetailBtn.setDisabled(true);
        	}
        }
        me.getContentPanelActiveTab().personType  =personType;
        personInfoTabPanel.setActiveTab(innerPanel);
    },
    
    setDisabledPersonDetailsLinkPanel : function(visibleStatus){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personDetailsLinkPanel = personProfile.down('persondetailslinkpanel');
    	Ext.each(personDetailsLinkPanel.items.items, function(panel){
    		panel.setDisabled(visibleStatus);
    	});
    },
    
    getEnabledPersonalInformationLinkPanel : function(){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var panel = personProfile.down('persondetailslinkpanel').down('#PERSONAL_INFORMATION');
    	panel.setDisabled(false);
    },
    getContentPanelActiveTab: function() {
    	var this$ = this;
        var personProfile = null;
        var controller = this$.getController('Academia.controller.personinfo.common.PersonCommonController');
        var contentPanel = controller.getContentPanel();
        if (contentPanel) {
            personProfile = contentPanel.getActiveTab();
        }
        return personProfile;
    },
    getPersonObj : function(){
    	var this$ = this;
    	var personObj = new Object();
    	var personProfile = this$.getContentPanelActiveTab();
    	if(personProfile){
    		if(this$.getCurrentLoggedPortalId()==6){
        		personObj.id = this$.getCurrentlyLoggedInUserWithPersonId().personId;
        		personObj.personType = 'APPLICANT';
    		} else if(this$.getCurrentLoggedPortalId()==7){
        		personObj.id = this$.getCurrentlyLoggedInUserWithPersonId().personId;
    		}else if(this$.getCurrentLoggedPortalId()==3){
    		    personObj.id = this$.getCurrentlyLoggedInUserWithPersonId().personId;
        		personObj.personType = 'STUDENT' ;
    		}else {
    			var personInfo = personProfile.getPersonInfo();
    			personObj.id = personInfo.id;
    			personObj.personType = personInfo.personType;
    		}
    	}
    	return personObj;
    },
    getUserInfo : function(){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	if(personProfile){
    		var userInfo = personProfile.getUserId();
    	}
    	return userInfo;
    },
    changeNameFieldConfig: function(combo) {
        var nameField = combo.up('form').down('#selectedName');
        if (nameField != undefined) {
            nameField.setFieldLabel(combo.getRawValue());
            nameField.name = combo.getValue();
            nameField.applyEmptyText();
        }
    },
    getMenuController: function() {
        return Academia.app.getController('menu.CoreERPNavigationController');
    },
    /**
     * This method is used to clear request type combo on student List & FAculty list
     * @param btn
     */
    onClickClearRequestTypeCombo: function(btn) {
        var this$ = this;
        var form = btn.up('form');
        var record = this$.getRequestTypeRecord(btn);
        if(record !==false){
              if (record.get("value") === 'EXAM_RELATED' || record.get("value") === 'OTHER') {
              	form.down('#serviceRequestCombo').clearValue();
              } else {
              	form.down('#serviceRequestCategoryCombo').clearValue();
              }
        }
    },
    /**
     * This is used to get record of requestType combo on student List & FAculty list
     *  @param btn
     *  @return record
     */
    getRequestTypeRecord: function(btn) {
        var form = btn.up('form');
        var requestTypeComboField = form.down('#serviceRequestCategoryCombo');
        var value = requestTypeComboField.getValue();
        var record = requestTypeComboField.findRecordByValue(value);
        return record;
    },
    
    /**
     * method to return the reference of the content panel.
     * added for providing the reference of the content panel when personCommonController is added
     * as mixin in another controller.
     * in above case PPC does not get the reference of the content panel from the ref:[] array.
     */
    getContentPanel: function() {
    	var viewport = Ext.ComponentQuery.query('vp2')[0];
    	return viewport.down('contentPanel');
    },
    loadMarkEntry: function(entryController,selectedRecord, academyLocationId){
    	var this$ = entryController;
    	var portalId = this.getCurrentLoggedPortalId();
    	var form;
    	if(portalId == 2) {
    		entryController = Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController');
    		this$=entryController;
    		form = this$.getFacultyevaluationplanfilter().getForm();
    	} else {
    		form = this$.getEvaluationplanfilter().getForm();
    	}
    	
    	var formValue = form.getValues();
    	/*var courseField = form.findField('course_name');
    	courseField.getStore().getProxy().extraParams = {
			facultyId: this$.getCurrentlyLoggedInUser().id,
			academyLocationId:this$.getCurrentAcademyLocation()
		};
    	courseField.getStore().load({
			callback: function(records, operation, success) {
    	courseField.setValue(selectedRecord.get('courseId'));
    	if(!isNullOrEmpty(selectedRecord.get('childCourseId'))){
    		courseField.setValue(selectedRecord.get('childCourseId'));
    	}
			}
		});*/
    	var plan = form.findField('evalautionPlan'); 
    	var courseVariant = form.findField('courseVariant');
    	var academicTerm = form.findField('academicTerm');
		var event = form.findField('detailSequence');
    	academicTerm.reset();
    	courseVariant.enable();
    	plan.reset();
    	plan.setDisabled(false);
		var portalId = this$.getCurrentLoggedPortalId();
    	var facultyId = this$.getCurrentlyLoggedInUser();
		var variantStore = courseVariant.getStore();
	/*	Ext.each(academicTerm.getStore().data.items, function(value) {
							if(value.get('id')==selectedRecord.data.academicTermId){
								academicTerm.reset();
								academicTerm.setValue(value.get('id'));
							}
		});*/
		
		
		academicTerm.getStore().load({
			callback:function(records){
				Ext.each(records,function(rec){
					if(rec.get('id')==selectedRecord.data.academicTermId){
						academicTerm.reset();
						academicTerm.setValue(rec.get('id'));
					}
				});
			}
		});
    	/*var courseId = selectedRecord.get('courseId');
    	if(!isNullOrEmpty(selectedRecord.get('childCourseId'))){
    		courseId = selectedRecord.get('childCourseId');
    	}*/

		if(portalId == 2) {
    						//variantStore.getProxy().api.read=SERVERURL.LOAD_COURSE_FOR_FACULTY;
    						variantStore.getProxy().extraParams = {
    							facultyId: facultyId.id,
    							courseId:selectedRecord.get('courseId'),
    							//evaluationPlanId:records[0].data.id,
    							courseVariantId:selectedRecord.get('courseVariantId')
    						};
    					} else {
    						variantStore.getProxy().extraParams = {
    							evaluationPlanId:records[0].data.id,
    							//courseId:selectedRecord.get('courseId'),
    							academyLocationId:academyLocationId,
    						};
					    					}
					
							setTimeout(function(){
					
					
								variantStore.load({
									callback: function(records, operation, success) {
										Ext.each(records,function(rec){
											if(rec.get('id')== selectedRecord.get('courseVariantId')){
												courseVariant.setValue(selectedRecord.get('courseVariantId'));
											}
										});
										//	courseVariant.setValue(selectedRecord.get('courseVariantId'));
					
										plan.setValue(records[0].data.id);
										event.setDisabled(false);
					
										form.findField('isDynamicScheme').setValue(records[0].data.code);
										var facManEvalResController=  Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController');
										if(records[0].data.secondCheck){
											facManEvalResController.permissionManagementForEvaluaionPlanFilterOnlyForAnonymousEventForFaculty(facManEvalResController.getFacultyevaluationplanfilter(), facManEvalResController.getFACULTY_MARK_ENTRY_PERMISSION());
										} else {
											facManEvalResController.getFacultyevaluationplanfilter().down('#anonymousEvent').
											setVisible(false);
										}
					
					
										/*	if(portalId == 2) {
								//variantStore.getProxy().api.read=SERVERURL.LOAD_COURSE_FOR_FACULTY;
								variantStore.getProxy().extraParams = {
									facultyId: facultyId.id,
									courseId:selectedRecord.get('courseId'),
									//evaluationPlanId:records[0].data.id,
									courseVariantId:selectedRecord.get('courseVariantId')
								};
							} else {
								variantStore.getProxy().extraParams = {
									evaluationPlanId:records[0].data.id,
									//courseId:selectedRecord.get('courseId'),
									academyLocationId:academyLocationId,
								};
							}
							variantStore.load({
								callback: function(records, operation, success) {
									courseVariant.setValue(selectedRecord.get('courseVariantId'));
								}
							});*/
					
					
										var evalPlanLevelField=form.findField('evalPlanLevelId');
										evalPlanLevelField.enable();
										evalPlanLevelField.reset();
										evalPlanLevelField.getStore().getProxy().extraParams = {
											evaluationPlanId:records[0].data.id,
											isStatus:false
										};
										evalPlanLevelField.getStore().load();
					
										event.getStore().getProxy().extraParams = {
											evalPlanId:form.findField('evalautionPlan').getValue(),
											rmAnonEvent:formValue.anonymousEvent,
											isDynamicScheme:records[0].data.code,
											courseVariantId:selectedRecord.get('courseVariantId'),
										};
										event.getStore().load();
									}		 
								});
							},500);
					
					
					
					


    /*	
    	plan.getStore().getProxy().extraParams = {
    		evaluationPlantype : getExaminationTranslation('CNTRL_ACADEMICS') ,
    		evaluationStage : 'COURSE_EXECUTION',
    		academyLocationId : this$.getCurrentAcademyLocation(),
    		//courseId : courseId,
    		courseVariantId : selectedRecord.get('courseVariantId')
    	};*/
    	//plan.reset();
    	
    /*	plan.getStore().load({
    		callback: function(records, operation, success) {
    			if (success) {
    				
    				if(records.length == 1){
    					academicTerm.reset();
    					plan.setValue(records[0].data.id);
    					event.setDisabled(false);
						var variantStore = courseVariant.getStore();
    					form.findField('isDynamicScheme').setValue(records[0].data.code);
    					var facManEvalResController=  Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController');
    					if(records[0].data.secondCheck){
    						facManEvalResController.permissionManagementForEvaluaionPlanFilterOnlyForAnonymousEventForFaculty(facManEvalResController.getFacultyevaluationplanfilter(), facManEvalResController.getFACULTY_MARK_ENTRY_PERMISSION());
    					} else {
    						facManEvalResController.getFacultyevaluationplanfilter().down('#anonymousEvent').
    						setVisible(false);
    					}
	
						Ext.each(academicTerm.getStore().data.items, function(value) {
							if(value.get('id')==selectedRecord.data.academicTermId){
								academicTerm.reset();
								academicTerm.setValue(value.get('id'));
							}
						});
					/*	if(portalId == 2) {
    						//variantStore.getProxy().api.read=SERVERURL.LOAD_COURSE_FOR_FACULTY;
    						variantStore.getProxy().extraParams = {
    							facultyId: facultyId.id,
    							courseId:selectedRecord.get('courseId'),
    							//evaluationPlanId:records[0].data.id,
    							courseVariantId:selectedRecord.get('courseVariantId')
    						};
    					} else {
    						variantStore.getProxy().extraParams = {
    							evaluationPlanId:records[0].data.id,
    							//courseId:selectedRecord.get('courseId'),
    							academyLocationId:academyLocationId,
    						};
    					}
    					variantStore.load({
							callback: function(records, operation, success) {
								courseVariant.setValue(selectedRecord.get('courseVariantId'));
							}
						});*/
	
    				/*
    					var evalPlanLevelField=form.findField('evalPlanLevelId');
					    evalPlanLevelField.enable();
					    evalPlanLevelField.reset();
					    evalPlanLevelField.getStore().getProxy().extraParams = {
					    	evaluationPlanId:records[0].data.id,
							isStatus:false
	   				    };
					    evalPlanLevelField.getStore().load();
    					var portalId = this$.getCurrentLoggedPortalId();
    					var facultyId = this$.getCurrentlyLoggedInUser();
	
						event.getStore().getProxy().extraParams = {
    						evalPlanId:form.findField('evalautionPlan').getValue(),
    						rmAnonEvent:formValue.anonymousEvent,
    						isDynamicScheme:records[0].data.code,
    						courseVariantId:selectedRecord.get('courseVariantId'),
    					};
    					event.getStore().load();
    				}		 
    			}
    		}	   
    	});  */
    	Ext.apply(form,{
 		   isLongDistance:null,
 		  setLongDistance : function(isLongDistance){
 			 form.isLongDistance = isLongDistance;
 		  },
 		  getLongDistance:function(){
 			  return form.isLongDistance;
 		  }
 	  });
		/*var sectionsId = form.findField('sectionsId');
		var cvIds=[];
		cvIds.push(selectedRecord.get('courseVariantId'));
		sectionsId.reset();
		sectionsId.setDisabled(false);
		sectionsId.getStore().getProxy().extraParams = {
			courseVariantIds:cvIds.join()
		};
		sectionsId.getStore().load({
			callback: function(records, operation, success) {
				var arr = [];
				for(var i in records){
					arr.push(records[i].data.id);
				}
				sectionsId.setValue(arr);
			}
		});*/
    },
    loadMarkAttendance : function(attendanceController, selectedRecord, academyLocationId, facultyId, studentAttendanceType){
    	var this$ = attendanceController;
    	var attendanceTypeRadio=this$.getStudentcaptureattendancestructure().down('#newAttendanceTypeRadio');
    	var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
    	if(studentAttendanceType=="COURSE_LEVEL"){
    		attendanceTypeRadio.items.items[0].setValue(false);
    		attendanceTypeRadio.items.items[1].setValue(true);
    		attendanceTypeRadio.items.items[2].setValue(false);
    	}
    	var courseVariantId = selectedRecord.get('courseVariantId');
    	var facultyId = this.getCurrentlyLoggedInUser().id;
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var form = this$.getCoursewisecaptureattendancesearch();
    	var courseVariantField = this$.getCoursewisecaptureattendancesearch().down('#courseVariantId');
    	var courseVariantFieldStore = courseVariantField.getStore();
    	courseVariantFieldStore.getProxy().extraParams = {
    		academyLocationIds:academyLocationId,
			facultyId:facultyId,
			isCurrentPeriod:true
    	};
    	courseVariantFieldStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				Ext.defer(function(){
    					try{
    						var record = courseVariantFieldStore.findRecord('id', courseVariantId).data;
        					courseVariantField.setValue(record.id);
        					if(attendanceTypess.data.COURSE_LEVEL.attendanceSlot=="TIME_TABLE_SLOTS"){
        						var timetableSlotField = form.down('#timetableSlotListId');
        						timetableSlotField.setDisabled(false);
        						timetableSlotField.clearValue();
        						timetableSlotField.allowBlank=false;
        	        			var timetableSlotFieldStore = timetableSlotField.getStore();
        	        			timetableSlotFieldStore.load({
        							callback: function(record, operation, success) {
        								if (success) {
        									if(record.length == 1){
        										timetableSlotField.setValue([record[0].data.id]);
        										timetableSlotField.setValue([record[0].data.id]);
        										form.down('#fromTime').clearValue();
        										form.down('#toTime').clearValue();
        										form.down('#dateOfAttendance_Id').setDisabled(true);
        										form.down('#fromTime').setDisabled(true);
        										form.down('#toTime').setDisabled(true);
        										form.down('#fromTime').allowBlank=true;
        										form.down('#toTime').allowBlank=true;
        										form.down('#dateOfAttendance_Id').allowBlank=true;
        										form.down('#timeBtnAdd').setDisabled(true);
        										this$.loadCaptureAttendanceStudentGrid();
        									}
        								}
        							}
        						});
        					}
    					}catch(e){
    						
    					}
    				}, 500, this);
    			}
    		}
    	});

    },
    loadAssignments : function(assignmentController, selectedRecord, facultyId){
    	var this$ = assignmentController;
    	var form = this$.getFacultyhomeworkassignmentsearch();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		var periodField = form.down('#facultyperiodId');
		var courseField = form.down('#faculty_course_Id');
		var courseVariantField = form.down('#facultycourseVarient_Id');
		var facultyId = this.getCurrentlyLoggedInUser().id;
		var academyLocationId = this.getCurrentAcademyLocation();
		if(wheatherSchool){
			periodField.hide();
		}
		var acdemicTerm = form.down('#facultyacademicTerm');
		var academicTermStore = acdemicTerm.getStore();
		academicTermStore.load({
			callback: function(records, operation, success) {
				if (success) {
					for(var i in records){
						if(records[i].data.whetherCurrentAcademicTerm == 'true' || records[i].data.whetherCurrentAcademicTerm) {
							var academicTermId = records[i].data.id;
							acdemicTerm.setValue(records[i].data.id);
							var courseStore = courseField.getStore();
							courseStore.getProxy().extraParams = {
								academyLocationId: academyLocationId,
								facultyId: facultyId,
								sectionType: "ALL",
								isCurrentPeriod:false,
								academicTermId:academicTermId
							};
							courseStore.load({
								callback: function(records, operation, success) {
									if (success) {
										for(var i in records){
											if(selectedRecord.get('courseId') == records[i].get('courseId') || selectedRecord.get('childCourseId') == records[i].get('courseId')) {
												courseField.setValue(records[i].get('courseId'));
												var courseVariantStore = courseVariantField.getStore();
												courseVariantStore.getProxy().extraParams = {
													academyLocationId: academyLocationId,
													facultyId: facultyId,
													isCurrentPeriod:false,
													academicTermId:academicTermId,
													courseId:records[i].get('courseId')
												};
												courseVariantStore.load({
													callback: function(records, operation, success) {
														if (success) {
															for(var i in records){
																if(selectedRecord.get('courseVariantId') == records[i].get('id')) {
																	courseVariantField.setValue(records[i].get('id'));
																}
															}
														}
													}
												});
											}
										}
									}
								}
							});
						}
					}
				}
			}
		});
    },
    loadSessionReport : function(sessionController,selectedRecord, facultyId){
    	var this$ = sessionController;
    	var form = this$.getCoursesessiondiaryfilter().getForm();
    	var courseField = form.findField('courseId');
    	var programField = form.findField('PROGRAM');
    	var batchField = form.findField('BATCH');
    	var periodField = form.findField('PERIOD');
    	var sectionField = form.findField('sectionId');
    	var CoursesStore = this$.getStore('attendance.AssignedCoursesFacultyStore');
    	CoursesStore.getProxy().extraParams = {
    		academyLocationId:this$.getCurrentAcademyLocation(),
    		facultyId : facultyId
    	};
    	CoursesStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				for(var i = 0 ;i<=records.length-1;i++){
    					if(records[i].data.courseId==selectedRecord.get('courseId')){
    						courseField.setValue(records[i].data.courseId);
    						if(records[i].data.sectionType=="ProgramBatchSection"){
    							programField.setValue(selectedRecord.get('programId'));
    							batchField.setDisabled(false);
    							var store = this$.getStore('enquiry.AcademicBatchStore');
    							store.getProxy().extraParams = {
    								id : selectedRecord.get('programId')
    							};
    							store.load();
    							batchField.setValue(selectedRecord.get('batchId'));
    							periodField.setDisabled(false);
    							var periodStore = periodField.getStore();
    							periodStore.getProxy().extraParams = {
    								id: selectedRecord.get('batchId')
    							};
    							periodStore.load();
    							periodField.setValue(selectedRecord.get('periodId'));
    							sectionField.setDisabled(false);
    							var sectionStore = sectionField.getStore();
    							sectionStore.getProxy().extraParams = {
    								periodId:selectedRecord.get('periodId')
    							};
    							sectionStore.load({
    						    		callback: function(records, operation, success) {
    						    			if (success) {
    						    				this$.loadCourseSessionDiaryGrid(selectedRecord.get('courseVariantId'));
    						    			}
    						    		}
    							});
    							sectionField.setValue(selectedRecord.get('sectionId'));
    						}else{
    							if(!records[i].data.sectionAtComponentLevel){
    								form.findField('sectionId').setVisible(false);
    								var sectionCombo = form.findField('courseSectionId');
    								sectionCombo.setVisible(true);
    								sectionCombo.setDisabled(false);
    								sectionCombo.clearValue();
    								var sectionStore = sectionCombo.getStore();
    								sectionStore.getProxy().extraParams = {
    									parentCourseId:records[i].data.courseId,
    									sectionAtComponentLevel:records[i].data.sectionAtComponentLevel
    								}
    								sectionStore.load({
    									callback: function(records, operation, success) {
	                						   if (success) {
	                							   sectionCombo.setValue(selectedRecord.get('sectionId'));
	                							   this$.loadCourseSessionDiaryGrid(selectedRecord.get('courseVariantId'));
	                						   }
    									}
    								});
    							}else{
    								form.findField('sectionId').setVisible(false);
    								form.findField('courseSectionId').setVisible(false);
    								form.findField('componentId').setVisible(true);
    								var componentCombo = form.findField('componentId');
    								var componentStore = componentCombo.getStore();
    								var courseId = records[i].data.courseId;
    								componentStore.getProxy().extraParams = {
    									courseId:records[i].data.courseId
    								}
    								componentStore.load({
    									callback: function(records, operation, success) {
    										if (success) {
    											for(var i = 0 ;i<=records.length-1;i++){
    												if(records[i].data.id==selectedRecord.get('componentId')){
    													form.findField('componentId').setValue(records[i].data.id);
    													var sectionComboBox = form.findField('courseSectionId');
    													   sectionComboBox.setDisabled(false);
    					                				   sectionComboBox.setVisible(true);
    					                				   sectionComboBox.clearValue();
    					                				   var sectionStore = sectionComboBox.getStore();
    					                				   sectionStore.getProxy().extraParams = {
    					                					   parentCourseId:courseId,
    					                					   componentId:records[i].data.id,
    					                					   sectionAtComponentLevel:true
    					                				   };
    					                				   sectionStore.load({
    					                					   callback: function(records, operation, success) {
    					                						   if (success) {
    					                							   sectionComboBox.setValue(selectedRecord.get('sectionId'));
    					                							   this$.loadCourseSessionDiaryGrid();
    					                						   }
    					                					   }
    					                				   });
    												}
    											}
    										}
    									}
    								});
    							}
    						}
    					}
    				}
    			}
    		}
    	});
    },
    loadCompleteDayMarkAttendance : function(attendanceController, sectionId){
    	var this$ = attendanceController;
    	var facultyId = this.getCurrentlyLoggedInUser().id;
    	var academyLocatioId = this.getCurrentAcademyLocation();
    	var date = new Date();
    	var programWiseSearch = this$.getProgramwisecaptureattendancesearch();
    	var sessionWiseSearch = this$.getMultiplesessionwisecaptureattendancesearch();
    	var programByAcademyLocationStore = programWiseSearch.down('#facultyAttendanceProgramId').getStore();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
    	programByAcademyLocationStore.getProxy().extraParams = {
    		academyLocationIds:academyLocationId,
    		facultyId:facultyId,
    		onlyCurrentRecords:true,
    		wheatherSchool:wheatherSchool
    	};
    	programByAcademyLocationStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				Ext.defer(function(){
    					var record = programByAcademyLocationStore.findRecord('sectionId', sectionId).data;
    					programWiseSearch.down('#facultyAttendanceProgramId').setValue(record.sectionId);
    					sessionWiseSearch.down('#session_programBatch_programId').setValue(record.sectionId);
    					this$.loadCaptureAttendanceStudentGrid();
    				}, 500, this);
    			}
    		}
    	});
    },
    getProfileAddressPrivileges: function(gridreference, permissionMap) {
    	if(!isNullOrEmpty(gridreference)){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    	if(this.getCurrentLoggedPortalId() == 3){
    		var comboStore = gridreference.down('#addressCombo').getStore();
        	
        	var permissions = {
        		    "SELF_ADDRESS": true,
        		    "FATHER_ADDRESS": false,
        		    "MOTHER_ADDRESS": false,
        		    "GUARDIAN_ADDRESS": false,
        		    "LOCAL_GUARDIAN_ADDRESS": false
        		};
        	
        	for (var i = 0; i < permissionList.length; i++) {
        	    var permission = permissionList[i];
        	    if (permissions[permission] !== undefined) {
        	        permissions[permission] = true;
        	    }
        	}
    			
    			if (comboStore !== null) {
    			    var itemsToRemove = [];
    			    for (var i = 0; i < comboStore.data.items.length; i++) {
    			        var item = comboStore.data.items[i];
    			        var itemId = item.data.id;
    			        if (!permissions[itemId]) {
    			            itemsToRemove.push(item);
    			        }
    			    }
    			    
    			    for (var i = 0; i < itemsToRemove.length; i++) {
    			        comboStore.remove(itemsToRemove[i]);
    			    }
    			  
    			}
    		
        	var currentAddress  = gridreference.down('#currentAddressPanel');
        	currentAddress.setVisible(false);
        	var correspondanceAddress = gridreference.down('#addressForCorrespondance');
        	correspondanceAddress.setVisible(false);
        	var permanentAddress = gridreference.down('#permanentAddressPanel');
        	permanentAddress.setVisible(false);
        	var officeAddress =  gridreference.down('#officeAddressPanel');
        	officeAddress.setVisible(false);
        	var googleAddress =  gridreference.down('#googleAddressPanel');
        	googleAddress.setVisible(false);
    	} else if(this.getCurrentLoggedPortalId() == 2){
    		var googleAddress =  gridreference.down('#googleAddressPanel');
        	googleAddress.setVisible(false);
    	}
        var modifyPersonalAddress1 = gridreference.down('button#modifyPersonalAddress1');
        var modifyPersonalAddress2 = gridreference.down('button#modifyPersonalAddress2');
        var modifyPersonalAddress3 = gridreference.down('button#modifyPersonalAddress3');
        var modifyPersonalAddress4 = gridreference.down('button#modifyPersonalAddress4');
        var modifyPersonalAddress5 = gridreference.down('button#modifyPersonalAddress5');
        
        modifyPersonalAddress1.setVisible(false);
        modifyPersonalAddress2.setVisible(false);
        modifyPersonalAddress3.setVisible(false);
        modifyPersonalAddress4.setVisible(false);
        modifyPersonalAddress5.setVisible(false);
         
     	Ext.each(permissionList, function(privilege) {
     			if (privilege === 'CURRENT_ADDRESS') {
        			if(!isNullOrEmpty(currentAddress)){
        				currentAddress.setVisible(true);
        			}        		
        		}
        		if (privilege === 'ADDRESS_FOR_CORRESPONDANCE') {
        			if(!isNullOrEmpty(correspondanceAddress)){
        				correspondanceAddress.setVisible(true);
        			}    
        			
        		}
        		if (privilege === 'PERMANENT_ADDRESS') {
        			if(!isNullOrEmpty(permanentAddress)){
        				permanentAddress.setVisible(true);
        			}        		
        		}
        		if (privilege === 'OFFICE_ADDRESS') {
        			if(!isNullOrEmpty(officeAddress)){
        				officeAddress.setVisible(true);
        			}        		
        		}
        		if (privilege === 'GOOGLE_ADDRESS') {
        			if(!isNullOrEmpty(googleAddress)){
        				googleAddress.setVisible(true);
        			}        		
        		}
     		
    		if (privilege === 'CREATE') {
    			if(!isNullOrEmpty(modifyPersonalAddress1) && !isNullOrEmpty(modifyPersonalAddress2) && !isNullOrEmpty(modifyPersonalAddress3) && !isNullOrEmpty(modifyPersonalAddress4) && !isNullOrEmpty(modifyPersonalAddress5)){
    				//if(modifyPersonalAddress1.address.isModify == false) {
    					modifyPersonalAddress1.setVisible(true);
    				//}
    				//if(modifyPersonalAddress2.address.isModify == false) {
    					modifyPersonalAddress2.setVisible(true);
    				//}
    				//if(modifyPersonalAddress3.address.isModify == false) {
    					modifyPersonalAddress3.setVisible(true);
    				//}
    				//if(modifyPersonalAddress4.address.isModify == false) {
    					modifyPersonalAddress4.setVisible(true);
    				//}
    				//if(modifyPersonalAddress5.address.isModify == false) {
    					modifyPersonalAddress5.setVisible(true);
    				//}
    			}        		
    		} else if (privilege === 'UPDATE') {
    			if(!isNullOrEmpty(modifyPersonalAddress1) && !isNullOrEmpty(modifyPersonalAddress2) && !isNullOrEmpty(modifyPersonalAddress3) && !isNullOrEmpty(modifyPersonalAddress4) && !isNullOrEmpty(modifyPersonalAddress5)){
    				//if(modifyPersonalAddress1.address.isModify == true) {
    					modifyPersonalAddress1.setVisible(true);
    				//}
    				//if(modifyPersonalAddress2.address.isModify == true) {
    					modifyPersonalAddress2.setVisible(true);
    				//}
    				//if(modifyPersonalAddress3.address.isModify == true) {
    					modifyPersonalAddress3.setVisible(true);
    				//}
    				//if(modifyPersonalAddress4.address.isModify == true) {
    					modifyPersonalAddress4.setVisible(true);
    				//}
    				//if(modifyPersonalAddress5.address.isModify == true) {
    					modifyPersonalAddress5.setVisible(true);
    				//}
    			}        		
    		}
    	});
    	}
    },
    loadSessionReportFacultyPortal : function(sessionController,selectedRecord, facultyId){
    	var this$ = sessionController;
    	var courseSessionDiaryForm =  this$.getCoursesessiondiaryfacultyportalfilter();
    	var courseVariantId = selectedRecord.get('courseVariantId');
		var courseId = selectedRecord.get('courseId');
		var programId = selectedRecord.get('programId');
		var batchId = selectedRecord.get('batchId');
		var sectionId = selectedRecord.get('sectionId');
		var periodId = selectedRecord.get('periodId');

	   var academicTermField = courseSessionDiaryForm.down("#academicTerm");
  	   var courseVariantField = courseSessionDiaryForm.down("#courseVariantId");
  	   var programField = courseSessionDiaryForm.down("#programItemId");
  	   var batchField = courseSessionDiaryForm.down("#batchItemId");
  	   var periodField = courseSessionDiaryForm.down("#periodItemId");
  	   var sectionField = courseSessionDiaryForm.down("#sectionItemId");
  	   
  	   academicTermField.reset();
  	   courseVariantField.reset();
  	   programField.reset();
	   batchField.reset();
	   periodField.reset();
	   sectionField.reset();
	   
		var academicTerm = courseSessionDiaryForm.down('#academicTerm');
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool){
			courseSessionDiaryForm.down("#periodItemId").hide();
		}else{
			courseSessionDiaryForm.down("#periodItemId").setVisible(true);
		}
	    var academyLocationIds = this.getCurrentAcademyLocation();
	    var facultyId = this.getCurrentlyLoggedInUser().id;
	    if(selectedRecord.get('courseVariantId')!=null&&facultyId!=null&&academyLocationIds!=null){
				var data='?facultyId='+facultyId+'&courseVariantId='+selectedRecord.get('courseVariantId')+'&academyLocationId='+academyLocationIds;
				var uniqCheckUrl=SERVERURL.PATH_GET_ACADEMICTERM_BY_COURSEVARIANT+data;
				Ext.Ajax.request({
					 type: 'rest',
					 url: uniqCheckUrl,
					 method: 'GET',
					 success: function(resp, action) {
						 var objAcademicTerm = Ext.decode(resp.responseText);
						 if(!isNullOrEmpty(objAcademicTerm)){
							 courseSessionDiaryForm.down("#academicTerm").setValue(objAcademicTerm.id);
						 }
									
					 }
				 });
			}
	    if(selectedRecord.get('courseVariantId')!=null&&facultyId!=null&&academyLocationIds!=null){
			var data='?id='+selectedRecord.get('courseVariantId');
			var uniqCheckUrl=SERVERURL.COURSE_BY_COURSE_VARIANT+data;
			Ext.Ajax.request({
				 type: 'rest',
				 url: uniqCheckUrl,
				 method: 'GET',
				 success: function(resp, action) {
					 var objCourseVariants = Ext.decode(resp.responseText);
					 if(!isNullOrEmpty(objCourseVariants)){
						 setTimeout(function(){
							 courseSessionDiaryForm.down("#courseVariantId").setValue(objCourseVariants.id);
		                  },300);
					 }
								
				 }
			 });
		}
    }
});