/**
 * This controller is used for faculty course execution information actions.
 * @author Sachin.Bangar   
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyDetailedScheduleController', {
	extend: 'Academia.controller.base.BaseController',
	alias: "widget.facultydetailedschedulecontroller",
	views: ['facultyPortal.detailScheduleFaculty.DetailedScheduleFacultyStructure', 'facultyPortal.detailScheduleFaculty.DetailedScheduleFacultySearchFilter',
		'facultyPortal.detailScheduleFaculty.FacultyDetailedScheduleGrid','facultyPortal.detailScheduleFaculty.AssignTopicStructure',
		'facultyPortal.detailScheduleFaculty.AssignTopicGrid','facultyPortal.detailScheduleFaculty.AssignedTopicDetailWindow',
        'coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableExportReportWindow',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsTabStructure',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsUploadDownloadForm',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadTemplatePanel',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsUploadTemplatePanel',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadPBSPanel',
        'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadCBSPanel',
        'importutility.ImportByModule.ImportListExtendedTimeTable'],
		stores:['program.programDetails.programBatches.courseParameter.ExtendedTimeTableCBSGridStore',
			'course.coursetopic.AssignTopicDetailGridStore',
			'importutility.ImportExtendedTimeTable',
			'importutility.ModuleName'],
		config: {
			FACULTY_DETAILED_SCHEDULE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_DETAILED_SCHEDULE_PRIVILEGE'),
			FACULTY_IMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_IMPORT_SESSION_AND_TOPICS_MAPPING_PRIVILEGES'),
		},
		refs : [{
			ref : 'detailedschedulefacultystructure',
			selector : 'detailedschedulefacultystructure'
		},{
			ref : 'detailedschedulefacultysearchfilter',
			selector : 'detailedschedulefacultysearchfilter'
		},{
			ref: 'facultydetailedschedulegrid',
			selector: 'facultydetailedschedulegrid'
		},{
			ref: 'assigntopicgrid',
			selector: 'assigntopicgrid'
		},{
			ref: 'assigntopicstructure',
			selector: 'assigntopicstructure'
		},{
			ref: 'assignedtopicdetailwindow',
			selector: 'assignedtopicdetailwindow'
		},{
			ref : 'contentPanel',
			selector:'contentpanel'
		},{
			ref: 'extendedtimetableexportreportwindow',
			selector: 'extendedtimetableexportreportwindow'
		},{
			ref: 'importsessiontopicstabstructure',
			selector: 'importsessiontopicstabstructure'
		},{
			ref: 'importsessiontopicsuploaddownloadform',
			selector: 'importsessiontopicsuploaddownloadform'
		},{
			ref: 'importsessiontopicsdownloadtemplatepanel',
			selector: 'importsessiontopicsdownloadtemplatepanel'
		},{
			ref: 'importsessiontopicsuploadtemplatepanel',
			selector: 'importsessiontopicsuploadtemplatepanel'
		},{
			ref: 'importsessiontopicsdownloadpbspanel',
			selector: 'importsessiontopicsdownloadpbspanel'
		},{
			ref: 'importsessiontopicsdownloadcbspanel',
			selector: 'importsessiontopicsdownloadcbspanel'
		},{
			ref : 'importlistextendedtimetable',
			selector : 'importlistextendedtimetable'
		}],

		init: function(application) {
			this.control({
				'facultydetailedschedulegrid' :{
					afterrender:function(){
						var this$ = this;
						var grid = this.getFacultydetailedschedulegrid();
						var assignTopicButton=grid.down("#assignTopicButton");
						assignTopicButton.setVisible(false);
						var exportReportButton=grid.down("#exportReport");
						exportReportButton.setVisible(false);
						var permissionsMap=this.getFACULTY_DETAILED_SCHEDULE_PERMISSION();
						this.doAccessControlValidation(grid, permissionsMap);
						var associatedAcadLocationIds = new Array();
						associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						if(Ext.Array.contains(permissionList, 'ASSIGNTOPIC')){
							assignTopicButton.setVisible(true);
						}
						if(Ext.Array.contains(permissionList, 'EXPORT_REPORT')){
							exportReportButton.setVisible(true);
						}
					},
					cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
		           		var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
		           		if (e.target.tagName == 'A' && columnName=='assignedTopicCount') {
		           			this.viewAssignedTopics(View, record);
		           		}
					},
					selectionchange: function(column, selected,eOpts ){
						var grid = this.getFacultydetailedschedulegrid();
						var assignTopicButtonItemId = grid.down('#assignTopicButton');
						if(selected.length > 0){
							assignTopicButtonItemId.setDisabled(false);
						} else {
							assignTopicButtonItemId.setDisabled(true);
						}
	                }
				},
				'facultydetailedschedulegrid button[itemId=assignTopicButton]' :{
					click:function(){
						var this$ = this;
						var grid = this.getFacultydetailedschedulegrid();
						if(grid.getSelectionModel().getCount() > 0) {
							var records = grid.getSelectionModel().getSelection();
							var ccpIds = [];
							var uniqueCourseId;
							for(var rec in records) {
								if(isNullOrEmpty(uniqueCourseId) || uniqueCourseId == records[rec].data.courseId) {
									ccpIds.push(records[rec].data.id);
									uniqueCourseId = records[rec].data.courseId;
								}
								else{
									showWarningMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getProgramandcourseTranslation('ASSIGN_TOPIC_VALIDATION'));
									return;
								}
							}
							var contentPanel = grid.up().up();
							var structure = Ext.widget('assigntopicstructure');
							var tabName = getProgramandcourseTranslation('ASSIGN_TOPIC');
							var getcontroller=this$.getController('menu.CoreERPNavigationController');
							var getTab = null;
							for(var i =0 ;i<contentPanel.items.length;i++){
								if(contentPanel.items.items[i].title == tabName){
									getTab= contentPanel.items.items[i];
								}
							}
							if(getTab!=null){
								contentPanel.remove(getTab, true);
							}
							var structure = this.getAssigntopicstructure();
							structure.down('#courseIds').setValue(records[0].data.courseId);
							structure.down('#courseCovergaPlanIds').setValue(ccpIds.join());
							openTab(contentPanel, tabName, structure);
						} else {
							showWarningMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
				},
				'assigntopicgrid' :{
					afterrender:function(){
						var this$ = this;
						var grid = this.getAssigntopicgrid();
						var structure = this.getAssigntopicstructure();
						var courseId = structure.down('#courseIds').getValue();
						var store = grid.getStore();
						store.getProxy().extraParams = {
							courseId:courseId
						};
						store.load();
					},
					selectionchange: function(column, selected,eOpts ){
						var grid = this.getAssigntopicgrid();
						var topicSaveButton = grid.down('#topicSaveButton');
						if(selected.length > 0) {
							topicSaveButton.setDisabled(false);
						} else {
							topicSaveButton.setDisabled(true);
						}
					}
				},
				'assigntopicgrid button[itemId=topicSaveButton]' :{
					click:function() {
						this.assignTopicInSession()
					}
				},
       		 'facultydetailedschedulegrid button[itemId=exportReport]': {
    			 click : function() {
    				 this.openExportReportWindow();
    			 }
    		 },
				'detailedschedulefacultystructure': {
					render : function(){
						var me = this;
						var form  = me.getDetailedschedulefacultysearchfilter();
						var academyLocationId = this.getCurrentAcademyLocation();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var acdemicTerm = form.down('#academicTermId');
						var academicTermStore = form.down('#academicTermId').getStore();
						var courseVarientCombo=form.down("#courseVariantId");
						var programCombo=form.down("#programBatch_programId");
						var batchCombo=form.down("#programBatch_batchId");
						var periodCombo=form.down("#programBatch_periodId");
						var topicsBoxCombo = form.down('customcombobox#topicsId');
						var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
						
						if(wheatherSchool){
							form.down('#programBatch_periodId').setVisible(false);
						} else {
							form.down('#programBatch_periodId').setVisible(true);
						}
						
						topicsBoxCombo.reset();
						topicsBoxCombo.setDisabled(true);
						
						multipleTopicsBoxCombo.reset();
						multipleTopicsBoxCombo.setDisabled(true);
						
						var academicTermId = 0;
						academicTermStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId
						};
						academicTermStore.load({
							callback: function(rec, success) {
								if (success) {
									for(var i in rec){
										if(rec[i].get('sequence')==1){
											acdemicTerm.setValue(rec[i].data.id);
											me.loadFacultyDetailedScheduleGrid();
											me.sendCalendarEventsRequestFacultyDetailedSchedule('FACULTY', '#personViewCalendar', SERVERURL.PATH_GET_FACULTY_DETAILED_SCHEDULE);
											academicTermId=rec[i].data.id ;

											programCombo.reset();
											programCombo.setDisabled(false);

											batchCombo.reset();
											batchCombo.setDisabled(true);

											periodCombo.reset();
											periodCombo.setDisabled(true);
											
											topicsBoxCombo.reset();
											topicsBoxCombo.setDisabled(true);
											
											multipleTopicsBoxCombo.reset();
											multipleTopicsBoxCombo.setDisabled(true);

											var programStore = form.down('#programBatch_programId').getStore();
											programStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												facultyId:facultyId
											};
											programStore.load();	
											
											var courseVarientStore=courseVarientCombo.getStore();
											courseVarientCombo.reset();
											courseVarientStore.getProxy().extraParams = {
												academyLocationIds:academyLocationId,
												academicTermId:academicTermId,
												facultyId:facultyId
											};
											courseVarientStore.load();
										}
									}
									if(academicTermId == 0){
										var programStore = form.down('#programBatch_programId').getStore();
										programStore.getProxy().extraParams = {
											academyLocationIds:academyLocationId,
											facultyId:facultyId
										};
										programStore.load();	

										var courseVarientStore=courseVarientCombo.getStore();
										courseVarientCombo.reset();
										courseVarientStore.getProxy().extraParams = {
											academyLocationIds:academyLocationId,
											facultyId:facultyId
										};
										courseVarientStore.load();
										me.loadFacultyDetailedScheduleGrid();
										me.sendCalendarEventsRequestFacultyDetailedSchedule('FACULTY', '#personViewCalendar', SERVERURL.PATH_GET_FACULTY_DETAILED_SCHEDULE);
									}
								}
							}
						});
						
						
					},
					afterrender : function(structure){
						var me = this;
						var contentPanel = this.getContentPanel();
	            		var mainStructure = contentPanel.down('personinfofacultyportal');
						var grid=structure.down('facultydetailedschedulegrid');
	               		this.getGridHeaderFreeze(grid,mainStructure,true);
	               		
	               		var tabPanel = contentPanel.down('tabpanel');
	               		
	               		var associatedAcadLocationIds = new Array();
    		 			associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    	            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFACULTY_IMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION());
    		 				               		
    	            	Ext.each(permissionList, function(privilege) {
    	            		if (privilege === 'VIEW') {
			               		tabPanel.add({
		    		 				xtype: 'importsessiontopicstabstructure',
		    		 				title: getCommonTranslation('IMPORT_SESSION_TOPICS_MAPPING'),
		    		 				itemId: 'facultyImportaSessionTopicTab'
		    		 			});
    	            		}
    	            	});
					}
				},
				'tabpanel[itemId=pendingattendancereportpanelId] tab':{
					activate: function(){
						var contentPanelMain = this.getContentPanel().getActiveTab();
						contentPanelMain.scrollBy(0,1);
						contentPanelMain.scrollBy(0,-1);
					}
				},
				'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab]':{
    		 		afterrender: function(structure){
    		 			var me = this;
    		 			var associatedAcadLocationIds = new Array();
    		 			associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    	            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFACULTY_IMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION());
    	            	
    	            	var sectionTypeRadioGroup = structure.down('radiogroup[itemId=sectionTypeId]');
    	            	
    	            	var isPBSVisible = false;
    	            	var isCBSVisible = false;
    	            	
    	            	Ext.each(permissionList, function(privilege) {
    	            		if (privilege === 'PROGRAM_BATCH_SECTION') {
    	            			isPBSVisible = true;
    	            		}
    	            		else if (privilege === 'COURSE_SECTION') {
    	            			isCBSVisible = true;
    	            		}
    	            	});
    	            	
    	            	if(isPBSVisible == true && isCBSVisible == true){
    	            		sectionTypeRadioGroup.show();
    	            		sectionTypeRadioGroup.setValue({sectionType: "PBS"});
    	            	}
    	            	else if(isPBSVisible == true){
    	            		sectionTypeRadioGroup.hide();
    	            		sectionTypeRadioGroup.setValue({sectionType: "PBS"});
    	            	}
    	            	else { // if(isCBSVisible == true || (isPBSVisible == false && isCBSVisible == true)) //CASE
    	            		sectionTypeRadioGroup.hide();
    	            		sectionTypeRadioGroup.setValue({sectionType: "CBS"});
    	            	}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsuploaddownloadform radiogroup[itemId=templateTypeId]':{
    		 		change: function( radioGroup, newValue, oldValue, eOpts){
    		 			var me = this;
    		 			var importsessiontopicsdownloadtemplatepanel = me.getImportsessiontopicsdownloadtemplatepanel();
    		 			var importsessiontopicsuploadtemplatepanel = me.getImportsessiontopicsuploadtemplatepanel();
    		 			var importlistextendedtimetable = me.getImportlistextendedtimetable();
    		 			if(newValue.templateType == "Upload_Template"){
    		 				importsessiontopicsdownloadtemplatepanel.hide();
    		 				importlistextendedtimetable.show();
    		 				importsessiontopicsuploadtemplatepanel.show();
    		 			}
    		 			else{
    		 				importsessiontopicsdownloadtemplatepanel.show();
    		 				importsessiontopicsuploadtemplatepanel.hide();
    		 				importlistextendedtimetable.hide();
    		 			}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsuploadtemplatepanel button[itemId=uploadImportSessionTopicUploadFormItemId]':{
    		 		click:function(obj){
    		 		var $this=this;
    		 		var form=obj.up('importsessiontopicsuploadtemplatepanel');
    		 		var templateName = form.down('#moduleName').getRawValue()=='Bulk PBS Session Topic Mapping'?'BULK_PBS_SESSION_TOPIC_MAPPING':'BULK_CBS_SESSION_TOPIC_MAPPING';
    		 		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    		 		            $this.getHashOfFile(form);
    		 		        setTimeout(function() {
    		 		form.getForm().submit({
    		 		method : 'POST',
    		 		url : submitUrl,
    		 		success : function(form, action){
    		 		showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
    		 		},
    		 		failure: function(form, action) {
    		 		    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
    		 		}
    		 		});
    		 		        },1000);

    		 		Ext.defer(function() {
    		 		var grid = $this.getImportlistextendedtimetable();
    		 		var isUploadAll = false;
    		 		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateName);
    		 		}, 2000, this);
    		 		}  
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadtemplatepanel radiogroup[itemId=sectionTypeId]':{
    		 		change: function( radioGroup, newValue, oldValue, eOpts){
    		 			var me = this;
    		 			var importsessiontopicsdownloadpbspanel = me.getImportsessiontopicsdownloadpbspanel();
    		 			var importsessiontopicsdownloadcbspanel = me.getImportsessiontopicsdownloadcbspanel();
    		 			if(newValue.sectionType == "PBS"){
    		 				importsessiontopicsdownloadpbspanel.show();
    		 				importsessiontopicsdownloadcbspanel.hide();
    		 				this.resetImportSessionTopicPBSFilter(importsessiontopicsdownloadpbspanel);
    		 			}
    		 			else{
    		 				importsessiontopicsdownloadpbspanel.hide();
    		 				importsessiontopicsdownloadcbspanel.show();
    		 				this.resetImportSessionTopicCBSFilter(importsessiontopicsdownloadcbspanel);
    		 			}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel':{
    		 		afterrender: function(panel){
    		 			var me = this;
    		 			var academyLocationId = this.getCurrentAcademyLocation();
    		 			var academicTermCombo = panel.down('#academicTermIdCBS');
    		 			var batchField = panel.down('#batchId');
    		 			batchField.setVisible(false);
    		 			var academicTermComboStore = academicTermCombo.getStore();
    		 			var facultyId = this.getCurrentlyLoggedInUser().id;
    		 			academicTermComboStore.getProxy().extraParams = {
    		 				academyLocationIds : academyLocationId,
    		 				facultyId :facultyId
    		 			};
    		 			academicTermComboStore.load({
    		 				callback: function(rec, success) {
    		 					if (success) {
    		 						for(var i in rec){
    		 							if(rec[i].get('sequence')==1){
    		 								academicTermCombo.setValue(rec[i].get('id'));
    		 							}
    		 						}
    		 					}
    		 				}
    		 			});
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel':{
    		 		afterrender: function(panel){
    		 			var me = this;
    		 			var alinfomodel = Academia.model.authentication.ALInfoModel;
    		 			var wheatherSchool = alinfomodel.get('wheatherSchool');
    		 			if(wheatherSchool) {
    		 				panel.down('#periodIdPBS').setVisible(false);
    		 			} else{
    		 				panel.down('#periodIdPBS').setVisible(true); 
    		 			}
    		 			var academyLocationId = this.getCurrentAcademyLocation();
    		 			var academicTermCombo = panel.down('#academicTermIdPBS');
    		 			var batchField = panel.down('#batchIdPBS');
    		 			var periodField = panel.down('#periodIdPBS');
    		 			var courseField = panel.down('#course_IdPBS');
    		 			academicTermCombo.reset();
    		 			batchField.reset();
    		 			courseField.reset();
    		 			periodField.reset();
    		 			
    		 			batchField.setDisabled(true);
    		 			courseField.setDisabled(true);
    		 			periodField.setDisabled(true);

    		 			var academicTermComboStore = academicTermCombo.getStore();
    		 			var facultyId = this.getCurrentlyLoggedInUser().id;
    		 			academicTermComboStore.getProxy().extraParams = {
    		 				academyLocationIds : academyLocationId,
    		 				facultyId :facultyId
    		 			};
    		 			academicTermComboStore.load({
    		 				callback: function(rec, success) {
    		 					if (success) {
    		 						for(var i in rec){
    		 							if(rec[i].get('sequence')==1){
    		 								academicTermCombo.setValue(rec[i].get('id'));
    		 							}
    		 						}
    		 					}
    		 				}
    		 			});
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel customcombobox#academicTermIdPBS':{
     			   change: function(obj, record) {
     				   var me = this;
     				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
     				   var academicTermId = obj.getValue();
     				   var facultyId = this.getCurrentlyLoggedInUser().id;
     				   var batchField = importsessiontopicsdownloadpbspanel.down('#batchIdPBS');
     				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
     				   var periodField = importsessiontopicsdownloadpbspanel.down('#periodIdPBS');
     				   var batchStore = batchField.getStore();
     				   var courseStore = courseField.getStore();
     				   var periodStore = periodField.getStore();
					   batchStore.getProxy().extraParams = {
						   academicTermId:academicTermId,
						   facultyId:facultyId
					   };
					   batchField.reset();
					   courseField.reset();
					   periodField.reset();
					   batchField.setValue('');
					   batchField.setDisabled(true);
					   courseField.setDisabled(true);
					   periodField.setDisabled(true);
					   if(!isNullOrEmpty(academicTermId)){
						   batchStore.load({
							   callback: function(rec, success){
								   if (success && !isNullOrEmpty(academicTermId)) {
									   batchField.setDisabled(false);
									   importsessiontopicsdownloadpbspanel.isValid();
									   if(rec.length==1){
										   batchField.setValue(rec[0].get('id'))
									   }
								   }
							   }
						   });
					   }
     			   }
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel multiselectcombofield#batchIdPBS':{
    		 		change: function(obj, record) {
    		 			var me = this;
        				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
        				   var facultyId = this.getCurrentlyLoggedInUser().id;
        				   var batchIds = importsessiontopicsdownloadpbspanel.down('#batchIdPBS').getValue();
        				   var academicTermId = importsessiontopicsdownloadpbspanel.down('#academicTermIdPBS').getValue();
        				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
        				   var periodField = importsessiontopicsdownloadpbspanel.down('#periodIdPBS');
        				   var batchIdArr=[];
        	 				var batchIdVal = batchIds;
        	 				var batchIdVals = null;
        	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
        						for (var i in batchIdVal) {
        							if (Ext.isObject(batchIdVal[0])) {
        								batchIdArr.push(batchIdVal[i].get("id"));
        							} else {
        								batchIdArr.push(batchIdVal[i]);
        							}
        						}
        						batchIdVals = batchIdArr.join();
        					}
        					else if(!isNullOrEmpty(batchIdVal)){
        						batchIdVals = batchIdVal;
        					}
        				   var courseStore = courseField.getStore();
        				   var periodStore = periodField.getStore();
        				   periodStore.getProxy().extraParams = {
 							   academicTermId:academicTermId,
 							   batchIds:batchIdVals,
 							  facultyId:facultyId
 						   };
 						   courseField.reset();
 						   periodField.reset();
 						   courseField.setDisabled(true);
 						   periodField.setDisabled(true);
 						   var alinfomodel = Academia.model.authentication.ALInfoModel;
 						   var wheatherSchool = alinfomodel.get('wheatherSchool');
 						   if(!isNullOrEmpty(batchIds) && batchIds.length > 0){
 							  if(!wheatherSchool){
 								 periodStore.load({
 	 	 							   callback: function(rec, success){
 	 	 								   if (success && !isNullOrEmpty(batchIds)) {
 	 	 									  periodField.setDisabled(false);
 	 	 									   if(rec.length==1){
 	 	 										  periodField.setValue(rec[0].get('id'))
 	 	 									   }
 	 	 									 courseStore.getProxy().extraParams = {
 	 	 										 academicTermId:academicTermId,
 	 											   batchIds: batchIdVals,
 	 											   periodId:periodField.getValue(),
 	 											   facultyId:facultyId
 	 	 		        		 			};
 	 	 									  courseStore.load({
 	 	 	        							   callback: function(rec, success){
 	 	 	        								   if (success) {
 	 	 	        									   courseField.setDisabled(false);
 	 	 	        									   if(rec.length==1){
 	 	 	        										   courseField.setValue(rec[0].get('id'))
 	 	 	        									   }
 	 	 	        								   }
 	 	 	        							   }
 	 	 									   });
 	 	 								   }
 	 	 							   }
 	 	 						   });
 	 						   } else{
 	 							 courseStore.getProxy().extraParams = {
										 academicTermId:academicTermId,
										 batchIds: batchIdVals,
										 facultyId:facultyId
		        		 			};
 	 							courseStore.load({
        							   callback: function(rec, success){
        								   if (success) {
        									   courseField.setDisabled(false);
        									   if(rec.length==1){
        										   courseField.setValue(rec[0].get('id'))
        									   }
        								   }
        							   }
								   });
 	 						   }
 						   }
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel customcombobox#periodIdPBS':{
     			   select: function(obj, record) {
     				   var me = this;
     				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
     				   var facultyId = this.getCurrentlyLoggedInUser().id;
     				   var academicTermId = importsessiontopicsdownloadpbspanel.down('#academicTermIdPBS').getValue();
     				   var batchIds = importsessiontopicsdownloadpbspanel.down('#batchIdPBS').getValue();
     				   var periodId = importsessiontopicsdownloadpbspanel.down('#periodIdPBS').getValue();
     				   var batchIdArr=[];
     	 				var batchIdVal = batchIds;
     	 				var batchIdVals = null;
     	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
     						for (var i in batchIdVal) {
     							if (Ext.isObject(batchIdVal[0])) {
     								batchIdArr.push(batchIdVal[i].get("id"));
     							} else {
     								batchIdArr.push(batchIdVal[i]);
     							}
     						}
     						batchIdVals = batchIdArr.join();
     					}
     					else if(!isNullOrEmpty(batchIdVal)){
     						batchIdVals = batchIdVal;
     					}
     				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
     				   var courseStore = courseField.getStore();
     				   courseStore.getProxy().extraParams = {
     					   academicTermId:academicTermId,
     					   batchIds:batchIdVals,
     					   periodId:periodId,
     					   facultyId:facultyId
     				   };
     				   courseField.reset();
     				   courseStore.load({
     					   callback: function(rec, success){
								   if (success && !isNullOrEmpty(academicTermId)) {
									 courseField.setDisabled(false);
									   if(rec.length==1){
										 courseField.setValue(rec[0].get('id'))
									   }
								   }
							   }
     				   });
				   
     			   }
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel button[itemId=importSessionTopicPBSResetBtn]':{
    		 		click: function(btn){
    		 			var panel = btn.up('importsessiontopicsdownloadpbspanel');
    		 			this.resetImportSessionTopicPBSFilter(panel);
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadpbspanel button[itemId=importSessionTopicPBSDownload]':{
    		 		click:function(obj){
    	 				var $this = this;
    	 				var form =obj.up('importsessiontopicsdownloadpbspanel').getForm();
                        var submitUrl= SERVERURL.DOWNLOAD_TEMPLATE_PBS_SESSION_TOPIC_MAPPING_CREATION;
    	 				var csvForm = Ext.create('Ext.form.Panel'); 
    	 				var facultyId = this.getCurrentlyLoggedInUser().id;
    	 				var values = form.getValues();
    	 				var batchIdArr=[];
    	 				var batchIdVal = values.batchPBS;
    	 				var batchIdVals = null;
    	 				var courseIdArr=[];
    					var courseIdVal = values.coursePBS;
    					var courseIdVals = null;
    					
    					if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
    						for (var i in batchIdVal) {
    							if (Ext.isObject(batchIdVal[0])) {
    								batchIdArr.push(batchIdVal[i].get("id"));
    							} else {
    								batchIdArr.push(batchIdVal[i]);
    							}
    						}
    						batchIdVals = batchIdArr.join();
    					}
    					else if(!isNullOrEmpty(batchIdVal)){
    						batchIdVals = batchIdVal;
    					}

    					if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
    						for (var i in courseIdVal) {
    							if (Ext.isObject(courseIdVal[0])) {
    								courseIdArr.push(courseIdVal[i].get("id"));
    							} else {
    								courseIdArr.push(courseIdVal[i]);
    							}
    						}
    						courseIdVals = courseIdArr.join();
    					}
    					else if(!isNullOrEmpty(courseIdVal)){
    						courseIdVals = courseIdVal;
    					}
    					
    	 				var params = {
	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	 						academicTermId : values.academicTermPBS,
	 						batchIds : batchIdVals,
     	 					courseIds : courseIdVals,
     	 					periodId : values.periodIdPBS,
     	 					facultyId : facultyId
	 					};
    	 				csvForm.getForm().submit({
    	 					target: '_blank',
    	 					method:'POST',
    	 					params :params,
    	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	 					url: submitUrl,
    	 					standardSubmit :true
    	 				});
    	 			}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel customcombobox#academicTermIdCBS':{
        			   change: function(obj, record) {
        				   var me = this;
        				   var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
        				   var academicTermId = obj.getValue();
        				   var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
        				   var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
        				   var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
        				   var facultyId = this.getCurrentlyLoggedInUser().id;
        				   var batchStore = batchField.getStore();
        				   var courseStore = courseField.getStore();
        				   var courseVariantStore = courseVariantField.getStore();
						   batchStore.getProxy().extraParams = {
							   academicTermId:academicTermId
						   };
						   batchField.reset();
						   courseField.reset();
						   courseVariantField.reset();
						   batchField.setDisabled(true);
						   courseField.setDisabled(true);
						   courseVariantField.setDisabled(true);
						   me.validateImportSessionTopicsDownloadCBSForm();
						   batchStore.load({
							   callback: function(rec, success){
								   if (success && !isNullOrEmpty(academicTermId)) {
									   batchField.setDisabled(false);
									   if(rec.length==1){
										   batchField.setValue(rec[0].get('id'))
										   var courseStoreExtraParams = {
												   academicTermId:academicTermId,
												   batchIds: rec[0].get('id'),
												   facultyId:facultyId
										   }
									   }
									   else{
										   var courseStoreExtraParams = {
												   academicTermId:academicTermId,
												   facultyId:facultyId
										   }
									   }
									   courseStore.getProxy().extraParams = courseStoreExtraParams;
									   me.validateImportSessionTopicsDownloadCBSForm();
									   courseStore.load({
	        							   callback: function(rec, success){
	        								   if (success) {
	        									   courseField.setDisabled(false);
	        									   if(rec.length==1){
	        										   courseField.setValue(rec[0].get('id'))
	        										   var courseVariantStoreExtraParams = {
	        												   academicTermId:academicTermId,
	        												   courseIds: rec[0].get('id'),
	        												   facultyId:facultyId
	        										   }

    	        									   if(!isNullOrEmpty(batchField.getValue())){
    	        										   courseVariantStoreExtraParams.batchIds = courseStoreExtraParams.batchIds;
    	        									   }
    	        									   
    	        									   courseVariantStore.getProxy().extraParams = courseVariantStoreExtraParams;
    	        									   me.validateImportSessionTopicsDownloadCBSForm();
    	        									   courseVariantStore.load({
    	        	        							   callback: function(rec, success){
    	        	        								   if (success) {
    	        	        									   courseVariantField.setDisabled(false);
    	        	        									   if(rec.length==1){
    	        	        										   courseVariantField.setValue(rec[0].get('id'))
    	        	        									   }
    	        	        									   me.validateImportSessionTopicsDownloadCBSForm();
    	        	        								   }
    	        	        							   }
    	        									   });
	        									   }
	        								   }
	        							   }
									   });
								   }
							   }
						   });
        			   }
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel multiselectcombofield#batchId':{
    		 		select: function(obj, record) {
    		 			this.onBatchChange(obj, record);
    		 		},
    		 		change: function(obj, newValue, oldValue, eOpts){
    		 			try{
    		 				if(obj.store.count()){
	        		 			if(obj.store.count() == obj.value.length){ //onselectall
	        		 				this.onBatchChange(obj);
	        		 			}
	        		 			else if(oldValue.length == obj.store.count() && obj.value.length == 0){ //ondeselectall
	        		 				this.onBatchChange(obj);
	        		 			}
	        		 			else if(obj.getPicker().hidden){
	        		 				this.onBatchChange(obj);
	        		 			}
	    		 			}
    		 			}
    		 			catch(e){}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel multiselectcombofield#course_Id':{
    		 		select: function(obj, record) {
    		 			this.onCourseChange(obj, record);
    		 		},
    		 		change: function(obj, newValue, oldValue, eOpts){
    		 			try{
    		 				if(obj.store.count()){
	        		 			if(obj.store.count() == obj.value.length){ //onselectall
	        		 				this.onCourseChange(obj);
	        		 			}
	        		 			else if(oldValue.length == obj.store.count() && obj.value.length == 0){ //ondeselectall
	        		 				this.onCourseChange(obj);
	        		 			}
	        		 			else if(obj.getPicker().hidden){
	        		 				this.onCourseChange(obj);
	        		 			}
	    		 			}
    		 			}
    		 			catch(e){}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel button[itemId=importSessionTopicCBSResetBtn]':{
    		 		click: function(btn){
    		 			var panel = btn.up('importsessiontopicsdownloadcbspanel');
    		 			this.resetImportSessionTopicCBSFilter(panel);
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsuploadtemplatepanel button[itemId=resetBtnImportSessionTopicUploadFormItemId]':{
    		 		click: function(btn){
    		 			btn.up('form').getForm().reset();
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importsessiontopicsdownloadcbspanel button[itemId=importSessionTopicCBSDownload]':{
    		 		click:function(obj){
    	 				var $this = this;
    	 				var form =obj.up('importsessiontopicsdownloadcbspanel').getForm();
    	 				var facultyId = this.getCurrentlyLoggedInUser().id;
                        var submitUrl= SERVERURL.DOWNLOAD_TEMPLATE_CBS_SESSION_TOPIC_MAPPING_CREATION;
    	 				var csvForm = Ext.create('Ext.form.Panel'); 
    	 				var values = form.getValues();
    		 			var courseIdArr=[];
    					var courseIdVal = values.course;
    					var courseIdVals = null;
    					var courseVariantArr=[];
    					var courseVariantIdVal = values.downloadCourseVariantName;
    					var courseVariantIdVals = null;

    					if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
    						for (var i in courseIdVal) {
    							if (Ext.isObject(courseIdVal[0])) {
    								courseIdArr.push(courseIdVal[i].get("id"));
    							} else {
    								courseIdArr.push(courseIdVal[i]);
    							}
    						}
    						courseIdVals = courseIdArr.join();
    					}
    					else if(!isNullOrEmpty(courseIdVal)){
    						courseIdVals = courseIdVal;
    					}
    					
    					if (!isNullOrEmpty(courseVariantIdVal) && courseVariantIdVal.length > 0 && !isNullOrEmpty(courseVariantIdVal[0])) {
    						for (var i in courseVariantIdVal) {
    							if (Ext.isObject(courseVariantIdVal[0])) {
    								courseVariantArr.push(courseVariantIdVal[i].get("id"));
    							} else {
    								courseVariantArr.push(courseVariantIdVal[i]);
    							}
    						}
    						courseVariantIdVals = courseVariantArr.join();
    					}
    					else if(!isNullOrEmpty(courseVariantIdVal)){
    						courseVariantIdVals = courseVariantIdVal;
    					}
    	 				
    	 				var params = {
	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	 						academicTermId : values.academicTermCBS,
     	 					courseIds : courseIdVals,
     	 					courseVariantIds : courseVariantIdVals,
     	 					facultyId : facultyId
	 					};
    	 				csvForm.getForm().submit({
    	 					target: '_blank',
    	 					method:'POST',
    	 					params :params,
    	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	 					url: submitUrl,
    	 					standardSubmit :true
    	 				});
    	 			}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importlistextendedtimetable':{
    		 		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    		 			if (e.target.tagName == 'A') {
    		 				var fileType=null;
    		 				if(cellIndex==1){
    		 					fileType='successFile';
    		 				}else if(cellIndex==6){
    		 					fileType='errorFile';
    		 				}else if(cellIndex==7){
    		 					fileType='logFile';
    		 				}
    		 				var documentId = record.get("id");
    		 				if (!isNullOrEmpty(documentId)) {
    		 					this.getDownloadFile(documentId,fileType);
    		 				}
    		 			}
    		 		}
    		 	},
    		 	'importsessiontopicstabstructure[itemId=facultyImportaSessionTopicTab] importlistextendedtimetable button[itemId=btnForce]':{
    		 		click: function(obj) {
    		 			var grid = this.getImportlistextendedtimetable();
    		 			if (grid.getSelectionModel().getCount() > 0) {
    		 				if(grid.getSelectionModel().getCount() > 1){
    		 					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    		 				}else{
    		 					var this$ = this;
    		 					var id = grid.getSelectionModel().selectionStart.data.id;
    		 					console.log(id);
    		 					var urlAppend="?jobName="+id;
    		 					var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
    		 					Ext.Ajax.request({
    		 						url: submitURL,
    		 						method: 'GET',
    		 						success: function(response) {
    		 							if(response.responseText==="JOB_STATUS_NOT_PENDING"){
    		 								showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
    		 							}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
    		 								//console.log("Manual trigger hit");
    		 								showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
    		 							}else if(response.responseText==="SUCCESS"){
    		 								//console.log("Manual trigger hit");
    		 								showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    		 							}
    		 						}
    		 					});
    		 				}
    		 			} else {
    		 				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		 			}  
    		 		}
    		 	},
				'detailedschedulefacultysearchfilter combo#academicTermId':{
					select : function(obj,record){
						var this$ = this;
						var academicTermId = record[0].get('id');
						var form = this$.getDetailedschedulefacultysearchfilter();
						form.down('#programBatch_periodId').reset();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var aLId = this.getCurrentAcademyLocation();
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var programCombo=form.down("#programBatch_programId");
						var batchCombo=form.down("#programBatch_batchId");
						var periodCombo=form.down("#programBatch_periodId");
						var courseVarientCombo=form.down("#courseVariantId");
						var topicsBoxCombo = form.down('customcombobox#topicsId');
						var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
						this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(true);
        				 
						
						if(wheatherSchool){
							form.down('#programBatch_periodId').setVisible(false);
						} else {
							form.down('#programBatch_periodId').setVisible(true);
						}
						
						topicsBoxCombo.reset();
						topicsBoxCombo.setDisabled(true);
						
						multipleTopicsBoxCombo.reset();
						multipleTopicsBoxCombo.setDisabled(true);
						
						programCombo.reset();
						programCombo.setDisabled(false);

						batchCombo.reset();
						batchCombo.setDisabled(true);

						periodCombo.reset();
						periodCombo.setDisabled(true);

						courseVarientCombo.reset();
						courseVarientCombo.setDisabled(false);

						var programStore = programCombo.getStore();
						programStore.getProxy().extraParams = {
							academyLocationIds:aLId,
							academicTermId:academicTermId,
							facultyId:facultyId
						};
						programStore.load();		
						
						var courseVarientStore=courseVarientCombo.getStore();
						courseVarientCombo.reset();
						courseVarientStore.getProxy().extraParams = {
							academyLocationIds:aLId,
							academicTermId:academicTermId,
							facultyId:facultyId
						};
						courseVarientStore.load();
					}
				},
				'detailedschedulefacultysearchfilter combo#programBatch_programId':{
					select : function(obj,record){
						var this$ = this;
						var programId = record[0].get('id');
						var form = this$.getDetailedschedulefacultysearchfilter();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var aLId = this.getCurrentAcademyLocation();
						form.down('#programBatch_periodId').reset();
						var academicTermId=form.down('#academicTermId').getValue();
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var programCombo=form.down("#programBatch_programId");
						var batchCombo=form.down("#programBatch_batchId");
						var periodCombo=form.down("#programBatch_periodId");
						var courseVarientCombo=form.down("#courseVariantId");
						this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(true);
						if(wheatherSchool){
							form.down('#programBatch_periodId').setVisible(false);
						} else {
							form.down('#programBatch_periodId').setVisible(true);
						}
						
						courseVarientCombo.reset();
						courseVarientCombo.setDisabled(false);
						
						var topicsBoxCombo = form.down('customcombobox#topicsId');
						var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
						
						topicsBoxCombo.reset();
						topicsBoxCombo.setDisabled(true);
						
						multipleTopicsBoxCombo.reset();
						multipleTopicsBoxCombo.setDisabled(true);

						batchCombo.setDisabled(false);
						periodCombo.reset();
						periodCombo.setDisabled(true);

						var batchStore=batchCombo.getStore();
						batchStore.getProxy().extraParams = {
							academyLocationIds:aLId,
							academicTermId:academicTermId,
							programId:programId,
							facultyId:facultyId
						};
						batchStore.load({
							callback: function(records, operation, success) {
								if (success) {

									if(records.length==1){
										periodCombo.setDisabled(false);
										var batchId = records[0].get('id');
										batchCombo.setValue(batchId);

										var periodStore = periodCombo.getStore();
										periodStore.getProxy().extraParams = {
											academyLocationIds:aLId,
											academicTermId:academicTermId,
											batchId:batchId,
											facultyId:facultyId
										};
										periodStore.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length==1){
														periodCombo.setValue(records[0].get('id'));
														form.down("#programBatch_periodId").setValue(records[0].get('id'));
														var periodId=records[0].get('id');

														var courseVarientStore=courseVarientCombo.getStore();
														courseVarientCombo.reset();
														courseVarientStore.getProxy().extraParams = {
															academyLocationIds:aLId,
															academicTermId:academicTermId,
															programId:programId,
															batchId:batchId,
															periodId:periodId,
															facultyId:facultyId
														};
														courseVarientStore.load();
													}
												}
											}
										});									
									}else if(records.length>1){
										var courseVarientStore=courseVarientCombo.getStore();
										courseVarientCombo.reset();
										courseVarientStore.getProxy().extraParams = {
											academyLocationIds:aLId,
											academicTermId:academicTermId,
											programId:programId,
											facultyId:facultyId
										};
										courseVarientStore.load();

									}
								}
							}
						});
					}
				},
				'detailedschedulefacultysearchfilter combo#programBatch_batchId':{
					select : function(obj,record){
						var this$ = this;
						var batchId = record[0].get('id');
						var form = this$.getDetailedschedulefacultysearchfilter();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var aLId = this.getCurrentAcademyLocation();
						form.down('#programBatch_periodId').reset();
						var academicTermId=form.down('#academicTermId').getValue();
						var programId=form.down("#programBatch_programId").getValue();
						var periodCombo=form.down("#programBatch_periodId");
						var courseVarientCombo=form.down("#courseVariantId");
						courseVarientCombo.reset();
						courseVarientCombo.setDisabled(false);
						periodCombo.setDisabled(false);
						
						this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(true);
						
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						
						var whetherSchool = alinfomodel.get('wheatherSchool');
						if(whetherSchool){
							form.down('#programBatch_periodId').setVisible(false);
						} else {
							form.down('#programBatch_periodId').setVisible(true);
						}
						
						var topicsBoxCombo = form.down('customcombobox#topicsId');
						var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
						
						topicsBoxCombo.reset();
						topicsBoxCombo.setDisabled(true);
						
						multipleTopicsBoxCombo.reset();
						multipleTopicsBoxCombo.setDisabled(true);
						
						var periodStore = periodCombo.getStore();

						periodStore.getProxy().extraParams = {
							academyLocationIds:aLId,
							academicTermId:academicTermId,
							batchId:batchId,
							facultyId:facultyId
						};
						periodStore.load({
							callback: function(records, operation, success) {
								if (success) {
									periodCombo.setDisabled(false);
									if(records.length==1){
										periodCombo.setValue(records[0].get('id'));
										form.down("#programBatch_periodId").setValue(records[0].get('id'));
										var periodId=records[0].get('id');
										var courseVarientStore=courseVarientCombo.getStore();
										courseVarientCombo.reset();
										courseVarientStore.getProxy().extraParams = {
											academyLocationIds:aLId,
											academicTermId:academicTermId,
											programId:programId,
											batchId:batchId,
											periodId:periodId,
											facultyId:facultyId
										};
										courseVarientStore.load();
									}else if(records.length>1){
										var courseVarientStore=courseVarientCombo.getStore();
										courseVarientCombo.reset();
										courseVarientStore.getProxy().extraParams = {
											academyLocationIds:aLId,
											academicTermId:academicTermId,
											programId:programId,
											batchId:batchId,
											facultyId:facultyId
										};
										courseVarientStore.load();
									}
								}
							}
						});
					}
				},
				'detailedschedulefacultysearchfilter combo#programBatch_periodId':{
					select : function(obj,record){
						var this$ = this;
						var periodId = record[0].get('id');
						var form = this$.getDetailedschedulefacultysearchfilter();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var aLId = this.getCurrentAcademyLocation();
						form.down("#programBatch_periodId").setValue(record[0].get('id'));
						var academicTermId=form.down('#academicTermId').getValue();
						var programId=form.down("#programBatch_programId").getValue();
						var batchId=form.down("#programBatch_batchId").getValue();
						var courseVarientCombo=form.down("#courseVariantId");
						courseVarientCombo.reset();
						courseVarientCombo.setDisabled(false);
						this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(true);
						
						var topicsBoxCombo = form.down('customcombobox#topicsId');
						var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
						
						topicsBoxCombo.reset();
						topicsBoxCombo.setDisabled(true);
						
						multipleTopicsBoxCombo.reset();
						multipleTopicsBoxCombo.setDisabled(true);
						
						var courseVarientStore=courseVarientCombo.getStore();
						courseVarientCombo.reset();
						courseVarientStore.getProxy().extraParams = {
							academyLocationIds:aLId,
							academicTermId:academicTermId,
							programId:programId,
							batchId:batchId,
							periodId:periodId,
							facultyId:facultyId
						};
					}
				},
				'detailedschedulefacultysearchfilter combo#courseVariantId':{
					select : function(obj,record){
						var this$ = this;
						var courseId = record[0].get('courseId');
						var courseComponentId = record[0].get('courseComponentId');
						var sectionId = record[0].get('sectionId');
						var sectionType = record[0].get('sectionType');

						var form = this$.getDetailedschedulefacultysearchfilter();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var aLId = this.getCurrentAcademyLocation();
						var academicTermId=form.down('#academicTermId').getValue();
						var courseVarientCombo=form.down("#courseVariantId");
						var programId=form.down("#programBatch_programId").getValue();
						var batchId=form.down("#programBatch_batchId").getValue();
						var periodId=form.down("#programBatch_periodId").getValue();
						
						this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(false);
						form.down('#courseId').setValue(courseId);
						form.down('#courseSectionId').setValue(sectionId);
						form.down('#courseComponentId').setValue(courseComponentId);
						form.down('#sectionTypeId').setValue(sectionType);
						
						
						var topicsBox = form.down('customcombobox#topicsId');
						var multipleTopicsBox = form.down('#multipleTopicsId');
						topicsBox.clearValue();
						topicsBox.setDisabled(false);
						multipleTopicsBox.setDisabled(false);
						
						var multipleTopicStore = multipleTopicsBox.getStore();
						multipleTopicStore.getProxy().extraParams = {
							courseId: courseId,
						};
						multipleTopicStore.load();
					}
				},
				'detailedschedulefacultysearchfilter button[itemId=resetSearchFilterId]' : {
					click : function(){
						this.resetDetailedScheduleFacultySearchFilter();
					}
				},
				'detailedschedulefacultysearchfilter button[itemId=viewSearchFilterId]' :{
					click : function(obj, record){
						var me = this;
						var contentPanel = me.getContentPanel();
			    		var structure = contentPanel.down('personinfofacultyportal');
			    		var structureBody = structure.body;
			    		var currentTimeHour = 8;//new Date().getHours();
			    		structureBody.setScrollTop();
			    		structureBody.scrollBy(0,274);
			    		setTimeout(function(){
			    			structureBody.scrollBy(0,((75*currentTimeHour)));
			    		},100);
						this.loadFacultyDetailedScheduleGrid();
						this.sendCalendarEventsRequestFacultyDetailedSchedule('FACULTY', '#personViewCalendar', SERVERURL.PATH_GET_FACULTY_DETAILED_SCHEDULE);
				

						
					}
				},
				'assignedtopicdetailwindow grid[itemId=assignedTopicDetailGrid]' :{
					selectionchange: function(column, selected,eOpts ){
						var grid = this.getAssignedtopicdetailwindow().down('grid');
						var deleteTopicButton = grid.down('#btnDelete');
						if(selected.length > 0){
							deleteTopicButton.setDisabled(false);
						} else {
							deleteTopicButton.setDisabled(true);
						}
					}
				},
       		 'extendedtimetableexportreportwindow button[itemId=submitBtn]':{
    			 click : function() {
    				 this.downloadD1D2Report();
    			 }
    		 },
				'assignedtopicdetailwindow grid[itemId=assignedTopicDetailGrid] button[itemId=btnDelete]' :{
					click : function(obj, record){
						var me = this;
						var grid = this.getAssignedtopicdetailwindow().down('grid');
						if(grid.getSelectionModel().getCount() > 0) {
							var records = grid.getSelectionModel().getSelection();
							var sessionTopicIds = [];
							for(var rec in records){
								sessionTopicIds.push(records[rec].data.id);
							}
							showConfirmMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									function(btn, text) {
								if (btn == 'yes'){
									Ext.Ajax.request({
										method: "DELETE",
										type: 'rest',
										url: SERVERURL.PATH_DELETE_ASSIGN_SESSION_TOPIC+'?ids='+sessionTopicIds.join(),
										headers: {
											'Content-Type': 'application/json'
										},
										params: {
											ids: sessionTopicIds.join()
										},
										success: function(form, action) {
											me.getAssignedtopicdetailwindow().close();
											showSuccessMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getCommonTranslation('SUCCESS'));
											me.getFacultydetailedschedulegrid().getStore().reload();
											me.getFacultydetailedschedulegrid().down('#assignTopicButton').setDisabled(true);
											me.getFacultydetailedschedulegrid().getSelectionModel().deselectAll(true);
										}
									});
								}
							});
						} else {
							showWarningMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
				},
				'scheduledetails[itemId=facultyPortalScheduleDetails] radiogroup[itemId=viewCalendarId]': {
	            	change: function(obj,rec) {
                     if(rec.isViewCalendar){
	            			this.sendCalendarEventsRequestFacultyDetailedSchedule('FACULTY', '#personViewCalendar', SERVERURL.PATH_GET_FACULTY_DETAILED_SCHEDULE);	
	            		}else{
	            			var scheduleController = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyCourseExecutionController');
	            			this.sendCalendarEventsWithDateFilter('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS);
	            		
	            		} 
                            var this$ = this;
		            		var contentPanel = this$.getContentPanel();
		            		var structure = contentPanel.down('personinfofacultyportal');
		            	//	structure.down('#viewCalendarId').items.items[1].setValue(true);
		            		//structure.down('#viewCalendarId').items.items[0].setValue(true);
                            var structureBody = structure.body;
		            		var currentTimeHour = 8;//new Date().getHours();
		            		structureBody.setScrollTop();
		            		structureBody.scrollBy(0,300);
		            		setTimeout(function(){
		            			structureBody.scrollBy(0,((75*currentTimeHour)));
		            		},100);
	            	}
	            },
	            'scheduledetails[itemId=facultyPortalScheduleDetails] calendarpanel[itemId=personViewCalendar]': {
	                afterrender:function(calender){
	                	var me=this;
	                	var portalId = this.getCurrentLoggedPortalId();
	                	setTimeout(function(){
	                		var contentPanel = me.getContentPanel();
		            		var structure = contentPanel.down('personinfofacultyportal');
	                    	
	                    	var structureBody = structure.body;
	                        var currentTimeHour = 8;//new Date().getHours();
	                    	structureBody.setScrollTop();
	                    	structureBody.scrollBy(0,279);
	                   		structureBody.scrollBy(0,((75*currentTimeHour)));
	                	},500);
	                
	                }
	            }
			});
		},
		resetDetailedScheduleFacultySearchFilter:function(){
			var this$ = this;
			var form = this$.getDetailedschedulefacultysearchfilter();
			form.down('#programBatch_periodId').reset();
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var aLId = this.getCurrentAcademyLocation();
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			var acdemicTerm = form.down('#academicTermId');
			var academicTermStore = form.down('#academicTermId').getStore();
			var courseVarientCombo=form.down("#courseVariantId");
			var programCombo=form.down("#programBatch_programId");
			var batchCombo=form.down("#programBatch_batchId");
			var periodCombo=form.down("#programBatch_periodId");
			var topicsBoxCombo = form.down('customcombobox#topicsId');
			var multipleTopicsBoxCombo = form.down('#multipleTopicsId');
			
			acdemicTerm.reset();
			
			topicsBoxCombo.reset();
			topicsBoxCombo.setDisabled(true);
			
			multipleTopicsBoxCombo.reset();
			multipleTopicsBoxCombo.setDisabled(true);
			
			programCombo.reset();
			programCombo.setDisabled(false);

			batchCombo.reset();
			batchCombo.setDisabled(true);

			periodCombo.reset();
			periodCombo.setDisabled(true);

			courseVarientCombo.reset();
			courseVarientCombo.setDisabled(false);
			
			if(wheatherSchool) {
				periodCombo.setVisible(false);
			}
			
			this.getFacultydetailedschedulegrid().down('#exportReport').setDisabled(true);
        	 
			form.down('#fromDate_Id').reset();
			form.down('#toDate_Id').reset();
			form.down('#fromDate_Id').setMinValue(null);
			form.down('#fromDate_Id').setMaxValue(null);
			form.down('#toDate_Id').setMinValue(null);
			form.down('#toDate_Id').setMaxValue(null);
			
			var academicTermId = 0;
			
			academicTermStore.getProxy().extraParams = {
				academyLocationIds:aLId
			};
			academicTermStore.load({
				callback: function(rec, success) {
					if (success) {
						for(var i in rec){
							if(rec[i].get('sequence')==1){
								acdemicTerm.setValue(rec[i].data.id);
								academicTermId=rec[i].data.id ;

								programCombo.reset();
								programCombo.setDisabled(false);

								batchCombo.reset();
								batchCombo.setDisabled(true);

								periodCombo.reset();
								periodCombo.setDisabled(true);

								var programStore = form.down('#programBatch_programId').getStore();
								programStore.getProxy().extraParams = {
									academyLocationIds:aLId,
									academicTermId:academicTermId,
									facultyId:facultyId
								};
								programStore.load();

								var courseVarientStore=courseVarientCombo.getStore();
								courseVarientCombo.reset();
								courseVarientStore.getProxy().extraParams = {
									academyLocationIds:aLId,
									academicTermId:academicTermId,
									facultyId:facultyId
								};
								courseVarientStore.load();
							}
						}
						if(academicTermId == 0){
							var programStore = form.down('#programBatch_programId').getStore();
							programStore.getProxy().extraParams = {
								academyLocationIds:aLId,
								facultyId:facultyId
							};
							programStore.load();	

							var courseVarientStore=courseVarientCombo.getStore();
							courseVarientCombo.reset();
							courseVarientStore.getProxy().extraParams = {
								academyLocationIds:aLId,
								facultyId:facultyId
							};
							courseVarientStore.load();
						}
					}
				}
			});
		},
		loadFacultyDetailedScheduleGrid: function(){
			var this$=this;
			var grid = this.getFacultydetailedschedulegrid();
			grid.setVisible(true);
			var store = grid.getStore();
			var form = this$.getDetailedschedulefacultysearchfilter().getForm();
			var values = form.getValues();
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var aLId = this.getCurrentAcademyLocation();
			
			var multiselectTopics = form.findField('multiselectTopics').getValue();
			/*** for multiple topics ***/
		     var multiTopicsData;
		     var multiTopicsArrayData=[];
		     for(var i in multiselectTopics){
		         if(Ext.isObject(multiselectTopics[0])){
		        	 multiTopicsData = multiselectTopics[i].get("id");
		        	 multiTopicsArrayData.push(multiTopicsData);
		         }else{
		        	 multiTopicsData = multiselectTopics[i];
		        	 multiTopicsArrayData.push(multiTopicsData);
		         }
		     }
			
			var topics =[];
			if(multiTopicsArrayData.length > 0){
				for(var i=0; i<multiTopicsArrayData.length;i++){
					topics.push(multiTopicsArrayData[i]);
				}
			}else if(values.topics !="" && values.topics !=null  ){
				topics.push(values.topics);
			}
			var academicTermId = form.findField('academicTerm').getValue();
			var programId = form.findField('programId').getValue();
			var batchId = form.findField('batchId').getValue();
			var periodId = form.findField('periodId').getValue();
			var courseVariantId = form.findField('courseVariant').getValue();
			var startDate = form.findField('fromDate').getValue();
			var endDate = form.findField('toDate').getValue();
			
			var gridStore = grid.getStore();
			gridStore.getProxy().extraParams = {
				academyLocationId : aLId,
				facultyId:facultyId,
				academicTerm:academicTermId,
				programId:programId,
				batchId:batchId,
				periodId:periodId,
				courseVariantId:courseVariantId,
				topicId:topics.join(),
				fromDate:startDate,
				toDate:endDate,
				sectionTypeCheck:false
			};
			this.resetPageSetting(gridStore);
			gridStore.load();
		},
		getIdValueJson: function(id, value) {
			if (id) return {
				id: id,
				value: value
			};
		},
		viewAssignedTopics: function(view, record) {
			var courseCoveragePlanId = record.data.id;
			var studentCourseAttendanceId = record.data.studentCourseAttendanceId
			var formWindow = this.getAssignedtopicdetailwindow();
			if (!formWindow) {
				Ext.widget('assignedtopicdetailwindow');
				formWindow = this.getAssignedtopicdetailwindow();
			}
			formWindow.show();
			if(studentCourseAttendanceId > 0) {
				formWindow.down('grid').down('#btnDelete').setVisible(false);
			} else {
				formWindow.down('grid').down('#btnDelete').setVisible(true);
			}
			var store = formWindow.down('grid').getStore();
			store.getProxy().extraParams = {
				courseCoveragePlanIds: courseCoveragePlanId,
			};
			store.load();
		},
		sendCalendarEventsRequestFacultyDetailedSchedule: function(personType, calenderItemId, submitURL) {
			
			 var $this = this;
			 var structure = this.getDetailedschedulefacultystructure();
			 
	       	 var calendarPanelStructure =structure.down('#facultyPortalScheduleDetails');
	       	 var tabPanel = structure.down('#pendingattendancereportpanelId');
	       	 if(tabPanel.getActiveTab().title == getProgramandcourseTranslation('GRID')) {
	       		if(!isNullOrEmpty(calendarPanelStructure)) {
		       		calendarPanelStructure.destroy();
		       	 }
		       	 tabPanel.insert(1,{xtype:'scheduledetails', itemId:'facultyPortalScheduleDetails', title:getProgramandcourseTranslation('CALENDAR'), closable:false});
	       	 }
	       	 
			var this$ = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var aLId = this.getCurrentAcademyLocation();
			var form = this$.getDetailedschedulefacultysearchfilter().getForm();
			var values = form.getValues();
			//var calendar = this.getScheduledetails();
			
	        var calendar = this.getDetailedschedulefacultystructure().down('#facultyPortalScheduleDetails');
			
			var academicTermId = form.findField('academicTerm').getValue();
			var programId = form.findField('programId').getValue();
			var batchId = form.findField('batchId').getValue();
			var periodId = form.findField('periodId').getValue();
			var courseVariantId = form.findField('courseVariant').getValue();
			var startDate = form.findField('fromDate').getValue();
			var endDate = form.findField('toDate').getValue();
			
			var multiselectTopics = form.findField('multiselectTopics').getValue();
			this.getDetailedschedulefacultysearchfilter().down('#detailedScheduleFacultySearchFormItemId').collapse(true);
			/*** for multiple topics ***/
		     var multiTopicsData;
		     var multiTopicsArrayData=[];
		     for(var i in multiselectTopics){
		         if(Ext.isObject(multiselectTopics[0])){
		        	 multiTopicsData = multiselectTopics[i].get("id");
		        	 multiTopicsArrayData.push(multiTopicsData);
		         }else{
		        	 multiTopicsData = multiselectTopics[i];
		        	 multiTopicsArrayData.push(multiTopicsData);
		         }
		     }
			
			var topics =[];
			if(multiTopicsArrayData.length > 0){
				for(var i=0; i<multiTopicsArrayData.length;i++){
					topics.push(multiTopicsArrayData[i]);
				}
			}else if(values.topics !="" && values.topics !=null  ){
				topics.push(values.topics);
			}
			
			var params = new Object();
			calendar.eventStore.getProxy().actionMethods.read = 'GET';
			if(personType == 'FACULTY'){
				params.facultyId = facultyId;
				params.academyLocationId = aLId;
				params.academicTermId = academicTermId;
				params.programId = programId;
				params.batchId = batchId;
				params.periodId = periodId;
				params.courseVariantId = courseVariantId;
				params.start = startDate;
				params.end = endDate;
				params.courseTopicIds = topics.join();
			}
			calendar.eventStore.removeAll();
			calendar.eventStore.getProxy().url = submitURL;
			calendar.eventStore.getProxy().extraParams = params;
			calendar.eventStore.load();
			
		},
		sendCalendarEventsWithDateFilter: function(personType, calenderItemId, submitURL) {
			
			 var $this = this;
			 var structure = this.getDetailedschedulefacultystructure();
			 
	       	 var calendarPanelStructure =structure.down('#facultyPortalScheduleDetails');
	       	 var tabPanel = structure.down('#pendingattendancereportpanelId');
	       	 if(tabPanel.getActiveTab().title == getProgramandcourseTranslation('GRID')) {
	       		if(!isNullOrEmpty(calendarPanelStructure)) {
		       		calendarPanelStructure.destroy();
		       	 }
		       	 tabPanel.insert(1,{xtype:'scheduledetails', itemId:'facultyPortalScheduleDetails', title:getProgramandcourseTranslation('CALENDAR'), closable:false});
	       	 }
	       	 
			var this$ = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var aLId = this.getCurrentAcademyLocation();
			var form = this$.getDetailedschedulefacultysearchfilter().getForm();
			var values = form.getValues();
			//var calendar = this.getScheduledetails();
			
	        var calendar = this.getDetailedschedulefacultystructure().down('#facultyPortalScheduleDetails');
			
			
			var startDate = form.findField('fromDate').getValue();
			var endDate = form.findField('toDate').getValue();
			
		
			
			var params = new Object();
			calendar.eventStore.getProxy().actionMethods.read = 'GET';
			if(personType == 'FACULTY'){
				params.facultyId = facultyId;
				
				params.start = startDate;
				params.end = endDate;
			}
			calendar.eventStore.removeAll();
			calendar.eventStore.getProxy().url = submitURL;
			calendar.eventStore.getProxy().extraParams = params;
			calendar.eventStore.load();
		
		},
		assignTopicInSession: function() {
			var this$ = this;
			var grid = this.getAssigntopicgrid();
			var structure = this.getAssigntopicstructure();
			var ccpIds = structure.down('#courseCovergaPlanIds').getValue();
			var courseCovergaPlanIds = ccpIds.split(',');
			if(grid.getSelectionModel().getCount() > 0) {
				var records = grid.getSelectionModel().getSelection();
				var masterData=[];
				for(var rec in records) {
					for(var ccpId in courseCovergaPlanIds){
						masterData.push({
							"courseCoveragePlan":this$.getIdValueJson(courseCovergaPlanIds[ccpId]),
							"courseTopic":this$.getIdValueJson(records[rec].data.id)
						});
					}
				}
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				submitUrl = SERVERURL.PATH_SAVE_ASSIGN_SESSION_TOPIC;
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : masterData,
					method : 'POST',
					success : function(form, action) {
						Ext.getBody().unmask();
						structure.up().up().getActiveTab().close();
						showSuccessMessage(getProgramandcourseTranslation('DETAILED_SESSION'),getCommonTranslation('SUCCESS'));
						this$.getFacultydetailedschedulegrid().getStore().reload();
						this$.getFacultydetailedschedulegrid().down('#assignTopicButton').setDisabled(true);
						this$.getFacultydetailedschedulegrid().getSelectionModel().deselectAll(true);
					}
				});
			} else {
				showWarningMessage(getProgramandcourseTranslation('DETAILED_SESSION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			} 
		},
	     openExportReportWindow:function(){
	    	  var formWindow = this.getExtendedtimetableexportreportwindow();
	    	  if (!formWindow) {
	    		  Ext.widget('extendedtimetableexportreportwindow');
	    		  formWindow = this.getExtendedtimetableexportreportwindow();
	    	  }
	    	  formWindow.show();
	    	  var tempalte = formWindow.down('#exportType').getStore();
	    	  tempalte.getProxy().extraParams={
	    		  reportType:'Planning Reports'
	    	  };
	    	  tempalte.load();
	      },  
	      downloadD1D2Report:function(){
	    	  var $this = this;
	    	  var form = $this.getDetailedschedulefacultysearchfilter().getForm();
	    	  var formValues = form.getValues();
	    	  var program = formValues.programId;
	    	  var batch = formValues.batchId;
	    	  var period = formValues.periodId;
	    	  var academicTermId = formValues.academicTerm;
	    	  var sectionType = form.findField('sectionType').getValue();

	    	  var fromDate = formValues.fromDate;
	    	  var toDate = formValues.toDate;
	    	  var course;

	    	  if(formValues.courseId!=null){
	    		course=  parseInt(formValues.courseId);
	    	  }
	    	  
	    	 
	    	  var programId;
	    	  if(program !="" && program !=null){
	    		  programId = program; 
	    	  }
	    	  var batchId;
	    	  if(batch !="" && batch !=null){
	    		  batchId = batch; 
	    	  }
	    	  
	    	  var periodId;
	    	  if(period !="" && period !=null){
	    		  periodId = period; 
	    	  }
	    	  
	    	  var courseId;
	    	  if(course !="" && course !=null){
	    		  courseId = course; 
	    	  }
	    	  
	    	  var component;
	    	  if(formValues.component!=null){
	    		  component = parseInt(formValues.component);
	    	  }
	    	  var componentId;
	    	  if(!isNullOrEmpty(component)){
	    		  componentId = component; 
	    	  }
	    	  
	    	  var section; 
	    	  if(formValues.section!=null){
	    		  section = parseInt(formValues.section);
	    	  }
	    	  var sectionId;
	    	  if(section !="" && section !=null){
	    		  sectionId = section; 
	    	  }
	    	  
	    	  topics = formValues.multiselectTopics;
	    	  var faculty = this.getCurrentlyLoggedInUser();
	    	 
	    	  var topicsId = new Array();
	    	  if(topics !=undefined && topics.length > 0){
	    		  for(var i in topics){
	    			  if(Ext.isObject(topics[i])){
	    				  topicsId.push(topics[i].get("id"));
	    			  }else{
	    				  topicsId.push(topics[i]);
	    			  }
	    		  }
	    	  }
	    	  var facultyId = [];
	    	  if(faculty.id !=undefined && faculty.id.length > 0){
	    		
	    	   facultyId.push(faculty.id);
	    		
	    	  }
	    	  var window = this.getExtendedtimetableexportreportwindow();
	    	  var reportValue = window.down('#exportType').valueModels[0].data.value;
	    	  var academyLocationId = this.getCurrentAcademyLocation();
	    	  var code;
	    	  var reportTitle;
	    	  if(reportValue == 'D1_TEACHING_PLAN'){
	    		  code ="D1_TEACHING_PLAN";
	    		  reportTitle='D1 Teaching Plan';
	    	  }else if(reportValue == 'D2_TEACHING_PLAN'){
	    		  code ="D2_TEACHING_PLAN";
	    		  reportTitle='D2 Teaching Plan';
	    	  }else if(reportValue == 'COURSE_TOPIC_REPORT'){
	    		  code ="COURSE_TOPIC_REPORT";
	    		  reportTitle=' Course Topic Report';
	    	  }
    		  var reportParams =new Object();
    		  reportParams.code = code;
    		  reportParams.reportTitle = reportTitle;
    		  reportParams.academyLocationId = academyLocationId;
    		  reportParams.academicTermId = academicTermId;
    		  reportParams.programId = programId;
    		  reportParams.batchId = batchId;
    		  reportParams.periodId = periodId;
    		  reportParams.courseId = courseId;
    		  reportParams.facultyId = facultyId.join();
    		  reportParams.componentId = componentId;
    		  reportParams.topicsId = topicsId.join();
    		  reportParams.fromDate = fromDate;
    		  reportParams.toDate = toDate;
    		  reportParams.sectionId = sectionId;
    		
    		  if(sectionType== "CourseSection"){
    			  reportParams.sectionType = 'CBS';
    		  }
    		  else{
    			  reportParams.sectionType = 'PBS';
    		  }
    		     		  
    		  var exportUrl = SERVERURL.PATH_GET_EXTENDED_TIME_TABLE_EXPORT_REPORT;
    		  var fileType = 'pdf';
    		  $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel',exportUrl);
    		  window.close();
	      },
	      onBatchChange: function(obj, record){
	    	  var me = this;
	    	  var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
	    	  var academicTermField = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
	    	  var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
	    	  var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
	    	  var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
	    	  var academicTermId = academicTermField.getValue();

	    	  var batchStore = batchField.getStore();
	    	  var courseStore = courseField.getStore();
	    	  var courseVariantStore = courseVariantField.getStore();

	    	  var batchIds = '';
	    	  var courseIds = '';

	    	  if(Ext.isDefined(batchField.getValue()) && batchField.getValue().length){
	    		  try{
	    			  batchIds = Ext.Array.pluck(Ext.Array.pluck(batchField.value,'data'),'id').join();
	    		  }
	    		  catch(e){
	    			  try{
		    			  if(typeof batchField.value[0] != "object"){
		    				  batchIds = batchField.value.join();
		    			  }
	    			  }
	    			  catch(e){}
	    		  }
	    	  }

	    	  courseStore.getProxy().extraParams = {
	    		  academicTermId:academicTermId,
	    		  batchIds: batchIds
	    	  };

	    	  courseField.reset();
	    	  courseVariantField.reset();

	    	  courseField.setDisabled(true);
	    	  courseVariantField.setDisabled(true);
	    	  
	    	  me.validateImportSessionTopicsDownloadCBSForm();

	    	  courseStore.load({
	    		  callback: function(rec, success){
	    			  if (success) {
	    				  courseField.setDisabled(false);
	    				  if(rec.length==1){
	    					  courseField.setValue(rec[0].get('courseId'));

	    					  if(Ext.isDefined(courseField.getValue()) && courseField.getValue().length){
	    						  try{
	    							  courseIds = rec[0].get('courseId');
	    						  }
	    						  catch(e){}
	    					  }

	    					  var courseVariantStoreExtraParams = {
	    							  academicTermId:academicTermId,
	    							  courseIds: courseIds,
	    							  batchIds: batchIds
	    					  }

	    					  courseVariantStore.getProxy().extraParams = courseVariantStoreExtraParams;
	    					  me.validateImportSessionTopicsDownloadCBSForm();
	    					  courseVariantStore.load({
	    						  callback: function(rec, success){
	    							  if (success && !isNullOrEmpty(courseIds)) {
	    								  courseVariantField.setDisabled(false);
	    								  if(rec.length==1){
	    									  courseVariantField.setValue(rec[0].get('id'))
	    								  }
	    								  me.validateImportSessionTopicsDownloadCBSForm();
	    							  }
	    						  }
	    					  });
	    				  }
	    			  }
	    		  }
	    	  });
	      },
	      onCourseChange: function(obj, record){
	    	  var me = this;
	    	  var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
	    	  var facultyId = this.getCurrentlyLoggedInUser().id;
	    	  var academicTermField = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
	    	  var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
	    	  var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
	    	  var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
	    	  var academicTermId = academicTermField.getValue();
	    	  courseVariantField.reset();
	    	  courseVariantField.setDisabled(true);
	    	  var courseVariantStore = courseVariantField.getStore();

	    	  var batchIds = '';
	    	  var courseIds = '';

	    	  if(Ext.isDefined(courseField.getValue()) && courseField.getValue().length){
	    		  try{
	    			  courseIds = Ext.Array.pluck(Ext.Array.pluck(courseField.value,'data'),'id').join();
	    		  }
	    		  catch(e){
	    			  try{
		    			  if(typeof courseField.value[0] != "object"){
		    				  courseIds = courseField.value.join();
		    			  }
	    			  }
	    			  catch(e){}
	    		  }
	    	  }

	    	  courseVariantStore.getProxy().extraParams = {
	    		  academicTermId:academicTermId,
	    		  courseIds: courseIds,
	    		  batchIds: batchIds,
	    		  facultyId : facultyId
	    	  };
	    	  
	    	  me.validateImportSessionTopicsDownloadCBSForm();

	    	  courseVariantStore.load({
	    		  callback: function(rec, success){
	    			  if (success && !isNullOrEmpty(courseIds)) {
	    				  courseVariantField.setDisabled(false);
	    				  if(rec.length==1){
	    					  courseVariantField.setValue(rec[0].get('id'))
	    				  }
	    			  }
    				  me.validateImportSessionTopicsDownloadCBSForm();
	    		  }
	    	  });
	      },
   	      
   	      validateImportSessionTopicsDownloadCBSForm: function(){
   	    	  var me = this;
   	    	  var importsessiontopicsdownloadcbspanel = me.getImportsessiontopicsdownloadcbspanel();
   	    	  var academicTermIdCBS = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
   	    	  var course_Id = importsessiontopicsdownloadcbspanel.down('#course_Id');
   	    	  var importSessionTopicCBSDownload = importsessiontopicsdownloadcbspanel.down('#importSessionTopicCBSDownload');
   	    	  
   	    	  if(isNullOrEmpty(academicTermIdCBS.getValue()) || isNullOrEmpty(course_Id.getValue())){
   	    		  importSessionTopicCBSDownload.setDisabled(true);
   	    	  }
   	    	  else{
   	    		  if(course_Id.getValue().length==1 && isNullOrEmpty(course_Id.getValue()[0])){
   	    			  importSessionTopicCBSDownload.setDisabled(true);
   	    		  }
   	    		  else{
   	    			  importSessionTopicCBSDownload.setDisabled(false);
   	    		  }
   	    	  }
   	      },
   	      
   	   getDownloadFile : function(documentId,fileType){

       	if(!isNullOrEmpty(documentId)){
       		var csvForm = Ext.create('Ext.form.Panel'); 
       		csvForm.getForm().submit({
       			target: '_blank',
       			method:'POST',
       			params :{
       				access_token : Ext.Ajax.defaultHeaders.access_token
       			},
       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
       			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
       			standardSubmit :true
       		});
       	}
       },
       
       resetImportSessionTopicPBSFilter : function(panel){

			var me = this;
			var academyLocationId = this.getCurrentAcademyLocation();
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academicTermCombo = panel.down('#academicTermIdPBS');
			var batchField = panel.down('#batchIdPBS');
			var periodField = panel.down('#periodIdPBS');
			var courseField = panel.down('#course_IdPBS');
			
			academicTermCombo.reset();
			batchField.reset();
			courseField.reset();
			periodField.reset();
			
			batchField.setDisabled(true);
			courseField.setDisabled(true);
			periodField.setDisabled(true);
			
			var academicTermComboStore = academicTermCombo.getStore();
			academicTermComboStore.getProxy().extraParams = {
				academyLocationIds : academyLocationId,
				facultyId : facultyId
			};
			academicTermComboStore.load({
				callback: function(rec, success) {
					if (success) {
						for(var i in rec){
							if(rec[i].get('sequence')==1){
								academicTermCombo.setValue(rec[i].get('id'));
							}
						}
					}
				}
			});
       },
       
       resetImportSessionTopicCBSFilter : function(panel){
    	   var me = this;
 			var academyLocationId = this.getCurrentAcademyLocation();
 			var facultyId = this.getCurrentlyLoggedInUser().id;
 			var academicTermCombo = panel.down('#academicTermIdCBS');
 			var batchField = panel.down('#batchId');
 			var courseField = panel.down('#course_Id');
 			var courseVariantField = panel.down('#downloadCourseVariant_ID');
 			
 			academicTermCombo.reset();
 			batchField.reset();
 			courseField.reset();
 			courseVariantField.reset();
 			
 			batchField.setDisabled(true);
 			courseField.setDisabled(true);
 			courseVariantField.setDisabled(true);
 			
 			var academicTermComboStore = academicTermCombo.getStore();
 			academicTermComboStore.getProxy().extraParams = {
 				academyLocationIds : academyLocationId,
 				facultyId : facultyId
 			};
 			academicTermComboStore.load({
 				callback: function(rec, success) {
 					if (success) {
 						for(var i in rec){
 							if(rec[i].get('sequence')==1){
 								academicTermCombo.setValue(rec[i].get('id'));
 							}
 						}
 					}
 				}
 			});
       }
});