
/**
 * @author Deepak.Nigam
 *  This controller is used for student Examination Documents.
 */

Ext.define('Academia.controller.personinfo.student.StudentExaminationDocumentsController', {
    extend: 'Academia.controller.base.BaseController',

    alias: "widget.studentexaminationdocumentscontroller",

    stores: ['personinfo.student.GenerateHallTicketGridStore', 'examinationcenters.evaluationgroup.AttestationFormGridStore',
             'personinfo.student.StudentMarksheetStore'],

    views: [ 'studentPortal.examinationDocuments.GenerateHallTicketMarksheetStructureForPortal','studentPortal.examinationDocuments.GenerateHallTicketStudentPortalGrid',
             'studentPortal.examinationDocuments.StudentPortalMarksheetGrid'],
    
    refs: [{
        ref: 'generatehallticketmarksheetstructureforportal',
        selector: 'generatehallticketmarksheetstructureforportal'
    },{
        ref: 'generatehallticketstudentportalgrid',
        selector: 'generatehallticketstudentportalgrid[itemId=generatehallticketPortalgrid]'
    },{
    	ref:'studentportalmarksheetgrid',
    	selector : 'studentportalmarksheetgrid'
    }],
    config: {
    	
    	STUDENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_DOCUMENTS_HALL_TICKET_PRIVILEGES'),
    	STUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PRIVILEGES'),
    	PARENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_DOCUMENTS_HALL_TICKET_PRIVILEGES'),
    	PARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            
            'generatehallticketstudentportalgrid[itemId=generatehallticketPortalgrid] button[itemId=btnDownloadAllHallTickets]':{
 			   click:function(obj){
 				   this.downloadAllHallTicketZip();
 			   }
 		   },
 		   
 		  'generatehallticketstudentportalgrid[itemId=generatehallticketPortalgrid]':{
			   render: function(grid) {
				   
				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	               
               	   if(!wheatherSchool){
               		var gridColumns = grid.columns;
               		var len = gridColumns.length;
               		for (var j = 0; j < len; j++) {
						var gridColumn = gridColumns[j];
						if (gridColumn.dataIndex == "periodName") {
							gridColumn.show();
						}
               		}
               	   }
               	   
				   if(this.getCurrentLoggedPortalId() == 3) {

					   this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS());
					   this.doAccessControlHallTicketBtnValidation(grid, this.getSTUDENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS());
					   grid.down('#btnExportToPDF').setDisabled(true); 
					   grid.down('#btnExportToExcel').setDisabled(true);

					   var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();

					   var admissionId = portalInfo.admissionDetails[0].id;
					   var programId = portalInfo.programBatchDetails.programId;
					   var batchId = portalInfo.programBatchDetails.batchId;
					   var periodId = portalInfo.programBatchDetails.periodId;
					   var studentId = portalInfo.student.id;
					   
					   var store = grid.getStore();
					   store.getProxy().api.read = SERVERURL.FIND_ALL_PUBLISHED_HALL_TICKET_ADMISSIONID;
					   store.getProxy().extraParams={
//						   admissionId:admissionId,
						   studentId:studentId,
						   reportEnum :'HALL_TICKET',
						   periodId:periodId
					   };

					   store.load();
				   }else if (this.getCurrentLoggedPortalId() == 7){

					   this.doAccessControlValidation(grid, this.getPARENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS());
					   this.doAccessControlHallTicketBtnValidation(grid, this.getPARENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS());
					   grid.down('#btnExportToPDF').setDisabled(true); 
					   grid.down('#btnExportToExcel').setDisabled(true);

					   var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();

					   var admissionId = portalInfo.admissionDetails[0].id;
					   var programId = portalInfo.programBatchDetails.programId;
					   var batchId = portalInfo.programBatchDetails.batchId;
					   var studentId = portalInfo.student.id;
					   var store = grid.getStore();
					   store.getProxy().api.read = SERVERURL.FIND_ALL_PUBLISHED_HALL_TICKET_ADMISSIONID;
					   store.getProxy().extraParams={
//						   admissionId:admissionId,	
						   studentId:studentId,
						   reportEnum :'HALL_TICKET'
					   };

					   store.load();
				   }
					   
			   },
			   cellclick:function(view, td, colIndex, record, event,target,pop){
				   if(pop.target.tagName=='A'){
					   var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
					   var csvForm = Ext.create('Ext.form.Panel'); 
					   var filePath = window.btoa(unescape(encodeURIComponent(record.data.hallTicketPath)));
					   csvForm.getForm().submit({
						   url : submitUrl+"?filePath="+filePath,
						   method : 'POST',
						   target: '_blank',
						   params :{
							   access_token : Ext.Ajax.defaultHeaders.access_token
						   },
						   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						   standardSubmit :true
					   });
				   }
			   },
			   select:function(obj, record,rowIndex, e){
				   var $this = this;
				   var grid = $this.getGeneratehallticketstudentportalgrid();
				   if(obj.selected.items.length>=1){
					   var records=grid.getSelectionModel().getSelection();
					   for(var i in records) {
						   if(records[i].get('hallTicketPath')==null || records[i].get('hallTicketPath')=='') {
							   grid.down('#btnDownloadAllHallTickets').setDisabled(true);
							   break;
						   }
						   else{
							   grid.down('#btnDownloadAllHallTickets').setDisabled(false);
						   }
					   }
				   } else {
					   grid.down('#btnDownloadAllHallTickets').setDisabled(true);
				   }
			   },
			   deselect:function(obj, record, rowIndex, e){
				   var $this = this;
				   var grid = $this.getGeneratehallticketstudentportalgrid();
				   if(obj.selected.items.length>=1){
					   var records=grid.getSelectionModel().getSelection();
					   for(var i in records) {
						   if(records[i].get('hallTicketPath')==null || records[i].get('hallTicketPath')=='') {
							   grid.down('#btnDownloadAllHallTickets').setDisabled(true);
							   break;
						   }
						   else{
							   grid.down('#btnDownloadAllHallTickets').setDisabled(false);
						   }
					   }
				   } else {
					   grid.down('#btnDownloadAllHallTickets').setDisabled(true);
				   }
			   }
		   },
		   
		   'studentportalmarksheetgrid ':{
			   select:function(obj, record,rowIndex, e){
				   var studentGrid=this.getStudentportalmarksheetgrid();

				   /**
				    * this condition is for student's can't selected with students whose marksheet already created.   
				    */
				   if(obj.selected.items.length>1){
					   var newLength=obj.selected.items.length-2;
					   if((!obj.selected.items[newLength].data.marksheetPath && record.data.marksheetPath) ||
							   (!record.data.marksheetPath && obj.selected.items[newLength].data.marksheetPath)){
						   obj.deselect(record);
						   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
					   }
				   }	        				 

				   if (studentGrid.getSelectionModel().getCount() > 0) {
					   var records = studentGrid.getSelectionModel().getSelection();
					   this.enableDisableDownloadAllBtn(studentGrid,records);
				   } else {
					   var buttonsToolBar = studentGrid.query('toolbar')[0];
					   var downloadAllButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
					   downloadAllButton.disable();
				   }
			   },
			   deselect:function(obj, record, rowIndex, e){
				   var studentGrid=this.getStudentportalmarksheetgrid();
				   if (studentGrid.getSelectionModel().getCount() > 0) {
					   var records = studentGrid.getSelectionModel().getSelection();
					   this.enableDisableDownloadAllBtn(studentGrid,records);
				   } else {
					   var buttonsToolBar = studentGrid.query('toolbar')[0];
					   var downloadAllButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
					   downloadAllButton.disable();
				   }
			   }
		   },
		   'studentportalmarksheetgrid': {
			   render: function(grid) {                	                	

				   if(portalId == 7){
					   this.doAccessControlValidation(grid, this.getPARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS());
					   this.doAccessControlMarksheetBtnValidation(grid, this.getPARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS());
				   }else{
					   this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS());
					   this.doAccessControlMarksheetBtnValidation(grid, this.getSTUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS());
				   }
				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	               
               	   if(!wheatherSchool){
               		var gridColumns = grid.columns;
               		var len = gridColumns.length;
               		for (var j = 0; j < len; j++) {
						var gridColumn = gridColumns[j];
						if (gridColumn.dataIndex == "periodName") {
							gridColumn.show();
						}
               		}
               	   }

				   var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
				   var admissionId = portalInfo.admissionDetails[0].id;
				   var studentId = portalInfo.student.id;
				   
				   var store  = grid.getStore();
				   store.getProxy().extraParams = {
//					   admissionId : admissionId
					   studentId : studentId
				   }
				   store.load();
			   },
			   cellclick:function(view, td, colIndex, record, event,target,pop){
				   if(pop.target.tagName=='A'){
					   var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
					   var csvForm = Ext.create('Ext.form.Panel'); 
					   var filePath = window.btoa(unescape(encodeURIComponent(record.data.marksheetPath)));
					   csvForm.getForm().submit({
						   url : submitUrl+"?filePath="+filePath,
						   method : 'POST',
						   target: '_blank',
						   params :{
							   access_token : Ext.Ajax.defaultHeaders.access_token
						   },
						   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						   standardSubmit :true
					   });
				   }
			   }
		   },
		   
		   'studentportalmarksheetgrid button[itemId=btnDownloadAllMarksheet]':{
			   click:function(obj){
				   this.downloadAllMarksheetZip();
			   }
		   },
		   
		   'generatehallticketmarksheetstructureforportal':{
			   beforerender:function(structure){
 				   this.stuentExaminationDocumenttabPermissionMangement(structure);
 			   }
 		   }
		   
        });
    },
    
    /**
      * Download All Hall Ticket. 
      */
    downloadAllHallTicketZip:function(){
    	var $this=this;
    	var studentGrid=$this.getGeneratehallticketstudentportalgrid();
    	if (studentGrid.getSelectionModel().getCount() > 0) {
    		var records = studentGrid.getSelectionModel().getSelection();
    		var saveModel=[];  
			
			//Commented as date is already added in the zipFileName variable in the backend controller
    		//var hallTicketZipName = records[0].get('evaluationGroupCode')+'_'+new Date();
    		var hallTicketZipName = records[0].get('evaluationGroupCode'); 
    		for(var i in records){
    			if(!isNullOrEmpty(records[i].get('hallTicketPath'))) {
					   var filePath = window.btoa(unescape(encodeURIComponent(records[i].get('hallTicketPath'))));
					   saveModel.push(filePath);
    			}
    		}
    		showConfirmMessage(getExaminationTranslation('HALL_TICKET'),
    				getExaminationTranslation('DOWNLOAD_ALL_HALL_TICKET_MSG'),function(btn, text) {
    			if (btn == 'yes') {
    				var directoryType = CONSTANTS.DIRECTORY_TYPE_MARKSHEET;
    				$this.getController('Academia.controller.document.DocumentController').downloadMultipleDocumentFile(saveModel, hallTicketZipName, directoryType);
    			}});
    	}else {
    		$this.hideWindowMask();
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
      * Download all Marksheet generation
      */
	   downloadAllMarksheetZip:function(){
		   var $this=this;
		   var studentGrid=$this.getStudentportalmarksheetgrid();
		   if (studentGrid.getSelectionModel().getCount() > 0) {
			   var records = studentGrid.getSelectionModel().getSelection();
			   var saveModel=[];  

			   var studentDetails = $this.getCurrentlyLoggedInUserInfoForPortal().student;
			   
			   var marksheetZipName =  studentDetails.code+'_'+studentDetails.firstName+'_'+records[0].get('programName');
			   
			   for(var i in records){
				   if(!isNullOrEmpty(records[i].get('marksheetPath'))) {
					   var filePath = window.btoa(unescape(encodeURIComponent(records[i].get('marksheetPath'))));
					   saveModel.push(filePath);
				   }
			   }
			   showConfirmMessage(getExaminationTranslation('MARKSHEET'),getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET_MSG'),function(btn, text) {
				   if (btn == 'yes') {
					   var directoryType = CONSTANTS.DIRECTORY_TYPE_MARKSHEET;
					   $this.getDocumentController().downloadMultipleDocumentFile(saveModel, marksheetZipName, directoryType);
				   }});
		   }else {
			   $this.hideWindowMask();
			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		   }
	   },
	   
	   enableDisableDownloadAllBtn : function(grid,records) {
		   var isRecordHold = false;
		   var studentGrid=this.getStudentportalmarksheetgrid();
		   var buttonsToolBar = grid.query('toolbar')[0];
		   var downloadButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
		   if (studentGrid.getSelectionModel().getCount() > 0) {
			   var records = studentGrid.getSelectionModel().getSelection();
			   var marksheetPublishFlag = false; 
			   for(var i in records){
				   if(!isNullOrEmpty(records[i].get('marksheetPath'))){
					  if(records[i].get('marksheetPath') == "Hold Applied"){
						  isRecordHold = true;
					  }
				   }
			   }
			   downloadButton.setDisabled(isRecordHold);
		   }  
	   },
	   
	   doAccessControlMarksheetBtnValidation : function(grid, permissionsMap) {
		   
		   var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	var downloadMarksheetButton = grid.down('#btnDownloadAllMarksheet');
	    	
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'DOWNLOADMARKSHEETS') {
	        		if(!isNullOrEmpty(downloadMarksheetButton)){
	        			downloadMarksheetButton.setVisible(true);
	        		}        		
	        	}
	      });
	   },
	   
	   doAccessControlHallTicketBtnValidation : function(grid, permissionsMap) {

		   var associatedAcadLocationIds = new Array();
		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   var downloadHallTicketButton = grid.down('#btnDownloadAllHallTickets');

		   Ext.each(permissionList, function(privilege) {
			   if (privilege === 'DOWNLOADALLHALLTICKET') {
				   if(!isNullOrEmpty(downloadHallTicketButton)){
					   downloadHallTicketButton.setVisible(true);
				   }        		
			   }
		   });
	   },
	   
	   getDocumentController : function() {
		   var this$ = this;
		   return this$.getController('Academia.controller.document.DocumentController');
	   },
	   
	   stuentExaminationDocumenttabPermissionMangement : function(structure) {
		   
		   var $this = this;
		   
		   var associatedAcadLocationIds = new Array();
		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   var tab1=false, tab2=false;
		   var portalId =  $this.getCurrentLoggedPortalId();
		   
		   var permissionsMap = new Ext.util.HashMap();
		   if(portalId == 7){
			   hallTicketPermissionsMap = $this.getPARENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS();
		   }else{
			   hallTicketPermissionsMap = $this.getSTUDENT_PORTAL_EXAM_HALL_TICKET_DOCUMENTS_PERMISSIONS();
		   }
		   
		   var hallTicketPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, hallTicketPermissionsMap);
		   for (var i = 0; i < hallTicketPermissionList.length; i++) {
			   if (hallTicketPermissionList[i] === "VIEW") {
				   tab1=true;
			   }
		   }
		   var permissionsMap = new Ext.util.HashMap();
		   if(portalId == 7){
			   examMarksheetsPermissionsMap = $this.getPARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS();
		   }else{
			   examMarksheetsPermissionsMap = $this.getSTUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PERMISSIONS();
		   }
		   var examMarksheetsPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, examMarksheetsPermissionsMap);

		   for (var i = 0; i < examMarksheetsPermissionList.length; i++) {
			   if (examMarksheetsPermissionList[i] === "VIEW") {
					   tab2=true;
			   }
		   }
		   
		   Ext.suspendLayouts();
		   $this.setExaminationDocumentTabsVisibility(tab1, tab2, structure);
		   Ext.resumeLayouts();
	   },
	   
	   
	   setExaminationDocumentTabsVisibility:function(tab1, tab2, structure) {
       	var panelItem = new Array();
       	var $this = this;
       	var newcont=structure.items.items.length;
       	var insertPosition=newcont+1;
       	if(tab1 && tab2) {
       		panelItem.push({
       			xtype:'panel',
       			itemId:'generatehalltickettab',
       			title: getExaminationTranslation('GENERATE_HALL_TICKET'),
//       			tabCls: 'right-tab',
       			width: '100%',
                layout: 'vbox',
                defaults:{
                    width: '100%'
                },
       			autoScroll: true,
       			items:[{
       				xtype:'generatehallticketstudentportalgrid',
       				itemId:'generatehallticketPortalgrid',
       			}]	   
       		},{
       			xtype:'panel',
       			itemId:'studentmarksheetformtab',
       			title: getExaminationTranslation('MARKSHEET'),
//       			tabCls: 'right-tab',
       			width: '100%',
                layout: 'vbox',
                defaults:{
                    width: '100%'
                },
       			autoScroll: true,
       			items:[{
       				xtype:'studentportalmarksheetgrid',
       			}] 
       		});
       	} else if(tab1) {
       		panelItem.push({
       			xtype:'panel',
       			itemId:'generatehalltickettab',
       			title: getExaminationTranslation('GENERATE_HALL_TICKET'),
       			tabCls: 'right-tab',
       			autoScroll: true,
       			items:[{
       				xtype:'generatehallticketstudentportalgrid',
       				itemId:'generatehallticketPortalgrid',
       			}]	   
       		});
       	} else if(tab2) {
       		panelItem.push({
       			xtype:'panel',
       			itemId:'studentmarksheetformtab',
       			title: getExaminationTranslation('MARKSHEET'),
       			tabCls: 'right-tab',
       			autoScroll: true,
       			items:[{
       				xtype:'studentportalmarksheetgrid',
       			}] 
       		});
       	}
       	structure.insert(insertPosition,panelItem);
       	Ext.defer(function() {
       	}, 2000, this);
       }
});
