/**
 * This controller is used for student kys information actions.
 * @author Sachin.Bangar   
 */
Ext.define('Academia.controller.personinfo.student.StudentKYSController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',

    stores: ['personinfo.common.kys.KYSDetailsStore'],

    views: ['personinfo.common.kys.KYSDetailsGrid', 'personinfo.common.kys.KYSDetailsForm'],

    alias: "widget.studentkyscontroller",

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personKYSDetailsForm',
        selector: 'kysdetailsform[itemId=studentKYSDetailsForm]'
    }, {
        ref: 'personKYSPendingDetailsForm',
        selector: 'kysdetailsform[itemId=studentKYSPendingDetailsForm]'
    }],
    config: {
    	STUDENT_KYS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_KYS_PRIVILEGES'),
    	STUDENT_PENDING_KYS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PENDING_KYS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	
        	/**
             * KYS History
             */
        	'kysdetailsgrid[itemId=studentKYSHistoryDetailsGrid]': {
                render: function(grid) {
                	grid.setTitle(getPersonModuleTranslation('KYS_HISTORY'));
                    this.loadGridStore('#studentKYSHistoryDetailsGrid', SERVERURL.PERSON_KYS_HISTORY_GRIDDATA);
                    this.doAccessControlValidation(grid, this.getSTUDENT_KYS_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getSTUDENT_KYS_PERMISSIONS());
                }
            },
            'kysdetailsgrid[itemId=studentKYSHistoryDetailsGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewKYSHistory('KYS_HISTORY', 'studentKYSDetailsForm', '#studentKYSHistoryDetailsGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] kysdetailsform[itemId=studentKYSDetailsForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },

            /**
             * Pending KYS Detail
             */

            'kysdetailsgrid[itemId=studentKYSPendingDetailsGrid]': {
            	render: function(grid) {
                	grid.setTitle(getPersonModuleTranslation('PENDING_KYS'));
                    this.loadGridStore('#studentKYSPendingDetailsGrid', SERVERURL.PERSON_PENDING_KYS_GRIDDATA);
                    this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_KYS_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getSTUDENT_PENDING_KYS_PERMISSIONS());
                }
            },
            'kysdetailsgrid[itemId=studentKYSPendingDetailsGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewKYSPendingDetails('KYS_PENDING', 'studentKYSPendingForm', '#studentKYSPendingDetailsGrid');
                }
            },
            'kysdetailsgrid[itemId=studentKYSPendingDetailsGrid] button[itemId=btnSubmit]': {
                click: function(){
                	this.submitPendingKYS('#studentKYSPendingDetailsGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] kysdetailsform[itemId=studentKYSPendingForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            }
        });
    },

    
    /**
	 *  Load store after grid renderer
	 *  @param gridItemId
	 *  @param url
	 */
	
	loadGridStore: function(gridItemId, url) {
	    var this$ = this;
	    var personProfile = this$.getContentPanelActiveTab();
	    var grid = personProfile.down(gridItemId);
	    if (grid) {
	        var studentId = personProfile.getUserId();
	        var store = grid.getStore();
	        store.getProxy().api.read = url;
	        store.getProxy().extraParams = {
            	studentId: studentId
            };
            store.load();
	    }
	},
	
	/**
	 * show person common window
	 * @param informationType
	 * @param formItemId
	 */
	showPersonCommonWindow: function(informationType, formItemId) {
	    var this$ = this;
	    var title = null,
	        xtypeForm = null;
	    var formWindow = this$.getPersonCommonWindow();
	    if (!formWindow) {
	        switch (informationType) {
	
	        case 'KYS_HISTORY':
	            { //KYS History
	                title = getPersonModuleTranslation('KYS_HISTORY');
	                xtypeForm = 'kysdetailsform';
	                break;
	            }
	        case 'KYS_PENDING':
	            { //KYS Pending Details
	                title = getPersonModuleTranslation('PENDING_KYS');
	                xtypeForm = 'kysdetailsform';
	                break;
	            }
	        default:
	            {
	                break;
	            }
	        }
	
	        formWindow = Ext.widget('personcommonwindow', {
	            title: title,
	            itemId: 'personCommonWindow',
	            items: [{
	                xtype: xtypeForm,
	                itemId: formItemId
	            }]
	        });
	    }
	
	    formWindow.show();
	},
	/**
	 * view person common window
	 */
	viewPersonCommonWindow: function(form) {
	
	    if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	
	/**
	 * Close person common window
	 */
	closePersonCommonWindow: function() {
	    var this$ = this;
	    this$.getPersonCommonWindow().close();
	},
	/**
     * View KYS history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
	viewKYSHistory: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonKYSDetailsForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('KYS_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    submitPendingKYS: function(gridItemId) {
    	
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	successMessge = getCommonTranslation('KYS_SUBMITTED');
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	var json = {
            			submissionDate:records.data.submissionDate,
            			daysOverdue:records.data.daysOverdue,
            			lastSubmissionDate:records.data.lastSubmissionDate,
            			progBatchPeriodConfigId:records.data.progBatchPeriodConfigId,
            			status:records.data.status,
            			id:records.data.id
            			}
            	var formData = Ext.encode(json);
            	Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.PERSON_SUBMIT_KYS,
                    jsonData: formData,
                    method: 'PUT',
                    success: function(form, action) {
                    	grid.getStore().reload();
                    	grid.getSelectionModel().deselectAll(true);
                        showSuccessMessage(getCommonTranslation('ACAD_MSG_BOX_TITLE'), successMessge);
                    }
                });
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('PENDING_KYS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * View KYS pending details
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewKYSPendingDetails: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonKYSPendingDetailsForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('PENDING_KYS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    // ********* Hide  all more Action button  *************
    disableMoreActionPivileges : function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	button = gridReference.down('#btnSubmit');
    	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
    	button.setVisible(false);
   /* 	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
    		menuItems.setVisible(false);
    	});*/
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SUBMIT') {
    			var button = buttonsToolBar.query('#btnSubmit')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}        		
    		}
    	
    	});
    }
});
