/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.controller.portal.StudentPortalController', {
	extend: 'Academia.controller.base.BaseController',
	views: ['studentPortal.PersonInfoStudentPortal', 'studentPortal.StudentPortalPreRegistrationWindow'],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	},{
		ref: 'personInfoStudentPortal',
		selector: 'personinfostudentportal'
	}, {
		ref: 'stcpncstudentregistration',
		selector: 'stcpncstudentregistration'
	}, {
		ref: 'studentportalpreregistrationwindow',
		selector: 'studentportalpreregistrationwindow'
	}],
	config: {
   	 STUDENT_PORTAL_COURSE_REGISTRATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_COURSE_REGISTRATION_PRIVILEGES'),
    },
	init: function(application) {
		this.control({
			'personinfostudentportal, stcpncstudentregistration': {
				afterrender: this.getPersonInfoStudentPortalRender 
			},
			'studentportalpreregistrationwindow':{
				afterrender: this.loadPreRegWindowData
			},
			'studentportalpreregistrationwindow button[itemId=btnContinue]':{
				click: this.acceptAndContinue
			},
			'stcpncstudentregistration tabpanel[itemId=stcPncStudentRegistration]':{
           	 afterrender: function(tabpanel){
           		 var me = this;
           		 var permissionsMap = me.getSTUDENT_PORTAL_COURSE_REGISTRATION_PERMISSIONS()
           		 var associatedAcadLocationIds = new Array();
               	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
               	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       
               	if (permissionList.includes('PAYMENT_DETAILS')) {
               		tabpanel.add({
            			xtype: 'studentpaymentdetialsregistrationstructure',
            			itemId :'studentpaymentdetialsregistrationstructureItemId',
            			title: getCommonTranslation('PNC_PAYMENT_DETAILS'),
            			disabled:true
            		});
               	 }
           	 }
            }
		});
	},
	/**
	 * @author Rajkumar.patidar
	 */

	getPersonInfoStudentPortalRender : function(tb){
		if(!tb.items.length || tb.xtype === "stcpncstudentregistration"){
		var $this=this;
		var programBatchSeatTypeConfigId=0;
		var userInfo = Academia.model.authentication.UserInfoModel;
		$this.applyConfigToPersonTab(tb);
		if(tb.contentXtype=='feeplangrid'){
			 programBatchSeatTypeConfigId  = $this.getProgramBatchSeatTypeConfig(userInfo);
		}
		try{
			var personInfo = contentPanel.getPersonInfo();
			}
			catch(ee){
			var contentPanel = $this.getContentPanel();
			var personInfo = contentPanel.getPersonInfo();
			}
		tb.setPersonInfo(personInfo);
		tb.setUserId(userInfo.get("userId"));
		tb.setPersonId(userInfo.get("personId"));
		tb.setAdmissionId(null);
		tb.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
		
		var singleCmpXtypes = ['postdatedchequegrid','paymentreceivedhistorygrid','refundhistorygrid','refundablepaymentgrid','searchresultgrid','serviceoptgrid','communityoptgrid','hostelpersondetailsgrid',
			'transportpersondetailsgrid','spelectionsgrid','sgstudentappointmentdetailgrid','sgfollowupdetailsgridforsp','placementdrivegrid','studentthesismanagementgrid',
			'feepayerdetailgrid','siblingdetailsgrid','kysdetailsgrid','studentonlinedocumentgrid','studentprogramwiseconditionsadmissionadmgrid','ssodetailsgrid',
			'flagdetailsform','educationhistorygrid','workexperiencegrid','medicalgrid','vaccinationgrid','extracurriculargrid','physicalcharacteristicsgrid','researchtypegrid','seminardetailsgrid',
			'patentdetailsgrid','trainingpersondetailsgrid','competitiveexamgrid','identitydetailsgrid','disciplinaryactiongrid','disciplinaryactionsugrid','positiveincidentgrid','negativeincidentgrid','nonacademicachievementsgrid','studentethicsclearancelettergrid','studentownprogressreportgrid','studentmougrid'];
		if(singleCmpXtypes.indexOf(tb.contentXtype) !== -1){
					tb.insert(0,{
						xtype: 'panel',
						 overflowX:true,
						layout:'fit',
						cls:'horizontalScrollingFixed' ,
						items:[{
							xtype: tb.contentXtype,
							itemId: tb.contentXtypeItemId,
							personType:'STUDENT'
						}]
				});
		}else{
				tb.insert(0,{
						xtype: tb.contentXtype,
						itemId: tb.contentXtypeItemId,
						personType:'STUDENT'
			});
		}
		
		
		
		var that = this;
		setTimeout(function(){
			var contentPanel = that.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			contentPanel.items.findBy(function(tab) {
				if(tab!=undefined){
					if(tab.title == 'Portal'){
						contentPanel.remove(tab,true);
					}
				}
			});
			try{
				contentPanel.getActiveTab().down('tabpanel').setActiveTab(0);
				}
				catch(e){

				}
		}, 20);

		tb.items.items[0].setTitle(false);
		tb.items.items[0].closable=false;
		
		if(tb.items.items[0].viewType=='gridview'){
			tb.items.items[0].setTitle(tb.title);
		}
		}else if(tb.contentXtype=='parentguardiangrid'){
			var $this=this;
			var programBatchSeatTypeConfigId=0;
			var userInfo = Academia.model.authentication.UserInfoModel;
			$this.applyConfigToPersonTab(tb);
			if(tb.contentXtype=='feeplangrid'){
				 programBatchSeatTypeConfigId  = $this.getProgramBatchSeatTypeConfig(userInfo);
			}
			try{
				var personInfo = contentPanel.getPersonInfo();
				}
				catch(ee){
				var contentPanel = $this.getContentPanel();
				var personInfo = contentPanel.getPersonInfo();
				}
			tb.setPersonInfo(personInfo);
			tb.setUserId(userInfo.get("userId"));
			tb.setPersonId(userInfo.get("personId"));
			tb.setAdmissionId(null);
			tb.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
			tb.insert(0,{
				xtype: tb.contentXtype,
				itemId: tb.contentXtypeItemId,
				personType:'STUDENT'
			});
			var that = this;
			setTimeout(function(){
				var contentPanel = that.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				contentPanel.items.findBy(function(tab) {
					if(tab!=undefined){
						if(tab.title == 'Portal'){
							contentPanel.remove(tab,true);
						}
					}
				});
				try{
					contentPanel.getActiveTab().down('tabpanel').setActiveTab(0);
					}
					catch(e){

					}
			}, 20);

			tb.items.items[0].setTitle(false);
			tb.items.items[0].closable=false;
			
			if(tb.items.items[0].viewType=='gridview'){
				tb.items.items[0].setTitle(tb.title);
			}
			
		}
	},
	/*getloggedInStudentDetails : function(){	//removed by Raghavendra.Soni, direct writing code in caller->another function
		var this$ = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var studentProfile = this$.getContentPanel();
		Ext.apply(studentProfile, {
			personInfo: null,
			setPersonInfo: function(personInfo) {
				studentProfile.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return studentProfile.personInfo;
			}
		});
		var userId = userInfo.get("userId");
		if (!isNullOrEmpty(userId)) {
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			var studentProfileUrl = SERVERURL.STUDENT_PERSONAL_INFORMATION_BY_ID + userId;
			Ext.Ajax.request({
				type: 'rest',
				url: studentProfileUrl,
				method: 'GET',
				success: function(res, action) {
					Ext.getBody().unmask();
					var data = Ext.decode(res.responseText);
					if(!isEmpty(data)){
						studentProfile.setPersonInfo(data.person);
					}
				},
				failure: function(res, action) {
					Ext.getBody().unmask();
				}
			});
		}
	},*/
	getProgramBatchSeatTypeConfig : function(){
		var portalInfo = Academia.model.authentication.PortalInfoModel;
        var admissionDetails = portalInfo.get('admissionDetails')[0];
        var batchId = admissionDetails.batch.id;
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			url: SERVERURL.FIND_PROGRAMBATCHSEATCONFIG_BY_BATCH_ID+'?batchId='+batchId,
			method: 'GET',
			success: function(res, action) {
				var jsonData = Ext.decode(res.responseText);
				var myArray=[];
				for(var i in jsonData){
					myArray.push(jsonData[i].id);
				}
				programBatchSeatTypeConfigId = myArray.join();
			}
		});
		return programBatchSeatTypeConfigId;
	},
	getLoadStudentDetailForSP : function(){
		var this$ = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		
		var studentProfile = this$.getContentPanel();
		Ext.apply(studentProfile, {
			personInfo: null,
			setPersonInfo: function(personInfo) {
				studentProfile.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return studentProfile.personInfo;
			}
		});
		
		var studentId = userInfo.get("userId");
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+studentId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				var portalInfo = Academia.model.authentication.PortalInfoModel;
				portalInfo.set('admissionDetails',data[0].admissionDetails);
				portalInfo.set('student',data[0].student);
				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
				portalInfo.set('programBatchDetails',data[0].programBatchDetails);
				portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
				studentProfile.setPersonInfo(data[0].student);	//--code from getloggedInStudentDetails @raghavendra.soni
			}
		});
	},
	applyConfigToPersonTab : function(newTab){

		Ext.apply(newTab,{
			personId: null,
			userId: null,
			admissionId: null,
			personInfo: {},
			setPersonId: function(personId) {
				newTab.personId = personId;
			},
			getPersonId: function() {
				return newTab.personId;
			},
			setUserId: function(userId) {
				newTab.userId = userId;
			},
			getUserId: function() {
				return newTab.userId;
			},
			setPersonInfo: function(personInfo) {
				newTab.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return newTab.personInfo;
			},
			setAdmissionId: function(admissionId) {
				newTab.admissionId = admissionId;
			},
			getAdmissionId: function() {
				return newTab.admissionId;
			},
			setProgramBatchSeatTypeConfigId: function(programBatchSeatTypeConfigId) {
				newTab.programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
			},
			getProgramBatchSeatTypeConfigId: function() {
				return newTab.programBatchSeatTypeConfigId;
			}
		});
	},
	loadPreRegistrationWin: function(){
		var me = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var studentId = userInfo.get("userId");
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_STUDENT_PREREGISTRATION_DETAILS+'?studentId='+studentId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				var portalInfo = Academia.model.authentication.PortalInfoModel;

				if(data.length){
					me.showPreRegWin(data, 0);
				}
			}
		});
	},
	
	showPreRegWin: function(data, i){
		var me = this;
		
		var formWindow = me.getStudentportalpreregistrationwindow();
		if (!formWindow) {
			Ext.widget('studentportalpreregistrationwindow',{
				data:data,
				currentRec: i
			});
			formWindow = me.getStudentportalpreregistrationwindow();
		}
		formWindow.show();
	},
	
	loadPreRegWindowData: function(){
		var me = this;
		var win = me.getStudentportalpreregistrationwindow();
		var windowContentPanel = win.down('#windowContent');
		var windowData = win.data;
		var currentRecInc = win.currentRec;
		
		var currentRecord = windowData[currentRecInc];
		
		var documentId = currentRecord.encryptDocId;
		
		//var staticContent = getCommonTranslation('PRE_REG_WIN_CONTENT_LINE1')+"<br /><br />"+getCommonTranslation('PRE_REG_WIN_CONTENT_LINE2')+"<br />";
		var staticContent = "<span class='line1MsgCls'>"+getCommonTranslation('PRE_REG_WIN_CONTENT_LINE1')+"<br /><br />"+getCommonTranslation('PRE_REG_WIN_CONTENT_LINE2')+"<br />"+"</span>";
		
		var msgContent = currentRecord.msgContent;
		
		var msgContentStatic = "<br />Click <a href='[LINK]' target='_blank'>here</a> to view to view the information about Registration and Fees. <br />";

 		var gdocument = "[ENCRYPT_DOC_ID]";

		var tncCheck = "<label><input type='checkbox' onchange='preRegAcceptCheck(this);' style='margin-top: 10px;' > I Agree to the Terms and Conditions and the Qualification/Programme Status</label>";
		
		var fullMessageContent = staticContent + gdocument+"<div class='preRegWinContentDivConfirmation'>"+msgContent + msgContentStatic+"<br /></div>"+tncCheck;
		
		var finalMessage = fullMessageContent;
		
		for(inc=0; inc<3;inc++){
			finalMessage = finalMessage.replace("[ACADEMY_LOCATION]",currentRecord.academyLocationName);
			finalMessage = finalMessage.replace("[STUDENT_NAME]",currentRecord.studentName);
			finalMessage = finalMessage.replace("[STUDENT_ID]",currentRecord.studentCode);
			finalMessage = finalMessage.replace("[PROGRAM_NAME]",currentRecord.programName);
			finalMessage = finalMessage.replace("[PROGRAM_CODE]",currentRecord.programCode);
			finalMessage = finalMessage.replace("[SAQA_ID]", (isNullOrEmpty(currentRecord.saqaId) ? "-" : currentRecord.saqaId) );
			finalMessage = finalMessage.replace("[LINK]",(isNullOrEmpty(currentRecord.termAndConditionLink) ? "#" : currentRecord.termAndConditionLink) );
			finalMessage = finalMessage.replace("[ENCRYPT_DOC_ID]",(isNullOrEmpty(currentRecord.encryptDocId) ? "" : "<a onclick='downloadDocumentByDocId(\""+currentRecord.encryptDocId+"\");' style='margin:5px 10px;color:blue;width: auto;padding: 0px 5px;border: 1px solid;display: block;float: left;cursor: pointer;'/><i class='downloadBtnGuidlineDocumentIconCls'></i><span style=\"display:inline-block;float:left;padding: 5px;\">Guidelines Documents</span></a>"));
		}
		
		windowContentPanel.body.setHTML(finalMessage);
	},
	
	acceptAndContinue: function(btn){
		var me = this;
		var win = btn.up('studentportalpreregistrationwindow');

		var windowData = win.data;
		var currentRecInc = win.currentRec;
		var currentRecord = windowData[currentRecInc];
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_STUDENT_REGISTRATION_ACCEPTANCE_SAVE+'?periodId='+currentRecord.periodId+'&studentId='+currentRecord.studentId+"&registrationTermSetupDetailId="+currentRecord.registrationTermSetupDetailId,
			method: 'POST',
			async: false,
			success: function(res, action) {
				if(currentRecInc == (windowData.length-1)){
					//me.changeDefaultRegistrationTab();
					win.close();
				}
				else{
					win.close();
					setTimeout(function(){
						me.showPreRegWin(windowData, currentRecInc+1);
					},1000);
				}
			}
		});
	},
	
	downloadDocumentByDocId : function(documentId) {
    	var this$ = this;
    	var documentController =  this$.getController('Academia.controller.document.DocumentController');
    	documentController.downloadDocumentFile(documentId);
    },
    
    /*changeDefaultRegistrationTab: function(){
    	var me = this;
    	try{
        	if(Ext.ComponentQuery.query('#stcPncStudentRegistration').length){
        		var stcPncStudentRegistration = Ext.ComponentQuery.query('#stcPncStudentRegistration')[0];
        		stcPncStudentRegistration.setActiveTab(0);
        	}
    	}
    	catch(e){
    		
    	}
    }*/
});
