Ext.define('Academia.controller.program.ProgramAssignExamCentersController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['program.programDetails.programBatches.assignExamCenter.ProgramAssignExamCenterStoreGrid','program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore','program.programDetails.programBatches.assignExamCenter.ProgramExamCenterAvilbleItemStore'],
    models: ['program.programDetails.programBatches.assignExamCenter.ProgramAssignExamCenterModelGrid','genericmodels.dropdowns.EnumCombo','common.IdValueCodeDataModel'],
    views: ['program.programDetails.programBatchDetails.assignExamCenters.ProgramAssignExamCentersForm',
            'baselayout.contentarea.ContentPanel',
            'program.programDetails.programBatchDetails.assignExamCenters.ProgramAssignExamCentersGrid',
            'program.programDetails.programBatchDetails.assignExamCenters.ProgramAssignExamCentersStructure',
            'program.programDetails.BatchDetailsTabStructure'
        	],
    config:{
    	 /* * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
          
         	*//**
           * @cfg {Array} ASSIGNEXAMCENTER_PERMISSIONS array (required)
           * The array of permissions to use for Access control wise enabling and disabling buttons.
           * @accessor
           */
      ASSIGNEXAMCENTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSIGNEXAMCENTER_PRIVILEGES')  
    } ,   	
    
    refs: [{
        ref: 'programassignexamcentersgrid',
        selector: 'programassignexamcentersgrid'
    },{
        ref: 'programassignexamcentersformwindow',
        selector: 'programassignexamcentersformwindow'
    },{
	    ref: 'contentPanel',
	    selector: 'contentPanel'
	},{
	    ref: 'programbatchdetailstabstructure',
	    selector: 'programbatchdetailstabstructure'
	},{
	    ref: 'batchdetailstabstructure',
	    selector: 'batchdetailstabstructure'
	}],


    init: function(application) {
        this.control({
        	
        	'programassignexamcentersgrid':{
        		render:function(grid){
        			this.doAccessControlValidation(grid, this.getASSIGNEXAMCENTER_PERMISSIONS());
        			 var programStructure = this.getBatchdetailstabstructure();
     				  var batchId = programStructure.down("#batchId").getValue();
     				  var store = grid.getStore();
     				  store.getProxy().extraParams = {
     					  batchId : batchId
     				  };
     				  store.load();
        		}
        	},

        	'programassignexamcentersgrid button[itemId=btnAdd]':{
        		click: function() {
        			this.onAddshowProgramAssignExamCentersFormWindow();
        		}
        	}
        	,'programbatchdetailstabstructure combo[itemId=batchId]':{
        		select: function(c,r) {
        			var batchId = "";
        			if(Ext.isObject(r) || Ext.isArray(r)){
        				batchId=r[0].data.id;
        			}else{
        				batchId=r;
        			}
        			var $this=this;
        			var store = $this.getStore('program.programDetails.programBatches.assignExamCenter.ProgramAssignExamCenterStoreGrid');
        			if(batchId!=null){
        				store.getProxy().extraParams = {
        					batchId: batchId
        				};
        				store.load();
        			}	
        		}
        	}
        ,'programassignexamcentersformwindow button[itemId=programAssignExamCentersFormCancel]':{
            	click: function() {
                	this.closeProgramAssignExamCentersFormCancel();
                }
            },'programassignexamcentersformwindow combo[itemId=centerTypeItemId]':{
            	select: function() {
            		var windowform= Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
                    var form=windowform.getForm();
                    form.findField('centreCode').setDisabled(false);
                    form.findField('centreCode').reset();
            		this.getProgramExamCenters();
//         		  centerType=EXTERNAL&stageType=COURSE_EXECUTION&batchId=2
         		 /* if(store.data.items.length==0){
         			 showWarningMessage(getCommonTranslation('ASSIGN_EXAM_CENTER'),getCommonTranslation('DATA_IS_NOT_AVAILABLE'));
         		  }*/
                }
            },
            'programassignexamcentersformwindow radiogroup[itemId=selectionStageItemId]':{
            	change: function() {
            		var windowform= Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
                    var form=windowform.getForm();
                    form.findField('centreCode').reset();
            		this.getProgramExamCenters();
            	}
            },'programassignexamcentersformwindow button[itemId=programAssignExamCentersFormSubmit]':{
            	click: function() {
                	this.saveAssignExamCentersForm();
                }
            },'programassignexamcentersgrid button[itemId=btnEdit]':{
            	click: function() {
                	this.editAssignExamCentersWindow();
                }
            },'programassignexamcentersgrid button[itemId=btnDelete]':{
            	click: function() {
                	this.deleteAssignExamCentersData();
                }
            },
            'programassignexamcentersgrid button[itemId=btnView]':{
              click: function() {
            	this.viewAssignExamListData();
              }
            }
        });
      },
      onAddshowProgramAssignExamCentersFormWindow: function() {
	        var formWindow = this.getProgramassignexamcentersformwindow();
	        if (!formWindow) {
	            Ext.widget('programassignexamcentersformwindow');
	            formWindow = this.getProgramassignexamcentersformwindow();
	        }
	        formWindow.show();
	        this.setValuesAfterWindowShow();
	    }, 
	    onEditshowProgramAssignExamCentersFormWindow: function() {
	        var formWindow = this.getProgramassignexamcentersformwindow();
	        if (!formWindow) {
	            Ext.widget('programassignexamcentersformwindow');
	            formWindow = this.getProgramassignexamcentersformwindow();
	        }
	        formWindow.show();
	    },
	    closeProgramAssignExamCentersFormCancel: function() {
	        this.getProgramassignexamcentersformwindow().hide();
	    },
	    saveAssignExamCentersForm:function(){
	    	var $this=this;
	    	var grid=$this.getProgramassignexamcentersgrid();
	    	var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
    		var batchId=batchTabStructureForm.findField('batch').getValue();
	    	var prgmAssignExamCenter=Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
	    	var form=prgmAssignExamCenter.getForm();
	    	var centreCodeField=form.findField('centreCode');
	    	var values=form.getFieldValues();
	    	var selectionStage;
	    	if(values.rb1){
	    		selectionStage=values.selectionStageRadio;
	    	}else if(!values.rb1){
	    		selectionStage=values.courseExecutionStageRadio;
	    	}
	    	var examCenterType = values.centreCode;
	    	var examCenterTypeArray = [];
	    	var examCenterTypeId;
	    	if(examCenterType !="" && examCenterType !=null){
				for(var i in examCenterType){
					if(Ext.isObject(examCenterType[0])){
						examCenterTypeId = examCenterType[i].get("id");
						examCenterTypeArray.push(examCenterTypeId);
					}else{
						examCenterTypeId = examCenterType[i];
						examCenterTypeArray.push(examCenterTypeId);
					}
				}
			}	
	    	
	    	var myJson;
	       		  myJson = [];
	       		  for(var i in examCenterTypeArray){
	       			  myJson.push({
		       				"selectionStage":selectionStage,
		       				"batchId":batchId,
		       				"examCenterId":examCenterTypeArray[i],
		       				"centerType":values.centerType
	       			  });
	       		  };
	    	 var submitUrl = SERVERURL.PROGRAM_BATCH_DETAIL_EXAM_CENTER_CREATE_URL;
	    	 $this.applyWindowMask();
    			Ext.Ajax.request({
    				type: 'rest',
    				url: submitUrl,
    				jsonData: myJson,
    				method: 'POST',
    				success: function(f, action) {
    					 $this.hideWindowMask();
    					showSuccessMessage(getCommonTranslation('ASSIGN_EXAM_CENTER'), getCommonTranslation('SUCCESS'));
    					form.reset();
    					grid.getStore().reload();
    					$this.closeProgramAssignExamCentersFormCancel();
    				}
    			});
	    	
	    }, 
	    editAssignExamCentersWindow:function(){
	    	 var $this = this;
	    	 var assignExamCenter= Ext.widget('programassignexamcentersformwindow');
	    	 var button= Ext.ComponentQuery.query('button#programAssignExamCentersFormSubmit')[0];
	    	     button.setText('Save');
	    	 var selectedItem= Ext.ComponentQuery.query('multiselectcombofield#centreCodeItemId')[0];
	    	 var grid = $this.getProgramassignexamcentersgrid();
	    	 var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
	    	 var batchId=batchTabStructureForm.findField('batch').getValue();
	    	 var centerTypeField= Ext.ComponentQuery.query('combo#centerTypeItemId')[0];
	         var selelctedDataURL=SERVERURL.PROGRAM_BATCH_DETAIL_EXAM_CENTER_SELECTED_ITEM_URL;
	         if (grid.getSelectionModel().getCount() > 0) {
	        	 var records = grid.getSelectionModel().getSelection()[0];  
	        	 var store=$this.getStore('program.programDetails.programBatches.assignExamCenter.ProgramExamCenterAvilbleItemStore');
        		  store.load({
        			  params:{
        				 centerType:records.data.centerType
        			  }
//        		  centerType=EXTERNAL&stageType=COURSE_EXECUTION&batchId=2
        		  });
	        	  $this.onEditshowProgramAssignExamCentersFormWindow();
	        	  centerTypeField.store.load({
	                    callback: function(re, operation, success) {
	                        if (success) {
	                        	centerTypeField.setValue(records.data.centerType);
	                        }
	                    }
	                });
	        	    if(records.data.selectionStage=='Selection'){
						Ext.ComponentQuery.query('radiogroup#selectionStageItemId')[0].items.items[0].setValue(true);
						Ext.ComponentQuery.query('radiogroup#selectionStageItemId')[0].items.items[1].setValue(false);
					}else if(records.data.selectionStage=='Course Execution'){
						Ext.ComponentQuery.query('radiogroup#selectionStageItemId')[0].items.items[0].setValue(false);
						Ext.ComponentQuery.query('radiogroup#selectionStageItemId')[0].items.items[1].setValue(true);
					}
	        	    Ext.Ajax.request({
	    				type: 'rest',
	    				url: selelctedDataURL+'?batchId='+batchId,
	    				method: 'GET',
	    				success: function(f, action) {
	    					var  jData=Ext.JSON.decode(f.responseText);
	    					var arrayData=[];
	    				   Ext.Array.each(jData, function(name, index) {
	    					    arrayData.push(name.id);
	    					});
	    				   selectedItem.setValue(arrayData);
	    				}
	    			});
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    		}
	    },
	    viewAssignExamListData:function(){
       	 var $this=this; 
       	 var grid = $this.getProgramassignexamcentersgrid();
              Ext.widget('programassignexamcentersformwindow');
         var formWindow= Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
       	 var form=formWindow.getForm();
       	 if (grid.getSelectionModel().getCount() > 0) {
       		$this.editAssignExamCentersWindow();
           	form.findField('selectionStage').setReadOnly(true);
           	form.findField('centerType').setReadOnly(true);
           	form.findField('centreCode').setDisabled(true);
           	var button= Ext.ComponentQuery.query('button#programAssignExamCentersFormSubmit')[0];
       		button.hide();
       	 } else {
       		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
       	 }
        },
	    deleteAssignExamCentersData:function(){
	    	 var $this=this;
	    	 var grid = $this.getProgramassignexamcentersgrid();
	         if (grid.getSelectionModel().getCount() > 0) {
	        	 var records = grid.getSelectionModel().getSelection()[0];  
		         var id=records.data.id;
		         showConfirmMessage(getCommonTranslation('ASSIGN_EXAM_CENTER'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
        				 
	        	 Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PROGRAM_BATCH_DETAIL_EXAM_CENTER_DELETE_URL+'?id='+id,
	    				method: 'DELETE',
	    				params:{
	    					id:id
	    				},
	    				success: function(f, action) {
	    					showSuccessMessage(getCommonTranslation('ASSIGN_EXAM_CENTER'), getCommonTranslation('SUCCESS'));
	    					grid.getStore().reload();
	    					$this.closeProgramAssignExamCentersFormCancel();
	    				}
	    			});
        			 }
        		 });
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    		}
	    },
	    setValuesAfterWindowShow:function(){
	    	
	    	var $this=this;
    		var store=$this.getStore('program.programDetails.programBatches.assignExamCenter.ProgramAssignExamCenterStoreGrid');
    		store.load();
        	var windowform= Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
            var form=windowform.getForm();
            var selectionStageRadio=form.findField('selectionStageRadio');
            var courseExecutionStageRadio=form.findField('courseExecutionStageRadio');
    	    var submitUrl = SERVERURL.PROGRAM_BATCH_DETAIL_EXAM_CENTER_SELECT_STAGE_URL;
 			Ext.Ajax.request({
 				type: 'rest',
 				url: submitUrl,
 				method: 'GET',
 				success: function(resp, action) {
                  var  jData=Ext.JSON.decode(resp.responseText);
                  selectionStageRadio.setValue(jData[0].value);
                  courseExecutionStageRadio.setValue(jData[1].value);
 				}
 			});
	    	
	    },
	    getProgramExamCenters:function(){
	    	var $this = this;
	    	var windowform= Ext.ComponentQuery.query('form#programAssignExamCentersFormWindow')[0];
            var form=windowform.getForm();
            //form.findField('centreCode').setDisabled(false);
            
            var values = form.getValues();
            var centerTypeData=form.findField('centerType').getValue();
            var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
	    	 var batchId=batchTabStructureForm.findField('batch').getValue();
	    	 var stageType;
	    	 if(values.rb1){
	    		 stageType = 'SELECTION';
	    	 }else{
	    		 stageType = 'COURSE_EXECUTION';
	    	 }
	    	 
            var store=$this.getStore('program.programDetails.programBatches.assignExamCenter.ProgramExamCenterAvilbleItemStore');
            store.getProxy().extraParams = {
            	centerType:centerTypeData,
				  stageType:stageType,
				  batchId:batchId
			};
			//store.load();
            store.proxy.extraParams = {centerType:centerTypeData};
            store.load(function(){
           	 windowform.down('#centreCodeItemId').bindStore(store);
            });
	    }

});