Ext.define('Academia.controller.program.ProgramCourseGroupsController', {
//    extend: 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
    stores: ['program.programDetails.programBatches.courseGroup.ProgramCourseGroupStoreGrid','program.programDetails.programBatches.courseGroup.ProgramCourseGroupAvialbleItemStore'],
    models: ['program.programDetails.programBatches.courseGroup.ProgramCourseGroupModelGrid','common.IdValueCodeDataModel'],
    views: ['baselayout.contentarea.ContentPanel',
            'program.programDetails.programBatchDetails.courseGroups.ProgramCourseGroupsForm',
        	'program.programDetails.programBatchDetails.courseGroups.ProgramCourseGroupsGrid',
        	'program.programDetails.programBatchDetails.courseGroups.ProgramBatchCourseGroupStructure'
        	],
    
    refs: [{
        ref: 'programcoursegroupsgrid',
        selector: 'programcoursegroupsgrid'
    },{
        ref: 'programcoursegroupsformwindow',
        selector: 'programcoursegroupsformwindow'
    },{
        ref: 'programCoursegroupsFormwindow',
        selector: 'programcoursegroupsformwindow form'
    },{
	    ref: 'contentPanel',
	    selector: 'contentPanel'
	},{
	    ref: 'programbatchdetailstabstructure',
	    selector: 'programbatchdetailstabstructure'
	}],
	
	config: {
        
         	 /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
          		   	 
          	   	/**
          	        * @cfg {Array} PROGRAM_COURSE_GROUP_PERMISSIONS array (required)
          	        * The array of permissions to use for Access control wise enabling and disabling buttons.
          	        * @accessor
          	        */
       PROGRAM_COURSE_GROUPS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_COURSE_GROUPS_PRIVILEGES')  		  
   },	                 
      

    init: function(application) {
        this.control({
        	
        	'programcoursegroupsgrid':{
        		render:function(grid){
        			this.doAccessControlValidation(grid, this.getPROGRAM_COURSE_GROUPS_PERMISSIONS());
        			this.addDataGridConfigButton(grid, this.getPROGRAM_COURSE_GROUPS_PERMISSIONS());

        			var store = grid.getStore();
        			store.load();
        		},
        		cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var programGrid = $this.getProgramcoursegroupsgrid();
                    programGrid.down('#btnSaveItemId').setDisabled(false);
                }
        	},
        	
        	/*'programcoursegroupsgrid':{
        		 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                     var $this = this;
                     var programGrid = $this.getProgramcoursegroupsgrid();
                     programGrid.down('#btnSaveItemId').setDisabled(false);
                 }
        	},*/
        	
        	'programcoursegroupsgrid button[itemId=btnAdd]':{
            	click: function() {
        	        	 this.editCourseGroupFormWindow();
                }
            },
            'programcoursegroupsgrid button[itemId=btnSaveItemId]':{
            	click:function(){
            		this.updateProgramBatchCourseGroup();
            	}	
            },
            'programcoursegroupsgrid button[itemId=courseGroupsbtnEdit]':{
            	click: function() {
                	this.editCourseGroupFormWindow();
                }
            },'programcoursegroupsgrid button[itemId=courseGroupsbtnView]':{
            	click: function() {
                	this.viewCourseGroupFormWindow();
                }
            },'programcoursegroupsformwindow button[itemId=programCourseGroupsFormSubmit]':{
            	click: function() {
                	this.saveDataProgramCourseGroupForm();
                }
            },'programcoursegroupsgrid button[itemId=btnDelete]':{
            	click: function() {
                	this.deleteProgramCourseGroupData();
                }
            },'programcoursegroupsformwindow button[itemId=programCourseGroupsFormCancel]':{
            	click: function() {
                	this.closeProgramCourseGroupsFormCancel();
                }
            },'programcoursegroupsformwindow':{
            	show: function() {
            		var gridStore = this.getStore('program.programDetails.programBatches.courseGroup.ProgramCourseGroupStoreGrid');
            		var array = [];
            		for(var i=0;i<gridStore.data.length;i++){
            			var ids = gridStore.data.items[i].data.courseGroupId;
            			array.push(parseInt(ids));
            		}
            		var courseGroup = this.getProgramCoursegroupsFormwindow().down('#courseGroup_Id');
            		courseGroup.setValue(array);     
                }
            }
            ,
            'programbatchdetailstabstructure combo[itemId=batchId]':{
            	select: function(c,r) {
            		var batchId = "";
            		if(Ext.isObject(r) || Ext.isArray(r)){
            			batchId=r[0].data.id;
					  }else{
						  batchId=r;
					  }
            		var $this=this;
            		var store = $this.getStore('program.programDetails.programBatches.courseGroup.ProgramCourseGroupStoreGrid');
            		if(batchId!=null){
	            		store.getProxy().extraParams = {
	            			batchId: batchId
	    				};
	    				store.load();
	    			 }	
                }
            }
        });
    },
      showProgramCourseGroupsFormWindow: function() {
	        var formWindow = this.getProgramcoursegroupsformwindow();
	        if (!formWindow) {
	            Ext.widget('programcoursegroupsformwindow');
	            formWindow = this.getProgramcoursegroupsformwindow();
	        }
	        formWindow.show();
	    },
	    closeProgramCourseGroupsFormCancel: function() {
	        this.getProgramcoursegroupsformwindow().close();
	    },
	    editCourseGroupFormWindow:function(){
	    	 var $this = this;
	    	 /**
	    	  * Load store before window becoz window get displaced if we load store after window show.
	    	  */
	    	 var itemSelectorData=$this.getStore('program.programDetails.programBatches.courseGroup.ProgramCourseGroupAvialbleItemStore');
     		itemSelectorData.load({
     			callback:function(){
     				$this.showProgramCourseGroupsFormWindow(); 				
     			}
     		});
	    	 //var prgmCourse= Ext.widget('programcoursegroupsformwindow');
	    	 //var prgmCourseForm=prgmCourse.items.items[0];
	         //var selectedItem=prgmCourseForm.items.items[0];
	    	 //var grid = $this.getProgramcoursegroupsgrid();
	         //var selelctedDataURL=SERVERURL.PROGRAM_BATCH_DETAIL_COURSE_GROUP_SELECTED_ITEM_URL;
	         //var gridRecordFirst=grid.getStore().data.items;
	         //var batchId = $this.getProgrambatchdetailstabstructure().getForm().findField('batch').getValue();
	      	  
	         /*if (gridRecordFirst.length > 0) {
	        	    Ext.Ajax.request({
	    				type: 'rest',
	    				url: selelctedDataURL+'?id='+batchId,
	    				method: 'GET',
	    				success: function(f, action) {
	    					var  jData=Ext.JSON.decode(f.responseText);
	    					var arrayData=[];
	    				   Ext.Array.each(jData, function(name, index) {
	    					    arrayData.push(name.id);
	    					});
	    				   selectedItem.setValue(arrayData);
	    				}
	    			});
	    		}*/
	    },
	    
	    saveDataProgramCourseGroupForm:function(){
	    	var $this=this;
	    	var grid=$this.getProgramcoursegroupsgrid();
	    	var batchTabStructureForm=$this.getProgrambatchdetailstabstructure().getForm();
    		var batchId=batchTabStructureForm.findField('batch').getValue();
	    	var prgmCourse=Ext.ComponentQuery.query('form#programCourseGroupsFormWindowItemId')[0];
	    	var form=prgmCourse.getForm();
	    	var values=form.getFieldValues();
	    	 var myJson;
	       		  myJson = [];
	       		  for(var i in values.courseGroup){
	       			  myJson.push({
	       				  "batchId":batchId,
	       				  "courseGroupId" :values.courseGroup[i]
	       			  });
	       		  }
	    	 var submitUrl = SERVERURL.PROGRAM_BATCH_DETAIL_COURSE_GROUP_CREATE_URL;
    			Ext.Ajax.request({
    				type: 'rest',
    				url: submitUrl,
    				jsonData: myJson,
    				method: 'POST',
    				success: function(response, action) {
    					var ALcheck = response.responseText.match("_NOT_AVAILABLE_IN_ACADEMY_LOCATION"
    							+"$") == "_NOT_AVAILABLE_IN_ACADEMY_LOCATION";
    					if(response.responseText == 'SUCCESS'){
    						showSuccessMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('SUCCESS'));
        					form.reset();
        					grid.getStore().reload();
        					$this.closeProgramCourseGroupsFormCancel();
        					
    					}else if(response.responseText == 'Conflicting Course'){
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_CONFLICT')); 
    					}else if(response.responseText == 'Course_Group_Associated_Zero_Course'){
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED_ZERO_COURSE')); 
    					}else if(response.responseText == 'This program can contain only single course'){
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PROGRAM_CONTAIN_SINGLE_COURSE')); 
    					}else if(response.responseText == 'NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH'){
    						showWarningMessage(getCommonTranslation('ALERT'), 
    								getProgramandcourseTranslation('NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH')); 
    					}else if(response.responseText == 'COURSE_WITH_M_CANT_BE_ADDED'){
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_M_CANT_BE_ADDED_COURSE_GROUP'));
    					}else if(response.responseText == 'COURSE_WITH_G_CANT_BE_ADDED'){
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_G_CANT_BE_ADDED_COURSE_GROUP'));
    					}else if(ALcheck){
    						var courseCodeName = response.responseText.split("_")[1];
    						var groupName = response.responseText.split("_")[0];
    						showWarningMessage(getCommonTranslation('ALERT'), groupName + " " + getProgramandcourseTranslation('CONTAINS') + " " + 
    								courseCodeName + ", " + getProgramandcourseTranslation('WHICH_IS') + 
    								getProgramandcourseTranslation('NOT_AVAILABLE_IN_ACADEMY_LOCATION'));
    					}
    				}
    			});
	    },
	    
	    updateProgramBatchCourseGroup:function(){
	    	var $this=this;
	    	var grid=$this.getProgramcoursegroupsgrid();
	    	var records = grid.getSelectionModel().getSelection()[0];
	    	var id=records.data.id;
	    	var batchId=records.data.batchId;
	    	var courseGroupId=records.data.courseGroupId;
	    	var byPassRule=null;
	    	if (records.data.byPassRule == "YES" || records.data.byPassRule == "Yes") {
	    		byPassRule = true;
			 }
	    	if (records.data.byPassRule == "NO" || records.data.byPassRule == "No") {
	    		byPassRule = false;
			 }
	    	Ext.Ajax.request({
				 type: 'rest',
				 url: SERVERURL.PROGRAM_BATCH_DETAIL_COURSE_GROUP_UPDATE_URL,
				 method: 'GET',
				 params:{
					 id:id,
					 byPassRule:byPassRule,
					 courseGroupId:courseGroupId,
					 batchId:batchId
					 
				 },
				 success: function(f, action) {
				 showSuccessMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('SUCCESS'));
				 grid.getStore().reload();
				 grid.getSelectionModel().deselectAll();
				 grid.down('#btnSaveItemId').setDisabled(true);
				 }
			 });
	    },
	    
	deleteProgramCourseGroupData: function() {
		var $this = this;
		var grid = $this.getProgramcoursegroupsgrid();

		if (grid.getSelectionModel().getCount() === 0) {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			return;
		}

		var record = grid.getSelectionModel().getSelection()[0];
		var store = grid.getStore();

		var hasDirectChild = store.findBy(function(rec) {
			return rec.get("parentCourseGroupName") === record.get("code")+"/"+record.get("groupName");
		});

		if (hasDirectChild !== -1) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getCommonTranslation('PLEASE_DELETE_CHILD_COURSE_GROUP_FIRST')
			);
			store.reload();
			return; 
		}

			if (record.data.whetherSpecializedGroup) {
				showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('COURSE_SPECIAL_GROUP'));
				return;
			}

			showConfirmMessage(
				getCommonTranslation('COURSE_GROUP'),
				getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
				function(btn) {
					if (btn === 'yes') {

						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PROGRAM_BATCH_DETAIL_COURSE_GROUP_DELETE_URL + '?id=' + record.data.id,
							method: 'DELETE',
							params: { id: record.data.id },

							success: function(f) {
								if (f.responseText == "SUCCESS") {
									showSuccessMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('SUCCESS'));
									grid.getStore().reload();
									$this.closeProgramCourseGroupsFormCancel();
								}
								else if (f.responseText == "COURSE_PARAMETER_SETTINGS_DONE") {
									showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('GROUP_PARAM_DEPENDENY'));
								}
							}
						});

					}
				}
			);
	    },
	    viewCourseGroupFormWindow:function(){
	    	 var $this=this; 
	       	 var grid = $this.getProgramcoursegroupsgrid();
	              Ext.widget('programcoursegroupsformwindow');
	         var formWindow= Ext.ComponentQuery.query('form#programCourseGroupsFormWindowItemId')[0];
	         var form=formWindow.getForm();
	       	 if (grid.getSelectionModel().getCount() > 0) {
	 	         $this.editCourseGroupFormWindow();
	 	         form.fidnField('courseGroup').setDisabled(true);
	        	 var button= Ext.ComponentQuery.query('button#programCourseGroupsFormSubmit')[0];
	        		button.hide();
	       	 } else {
	       		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	       	 }
	    }
});