/**
 * @Author Raghavendra.Soni
 */
Ext.define('Academia.controller.program.lessonplanning.LessonPlanningInnerController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'attendance.AllProgramMappedByCourse',
		'attendance.AssignedCoursesFacultyStore',
		'attendance.AttendanceFacultyList',
		'attendance.LessonPlanFacultyStore',
		'course.CoursesWithoutLPStore',
		'attendance.VariantMappedToPlan',
		'common.AcademicTermStore',
		'common.ActiveUserStore',
		'common.AssignedProgramStore',
		'common.BatchesByProgramId',
		'course.AssignedPeriodCoursesFacultyStore',
		'course.coursevariants.CourseVariantStore',
		'course.coursevariants.NewCourseVariantStore',
		'enquiry.AcademicBatchForSectionGroupStore',
		'lessonplan.CourseByAcademicTermLessonPlan',
		'lessonplan.LessonPlanCourseVariantListStore',
		'lessonplan.LessonPlanDocumentStore',
		'lessonplan.LessonPlanDurationStore',
		'lessonplan.LessonPlanGridStore',
		'lessonplan.LessonPlanObjectiveDetailtListStore',
		'lessonplan.LessonPlanObjectiveStore',
		'lessonplan.LessonPlanTermStore',
		'lessonplan.LessonPlanTopicStore',
		'lessonplan.LessonPlanUnitTitleStore',
		'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'course.CourseCategoryStore',
		'lessonplan.LessonPlanExamDetailTypeStore',
		'lessonplan.LessonPlanAssessmentTransferredSkillStore',
		'attendance.LessonPlanLearningOutcomeStore',
		'lessonplan.LessonPlanExamDurationStore',
		'lessonplan.LessonPlanWhetherGrouporIndividual',
		'lessonplan.GeneralEducationCategoryStore',
		'lessonplan.ReferenceProgramStore',
		'lessonplan.ProgramLearningOutcomeStore',
		'lessonplan.DublinDescriptorStore'
	],
	models: [
		'lessonplan.CopyLessonPlanModel',
		'lessonplan.LessonPlanGridModel',
		'lessonplan.LessonPlanModel'
	],
	views: [
		'program.lessonplanning.LessonPlanDocumentGridDownload',
		'program.lessonplanning.LessonPlanningDetailsForm',
		'program.lessonplanning.LessonPlanningDocumentGrid',
		'program.lessonplanning.LessonPlanningGrid',
		'program.lessonplanning.LessonPlanningAddExamWin',
		'program.lessonplanning.LessonPlanningResitWin'
	],
	config: {
		LESSON_PLANNING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_PRIVILEGES'),
		LESSON_PLANNING_FACULTY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_FACULTY_PRIVILEGES'),
	    LESSON_PLANNING_DETAIL_FROM_BUTTON_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_DETAIL_FROM_BUTTON_PRIVILEGES'),
	    LESSON_PLANNING_FACULTY_DETAIL_FROM_BUTTON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_FACULTY_DETAIL_FROM_BUTTON_PRIVILEGES')
	},	
	refs: [
		{
			ref: 'contentPanel',
			selector: 'contentPanel'
		},
		{
			ref: 'lessonplanninggrid',
			selector: 'lessonplanninggrid'
		},
		{
			ref: 'lessonplanningdetailsform',
			selector: 'lessonplanningdetailsform'
		},
		{
			ref:'lessonplanningdocumentgrid',
			selector:'lessonplanningdocumentgrid'
		},
		{
			ref:'lessonplandocumentgriddownload',
			selector:'lessonplandocumentgriddownload'
		},
		{
			ref: 'lessonplanningaddexamwin',
			selector: 'lessonplanningaddexamwin'
		},
		{
			ref: 'lessonplanningresitwin',
			selector: 'lessonplanningresitwin'
		}
	],

	//-- START -- initialization
	init: function(application) {
		this.control({
			'lessonplanninggrid button[itemId=btnEdit]':{
				click: Ext.bind(this.editLessonPlanRecord, this, [false])
			},
			'lessonplanninggrid button[itemId=btnView]':{
				click: Ext.bind(this.editLessonPlanRecord, this, [true])
			},
			'lessonplanningdetailsform' :  {
				afterrender: function(frm){
					var me = this;
					if(isNullOrEmpty(frm['whethePublished'])){
						var lessonPlanDocGrid =me.getLessonplanningdocumentgrid();
					    var store = lessonPlanDocGrid.getStore();
						store.removeAll();
					}
					this.addBlankObjectiveField(frm, false);
					
					frm.down('#lessonPlanFacultyItemId').getStore().on('beforeload', function(str){
						str.getProxy().extraParams.id = me.getCurrentAcademyLocation();
					});
				}
			},
			'lessonplanningdetailsform button[itemId=lessonPlanSaveBtnItemId]': {
				click: this.saveUpdateLessonPlanData
			},
			'lessonplanningdetailsform customcombobox[itemId=lessonPlanAcademicTermItemId]': {
				select: function(obj, record) {
					var me = this;
					var academicTermId = record[0].get("id");
					var form = me.getLessonplanningdetailsform();
					var coursefield = form.down('#lessonPlanCourseItemId');
					var lessonPlanCoursefield = form.down('#lessonPlanCourseItemId');
					var lessonPlanTopicsfield = form.down('#lessonPlanTopicsItemId');
					var lessonPlanTermfield = form.down('#lessonPlanTermItemId');
					var lessonPlanDurationfield = form.down('#lessonPlanDurationItemId');
					var lessonPlanAimfield = form.down('#lessonPlanAimItemId');
					var lessonPlanPrerequisitefield = form.down('#lessonPlanPrerequisiteItemId');
					var lessonPlanUnitTitlefield = form.down('#lessonPlanUnitTitleItemId');
					var superVisedPracticeHours = form.down('#superVisedPracticeHours');
					var lessonPlanfaculty = form.down("#lessonPlanFacultyItemId");
					var generalEducationCategory = form.down("#generalEducationCategoryItemId");
					var referenceProgram = form.down("#referenceProgramItemId");
					var lessonPlanCourseVariant = form.down("#lessonPlanCourseVariantIdItemId");
					var maxAbsences = form.down("#maxAbsencesItemId");
					var adminAbsences = form.down("#adminAbsencesItemId");
					var facultyOfficeHours = form.down("#facultyOfficeHoursItemId");
					coursefield.setDisabled(false);
					lessonPlanCoursefield.setDisabled(false);
					lessonPlanTopicsfield.setDisabled(false);
					lessonPlanTermfield.setDisabled(false);
					lessonPlanDurationfield.setDisabled(false);
					lessonPlanAimfield.setDisabled(false);
					lessonPlanPrerequisitefield.setDisabled(false);
					lessonPlanUnitTitlefield.setDisabled(false);
					superVisedPracticeHours.setDisabled(false);
					lessonPlanfaculty.setDisabled(false);
					generalEducationCategory.setDisabled(false);
					referenceProgram.setDisabled(false);
					referenceProgram.reset();
					maxAbsences.setDisabled(false);
					adminAbsences.setDisabled(false);
					facultyOfficeHours.setDisabled(false);
					
					var portalId = this.getCurrentLoggedPortalId();
					var facultyId = null;
					if(portalId == 2) {
						facultyId=this.getCurrentlyLoggedInUser().id;
					}
					var academyLocationId = this.getCurrentAcademyLocation();
					var courseStore = coursefield.getStore();
					courseStore.getProxy().extraParams = {
						academicTermId: academicTermId,
						academyLocationId: academyLocationId,
						facultyId:facultyId
					};
					courseStore.load();
					lessonPlanCourseVariant.reset();
				}
			},
			'lessonplanningdetailsform customcombobox[itemId=lessonPlanCourseItemId]': {
				select: function(obj, record) { 
					var me = this;
					var courseId=record[0].data.courseId;
					var form = me.getLessonplanningdetailsform();
					var courseVariant=form.down('#lessonPlanCourseVariantIdItemId');
					var academicTermId = form.down("#lessonPlanAcademicTermItemId").getValue();
					var faculty = form.down("#lessonPlanFacultyItemId");
					var facultyStore = faculty.getStore();
					var referenceProgram = form.down("#referenceProgramItemId");
					var referenceProgramStore = referenceProgram.getStore();
					courseVariant.setDisabled(false);
					courseVariant.reset();
					
					var loggedInFacultyId = null;
					if(portalId == 2) {
						loggedInFacultyId=this.getCurrentlyLoggedInUser().id;
					}
					var alinfomodel = Academia.model.authentication.ALInfoModel;
		            var whetherSchool = alinfomodel.get('wheatherSchool');
					
					faculty.reset();
					var store = courseVariant.getStore();
					store.getProxy().extraParams = {
						courseId: courseId,
						academicTermId:academicTermId,
						isCurrentPeriod : true,
						whetherSchool : whetherSchool
					};
					referenceProgram.reset();
					referenceProgramStore.removeAll();
					referenceProgramStore.getProxy().extraParams = {
						courseId: courseId
					};
					referenceProgramStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if (record.length >0) {
									referenceProgram.setValue(record[0].data.id);
									Ext.each(Ext.ComponentQuery.query('[name=programLearningOutcome]'), function(currentField){
									    currentField.reset();
									    currentField.clearValue();
									    currentField.getStore().getProxy().extraParams={
									    	programId:record[0].data.id
									    };
									    currentField.getStore().load();
									});
									
									Ext.each(Ext.ComponentQuery.query('[name=dublinDescriptor]'), function(dublinDescriptor){
										dublinDescriptor.reset();
										dublinDescriptor.clearValue();
										dublinDescriptor.getStore().getProxy().extraParams={
									    	programId:record[0].data.id
									    };
										dublinDescriptor.getStore().load();
									});
								}
							}
						}
					});
					store.load({
						callback: function(rec){
							if(rec.length){
								var cvIds = Ext.Array.pluck(Ext.Array.pluck(rec,'data'),'id');
								courseVariant.setValue(rec);
								
								//--Loading Faculty Store on Auto Selecting Course Variant
								
								facultyStore.getProxy().extraParams = {
									/*courseVariantIds:cvIds.join(),
									courseId:courseId*/
									id: me.getCurrentAcademyLocation()
								};
								/*facultyStore.load({
									callback: function(record, operation, success) {
										if (success) {
											if (record.length == 1) {
												faculty.setValue(record[0].data.id);
											}
											else{
												faculty.setValue(loggedInFacultyId);
											}
										}
									}
								});*/
							}
							else{
								courseVariant.reset();
							}
						}
					});
				},
				blur: function(obj, record) {
					var me = this;
					var form = me.getLessonplanningdetailsform();
					var faculty = form.down("#lessonPlanFacultyItemId");
					var facultyStore = faculty.getStore();
					var portalId = this.getCurrentLoggedPortalId();
					var loggedInFacultyId = null;
					if(portalId == 2) {
						loggedInFacultyId=this.getCurrentlyLoggedInUser().id;
					}
					unitTitle=form.down('#lessonPlanUnitTitleItemId');
					topic=form.down('#lessonPlanTopicsItemId');
					term=form.down('#lessonPlanTermItemId');
					duration=form.down('#lessonPlanDurationItemId');
					aim=form.down('#lessonPlanAimItemId');
					prerequisite=form.down('#lessonPlanPrerequisiteItemId');
					var referenceProgram = form.down("#referenceProgramItemId");
					var referenceProgramStore = referenceProgram.getStore();
					if(isNullOrEmpty(obj.getValue())){
						unitTitle.setDisabled(true);
						topic.setDisabled(true);
						term.setDisabled(true);
						duration.setDisabled(true);
						aim.setDisabled(true);
						prerequisite.setDisabled(true);
					}
					else {
						unitTitle.setDisabled(false);
						topic.setDisabled(false);
						term.setDisabled(false);
						duration.setDisabled(false);
						aim.setDisabled(false);
						prerequisite.setDisabled(false);
						if(isNullOrEmpty(form.down('#lessonPlanIdItemId').getValue())){
							objective=form.down('#lessonPlanObjectiveFieldItemId_0');
							objective.setDisabled(false);
							isSubObjective=form.down('[name=lessonPlanIsSubObjectiveCheckField_0]');
							isSubObjective.setDisabled(false);
							objDescription=form.down('#lessonPlanDescriptionFieldItemId_0');
							objDescription.setDisabled(false);
						}
						faculty.setDisabled(false);
						var course = form.down("#lessonPlanCourseItemId");
						/*var courseVariantId = obj.getValue();
						var courseVariantIds; 
						var cvIds=[];
						if(courseVariantId !=undefined && courseVariantId.length > 0 && courseVariantId[0] != ""){
							for(var i in courseVariantId){
								if(Ext.isObject(courseVariantId[0])){
									cvIds.push(courseVariantId[i].get("id"));
								}else{
									cvIds.push(courseVariantId[i]);
								}
							}
						} 
						courseVariantIds = cvIds.join();*/
						facultyStore.getProxy().extraParams = {
							//courseVariantIds:courseVariantIds,
							//courseId:course.getValue()
							id: me.getCurrentAcademyLocation()
						};
						/*facultyStore.load({
							callback: function(record, operation, success) {
								if (success) {
									if (record.length == 1) {
										faculty.setValue(record[0].data.id);
									}
									else{
										faculty.setValue(loggedInFacultyId);
									}
								}
							}
						});*/
					}
				}
			},
			'lessonplanningdetailsform customcombobox[itemId=referenceProgramItemId]': {
				select: function(obj, record) {
					var me = this;
					var academicTermId = record[0].get("id");
					var form = me.getLessonplanningdetailsform();
					var programLearningOutcome =form.down('[name=programLearningOutcome]');
					var referenceProgram = form.down("#referenceProgramItemId");
					var academyLocationId = this.getCurrentAcademyLocation();	
					/*if(programLearningOutcome!=undefined && programLearningOutcome!=null){
					programLearningOutcome.reset();
					var programLearningOutcomeStore = programLearningOutcome.getStore();
					programLearningOutcomeStore.removeAll();
					programLearningOutcomeStore.getProxy().extraParams = {
						programId:referenceProgram.getValue()
					};
					programLearningOutcomeStore.load();*/
					
					Ext.each(Ext.ComponentQuery.query('[name=programLearningOutcome]'), function(currentField){
					    currentField.reset();
					    currentField.clearValue();
					    currentField.getStore().getProxy().extraParams={
					    	programId:referenceProgram.getValue()
					    };
					    currentField.getStore().load();
					});
					
					Ext.each(Ext.ComponentQuery.query('[name=dublinDescriptor]'), function(dublinDescriptor){
						dublinDescriptor.reset();
						dublinDescriptor.clearValue();
						dublinDescriptor.getStore().getProxy().extraParams={
					    	programId:referenceProgram.getValue()
					    };
						dublinDescriptor.getStore().load();
					});
				//}
				}
			},
			'lessonplanningdetailsform radiogroup[itemId=lessonPlanIsSubObjectiveCheckFieldItemId]': {
				change: this.lessonPlanIsSubObjectiveCheckChange
			},
			'lessonplanningdetailsform button[itemId=lessonPlanAddObjBtnItemId]' : {
				click : function(btn){
					var me = this;
					this.addBlankObjectiveField(btn, false);
				}
			},
			'lessonplanningdetailsform button[action=addButtonLessonPlanSubObjAction]':{
				click: this.addNewLessonPlanSubObj
			},
			'lessonplanningdetailsform button[itemId=lessonPlanCancelBtnItemId]': {
				click: this.closeLessonPlanDetailFormTab
			},
			'lessonplanningdetailsform button[action=deleteButtonLessonPlanSubObjAction]':{
				click : this.deleteNewLessonPlanSubObj
			},
			'lessonplanningdetailsform customcombobox[name=lessonPlanObjectiveField]' : {
				select: function(obj, record) {
					var me = this;
					var form = me.getLessonplanningdetailsform();
					addObjective=form.down('#lessonPlanAddObjBtnItemId');
					addObjective.setDisabled(false);
				},
				change : this.onChangeObjectiveCombo,
				focus: function(combo, e, eOpts) {
					combo.lastQuery = null;
				},
				afterrender: function( combo, eOpts ) {
					var me = this;
					combo.getStore().on('beforeload', function(){
						this.getProxy().extraParams = {
							ids: '',//me.getAllSelectedObjSubObjIds(combo)
						};
					});
				} 
			},
			'lessonplanningdetailsform customcombobox[name=lessonPlanSubObjectiveField]' : {
      			 focus: function(combo, e, eOpts) {
      				combo.lastQuery = null;
      			 },
      			 afterrender: function( combo, eOpts ) {
      				 var me = this;
      				 combo.getStore().on('beforeload', function(){
  						this.getProxy().extraParams = {
  							ids: '',//me.getAllSelectedObjSubObjIds(combo)
  						 };
  					 });
      			 }
      		 },
      		 'lessonplanningdetailsform button#lessonPlanUploadDocsBtnItemId' : {
      			 click : function() {
      				 this.getDocumentController().showDocumentFormWindow('lessonPlanningDetailsFormItemId','DOCUMENT');
      			 }
      		 },
      		'lessonplanningdetailsform button#lessonPlanAddExamDetailBtnItemId' : {
     			 click : function(btn) {
     				 this.openAddExamDetailsWin(btn);
     			 }
     		 },
     		 
     		 'lessonplanningdetailsform button#lessonPlanResitDetailBtnItemId' : {
     			 click : function(btn) {
     				 this.openResitDetailsWin(btn);
     			 }
     		 },
     		 
     		 'lessonplanningaddexamwin': {
     			 afterrender: function(win){
     				 var me = this;
     				 if(isNullOrEmpty(win.examDetailsId)){
     					 me.addItemInEventsPnl(win, 1);
     				 }
     				 else{
     					 me.renderAllEvents(win, 0);
     				 }

     				 setTimeout(function(){
         				 me.hideShowAddExamWinBtns(win);
         				 if(win.isView && !win.examDatesEditable){
         					 win.down('#btnAddExamDetailsSubmit').hide();
         					win.down('#btnAddExamDetailsCancel').hide();
         				 }
         				 else if(win.isView && win.examDatesEditable){
         					win.down('#btnAddExamDetailsSubmit').show();
         					win.down('#btnAddExamDetailsCancel').show();
         				 }
         				 else{
         					win.down('#btnAddExamDetailsSubmit').show();
         					win.down('#btnAddExamDetailsCancel').show();
         				 }
     				 },300);
     			 }
     		 },
     		 
     		 'lessonplanningaddexamwin button#lessonPlanAddExamDetailsResetBtnItemId':{
     			click: this.resetButtonLessonPlanAddExamDetailsAction
     		 },
     		 
     		 'lessonplanningaddexamwin button#lessonPlanAddExamDetailsDeleteBtnItemId':{
     			 click: this.deleteButtonLessonPlanAddExamDetailsAction
     		 },
     		 
     		'lessonplanningaddexamwin button#lessonPlanAddExamDetailsAddBtnItemId':{
    			 click: this.addButtonLessonPlanAddExamDetailsAction
    		 },
    		 
    		 'lessonplanningaddexamwin button#btnAddExamDetailsSubmit':{
    			 click: this.submitLPExamDetails
    		 },
    		 
    		 'lessonplanningaddexamwin button#btnAddExamDetailsCancel':{
    			 click: function(btn){
    				 btn.up('window').close();
    			 }
    		 },
    		 
    		 'lessonplanningresitwin': {
     			 afterrender: function(win){
     				 var me = this;
     				 if(isNullOrEmpty(win.resitId)){
     					 me.addItemInResitEventsPnl(win, 1);
     				 }
     				 else{
     					 me.renderAllResitEvents(win, 0);
     				 }

     				 setTimeout(function(){
         				 me.hideShowResitWinBtns(win);
         				 if(win.isView){
         					win.down('#btnResitDetailsSubmit').hide();
         					win.down('#btnResitDetailsCancel').hide();
         				 }
         				 else{
         					win.down('#btnResitDetailsSubmit').show();
         					win.down('#btnResitDetailsCancel').show();
         				 }
     				 },300);
     			 }
     		 },
     		 
     		 'lessonplanningresitwin button#lessonPlanResitDetailsResetBtnItemId':{
     			click: this.resetButtonLessonPlanResitDetailsAction
     		 },
     		 
     		 'lessonplanningresitwin button#lessonPlanResitDetailsDeleteBtnItemId':{
     			 click: this.deleteButtonLessonPlanResitDetailsAction
     		 },
     		 
     		'lessonplanningresitwin button#lessonPlanResitDetailsAddBtnItemId':{
    			 click: this.addButtonLessonPlanResitDetailsAction
    		 },
    		 
    		 'lessonplanningresitwin button#btnResitDetailsSubmit':{
    			 click: this.submitLPResitDetails
    		 },
    		 
    		 'lessonplanningresitwin button#btnResitDetailsCancel':{
    			 click: function(btn){
    				 btn.up('window').close();
    			 }
    		 },
     		
      		'documentformwindow[itemId=lessonPlanningDetailsFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
      			 click : function() {
      				 var $this = this;
      				 var isTransient = true;
      				 var module = 'lessonPlanning';
      				 var entityId;
      				 var entityType = 'lessonPlanningDocument';

      				 $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', 
  						 function(success, response, isCallBackTransient) {
							 var documentModel = new Academia.model.course.CourseDocument();
							 documentModel.set("documentName", response.name);
							 documentModel.set("path", response.path);
							 documentModel.set("type", response.type);
							 documentModel.set("documentName", response.name);
							 documentModel.set("createdBy", $this.getIdValueJsonLP(response.createdBy.id, response.createdBy.value));
							 var lessonPlanDocGrid = $this.getLessonplanningdocumentgrid();
							 var store = lessonPlanDocGrid.getStore();
							 store.add(documentModel);
							 if (lessonPlanDocGrid.isHidden() && store.data.items.length > 0) {
								 lessonPlanDocGrid.setVisible(true);
							 }
							 $this.getDocumentController().closeDocumentFormWindow();
							 showSuccessMessage(getProgramandcourseTranslation('Lesson Planning'),getProgramandcourseTranslation('Document added successfully'));
      				 	},
      				 isTransient);
      			}
      		},
      		'lessonplanningdocumentgrid': {
      			cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
      				var $this = this;
      				var documentGrid = $this.getLessonplanningdocumentgrid();
      				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
      				if (columnName == "documentName") {
      					if (e.target.tagName == 'A') {
      						var documentId = record.get("documentId");
      						if (!isNullOrEmpty(documentId)) {
      							$this.getDocumentController().downloadDocumentFile(documentId);
      						}
      					}
      				}
      			}
      		},
      		'lessonplanningdocumentgrid button#btnDelete' : {
      			click : function() {
      				var $this = this;
      				var grid = $this.getLessonplanningdocumentgrid();
      				if (grid.getSelectionModel().getCount() > 0) {
      					showConfirmMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
      					function(btn,text) {
      						if (btn == 'yes') {
      							var store = grid.getStore();
      							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      							var record = grid.getSelectionModel().getSelection()[0];
      							var id = record.get("id");
      							if (!isNullOrEmpty(id)) {
      								Ext.Ajax.request({
      									method : "DELETE",
      									type : 'rest',
      									url : SERVERURL.LESSON_PLAN_DOCUMENT_DELETE + '?id=' + id,
      									headers : {
      										'Content-Type' : 'application/json'
      									},
      									success : function(form, action) {
      										Ext.getBody().unmask();
      										store.reload();
      										showSuccessMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
      									}
      								});
      							} else {
      								if (record) {
      									store.remove(record);
      									showSuccessMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
      								}
      								Ext.getBody().unmask();
      							}
      						}
      					});
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		'lessonplanninggrid #moreActionPublishBtn':{
      			afterrender: function(btn){
      				var me = this;
      				var gridReference = this.getContentPanel().getActiveTab().down('lessonplanninggrid');
      				
      				var moreBtn = gridReference.down('#btnMoreOperations');
      				var moreActionPermissionList = moreBtn.permissions;
      				
      				var isBtnVisible = false;
      				Ext.each(moreActionPermissionList, function(privilege) {
                		   if (privilege === 'PUBLISH') {
                			   isBtnVisible = true;
                		   }
      				});
      				btn.setVisible(isBtnVisible);
      			},
      			click : function(btn) {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() == 1) {
							var store = grid.getStore();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							
							var isPublish = true;
 						   	var isValidate = true;
 						   								
							if (!isNullOrEmpty(ids)) {
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids+ '&isPublished='+isPublish+'&isValidated='+isValidate,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										grid.getSelectionModel().deselectAll();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		'lessonplanninggrid #moreActionValidateBtn':{
      			afterrender: function(btn){
      				var me = this;
      				var gridReference = this.getContentPanel().getActiveTab().down('lessonplanninggrid');
      				
      				var moreBtn = gridReference.down('#btnMoreOperations');
      				var moreActionPermissionList = moreBtn.permissions;
      				
      				var isBtnVisible = false;
      				Ext.each(moreActionPermissionList, function(privilege) {
                		   if (privilege === 'VALIDATE') {
                			   isBtnVisible = true;
                		   }
      				});
      				btn.setVisible(isBtnVisible);
      			},
      			click : function(btn) {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() == 1) {
							var store = grid.getStore();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							
							var isPublish = false;
 						   	var isValidate = true;
							
							if (!isNullOrEmpty(ids)) {
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids + '&isPublished='+isPublish+'&isValidated='+isValidate,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										grid.getSelectionModel().deselectAll();
										store.reload();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		'lessonplanninggrid #moreActionUnPublishBtn':{
      			afterrender: function(btn){
      				var me = this;
      				var gridReference = this.getContentPanel().getActiveTab().down('lessonplanninggrid');
      				
      				var moreBtn = gridReference.down('#btnMoreOperations');
      				var moreActionPermissionList = moreBtn.permissions;
      				      				
      				var isBtnVisible = false;
      				Ext.each(moreActionPermissionList, function(privilege) {
                		   if (privilege === 'UNPUBLISH') {
                			   isBtnVisible = true;
                		   }
      				});
      				btn.setVisible(isBtnVisible);
      			},
      			click : function(btn) {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() == 1) {
							var store = grid.getStore();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							
							var isPublish = false;
 						   	var isValidate = true;
							
							if (!isNullOrEmpty(ids)) {
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids + '&isPublished='+isPublish+'&isValidated='+isValidate,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										grid.getSelectionModel().deselectAll();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		'lessonplanninggrid #moreActionUnValidateBtn':{
      			afterrender: function(btn){
      				var me = this;
      				var gridReference = this.getContentPanel().getActiveTab().down('lessonplanninggrid');
      				
      				var moreBtn = gridReference.down('#btnMoreOperations');
      				var moreActionPermissionList = moreBtn.permissions;
      				
      				var isBtnVisible = false;
      				Ext.each(moreActionPermissionList, function(privilege) {
                		   if (privilege === 'UNVALIDATE') {
                			   isBtnVisible = true;
                		   }
      				});
      				btn.setVisible(isBtnVisible);
      			},
      			click : function(btn) {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() == 1) {
							var store = grid.getStore();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							
							var isPublish = false;
 						   	var isValidate = false;
							
							if (!isNullOrEmpty(ids)) {
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids + '&isPublished='+isPublish+'&isValidated='+isValidate,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										grid.getSelectionModel().deselectAll();
										store.reload();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		'lessonplanninggrid button#btnPublishId' : {
      			click : function() {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() > 0) {
							var store = grid.getStore();
							//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							var isPublish =  record[0].data.whethePublished;
							var isValidate = record[0].data.whetherValidated;
							if(isValidate == "Validated") {
			        isValidated = true;
			        isPublished = true;
		            }else {
			          isValidated = false;
			          isPublished = false;
		            }
		            		
							if(isValidate=='Not Validated'){
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CANNOT_PUBLISH_UNVALIDATED_LESSON_PLAN')); 
							}
							else if (!isNullOrEmpty(ids)) {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids + '&isPublished='+isPublished+'&isValidated='+isValidated,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		
      		'lessonplanninggrid button#lessonPlanningValidateBtn' : {
      			click : function() {
      				var $this = this;
      				var grid = $this.getLessonplanninggrid();
      				if (grid.getSelectionModel().getCount() > 0) {
							var store = grid.getStore();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var record = grid.getSelectionModel().getSelection();
							var ids = Ext.Array.pluck(Ext.Array.pluck(record, 'data'),'id').join();
							if (!isNullOrEmpty(ids)) {
								Ext.Ajax.request({
									method : "POST",
									type : 'rest',
									url : SERVERURL.PATH_UPDATE_LESSON_PLAN_PUBLISH_VALIDATE + '?ids=' + ids + '&isValidated=true',
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form, action) {
										Ext.getBody().unmask();
										store.reload();
										if(form.responseText == 'SUCCESS'){
					                           showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SUCCESS'));
										}else{
											showWarningMessage("alert","Please Create Variant for the course(s) : "+form.responseText); 
										}
										store.removeAll();
										store.reload();
									}
								});
							}
						
      				} else {
      					showWarningMessage(getProgramandcourseTranslation('Lesson Planning'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
      				}
      			}
      		},
      		
      		'lessonplandocumentgriddownload button[itemId=downloadDocumentItemId]':{
      			click:function(obj){
      				this.downloadAllLessonDocumentFormsZip();
      			}
      		},
      		'documentformwindow[itemId=lessonPlanningDetailsFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
      			click : function() {
      				this.getDocumentController().closeDocumentFormWindow();
      			}
      		}
		});
	},
	//-- END -- initialization

	//-- START -- functions
	addBlankObjectiveField:function(cmp, isView){
		if(!Ext.isDefined(isView)){
			isView = false;
		}
		var me = this;
		var form = me.getLessonplanningdetailsform();
		var lessonPlanMainPnl = form.down('#lessonPlanMainPnlItemId');
		var objectCount = lessonPlanMainPnl.items.length;
		var panelItem = new Array();
		if(objectCount==0){
			var fieldDisable = false;
		}
		else {
			var fieldDisable = false;
		}
		if(Ext.isDefined(isView) && isView ==true){
			fieldDisable = true;
		}
		if(this.getCurrentLoggedPortalId() == 1){
			this.disableAddExamAndResitButtonPivileges(form, this.getLESSON_PLANNING_DETAIL_FROM_BUTTON_PRIVILEGES_PERMISSIONS()); 
        }
        else{
			this.disableResitButtonPivileges(form, this.getLESSON_PLANNING_FACULTY_DETAIL_FROM_BUTTON_PERMISSIONS());
		}
        //this.disableIsValidationAndRestricTLPCheckBox(form, this.getLESSON_PLANNING_PERMISSIONS());
        //}else{
        //this.disableIsValidationAndRestricTLPCheckBox(form, this.getLESSON_PLANNING_FACULTY_PERMISSIONS());
        //}
		
		var objectiveContainer = me.generateNewObjectiveCode(objectCount,fieldDisable, fieldDisable);
		objectiveContainer.width = '96%';
		

		panelItem.push({
			xtype:'panel',
			width:'100%',
			layout:{
				type:'hbox'
			},
			style:{
				marginBottom:'0px',
				left:'0px',
				marginLeft:'0px',
				marginTop:'10px'
			},
			items:[objectiveContainer,{
				xtype : 'button',
				itemId: 'lessonPlanObjDeleteBtnItemId_'+objectCount,
				width:'4%',
				glyph: ICONGLYPH.DELETEGLYPH,
				cls: 'CustomBodyBtnReject',
				margin:'10px 0 0 0',
				action: 'deleteButtonLessonPlanAction',
				tooltip: getCommonTranslation('DELETETOOLTIP'),
				listeners:{
					click:function(obj){
						var container = obj.up('panel');
						//lessonPlanMainPnl.remove(container);
						container.hide();
						container.down('[name=isObjDeleted]').setValue(1);
						me.setAllowBlank(container.down('[name=lessonPlanObjectiveField]'),true);
						container.down('[name=lessonPlanObjectiveField]').setValue('null');
						lessonPlanMainPnl.doLayout();
						
						me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform());
						
						var allObjectives  = Ext.ComponentQuery.query('[name=lessonPlanObjectiveField]');
						var isAddButtonDisable = false;
						Ext.each(allObjectives, function(currentObjective){
							if(isNullOrEmpty(currentObjective.getValue())){
								isAddButtonDisable = true;
							}
						});

						me.getLessonplanningdetailsform().down('#lessonPlanAddObjBtnItemId').setDisabled(isAddButtonDisable);
					},
					render: function(btn){
						if(objectCount==0 || isView==true){
							btn.setVisible(false); // cannot delete first objective
						}else{
							btn.setVisible(true);
						}
					}
				}
			}]
		});

		lessonPlanMainPnl.items.each(function(item, index, items) {
			if(item.items.items[0].getCollapsed() == false){
				item.items.items[0].toggleCollapse(true);	 
			}
		});
		lessonPlanMainPnl.add(panelItem);
		lessonPlanMainPnl.doLayout();

		//-- disable add object button if we have blank objective field
		//form.down('#lessonPlanAddObjBtnItemId').setDisabled(true);
		if(objectCount==0 && !fieldDisable){
			form.down('#lessonPlanAddObjBtnItemId').setDisabled(false);
		}else{
			form.down('#lessonPlanAddObjBtnItemId').setDisabled(true);
		}
	},
	addPreFilledObjectiveField: function(lessonPlanObjectives, currentRecordInc, jsonData, isView){
		var me = this;
		var form = me.getLessonplanningdetailsform();
		var objectivePnl = form.down('#lessonPlanMainPnlItemId');
		if(isView){
			me.getLessonplanningdocumentgrid().down('#btnDelete').setDisabled(true);
		}
		if(currentRecordInc<lessonPlanObjectives.length) {
			me.addBlankObjectiveField(form, isView); //adding blank objective first

			setTimeout(function(){
				var newAddedObj = objectivePnl.down('#lessonPlanObjPnlItemId_'+currentRecordInc);
				var lessonPlanHiddenObjField = newAddedObj.down('#lessonPlanHiddenObjIdItemId_'+currentRecordInc);
				var lessonPlanObjectiveField = newAddedObj.down('#lessonPlanObjectiveFieldItemId_'+currentRecordInc);
				var lessonPlanDescriptionField = newAddedObj.down('#lessonPlanDescriptionFieldItemId_'+currentRecordInc);
				var isSubObjective=newAddedObj.down('#lessonPlanIsSubObjectiveCheckFieldItemId');

				lessonPlanObjectiveField.setDisabled(false);
				lessonPlanDescriptionField.setDisabled(false);
				isSubObjective.setDisabled(false);

				lessonPlanHiddenObjField.setValue(jsonData.lessonPlanObjectives[currentRecordInc].id);
				lessonPlanObjectiveField.setValue(jsonData.lessonPlanObjectives[currentRecordInc].objective.id);
				lessonPlanDescriptionField.setValue(jsonData.lessonPlanObjectives[currentRecordInc].remark);

				if (jsonData.lessonPlanObjectives[currentRecordInc].isSubObjectiveRequired)
				{
					isSubObjective.items.items[0].setValue(true);
					isSubObjective.items.items[1].setValue(false);

					setTimeout(function(){
						//--first subobjective will be added automatically on change event
						var subObjectiveHiddenId = newAddedObj.down('[name=lessonPlanHiddenSubObjId]');
						var subObjectiveIdField = newAddedObj.down('[name=lessonPlanSubObjectiveField]');
						var programLearningOutcomeField = newAddedObj.down('[name=programLearningOutcome]');
						var dublinDescriptorField = newAddedObj.down('[name=dublinDescriptor]');
						var subObjectiveDescIdField = newAddedObj.down('[name=lessonPlanSubObjectiveDescField]');
						
						subObjectiveHiddenId.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].id);
						subObjectiveIdField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].subObjective.id);
						if(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].programLearningOutcome!=undefined){
							newAddedObj.down('[name=programLearningOutcomeHidden]').setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].programLearningOutcome.id);
							programLearningOutcomeField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].programLearningOutcome.programLearningOutcomeName);
						}
						if(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].dublinDescriptors!=undefined){
						newAddedObj.down('[name=dublinDescriptorHidden]').setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].dublinDescriptors.id);
						dublinDescriptorField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].dublinDescriptors.dublinDescriptorsName);
						}
						subObjectiveDescIdField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].remark);

						//--continue adding more subobjectives from second subobjective
						var subObjectivePnl = newAddedObj.down('#lessonPlanSubObjPnlItemId');
						var currentRecordSubInc = 1;
						me.addLessonPlanSubObjectives(subObjectivePnl, lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives, currentRecordSubInc, isView);

						setTimeout(function(){
							me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform()); //validating fields and setting button enable/disable manually

							if(isView){
								toggleReadOnlyFormItems(me.getLessonplanningdetailsform().getForm(), true);
								/*//--disabled all objective buttons
								Ext.each(Ext.ComponentQuery.query('[action=deleteButtonLessonPlanAction]'), function(objDeleteBtns){
									objDeleteBtns.setDisabled(true);
								});*/
						
								//--subobj all objective buttons
								Ext.each(Ext.ComponentQuery.query('[action=deleteButtonLessonPlanSubObjAction]'), function(subObjDeleteBtns){
									subObjDeleteBtns.setDisabled(true);
								});
								
								Ext.each(Ext.ComponentQuery.query('[action=addButtonLessonPlanSubObjAction]'), function(subObjAddBtns){
									subObjAddBtns.setDisabled(true);
								});
							}

							//--increasing currentRecordInc value and calling this function again
							currentRecordInc = currentRecordInc+1;
							me.addPreFilledObjectiveField(lessonPlanObjectives, currentRecordInc, jsonData, isView);
						},(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives.length)*1500);
					},1500);

				} else {
					isSubObjective.items.items[0].setValue(false);
					isSubObjective.items.items[1].setValue(true);

					me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform()); //validating fields and setting button enable/disable manually

					//--increasing currentRecordInc value and calling this function again
					currentRecordInc = currentRecordInc+1;
					me.addPreFilledObjectiveField(lessonPlanObjectives, currentRecordInc, jsonData, isView);
				}
			},1000);
		}
		else{
			//hide loader here
			Ext.getBody().unmask();
		}
	},
	addLessonPlanSubObjectives: function(subObjectivePnl, lessonPlanSubObjectives, currentRecordSubInc, isView){
		var me = this;
		if(currentRecordSubInc<lessonPlanSubObjectives.length)
		{
			var addButton = subObjectivePnl.down('[action=addButtonLessonPlanSubObjAction]');

			var newStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
			newStore.load({
				callback: function(){
					var subObjectiveContainer = me.generateNewSubObjectiveCode(currentRecordSubInc,lessonPlanSubObjectives[currentRecordSubInc].id,lessonPlanSubObjectives[currentRecordSubInc].subObjective.id,
							isNullOrEmpty(lessonPlanSubObjectives[currentRecordSubInc].programLearningOutcome) ? "": lessonPlanSubObjectives[currentRecordSubInc].programLearningOutcome.programLearningOutcomeName,isNullOrEmpty(lessonPlanSubObjectives[currentRecordSubInc].dublinDescriptors) ? "":lessonPlanSubObjectives[currentRecordSubInc].dublinDescriptors.dublinDescriptorsName,lessonPlanSubObjectives[currentRecordSubInc].remark,newStore,isView,
									isNullOrEmpty(lessonPlanSubObjectives[currentRecordSubInc].programLearningOutcome) ? "": lessonPlanSubObjectives[currentRecordSubInc].programLearningOutcome.id,isNullOrEmpty(lessonPlanSubObjectives[currentRecordSubInc].dublinDescriptors) ? "":lessonPlanSubObjectives[currentRecordSubInc].dublinDescriptors.id);

					var panelItem = new Array();
					panelItem.push(subObjectiveContainer);
					subObjectivePnl.add(panelItem);

					setTimeout(function(){
						me.hideShowSubObjectiveDetails(addButton,subObjectivePnl);
						subObjectivePnl.doLayout();
						me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform()); //validating fields and setting button enable/disable manually

						if(isView){
							toggleReadOnlyFormItems(me.getLessonplanningdetailsform().getForm(), true);
						}

						currentRecordSubInc = currentRecordSubInc+1;
						me.addLessonPlanSubObjectives(subObjectivePnl, lessonPlanSubObjectives, currentRecordSubInc, isView);
					},300);
				}
			});
		}
	},
	generateNewObjectiveCode: function(newInc,fieldDisable,fieldReadOnly){
		var me = this;
		var newStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
		newStore.load();
		
		var objectiveContainer = {
				xtype:'panel',
				itemId:'lessonPlanObjPnlItemId_'+newInc,
				collapsible : true,
				collapsed: false,
				style:{
					marginBottom:'10px',
					marginLeft:'0px',
					marginTop:'0px'
				},
				title: getCommonTranslation('OBJECTIVE'),
				items:[
					{
						xtype: 'fieldcontainer',
						width:'100%',
						layout: {
							type: 'hbox'
						},
						defaults :{
							width: 226,
							labelAlign:'top'
						},
						items: [
							{
								xtype: 'hiddenfield',
								name:'lessonPlanHiddenObjId',
								itemId: 'lessonPlanHiddenObjIdItemId_'+newInc
							},
							{
								xtype: 'hiddenfield',
								name:'isObjDeleted',
								value: 0
							},
							{
								xtype: 'customcombobox',
								fieldLabel:getCommonTranslation('OBJECTIVE'),
								name:'lessonPlanObjectiveField',
								itemId: 'lessonPlanObjectiveFieldItemId_'+newInc,
								store:newStore,
								displayField:'value',
								valueField: 'id',
								disabled: fieldDisable,
								forceSelection:true,
								readOnly: fieldReadOnly,
								listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.width = picker.up('combobox').getSize().width;
                            
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                        '{value}'  +
                        '</div>';
                    }
                }
							},
							{
								xtype      : 'radiogroup',
								fieldLabel : getCommonTranslation('IS_SUB_OBJECTIVE'),
								name:'lessonPlanIsSubObjectiveCheckField_'+newInc, // HERE NAME WILL BE DYNAMIC
								itemId:'lessonPlanIsSubObjectiveCheckFieldItemId',
								disabled: fieldDisable,
								readOnly: fieldReadOnly,
								defaults: {
									flex: 1
								},
								layout: 'hbox',
								items: [
									{
										boxLabel  :getCommonTranslation('YES') ,
										name      : 'lessonPlanIsSubObjectiveCheckField_'+newInc,
										readOnly: fieldReadOnly,
										inputValue: true
									},
									{
										boxLabel  : getCommonTranslation('NO'),
										name      : 'lessonPlanIsSubObjectiveCheckField_'+newInc,
										readOnly: fieldReadOnly,
										inputValue: false,
										checked:true
									}
								]
							}
						]
					},
					{
						xtype: 'fieldcontainer',
						width:'100%',
						layout: {
							type: 'hbox'
						},
						defaults :{
							labelAlign:'top'
						},
						style:{
							marginBottom:'0px'
						},
						items: [
							{
								xtype: 'textareafield',
								name: 'lessonPlanDescriptionField',
								flex:1,
								itemId:'lessonPlanDescriptionFieldItemId_'+newInc,	                
								allowBlank: true,
								disabled:fieldDisable,
								readOnly: fieldReadOnly,
								maxLength: 10000
							}
							]
					},
					{
						xtype:'panel',
						itemId:'lessonPlanSubObjPnlItemId', //not changing itemId
						width:'100%',
						hidden:true,
						style:{
							marginLeft:'0px',
							marginTop:'0px',
							marginBottom:'0px'
						},
						items:[]
					}
					]
		};
		return objectiveContainer;
	},
	generateNewSubObjectiveCode: function(newSubInc,subObjectiveId, subObjectiveValue,LOAValue,dublinValue,subObjectiveDescValue, newStore,isView,PLOhiddenId,dublinHiddenId){
		var form = this.getLessonplanningdetailsform();
		var referenceProgram = form.down("#referenceProgramItemId");
		var subObjectiveStore = Ext.create('Academia.store.lessonplan.LessonPlanningSubObjectiveStore');
		subObjectiveStore.load();
		var programLearningOutcomeStore = Ext.create('Academia.store.lessonplan.ProgramLearningOutcomeStore');
		 programLearningOutcomeStore.getProxy().extraParams = {
						programId:referenceProgram.getValue()
					};
		programLearningOutcomeStore.load();
		var dublinDescriptorStore = Ext.create('Academia.store.lessonplan.DublinDescriptorStore');
		dublinDescriptorStore.getProxy().extraParams = {
			programId:referenceProgram.getValue()
		};
		dublinDescriptorStore.load();
		if(!Ext.isDefined(isView)){
			isView = false;
		}
		var subObjectiveContainer = {
				xtype:'panel',
				width:'100%',
				layout : {
					type : 'vbox'
				},
				style:{
					marginLeft:'0px',
					marginTop:'0px',
					marginBottom:'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					defaults : {
						labelAlign : 'top',
						width:212
					},
					layout : {
						type : 'hbox'
					},
					standardSubmit: false,
					plugins:"formlabelrequired", 
					items:[{
						xtype: 'hiddenfield',
						name:'lessonPlanHiddenSubObjId',
						itemId: 'lessonPlanHiddenSubObjIdItemId_'+newSubInc,
						value: subObjectiveId
					},{
						xtype: 'hiddenfield',
						name: 'isDeleted',
						value: 0
					},{
						xtype: 'customcombobox',
						name: 'lessonPlanSubObjectiveField',
						itemId: 'lessonPlanSubObjectiveFieldItemId_'+newSubInc,
						fieldLabel: getProgramandcourseTranslation('SUB_OBJECTIVE'),
						store:subObjectiveStore,
						displayField:'value',
						valueField:'id',
						value:subObjectiveValue,
						typeAhead:true,
						forceSelection:false,
						allowBlank: false,
						readOnly: isView,
						editable:false,
						listConfig: {
                            listeners: {
                                beforeshow: function(picker) {
                                    picker.minWidth = picker.up('combobox').getSize().width;
                                    picker.width = picker.up('combobox').getSize().width;
                                    
                                }
                            },
                    }
					},
					 {
		            	xtype: 'customcombobox',
						fieldLabel: getProgramandcourseTranslation('PROGRAM_LEARNING_OUTCOME'), 
						name:'programLearningOutcome',
						itemId: 'programLearningOutcomeItemId_'+newSubInc,
						store:programLearningOutcomeStore,
						displayField: 'value',
						valueField: 'id',
						value:LOAValue,
						typeAhead:true,					
						forceSelection:false,
						allowBlank: true,
						readOnly: isView,
						editable:false,
						listConfig: {
                            listeners: {
                                beforeshow: function(picker) {
                                    picker.minWidth = picker.up('combobox').getSize().width;
                                    picker.width = picker.up('combobox').getSize().width;
                                    
                                }
                            },
                    }
		            },{
		                xtype: 'hiddenfield',
		                itemId: 'programLearningOutcomeHiddenId',
		                name: 'programLearningOutcomeHidden',
		                value: PLOhiddenId
		            },
		            {
		            	xtype: 'customcombobox',
						fieldLabel: getProgramandcourseTranslation('DUBLIN_DESCRIPTOR'),
						name:'dublinDescriptor',
						itemId: 'dublinDescriptorItemId_'+newSubInc,
						store:dublinDescriptorStore,
						displayField: 'value',
						valueField: 'id',
						value:dublinValue,
						typeAhead:true,					
						forceSelection:false,
						allowBlank: true,
						readOnly: isView,
						editable:false,
						listConfig: {
                            listeners: {
                                beforeshow: function(picker) {
                                    picker.minWidth = picker.up('combobox').getSize().width;
                                    picker.width = picker.up('combobox').getSize().width;
                                    
                                }
                            },
                    }
		            },
		            {
		                xtype: 'hiddenfield',
		                itemId: 'dublinDescriptorHiddenId',
		                name: 'dublinDescriptorHidden',
		                value: dublinHiddenId
		            }]
				},{
					xtype:'fieldcontainer',
					width:'100%',
					layout:{
						type:'hbox'
					},
					style:{
						marginBottom:'0px'
					},
					items:[{
						xtype: 'textareafield',
						name: 'lessonPlanSubObjectiveDescField',
						flex:2,
						itemId:'subObjectiveDescItemId_'+newSubInc,
						value:subObjectiveDescValue,
						allowBlank: true,
						readOnly: isView,
						maxLength: 10000
					},{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						itemId: 'lessonPlanSubObjDeleteBtnItemId_'+newSubInc,
						width: 'auto',
						cls: 'CustomBodyBtnReject',
						action: 'deleteButtonLessonPlanSubObjAction',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
						disabled: isView,
						listeners: {
							afterrender: function(obj){
								if(isView==true){
									obj.setDisabled(true);
								}
							}
						}
					},{
						xtype : 'button',
						itemId: 'lessonPlanSubObjAddBtnItemId_'+newSubInc,
						width: 'auto',
						cls: 'CustomBodyBtnSettings',
						action: 'addButtonLessonPlanSubObjAction',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						disabled: isView,
						listeners: {
							afterrender: function(obj){
								if(isView==true){
									obj.setDisabled(true);
								}
							}
						}
					}]
				}]
		};
		return subObjectiveContainer;
	},
	checkAndValidateLessonPlanningForm: function(form){
		if(form.isValid()){
			form.down('#lessonPlanSaveBtnItemId').setDisabled(false);
		}
		else {
			form.down('#lessonPlanSaveBtnItemId').setDisabled(true);
		}
	},
	lessonPlanIsSubObjectiveCheckChange: function(elm, newValue, oldValue, eOpts ){
		var me = this;
		var form = me.getLessonplanningdetailsform(),
		subObjectivePnl = elm.up('panel').down('#lessonPlanSubObjPnlItemId');

		var val = newValue[Object.keys(newValue)[0]];
		if(!isNullOrEmpty(newValue) && val == true){
			var newStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
			newStore.load({
				callback: function(){
					var panelItem = new Array();
					var subObjectiveContainer = me.generateNewSubObjectiveCode(0,'',null,null,null,'',newStore);
					panelItem.push(subObjectiveContainer);
					subObjectivePnl.add(panelItem);
					subObjectivePnl.show();
					me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform()); //validating fields and setting button enable/disable manually
				}
			});
		}
		else{
			subObjectivePnl.removeAll();
			subObjectivePnl.hide();
			me.checkAndValidateLessonPlanningForm(me.getLessonplanningdetailsform()); //validating fields and setting button enable/disable manually
		}
	},

	hideShowSubObjectiveDetails: function(addButton, detailedPanel) {
		var this$ = this;
		var form = this$.getLessonplanningdetailsform();
		addButton.hide();
	},

	addNewLessonPlanSubObj: function(addButton){
		var $this = this;	 	            	
		var detailedForm = $this.getLessonplanningdetailsform();
		var lessonPlanSubObjPnl = addButton.up('#lessonPlanSubObjPnlItemId');
		var currentRecordSubInc = lessonPlanSubObjPnl.items.length;

		var newStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
		newStore.load({
			callback: function(){
				var subObjectiveContainer = $this.generateNewSubObjectiveCode(currentRecordSubInc,'',null,null,null,'',newStore);

				var panelItem = new Array();
				panelItem.push(subObjectiveContainer);
				lessonPlanSubObjPnl.add(panelItem);
				$this.checkAndValidateLessonPlanningForm($this.getLessonplanningdetailsform());
				$this.hideShowSubObjectiveDetails(addButton,lessonPlanSubObjPnl);
				lessonPlanSubObjPnl.doLayout();
			}
		});
	},

	closeLessonPlanDetailFormTab:function(){
		var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
		var contentpanel = this.getContentPanel();
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
	},

	deleteNewLessonPlanSubObj: function(deleteButton) {
		var this$ = this;
		var form = this.getLessonplanningdetailsform();

		var timeSlotPanel = deleteButton.up('panel').up();
		var container = deleteButton.up('panel');

		if (container != null && timeSlotPanel != null) {
			
			var notDeletedSubObjs = [];
			Ext.each(timeSlotPanel.items.items, function(currentSubObj){
				if(currentSubObj.hidden!=true){
					notDeletedSubObjs.push(currentSubObj);
				}
				else{
					currentSubObj.down('[name=lessonPlanSubObjectiveField]').setValue('null');
					currentSubObj.down('[name=programLearningOutcome]').setValue('null');
					currentSubObj.down('[name=dublinDescriptor]').setValue('null');
				}
			});
			
			if (notDeletedSubObjs.length > 1) {
				//timeSlotPanel.remove(container);
				container.down('[name=isDeleted]').setValue(1);
				container.hide();
				Ext.each(timeSlotPanel.items.items, function(currentSubObj){
					if(currentSubObj.hidden!=true){
						notDeletedSubObjs.push(currentSubObj);
					}
					else{
						currentSubObj.down('[name=lessonPlanSubObjectiveField]').setValue('null');
						currentSubObj.down('[name=programLearningOutcome]').setValue('null');
						currentSubObj.down('[name=dublinDescriptor]').setValue('null');
					}
				});
				
				var lastPnl = notDeletedSubObjs[notDeletedSubObjs.length-1];
				lastPnl.down('button[action=addButtonLessonPlanSubObjAction]').show();
				
				/*var lastPnl = timeSlotPanel.items.items[timeSlotPanel.items.length - 1];
				lastPnl.down('button[action=addButtonLessonPlanSubObjAction]').show();*/
			}
		}
		this$.checkAndValidateLessonPlanningForm(this$.getLessonplanningdetailsform());
	},
	onChangeObjectiveCombo:function(combo, newValue, oldValue, eOpts){
		var me = this;
		var pnlTitle = combo.up('panel'),
		store = combo.getStore(),
		rec = store.getById(combo.getValue()),
		titleText = rec.data.value;
		pnlTitle.setTitle(titleText);
		var form = me.getLessonplanningdetailsform();
		addObjective=form.down('#lessonPlanAddObjBtnItemId');
		addObjective.setDisabled(false);
	},
	getAllSelectedObjSubObjIds: function(combo){
		var ids = [];
		//-- Getting objective fields data
		Ext.each(Ext.ComponentQuery.query('[name=lessonPlanObjectiveField]'), function(currentObj){
			if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue()) && currentObj.getValue()!="null"){
				ids.push(currentObj.getValue());
			}
		});

		//-- Getting sub-objective fields data by name
		Ext.each(Ext.ComponentQuery.query('[name=lessonPlanSubObjectiveField]'), function(currentObj){
			if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue()) && currentObj.getValue()!="null"){
				ids.push(currentObj.getValue());
			}
		});
		Ext.each(Ext.ComponentQuery.query('[name=programLearningOutcome]'), function(currentObj){
			if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue()) && currentObj.getValue()!="null"){
				ids.push(currentObj.getValue());
			}
		});
		Ext.each(Ext.ComponentQuery.query('[name=dublinDescriptor]'), function(currentObj){
			if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue()) && currentObj.getValue()!="null"){
				ids.push(currentObj.getValue());
			}
		});
		
		return ids.join();
	},
	getDocumentController : function() {
		var this$ = this;
		return this$.getController('Academia.controller.document.DocumentController');
	},
	getIdValueJsonLP: function(id, value,code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	},
	downloadAllLessonDocumentFormsZip:function() {
		var $this=this;
		var grid=$this.getLessonplandocumentgriddownload();
		var records = grid.getStore().data.items;
		var saveModel=[];  
		var dispatchZipName = "Lesson PLan Document";
		for(var i in records){
			if(!isNullOrEmpty(records[i].get('path'))) {
				saveModel.push(records[i].get('path'));
			}
		}
		showConfirmMessage(getProgramandcourseTranslation('LESSON_PLAN_DOCUMENTS'), getProgramandcourseTranslation('LESSON_PLAN_DOCUMENTS_ALERT'),
		function(btn, text) {
			if (btn == 'yes') {
				var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
				$this.getDocumentController().downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
			}
		});
	},
	saveUpdateLessonPlanData: function() {
		var $this = this;
		var form = $this.getLessonplanningdetailsform().getForm();
		var formValues = form.getValues();
		
		var lessonPlan = new Academia.model.lessonplan.LessonPlanModel();
		lessonPlan.set("id",formValues.lessonPlanId);
		lessonPlan.set("academicTerm",$this.getIdValueJsonLP(formValues.lessonPlanAcademicTerm));
		lessonPlan.set("course",$this.getIdValueJsonLP(formValues.lessonPlanCourse));
		
		var lessonPlanStaffIds = [];
		if(formValues.lessonPlanFaculty && formValues.lessonPlanFaculty.length){
		    var filteredFaculty = Ext.Array.filter(formValues.lessonPlanFaculty, function(item){
		        return item && item !== " ";
		    });

		    if(!filteredFaculty.length){
		        return;
		    }
		    var staffIds = '';
		    if(typeof filteredFaculty[0] == "object"){
		        staffIds = Ext.Array.pluck(Ext.Array.pluck(filteredFaculty,'data'),'id');
		    } else{
		        if (Ext.isArray(filteredFaculty)){
		            staffIds = filteredFaculty;
		        }else if (Ext.isString(filteredFaculty)){
		            staffIds = filteredFaculty.split(',');
		        }
		    }
		    if(staffIds.length && !isNullOrEmpty(staffIds[0])){
		        Ext.each(staffIds, function(currentStaffId){
		            lessonPlanStaffIds.push({
		                "id":null,
		                "lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
		                "staff" : $this.getIdValueJsonLP(currentStaffId)
		            });
		        });
		    }
		}
		
		lessonPlan.set("unitTitle",formValues.lessonPlanUnitTitle);
		lessonPlan.set("topics",formValues.lessonPlanTopics);
		lessonPlan.set("term",formValues.lessonPlanTerm);
		lessonPlan.set("aim",formValues.lessonPlanAim);
		lessonPlan.set("dateOfPlan",formValues.lessonPlanDateOfPlanning);
		lessonPlan.set("preRequisites",formValues.lessonPlanPrerequisite);
		lessonPlan.set("lessonPlanDuration",$this.getIdValueJsonLP(formValues.lessonPlanDuration));
		lessonPlan.set("superVisedPracticeHours",formValues.superVisedPracticeHours);
		lessonPlan.set("isRestrictMultipleLPOfaCourse",formValues.isRestrictMultipleLPOfaCourse);
		lessonPlan.set("isValidationRequired",formValues.isValidationRequired);
		lessonPlan.set("generalEducationCategory",$this.getIdValueJsonLP(formValues.generalEducationCategory));
		lessonPlan.set("referenceProgram",$this.getIdValueJsonLP(formValues.referenceProgram));
		lessonPlan.set("maxAbsences",formValues.maxAbsences);
		lessonPlan.set("adminAbsences",formValues.adminAbsences);
		lessonPlan.set("facultyOfficeHours",formValues.facultyOfficeHours);
		var contentpanel = this.getContentPanel();
    	var activeTab = contentpanel.getActiveTab();
		
		var lessonPlanExamDetails = [];
    	if(isNullOrEmpty(activeTab.examDetailsId)){
    		lessonPlanExamDetails.push({
				"id":null,
				"lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
				"events" : null
			});
    	}
    	else{
    		var examDetailId;
    		if(activeTab.examDetailsId == "-"){
    			examDetailId = null;
    		}
    		else{
    			examDetailId = activeTab.examDetailsId;
    		}
    		
    		var eventsArray = [];
    		
    		var selectedSubObjectives = [];
    		if(formValues && formValues.lessonPlanSubObjectiveField && !isNullOrEmpty(formValues.lessonPlanSubObjectiveField)){
    			if(typeof formValues.lessonPlanSubObjectiveField == "object" && formValues.lessonPlanSubObjectiveField.length){
        			selectedSubObjectives = formValues.lessonPlanSubObjectiveField;
    			}
    			else if(typeof formValues.lessonPlanSubObjectiveField == "number"){
        			selectedSubObjectives = [formValues.lessonPlanSubObjectiveField];
    			}
    		}
    		
    		var selectedPLO = [];
    		if(formValues && formValues.programLearningOutcome && !isNullOrEmpty(formValues.programLearningOutcome)){
    			if(typeof formValues.programLearningOutcome == "object" && formValues.programLearningOutcome.length){
    				selectedPLO = formValues.programLearningOutcome;
    			}
    			else if(typeof formValues.programLearningOutcome == "number"){
    				selectedPLO = [formValues.programLearningOutcome];
    			}
    		}
    		
    		var selectedDublin = [];
    		if(formValues && formValues.dublinDescriptor && !isNullOrEmpty(formValues.dublinDescriptor)){
    			if(typeof formValues.dublinDescriptor == "object" && formValues.dublinDescriptor.length){
    				selectedDublin = formValues.dublinDescriptor;
    			}
    			else if(typeof formValues.programLearningOutcome == "number"){
    				selectedDublin = [formValues.dublinDescriptor];
    			}
    		}
    		
    		Ext.each(activeTab.eventsAr, function(currentEv){
    			var outcomeArray = [];
    			var outcomeArraySplitted = (currentEv.outcome && typeof currentEv.outcome != "object") ? currentEv.outcome.split(",") : ((typeof currentEv.outcome == "object") ? currentEv.outcome : [] );
    			
    			if(outcomeArraySplitted.length && selectedSubObjectives){
    				outcomeArraySplitted = outcomeArraySplitted.filter(function(element) {
    				    return selectedSubObjectives.indexOf(Number(element)) !== -1;
    				});
    			}
    			else{
    				outcomeArraySplitted = [];
    			}
    			/*if(outcomeArraySplitted.length && selectedPLO){
    				outcomeArraySplitted = outcomeArraySplitted.filter(function(element) {
    				    return selectedPLO.indexOf(Number(element)) !== -1;
    				});
    			}
    			else{
    				outcomeArraySplitted = [];
    			}
    			
    			if(outcomeArraySplitted.length && selectedDublin){
    				outcomeArraySplitted = outcomeArraySplitted.filter(function(element) {
    				    return selectedDublin.indexOf(Number(element)) !== -1;
    				});
    			}
    			else{
    				outcomeArraySplitted = [];
    			}*/
    			
    			Ext.each(outcomeArraySplitted, function(currentOutcome){
    				outcomeArray.push({
    					outcome: {
        					id: currentOutcome
        				}
    				});
    			});
    			
    			var skillsArray = [];
    			var skillsArraySplitted = (currentEv.skills && typeof currentEv.skills != "object") ? currentEv.skills.split(",") : ((typeof currentEv.skills == "object") ? currentEv.skills : [] );
    			Ext.each(skillsArraySplitted, function(currentSkills){
    				skillsArray.push({
    					skill: {
        					id: currentSkills
        				}
    				});
    			});
    			
    			delete currentEv.outcome;
    			currentEv.outcomes = outcomeArray;
    			currentEv.skills = skillsArray;
    			eventsArray.push(currentEv);
    		});
    		
    		lessonPlanExamDetails.push({
				"id":examDetailId,
				"lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
				"events" : eventsArray
			});
    	}
    	
    	lessonPlan.set("lessonPlanExamDetails",lessonPlanExamDetails);
    	
    	//Resit Detail
    	
    	var lessonPlanResitDetails = [];
    	if(isNullOrEmpty(activeTab.resitId)){
    		lessonPlanResitDetails.push({
				"id":null,
				"lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
				"resitDetailEvents" : null
			});
    	}
    	else{
    		var resitId;
    		if(activeTab.resitId == "-"){
    			resitId = null;
    		}
    		else{
    			resitId = activeTab.resitId;
    		}
    		var resitEventsArray = [];
    		Ext.each(activeTab.resitAr, function(currentEv){
    			resitEventsArray.push(currentEv);
    		});
    		
    		lessonPlanResitDetails.push({
				"id":resitId,
				"lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
				"resitDetailEvents" : resitEventsArray
			});
    	}
    	
    	lessonPlan.set("lessonPlanResitDetails",lessonPlanResitDetails);


		var courseVariants = formValues.lessonPlanCourseVariantId;
		var lessonPlanCourseVariants =[];
		
		if(Ext.isDefined(courseVariants) && courseVariants.length > 0 && !isNullOrEmpty(courseVariants[0])){
			for(var i in courseVariants){
				var cvId = "";
				if(Ext.isObject(courseVariants[0])){
					cvId = courseVariants[i].get("id");
				} else {
					cvId = courseVariants[i];
				}
				lessonPlanCourseVariants.push({
					"id":null,
					"lessonPlan":$this.getIdValueJsonLP(formValues.lessonPlanId),
					"courseVariant" : $this.getIdValueJsonLP(cvId)
				});
			}
		}

		var objectivePnl = $this.getLessonplanningdetailsform().down('#lessonPlanMainPnlItemId');
		var	objectiveItems = objectivePnl.items;

		if(objectiveItems.length>0){
			var lessonPlanObjectives =[];
			for(var i=0; i<objectiveItems.length; i++)
			{
				var isObjDeleted = objectiveItems.items[i].down('[name=isObjDeleted]').value;
				var objective = objectiveItems.items[i].down('[name=lessonPlanObjectiveField]').getValue();
				if(isObjDeleted==0  && !isNullOrEmpty(objective)){
					var remark	= objectiveItems.items[i].down('[name=lessonPlanDescriptionField]').value;
					var hiddenObjId = objectiveItems.items[i].down('[name=lessonPlanHiddenObjId]').value;
					//var objective = objectiveItems.items[i].down('[name=lessonPlanObjectiveField]').getValue();
					var isSubObjective = objectiveItems.items[i].down('#lessonPlanIsSubObjectiveCheckFieldItemId').getValue();
					var isSubObjective = isSubObjective[Object.keys(isSubObjective)];
					var objSequence = i+1;
					if(!isNullOrEmpty(isSubObjective) && isSubObjective == true){
						var subObjectivesLessonPlan = [];
						var currentObjectivePanel = objectivePnl.down('#lessonPlanObjPnlItemId_'+i)
						var subObjectivePnl = currentObjectivePanel.down('#lessonPlanSubObjPnlItemId');

						for(var j=0; j<subObjectivePnl.items.length; j++)
						{
							var isDeleted = subObjectivePnl.items.items[j].down('hiddenfield[name=isDeleted]').getValue()
							if(isDeleted==0){
								var hiddenSubObjId = subObjectivePnl.items.items[j].down('hiddenfield[name=lessonPlanHiddenSubObjId]').getValue();
								var subObjectiveVal= subObjectivePnl.items.items[j].down('customcombobox[name=lessonPlanSubObjectiveField]').getValue();
								var subObjectiveDescVal= subObjectivePnl.items.items[j].down('textareafield[name=lessonPlanSubObjectiveDescField]').getValue();
								//var programLearningOutcomeVal= subObjectivePnl.items.items[j].down('customcombobox[name=programLearningOutcome]').getValue();
								if(Ext.isString(subObjectivePnl.items.items[j].down('customcombobox[name=programLearningOutcome]').getValue())){
									var programLearningOutcomeVal = subObjectivePnl.items.items[j].down('hiddenfield[name=programLearningOutcomeHidden]').getValue();
								}else{
									var programLearningOutcomeVal= subObjectivePnl.items.items[j].down('customcombobox[name=programLearningOutcome]').getValue();
								}
								if(Ext.isString(subObjectivePnl.items.items[j].down('customcombobox[name=dublinDescriptor]').getValue())){
									var dublinDescriptorVal = subObjectivePnl.items.items[j].down('hiddenfield[name=dublinDescriptorHidden]').getValue();
								}else{
									var dublinDescriptorVal=subObjectivePnl.items.items[j].down('customcombobox[name=dublinDescriptor]').getValue();
								}
								//var dublinDescriptorVal= subObjectivePnl.items.items[j].down('customcombobox[name=dublinDescriptor]').getValue();
								var subObjSequence = j+1;
								data ={
										"id":hiddenSubObjId,
										"sequence": subObjSequence,
										"remark": subObjectiveDescVal,
										"subObjective": {
											"id": subObjectiveVal,
											"value" : subObjectiveDescVal
										},
										"programLearningOutcome":{
											"id":programLearningOutcomeVal
										},
										"dublinDescriptors":{
											"id":dublinDescriptorVal
										},
								};
								subObjectivesLessonPlan.push(data);
							}
						}

						lessonPlanObjectives.push({
							"lessonPlan": {
								"id": formValues.lessonPlanId,
								"value": "null"
							},
							"remark": remark,
							"isSubObjectiveRequired": isSubObjective,
							"id": hiddenObjId,
							"sequence": objSequence,
							"objective": $this.getIdValueJsonLP(objective),
							"lessonPlanSubObjectives":subObjectivesLessonPlan
						});
					} else {
						lessonPlanObjectives.push({
							"lessonPlan": {
								"id": formValues.lessonPlanId,
								"value": "null"
							},
							"remark": remark,
							"isSubObjectiveRequired": isSubObjective,
							"id": hiddenObjId,
							"sequence": objSequence,
							"objective": $this.getIdValueJsonLP(objective)
						});
					}
				}
			}
		}
		
		lessonPlan.set("lessonPlanObjectives",lessonPlanObjectives);
		lessonPlan.set("lessonPlanCourseVariants",lessonPlanCourseVariants);
		lessonPlan.set("lessonPlanStaffs",lessonPlanStaffIds);
		
		if(this$.getContentpanel() && this$.getContentpanel().getActiveTab() && this$.getContentpanel().getActiveTab().down('lessonplanningdetailsform') && this$.getContentpanel().getActiveTab().down('lessonplanningdetailsform').isView && this$.getContentpanel().getActiveTab().down('lessonplanningdetailsform').examDatesEditable){
			lessonPlan.set("whethePublished", this$.getContentpanel().getActiveTab().down('lessonplanningdetailsform').whethePublished);
			lessonPlan.set("whetherValidated", this$.getContentpanel().getActiveTab().down('lessonplanningdetailsform').whetherValidated);
		}
		else{
			lessonPlan.set("whethePublished","Not Published");
			lessonPlan.set("whetherValidated","Not Validated");
		}
		
		var docStore = $this.getStore('lessonplan.LessonPlanDocumentStore');
		var docArray = [];
		if (docStore.data.items != null && docStore.data.items.length > 0) {
			Ext.each(docStore.data.items, function(val) {
				var type=null;
				if(isNullOrEmpty(val.data.id) && isNullOrEmpty(val.data.documentId)){
					if(isNullOrEmpty(val.data.type)){
						type="DOCUMENT";
					}else{
						type=val.data.type;
					}
					var newData = {
							"name" : val.data.documentName,
							"path" : val.data.path,
							"type" : type,
							"createdBy" : $this.getIdValueJsonLP(val.data.createdBy.id, val.data.createdBy.value),
							"submissionDate" : Ext.Date.format(new Date(), CONSTANTS.DATE_TIME_FORMAT)            			  
					};
					docArray.push(newData);
				}
			});
		}

		lessonPlan.documents = docArray;
		lessonPlan.document = docArray[docArray.length-1];
		lessonPlan.set("lessonPlanDocuments",docArray);
		var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
		
		try{
			if(this.getLessonplanninggrid() && this.getLessonplanninggrid().getSelectionModel() && this.getLessonplanninggrid().getSelectionModel().getSelection() && this.getLessonplanninggrid().getSelectionModel().getSelection().length){
				loggedInAcademyLocationId = this.getLessonplanninggrid().getSelectionModel().getSelection()[0].raw.academyLocationId
			}
		}
		catch(e){
			loggedInAcademyLocationId = this.getCurrentAcademyLocation();
		}
		
		lessonPlan.set("academyLocationId",loggedInAcademyLocationId);
		var formData = Ext.encode(lessonPlan.data);
		if (isNullOrEmpty(formValues.lessonPlanId)) {
			var URL = SERVERURL.LESSON_PLAN_SAVE;
		} else {
			var URL = SERVERURL.LESSON_PLAN_UPDATE;
		}
    	   
		Ext.Ajax.request({
			type : 'rest',
			url : URL,
			timeout: 9000000,
			method : 'POST',
			jsonData : formData,
			success : function(form, action) {
				var grid = $this.getLessonplanninggrid();
				if(form.responseText == 'SUCCESS'){
					$this.hideWindowMask();
					showSuccessMessage(getCommonTranslation('Lesson Planning'),getCommonTranslation('Lesson Plan added successfully'));
					if(!isNullOrEmpty(grid)){
						grid.getSelectionModel().deselectAll();
						grid.getStore().load();
					}
				}else if(form.responseText == "UPDATESECCUSS"){
					$this.hideWindowMask();
					showSuccessMessage(getCommonTranslation('Lesson Planning'),getCommonTranslation('Lesson Plan Updated successfully'));         
					if(!isNullOrEmpty(grid)){
						grid.getSelectionModel().deselectAll();
						grid.getStore().load();
					}
				}
				else{
					$this.hideWindowMask();
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
				}
			}
		});
		$this.closeLessonPlanDetailFormTab();
	},
	editLessonPlanRecord: function(isView){
 	   var this$ = this;
 	   var grid = this$.getLessonplanninggrid();
 	   
 	   if (grid.getSelectionModel().getCount() == 1)
 	   {
 		   var record = grid.getSelectionModel().getSelection()[0];
 		   if(record.data.isValidationRequired && record.data.whethePublished == 'Published' && portalId == 2 && !isView){
 			   showConfirmMessage(getProgramandcourseTranslation('LESSON_PLAN'), getCommonTranslation('LESSONPLAN_EDIT_CONFIRM_MESSAGE'), function(btn,text) {
 				   if (btn == 'yes') {
 					  this$.editSelectedLessonPlan(true, grid, record, true);
 				   }
 				   else{
 					   //-- do nothing
 				   }
 			   });
 		   }
 		   else if(record.data.isValidationRequired && record.data.whethePublished == 'Published' && !isView){
 			  showConfirmMessage(getProgramandcourseTranslation('LESSON_PLAN'), getCommonTranslation('LESSONPLAN_EDIT_CONFIRM_MESSAGE'), function(btn,text) {
 			     if (btn == 'yes') {
 					  this$.editSelectedLessonPlan(true, grid, record, true);
 				   }
 				   else{
 					   //-- do nothing
 				   }
 			   });
 		   }
 		    else if(record.data.isValidationRequired && record.data.whetherValidated == 'Validated' && !isView){
             showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CANNOT_EDIT_VALIDATED_LESSON_PLAN')); 
 		   }
 		   else{
 			  this$.editSelectedLessonPlan(isView, grid, record, !isView);
 		   }
 	   } else if(grid.getSelectionModel().getCount() > 1){
 		  showWarningMessage(getProgramandcourseTranslation('LESSON_PLAN'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD'));
 	   } else{
  		 showWarningMessage(getProgramandcourseTranslation('LESSON_PLAN'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
 	   }
    },
    editSelectedLessonPlan: function(isView, grid, record, examDatesEditable){
    	var this$ = this;
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	this$.openLessonPlanningEditWindow(isView, examDatesEditable, record);
    	var editFormPanel = this$.getLessonplanningdetailsform();
    	var editForm = editFormPanel.getForm();
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	if (!isNullOrEmpty(selectedRecord)) {
    		var course= editFormPanel.down('#lessonPlanCourseItemId');
    		var courseVariant= editFormPanel.down('#lessonPlanCourseVariantIdItemId');
    		var faculty= editFormPanel.down('#lessonPlanFacultyItemId');
    		var unitTitle=editFormPanel.down('#lessonPlanUnitTitleItemId');
    		var topic=editFormPanel.down('#lessonPlanTopicsItemId');
    		var term=editFormPanel.down('#lessonPlanTermItemId');
    		var duration=editFormPanel.down('#lessonPlanDurationItemId');
    		var aim=editFormPanel.down('#lessonPlanAimItemId');
    		var prerequisite=editFormPanel.down('#lessonPlanPrerequisiteItemId');
    		var objective=editFormPanel.down('[name=lessonPlanObjectiveField]');
    		var isSubObjective=editFormPanel.down('#lessonPlanIsSubObjectiveCheckFieldItemId');
    		var objDescription=editFormPanel.down('[name=lessonPlanDescriptionField]');
    		var superVisedPracticeHours=editFormPanel.down('#superVisedPracticeHours');
    		var generalEducationCategory=editFormPanel.down('#generalEducationCategoryItemId');
    		var referenceProgram=editFormPanel.down('#referenceProgramItemId');
    		var maxAbsences = editFormPanel.down("#maxAbsencesItemId");
			var adminAbsences = editFormPanel.down("#adminAbsencesItemId");
			var facultyOfficeHours = editFormPanel.down("#facultyOfficeHoursItemId");
    		course.setDisabled(false);
    		courseVariant.setDisabled(false);
    		faculty.setDisabled(false);
    		unitTitle.setDisabled(false);
    		topic.setDisabled(false);
    		term.setDisabled(false);
    		duration.setDisabled(false);
    		aim.setDisabled(false);
    		prerequisite.setDisabled(false);
    		superVisedPracticeHours.setDisabled(false);
    		duration.setDisabled(false);
    		generalEducationCategory.setDisabled(false);
    		referenceProgram.setDisabled(false);
    		maxAbsences.setDisabled(false);
			adminAbsences.setDisabled(false);
			facultyOfficeHours.setDisabled(false);
    		if (isView && !examDatesEditable) {
    			editFormPanel.down('#lessonPlanAddObjBtnItemId').setVisible(false);
    			editFormPanel.down('#lessonPlanSaveBtnItemId').setVisible(false);
    			editFormPanel.down('#lessonPlanUploadDocsBtnItemId').setVisible(false);

    			toggleReadOnlyFormItems(editForm, true);
    		}
    		else if (isView && examDatesEditable){
    			editFormPanel.down('#lessonPlanAddObjBtnItemId').setVisible(false);
    			editFormPanel.down('#lessonPlanSaveBtnItemId').setVisible(true);
    			editFormPanel.down('#lessonPlanUploadDocsBtnItemId').setVisible(false);

    			toggleReadOnlyFormItems(editForm, true);
    		}
    	}
    	Ext.Ajax.request({
    		type: 'rest',
    		url: SERVERURL.LESSON_PLAN_FINDBYID,
    		method: 'GET',
    		params:{
    			id:selectedRecord.get('id')
    		},
    		success: function(response, action) {
    			var data = response.responseText;
    			if(!isNullOrEmpty(data)) {
    				//-- decoding data from json to object
    				var jsonData=Ext.decode(data);

    				var contentpanel = this$.getContentPanel();
    				var activeTab = contentpanel.getActiveTab();

    				if(jsonData.lessonPlanExamDetails && jsonData.lessonPlanExamDetails.length){
    					activeTab.examDetailsId = jsonData.lessonPlanExamDetails[0].id;
    					var newEventsAr = [];
    					Ext.each(jsonData.lessonPlanExamDetails[0].events, function(curEv){
    						newEventsAr.push({
    							id: curEv.id,
    							eventId:curEv.eventId,
    							weitage: curEv.weitage,
    							date: curEv.date,
    							type: curEv.typeId,
    							week: curEv.week,
    							outcome: Ext.Array.pluck(Ext.Array.pluck(curEv.outcomes,'outcome'),'id'),
    							skills: Ext.Array.pluck(Ext.Array.pluck(curEv.skills,'skill'),'id'),
    							examDuration:curEv.examDurationId,
    							groupOrIndividual:curEv.groupOrIndividualId
    						});
    					});
    					activeTab.eventsAr = newEventsAr;
    				}

    				
    				// Resit Details
    				if(jsonData.lessonPlanResitDetails && jsonData.lessonPlanResitDetails.length){
    					activeTab.resitId = jsonData.lessonPlanResitDetails[0].id;
    					var newEventsAr = [];
    					Ext.each(jsonData.lessonPlanResitDetails[0].resitDetailEvents, function(curEv){
    						newEventsAr.push({
    							id: curEv.id,
    							eventId:curEv.eventId,
    							weitage: curEv.weitage,
    							resittype: curEv.typeId,
    							resitexamDuration:curEv.examDurationId,
    						});
    					});
    					activeTab.resitAr = newEventsAr;
    				}
    				
    				
    				//-- getting CourseVarientId
    				var cvid =[];
    				if(jsonData.lessonPlanCourseVariants.length > 0){
    					for (var k in jsonData.lessonPlanCourseVariants){
    						cvid.push(jsonData.lessonPlanCourseVariants[k].courseVariant.id);
    					}
    				}
    				//--

    				//-- form fields
    				var formFieldId = editForm.findField('lessonPlanId');
    				var formFieldIdAcademicTerm=editForm.findField('lessonPlanAcademicTerm');
    				var formFieldIdCourse=editForm.findField('lessonPlanCourse');
    				var formFieldCourseVariant=editForm.findField('lessonPlanCourseVariantId');
    				var formFieldUnitTitle = editForm.findField('lessonPlanUnitTitle');
    				var formFieldFaculty=editForm.findField('lessonPlanFaculty');
    				var formFieldTopics = editForm.findField('lessonPlanTopics');
    				var formFieldTerm = editForm.findField('lessonPlanTerm');
    				var formFieldSuperVisedPracticeHours = editForm.findField('superVisedPracticeHours');
    				var formFieldIsRestrictMultipleLPOfaCourse = editForm.findField('isRestrictMultipleLPOfaCourse');
    				var formFieldIsValidationRequired = editForm.findField('isValidationRequired');
    				var formFieldDuration=editForm.findField('lessonPlanDuration');
    				var formFieldAim = editForm.findField('lessonPlanAim');
    				var formFieldPrerequisite = editForm.findField('lessonPlanPrerequisite');
    				var formFieldDateOfPlanning = editForm.findField('lessonPlanDateOfPlanning');
    				var documentGrid = this$.getLessonplanningdocumentgrid();
    				var formFieldReferenceProgram=editForm.findField('referenceProgram');
    				var formFieldGeneralEducationCategory=editForm.findField('generalEducationCategory');
    				var formFieldMaxAbsences=editForm.findField('maxAbsences');
    				var formFieldAdminAbsences=editForm.findField('adminAbsences');
    				var formFieldFacultyOfficeHours=editForm.findField('facultyOfficeHours');
    				//-- form field stores
    				var academicTermStore = formFieldIdAcademicTerm.getStore();
    				var courseStore = formFieldIdCourse.getStore();
    				var facultyStore = formFieldFaculty.getStore();
    				var durationStore = formFieldDuration.getStore();
    				var formFieldReferenceProgramStore=formFieldReferenceProgram.getStore();
    				var formFieldGeneralEducationCategoryStore=formFieldGeneralEducationCategory.getStore();
    				var courseVariantStore = formFieldCourseVariant.getStore();
    				var documentStore=documentGrid.getStore();
    				var alinfomodel = Academia.model.authentication.ALInfoModel;
    				var whetherSchool = alinfomodel.get('wheatherSchool');
    				//-- setting values in form fields
    				formFieldId.setValue(selectedRecord.get('id'));
    				formFieldUnitTitle.setValue(jsonData.unitTitle);
    				formFieldTerm.setValue(jsonData.term);
    				formFieldSuperVisedPracticeHours.setValue(jsonData.superVisedPracticeHours);
    				formFieldIsRestrictMultipleLPOfaCourse.setValue(jsonData.isRestrictMultipleLPOfaCourse);
    				formFieldIsValidationRequired.setValue(jsonData.isValidationRequired);
    				formFieldTopics.setValue(jsonData.topics);
    				formFieldAim.setValue(jsonData.aim);
    				formFieldPrerequisite.setValue(jsonData.preRequisites);
    				formFieldDateOfPlanning.setRawValue(dateRender(jsonData.dateOfPlan));
    			//	formFieldReferenceProgram.setValue(jsonData.referenceProgram.id);
    				formFieldMaxAbsences.setValue(jsonData.maxAbsences);
    				formFieldAdminAbsences.setValue(jsonData.adminAbsences);
    				formFieldFacultyOfficeHours.setValue(jsonData.facultyOfficeHours);
    				academicTermStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							formFieldIdAcademicTerm.setValue(jsonData.academicTerm.id);
    						}
    					}
    				});
    				academyLocationIds = jsonData.academyLocationId;
    				if(isNullOrEmpty(academyLocationIds)){
    					academyLocationIds=this$.getCurrentAcademyLocation();
    				}
    				courseStore.getProxy().extraParams = {
    					academicTermId:jsonData.academicTerm.id,
    					academyLocationId:academyLocationIds,
    					facultyId :null,
 						lessonPlanId:selectedRecord.get('id')
    				};
    				courseStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							formFieldIdCourse.setValue(jsonData.course.id);
    							courseVariantStore.getProxy().extraParams = {
    								limit: -1,
    								courseId :jsonData.course.id,
    								isCurrentPeriod: true,
    								whetherSchool: whetherSchool,
    								academicTermId:jsonData.academicTerm.id,
    								academyLocationId:academyLocationIds
    							};
    							courseVariantStore.load({
    								/* params:{
			 							   'limit': -1,
			 							   "courseId" :jsonData.course.id
			 						   },*/
    								callback: function(records, operation, success) {
    									if (success) {
    										var cvs =[];
    										if(jsonData.lessonPlanCourseVariants.length > 0){
    											for (var k in jsonData.lessonPlanCourseVariants){
    												cvs.push(jsonData.lessonPlanCourseVariants[k].courseVariant.id);
    											}
    										}
    										formFieldCourseVariant.setValue(cvs);
    										facultyStore.getProxy().extraParams = {
    											/*'courseVariantIds': cvid.join(),
			 			 						   "courseId" :jsonData.course.id*/
    											id: this$.getCurrentAcademyLocation()
    										};
    										formFieldReferenceProgramStore.getProxy().extraParams = {
    											courseId:jsonData.course.id
    					    				};
    										facultyStore.load({
    											callback: function(record, operation, success) {
    												if (success) {
    													var stf =[];
    													if(jsonData.lessonPlanStaffs.length > 0){
    														for (var k in jsonData.lessonPlanStaffs){
    															stf.push(jsonData.lessonPlanStaffs[k].staff.id);
    														}
    													}
    													formFieldFaculty.setValue(stf);
    												}
    											}
    										});
    									}
    								}
    							});
    						}
    					}
    				});

    				durationStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							formFieldDuration.setValue(jsonData.lessonPlanDuration.id);
    						}
    					}
    				});
    				formFieldReferenceProgramStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							if(jsonData.referenceProgram!=undefined){
    							formFieldReferenceProgram.setValue(jsonData.referenceProgram.id);
    							}
    						}
    					}
    				});
    				formFieldGeneralEducationCategoryStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							if(jsonData.generalEducationCategory!=undefined){
    							formFieldGeneralEducationCategory.setValue(jsonData.generalEducationCategory.id);
    							}
    						}
    					}
    				});
    				documentStore.getProxy().extraParams = {
    					ID: selectedRecord.get('id')
    				};
    				documentStore.load();
    				documentGrid.setVisible(true);

    				//-- remove all pre-objectives from main objective panel
    				var objectivePnl = editFormPanel.down('#lessonPlanMainPnlItemId');
    				objectivePnl.removeAll();

    				//-- loading data for objective combo store
    				var objectiveStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
    				objectiveStore.removeAll();
    				objectiveStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    							var currentRecordInc = 0;
    							this$.addPreFilledObjectiveField(jsonData.lessonPlanObjectives, currentRecordInc, jsonData, isView); // adding through recursion
    						}
    						else{
    							Ext.getBody().unmask();
    						}
    					}
    				});
    			}
    			else{
    				Ext.getBody().unmask();
    			}
    		}
    	});
    },
    openLessonPlanningEditWindow: function(isView, examDatesEditable, record){
 	   var contentPanel = this.getContentPanel();
 	   var structure = Ext.widget('lessonplanningdetailsform',{
 		  isView: isView,
 		  examDatesEditable: examDatesEditable,
 		  whethePublished: record.data.whethePublished,
 		  whetherValidated: record.data.whetherValidated,
 	   });
 	   var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
 	   var getcontroller=this.getController('menu.CoreERPNavigationController');
 	   var getTab=getcontroller.getTab(tabName);
 	   if(getTab!=null){
 		   contentPanel.remove(getTab, true);
 	   }
 	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
    },
	//-- END -- functions
	
    disableAddExamAndResitButtonPivileges: function(formReference,permissionsMap) {

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	formReference.down('#lessonPlanAddExamDetailBtnItemId').setVisible(false);
    	formReference.down('#lessonPlanResitDetailBtnItemId').setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'ADDEXAMDETAILBUTTON') {
    			formReference.down('#lessonPlanAddExamDetailBtnItemId').setVisible(true);
    		}
    		if (privilege === 'RESITDETAILBUTTON') {
    			formReference.down('#lessonPlanResitDetailBtnItemId').setVisible(true);
    		}
    	});
    },
    
    disableResitButtonPivileges: function(formReference,permissionsMap) {

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	formReference.down('#lessonPlanResitDetailBtnItemId').setVisible(false);
    	Ext.each(permissionList, function(privilege) {	
    		if (privilege === 'RESITDETAILBUTTON') {
    			formReference.down('#lessonPlanResitDetailBtnItemId').setVisible(true);
    		}
    	});
    },
    
    /*disableIsValidationAndRestricTLPCheckBox: function(formReference,permissionsMap) {

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	formReference.down('#isRestrictMultipleLPOfaCourseId').setVisible(false);
    	formReference.down('#isValidationRequiredId').setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if(privilege === 'RESTRICT_MULTIPLE_LP') {
    			formReference.down('#isRestrictMultipleLPOfaCourseId').setVisible(true);
    			
    		}if(privilege === 'IS_VALIDATION_REQUIRED') {
    		formReference.down('#isValidationRequiredId').setVisible(true);
    		}
    	});
    },*/
    
    openResitDetailsWin: function(btn){
    	var me = this;
    	var lessonplanningresitwin = this.getLessonplanningresitwin();
    	if(isNullOrEmpty(lessonplanningresitwin)){
    		lessonplanningresitwin = Ext.widget('lessonplanningresitwin');
    	}
    	
    	var contentpanel = this.getContentPanel();
    	var activeTab = contentpanel.getActiveTab();
    	
    	lessonplanningresitwin.resitId = isNullOrEmpty(activeTab.resitId) ? null : activeTab.resitId;
    	lessonplanningresitwin.resitAr = isNullOrEmpty(activeTab.resitAr) ? null : activeTab.resitAr;
    	
    	if(lessonplanningresitwin.resitAr && lessonplanningresitwin.resitAr.length){
    		var newResitArray = lessonplanningresitwin.resitAr;
    		lessonplanningresitwin.resitAr = newResitArray.sort(function(aa,bb){
			      var x = aa.eventId.toLowerCase();
			      var y = bb.eventId.toLowerCase();
	
			      if(x>y){return 1;} 
			      if(x<y){return -1;}
			      return 0;
			 });
    	}
    	
    	if(activeTab.down('lessonplanningdetailsform')){
    		lessonplanningresitwin.isView = isNullOrEmpty(activeTab.down('lessonplanningdetailsform').isView) ? false : activeTab.down('lessonplanningdetailsform').isView;
    	}
    	else{
    		lessonplanningresitwin.isView = false;
    	}
    	lessonplanningresitwin.show(); 
    },
    
    openAddExamDetailsWin: function(btn){
    	var me = this;
    	var lessonplanningaddexamwin = this.getLessonplanningaddexamwin();
    	if(isNullOrEmpty(lessonplanningaddexamwin)){
    		lessonplanningaddexamwin = Ext.widget('lessonplanningaddexamwin');
    	}
    	
    	var contentpanel = this.getContentPanel();
    	var activeTab = contentpanel.getActiveTab();
    	
    	lessonplanningaddexamwin.examDetailsId = isNullOrEmpty(activeTab.examDetailsId) ? null : activeTab.examDetailsId;
    	lessonplanningaddexamwin.eventsAr = isNullOrEmpty(activeTab.eventsAr) ? null : activeTab.eventsAr;
    	
    	if(lessonplanningaddexamwin.eventsAr && lessonplanningaddexamwin.eventsAr.length){
    		var newEvArray = lessonplanningaddexamwin.eventsAr;
    		lessonplanningaddexamwin.eventsAr = newEvArray.sort(function(aa,bb){
			      var x = aa.eventId.toLowerCase();
			      var y = bb.eventId.toLowerCase();
	
			      if(x>y){return 1;} 
			      if(x<y){return -1;}
			      return 0;
			 });
    	}
    	
    	if(activeTab.down('lessonplanningdetailsform')){
    		lessonplanningaddexamwin.isView = isNullOrEmpty(activeTab.down('lessonplanningdetailsform').isView) ? false : activeTab.down('lessonplanningdetailsform').isView;
    		lessonplanningaddexamwin.examDatesEditable = isNullOrEmpty(activeTab.down('lessonplanningdetailsform').examDatesEditable) ? true : activeTab.down('lessonplanningdetailsform').examDatesEditable;
    	}
    	else{
    		lessonplanningaddexamwin.isView = false;
    	}
    	lessonplanningaddexamwin.show(); 
    },
    
    addItemInResitEventsPnl: function(win, itemNumber, resitData, isEmptyItem){
    	var me = this;
    	var mainEventPnl = win.down('#eventsMainPanel');
    	var eventPnl = {
    			xtype: 'panel',
    			layout: { type: 'hbox' },
    			width : '100%',
    			style:{ padding: 0 },
    			bodyStyle:{ padding: 0 },
    			itemIdentifier: 'eventPnlItem',
    			itemNumber: itemNumber,
    			autoDestroy: true,
    			resitData:resitData,
				height: 'auto',
    			items:[{
    				xtype: 'panel',
    				layout: { type: 'vbox' },
    				defaults:{ width: 226, labelAlign: 'top' },
    				style:{ margin: 0 },
    				bodyStyle:{ margin: 0 },
    				width: 560,
    				title: getCommonTranslation("RESIT_DETAIL")+' '+itemNumber,
    				collapsible : true,
    				collapsed: (isEmptyItem) ? true : false,
    				height: 'auto',
    				items:[{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					items: [	
    						{
    							xtype: 'hiddenfield',
    							name: 'eventId',
    							itemId:'eventId'
    						},
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getCommonTranslation('TYPE'),
    							name:'lessonPlanRDType',
    							itemId: 'lessonPlanRDTypeItemId',
    							store:'lessonplan.LessonPlanExamDetailTypeStore',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,
    							forceSelection:true,
    							allowBlank: true,
    							readOnly: (win.isView == true) ? true : false,
								listeners:{
									change: function(cmb){
										var pnl = cmb.up('panel');
										var examDurationField = pnl.down('#lessonPlanRDexamDuration');
										
										if(!isNullOrEmpty(cmb.displayTplData[0]))
										{
											if(cmb.displayTplData[0].code.toLowerCase() == "test" || cmb.displayTplData[0].code.toLowerCase() == "exam"){
												examDurationField.setDisabled(false);
											}
											else{
												examDurationField.setDisabled(true);
												examDurationField.reset();
											}
											var isValidForm = win.down('form').isValid();
											if (isValidForm) {
												win.down('#btnResitDetailsSubmit').setDisabled(false);
											}
											else {
												win.down('#btnResitDetailsSubmit').setDisabled(true);
											}
											win.down('form').getForm().clearInvalid();
										}
									}
								},
    									
    						},
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getCommonTranslation('EXAM_DURATION'),
    							name:'lessonPlanRDexamDuration',
    							itemId: 'lessonPlanRDexamDuration',
    							store:'lessonplan.LessonPlanExamDurationStore',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,					
    							forceSelection:true,
    							allowBlank: true,
    							disabled:true,
    							listConfig: {
    								listeners: {
    									beforeshow: function(picker) {
    										picker.minWidth = picker.up('combobox').getSize().width;
    									}
    								},
    								loadingText: getCommonTranslation('SEARCHING'),
    								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    								getInnerTpl: function() {
    									return '<div class="search-item">' +
    									'{value}' +
    									'</div>';
    								}
    							},
    							readOnly: (win.isView == true) ? true : false
    						}
    					]
    				},{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					items: [	    		
    						{
    							xtype: 'numberfield',
    							name: 'lessonPlanRDWeightage',
    							fieldLabel:getCommonTranslation('RESIT_WEIGHTING_PERCENTAGE'),
    							itemId:'lessonPlanRDWeightageItemId',	
    							minValue: 0,
    							maxValue: 100,
    							value:100,
    							allowBlank: true,
    							readOnly: (win.isView == true) ? true : false
    						}
    					]
    				}	
    			]
    			},{
    				xtype: 'panel',
    				layout: {
    					type: 'hbox'
    				},
    				defaults:{
    					width: 226,
    					labelAlign: 'top'
    				},
    				style:{
    					margin: 0
    				},
    				bodyStyle:{
    					margin: 0,
    					height:42
    				},
    				bodyCls: 'lpAddExamDetailsBtnsPnlCls',
    				width: 90,
    				height:42,
    				items:[{
    					xtype: 'button',
    					itemId: 'lessonPlanResitDetailsResetBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnSettings',
    					icon: 'resources/images/icon-refresh.svg',
    					iconCls:'examDetailRefreshBtnIcon',
    					tooltip: getCommonTranslation('RESET'),
    					height: 24,
    					hidden: win.isView
    				},{
    					xtype: 'button',
    					glyph: ICONGLYPH.DELETEGLYPH,
    					itemId: 'lessonPlanResitDetailsDeleteBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnReject',
    					height: 24,
    					tooltip: getCommonTranslation('DELETETOOLTIP'),
    					hidden: win.isView
    				},{
    					xtype : 'button',
    					itemId: 'lessonPlanResitDetailsAddBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnSettings',
    					text: getCommonTranslation('ADDBUTTONTEXT'),
    					tooltip: getCommonTranslation('ADD'),
    					hidden: win.isView
    				}]
    			}],
    			listeners:{
    				beforerender: function(pnl){
    					var items = pnl.query('[allowBlank=false]');
    					for (i = 0, len = items.length; i < len; i++) {
    			            var item = items[i];
    			            item.afterLabelTextTpl = (item.afterLabelTextTpl || "") + ' <span class="required" style="color:red"> *</span>';
    			        }
    				},
    				afterrender: function(pnl){
    					if(!isNullOrEmpty(pnl.resitData)){
    						pnl.down('#eventId').setValue(pnl.resitData.id);
    						pnl.down('#lessonPlanRDWeightageItemId').setValue(pnl.resitData.weitage);
    						
    						
    						pnl.down('#lessonPlanRDTypeItemId').store.load({
    							callback: function(){
    								pnl.down('#lessonPlanRDTypeItemId').setValue(pnl.resitData.resittype);
    							}
    						});
    						
   
    						pnl.down('#lessonPlanRDexamDuration').store.load({
    							callback: function(){
    								pnl.down('#lessonPlanRDexamDuration').setValue(pnl.resitData.resitexamDuration);
    							}
    						});
    						
    					}
    				}
    			}
    	};
    	Ext.suspendLayouts();
    	mainEventPnl.insert(mainEventPnl.items.length, eventPnl);
    	Ext.resumeLayouts();
    	mainEventPnl.doLayout();
    	
    	if(!isNullOrEmpty(resitData)){
    		me.renderAllResitEvents(win,itemNumber);
    	}
    },
    
    renderAllResitEvents: function(win, indx){
    	var me = this;
    	if(win.resitAr && win.resitAr.length != indx){
    		me.addItemInResitEventsPnl(win, indx+1, win.resitAr[indx]);
    	}
    	else if(win.resitAr && !win.resitAr.length){
    		me.addItemInResitEventsPnl(win, indx+1, null, true)
    	}
    },
    
    hideShowResitWinBtns: function(win){
    	var me = this;
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var allEventItems = mainEventPnl.query('[itemIdentifier=eventPnlItem]');
    	
    	Ext.each(allEventItems, function(currentEventItem, idx){
    		var currentDltBtn = currentEventItem.down('#lessonPlanResitDetailsDeleteBtnItemId');
    		var currentAddBtn = currentEventItem.down('#lessonPlanResitDetailsAddBtnItemId');
    		var currentResetBtn = currentEventItem.down('#lessonPlanResitDetailsResetBtnItemId');
    		
    		if(idx == 0){
        		currentDltBtn.hide();
        		currentResetBtn.show();
    		}
    		else{
        		currentDltBtn.show();
        		currentResetBtn.hide();
    		}
    		
    		if(allEventItems.length-1 == idx){
        		currentAddBtn.show();
    		}
    		else{
        		currentAddBtn.hide();
    		}
    		
    		if(win.isView){ //In Case of View V2D-368362
    			currentDltBtn.hide();
    			currentAddBtn.hide();
    			currentResetBtn.hide();
    		}
    	});
    	
    	me.applyDFROnFormFields(win.down('form'), 'lessonplanningresitwin');
    	var isValidForm = win.down('form').isValid();
    	if(isValidForm){
    		win.down('#btnResitDetailsSubmit').setDisabled(false);
    	}
    	else{
    		win.down('#btnResitDetailsSubmit').setDisabled(true);
    	}
    	win.down('form').getForm().clearInvalid();
    },
    
    renderAllEvents: function(win, indx){
    	var me = this;
    	if(win.eventsAr && win.eventsAr.length != indx){
    		me.addItemInEventsPnl(win, indx+1, win.eventsAr[indx]);
    	}
    	else if(win.eventsAr && !win.eventsAr.length){
    		me.addItemInEventsPnl(win, indx+1, null, true)
    	}
    },
    
    addItemInEventsPnl: function(win, itemNumber, evData, isEmptyItem){
    	var me = this;
    	var mainEventPnl = win.down('#eventsMainPanel');
    	var eventPnl = {
    			xtype: 'panel',
    			layout: { type: 'hbox' },
    			width : '100%',
    			style:{ padding: 0 },
    			bodyStyle:{ padding: 0 },
    			itemIdentifier: 'eventPnlItem',
    			itemNumber: itemNumber,
    			autoDestroy: true,
    			evData:evData,
				height: 'auto',
    			items:[{
    				xtype: 'panel',
    				layout: { type: 'vbox' },
    				defaults:{ width: 226, labelAlign: 'top' },
    				style:{ margin: 0 },
    				bodyStyle:{ margin: 0 },
    				width: 560,
    				title: getCommonTranslation("EVENT")+' '+itemNumber,
    				collapsible : true,
    				collapsed: (isEmptyItem) ? true : false,
    				height: 'auto',
    				items:[{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					items: [	
    						{
    							xtype: 'hiddenfield',
    							name: 'eventId',
    							itemId:'eventId'
    						},
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getCommonTranslation('TYPE'),
    							name:'lessonPlanEDType',
    							itemId: 'lessonPlanEDTypeItemId',
    							store:'lessonplan.LessonPlanExamDetailTypeStore',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,
    							forceSelection:true,
    							allowBlank: true,
    							readOnly: (win.isView == true) ? true : false,
    							listeners:{
    								change: function(cmb){
    									var pnl = cmb.up('panel');
    									var examDurationField = pnl.down('#examDuration');
    									examDurationField.reset();
    									if(!isNullOrEmpty(cmb.displayTplData[0]))
    									{
    										if(cmb.displayTplData[0].code.toLowerCase() == "test" || cmb.displayTplData[0].code.toLowerCase() == "exam"){
    											examDurationField.setDisabled(false);
    										}
    										else{
    											examDurationField.setDisabled(true);
    										}
    										var isValidForm = win.down('form').isValid();
    										if (isValidForm) {
    											win.down('#btnAddExamDetailsSubmit').setDisabled(false);
    										}
    										else {
    											win.down('#btnAddExamDetailsSubmit').setDisabled(true);
    										}
    										win.down('form').getForm().clearInvalid();
    									}
    								}
								}
    						},
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getProgramandcourseTranslation('WHETHER_GROUP_OR_INDIVIDUAL'),
    							name:'whetherGrouporindividual',
    							itemId: 'whetherGrouporindividual',
    							store:'lessonplan.LessonPlanWhetherGrouporIndividual',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,					
    							forceSelection:true,
    							allowBlank: true,
    							listConfig: {
    								listeners: {
    									beforeshow: function(picker) {
    										picker.minWidth = picker.up('combobox').getSize().width;
    									}
    								},
    								loadingText: getCommonTranslation('SEARCHING'),
    								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    								getInnerTpl: function() {
    									return '<div class="search-item">' +
    									'{value}' +
    									'</div>';
    								}
    							},
    							readOnly: (win.isView == true) ? true : false
    						}
    						]
    				},{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					items: [
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getCommonTranslation('EXAM_DURATION'),
    							name:'examDuration',
    							itemId: 'examDuration',
    							store:'lessonplan.LessonPlanExamDurationStore',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,					
    							forceSelection:true,
    							allowBlank: true,
    							disabled : true,
    							listConfig: {
    								listeners: {
    									beforeshow: function(picker) {
    										picker.minWidth = picker.up('combobox').getSize().width;
    									}
    								},
    								loadingText: getCommonTranslation('SEARCHING'),
    								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    								getInnerTpl: function() {
    									return '<div class="search-item">' +
    									'{value}' +
    									'</div>';
    								}
    							},
    							readOnly: (win.isView == true) ? true : false
    						},
    						{
    							xtype: 'textfield',
    							name: 'lessonPlanEDWeightage',
    							fieldLabel:getCommonTranslation('WEIGHTAGE'),
    							itemId:'lessonPlanEDWeightageItemId',	
    							maxLength: 255,
    							allowBlank: true,
    							readOnly: (win.isView == true) ? true : false
    						},
    						
    						]
    				},{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					height: 'auto',
    					items: [
    						{
    							xtype: 'textfield',
    							anchor: '100%',
    							fieldLabel: getCommonTranslation('DATE'),
    							name: 'lessonPlanEDDate',
    							itemId:'lessonPlanEDDateItemId',
    							allowBlank: true,
    							maxLength: 45,
    							listeners: {
    								
    							},
    							readOnly: (win.isView == true && win.examDatesEditable == true) ? false : (win.isView == true && win.examDatesEditable == false ? true : false)
    						},
    						{
    							xtype: 'textfield',
    							name: 'lessonPlanEDWeek',
    							fieldLabel:getCommonTranslation('WEEK'),
    							itemId:'lessonPlanEDWeekItemId',	
    							maxLength: 255,
    							allowBlank: true,
    							readOnly: (win.isView == true) ? true : false
    						},
    						
    						
    						
    						/*{
    							xtype: 'textfield',
    							name: 'lessonPlanEDAssessmentLearningOutcome',
    							fieldLabel:getCommonTranslation('ASSESSMENT_LEARNING_OUTCOME'),
    							itemId:'lessonPlanEDAssessmentLearningOutcomeItemId',	
    							maxLength: 255,
    							allowBlank: true
    						},
    						{
    							xtype: 'customcombobox',
    							fieldLabel: getCommonTranslation('ASSESSMENT_TRANSFERED_SKILLS'),
    							name:'lessonPlanEDAssessmentTransferedSkills',
    							itemId: 'lessonPlanEDAssessmentTransferedSkillsItemId',
    							store:'lessonplan.LessonPlanAssessmentTransferredSkillStore',
    							displayField: 'value',
    							valueField: 'id',
    							typeAhead:false,	
    							editable: false,					
    							forceSelection:true,
    							allowBlank: true
    						}*/
    						]
    				},
    				{
    					xtype: 'fieldcontainer',
    					width:'100%',
    					layout: { type: 'hbox' },
    					defaults :{ width: 226, labelAlign:'top' },
    					items: [
    						{
    							xtype: 'multiselectcombofield',
    							fieldLabel: getCommonTranslation('ASSESSMENT_LEARNING_OUTCOME'),
    							name:'lessonPlanEDAssessmentLearningOutcome',
    							itemId:'lessonPlanEDAssessmentLearningOutcomeItemId',
    							store:Ext.create('Ext.data.Store', {
    							    fields: ['id', 'value'],
    							    data: [] // Initial empty data
    							}),//'attendance.LessonPlanLearningOutcomeStore',
    							displayField : 'value',
    							valueField : 'id',
    							allowBlank: true,
    							forceSelection:true,
    							width :226,
    							matchFieldWidth:true,
    							queryMode: 'local',
    							//_isStoreLoadCalled: true,
    							height:28,
    				  			listConfig: {
    								listeners: {
    									beforeshow: function(picker) {
    										picker.minWidth = picker.up('combobox').getSize().width;
    									}
    								},
    								loadingText: getCommonTranslation('SEARCHING'),
    								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    								getInnerTpl: function() {
    									return '<div class="search-item">' +
    									'{value}' +
    									'</div>';
    								}
    							},
    							readOnly: (win.isView == true) ? true : false,
								listeners: {
								    afterrender: function(combo) {
								        // Manually load data into the store
								        var storeData = [];
								        var subObjFields = Ext.ComponentQuery.query('[name=lessonPlanSubObjectiveField]');
								        Ext.each(subObjFields, function(currentField){
								        	var curId = currentField.getValue();
								        	var curVal = currentField.getDisplayValue();
								        	if(!isNullOrEmpty(curId) && !isNullOrEmpty(curVal) && curId != "null" && curVal != "null"){
									        	storeData.push({
									        		id: curId,
									        		value: curVal
									        	});
								        	}
								        });
								        setTimeout(function(){
								        	combo.getStore().removeAll();
									        combo.getStore().loadData(storeData);
									        combo.getStore().loadRawData(storeData, true);
								        },300);
								    },
						            expand: function(combo) {
						                // Ensure the picker is shown even if the store is already loaded
						                combo.ignoreSelection = 0;
						            }
								}
    						},
    						{
    							xtype: 'multiselectcombofield',
    							fieldLabel: getCommonTranslation('ASSESSMENT_TRANSFERED_SKILLS'),
    							name:'lessonPlanEDAssessmentTransferedSkills',
    							itemId:'lessonPlanEDAssessmentTransferedSkillsItemId',
    							store:'lessonplan.LessonPlanAssessmentTransferredSkillStore',
    							displayField : 'value',
    							valueField : 'id',
    							allowBlank: true,
    							forceSelection:true,
    							width :226,
    							matchFieldWidth:true,
    							_isStoreLoadCalled: true,
    							height:28,
    							listConfig: {
    								listeners: {
    									beforeshow: function(picker) {
    										picker.minWidth = picker.up('combobox').getSize().width;
    									}
    								},
    								loadingText: getCommonTranslation('SEARCHING'),
    								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    								getInnerTpl: function() {
    									return '<div class="search-item">' +
    									'{value}' +
    									'</div>';
    								}
    							},
    							readOnly: (win.isView == true) ? true : false
    						}
    						]
    				}	
]
    			},{
    				xtype: 'panel',
    				layout: {
    					type: 'hbox'
    				},
    				defaults:{
    					width: 226,
    					labelAlign: 'top'
    				},
    				style:{
    					margin: 0
    				},
    				bodyStyle:{
    					margin: 0,
    					height:42
    				},
    				bodyCls: 'lpAddExamDetailsBtnsPnlCls',
    				width: 90,
    				height:42,
    				items:[{
    					xtype: 'button',
    					itemId: 'lessonPlanAddExamDetailsResetBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnSettings',
    					icon: 'resources/images/icon-refresh.svg',
    					iconCls:'examDetailRefreshBtnIcon',
    					tooltip: getCommonTranslation('RESET'),
    					height: 24,
    					hidden: win.isView
    				},{
    					xtype: 'button',
    					glyph: ICONGLYPH.DELETEGLYPH,
    					itemId: 'lessonPlanAddExamDetailsDeleteBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnReject',
    					height: 24,
    					tooltip: getCommonTranslation('DELETETOOLTIP'),
    					hidden: win.isView
    				},{
    					xtype : 'button',
    					itemId: 'lessonPlanAddExamDetailsAddBtnItemId',
    					width: 'auto',
    					cls: 'CustomBodyBtnSettings',
    					text: getCommonTranslation('ADDBUTTONTEXT'),
    					tooltip: getCommonTranslation('ADD'),
    					hidden: win.isView
    				}]
    			}],
    			listeners:{
    				beforerender: function(pnl){
    					var items = pnl.query('[allowBlank=false]');
    					for (i = 0, len = items.length; i < len; i++) {
    			            var item = items[i];
    			            item.afterLabelTextTpl = (item.afterLabelTextTpl || "") + ' <span class="required" style="color:red"> *</span>';
    			        }
    				},
    				afterrender: function(pnl){
    					if(!isNullOrEmpty(pnl.evData)){
    						pnl.down('#eventId').setValue(pnl.evData.id);
    						pnl.down('#lessonPlanEDWeightageItemId').setValue(pnl.evData.weitage);
    						
    						pnl.down('#lessonPlanEDDateItemId').setValue(!isNullOrEmpty(pnl.evData.date) ? pnl.evData.date : '' );
    						
    						pnl.down('#lessonPlanEDTypeItemId').store.load({
    							callback: function(){
    								pnl.down('#lessonPlanEDTypeItemId').setValue(pnl.evData.type);
    							}
    						});
    						pnl.down('#lessonPlanEDWeekItemId').setValue(pnl.evData.week);
    						
    						if(!isNullOrEmpty(pnl.evData.outcome)){
    							setTimeout(function(){
        							var outcomeArray = [];
    								if(typeof pnl.evData.outcome != "object"){
        								Ext.each(pnl.evData.outcome.split(','), function(currentOutcomeId){
        									outcomeArray.push(parseInt(currentOutcomeId));
        								});
    								}
    								else{
    									outcomeArray = pnl.evData.outcome;
    								}
    								
    								var store = pnl.down('#lessonPlanEDAssessmentLearningOutcomeItemId').getStore();
    						        var filteredOutcomeArray = outcomeArray.filter(function(value) {
    						            return store.findExact('id', value) !== -1;
    						        });

    						        pnl.down('#lessonPlanEDAssessmentLearningOutcomeItemId').setValue(filteredOutcomeArray);
    							},600);
    						}
    						
    						if(!isNullOrEmpty(pnl.evData.skills)){
        						pnl.down('#lessonPlanEDAssessmentTransferedSkillsItemId').getStore().load({
        							callback: function(){
        								var skillsArray = [];
        								if(typeof pnl.evData.skills != "object"){
            								Ext.each(pnl.evData.skills.split(','), function(currentSkillId){
            									skillsArray.push(parseInt(currentSkillId));
            								});
        								}
        								else{
        									skillsArray = pnl.evData.skills;
        								}
        								pnl.down('#lessonPlanEDAssessmentTransferedSkillsItemId').setValue(skillsArray);
        							}
        						});
    						}
    						pnl.down('#examDuration').store.load({
    							callback: function(){
    								pnl.down('#examDuration').setValue(pnl.evData.examDuration);
    							}
    						});
    						pnl.down('#whetherGrouporindividual').store.load({
    							callback: function(){
    								pnl.down('#whetherGrouporindividual').setValue(pnl.evData.groupOrIndividual)
    							}
    						});
    						
    					}
    				}
    			}
    	};
    	Ext.suspendLayouts();
    	mainEventPnl.insert(mainEventPnl.items.length, eventPnl);
    	Ext.resumeLayouts();
    	mainEventPnl.doLayout();
    	
    	if(!isNullOrEmpty(evData)){
    		me.renderAllEvents(win,itemNumber);
    	}
    },
    
    hideShowAddExamWinBtns: function(win){
    	var me = this;
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var allEventItems = mainEventPnl.query('[itemIdentifier=eventPnlItem]');
    	
    	Ext.each(allEventItems, function(currentEventItem, idx){
    		var currentDltBtn = currentEventItem.down('#lessonPlanAddExamDetailsDeleteBtnItemId');
    		var currentAddBtn = currentEventItem.down('#lessonPlanAddExamDetailsAddBtnItemId');
    		var currentResetBtn = currentEventItem.down('#lessonPlanAddExamDetailsResetBtnItemId');
    		
    		if(idx == 0){
        		currentDltBtn.hide();
        		currentResetBtn.show();
    		}
    		else{
        		currentDltBtn.show();
        		currentResetBtn.hide();
    		}
    		
    		if(allEventItems.length-1 == idx){
        		currentAddBtn.show();
    		}
    		else{
        		currentAddBtn.hide();
    		}
    		
    		if(win.isView){ //In Case of View V2D-368362
    			currentDltBtn.hide();
    			currentAddBtn.hide();
    			currentResetBtn.hide();
    		}
    	});
    	
    	me.applyDFROnFormFields(win.down('form'), 'lessonplanningaddexamwin');
    	var isValidForm = win.down('form').isValid();
    	if(isValidForm){
    		win.down('#btnAddExamDetailsSubmit').setDisabled(false);
    	}
    	else{
    		win.down('#btnAddExamDetailsSubmit').setDisabled(true);
    	}
    	win.down('form').getForm().clearInvalid();
    },
    
    addButtonLessonPlanAddExamDetailsAction: function(btn){
    	var me = this;

    	var win = btn.up('window');

    	var mainEventPnl = win.down('#eventsMainPanel');

    	var allEventItems = mainEventPnl.items.items;

    	var totalEventItems = allEventItems.length;

    	var lastEventItem = allEventItems[totalEventItems-1];

    	var newItemNumber = lastEventItem.itemNumber + 1;

    	me.addItemInEventsPnl(win, newItemNumber);

    	setTimeout(function(){
    		me.hideShowAddExamWinBtns(win);
    	},300);
    },
    
    addButtonLessonPlanResitDetailsAction: function(btn){
    	var me = this;

    	var win = btn.up('window');

    	var mainEventPnl = win.down('#eventsMainPanel');

    	var allEventItems = mainEventPnl.items.items;

    	var totalEventItems = allEventItems.length;

    	var lastEventItem = allEventItems[totalEventItems-1];

    	var newItemNumber = lastEventItem.itemNumber + 1;

    	me.addItemInResitEventsPnl(win, newItemNumber);

    	setTimeout(function(){
    		me.hideShowResitWinBtns(win);
    	},300);
    },
    
    deleteButtonLessonPlanAddExamDetailsAction: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var currentEventPnlItem = btn.up('[itemIdentifier=eventPnlItem]');
    	
    	currentEventPnlItem.destroy();
    	
    	setTimeout(function(){
    		me.hideShowAddExamWinBtns(win);
    	},300);
    },
    
    deleteButtonLessonPlanResitDetailsAction: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var currentEventPnlItem = btn.up('[itemIdentifier=eventPnlItem]');
    	
    	currentEventPnlItem.destroy();
    	
    	setTimeout(function(){
    		me.hideShowResitWinBtns(win);
    	},300);
    },
    
    resetButtonLessonPlanAddExamDetailsAction: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var currentEventPnlItem = btn.up('[itemIdentifier=eventPnlItem]');
    	
    	var allFields = currentEventPnlItem.query('[isFormField=true]');
    	
    	Ext.each(allFields, function(currentField){
    		if(currentField.xtype != "hiddenfield"){
    			currentField.reset();
    			if(currentField.clearValue){
    				currentField.clearValue();
    			}
    		}
    	});

    	me.submitLPExamDetails(btn);
    },
    
    resetButtonLessonPlanResitDetailsAction: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	
    	var mainEventPnl = win.down('#eventsMainPanel');
    	
    	var currentEventPnlItem = btn.up('[itemIdentifier=eventPnlItem]');
    	
    	var allFields = currentEventPnlItem.query('[isFormField=true]');
    	
    	Ext.each(allFields, function(currentField){
    		if(currentField.xtype != "hiddenfield"){
    			currentField.reset();
    			if(currentField.clearValue){
    				currentField.clearValue();
    			}
    			if(currentField.xtype == "numberfield"){
    				currentField.setValue(null);
    			}
    		}
    	});
    	
    	me.submitLPResitDetails(btn);
    }, 

    submitLPExamDetails: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	var allEventsPnls = win.query('[itemIdentifier=eventPnlItem]');
    	
    	var eventsAr = [];
    	var i = 1;
    	Ext.each(allEventsPnls, function(currentEventPnl){
    		
    		var outcomeValue = currentEventPnl.down('#lessonPlanEDAssessmentLearningOutcomeItemId').getValue();
    		
    		if(outcomeValue && typeof outcomeValue == 'object' && outcomeValue.length){
    			if(typeof outcomeValue[0] == 'object' && outcomeValue[0].data.id){
    				outcomeValue = Ext.Array.pluck(Ext.Array.pluck(outcomeValue,'data'),'id').join();
    			}
    			else if(outcomeValue[0] == '' || outcomeValue[0] == ' '){
    				outcomeValue = '';
    			}
    			else if(typeof outcomeValue[0] == 'number'){
    				outcomeValue = outcomeValue.join();
    			}
    		}
    		
    		var skillsValue = currentEventPnl.down('#lessonPlanEDAssessmentTransferedSkillsItemId').getValue();
    		
    		if(skillsValue && typeof skillsValue == 'object' && skillsValue.length){
    			if(typeof skillsValue[0] == 'object' && skillsValue[0].data.id){
    				skillsValue = Ext.Array.pluck(Ext.Array.pluck(skillsValue,'data'),'id').join();
    			}
    			else if(skillsValue[0] == '' || skillsValue[0] == ' '){
    				skillsValue = '';
    			}
    			else if(typeof skillsValue[0] == 'number'){
    				skillsValue = skillsValue.join();
    			}
    		}
    		
    		eventsAr.push({
    			id: currentEventPnl.down('#eventId').getValue(),
    			eventId: 'ev'+ i,
    			weitage: currentEventPnl.down('#lessonPlanEDWeightageItemId').getValue(),
        		date: currentEventPnl.down('#lessonPlanEDDateItemId').getValue(),
        		type: currentEventPnl.down('#lessonPlanEDTypeItemId').getValue(),
        		week: currentEventPnl.down('#lessonPlanEDWeekItemId').getValue(),
        		outcome: outcomeValue,
        		skills: skillsValue,
        		examDuration:currentEventPnl.down('#examDuration').getValue(),
        		groupOrIndividual:currentEventPnl.down("#whetherGrouporindividual").getValue()
    		});
    		
    		i = i+1;
    	});
    	
    	var contentpanel = this.getContentPanel();
    	var activeTab = contentpanel.getActiveTab();
    	
    	if(isNullOrEmpty(activeTab.examDetailsId)){
        	activeTab.examDetailsId = '-';
    	}
    	else{
    		activeTab.examDetailsId = win.examDetailsId;
    	}
    	
    	activeTab.eventsAr = eventsAr;
    	
    	if(!(btn.icon != undefined && !isNullOrEmpty(btn.icon))){
    		win.close();
    	}
    },
    
    submitLPResitDetails: function(btn){
    	var me = this;
    	
    	var win = btn.up('window');
    	var allEventsPnls = win.query('[itemIdentifier=eventPnlItem]');
    	
    	var resitAr = [];
    	var i = 1;
    	Ext.each(allEventsPnls, function(currentEventPnl){
    		
    		
    		resitAr.push({
    			id: currentEventPnl.down('#eventId').getValue(),
    			eventId: 'rs'+ i,
    			weitage: currentEventPnl.down('#lessonPlanRDWeightageItemId').getValue(),
        		resittype: currentEventPnl.down('#lessonPlanRDTypeItemId').getValue(),
        		resitexamDuration:currentEventPnl.down('#lessonPlanRDexamDuration').getValue(),
        		});
    		
    		i = i+1;
    	});
    	
    	var contentpanel = this.getContentPanel();
    	var activeTab = contentpanel.getActiveTab();
    	
    	if(isNullOrEmpty(activeTab.resitId)){
        	activeTab.resitId = '-';
    	}
    	else{
    		activeTab.resitId = win.resitId;
    	}
    	
    	activeTab.resitAr = resitAr;
    	if(!(btn.icon != undefined && !isNullOrEmpty(btn.icon))){
    		win.close();
    	}
    },
 	
    applyDFROnFormFields: function (form,formAlias) {
 		var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
 		var formFieldsInfo = fieldInfo.get("formFieldsInfo");
 		var formfields = formFieldsInfo[formAlias];
 		if(formfields != undefined){
 			for(var i in formfields){
 				if(formfields[i].formAliasName == formAlias){
 					var formFieldName = formfields[i].formFieldName;
 					var formItemId = formfields[i].formFieldId;
 					if(formItemId==""){
 						formItemId=null;
 					}
 					var isMandatory = formfields[i].isMandatory;
 					var defaultValue = formfields[i].defaultValue;
 					var isVisible = formfields[i].isVisible;
 					var formFieldLabel = formfields[i].formFieldLabel;
 					Ext.suspendLayouts();


 					var fields = form.query('[name='+formFieldName+']');

 					Ext.each(fields, function(field){
 	 					if(field != null){
 	 						if(field.xtype=='textfield' || field.xtype=='numberfield'){
 	 							if(field.name == formFieldName){
 	 								field.setFieldLabel(formFieldLabel);
 	 								if(isVisible == false){
 	 									field.setVisible(isVisible);
 	 									if(isMandatory == true){
 	 										field.allowBlank=true;
 	 									}
 	 								}
 	 								else if(isVisible == true){
 	 									field.setVisible(isVisible);
 	 									field.setFieldLabel(formFieldLabel);
 	 									if(isMandatory == true){
 	 										field.labelSeparator = '';
 	 										field.setFieldLabel(formFieldLabel+':<span class="required" style="color:red"> *</span>');
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 	 								}
 	 							}
 	 						}
 	 						if(field.xtype=='customcombobox' || field.xtype=='multiselectcombofield'){
 	 							if(field.name == formFieldName){
 	 								if(!isNullOrEmpty(defaultValue)){
 	 									var newVariable = 0;
 	 									newVariable = defaultValue;
 	 									tempField = field;
 	 									if(tempField.getStore().getProxy().api != undefined && tempField.getStore().getProxy().api  !=null){
 	 										tempField.getStore().load({
 	 											callback : function(records, operation, success) {
 	 												if (success) {
 	 													var indx= this.find('id',newVariable);
 	 													if(indx != -1){
 	 														var id = this.getAt(indx).get('id');
 	 														tempField.setValue(id);
 	 													}
 	 												}
 	 											}

 	 										});
 	 									}
 	 								}
 	 								field.setFieldLabel(formFieldLabel);
 	 								if(isVisible == true){
 	 									field.setVisible(isVisible);
 	 									if(isMandatory == true){
 	 										field.labelSeparator = '';
 	 										field.setFieldLabel(formFieldLabel+':<span class="required" style="color:red"> *</span>');
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 	 								}
 	 								if(isVisible == false){
 	 									field.setVisible(isVisible);
 	 									if(isMandatory == true){
 	 										field.labelSeparator = '';
 	 										field.setFieldLabel(formFieldLabel+':<span class="required" style="color:red"> *</span>');
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 	 								}
 	 							}
 	 						}
 	 					}
 					});
 					Ext.resumeLayouts();
 				}			
 			}
 		}
 	}
});

 