/**
 * Bhartendu Bhaskar
 */
Ext.define('Academia.controller.resourceavailability.ResourceAvailabilityReportController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
        'resourceutilization.ResourcesStore',
        'program.programDetails.programBatches.courseParameter.FacultyCombo',
        'transport.serviceRoute.WeekDays',
        'resourceavailability.ResourceAvailabilityReportStore',
        'resourceavailability.ResourseAvailabilityCourseStr'
        
    ],
    model: [],
    views: ['resourceavailability.ResourceAvailabilityReportStructure',
        'resourceavailability.ResourceAvailabilityReportFilter',
        'resourceavailability.ResourceAvailabilityReportGrid',
        'resourceavailability.ResourceAvailabilityCourseWin',
        'resourceavailability.ResourseAvailabilityCourseGrid'
    ],
    config: {
        RESOURCE_AVAILABILITY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RESOURCE_AVAILABILITY_REPORT_PRIVILEGES'),
    },
    refs: [{
        ref: 'resourceavailabilityreportfilter',
        selector: 'resourceavailabilityreportfilter'
    }, {
        ref: 'resourceavailabilityreportgrid',
        selector: 'resourceavailabilityreportgrid'
    }, {
        ref: 'resourceavailabilitycoursewin',
        selector: 'resourceavailabilitycoursewin'
    }, {
        ref: 'resourseavailabilitycoursegrid',
        selector: 'resourseavailabilitycoursegrid'
    },{
        ref: 'resourceAvailabilitycoursewin',
        selector: 'resourceavailabilitycoursewin form' 
    }],
    init: function(application) {
        this.control({
        	'resourceavailabilityreportgrid': {
                beforerender: function() {
                    this.getStore('resourceavailability.ResourceAvailabilityReportStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getRESOURCE_AVAILABILITY_REPORT_PERMISSIONS());
                }
            },
            'resourceavailabilityreportfilter radiogroup[itemId=selectionTypeItemId]': {
                change: function() {
                    var $this = this;
                    var filter = $this.getResourceavailabilityreportfilter();
                    var grid = $this.getResourceavailabilityreportgrid();
                    var store = grid.getStore();
                   
                    var selectedValue = filter.down('#selectionTypeItemId').getValue();
                    var val = selectedValue.resourceViewType;
                    if (val == 'masterTimetable') {
						grid.columns[2].setVisible(false);
                    } else {
						grid.columns[2].setVisible(true);
                    }
                    grid.columns[1].setVisible(false);
                    this.loadCurrentAcademyLocatonPrefill(true);
                    grid.getStore().removeAll();
                    this.resetPageSetting(grid.getStore());
                    var dockedItemsItemId = grid.down('#dockedItemsItemId');
                    dockedItemsItemId.setVisible(false);
                }
            },
            'resourceavailabilityreportfilter multiselectcombofield[itemId=academyLocationItemId]': {
            	afterrender: function() {
            		this.loadCurrentAcademyLocatonPrefill(false);
            	},
                blur: function() {
                    var $this = this;
                    var filter = $this.getResourceavailabilityreportfilter();
                    var academyLocationItemId = filter.down('#academyLocationItemId');
                    var academyLocationIdList = academyLocationItemId.getValue();

                    var roomFacultyTypeItemId = filter.down('#roomFacultyTypeItemId');
                    var roomItemId = filter.down('#roomItemId');
                    var facultyItemId = filter.down('#facultyItemId');
                    var weekDayItemId = filter.down('#weekDayItemId');
                    var fromDateItemId = filter.down('#fromDateItemId');
                    var toDateItemId = filter.down('#toDateItemId');

                    if (!isNullOrEmpty(academyLocationIdList) && ((!Ext.isArray(academyLocationIdList)) || (Ext.isArray(academyLocationIdList) && academyLocationIdList.length > 0 && academyLocationIdList[0] != ""))) {
                    	this.manageOtherFilter(false);
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PLEASE_SELECT_ACADEMY_LOCATION'));
                        roomFacultyTypeItemId.setDisabled(true);
                        roomItemId.setDisabled(true);
                        facultyItemId.setDisabled(true);
                        weekDayItemId.setDisabled(true);
                        fromDateItemId.setDisabled(true);
                        toDateItemId.setDisabled(true);
                        roomItemId.reset();
                        facultyItemId.reset();
                        weekDayItemId.reset();
                        fromDateItemId.reset();
                        toDateItemId.reset();
                        filter.isValid();
                    }
                }
            },
            'resourceavailabilityreportfilter radiogroup[itemId=roomFacultyTypeItemId]': {
                change: function() {
                    var $this = this;
                    var filter = $this.getResourceavailabilityreportfilter();
                    var grid = $this.getResourceavailabilityreportgrid();
                    
                    var roomItemId = filter.down('#roomItemId');
                    var facultyItemId = filter.down('#facultyItemId');

                    var academyLocationItemId = filter.down('#academyLocationItemId');
                    var selectedValue = filter.down('#selectionTypeItemId').getValue();
                    var selectRadioval = selectedValue.resourceViewType;
                    var academyLocationIdList = academyLocationItemId.getValue();
                    if (!isNullOrEmpty(academyLocationIdList)) {
                    	 var selectedValue = filter.down('#roomFacultyTypeItemId').getValue();
                         var val = selectedValue.roomFacultyType;
                         if (val == 'room') {
                        	 grid.columns[0].setVisible(true);
                        	 grid.columns[1].setVisible(false);
                        	 grid.columns[6].setVisible(false);
                        	 
                             roomItemId.setVisible(true);
                             roomItemId.setDisabled(false);

                             facultyItemId.setVisible(false);
                             facultyItemId.setDisabled(true);
                         } else {
                        	 grid.columns[0].setVisible(false);
                        	 grid.columns[1].setVisible(true);
                        	 
                             roomItemId.setVisible(false);
                             roomItemId.setDisabled(true);

                             facultyItemId.setVisible(true);
                             facultyItemId.setDisabled(false);
                             if(selectRadioval=='detailedTimetable'){
                            	 grid.columns[6].setVisible(true);
                             }
                         }
                         roomItemId.reset();
                         facultyItemId.reset();
                         filter.isValid();
                    }
                    grid.getStore().removeAll(); 
                    this.resetPageSetting(grid.getStore());
                    var dockedItemsItemId = grid.down('#dockedItemsItemId');
                    dockedItemsItemId.setVisible(false);
                }
            },
            'resourceavailabilityreportfilter button[itemId=resetBtnResourceAvailabilityReportFilterItemId]': {
                click: function() {
                    var $this = this;
                    this.loadCurrentAcademyLocatonPrefill(true);
                }
            },
            'resourceavailabilityreportfilter button[itemId=searchBtnResourceAvailabilityReportFilterItemId]': {
                click: function() {
                    this.loadResourceAvailabilityReportGrid();
                }
            },
            'resourceavailabilityreportgrid': {
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
   				 var resourceavailabilityreportgrid = this.getResourceavailabilityreportgrid();
   				 var columnName=resourceavailabilityreportgrid.columnManager.columns[cellIndex].dataIndex;

   				 if(columnName=='noOfAssociatedCourses'){
   					 if (e.target.tagName == 'A') {
   						 this.openCourseWin(grid, rowIndex, record);
   					 }
   				 }

				 }
		   }
        });
    },
    loadResourceAvailabilityReportGrid: function() {
        var $this = this;
        var filter = $this.getResourceavailabilityreportfilter();
        filter.down('#searchBtnResourceAvailabilityReportFilterItemId').setDisabled(true);
        var filterForm = filter.getForm();
        var grid = this.getResourceavailabilityreportgrid();
        var store = grid.getStore();
        var selectionTypeItemId = filter.down('#selectionTypeItemId');
        var academyLocationItemId = filter.down('#academyLocationItemId');
        var roomFacultyTypeItemId = filter.down('#roomFacultyTypeItemId');
        var roomItemId = filter.down('#roomItemId');
        var facultyItemId = filter.down('#facultyItemId');
        var weekDayItemId = filter.down('#weekDayItemId');
        var fromDateItemId = filter.down('#fromDateItemId');
        var toDateItemId = filter.down('#toDateItemId');
        var fromTimeItemId = filter.down('#fromTimeItemId');
        var toTimeItemId = filter.down('#toTimeItemId');

        var selectionTypeValue = selectionTypeItemId.getValue().resourceViewType;
        var roomFacultyType = roomFacultyTypeItemId.getValue().roomFacultyType;
        var academyLocationValue = academyLocationItemId.getValue();
        var roomId = roomItemId.getValue();
        var facultyId = facultyItemId.getValue();
        var weekDay = weekDayItemId.getValue();
        var fromDate = fromDateItemId.getValue();
        var toDate = toDateItemId.getValue();
        

		var values = filterForm.getValues();
        var fromTime = values.fromTime;
        var toTime = values.toTime;
        
		var facultyIds=[];
		var facultyUserIds; 
		if(facultyId !=undefined && facultyId.length > 0){
			for(var i in facultyId){
				if(Ext.isObject(facultyId[i])){
					facultyIds.push(facultyId[i].get("id"));
				}else{
					facultyIds.push(facultyId[i]);
				}
			}
			facultyUserIds = facultyIds.join();
		} else {
			facultyIds.push(facultyId);
			facultyUserIds = facultyIds.join();
		}
		
        var alIds = [];
        var academyLocationIds;
        if (academyLocationValue != undefined && academyLocationValue.length > 0) {
            for (var i in academyLocationValue) {
                if (Ext.isObject(academyLocationValue[0])) {
                    alIds.push(academyLocationValue[i].get("id"));
                } else {
                    alIds.push(academyLocationValue[i]);
                }
            }
            academyLocationIds = alIds.join();
        } else {
			alIds.push(academyLocationValue);
			academyLocationIds = alIds.join();
		}
        var submitURL = null;
        if (selectionTypeValue == 'masterTimetable') {
            submitURL = SERVERURL.RAR_FIND_MASTER_TIME_TABLE_DATA;
        } else {
            submitURL = SERVERURL.RAR_FIND_DETAILED_TIME_TABLE_DATA;
        }
        store.getProxy().api.read = submitURL;
        store.getProxy().extraParams = {
            academyLocationIds: academyLocationIds,
            selectionType: selectionTypeValue,
            roomFacultyType: roomFacultyType,
            roomId: roomId,
            facultyId: facultyUserIds,
            weekDay: weekDay,
            fromDate: fromDate,
            toDate: toDate,
            fromTime: fromTime,
            toTime: toTime
        };
        this.resetPageSetting(store);
        store.load({
			callback: function(records, operation, success) {
				filter.down('#searchBtnResourceAvailabilityReportFilterItemId').setDisabled(false);
			}
		});
        
        var dockedItemsItemId = grid.down('#dockedItemsItemId');
        dockedItemsItemId.setVisible(true);
        grid.config.searchFilterForm = filter;
    },
    loadCurrentAcademyLocatonPrefill: function(isReset) {
    	var $this = this;
    	var filter = $this.getResourceavailabilityreportfilter();
    	var academyLocationItemId = filter.down('#academyLocationItemId');
    	var academyLocationStore = academyLocationItemId.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var models = academyLocationStore.getRange();
    	if(!isNullOrEmpty(models) && models.length > 0) {
    		academyLocationItemId.setValue(academyLocationId);
    		this.manageOtherFilter(isReset);
    	} else {
    		academyLocationStore.load({
    			callback: function(records, operation, success) {
    				if (success) {
    					academyLocationItemId.setValue(academyLocationId);
    					$this.manageOtherFilter(isReset);
    				}
    			}
    		});
    	}
    },
    manageOtherFilter: function(isReset) {
    	var $this = this;
    	var filter = $this.getResourceavailabilityreportfilter();
    	var academyLocationItemId = filter.down('#academyLocationItemId');
        var academyLocationIdList = academyLocationItemId.getValue();

        var roomFacultyTypeItemId = filter.down('#roomFacultyTypeItemId');
        var roomItemId = filter.down('#roomItemId');
        var facultyItemId = filter.down('#facultyItemId');
        var weekDayItemId = filter.down('#weekDayItemId');
        var fromDateItemId = filter.down('#fromDateItemId');
        var toDateItemId = filter.down('#toDateItemId');
        var fromTimeItemId = filter.down('#fromTimeItemId');
        var toTimeItemId = filter.down('#toTimeItemId');
        
        roomItemId.reset();
        facultyItemId.reset();
        fromTimeItemId.reset();
        toTimeItemId.reset();
        fromTimeItemId.setMinValue(false);
        fromTimeItemId.setMaxValue(false);
        toTimeItemId.setMinValue(false);
        toTimeItemId.setMaxValue(false);
        
        fromDateItemId.setMinValue(false);
        fromDateItemId.setMaxValue(false);
        toDateItemId.setMinValue(false);
        toDateItemId.setMaxValue(false);
        
    	var alIds = [];
        var academyLocationIds;
        if (Ext.isArray(academyLocationIdList)) {
        	for (var i in academyLocationIdList) {
                if (Ext.isObject(academyLocationIdList[0])) {
                    alIds.push(academyLocationIdList[i].get("id"));
                } else {
                    alIds.push(academyLocationId[i]);
                }
            }
        } else {
        	alIds.push(academyLocationIdList);
        }
        academyLocationIds = alIds.join();

        roomFacultyTypeItemId.setDisabled(false);
        roomFacultyTypeItemId.reset();

        roomItemId.setDisabled(false);
        var roomStore = roomItemId.getStore();
        roomStore.getProxy().extraParams = {
            name: '',
            academyLocationIds: academyLocationIds,
            onlyClassRoom: true
        };
        roomStore.load();

        var facultyStore = facultyItemId.getStore();
        facultyStore.getProxy().extraParams = {
        	restrictToFacultyRole : true,
            academyLocationIds: academyLocationIds
        };
        facultyStore.load();

        var selectedValue = filter.down('#selectionTypeItemId').getValue();
        var val = selectedValue.resourceViewType;
        if (val == 'masterTimetable') {
            weekDayItemId.setVisible(true);
            fromDateItemId.setVisible(false);
            toDateItemId.setVisible(false);

            weekDayItemId.setDisabled(false);
            fromDateItemId.setDisabled(true);
            toDateItemId.setDisabled(true);

            toDateItemId.allowBlank = true;
            toDateItemId.allowBlank = true;
        } else {
            weekDayItemId.setVisible(false);
            fromDateItemId.setVisible(true);
            toDateItemId.setVisible(true);

            weekDayItemId.setDisabled(true);
            fromDateItemId.setDisabled(false);
            toDateItemId.setDisabled(false);

            toDateItemId.allowBlank = false;
            toDateItemId.allowBlank = false;
        }
        
        var selectedRoomFacultyValue = roomFacultyTypeItemId.getValue();
        var val = selectedRoomFacultyValue.roomFacultyType;
        if (val == 'room') {
            roomItemId.setVisible(true);
            roomItemId.setDisabled(false);

            facultyItemId.setVisible(false);
            facultyItemId.setDisabled(true);
        } else {
            roomItemId.setVisible(false);
            roomItemId.setDisabled(true);

            facultyItemId.setVisible(true);
            facultyItemId.setDisabled(false);
        }
        if (isReset) {
        	weekDayItemId.reset();
            fromDateItemId.reset();
            toDateItemId.reset();
        }
        filter.getForm().checkValidity();
        //filter.isValid()
    },
    openCourseWin:function(grid, rowIndex, record){
    	var $this = this;
    	var formWindow = $this.getResourceavailabilitycoursewin();
    	if (!formWindow) {
    		Ext.widget('resourceavailabilitycoursewin');
    		formWindow = $this.getResourceavailabilitycoursewin();
    	}
    	formWindow.show();

    	var form = $this.getResourceAvailabilitycoursewin().getForm();

    	if(!isNullOrEmpty(record.data.facultyName)){
    		var facultyName =  record.data.facultyName;
    		form.findField('facultyName').setValue(facultyName);
    	}

    	var resourceavailabilityForm = $this.getResourceavailabilityreportfilter().getForm();
    	var values = resourceavailabilityForm.getValues();

    	var alIds = [];
    	var academyLocationIds;
    	if (values.academyLocationId != undefined && values.academyLocationId.length > 0) {
    		for (var i in values.academyLocationId) {
    			if (Ext.isObject(values.academyLocationId[0])) {
    				alIds.push(values.academyLocationId[i].get("id"));
    			} else {
    				alIds.push(values.academyLocationId[i]);
    			}
    		}
    		academyLocationIds = alIds.join();
    	} else {
    		alIds.push(values.academyLocationId);
    		academyLocationIds = alIds.join();
    	}

    	var store = $this.getResourseavailabilitycoursegrid().getStore();
    	store.getProxy().extraParams = {
    		facultyId : record.data.facultyId
    	};
    	$this.resetPageSetting(store);
    	store.load();

    }
});