/**
 * @author Sumit Sharma
 * 
 */
Ext.define('Academia.controller.scholarship.PoetMasterController', {
	extend: 'Academia.controller.base.BaseController',
	stores : [
		'scholarships.PoetMasterFeeHeadStore','poet.PoetProjectNumberStore','poet.PoetFeeHeadStore','poet.PoetMasterListGridStore'
	],
	views : [
		'scholarship.poetmaster.PoetMasterStructure',
		'scholarship.poetmaster.PoetMasterTabStructure',
		'scholarship.poetmaster.PoetMasterFilter',
		'scholarship.poetmaster.PoetMasterGrid',
		'scholarship.poetmaster.PoetSetupForm'
	],
	refs : [
		{
			ref:'poetmastergrid',
			selector:'poetmastergrid'
		},
		{
			ref: 'poetsetupform',
			selector:'poetsetupform'
		},
		{
			ref: 'contentPanel',
			selector: 'contentpanel'
		},
		{
			ref: 'poetmasterfilter',
			selector: 'poetmasterfilter'
		},
	],
	config: {POET_MASTER_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('POETMASTER_PRIVILEGES')

	},
	init : function() {
		this.showContractSubAddBtn;
		this.control({
			'poetmastergrid':{
				selectionchange:function(view,record){
					var grid = this.getPoetmastergrid();
					var editBtn = grid.down('#btnEdit');
					var viewBtn = grid.down('#btnView');
					var deleteBtn = grid.down('#btnDelete');
					if(record.length > 0){
						editBtn.setDisabled(false);
						viewBtn.setDisabled(false);
						deleteBtn.setDisabled(false);
					}else{
						editBtn.setDisabled(true);
						viewBtn.setDisabled(true);
						deleteBtn.setDisabled(true);
					}
				},
				render: function(grid) {
    				var me=this;
    				me.doAccessControlValidation(grid,me.getPOET_MASTER_PERMISSIONS());
    				var store = grid.getStore();
                  	store.load({
                  		callback: function(){
                  			grid.getSelectionModel().deselectAll();
                  		}
                  	});
    				
    			}
			},
			
			'poetmastergrid button[itemId=btnAdd]':{
				click:function(obj){
					var contentpanel = this.getContentPanel();
					var structure = Ext.widget('poetsetupform',{
						formType: 'add'
					});
					var tabName = getCommonTranslation('POET_SETUP');
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_ONE);
				}
			},
			'poetmastergrid button[itemId=btnEdit]':{
				click:function(obj){
					var grid = this.getPoetmastergrid();
					var record = grid.getSelectionModel().getSelection()[0];
					var contentpanel = this.getContentPanel();
					var structure = Ext.widget('poetsetupform',{
						formType: 'edit',
						record: record
					});
					var tabName = getCommonTranslation('POET_SETUP');
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_ONE);
				}
			},
			'poetmastergrid button[itemId=btnView]':{
				click:function(obj){
					var grid = this.getPoetmastergrid();
					var record = grid.getSelectionModel().getSelection()[0];
					var contentpanel = this.getContentPanel();
					var structure = Ext.widget('poetsetupform',{
						formType: 'view',
						record: record
					});
					var tabName = getCommonTranslation('POET_SETUP');
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_ONE);
				}
			},
			'poetmastergrid button[itemId=btnDelete]':{
				click:this.deletPoetDetail
					
				
			},
			
			'poetmasterfilter button[itemId=searchBtnTmmytasksfilterItemId]': {
                click: function() {
                    this.loadPoetMasterGrid();
                },
                
			},
			'poetmasterfilter customcombobox[itemId=projectNumber]': {
				select: function(obj) {
					  var $this = this;
					  var form = this.getPoetmasterfilter();
					    var projectNumber = form.down('#projectNumber').getValue();
					    var feeHeadName = form.down('#feeHeadName');
					    feeHeadName.reset();
					  var feeheadNameStore =  feeHeadName.getStore();
					  feeheadNameStore.getProxy().extraParams = {
	      					id: projectNumber
	      				};
					  feeheadNameStore.load();
					  
					
                },
                
			},

			'poetmasterfilter button[itemId=resetTmmytasksfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getPoetmasterfilter();
                    var feeHeadName = form.down('#feeHeadName');
                    feeHeadName.getStore().getProxy().extraParams={
                    	feeHeadName:null
                    	
                    }
                    form.getForm().reset();
                    feeHeadName.getStore().load();
                    
                }
            },
            
			'poetsetupform':{
				afterrender: function(form){
					var me = this;
					var formType = form.formType;
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getPOET_MASTER_PERMISSIONS());
					var showTaskAddBtn =  permissionList.indexOf("ADD_TASK_DETAILS");
					var showContractAddBtn =  permissionList.indexOf("ADD_CONTRACT_DETAILS");
					this.showContractSubAddBtn =  permissionList.indexOf("ADD_CONTRACT_SUB_DETAILS");
					if(formType == "add"){
						var isViewOnly = false;
						var totalRows = 1;
						var currentRow = 1;
						var fieldData = [];
						me.addTaskFields(form, totalRows, currentRow, fieldData, isViewOnly,showTaskAddBtn);
						me.addContractFields(form, totalRows, currentRow, fieldData, isViewOnly,showContractAddBtn,this.showContractSubAddBtn);
						
						var feeHeadField = form.down('[name=feeHeadName]');
						if(feeHeadField.getStore().getProxy().extraParams.id){
							delete feeHeadField.getStore().getProxy().extraParams.id;
						}
					}
					else{
						var recordId = form.record.data.id;
						var isViewOnly = (formType == "edit") ? false : true;
						
						Ext.Ajax.request({
				    		type: 'rest',
				    		url: SERVERURL.PATH_FIND_POET_MASTER_DETAILS_BY_ID,
				    		method: 'GET',
				    		params:{
				    			id: recordId
				    		},
				    		success: function(response, action) {
				    			var data = response.responseText;
				    			if(!isNullOrEmpty(data)) {
				    				var jsonData=Ext.decode(data);

				    				form.record.data = jsonData;

				    				var id = jsonData.id;
				    				var projectId = jsonData.projectId;
				    				var projectName = jsonData.projectName;
				    				var projectNumber = jsonData.projectNumber;
				    				var feeHeadId = jsonData.feeHead.id;
				    				var wsPoetMasterContractDetails = jsonData.wsPoetMasterContractDetails;
				    				var wsPoetMasterTaskDetails = jsonData.wsPoetMasterTaskDetails;

				    				var feeHeadField = form.down('[name=feeHeadName]');

				    				form.down('[name=id]').setValue(id);
				    				form.down('[name=projectNumber]').setValue(projectNumber);
				    				form.down('[name=projectName]').setValue(projectName);
				    				form.down('[name=projectId]').setValue(projectId);
									feeHeadField.getStore().getProxy().extraParams = {
										id:recordId
									};
				    				feeHeadField.getStore().load({
				    					callback: function(){
				    						feeHeadField.setValue(feeHeadId);
				    					}
				    				});

				    				form.down('[name=projectNumber]').setReadOnly(isViewOnly);
				    				form.down('[name=projectName]').setReadOnly(isViewOnly);
				    				form.down('[name=projectId]').setReadOnly(isViewOnly);
				    				feeHeadField.setReadOnly(isViewOnly);

				    				var totalRows = wsPoetMasterTaskDetails.length;
				    				var currentRow = 1;
				    				var fieldData = wsPoetMasterTaskDetails;
				    				me.addTaskFields(form, totalRows, currentRow, fieldData, isViewOnly,showTaskAddBtn);

				    				var totalRows = wsPoetMasterContractDetails.length;
				    				var currentRow = 1;
				    				var fieldData = wsPoetMasterContractDetails;
				    				me.addContractFields(form, totalRows, currentRow, fieldData, isViewOnly,showContractAddBtn,this.showContractSubAddBtn);
				    				
				    				form.down('#SubmitBtn').setVisible(!isViewOnly);
				    				form.down('#btnCancel').setVisible(!isViewOnly);
				    				form.down('#CancelBtnPOETForm').setVisible(isViewOnly);
				    			}
				    		}
						});
					}
				}
			},
			'poetsetupform button[itemId=SubmitBtn]':{
				click: function(btn){
					var me = this
					var form = btn.up('form');
					var formType = form.formType;
					
					if(formType == "add"){
						me.saveUpdatePoetSetupForm("add", form);
					}
					else{
						me.saveUpdatePoetSetupForm("edit", form);
					}
				}
			},
			'poetsetupform button[itemId=CancelBtnPOETForm]':{
				click: function(btn){
					this.closePoetDetailFormTab();
				}
			},
			'poetsetupform button[itemId=btnCancel]':{
				click: function(btn){
					var me = this
					var form = btn.up('form');
					me.resetPoetSetupForm(form);
				}
			},
			'poetsetupform button[action=deleteTaskBtnAction]':{
				click : this.deleteTaskFieldContainer
			},
			'poetsetupform button[action=addTaskBtnAction]':{
				click : this.addNewTaskFiekdContainer
			},
			'poetsetupform button[action=deleteContractBtnAction]':{
				click : this.deleteContractFieldContainer
			},
			'poetsetupform button[action=addContractBtnAction]':{
				click : this.addNewContractFiekdContainer
			},
			'poetsetupform button[action=deleteSubContractBtnAction]':{
				click : this.deleteSubContractFieldContainer
			},
			'poetsetupform button[action=addSubContractBtnAction]':{
				click : this.addNewSubContractFiekdContainer
			},
			'poetsetupform textfield':{
				change: function(field){
					var me = this;
					var form = field.up('form');
					me.checkAndValidatePoetMasterForm(form);
				}
			}
			
		});
	},
	addTaskFields: function(form, totalRows, currentRow, fieldData, isViewOnly,ispermissionGranted){
		var me = this;
		var panelToAdd = form.down('#taskPanelItemId');
		var panelItem = new Array();
		if(currentRow <= totalRows){
			panelItem.push({
				xtype : 'fieldcontainer',
				layout : 'hbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				fieldDataId: (fieldData.length) ? fieldData[currentRow-1].id : null,
				items : [{
					xtype: 'textfield',
					name: 'taskNumber',
					fieldLabel: getCommonTranslation('TASK_NUMBER'),
					allowBlank:false,
					value: (fieldData.length) ? fieldData[currentRow-1].taskNumber : '',
					readOnly: isViewOnly,
					maxLength: 255,
					listeners:{
						afterrender: function(field){
							me.setAllowBlank(field, false);
						}
					}
				},
				{
					xtype: 'textfield',
					name: 'taskName',
					fieldLabel: getCommonTranslation('TASK_NAME'),
					allowBlank:false,
					value: (fieldData.length) ? fieldData[currentRow-1].taskName : '',
					readOnly: isViewOnly,
					maxLength: 255,
					listeners:{
						afterrender: function(field){
							me.setAllowBlank(field, false);
						}
					}
				},
				{
					xtype: 'textfield',
					name: 'taskIdName',
					fieldLabel: getCommonTranslation('TASK_ID'),
					allowBlank: false,
					value: (fieldData.length) ? fieldData[currentRow-1].taskId : '',
					readOnly: isViewOnly,
					maxLength: 255,
					listeners:{
						afterrender: function(field){
							me.setAllowBlank(field, false);
						}
					}
				},{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					cls: 'CustomBodyBtnReject',
					action: 'deleteTaskBtnAction',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					height: 27,
					width: 25,
					hidden: (currentRow == 1 || isViewOnly || (ispermissionGranted<0)),
					style:{
						marginTop:'30px'
					}
				},
				{
					xtype: 'button',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					action: 'addTaskBtnAction',
					cls: "CustomBodyBtnSettings", 
					height: 27,
					width: 25,
					hidden: (isViewOnly || (ispermissionGranted<0)),
					style:{
						marginTop:'30px'
					}
				}]
			});
			
			panelToAdd.add(panelItem);
			panelToAdd.doLayout();
			
			me.addTaskFields(form, totalRows, currentRow+1, fieldData, isViewOnly,ispermissionGranted);
		}
	},
	addNewTaskFiekdContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var panelToAdd = btn.up('#taskPanelItemId');
		var objectCount = panelToAdd.items.length;
		var isViewOnly = false;
		var totalRows = objectCount+1;
		var currentRow = objectCount+1;
		var fieldData = [];
		
		/*if(totalRows > 15){
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_ROWS_LIMIT_MSG')); 
            return false;
		}*/
		
		me.addTaskFields(form, totalRows, currentRow, fieldData, isViewOnly);
		me.checkAndValidatePoetMasterForm(form);
	},
	deleteTaskFieldContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var fieldContainer = btn.up('fieldcontainer');
		fieldContainer.destroy();
		me.checkAndValidatePoetMasterForm(form);
	},
	 loadPoetMasterGrid: function() {
	        var $this = this;
	        var form = this.getPoetmasterfilter();
	        var grid = this.getPoetmastergrid();
	        var projectNumber = form.down("#projectNumber").getValue();
	        var feeHead = form.down("#feeHeadName").getValue();
	        var store = grid.getStore();
	        store.getProxy().extraParams = {
	        	projectNumber: projectNumber,
	        	feeHead: feeHead
	        };
	        store.load();
	    },
	    deletPoetDetail:function() {
	        var grid = this.getPoetmastergrid();

	        if (grid.getSelectionModel().getCount() > 0) {
	            showConfirmMessage(getCommonTranslation('DELETE_POETMASTER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                if (btn == 'yes') {
	                    var records = grid.getSelectionModel().getSelection()[0];
	                    var id = records.data.id;

	                    Ext.Ajax.request({
	                        type: 'rest',
	                        method: 'DELETE',
	                        url: SERVERURL.PATH_POETMASTER_DELETE_BY_ID + '?id=' + id,
	                        headers: {
	                            'Content-Type': 'application/json'
	                        },
	                        params: {
								id: id
							},
	                        success: function(form, action) {
	                            var data = form.responseText;
	  						 if(data == 'DEPENDENCY_EXIST'){
	  							  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENCY_EXISTS'));
	  						  }else{
	  							  grid.getStore().reload(); // after deleted a record reloading the grid data
	  							showSuccessMessage(getCommonTranslation('DELETE_POETMASTER'), getCommonTranslation('DELETE_POETMASTER_SUCCESS'));
	  						  }
	                        }
	                    });
	                }
	            });
	        } else {
	            showWarningMessage(getCommonTranslation('DELETE_POETMASTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        }
	    },
	addContractFields: function(form, totalRows, currentRow, fieldData, isViewOnly,showContractAddBtn,showContractSubAddBtn){
		var me = this;
		var panelToAdd = form.down('#contractDetailsPanelItemId');
		var panelItem = new Array();
		if(currentRow <= totalRows){
			panelItem.push({
				xtype: 'panel',
				fieldData: (fieldData.length) ? fieldData[currentRow-1]: {},
				width: '100%',
				style: {
					margin: 0,
					marginTop:'10px',
					padding: 0
				},
				fieldDataId: (fieldData.length) ? fieldData[currentRow-1].id : null,
				items:[{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					width: '100%',
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype: 'textfield',
						name: 'contractNumber',
						fieldLabel: getCommonTranslation('CONTRACT_NUMBER'),
						value: (fieldData.length) ? fieldData[currentRow-1].contractNumber : '',
						readOnly: isViewOnly,
						maxLength: 255,
						listeners:{
							afterrender: function(field){
								me.setAllowBlank(field, true);
							}
						}
					},{
						xtype: 'textfield',
						name: 'contractName',
						fieldLabel: getCommonTranslation('CONTRACT_NAME'),
						value: (fieldData.length) ? fieldData[currentRow-1].contractName : '',
						readOnly: isViewOnly,
						maxLength: 255,
						listeners:{
							afterrender: function(field){
								me.setAllowBlank(field, true);
							}
						}
					},{
						xtype: 'textfield',
						name: 'contractId',
						fieldLabel: getCommonTranslation('CONTRACT_ID'),
						value: (fieldData.length) ? fieldData[currentRow-1].contractId : '',
						readOnly: isViewOnly,
						maxLength: 255,
						listeners:{
							afterrender: function(field){
								me.setAllowBlank(field, true);
							}
						}
					},{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						cls: 'CustomBodyBtnReject',
						action: 'deleteContractBtnAction',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
						height: 27,
						width: 25,
						hidden: (currentRow == 1 || isViewOnly || (showContractAddBtn<0)),
						style:{
							marginTop:'30px'
						}
					},
					{
						xtype: 'button',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						action: 'addContractBtnAction',
						cls: "CustomBodyBtnSettings",
						height: 27,
						width: 25,
						hidden: (isViewOnly || (showContractAddBtn<0)),
						style:{
							marginTop:'30px'
						}
					}]
				},{
					xtype: 'panel',
					width: '100%',
					style: {
						margin: 0,
						marginTop:'10px',
						padding: 0
					},
					items:[],
					listeners: {
						afterrender: function(pnl){
							var pnlFieldData = pnl.up('panel').fieldData;
							var totalSubRows = !Object.keys(pnlFieldData).length ? 1 : pnlFieldData.wsPoetMasterContractFundSource.length;
							var currentSubRow = 1;
							var subFieldData = !Object.keys(pnlFieldData).length ? [] : pnlFieldData.wsPoetMasterContractFundSource;
							me.addSubContractFields(pnl, totalSubRows, currentSubRow, subFieldData, isViewOnly,me.showContractSubAddBtn);
						}
					}
				}]
			});
			
			panelToAdd.add(panelItem);
			panelToAdd.doLayout();
			
			me.addContractFields(form, totalRows, currentRow+1, fieldData, isViewOnly,showContractAddBtn);
		}
	},
	addNewContractFiekdContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var panelToAdd = btn.up('#contractDetailsPanelItemId');
		var objectCount = panelToAdd.items.length;
		var isViewOnly = false;
		var totalRows = objectCount+1;
		var currentRow = objectCount+1;
		var fieldData = [];
		
		/*if(totalRows > 15){
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_ROWS_LIMIT_MSG')); 
            return false;
		}*/
		
		me.addContractFields(form, totalRows, currentRow, fieldData, isViewOnly);
		me.checkAndValidatePoetMasterForm(form);
	},
	deleteContractFieldContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var fieldContainer = btn.up('panel');
		fieldContainer.destroy();
		me.checkAndValidatePoetMasterForm(form);
	},
	addSubContractFields: function(pnl, totalRows, currentRow, fieldData, isViewOnly,showContractSubAddBtn){
		var me = this;
		var panelToAdd = pnl;
		var panelItem = new Array();
		if(currentRow <= totalRows){
			panelItem.push({
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				fieldDataId: (fieldData.length) ? fieldData[currentRow-1].id : null,
				items : [{
					xtype: 'textfield',
					name: 'fundingSourceNumber',
					fieldLabel: getCommonTranslation('FUNDING_SOURCE_NUMBER'),
					value: (fieldData.length) ? fieldData[currentRow-1].fundingSourceNumber : '',
					readOnly: isViewOnly,
					maxLength: 255,
					disabled: true,
					listeners:{
						afterrender: function(field){
							me.setAllowBlank(field, false);
						}
					}
				},{
					xtype: 'textfield',
					name: 'fundingSourceName',
					fieldLabel: getCommonTranslation('FUNDING_SOURCE_NAME'),
					value: (fieldData.length) ? fieldData[currentRow-1].fundingSourceName : '',
					readOnly: isViewOnly,
					maxLength: 255,
					disabled: true,
					listeners:{
						afterrender: function(field){
							me.setAllowBlank(field, false);
						}
					}
				},{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					cls: 'CustomBodyBtnReject',
					action: 'deleteSubContractBtnAction',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					height: 27,
					width: 25,
					hidden: (currentRow == 1 || isViewOnly || (showContractSubAddBtn<0)),
					style:{
						marginTop:'30px'
					}
				},
				{
					xtype: 'button',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					name: 'addSubContractBtnName',
					tooltip: getCommonTranslation('ADD'),
					action: 'addSubContractBtnAction',
					cls: "CustomBodyBtnSettings",
					height: 27,
					width: 25,
					hidden: (isViewOnly || showContractSubAddBtn<0),
					disabled: true,
					style:{
						marginTop:'30px'
					}
				}]
			});
			
			panelToAdd.add(panelItem);
			panelToAdd.doLayout();
			
			me.addSubContractFields(pnl, totalRows, currentRow+1, fieldData, isViewOnly,showContractSubAddBtn);
		}
	},
	addNewSubContractFiekdContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var panelToAdd = btn.up('panel');
		var objectCount = panelToAdd.items.length;
		var isViewOnly = false;
		var totalRows = objectCount+1;
		var currentRow = objectCount+1;
		var fieldData = [];
		
		/*if(totalRows > 15){
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_ROWS_LIMIT_MSG')); 
            return false;
		}*/
		
		me.addSubContractFields(panelToAdd, totalRows, currentRow, fieldData, isViewOnly);
		me.checkAndValidatePoetMasterForm(form);
	},
	deleteSubContractFieldContainer: function(btn){
		var me = this;
		var form = btn.up('form');
		var fieldContainer = btn.up('fieldcontainer');
		fieldContainer.destroy();
		me.checkAndValidatePoetMasterForm(form);
	},
	checkAndValidatePoetMasterForm: function(form){
		var me  = this;
		if(form.isValid()){
			var isFormValid = true;
			
			var projectNumber = form.down('#projectNumberItemId').getValue();
			var projectName = form.down('#projectNameItemId').getValue();
			var projectID = form.down('#projectIdItemId').getValue();
			var feeHead = form.down('#feeHeadNameItemId').getValue();
			
			if(isNullOrEmpty(projectNumber) || isNullOrEmpty(projectName) || isNullOrEmpty(projectID) || isNullOrEmpty(feeHead)){
				isFormValid = false;
			}
			else{
				//Creating TaskNumber & TaskID Combination
				var taskPanel = form.down('#taskPanelItemId');
				var taskNumberIdArray = [];
				
				Ext.each(taskPanel.items.items, function(taskPanelItem){
					var taskNumber = taskPanelItem.down('[name=taskNumber]').getValue();
					var taskId = taskPanelItem.down('[name=taskIdName]').getValue();

					if(!isNullOrEmpty(taskNumber) && !isNullOrEmpty(taskId)){
						taskNumberIdArray.push(taskNumber+'-'+taskId);
					}
				});
				
				if(taskNumberIdArray.length && !me.areAllElementsUnique(taskNumberIdArray)){
					isFormValid = false;
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TASK_NUMBER_ID_COMBINATION_UNIQUE_MSG'));
				}
				else{
					//Creating contractNumber & contractId Combination
					var contractDetailsPanel = form.down('#contractDetailsPanelItemId');
					var contractNumberIdArray = [];
					
					Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
						var contractNumber = contractDetailsPanelItem.down('[name=contractNumber]').getValue();
						var contractId = contractDetailsPanelItem.down('[name=contractId]').getValue();

						if(!isNullOrEmpty(contractNumber) && !isNullOrEmpty(contractId)){
							contractNumberIdArray.push(contractNumber+'-'+contractId);
						}
					});
					
					if(contractNumberIdArray.length && !me.areAllElementsUnique(contractNumberIdArray)){
						isFormValid = false;
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CONTRACT_NUMBER_ID_COMBINATION_UNIQUE_MSG'));
					}
					else{
						var isFundingRecordValid = true;
						//checking unique funding source number
						Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
							var contractNumber = contractDetailsPanelItem.down('[name=contractNumber]').getValue();
							var contractName = contractDetailsPanelItem.down('[name=contractName]').getValue();
							var contractId = contractDetailsPanelItem.down('[name=contractId]').getValue();
							
							var subContractDetailsPanel = contractDetailsPanelItem.down('panel');
							var fundingSourceNumberArray = [];
							
							Ext.each(subContractDetailsPanel.items.items, function(subContractDetailsPanelItem){
								var fundingSourceNumber = subContractDetailsPanelItem.down('[name=fundingSourceNumber]').getValue();
								var fundingSourceName = subContractDetailsPanelItem.down('[name=fundingSourceName]').getValue();
								if(!isNullOrEmpty(fundingSourceNumber)){
									fundingSourceNumberArray.push(fundingSourceNumber);
								}
								
								if(!isNullOrEmpty(contractNumber) || !isNullOrEmpty(contractName) || !isNullOrEmpty(contractId)){
									subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setDisabled(false);
									subContractDetailsPanelItem.down('[name=fundingSourceName]').setDisabled(false);
									subContractDetailsPanelItem.down('[name=addSubContractBtnName]').setDisabled(false);
									if(isNullOrEmpty(fundingSourceNumber) || isNullOrEmpty(fundingSourceName)){
										isFundingRecordValid = false;
										//contractNumbersStr.push(contractNumber);
									}
								}
								else{
									subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setDisabled(true);
									subContractDetailsPanelItem.down('[name=fundingSourceName]').setDisabled(true);
									subContractDetailsPanelItem.down('[name=addSubContractBtnName]').setDisabled(true);
									subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setValue('');
									subContractDetailsPanelItem.down('[name=fundingSourceName]').setValue('');
								}
							});
							
							if(fundingSourceNumberArray.length && !me.areAllElementsUnique(fundingSourceNumberArray)){
								isFormValid = false;
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FUNDING_SOURCE_NUMBER_UNIQUE_MSG'));
							}
						});
						
						if(!isFundingRecordValid){
							isFormValid = false;
						}
					}
				}
			}
		}
		else {
			var isFundingRecordValid = true;
			var contractDetailsPanel = form.down('#contractDetailsPanelItemId');
			
			Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
				var contractNumber = contractDetailsPanelItem.down('[name=contractNumber]').getValue();
				var contractName = contractDetailsPanelItem.down('[name=contractName]').getValue();
				var contractId = contractDetailsPanelItem.down('[name=contractId]').getValue();
				
				var subContractDetailsPanel = contractDetailsPanelItem.down('panel');
				var fundingSourceNumberArray = [];
				
				Ext.each(subContractDetailsPanel.items.items, function(subContractDetailsPanelItem){
					var fundingSourceNumber = subContractDetailsPanelItem.down('[name=fundingSourceNumber]').getValue();
					var fundingSourceName = subContractDetailsPanelItem.down('[name=fundingSourceName]').getValue();
					if(!isNullOrEmpty(fundingSourceNumber)){
						fundingSourceNumberArray.push(fundingSourceNumber);
					}
					
					if(!isNullOrEmpty(contractNumber) || !isNullOrEmpty(contractName) || !isNullOrEmpty(contractId)){
						subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setDisabled(false);
						subContractDetailsPanelItem.down('[name=fundingSourceName]').setDisabled(false);
						subContractDetailsPanelItem.down('[name=addSubContractBtnName]').setDisabled(false);
						if(isNullOrEmpty(fundingSourceNumber) || isNullOrEmpty(fundingSourceName)){
							isFundingRecordValid = false;
							//contractNumbersStr.push(contractNumber);
						}
					}
					else{
						subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setDisabled(true);
						subContractDetailsPanelItem.down('[name=fundingSourceName]').setDisabled(true);
						subContractDetailsPanelItem.down('[name=addSubContractBtnName]').setDisabled(true);
						subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setValue('');
						subContractDetailsPanelItem.down('[name=fundingSourceName]').setValue('');
					}
				});
				
				if(fundingSourceNumberArray.length && !me.areAllElementsUnique(fundingSourceNumberArray)){
					isFormValid = false;
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FUNDING_SOURCE_NUMBER_UNIQUE_MSG'));
				}
			});
			
			if(!isFundingRecordValid){
				var isFormValid = false;
			}
			else if(form.isValid()){
				var isFormValid = true;
			}
			else{
				var isFormValid = false;
			}
		}
		
		form.down('#SubmitBtn').setDisabled(!isFormValid);
		form.getForm().clearInvalid();
		
	},
	areAllElementsUnique: function(array) {
	    var hash = {};
	    for (var i = 0; i < array.length; i++) {
	        if (hash[array[i]]) {
	            return false;
	        }
	        hash[array[i]] = true;
	    }
	    return true;
	},
	saveUpdatePoetSetupForm: function(type, form){
		var me = this;
		var poetId = form.down('[name=id]').getValue();
		var projectNumber = form.down('#projectNumberItemId').getValue();
		var projectName = form.down('#projectNameItemId').getValue();
		var projectId = form.down('#projectIdItemId').getValue();
		var feeHeadId = form.down('#feeHeadNameItemId').getValue();

		var wsPoetMasterTaskDetails = [];
		var wsPoetMasterContractDetails = [];


		if(type == "add"){
			var taskPanel = form.down('#taskPanelItemId');
			Ext.each(taskPanel.items.items, function(taskPanelItem){
				var taskNumber = taskPanelItem.down('[name=taskNumber]').getValue();
				var taskName = taskPanelItem.down('[name=taskName]').getValue();
				var taskId = taskPanelItem.down('[name=taskIdName]').getValue();

				wsPoetMasterTaskDetails.push({
					"taskNumber": taskNumber,
					"taskName": taskName,
					"taskId": taskId
				});
			});

			var contractDetailsPanel = form.down('#contractDetailsPanelItemId');
			Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
				var contractNumber = contractDetailsPanelItem.down('[name=contractNumber]').getValue();
				var contractName = contractDetailsPanelItem.down('[name=contractName]').getValue();
				var contractId = contractDetailsPanelItem.down('[name=contractId]').getValue();

				var wsPoetMasterContractDetailItem = {
						"contractNumber": contractNumber,
						"contractName": contractName,
						"contractId": contractId,
						"wsPoetMasterContractFundSource": []
				};

				var subContractDetailsPanel = contractDetailsPanelItem.down('panel');

				Ext.each(subContractDetailsPanel.items.items, function(subContractDetailsPanelItem){
					wsPoetMasterContractDetailItem.wsPoetMasterContractFundSource.push({
						"fundingSourceNumber": subContractDetailsPanelItem.down('[name=fundingSourceNumber]').getValue(),
						"fundingSourceName": subContractDetailsPanelItem.down('[name=fundingSourceName]').getValue()
					})
				});
				 if(!isNullOrEmpty(contractNumber) && !isNullOrEmpty(contractName) && !isNullOrEmpty(contractId)){
	                	wsPoetMasterContractDetails.push(wsPoetMasterContractDetailItem);
	                }
			});

			var url = SERVERURL.PATH_SAVE_POET_MASTER_DETAIL;


			var submitJson = {
					"projectNumber": projectNumber,
					"projectName": projectName,
					"projectId": projectId,
					"feeHead": {
						"id": feeHeadId
					},
					"wsPoetMasterTaskDetails": wsPoetMasterTaskDetails,
					"wsPoetMasterContractDetails": wsPoetMasterContractDetails
			};
		}
		else{
			var taskPanel = form.down('#taskPanelItemId');
			Ext.each(taskPanel.items.items, function(taskPanelItem){
				var id = taskPanelItem.fieldDataId;
				var taskNumber = taskPanelItem.down('[name=taskNumber]').getValue();
				var taskName = taskPanelItem.down('[name=taskName]').getValue();
				var taskId = taskPanelItem.down('[name=taskIdName]').getValue();

				wsPoetMasterTaskDetails.push({
					"id": id,
					"taskNumber": taskNumber,
					"taskName": taskName,
					"taskId": taskId
				});
			});

			var contractDetailsPanel = form.down('#contractDetailsPanelItemId');
			Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
				var id = contractDetailsPanelItem.fieldDataId;
				var contractNumber = contractDetailsPanelItem.down('[name=contractNumber]').getValue();
				var contractName = contractDetailsPanelItem.down('[name=contractName]').getValue();
				var contractId = contractDetailsPanelItem.down('[name=contractId]').getValue();

				var wsPoetMasterContractDetailItem = {
						"id": id,
						"contractNumber": contractNumber,
						"contractName": contractName,
						"contractId": contractId,
						"wsPoetMasterContractFundSource": []
				};

				var subContractDetailsPanel = contractDetailsPanelItem.down('panel');

				Ext.each(subContractDetailsPanel.items.items, function(subContractDetailsPanelItem){
					wsPoetMasterContractDetailItem.wsPoetMasterContractFundSource.push({
						"id": subContractDetailsPanelItem.fieldDataId,
						"fundingSourceNumber": subContractDetailsPanelItem.down('[name=fundingSourceNumber]').getValue(),
						"fundingSourceName": subContractDetailsPanelItem.down('[name=fundingSourceName]').getValue()
					})
				});
                if(!isNullOrEmpty(contractNumber) && !isNullOrEmpty(contractName) && !isNullOrEmpty(contractId)){
                	wsPoetMasterContractDetails.push(wsPoetMasterContractDetailItem);
                }
			});

			var url = SERVERURL.PATH_UPDATE_POETMASTERDETAIL;


			var submitJson = {
					"id": poetId,
					"projectNumber": projectNumber,
					"projectName": projectName,
					"projectId": projectId,
					"feeHead": {
						"id": feeHeadId
					},
					"wsPoetMasterTaskDetails": wsPoetMasterTaskDetails,
					"wsPoetMasterContractDetails": wsPoetMasterContractDetails
			};
		}

		Ext.Ajax.request({
			type : 'rest',
			url : url,
			timeout: 9000000,
			method : 'POST',
			jsonData : submitJson,
			success : function(response, action) {
				
				if(!isNullOrEmpty(response.responseText)){
					//need to manage messages here
					showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getExaminationTranslation('RECORD_SAVED_SUCCESSFULLY'));
					
					var grid = me.getPoetmastergrid();

					if(!isNullOrEmpty(grid)){
						grid.getSelectionModel().deselectAll();
						grid.getStore().load();
					}

					me.closePoetDetailFormTab(); 
				}
			}
		});
	},
	closePoetDetailFormTab: function(){
		var me = this;
		
		var tabName = getCommonTranslation('POET_SETUP');
		var contentpanel = this.getContentPanel();
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
	},
	resetPoetSetupForm: function(form){
		var me = this;

		form.down('#projectNumberItemId').reset();
		form.down('#projectNameItemId').reset();
		form.down('#projectIdItemId').reset();
		form.down('#feeHeadNameItemId').reset();
		
		var taskPanel = form.down('#taskPanelItemId');
		Ext.each(taskPanel.items.items, function(taskPanelItem){
			taskPanelItem.down('[name=taskNumber]').setValue('');
			taskPanelItem.down('[name=taskName]').setValue('');
			taskPanelItem.down('[name=taskIdName]').setValue('');
		});

		var contractDetailsPanel = form.down('#contractDetailsPanelItemId');
		Ext.each(contractDetailsPanel.items.items, function(contractDetailsPanelItem){
			contractDetailsPanelItem.down('[name=contractNumber]').setValue('');
			contractDetailsPanelItem.down('[name=contractName]').setValue('');
			contractDetailsPanelItem.down('[name=contractId]').setValue('');

			var subContractDetailsPanel = contractDetailsPanelItem.down('panel');
			Ext.each(subContractDetailsPanel.items.items, function(subContractDetailsPanelItem){
				subContractDetailsPanelItem.down('[name=fundingSourceNumber]').setValue('');
				subContractDetailsPanelItem.down('[name=fundingSourceName]').setValue('');
			});
		});
	}
});
