/**
 * Controller for Scholarship Receipts from scholarship Module.
 * @author Akshay.Kalbhor
 */

Ext.define('Academia.controller.scholarship.ScholarshipReceiptController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['Academia.view.scholarship.scholarshipreceipt.ScholarshipReceipt', 'Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptSearchForm',
            'Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptScreen', 'Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptForm',
            'Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptFormWindow', 'Academia.view.scholarship.scholarshipreceipt.ScholarshipRecieptGrid'],

    stores: ['scholarships.TransactionTypes', 'scholarships.AddAwardeeScholarshipComboStore', 'scholarships.ScholarshipAwardeeListStore',
             'scholarships.AcademyYears', 'scholarships.ScholarshipReceipts','common.UserAccessibleAcademys',
             'organization.academylocations.LocationStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
             'feeandpayment.managebill.ScholarshipSmartSearch','Academia.store.sponsorship.Students','sponsorship.SponsorsNameCodeStore','scholarships.Organizations'],

    mixins: {
        PersonInfoController: 'Academia.controller.personinfo.common.PersonInfoController'
    },
    
    refs: [{
        ref: 'scholarshipReceiptForm',
        selector: 'scholarshipeceiptsearchform form[itemId=scholarshipReceipt]'
    }, {
        ref: 'searchResultGrid',
        selector: 'scholarshipreceipt grid[itemId=scholarshipReceiptGrid]'
    }, {
        ref: 'scholarshipReceiptFormWindow',
        selector: 'scholarshipreceiptformwindow'
    },
    {
   		ref : 'scholarshipRecieptGrid',
   		selector : 'scholarshiprecieptgrid' 
   	},
   	{
   		ref : 'scholarshipreceiptscreen',
   		selector : 'scholarshipreceiptscreen' 
   	}, {
   		ref: 'verticalNavigationMenu',
   		selector: 'verticalNavigationMenu'
   	}],
    
    config: {
        SCHOLARSHIP_RECEIPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_RECEIPT_PRIVILEGES')
    },
    
    init: function(application) {
        this.control({
            'scholarshipreceipt button[itemId=ScholarshipReceiptSearchBtn]': {
                click: function(button) {
                    this.loadGridAndSearchUsers(button)
                },
                render: function(button) {
                    this.loadGridAndSearchUsers(button)
                }
            },
            'scholarshiprecieptgrid button[itemId=btnAdd]': {
                click: this.showReceiptWindow
            },
            'scholarshipreceipt grid[itemId=scholarshipReceiptGrid]': {
                afterrender: function(grid) {
                    this.doAccessControlValidation(grid, this.getSCHOLARSHIP_RECEIPT_PERMISSIONS());
                },
                cellclick: function(view, td, cellIndex, record) {
                    this.studentCodeCellClick(view, td, cellIndex, record);
                }
            },
            'scholarshipreceiptformwindow combo': {
                render: function(cmp) {
                    cmp.getStore().load();
                }
            },
            'scholarshipreceiptformwindow combo[itemId=cmbSelectScholarship]': {
                select: function(combo, records, evts) {
                    var scholarshipId = records[0].get('id');
                    this.validateTransactionAmount();
                    var scholarshipAwardeeCombo = this.getScholarshipReceiptFormWindow().down('#cmbScholarshipAwardee');
                    if (scholarshipAwardeeCombo) {
                        scholarshipAwardeeCombo.getStore().load({
                            params: {
                                id: scholarshipId
                            }
                        });
                    }
                }
            },
            'scholarshipreceiptformwindow numberfield[itemId=transactionAmount]': {
                change: function(field, newValue, oldValue, eOpts) {
                	this.validateTransactionAmount();
                }
            },
            'scholarshipreceiptformwindow datefield[itemId=transactionDate]': {
                change: function(field, newValue, oldValue, eOpts) {
                	this.validateInstrumentDate();
                }
            },
            'scholarshipreceiptformwindow button[itemId=btnCancelScholarshipReceiptForm]': {
                click: function(button) {
                    this.getScholarshipReceiptFormWindow().close();
                }
            },
            'scholarshipreceiptformwindow button[itemId=btnSaveScholarshipReceiptForm]': {
                click: this.saveReceipt
            },
            'scholarshipreceiptform combo[itemId=cmbTransactionType]': {
             	
                focus: function(combo) {
                    var store = combo.getStore(); 
                    var filterItemIds = ['ADJ'];
        	        var storeItems = store.getRange()
        
                    for(var i = 0; i<storeItems.length; i++){     
                            if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
                            store.remove(store.getById(storeItems[i].get('id')));            
                       }
                },
                select: function(combo, records, eOpts) {
                    var scholarshipTransactionCombo = this.getScholarshipReceiptFormWindow().down('#cmbTransactionType');
                    
                    var scholarshipCombo = this.getScholarshipReceiptFormWindow().down('#cmbSelectScholarship');
                    var voucherReferenceTxtBox = this.getScholarshipReceiptFormWindow().down('#voucherReference');
                    var transactionDate = this.getScholarshipReceiptFormWindow().down('#transactionDate');
                    var instrumentNo = this.getScholarshipReceiptFormWindow().down('#instrumentNo');
                    var instrumentDate = this.getScholarshipReceiptFormWindow().down('#instrumentDate');
                    var instrumentDrawnOn = this.getScholarshipReceiptFormWindow().down('#instrumentDrawnOn');
                    var transactionAmount = this.getScholarshipReceiptFormWindow().down('#transactionAmount');
                    var scholarshipId = scholarshipCombo.getValue();
                    if(!isNullOrEmpty(scholarshipId)){
                    	var scholarshipRecord = scholarshipCombo.getStore().getById(scholarshipId);
                        var disbursementMode = scholarshipRecord.get('disbursementMode');
                        if (!isNullOrEmpty(disbursementMode) && disbursementMode === 'DIR' && scholarshipTransactionCombo.getValue() === 'RCT') {
                            voucherReferenceTxtBox.setDisabled(true);
                        }
                    }
                    this.validateInstrumentDate();
                    
                }
            },

            'scholarshiprecieptgrid button[itemId=btnView]': {
                click: this.viewTransaction
            },
            'scholarshiprecieptgrid':{
            	afterrender:function(structure){
   				 var $this = this;
   				 var structure =$this.getScholarshipreceiptscreen();
   				 structure.body.on('scroll', function(e, target) {
   					 var grid = $this.getScholarshipRecieptGrid();
   					 if(grid!=null){
   						 $this.getMultipleGridHeaderFreeze(grid,structure,true); 
   					 }
   				 });
   			 }
            	
            },

            'scholarshipeceiptsearchform': {
                render: function(obj) {
                	var studentId =obj.down('#studentId');
                	studentId.getStore().getProxy().extraParams={
                		restrictToAL:true
                	};
                	studentId.getStore().load();
                }
            },
            
             'scholarshipeceiptsearchform  combo[itemId=organizationItemId]':{
            	render:function(combo){
            		combo.getStore().load({
            			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	}
            },
            'scholarshipeceiptsearchform combo[itemId=transactionType]': {
                render: function(combo) {
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            var model = new Academia.model.common.IdValueDataModel();
                            model.set('id', null);
                            model.set('value', getCommonTranslation('ALL'));
                            combo.getStore().add(model);
                        }
                    });
                }
            },

            'scholarshipeceiptsearchform combo[itemId=academyYear]': {
                render: function(combo) {
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            var model = new Academia.model.common.IdValueDataModel();
                            model.set('id', '');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }
                    });
                }
            }

        });
    },


    /**
     * method to load the scholarship Receipt grid.
     * called on render of the receipt screen and on click of the search button.
     * checks for the disbursement mode radio and changes the URL accordingly.
     * @Param {Object} btn: The reference of the Search Button.
     * @author Akshay.Kalbhor 
     */
    loadGridAndSearchUsers: function(btn) {
        var searchForm = this.getScholarshipReceiptForm();
        var searchCriteria = searchForm.getValues();
        searchCriteria.locationIds = this.getCurrentAcademyLocation();
        if (isNullOrEmpty(searchCriteria.transactionType) || searchCriteria.transactionType== getCommonTranslation('ALL')) {
            searchCriteria.transactionType = null;
        }
        var receiptsGrid = this.getSearchResultGrid();
        var receiptsStore = receiptsGrid.getStore();
        if (searchCriteria.disbursementMode) {
            var url = SERVERURL.SCHOLARSHIP_RECEIPT_LISTING;
            receiptsStore.getProxy().api.read = url;
            receiptsStore.getProxy().extraParams = searchCriteria;
            receiptsStore.reload({
        		callback: function(record, operation, success) {
    	    			var gridColumns=receiptsGrid.columns;
    		 				 var length = gridColumns.length;
    		 				 if(length!=null && length!=""){
    		 					 for(var i=0; i<length; i++){
    		 						 if(gridColumns[i].dataIndex=='conversionRate' || gridColumns[i].dataIndex=='acadLocBaseCurrencyAmount'){
    		 							 gridColumns[i].setVisible(false);
    		 						 }
    		 					 }
    		 				 }	
    			}
        	});
        } else {
            var url = SERVERURL.SCHOLARSHIP_RECEIPT_LISTING_FP;
            receiptsStore.getProxy().api.read = url;
            receiptsStore.getProxy().extraParams = searchCriteria;
            receiptsStore.reload({
        		callback: function(record, operation, success) {
    				if(record[0].data.isMultiCurrency==true){
    	    			var gridColumns=receiptsGrid.columns;
    		 				 var length = gridColumns.length;
    		 				 if(length!=null && length!=""){
    		 					 for(var i=0; i<length; i++){
    		 						 if(gridColumns[i].dataIndex=='conversionRate' || gridColumns[i].dataIndex=='acadLocBaseCurrencyAmount'){
    		 							 gridColumns[i].setVisible(true);
    		 						 }
    		 					 }
    		 				 }	
    				}
    			}
        	});
        }
    },

    /**
     * Method to show the Reciept Form Window
     * @author Akshay.Kalbhor
     */
    showReceiptWindow: function() {
        var window = this.getScholarshipReceiptFormWindow();
        if (!window) {
            window = Ext.widget('scholarshipreceiptformwindow');
        }
        window.show();
        this.getVerticalNavigationMenu().collapse();
    },

    /**
     * Method to Save the receipt on click of Save button on the Add receipt screen.
     * @author Akshay.Kalbhor
     */
    saveReceipt: function() {
    	var this$ = this;
        var scholarshipReceiptFormWindow = this.getScholarshipReceiptFormWindow();
        var searchResultGrid = this.getSearchResultGrid();
        var scholarshipReceiptForm = scholarshipReceiptFormWindow.down('#scholarshipReceiptForm');

        var formData = scholarshipReceiptForm.getValues();
        if (!isEmpty(formData)) {
            if (!isNullOrEmpty(formData.scholarshipId)) {
                delete formData.scholarshipId;
            }

            var jsonFormatFormData = Ext.encode(formData);
            var scholarshipTransactionCombo = this.getScholarshipReceiptFormWindow().down('#cmbTransactionType');
            var scholarshipCombo = this.getScholarshipReceiptFormWindow().down('#cmbSelectScholarship');
            var scholarshipValue = scholarshipCombo.getValue();
            var scholarshipRecord = scholarshipCombo.getStore().getById(scholarshipValue);
            var disbursementMode = scholarshipRecord.get('disbursementMode');
            if (!isNullOrEmpty(disbursementMode) && disbursementMode === 'ACD' && scholarshipTransactionCombo.getValue() === 'ISS') {
                showInfoMessage(getCommonTranslation('ADD_TRANSACTION'), getCommonTranslation('USE_FEE_PMNT'));
            } else {
            	 this$.applyWindowMask(); 
            	 
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SCHOLARSHIP_TRANSACTION_CREATE,
                    jsonData: jsonFormatFormData,
                    method: 'POST',
                    success: function(form, action) {
                    	 this$.hideWindowMask();
                        scholarshipReceiptFormWindow.close();
                        searchResultGrid.getStore().reload();
                        searchResultGrid.getSelectionModel().deselectAll();
                        showSuccessMessage(getCommonTranslation('ADD_TRANSACTION'), getCommonTranslation('ADD_TRANSACTION_MSG')); //Transaction details added successfully												                
                    },
                    failure: function(form, action) {
                    	 this$.hideWindowMask();
                        scholarshipReceiptFormWindow.close();
                        searchResultGrid.getStore().reload();
                    }
                });
            }
        }
    },

    /**
     * Method to display the receipt record in the view mode.
     * @author Akshay.Kalbhor
     */
    viewTransaction: function(isView) {
        var me = this;
        var grid = me.getSearchResultGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isNullOrEmpty(records.data.id)) {
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SCHOLARSHIP_TRANSACTION_FIND_BY_ID,
                    method: 'GET',
                    params: {
                        id: records.data.id
                    },
                    success: function(form, action) {
                        var formDataObject = eval("(" + form.responseText + ")");
                        me.showReceiptWindow();
                        var scholarshipReceiptWindow = me.getScholarshipReceiptFormWindow();
                        var scholarshipReceiptForm = scholarshipReceiptWindow.down('#scholarshipReceiptForm');
                        scholarshipReceiptForm.getForm().setValues(formDataObject);
                        scholarshipReceiptWindow.down('#btnSaveScholarshipReceiptForm').setVisible(false);
//                        scholarshipReceiptForm.down('#cmbSelectScholarship').setVisible(false);
                        if (!isNullOrEmpty(formDataObject.scholarshipAwardeeId)) {
                            var awardeeCombo = scholarshipReceiptForm.down('#cmbScholarshipAwardee');
                            awardeeCombo.getStore().load({

                                callback: function(records, operation, success) {
                                    awardeeCombo.setValue(formDataObject.scholarshipAwardeeId);
                                }
                            });
                        }
                        toggleReadOnlyFormItems(scholarshipReceiptForm.getForm(), true);
                        
                        var transDate = scholarshipReceiptForm.down('#transactionDate');
                        transDate.setValue(dateRender(formDataObject.transactionDate));
                        
                        var instrumentDate = scholarshipReceiptForm.down('#instrumentDate');
                        instrumentDate.setValue(dateRender(formDataObject.instrumentDate));
                        
                    }
                });
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /**
     * Method to show the window containing the addAwardee form.
     * @author Akshay.Kalbhor
     */
    showRecieptWindow: function() {
        var window = this.getAddAwardeeWindow();
        if (!window) {
            window = Ext.widget('addawardee');
        }
        window.show();
    },

    /**
     * Method to open the Student profile on click of the StudentId.
     * Method checks if the Click has been done in the cell of student code and processes it.
     * @author Akshay.Kalbhor
     */
    studentCodeCellClick: function(view, td, cellIndex, record) {
        var this$ = this;
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        if (columnName == "studentCode") {
            var tabTitle = record.get('studentCode');
            var personId = record.raw.personId;
            var userId = record.get('userId');
            var programBatchSeatTypeConfigId = record.get('programBatchSeatConfigId');
            this$.mixins.PersonInfoController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId,null,null,CONSTANTS.MENU_COLOR_TEN);
        } else if(columnName == "scholarshipCode") {
        	this.viewScholarship(view, td, cellIndex, record);
        }
        return false;
    },
    
    /**
     * @method
     * method to make a call for fetching the data related of a scholarship.
     * @author Akshay.Kalbhor
     */
    viewScholarship: function(grid, td, cellIndex, record) {
    	var this$$= this;
    	var tabName = getCommonTranslation('VIEW_SCHOLARSHIP');
    	var addScholarshipFormWindow = this.openTab(tabName, 'addscholarship',CONSTANTS.MENU_COLOR_TEN);
    	this.toggleReadOnlyFormItems(addScholarshipFormWindow.getForm(), true);

    	addScholarshipFormWindow.down('#addScholarshipBtn').setVisible(false);
    	addScholarshipFormWindow.down('#resetButtonId').setVisible(false);
    	var id = record.get('scholarshipId');

    	Ext.Ajax.request({
    		type: 'rest',
    		url: SERVERURL.SCHOLARSHIP_URL,
    		method: 'GET',
    		params: {
    			id: id
    		},
    		success: function(res, action) {
    			var data = Ext.decode(res.responseText);
    			this$$.loadScholarshipDetailsForm(data, tabName);
    		}
    	});
    },
    
    /**
     * Method to load the data into the form
     * @author Akshay.Kalbhor
     */
    loadScholarshipDetailsForm: function(data, tabName) {
        if (data) {
            var form = this.getTabReferenceByTabTitle(tabName).getForm();
            form.setValues(data);
        }
    },
    /**
     * Method to validate the transaction amount with scholarship amount
     * @author Sachin.Bangar
     */
    validateTransactionAmount: function(){
    	var scholarshipReceiptForm = this.getScholarshipReceiptFormWindow().down('#scholarshipReceiptForm');
    	var cmbSelectScholarship = scholarshipReceiptForm.down('#cmbSelectScholarship');
    	var transactionAmountField = scholarshipReceiptForm.down('#transactionAmount');
        var scholarshipId = cmbSelectScholarship.getValue();
        var transactionAmount = transactionAmountField.getValue();
        if (!isNullOrEmpty(scholarshipId)) {
        	var record = cmbSelectScholarship.findRecordByValue(scholarshipId);
        	if(!isEmpty(record) && !isNullOrEmpty(record.get('amount'))){
        		if(transactionAmount > record.get('amount')){
        			transactionAmountField.setValue('');
        			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TRANSACTION_AMOUNT_EXCEED_LIMIT'));
        		}
        	}
        }
    },
    
    /**
     * Method to validate the transaction amount with scholarship amount
     * @author Sachin.Bangar
     */
    validateInstrumentDate: function(){
    	var scholarshipReceiptForm = this.getScholarshipReceiptFormWindow().down('#scholarshipReceiptForm');
    	var cmbTransactionType = scholarshipReceiptForm.down('#cmbTransactionType');
    	var transactionDateField = scholarshipReceiptForm.down('#transactionDate');
    	var instrumentDateField = scholarshipReceiptForm.down('#instrumentDate');
    	var transactionType = cmbTransactionType.getValue();
    	var transactionDate = transactionDateField.getValue();
    	var instrumentDate = instrumentDateField.getValue();
    	if(!isNullOrEmpty(transactionType) && !isNullOrEmpty(transactionDate) && transactionType == 'RCT'){
    		instrumentDateField.setMaxValue(transactionDate);
    	}else{
    		instrumentDateField.setMaxValue(null);
    	}
    	if(!isNullOrEmpty(instrumentDate)){
    		instrumentDateField.validate();
    	}
    }
});
