/**
 * @author Pritam.Patil
 * This is used for never Locked User Functionality
 */
Ext.define('Academia.controller.securitysetup.unlockUser.NeverLockUserController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['securitysetup.unlockuser.NeverLockedUserPanel', 'securitysetup.unlockuser.NeverLockedUserSearchForm',
            'securitysetup.unlockuser.NeverLockedUserView'],

    stores: ['common.AllActiveAcademyLocationStore', 'securitysetup.unlockUser.userBelongsToStore',
             'common.AssignedAcademyLocations'],

    refs: [{
        ref: 'neverlockForm',
        selector: 'neverlockedusersearchform[itemId=neverLockedUserSearchForm]'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=neverLockedUserGrid]'
    }],
    requires:['Academia.constants.ServiceRequestConstants'],
    config: {
    	NEVER_LOCKED_USER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NEVER_LOCKED_USER_PRIVILEGES')
    },
    init: function(application) {
        this.control({

            'neverlockedusersearchform  button[itemId=neverLockedUserSearchButtonId]': {
                click: this.loadGridAndSearchUsers,
                //render: this.loadGridAndSearchUsers
            },
            'neverlockedusersearchform[itemId=neverLockedUserSearchForm] button[itemId=neverLockedUserClearSearchBtn]': {
                click: this.clearSearchForm
            },
            'searchresultgrid[itemId=neverLockedUserGrid]': {
            	afterrender: function(grid) {
            		this.loadGridAndSearchUsers();
 					this.gridRenderFunction(grid);
 				}
            },
            'neverlockeduserpanel grid[itemId=neverLockedUserGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getNEVER_LOCKED_USER_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
            },
            /*FixingHeaderColumn*/
            'neverlockeduserpanel':{
				afterrender : function(structure){
					var grid = structure.down('searchresultgrid');
					this.getGridHeaderFreeze(grid,structure);
				}
     		},
            /**** Export button for currently locked user ******/
	        'searchresultgrid[itemId=neverLockedUserGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportNeverLockedUser(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=neverLockedUserGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportNeverLockedUser(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=neverLockedUserGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportNeverLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=neverLockedUserGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportNeverLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        }
            
        });
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
  
    exportNeverLockedUser : function(exportUrl,filetype,whetherAll,requestType) {
	   	 var quickSearchForm=this.getNeverlockForm();
	   	 var searchResultGrid = this.getSearchResultGrid();	
	   	 var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
         var reportTitle=getCommonTranslation('NEVER_LOCKED_USER');
	   	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	   	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	   	var me=this;
	       var formValues = new Array();
	       formValues = searchForm.getValues();        
	       var searchCriteriaString="";
	       for (var key in formValues) {
	       	var value = formValues[key];            
	           if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	               var keyValueJsonObject = me.getJsonObject( key , value);
	   	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	           }
	       }
	       searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	       return searchCriteriaString;
	   },
  
	   gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	   },
	   
    /**
     * This is used to load search result grid
     * @param model
     * @param records
     */
    loadGridAndSearchUsers: function(model, records) {

        var neverviewForm = this.getNeverlockForm();
        var jsonFormatFormData = this.createJsonFormat(neverviewForm);
        var searchResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.NEVER_LOCKED_USER_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(neverviewForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.NEVER_LOCKED_USER_BASIC_CONFIGCODE;

        formValues = neverviewForm.getValues();

        var radioValue = neverviewForm.getForm().getValues()['USERS_GROUP_NAME'];
        var serviceRequestConstants = this.getServiceRequestConstant();
        var userGroupStudentId= serviceRequestConstants.getRequestStatus('USER_GROUP_STUDENT_ID');
        
        if (radioValue === 'Student') {
        	formValues.USER_GROUP_ID = userGroupStudentId;
            var USER_GROUP_ID = this.getJsonObject('USER_GROUP_ID',formValues.USER_GROUP_ID);
            this.pushJsonObjectInArray(USER_GROUP_ID, searchcriteria);
        }
        
        delete formValues.USER_GROUP_NAME;

        var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', formValues.ACADEMY_LOCATION_ID);
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
        
        if(formValues.USER_BELONGS_TO !== 'all'){
       	 var USER_BELONGS_TO	= this.getJsonObject('USER_BELONGS_TO',formValues.USER_BELONGS_TO);
            this.pushJsonObjectInArray(USER_BELONGS_TO, searchcriteria);
       } 

        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value !=='' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This method is used to clear fields on User Frequency search Form
     * @param button which is reference of buttton
     */
    clearSearchForm: function(button) {

        form = button.up('form').getForm();
        form.getFields().each(function(field) {
            field.reset();
        });
    },
    /**
	  * This method is use to get the reference to the service request  constants file 
	  */
	 getServiceRequestConstant:function() {
		 var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
		 return serviceRequestConstant;
	 }

});