/**
 * This controller is used for scholarship request functionality
 */
Ext.define('Academia.controller.servicerequest.PersonalDataChangeRequestController', {
    extend: 'Academia.controller.servicerequest.ServiceRequestController',
    mixins: {
        AddressController: 'Academia.controller.organization.AddressController',
        PersonInfoController: 'Academia.controller.personinfo.common.PersonInfoController'
    },
    views: [ /* Person Data Change Request view */

    'servicerequest.personaldatachangerequest.PersonRequestDetailsPanel', 'servicerequest.personaldatachangerequest.datatobechanged.CommonWindow',

    'servicerequest.personaldatachangerequest.datatobechanged.CommonTabPanel', 'servicerequest.personaldatachangerequest.datatobechanged.ContactDetailsForm',

    'servicerequest.personaldatachangerequest.datatobechanged.PersonalDetailFormPanel', 'personinfo.common.personalinfo.PersonalInformationForm',

    'servicerequest.personaldatachangerequest.datatobechanged.PersonalAddressDetailFormPanel',
    
    'personinfo.common.pasthistory.MedicalHistoryForm', 'servicerequest.personaldatachangerequest.datatobechanged.MedicalHistoryPanel',

    'servicerequest.personaldatachangerequest.datatobechanged.WorkExperienceDetailsPanel', 'personinfo.common.pasthistory.WorkExperienceForm',

    'servicerequest.personaldatachangerequest.datatobechanged.EducationDetailsForm', 'servicerequest.personaldatachangerequest.datatobechanged.EducationDetailPanel',

    'servicerequest.personaldatachangerequest.datatobechanged.VaccinationDetailsPanel', 'personinfo.common.pasthistory.VaccinationForm',

    'servicerequest.personaldatachangerequest.datatobechanged.ExtraCurricularDetailsPanel', 'personinfo.common.pasthistory.ExtraCurricularForm',

    'servicerequest.personaldatachangerequest.datatobechanged.SiblingDetailsPanel', 'personinfo.common.personalinfo.SiblingForm',

    'personinfo.common.personalinfo.ParentGuardianForm', 'servicerequest.personaldatachangerequest.datatobechanged.ParentGuardianDetailPanel',
    
    'personinfo.student.StudentUploadPhotoWindow'

    ],

    stores: [ /*person data change request store*/ 'servicerequest.personaldatachangerequest.Details', 'servicerequest.personaldatachangerequest.StakeHolders', 'servicerequest.personaldatachangerequest.AddressTypeStore',

    'servicerequest.personaldatachangerequest.SiblingNameStore', 'servicerequest.personaldatachangerequest.MedicalConditionStore', 'servicerequest.personaldatachangerequest.WorkExperienceEmployerStore',

    'servicerequest.personaldatachangerequest.VaccinationNameStore', 'servicerequest.personaldatachangerequest.ExamPassedComboStore',

    'servicerequest.personaldatachangerequest.ActivityNameComboStore','personinfo.common.personalinfo.HaveDisibilitiesStore'],

    refs: [{
        ref: 'commonTabPanel',
        selector: 'commontabpanel'
    }, {
        ref: 'commonWindow',
        selector: 'commonwindow'
    }, {
        ref: 'personRequestDetailsPanel',
        selector: 'personrequestdetailspanel'
    }, {
        ref: 'personSiblingForm',
        selector: 'siblingform'
    }, {
        ref: 'personalDetailsRequestForm',
        selector: 'personaldetailformpanel personaldetailsform[itemId=personalDetailsRequestForm]'
    }, {
        ref: 'addressFieldRequestForm',
        selector: 'addressfieldsform[itemId=addressFieldRequestForm]'
    }, {
        ref: 'siblingDetailsPanel',
        selector: 'siblingdetailspanel'
    }, {
        ref: 'parentGuardianRequestForm',
        selector: 'parentguardianform[itemId=parentGuardianRequestForm]'
    }, {
        ref: 'parentGuardianDetailPanel',
        selector: 'parentguardiandetailpanel'
    }, {
        ref: 'medicalHistoryPanel',
        selector: 'medicalhistorypanel'
    }, {
        ref: 'workExperiencePanel',
        selector: 'workexperiencepanel'
    }, {
        ref: 'vaccinationDetailsPanel',
        selector: 'vaccinationdetailspanel'
    }, {
        ref: 'educationDetailPanel',
        selector: 'educationdetailpanel'
    }, {
        ref: 'extraCurricularDetailsPanel',
        selector: 'extracurriculardetailspanel'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref:'personalinformationform',
    	selector:'personalinformationform'
    },{
    	ref: 'studentuploadphotowindow',
		selector: 'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow]'
    }],
    init: function(application) {
        this.control({
        	
        	/*Student Current Profile Photo Pop up*/
        	
        	'commonwindow personaldetailformpanel personalinformationform container[itemId=profile_image_icon]': {
				  afterrender: function(container) {
				       container.getEl().on('click', this.openPhotoUploadPopup, this);
				  }
			},
			
			'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[name=btnEdit]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
//				        var btnSave = window.down('button[name=btnSave]');
				        
				        // Hide Edit and Remove buttons
				        btnEdit.setVisible(false);
				        btnRemove.setVisible(false);
				        btnCancel.setVisible(false);
//				        btnSave.setVisible(false);
				        
				        // Show Upload Photo and Take a Photo buttons
				        btnUploadPhoto.setVisible(true);
				        btnTakePhoto.setVisible(true);
				        btnBack.setVisible(true);
				   }
			   },
			   
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[name=btnBack]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
					   	window.down('#profile_image_containerBox').destroy();
					   	window.down('#profileRoatateImageIconId').hide();
					   	window.down('#profileImageFormItemId').insert(0,{
					   		// Profile Image Container
					   		xtype: 'container',
					   		width: 320,
					   		height: 280,
					   		layout: {
					   			type: 'vbox',
					   			align: 'center',
					   			style: {
					   				position: 'relative',
					   			}
					   		},
					   		itemId: 'profile_image_containerBox',
					   		items: [{
					   			xtype: 'image',
					   			itemId: 'profile_image',
					   			border: 1,
					   			style: {
					   				borderColor: '#e0e0e0',
					   				borderStyle: 'solid',
					   				borderRadius: '50%',
					   				marginTop:'67px !important'
					   			},
					   			width: 210,
					   			height: 210,
					   			src: 'resources/images/default-profile.png',
//					   			margin: '0 0 3 0', // Adds spacing around the image
					   		},{
					   			xtype: 'hidden',
					   			name: 'isImageRemoved',
					   			itemId: 'isImageRemovedItemId'
					   		}]
					   	},
					   	{
					   		id:'capture_panel',
					   		itemId:'capturePanelId',
					   		hidden:true,
					   		listeners:{
					   			show:function(obj){
					   				Webcam.set({
					   					width: 320,
					   					height: 240,
					   					crop_width: 320,
					   					crop_height: 240,
					   					flip_horiz: true,
					   					image_format: 'jpeg', // image format (may be jpeg or png)
					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					   				});
					   				Webcam.attach('#capture_panel-innerCt');
					   			},
					   			hide: function () {
					   				Webcam.reset();
					   			}
					   		}
					   	},{
					   		xtype:'panel',
					   		itemId:'previewPanelId',
					   		hidden:true
					   	},{
					   		xtype:'panel',
					   		hidden:true,
					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
					   	},
					   	// Button Container for Profile Actions
					   	{
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			align: 'middle',
					   			//pack: 'center',
					   		},
					   		margin: '20 0 0 0', // Adds spacing above the buttons
					   		/*defaults: {
					labelAlign: 'top',
					margin: '0 5', // Adds spacing between buttons
				},*/
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('EDIT'),
					   			name: 'btnEdit',
					   			itemId: 'btnEditItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			style: {
					   				width: "60px !important",
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('REMOVE'),
					   			name: 'btnRemove',
					   			itemId: 'btnRemoveItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		},{
					   			xtype: 'filefield',
					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
					   			name: 'file',
					   			itemId: 'btnUploadPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			buttonOnly: true
					   		}, {
					   			xtype: 'hidden',
					   			name: 'name',
					   			itemId: 'fileName'
					   		}, {
					   			xtype: 'hidden',
					   			name: 'personId',
					   			itemId: 'personId'
					   		}, {
					   			xtype: 'button',
					   			text: getCommonTranslation('TAKE_A_PHOTO'),
					   			name: 'btnTakePhoto',
					   			itemId: 'btnTakePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('CAPTURE'),
					   			name: 'capturePhoto',
					   			itemId: 'capturePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('RESET'),
					   			name: 'resetPhoto',
					   			itemId: 'resetPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		}]
					   	},
					   	{
					   		xtype: 'button',
					   		cls: 'profileRoatateImageIcon',	
					   		itemId: 'profileRoatateImageIconId',
					   		hidden: true,
					   		rotate: 0.1
					   	},{
					   		// Footer Button Container
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			pack: 'space-between',
					   			//align: 'middle'
					   		},
					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
					   		width: '100%',
					   		defaults: {
					   			//flex: 1,
					   			//margin: '0 100',
					   		},
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('CANCEL'),
					   			name: 'btnCancel',
					   			itemId: 'btnCancelItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,	
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('BACK'),
					   			name: 'btnBack',
					   			itemId: 'btnBackItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   		},{
					   			xtype: 'component', 
					   			flex: 2
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('SAVE'),
					   			name: 'btnSave',
					   			itemId: 'btnSaveItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		}]
					   	});
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
//				        var btnSave = window.down('button[name=btnSave]');
				        var capturePhoto = window.down('#capturePhotoItemId');
 					   	var resetPhoto = window.down('#resetPhotoItemId');
 					   	var profileImage = window.down('#profile_image');
 					   	var capturePanel = window.down('#capturePanelId');
 					   	var previewPanelId = window.down('#previewPanelId');
 					    var btnSave = window.down('button[name=btnSave]');
 					    
 					   if (window.lastSavedImageUrl) {
                           profileImage.setSrc(window.lastSavedImageUrl);
                       } else {
                           profileImage.setSrc('resources/images/default-profile.png');
                       }
 					   
 					// Restore the previous image if available
				        if (window.previousProfileImage) {
				            profileImage.setSrc(window.previousProfileImage);
				            profileImage.setVisible(true);
				        }
				        
				        // Reset the file field so it detects the same image when uploaded again
	                       btnUploadPhoto.reset();
 					   	
				        btnEdit.setVisible(true);
				        btnRemove.setVisible(true);
				        btnCancel.setVisible(true);
//				        btnSave.setVisible(true);
				        profileImage.setVisible(true);
				        
				        btnUploadPhoto.setVisible(false);
				        btnTakePhoto.setVisible(false);
				        btnBack.setVisible(false);
				        capturePhoto.setVisible(false);
 					   	resetPhoto.setVisible(false);
 					   	capturePanel.setVisible(false);
 					    previewPanelId.setVisible(false);
 					    btnSave.setDisabled(true);

 					    
 					   // Re-enable capture/reset buttons for future actions
				        capturePhoto.setDisabled(false);
				        resetPhoto.setDisabled(true);
				        window.down('#btnUploadPhotoItemId').reset();
				       
				   }
			   },
			   
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[name=btnCancel]': {
				   click: function(button) {
					   var window = this.getStudentuploadphotowindow();
					   window.close();
				   }
			   },
			   
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=btnTakePhotoItemId]': {
				   click: function(button) {
					   this.openCapturePhoto();
				   }
			   },
			   
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow]' : {
					close : function(obj){
						Webcam.userMedia=true;
						Webcam.reset();
					}
				},
				
				'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=capturePhotoItemId]': {
 				   click: function(button) {
 					   this.captureUserPhoto(button);
 				   }
 			   },
			   
 			  'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=resetPhotoItemId]': {
                  click: function(button) {
                      var window = this.getStudentuploadphotowindow();
                      window.down('#capturePanelId').setVisible(true);
                      window.down('#previewPanelId').setVisible(false);
                      window.down('#previewPanelId').update('');
                      window.down('#capturePhotoItemId').setDisabled(false);
                      window.down('#resetPhotoItemId').setDisabled(true);
                      window.down('#btnSaveItemId').setDisabled(true);
                      window.cropData = null;
                      window.component = null;
                  }
              },
              
              'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] filefield[itemId=btnUploadPhotoItemId]': {
				   change: this.uploadProfilePhoto
			   },
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=btnSaveItemId]': {
				   click: this.uploadCapturedImage
			   },
			   'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=btnRemoveItemId]': {
				   click:this.removeUploadCapturedImage
			   },
        	
            /* Request tab panel */'personrequestdetailspanel nestedJsonCombo[itemId=dataChangedComboField]': {
                afterrender: this.loadDataChangedComboStore,
                select: function(cmb, records) {
                    this.onSelectionShowPersonalDetailsForm(cmb, records);
                }
            },
            'personrequestdetailspanel button[itemId=clearBtn]': {
                click: function() {
                    this.onClickClearDataToBeChangedField();
                }
            },
            'personrequestdetailspanel label[itemId= showDetailsLink]': {
                render: function(component) {
                    var this$ = this;
                    var isOpenFromShow = true;
                    component.getEl().on('click', function(e) {
                        this$.onClickShowDetailsLinkPanel(isOpenFromShow);
                    });
                }
            },
            'personrequestdetailspanel combo[itemId=stakeHolderTypeId]': {
                select: this.onStackHolderComboSelection
            },

            /*
             *  Personal Details & Address Form 
             */
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] combo': {
                render: function(combo) {
                    combo.getStore().load();
                }
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                	this.validateUploadPhotoImageExtension(photoFileImage);
                }
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] button[itemId=stopBtn]': {
            	click: function(obj){
    				this.addMultipleLanguage(obj);
    			}          
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] button[itemId=languageDeleteButton1]':{
    			click : function(deleteButton) {
   				 	this.deleteLanguageCompentecny(deleteButton);
   			 	}
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] [itemId=employeeLanguage]': {
            	select: function(combo, record) {
                	var currentForm = this.getCommonWindow().down('#currentForm');
    	            var form = currentForm.down('#personalInformationRquestForm');
                    this.onSelectionLanguage(combo, record,form);
            	}               
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] customcombobox[itemId=cellCountryCode]': {
            	select: function(rowModel, record){
    				var this$ = this;
    				var currentForm = this$.getCommonWindow().down('#currentForm');
    	            var form = currentForm.down('#personalInformationRquestForm');
                	var countryCodeField = form.down("#cellCountryCode");
                 	var mobileField = form.down("#mobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			}
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] numberfield[itemId=mobileNumber]': {
            	change: function(record){
    				var this$ = this;
    				var currentForm = this$.getCommonWindow().down('#currentForm');
    	            var form = currentForm.down('#personalInformationRquestForm');
                	var mobileField = form.down("#mobileNumber");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] textfield[itemId=birthDateId] ':
        	{
        	 change : function(obj,record)
        	 {
        		 var $this = this;
                 var form = obj.up('personalinformationform');
                 var ageData =form.down("#ageId");
                  var currentYear = new Date(record);
                 var todayDate = new Date();
                  var calculateAge =todayDate.getFullYear()-currentYear.getFullYear();
                  if (form.down("#birthDateId").isValid()){
                 if (todayDate.getMonth() < currentYear.getMonth() || (todayDate.getMonth() === currentYear.getMonth() && todayDate.getDate() < currentYear.getDate())) {
                     calculateAge--;
                 }}
                  else
                      {
                          calculateAge = 0;
                      }
                  //ageData.setValue(calculateAge);
                  
                  //ageData.setReadOnly(true);
        	 }
        	},
        	'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#stuPermanentResItemId':{
           	 change:function(obj,newValue,oldValue){
           		 var  $this = this;
           		 var form = obj.up('personalinformationform');
           		 var value = newValue.isPermanentResident;
           		 $this.SAValueValidationOnPersonalForm(form,value);
           		 
           	 }
     		 },
     		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#stuAsylumSeekerItemId':{
           	 change:function(obj,newValue,oldValue){
     				 var form = obj.up('personalinformationform');
     				 var value = newValue.isAsylumSeeker;
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
     				 var diplomaticStatusId = form.down("#diplomaticStatusId");
     				 var temporaryStudyId = form.down("#temporaryStudyId");
     				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
     				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAreYouRefugeeItemId.items.items[0].setValue(false);
     					stuAreYouRefugeeItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					
     					stuPermanentResItemId.setDisabled(true);
     					stuAreYouRefugeeItemId.setDisabled(true);
     					diplomaticStatusId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					workCriticalSkillsId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAreYouRefugeeItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					diplomaticStatusId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					workCriticalSkillsId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
     		 },
     		 'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#temporaryStudyId':{
     			 change:function(obj,newValue,oldValue){    
     				 var form = obj.up('personalinformationform');
      				 var value = newValue.temporaryStudy;
      				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
      				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
      				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
      				 var diplomaticStatusId = form.down("#diplomaticStatusId");
      				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
      				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
      				 if(!isNullOrEmpty(value)){
      				 if(value==true){
      					stuAsylumSeekerItemId.items.items[0].setValue(false);
      					stuAsylumSeekerItemId.items.items[1].setValue(true);
      					stuPermanentResItemId.items.items[0].setValue(false);
      					stuPermanentResItemId.items.items[1].setValue(true);
      					stuAreYouRefugeeItemId.items.items[0].setValue(false);
      					stuAreYouRefugeeItemId.items.items[1].setValue(true);
      					
      					stuAreYouRefugeeItemId.setDisabled(true);
      					stuPermanentResItemId.setDisabled(true);
      					stuAsylumSeekerItemId.setDisabled(true);
      					diplomaticStatusId.setDisabled(true);
      					workCriticalSkillsId.setDisabled(true);
      					postgraduateNonResidentialStudentId.setDisabled(true);
      				 }else{
      					stuAsylumSeekerItemId.setDisabled(false);
      					stuPermanentResItemId.setDisabled(false);
      					stuAreYouRefugeeItemId.setDisabled(false);
      					diplomaticStatusId.setDisabled(false);
      					workCriticalSkillsId.setDisabled(false);
      					postgraduateNonResidentialStudentId.setDisabled(false);
      				 }
      				 }
      			 }
      		 },
      		 'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#stuAreYouRefugeeItemId':{
            	 change:function(obj,newValue,oldValue){    
    				 var form = obj.up('personalinformationform');
     				 var value = newValue.areYouRefugee;
     				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				 var diplomaticStatusId = form.down("#diplomaticStatusId");
     				 var temporaryStudyId = form.down("#temporaryStudyId");
     				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
     				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAsylumSeekerItemId.items.items[0].setValue(false);
     					stuAsylumSeekerItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					
     					stuPermanentResItemId.setDisabled(true);
     					stuAsylumSeekerItemId.setDisabled(true);
     					diplomaticStatusId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					workCriticalSkillsId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAsylumSeekerItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					diplomaticStatusId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					workCriticalSkillsId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
      		 },
      		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#diplomaticStatusId':{
    			 change:function(obj,newValue,oldValue){    
    				 var form = obj.up('personalinformationform');
     				 var value = newValue.diplomaticStatus;
     				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
     				 var temporaryStudyId = form.down("#temporaryStudyId");
     				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
     				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAsylumSeekerItemId.items.items[0].setValue(false);
     					stuAsylumSeekerItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					stuAreYouRefugeeItemId.items.items[0].setValue(false);
     					stuAreYouRefugeeItemId.items.items[1].setValue(true);
     					
     					stuPermanentResItemId.setDisabled(true);
     					stuAreYouRefugeeItemId.setDisabled(true);
     					stuAsylumSeekerItemId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					workCriticalSkillsId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAsylumSeekerItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					stuAreYouRefugeeItemId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					workCriticalSkillsId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
     		 },
     		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#workCriticalSkillsId':{
    			 change:function(obj,newValue,oldValue){    
    				 var form = obj.up('personalinformationform');
     				 var value = newValue.workCriticalSkills;
     				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
     				 var diplomaticStatusId = form.down("#diplomaticStatusId");
     				 var temporaryStudyId = form.down("#temporaryStudyId");
     				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAsylumSeekerItemId.items.items[0].setValue(false);
     					stuAsylumSeekerItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					stuAreYouRefugeeItemId.items.items[0].setValue(false);
     					stuAreYouRefugeeItemId.items.items[1].setValue(true);
     					
     					stuAsylumSeekerItemId.setDisabled(true);
     					stuPermanentResItemId.setDisabled(true);
     					stuAreYouRefugeeItemId.setDisabled(true);
     					diplomaticStatusId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAsylumSeekerItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					stuAreYouRefugeeItemId.setDisabled(false);
     					diplomaticStatusId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
     		 },
     		 'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] radiogroup#postgraduateNonResidentialStudentId':{
        			 change:function(obj,newValue,oldValue){    
        				 var form = obj.up('personalinformationform');
         				 var value = newValue.postgraduateNonResidentialStudent;
         				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
         				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
         				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
         				 var diplomaticStatusId = form.down("#diplomaticStatusId");
         				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
         				 var temporaryStudyId = form.down("#temporaryStudyId");
         				 if(!isNullOrEmpty(value)){
         				 if(value==true){
         					stuAsylumSeekerItemId.items.items[0].setValue(false);
         					stuAsylumSeekerItemId.items.items[1].setValue(true);
         					stuPermanentResItemId.items.items[0].setValue(false);
         					stuPermanentResItemId.items.items[1].setValue(true);
         					stuAreYouRefugeeItemId.items.items[0].setValue(false);
         					stuAreYouRefugeeItemId.items.items[1].setValue(true);
         					
         					stuAsylumSeekerItemId.setDisabled(true);
         					stuPermanentResItemId.setDisabled(true);
         					stuAreYouRefugeeItemId.setDisabled(true);
         					diplomaticStatusId.setDisabled(true);
         					workCriticalSkillsId.setDisabled(true);
         					temporaryStudyId.setDisabled(true);
         				 }else{
         					stuAsylumSeekerItemId.setDisabled(false);
         					stuPermanentResItemId.setDisabled(false);
         					stuAreYouRefugeeItemId.setDisabled(false);
         					diplomaticStatusId.setDisabled(false);
         					workCriticalSkillsId.setDisabled(false);
         					temporaryStudyId.setDisabled(false);
         				 }
         				 }
         			 }
         		 },
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm] combo#genericFieldId1': {
                select: function(obj, record) {
                    this.onSelectionGenericField(obj, record);
                }
            },
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm] combo#countryId': {
                select: function(obj, record) {
                	var newValue = record[0].data.id;
                	this.onChangeCountry(obj, newValue);
                    this.onSelectionCountry(obj, record);
                    var form = this.getAddressFieldRequestForm();
                    var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }//,
            //V2D-103438

//                change: function(obj, newValue) {
//                    this.onChangeCountry(obj, newValue);
//                }
            },
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = this.getAddressFieldRequestForm().down('customcombobox#cityId');
                    cityComboBox.reset();

                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    //var store = this.getStore('organization.CityByCountryRegion');
                    var store = cityComboBox.getStore();
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                }
            },
    
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm]  customcombobox#cityId': {
                select: function(obj1, record) {
                	var me = this;
                	 var city = record[0].get("id");
                	 var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
                	 Ext.Ajax.request({
                        type: 'rest',
                        url: getPinCodeUrl1,
                        method: 'GET',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: {
                            id: city
                        },
                        success: function(res, action) {
                        	var data = res.responseText;
                        	if(!isNullOrEmpty(data) && data !="[]"){
                        		obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
                        		obj1.up('form').down('textfield#pincodeId').setVisible(false);
                        		obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
                        		obj1.up('form').down('customcombobox#pincodeNewId').reset();
                        		obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
                        		setTimeout(function(){
                        			obj1.up('form').down('customcombobox#pincodeNewId').reset();
                            		obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
                            	},100);
                        		var form = me.getAddressFieldRequestForm();
                            	var phoneCountryCode = form.down("#phoneCountryCode");
                            	var phoneNoField = form.down("#phoneNoField");
                            	me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                                var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
                                 store.getProxy().extraParams = {
                                     id: city
                                 };
                                 store.reload();
                        	}else{
                        		obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
                        		obj1.up('form').down('textfield#pincodeId').setVisible(true);
                        		obj1.up('form').down('textfield#pincodeId').setDisabled(false);
                        		obj1.up('form').down('textfield#pincodeId').reset();
                        		var form = me.getAddressFieldRequestForm();
                            	var phoneCountryCode = form.down("#phoneCountryCode");
                            	var phoneNoField = form.down("#phoneNoField");
                            	me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                        	}
                        }
                    });
                },
                select: function(obj1, newValue) {
                	var cityPinCodeTextBox = obj1.up('form').down('textfield#pincodeId');
                	var cityPinCodeComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
                	if(!isNullOrEmpty(newValue)){                   
                		cityPinCodeComboBox.setDisabled(false);
                		cityPinCodeTextBox.setDisabled(false);
                	}else{
                		cityPinCodeTextBox.setDisabled(true);
                		cityPinCodeTextBox.reset();
                		cityPinCodeComboBox.setDisabled(true); 
                		cityPinCodeComboBox.clearValue();
                	}
                	var me = this;
                	var city = newValue;
                	var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
                	Ext.Ajax.request({
                		type: 'rest',
                		url: getPinCodeUrl1,
                		method: 'GET',
                		headers: {
                			'Content-Type': 'application/json'
                		},
                		params: {
                			id: city[0].data.id
                		},
                		success: function(res, action) {
                			var data = res.responseText;
                			if(!isNullOrEmpty(data) && data !="[]"){
                				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
                				obj1.up('form').down('textfield#pincodeId').setVisible(false);
                				obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
                				var form = me.getAddressFieldRequestForm();
                				var phoneCountryCode = form.down("#phoneCountryCode");
                				var phoneNoField = form.down("#phoneNoField");
                				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                				var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
                				store.getProxy().extraParams = {
                					id: typeof city == 'object' ? city[0].data.id : city
                				};
                				store.reload();
                			}else{
                				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
                				obj1.up('form').down('textfield#pincodeId').setVisible(true);
                				obj1.up('form').down('textfield#pincodeId').setDisabled(false);
                				var form = me.getAddressFieldRequestForm();
                				var phoneCountryCode = form.down("#phoneCountryCode");
                				var phoneNoField = form.down("#phoneNoField");
                				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                			}
                		}
                	});
                },
            },
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm] customcombobox#cellCountryCode': {
                select: function(rowModel, record) {
                	var form = this.getAddressFieldRequestForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
                }
            },
            'commonwindow addressfieldsform[itemId=addressFieldRequestForm] numberfield#cellNo': {
                change: function(record) {
                	var form = this.getAddressFieldRequestForm();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },

            'commonwindow nestedJsonCombo[itemId=addressTypeItemField]': {
                beforerender: function(combo) {
                    combo.getStore().load();
                },
                select: function(combo, record) {
                    var this$ = this;
                    var currentForm = this$.getCommonWindow().down("#currentForm");
                    this.onSelectionAddressTypeCombo(combo, record[0], currentForm);
                }
            },

            'commonwindow personaldetailformpanel[itemId=currentForm] button[itemId=requestFormsubmitButtonId]': {
                click: this.createPersonalDetailFormJson
            },
            'commonwindow personaldetailformpanel button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },
            'commonwindow personaladdressdetailformpanel[itemId=currentForm] button[itemId=requestFormsubmitButtonId]': {
            	click: this.createPersonalAddressDetailFormJson
            },
            'commonwindow personaladdressdetailformpanel button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*
             * parent guardian Details
             */'commonwindow parentguardiandetailpanel[itemId=currentForm] button[itemId=requestFormsubmitButtonId]': {
                click: this.createParentGuardianFormJson
            },
            'commonwindow parentguardiandetailpanel button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*'commonwindow parentguardianform[itemId=parentGuardianRequestForm] textfield[itemId=employeeIdField]': {
                blur: function(){
                                var this$ = this;
                    var form = this$.getParentGuardianRequestForm();
                    this$.mixins.PersonInfoController.validateIsEmployeeOfOrganizationId(form);
                }
            },
            'commonwindow parentguardianform[itemId=parentGuardianRequestForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                                var this$ = this;
                    var form = this$.getParentGuardianRequestForm();
                    this$.mixins.PersonInfoController.onChangeIsEmployeeOfOrganizationField(form, checkValue);
                }
            },*/

            /*
             * Sibling Details
             */'commonwindow siblingdetailspanel nestedJsonCombo[itemId=siblingNameItemField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionSiblingNameLoadData
            },
            'commonwindow siblingform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow siblingform': {
                render: this.showHideSiblingDetailsField
            },
            'commonwindow siblingform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },
            'commonwindow siblingform button[itemId=searchButtonId]': {
            	click: function(){
            		var siblingForm = this.getPersonSiblingForm();
            		click: this.searchSiblingInfo(siblingForm);
            	}
            },
            'commonwindow siblingdetailspanel button[itemId=addNewBtn]': {
                click: this.addNewSibling
            },


            /*
             * Medical History
             */
            
            'commonwindow medicalhistoryform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow medicalhistorypanel nestedJsonCombo[itemId=medicalConditionField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionMedicalComboLoadData
            },
            'commonwindow medicalhistorypanel button[itemId=addNewBtn]': {
                click: this.addNewMedicalFormHistory
            },
            'commonwindow medicalhistoryform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createMedicalHistoryFormJson
            },
            'commonwindow medicalhistoryform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*
             * Work Experience
             */
            'commonwindow workexperienceform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow workexperiencepanel nestedJsonCombo[itemId=workExperienceEmployerField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionWorkExperienceComboLoadData
            },
            'commonwindow workexperiencepanel button[itemId=addNewBtn]': {
                click: this.addNewWorkExperienceForm
            },
            'commonwindow workexperienceform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createWorkExperienceFormJson
            },
            'commonwindow workexperienceform[itemId=currentForm] datefield[itemId=dateOfJoining]': {
                 select: function(field, The, eOpts ){
                    	this.calculateExperience(field);
                    }
                },
            'commonwindow workexperienceform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*
             * Vaccination Details
             */
            'commonwindow vaccinationform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow vaccinationdetailspanel nestedJsonCombo[itemId=vaccinationNameField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionVaccinationNameComboLoadData
            },
            'commonwindow vaccinationdetailspanel button[itemId=addNewBtn]': {
                click: this.addNewVaccinationForm
            },
            'commonwindow vaccinationform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createVaccinationFormJson
            },
            'commonwindow vaccinationform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*
             * Education Details
             */
            'commonwindow educationdetailsform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow educationdetailpanel nestedJsonCombo[itemId=examPassedField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionEducationNameComboLoadData
            },
            'commonwindow educationdetailpanel button[itemId=addNewBtn]': {
                click: this.addNewEducationForm
            },
            'commonwindow educationdetailsform combo[itemId=subject]': {
                select: this.onSelectionSubjectDisplayMarks
            },
            'commonwindow educationdetailsform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createEducationFormJson
            },
            'commonwindow educationdetailsform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            /*
             * Extra Curricular Details
             */
            'commonwindow extracurricularform[itemId=currentForm]': {
                render: function(form){
                	form.setDisabled(true);
                }
            },
            'commonwindow extracurriculardetailspanel nestedJsonCombo[itemId=activityNameField]': {
                render: this.loadSearchComboStore,
                select: this.onSelectionActivityNameComboLoadData
            },
            'commonwindow extracurriculardetailspanel button[itemId=addNewBtn]': {
                click: this.addNewExtraCurricularForm
            },
            'commonwindow extracurricularform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createExtraCurricularJson
            },
            'commonwindow siblingform[itemId=currentForm] button[itemId=submitButtonId]': {
                click: this.createSiblingJson
            },
            'commonwindow extracurricularform button[itemId=cancelButtonId]': {
                click: this.closeCommonWindowForm
            },

            'personrequestdetailspanel button[itemId=submitBtn]': {
                click: this.saveServiceRequestForm
            },
            'personrequestdetailspanel #withdrawButtonId': {
                click: function(button) {
                    this.withdrawRequest(button);
                }
            },
            'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] button[itemId=verifyDetail]': {
    			click: function(obj) {
    				//personType = obj.up().up().up().personType;
    					var $this = this;
    					var personalInformationForm = this.getCommonWindow().down('#currentForm');
    					if(personalInformationForm){
    						var data = personalInformationForm.getValues()
    					}
    					var nationalId = data.nationalID;
    					var Url = SERVERURL.VERIFY_NATIONAL_ID;
    					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    					if(!isNullOrEmpty(nationalId)){
    						Ext.Ajax.request({
    							type: 'rest',
    							url: Url+'?identityNumber='+nationalId,
    							method: 'GET',
    							success : function(response, action){
    								Ext.getBody().unmask();
    								var responseData = Ext.JSON.decode(response.responseText);
    								 //var id = parseInt(XMLHttpRequestObject.responseText);
    								if(responseData.message!='Not Found' && responseData.citizenship!=null)
    								{
    								//var getIDWindow='';
    		    					//getIDWindow = $this.getStudentIdVerificationDetailWin();
    		    					//if (!getIDWindow) {
    									var getIDWindow =Ext.widget('idverificationdetailwin',{
  										   itemId:'studentIdVerificationDetailWinItemId'
  									   });
    		    						//getIDWindow = $this.getStudentIdVerificationDetailWin();
    		    					//}
    		    					getIDWindow.show();
    		    					//getFormWindow = formWindow.getForm();
    	    						getIDWindow.down('#userFirstName').setValue(data.firstName);
    	    						getIDWindow.down('#userLastName').setValue(data.lastName);
    	    						getIDWindow.down('#userGender').setValue(data.gender);
    	    						getIDWindow.down('#userDOB').setValue(data.birthDate);
    								
    								var nationalityCombo =  personalInformationForm.down("#nationalityCombo");
    								var matched = '<span style="color:green">Matched</span>';
    								var notMatched = '<span style="color:red">Not Matched</span>';
    							
    								if(!isNullOrEmpty(nationalityCombo.getRawValue())){
    									getIDWindow.down('#userCitizenship').setValue(nationalityCombo.getRawValue());
    								}
    								if(responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(notMatched);
    								}
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase() && responseData.surname.toUpperCase() == data.lastName.toUpperCase() &&
    										responseData.gender.toUpperCase() == data.gender.toUpperCase() &&
    										dateRender(responseData.dateOfBirth) == data.birthDate && responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('VERIFIED_NOTE'));

    								}else
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('NOT_VERIFIED_NOTE'));
    								}
    								
    								getIDWindow.down('#dbFirstName').setValue(responseData.firstNames);
    								getIDWindow.down('#dbLastName').setValue(responseData.surname);
    								getIDWindow.down('#dbGender').setValue(responseData.gender);
    								getIDWindow.down('#dbDOB').setValue(dateRender(responseData.dateOfBirth));
    								getIDWindow.down('#dbCitizenship').setValue(responseData.citizenship);
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase())
    								{
    									getIDWindow.down('#firstNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#firstNameStatus').setValue(notMatched);
    								}
    								if(responseData.surname.toUpperCase() == data.lastName.toUpperCase())
    								{
    									getIDWindow.down('#lastNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#lastNameStatus').setValue(notMatched);
    								}
    								if(responseData.gender.toUpperCase() == data.gender.toUpperCase())
    								{
    									getIDWindow.down('#genderStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#genderStatus').setValue(notMatched);
    								}
    								if(dateRender(responseData.dateOfBirth) == data.birthDate)
    								{
    									getIDWindow.down('#dobStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#dobStatus').setValue(notMatched);
    								}
    								
    							}else{
    								showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('GET_RECORD_NOT_FOUND'));
    							}

    							}
    						});
    					}
    			}
    		},
    		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] fieldset[itemId=otherDetailsStudentFieldSet]': {
    			resize: function(element, info, eOpts) {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		commonWin.body.dom.scrollTop = size.height;
    			}
    		},
    		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] fieldset[itemId=bankDetailsStudentApplicationFieldSetId]': {
    			resize: function(element, info, eOpts) {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		commonWin.body.dom.scrollTop = size.height;
    			}
    		},
    		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] numberfield[itemId=mobileNumber]': {
    			validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			commonWin.body.dom.scrollTop = size.height;
            		}
    			}
    		},
    		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] textfield[itemId=emailId]': {
    			validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			commonWin.body.dom.scrollTop = size.height;
            		}
    			}
    		},
    		'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] textfield[itemId=alternateEmailId]': {
    			validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			commonWin.body.dom.scrollTop = size.height;
            		}
    			}
    		},
    		'commonwindow personaladdressdetailformpanel addressfieldsform[itemId=addressFieldRequestForm] numberfield[itemId=cellNo]': {
    			validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			commonWin.body.dom.scrollTop = size.height;
            		}
    			}
    		},
    		'commonwindow workexperienceform[itemId=currentForm] radiogroup[itemId=currentOrgGroupId]': {
            	change: function(cb, nv, ov){
            		var form = cb.up('workexperienceform');
            		var datOfExit = form.down('#exitDate');
            		datOfExit.reset(); 
            		if(nv.whetherCurrentOrg){
            			datOfExit.setDisabled(true);
            		} else {
            			datOfExit.setDisabled(false);
            		}
            	}
           },
           'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] textfield[itemId=birthDateId] ':{
        	   change : function(obj,record){
       		    var $this = this;
                var form = obj.up('personalinformationform');
                var ageData =form.down("#ageId");
                var currentYear = new Date(record);
                var todayDate = new Date();
                var calculateAge =todayDate.getFullYear()-currentYear.getFullYear();
                if (form.down("#birthDateId").isValid()){
                   if (todayDate.getMonth() < currentYear.getMonth() || (todayDate.getMonth() === currentYear.getMonth() && todayDate.getDate() < currentYear.getDate())) {
                     calculateAge--;
                   }
                }else{
                     calculateAge = 0;
                }
                if(!isNullOrEmpty(ageData)){
                 ageData.setValue(calculateAge);
                 ageData.setReadOnly(true);
                }
       	      }
       	}
           ,
           'commonwindow personaldetailformpanel personalinformationform[itemId=personalInformationRquestForm] combo[itemId=armsOfService]': {
             	 select:function(obj1,records) {
             	  var musteringComboBox = obj1.up('form').down('customcombobox#mustering');
                var armsOfServiceComboBox = obj1.up('form').down('customcombobox#armsOfService');
              	musteringComboBox.setDisabled(false);
              	musteringComboBox.reset();
                
                var armsOfServiceIdVal = records[0].get("id");
                //var countryIdVal = armsOfServiceComboBox.getValue();
                var musteringStore = musteringComboBox.getStore();
                musteringStore.getProxy().extraParams = {
              	  armsOfServiceId: armsOfServiceIdVal
                };
                musteringStore.reload();
             	 }
             },
             'studentuploadphotowindow[itemId=studentcurrentuploadphotowindow] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
					   button.rotate = parseFloat(button.rotate) + .50;
				   }
			   }
        });
    },


    /*
     *  load data on render data changed combo
     *  @param combo - data changed combo
     */
    loadDataChangedComboStore: function(combo) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var serviceRequestCategory = serviceRequestActiveTab.getRequestType();
        var serviceRequestGroup = serviceRequestActiveTab.getRequestGroup();
        var program = serviceRequestActiveTab.getProgram();
        var programId = null;
        if(program !=null && program.id !=null){
        	programId = program.id;
        }
        if(serviceRequestGroup=="Personal Data Change" || serviceRequestGroup== "Personal Detail Change"){
        	serviceRequestGroup="PERSONAL_DATA_CHANGE";
        }
        var academyLocationId = serviceRequestActiveTab.getAcademyLocationId();
        var portalId = this$.getCurrentLoggedPortalId();
        var store = combo.getStore();
        if(!isNullOrEmpty(this.getActiveTabfromContentPanel().getProgram())){
        	 programId=this.getActiveTabfromContentPanel().getProgram().id;
        store.getProxy().extraParams = {
            serviceRequestCategory: serviceRequestCategory,
            academyLocationId: academyLocationId,
            serviceRequestGroup: serviceRequestGroup,
            portalId: portalId,
            programId:programId
        };
        }else{
        	   store.getProxy().extraParams = {
                   serviceRequestCategory: serviceRequestCategory,
                   academyLocationId: academyLocationId,
                   serviceRequestGroup: serviceRequestGroup,
                   portalId: portalId
               };
        }
        store.load();
    },
    searchSiblingInfo: function(personSiblingForm) {
        var this$ = this;
        var siblingStudentField = personSiblingForm.down('#siblingStudentId');
        //var studentCode = siblingStudentField.getValue();
        var studentCode = siblingStudentField.valueModels[0].data.studentCode;
        var siblingInfoForm = personSiblingForm.down('form');
        /*personSiblingForm.down('combo[name=salutation]').setReadOnly(true);
        personSiblingForm.down('textfield[name=firstName]').setReadOnly(true);
        personSiblingForm.down('textfield[name=middleName]').setReadOnly(true);
        personSiblingForm.down('textfield[name=lastName]').setReadOnly(true);
        personSiblingForm.down('combo[name=gender]').setReadOnly(true);
        personSiblingForm.down('datefield[name=birthDate]').setReadOnly(true);*/
        if (!isNullOrEmpty(studentCode)) {
        	
        	 var params = {
                 studentCode: studentCode
             };
        	 
        	 this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
             	if(success){
                    var data = Ext.decode(response.responseText);
                    if (!isEmpty(data)) {
                        var id = personSiblingForm.down('#sibling_hidden_field').getValue();
                        var version = personSiblingForm.down('#sibling_version_field').getValue();
                        var formDetails = new Object();
                        formDetails["id"] = id;
                        formDetails["version"] = version;
                        if (!isNullOrEmpty(data["person"])) {
                        	if(data.status == true){
                        		siblingInfoForm.setVisible(true);
                        		personSiblingForm.down('#submitButtonId').setDisabled(false);
                        		var innerForm = personSiblingForm.down('#siblingInfoItemField');
                        		/*innerForm.setDisabled(false);*/
                        		data.person.birthDate = new Date(data.person.birthDate);
                        		innerForm.getForm().setValues(data.person);
                        		personSiblingForm.getForm().setValues(formDetails);
                        		personSiblingForm.setRelatedPersonUserId(data.id);
                        		personSiblingForm.setRelatedPerson(data.person);
                                personSiblingForm.down('#contactFieldSet').hide();
                               	if(!isNullOrEmpty(data.person.genderCSM) && !isNullOrEmpty(data.person.genderCSM.id)) {
	                        		innerForm.down('#genderCombo').getStore().load({
	                    				callback: function(records, operation, success) {
	                    					innerForm.down('#genderCombo').setValue(data.person.genderCSM.id);
	                    				}
	                    			});
                        		}
                        	} else {
                        		personSiblingForm.down('#submitButtonId').setDisabled(true);
                        		showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('STUDENT_IS_NULL'));
                        	}
                        } else {
                    		personSiblingForm.down('#submitButtonId').setDisabled(true);
                            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('STUDENT_ID_NOT_EXIST'));
                        }
                    }
                }
             });
        }
    },

    onClickClearDataToBeChangedField: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var record = this$.getDataChangedComboRecord();
        if(!isNullOrEmpty(record)){
        	if (record.get("code") == 'SHR') {
                serviceRequestActiveTab.down('#stakeHolderTypeId').clearValue();
            } else {
                serviceRequestActiveTab.down('#dataChangedComboField').clearValue();
            }
        }
        


    },

    /*
     *  Get common window form active tab panel 
     */
    getWindowFormActiveTabPanel: function() {
        var this$ = this;
        var tabPanel = this$.getCommonWindow().down('commontabpanel');
        var form = null;
        if (tabPanel) {
            form = tabPanel.getActiveTab();
        }
        return form;
    },


    /*
     *  load data on render of window search combo
     *  @param combo - render data changed combo
     */
    loadSearchComboStore: function(combo) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();

        var store = combo.getStore();
        store.getProxy().extraParams = {
            personId: personId
        };
        store.load();
    },

    onSelectionShowPersonalDetailsForm: function(cmb, records) {
        var this$ = this;
        var isNew = true;
        var record = this$.getDataChangedComboRecord();
        if(!isNullOrEmpty(record)){
        	if (record.get("code") == 'SHR') {
                this$.onStackHolderRecordSelection(true);
            } else {
                this$.onStackHolderRecordSelection(false);
                this$.showPersonalDetailsForm(record, isNew);
            }
        }

    },

    /*
     * on stackholder record selection
     */
    onStackHolderRecordSelection: function(visible) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var stakeHolderTypeCombo = serviceRequestActiveTab.down('#stakeHolderTypeId');
        stakeHolderTypeCombo.clearValue();
        stakeHolderTypeCombo.setDisabled(!visible);
        stakeHolderTypeCombo.setVisible(visible);
    },

    /*
     * on stackholder combo selection
     */
    onStackHolderComboSelection: function() {
        var this$ = this;
        var isNew = true;
        var record = this$.getDataChangedComboRecord();
        this$.showPersonalDetailsForm(record, isNew);
    },

    onClickShowDetailsLinkPanel: function(isOpenFromShow) {
        var this$ = this;
        var isNew = false;
        var record = this$.getDataChangedComboRecord();
        this$.showPersonalDetailsForm(record, isNew, isOpenFromShow);
    },
    /*
     * get data changed combo record
     */
    getRequestByPersonType: function() {
        var this$ = this;
        var value = '';
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var requestType = serviceRequestActiveTab.getRequestType();
        if (requestType == 'STUDENT_REQUEST') {
            value = 'STUDENT';
        } else {
            value = 'FACULTY';
        }
        return value;
    },
    /*
     * get data changed combo record
     */
    getDataChangedComboRecord: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var form = serviceRequestActiveTab.down('personrequestdetailspanel');
        var dataChangedComboField = form.down('#dataChangedComboField');
        var value = dataChangedComboField.getValue();
        var record = dataChangedComboField.findRecordByValue(value);

        return record;
    },


    /*
     *  Show personal details form
     *  @param record
     *  @param isNew
     */
    showPersonalDetailsForm: function(record, isNew, isOpenFromShow) {

        var this$ = this;
        var xtypePanel = null;
        var xtypeForm = null;
        var id = record.get("id");
        var code = record.get("code");
        var window = this$.getCommonWindow();
        this$.getServiceRequestSettingData(id);
        switch (code) {
        case 'SHR':
            xtypeForm = 'parentguardiandetailpanel';
            break;
        case 'PDCPDC':
            xtypeForm = 'personaldetailformpanel';
            break;
        case 'SBDPDC':
            xtypePanel = 'siblingdetailspanel';
            xtypeForm = 'siblingform';
            break;
        case 'MHPDC':
            xtypePanel = 'medicalhistorypanel';
            xtypeForm = 'medicalhistoryform';

            break;
        case 'VDPDC':
            xtypePanel = 'vaccinationdetailspanel';
            xtypeForm = 'vaccinationform';
            break;
        case 'WEPDC':
            xtypePanel = 'workexperiencepanel';
            xtypeForm = 'workexperienceform';
            break;
        case 'PD':
            xtypePanel = 'educationdetailpanel';
            xtypeForm = 'educationdetailsform';
            break;
        case 'ECPDC':
            xtypePanel = 'extracurriculardetailspanel';
            xtypeForm = 'extracurricularform';
            break;
        case 'ADPDC':
            //xtypePanel = 'extracurriculardetailspanel';
            xtypeForm = 'personaladdressdetailformpanel';
            break;
        }

        if (!window) {

            var title = record.get("value");
            this$.showCommonWindow(title, xtypePanel, xtypeForm, isNew);
            
            if (!isNew) {
                this$.setRecordToCurrentPreviousFormWindow();
            } else {
                var currentForm = this$.getCommonWindow().down('#currentForm');
                if (xtypeForm == 'personaldetailformpanel' || xtypeForm == 'personaladdressdetailformpanel') { //Personal details
                    if(xtypeForm == 'personaldetailformpanel'){
                    	if (!isNullOrEmpty(currentForm.down('#verifyDetail'))) {
                    		//currentForm.down('#verifyDetail').setVisible(false);
                    	}
                    	this$.onRenderPersonalDetailForm(currentForm);
                    	var form = currentForm.down('#personalInformationRquestForm');
                        var countryCodeField = form.down("#cellCountryCode");
                     	var mobileField = form.down("#mobileNumber");
                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    }
                    if(xtypeForm == 'personaladdressdetailformpanel'){ //Personal Address Details
                    	this$.onRenderPersonalAddressDetailForm(currentForm);
                    	var form = this$.getCommonWindow();
                        var countryCodeField = form.down("#cellCountryCode");
                     	var mobileField = form.down("#cellNo");
                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    }
                } else if (xtypeForm == 'parentguardiandetailpanel') { //Parent & Guardian details
                    this$.onRenderParentGuardianLoadData(currentForm);
                }
            }
            
            if(xtypeForm==='personaldetailformpanel'){
            	var commonWin = this$.getCommonWindow();
            	var formPanel = commonWin.down('personaldetailformpanel').down('personalinformationform');
            	if(formPanel.personType === 'STUDENT'){
            		var photofileimage = formPanel.down('#studentPhotoUploadForm');
                    photofileimage.down('#photoFileImage').setVisible(false);
                    var admissionIdIteamId = formPanel.down('#admissionIdIteamId');
                    admissionIdIteamId.setVisible(false);
                    var photoSnapFileImage = formPanel.down('#photoFileImage');
                    photoSnapFileImage.setVisible(false);
                    var profilePhotoRemove = formPanel.down('#profilePhotoRemove');
                    profilePhotoRemove.setVisible(false);
                    var studentAcademicContainer = formPanel.down('#studentAcademicContainer');
                    studentAcademicContainer.setVisible(false);
            	}
            	
            }
            if(xtypeForm === 'personaladdressdetailformpanel'){
            	var commonWin = this$.getCommonWindow();
            	/*var formPanel = commonWin.down('personaladdressdetailformpanel').down('personalinformationform');
            	if(formPanel.personType === 'STUDENT'){
            		var photofileimage = formPanel.items.items[9].items.items[0].items.items[2];
            		photofileimage.setVisible(false);
            	}*/
            }
            if(xtypeForm === 'vaccinationform'){
            	var currentForm = this$.getCommonWindow().down('#currentForm');
            	if(!isNullOrEmpty(currentForm) && currentForm != undefined){
            		if(!isNullOrEmpty(currentForm.down('#uploadVaccinationItemId')) && currentForm.down('#uploadVaccinationItemId') != undefined){
            			currentForm.down('#uploadVaccinationItemId').setVisible(false);
            		}
            	}
            }
        }
    },

    /*
     * show common window
     * @param title form xtype add to tab panel
     * @param xtypePanel panel added in panel 
     * @param xtypeform form xtype add to tab panel
     * @param isNew new
     */
    showCommonWindow: function(title, xtypePanel, xtypeForm, isNew) {
        var this$ = this;
        var commonWindow = this$.getCommonWindow();
        if (!commonWindow) {

            commonWindow = Ext.widget('commonwindow', {
                title: title
            });
            if (!isNullOrEmpty(xtypePanel)) {
                var searchPanel = Ext.widget(xtypePanel, {
                    itemId: 'changeFormPanel'
                });

                if (isNew) {
                    commonWindow.add(searchPanel);
                }
            }
            var tabPanel = this$.addFormToTabPanel(xtypeForm, isNew);
            commonWindow.add(tabPanel);
            commonWindow.show();
            var profileImageItemId = commonWindow.down('#profileImageItemId');
            if(profileImageItemId) {
            	var personProfile = this$.getContentPanelActiveTab();
                var personId = personProfile.getPersonId();
                var profileImage = profileImageItemId.down('#profile_image');
                var finalUrl;
            	profileImageItemId.setVisible(true);
            	var dataToBeChangedId = personProfile.down('#dataToBeChangedId').value;
            	if(!dataToBeChangedId) {
            		finalUrl = SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId;
            	} else {
            		var profileImageIcon = profileImageItemId.down('#profile_image_icon');
                    profileImageIcon.setVisible(false);
            		finalUrl = SERVERURL.PERSON_IMAGE_DOWNLOAD_CURRENT + '?dataToBeChangedId=' + dataToBeChangedId;
            	}
            	
            	if (!isNullOrEmpty(personId)) {
            		Ext.Ajax.request({
                        url: finalUrl,
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                profileImage.getEl().dom.src = url;
                            }
                        },
                    });
            	}
            }

        }
    },

    /*
     * Add form To tab panel
     * @param xtypeform form xtype add to tab panel
     * @param isNew new
     */
    addFormToTabPanel: function(xtypeform, isNew) {
        var this$ = this;
        var tabPanel = Ext.widget('commontabpanel');
        var personType = this$.getRequestByPersonType();
        this.loadContollers(xtypeform);
        var panelTitle = null;
        if(xtypeform == 'workexperienceform'){
        	panelTitle = getServiceRequestTranslation('WORK_EXPERIENCE_DETAIL')
        } else {
        	panelTitle = getServiceRequestTranslation('CURRENT_VERSION')
        }
        tabPanel.add({
            xtype: xtypeform,
            itemId: 'currentForm',
            personType: personType,
            title: panelTitle,/*getServiceRequestTranslation('CURRENT_VERSION')*/
            tabCls: 'right-tab'

        });
        if (!isNew) {
            tabPanel.add({
                xtype: xtypeform,
                itemId: 'previousForm',
                personType: personType,
                title: getServiceRequestTranslation('PREVIOUS_VERSION'),
                tabCls: 'right-tab',
                listeners:{
                	activate:function(cmp){
                		if(!isNew)
                        	toggleReadOnlyFormItems(cmp.getForm(), true);
                	}
                	
                }
            });
        }

        if (!isNew) {
            var currentForm = tabPanel.down('#currentForm');
            var previousForm = tabPanel.down('#previousForm');
            previousForm.tab.show();
            if(previousForm.down('#studentPhotoUploadForm')) {
            	previousForm.down('#studentPhotoUploadForm').setVisible(false);
            }
            if(previousForm.down('#profilePhotoRemove')) {
            	previousForm.down('#profilePhotoRemove').setVisible(false);
            }
            //previousForm.down('#studentPhotoUploadForm').setVisible(false);
            //previousForm.down('#profilePhotoRemove').setVisible(false);
            	var personProfile = this$.getContentPanelActiveTab();
                var personId = personProfile.getPersonId();
                var profileImage = previousForm.down('#profile_image_prev');
                var finalUrl;
                if(profileImage){
            		profileImage.setVisible(true)
            	}
            	//profileImage.setVisible(true);
            	finalUrl = SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId;
            	
            	if (!isNullOrEmpty(personId)) {
            		Ext.Ajax.request({
                        url: finalUrl,
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                if(profileImage){
                                profileImage.setSrc(url);
                             }
                            }
                        },
                    });
            }
            if (xtypeform == 'parentguardiandetailpanel' || xtypeform == 'personaldetailformpanel' || xtypeform == 'personaladdressdetailformpanel') {
                currentForm.down('#requestFormsubmitButtonId').hide();
                previousForm.down('#requestFormsubmitButtonId').hide();
            } else {
            	if(currentForm.down('#submitButtonId')){
            		currentForm.down('#submitButtonId').hide();
            	}
            	
            	if(previousForm.down('#submitButtonId')){
            		previousForm.down('#submitButtonId').hide();
            		previousForm.down('#profilePhotoRemove').hide();
            		previousForm.down('#studentPhotoUploadForm').hide();
            	}
            }
        }
        tabPanel.setActiveTab(0);
        if (!isNew) {
        	currentForm.isReadOnly=true;
        	Ext.defer(function(){
        		 toggleReadOnlyFormItems(currentForm.getForm(), true);
        	        //toggleReadOnlyFormItems(previousForm.getForm(), true);
        	},1000)
       
        }
        return tabPanel;
    },
    /*
     *  set record to current form window
     */
    setRecordToCurrentFormWindow: function(data) {
        var this$ = this;
        var currentForm = this$.getCommonWindow().down('#currentForm');
        currentForm.setDisabled(false);
        currentForm.getForm().setValues(data);
        if(!isNullOrEmpty(currentForm.down("#vaccinationDate"))){
        currentForm.down("#vaccinationDate").setValue(dateRender(data.vaccinationDate));
        }
        if(!isNullOrEmpty(currentForm.down("#dateSince"))){
            currentForm.down("#dateSince").setValue(dateRender(data.dateSince));
            }
        var countryCode=currentForm.down("#doctorTelephoneCountryCodeItemId")
        if(!isNullOrEmpty(countryCode)){
        	countryCode.getStore().load({
				callback: function(records, operation, success) {
					for(var i=0;i<records.length;i++){
						if(records[i].data.value==data.doctorTelephoneCountryCode)
						
							countryCode.setValue(records[i].data.value);
						
					}
				}
			});
			
           // currentForm.down("#doctorTelephoneCountryCodeItemId").setValue(data.doctorTelephoneCountryCode);
            }
        
    },
    /*
     *  set record to previous form window
     */
    setRecordToCurrentPreviousFormWindow: function() {

        var this$ = this;
        var isPreviousFormActive = false;
        var params = {};
        var previousForm = this$.getCommonWindow().down('#previousForm');
        var currentForm = this$.getCommonWindow().down('#currentForm');
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var requestType = serviceRequestActiveTab.getResponseData().dataTobeChanged;
        var dataToBeChanged = serviceRequestActiveTab.getResponseData().detail.dataToBeChanged;

        if (!isNullOrEmpty(dataToBeChanged)) {
            switch (requestType.code) {
            case 'SHR':
                { /* Parent Guardian Details*/

                    this$.setRecordToCurrentParentGuardianForm(currentForm, dataToBeChanged); // On current form renderer
                    this$.setRecordToCurrentAddressFieldForm(currentForm, dataToBeChanged); // On current form renderer
                    this$.onRenderParentGuardianLoadData(previousForm); // On previuos for renderer
                    isPreviousFormActive = true;
                    break;
                }
                break;
            case 'PDCPDC':
                { /* Personal Information Details*/

                    this$.setRecordToCurrentPersonalInformationForm(currentForm, dataToBeChanged); // On current form renderer
                    this$.setRecordToCurrentAddressFieldForm(currentForm, dataToBeChanged); // On current form renderer
                    this$.onRenderPersonalDetailForm(previousForm); // On previuos for renderer
                    isPreviousFormActive = true;
                    break;
                }
            case 'SBDPDC':
            	{/*sibling information details*/
            		isPreviousFormActive = false;
            		this$.setCurrentSiblingInfoForm(currentForm, dataToBeChanged);
            		break;
            	}
                
            case 'MHPDC':
                { /*Medical History*/

                    var conditionType = {
                        id: dataToBeChanged.conditionTypeId
                    };
                    dataToBeChanged.conditionType = conditionType;
                    this$.setRecordToCurrentFormWindow(dataToBeChanged); // On current form renderer
                    
                    if (!isEmpty(dataToBeChanged)) {
                    	if(!isNullOrEmpty(dataToBeChanged.dateSince)){
                    		dataToBeChanged.dateSince = new Date(dataToBeChanged.dateSince);
	                        var currentForm = this$.getCommonWindow().down('#currentForm');
	                        currentForm.getForm().setValues(dataToBeChanged);
                    	}
                    }
                    
                    var medicalHistoryId = dataToBeChanged.medicalHistoryId;
                    if (!isNullOrEmpty(medicalHistoryId)) {
                        params.medicalHistoryId = medicalHistoryId;
                        this$.setMedicalHistoryToForm(previousForm, params); // On previuos for renderer
                        isPreviousFormActive = true;
                    }
                    break;
                }

            case 'VDPDC':
                { /*Vaccination History*/

                    this$.setRecordToCurrentFormWindow(dataToBeChanged); // On current form renderer

                    var vaccinationInfoId = dataToBeChanged.vaccinationInfoId;
                    if (!isNullOrEmpty(vaccinationInfoId)) {
                        params.id = vaccinationInfoId;
                        this$.setVaccinationDetailToForm(previousForm, params); // On previuos for renderer
                        isPreviousFormActive = true;
                    }
                    break;
                }
            case 'WEPDC':
                { /*Work Experience History*/

                    var experienceType = {
                        id: dataToBeChanged.experienceTypeId
                    };
                    dataToBeChanged.experienceType = experienceType;
                    this$.setRecordToCurrentFormWindow(dataToBeChanged); // On current form renderer
                    if (!isEmpty(dataToBeChanged)) {
                    	if(!isNullOrEmpty(dataToBeChanged.joiningDate)){
                    		dataToBeChanged.joiningDate = new Date(dataToBeChanged.joiningDate);
	                        var currentForm = this$.getCommonWindow().down('#currentForm');
	                        currentForm.getForm().setValues(dataToBeChanged);
                    	}
                    }
                    var workExperienceId = dataToBeChanged.workExperienceId;
                    if (!isNullOrEmpty(workExperienceId)) {
                        params.id = workExperienceId;
                        this$.setWorkExperienceToForm(previousForm, params); // On previuos for renderer
                        isPreviousFormActive = true;
                    }
                    break;
                }
            case 'PD':
                { /*Previous Education History*/
                    if (!isEmpty(dataToBeChanged.subjectMarkDataToBeChanged)) {
                        var subjectMarksData = dataToBeChanged.subjectMarkDataToBeChanged[0];
                        dataToBeChanged.subjectId = subjectMarksData.subjectMarkInfoId;
                        if (!isNullOrEmpty(subjectMarksData.subjectId)) {
                            dataToBeChanged.subject = parseInt(subjectMarksData.subjectId);
                        }
                        dataToBeChanged.marks = subjectMarksData.marks;
                    }
                    var examPassed = {
                        id: dataToBeChanged.examPassedId
                    };
                    dataToBeChanged.examPassed = examPassed;
                    var educationHistoryId = dataToBeChanged.educationalHistoryId;
                    this$.setRecordToCurrentFormWindow(dataToBeChanged);
                    if (!isNullOrEmpty(educationHistoryId)) {
                        params.educationHistoryId = educationHistoryId;
                        isPreviousFormActive = true;
                        this$.setEducationHistoryToForm(previousForm, params, function(option, success, response) {
                            if (success) {
                                var data = Ext.decode(response.responseText);
                                currentForm.setDisabled(false);
                                this$.setDataToEducationDetailsForm(previousForm, data);
                                if (!isNullOrEmpty(dataToBeChanged.subject)) {
                                    var previousFormSubject = previousForm.down('#subject');
                                    var previousFormMarks = previousForm.down('#marks');
                                    previousFormMarks.setDisabled(false);
                                    var currentFormSubject = currentForm.down('#subject');
                                    var currentFormMarks = currentForm.down('#marks');
                                    currentFormMarks.setDisabled(false);
                                    currentFormSubject.bindStore(previousFormSubject.getStore());
                                    previousFormSubject.setValue(dataToBeChanged.subject);
                                    var record = previousFormSubject.getStore().findRecord('id', dataToBeChanged.subject);
                                    if (!isEmpty(record)) {
                                        previousFormMarks.setValue(record.get("marks"));
                                    }
                                }
                               // this$.setRecordToCurrentFormWindow(dataToBeChanged); // On current form renderer
                            }
                        });
                    }
                    break;
                }
            case 'ECPDC':
                { /*Extra Curricular History*/
                    var activityType = {
                        id: dataToBeChanged.activityTypeId
                    };
                    var community = {
                        id: dataToBeChanged.communityId
                    };
                    dataToBeChanged.activityType = activityType;
                    dataToBeChanged.community = community;
                    var isCurrentOrganization = dataToBeChanged.isCurrentOrganization;
                    if (!isNullOrEmpty(isCurrentOrganization)) {
                        currentForm.down('#previousOrgRadioBtn').setValue(!isCurrentOrganization);
                        currentForm.down('#currentOrgRadioBtn').setValue(isCurrentOrganization);
                    }
                    this$.setRecordToCurrentFormWindow(dataToBeChanged); // On current form renderer

                    var extraCurricularActivityId = dataToBeChanged.extraCurricularActivityId;
                    if (!isNullOrEmpty(extraCurricularActivityId)) {
                        params.id = extraCurricularActivityId;
                        this$.setExtraCurricularDetailToForm(previousForm, params); // On previuos for renderer
                        isPreviousFormActive = true;
                    }
                    break;
                }
	            case 'ADPDC':
	            { /* Personal Address Details*/
	
	                //this$.setRecordToCurrentPersonalInformationForm(currentForm, dataToBeChanged); // On current form renderer
	                this$.setRecordToCurrentAddressFieldForm(currentForm, dataToBeChanged); // On current form renderer
	                //this$.onRenderPersonalDetailForm(previousForm); // On previuos for renderer
	                this$.onRenderPersonalAddressDetailForm(previousForm); // On previuos for renderer
	                isPreviousFormActive = true;
	                break;
	            }
            }

            if (isPreviousFormActive) {
                previousForm.tab.show();
            } else {
                previousForm.tab.hide();
            }
        } else {
            previousForm.tab.hide();
        }

    },
    
    setCurrentSiblingInfoForm: function(form, data){
    	var this$ = this;
    	form.getForm().setValues(data);
    	form.down('#salutationItemId').getStore().load({
    		callback: function(record){
    			form.down('#salutationItemId').setValue(data.salutationId);
    		}
    	})
    	this$.setSiblingCode(form,data.relatedPersonId);
    	form.down("#searchButtonId").setVisible(false);
    	form.setDisabled(false);
    },

    /*
     *  close common window form
     */
    closeCommonWindowForm: function() {
        var this$ = this;
        this$.getCommonWindow().close();
    },
    /*
     *  Get service request setting
     */
    getServiceRequestSettingData: function(requestTypeId) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        serviceRequestActiveTab.setFormData(null);
        var requestType = serviceRequestActiveTab.getRequestType();
        var academyLocationId = serviceRequestActiveTab.getAcademyLocationId();
        var params = {
            requestTypeId: requestTypeId,
            serviceRequestCategory: requestType,
            academyLocationId: academyLocationId
        };
        this$.sendGetAjaxRequest(SERVERURL.FIND_REQUEST_TYPE_ID, 'GET', params, function(opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                serviceRequestActiveTab.setServiceRequestSetting(data);
            }
        });

    },
    isRadioButtonTrue: function(data){
       var currentForm = this.getCommonWindow().down('#currentForm');
       var form = currentForm.down('#personalInformationRquestForm');
       var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
  	   var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
  	   var diplomaticStatusId = form.down("#diplomaticStatusId");
  	   var temporaryStudyId = form.down("#temporaryStudyId");
  	   var workCriticalSkillsId = form.down("#workCriticalSkillsId");
  	   var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
	   var stuPermanentResItemId = form.down("#stuPermanentResItemId");
 
	   if(!isEmpty(data)){
    	   if(data.isPermanentResident == true){
    		    stuAsylumSeekerItemId.setDisabled(true);
    		    stuAreYouRefugeeItemId.setDisabled(true);
				diplomaticStatusId.setDisabled(true);
				temporaryStudyId.setDisabled(true);
				workCriticalSkillsId.setDisabled(true);
				postgraduateNonResidentialStudentId.setDisabled(true);
    		}
    	if(data.areYouRefugee == true){
		    stuAsylumSeekerItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(data.isAsylumSeeker == true){
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(data.diplomaticStatus == true){
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(data.temporaryStudy == true){
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
		    diplomaticStatusId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(data.workCriticalSkills == true){
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(data.postgraduateNonResidentialStudent == true){
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
		}
	   }
    },
    SAValueValidationOnPersonalForm:function(form,value){
 	       var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
		   var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
		   var diplomaticStatusId = form.down("#diplomaticStatusId");
		   var temporaryStudyId = form.down("#temporaryStudyId");
		   var workCriticalSkillsId = form.down("#workCriticalSkillsId");
		   var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
		   if(!isNullOrEmpty(value)){
	  			 if(value==true){
	      			 stuAsylumSeekerItemId.items.items[0].setValue(false);
	      			 stuAsylumSeekerItemId.items.items[1].setValue(true);
	      			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
	      			 stuAreYouRefugeeItemId.items.items[1].setValue(true);
	      			 
	      			 stuAsylumSeekerItemId.setDisabled(true);
	      			 stuAreYouRefugeeItemId.setDisabled(true);
	      			 diplomaticStatusId.setDisabled(true);
	     			 temporaryStudyId.setDisabled(true);
	     			 workCriticalSkillsId.setDisabled(true);
	     			 postgraduateNonResidentialStudentId.setDisabled(true);
	      		 }else{
	      			 stuAsylumSeekerItemId.setDisabled(false);
	      			 stuAreYouRefugeeItemId.setDisabled(false);
	      			 diplomaticStatusId.setDisabled(false);
	      			 temporaryStudyId.setDisabled(false);
	      			 workCriticalSkillsId.setDisabled(false);
	      			 postgraduateNonResidentialStudentId.setDisabled(false);
	      		 }
		 }	 
    },
    /*
     *  On Selection Generic field store load 
     */
    onSelectionGenericField: function(obj, record) {
        var genericField2ComboBox = this.getAddressFieldRequestForm().down('combo#genericFieldId2');
        genericField2ComboBox.reset();

        var countryRegion1 = record[0].get("id");
        var store = this.getStore('organization.CountryRegionStore1');
        store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
        store.getProxy().extraParams = {
            pid: countryRegion1
        };
        store.reload();
    },

    /*
     *  On Country Selection Generic, cell, city field store load 
     */
    onSelectionCountry: function(combo, record) {
        var cityComboBox = this.getAddressFieldRequestForm().down('customcombobox#cityId');
        cityComboBox.clearValue();

        var genericField1ComboBox = this.getAddressFieldRequestForm().down('customcombobox#parentCountryRegionId');
        genericField1ComboBox.reset();

        /*var genericField2ComboBox = this.getAddressFieldRequestForm().down('combo#genericFieldId2');
        genericField2ComboBox.reset();*/

        var countryId = record[0].get("id");

        var cityStore = cityComboBox.getStore();
        /*cityStore.getProxy().extraParams = {
            id: countryId
        };
        cityStore.load();
*/
        var countryRegionStore = genericField1ComboBox.getStore();
        countryRegionStore.getProxy().extraParams = {
            cid: countryId
        };
        countryRegionStore.load();

        /*var countryRegion2Store = genericField2ComboBox.getStore();
        countryRegion2Store.removeAll();*/
    },

    /*
     *  On Country change, value set for Generic, cell field
     */
    onChangeCountry: function(combo, newValue) {
        var phoneCountryCode = this.getAddressFieldRequestForm().down('combo#phoneCountryCode');
        var cellCountryCode = this.getAddressFieldRequestForm().down('combo#cellCountryCode');
        var countryStore = this.getAddressFieldRequestForm().down('combo#countryId').getStore();
        var val = countryStore.getById(newValue);
        phoneCountryCode.setValue(val);
        cellCountryCode.setValue(val);
    },
    /**
     *  show hid epersonal details form field
     *  @param tabPanelForm - render form
     */
    showHidePersonalDetailsFormField: function(tabPanelForm) {
        var personCodeField = tabPanelForm.down('#personCodeField');
        var isMidtermJoineeField = tabPanelForm.down('#isMidtermJoineeField');
        var submitButton = tabPanelForm.down('#personalInfoSaveButtonId');
        personCodeField.setVisible(false);
        tabPanelForm.down('#imageMarketingCheckbox').setVisible(false);
        tabPanelForm.down('#consentedCommunicationChannel').setVisible(false);
        tabPanelForm.down('#consentStatementAccepted').setVisible(false);
        tabPanelForm.down('#consentedCommunicationChannel').allowBlank=true;
        tabPanelForm.down('#consentStatementAccepted').allowBlank=true;
        if (isMidtermJoineeField) {
            isMidtermJoineeField.setVisible(false);
            isMidtermJoineeField.setDisabled(true);
        }

        submitButton.setVisible(false);
        personCodeField.setDisabled(true);

    },
    /*
     *  get data on render personal detail form
     */
    onRenderPersonalDetailForm: function(tabPanelForm) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        this$.showHidePersonalDetailsFormField(tabPanelForm);
        var requesterId = serviceRequestActiveTab.getRequesterId();
        var params = {
            id: requesterId
        };
        
        if (tabPanelForm.itemId == 'previousForm') {
        tabPanelForm.on('afterrender', function(){
            this$.setPersonalDetailsToForm(tabPanelForm, params);
        });
        }
        else {
        	this$.setPersonalDetailsToForm(tabPanelForm, params);
        }
       
    },
    
    /*
     *  get data on render personal address detail form
     */
    onRenderPersonalAddressDetailForm: function(tabPanelForm) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        //this$.showHidePersonalDetailsFormField(tabPanelForm);
        var requesterId = serviceRequestActiveTab.getRequesterId();
        var params = {
            id: requesterId
        };
        //this$.setPersonalDetailsToForm(tabPanelForm, params);
        this$.setPersonalAddressDetailsToForm(tabPanelForm, params);
    },
    /*
     *  Set personal details to personal details form
     *  @param tabPanelForm - tab panel form to set person data
     *  @param params - params 
     */
    setPersonalAddressDetailsToForm: function(tabPanelForm, params) {
        var this$ = this;
        //var personalDetailsForm = tabPanelForm.down('#personalInformationRquestForm');
        if (tabPanelForm.personType == 'STUDENT') {
        	this$.sendGetAjaxRequest(SERVERURL.FIND_STUDENT_PERSONAL_INFORMATION_DETAILS, 'GET', params, function(option, success, response) {
                if (success) {
                	
                    if (!isNullOrEmpty(response.responseText)) {
                        var data = Ext.decode(response.responseText);
                        tabPanelForm.setPersonData(data);
                        this$.getPersonalInfoFormValue(data);
                        //personalDetailsForm.getForm().setValues(data);
                        if (tabPanelForm.itemId == 'previousForm') {
                            this$.onPreviousFormAddressRenderer(tabPanelForm);
                            
                        }
                    	var getPinCodeUrl = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
                		Ext.Ajax.request({
                            type: 'rest',
                            url: getPinCodeUrl,
                            method: 'GET',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(res, action) {
                            	var pincodeData = res.responseText;
                            	var resData = Ext.decode(pincodeData);
                            	if(!isNullOrEmpty(resData)){
                            		tabPanelForm.down('#pincodeNewId').setVisible(true);
                            		tabPanelForm.down('#pincodeId').setVisible(false);
                            		if(tabPanelForm.down('#pincodeNewId')){
    									tabPanelForm.down('#pincodeNewId').getStore().load({
                            			callback: function(recordss, operation, success) {
           								  for(var i in recordss){
           									  if(recordss[i].data.id == resData[0].id){
           										tabPanelForm.down('#pincodeNewId').setValue(recordss[i].data.id);
           									  }
           								  }
           							  }	
    							  });
                            			
                                  }
                            	}else{
                            		tabPanelForm.down('#pincodeNewId').setVisible(false);
                            		tabPanelForm.getPersonAddressFieldsForm().down('#pincodeId').setVisible(true);
                            		if(tabPanelForm.down('#pincodeId')){
                            			tabPanelForm.down('#pincodeId').setValue();
                                	}
                            	}
                            }
                        });
                    }
                    var addressTypeCombo = tabPanelForm.down('#addressTypeItemField');
                	if(!isEmpty(addressTypeCombo)){
            		    /*var recordSelected = addressTypeCombo.getStore().getAt(0);                     
            		    addressTypeCombo.setValue(recordSelected);
            		    addressTypeCombo.fireEvent('select', addressTypeCombo, recordSelected);*/
            		    recordSelected = addressTypeCombo.getStore().getAt(0);
            		    var currentForm = tabPanelForm;
            		    addressTypeCombo.setValue(recordSelected);
            		    this$.onSelectionAddressTypeCombo(addressTypeCombo, recordSelected, tabPanelForm);
                	}
                }
            });
        }else if(tabPanelForm.personType == 'FACULTY'){
        	this$.sendGetAjaxRequest(SERVERURL.FIND_FACULTY_PERSONAL_INFORMATION_DETAILS, 'GET', params, function(option, success, response) {
                if (success) {
                    if (!isNullOrEmpty(response.responseText)) {
                        var data = Ext.decode(response.responseText);
                        var person = data.person;
                        if(!isEmpty(person)){
                        	/*data.gender = person['gender'];
                        	data.category = person['category'];
                        	data.maritalStatus = person['maritalStatus'];
                        	data.birthDate = person['birthDate'];
                        	data.bloodGroup = person['bloodGroup'];
                        	data.salutation = person['salutation'];
                        	data.castCategory = person['castCategory'];
                        	data.country = person['country'];
                        	data.nationality = person['nationality'];
                        	data.religion = person['religion'];
                        	data.birthDate = person['birthDate'];
                        	data.mobileCountryCode = person['mobileCountryCode'];
                        	data.mobileNumber = person['mobileNumber'];
                        	data.phoneCountryCode = person['phoneCountryCode'];
                        	data.phoneNo = person['phoneNo'];
                        	var bankDetail = person.bankDetail;*/
                        	var addressDetails = person.personAddresses;
                        	/*if(!isEmpty(bankDetail)){
                        		data.bankName = bankDetail.bankName;
                        		data.accountNumber = bankDetail.accountNumber;
                        		data.branchName = bankDetail.branchName;
                        		data.ifsCode = bankDetail.ifsCode;
                        		data.beneficiaryName = bankDetail.beneficiaryName;
                        		data.accountTypeId = bankDetail.accountTypeId;
                        	}*/
                        	if(!isEmpty(addressDetails)){
                        		
                        		data.addressType= addressDetails[0]['addressType'].id;
                        		data.addressText= addressDetails[0]['address'].addressText;
                        		data.country = addressDetails[0]['address'].country.id;
                        		data.parentCountryRegion = addressDetails[0]['address'].parentCountryRegion.id;
                        		data.city = addressDetails[0]['address'].city.id;
                        		data.pincode = addressDetails[0]['address'].pincode;
                        	}
                        }
                       
                        tabPanelForm.setPersonData(data);
                        
                        tabPanelForm.down('#addressFieldRequestForm').getForm().setValues(data);
                        //this$.getPersonalInfoFormValue(data);
                        //personalDetailsForm.getForm().setValues(data);
                        var addressTypeCombo = tabPanelForm.down('#addressTypeItemField');
                        addressTypeCombo.setValue(data.person.personAddresses[0]['addressType'].id);
                        if (tabPanelForm.itemId == 'previousForm') {
                            this$.onPreviousFormAddressRenderer(tabPanelForm);
                        }
                    }
                }
            });
        }
        
    },

    /*
     *  Set personal details to personal details form
     *  @param tabPanelForm - tab panel form to set person data
     *  @param params - params 
     */
    setPersonalDetailsToForm: function(tabPanelForm, params) {
        var this$ = this;
        var personalDetailsForm = tabPanelForm.down('#personalInformationRquestForm');
        
        if (tabPanelForm.personType == 'STUDENT') {
			personalDetailsForm.down('#admissionIdIteamId').setVisible(false);
			personalDetailsForm.down('#personCodeField').setVisible(false);
			personalDetailsForm.down('#admissionIdIteamId').allowBlank = true;
			personalDetailsForm.down('#personCodeField').allowBlank = true;
        	this$.sendGetAjaxRequest(SERVERURL.FIND_STUDENT_PERSONAL_INFORMATION_DETAILS, 'GET', params, function(option, success, response) {
                if (success) {
                    if (!isNullOrEmpty(response.responseText)) {
                    	
                    	if (!isNullOrEmpty(tabPanelForm.down('#addressChangeForm'))) {
                    		tabPanelForm.remove(tabPanelForm.down('#addressChangeForm'));
                    	}
                    	
                        var data = Ext.decode(response.responseText);
                        if(!isNullOrEmpty(data.photoUrl)) {
                        	personalDetailsForm.down('#photo_url').setValue(data.photoUrl);
                        }
                        var haveDisabilities = personalDetailsForm.down('#haveDisabilities');
                        var haveDisabilitiesStore = personalDetailsForm.down('#haveDisabilities').getStore();
            			haveDisabilitiesStore.getProxy().extraParams={
            				type:'HaveDisabilities'
            			};
            			haveDisabilitiesStore.load();
            			
            			if(!isNullOrEmpty(data.personDisability)){
            				haveDisabilitiesStore.load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var haveDisabilitiesArray= [];
                						if(records.length > 0){
                							data.personDisability.forEach(function(persondisabilityObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === persondisabilityObj.haveDisabilities.id;
                									})[0];
                								haveDisabilitiesArray.push(result);
                							});
                							haveDisabilities.setValue(haveDisabilitiesArray);
                						}
                					}
                				}
                	        });
            			}
            			personalDetailsForm.down('#imageMarketingCheckbox').setVisible(false);
                        personalDetailsForm.down('#consentedCommunicationChannel').setVisible(false);
                        personalDetailsForm.down('#consentStatementAccepted').setVisible(false);
                        personalDetailsForm.down('#consentedCommunicationChannel').allowBlank=true;
            			personalDetailsForm.down('#consentStatementAccepted').allowBlank=true;
            			personalDetailsForm.down('#consentedCommunicationChannel').allowBlank=true;
            			personalDetailsForm.down('#consentStatementAccepted').allowBlank=true;
            			                      
            			personalDetailsForm.down('#admissionCodeIteamId').allowBlank=true;
            			personalDetailsForm.down('#admissionIdIteamId').allowBlank=true;
            			personalDetailsForm.down('#personCodeField').allowBlank=true;
            			var homeLanguageStore = personalDetailsForm.down('#homeLanguage').getStore();
            			homeLanguageStore.getProxy().extraParams={
            				type:'HomeLanguage'
            			};
            			homeLanguageStore.load();

            			var secondLanguageStore = personalDetailsForm.down('#secondLanguage').getStore();
            			secondLanguageStore.getProxy().extraParams={
            				type:'SecondLanguage'
            			};
            			secondLanguageStore.load();
            			
                        tabPanelForm.setPersonData(data);
                        this$.getPersonalInfoFormValue(data);
                        personalDetailsForm.getForm().setValues(data);
                        
                        //code for V2D-400636
                        if(!isNullOrEmpty(data.initials)){
                            personalDetailsForm.down('#initialsId').setValue(data.initials);
                        }
                        if(!isNullOrEmpty(data.birthDate)){
                        	personalDetailsForm.down('#birthDateId').setValue(dateRender(data.birthDate));
                        }
                        if(!isNullOrEmpty(data.firstName)){
                            personalDetailsForm.down('#firstNameId').setValue(data.firstName);
                        }
                        if(!isNullOrEmpty(data.lastName)){
                            personalDetailsForm.down('#lastNameId').setValue(data.lastName);
                        }
                        if(!isNullOrEmpty(data.unconditionalOfferSentDate)){
                            personalDetailsForm.down('#unconditionalOfferSentDate').setValue(dateRender(data.unconditionalOfferSentDate));
                        }
                       
                        if(personalDetailsForm.down("#studentDocUploadForm").isHidden()){
                        	personalDetailsForm.down("#studentDownloadURL").setVisible(false);
                        }
                        
                        //----------------------------------------RadioGroupStartSection------------------------------------
                        
                        if(data.isWheelChairRequired == true){
                        	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
                        	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
                	   }else
                	   {
                		   personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
                		   personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
                	   }
                      
           			if(data.isPermanentResident == true){
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
           			}else if(data.isPermanentResident == false){
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
           			}else{
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
           			}	

                      if(data.areYouRefugee == true){
                    	  personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
           			}else if (data.areYouRefugee == false){
           				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
           			}else{
           				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
               	    }
                      
                      if(data.isAsylumSeeker == true){
                    	  personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
           			}else if(data.isAsylumSeeker == false){
           				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
           			}else{
           				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
           				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
               	   }
                      
                      if(data.isTertiaryInstitution == true){
                    	  personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
                 	   }else
                 	   {
                 		  personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
                 		 personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
                 	   }
                      if(data.isEnrolledTertiaryInstitute == true){
                    	  personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
               	   }else
               	   {
               		personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
               		personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
               	   }
                      
                      if(data.isMilitarySponsored == true){
                    	  personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
                      }
                      if(data.isMilitarySponsored == false){
                    	  personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
                    	  personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
                      }

                      if(data.isBursaryRequirements == true){
                    	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
                      }
                      if(data.isBursaryRequirements == false){
                    	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
                    	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
                      }
                      if(data.diplomaticStatus == true){
                    	  personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(false);
           			}else
           			{
           				personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(false);
           				personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(true);
           			}

           			if(data.temporaryStudy == true){
           				personalDetailsForm.down("#temporaryStudyId").items.items[0].setValue(true);
           				personalDetailsForm.down("#temporaryStudyId").items.items[1].setValue(false);
           			}else
           			{
           				personalDetailsForm.down("#temporaryStudyId").items.items[0].setValue(false);
           				personalDetailsForm.down("#temporaryStudyId").items.items[1].setValue(true);
           			}
           			
           			if(data.workCriticalSkills == true){
           				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
           				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
           			}else
           			{
           				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
           				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
           			}
           			
           			if(data.postgraduateNonResidentialStudent == true){
           				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
           				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
           			}else
           			{
           				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
           				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
           			}
                      
                      if(data.pHDSponsor == 'DOD'){
                    	  personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
                      }
                      if(data.pHDSponsor == 'MYSELF'){
                    	  personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
                    	  personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
                      }
                   	
                      if(data.isAdult == true){
                    	  personalDetailsForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(false);
                 	   }else if(data.isAdult == false)
                 	   {
                 		  personalDetailsForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(false);
                 		 personalDetailsForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(true);
                 	   }
                      
                      if(data.whetherRPLApplicant == true){
                    	  personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(true);
                    	  personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(false);
               	   }else if(data.whetherRPLApplicant == false)
               	   {
               		personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(false);
               		personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(true);
               	   }
                        
                        //-----------------------------------------RadioGroupEndSection--------------------------------------
                        
                        
                       
                        if(!isNullOrEmpty(data.accountingKey)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#accountingKeyId'))){
                        		personalDetailsForm.down('#accountingKeyId').setValue(data.accountingKey);
                        	}
                        }
                        if(!isNullOrEmpty(data.validTill)){
                        	personalDetailsForm.down('#validTill').setValue(dateRender(data.validTill));
                        }
                        if (tabPanelForm.itemId == 'previousForm') {
                            this$.onPreviousFormAddressRenderer(tabPanelForm);
                        }
                        
                        personalDetailsForm.down("#currentOrLastSchoolAttended").setVisible(false);
                        personalDetailsForm.down("#currentOrLastSchoolAttended").allowBlank=true;
                        personalDetailsForm.down("#isAutomateExchange").setVisible(false);
                        
                        var ageData =personalDetailsForm.down("#ageId");
                        var currentYear = new Date(data.birthDate);
                        var todayDate = new Date();
                        var calculateAge =todayDate.getFullYear()-currentYear.getFullYear();
                        if (personalDetailsForm.down("#birthDateId").isValid()){
                           if (todayDate.getMonth() < currentYear.getMonth() || (todayDate.getMonth() === currentYear.getMonth() && todayDate.getDate() < currentYear.getDate())) {
                               calculateAge--;
                           }
                        }else{
                               calculateAge = 0;
                            }
                        ageData.setValue(calculateAge);
                        ageData.setReadOnly(true);
                        
                        if(!isNullOrEmpty(data.dateTimeOfInterview)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#dateTimeOfInterview'))){
                        		personalDetailsForm.down('#dateTimeOfInterview').setValue(data.dateTimeOfInterview);
                        	}
                        }
                        if(!isNullOrEmpty(data.identityExpiryDate)){
                        	personalDetailsForm.down('#identityExpiryDateItemId').setValue(dateRender(data.identityExpiryDate));
                        }
                        if(!isNullOrEmpty(data.admissionDate)){
                        	personalDetailsForm.down('#admissionDate').setValue(dateRender(data.admissionDate));
                        }
                        if(!isNullOrEmpty(data.maritalStatusId)){
                        	var maritalStatus = personalDetailsForm.down('#maritalStatusId');
                        	if(!isNullOrEmpty(maritalStatus)){
                        		maritalStatus.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.maritalStatusId) && !isNullOrEmpty(data.maritalStatusId.id)){
                            				maritalStatus.setValue(data.maritalStatusId.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        if(!isNullOrEmpty(data.dietPreference)){
                        	var dietPreference = personalDetailsForm.down('#dietPreferenceId');
                        	if(!isNullOrEmpty(dietPreference)){
                        		dietPreference.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.dietPreference) && !isNullOrEmpty(data.dietPreference.id)){
                            				dietPreference.setValue(data.dietPreference.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        if(!isNullOrEmpty(data.studentStatus)){
                        	var studentStatus = personalDetailsForm.down('#studentStatusItemId');
                        	if(!isNullOrEmpty(studentStatus)){
                        		studentStatus.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.studentStatus) && !isNullOrEmpty(data.studentStatus.id)){
                            				studentStatus.setValue(data.studentStatus.id);
                            			}
                            		}
                            	});
                        	}
                        }
                       
                        var FieldOfInterestStore = personalDetailsForm.down('#fieldOfInterestItemId').getStore();
                        FieldOfInterestStore.getProxy().extraParams={
            				type:'fieldOfInterest'
            			};
                        FieldOfInterestStore.load();
                        
                        if(!isNullOrEmpty(data.fieldOfInterest)){
                        	var fieldOfInterest = personalDetailsForm.down('#fieldOfInterestItemId');
                        	if(!isNullOrEmpty(fieldOfInterest)){
                        		fieldOfInterest.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.fieldOfInterest) && !isNullOrEmpty(data.fieldOfInterest.id)){
                            				fieldOfInterest.setValue(data.fieldOfInterest.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        
                        var CurrentActivityStore = personalDetailsForm.down('#currentActivity').getStore();
                        CurrentActivityStore.getProxy().extraParams={
            				type:'currentActivity'
            			};
                        CurrentActivityStore.load();
                        
                        if(!isNullOrEmpty(data.currentActivity)){
                        	var currentActivity = personalDetailsForm.down('#currentActivity');
                        	if(!isNullOrEmpty(currentActivity)){
                        		currentActivity.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.currentActivity) && !isNullOrEmpty(data.currentActivity.id)){
                            				currentActivity.setValue(data.currentActivity.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        
                        var ExamCenterCSMStore = personalDetailsForm.down('#examCenterCSM').getStore();
                        ExamCenterCSMStore.getProxy().extraParams={
            				type:'examCenterCSM'
            			};
                        ExamCenterCSMStore.load();
                        if(!isNullOrEmpty(data.examCenterCSM)){
                        	var examCenterCSMCombo = personalDetailsForm.down('#examCenterCSM');
                        	if(!isNullOrEmpty(genderCSMCombo)){
                        		examCenterCSMCombo.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.examCenterCSM) && !isNullOrEmpty(data.examCenterCSM.id)){
                            				examCenterCSMCombo.setValue(data.examCenterCSM.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        var currentEducationalInterventions = personalDetailsForm.getForm().findField('currentEducationalInterventions');                			
                		var educationalInterventionsStore = currentEducationalInterventions.getStore();
                        if(data.currentEducationalInterventions == null) {
            		    	educationalInterventionsStore.load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var educationalInterventionsArray= [];
                						if(records.length > 0){
                							data.personEducationInterventions.forEach(function(eduInterventionObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === eduInterventionObj.educationInterventions.id;
                									})[0];
                								educationalInterventionsArray.push(result);
                							});
                							currentEducationalInterventions.setValue(educationalInterventionsArray);
                						}
                					}
                				}
                	        });
            			}
                        var SADCCitizenshipStore = personalDetailsForm.down('#sadcCitizenship').getStore();
                        SADCCitizenshipStore.getProxy().extraParams={
            				type:'SADCCitizenship'
            			};
                        SADCCitizenshipStore.load();
                        
                        if(!isNullOrEmpty(data.sadcCitizenship)){
                        	var sadcCitizenship = personalDetailsForm.down('#sadcCitizenship');
                        	if(!isNullOrEmpty(sadcCitizenship)){
                        		sadcCitizenship.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.sadcCitizenship) && !isNullOrEmpty(data.sadcCitizenship.id)){
                            				sadcCitizenship.setValue(data.sadcCitizenship.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        if(!isNullOrEmpty(data.leadOwner)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#leadOwner'))){
                        		personalDetailsForm.down('#leadOwner').setValue(data.leadOwner);
                        	}
                        }
                        if(!isNullOrEmpty(data.advisorId)){
                        	var advisorId = personalDetailsForm.down('#advisorItemId');
                        	if(!isNullOrEmpty(advisorId)){
                        		advisorId.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.advisorId) && !isNullOrEmpty(data.advisorId.id)){
                            				advisorId.setValue(data.advisorId.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        
                        if(!isNullOrEmpty(data.englishProficiency)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#englishProficiency'))){
                        		personalDetailsForm.down('#englishProficiency').setValue(data.englishProficiency);
                        	}
                        }
                        if(!isNullOrEmpty(data.decisionByInterviewer)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#decisionByInterviewer'))){
                        		personalDetailsForm.down('#decisionByInterviewer').setValue(data.decisionByInterviewer);
                        	}
                        }
                        if(!isNullOrEmpty(data.commentsByInterviewer)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#commentsByInterviewer'))){
                        		personalDetailsForm.down('#commentsByInterviewer').setValue(data.commentsByInterviewer);
                        	}
                        }
                        if(!isNullOrEmpty(data.academicBankCredits)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#academicBankCredits'))){
                        		personalDetailsForm.down('#academicBankCredits').setValue(data.academicBankCredits);
                        	}
                        }
                        
                        if(!isNullOrEmpty(data.idNumberSecond)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#idNumberSecond'))){
                        		personalDetailsForm.down('#idNumberSecond').setValue(data.idNumberSecond);
                        	}
                        }
                        if(!isNullOrEmpty(data.hpcsaRegNo)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#hpcsaRegNoId'))){
                        		personalDetailsForm.down('#hpcsaRegNoId').setValue(data.hpcsaRegNo);
                        	}
                        }
                        var AreaOfResearchStore = personalDetailsForm.down('#areaOfResearchItemId').getStore();
                        AreaOfResearchStore.getProxy().extraParams={
            				type:'areaOfResearch'
            			};
                        AreaOfResearchStore.load();
                        if(!isNullOrEmpty(data.areaOfResearch)){
                        	var areaOfResearch = personalDetailsForm.down('#areaOfResearchItemId');
                        	if(!isNullOrEmpty(areaOfResearch)){
                        		areaOfResearch.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.areaOfResearch) && !isNullOrEmpty(data.areaOfResearch.id)){
                            				areaOfResearch.setValue(data.areaOfResearch.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        if(!isNullOrEmpty(data.armsOfService)){
                        	var armsOfService = personalDetailsForm.down("#armsOfService");
                        	armsOfService.getStore().load({
                        		callback: function(records, operation, success) {
                        			if (success) {
                        				for(i in records){
                        					if(data.armsOfService!==null){
                        						if(records[i].data.id==data.armsOfService.id){
                        							var armsOfServiceId =  armsOfService.setValue(records[i].data.id);
                        							var mustering = personalDetailsForm.getForm().findField('mustering');
                        							mustering.setDisabled(false);
                        							var musteringStore = mustering.getStore();
                        							musteringStore.getProxy().extraParams={
                        								armsOfServiceId:records[i].data.id
                        							};
                        							musteringStore.load({
                        								callback: function(records, operation, success) {
                        									for(i in records){
                        										if(data.mustering!==null){
                        											if(records[i].data.id==data.mustering.id){
                        												mustering.setValue(records[i].data.id);
                        											}
                        										}
                        		
                        									}

                        								}

                        							})
                        						}
                        					}
                        				}

                        			}
                        		}

                        	})
                        } 
                        if(!isNullOrEmpty(data.bankDetail)){
                        if(!isNullOrEmpty(data.bankDetail.beneficiaryNameOtherLanguage)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#beneficiaryNameOtherLanguageId'))){
                        		personalDetailsForm.down('#beneficiaryNameOtherLanguageId').setValue(data.bankDetail.beneficiaryNameOtherLanguage);
                        	}
                        }
                        }
                        if(!isNullOrEmpty(data.birthPlaceOtherLanguage)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#birthPlaceOtherLanguageItemId'))){
                        		personalDetailsForm.down('#birthPlaceOtherLanguageItemId').setValue(data.birthPlaceOtherLanguage);
                        	}
                        }
                        if(!isNullOrEmpty(data.boardNumber)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#boardNumberId'))){
                        		personalDetailsForm.down('#boardNumberId').setValue(data.boardNumber);
                        	}
                        }
                        if(!isNullOrEmpty(data.genderCSM)){
                        	var genderCSMCombo = personalDetailsForm.down('#genderId');
                        	if(!isNullOrEmpty(genderCSMCombo)){
                        		genderCSMCombo.getStore().load({
                            		callback: function(records, operation, success) {       
                            			if(!isNullOrEmpty(data.genderCSM) && !isNullOrEmpty(data.genderCSM.id)){
                            				genderCSMCombo.setValue(data.genderCSM.id);
                            			}
                            		}
                            	});
                        	}
                        }
                        if(!isNullOrEmpty(data.idtype)){
                        	var idTypeCombo = personalDetailsForm.down('#idTypeCombo');
                        	idTypeCombo.getStore().load({
                        		callback: function(records, operation, success) {       
                        			if(!isNullOrEmpty(data.idtype) && !isNullOrEmpty(data.idtype.id)){
                        				idTypeCombo.setValue(data.idtype.id);
                        			}
                        		}
                        	});
                        }
                        var panelContiner = personalDetailsForm.down('#serviceStopPanelId');
        				var indx = 0;
        				if(data.languageCompetency.length>0){
        					panelContiner.removeAll();
        					var record=data.languageCompetency;
        					data.languageCompetency.forEach(function(obj){
        						var panelItem = new Array();
        						var departmentId =obj.multiLanguage.employeeLanguage;
        						var multiLanguage =obj.multiLanguage.id;
        						var read =	obj.read.id;
        						var speak =obj.speak.id;
        						var write =	obj.write.id;
        						var langId=obj.id
        						var weightage = obj.weightage;
        						if(panelContiner.items.length == 0){
        							panelItem.push({
        								plugins: "formlabelrequired",
        								xtype : 'fieldcontainer',
        								layout : 'hbox',
        								width: '100%',
        								scope: this$,
        								defaults : {
        									labelAlign : 'top'
        								},
        								items:[{
        									xtype: 'hidden',
        									itemId:'langItemId',
        									name: 'langId',
        									value: langId
        							},{
        									xtype: 'customcombobox',
        									width: 226,
        									name: 'employeeLanguage',
        									itemId : 'employeeLanguage',
        									fieldLabel:getCommonTranslation('LANGUAGE'),
        									store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
        									valueField: 'id',
        									displayField: 'value',
        									editable: false,
        									typeAhead: false,
        									rowIndx:indx,
        									forceSelection:true,
        									listConfig: {
        										listeners: {
        											beforeshow: function(picker) {
        												picker.minWidth = picker.up('combobox').getSize().width;
        											}
        										}
        									},
        									listeners:{
        										render: function(combo){
        											var cDepartmentStore= combo.getStore();
        											cDepartmentStore.getProxy().extraParams = {
        												limit:-1
        											};
        											cDepartmentStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(multiLanguage);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										},
        										select:function(obj,rec,value){
        											var departmentId=rec[0].get('id');
        											var flag = true;
        											var pnlMain = obj.up("#serviceStopPanelId");
        											var rowIndx = obj.rowIndx;
        											if(!isNullOrEmpty(pnlMain)){
        												pnlMain.items.each(function(item, index, items) {
        													var deptNameVal = item.down("[name=employeeLanguage]").getValue();
        													if(departmentId == deptNameVal && rowIndx != index){
        														flag = false;
        							        					return false;
        													}
        												});
        												
        												if(flag){
        													var nextSiblingField = obj.nextSibling();
        													var write = obj.nextSibling().nextSibling();
        													var speak = obj.nextSibling().nextSibling().nextSibling();
        													nextSiblingField.reset();
        													write.reset();
        													speak.reset();
        													if (departmentId > 0) {
        														var writeStore=write.getStore();
        														var speakStore=speak.getStore();
        														
        														var store=nextSiblingField.getStore();
        														store.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														store.load();
        														writeStore.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														writeStore.load();
        														speakStore.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														speakStore.load();
        													}
        												}
        												else{
        													obj.reset();
        													var nextSiblingField = obj.nextSibling();
        													var write = obj.nextSibling().nextSibling();
        													var speak = obj.nextSibling().nextSibling().nextSibling();
        													nextSiblingField.reset();
        													write.reset();
        													speak.reset();
        													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
        													return false;
        												}
        											}
        										}
        									}
        								},
        								{
        									xtype: 'customcombobox',
        									name: 'read',
        									itemId : 'readItemId',
        									editable: false,
        									valueField: 'id',
        									displayField: 'value',
        									fieldLabel:getCommonTranslation('READ'),
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									width: 226,
        									listeners: {
        										render: function(combo) {
        											var readStore= combo.getStore();
        											readStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											readStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(read);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},{    
        									xtype: 'customcombobox',
        									name: 'write',
        									itemId : 'writeItemId',
        									fieldLabel: getCommonTranslation('WRITE'),
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									editable: false,
        									valueField: 'id',
        									displayField: 'value',
        									width: 226,
        							         listeners: {
        										render: function(combo) {
        											var writeStore= combo.getStore();
        											writeStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											writeStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(write);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},{    
        									xtype: 'customcombobox',
        									name: 'speak',
        								    itemId : 'speakItemId',
        									valueField: 'id',
        									displayField: 'value',
        									fieldLabel: getCommonTranslation('SPEAK'),
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									editable: false,
        									width: 191,
        									listeners: {
        										render: function(combo) {
        											var speakStore= combo.getStore();
        											speakStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											speakStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(speak);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},{
        									xtype: 'button',
        									itemId: 'stopBtn',
        									cls: 'CustomBodyBtnSettings',
        									text: getCommonTranslation('ADDBUTTONTEXT'),
        									tooltip: getCommonTranslation('ADD'),
        									style:{
        										marginTop:'30px'
        									},
        									listeners: {
        								        afterrender: function (btn) {
        								        	if(tabPanelForm.itemId == 'previousForm'){
        								        		btn.setDisabled(true);
        								        	}
        								        }
        								    }
        								}]
        							});
        						}else{
        							panelItem.push({
        								xtype : 'fieldcontainer',
        								layout : 'hbox',
        								width: '100%',
        								scope: this$,
        								defaults : {
        									labelAlign : 'top',
        								},
        								layout : {
        									type : 'hbox'
        								},
        								items:[{
        									xtype: 'hidden',
        									itemId:'langItemId',
        									name: 'langId',
        									value: langId
        							},{
        									xtype: 'customcombobox',
        									width: 226,
        									name: 'employeeLanguage',
        									store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
        									valueField: 'id',
        									displayField: 'value',
        									editable: false,
        									typeAhead: false,
        									rowIndx:indx,
        									forceSelection:true,
        									listConfig: {
        										listeners: {
        											beforeshow: function(picker) {
        												picker.minWidth = picker.up('combobox').getSize().width;
        											}
        										}
        									},
        									listeners:{
        										render: function(combo){
        											var cDepartmentStore= combo.getStore();
        											cDepartmentStore.getProxy().extraParams = {
        												limit:-1
        											};
        											cDepartmentStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(multiLanguage);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										},
        										select:function(obj,rec,value){
        											var departmentId=rec[0].get('id');
        											var flag = true;
        											var pnlMain = obj.up("#serviceStopPanelId");
        											var rowIndx = obj.rowIndx;
        											if(!isNullOrEmpty(pnlMain)){
        												pnlMain.items.each(function(item, index, items) {
        													var deptNameVal = item.down("[name=employeeLanguage]").getValue();
        													if(departmentId == deptNameVal && rowIndx != index){
        														flag = false;
        							        					return false;
        													}
        												});
        												
        												if(flag){
        													var nextSiblingField = obj.nextSibling();
        													var write = obj.nextSibling().nextSibling();
        													var speak = obj.nextSibling().nextSibling().nextSibling();
        													nextSiblingField.reset();
        													write.reset();
        													speak.reset();
        													if (departmentId > 0) {
        														var writeStore=write.getStore();
        														var speakStore=speak.getStore();
        														
        														var store=nextSiblingField.getStore();
        														store.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														store.load();
        														writeStore.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														writeStore.load();
        														speakStore.getProxy().extraParams = {
        															limit:-1,
        															employeeLanguage : departmentId
        														};
        														speakStore.load();
        													}
        												}
        												else{
        													obj.reset();
        													var nextSiblingField = obj.nextSibling();
        													var write = obj.nextSibling().nextSibling();
        													var speak = obj.nextSibling().nextSibling().nextSibling();
        													nextSiblingField.reset();
        													write.reset();
        													speak.reset();
        													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
        													return false;
        												}
        											}
        										}
        									}
        								},{    
        									xtype: 'customcombobox',
        									name: 'read',
        									width: 226,
        									valueField: 'id',
        									displayField: 'value',
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									editable: false,
        									listeners: {
        										render: function(combo) {
        											var readStore= combo.getStore();
        											readStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											readStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(read);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},
        								{    
        									xtype: 'customcombobox',
        									name: 'write',
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									editable: false,
        									width: 226,
        									valueField: 'id',
        									displayField: 'value',
        									listeners: {
        										render: function(combo) {
        											var writeStore= combo.getStore();
        											writeStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											writeStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(write);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},{    
        									xtype: 'customcombobox',
        									name: 'speak',
        									store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
        									width: 191,
        									valueField: 'id',
        									displayField: 'value',
        									editable: false,
        									listeners: {
        										render: function(combo) {
        											var speakStore= combo.getStore();
        											speakStore.getProxy().extraParams = {
        												limit:-1,
        												employeeLanguage : departmentId
        											};
        											speakStore.load({
        												callback:function(record, operation, success){
        													combo.setValue(speak);
        												}
        											});
        											if(tabPanelForm.itemId == 'previousForm'){
														combo.setReadOnly(true);
        								        	}
        										}
        									}
        								},{
        									xtype: 'button',
        									glyph: ICONGLYPH.DELETEGLYPH,
        									itemId: 'languageDeleteButton1',
        									width: 'auto',
        									cls: 'CustomBodyBtnReject',
        									tooltip: getCommonTranslation('DELETETOOLTIP'),
        									width:40,
        									style:{
        										marginTop:'2px'
        									},
        									listeners: {
        								        afterrender: function (btn) {
        								        	if(tabPanelForm.itemId == 'previousForm'){
        								        		btn.setDisabled(true);
        								        		tabPanelForm.down("#stopBtn").setDisabled(true);
        								        	}
        								        }
        								    }
        								}]

        							});
        						}
        						panelContiner.add(panelItem);
        						indx = indx + 1; 
        						panelContiner.doLayout();
        					});
        				}
                    }
                }
            });
        }else if(tabPanelForm.personType == 'FACULTY'){
        	this$.sendGetAjaxRequest(SERVERURL.FIND_FACULTY_PERSONAL_INFORMATION_DETAILS, 'GET', params, function(option, success, response) {
                if (success) {
                    if (!isNullOrEmpty(response.responseText)) {
                        var data = Ext.decode(response.responseText);
                        var person = data.person;
                        if(!isEmpty(person)){
                        	data.genderCSM = person['genderCSM'];
                        	data.category = person['category'];
                        	data.maritalStatus = person['maritalStatus'];
                        	data.birthDate = person['birthDate'];
                        	data.bloodGroup = person['bloodGroup'];
                        	data.salutation = person['salutation'];
                        	data.castCategory = person['castCategory'];
                        	data.country = person['country'];
                        	data.nationality = person['nationality'];
                        	data.religion = person['religion'];
                        	data.birthDate = person['birthDate'];
                        	data.mobileCountryCode = person['mobileCountryCode'];
                        	data.mobileNumber = person['mobileNumber'];
                        	data.phoneCountryCode = person['phoneCountryCode'];
                        	data.phoneNo = person['phoneNo'];
                        	data.domicile = person['domicile'];
                        	data.alternateEmailId = person['alternateEmailId'];
                        	data.phoneAreaCode = person['phoneAreaCode'];
                        	data.nationalID = person['nationalID'];
                        	
                        	var bankDetail = person.bankDetail;
                        	var addressDetails = person.personAddresses
                        	var addressFieldRequestForm= tabPanelForm.down('#addressFieldRequestForm');
                        	if(!isEmpty(bankDetail)){
                        		data.bankName = bankDetail.bankName;
                        		data.accountNumber = bankDetail.accountNumber;
                        		data.branchName = bankDetail.branchName;
                        		data.ifsCode = bankDetail.ifsCode;
                        		data.beneficiaryName = bankDetail.beneficiaryName;
                        		data.accountTypeId = bankDetail.accountTypeId;
                        	}
                        	
                        }
                       
                        tabPanelForm.setPersonData(data);
                        tabPanelForm.show();
                         this$.getCommonWindow().down('#currentForm').show();
                        
                        addressFieldRequestForm.getForm().setValues(data);
                        //this$.getPersonalInfoFormValue(data);
                        personalDetailsForm.getForm().setValues(data);
                        var addressTypeCombo = tabPanelForm.down('#addressTypeItemField');
                        if(!isEmpty(addressDetails)){
                        	addressDetails.forEach(function(obj){
                        		if(obj.addressType.id == 5){
                        			var addressData = obj['address'];
                            		//data.addressType= addressData.id;
                            		//data.addressText= addressData.addressText;
                            		//data.country = addressData.country.id;
                            		//data.parentCountryRegion = addressData.parentCountryRegion.id;
                            		//data.city = addressData.city.id;
                            		//data.pincode = addressData.pincode;

                            		addressFieldRequestForm.down('#addressText').setValue(addressData.addressText);
                            		
                            		var addressTypeFld =  addressTypeCombo;
                            		var addressTypeFldStore = addressTypeFld.getStore();
                            		addressTypeFldStore.getProxy().api.read = SERVERURL.PERSON_ADDRESS_TYPE_COMBO_STORE;
                            		addressTypeFldStore.load({
                            			callback: function(records, operation, success) {
                            				if (success) {
                            					addressTypeFld.setValue(addressData.addressType.id);
                            					var countryID = addressFieldRequestForm.down('#countryId');
                                        		var countryStore=countryID.getStore();
                                        		countryStore.load({
                                        			callback: function(records, operation, success) {
                                        				if (success) {
                                        					countryID.setValue(addressData.country);
                                        				}
                                        			}
                                        		});

                                        		var countryRegion = addressFieldRequestForm.down('#parentCountryRegionId');
                                        		var countryRegionStore=countryRegion.getStore();

                                        		countryRegionStore.getProxy().extraParams = {
                                        			cid: addressData.country.id
                                        		};
                                        		countryRegionStore.load({
                                        			callback: function(records, operation, success) {
                                        				if (success) {
                                        					countryRegion.setValue(addressData.parentCountryRegion);
                                        				}
                                        			}
                                        		});
                                        		var cityId = addressFieldRequestForm.down('#cityId');
                                        		var storeCity = cityId.getStore();
                                        		storeCity.getProxy().extraParams = {
                                        			id: addressData.parentCountryRegion.id
                                        		};
                                        		storeCity.load({
                                        			callback: function(records, operation, success) {
                                        				if (success) {
                                        					if(cityId)
                                        						Ext.defer(function(){
                                        							cityId.setValue(addressData.city);
                                        						},1000)
                                        						
                                        				}
                                        			}
                                        		});

                                        		addressFieldRequestForm.down('#pincodeId').setValue(addressData.pincode);
                                        		addressFieldRequestForm.down('#phoneCountryCode').setValue(addressData.phoneCountryCode);
                                        		addressFieldRequestForm.down('#phoneAreaCode').setValue(addressData.phoneAreaCode);
                                        		addressFieldRequestForm.down('#phoneNoField').setValue(addressData.phoneNo);
                                        		
                                        		addressFieldRequestForm.down('#cellCountryCode').setValue(addressData.cellCountryCode);
                                        		addressFieldRequestForm.down('#cellNo').setValue(addressData.cellNo);
                                        		
                                        		addressFieldRequestForm.down('#primaryeEmailId').setValue(addressData.primaryeEmailId);
                                        		addressFieldRequestForm.down('#alternateEmailId').setValue(addressData.alternateEmailId);
                            				}
                            			}
                            		});
                            		
                            		
                        		}
                        	});
                    	}
                        
                        if(!isNullOrEmpty(data.birthDate)){
                        	personalDetailsForm.down('#birthDateId').setValue(dateRender(data.birthDate));
                        }
                        if(!isNullOrEmpty(data.accountingKey)){
                        	if(!isNullOrEmpty(personalDetailsForm.down('#accountingKeyId'))){
                        		personalDetailsForm.down('#accountingKeyId').setValue(data.accountingKey);
                        	}
                        }
                        if(!isNullOrEmpty(data.validTill)){
                        	personalDetailsForm.down('#validTill').setValue(dateRender(data.validTill));
                        }
                        
                        if(!isNullOrEmpty(data.joiningDate)){
                        	personalDetailsForm.down('[name=joiningDate]').setValue(dateRender(data.joiningDate));
                        }
                        if(!isNullOrEmpty(data.exitDate)){
                        	personalDetailsForm.down('[name=exitDate]').setValue(dateRender(data.exitDate));
                        }
                        
                        var departmentId = data.department.id;
                        if(!isNullOrEmpty(departmentId)){
                        	var subDepartmentCombo = personalDetailsForm.down('#subDepartmentCombo');
                        	subDepartmentCombo.getStore().getProxy().extraParams = {
                        		parentId : departmentId
                        	};
                        	subDepartmentCombo.getStore().load({
                        		callback: function(records, operation, success) {       
                        			if(!isNullOrEmpty(data.subDepartment) && !isNullOrEmpty(data.subDepartment.id)){
                        				subDepartmentCombo.setValue(data.subDepartment.id);
                        			}
                        		}
                        	});
                        }
                        
                        if(!isNullOrEmpty(data.genderCSM)){
                        	var genderCSMCombo = personalDetailsForm.down('#genderId');
                        	genderCSMCombo.getStore().load({
                        		callback: function(records, operation, success) {       
                        			if(!isNullOrEmpty(data.genderCSM) && !isNullOrEmpty(data.genderCSM.id)){
                        				genderCSMCombo.setValue(data.genderCSM.id);
                        			}
                        		}
                        	});
                        }
                        
                        if (tabPanelForm.itemId == 'previousForm') {
                        	if(data.person.personAddresses.length>0){
                        		addressTypeCombo.setValue(data.person.personAddresses[0]['addressType'].id);	
                        	}
                            this$.onPreviousFormAddressRenderer(tabPanelForm);
                        }
                    }
                }
            });
        }
        
    },
    /*
     *  Need to set value in form
     */
    getPersonalInfoFormValue: function(data) {
        var this$ = this;
        this$.getPersonalInfoJsonValue(data, 'user', 'id', 'userId');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'id', 'bankDetailsId');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'version', 'bankDetailsVersion');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'bankName', 'bankName');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'accountNumber', 'accountNumber');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'branchName', 'branchName');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'ifsCode', 'ifsCode');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'beneficiaryName', 'beneficiaryName');
        this$.getPersonalInfoJsonValue(data, 'bankDetail', 'accountTypeId', 'accountTypeId');

        return data;
    },
    /*
     *  get personal info json value
     */
    getPersonalInfoJsonValue: function(data, obj, datafield, formField) {
        if (data[obj] != null && data[obj].hasOwnProperty(datafield)) {
            var dataObj = data[obj];
            data[formField] = dataObj[datafield];
        }
        return data;
    },
    /*
     *  on selection address type combo
     *  @param combo - selection data changed combo
     *  @param record - selection data changed combo record
     */
    onSelectionAddressTypeCombo: function(combo, record, personalRequestForm) {
        var this$ = this;
        var addressFieldRequestForm = personalRequestForm.down('#addressFieldRequestForm');
        var personData = personalRequestForm.getPersonData();
        var addressType = record.get('addressTypeName');
        if (!isNullOrEmpty(personData)) {
            var data = null;
            var personAddresses = null;
            if(personalRequestForm.personType == 'STUDENT'){
            	personAddresses = personData['personAddresses'];
            } else {
                personAddresses = personData.person['personAddresses'];
            }
            if (!isEmpty(personAddresses)) {
                for (var i = 0; i < personAddresses.length; i++) {
                    var obj = personAddresses[i];
                    if (obj['addressType'].value == addressType) {
                        data = obj['address'];
                        this$.mixins.AddressController.setIdFromNestedObject(data, "country");
                        this$.mixins.AddressController.setIdFromNestedObject(data, "parentCountryRegion");
                        this$.mixins.AddressController.setIdFromNestedObject(data, "countryRegion");
                        this$.mixins.AddressController.setIdFromNestedObject(data, "city");
                        this$.mixins.AddressController.setIdFromNestedObject(data, "countryRegion");
                        var countryId = data["country"];
                        var parentCountryRegionId = data["parentCountryRegion"];
                        if (countryId) {
                            this$.mixins.AddressController.setCountryDropDown(countryId, addressFieldRequestForm);
                            //this$.mixins.AddressController.setCityropDown(countryId, data["city"], addressFieldRequestForm);
                            this$.mixins.AddressController.setRegion1DropDown(countryId, data["parentCountryRegion"], addressFieldRequestForm);
                            this$.mixins.AddressController.setRegion2DropDown(data["parentCountryRegion"], data["countryRegion"], addressFieldRequestForm);
                        }
                        if (parentCountryRegionId) {
                        	this$.mixins.AddressController.setCityropDown(parentCountryRegionId, data["city"], addressFieldRequestForm);
                        }
                        addressFieldRequestForm.getForm().setValues(data);
                        break;
                    } else {
                        addressFieldRequestForm.getForm().reset();
                    }
                }
            } else {
                addressFieldRequestForm.getForm().reset();
            }
        }
    },
    /**
     *  On previous form render (show details thruogh student track request)
     */
    onPreviousFormAddressRenderer: function(previousForm) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var dataToBeChanged = serviceRequestActiveTab.getResponseData().detail.dataToBeChanged;
        if(dataToBeChanged["addressesToBeChanged"]!=undefined){
        	  var addressesToBeChanged = dataToBeChanged["addressesToBeChanged"][0];
        }else{
        	  var addressesToBeChanged = dataToBeChanged;
        }
        var addressTypeItemField = previousForm.down('#addressTypeItemField');
        if (!isEmpty(addressesToBeChanged)) {
            addressTypeItemField.setValue(addressesToBeChanged["addressTypeId"]);
            var record = addressTypeItemField.findRecordByValue(addressesToBeChanged["addressTypeId"]);

            this$.onSelectionAddressTypeCombo(addressTypeItemField, record, previousForm);
        }

    },
    addMultipleLanguage:function(obj){
	   	   var $this = this;
	   	   var currentForm = $this.getCommonWindow().down('#currentForm');
	   	   var personalDetailForm = currentForm.down('#personalInformationRquestForm');
	   	   var stopContiner = personalDetailForm.down('#serviceStopPanelId');
	   	   var indx = stopContiner.items.length;
	   	   var panelItem = new Array();
		   var insertPosition=indx;
		    panelItem.push({
		   		   xtype:'fieldcontainer',
		   		   width: '100%',
		   		   layout : 'hbox',
		   		   defaults : {
		   			   labelAlign : 'top'
		   		   },
		   		   items : [{
						xtype: 'hidden',
						itemId:'langItemId',
						name: 'langId'
				},{
						xtype : 'customcombobox',
						name : 'employeeLanguage',	
						itemId:'employeeLanguage',
						store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
						valueField: 'id',
						displayField: 'value',
						editable: false,
			            disableKeyFilter: false,
						forceSelection:true,
						width: 226,
						rowIndx:indx,
						allowBlank:false,
						listeners:{
							select:function(obj,rec,value){
								

								var departmentId=rec[0].get('id');
								var employeeLanguage =  rec[0].data.employeeLanguage;
								var flag = true;
								var pnlMain = obj.up("#serviceStopPanelId");
								var rowIndx = obj.rowIndx;
								if(!isNullOrEmpty(pnlMain)){
									pnlMain.items.each(function(item, index, items) {
										var deptNameVal = item.down("[name=employeeLanguage]").getValue();
										if(departmentId == deptNameVal && rowIndx != index){
											flag = false;
											return false;
										}
									});

									if(flag){
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										if (departmentId > 0) {
											var writeStore=write.getStore();
											var speakStore=speak.getStore();
											
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											store.load();
											writeStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											writeStore.load();
											speakStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											speakStore.load();
										}
									}
									else{
										obj.reset();
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
										return false;
									}
								}
								
							},
							change:function(obj,rec,value){
								var nextSiblingField = obj.nextSibling();
								nextSiblingField.reset();
							}
						}
					},{
						xtype : 'customcombobox',
						name : 'read',	
						itemId:'readItemId1',
					    width: 226,
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						allowBlank:false,
						editable: false,
						valueField: 'id',
						displayField: 'value',
						autoloadStore: false
					},{
						xtype : 'customcombobox',
						name : 'write',	
					    store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						itemId : 'writeItemId1',
						allowBlank:false,
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 226,
						autoloadStore: false,
					},{
						xtype : 'customcombobox',
						name : 'speak',
						itemId : 'speakItemId1',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						editable:false,
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						width: 191,
						autoloadStore: false
			   	   },{
		   			   xtype: 'button',
		   			   glyph: ICONGLYPH.DELETEGLYPH,
		   			   cls: 'CustomBodyBtnReject',
		   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		   			   width:30,
		   			   style:{
						marginTop:'2px'
					   },
		   			   listeners:{
		   				   click:function(obj){
		   					   var container = obj.up('fieldcontainer');
		   					   var panelContiner = personalDetailForm.down('#serviceStopPanelId');
		   					       panelContiner.remove(container);
		   					       personalDetailForm.getForm().checkValidity();
		   					       if(personalDetailForm.getForm().isValid()){
		   					    	   var currentForm = $this.getCommonWindow().down('#currentForm');
		   					    	   personalDetailForm.getForm().clearInvalid();
		   					    	   currentForm.down('#requestFormsubmitButtonId').setDisabled(false);
		   					       }else{
		   					    	   currentForm.down('#requestFormsubmitButtonId').setDisabled(true);
		   					       }
		   				   }
		   			   }
		   		   }]
		   	   });
	     	stopContiner.insert(insertPosition,panelItem);
	     	stopContiner.doLayout();
	     	if(currentForm.isValid()){
	     		 currentForm.down('#requestFormsubmitButtonId').setDisabled(false);
	     	}else{
		    	 currentForm.down('#requestFormsubmitButtonId').setDisabled(true);
		    }
	   },
	   
	   deleteLanguageCompentecny: function(deleteButton) {
		   	 var this$ = this;
		   	 var currentForm = this$.getCommonWindow().down('#currentForm');
		   	 var form = currentForm.down('#personalInformationRquestForm');
		     var departmentPanel = form.down('#serviceStopPanelId');
		   	 var container = deleteButton.up('fieldcontainer');
		 	 var langId= container.down('#langItemId').getValue();
		     if (container != null && departmentPanel != null) {
		   		 if (departmentPanel.items.length > 1) {
		   			 departmentPanel.remove(container);
		   		 }
		   	 }
		    if(langId!=null){
			   deleteUrl = SERVERURL.PATH_DELETE_LANAGUAGE_COMPETENCY+'?id='+ langId,
		       Ext.Ajax.request({
		           type: 'rest',
		           url: deleteUrl,
		           method: 'DELETE',
		           headers: {
		               'Content-Type': 'application/json'
		           },
		           success: function(form, action) {
		           }
		       });
		   	}
		   	 form.getForm().checkValidity();
		},
	   
    onSelectionLanguage: function(combo, record, form) {
    	
  	  var cityComboBox = combo.nextSibling();
  	  var writeComboBox = combo.nextSibling().nextSibling();
  	  var speakComboBox = combo.nextSibling().nextSibling().nextSibling();
        cityComboBox.reset();
        writeComboBox.reset();
        speakComboBox.reset();
        var employeeLanguage =  record[0].raw.employeeLanguage;
        var cityStore = cityComboBox.getStore();
        cityStore.getProxy().extraParams = {
        	  limit:-1,
      	  employeeLanguage: employeeLanguage
        };
        cityStore.load();

        var writeStore = writeComboBox.getStore();
        writeStore.getProxy().extraParams = {
        	  limit:-1,
      	  employeeLanguage: employeeLanguage
        };
        writeStore.load();
        
        var speakStore = speakComboBox.getStore();
        speakStore.getProxy().extraParams = {
        	  limit:-1,
      	  employeeLanguage: employeeLanguage
        };
        speakStore.load(); 
      },
    /**
     * Validate upload photo image extension
     * @param photoFileImage
     */
    validateUploadPhotoImageExtension: function(photoFileImage){
    	
    	var fileUploadPath = photoFileImage.getValue();
    	
    	if (!isNullOrEmpty(fileUploadPath)) {
    		value = fileUploadPath.replace('C:\\fakepath\\', '');
        	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
        	photoFileImage.setRawValue(newValue);
            var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
            if (extension != "gif" && extension != "png" && extension != "bmp" && extension != "jpeg" && extension != "jpg") {
            	photoFileImage.reset();
                showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
            }

        }
    },
    /**
     * Save file upload for person
     * @param  form
     * @param personId
     * @param personId
     */
    savePersonPhotoUpload: function(currentForm, personId, uplaodUrl, callback) {
        var personalInformationRquestForm = currentForm.down('#personalInformationRquestForm');
        var photouploadform = personalInformationRquestForm.down('photouploadform');
        var photoFileImage = personalInformationRquestForm.down('#photoFileImage');
        var fileUploadPath = photoFileImage.getValue();
        if (!isNullOrEmpty(fileUploadPath)) {
        	
        	photouploadform.getForm().submit({
                method: 'POST',
                url: uplaodUrl,
                params: {
                    personId: personId
                },
                success: function(response, action) {
                    callback(response, action, true);
                }
            });
        }else{
        	var photo = currentForm.getValues().photo_url;
        	var action = {
        		    response: {
        		        responseText: Ext.encode({
        		            success: true,
        		            path: photo
        		        })
        		    }
        		};
        	callback(null, action, true);
        }


    },

    /**
     *  On previous form render (show details thruogh student track request)
     */
    createPersonalDetailFormJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var currentForm = this$.getCommonWindow().down("#currentForm");
        var personalInformationRquestForm = currentForm.down('#personalInformationRquestForm');
        var personalInfoData = personalInformationRquestForm.getValues();

        this$.savePersonPhotoUpload(currentForm, personId, SERVERURL.SERVICE_REQUEST_IMAGE_UPLOAD, function(response, action, success) {
            if (success) {
            	if(!isNullOrEmpty(action)){
            		var data = Ext.decode(action.response.responseText);
                    personalInfoData.photoUrl = data.path;
            	}else{
            		personalInfoData.photoUrl = null;
            	}
                
            	if (currentForm.personType == 'FACULTY') {
            		
	                var addressFieldRequestForm = currentForm.down('#addressFieldRequestForm');
	                var addressTypeCombo = currentForm.down('#addressTypeItemField');
	
	                //Address Json
	                var addressFormdata = addressFieldRequestForm.getValues();
	                addressFormdata.addressId = addressFormdata.id;
	                addressFormdata.addressTypeId = addressTypeCombo.getValue();
	                addressFormdata.countryId = addressFormdata.country;
	                addressFormdata.cityId = addressFormdata.city;
	                addressFormdata.pincode = addressFormdata.pincode;
	                if (!isNullOrEmpty(addressFormdata.parentCountryRegion)) {
	                    addressFormdata.countryRegionByParentRegionId = addressFormdata.parentCountryRegion;
	                } else {
	                    addressFormdata.countryRegionByParentRegionId = null;
	                }
	                if (!isNullOrEmpty(addressFormdata.countryRegion)) {
	                    addressFormdata.countryRegionByCountryRegionId = addressFormdata.countryRegion;
	                } else {
	                    addressFormdata.countryRegionByCountryRegionId = null;
	                }
	
	
	                delete addressFormdata.id;
	                delete addressFormdata.version;
	                delete addressFormdata.addressType;
	                delete addressFormdata.country;
	                delete addressFormdata.customData;
	                delete addressFormdata.city;
	                delete addressFormdata.parentCountryRegion;
	                delete addressFormdata.countryRegion;

            	}
                
                // Pesonal Information

                personalInfoData.personId = serviceRequestActiveTab.getPersonId();
                if(Ext.isDefined(personalInfoData.salutation)){
                  personalInfoData.salutationId = personalInfoData.salutation.id;
                }
                if(Ext.isDefined(personalInfoData.country)){
                	personalInfoData.countryId = personalInfoData.country.id;
                }
                if(Ext.isDefined(personalInfoData.nationality)){
                	personalInfoData.nationalityId = personalInfoData.nationality.id;
                }
                if (personalInfoData.castCategory) {
                    personalInfoData.castCategoryId = personalInfoData.castCategory.id;
                }
                if (personalInfoData.religion) {
                    personalInfoData.religionId = personalInfoData.religion.id;
                }
                if (isNullOrEmpty(personalInfoData.bloodGroup)) {
                    delete personalInfoData.bloodGroup;
                }
                if (isNullOrEmpty(personalInfoData.maritalStatus)) {
                    delete personalInfoData.maritalStatus;
                }
                if (isNullOrEmpty(personalInfoData.armsOfService)) {
                    delete personalInfoData.armsOfService;
                }
                if (isNullOrEmpty(personalInfoData.mustering)) {
                    delete personalInfoData.mustering;
                }
                personalInfoData.ifscCode = personalInfoData.ifsCode;
                personalInfoData.physicalCharacteristicId = personalInfoData.phyId;
             //   personalInfoData.genderId = personalInfoData.genderCSM;
                if(isNullOrEmpty(personalInfoData.hairColor)){
                	personalInfoData.hairColor = null;
                }
                if(isNullOrEmpty(personalInfoData.eyeColor)){
                	personalInfoData.eyeColor = null;
                }
                if (currentForm.personType == 'FACULTY') {
                    personalInfoData.designationId = personalInfoData.designation.id;
                    personalInfoData.departmentId = personalInfoData.department.id;
                    if(!isEmpty(personalInfoData.subDepartment)){
                    	personalInfoData.subDepartmentId = personalInfoData.subDepartment.id;
                    }else{
                    	personalInfoData.subDepartmentId = null;
                    }
                    delete personalInfoData.designation;
                    delete personalInfoData.department;
                    delete personalInfoData.subDepartment;
                } else {
                    delete personalInfoData.isMidtermJoinee;
                }

                delete personalInfoData.id;
                delete personalInfoData.version;
                delete personalInfoData.code;
                delete personalInfoData.personVersion;
                delete personalInfoData.salutation;
                delete personalInfoData.castCategory;
                delete personalInfoData.country;
                delete personalInfoData.nationality;
                delete personalInfoData.religion;
                delete personalInfoData.isEmployeeOfOrganization;
                delete personalInfoData.userId;
                delete personalInfoData.bankDetailsVersion;
                delete personalInfoData.phyId;
                delete personalInfoData.phyVersion;
                delete personalInfoData.ifsCode;
                delete personalInfoData.hasAppliedForPlacement;
                delete personalInfoData.customData;
                delete personalInfoData.age;
                
                delete personalInfoData.specifyOther;
                delete personalInfoData.isLearnerSACitizen;
                delete personalInfoData.isRegistrationContract;
               // delete personalInfoData.genderCSM;
                
                data = personalInfoData;
                data.dataToBeChangedType = "PERSONALDATATOBECHANGED";
                data.relationship = "SELF";

                if (currentForm.personType == 'FACULTY') {
	                var addressesToBeChanged = new Array();
	                addressesToBeChanged.push(addressFormdata);
	                data.addressesToBeChanged = addressesToBeChanged;
                }
                //var z = xyz.i;
                if(currentForm.down('#profileImageItemId')) {
                	
                	if(currentForm.down('#profileImageItemId').down('#hiddenImageItemId').value == undefined || isNullOrEmpty(currentForm.down('#profileImageItemId').down('#hiddenImageItemId').value)){
                		data.photoUrl= personalInfoData.photoUrl
                	}
                	else{
                		data.photoUrl= currentForm.down('#profileImageItemId').down('#hiddenImageItemId').value
                	}
                }
                delete personalInfoData.photo_url;
                serviceRequestActiveTab.setFormData(data);
                this$.getCommonWindow().close();
            }

        });




    },
    
    createPersonalAddressDetailFormJson: function(){ 

        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var currentForm = this$.getCommonWindow().down("#currentForm");
        //var personalInformationRquestForm = currentForm.down('#personalInformationRquestForm');
        //var personalInfoData = personalInformationRquestForm.getValues();
        var personalInfoData = currentForm.getValues();

        // this$.savePersonPhotoUpload(currentForm, personId, SERVERURL.SERVICE_REQUEST_IMAGE_UPLOAD, function(response, action, success) {
          //  if (success) {
            	/*if(!isNullOrEmpty(action)){
            		var data = Ext.decode(action.response.responseText);
                    personalInfoData.photoUrl = data.path;
            	}else{
            		personalInfoData.photoUrl = null;
            	}*/

                var addressFieldRequestForm = currentForm.down('#addressFieldRequestForm');
                var addressTypeCombo = currentForm.down('#addressTypeItemField');

                //Address Json
                var addressFormdata = addressFieldRequestForm.getValues();
                addressFormdata.addressId = addressFormdata.id;
                addressFormdata.addressTypeId = addressTypeCombo.getValue();
                addressFormdata.countryId = addressFormdata.country;
                addressFormdata.cityId = addressFormdata.city;
                if (!isNullOrEmpty(addressFormdata.parentCountryRegion)) {
                    addressFormdata.countryRegionByParentRegionId = addressFormdata.parentCountryRegion;
                } else {
                    addressFormdata.countryRegionByParentRegionId = null;
                }
                if (!isNullOrEmpty(addressFormdata.countryRegion)) {
                    addressFormdata.countryRegionByCountryRegionId = addressFormdata.countryRegion;
                } else {
                    addressFormdata.countryRegionByCountryRegionId = null;
                }


                delete addressFormdata.id;
                delete addressFormdata.version;
                delete addressFormdata.addressType;
                delete addressFormdata.country;
                delete addressFormdata.customData;
                delete addressFormdata.city;
                delete addressFormdata.parentCountryRegion;
                delete addressFormdata.countryRegion;

                // Pesonal Information

                personalInfoData.personId = serviceRequestActiveTab.getPersonId();
                if(Ext.isDefined(personalInfoData.salutation)){
                  personalInfoData.salutationId = personalInfoData.salutation.id;
                }
                if(Ext.isDefined(personalInfoData.country)){
                	personalInfoData.countryId = personalInfoData.country.id;
                }
                if(Ext.isDefined(personalInfoData.nationality)){
                	personalInfoData.nationalityId = personalInfoData.nationality.id;
                }
                if (personalInfoData.castCategory) {
                    personalInfoData.castCategoryId = personalInfoData.castCategory.id;
                }
                if (personalInfoData.religion) {
                    personalInfoData.religionId = personalInfoData.religion.id;
                }
                if (isNullOrEmpty(personalInfoData.bloodGroup)) {
                    delete personalInfoData.bloodGroup;
                }
                if (isNullOrEmpty(personalInfoData.maritalStatus)) {
                    delete personalInfoData.maritalStatus;
                }
                personalInfoData.ifscCode = personalInfoData.ifsCode;
                personalInfoData.physicalCharacteristicId = personalInfoData.phyId;
               // personalInfoData.genderId = personalInfoData.genderCSM;
                if(isNullOrEmpty(personalInfoData.hairColor)){
                	personalInfoData.hairColor = null;
                }
                if(isNullOrEmpty(personalInfoData.eyeColor)){
                	personalInfoData.eyeColor = null;
                }
                if (currentForm.personType == 'FACULTY') {
                    personalInfoData.designationId = personalInfoData.designation.id;
                    personalInfoData.departmentId = personalInfoData.department.id;
                    if(!isEmpty(personalInfoData.subDepartment)){
                    	personalInfoData.subDepartmentId = personalInfoData.subDepartment.id;
                    }else{
                    	personalInfoData.subDepartmentId = null;
                    }
                    delete personalInfoData.designation;
                    delete personalInfoData.department;
                    delete personalInfoData.subDepartment;
                } else {
                    delete personalInfoData.isMidtermJoinee;
                }

                delete personalInfoData.id;
                delete personalInfoData.version;
                delete personalInfoData.code;
                delete personalInfoData.personVersion;
                delete personalInfoData.salutation;
                delete personalInfoData.castCategory;
                delete personalInfoData.country;
                delete personalInfoData.nationality;
                delete personalInfoData.religion;
                delete personalInfoData.isEmployeeOfOrganization;
                delete personalInfoData.userId;
                delete personalInfoData.bankDetailsVersion;
                delete personalInfoData.phyId;
                delete personalInfoData.phyVersion;
                delete personalInfoData.ifsCode;
                delete personalInfoData.hasAppliedForPlacement;
                delete personalInfoData.customData;
                delete personalInfoData.age;
                
                delete personalInfoData.specifyOther;
                delete personalInfoData.isLearnerSACitizen;
                delete personalInfoData.isRegistrationContract;
                delete personalInfoData.domicile;
              //  delete personalInfoData.genderCSM;
                
                var loggedInUser = this.getCurrentlyLoggedInUser();
                
                //data = personalInfoData;
                data = addressFormdata;
                //data.lastUpdatedBy = loggedInUser.id;
                data.dataToBeChangedType = "ADDRESSDETAILTOBECHANGED";
                //data.relationship = "SELF";

                //var addressesToBeChanged = new Array();
                //addressesToBeChanged.push(addressFormdata);
                //data.addressesToBeChanged = addressesToBeChanged;
                
                //var z = xyz.i;
                serviceRequestActiveTab.setFormData(data);
                this$.getCommonWindow().close();
           // }

       // });
    
    },

    /**
     * Set record to personal information form (show details thruogh student track request)
     * @param currentForm - current form
     * @param data - data to be changed data
     */
    setRecordToCurrentPersonalInformationForm: function(currentForm, data) {
        var this$ = this;
        this$.showHidePersonalDetailsFormField(currentForm);
        var personalDetailsForm = currentForm.down('#personalInformationRquestForm');

        if (!isEmpty(data)) {
            var salutation = {
                id: data.salutationId
            };
            var castCategory = {
                id: data.castCategoryId
            };
            var country = {
                id: data.countryId
            };
            var nationality = {
                id: data.nationalityId
            };
            var religion = {
                id: data.religionId
            };
            if(undefined!=data.genderId){
            	 var genderCSM = {
                     	id:data.genderId	
                     };	
            }else if(!isNullOrEmpty(data.genderCSM)){
            	 var genderCSM = {
                     	id:data.genderCSM.id	
                     };
            }
            if(!isNullOrEmpty(data.dietPreference)){
            	var dietPreference = personalDetailsForm.down('#dietPreferenceId');
            	if(!isNullOrEmpty(dietPreference)){
            		dietPreference.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.dietPreference) && !isNullOrEmpty(data.dietPreference.id)){
                				dietPreference.setValue(data.dietPreference.id);
                			}
                		}
                	});
            	}
            }
            
            if(!isNullOrEmpty(data.idtype)){
            	var idtype = personalDetailsForm.down('#idTypeCombo');
            	if(!isNullOrEmpty(idtype)){
            		idtype.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.idtype) && !isNullOrEmpty(data.idtype.id)){
                				idtype.setValue(data.idtype.id);
                			}
                		}
                	});
            	}
            }
            
            if(!isNullOrEmpty(data.maritalStatusId)){
            	var maritalStatusId = personalDetailsForm.down('#maritalStatusId');
            	if(!isNullOrEmpty(maritalStatusId)){
            		maritalStatusId.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.maritalStatusId) && !isNullOrEmpty(data.maritalStatusId.id)){
                				maritalStatusId.setValue(data.maritalStatusId.id);
                			}
                		}
                	});
            	}
            }
            
            if(!isNullOrEmpty(data.studentStatus)){
            	var studentStatus = personalDetailsForm.down('#studentStatusItemId');
            	if(!isNullOrEmpty(studentStatus)){
            		studentStatus.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.studentStatus) && !isNullOrEmpty(data.studentStatus.id)){
                				studentStatus.setValue(data.studentStatus.id);
                			}
                		}
                	});
            	}
            }
            
            var haveDisabilities = personalDetailsForm.down('#haveDisabilities');
            if(!isNullOrEmpty(haveDisabilities)){
            var haveDisabilitiesStore = haveDisabilities.getStore();
			haveDisabilitiesStore.getProxy().extraParams={
				type:'HaveDisabilities'
			};
			haveDisabilitiesStore.load();
            if(data.personDisability != null) {
    			haveDisabilitiesStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						var haveDisabilitiesArray= [];
    						if(records.length > 0){
    							data.personDisability.forEach(function(persondisabilityObj){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === persondisabilityObj.haveDisabilities.id;
    									})[0];
    								haveDisabilitiesArray.push(result);
    							});
    							haveDisabilities.setValue(haveDisabilitiesArray);
    						}
    					}
    				}
    	        });
			}
            }
            var currentEducationalInterventions = personalDetailsForm.getForm().findField('currentEducationalInterventions'); 
            if(!isNullOrEmpty(currentEducationalInterventions)){
    		var educationalInterventionsStore = currentEducationalInterventions.getStore();
            if(data.currentEducationalInterventions == null) {
		    	educationalInterventionsStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						var educationalInterventionsArray= [];
    						if(records.length > 0){
    							data.personEducationInterventions.forEach(function(eduInterventionObj){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === eduInterventionObj.educationInterventions.id;
    									})[0];
    								educationalInterventionsArray.push(result);
    							});
    							currentEducationalInterventions.setValue(educationalInterventionsArray);
    						}
    					}
    				}
    	        });
			}
            }
            if(!isNullOrEmpty(data.armsOfService)){
            	var armsOfService = personalDetailsForm.down("#armsOfService");
            	armsOfService.getStore().load({
            		callback: function(records, operation, success) {
            			if (success) {
            				for(i in records){
            					if(data.armsOfService!==null){
            						if(records[i].data.id == data.armsOfService.id){
            							var armsOfServiceId =  armsOfService.setValue(records[i].data.id);
            							var mustering = personalDetailsForm.getForm().findField('mustering');
            							mustering.setDisabled(false);
            							var musteringStore = mustering.getStore();
            							musteringStore.getProxy().extraParams={
            								armsOfServiceId:records[i].data.id
            							};
            							musteringStore.load({
            								callback: function(records, operation, success) {
            									for(i in records){
            										if(data.mustering !== null){
            											if(records[i].data.id == data.mustering.id){
            												mustering.setValue(records[i].data.id);
            											}
            										}
            		
            									}

            								}

            							})
            						}
            					}
            				}

            			}
            		}

            	})
            }
            
            var FieldOfInterest = personalDetailsForm.down('#fieldOfInterestItemId');
            if(!isNullOrEmpty(FieldOfInterest)){
            var FieldOfInterestStore = FieldOfInterest.getStore();
            FieldOfInterestStore.getProxy().extraParams={
				type:'fieldOfInterest'
			};
            FieldOfInterestStore.load();
            
            if(!isNullOrEmpty(data.fieldOfInterest)){
            	var fieldOfInterest = personalDetailsForm.down('#fieldOfInterestItemId');
            	if(!isNullOrEmpty(fieldOfInterest)){
            		fieldOfInterest.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.fieldOfInterest) && !isNullOrEmpty(data.fieldOfInterest.id)){
                				fieldOfInterest.setValue(data.fieldOfInterest.id);
                			}
                		}
                	});
            	}
            }
            }
            var CurrentActivity = personalDetailsForm.down('#currentActivity');
            if(!isNullOrEmpty(CurrentActivity)){
            var CurrentActivityStore = CurrentActivity.getStore();
            CurrentActivityStore.getProxy().extraParams={
				type:'currentActivity'
			};
            CurrentActivityStore.load();
            
            if(!isNullOrEmpty(data.currentActivity)){
            	var currentActivity = personalDetailsForm.down('#currentActivity');
            	if(!isNullOrEmpty(currentActivity)){
            		currentActivity.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.currentActivity) && !isNullOrEmpty(data.currentActivity.id)){
                				currentActivity.setValue(data.currentActivity.id);
                			}
                		}
                	});
            	}
            }
            }
            if(!isNullOrEmpty(data.advisorId)){
            	var advisorId = personalDetailsForm.down('#advisorItemId');
            	if(!isNullOrEmpty(advisorId)){
            		advisorId.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.advisorId) && !isNullOrEmpty(data.advisorId.id)){
                				advisorId.setValue(data.advisorId.id);
                			}
                		}
                	});
            	}
            }
            var SADCCitizenship = personalDetailsForm.down('#sadcCitizenship');
            if(!isNullOrEmpty(SADCCitizenship)){
            var SADCCitizenshipStore = SADCCitizenship.getStore();
            SADCCitizenshipStore.getProxy().extraParams={
				type:'SADCCitizenship'
			};
            SADCCitizenshipStore.load();
            
            if(!isNullOrEmpty(data.sadcCitizenship)){
            	var sadcCitizenship = personalDetailsForm.down('#sadcCitizenship');
            	if(!isNullOrEmpty(sadcCitizenship)){
            		sadcCitizenship.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.sadcCitizenship) && !isNullOrEmpty(data.sadcCitizenship.id)){
                				sadcCitizenship.setValue(data.sadcCitizenship.id);
                			}
                		}
                	});
            	}
            }
            }
            var AreaOfResearch = personalDetailsForm.down('#areaOfResearchItemId');
            if(!isNullOrEmpty(AreaOfResearch)){
            var AreaOfResearchStore = AreaOfResearch.getStore();
            AreaOfResearchStore.getProxy().extraParams={
				type:'areaOfResearch'
			};
            AreaOfResearchStore.load();
            if(!isNullOrEmpty(data.areaOfResearch)){
            	var areaOfResearch = personalDetailsForm.down('#areaOfResearchItemId');
            	if(!isNullOrEmpty(areaOfResearch)){
            		areaOfResearch.getStore().load({
                		callback: function(records, operation, success) {       
                			if(!isNullOrEmpty(data.areaOfResearch) && !isNullOrEmpty(data.areaOfResearch.id)){
                				areaOfResearch.setValue(data.areaOfResearch.id);
                			}
                		}
                	});
            	}
            }
            }
            if(!isNullOrEmpty(data.hpcsaRegNo)){
            	if(!isNullOrEmpty(personalDetailsForm.down('#hpcsaRegNoId'))){
            		personalDetailsForm.down('#hpcsaRegNoId').setValue(data.hpcsaRegNo);
            	}
            }
            if(!isNullOrEmpty(data.idNumberSecond)){
            	if(!isNullOrEmpty(personalDetailsForm.down('#idNumberSecond'))){
            		personalDetailsForm.down('#idNumberSecond').setValue(data.idNumberSecond);
            	}
            }
            if(!isNullOrEmpty(data.beneficiaryNameOtherLanguage)){
            	if(!isNullOrEmpty(personalDetailsForm.down('#beneficiaryNameOtherLanguageId'))){
            		personalDetailsForm.down('#beneficiaryNameOtherLanguageId').setValue(data.beneficiaryNameOtherLanguage);
            	}
            }
            if(!isNullOrEmpty(data.birthPlaceOtherLanguage)){
            	if(!isNullOrEmpty(personalDetailsForm.down('#birthPlaceOtherLanguageItemId'))){
            		personalDetailsForm.down('#birthPlaceOtherLanguageItemId').setValue(data.birthPlaceOtherLanguage);
            	}
            }
            if(data.isWheelChairRequired == true){
            	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
       	    }else{
       	    	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
       	    	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
       	    }
            
            if(data.isPermanentResident == true){
            	personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}else if(data.isPermanentResident == false){
				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
			}else{
				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}	
            
            if(data.isAsylumSeeker == true){
            	personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
   			}else if(data.isAsylumSeeker == false){
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
   			}else{
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
      	    }
            
            if(data.temporaryStudy == true){
				personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
				personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
			}else {
   				personalDetailsForm.down("#temporaryStudyId").items.items[0].setValue(false);
   				personalDetailsForm.down("#temporaryStudyId").items.items[1].setValue(true);
   			}
            
            if(data.areYouRefugee == true){
            	personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
   			}else if(data.areYouRefugee == false){
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
   			}else{
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
       	    }
            
            if(data.diplomaticStatus == true){
            	personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(true);
            	personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(false);
				personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(true);
			}

			if(data.workCriticalSkills == true){
				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
			}
			
			if(data.postgraduateNonResidentialStudent == true){
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
			}

			if(data.isTertiaryInstitution == true){
				personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
				personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
     	    }else{
     	    	personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
     	    	personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
     	    }
			
           if(data.isEnrolledTertiaryInstitute == true){
        	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
        	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
   	       }else{
   	    	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
   	    	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
   	       }
          
           if(data.isMilitarySponsored == true){
        	   personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
       	       personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
           }else if(data.isMilitarySponsored == false){
        	   personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
       	       personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
           } 
           
           
         /*  
           
            if(data.isWheelChairRequired == true){
            	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
       	    }else{
       	    	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
       	    	personalDetailsForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
       	    }
            
            if(data.isPermanentResident == true){
            	personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}else if(data.isPermanentResident == false){
				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
			}else{
				personalDetailsForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalDetailsForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}	
            
            if(data.isAsylumSeeker == true){
            	personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
   			}else if(data.isAsylumSeeker == false){
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
   			}else{
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
      	    }
            
            if(data.temporaryStudy == true){
				personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
				personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
			}else {
   				personalDetailsForm.down("#temporaryStudyId").items.items[0].setValue(false);
   				personalDetailsForm.down("#temporaryStudyId").items.items[1].setValue(true);
   			}
            
            if(data.areYouRefugee == true){
            	personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
            	personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
   			}else if(data.areYouRefugee == false){
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
   			}else{
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
   				personalDetailsForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
       	    }
            
            if(data.diplomaticStatus == true){
            	personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(true);
            	personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#diplomaticStatusId").items.items[0].setValue(false);
				personalDetailsForm.down("#diplomaticStatusId").items.items[1].setValue(true);
			}

			if(data.workCriticalSkills == true){
				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
				personalDetailsForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
			}
			
			if(data.postgraduateNonResidentialStudent == true){
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
			}else{
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
				personalDetailsForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
			}

			if(data.isTertiaryInstitution == true){
				personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
				personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
     	    }else{
     	    	personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
     	    	personalDetailsForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
     	    }
			
           if(data.isEnrolledTertiaryInstitute == true){
        	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
        	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
   	       }else{
   	    	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
   	    	   personalDetailsForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
   	       }
          
           if(data.isMilitarySponsored == true){
        	   personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
       	       personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
           }else if(data.isMilitarySponsored == false){
        	   personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
       	       personalDetailsForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
           }
           
           if(data.pHDSponsor == 'DOD'){
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
           }else if(data.pHDSponsor == 'MYSELF'){
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
           }

          if(data.isBursaryRequirements == true){
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
          }else if(data.isBursaryRequirements == false){
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
          }
          
          if(data.whetherRPLApplicant == true){
        	  personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(true);
        	  personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(false);
   	      }else if(data.whetherRPLApplicant == false){
   	    	personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(false);
   	    	personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(true);
   	      }
          
          this.isRadioButtonTrue(data);
          
          if(!isNullOrEmpty(data.externalSysRefOne)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefOne'))){
          		personalDetailsForm.down('#externalSysRefOne').setValue(data.externalSysRefOne);
          	}
          }
          if(!isNullOrEmpty(data.externalSysRefTwo)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefTwo'))){
          		personalDetailsForm.down('#externalSysRefTwo').setValue(data.externalSysRefTwo);
          	}
          }
          if(!isNullOrEmpty(data.externalSysRefThree)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefThree'))){
          		personalDetailsForm.down('#externalSysRefThree').setValue(data.externalSysRefThree);
          	}
          } */
           
           if(data.pHDSponsor == 'DOD'){
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
           }else if(data.pHDSponsor == 'MYSELF'){
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
        	   personalDetailsForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
           }

          if(data.isBursaryRequirements == true){
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
          }else if(data.isBursaryRequirements == false){
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
        	  personalDetailsForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
          }
          
          if(data.whetherRPLApplicant == true){
        	  personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(true);
        	  personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(false);
   	      }else if(data.whetherRPLApplicant == false){
   	    	personalDetailsForm.down("#whetherRPLApplicant").items.items[0].setValue(false);
   	    	personalDetailsForm.down("#whetherRPLApplicant").items.items[1].setValue(true);
   	      }
          
          this.isRadioButtonTrue(data);
          
          if(!isNullOrEmpty(data.externalSysRefOne)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefOne'))){
          		personalDetailsForm.down('#externalSysRefOne').setValue(data.externalSysRefOne);
          	}
          }
          if(!isNullOrEmpty(data.externalSysRefTwo)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefTwo'))){
          		personalDetailsForm.down('#externalSysRefTwo').setValue(data.externalSysRefTwo);
          	}
          }
          if(!isNullOrEmpty(data.externalSysRefThree)){
          	if(!isNullOrEmpty(personalDetailsForm.down('#externalSysRefThree'))){
          		personalDetailsForm.down('#externalSysRefThree').setValue(data.externalSysRefThree);
          	}
          }
           
            data.salutation = salutation;
            data.castCategory = castCategory;
            data.country = country;
            data.nationality = nationality;
            data.religion = religion;
            data.ifsCode = data.ifscCode;
            data.genderCSM = genderCSM;
            data.initials = data.initials;
            data.firstName = data.firstName;
            data.lastName = data.lastName;
            
            if(!isNullOrEmpty(personalDetailsForm.down("#currentOrLastSchoolAttended"))){
            personalDetailsForm.down("#currentOrLastSchoolAttended").setVisible(false);
            personalDetailsForm.down("#currentOrLastSchoolAttended").allowBlank=true;
            }
            if(!isNullOrEmpty(personalDetailsForm.down("#isAutomateExchange"))){
            personalDetailsForm.down("#isAutomateExchange").setVisible(false);
            }
            var panelContiner = personalDetailsForm.down('#serviceStopPanelId');
			var indx = 0;
			if(data.languageCompetency.length>0){
				panelContiner.removeAll();
				var record=data.languageCompetency;
				data.languageCompetency.forEach(function(obj){
					var panelItem = new Array();
					var departmentId =obj.multiLanguage.employeeLanguage;
					var multiLanguage =obj.multiLanguage.id;
					var read =	obj.read.id;
					var speak =obj.speak.id;
					var write =	obj.write.id;
					var langId=obj.id
					var weightage = obj.weightage;
					if(panelContiner.items.length == 0){
						panelItem.push({
							plugins: "formlabelrequired",
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: this$,
							defaults : {
								labelAlign : 'top',
							},
							items:[{
								xtype: 'hidden',
								itemId:'langItemId',
								name: 'langId',
								value: langId
						},{
								xtype: 'customcombobox',
								width: 226,
								name: 'employeeLanguage',
								itemId : 'employeeLanguage',
								fieldLabel:getCommonTranslation('LANGUAGE'),
								store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
								valueField: 'id',
								displayField: 'value',
								editable: false,
								typeAhead: false,
								rowIndx:indx,
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(multiLanguage);
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#serviceStopPanelId");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=employeeLanguage]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												var write = obj.nextSibling().nextSibling();
												var speak = obj.nextSibling().nextSibling().nextSibling();
												nextSiblingField.reset();
												write.reset();
												speak.reset();
												if (departmentId > 0) {
													var writeStore=write.getStore();
													var speakStore=speak.getStore();
													
													var store=nextSiblingField.getStore();
													store.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													store.load();
													writeStore.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													writeStore.load();
													speakStore.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													speakStore.load();
												}
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												var write = obj.nextSibling().nextSibling();
												var speak = obj.nextSibling().nextSibling().nextSibling();
												nextSiblingField.reset();
												write.reset();
												speak.reset();
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									}
								}
							},
							{
								xtype: 'customcombobox',
								name: 'read',
								itemId : 'readItemId',
								editable: false,
								valueField: 'id',
								displayField: 'value',
								fieldLabel:getCommonTranslation('READ'),
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								width: 226,
								listeners: {
									render: function(combo) {
										var subDepartmentStore= combo.getStore();
										subDepartmentStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										subDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(read);
											}
										});
									}
								}
							},{    
								xtype: 'customcombobox',
								name: 'write',
								itemId : 'writeItemId',
								fieldLabel: getCommonTranslation('WRITE'),
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								editable: false,
								valueField: 'id',
								displayField: 'value',
								width: 226,
						         listeners: {
									render: function(combo) {
										var writeStore= combo.getStore();
										writeStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										writeStore.load({
											callback:function(record, operation, success){
												combo.setValue(write);
											}
										});
									}
								}
							},{    
								xtype: 'customcombobox',
								name: 'speak',
							    itemId : 'speakItemId',
								valueField: 'id',
								displayField: 'value',
								fieldLabel: getCommonTranslation('SPEAK'),
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								editable: false,
								width: 191,
								listeners: {
									render: function(combo) {
										var speakStore= combo.getStore();
										speakStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										speakStore.load({
											callback:function(record, operation, success){
												combo.setValue(speak);
											}
										});
									}
								}
							},{
								xtype: 'button',
								itemId: 'stopBtn',
								cls: 'CustomBodyBtnSettings',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								},
								listeners: {
								    afterrender: function (btn) {
								        btn.setDisabled(true);
								    }
								}
							}]
						});
					}else{
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: this$,
							defaults : {
								labelAlign : 'top',
							},
							layout : {
								type : 'hbox'
							},
							items:[{
								xtype: 'hidden',
								itemId:'langItemId',
								name: 'langId',
								value: langId
						},{
								xtype: 'customcombobox',
								width: 226,
								name: 'employeeLanguage',
								store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
								valueField: 'id',
								displayField: 'value',
								editable: false,
								typeAhead: false,
								rowIndx:indx,
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(multiLanguage);
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#serviceStopPanelId");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=employeeLanguage]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												var write = obj.nextSibling().nextSibling();
												var speak = obj.nextSibling().nextSibling().nextSibling();
												nextSiblingField.reset();
												write.reset();
												speak.reset();
												if (departmentId > 0) {
													var writeStore=write.getStore();
													var speakStore=speak.getStore();
													
													var store=nextSiblingField.getStore();
													store.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													store.load();
													writeStore.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													writeStore.load();
													speakStore.getProxy().extraParams = {
														limit:-1,
														employeeLanguage : departmentId
													};
													speakStore.load();
												}
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												var write = obj.nextSibling().nextSibling();
												var speak = obj.nextSibling().nextSibling().nextSibling();
												nextSiblingField.reset();
												write.reset();
												speak.reset();
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									}
								}
							},{    
								xtype: 'customcombobox',
								name: 'read',
								width: 226,
								valueField: 'id',
								displayField: 'value',
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								editable: false,
								listeners: {
									render: function(combo) {
										var speakStore= combo.getStore();
										speakStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										speakStore.load({
											callback:function(record, operation, success){
												combo.setValue(read);
											}
										});
									}
								}
							},
							{    
								xtype: 'customcombobox',
								name: 'write',
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								editable: false,
								width: 226,
								valueField: 'id',
								displayField: 'value',
								listeners: {
									render: function(combo) {
										var speakStore= combo.getStore();
										speakStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										speakStore.load({
											callback:function(record, operation, success){
												combo.setValue(write);
											}
										});
									}
								}
							},{    
								xtype: 'customcombobox',
								name: 'speak',
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								width: 191,
								valueField: 'id',
								displayField: 'value',
								editable: false,
								listeners: {
									render: function(combo) {
										var speakStore= combo.getStore();
										speakStore.getProxy().extraParams = {
											limit:-1,
											employeeLanguage : departmentId
										};
										speakStore.load({
											callback:function(record, operation, success){
												combo.setValue(speak);
											}
										});
									}
								}
							},{
								xtype: 'button',
								glyph: ICONGLYPH.DELETEGLYPH,
								itemId: 'languageDeleteButton1',
								width: 'auto',
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								width:40,
								style:{
									marginTop:'2px'
								},
								listeners: {
								    afterrender: function (btn) {
								        btn.setDisabled(true);
								        panelContiner.down('#stopBtn').setDisabled(true);
								    }
								}
							}]

						});
					}
					panelContiner.add(panelItem);
					indx = indx + 1; 
					panelContiner.doLayout();
				});
			}
            
            if (currentForm.personType == 'FACULTY') {
            	var designation = {
            			id : data.designationId	
            	};
            	var department = {
            			id : data.departmentId	
            	}; 
            	var subDepartment = {
            			id : data.subDepartmentId	
            	}; 
            	data.designation = designation;
                data.department = department;
                data.subDepartment = subDepartment;
                data.nationality = nationality;
               
                if(!isNullOrEmpty(data.joiningDate)){
                	data.joiningDate = dateRender(data.joiningDate);
                }
                if(!isNullOrEmpty(data.exitDate)){
                	data.exitDate = dateRender(data.exitDate);
                }
            }
            
            var personalDetails = this$.deepCopyObj(data);
            
            if(!isNullOrEmpty(data.birthDate)){
            	personalDetails.birthDate = dateRender(data.birthDate);
            }
            if(!isNullOrEmpty(data.validTill)){
            	personalDetails.validTill = dateRender(data.validTill);
            }
            if(!isNullOrEmpty(data.unconditionalOfferSentDate)){
            	personalDetails.unconditionalOfferSentDate = dateRender(data.unconditionalOfferSentDate);
            }
            if(!isNullOrEmpty(data.admissionDate)){
            	personalDetails.admissionDate = dateRender(data.admissionDate);
            }
            if(!isNullOrEmpty(data.identityExpiryDate)){
            	personalDetails.identityExpiryDate = dateRender(data.identityExpiryDate);
            }
            personalDetailsForm.getForm().setValues(personalDetails);
        }
    },
    
    deepCopyObj: function(obj) {
    	var me = this;
        var copy;
        if (null === obj || "object" !== typeof obj) return obj;

        // Handle Array
        if (Array.isArray(obj)) {
            copy = [];
            for (var i = 0; i < obj.length; i++) {
                copy[i] = me.deepCopyObj(obj[i]);
            }
            return copy;
        }

        // Handle Object
        copy = {};
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                copy[key] = me.deepCopyObj(obj[key]);
            }
        }
        return copy;
    },
    
    /*
     *  Set record to current address field form
     *  @param currentForm - current form
     *  @param data - current address form data
     */
    setRecordToCurrentAddressFieldForm: function(currentForm, data) {
        var this$ = this;
        var addressFieldRequestForm = currentForm.down('#addressFieldRequestForm');
        if (!isEmpty(data)) {
        	if(data["addressesToBeChanged"]!=undefined){
        		var addressData = data["addressesToBeChanged"][0];
        	}else{
        		var addressData = data;
        	}
            if (!isEmpty(addressData)) {
                addressData.country = addressData.countryId;
                addressData.city = addressData.cityId;
                addressData.parentCountryRegion = addressData.countryRegionByParentRegionId;
                addressData.countryRegion = addressData.countryRegionByCountryRegionId;
                addressData.pincodeNew = addressData.pincodeNew ? addressData.pincodeNew.id : null;


                var countryId = addressData["country"];
                var parentCountryRegion = addressData["parentCountryRegion"];
                if (countryId) {
                    this$.mixins.AddressController.setCountryDropDown(countryId, addressFieldRequestForm);
                    this$.mixins.AddressController.setCityropDown(parentCountryRegion, addressData["city"], addressFieldRequestForm);
                    this$.mixins.AddressController.setRegion1DropDown(countryId, addressData["parentCountryRegion"], addressFieldRequestForm);
                    this$.mixins.AddressController.setRegion2DropDown(addressData["parentCountryRegion"], addressData["countryRegion"], addressFieldRequestForm);
                }
                var addressTypeItemField = currentForm.down('#addressTypeItemField');
                addressTypeItemField.setValue(addressData["addressTypeId"]);
                addressFieldRequestForm.getForm().setValues(addressData);
            }
        }

    },

    /*
     *  show hide parent-guardian form details
     *  @param form - render form
     */
    showHideParentGuardianDetailsField: function(form) {
        var relationShipEmployeeField = form.down('#relationShipEmployeeField');
        var parentGuardianButtonField = form.down('#parentGuardianButtonField');
        relationShipEmployeeField.setDisabled(true);
        relationShipEmployeeField.setVisible(false);
        parentGuardianButtonField.setVisible(false);
    },

    /*
     *  load data on parent-guardian form
     *  @param form - render form
     */
    onRenderParentGuardianLoadData: function(form) {
        var this$ = this;
        
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var stakeHolderType = serviceRequestActiveTab.down('#stakeHolderTypeId');
        this$.showHideParentGuardianDetailsField(form);
        var relationship = stakeHolderType.getValue();
        var genderCombo = form.down('#genderCombo');
        var maritalStatusCombo = form.down('#maritalStatusCombo');
        var salutation = form.down('#salutationId');
        if(relationship!="FATHER" && relationship!="MOTHER"){
        	genderCombo.readOnly = false;
        	genderCombo.editable = true;
        	maritalStatusCombo.readOnly = false;
        	maritalStatusCombo.editable = true;
        	salutation.readOnly= false;
        	salutation.editable= true;
        }
        if(relationship === "FATHER"){
            salutation.getStore().load({
            	callback : function(rec,opt){
            		salutation.setValue(rec[0]);
            	}
            });
            
            var storeData = genderCombo.getStore().data.items;
 			var idToSet = null;
 			Ext.each(storeData, function(item) {
 				if (item.data.value == 'Male') {
 					idToSet = item.data.id;
 				}
 			});
 			if (idToSet != null) {
 				genderCombo.setValue(idToSet);
 			}
        }
        if(relationship === "MOTHER"){
            salutation.getStore().load({
            	callback : function(rec,opt){
            		salutation.setValue(rec[3]);
            	}
            });
            
            var storeData = genderCombo.getStore().data.items;
 			var idToSet = null;
 			Ext.each(storeData, function(item) {
 				if (item.data.value == 'Female') {
 					idToSet = item.data.id;
 				}
 			});
 			if (idToSet != null) {
 				genderCombo.setValue(idToSet);
 			}
        }     
        if(relationship === "FATHER" || relationship === "MOTHER"){
            genderCombo.readOnly = true;
        	genderCombo.editable = false;
        	maritalStatusCombo.readOnly = true;
        	maritalStatusCombo.editable = false;
        	salutation.readOnly= true;
        	salutation.editable= false;
        	
        	var storeData = maritalStatusCombo.getStore().data.items;
 			var idToSet = null;
 			Ext.each(storeData, function(item) {
 				if (item.data.value == 'Married') {
 					idToSet = item.data.id;
 				}
 			});
 			if (idToSet != null) {
 				maritalStatusCombo.setValue(idToSet);
 			}
        }   
        var params = {
            personId: serviceRequestActiveTab.getPersonId(),
            relationship: relationship
        };
        form.doLayout();
        this$.setParentGuardianStudentDataToForm(form, params);
    },

    /*
     *  Set parent guardian data to form
     *  @param tabPanelForm - tab panel form to set person data
     *  @param params - params 
     */
    setParentGuardianStudentDataToForm: function(tabPanelForm, params) {
        var this$ = this;
        var parentGuardianRequestForm = tabPanelForm.down('#parentGuardianRequestForm');
        this$.sendGetAjaxRequest(SERVERURL.PARENR_GUARDIAN_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    tabPanelForm.setPersonData(data);
                    this$.getPersonalInfoFormValue(data);
                    parentGuardianRequestForm.getForm().setValues(data);
                    if (tabPanelForm.itemId == 'previousForm') {
                        this$.onPreviousFormAddressRenderer(tabPanelForm);
                    }
                }
            }
        });
    },
    /**
     * create parent guardian form json
     */
    createParentGuardianFormJson: function() {
        var this$ = this;
        var data = new Object();
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var stakeHolderType = serviceRequestActiveTab.down('#stakeHolderTypeId');
        var currentForm = this$.getCommonWindow().down("#currentForm");
        var parentGuardianRequestForm = currentForm.down('#parentGuardianRequestForm');
        var personalInfoData = parentGuardianRequestForm.getValues();

        var addressFieldRequestForm = currentForm.down('#addressFieldRequestForm');
        var addressTypeCombo = currentForm.down('#addressTypeItemField');

        //Address Json
        var addressFormdata = addressFieldRequestForm.getValues();
        addressFormdata.addressId = addressFormdata.id;
        addressFormdata.addressTypeId = addressTypeCombo.getValue();
        addressFormdata.countryId = addressFormdata.country;
        addressFormdata.countryRegionByParentRegionId = addressFormdata.parentCountryRegion;
        addressFormdata.cityId = addressFormdata.city;
        addressFormdata.countryRegionByCountryRegionId = addressFormdata.countryRegion;

        delete addressFormdata.id;
        delete addressFormdata.version;
        delete addressFormdata.addressType;
        delete addressFormdata.country;
        delete addressFormdata.city;
        delete addressFormdata.customData;
        delete addressFormdata.parentCountryRegion;
        delete addressFormdata.countryRegion;

        // Pesonal Information

        personalInfoData.personId = serviceRequestActiveTab.getPersonId();
        personalInfoData.salutationId = personalInfoData.salutation.id;
        if(isNullOrEmpty(personalInfoData.maritalStatus)){
        	personalInfoData.maritalStatus = null;
        }
        if(isNullOrEmpty(personalInfoData.bloodGroup)){
        	personalInfoData.bloodGroup = null;
		}
        if(isNullOrEmpty(personalInfoData.gender)){
        	personalInfoData.gender = null;
		}

        delete personalInfoData.id;
        delete personalInfoData.version;
        delete personalInfoData.customData;
        delete personalInfoData.salutation;
        delete personalInfoData.userCode;

        data = personalInfoData;
        data.dataToBeChangedType = "RELATIONDATATOBECHANGED";
        data.relationship = stakeHolderType.getValue();

        var addressesToBeChanged = new Array();
        addressesToBeChanged.push(addressFormdata);
        data.addressesToBeChanged = addressesToBeChanged;

        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },

    /**
     * Set record to current parent guardian form (show details thruogh student track request)
     * @param currentForm - current form
     * @param data - data to be changed data
     */
    setRecordToCurrentParentGuardianForm: function(currentForm, data) {
        var this$ = this;
        this$.showHideParentGuardianDetailsField(currentForm);
        var parentGuardianRequestForm = currentForm.down('#parentGuardianRequestForm');

        if (!isEmpty(data)) {
            var salutation = {
                id: data.salutationId
            };
            data.salutation = salutation;
            parentGuardianRequestForm.getForm().setValues(data);
        }
    },
    /*
     *  show hide sibling form details
     *  @param formItemId - render form item id
     */
    showHideSiblingDetailsField: function() {
        var this$ = this;
        var form = this$.getCommonWindow().down('siblingform');
        var relationShipItemField = form.down('#relationShipItemField');
        form.remove(relationShipItemField);
        
        var phoneFieldContainer = form.down('#phoneFieldContainer');
        form.remove(phoneFieldContainer);
        this.removeField(phoneFieldContainer,true)
        var cellFieldContainer = form.down('#cellFieldContainer');
        this.removeField(cellFieldContainer,true)
        var emailFieldContainer = form.down('#emailFieldContainer');
        this.removeField(emailFieldContainer,true)
    },

    /*
     *  load data on selection sibling name combo
     *  @param combo - selection data changed combo
     */
    onSelectionSiblingNameLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        form.setDisabled(false);
        form.down("#searchButtonId").setDisabled(true);
        form.down('combo[name=salutation]').setReadOnly(true);
        form.down('textfield[name=firstName]').setReadOnly(true);
        form.down('textfield[name=middleName]').setReadOnly(true);
        form.down('textfield[name=lastName]').setReadOnly(true);
        form.down('combo[name=gender]').setReadOnly(true);
        form.down('datefield[name=birthDate]').setReadOnly(true);
        form.down('#siblingStudentId').setValue(" ");
        form.down('#siblingStudentId').setReadOnly(true);
        form.down('#submitButtonId').setVisible(false);
        var siblingStudentId = combo.getValue();
        var params = {
            siblingStudentId: siblingStudentId
        };
        this$.setSiblingStudentDataToForm(form, params);
    },
    /*
     *  Set sibling data to form
     *  @param form - form to set data
     *  @param params - params 
     */
    setSiblingStudentDataToForm: function(form, params) {
        var this$ = this,url=SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS;
		 url = url.concat('?id='+params.siblingStudentId);
        
        this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
//                console.log(data.relatedPerson.id)
                form.getForm().setValues(data.relatedPerson);
                this$.setSiblingCode(form,data.relatedPerson.id); //siblingStudentId
            }
        });
    },
    
    
    setSiblingCode: function(form, params) {
        var this$ = this,url=SERVERURL.STUDENT_FIND_CODE;
		 url = url.concat('?id='+params);
        
        this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
            if (success) {
                var data = response.responseText;
                console.log(data)
                var siblingCode=form.down("#siblingStudentId");
                siblingCode.getStore().getProxy().extraParams = {
                	isMultiAccessAllowForSibiling: true,
                	studentNameOrCode:data
	    		},
                siblingCode.getStore().load({
					callback: function(records, operation, success) {
	                    for(var i=0;i<records.length;i++){
							if(records[i].data.personId==params){
								siblingCode.setValue(records[i].data.id);
							}
						
					}
						
						
					}
				});
            }
        });
    },
    
    
    
    
    
    
    

    /**
     *  load data on selection exam passed combo
     *  @param combo - selection data changed combo
     */
    onSelectionEducationNameComboLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var educationHistoryId = combo.getValue();
        var params = {
            educationHistoryId: educationHistoryId
        };
        //        form.setDisabled(false);
        this$.setEducationHistoryToForm(form, params, function(option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                form.setDisabled(false);
                this$.setDataToEducationDetailsForm(form, data);
            }
        });
    },
    /**
     * On select subject combo, display marks accordingly
     */
    onSelectionSubjectDisplayMarks: function(combo, records, index) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var subjectMarkInfoId = form.down('#subjectMarkInfoId');
        var subjectMarkVersion = form.down('#subjectMarkVersion');
        var marks = form.down('#marks');
        var record = records[0];
        subjectMarkInfoId.setValue(record.get("subjectMarkInfoId"));
        subjectMarkVersion.setValue(record.get("version"));
        marks.setDisabled(false);
        marks.setValue(record.get("marks"));

    },
    /**
     *  Set education history to form
     *  @param form - form to set data
     *  @param params - params 
     */

    setEducationHistoryToForm: function(form, params, callback) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.FIND_EDUCATION_DETAILS, 'GET', params, callback);
    },

    /**
     * bind store to subject combo and set data to values
     */
    setDataToEducationDetailsForm: function(form, data) {

        if (!isEmpty(data)) {
            var subjectMarkInfo = data.subjectMarkInfo;
            if (!isEmpty(subjectMarkInfo)) {
                var subjectCombo = form.down('#subject');
                var subjectArray = new Array();
                for (var i = 0; i < subjectMarkInfo.length; i++) {

                    var subjectMarkInfoId = subjectMarkInfo[i].id;
                    var version = subjectMarkInfo[i].version;
                    var marks = subjectMarkInfo[i].marks;
                    var subjectId = subjectMarkInfo[i].subject.id;
                    var value = subjectMarkInfo[i].subject.value;
                    var code = subjectMarkInfo[i].subject.code;
                    var subjectObj = {
                        'id': subjectId,
                        'subjectMarkInfoId': subjectMarkInfoId,
                        'version': version,
                        'value': value,
                        'code': code,
                        'marks': marks
                    };
                    subjectArray.push(subjectObj);
                }
                var store = Ext.create('Ext.data.Store', {
                    fields: ['id', 'version', 'subjectMarkInfoId', 'value', 'code', 'marks'],
                    data: subjectArray
                });
                subjectCombo.bindStore(store);
            }
            form.setDisabled(false);
            form.getForm().setValues(data);
        }
    },
    /*
     *  create education history form json
     */
    createEducationFormJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        data.examPassedId = data.examPassed.id;
        data.educationalHistoryId = data.id;
        data.dataToBeChangedType = "EDUCATIONHISTORYDATATOBECHANGED";
        var subjectMarkDataToBeChanged = [{
            'subjectMarkInfoId': !isNullOrEmpty(data.subjectMarkInfoId) ? data.subjectMarkInfoId : null,
            'subjectId': !isNullOrEmpty(data.subject) ? data.subject : null,
            'marks': !isNullOrEmpty(data.marks) ? data.marks : null
        }];
        data.subjectMarkDataToBeChanged = subjectMarkDataToBeChanged;

        delete data.id;
        delete data.version;
        delete data.customData;
        delete data.examPassed
        delete data.subjectMarkInfoId;
        delete data.subjectMarkVersion;
        delete data.subject;
        delete data.marks;

        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },



    /*
     *  load data on selection Medical Condition combo
     *  @param combo - selection data changed combo
     */
    onSelectionMedicalComboLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var medicalHistoryId = combo.getValue();
        var params = {
            medicalHistoryId: medicalHistoryId
        };
        this$.setMedicalHistoryToForm(form, params);
    },
    /*
     *  Set medical history to form
     *  @param form - form to set data
     *  @param params - params 
     */
    setMedicalHistoryToForm: function(form, params) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.FIND_MEDICAL_HISTORY_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    
                    if (!isEmpty(data)) {
                    	if(!isNullOrEmpty(data.dateSince)){
                    		data.dateSince = new Date(data.dateSince);
                    	}
                    }
                    form.setDisabled(false);
                    form.getForm().setValues(data);
//                  form.down('#medicalConditionId').setReadOnly(true);
                  
                }
            }
        });
    },
    

    /*
     *  add new sibling - reset field
     */
    addNewSibling: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        form.down("#searchButtonId").setDisabled(false);
        form.down("#submitButtonId").setVisible(true);
        form.down("#submitButtonId").setDisabled(true);
        this$.getSiblingDetailsPanel().down('#siblingNameItemField').clearValue();
        form.down('combo[name=salutation]').setReadOnly(true);
        form.down('textfield[name=firstName]').setReadOnly(true);
        form.down('textfield[name=middleName]').setReadOnly(true);
        form.down('textfield[name=lastName]').setReadOnly(true);
        form.down('combo[name=gender]').setReadOnly(true);
        form.down('datefield[name=birthDate]').setReadOnly(true);
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#siblingStudentId').setReadOnly(false);
    },
    
    /*
     *  add new medical form history - reset field
     */
    addNewMedicalFormHistory: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        this$.getMedicalHistoryPanel().down('#medicalConditionField').clearValue();
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#medicalConditionId').setReadOnly(false);
    },

    /*
     *  create medical history form json
     */
    createMedicalHistoryFormJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        data.medicalHistoryId = data.id;
        data.dataToBeChangedType = "MEDICALHISTORYDATATOBECHANGED";
        data.conditionTypeId = data.conditionType.id;
        delete data.id;
        delete data.version;
        delete data.customData;
        delete data.conditionType;
        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },



    /*
     *  load data on selection work experience employer combo
     *  @param combo - selection data changed combo
     */
    onSelectionWorkExperienceComboLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var workExperienceId = combo.getValue();
        var params = {
            id: workExperienceId
        };
        this$.setWorkExperienceToForm(form, params);
    },
    /*
     *  Set work experience to form
     *  @param form - form to set data
     *  @param params - params 
     */
    setWorkExperienceToForm: function(form, params) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.FIND_WORK_EXP_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    form.setDisabled(false);
                    form.getForm().setValues(data);
                    form.down('#dateOfJoining').setValue(dateRender(data.joiningDate));
                    if(!isNullOrEmpty(data.exitDate)){
                    	form.down('#currentOrgGroupId').setValue({whetherCurrentOrg:false});
                    	form.down('#exitDate').setValue(dateRender(data.exitDate));
                    	form.down('#exitDate').setDisabled(false);
                    }
                    form.down('#employerId').setReadOnly(true);
                    if (!isNullOrEmpty(data.industry)) {
                    var industryStore = form.down('#industryItemId').getStore();
                    industryStore.load({
            				callback: function(records, operation, success) {
            					for(var i=0;i<records.length;i++){
            						if(records[i].data.id==data.industry.id)
            							form.down('#industryItemId').setValue(records[i].data.id);
            						
            					}
            				}
            			});
					}
                }
            }
        });
    },
    /*
     *  add new work experience form - reset field
     */
    addNewWorkExperienceForm: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        this$.getWorkExperiencePanel().down('#workExperienceEmployerField').clearValue();
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#employerId').setReadOnly(false);
        form.isValid();
    },

    /*
     *  create work experience form json
     */
    createWorkExperienceFormJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        data.workExperienceId = data.id;
        if(data.experienceType){
        	data.experienceTypeId = data.experienceType.id;
        }
        data.dataToBeChangedType = "WORKEXPERIENCEDATATOBECHANGED";
        delete data.customData;
        delete data.id;
        delete data.version;
        delete data.experienceType;
        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },
    
    calculateExperience: function(dateField){
        var this$ = this;
    	var form = this$.getCommonWindow().down("#currentForm");
    	var dateOfJoining = form.down('#dateOfJoining').getValue();
        var exitDate = form.down('#exitDate').getValue();
        
        if(exitDate !=null || exitDate != undefined){
        	var experienceInMonths = this.calculateDiffInMonths(dateOfJoining,exitDate);
        }else if(dateOfJoining != null){
        	var experienceInMonths = this.calculateDiffInMonths(dateOfJoining,new Date());
        }
        form.down("#durationInMonths").setValue(experienceInMonths);
    },
    
    calculateDiffInMonths: function(date1, date2) {
    	if(isNullOrEmpty(date1)) {
    		return 0;
    	}
    	var months = (date2.getFullYear() - date1.getFullYear()) * 12;
    	months -= date1.getMonth();
        months += date2.getMonth();
		if(date1.getDate() > date2.getDate()) {
			months = months -1;
		}
        return months <= 0 ? 0 : months;
    },
    
    /*
     *  load data on selection vaccination name combo
     *  @param combo - selection data changed combo
     */
    onSelectionVaccinationNameComboLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var vaccinationInfoId = combo.getValue();
        var params = {
            id: vaccinationInfoId
        };
        this$.setVaccinationDetailToForm(form, params);
        if(!isNullOrEmpty(form) && form != undefined){
    		if(!isNullOrEmpty(form.down('#uploadVaccinationItemId')) && form.down('#uploadVaccinationItemId') != undefined){
    			form.down('#uploadVaccinationItemId').setVisible(false);
    		}
    	}
    },
    /*
     *  Set vaccination to form
     *  @param form - form to set data
     *  @param params - params 
     */
    setVaccinationDetailToForm: function(form, params) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.FIND_VACCINATION_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    form.setDisabled(false);
                    form.getForm().setValues(data);
                    form.down('#vaccinationDate').setValue(dateRender(data.vaccinationDate));
                    form.down('#vacinationNameId').setReadOnly(true);
                }
            }
        });
    },
    /*
     *  add new vaccination form  - reset field
     */
    addNewVaccinationForm: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        form.down("#submitButtonId").setDisabled(true);
        this$.getVaccinationDetailsPanel().down('#vaccinationNameField').clearValue();
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#vacinationNameId').setReadOnly(false);
        if(!isNullOrEmpty(form) && form != undefined){
    		if(!isNullOrEmpty(form.down('#uploadVaccinationItemId')) && form.down('#uploadVaccinationItemId') != undefined){
    			form.down('#uploadVaccinationItemId').setVisible(false);
    		}
    	}
    },

    /*
     *  create vaccination form json
     */
    createVaccinationFormJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        data.vaccinationInfoId = data.id;
        data.dataToBeChangedType = "VACCINATIONDATATOBECHANGED";
        delete data.id;
        delete data.customData;
        delete data.version;
        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },
    
    /*
     *  create vaccination form json
     */
    createSiblingJson: function() {
    	
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var siblingForm = this$.getPersonSiblingForm();
        
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        if(isNullOrEmpty(form.getRelatedPerson()))
        	{
        	showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('SIBLING_SEARCH_ACTION'));
        	}else
        		{
                data.relatedPersonId = form.getRelatedPerson().id;
                if( data.personId == data.relatedPersonId){
                    showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getPersonModuleTranslation('INCORRECT_SIBLING_SELECTED'));
                }
                data.dataToBeChangedType = "RELATIONDATATOBECHANGED";
                data.salutationId = !isNullOrEmpty(data.salutation)?data.salutation.id:null;
                delete data.salutation;
                delete data.id;
                delete data.studentCode;
                delete data.customData;
                delete data.version;
                serviceRequestActiveTab.setFormData(data);
                this$.getCommonWindow().close();
        		}

    
       
     
    },

    /*
     *  load data on selection activity name combo
     *  @param combo - selection data changed combo
     */
    onSelectionActivityNameComboLoadData: function(combo) {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        var activityNameId = combo.getValue();
        var params = {
            id: activityNameId
        };
        this$.setExtraCurricularDetailToForm(form, params);

    },
    /*
     *  Set Extra Curricular to form
     *  @param form - form to set data
     *  @param params - params 
     */
    setExtraCurricularDetailToForm: function(form, params) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.FIND_EXTRA_CURRICULAR_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                form.setDisabled(false);
                form.getForm().setValues(data);
                form.down("#awardDate").setValue(dateRender(data.awardDate));
                var isCurrentOrganization = data.isCurrentOrganization;
                if (!isNullOrEmpty(isCurrentOrganization)) {
                    form.down('#previousOrgRadioBtn').setValue(!isCurrentOrganization);
                    form.down('#currentOrgRadioBtn').setValue(isCurrentOrganization);
                    form.down('#activityNameId').setReadOnly(true);
                }
            }
        });
    },
    /*
     *  add new extra curricular form  - reset field
     */
    addNewExtraCurricularForm: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        this$.getExtraCurricularDetailsPanel().down('#activityNameField').clearValue();
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#activityNameId').setReadOnly(false);
        form.isValid();
    },

    /*
     *  add new education form  - reset field
     */
    addNewEducationForm: function() {
        var this$ = this;
        var form = this$.getWindowFormActiveTabPanel();
        this$.getEducationDetailPanel().down('#examPassedField').clearValue();
        form.getForm().reset();
        form.setDisabled(false);
        form.down('#examPassed').setReadOnly(false);
    },
    /*
     *  create extra curricular form json
     */
    createExtraCurricularJson: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var personId = serviceRequestActiveTab.getPersonId();
        var form = this$.getCommonWindow().down("#currentForm");
        var data = form.getValues();
        data.personId = personId;
        data.extraCurricularActivityId = data.id;
        if(data.activityType){
        	data.activityTypeId = data.activityType.id;
        }
        if(data.community){
        	 data.communityId = data.community.id;	
        }
        data.dataToBeChangedType = "EXTRACURRICULARDATATOBECHANGED";
        delete data.id;
        delete data.version;
        delete data.customData;
        delete data.activityType;
        delete data.community;
        serviceRequestActiveTab.setFormData(data);
        this$.getCommonWindow().close();
    },

    /*
     *  Create service request common json
     */
    createServiceRequestJson: function(requestFormDetail, formData) {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var loggedInUser = this.getCurrentlyLoggedInUser();
        var requestObject = new Object();
        requestObject.id = requestFormDetail.id;
        requestObject.version = requestFormDetail.version;
        requestObject.requestId = null;
       // requestObject.name = null; //"PersonalDataRequest";
        requestObject.serviceRequestStage = 'INITIATED';
        requestObject.isWithdrawn = false;
        requestObject.enteredBy = {
            id: loggedInUser.id
        };
        requestObject.requesterId = requestFormDetail.requesterId;
        requestObject.requesterType = requestFormDetail.requesterType;
        requestObject.requester = {
            id: serviceRequestActiveTab.getRequesterId()
        };
        requestObject.requestDate = requestFormDetail.requestDate;
        requestObject.remarks = requestFormDetail.remarks;

        requestObject.serviceRequestSetting = serviceRequestActiveTab.getServiceRequestSetting(),

        requestObject.documents = null;
        requestObject.followupDetails = null;
        requestObject.approvalDetails = null;
        //        delete requestFormDetail.requesterType;
        //        delete requestFormDetail.requester;
        //        delete requestFormDetail.requestDate;
        //        delete requestFormDetail.remarks;
        var detail = new Object();
        detail.id = null;
        detail.version = 0;
        detail.dataToBeChanged = formData;
        requestObject.detail = detail;
        return requestObject;
    },
    /*
     *  Save service request form
     */
    saveServiceRequestForm: function() {
        var this$ = this;
        var serviceRequestActiveTab = this$.getContentPanelActiveTab();
        var form = serviceRequestActiveTab.down('personrequestdetailspanel');
        var formData = serviceRequestActiveTab.getFormData();
        var requestFormDetail = form.getValues();
        serviceRequestActiveTab.setFormData(this$.createServiceRequestJson(requestFormDetail, formData));
        if (!isNullOrEmpty(formData)) {
            this$.addDocumentPanel(serviceRequestActiveTab, false);
            toggleReadOnlyFormItems(form.getForm(), true);
            form.down('#clearBtn').setDisabled(true);
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('FILL_FORM_FIELD_DETAILS'));
            form.down('#submitBtn').setDisabled(true);
        }

    },  
    
    /*Profile Photo upload*/
    openPhotoUploadPopup: function() {
    	var $this = this;
    	var profileUploadWindow = this.getStudentuploadphotowindow();
    	
        if (!profileUploadWindow) {
        	profileUploadWindow = Ext.widget('studentuploadphotowindow',{
        				 itemId : 'studentcurrentuploadphotowindow'
        			 }); 
        }
        
        if (!profileUploadWindow.hasAfterRenderHandler) {
        	profileUploadWindow.on('afterrender', function () {
                var personProfile = $this.getContentPanelActiveTab();
                var personId = personProfile.getPersonId();
                if (!isNullOrEmpty(personId)) {
                    Ext.Ajax.request({
                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId+'&isDefaultImageRequired=false',
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                var profileImage = profileUploadWindow.down("#profile_image");
                                profileImage.getEl().dom.src = url;
                             // **Store the last saved image URL**
                                profileUploadWindow.lastSavedImageUrl = url;
                                profileImage.setVisible(true);
                                var form = $this.getPersonalinformationform();
                                var existingImageUrl = form.down('#hiddenImageItemId').getValue();
                                profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
//                                 if(personProfile.photoUrl){
//                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
//                                }else{
//                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
//                                }
                            }
                        },
                    });
                }
            }, $this);
            
            // Mark handler as attached to avoid duplicate bindings
        	profileUploadWindow.hasAfterRenderHandler = true;
        }
        
        profileUploadWindow.show();
     },
     
     openCapturePhoto:function(){
	   		var window = this.getStudentuploadphotowindow(),
	   		profileImage = window.down('#profile_image'),
	   		capturePanelId = window.down('#capturePanelId'),
	   		btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
	   		btnTakePhoto = window.down('#btnTakePhotoItemId'),
	   		capturePhoto = window.down('#capturePhotoItemId'),
	   		resetPhoto = window.down('#resetPhotoItemId'),
	   		btnBack = window.down('#btnBackItemId'),
	   		btnSave = window.down('#btnSaveItemId');
	   		window.down('#profile_image_containerBox').hide();
	   		window.down('#profileRoatateImageIconId').hide();  
	   		
	   	// **Store the current profile image before hiding it**
 	    window.previousProfileImage = profileImage.el.dom.src;
	   		
	   		btnUploadPhoto.reset();
	   		btnUploadPhoto.setVisible(false);
	   		btnTakePhoto.setVisible(false);
	   		profileImage.setSrc('');
	   		profileImage.setVisible(false);
	   		capturePanelId.setVisible(true);
	   		capturePhoto.setVisible(true);
	   		resetPhoto.setVisible(true);
	   		resetPhoto.setDisabled(true);
	   		btnBack.setVisible(true);
	   		btnSave.setVisible(true);
	   		
	   	},
	   	
	   	captureUserPhoto: function(btn){
			var $this = btn.up('window');
			var form = btn.up('window').down('form');
			var imageUrl;
			Webcam.snap( function(data_uri) {
				imageUrl = data_uri;
			});
	        Ext.defer(function() {
	        	var imgLoad = new Image();
	    		imgLoad.onload = (function(){
	    			var crop = new Academia.utilities.ImageCrop({
	    				id:'testing',
	    				width: 310,
	    				height: 272,
	    				src:imageUrl
	    			});
	    			crop.on('changeCrop', function(component,region) {
	    				$this.cropData = region;
	    				$this.component = component;
	    			});
	    			var PREVIEW_TEST = form.down('#previewPanelId');
	    			PREVIEW_TEST.add(crop);
	    			$this.down('#capturePanelId').setVisible(false);
	    			$this.down('#previewPanelId').setVisible(true);
	    			btn.setDisabled(true);
	    			$this.down('#resetPhotoItemId').setDisabled(false);
	    			$this.down('#btnSaveItemId').setDisabled(false);
	    			
	    			var canvas = document.getElementById('canvas');
					var ctx = canvas.getContext("2d");
					var region = $this.cropData; 
					var component = $this.component;
					var sw = region.width - region.x;
					var sh = region.height - region.y;

					var imgWidth = component.width;
					var imgHeight = component.height;

					var img = new Image();
					img.src = component.src;

					ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
	    			$this.captureImageaUrl = canvas.toDataURL("image/png");
	    		}).bind($this);
	    		imgLoad.src = imageUrl;
	    		$this.imagesUrl = imageUrl;
	  	  }, 500, $this);
	   	},
	   	
	   	uploadProfilePhoto: function(cmp, value) {
	    	var window = this.getStudentuploadphotowindow();
	        var form = window.down('form');
	        var image = form.down('#profile_image');
	        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
    	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
	        var btnSave = window.down('button[name=btnSave]');
	        var file = cmp.el.down('input[type=file]').dom.files[0];

	        // File extension validation
	        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
	        if (!isNullOrEmpty(value)) {
	            if (extension === "png" || extension === "jpeg" || extension === "jpg") {
	            	if(file){
	           		 if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
	           			 cmp.reset();
	                        showWarningMessage(
	                            getPersonModuleTranslation('PHOTO_UPLOAD'),
	                            getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
	                        );
	                        return;
	                    }
	            	}
	            } else {
	                cmp.reset();
	                showWarningMessage(
	                    getPersonModuleTranslation('PHOTO_UPLOAD'),
	                    getPersonModuleTranslation('UPLOAD_VALID_FILE')
	                );
	                return;
	            }
	        } else {
	            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
	            return;
	        }

	        // Process the valid file
	        if (file) {
	            form.down('#fileName').setValue(file.name);
	            var personProfile = this.getContentPanelActiveTab();
	            var personId = Number(personProfile.getPersonId());
	            form.down('#personId').setValue(personId);

	            var reader = new FileReader();
	            reader.onload = function(e) {
	            	var crop;
		        	var imageSrc;
		        	var canvasDiv ;
	                image.setSrc(e.target.result);
	                Ext.defer(function(){
		            	imageSrc = imageInnerContainerBox.children[0].src;
				        image.setVisible(false);
				        window.down('#profileRoatateImageIconId').show();
		            	 crop = cropper(imageInnerContainerBox, {
	    				    area: [ 210, 210 ],
	    				    crop: [ 115, 115],
	    				    value: imageSrc,
	    				    allowResize: true,
	    		            allowZoom: true,
	    		            allowRotation: true,         		            
	    				})
	    				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
		            	 if (jcropArea) {
		            		    var innerJcropDiv1 = document.createElement('div');
		            		    innerJcropDiv1.className = 'border-left';
		            		    var innerJcropDiv2 = document.createElement('div');
		            		    innerJcropDiv2.className = 'border-right';
		            		    jcropArea.appendChild(innerJcropDiv1);
		            		    jcropArea.appendChild(innerJcropDiv2);
		            		}
	    				canvasDiv = jcropArea.nextSibling;
	    				if(!isNullOrEmpty(canvasDiv)){
	    					var mouseEventOccurred = false;
	    				if (canvasDiv) {
	    				    // Listen for mouse events and set the flag to true when one occurs
	    					canvasDiv.addEventListener('mousemove', function () {
	    						mouseEventOccurred = true;
					            if (mouseEventOccurred) {    				                
					                var croppedImage = crop.getCroppedImage().src;
	    				            image.setSrc(croppedImage);
	    				            image.setVisible(true);
					            }    				            
					        })
					        if(mouseEventOccurred == false) {
	    				    image.setSrc(imageSrc);
	    				    image.setVisible(true);
	    				}
	    				} 
	    			} 
					else {
					    image.setSrc(imageSrc);
					    image.setVisible(true);
					}
		            },500)
	                btnSave.setDisabled(false);
	            };
	            reader.readAsDataURL(file);
	        }
	    },
	    
	    uploadCapturedImage: function() {
	    	var me = this;
	    	var personProfile = me.getContentPanelActiveTab();
	    	var personInfoForm = me.getPersonalinformationform();
	    	var personId = Number(personProfile.getPersonId());
	        var formPanel = me.getStudentuploadphotowindow();
	        var form = formPanel.down('form');
	        if(form.down('#profile_image_containerBox').isVisible()) {
	        	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	        	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
	        	 var finalImageBase64;
	        	 var imageBlob;
	        	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
	        		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
	        		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
	        	 }
	         }
	         
	        var formValues = form.getValues();
	        if(form.down('#profile_image_containerBox').isVisible()) {
	        	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	        	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
	        	 var finalImageBase64;
	        	 var imageBlob;
	        	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
	        		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
	        		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
	        	 }
	         }
	         
	         var formValues = form.getValues();
	        // Check if there's an image to upload
	        var imageField = formPanel.down('#profileImageFormItemId');
	        var imageVal = formPanel.down('#btnUploadPhotoItemId');
	        var profile_image = formPanel.down('#profile_image');
	        if(profile_image.src == 'resources/images/default-profile.png'){
	        	personInfoForm.down('#hiddenImageItemId').setValue('');
	        	//return;
	        }
	        /*if(isImageRemoved.value == "true"){
	        	me.saveuploadAlumniCapturedImage('');
	        	return;
	        }*/
	        me.applyWindowMask();
	        if (profile_image.isVisible()) {

	        	var formData = new FormData();
	        	 for (var key in formValues) {
	        	     if (formValues.hasOwnProperty(key)) {
	        	         formData.append(key, formValues[key]);
	        	     }
	        	 }
	        	 if(!isNullOrEmpty(imageBlob)){
	        		 formData.append('file', imageBlob, 'profile.png');
		        	 formData.append('isImageRemoved', formValues.isImageRemoved);
		        	 formData.append('name', formValues.name);
		        	 formData.append('personId', formValues.personId); 
	        	 }
	        	 else{
	        		 var blankBlob = new Blob([''], { type: 'application/octet-stream' });
	        		 formData.append('file', blankBlob, 'profile.png');	        		 
	        	 }	 
	        	 var userInfo = Academia.model.authentication.UserInfoModel;
	        	 var access_token = userInfo.get("accessToken");
	        	 
	        	 var url = SERVERURL.PATH_UPLOAD_PERSONAL_DATA_REQUEST_IMAGE+'?access_token='+access_token;
	        	 
	        	 var xhr = new XMLHttpRequest();
	        	 xhr.open('POST', url, true);
	        	 
	        	 xhr.onload = function () {
	        	     if (xhr.status >= 200 && xhr.status < 300) {
	        	         var response = JSON.parse(xhr.responseText);
	        	         var path = response.path;
	        	         //var updatedPath = path.replace(/^\/+/, "");
	        	         //me.saveuploadCapturedImage(path);
	        	         personInfoForm.down('#hiddenImageItemId').setValue(path);
		                    var imageFullPath = me.getFullImagePath(path);	
		                    if (path.includes('null')) {
		                    	imageFullPath = 'resources/images/default-profile.png';
		                    }
		                    personInfoForm.down('#profile_image').setSrc(imageFullPath);
		                    me.hideWindowMask();
		                    formPanel.close();
	        	     }
	        	 };
	        	 xhr.send(formData);
	            // If there's an image, upload it first
	        	/*form.getForm().submit({ 
	                method: 'POST',
	                url: SERVERURL.PATH_UPLOAD_PERSONAL_DATA_REQUEST_IMAGE, 
	                success: function(form, action) {
	                    var responseData = Ext.decode(action.response.responseText);
	                    var path = responseData.path;
	                    var updatedPath = path.replace(/^\/+/, "");
//	                    me.saveuploadCapturedImage(path);
	                    personInfoForm.down('#hiddenImageItemId').setValue(path);
	                    var imageFullPath = me.getFullImagePath(path);
	                    if (path.includes('null')) {
	                    	imageFullPath = 'resources/images/default-profile.png';
	                    }
	                    personInfoForm.down('#profile_image').setSrc(imageFullPath);
	                    me.hideWindowMask();
	                    formPanel.close();
	                },
	                failure: function(response){
	                	me.hideWindowMask();
	                }
	            });*/
	        }else{
	        	var userInfo = Academia.model.authentication.UserInfoModel;
				var access_token = userInfo.get("accessToken");
	        	var canvas = document.getElementById('canvas');
				var ctx = canvas.getContext("2d");
				var region = formPanel.cropData; 
				var component = formPanel.component;
				var sw = region.width - region.x;
				var sh = region.height - region.y;
				var imgWidth = component.width;
				var imgHeight = component.height;
				var img = new Image();
				img.src = component.src;
				ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
				var dataUrl = canvas.toDataURL("image/png");
				
				var url = 'rest/personImage/uploadeB64ImagePersonalDataChangeRequest?access_token='+access_token;
				var form = new FormData();
				form.append('file', dataUrl);
				form.append('fileName', '1.png');
				form.append('personId', personId);
				var xhr = new XMLHttpRequest();
				xhr.open('POST', url, true);

				xhr.onreadystatechange = function () {
					if (xhr.readyState == 4 && xhr.status == 200) {
						if (xhr.responseText != "") {
							var data = Ext.decode(xhr.responseText);
							var personinfo = personProfile;
							personinfo.photoUrl = data.path;
							//var updatedPath = data.path.replace(/^\/+/, "");
							showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
							var imageFullPath = me.getFullImagePath(data.path);
		                    personInfoForm.down('#profile_image').setSrc(imageFullPath);
							personInfoForm.down('#hiddenImageItemId').setValue(data.path);
							var imageFullPath = me.getFullImagePath(data.path)
							me.hideWindowMask();
						}
					}
					formPanel.close();	
					//me.hideWindowMask();
				};
				xhr.send(form);
	        } 
	    },
	    
	    getFullImagePath: function (imageURL) {
        	var extensionArr = imageURL.split(".");
        	var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
            return imageUrl;
        },
	    
	    removeUploadCapturedImage: function(){
	      	 var win = this.getStudentuploadphotowindow();
	           var saveBtn = win.down('#btnSaveItemId');
	           var profileImage = win.down('#profile_image');
	           profileImage.setSrc('resources/images/default-profile.png');
	           saveBtn.setDisabled(false);
	     },
	     
	     /*saveuploadCapturedImage: function(imageUrl){ 
	     	var me = this;
	     	var win = me.getStudentuploadphotowindow();
	     	var form = this.getPersonalinformationform();
	     	var personProfile = me.getContentPanelActiveTab();
	     	var personId = Number(personProfile.getPersonId());
//	     	personProfile.getPersonInfo().photoUrl=imageUrl;
	     	form.down('#hiddenImageItemId').value = imageUrl;
	     	var payload = {
	     			personId: personId,
	     			path: imageUrl
	     	};
	     	
	     	var submitUrl = SERVERURL.PATH_UPLOAD_PERSON_PROFILE_PHOTOS;
	     	
	     	var data = Ext.encode(payload);
	     	
	     	Ext.Ajax.request({
	     		url: submitUrl,
	     		method: 'POST',
	     		jsonData:data,
	             success: function(response){
	             	var responseData = response.responseText;
	             	if (responseData=='fail') {
	             		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
	             	}else{
	             		if(imageUrl==''){
	             			  var profileImage = form.down('#profile_image');
	             		      //profileImage.setSrc('resources/images/default-profile.png');
	              			  showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
	            		 	}
	             		else{
//	             			me.getUploadCaptureToPersonProfile();
	             			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
	             		}
	             	}
	             	win.close();
	             	me.hideWindowMask();
	             },
	             failure: function(response){
	             	me.hideWindowMask();
	             }
	     	})
	     }, */
	     
	     getUploadCaptureToPersonProfile : function(){
	            var this$ = this;
	            var personProfile = this$.getContentPanelActiveTab();
	            var form = this$.getPersonalinformationform();
	            var personId = personProfile.getPersonId();
	            if(!isNullOrEmpty(personId)){
	                Ext.Ajax.request({
	                    type: 'rest',
	                    binary: true,
	                    url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId+'&isDefaultImageRequired=false',
	                    method: 'GET',
	                    success : function(response){
	                        if(response.responseBytes.length>0){
	                            var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	                            var url = window.URL.createObjectURL(blob);
	                            var a=form.down("#profile_image");
	                            a.getEl().dom.src=url;
	                            a.setVisible(true);
	                        }
	                    }
	                });
	            }
	        },
    
 //test commit
});
