/**
 *  @author sandeep.patil  
 *  @author pritam.patil 
 * This controller is used to handle service request functionality
 */
Ext.define('Academia.controller.servicerequest.ServiceRequestBaseController',{
	extend: 'Academia.controller.base.BaseController',
	alias:'widget.requestbasecontroller',
	views:['servicerequest.ServiceRequestPanel','servicerequest.leavefineapplyrelatedrequest.EmployeeLeaveDetailGrid','servicerequest.HostelServiceRequest.ReAddmissionServiceRequest'],
	stores: ['leavemanagement.EmployeeLeaveDetailStore','common.StudentLeaveTypeStore'],
	refs : [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref :'employeeleavedetailgrid',
    	selector : 'employeeleavedetailgrid'
    },{
    	ref :'studentListGridView',
    	 selector: 'searchresultgrid[itemId=StudentSearchResultGrid]'
    }],
	init:function(config){
		this.callParent(arguments);
	},
	
	 /**
	   * This method is use to open the tab for the request.
	   * @param requestType Type of the request
	   * @param requestGroup requestGroup of the request
	   * @param personId id of the person for whom the request id created
	   * @param requestTypeId Id of the request type in case of request group OTHER.
	   */ 
	  getRequestPanel:function(requestorType,requestGroup,requesterId,personId,otherRequestType,record) {
		  
		  var controller = this$.getController('Academia.controller.servicerequest.PersonalDataChangeRequestController');
		  if(this.getCurrentLoggedPortalId() == 7){
			  
			   requesterId =this.getCurrentlyLoggedInUserInfoForPortal().student.id;
		  }
		  var me = this;
		  var requestTitle = '';
		  var requestTypeId = '';
		  var requestTypeCode = null;
		  var programBatchId,progBatchPeriodConfigId,admissionId,programId,studentCode,programName;
		  try{
			  if (record) {
				  programBatchId = record.data.PROGRAM_BATCH_ID;
				  progBatchPeriodConfigId = record.data.PROGRAM_BATCH_SEAT_CONFIG_ID;
				  admissionId = record.data.ADMISSION_ID;
				  programId = record.data.PROGRAM_ID;
				  programName = record.data.PROGRAM_NAME;
				  studentCode = record.data.STUDENT_ID;
	
				  if (!Ext.isDefined(programId)) {
					//  programBatchId = record.get('PROGRAM_BATCH_ID');
					//  progBatchPeriodConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
					//  admissionId = record.get('ADMISSION_ID');
					  	programId = record.get('programId');
					  	programName = record.get('programName');
					//  studentCode = record.get('STUDENT_ID');
				  }
				  if(Academia.model.authentication && Academia.model.authentication.PortalInfoModel && Academia.model.authentication.PortalInfoModel.data && Academia.model.authentication.PortalInfoModel.data.programBatchDetails && Academia.model.authentication.PortalInfoModel.data.admissionDetails && Academia.model.authentication.PortalInfoModel.data.admissionDetails.length){
					  if(isNullOrEmpty(programBatchId)){
					  programBatchId = Academia.model.authentication.PortalInfoModel.data.programBatchDetails.batchId;
					  }
					  if(isNullOrEmpty(progBatchPeriodConfigId)){
					  progBatchPeriodConfigId = Academia.model.authentication.PortalInfoModel.data.programBatchDetails.periodId;
					  }
					  if(isNullOrEmpty(admissionId)){
					  admissionId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].id;
					  }
					  if(isNullOrEmpty(programId)){
					  programId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].program.id;
					  }
				  }
			  }
			  else if(Academia.model.authentication && Academia.model.authentication.PortalInfoModel && Academia.model.authentication.PortalInfoModel.data && Academia.model.authentication.PortalInfoModel.data.programBatchDetails && Academia.model.authentication.PortalInfoModel.data.admissionDetails && Academia.model.authentication.PortalInfoModel.data.admissionDetails.length){
				  programBatchId = Academia.model.authentication.PortalInfoModel.data.programBatchDetails.batchId;
				  progBatchPeriodConfigId = Academia.model.authentication.PortalInfoModel.data.programBatchDetails.periodId;
				  admissionId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].id;
				  programId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].program.id;
			  }
		  }
		  catch(e){
			  //
		  }
		  
		  var program = {
				  id:	programId,
				  value:programName
		  };
		  var academyLocationId = me.getCurrentAcademyLocation();
		  if(isNullOrEmpty(otherRequestType)) {
			  requestTitle = getServiceRequestTranslation(requestGroup) +' '+ getServiceRequestTranslation('REQUEST'); 
		  } else {
			  if(typeof otherRequestType=='string'){
				  if(requestGroup == 'PERSONAL_DATA_CHANGE' || requestGroup == 'CERTIFICATE' || requestGroup == 'FREE_FORM'){
					  if(requestGroup == 'FREE_FORM'){
						  requestGroup='General';
					  }
					  requestTitle = getServiceRequestTranslation(requestGroup) +' '+ getServiceRequestTranslation('REQUEST'); 
				  }else{
					requestTitle = otherRequestType;
				  }
				  requestTypeId = requestId;
				  requestTypeCode =  requestCode;
			  }else{
				  requestTitle = otherRequestType.get('value');
				  requestTypeId = otherRequestType.get('id');
				  requestTypeCode =  otherRequestType.get('code');
			  }
		  }
		  
		  var tabName= this.getTabReferenceByTabTitle(requestTitle);
		  contentPanel = this.getContentPanel();
		  
		  if(!tabName){
			  var tabName1 = this.getTabReferenceByTabXtype('servicerequestpanel');
			  if(tabName1){
				  contentPanel.remove(tabName1);
			  }
		  }
		  
		  if(tabName){
			  contentPanel.remove(tabName);
		  }
		  
		  //if(!tabName){
			  var tab = this.openTab(requestTitle, 'servicerequestpanel',CONSTANTS.MENU_COLOR_EIGHT);
			  if(requestGroup == 'General'){
				  requestGroup='FREE_FORM';
			  }
			  this.applyServiceRequestConfig(tab);
			  this.setServiceRequestConfig(tab, requestorType, requestGroup, requesterId,personId, null, null, null,admissionId,null,programBatchId,
			    progBatchPeriodConfigId, academyLocationId,program,requestTypeCode, studentCode);
			  var details = this.findRequesterDetailsByRequestorType(requestorType,requesterId,admissionId, tab);
			  tab.config.freeFormRaiseReq=true;
			  if(record && record.raw && record.raw.categoryId){
				  tab.config.categoryId = record.raw.categoryId;
				  tab.config.subcategoryId = record.raw.id;
			  }
			  if(!isNullOrEmpty(details.periodId))
			  {
				  tab.config.periodId=details.periodId;
			  }
			  this.openServiceRequestPanel(requestGroup,tab,requestTypeId,details,academyLocationId,record);
			  Ext.defer(function() {
				  if(otherRequestType!=undefined){
					  if(typeof otherRequestType!='string'){
						  if(otherRequestType.data.displayValue=="Employee Leave"){
		        				var grid = me.getEmployeeleavedetailgrid();
		        	       		grid.getStore().getProxy().extraParams={
		        	       			userId:requesterId,
		        	       			academyLocationId:me.getCurrentAcademyLocation()
		        	       		};
		        	       		grid.getStore().load();
		        			}
					  }
	    			}
  	        }, 50, this);
		  /*}else{
			  contentPanel.setActiveTab(tabName);
		  }*/
        },
        
        /**
   	  * This method is used to apply service request config to TAB
   	  * @param requestType
   	  * @param requestGroup
   	  * @param personId
   	  * @param assignee
   	  * @param settingId
   	  */
   	  applyServiceRequestConfig : function(newTab){   
   		  
   		  Ext.apply(newTab, {
   			  requestType:null, 
   			  requestGroup:null,
   			  requesterId:null,
   			  personId:null, 
   			  assignee:null,
   			  settingId:null,
   			  serviceRequestSetting : null,
   			  responseData:null,
   			  formData : null,
   			  admissionId:null,
   			  documentData:null,
   			  voluntaryDocument:null,
   			  programBatchId:null,
   			  progBatchPeriodConfigId:null,
   			  academyLocationId: null,
   			  program:null,
   			  requestTypeCode:null, 
   			  requesterCode:null,
   			  periodId: null,
   			  setPeriodId: function(periodId) {
 	        	  newTab.periodId = periodId;
 	          },
 	          getPeriodId: function() {
 	        	  return newTab.periodId;
 	          },
   	          setRequestType: function(requestType) {
   	        	  newTab.requestType = requestType;
   	          },
   	          getRequestType: function() {
   	        	  return newTab.requestType;
   	          },
   	          setRequestGroup: function(requestGroup) {
   	        	  newTab.requestGroup = requestGroup;
   	          },
   	          getRequestGroup: function() {
   	        	  return newTab.requestGroup;
   	          },
   	          setRequesterId: function(requesterId) {
	        	  newTab.requesterId = requesterId;
	          },
	          getRequesterId: function() {
	        	  return newTab.requesterId;
	          },
   	          setPersonId: function(personId) {
   	        	  newTab.personId = personId;
   	          },
   	          getPersonId: function() {
   	        	  return newTab.personId;
   	          },
   	          setAssignee: function(assignee) {
   	        	  newTab.assignee = assignee;
   	          },
   	          getAssignee: function() {
   	        	  return newTab.assignee;
   	          },
   	          setSettingId: function(settingId) {
   	        	  newTab.settingId = settingId;
   	          },
   	          getSettingId: function() {
   	        	  return newTab.settingId;
   	          },
   	          setServiceRequestSetting: function(serviceRequestSetting) {
   	        	  newTab.serviceRequestSetting = serviceRequestSetting;
   	          },
   	          getServiceRequestSetting: function() {
   	        	  return newTab.serviceRequestSetting;
   	          },
   	          setResponseData:function(responseData) {
   	        	  newTab.responseData = responseData;
   	          },
   	          getResponseData: function() {
   	        	  return newTab.responseData;
   	          },
   	          setFormData:function(formData) {
   	        	  newTab.formData = formData;
   	          },
   	          getFormData: function() {
   	        	  return newTab.formData;
   	          },
   	          setAdmissionId: function(admissionId) {
	        	  newTab.admissionId = admissionId;
	          },
	          getAdmissionId: function() {
	        	  return newTab.admissionId;
	          },
	          setDocumentData: function(documentData) {
	        	  newTab.documentData = documentData;
	          },
	          getDocumentData: function() {
	        	  return newTab.documentData;
	          },
	          setVoluntaryDocument: function(voluntaryDocument) {
	        	  newTab.voluntaryDocument = voluntaryDocument;
	          },
	          getVoluntaryDocument: function() {
	        	  return newTab.voluntaryDocument;
	          },
	          setProgramBatchId: function(programBatchId) {
	        	  newTab.programBatchId = programBatchId;
	          },
	          getProgramBatchId: function() {
	        	  return newTab.programBatchId;
	          },
	          setProgBatchPeriodConfigId: function(progBatchPeriodConfigId) {
	        	  newTab.progBatchPeriodConfigId = progBatchPeriodConfigId;
	          },
	          getProgBatchPeriodConfigId: function() {
	        	  return newTab.progBatchPeriodConfigId;
	          },
	          setAcademyLocationId: function(academyLocationId) {
	        	  newTab.academyLocationId = academyLocationId;
	          },
	          getAcademyLocationId: function() {
	        	  return newTab.academyLocationId;
	          },
	          setProgram: function(program) {
   	        	  newTab.program = program;
   	          },
   	          getProgram: function() {
   	        	  return newTab.program;
   	          },
   	          setRequestTypeCode: function(requestTypeCode) {
   	        	  newTab.requestTypeCode = requestTypeCode;
   	          },
   	          getRequestTypeCode: function() {
   	        	  return newTab.requestTypeCode;
   	          },
   	          setRequesterCode: function(requesterCode) {
	        	  newTab.requesterCode = requesterCode;
	          },
	          getRequesterCode: function() {
	        	  return newTab.requesterCode;
	          }
   	       
   	     });
   	 },
   	 
   	 /**
   	  * This method is use to set the configs to the tab. 
   	  */
   	
   	setServiceRequestConfig : function(newTab, requestType, requestGroup, studentId,personId, assignee, settingId, responseData,admissionId,setting,programBatchId,
   			progBatchPeriodConfigId, academyLocationId,program, requestTypeCode, studentCode){
   		 if(newTab){
   			 newTab.setRequestType(requestType);
   			 newTab.setRequestGroup(requestGroup);
   			 newTab.setRequesterId(studentId);
   			 newTab.setPersonId(personId);
   			 newTab.setAssignee(assignee);
   			 newTab.setSettingId(settingId); 
   			 newTab.setResponseData(responseData);
   			 newTab.setAdmissionId(admissionId);
   			 newTab.setServiceRequestSetting(setting);
   			 newTab.setProgramBatchId(programBatchId);
   			 newTab.setProgBatchPeriodConfigId(progBatchPeriodConfigId);
   			 newTab.setAcademyLocationId(academyLocationId);
   			 newTab.setProgram(program);
   			 newTab.setRequestTypeCode(requestTypeCode);
   			 newTab.setRequesterCode(studentCode);
   		 }
   	 },
   	 
   	/**
      * This method is use to open the request details form according to the request types
      * @param requestGroup Request group of the request
      * @param requestTypeId Id of the request type in case of request group OTHER.
      */
     openServiceRequestPanel: function(requestGroup, panel, requestTypeId,details,data,record) {
    	 if(panel && data && data.detail) {
    		 panel.isCalculateSeparateCGPAndSGPA = data.detail.isCalculateSeparateCGPAndSGPA;
    	 }
         var map = Academia.view.servicerequest.ServiceRequestViewMap;
         var academyLocationId = null;
         if(data instanceof Object) {
        	 academyLocationId = data.serviceRequestSetting.academyLocation.id;
         } else {
        	 academyLocationId=data;
         }
         switch (requestGroup) {
         case 'CERTIFICATE':
             {
                 var requestPanel = Ext.widget('certificaterequestdetailspanel');              
                 requestPanel.down('#requestorId').setValue(panel.getRequesterId());           
                 panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details);
                 break;
             }
         case 'TRANSFER':
         case 'Transfer':
         {
        	 var view = map.getRequestView(requestTypeId);
        	 var requestPanel = Ext.widget(view);
        	 if(details.programs && details.programs[0] && details.programs[0].id){
        		 requestPanel.programId=details.programs[0].id;
        	 }
        	 
        	 panel.add(requestPanel);
        	 this.getServiceRequestSettings(requestTypeId,SERVERURL.FIND_REQUEST_TYPE_ID,requestPanel,panel.getRequestType(),academyLocationId,data,record);                
        	 if(view == 'programrequestdetailspanel' || view == 'studenttransferrequestdetailspanel' || view == 'schoolleavingrequestdetailspanel'){
        		 this.setRequesterDetailsValues(panel,details,'TRANSFER_REQUEST');
        	 }else{
        			 if(view == 'leaveofabsencerequestform' || view == 'exchangesemesterrequestdetailspanel'){
        				 details.data = data;  
        			 }
        			 this.setRequesterDetailsValues(panel,details);
        		 }
        	 break;
         }
         case 'PERSONAL_DATA_CHANGE':
         case 'Personal Data Change':
             {
        	    var requestPanel = Ext.widget('personrequestdetailspanel');
        	     panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details);
                 break;
             }
         case 'FREE_FORM':
         case 'Free Form':
         case 'GENERAL':
             {
                 var requestPanel = Ext.widget('freeformrequestdetailspanel');
                 if(panel.config.freeFormRaiseReq==true){
                	 if(undefined!=requestPanel.down('#freeFormRequestSubTypeId')&&!isNullOrEmpty(requestPanel.down('#freeFormRequestSubTypeId'))){
                    	 requestPanel.down('#freeFormRequestSubTypeId').allowBlank = true
                         requestPanel.down('#freeFormRequestSubTypeId').setVisible(false); 
                     } 
                 }
                 panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details);
                 break;
             }
         case 'EXAM_RELATED':
             {
				var viewXtype = map.getRequestView(requestTypeId); 
				var requestPanel = Ext.widget('examrequestdetailspanel');
				requestPanel.down('#requestType').setValue(viewXtype);
				var examTypePanel = requestPanel.down('#examTypeRequest');
				var view = Ext.widget(viewXtype);
				examTypePanel.add(view);
				panel.add(requestPanel);
				this.getServiceRequestSettings(requestTypeId,SERVERURL.FIND_REQUEST_TYPE_ID,requestPanel,panel.getRequestType(),academyLocationId,data,record);				
				this.setRequesterDetailsValues(panel,details);
				break;
             }
         case 'FEE_RELATED':
         {
             var requestPanel = Ext.widget('feerequestdetailspanel');
             panel.add(requestPanel); 
             this.setRequesterDetailsValues(panel,details);
             break;
         } 
         case 'OTHER':
         {
        	 if(panel.gridTitle == 'Readmission' || panel.gridTitle == 'Readmission Request' || panel.requestGroup == 'READMISSION'){
        		 var requestPanel = Ext.widget('reAddmissionServiceRequest');              
            	 requestPanel.down('#requestorId').setValue(panel.getRequesterId());
            	 requestPanel.config.requestTypeCode = panel.getRequestTypeCode();
            	 panel.add(requestPanel);
            	 requestPanel.down('#campusId').setVisible(false);
            	 panel.down('#withdrawDateId').setVisible(false);
            	 if(typeof data == 'object' && data.detail){
            		 panel.down('#btnSaveRequestDetails').setVisible(false);
            	 }
            	 this.getServiceRequestSettings(requestTypeId,SERVERURL.FIND_REQUEST_TYPE_ID,requestPanel,panel.getRequestType(),academyLocationId,data,record);                
                 this.setRequesterDetailsValues(panel,details);
                 
                 /*To reinitialize readmission json objects*/
                var serviceRequestController = this.getController('Academia.controller.servicerequest.ServiceRequestController');
                serviceRequestController.readdmmisonRequestJsonData=null;
                serviceRequestController.EditDocumentFormDataNew=null;
        	 }else{
        		 var requestPanel = Ext.widget('hostelleaverequestdetailspanel');              
            	 requestPanel.down('#requestorId').setValue(panel.getRequesterId());
            	 requestPanel.config.requestTypeCode = panel.getRequestTypeCode();
        		 if(panel.getRequestTypeCode()==='LR'){
					requestPanel.down('#startDate').setMinValue(false);
				 }
            	 panel.add(requestPanel);
            	 this.getServiceRequestSettings(requestTypeId,SERVERURL.FIND_REQUEST_TYPE_ID,requestPanel,panel.getRequestType(),academyLocationId,data,record);                
                this.setRequesterDetailsValues(panel,details);
        	 }
        	
        	 break;
         }
         }
     },
     /**
      * This method is used to set other serviceREquestSettingID & assignee
      * @param requestTypeId 
      */
     getServiceRequestSettings : function(requestTypeId,url,requestPanel,requestCategory,academyLocationId,data,record){     
    	 var me = this;
    	// var academyLocationId = me.getCurrentAcademyLocation();
    	 var tab = null;
    	 var portalId = me.getCurrentLoggedPortalId();
    	 if(!isNullOrEmpty(requestPanel)){
    		 tab  = requestPanel.up('panel');
    	 }    
    	 var programId = null;
    	 var studentId=null;
    	 if(requestPanel.down('#leaveRequest')!=undefined && requestPanel.down('#leaveRequest').value=='Other'){
    		 if(record!=undefined && portalId!=3){
    			 studentId= record.data.ID;
    		 }
    		 var requestTypeCode = tab.getRequestTypeCode();
    		 if(!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR"){
    			 if(record!=undefined){
        			 programId = record.data.PROGRAM_ID;
        		}
    		 }
    		 /*else if(data!=undefined){
    			 studentId= data.requester.id;
    		 }*/
    	 } else if(requestCategory=="STUDENT_REQUEST"){
    		 if(record!=undefined){
    			 programId = record.data.PROGRAM_ID;
    		}
      	 }
    	 if((tab.gridTitle == 'Readmission' || tab.gridTitle == 'Readmission Request' || tab.requestGroup=="READMISSIO") && record ){
      		 		programId = record.data.PROGRAM_ID?record.data.PROGRAM_ID:record.data.programId;
      	 }
    	 if(record!=undefined && portalId!=3){
    		 studentId=record.data.ID;
		}
    	 var param = {
    			 requestTypeId : requestTypeId,
    			 academyLocationId : academyLocationId,
    			 serviceRequestCategory:requestCategory,
    			 programId:programId,
    			 studentId:studentId,
    			 
	           };    	 
    	 me.sendGetAjaxRequest(url, 'GET', param, function(opt, success, response) {
             if (success) {
            	 var settings="";
            	 if(!isNullOrEmpty(response.responseText)){
            		  settings = Ext.decode(response.responseText);
            	 }
            	 if(!isNullOrEmpty(tab) && !isNullOrEmpty(settings)){
            		 tab.setServiceRequestSetting(settings);
            		 var  isStudentAdivsor =false ;
            		 if(settings.serviceRequestCategory=="STUDENT_REQUEST" && settings.serviceRequestGroup=="OTHER"){
            			if(settings.isStudentAdivsor==true)
            			isStudentAdivsor=settings.isStudentAdivsor;
            		 }
                     requestPanel.down('#settingId').setValue(settings.id);
                     if(!isNullOrEmpty(settings.defaultAssignee)){
                     requestPanel.down('#assigneeId').setValue(settings.defaultAssignee.id);
                     if(requestTypeId === 47){
                    	 requestPanel.down('#assignedTo').setValue(settings.defaultAssignee.value);
                     }else if(isStudentAdivsor==true){
                    	 var personId=	requestPanel.items.items[2].value;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
							method : 'GET',
							params : {
								personId : personId,
								
							},
							 headers : {
            					 'Content-Type' : 'application/json'
            				 },
							async: false,
							success : function(response, action) {
								var resp = Ext.JSON.decode(response.responseText);
								var advisorId=resp.id;
								var reqPanel = Ext.ComponentQuery.query('hostelleaverequestdetailspanel')[0];
								reqPanel.down('#defultAssgineID').setValue(resp.id);
								reqPanel.down('#defultAssgineName').setValue(resp.value);
								reqPanel.down('#defultAssgineCode').setValue(resp.code);
								reqPanel.down('basicdetails').down('#assignedTo').setValue(resp.value);
							}
							});
				
                    	 
                     }else{
                    	 requestPanel.down('basicdetails').down('#assignedTo').setValue(settings.defaultAssignee.value);
                     }
                     
                     requestPanel.down('basicdetails').down('#RequestDate').setValue(new Date());
            	 }else if (isStudentAdivsor==true){
                	 var personId=	requestPanel.items.items[2].value;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
							method : 'GET',
							params : {
								personId : personId,
								
							},
							 headers : {
         					 'Content-Type' : 'application/json'
         				 },
							async: false,
							success : function(response, action) {
								var resp = Ext.JSON.decode(response.responseText);
								var advisorId=resp.id;
								var reqPanel = Ext.ComponentQuery.query('hostelleaverequestdetailspanel')[0];
								reqPanel.down('#defultAssgineID').setValue(resp.id);
								reqPanel.down('#defultAssgineName').setValue(resp.value);
								reqPanel.down('#defultAssgineCode').setValue(resp.code);
								reqPanel.down('basicdetails').down('#assignedTo').setValue(resp.value);
							}
							});
				
                 	 
                  } /*else{
                	  requestPanel.down('#assignedTo').setValue(me.getCurrentlyLoggedInUser().value);
                	  } */
                  }
             }
         });
     },
     
     /**
      * This is used to get Termination ,Transfer & debarment service request settings
      * @param requestTypeId
      * @param url
      * @param requestCategory
      * @return return settings object
      */
     getStudentServiceRequestSettings : function(requestTypeId,url,requestCategory){
    	 var me = this;
    	 var settings = null;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 
    	  Ext.Ajax.request({
              type: 'rest',
              async: false,
              method: 'GET',
              url: url, 
              params: {
            	  requestTypeId : requestTypeId,
     			  academyLocationId : me.getCurrentAcademyLocation(),
     			  serviceRequestCategory:requestCategory
              },
              success: function(response, action) {
            	  Ext.getBody().unmask();
            	  if(!isNullOrEmpty(response.responseText)){
            		  settings = Ext.decode(response.responseText);
            	  }            	  
              }
          });
    	 return settings ;
     },
     
     /**
      * This  method is used to Open Student Termination Panel 
      */
     openTerminationPanel:function(requestType,userId,settings,record){
    	 var requestTitle = 'Student Termination ';
    	 var tab = this.openTab(requestTitle, 'servicerequestpanel');
    	 var requestPanel = Ext.widget('terminationform'); 
    	 var admissionId = record.get('ADMISSION_ID');
    	 this.applyServiceRequestConfig(tab);
		 this.setServiceRequestConfig(tab, requestType, 'TERMINATION_REQUEST', userId, null, null, null,null,admissionId,null);
		 tab.add(requestPanel);
		 tab.setServiceRequestSetting(settings); 
		 var details = this.findRequesterDetailsByRequestorType(settings.serviceRequestCategory,userId,admissionId,tab);
		 this.setRequesterDetailsValues(requestPanel,details);
         requestPanel.down('#settingId').setValue(settings.id);
         if(!isNullOrEmpty(settings.defaultAssignee)){
        	  requestPanel.down('#assigneeId').setValue(settings.defaultAssignee.id);
         }
     },
     
     /**
      * This  method is used to Open Student Transfer Panel 
      */
     openTransferPanel:function(requestType,userId,settings,record){
    	 var requestTitle = 'Student Transfer ';
    	 var tab = this.openTab(requestTitle, 'servicerequestpanel');
    	 var requestPanel = Ext.widget('transferform'); 
    	 var admissionId = record.get('ADMISSION_ID');
    	 this.applyServiceRequestConfig(tab);
    	 this.setServiceRequestConfig(tab, requestType, 'TRANSFER_REQUEST', userId, null, null, null,null,admissionId, null);
    	 tab.add(requestPanel);
    	 tab.setServiceRequestSetting(settings); 
    	 var details = this.findRequesterDetailsByRequestorType(settings.serviceRequestCategory,userId,admissionId,tab);
		 this.setRequesterDetailsValues(requestPanel,details,'TRANSFER_REQUEST');
         requestPanel.down('#settingId').setValue(settings.id);
         if(!isNullOrEmpty(settings.defaultAssignee)){
       	  requestPanel.down('#assigneeId').setValue(settings.defaultAssignee.id);
        }
     },
     
     /**
      * This  method is used to Open Student Debarment Panel 
      */
     openDebarmentPanel:function(requestType,userId,settings,record){
    	 var requestTitle = 'Student Debarment ';
    	 var tab = this.openTab(requestTitle, 'servicerequestpanel');
    	 var requestPanel = Ext.widget('debarmentform'); 
    	 var admissionId = record.get('ADMISSION_ID');
    	 this.applyServiceRequestConfig(tab);
	     this.setServiceRequestConfig(tab, requestType, 'DEBRAMENT_REQUEST', userId, null, null, null,null,admissionId, null);
	     tab.add(requestPanel);
	     tab.setServiceRequestSetting(settings);        
	     var details = this.findRequesterDetailsByRequestorType(settings.serviceRequestCategory,userId,admissionId,tab);
		 this.setRequesterDetailsValues(requestPanel,details);
         requestPanel.down('#settingId').setValue(settings.id);
         if(!isNullOrEmpty(settings.defaultAssignee)){
       	  requestPanel.down('#assigneeId').setValue(settings.defaultAssignee.id);
        }
     },
     
     /**
      * This method is use to open the Student Transfer ,Termination & Debarment details form according to the request types
      * @param requestGroup Request group of the request
      * @param requestTypeId Id of the request type in case of request group OTHER.
      */
     openStudentServiceRequestPanel: function(requestGroup, panel, requestTypeId,details) {
         switch (requestGroup) {
         case 'TRANSFER':
             {
                 var requestPanel = Ext.widget('transferform');              
                 panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details,'TRANSFER_REQUEST');
                 break;
             }
         case 'TERMINATION':
             {
                 var requestPanel = Ext.widget('terminationform');
                 panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details);
                 break;
             }
         case 'DEBARMENT':
             {
    	 		 var requestPanel = Ext.widget('debarmentform');
                 panel.add(requestPanel);
                 this.setRequesterDetailsValues(panel,details);
                 break;
             }
         }
     },
     
     addMandatoryDocuments:function(settings,form) {
  	   var documents = settings.get('documentRules');
  	   var container = form.down('#mandatoryDocsId');
  	   var displayFieldArray = new Array();
  	   Ext.each(documents,function(document){
  		   var displayField =  new Ext.form.field.Display({
  			   fieldLabel: getServiceRequestTranslation('DOCUMENT_NAME'),
  			   value :document.document.value
  		   });
  		displayFieldArray.push(displayField);   
  	   }); 
  	   container.add(displayFieldArray);
     },
     
     setRequesterDetailsValues:function(panel,details,requestType) {
    	 var me = this;
    	 var requesterPanel = panel.down('#requesterDetails');
    	 var hostelleaverequesting = panel.down('hostelleaverequestdetailspanel');
    	 var name = requesterPanel.down('#name');
    	 var batch = requesterPanel.down('#batch');
    	 var program = requesterPanel.down('#program');
    	 var email = requesterPanel.down('#email');
    	 var mobile = requesterPanel.down('#mobile');
    	 var firstName = details.printName;
    	 var admissionDate = requesterPanel.down('#admissionDateDisplay');
    	 var batchendDate = requesterPanel.down('#batchEndDateItemId');
    	 var programName = '';
    	 var withdrawFromProgramName = '';
    	 var programId = '';
    	 var batchName = '';    	
    	 var hostelName = requesterPanel.down('#hostelName');
    	 var buildingName = requesterPanel.down('#buildingName');
    	 var roomNo = requesterPanel.down('#roomNo');
    	 var studentName =panel.down('#studentName');
    	 var studentCode =panel.down('#studentCode');
    	 var returnStatus =panel.down('#returnStatusItemId');
    	 var studentHyperLink = requesterPanel.down('#studentHyperLink');
    	 var periodName = requesterPanel.down('#periodId');
    	 var campusName = requesterPanel.down('#campusId');
    	 var academiaName = requesterPanel.down('#academiaName');
    	 var msg = getServiceRequestTranslation('N_A');
    	 var withdrawFromProgram = panel.down('#withdrawFromProgram');
    	 var portalIds = me.getCurrentLoggedPortalId();
    	 var fromProgram = panel.down('#fromProgramId');
    	  var academicTermField=panel.down('#academicTermProgramWithdrwanId');
    	 if((panel.requestTypeCode == 'WFPO'  || panel.requestGroup =='PROGRAM_WITHDRAWAL') && portalIds == '3'){
			withdrawFromProgram.setVisible(false); 
		 }
		 if((panel.requestTypeCode == 'WFPO' || panel.requestGroup =='PROGRAM_WITHDRAWAL') && (portalIds == '1' || portalIds == '7')){
			withdrawFromProgram.setVisible(true);
			fromProgram.setVisible(false); 
			academicTermField.setVisible(true);
			 Ext.Ajax.request({
        		 type : 'rest',
        		 async : false,
        		 url : SERVERURL.COMMON_FORM_FIELD_INFO,
        		 params : {
        			 screenName : 'withdrawfromprogramdetailspanel',
        			 academyLocationId : this.getCurrentAcademyLocation(),
        			 languageCode : 'en'
        		 },
        		 method : 'GET',
        		 success : function(res, action) {
        			 var response = Ext.decode(res.responseText);
        			 if (Object.keys(response).length > 0) {
        				 var records = response.withdrawfromprogramdetailspanel;
        				 for (i in records) {
        					 if (records[i].formFieldInputType == 'customcombobox'&& records[i].formFieldId =='academicTermProgramWithdrwanId') {

        						 academicTermField.setVisible(records[i].isVisible);
        					 }
        				 }
        			 }
        		 }
        	 });
		 }
    	 if(!isNullOrEmpty(fromProgram) && !isNullOrEmpty(details.programs)){
    	 fromProgram.setValue(details.programs.value);
         }    	 
    	 if(periodName){
        	 if(!isNullOrEmpty(details.periodName)){
        		 periodName.setValue(details.periodName);
        	 }else{
        		 periodName.setValue(msg);
        	 }
    	 }
    	 
    	 if(campusName){
        	 if(!isNullOrEmpty(details.campusName)){
        		 campusName.setValue(details.campusName);
        	 }else{
        		 campusName.setValue(msg);
        	 }
    	 }
    	 
    	 if(academiaName){
        	 if(!isNullOrEmpty(details.academyLocationName)){
        		 academiaName.setValue(details.academyLocationName);
        	 }else{
        		 academiaName.setValue(msg);
        	 }
    	 }
    	 
    	 if(batchendDate && !isNullOrEmpty(details.batchEndDate)){
    		 batchendDate.setValue(details.batchEndDate);
    	 }
    	 if(studentHyperLink && !isNullOrEmpty(details.code)){
    		 studentHyperLink.setText(details.code);
    	 }
    	 
    	 if(isNullOrEmpty(details.emailId)){
    		 email.setValue(msg);
    	 }else{
    		 email.setValue(details.emailId);
    	 }
    	 
    	 if(isNullOrEmpty(details.mobileNumber)){
    		 mobile.setValue(msg);
    	 }else{
    		 mobile.setValue(details.mobileNumber);
    	 } 
    	 if(details.hostel!=null){
    		 if(hostelleaverequesting!=null){
    			 var hostelRoomAllotmentId=hostelleaverequesting.down('#hostelRoomAllotmentId'); 
    		 }
    		
    	if(details.hostel==null && isNullOrEmpty(details.hostel.value)){
    		 hostelName.setValue(msg);
    	 }else{
    		 hostelName.setValue(details.hostel.value);
    	 }if(details.building==null && isNullOrEmpty(details.building)){
    		 buildingName.setValue(msg);
    	 }else{
    		 buildingName.setValue(details.building);
    	 }if(details.room==null && isNullOrEmpty(details.room.value)){
    		 roomNo.setValue(msg);
    		 if(hostelRoomAllotmentId!=null){
    			 hostelRoomAllotmentId.setValue(msg); 
    		 }
    	 }else{
    		 roomNo.setValue(details.room.value);
    		 if(hostelRoomAllotmentId!=null){
    			 hostelRoomAllotmentId.setValue(details.room.id); 
    		 }
    		 
    	 }
    	 }
		 name.setValue(firstName);
		 if(!isNullOrEmpty(studentName)){
			 studentName.setValue(details.printName);
		 }
		 if(!isNullOrEmpty(studentCode)){
			 studentCode.setValue(details.code);
		 }
		 if(!isNullOrEmpty(admissionDate)){
			 admissionDate.setVisible(false);
		 } 
		 /*if(!isNullOrEmpty(returnStatus)){
			 returnStatus.setVisible(false);
		 }*/
		 
		 admissionDate.setVisible(false);

		 if(panel.requestGroup == 'LEAVE_OF_ABSENCE'){
			/* var academyLocationCombo = panel.down('#academyLocationCombo');
			 var programCombo = panel.down('#programCombo');
			 var batchCombo = panel.down('#batchCombo');
			 var academicTermCombo = panel.down('#academicTermCombo');
			 var periodCombo = panel.down('#periodCombo');
			 var seatTypeCombo = panel.down('#seatTypeCombo');*/
			 var serviceRequestId;
			 	if(!isNullOrEmpty(details.data.id)){
			 		serviceRequestId= details.data.id;
			 	}
			 	var serviceRequestType='LEAVE_OF_ABSENCE';
			 var programField = panel.down('#programCombo');
             var batchField = panel.down('#batchCombo');
             var periodField = panel.down('#periodCombo');
             var seatTypeField = panel.down('#seatTypeCombo');
             var programFieldStore = programField.getStore();
             var batchFieldStore = batchField.getStore();
             var periodFieldStore = periodField.getStore();
             var seatTypeFieldStore = seatTypeField.getStore();
             var academyLocationField =panel.down('#academyLocationCombo');
             var academicTermField =panel.down('#academicTermCombo');
             var startDateField =panel.down('#startDate');
             var academicTermFieldStore = academicTermField.getStore(); 
             var portalId = me.getCurrentLoggedPortalId();
             startDateField.setValue(dateRender(details.data.detail.startDate));
             var programId;
             var batchId;
             var periodId;
             var seatTypeId;
             var academicTermId;
             
			 academicTermFieldStore.load({
              	params:{
              	//	portalId : portalId,
              		studentId: me.getContentPanelActiveTab().getRequesterId(),
              	//	admissionId : admissionId
              	},
              	callback: function(records, opt, success){
              		if(success){
              			programField.setDisabled(false);
              			batchField.setDisabled(false);
              			periodField.setDisabled(false);
              			seatTypeField.setDisabled(false);
	           			 
              			programField.setReadOnly(true);
              			batchField.setReadOnly(true);
              			periodField.setReadOnly(true);
              			seatTypeField.setReadOnly(true);
           				academicTermId = details.data.detail.academicTermId;
           				academicTermField.setValue(academicTermId);
               			academicTermField.setReadOnly(true);
             
               		 programFieldStore.load({
                        	params: {
                        		studentId: me.getContentPanelActiveTab().getRequesterId(),
                        		academicTermId:academicTermId,
                        		serviceRequestId:serviceRequestId,
                        		serviceRequestType:serviceRequestType
                        	},
                            callback: function(records, opt, success) {
                                if (success) {
                               //	 batchField.setDisabled(false);
                               			programId = details.data.detail.programId;
                                		programField.setValue(programId);
                                    //	programField.setReadOnly(true);
                                    	batchFieldStore.load({
                                        	params: {
                                        		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                        		academicTermId:academicTermId,
                                        		serviceRequestId:serviceRequestId,
                                        		serviceRequestType:serviceRequestType
                                        	},
                                            callback: function(records1, opt1, success1) {
                                            	 if (success) {
                                           				 batchId = details.data.detail.batchId;
                                            			 batchField.setValue(batchId);
                                            			 
                                            			 periodFieldStore.getProxy().extraParams = {
                                            				studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                    		academicTermId:academicTermId,
                                                    		serviceRequestId:serviceRequestId,
                                                    		serviceRequestType:serviceRequestType
                                            			 };
                                            			 periodFieldStore.load({
                                            				params: {
                                                        		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                        		academicTermId:academicTermId,
                                                        		serviceRequestId:serviceRequestId,
                                                        		serviceRequestType:serviceRequestType
                                                        	}, 
                                                        	callback: function(records1, opt1, success1) {
                                                        		if (success) {
                                                           				 periodId = details.data.detail.periodId;
                                                              			 periodField.setValue(periodId);
                                                              			 seatTypeFieldStore.getProxy().extraParams = {
                                                            				studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                    		academicTermId:academicTermId
                                                            			 };
                                                            			 seatTypeFieldStore.load({
                                                            				params: {
                                                                        		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                        		academicTermId:academicTermId,
                                                                        		serviceRequestId:serviceRequestId,
                                                                        		serviceRequestType:serviceRequestType
                                                                        	}, 
                                                                        	callback: function(records1, opt1, success1) {
                                                                        		if (success) {
                                                                           				seatTypeId = details.data.detail.seatTypeId;
                                                                            			seatTypeField.setValue(seatTypeId);
                                                                        		}
                                                                        	}
                                                            			 });
                                                        		}
                                                        		
                                                        	}
                                                           		 
                                            			 });
                                            	 }
                                            }
                                    	});
                                }
                            }
                        });
              		}
           }
       });
			 
			 returnStatus.setVisible(true);
			 if(details.data.detail.studentReturnStatus && details.data.detail.studentReturnStatus.id){
				 returnStatus.getStore().load({
					callback: function(){
						 returnStatus.setValue(details.data.detail.studentReturnStatus.id);
					} 
				 });
			 }
		 }
		 if(panel.requestGroup == 'EXCHANGE_SEMESTER'){
			 var fromAcademyLocationCombo = panel.down('#fromAcademyLocationId');
			 var fromProgramIdCombo = panel.down('#fromProgramId');
			 var fromBatchIdCombo = panel.down('#fromBatchId');
			 var fromPeriodIdCombo = panel.down('#fromPeriodId');
			 var toAcademyLocationCombo = panel.down('#toAcademyLocationItemId');
			 var toProgramCombo = panel.down('#toProgramId');
			 var toBatchCombo = panel.down('#toBatchId');
			 var toPeriodCombo = panel.down('#toPeriodId');
			 var academicTermField =panel.down('#academicTermCombo');
     		 var academicTermFieldStore = academicTermField.getStore(); 
     		 var programFieldStore = fromProgramIdCombo.getStore();
     		 var batchFieldStore = fromBatchIdCombo.getStore();
     		 var periodFieldStore = fromPeriodIdCombo.getStore();
     		 var toBatchFieldStore = toBatchCombo.getStore();
     		 var toPeriodFieldStore = toPeriodCombo.getStore();
     		 var programId;
     		 var batchId;
     		 var periodId;
     		 var academicTermId;
     		 var serviceRequestId;
     		 var isEditRequest = false;
                    var serviceRequestId = null;
					var activeTab = me.getContentPanelActiveTab();
					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
			} 
		 	if(!isNullOrEmpty(details.data.id)){
		 		serviceRequestId= details.data.id;
		 	}
			 fromAcademyLocationCombo.getStore().load({
				 params:{
					studentId: me.getContentPanelActiveTab().getRequesterId(),
					isEditRequest : isEditRequest,
					serviceRequestId : serviceRequestId
				 },
                 callback: function(records, opt, success) {
                	 if (success) {
                		 fromAcademyLocationCombo.setDisabled(false);
                		 toAcademyLocationCombo.setDisabled(false);
                		 toProgramCombo.setDisabled(false);
                		 toBatchCombo.setDisabled(false);
                		 toPeriodCombo.setDisabled(false);
            			 
                		 fromAcademyLocationCombo.setReadOnly(true);
                		 fromProgramIdCombo.setReadOnly(true);
                		 fromBatchIdCombo.setReadOnly(true);
                		 fromPeriodIdCombo.setReadOnly(true);
                		 toAcademyLocationCombo.setReadOnly(true);
                		 toProgramCombo.setReadOnly(true);
                		 toBatchCombo.setReadOnly(true);
                		 toPeriodCombo.setReadOnly(true);
                		 fromAcademyLocationCombo.setValue(details.data.detail.fromAcademyLocation);
                		 
                		 academicTermFieldStore.load({
                          	params:{
                          		studentId: me.getContentPanelActiveTab().getRequesterId(),
                          		admissionId : details.data.detail.admissionId,
                          		isEditRequest : isEditRequest
                          	},
                          	callback: function(records, opt, success){
                          		if(success){
                          				fromProgramIdCombo.setDisabled(false);
                          				academicTermId = details.data.detail.academicTermId;
                          				academicTermField.setValue(academicTermId);
                              			academicTermField.setReadOnly(true);
                            		    programFieldStore.load({
                                     	params: {
                                     		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                     		academicTermId:academicTermId,
                                     		admissionId:details.data.detail.admissionId,
                                     		serviceRequestId:serviceRequestId
                                     	},
                                         callback: function(records, opt, success) {
                                             if (success) {
                                            	 	fromBatchIdCombo.setDisabled(false);
                                             		programId = details.data.detail.fromProgram;
                                             		fromProgramIdCombo.setValue(programId);
                                                 	batchFieldStore.load({
                                                     	params: {
                                                     		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                     		academicTermId:academicTermId,
                                                     		admissionId:details.data.detail.admissionId,
                                                     		serviceRequestId:serviceRequestId
                                                     	},
                                                         callback: function(records1, opt1, success1) {
                                                         	 if (success1) {
                                                         		 	fromPeriodIdCombo.setDisabled(false);
                                                         			batchId = details.data.detail.fromBatch;
                                                         			fromBatchIdCombo.setValue(batchId);
                                                         			// commented for V2D-449837 read comments
                                                         			 /*periodFieldStore.getProxy().extraParams = {
                                                         				studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                 		academicTermId:academicTermId,
                                                                 		admissionId:details.data.detail.admissionId,
                                                                 		serviceRequestId:serviceRequestId
                                                         			 };*/
                                                         			 periodFieldStore.load({
                                                         				params: {
                                                                     		studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                     		academicTermId:academicTermId,
                                                                     		admissionId:details.data.detail.admissionId,
                                                                     		serviceRequestId:serviceRequestId
                                                                     	}, 
                                                                     	callback: function(records1, opt1, success1) {
                                                                     		if (success1) {
                                                                           			periodId = details.data.detail.fromPeriod;
                                                                           			fromPeriodIdCombo.setValue(periodId);
                                                                           			
                                                                           			
                                                                           			toAcademyLocationCombo.getStore().getProxy().extraParams = {
                                                                       			 };
                                                               					 toAcademyLocationCombo.getStore().load({
                                                               						 callback: function(records1, opt1, success1) {
                                                               							 toAcademyLocationCombo.setValue(details.data.detail.toAcademyLocation);
                                                               						 }
                                                               					 });
                                                               					 
                                                               					 toProgramCombo.getStore().getProxy().extraParams = {
                                                               						 academyLocationIds: details.data.detail.toAcademyLocation
                                                                       			 };
                                                               					 toProgramCombo.getStore().load({
                                                               						 callback: function(records1, opt1, success1) {
                                                               							 toProgramCombo.setValue(details.data.detail.toProgram);
                                                               						 }
                                                               					 });
                                                               					 
                                                               					 
                                                               					 
                                                               					toBatchFieldStore.load({
                                                                                	params: {
                                                                                		programId:details.data.detail.toProgram,
                                                                                    	academicTermId:academicTermId
                                                                                 	}, 
                                                                                 	callback: function(records1, opt1, success1) {
                                                                                 		if (success1) {
                                                                                   				batchId = details.data.detail.toBatch;
                                                                                   				toBatchCombo.setValue(batchId);
                                                                                   				toBatchCombo.setReadOnly(true);
                                                                                   				toPeriodCombo.setDisabled(false);
                                                                                      			toPeriodFieldStore.load({
                                                                                      				params: {
                                                                                      					programId:details.data.detail.toProgram,
                                                                                                    	academicTermId:academicTermId
                                                                                                 	}, 
                                                                                                 	callback: function(records1, opt1, success1) {
                                                                                                 		if (success1) {
                                                                                                       			periodId = details.data.detail.toPeriod;
                                                                                                       			toPeriodCombo.setValue(periodId);
                                                                                                       			toPeriodCombo.setReadOnly(true);
                                                                                                 		}
                                                                                                 		
                                                                                                 	}
                                                                                      				
                                                                                      			});
                                                                                 		}
                                                                                	
                                                                                 	}
                                                                                }); 
                                                               					 
                                                               					 
                                                               					 
                                                               					 
                                                               					 /*toBatchCombo.getStore().getProxy().extraParams = {
                                                               						 programId: details.data.detail.toProgram
                                                                       			 };
                                                               					 toBatchCombo.getStore().load({
                                                               						 callback: function(records1, opt1, success1) {
                                                               							 toBatchCombo.setValue(details.data.detail.toBatch);
                                                               						 }
                                                               					 });
                                                               					 
                                                               					 toPeriodCombo.getStore().getProxy().extraParams = {
                                                               						 id: details.data.detail.toBatch
                                                                       			 };
                                                               					 toPeriodCombo.getStore().load({
                                                               						 callback: function(records1, opt1, success1) {
                                                               							 toPeriodCombo.setValue(details.data.detail.toPeriod);
                                                               						 }
                                                               					 });*/
                                                                           			
                                                                           			
                                                                           			
                                                                           			 }
                                                                     		}
                                                         			 });
                                                         	 }
                                                         }
                                                 	});
                                             }
                                         }
                                     });
                          		}
                       }
                   });
                	 }
                 }
			 });
			 
			 admissionDate.setValue(dateRender(details.admissionDate));
			 admissionDate.setVisible(true);
		 }
		 
		 if(panel.requestGroup == 'OTHER' || panel.requestGroup == 'HOSTEL_LEAVE'){
			 var requestTypeCode = panel.getRequestTypeCode();
			 if(!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR"){
				 hostelName.setVisible(false);
				 buildingName.setVisible(false);
				 roomNo.setVisible(false);
			 }
			 else{
				 hostelName.setVisible(true);
				 buildingName.setVisible(true);
				 roomNo.setVisible(true);
			 }
			 if(panel.title == 'READMISSION' || panel.requestGroup == 'READMISSION' || panel.title== "Readmission Request" || panel.title=="Readmission"){
				 hostelName.setVisible(false);
				 buildingName.setVisible(false);
				 roomNo.setVisible(false);
				 campusName.setVisible(false);
				 panel.down('#withdrawDateId').setVisible(false);
			 }
		 }
		 
    	 if(!isEmpty(details.admissionCodes)) {
    		 Ext.each(details.programs,function(program){
				 if(!isNullOrEmpty(program) && !isNullOrEmpty(program.id)){
					  programId = program.id;
					  programName = program.value;
					  withdrawFromProgramName = program.value; 
				 }else{
    			 if(programName ==='') {
    				 programName = programName.concat(program);
    			 } else {
    				 programName = programName.concat(' , ',program);
    			 } 
    			 }
    		 });
    		 Ext.each(details.batches,function(batch){
    			 if(batchName ==='') {
    				 batchName = batchName.concat(batch);
    			 } else {
    				 batchName = batchName.concat(' , ',batch);
    			 }
    		 });
    		 
    		 Ext.each(details.admissionCodes,function(admissionNumber){
    			 if(firstName){
    				 firstName = firstName.concat('(',admissionNumber,')');
    			 }
    		 });
    		 
    		 name.setValue(firstName);
    		 batch.setValue(batchName);
    		 program.setValue(programName);
    		 if(!isNullOrEmpty(withdrawFromProgram) && !isNullOrEmpty(withdrawFromProgramName))
    		 withdrawFromProgram.setValue(withdrawFromProgramName);
    		 
    		 if(!isNullOrEmpty(requestType)){
    			 var schoolleaving = Ext.ComponentQuery.query('schoolleavingrequestdetailspanel')[0];
    			 if(requestType == 'TRANSFER_REQUEST'){
    				 
    				var portalId = this.getCurrentLoggedPortalId();
		    		if(portalId != 3){
		    			if(schoolleaving != undefined){
		    				admissionDate.setVisible(false);
		    			}
		    			else{
		    				admissionDate.setVisible(true);	
		    			}
		    		}
    				admissionDate.setValue(dateRender(details.admissionDate));
    			 }
    		 }else if(panel.requestGroup == 'OTHER' || panel.requestGroup == 'HOSTEL_LEAVE'){
    			 var requestTypeCode = panel.getRequestTypeCode();
    			 if(!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR"){
    				 hostelName.setVisible(false);
    				 buildingName.setVisible(false);
    				 roomNo.setVisible(false);
    			 }
    			 else{
    				 hostelName.setVisible(true);
    				 buildingName.setVisible(true);
    				 roomNo.setVisible(true);
    			 }
    			 if(panel.title == 'READMISSION' || panel.requestGroup == 'READMISSION' || panel.title== "Readmission Request" || panel.title=="Readmission"){
    				 hostelName.setVisible(false);
    				 buildingName.setVisible(false);
    				 roomNo.setVisible(false);
    				 campusName.setVisible(false);
    				 panel.down('#withdrawDateId').setVisible(false);
    			 }
			 }
    		 else if(panel.requestGroup == 'TRANSFER'){
    			 var requestTypeCode = panel.getRequestTypeCode();
    			 if(!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LOA"){
    				 if(!isNullOrEmpty(details.admissionDate)){
    					 admissionDate.setValue(dateRender(details.admissionDate));
        				 admissionDate.setVisible(true);
    				 }
    				// returnStatus.setVisible(true);
    			 }else if(!isNullOrEmpty(requestTypeCode) && requestTypeCode == "ES"){
    				 if(!isNullOrEmpty(details.admissionDate)){
    					 admissionDate.setValue(dateRender(details.admissionDate));
        				 admissionDate.setVisible(true);
    				 } 
    			 }
    		 }
    		 
    	 } else {
    		 batch.setVisible(false);
    		 program.setVisible(false);
    		 name.setValue(firstName);
    		 var department = requesterPanel.down('#department');
    		 department.setVisible(true);
    		 department.setValue(details.departmentName); 
    		 var subDepartment = requesterPanel.down('#subDepartment');
    		 subDepartment.setVisible(true);
    		 subDepartment.setValue(details.subDepartmentName);    	
    	 }
    	 
    	 if(panel.requestGroup == 'STUDENT_TRANSFER'){
    		 panel.down('#reasonForLeavingItemId').setReadOnly(false);
    		 panel.down('#RequestReason').setReadOnly(false);
    	 }
     },
     
     findRequesterDetailsByRequestorType:function(requestorType,requesterId,admissionId, tab) {
    	 var me = this;
    	 var url = '';
    	 var res = '';
    	 requestorType ==='FACULTY_REQUEST'? url=SERVERURL.FIND_FACULTY_REQUESTOR_DETAILS:url=SERVERURL.FIND_STUDENT_REQUESTOR_DETAILS;
    	 var alIds = Ext.Array.pluck(Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations,'id').join();
    	 var params = new Object();
    	 params.id = requesterId;
    	 params.alIds = alIds;
    	 params.admissionId=admissionId;
    	 Ext.Ajax.request({
  			type:'rest',
  			async: false,
  			method:'GET',
  			url:url,
  			params:params,
  			success:function(response) {
  				res = (Ext.decode(response.responseText));
  				if(tab){
  					tab.setPeriodId(res.periodId);
  				 }
  				}
  		});
    	 return res;    	
     }
});