/**
 * @author Dharmendra.Prajapati
 */
Ext.define('Academia.controller.servicerequest.eventcalendar.EventCalendarController', {
	extend: 'Academia.controller.base.BaseController',
	
	models: [],
	
	stores: ['servicerequest.eventcalendar.EventCalendarGridStr','common.StatusComboStore','servicerequest.eventcalendar.EventCountStr',
	         'servicerequest.eventcalendar.AllEventCalendarName','common.AcademyLocationNameSeparated','common.ProgramsByAcademyIdLocationId'],
	
	views: ['servicerequest.eventcalendar.EventCalendarStructure','servicerequest.eventcalendar.EventCalendarSearch',
	        'servicerequest.eventcalendar.EventCalendarGrid','servicerequest.eventcalendar.EventCalendarWin',
	        'servicerequest.eventcalendar.NoOfEventCountGrid','servicerequest.eventcalendar.ViewCalendarWin'
	        ],
	
    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel' 
    },{
    	ref : 'eventcalendargrid',
    	selector : 'eventcalendargrid' 
    },{
    	ref : 'eventcalendarsearch',
    	selector : 'eventcalendarsearch' 
    },{
    	ref : 'eventcalendarwin',
    	selector : 'eventcalendarwin' 
    },{
    	ref : 'eventCalendarwin',
    	selector : 'eventcalendarwin form' 
    },{
    	ref : 'noofeventcountgrid',
    	selector : 'noofeventcountgrid' 
    },{
    	ref : 'noofeventCountgrid',
    	selector : 'noofeventcountgrid form' 
    },{
    	ref : 'noofeventcountGrid',
    	selector : 'noofeventcountgrid grid' 
    },{
    	ref : 'viewcalendarwin',
    	selector : 'viewcalendarwin' 
    }],
    config: {
    	EVENT_CALENDER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TOOLS_EVENT_CALENDER_PRIVILEGES'),
    },
    init: function(application) {
    	this.control({
    		
    		'eventcalendargrid button[itemId=btnAdd]':{
    			click : this.openCalendarWin
    		},
    		'eventcalendargrid button[itemId=btnEdit]':{
    			click : this.editCalendarWin
    		},
    		'eventcalendargrid button[itemId=btnDelete]':{
    			click : this.deleteCalendarRecord
    		},
    		'eventcalendargrid button[itemId=viewCalendar]':{
    			click : this.openViewCalendarWin
    		},
    		'eventcalendarsearch button[itemId=searchButtonId]':{
    			click : this.getEventCalendarsDetails
    		},
    		'eventcalendarsearch button[itemId=resetButtonId]':{
    			click :function(){ 
    				this.resetEventCalendarsDetails();
    			}
    		},
    		'eventcalendargrid': {
				render: function(grid) {
 					this.doAccessControlValidation(grid, this.getEVENT_CALENDER_PERMISSIONS());
 					this.disableViewCalandarPivileges(grid, this.getEVENT_CALENDER_PERMISSIONS());
				},
				cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				var searchResultGrid = this.getEventcalendargrid();
    				var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
    				if(columnName=='noOfEvents'){
    					if (e.target.tagName == 'A') {
    						this.openNoOfEventDetails(grid, rowIndex, record);
    					}
    				}
    			} 
			},
    		'eventcalendarwin button[itemId=saveBtn]':{
    			click:this.saveEventCalendarDetails	
    		},
    		'eventcalendarwin button[itemId=cancelBtn]':{
    			click:function(){
    				this.getEventcalendarwin().close();
    			}	
    		},
    		'eventcalendarsearch customcombobox#academyLocationId': {
    			select: function(obj, record) {
    				var academyLocationId = record[0].get("id");
    				if(academyLocationId > 0){
    					var form = obj.up('form');
    					var programField = form.down("#programId");
    					var store = programField.getStore();
    					store.getProxy().extraParams = {
    						academyLocationIds: academyLocationId
    					};
    					store.load();
    				}
    			}
    		},
    		'eventcalendarsearch ': {
    			render: function(obj, record) {
    				var academyLocationId = this.getCurrentAcademyLocation();
    				if(academyLocationId > 0){
    					var form = obj.up('form');
    					var programField = form.down("#programId");
    					var store = programField.getStore();
    					store.getProxy().extraParams = {
    						academyLocationIds: academyLocationId
    					};
    					store.load();
    				}
    			}
    		}
    	});
    	this.callParent(arguments);
    },
    getEventCalendarsDetails:function(){
    	var grid = this.getEventcalendargrid();
    	var form = this.getEventcalendarsearch().getForm();
    	var values = form.getValues();
    	var store = grid.getStore();
		   store.getProxy().extraParams = {
			   calendarId:values.calendarId,
			   academyLocationId:values.academyLocationId,
			   programId:values.programId,
			   status :values.status
		   };
		   store.loadPage(1);
		   grid.getSelectionModel().deselectAll();
		   /*pdf & excel report header filter*/
	       grid.config.searchFilterForm = this.getEventcalendarsearch();
    	
    },
    resetEventCalendarsDetails:function(){
    	var form = this.getEventcalendarsearch().getForm();
    	form.reset();
    	var program = form.findField('programId');
    	var programStore = program.getStore();
//    	programStore.load();
    	programStore .getProxy().extraParams = {
			academyLocationIds: this.getCurrentAcademyLocation()
		};
    	programStore .load();
    },
    openCalendarWin:function(){
    	var $this = this;
	   	 var formWindow = $this.getEventcalendarwin();
	   	 if (!formWindow) {
	   		 Ext.widget('eventcalendarwin');
	   		 formWindow = $this.getEventcalendarwin();
	   	 }
	   	 formWindow.show();
    },
    
    saveEventCalendarDetails : function(){
        var $this = this;
        var window = $this.getEventcalendarwin();
        var form = $this.getEventCalendarwin();
        var grid = $this.getEventcalendargrid();
        
        var submitUrl, isUpdate = false;
        
        var id = form.down('#id');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.EVENT_CALENDAR_SAVE;
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.EVENT_CALENDAR_UPDATE;
            isUpdate = true;
        }
        var jsonFormatFormData = $this.getJsonSubmitData(form);
        
        $this.applyWindowMask(); 
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	$this.hideWindowMask();
        	if(success){
        		window.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('TS_UPDATE_EVENT_CALENDAR_DETAILS'));
                } else {
                    showSuccessMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('TS_ADD_EVENT_CALENDAR_DETAILS'));
                }
    		}else{
    			window.close();
                grid.getStore().reload();
    		}
        });
    },
    getJsonSubmitData: function(form) {
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    editCalendarWin:function(){
        var $this = this;
        var grid = $this.getEventcalendargrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	this.openCalendarWin();
        	var form = $this.getEventCalendarwin();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
                form.down("#validFrom").setValue(dateRender(records.data.validFrom));
                form.down("#validTo").setValue(dateRender(records.data.validTo));
            }
        } else {
            showWarningMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    
    },
    deleteCalendarRecord: function() {
    	$this = this;
        var grid = $this.getEventcalendargrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.EVENT_CALENDAR_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('TS_DELETE_EVENT_CALENDAR_DETAILS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    openNoOfEventDetails : function(grid, rowIndex, record){
    	var $this = this;
    	var formWindow = $this.getNoofeventcountgrid();
    	if (!formWindow) {
    		Ext.widget('noofeventcountgrid');
    		formWindow = $this.getNoofeventcountgrid();
    	}
    	formWindow.show();

    	var form = $this.getNoofeventCountgrid().getForm();
    	if(!isNullOrEmpty(record.data.name)){
    		form.findField('name').setValue(record.data.name);
    	}
    	if(!isNullOrEmpty(record.data.validFrom)){
    		var validFrom = record.data.validFrom;
    		form.findField('validFrom').setValue(dateRender(validFrom));
    	}
    	if(!isNullOrEmpty(record.data.validTo)){
    		var validTo = record.data.validTo;
    		form.findField('validTo').setValue(dateRender(validTo));
    	}
    	var store = $this.getNoofeventcountGrid().getStore();
    	store.getProxy().extraParams = {
    		id:record.data.id
    	};
    	store.load();
    },
    openViewCalendarWin:function(){
    	var $this =this;
    	var grid = $this.getEventcalendargrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var formWindow = $this.getViewcalendarwin();
    		if (!formWindow) {
    			Ext.widget('viewcalendarwin');
    			formWindow = $this.getViewcalendarwin();
    		}
    		formWindow.show();
    		this.getCalendarData(grid);
    	} else {
    		showWarningMessage(getCommonTranslation('TS_EVENT_CALENDAR'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    getCalendarData:function(grid){
    	var calendar = this.getViewcalendarwin();
    	var records = grid.getSelectionModel().getSelection()[0];
    	var eventCalendarId = records.data.id;
    	calendar.eventStore.getProxy().actionMethods.read='GET';
    	submitURL=SERVERURL.EVENT_VIEW_CALENDAR;  

    	calendar.eventStore.getProxy().url = submitURL;
    	if(!isNullOrEmpty(eventCalendarId)){
    		calendar.eventStore.getProxy().setExtraParam('eventCalendarId', eventCalendarId);
    		calendar.eventStore.load();	
    	}
    },
    
  //******************Disable viewCalendar button**********************************
    disableViewCalandarPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var viewCalendar = gridReference.down('#viewCalendar');
    	
    	viewCalendar.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEWCALENDAR') {
        		if(!isNullOrEmpty(viewCalendar)){
        			viewCalendar.setVisible(true);
        		}        		
        	}
    	});
    }
});
