/**
 * @author Pritam.Patil
 * This is used for tables dashboard controller 
 */
Ext.define('Academia.controller.setup.dashboard.TablesDashboardController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['setup.dashboard.TransactionViewSearchForm', 'setup.dashboard.TransactionViewPanel', 'setup.dashboard.TranactionViewGrid',
            'setup.dashboard.UserViewSearchForm', 'setup.dashboard.UserViewPanel', 'setup.dashboard.UserViewGrid', 
            'setup.dashboard.TransactionDetailsForm', 'setup.dashboard.TablesTabPanel', 'setup.dashboard.TransactionDetailsGrid',
            'setup.dashboard.ChangeViewForm'],

    stores: ['setup.dashboard.TransactionViewStore', 'setup.dashboard.NatureOfChanges', 'setup.dashboard.NatureOfTransactions', 'setup.dashboard.TransactionDetailsGridStore', 'setup.dashboard.SelectRecords'],
    refs: [{
        ref: 'transactionViewSearchForm',
        selector: 'transactionviewsearchform'
    }, {
        ref: 'userViewSearchForm',
        selector: 'userviewsearchform'
    }, {
        ref: 'tranactionViewGrid',
        selector: 'tranactionviewgrid'
    }, {
        ref: 'transactionDetailsGrid',
        selector: 'transactiondetailsgrid[itemId=transactionDetailsGridId]'
    }, {
        ref: 'dynamicForm',
        selector: 'changeviewform form[itemId=dynamicFormId]'
    }, {
        ref: 'changeViewForm',
        selector: 'changeviewform'
    },{
    	ref: 'transactionDetails',
    	selector : 'transactiondetailsform form[itemId=transactionDetailsId]'
    }],

    init: function(application) {
        this.control({
            'tablestabpanel': {
                tabchange: function(tabPanel, newCard, oldCard, eOpts) {
                    var tab = tabPanel.activeTab.itemId;
                    var this$ = this;
                    switch (tab) {
                    case 'transactionViewPanelId':
                        {
                            var grid = tabPanel.down('#tranactionViewGrid');
                            this$.loadTransactionViewId(grid);
                            break;
                        }
                    case 'userViewPanelId':
                        {
                            var grid = tabPanel.down('#userViewGrid');
                            this$.loadUserViewId(grid);
                            break;
                        }
                    }
                },
                render: function(tabPanel) {
                    var grid = tabPanel.down('#tranactionViewGrid');
                    this.loadTransactionViewId(grid);
                }
            },

            'transactionviewsearchform button[itemId=findButtonId]': {
                click: function(button) {
                    var grid = button.up('transactionviewpanel').down('#tranactionViewGrid');
                    this.resetGridSetting(grid);
                    this.loadTransactionViewId(grid);
                }
            },
            'transactionviewsearchform button[itemId=clearSearch]': {
            	click: function(button) {
            		var form = this.getTransactionViewSearchForm();
            		form.getForm().reset();
            		var toDate =form.down('#till_date');
            		toDate.setMinValue(null);
            		toDate.setMaxValue(null);
            		var fromDate =form.down('#from_date');
            		fromDate.setMinValue(null);
            		fromDate.setMaxValue(null);
            	}
            },

            'userviewsearchform button[itemId=findButtonId]': {
                click: function(button) {
                    var grid = button.up('userviewpanel').down('#userViewGrid');
                    this.loadUserViewId(grid);

                }
            },

            'transactionviewpanel tranactionviewgrid[itemId=tranactionViewGrid]': {
                cellclick: function(grid, td, cellIndex, record) {
                    var searchGrid = this.getTranactionViewGrid();
                    var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                    if (columnName === "count") {
                        this.loadTransactionDetailsGrid(record);
                    }
                }
            },

            'userviewpanel userviewgrid[itemId=userViewGrid]': {
                cellclick: function(grid, td, cellIndex, record) {
                    var searchGrid = this.getTranactionViewGrid();
                    var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                    if (columnName === "count") {
                        this.loadTransactionDetailsGrid(record);

                    }
                }
            },

            'transactiondetailsform transactiondetailsgrid[itemId=transactionDetailsGridId]': {
                cellclick: function(grid, td, cellIndex, record) {
                    this.cellClickTransactionGrid(grid, cellIndex, record);
                }
            },

            'changeviewform combo[itemId=selectTableId]': {
                change: function(combo, newValue, oldValue, eOpts) {
                 	if(newValue){
	                    var revId = combo.up('form').down('#revID').getValue();
	                    this.loadSelectRecordCombo(combo, revId);
                    }
                }
            },

            'changeviewform combo[itemId=selectRecordId]': {
         		change: function(combo,newValue, oldValue, eOpts) {
         			if(newValue){
         				this.setDynamicFormData(combo);
         			}
                }
            }
        });

    },

    /**
     * This is used to load transaction view grid
     * @param transactionViewPanel
     */
    loadTransactionViewId: function(grid) {
        var form = this.getTransactionViewSearchForm();
        var obj = form.getValues();
        if(obj.user){
        	obj.userId = obj.user.id;
            delete obj.user;
        }
        var sortObj = new Object();
        sortObj.property = 'transactionCode';
        sortObj.direction = 'ASC';
        var list = new Array();
        list.push(sortObj);
        obj.sort = Ext.encode(list);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        grid.getStore().getProxy().extraParams = obj;
        grid.getStore().load();
        var taskDelay = new Ext.util.DelayedTask(function() {
            Ext.getBody().unmask();
        });
        taskDelay.delay(1000);
    },

    /**
     * This is used to load user view grid
     * @param userViewPanel 
     */
    loadUserViewId: function(grid) {
        var form = this.getUserViewSearchForm();
        var obj = form.getValues();
        var sortObj = new Object();
        sortObj.property = 'userName';
        sortObj.direction = 'ASC';
        var list = new Array();
        list.push(sortObj);
        obj.sort = Ext.encode(list);
        delete obj.userId;
        obj.userId=form.down('#user').getValue();
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        grid.getStore().getProxy().extraParams = obj;

        grid.getStore().load();
        var taskDelay = new Ext.util.DelayedTask(function() {
            Ext.getBody().unmask();
        });
        taskDelay.delay(1000);
    },

    /**
     * this method is used for loading transaction details grid
     * @param record
     */
    loadTransactionDetailsGrid: function(record) {
        var tabTitle = getCommonTranslation('TRANSACTION_DETAILS');
        this.openTab(tabTitle, 'transactiondetailsform');
        var transactionGrid = this.getTransactionDetailsGrid();
        var transDetails = this.getTransactionDetails();
        var obj = new Object();

        var transactionCode = record.get('transactionCode');
        var transDate = record.get('transactionDate');
        var user =  record.get('userName');
        
        obj.transactionCode = transactionCode ;
        obj.timestamp = transDate;
        obj.userId = record.get('userId');
        obj.user = user;
        transDetails.getForm().setValues(obj);
        transDetails.down('[name=timestamp]').setRawValue(dateRender(transDate));
        delete obj.user;
        transactionGrid.getStore().getProxy().extraParams = obj;
        transactionGrid.getStore().load();
    },

    /**
     * This is used to open tab on click of view Change 
     * @param grid
     * @param cellIndex
     * @param record
     */
    cellClickTransactionGrid: function(grid, cellIndex, record) {
        var columnName = grid.panel.columnManager.columns[cellIndex].text;
        // removed hard coded column name from if condition
        var dataChangedCol = getCommonTranslation('DATA_CHANGED');
        if (columnName === dataChangedCol) {
            var tabTitle = getCommonTranslation('CHANGE_VIEW');
            this.openTab(tabTitle, 'changeviewform');
            var form = this.getChangeViewForm();
            this.setFormValue(form, record);
        }
    },
    
    
    checkFieldToBeAdd : function(fieldName){
    	return (fieldName !== 'REV' && fieldName !== 'id'
    		&& fieldName !== 'lastUpdate' && fieldName !== 'lastUpdatedBy' 
    			&& fieldName !== 'REVTYPE'&& fieldName !== '$old_REV' && fieldName !== '$old_id'
    	    		&& fieldName !== '$old_lastUpdate' && fieldName !== '$old_lastUpdatedBy' 
    	    			&& fieldName !== '$old_REVTYPE'&& fieldName !== 'password'&& fieldName !== '$old_password'
    	    				&& fieldName !== 'salt'&& fieldName !== '$old_salt');
    },

    createForm : function(form, data) {
        var formItems = [],this$=this;
        if(data !== null){
        	
            var values = data.values,oldData= data.oldValues, headerHbox =  this$.getHBox(),fieldName=getCommonTranslation('FIELD_NAME'),
            oldValue=getCommonTranslation('OLD_VALUE'),      newValue=getCommonTranslation('NEW_VALUE');
            
            
     	   var headerLabel1 = this$.getDisplayfield( '<B>'+newValue+'</B>' ,'<B>'+fieldName+'</B>','40%');
     	  headerLabel1.width='60%';
     	  headerHbox.items.push(headerLabel1);
     	  if(oldData){
	     	   var headerLabel2 = this$.getDisplayfield( '<B>'+oldValue+'</B>');
	     	   headerLabel2.width='60%';
		       headerHbox.items.push(headerLabel2);
     	  }
	        formItems.push(headerHbox);
            
            Ext.iterate(values, function(fieldName, val) {
            	
		           if (this$.checkFieldToBeAdd(fieldName)) {
   		        	   var hbox =  this$.getHBox(), oldValue='';
		        	   		        	   
		        	   if(oldData){
		        		   oldValue=  oldData[fieldName];
		        	   }
		        	   
		        	   var field1 = this$.getDisplayfield(val,getCommonTranslation(fieldName),'40%');
		        	   field1.width='60%';
		        	   
		        	   if(oldValue!=val){
			        	   field1.fieldLabel= '<B>'+getCommonTranslation(fieldName)+'</B>';
		        	   }
		        	   
		        	   var field2 = this$.getDisplayfield(oldValue,getCommonTranslation(fieldName));
		        	   field2.width='40%';
		        	   field2.hideLabel=true;
		        	   
		               hbox.items.push(field1);
		               hbox.items.push(field2);
		               formItems.push(hbox);
		           }
		       });
       }else{
        var field = {
                xtype: 'displayfield',
                value: getCommonTranslation('EMPTY_GRID_MESSAGE'),
                minWidth: 437,
                labelWidth: 220
            };
            formItems.push(field);
    	}
        form.removeAll();
        form.add(formItems);
    },
    
    getHBox : function() {
		return field = {
				 xtype: 'fieldcontainer',
				 border:true,
				 style:{
					 border:'1px'
				 },
			        layout: {
			            type: 'hbox'
			        },
			        items:[]
		};
    },
    
    getDisplayfield : function(value,fieldLabel,labelWidth) {
		var field = {
				 xtype: 'displayfield',
				 
			        layout: {
			            type: 'hbox'
			        },
			        value:value,
			        listeners: {
						render: function(field) {
							if(fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_SESSIONDATE') || fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_LASTUPDATE')  )
								field.setValue(dateRender(value));
							else if(fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_SLOTTO') || fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_SLOTFROM')  )
								field.setValue(timeRender(value));
							else if(fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_OPTIONALSESSION') || fieldLabel == getCommonTranslation('COURSE_COVERAGE_PLAN_HISTORY_WHETHERATTENDANCETOBEENTERED')  )
								if(value==true){
									field.setValue('Yes');
								}else{
									field.setValue('No');
								}
						}
					},
			        items:[]
		};
		
		if(fieldLabel){
			field.fieldLabel=fieldLabel;
		}
		if(labelWidth){
			field.labelWidth=labelWidth;
		}
		return field;
    },
   
       /**
     * This is used to set form values
     * @param form ref of changeViewForm
     * @param record grid selected record
     */
    setFormValue: function(form, record) {
        this.resetFormValues(form);
        form.down('#changeViewTrans').getForm().setValues(record.data);
        form.down('[name=transactionDate]').setRawValue(dateRender(record.data.transactionDate));
        var tables = form.down('#selectTableId');
        var tablesArray = record.get('classNames').split(',');
        var storeData = new Array();
        for (var i = 0; i < tablesArray.length; i++) {
            storeData.push({
                value: tablesArray[i].trim()
            });
        }
        var store = Ext.create('Ext.data.Store', {
            fields: ['value'],
            data: storeData
        });
        if(storeData.length>0)
        	tables.select(store.getAt(0));
        tables.bindStore(store);
    },

    /**
     * This is used to load select record combo on select of select select table combo
     * @param combo
     * @param revId
     */
    loadSelectRecordCombo: function(combo, revId) {
    	var me = this;
        var selectRecordCombo = combo.up('form').down('#selectRecordId');
        var store = selectRecordCombo.getStore();
        form = me.getDynamicForm();
        form.removeAll();
        selectRecordCombo.setDisabled(false);
        store.comboRef=selectRecordCombo;
        selectRecordCombo.reset();
        store.load({
            params: {
                className: combo.getValue(),
                revisonNumber: revId
            },
            callback: function(records) {
                for (var i = 0; i < records.length; i++) {
                    if (records[i].get('REVTYPE') === 0) {
                        records[i].set('REVTYPE', getCommonTranslation('ADD'));
                    } else if (records[i].get('REVTYPE') === 1) {
                        records[i].set('REVTYPE', getCommonTranslation('UPDATE'));
                    } else if (records[i].get('REVTYPE') === 2) {
                        records[i].set('REVTYPE', getCommonTranslation('DELETE'));
                    }
                }
                
                for (var count = 0; count < records.length; count++) {
                    var record = records[count];
                    var concatValue = record.get('id')+ "-" +record.get('REVTYPE');
                    records[count].set('value', concatValue);
                }
                
                this.comboRef.select(this.getAt(0));
            }
        });
        
        store.commitChanges();
    },
    /**
     * This is used to set dynamic form data 
     * @param combo ref of select record combo
     * @oldValueForm ref of old value form
     */
    setDynamicFormData: function(combo) {
        var me = this, revisionCmbValue = combo.up('form').down('#revID').getValue();
        var tableId = combo.up('form').down('#selectTableId').getValue();
        
        var revId  = revisionCmbValue,  form = me.getDynamicForm();
        
        var param = {
            id: combo.getValue(),
            revisonNumber: revId,
            tableName: tableId
        };
        me.sendGetAjaxRequest(SERVERURL.FIND_BY_ID_AND_REVISION+"3", 'GET', param, function(option, success, response) {
            if (success) {
            	if(response.responseText !== ""){
            		var data = Ext.decode(response.responseText);
            		  me.createForm(form, data);
            	}else{
          	      me.createForm(form, null);
            	}
            }
        });
    },
    
    
    /**
     * this is used to reset form values
     * @param form which is ref of changeViewForm
     */
    resetFormValues : function(form){
    	  var recordCombo = form.down('#selectRecordId');
          var tables = form.down('#selectTableId');
          form.down('#dynamicFormId').removeAll();
          tables.reset();
          recordCombo.setDisabled(true);
          recordCombo.reset();
    }
});