/**
 * @author Amit Gupta
 * This is used for Term and Condition Report dashboard controller 
 */
Ext.define('Academia.controller.setup.dashboard.TermsandConditionReportController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['setup.dashboard.TermsandConditionLogReportStructure', 'setup.dashboard.TermsandConditionReportViewPanel', 'setup.dashboard.TermsandConditionViewSearchForm',
            'setup.dashboard.TermsandConditionReportViewGrid'],

    stores: ['common.AcademyLocationNameSeparated', 'setup.dashboard.UserGroupTermandConditionReportStore'],
    refs: [{
        ref: 'termsandconditionviewsearchform',
        selector: 'termsandconditionviewsearchform'
    }, {
        ref: 'termsandconditionreportviewgrid',
        selector: 'termsandconditionreportviewgrid'
    }],

    init: function(application) {
        this.control({
            'termsandconditionviewsearchform button[itemId=searchButtonId]': {
                click: function(button) {
                    var grid = this.getTermsandconditionreportviewgrid();
                    this.resetGridSetting(grid);
                    this.loadTermandConditionGrid(grid);
                }
            },
            'termsandconditionviewsearchform button[itemId=clearSearch]': {
            	click: function(button) {
            		var form = this.getTermsandconditionviewsearchform();
            		var academyLocationId = form.down('#academyLocationId');
            		var academyLocationStore =  academyLocationId.getStore();
            		var academyLocation = this.getCurrentAcademyLocation();
            		academyLocationStore.load({
            			callback: function(records, operation, success) {
            				for(var i in records){
            					if(records[i].data.id==academyLocation){
            						academyLocationId.setValue(records[i].data.id);
            					}
            				}
            			}
            		});
            		form.getForm().reset();
            		var toDate =form.down('#till_date');
            		toDate.setMinValue(null);
            		toDate.setMaxValue(null);
            		var fromDate =form.down('#from_date');
            		fromDate.setMinValue(null);
            		fromDate.setMaxValue(null);
            	}
            },
            'termsandconditionviewsearchform': { // getting the academyId, locationId from the form and sending request to server
            	afterrender: function(obj) {
            		var academyLocationId = obj.down('#academyLocationId');
            		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
            		academyLocationId.labelSeparator = '';
            		academyLocationId.setFieldLabel(getCommonTranslation('TERMCONDITION_ACADEMY_LOCATION')+allowblankFalse);
            		var academyLocationStore =  academyLocationId.getStore();
            		var academyLocation = this.getCurrentAcademyLocation();
            		academyLocationId.setValue(academyLocation);
            		
            		var userTypeField = obj.down('#userType');
            		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
            		userTypeField.labelSeparator = '';
            		userTypeField.setFieldLabel(getCommonTranslation('TERMCONDITION_USER_TYPE')+allowblankFalse);
            	}
		  }
        });
    },

    /**
     * This is used to load transaction view grid
     * @param transactionViewPanel
     */
    loadTermandConditionGrid: function(grid) {
    	var $this=this;
    	var formLayout = $this.getTermsandconditionviewsearchform();
    	$this.showInvalidIconOnField(formLayout);
    	var form = $this.getTermsandconditionviewsearchform().getForm();
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	pdftoolbar.setDisabled(true);
    	exceltoolbar.setDisabled(true);
    	var values = form.getValues();
    	var academyLocationIds = values.ACADEMY_LOCATION_ID;

    	var alIds = [];
    	var academyLocationAllIds;
    	if (academyLocationIds != undefined && academyLocationIds.length > 0 && academyLocationIds[0] != "") {
    		for (var i in academyLocationIds) {
    			if (Ext.isObject(academyLocationIds[0])) {
    				alIds.push(academyLocationIds[i].get("id"));
    			} else {
    				alIds.push(academyLocationIds[i]);
    			}
    		}
    		academyLocationAllIds = alIds.join();
    	}
    	else
    	{
    		academyLocationAllIds=$this.getCurrentAcademyLocation();
    	}

    	var userTypeIds=values.userType;
    	var fromDate = values.fromDate;
    	var tillDate = values.tillDate;


    	var store=grid.getStore();
    	$this.resetPageSetting(store);
    	store.getProxy().extraParams = {
    		academyLocationIds: academyLocationAllIds,
    		fromDate :fromDate,
    		tillDate:tillDate,
    		userType:userTypeIds,
    	};
    	store.load({
    		callback: function(records, operation, success) {
    			if(records.length>0){
    				pdftoolbar.setDisabled(false);
    				exceltoolbar.setDisabled(false);
    			}
    		}
    	});

    }
});