/**
 * @author Deepak Mathur
 * 
 */
Ext.define('Academia.controller.sgappointment.sgappointment.SGApplicantAppointmentController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',
	// un-comment the model code if required.
	//models : [''],
	stores: ['sgappointment.sgappointment.SGStudentAppointmentStore', 'common.CountryStore', 'sgappointment.sgappointment.SGVisitorCategoryStore',
	         'hostel.roomallocation.UserSmartSearchByUserType', 'sgappointment.sgappointment.SGAppointeeNameStore',
	         'sgappointment.sgappointment.SGBookingIDStore', 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch', 'sgappointment.sgappointment.SGParentGuardianStore',
	         'enquiry.EnquiryCodeSearchStore', 'sgappointment.sgappointment.SGReasonForVisitStore', 'sgappointment.sgappointment.SGVisitStatus',
	         'feeandpayment.managebill.Student','enquiry.EnquiryCodeSearchStore','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
	         'sgappointment.sgappointment.SGApplicantAppointmentGridStore', 'enquiry.EnqIntermediateType',
	         'common.AcademyLocationNameSeparated','program.ProgrmaFromBeatchLevelModAndRegType','enquiry.AcademicBatchStore','enquiry.ProgramBatchSeatTypeStore',
	         'common.AcademyLocationAppointment','program.ProgramsForAppointment','enquiry.BatchesForAppointment','enquiry.ProgramBatchSeatTypeForAppointment',
	         'sgappointment.sgappointment.SGAppointmentFlagIdStore','admission.applications.applicantProfileBase.ApplicantSmartSearchStore','enquiry.EnquiryCodeSearchForAppointmentStore'],
	         views: ['sgappointment.sgappointment.SGAppointmentTabStructure', 'sgappointment.sgappointment.SGStudentAppointmentDetailStructure', 'sgappointment.sgappointment.SGAppointmentFilter',
	                 'sgappointment.sgappointment.SGAppointmentForm', 'sgappointment.sgappointment.SGReasonToMeetGridWin', 'servicerequest.eventcalendar.ViewCalendarWin',
	                 'personinfo.common.course.ScheduleDetails', 'baselayout.contentarea.ContentPanel','sgappointment.sgappointment.SGApplicantAppointmentDetailStructure','sgappointment.sgappointment.SGApplicantAppointmentGrid'
	                 ],
	                 config: {
	                	 APPLICANT_MANAGE_APPOINTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_MANAGE_APPOINTMENT_PRIVILEGES'),
	                	 APPLICANT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES'),
	                 },
	                 refs: [{
	                	 ref: 'sgappointmentfilter',
	                	 selector: 'sgappointmentfilter'
	                 }, {
	                	 ref: 'contentPanel',
	                	 selector: 'contentPanel'
	                 },	{
	                	 ref: 'sgreasontomeetgridwin',
	                	 selector: 'sgreasontomeetgridwin'
	                 },	{
	                	 ref: 'viewcalendarwin',
	                	 selector: 'viewcalendarwin'
	                 }, {
	                	 ref: 'scheduledetails',
	                	 selector: 'scheduledetails'
	                 }, {
	                	 ref: 'sgappointmentform',
	                	 selector: 'sgappointmentform[itemId=sgappointmentapplicantform]'
	                 }, {
	                	 ref: 'sgapplicantappointmentgrid',
	                	 selector: 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId]'
	                 },{
	                	 ref: 'sgapplicantappointmentdetailstructure',
	                	 selector: 'sgapplicantappointmentdetailstructure'
	                 }],
	                 init: function() {
	                	 this.control({


	                		 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId]': {
	                			 render: function(grid) {
	                				 var me = this;  
	                				 var portalId = me.getCurrentLoggedPortalId();
	                				 if(portalId==6)
	                				 {
	                					 this.doAccessControlValidation(grid, this.getAPPLICANT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
	                				 }else{
	                					 this.doAccessControlValidation(grid, this.getAPPLICANT_MANAGE_APPOINTMENT_PERMISSIONS());
	                				 }
	                				                                       
	                				 var applicantProfile = me.getContentPanelActiveTab();
	                				 try{
	                					 applicantProfile.getApplicationId();
	                				 } catch(e){
	                					 applicantProfile = me.getContentPanel().items.items[0];
	                				 }
	                				 
									 grid.getStore().getProxy().extraParams = {
										 application: applicantProfile.getApplicationId()
									 };
									 grid.getStore().load();
	                			 }
	                		 },
	                		/* 'sgapplicantappointmentdetailstructure': {
	                			 activate: function(tab, eOpts) {
	                				 var gridStore = Ext.getStore('sgappointment.sgappointment.SGApplicantAppointmentGridStore');
	                				 var gridStore = this.getSgapplicantappointmentgrid().getStore();

	                				 // grid.loadPage(1);
	                				 gridStore.getProxy().extraParams = {
	                					 page: gridStore.currentPage,
	                					 limit: gridStore.pageSize,
	                					 start: ((gridStore.currentPage - 1) * (gridStore.pageSize)),
	                				 };
	                				 gridStore.load({
	                					 callback: function(record, operation, success) {
	                						 if (success) {
	                							 delete gridStore.getProxy().extraParams.page;
	                							 delete gridStore.getProxy().extraParams.limit;
	                							 delete gridStore.getProxy().extraParams.start;
	                							 delete gridStore.getProxy().extraParams.academyLocationIds;
	                						 }
	                					 }
	                				 });

	                			 }
	                		 },*/

	                		 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId] button[itemId=btnDelete]': {
	                			 click: this.deleteSGAppointmentDetailRecord
	                		 },
	                		 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId] button[itemId=btnAdd]': {
	                			 click: function() {
	                				 this.addSGAppointmentApplicantDetailRecord('ADD');
	                				 this.setEntrybyValuebydefault();
	                				 this.setVisitStatusByDefault();
	                			 }
	                		 },
	                		 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId] button[itemId=btnEdit]': {
	                			 click: function(obj, record) {
	                				 var $this=this;
	                				 var grid = $this.getSgapplicantappointmentgrid();
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 var record=grid.getSelectionModel().getSelection()[0];
	                					 if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment == true){
	                						 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("RESCHEDULE_APPOINTMENT_CANT_BE_EDITED"));
	                						 return;
	                					 }else{
	                						 this.editAppointmentApplicantDetailRecord(obj, record);
	                					 }
	                				 }
	                			 }
	                		 },
	                		 'sgapplicantappointmentgrid[itemId=sgapplicantappointmentgridItemId] button[itemId=btnView]': {
	                			 click: this.viewSGAppointmentApplicantDetailRecord
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] button[itemId=submitBtn]': {
	                			 click: this.saveSGAppointmentApplicantRecord
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] button[itemId=resetBtnForm]':{
	                			 click: function(){
	                				 var $this=this;
	                				 var form = $this.getSgappointmentform();
	                				 var visitTimeIdfield=form.getForm().findField('visitTime');
	                				 var expectedOutTimefield=form.getForm().findField('expectedOutTime');
	                				 visitTimeIdfield.setMaxValue(null);
	                				 visitTimeIdfield.setMinValue(null);
	                				 expectedOutTimefield.setMaxValue(null);
	                				 expectedOutTimefield.setMinValue(null);
	                				 this.resetSGAppointment(form);
	                				 this.setEntrybyValuebydefault();
	                				 this.setVisitStatusByDefault();
	                				 var me = this;  
	                				 var portalId = me.getCurrentLoggedPortalId();
	                				 if(portalId!=6) {
		                				 form.getForm().findField('bookingDate').setValue(new Date());
		                				 var userId=this.getCurrentlyLoggedInUser();
		                				 var personToMeetId = form.down("#personToMeetId");
		                				 personToMeetId.store.load({
		                					 callback : function(operation,success) {
		                						 if (success) {
		                							 personToMeetId.setValue(userId.id);
		             			    			}
		             			    		} 
		             			    	});
	                				 }
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] button[itemId=viewCalendar]': {
	                			 click: this.openViewCalendarWin
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] combo[itemId=personToMeetId]': {
	                			 render: function(obj) {
	                					var sgForm=this.getSgappointmentform();
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                				 var me = this;  
	                				 var portalId = me.getCurrentLoggedPortalId();
	                				 if(portalId!=6) {
		                				 var userId=this.getCurrentlyLoggedInUser();
		                				 obj.store.load({
		                					 callback : function(operation,success) {
		                						 if (success) {
		                							 obj.setValue(userId.id);
	                 			    			}
	                 			    		} 
	                 			    	});
	                				 }
	                				 Ext.defer(function(){
	                         			sgForm.down("#documentUploadFile").setVisible(false);
	                         			sgForm.down("#documentUploadFile").setDisabled(true);
	                         		},1000);
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] combo[itemId=personToMeetFilterItemId]': {
	                			 render: function(obj) {
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] combo[itemId=entryById]': {
	                			 render: function(obj) {
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                			 }
	                		 },
							 'sgappointmentform[itemId=sgappointmentapplicantform] combo[itemId= academyLocationId]': {
								 render: function(obj) {
									 var this$ = this;
									 var applicationId = null;
									 var items = this$.getContentPanel().items.items;

									 for (var i = 0; i < items.length; i++) {
										 var item = items[i];
										 if (item.xtype === 'applicantprofile') {
											 applicationId = item.getApplicationId();
											 break;
										 }
									 }
									 var store = obj.getStore();
									 store.getProxy().extraParams = {
										 enquiryStudentDetailId: null,
										 applicationId: applicationId
									 };
									 store.load();
								 }
							 },

	                		 'scheduledetails radiogroup[itemId=viewCalendarId]': {
	                			 change: function(obj, rec) {
	                				 if (rec.isViewCalendar) {
	                					 this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA);
	                				 } else {
	                					 this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS);
	                				 }
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] customcombobox[itemId=viewStatusID]': {
	                			 select : function(obj, record){
	                				 var sgForm=this.getSgappointmentform();
	                				 var recVal = record[0].data.value;
	                				 var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                				 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                				 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                				 var chkRescheduleAppointment = sgForm.down('#chkRescheduleAppointment');
	                				 if(recVal == "Rescheduled"){
	                					 rescheduleAppointmentFld.setVisible(true);
	                					 this.setAllowBlank(rescheduleAppointmentDateId,false);
	                					 rescheduleAppointmentDateId.reset();
	                					 chkRescheduleAppointment.setValue(true);
	                				 }
	                				 else{
	                					 rescheduleAppointmentFld.setVisible(false);
	                					 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                					 rescheduleAppointmentDateId.reset();
	                				 }
	                				 rescheduleAppointmentTimeId.reset();
	                				 sgForm.getForm().checkValidity();
	                			 }
	                		 },
	                         'sgappointmentform[itemId=sgappointmentapplicantform] checkboxfield[itemId=chkRescheduleAppointment]': {
	                        	 change : function(cmp, currentValue, oldValue, eOpts){
	                        		 var sgForm=this.getSgappointmentform();
	                        		 var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                        		 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                        		 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                        		 if (currentValue == true) {
	                        			 dateTimeRescheduleAppointmentItemId.setVisible(true);
	                        			 this.setAllowBlank(rescheduleAppointmentDateId,false);
	                        			 rescheduleAppointmentDateId.reset();
	                        		 }
	                        		 else{
	                        			 dateTimeRescheduleAppointmentItemId.setVisible(false);
	                        			 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                        			 rescheduleAppointmentDateId.reset();
	                        		 }
	                        		 rescheduleAppointmentTimeId.reset();
	                        		 sgForm.getForm().checkValidity();
	                        	 }
	                         },
  	                		 'sgappointmentform[itemId=sgappointmentapplicantform] combo#reasonForVisitID': {
	                			 select: function(obj,record) {
	                				 this.setExpectedOutTimeForApplicant(obj,record);
	                			 }
	                		 },
  	                		 'sgappointmentform[itemId=sgappointmentapplicantform] timefield[itemId=visitTimeId]': {
	                			 change: function(obj,record) {
	                				 this.setExpectedOutTimeForApplicant(obj,record);
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] datefield[itemId=appointmentId]': {
	                			 change: function(obj,record) {
	                				 var sgForm=this.getSgappointmentform();
	                				 var isAppointeeItemId=sgForm.down("#isAppointeeItemId");
	                				 var currentDate = Ext.Date.format(new Date() ,'Y-m-d');
	                				 var appointmentDate = Ext.Date.format(record ,'Y-m-d');
	                				 if(obj.itemId == 'appointmentId'){
	                					 if(currentDate>appointmentDate){
	                						 isAppointeeItemId.setValue({isAppointee:false});
	                					 }else{
	                						 isAppointeeItemId.setValue({isAppointee:true});
	                					 }
	                				 }
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentapplicantform] combo#reasonForVisitID':{
		    	            	   select : function(obj,record){
                  				   var userGroupName = record[0].get("code");
             	        		    this.enableOrDisableAdditionalReasonApplicant(userGroupName);
                  			   }
	        		 		  },
							 'sgappointmentform[itemId=sgappointmentapplicantform] customcombobox#academyLocationId': {
								 select: function(obj, record) {
									 var this$ = this;
									 var programComboField = obj.up('form').down('#programId');
									 var academyLocationField = obj.up('form').down('#academyLocationId');
									 var batchCombo = obj.up("form").down("#batchId");
									 var seatCombo = obj.up('form').down('#seatTypeId');
									 var alValue = academyLocationField.getValue();
									 programComboField.reset();
									 programComboField.setDisabled(false);
									 batchCombo.reset();
									 batchCombo.setDisabled(true);
									 batchCombo.allowBlank=true;
									 seatCombo.reset();
									 seatCombo.setDisabled(true);
									 seatCombo.allowBlank=true;
									 
									 var applicationId = null;
									 var items = this$.getContentPanel().items.items;
									 for (var i = 0; i < items.length; i++) {
										 var item = items[i];

										 if (item.xtype === 'applicantprofile') {
											 applicationId = item.getApplicationId();
											 break; // stop once found
										 }
									 }
									 programComboField.getStore().getProxy().extraParams = {
										 academyLocationId: alValue,
										 enquiryStudentDetailId: null,
										 applicationId: applicationId
									 }
									 this$.loadDFRForManageAppointment(academyLocationField);
									 programComboField.getStore().load();
								 }
							 },
							 'sgappointmentform[itemId=sgappointmentapplicantform] customcombobox#programId': {
								 select: function(obj, record) {
									 var this$ = this;
									 var programId = record[0].get("id");
									 var batchCombo = obj.up('form').down('#batchId');
									 var seatCombo = obj.up('form').down('#seatTypeId');
									 batchCombo.reset();
									 batchCombo.setDisabled(false);
									 seatCombo.reset();
									 seatCombo.setDisabled(true);
									 seatCombo.allowBlank = true;
									 var academyLocationId = obj.up('form').down("#academyLocationId");
									 this$.loadDFRForManageAppointment(academyLocationId);
									 
									 var applicationId = null;
									 var items = this$.getContentPanel().items.items;

									 for (var i = 0; i < items.length; i++) {
										 var item = items[i];
										 if (item.xtype === 'applicantprofile') {
											 applicationId = item.getApplicationId();
											 break; // stop once found
										 }
									 }
									 batchCombo.getStore().getProxy().extraParams = {
										 programId: programId,
										 enquiryStudentDetailId: null,
										 applicationId: applicationId
									 };
									 batchCombo.getStore().load();
									 obj.up('form').isValid();
								 }
							 },
							 'sgappointmentform[itemId=sgappointmentapplicantform] customcombobox#batchId': {
								 select: function(obj, record) {
									 var this$ = this;
									 var batchId = record[0].get("id");
									 var seatCombo = obj.up('form').down('#seatTypeId');
									 seatCombo.reset();
									 seatCombo.setDisabled(false);
									 var academyLocationId = obj.up('form').down("#academyLocationId");
									 this$.loadDFRForManageAppointment(academyLocationId);

									 var applicationId = null;
									 var items = this$.getContentPanel().items.items;

									 for (var i = 0; i < items.length; i++) {
										 var item = items[i];
										 if (item.xtype === 'applicantprofile') {
											 applicationId = item.getApplicationId();
											 break; // stop once found
										 }
									 }
									 seatCombo.getStore().getProxy().extraParams = {
										 batchId: batchId,
										 enquiryStudentDetailId: null,
										 applicationId: applicationId
									 };
									 seatCombo.getStore().load();
									 obj.up('form').isValid();
								 }
							 }
	                	 });
	                 },
	                 setEntrybyValuebydefault: function() {
	                	 var me = this;
	                	 var portalId = me.getCurrentLoggedPortalId();
	                	 var userId = this.getCurrentlyLoggedInUser();
	                	 var sgForm = this.getSgappointmentform();
	                	 var entryByField = sgForm.down("#entryById");
        				 if(portalId==6)
        				 {
        					 var appUserId = 1;
        					 entryByField.store.load({
        						 callback: function(operation, success) {
        							 if (success) {
        								 entryByField.setValue(appUserId);
        							 }
        						 }
        					 });

        				 }else{
        					 entryByField.store.load({
    	                		 callback: function(operation, success) {
    	                			 if (success) {
    	                				 entryByField.setValue(userId.id);
    	                			 }
    	                		 }
    	                	 });
        				 }
	                 },
	                 setVisitStatusByDefault: function(){
	                	 var sgForm=this.getSgappointmentform();
	                	 var viewStatusID = sgForm.down("#viewStatusID");
	                	 var viewStatusIDStore = viewStatusID.getStore();
	                	 viewStatusID.setReadOnly(true);
	                	 viewStatusIDStore.load({
	                		 callback:function(records,operation,success){
	                			 var rec = viewStatusIDStore.findRecord('code','Booked');
	                			 if(!isNullOrEmpty(rec)){
	                				 var idVal = rec.get('id');
	                				 viewStatusID.setValue(idVal);
	                			 }
	                		 }
	                	 });  
	                	 var me = this;  
        				 var portalId = me.getCurrentLoggedPortalId();
	                	 if(portalId!=6) {
	                		 sgForm.down("#appointmentId").setValue(new Date());	
	                	 }
	                 },
	                 deleteSGAppointmentDetailRecord: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgapplicantappointmentgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 var records = grid.getSelectionModel().getSelection();
	                				 var id = records[0].get("id");
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.SG_APPOINTMENT_DELETE + '?id=' + id,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {
	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
	                						 $this.resetPageSetting(store);
	                						 grid.getStore().reload();
	                					 }

	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },
	                 
	                 /*added for appointment tab on Applicant detail*/
	                 addSGAppointmentApplicantDetailRecord:function(openView, submitPortal){
	              	   var me = this;
	              	   var appPortalId = me.getCurrentLoggedPortalId();
	              	   var applicantProfile = me.getContentPanelActiveTab();
	              	   var applicationId = null;
	              	   var applicationCode = null;
	              	   var emailId = null;
	              	   var mobileCode = null;
	              	   var mobileNo = null;
	              	   try{
	              		   if(appPortalId==6){
	              			   applicationId = me.getContentPanel().items.items[0].getApplicationDataObject().id;
	              			   applicationCode = me.getContentPanel().items.items[0].getApplicationDataObject().code;
	              			   mobileNo =  me.getContentPanel().items.items[0].getApplicationDataObject().person.mobileNumber;
	              			   emailId =  me.getContentPanel().items.items[0].getApplicationDataObject().person.emailId;
	              			   mobileCode = me.getContentPanel().items.items[0].getApplicationDataObject().person.mobileCountryCode;
	              			   
	              		   }else{
	              			  // applicantProfile.getApplicationId();
	              			   applicationId = applicantProfile.getApplicationDataObject().id;
	              			   applicationCode = applicantProfile.getApplicationDataObject().code;
	              			   mobileNo =  applicantProfile.getApplicationDataObject().person.mobileNumber;
	              			   emailId =  applicantProfile.getApplicationDataObject().person.emailId;
	              			   mobileCode = applicantProfile.getApplicationDataObject().person.mobileCountryCode;
	              		   }           		   

	              	   } catch(e){
	              		   applicantProfile = me.getContentPanel().items.items[0];
	              	   }
	              	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	              	   var structure = Ext.widget('sgappointmentform', {
	          				itemId : 'sgappointmentapplicantform'
	          			});
	              	   
	              	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	              	 //  var manageAppointmentTab = me.getFacultyappointmentstructuretab();
	              	   /**
	              	    * This is to remove tab from content panel and open same tab again
	              	    */
	              	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	              	   var getTab=getcontroller.getTab(tabName);
	              	   if(getTab!=null){
	              		   contentPanel.remove(getTab, true);
	              	   }
	              	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_EIGHT);

	              	   var visitorCategoryIDCombo =Ext.ComponentQuery.query("#visitorCategoryID")[0];
	              	   var visitorCategoryIDComboStore = visitorCategoryIDCombo.getStore();
	              	   visitorCategoryIDComboStore.load({
	              		   callback:function(record){
	              			   for(var i in record) {
	              				   if(record[i].data.id == 5) {    					
	              					   visitorCategoryIDCombo.setValue(record[i].data.id);
	              					   visitorCategoryIDCombo.resetOriginalValue();
	              					   visitorCategoryIDCombo.setReadOnly(true);
	              					   visitorCategoryIDCombo.setVisible(false);
	              					   var sgForm=me.getSgappointmentform();
	              					   var bookingID = sgForm.down("#bookingId");
	              				    	 if(bookingID.readOnly != true){
	              				          me.setAllowBlank(bookingID,false);  
	              					      me.setFieldPlaceHolder(bookingID,'');
	              						  }else{
	              						         me.setAllowBlank(bookingID,true);
	              						         me.setFieldPlaceHolder(bookingID,getCommonTranslation('ID_AUTOGENERATE'));
	              					       }
	              					  // var facResultGrid = me.getFacultySearchResultGrid();
	              					   sgForm.down("#appointeeNameId").setVisible(false);
	              					   sgForm.down("#studentItemId").setVisible(false);
	              					   sgForm.down("#flagRelatedRadio").setVisible(false);
	              					   var applicantCombo = sgForm.down("#applicantNameId");
	              					   applicantCombo.setVisible(true);
	              					   var facCombo = sgForm.down("#facAppointmentId");
	              					   facCombo.setVisible(false);
	              					   var appointeeNameField=sgForm.down('#appointeeNameId');
	              					   var parentGuardian=sgForm.down("#appointeeNameParentId");
	              					   var leadNameField=sgForm.down("#leadId");
	              					   leadNameField.setVisible(false);
	              					   var reasonForVisitID = sgForm.down("#reasonForVisitID");
	              					   var visitCatId = record[i].data.id;
	             	    			   var reasonForVisitStore=reasonForVisitID.getStore();
	             	    			   reasonForVisitStore.getProxy().extraParams = {
	             	    				  id : visitCatId,
	             	    				 
	             	    			  };
	             	    			   reasonForVisitStore.load();
	              					   var studentNameField = sgForm.down("#studentItemId");
	              					   var appPortalId = me.getCurrentLoggedPortalId();
	              					   var staffInfo = null;
	              					   var appointeeEmailField = sgForm.down("#appointeeEmailItemId");
	              					   var mobileNoField = sgForm.down("#mobileNo");
	              					   var cellCountryCodeField = sgForm.down("#cellCountryCode");
	              					   var entryByNameItem = sgForm.down("#entryByNameItemId");
	              					   var entryByItem = sgForm.down("#entryById");
	              					   appointeeEmailField.setReadOnly(true);
	              					   mobileNoField.setReadOnly(true);
	              					   cellCountryCodeField.setReadOnly(true);
	              					   var reasonForVisitIDComboStore = reasonForVisitID.getStore();
	              					   var applicantStore = applicantCombo.getStore();
	              					   var cellCountryCodeStore = cellCountryCodeField.getStore();

	              					   appointeeNameField.allowBlank = true;
	              					   parentGuardian.allowBlank = true;
	              					   leadNameField.allowBlank = true;
	              					   studentNameField.allowBlank = true;
	              					   facCombo.allowBlank = true;

	              					   /*var locations = [];
	              					   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	              					   for(var i=0; i<academyLocationList.length; i++){
	              						   locations.push(academyLocationList[i].id);
	              					   }*/
	              					   
	              					   if(openView == 'ADD'){
	              						   var submitPortalData = sgForm.down("#submitPortalId")
	              						   submitPortalData.setValue(appPortalId);
	              					   }
	              					   if(appPortalId == 6){
	              						   if(submitPortal == 1){
	              							   entryByNameItem.setVisible(false);
	              							   entryByItem.setVisible(true);
	              							 //  entryByItem.allowBlank = true;
	              							   
	              							   appointeeEmailField.setValue(emailId);
	              							   mobileNoField.setValue(mobileNo);
	              							   applicantCombo.setReadOnly(true);
	              						   }else{
	              							   var entryName = applicantCombo.getValue();
	              							   entryByNameItem.setVisible(true);
	              							   entryByNameItem.setReadOnly(true);
	              							   entryByItem.setVisible(false);
	              							   entryByItem.allowBlank = true; // uncomment for Bug: V2D-41415

	              							   appointeeEmailField.setValue(emailId);
	              							   mobileNoField.setValue(mobileNo);
	              						   }        						  
	              					   }else{
	              						   appointeeEmailField.setValue(emailId);
	              						   mobileNoField.setValue(mobileNo);
	              						   applicantCombo.setReadOnly(true);
	              						   var entryByNameItem = sgForm.down("#entryByNameItemId");
	              						   var entryByItem = sgForm.down("#entryById");

	              						   if(submitPortal == 6){
	              							 entryByNameItem.setVisible(true);
	        	                			 entryByNameItem.setReadOnly(true);
	        	                			 entryByItem.setVisible(false);
	        	                			 entryByItem.allowBlank = true; // uncomment for Bug: V2D-41415
	              						   }else{
		              						   entryByNameItem.setVisible(false);
		              						   entryByItem.setVisible(true);
		              						  // entryByItem.allowBlank = false;
	              						   }
	              						   
	              					   }

	              					   applicantStore.getProxy().extraParams = {
	              						   codeOrName: applicationCode
	              					   }; 

	              					   appointeeEmailField.resetOriginalValue();
	              					   mobileNoField.resetOriginalValue();
	              					   applicantStore.load({
	              						   callback:function(record){
	              							   for(var i in record){
	              								   if(record[i].data.id == applicationId){
	              									   applicantCombo.setValue(record[i].data.id);
	              									   entryByNameItem.setValue(record[i].data.printName);
	              									   applicantCombo.resetOriginalValue();
	              									   entryByNameItem.resetOriginalValue()
	              									   break;
	              								   }
	              							   }    	    					
	              						   }

	              					   });
	              					   
	              					   cellCountryCodeStore.load({
	              						   callback:function(record){
	              							   for(var i in record){
	              								   if(record[i].data.isdCode == mobileCode){
	              									   cellCountryCodeField.setValue(record[i].data.isdCode);
	              									   cellCountryCodeField.resetOriginalValue();
	              									   break;
	              								   }
	              							   }    	    					
	              						   }

	              					   }); 
	              					   
	              					 var newMandatoryFields = ['applicantNameId'];
	                                 	
                                     Ext.Ajax.request({
             	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
             	                		method: 'GET',
             	                		async: false,
             	                		params: {
             	                			academyLocationId:me.getCurrentAcademyLocation(),
             	                			languageCode:'en'
             	                		},
             	                		success: function(response) {
             	                			var json = JSON.parse(response.responseText);
             	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
             	                			fieldInfo.set("formFieldsInfo", json);
             	                			var academyLocationId = sgForm.down("#academyLocationId");
            	                			var programId = sgForm.down("#programId");
            	                			var batchId = sgForm.down("#batchId");
            	                			var seatTypeId = sgForm.down("#seatTypeId");
             	                			if( !isNullOrEmpty(json) ){
             	                				if( !isNullOrEmpty(json.sgappointmentform) ){
             	                					var sgappointmentformDFRConfig = json.sgappointmentform;
             	                					for( i in sgappointmentformDFRConfig){
             	                						var fieldConfig = sgappointmentformDFRConfig[i];
             	                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
             	                							if( fieldConfig.isVisible ){
             	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
             	                								currentField.setVisible(true);
             	                							}else{
             	                								var currentField = sgForm.down("#"+fieldConfig.formFieldId);
             	                								currentField.setVisible(false);
             	                							}
             	                						}
             	                					}
             	                				}else{
            	                					academyLocationId.setVisible(false);
                                                	academyLocationId.reset();
                                                	programId.setVisible(false);
                                                	programId.reset();
                                                	batchId.setVisible(false);
                                                	batchId.reset();
                                                	seatTypeId.setVisible(false);
                                                	seatTypeId.reset();
            	                				}
             	                			}
             	                		}
             	                	});
	              					   
	              				   };
	              			   }
	              		   }
	              	   })
	                 },

	                 editAppointmentApplicantDetailRecord: function() {
	                	 var $this = this;
	                	 var grid = $this.getContentPanelActiveTab().down('sgapplicantappointmentgrid');
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var record = grid.getSelectionModel().getSelection()[0];
	                		 var submitPortalRecord = record.data.submitPortalId;
	                		 this.addSGAppointmentApplicantDetailRecord('EDIT',submitPortalRecord);
	                		 var sgForm = this.getSgappointmentform();
	                		 var portalId = $this.getCurrentLoggedPortalId();
	                		 var dataModel = new Academia.model.sgappointment.sgappointment.SGAppointmentModel(record.data);
	                		 sgForm.loadRecord(dataModel);

	                		 sgForm.down("#visitTimeId").setValue(timeRender(record.data.visitTime));
	                		 sgForm.down("#outTimeId").setValue(timeRender(record.data.expectedOutTime));
	                		 sgForm.down("#bookingDateId").setValue(dateRender(record.data.bookingDate));
	                		 sgForm.down("#appointmentId").setValue(dateRender(record.data.appointmentDate));
	                		 sgForm.down("#bookingId").setReadOnly(true);

	                		 var isAppointeeItemId =  sgForm.down("#isAppointeeItemId");
	                		 isAppointeeItemId.setValue({isAppointee:record.data.isAppointeeAppointment});

	                		 if(!isNullOrEmpty(submitPortalRecord)){
                				 sgForm.down("#submitPortalId").setValue(submitPortalRecord);
                			 }else{
                				 sgForm.down("#submitPortalId").setValue(1);
                			 }
	                		var academyLocationId=sgForm.down("#academyLocationId");
	                 		var programId = sgForm.down("#programId");
	                 		var batchId = sgForm.down("#batchId");
	                 		var seatTypeId = sgForm.down("#seatTypeId");
	             			var applicationId = null;
						    var items = $this.getContentPanel().items.items;

							    for (var i = 0; i < items.length; i++) {
									  var item = items[i];
										 if (item.xtype === 'applicantprofile') {
											 applicationId = item.getApplicationId();
											 break; // stop once found
										 }
	             				  }  
							 academyLocationId.getStore().getProxy().extraParams = {
								 enquiryStudentDetailId: null,
								 applicationId: applicationId
	             			}
	             			
							 if (record.data.academyLocation != null) {
								 programId.setDisabled(false);
								 academyLocationId.store.load({
									 callback: function(recordss, operation, success) {
										 if (success) {
											 var matchedId = null;
											 for (i in recordss) {
												 if (recordss[i].data.id == record.data.academyLocation.id) {
													 matchedId = recordss[i].data.id;
													 break;
												 }
											 }
											 if (matchedId != null) {
												 academyLocationId.setValue(recordss[i].data.id);
											 } else {
												 academyLocationId.setValue(null);
												 programId.setDisabled(true);
												 programId.allowBlank = true;
												 batchId.setDisabled(true);
												 batchId.allowBlank = true;
												 seatTypeId.setDisabled(true);
												 seatTypeId.allowBlank = true;
											 }
										 }
									 }
								 });

								 programId.getStore().getProxy().extraParams = {
									 academyLocationId: record.data.academyLocation.id,
									 enquiryStudentDetailId: null,
									 applicationId: applicationId
								 }
								 if (record.data.program != null) {
									 batchId.setDisabled(false);
									 programId.getStore().load({
										 callback: function(recordss, operation, success) {
											 if (success) {
												 var matchedId = null;
												 for (i in recordss) {
													 if (recordss[i].data.id == record.data.program.id) {
														 matchedId = recordss[i].data.id;
														 break;
													 }
												 }
												 if (matchedId != null) {
													 programId.setValue(recordss[i].data.id);
												 } else {
													 programId.setValue(null);
													 batchId.setDisabled(true);
													 batchId.allowBlank = true;
													 seatTypeId.setDisabled(true);
													 seatTypeId.allowBlank = true;
												 }
											 }
										 }
									 });

									 batchId.getStore().getProxy().extraParams = {
										 programId: record.data.program.id,
										 enquiryStudentDetailId: null,
										 applicationId: applicationId
									 }
									 if (record.data.batch != null) {
										 seatTypeId.setDisabled(false);
										 batchId.getStore().load({
											 callback: function(recordss, operation, success) {
												 if (success) {
													 var matchedId = null;
													 for (i in recordss) {
														 if (recordss[i].data.id == record.data.batch.id) {
															 matchedId = recordss[i].data.id;
															 break;
														 }
													 }
													 if (matchedId != null) {
														 batchId.setValue(recordss[i].data.id);
													 } else {
														 batchId.setValue(null);
														 seatTypeId.setDisabled(true);
														 seatTypeId.allowBlank = true;
													 }
												 }
											 }
										 });
										 seatTypeId.getStore().getProxy().extraParams = {
											 batchId: record.data.batch.id,
											 enquiryStudentDetailId: null,
											 applicationId: applicationId
										 }
										 if (record.data.progBatchSeatConfig != null) {
											 seatTypeId.getStore().load({
												 callback: function(recordss, operation, success) {
													 if (success) {
														 var matchedId = null;
														 for (i in recordss) {
															 if (recordss[i].data.id == record.data.progBatchSeatConfig.id) {
																 matchedId = recordss[i].data.id;
																 break;
															 }
														 }
														 if (matchedId != null) {
															 seatTypeId.setValue(recordss[i].data.id);
														 } else {
															 seatTypeId.setValue(null);
														 }
													 }
												 }
											 });
										 }
									 } else {
										 seatTypeId.setDisabled(true);
										 seatTypeId.allowBlank = true;
									 }
								 } else {
									 batchId.setDisabled(true);
									 batchId.allowBlank = true;
									 seatTypeId.setDisabled(true);
									 seatTypeId.allowBlank = true;
								 }
							 } else {
								 programId.setDisabled(true);
								 programId.allowBlank = true;
								 batchId.setDisabled(true);
								 batchId.allowBlank = true;
								 seatTypeId.setDisabled(true);
								 seatTypeId.allowBlank = true;
							 }
	                		 var visitorCategory = sgForm.down("#visitorCategoryID");
	                		 if (record.data.visitorCategory != null) {
	                			 visitorCategory.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 visitorCategory.setValue(record.data.visitorCategory.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 var entryByField = sgForm.down("#entryById");
	                		 var entryByNameItem = sgForm.down("#entryByNameItemId");
	                		 if(portalId == 6){
	                			 entryByField.setReadOnly(true);
	                		 }else{
	                			 entryByField.setReadOnly(false); 
	                		 }
	                		 if(record.data.submitPortalId == 6){
	                			 entryByNameItem.setVisible(true);
	                			 entryByNameItem.setReadOnly(true);
	                			 entryByField.setVisible(false);
	                			// entryByField.allowBlank = true;
	                			 entryByNameItem.setValue(record.data.appointeeName);
	                			 entryByNameItem.resetOriginalValue();
	                		 }else{
	                			 entryByNameItem.setVisible(false);
	                			 // entryByNameItem.setReadOnly(false);
	                			 entryByField.setVisible(true);
	                			// entryByField.allowBlank = false;

	                			 if (record.data.entryBy != null) {
	                				 entryByField.store.getProxy().extraParam = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 }
	                				 entryByField.store.load({
	                					 callback: function(records, operation, success) {
	                						 if (success) {
	                							 entryByField.setValue(record.data.entryBy.id);
	                						 }
	                					 }
	                				 });
	                			 }
	                		 }
	                		 var personToMeetId = sgForm.down("#personToMeetId");
	                		 personToMeetId.setFieldStyle('color:black');
	                		 if (record.data.personToMeet != null) {
	                			 personToMeetId.store.getProxy().extraParam = {
	                				 academyLocationIds: this.getCurrentAcademyLocation()
	                			 }
	                			 personToMeetId.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 for(i in records){
	 	        								if(records[i].data.valueCode == record.data.personToMeet){
	 	        								personToMeetId.setValue(records[i].data.id);
	 	        							}
	 	        						}
	                					//	 personToMeetId.setRawValue(record.data.personToMeet);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 var appointeeNameField = sgForm.getForm().findField('appointeeName');

	                		 var studentNameField = sgForm.down("#leadId");
	                		 var parentGuardian = sgForm.down("#appointeeNameParentId");
	                		 var leadNameField =  sgForm.down("#leadId");
	                		 var empNameField =  sgForm.down("#facAppointmentId");
	                		 if (record.data.visitorCategory.id == 1) {
	                			 parentGuardian.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 parentGuardian.setValue(record.data.person.id);
	                					 }
	                				 }
	                			 });
	                			 parentGuardian.setVisible(true);
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;

	                			 studentNameField.setVisible(false);
	                			 studentNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(false);
	                		 } else if (record.data.visitorCategory.id == 2) {
	                			 studentNameField.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 studentNameField.setValue(record.data.enquiry.id);
	                					 }
	                				 }
	                			 });
	                			 studentNameField.setVisible(false);
	                			 studentNameField.setReadOnly(true);
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(true);
	                			 leadNameField.allowBlank = true;

	                			 visitorCategory.setReadOnly(true);
	                		 } else if(record.data.visitorCategory.id == 3){
	                			 studentNameField.store.load({
	                				 callback : function(records,operation,success) {
	                					 if (success) {
	                						 studentNameField.setValue(record.data.student.id);
	                					 }
	                				 }
	                			 });
	                			 studentNameField.setVisible(true);
	                			 studentNameField.allowBlank = false;
	                			 studentNameField.setReadOnly(true);
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(true);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 visitorCategory.setReadOnly(true);
	                			 empNameField.setVisible(false);
	                			 empNameField.setReadOnly(true);
	                			 empNameField.allowBlank = true;
	                		 }else if(record.data.visitorCategory.id == 4){
	                			 empNameField.getStore().load({
	                				 callback : function(records,operation,success) {
	                					 if (success) {
	                						 empNameField.setValue(record.data.staff.id);
	                					 }
	                				 }
	                			 });
	                			 empNameField.setVisible(true);
	                			 empNameField.setReadOnly(true);
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(false);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 studentNameField.setVisible(false);
	                			 studentNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(true);
	                		 }else {
	                			 parentGuardian.allowBlank = true;
	                			 studentNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(false);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.allowBlank = true;
	                		 }
	                		 var mobileField = sgForm.down("#mobileNo");
	                		 var countryCodeField = sgForm.down("#cellCountryCode");
	                		 var str = record.data.appointeeContactNo;
	                		 var spiltMobileNo;
	                		 if (str != null) {
	                			 spiltMobileNo = str.split("-");
	                		 }
	                		 if (record.data.appointeeContactNo != null) {
	                			 if (spiltMobileNo.length == 2) {
	                				 //countryCodeField.setValue(spiltMobileNo[0]);
	                				 countryCodeField.getStore().load({
	                   					 callback: function(records, operation, success) {
	                   						  if (success) {
	                   							  for(i in records){
	               									  if(records[i].data.value == spiltMobileNo[0]){
	               										countryCodeField.setValue(records[i].data.isdCode);  									  
	                   								  }
	                   							  }
	                   						  }
	                   					  }
	                   				  });
	                				 mobileField.setValue(spiltMobileNo[1]);
	                			 }

	                		 }
	                		 /*added for visit status and reason to visit*/
	                		 var visitStatusCombo = sgForm.down("#viewStatusID");
	                		 var reasonForVisitCombo = sgForm.down("#reasonForVisitID");
	                		 var visitCatId = record.data.visitorCategory.id;
          				    var reasonForVisitStore=reasonForVisitCombo.getStore();
          				    reasonForVisitStore.getProxy().extraParams = {
                   			  id : visitCatId,
                   		   };
	                		 if (record.data.sgReasonForVisit != null) {
	                			 var userGroupName = record.data.sgReasonForVisit.code;
	             	        	this.enableOrDisableAdditionalReasonApplicant(userGroupName);
	                			 reasonForVisitCombo.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 reasonForVisitCombo.setValue(record.data.sgReasonForVisit.id);
	                					 }
	                				 }
	                			 });
	                		 }

	                		 if (record.data.sgVisitStatus != null) {
	                			 visitStatusCombo.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 visitStatusCombo.setValue(record.data.sgVisitStatus.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 sgForm.down('#resetBtnForm').setVisible(false);
	               		   
	                		 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                		 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                		 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                		 if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Completed"){
	                			 sgForm.down('#submitBtn').setVisible(false);
	                			 //var viewStatusID = sgForm.down('#viewStatusID');
	                			 sgForm = sgForm.getForm();
	                			 //viewStatusID.setReadOnly(true);
	                			 toggleReadOnlyFormItems(sgForm, true);
	                		 }
	                		 else if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Rescheduled"){
	                			 var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                			 var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                			 if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment){
	                				 dateTimeRescheduleAppointmentItemId.setVisible(true);
	                				 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                				 rescheduleAppointmentDateId.setValue(dateRender(record.data.rescheduleDate));
	                				 if(!isNullOrEmpty(record.data.rescheduleTime)){
	                					 sgForm.down("#rescheduleAppointmentTimeId").setValue(timeRender(record.data.rescheduleTime));
	                				 }
	                			 }
	                			 else{
	                				 dateTimeRescheduleAppointmentItemId.setVisible(false);
	                				 rescheduleAppointmentDateId.reset();
	                				 rescheduleAppointmentTimeId.reset();
	                			 }
	                			 rescheduleAppointmentFld.setVisible(true);
	                		 }
	                		 else{
	                			 rescheduleAppointmentDateId.reset();
	                			 rescheduleAppointmentTimeId.reset();
	                		 }
	                		 
	                		 var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
	                		// var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                		 if (record.data.enqIntermediateType != null) {
	                			 enqIntermediateStage.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 enqIntermediateStage.setValue(record.data.enqIntermediateType.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },
	                 viewSGAppointmentApplicantDetailRecord: function() {
	                	 this.editAppointmentApplicantDetailRecord();
	                	 var sgForm = this.getSgappointmentform();
	                	 sgForm.down('#submitBtn').setVisible(false);
	                	 sgForm.down('#resetBtnForm').setVisible(false);
	                	 sgForm = sgForm.getForm();
	                	 toggleReadOnlyFormItems(sgForm, true);
	                 },
	                 deleteSGAppointmentDetailRecord: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgapplicantappointmentgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 var records = grid.getSelectionModel().getSelection();
	                				 var id = records[0].get("id");
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.SG_APPOINTMENT_DELETE + '?id=' + id,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {
	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
	                						 $this.resetPageSetting(grid.getStore());
	                						 grid.getStore().reload();
	                					 }
	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },
	                 saveSGAppointmentApplicantRecord: function() {
	                	 // Create required json to Save
	                	 var $this = this;
	                	 var sgForm = $this.getSgappointmentform();
	                	 var academyLocationId = sgForm.down("#academyLocationId");
	              	     var programId = sgForm.down("#programId");
	              	     var batchId = sgForm.down("#batchId");
	              	     var seatTypeId = sgForm.down("#seatTypeId");
	              	     if(!academyLocationId.isVisible()){
	              		     academyLocationId.reset();
	              	     }
	              	     if(!programId.isVisible()){
	              		     programId.reset();
	              	     }
	              	     if(!batchId.isVisible()){
	              		     batchId.reset();
	              	     }
	              	     if(!seatTypeId.isVisible()){
	              		     seatTypeId.reset();
	              	     }
	                	 var portalId = $this.getCurrentLoggedPortalId();
	                	 var parentStore = sgForm.down("#appointeeNameParentId").getStore();
	                	 var sgFormValues = sgForm.getValues();
	                	 var submitPortalData = sgForm.down("#submitPortalId").getValue();
	                	 var submitUrl, isUpdate = false;
	                	 var contentPanel = $this.getContentPanel();
	                	 var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	                	 var grid = $this.getSgapplicantappointmentgrid();
	                	 var getcontroller = $this.getController('menu.CoreERPNavigationController');
	                	 var getTab = getcontroller.getTab(tabName);
	                	 if (isNullOrEmpty(sgFormValues.id)) {
	                		 submitUrl = SERVERURL.SG_APPOINTMENT_SAVE;
	                		 isUpdate = false;
	                	 } else {
	                		 submitUrl = SERVERURL.SG_APPOINTMENT_UPDATE;
	                		 isUpdate = true;
	                	 }
	                	 var visitorCategory = {
	                			 id: sgFormValues.visitorCategory
	                	 };
	                	
	                	 var appointeeName;
	                	 var personToMeetId=sgForm.getForm().findField('personToMeet').getValue();
	                	 if (sgFormValues.visitorCategory == 1) {
	                		 var str = sgForm.down('#appointeeNameParentId').getRawValue();
	                		 var appointee = str.split("-");
	                		 appointeeName = appointee[0];
	                	 } else if (sgFormValues.visitorCategory == 2) {
	                		 var str = sgForm.down('#leadId').getRawValue();
	                		 appointeeName = str;
	                	 } else if (sgFormValues.visitorCategory == 3) {
	                		 var str = sgForm.down('#studentItemId').getRawValue();
	                		 appointeeName = str;
	                	 }else if(sgFormValues.visitorCategory==4){                        		   
	                		 var str=sgForm.down('#facAppointmentId').getRawValue();
	                		 appointeeName=str;
	                	 }else if(sgFormValues.visitorCategory==5){                        		   
	                		 var str=sgForm.down('#applicantNameId').getRawValue();
	                		 appointeeName=str;
	                	 } else {
	                		 appointeeName = sgFormValues.appointeeName;
	                	 }
	                	 var personId = {
	                			 id: sgFormValues.appointeeNameParent
	                	 };
	                	 var enquiryId = {
	                			 id: sgFormValues.leadId
	                	 };
	                	 var visitStatusId = {
	                			 id: sgFormValues.viewStatusID
	                	 };
	                	 var reasonForVisitId = {
	                			 id: sgFormValues.reasonForVisitID
	                	 };
	                	 var student = {
	                			 id: sgFormValues.studentId
	                	 };
	                	 var staffId={
	                			 id:sgFormValues.facAppointmentId	   
	                	 };
	                	 var application={
	                			 id:sgFormValues.applicantNameId	   
	                	 };
	                	 var personToMeetId={
	              			   id:personToMeetId  
	              	   	 };
	                	 var academyLocationId={
	              			   id:sgFormValues.academyLocation	  
	              	     };
	               	     var programId={
	              			   id:sgFormValues.program	   
	              	     };
	               	     var batchId={
	              			   id:sgFormValues.batch   
	              	     };
	               	     var seatTypeId={
	              			   id:sgFormValues.seatType	   
	              	     };
	                	 var appointmentFormData = new Academia.model.sgappointment.sgappointment.SGAppointmentModel();
	                	 var chkRescheduleAppointment = sgForm.getForm().findField('isRescheduleAppointment');
	                	 if(chkRescheduleAppointment.getValue()){
	                		 appointmentFormData.set("isRescheduleAppointment",chkRescheduleAppointment.getValue());
	                		 appointmentFormData.set("rescheduleDate",sgFormValues.rescheduleDate);
	                		 if(!isNullOrEmpty(sgFormValues.rescheduleTime)){
	                			 appointmentFormData.set("rescheduleTime",sgFormValues.rescheduleTime); 
	                		 }else{
	                			 delete appointmentFormData.data.rescheduleTime;
	                		 }
	                	 }
	                	 appointmentFormData.set("id", sgFormValues.id);
	                	 appointmentFormData.set("visitorCategory", visitorCategory);
	                	 appointmentFormData.set("bookingId", sgFormValues.bookingId);
	                	 appointmentFormData.set("appointeeName", appointeeName);
	                	 appointmentFormData.set("personToMeetId",personToMeetId);
	                	 appointmentFormData.set("isAppointeeAppointment",sgFormValues.isAppointee);
	                	 appointmentFormData.set("program",programId);
	               	     appointmentFormData.set("batch",batchId);
	               	     appointmentFormData.set("progBatchSeatConfig",seatTypeId);
	               	     appointmentFormData.set("academyLocation",academyLocationId);
	                	 
	                	 var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                	 if( !isNullOrEmpty(enqIntermediateStage.getValue()) ){
	                		 var enqIntermediateStage={
	  	              			   id:enqIntermediateStage.getValue()  
	  	              	   	 };
	                		 appointmentFormData.set("enqIntermediateType",enqIntermediateStage);
	                	 }
	                	 delete appointmentFormData.data.enqIntermediateStage;
	                	 if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
	                		 delete appointmentFormData.data.enqIntermediateType;
	                	 }
	                	 var countryCode = sgFormValues.mobileCountryCode;
	                	 var mobileNo = sgFormValues.appointeeContactNo;
	                	 var mobileNoWithCode;
	                	 if (isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo)) {
	                		 mobileNoWithCode = null;
	                	 } else {
	                		 mobileNoWithCode = countryCode + '-' + mobileNo;
	                	 }
	                	 var entryBy;
	                	 if(submitPortalData == 1){
	                		 if(isNullOrEmpty(sgFormValues.entryBy)){
	                			 var userId=this.getCurrentlyLoggedInUser();
	                			 entryBy = {
	                					 id: userId.id
	                			 };
	                		 } else{
	                			 entryBy = {
	                					 id: sgFormValues.entryBy
	                			 };
	                		 }
	                	 }
	                	 else{
	                		 entryBy = {
	                				 id: this.getCurrentlyLoggedInUser().id
	                		 }
	                	 }
	                	 appointmentFormData.set("appointeeContactNo", mobileNoWithCode);
	                	 appointmentFormData.set("bookingDate", sgFormValues.bookingDate);
	                	 appointmentFormData.set("appointmentDate", sgFormValues.appointmentDate);
	                	 appointmentFormData.set("appointeeEmailId", sgFormValues.appointeeEmailId);
	                	 var persontoMeetValue = sgForm.getForm().findField('personToMeet').getRawValue();
	                	 appointmentFormData.set("personToMeet", persontoMeetValue);
	                	 appointmentFormData.set("visitTime", sgFormValues.visitTime);
	                	 appointmentFormData.set("expectedOutTime", sgFormValues.expectedOutTime);
	                	 appointmentFormData.set("reasonToVisit", sgFormValues.reasonToVisit);
	                	 appointmentFormData.set("entryBy", entryBy);
	                	 appointmentFormData.set("submitPortalId", submitPortalData);
	                	 appointmentFormData.set("additionalReasonToVisit",sgFormValues.additionalReasonToVisit);
	                	 
	                	 
	                	 if (!isNullOrEmpty(visitStatusId.id)) {
	                		 appointmentFormData.set("sgVisitStatus", visitStatusId);
	                	 } else {
	                		 appointmentFormData.set("sgVisitStatus", null);
	                	 }
	                	 if (!isNullOrEmpty(reasonForVisitId.id)) {
	                		 appointmentFormData.set("sgReasonForVisit", reasonForVisitId);
	                	 } else {
	                		 appointmentFormData.set("sgReasonForVisit", null);
	                	 }
	                	 appointmentFormData.set("customData",sgFormValues.customData);
	                	 if (sgFormValues.visitorCategory == 1) { //base category
	                		 appointmentFormData.set("person", personId);
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 } else if (sgFormValues.visitorCategory == 2) {
	                		 appointmentFormData.set("enquiry", enquiryId);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 } else if (sgFormValues.visitorCategory == 3) {
	                		 appointmentFormData.set("student", student);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 }else if(sgFormValues.visitorCategory==4){
	                		 appointmentFormData.set("staff",staffId);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.application;
	                	 }else if(sgFormValues.visitorCategory==5){
	                		 appointmentFormData.set("application",application);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                	 } else {
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 }
	                	 if(Ext.isDefined(appointmentFormData.data.entryByName)){
	                		 delete appointmentFormData.data.entryByName;
	                	 }
	                	 if(Ext.isDefined(appointmentFormData.data.personToMeetId)){
	                		 delete appointmentFormData.data.personToMeetId;
	                	 }
	                	 if (isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
	                		 delete appointmentFormData.data.enqIntermediateType;
	                	 }
	                	 if (isNullOrEmpty(appointmentFormData.data.enqIntermediateStage)) {
	                		 delete appointmentFormData.data.enqIntermediateStage;
	                	 }
	                	 if(isNullOrEmpty(appointmentFormData.data.academyLocation.id)){
	              		   delete appointmentFormData.data.academyLocation;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.program.id)){
	              		   delete appointmentFormData.data.program;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.batch.id)){
	              		   delete appointmentFormData.data.batch;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.progBatchSeatConfig.id)){
	              		   delete appointmentFormData.data.progBatchSeatConfig;
	              	     }
	                	 var formData = Ext.encode(appointmentFormData.data);
	                	 
	                	 Ext.getBody().mask();
	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: submitUrl,
	                		 jsonData: formData,
	                		 method: 'POST',
	                		 success: function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 sgForm.getForm().reset();
	                			 if (isUpdate) {
	                				 showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
	                				 if (getTab != null) {
	                					 contentPanel.remove(getTab, true);
	                				 }
	                				 if (grid != undefined) {
	                					 grid.getStore().reload();
	                					 grid.getSelectionModel().deselectAll();
	                				 } else if (sgDetailGrid != undefined) {
	                					 sgDetailGrid.getStore().load();
	                					 sgDetailGrid.getSelectionModel().deselectAll();
	                				 }
	                			 } else {
	                				 showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
	                				 if (getTab != null) {
	                					 contentPanel.remove(getTab, true);
	                				 }
	                				 if (grid != undefined) {
	                					 grid.getStore().loadPage(1, {
											 params: {
												 page: grid.getStore().currentPage,
												 limit: grid.getStore().pageSize,
												 start: ((grid.getStore().currentPage - 1) * (grid.getStore().pageSize)),
												 application: appointmentFormData.data.application.id
											 }, callback: function(record, operation, success) {
												 if (success) {
													 delete grid.getStore().getProxy().extraParams.page;
													 delete grid.getStore().getProxy().extraParams.limit;
													 delete grid.getStore().getProxy().extraParams.start;
													 delete grid.getStore().getProxy().extraParams.academyLocationIds;
												 }
											 }
										 });
	                					 //grid.getStore().load();  
	                				 }
	                				 else if (sgDetailGrid != undefined) {
	                					 //sgDetailGrid.getStore().load();
	                					 sgDetailGrid.getStore().loadPage(1, {
											 params: {
												 page: sgDetailGrid.getStore().currentPage,
												 limit: sgDetailGrid.getStore().pageSize,
												 start: ((sgDetailGrid.getStore().currentPage - 1) * (sgDetailGrid.getStore().pageSize)),
												 application: appointmentFormData.data.application.id
											 }, callback: function(record, operation, success) {
												 if (success) {
													 delete sgDetailGrid.getStore().getProxy().extraParams.page;
													 delete sgDetailGrid.getStore().getProxy().extraParams.limit;
													 delete sgDetailGrid.getStore().getProxy().extraParams.start;
													 delete sgDetailGrid.getStore().getProxy().extraParams.academyLocationIds;
												 }
											 }
										 });
	                					   
	                					 sgDetailGrid.getSelectionModel().deselectAll();
	                				 }
	                			 }
	                		 }
	                	 });

	                 },

	                 sendCalendarEventsRequest: function(personId, calenderItemId, submitURL) {
	                	 var this$ = this;
	                	 var sgForm = this$.getSgappointmentform();
	                	 if (!isNullOrEmpty(sgForm) && Ext.isDefined(sgForm)) {
	                		 var id = sgForm.down("#id").getValue();
		                	 var personToMeetId = null;
		                	 var appointmentDateId = sgForm.down("#appointmentId").getValue();
		                	 if (isNullOrEmpty(id)) {
		                		 personToMeetId = sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
		                	 } else {
		                		 var facultyName = sgForm.down("#personToMeetId").getValue();
		                		 var records = sgForm.down("#personToMeetId").getStore().data.items;
		                		 for (var i in sgForm.down("#personToMeetId").getStore().data.items) {
		                			 if (records[i].data.value == facultyName) {
		                				 personToMeetId = records[i].data.id;
		                			 }
		                		 }
		                	 }
		                	 var personProfile = this.getContentPanelActiveTab();
		                	 var calendar = personProfile.down(calenderItemId);
		                	 var params = new Object();
		                	 calendar.eventStore.getProxy().actionMethods.read = 'GET';
		                	 params.facultyId = personToMeetId;
		                	 calendar.eventStore.removeAll();
		                	 calendar.eventStore.getProxy().url = submitURL;
		                	 calendar.eventStore.getProxy().extraParams = params;
		                	 calendar.eventStore.load();
	                	 }
	                	
	                 },
	                 openViewCalendarWin: function() {
	                	 var $this = this;
	                	 var contentpanel = this.getContentPanel();
	                	 var scheduledetails = Ext.widget('scheduledetails');
	                	 var tabName = getServiceRequestTranslation('VIEW_CALENDAR');
	                	 var personToMeetId = null;

	                	 /**
	                	  * This is to remove tab from content panel and open same tab again
	                	  */
	                	 var getcontroller = this.getController('menu.CoreERPNavigationController');
	                	 var getTab = getcontroller.getTab(tabName);
	                	 if (getTab != null) {
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 openTab(contentpanel, tabName, scheduledetails, contentpanel.activeTab.menuColorCls);
	                	 var sgForm = $this.getSgappointmentform();
	                	 var id = sgForm.down("#id").getValue();

	                	 var appointmentDateId = sgForm.down("#appointmentId").getValue();
	                	 if (isNullOrEmpty(id)) {
	                		 personToMeetId = sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
	                	 } else {
	                		 var facultyName = sgForm.down("#personToMeetId").getValue();
	                		 var records = sgForm.down("#personToMeetId").getStore().data.items;
	                		 for (var i in sgForm.down("#personToMeetId").getStore().data.items) {
	                			 if (records[i].data.value == facultyName) {
	                				 personToMeetId = records[i].data.id;
	                			 }
	                		 }
	                	 }

	                	 var personProfile = this.getContentPanelActiveTab();
	                	 var calendar = personProfile.down('#personViewCalendar');
	                	 var params = new Object();
	                	 calendar.eventStore.getProxy().actionMethods.read = 'GET';
	                	 params.facultyId = personToMeetId;
	                	 calendar.eventStore.removeAll();
	                	 calendar.eventStore.getProxy().url = SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;
	                	 calendar.eventStore.getProxy().extraParams = params;
	                	 calendar.eventStore.load();
	                 },
	                 loadSGAppointmentGrid: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgappointmentgrid();
	                	 var sgFilter = this.getSgappointmentfilter();
	                	 var sgFilterValues = sgFilter.getValues();
	                	 var personMeetRawValue = sgFilter.down('#personToMeetFilterItemId').getRawValue();
	                	 var store = grid.getStore();
	                	 store.getProxy().extraParams = {
	                		 bookingID: sgFilterValues.bookingID,
	                		 appointeeName: sgFilterValues.appointeeName,
	                		 personTomeet: personMeetRawValue,
	                		 appointmentFromDate: sgFilterValues.appointmentFromDate,
	                		 appointmentToDate: sgFilterValues.appointmentToDate,
	                		 academyLocationIds: this.getCurrentAcademyLocation()
	                	 };
	                	 $this.resetPageSetting(store);
	                	 store.load();

	                 },
	                 resetSGAppointment: function(form) {
	                	// filter.reset();
	                	 var bookingId = form.down('#bookingId');
	                	 var vistrCategory = form.down('#visitorCategoryID');


	                	 var mobileField = form.down("#mobileNo");
	                	 var countryCodeField=form.down("#cellCountryCode");
	                	 var appointeeEmailItemId=form.down("#appointeeEmailItemId");
	                	 var submitPortalId=form.down("#submitPortalId");
	                	 submitPortalId.resetOriginalValue();

	                	 if(vistrCategory.getValue() == 5){
	                		 mobileField.resetOriginalValue();
	                		 appointeeEmailItemId.resetOriginalValue();
	                		 countryCodeField.resetOriginalValue();
	                	 }
	                	 form.getForm().reset();
	                 },
	                 setExpectedOutTimeForApplicant : function(obj,record){
	                	 var sgForm=this.getSgappointmentform();
	                	 var visitTimeValue='';
	                	 if(obj.itemId == 'visitTimeId'){
	                		 var visitTimeValue=record;
	                		 var id=sgForm.down("#reasonForVisitID").getValue();
	                	 }else{
	                		 visitTimeValue=sgForm.down("#visitTimeId").getValue();
	                		 var id = record[0].get("id");
	                	 }
	                	 var visitTimeIdfield=sgForm.getForm().findField('visitTime');
	                	 var expectedOutTimefield=sgForm.getForm().findField('expectedOutTime');
	                	 expectedOutTimefield.reset();
	                	 if(!isNullOrEmpty(id)){
	                		 var submitUrl = SERVERURL.PATH_SG_REASON_FOR_VISIT_TIME;
	                		 Ext.Ajax.request({
	                			 type : 'rest',
	                			 url : submitUrl,
	                			 params: {
	                				 id: id,
	                			 },
	                			 method : 'GET',
	                			 async: false,
	                			 success : function(data, action) {
	                				 var data=Ext.decode(data.responseText);
	                				 if(data.length>0){
	                					 if(!isNullOrEmpty(visitTimeValue)){
	                						 if(data[0].code!="0" && data[0].code!="00" || data[0].value!="0" && data[0].value!="00" ){
	                							 var expTimeDuration='';
	                							 var expTime =  parseInt(data[0].code)+(parseInt(data[0].value)/60);
	                							 expTimeDuration = visitTimeValue.getTime() + (expTime*60*60*1000);
	                							 var expTimeDurationRender = timeRender(expTimeDuration);
	                							 expectedOutTimefield.setValue(expTimeDurationRender);
	                						 }else{
	                							 expectedOutTimefield.reset();
	                							 visitTimeIdfield.setMaxValue(null);
	                							 visitTimeIdfield.setMinValue(null);
	                						 }
	                					 }
	                				 }
	                			 }
	                		 });   
	                	 }
	                 },
	                 enableOrDisableAdditionalReasonApplicant:function(userGroupName) {
	                    	
	               	   var form = this.getActiveTabfromContentPanel().down('sgappointmentform');
	               	   
	                  	if(userGroupName == 'Other'){
	              	    	
	              	    	form.down('#additionalReasonToVisitItemId').setDisabled(false);
	              	    	form.down('#additionalReasonToVisitItemId').allowBlank = false;
	              	    } 
	                  	else{ 
	                  	form.down('#additionalReasonToVisitItemId').setDisabled(true);
	          	    	form.down('#additionalReasonToVisitItemId').allowBlank = true;
	          	    	form.down('#additionalReasonToVisitItemId').reset();
	                  	}
	                  		
	                  	
	                  	var valid = form.isValid();
	                  	if(!valid) {
	                  		form.down('#submitBtn').setDisabled(true);
	                  	}
	                  },
	                  loadDFRForManageAppointment: function(academyLocationId) {
	                      var $this = this;
	                      var form = $this.getSgappointmentform();
	                      var academyLocationId = form.down("#academyLocationId");
	              		  var programId = form.down("#programId");
	              		  var batchId = form.down("#batchId");
	              		  var seatTypeId = form.down("#seatTypeId");

	                      Ext.Ajax.request({
	                          type: 'rest',
	                          async: false,
	                          url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                          params: {
	                              screenName: 'sgappointmentform',
	                              academyLocationId: this.getCurrentAcademyLocation(),
	                              languageCode: 'en'
	                          },
	                          method: 'GET',
	                          success: function(res, action) {
	                              var response = Ext.decode(res.responseText);
	                              if (Object.keys(response).length > 0) {
	                                  var records = response.sgappointmentform;
	                                  for (i in records) {
	                                      var fieldConfig = records[i];
	                                      
	                                        if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'academyLocationId') {
	                                          if (fieldConfig.isMandatory) {
	                                          	academyLocationId.allowBlank = false;
	                                          }else{
	                                          	academyLocationId.allowBlank = true;
	                                          }
	                                          if (fieldConfig.isVisible) {
	                                          	academyLocationId.setVisible(true);
	                                          }else{
	                                          	academyLocationId.setVisible(false);
	                                          	academyLocationId.reset();
	                                          	programId.setVisible(false);
	                                          	programId.reset();
	                                          	batchId.setVisible(false);
	                                          	batchId.reset();
	                                          	seatTypeId.setVisible(false);
	                                          	seatTypeId.reset();
	                                          }
	                                         }
	                                         if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'programId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	programId.allowBlank = false;
	                                              }else{
	                                              	programId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	programId.setVisible(true);
	                                              }else{
	                                              	programId.setVisible(false);
	                                              	programId.reset();
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'batchId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	batchId.allowBlank = false;
	                                              }else{
	                                              	batchId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	batchId.setVisible(true);
	                                              }else{
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'seatTypeId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	seatTypeId.allowBlank = false;
	                                              }else{
	                                              	seatTypeId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	seatTypeId.setVisible(true);
	                                              }else{
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                       }
	                                  }
	                              }
	                          }
	                      });
	                  }

});