/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.report.StudentMedicalDetailsReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['student.report.StudentMedicalDetailsReportStore'],
	         views: ['student.medicalDetailsReport.StudentMedicalDetailsReportTabStructure',
	                 'student.medicalDetailsReport.StudentMedicalDetailsReportStructure','student.medicalDetailsReport.StudentMedicalDetailsReportGrid',
	                 'student.medicalDetailsReport.StudentMedicalDetailsReportFilter'],
	                 config : {
	                	 MEDICAL_DETAILS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MEDICAL_DETAILS_REPORT_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentmedicaldetailsreporttabstructure',
	                	 selector: 'studentmedicaldetailsreporttabstructure'
	                 },{
	                	 ref: 'studentmedicaldetailsreportfilter',
	                	 selector: 'studentmedicaldetailsreportfilter'
	                 },{
	                	 ref: 'studentmedicaldetailsreportgrid',
	                	 selector: 'studentmedicaldetailsreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 'studentmedicaldetailsreporttabstructure':{
	                			 render:function(studentmedicaldetailsreporttabstructure){
	                				 this.enableTabforstudentMedicalPanel(studentmedicaldetailsreporttabstructure);
	                			 },
	                			 afterrender:function(structure)
	                			 {
	                				 var grid=structure.down('studentmedicaldetailsreportgrid');
	                				 this.getGridHeaderFreeze(grid,structure,true);
	                				 var me = this;
	                				setTimeout(function(){
	                				    		me.addDataGridConfigButton(grid,me.getMEDICAL_DETAILS_REPORT_PERMISSIONS());
	                				    	},1500);
	                			 }
	                		 },
	                		 'studentmedicaldetailsreportfilter multiselectcombofield[itemId=multiselectAcademyId]':{
	     	        			afterrender:function(obj, record){
	     	        				var $this = this;
	     	        				var academyLocationId = this.getCurrentAcademyLocation();
	     	        				obj.getStore().load({
	     	        					callback: function(record){
	     	        						obj.select(academyLocationId);
	     	        					}
	     	        				});
	     	        			},
	     	        			change: function(obj){
	     	        				var academyIds = this.getSelectedAcademyIds();
	     	        				if (academyIds != null && academyIds != '') {
	     	        					this.loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL();
	     							}
	     	        			}

	     	        		},
	                		'studentmedicaldetailsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.medicalDetailsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentmedicaldetailsreportfilter combo#studentId': {
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentMedicalReport = $this.getStudentmedicaldetailsreportfilter();
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentMedicalReport.down('#programGroupCombo');
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentMedicalReport.down('#programId');
	        				                    			programCombo.setDisabled(false);
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};
	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {
	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentMedicalReport.down('#batchId');
	        				                    						batchCombo.setDisabled(false);
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId,
	        				                    							programId:data[0].programId
	        				                    						};
	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentMedicalReport.down('#periodId');
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        	        				                    							id:data[0].batchId
	        				                    									};
	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
	                		 'studentmedicaldetailsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.medicalDetailsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentmedicaldetailsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentmedicaldetailsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentmedicaldetailsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 var multiselectAcademyIdField = $this.getStudentmedicaldetailsreportfilter().down('#multiselectAcademyId');
	                		        	var academyIdsArray = multiselectAcademyIdField.getValue();
	                		        	var academyIds;
	                	            	if(typeof academyIdsArray[0]!="object"){
	                	            		var academyIds = academyIdsArray;
	                	            	}
	                	            	else {
	                	            		var academyIdsTempArray = [];
	                	            		Ext.each(academyIdsArray,function(currentAcademyId){
	                	            			academyIdsTempArray.push(currentAcademyId.data.id);
	                	            		});
	                	            		var academyIds = academyIdsTempArray.join(',');
	                	            	}
	                				 store.getProxy().extraParams = {
	                					 academyLocationId : academyIds,
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 programCategory : values.programCategory,
	                					 intakeYearId : values.intakeYear,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 status:values.status
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                      					callback: function(record){
	                      						form.down('#searchBtn').setDisabled(false);
	                      					}
	                      				});
	                				 grid.config.searchFilterForm = this.getStudentmedicaldetailsreportfilter();
	                			 }
	                		 },
	                		 'studentmedicaldetailsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
            	                	 var programGroupCombo = form.down('#programGroupCombo');
            	                	 var academyLocationIds = form.down('#multiselectAcademyId');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId= this.getCurrentAcademyLocation();
                                      var academyLocationIdStore = academyLocationIds.getStore();
	                				 
                                    var academyLocationId = this.getCurrentAcademyLocation();
                                    academyLocationIds.getStore().load({
                      					callback: function(record){
                      						academyLocationIds.select(academyLocationId);
                      					}
                      				});
	                				
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                				 
	                				// var academyLocationId=this.getCurrentAcademyLocation();
	                				
	                				 
	                			 }
	                		  },
	                		  'studentmedicaldetailsreportgrid ': {
	                  			   render: function(grid){
	                   					 this.doAccessControlValidation(grid, this.getMEDICAL_DETAILS_REPORT_PERMISSIONS());
	                  			   }
	                		  },
	                		  'studentmedicaldetailsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.medicalDetailsReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  }
	                	 });
	                 },
	                 enableTabforstudentMedicalPanel:function(studentmedicaldetailsreporttabstructure)
	                 {
	                	 this.showTabforMedicalPanel(studentmedicaldetailsreporttabstructure);
	                 },
	                 showTabforMedicalPanel : function(studentmedicaldetailsreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentmedicaldetailsreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentmedicaldetailsreportstructure',
					  					itemId : 'studentmedicaldetailsreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentmedicaldetailsreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 medicalDetailsReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
            					 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 medicalDetailsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(true);
	                	 
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 medicalDetailsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 store.load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length > 0){
											   if(wheatherSchool){
												   period.setValue(records[0].data.id);
											   }
										   }
									   }
								   }
							    });
	                	 }
	                 },
	                 getSelectedAcademyIds:function(){
	                	 $this = this;
	                	 var multiselectAcademyIdField = $this.getStudentmedicaldetailsreportfilter().down('#multiselectAcademyId');
	     	        	var academyIdsArray = multiselectAcademyIdField.getValue();
	     	        	var academyIds;
	     	        	var academyIdsTempArray = [];
	     	        	if (academyIdsArray == null && academyIdsArray == undefined) {
	     	        		academyIdsArray = $this.getCurrentAcademyLocation();
						}
	     	        	if(typeof academyIdsArray[0]!="object"){
							academyIdsTempArray.push(academyIdsArray);
	                	}
	                	else {
	                		Ext.each(academyIdsArray,function(currentAcademyId){
	                			academyIdsTempArray.push(currentAcademyId.data.id);
	                		});
	                		
	                	}
	     	        	academyIds = academyIdsTempArray.join(',');
	                 	return academyIds;
	                 },
	                 loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL: function(){
	                	 $this = this;
	      				var academyIds = $this.getSelectedAcademyIds();
	      				if (academyIds == null || academyIds == '') {
	      					academyIds = $this.getCurrentAcademyLocation();
	 					}
	      				var basicStudentSearchForm=$this.getStudentmedicaldetailsreportfilter();
	      				var programGroupCombo = basicStudentSearchForm.down('#programGroupCombo');
	      				var programCombo = basicStudentSearchForm.down('#programId');
	      				var studentCombo = basicStudentSearchForm.down('#studentId');
	      				var batchIdCombo = basicStudentSearchForm.down('#batchId');
	      				var periodIdCombo = basicStudentSearchForm.down('#periodId');
	      				
	      				var programGroupStore = programGroupCombo.getStore();
	      				var programComboStore=programCombo.getStore();
	      				var studentComboStore=studentCombo.getStore();
	      				programGroupCombo.clearValue();
	      				programCombo.clearValue();
	      				studentCombo.clearValue();
	      				batchIdCombo.clearValue();
	      				batchIdCombo.setDisabled(true);
	      				periodIdCombo.clearValue();
	      				periodIdCombo.setDisabled(true);
	      				programGroupStore.getProxy().extraParams = {
	      					academyLocationIds:academyIds
	      				};
	      				programComboStore.getProxy().extraParams = {
	      					academyLocationIds:academyIds
	      				};
	      				studentComboStore.getProxy().extraParams = {
	      					academyLocationIds:academyIds
	      				};
	      				
	      				programGroupStore.load();
	      				programComboStore.load();
	      				studentComboStore.load();
	                  }                
});
