/*
 * @author Raghavendra.Soni   
 */
Ext.define('Academia.controller.survey.createSurvey.CreateSurveyController', {
	extend: 'Academia.controller.base.BaseController',
    stores: [
    	'survey.CreateSurveyGridStore',
    	'survey.ActiveSurveyListStore'
    ],
    views: [
    	'survey.createSurvey.CreateSurveyStructure',
    	'survey.createSurvey.CreateSurveyFilter',
    	'survey.createSurvey.CreateSurveyGrid',
    	'survey.createSurvey.CreateSurveyViewWindow'
    ],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
    	ref: 'createsurveystructure',
    	selector: 'createsurveystructure'
    },{
    	ref: 'createsurveyfilter',
    	selector: 'createsurveyfilter'
    },{
    	ref: 'createsurveygrid',
    	selector: 'createsurveygrid'
    },{
    	ref: 'createsurveyviewwindow',
    	selector: 'createsurveyviewwindow'
    }],
    config: {
    	CREATE_SURVEY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREATE_SURVEY_PRIVILEGES')
    },
    init: function(application) {    
        this.control({
        	'createsurveygrid':{
        		afterrender: function(grid){
        			this.applyGridPivileges(grid, this.getCREATE_SURVEY_PERMISSIONS());
        		},
        		selectionchange:function(view,record){
        			var grid = this.getCreatesurveygrid()
        			var btnView =grid.down('#btnView');
        			if(record.length == 1){
        				btnView.enable();
        			}else{
        				btnView.disable();
        			}
        		}
        	},
        	'createsurveygrid button[itemId=btnAdd]':{
        		click: function(btn){
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_GET_LIME_SURVEY_OTP_LINK,
        				method : 'GET',
        				success : function(response) {
        					if(!isNullOrEmpty(response.responseText)){
        						// Open the responseText link in a new tab
        	                    window.open(response.responseText, '_blank');
        					}
        				}
        			});
        		}
        	},
        	'createsurveygrid button[itemId=btnEdit]':{
        		click: function(btn){
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_GET_LIME_SURVEY_OTP_LINK,
        				method : 'GET',
        				success : function(response) {
        					if(!isNullOrEmpty(response.responseText)){
        						// Open the responseText link in a new tab
        	                    window.open(response.responseText, '_blank');
        					}
        				}
        			});
        		}
        	},
        	'createsurveygrid button[itemId=btnView]':{
        		click: function(btn){
        			var $this=this;
        			var grid = $this.getCreatesurveygrid();
        			if(grid.getSelectionModel().getCount()>0){
            			var createsurveyviewwindow = this.getCreatesurveyviewwindow();
            			if(isNullOrEmpty(createsurveyviewwindow)){
            				createsurveyviewwindow = Ext.widget('createsurveyviewwindow');
            			}
            			createsurveyviewwindow.show(); 
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
        			
        		}
        	},
        	'createsurveygrid button[itemId=btnDelete]':{
        		click: function(btn){
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_GET_LIME_SURVEY_OTP_LINK,
        				method : 'GET',
        				success : function(response) {
        					if(!isNullOrEmpty(response.responseText)){
        						// Open the responseText link in a new tab
        	                    window.open(response.responseText, '_blank');
        					}
        				}
        			});
        		}
        	},
        	'createsurveyfilter button[itemId=searchBtn]':{
        		click: function(btn){
        			var filterForm = btn.up('createsurveyfilter');
        			var activeSurveyListCombo = filterForm.down('#activeSurveyListComboItemId');
        			
        			var createSurveyGrid = filterForm.up('createsurveystructure').down('createsurveygrid');
        			var createSurveyGridStore = createSurveyGrid.getStore();
        			
        			var activeSurveyId=activeSurveyListCombo.getValue();
        			
        			createSurveyGridStore.getProxy().extraParams = {
        				surveyId: activeSurveyId
        			}
        			
        			createSurveyGridStore.load();
        			createSurveyGrid.getSelectionModel().deselectAll();
        		}
        	},
        	'createsurveyfilter button[itemId=resetBtn]':{
        		click: function(btn){
        			var filterForm = btn.up('createsurveyfilter');
        			filterForm.getForm().reset();
        		}
        	},
        	'createsurveyviewwindow':{
        		afterrender: function(win){
        			var me = this;
        			var createsurveygrid = this.getCreatesurveygrid();
        			var selectedRecord = createsurveygrid.getSelectionModel().getSelection()[0];
        			var winForm = win.down('form');
        			var isAnonymous = '';
        			if(selectedRecord.data.isAnonymized == true){
        				isAnonymous = 'Yes';
        			}else if(selectedRecord.data.isAnonymized == false){
        				isAnonymous = 'No'
        			}
        			winForm.getForm().setValues({
        				sid:selectedRecord.data.sid,
        				surveyls_title:selectedRecord.data.surveyls_title,
        				startdate:selectedRecord.data.startdate,
        				expires:selectedRecord.data.expires,
        				anonymous:isAnonymous,
        				active:(selectedRecord.data.active=="Y") ? getCommonTranslation('ACTIVE') : getCommonTranslation('INACTIVE'),
        			});
        		}
        	}
        });
    },
    applyGridPivileges: function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var portalId = this.getCurrentLoggedPortalId();
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

		var btnAdd = grid.down('#btnAdd');
    	var btnEdit = grid.down('#btnEdit');
    	var btnView = grid.down('#btnView');
    	var btnDelete = grid.down('#btnDelete');
    	var btnExportToPDF = grid.down('#btnExportToPDF');
    	var btnExportToExcel = grid.down('#btnExportToExcel');
    	
    	btnAdd.setVisible(false);
    	btnEdit.setVisible(false);
    	btnView.setVisible(false);
    	btnDelete.setVisible(false);
    	btnExportToPDF.setVisible(false);
    	btnExportToExcel.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'CREATE') {
        		if(!isNullOrEmpty(btnAdd)){
        			setTimeout(function(){
        				btnAdd.setVisible(true);
        			},300);
        		}  	     		
        	} else if (privilege === 'UPDATE') {
        		if(!isNullOrEmpty(btnEdit)){
        			setTimeout(function(){
        				btnEdit.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'GRID_VIEW_BTN') {
        		if(!isNullOrEmpty(btnView)){
        			setTimeout(function(){
        				btnView.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'DELETE') {
        		if(!isNullOrEmpty(btnDelete)){
        			setTimeout(function(){
        				btnDelete.setVisible(true);
        			},300);
        		}        		
        	}else if (privilege === 'EXPORT') {
        		if(!isNullOrEmpty(btnExportToPDF)){
        			setTimeout(function(){
        				btnExportToPDF.setVisible(true);
        				btnExportToExcel.setVisible(true);
        			},300);
        		}        		
        	}
    	});
    }
});