/**
 * 
 * @author Deepak Sharma
 */
Ext.define('Academia.model.hrm.biometric.BMIResourceDetailsModel', {
    extend: 'Ext.data.Model',
    fields: [
    	'id',
        'resourceType',
        'academyLocationId',
        'attendanceMachineLocationId',
        'resource',
        'academyLocation',
        {
            name: 'resourceName',
            convert: function(v, rec) {
            	if(!isNullOrEmpty(rec.get('resource'))){
            		return rec.get('resource').value;
            	}
            }
        },
        {
            name: 'academyLocationName',
            convert: function(v, rec) {
            	if(!isNullOrEmpty(rec.get('academyLocation'))){
            		return rec.get('academyLocation').value;  
            	}
            }
        },
        {
            name: 'resourceTypeName',
            convert: function(v, rec) {
            	if(!isNullOrEmpty(rec.get('resourceType'))){
            		return rec.get('resourceType').value;
            	}
            }
        },
        {
            name: 'academyLocationIdtemp',
            convert: function(v, rec) {
            	if(!isNullOrEmpty(rec.get('academyLocation'))){
            		return rec.get('academyLocation').id;  
            	}
            }
        },
    ]
});