/**
 * This store is for displaying the Program Groups in Admission Cycle of the Admission Setting.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.store.admission.admissionCycle.ProgramGroups', {
    extend: 'Ext.data.Store',
    model: 'Academia.model.admission.admissionCycle.ProgramGroup',
    autoLoad: false,
    remoteSort: true,
    pageSize: CONSTANTS.DEFAULT_PAGESIZE,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.ADMISSION_SETUP_PROGRAM_GROUPS_GRID_GET
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    },
    listeners: {
        beforeload: function(store, operation, eOpts) {
            var map = new Ext.util.HashMap();
            if (store.getProxy().api.read == SERVERURL.ADMISSION_SETUP_PROGRAM_GROUPS_GRID_GET) {
                map.add('programGroup', 'programGroup.groupName');
                map.add('appFormStartDate', 'appFormStartDate');
                map.add('appFormEndDate', 'appFormEndDate');
                map.add('appFormSubmitStartDate', 'appFormSubmitStartDate');
                map.add('appFormSubmitEndDate', 'appFormSubmitEndDate');
                map.add('maxProgramsAllowed', 'maxProgramsAllowed');
            } else {
                map.add('programGroup', 'groupName');
            }

            var sorters = store.sorters.items;
            Ext.each(sorters, function(sorter) {
                if (map.containsKey(sorter.property)) {
                    sorter.property = map.get(sorter.property);
                    store.getProxy().extraParams = {
                        'property': sorter.property,
                        'direction': sorter.direction
                    };
                } else {
                    if(!isNullOrEmpty(sorter)) {
                            delete sorter;
                            sorters.length = sorters.length -1;
                    }
                }
            });
        }
    }

});