Ext.define('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeSmartSearchStore',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.common.IdValueCodeDataModel',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('studentName');
	        var value2 = o2.get('studentName');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PATH_FIND_ADMISSION_CODE_FOR_SMART_SEARCH
		},
		reader: {
			type:'json'
		}
	},
	listeners:{
		beforeload: function(store){
			store.getProxy().extraParams.page = 1;
			store.getProxy().extraParams.start = 0;
			store.getProxy().extraParams.limit = 500;
		}
	}

});
