 Ext.define('Academia.store.datasetting.DataSettingEntityStore', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.datasetting.DataSettingEntityModel',     
     proxy: {
         type: 'rest',
         api: {
             read: SERVERURL.FIND_ALL_ENTITIES   //rest/idDefinition/entityPickListItems
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
		 load: {
	         fn: function(store, records, successful, eOpts){ 
	        	 store.each(function(record){
	        		 if(!isEmpty(record.data)){
    	    			 var valueText=getCBTranslation(record.get('tableName'));
    	    			 if(record.get('searchConfigCode') == 'IDG_BILLHEADERPAYABLECONFIGCODE5') {
    	    				 valueText = valueText + " (Bill Payable)";
    	    			 } else if (record.get('searchConfigCode') == 'IDG_BILLHEADERCONFIGCODE5') {
    	    				 valueText = valueText + " (Bill Recievable)";
    	    			 }
    	    			 record.set('tableName',valueText);         			  			 	        			 
	        		 }
	        	 });
	        	 store.sort('tableName', 'ASC');
	         }
	     }
	 }
 });